// Copyright 2023-2024 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        (unknown)
// source: buf/registry/module/v1/label_service.proto

package modulev1

import (
	_ "buf.build/gen/go/bufbuild/protovalidate/protocolbuffers/go/buf/validate"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The list order.
type ListLabelsRequest_Order int32

const (
	ListLabelsRequest_ORDER_UNSPECIFIED ListLabelsRequest_Order = 0
	// Order by create_time newest to oldest.
	ListLabelsRequest_ORDER_CREATE_TIME_DESC ListLabelsRequest_Order = 1
	// Order by create_time oldest to newest.
	ListLabelsRequest_ORDER_CREATE_TIME_ASC ListLabelsRequest_Order = 2
	// Order by update_time newest to oldest.
	ListLabelsRequest_ORDER_UPDATE_TIME_DESC ListLabelsRequest_Order = 3
	// Order by update_time oldest to newest.
	ListLabelsRequest_ORDER_UPDATE_TIME_ASC ListLabelsRequest_Order = 4
)

// Enum value maps for ListLabelsRequest_Order.
var (
	ListLabelsRequest_Order_name = map[int32]string{
		0: "ORDER_UNSPECIFIED",
		1: "ORDER_CREATE_TIME_DESC",
		2: "ORDER_CREATE_TIME_ASC",
		3: "ORDER_UPDATE_TIME_DESC",
		4: "ORDER_UPDATE_TIME_ASC",
	}
	ListLabelsRequest_Order_value = map[string]int32{
		"ORDER_UNSPECIFIED":      0,
		"ORDER_CREATE_TIME_DESC": 1,
		"ORDER_CREATE_TIME_ASC":  2,
		"ORDER_UPDATE_TIME_DESC": 3,
		"ORDER_UPDATE_TIME_ASC":  4,
	}
)

func (x ListLabelsRequest_Order) Enum() *ListLabelsRequest_Order {
	p := new(ListLabelsRequest_Order)
	*p = x
	return p
}

func (x ListLabelsRequest_Order) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ListLabelsRequest_Order) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_registry_module_v1_label_service_proto_enumTypes[0].Descriptor()
}

func (ListLabelsRequest_Order) Type() protoreflect.EnumType {
	return &file_buf_registry_module_v1_label_service_proto_enumTypes[0]
}

func (x ListLabelsRequest_Order) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ListLabelsRequest_Order.Descriptor instead.
func (ListLabelsRequest_Order) EnumDescriptor() ([]byte, []int) {
	return file_buf_registry_module_v1_label_service_proto_rawDescGZIP(), []int{2, 0}
}

// A filter on whether a Label is archived or not.
type ListLabelsRequest_ArchiveFilter int32

const (
	ListLabelsRequest_ARCHIVE_FILTER_UNSPECIFIED ListLabelsRequest_ArchiveFilter = 0
	// Return only unarchived labels.
	ListLabelsRequest_ARCHIVE_FILTER_UNARCHIVED_ONLY ListLabelsRequest_ArchiveFilter = 1
	// Return only archived labels.
	ListLabelsRequest_ARCHIVE_FILTER_ARCHIVED_ONLY ListLabelsRequest_ArchiveFilter = 2
	// Return both archived and unarchived labels.
	ListLabelsRequest_ARCHIVE_FILTER_ALL ListLabelsRequest_ArchiveFilter = 3
)

// Enum value maps for ListLabelsRequest_ArchiveFilter.
var (
	ListLabelsRequest_ArchiveFilter_name = map[int32]string{
		0: "ARCHIVE_FILTER_UNSPECIFIED",
		1: "ARCHIVE_FILTER_UNARCHIVED_ONLY",
		2: "ARCHIVE_FILTER_ARCHIVED_ONLY",
		3: "ARCHIVE_FILTER_ALL",
	}
	ListLabelsRequest_ArchiveFilter_value = map[string]int32{
		"ARCHIVE_FILTER_UNSPECIFIED":     0,
		"ARCHIVE_FILTER_UNARCHIVED_ONLY": 1,
		"ARCHIVE_FILTER_ARCHIVED_ONLY":   2,
		"ARCHIVE_FILTER_ALL":             3,
	}
)

func (x ListLabelsRequest_ArchiveFilter) Enum() *ListLabelsRequest_ArchiveFilter {
	p := new(ListLabelsRequest_ArchiveFilter)
	*p = x
	return p
}

func (x ListLabelsRequest_ArchiveFilter) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ListLabelsRequest_ArchiveFilter) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_registry_module_v1_label_service_proto_enumTypes[1].Descriptor()
}

func (ListLabelsRequest_ArchiveFilter) Type() protoreflect.EnumType {
	return &file_buf_registry_module_v1_label_service_proto_enumTypes[1]
}

func (x ListLabelsRequest_ArchiveFilter) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ListLabelsRequest_ArchiveFilter.Descriptor instead.
func (ListLabelsRequest_ArchiveFilter) EnumDescriptor() ([]byte, []int) {
	return file_buf_registry_module_v1_label_service_proto_rawDescGZIP(), []int{2, 1}
}

// The list order.
type ListLabelHistoryRequest_Order int32

const (
	ListLabelHistoryRequest_ORDER_UNSPECIFIED ListLabelHistoryRequest_Order = 0
	// Order by association time newest to oldest.
	//
	// The Commits most recently associated with the Label will be listed first.
	ListLabelHistoryRequest_ORDER_DESC ListLabelHistoryRequest_Order = 1
	// Order by association time oldest to newest.
	ListLabelHistoryRequest_ORDER_ASC ListLabelHistoryRequest_Order = 2
)

// Enum value maps for ListLabelHistoryRequest_Order.
var (
	ListLabelHistoryRequest_Order_name = map[int32]string{
		0: "ORDER_UNSPECIFIED",
		1: "ORDER_DESC",
		2: "ORDER_ASC",
	}
	ListLabelHistoryRequest_Order_value = map[string]int32{
		"ORDER_UNSPECIFIED": 0,
		"ORDER_DESC":        1,
		"ORDER_ASC":         2,
	}
)

func (x ListLabelHistoryRequest_Order) Enum() *ListLabelHistoryRequest_Order {
	p := new(ListLabelHistoryRequest_Order)
	*p = x
	return p
}

func (x ListLabelHistoryRequest_Order) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ListLabelHistoryRequest_Order) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_registry_module_v1_label_service_proto_enumTypes[2].Descriptor()
}

func (ListLabelHistoryRequest_Order) Type() protoreflect.EnumType {
	return &file_buf_registry_module_v1_label_service_proto_enumTypes[2]
}

func (x ListLabelHistoryRequest_Order) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ListLabelHistoryRequest_Order.Descriptor instead.
func (ListLabelHistoryRequest_Order) EnumDescriptor() ([]byte, []int) {
	return file_buf_registry_module_v1_label_service_proto_rawDescGZIP(), []int{4, 0}
}

type GetLabelsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Labels to request.
	//
	// This may reference archived Labels.
	LabelRefs []*LabelRef `protobuf:"bytes,1,rep,name=label_refs,json=labelRefs,proto3" json:"label_refs,omitempty"`
}

func (x *GetLabelsRequest) Reset() {
	*x = GetLabelsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_registry_module_v1_label_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetLabelsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetLabelsRequest) ProtoMessage() {}

func (x *GetLabelsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1_label_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetLabelsRequest.ProtoReflect.Descriptor instead.
func (*GetLabelsRequest) Descriptor() ([]byte, []int) {
	return file_buf_registry_module_v1_label_service_proto_rawDescGZIP(), []int{0}
}

func (x *GetLabelsRequest) GetLabelRefs() []*LabelRef {
	if x != nil {
		return x.LabelRefs
	}
	return nil
}

type GetLabelsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The retrieved Labels in the same order as requested.
	Labels []*Label `protobuf:"bytes,1,rep,name=labels,proto3" json:"labels,omitempty"`
}

func (x *GetLabelsResponse) Reset() {
	*x = GetLabelsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_registry_module_v1_label_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetLabelsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetLabelsResponse) ProtoMessage() {}

func (x *GetLabelsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1_label_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetLabelsResponse.ProtoReflect.Descriptor instead.
func (*GetLabelsResponse) Descriptor() ([]byte, []int) {
	return file_buf_registry_module_v1_label_service_proto_rawDescGZIP(), []int{1}
}

func (x *GetLabelsResponse) GetLabels() []*Label {
	if x != nil {
		return x.Labels
	}
	return nil
}

type ListLabelsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The maximum number of items to return.
	//
	// The default value is 10.
	PageSize uint32 `protobuf:"varint,1,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The page to start from.
	//
	// If empty, the first page is returned.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The reference to list Labels for.
	//
	// See the documentation on Ref for resource resolution details.
	//
	// Once the resource is resolved, the following Labels are listed (subject to any additional filters in the request):
	//   - If a Module is referenced, all Labels for the Module are returned.
	//   - If a Label is referenced, this Label is returned.
	//   - If a Commit is referenced, all Labels that currently point to the Commit are returned. Note that
	//     Labels only point to passed or approved Commits, or Commits where policy checks were disabled.
	ResourceRef *ResourceRef `protobuf:"bytes,3,opt,name=resource_ref,json=resourceRef,proto3" json:"resource_ref,omitempty"`
	// The order to return the Labels.
	//
	// If not specified, defaults to ORDER_CREATE_TIME_DESC.
	Order ListLabelsRequest_Order `protobuf:"varint,4,opt,name=order,proto3,enum=buf.registry.module.v1.ListLabelsRequest_Order" json:"order,omitempty"`
	// Only return Labels that point to a Commit with one of these CommitCheckStatus values.
	//
	// If not set, Labels that point to a Commit with any CommitCheckStatus value are returned.
	//
	// It is an error to filter on CommitCheckStatuses of pending or rejected, as Labels will only
	// point to Commits that are passed or approved, or that have policy checks disabled.
	CommitCheckStatuses []CommitCheckStatus `protobuf:"varint,5,rep,packed,name=commit_check_statuses,json=commitCheckStatuses,proto3,enum=buf.registry.module.v1.CommitCheckStatus" json:"commit_check_statuses,omitempty"`
	// Only return Labels with a name that contains this string using a case-insensitive comparison.
	NameQuery string `protobuf:"bytes,6,opt,name=name_query,json=nameQuery,proto3" json:"name_query,omitempty"`
	// The archive filter on the returned Labels.
	//
	// If not specified, defaults to ARCHIVE_FILTER_UNARCHIVED_ONLY.
	ArchiveFilter ListLabelsRequest_ArchiveFilter `protobuf:"varint,7,opt,name=archive_filter,json=archiveFilter,proto3,enum=buf.registry.module.v1.ListLabelsRequest_ArchiveFilter" json:"archive_filter,omitempty"`
}

func (x *ListLabelsRequest) Reset() {
	*x = ListLabelsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_registry_module_v1_label_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListLabelsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListLabelsRequest) ProtoMessage() {}

func (x *ListLabelsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1_label_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListLabelsRequest.ProtoReflect.Descriptor instead.
func (*ListLabelsRequest) Descriptor() ([]byte, []int) {
	return file_buf_registry_module_v1_label_service_proto_rawDescGZIP(), []int{2}
}

func (x *ListLabelsRequest) GetPageSize() uint32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListLabelsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListLabelsRequest) GetResourceRef() *ResourceRef {
	if x != nil {
		return x.ResourceRef
	}
	return nil
}

func (x *ListLabelsRequest) GetOrder() ListLabelsRequest_Order {
	if x != nil {
		return x.Order
	}
	return ListLabelsRequest_ORDER_UNSPECIFIED
}

func (x *ListLabelsRequest) GetCommitCheckStatuses() []CommitCheckStatus {
	if x != nil {
		return x.CommitCheckStatuses
	}
	return nil
}

func (x *ListLabelsRequest) GetNameQuery() string {
	if x != nil {
		return x.NameQuery
	}
	return ""
}

func (x *ListLabelsRequest) GetArchiveFilter() ListLabelsRequest_ArchiveFilter {
	if x != nil {
		return x.ArchiveFilter
	}
	return ListLabelsRequest_ARCHIVE_FILTER_UNSPECIFIED
}

type ListLabelsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The next page token.
	//
	// If empty, there are no more pages.
	NextPageToken string `protobuf:"bytes,1,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The listed Labels.
	Labels []*Label `protobuf:"bytes,2,rep,name=labels,proto3" json:"labels,omitempty"`
}

func (x *ListLabelsResponse) Reset() {
	*x = ListLabelsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_registry_module_v1_label_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListLabelsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListLabelsResponse) ProtoMessage() {}

func (x *ListLabelsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1_label_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListLabelsResponse.ProtoReflect.Descriptor instead.
func (*ListLabelsResponse) Descriptor() ([]byte, []int) {
	return file_buf_registry_module_v1_label_service_proto_rawDescGZIP(), []int{3}
}

func (x *ListLabelsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListLabelsResponse) GetLabels() []*Label {
	if x != nil {
		return x.Labels
	}
	return nil
}

type ListLabelHistoryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The maximum number of items to return.
	//
	// The default value is 10.
	PageSize uint32 `protobuf:"varint,1,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The page to start from.
	//
	// If empty, the first page is returned.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The Label to list history for.
	//
	// This may reference archived Labels.
	LabelRef *LabelRef `protobuf:"bytes,3,opt,name=label_ref,json=labelRef,proto3" json:"label_ref,omitempty"`
	// The order to list the Labels.
	//
	// If not specified, defaults to ORDER_DESC.
	Order ListLabelHistoryRequest_Order `protobuf:"varint,4,opt,name=order,proto3,enum=buf.registry.module.v1.ListLabelHistoryRequest_Order" json:"order,omitempty"`
	// Only return Commits that have one of these CommitCheckStatus values for this label.
	//
	// If not set, Commits with any CommitCheckStatus value are returned.
	CommitCheckStatuses []CommitCheckStatus `protobuf:"varint,5,rep,packed,name=commit_check_statuses,json=commitCheckStatuses,proto3,enum=buf.registry.module.v1.CommitCheckStatus" json:"commit_check_statuses,omitempty"`
	// The Commit id to start from.
	//
	// It is an error to provide a Commit id that doesn't exist on the Label.
	StartCommitId string `protobuf:"bytes,6,opt,name=start_commit_id,json=startCommitId,proto3" json:"start_commit_id,omitempty"`
	// Only list Commits where the Digest has changed from the previous Commit in the
	// history of this Label.
	OnlyCommitsWithChangedDigests bool `protobuf:"varint,7,opt,name=only_commits_with_changed_digests,json=onlyCommitsWithChangedDigests,proto3" json:"only_commits_with_changed_digests,omitempty"`
}

func (x *ListLabelHistoryRequest) Reset() {
	*x = ListLabelHistoryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_registry_module_v1_label_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListLabelHistoryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListLabelHistoryRequest) ProtoMessage() {}

func (x *ListLabelHistoryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1_label_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListLabelHistoryRequest.ProtoReflect.Descriptor instead.
func (*ListLabelHistoryRequest) Descriptor() ([]byte, []int) {
	return file_buf_registry_module_v1_label_service_proto_rawDescGZIP(), []int{4}
}

func (x *ListLabelHistoryRequest) GetPageSize() uint32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListLabelHistoryRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListLabelHistoryRequest) GetLabelRef() *LabelRef {
	if x != nil {
		return x.LabelRef
	}
	return nil
}

func (x *ListLabelHistoryRequest) GetOrder() ListLabelHistoryRequest_Order {
	if x != nil {
		return x.Order
	}
	return ListLabelHistoryRequest_ORDER_UNSPECIFIED
}

func (x *ListLabelHistoryRequest) GetCommitCheckStatuses() []CommitCheckStatus {
	if x != nil {
		return x.CommitCheckStatuses
	}
	return nil
}

func (x *ListLabelHistoryRequest) GetStartCommitId() string {
	if x != nil {
		return x.StartCommitId
	}
	return ""
}

func (x *ListLabelHistoryRequest) GetOnlyCommitsWithChangedDigests() bool {
	if x != nil {
		return x.OnlyCommitsWithChangedDigests
	}
	return false
}

type ListLabelHistoryResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The next page token.
	//
	// If empty, there are no more pages.
	NextPageToken string `protobuf:"bytes,1,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The ordered history of the Label.
	Values []*ListLabelHistoryResponse_Value `protobuf:"bytes,2,rep,name=values,proto3" json:"values,omitempty"`
}

func (x *ListLabelHistoryResponse) Reset() {
	*x = ListLabelHistoryResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_registry_module_v1_label_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListLabelHistoryResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListLabelHistoryResponse) ProtoMessage() {}

func (x *ListLabelHistoryResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1_label_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListLabelHistoryResponse.ProtoReflect.Descriptor instead.
func (*ListLabelHistoryResponse) Descriptor() ([]byte, []int) {
	return file_buf_registry_module_v1_label_service_proto_rawDescGZIP(), []int{5}
}

func (x *ListLabelHistoryResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListLabelHistoryResponse) GetValues() []*ListLabelHistoryResponse_Value {
	if x != nil {
		return x.Values
	}
	return nil
}

type CreateOrUpdateLabelsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Labels to create.
	Values []*CreateOrUpdateLabelsRequest_Value `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
}

func (x *CreateOrUpdateLabelsRequest) Reset() {
	*x = CreateOrUpdateLabelsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_registry_module_v1_label_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateOrUpdateLabelsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateOrUpdateLabelsRequest) ProtoMessage() {}

func (x *CreateOrUpdateLabelsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1_label_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateOrUpdateLabelsRequest.ProtoReflect.Descriptor instead.
func (*CreateOrUpdateLabelsRequest) Descriptor() ([]byte, []int) {
	return file_buf_registry_module_v1_label_service_proto_rawDescGZIP(), []int{6}
}

func (x *CreateOrUpdateLabelsRequest) GetValues() []*CreateOrUpdateLabelsRequest_Value {
	if x != nil {
		return x.Values
	}
	return nil
}

type CreateOrUpdateLabelsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The created or updated Labels in the same order as given on the request.
	Labels []*Label `protobuf:"bytes,1,rep,name=labels,proto3" json:"labels,omitempty"`
}

func (x *CreateOrUpdateLabelsResponse) Reset() {
	*x = CreateOrUpdateLabelsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_registry_module_v1_label_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateOrUpdateLabelsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateOrUpdateLabelsResponse) ProtoMessage() {}

func (x *CreateOrUpdateLabelsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1_label_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateOrUpdateLabelsResponse.ProtoReflect.Descriptor instead.
func (*CreateOrUpdateLabelsResponse) Descriptor() ([]byte, []int) {
	return file_buf_registry_module_v1_label_service_proto_rawDescGZIP(), []int{7}
}

func (x *CreateOrUpdateLabelsResponse) GetLabels() []*Label {
	if x != nil {
		return x.Labels
	}
	return nil
}

type ArchiveLabelsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Labels to archive.
	LabelRefs []*LabelRef `protobuf:"bytes,1,rep,name=label_refs,json=labelRefs,proto3" json:"label_refs,omitempty"`
}

func (x *ArchiveLabelsRequest) Reset() {
	*x = ArchiveLabelsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_registry_module_v1_label_service_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ArchiveLabelsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ArchiveLabelsRequest) ProtoMessage() {}

func (x *ArchiveLabelsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1_label_service_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ArchiveLabelsRequest.ProtoReflect.Descriptor instead.
func (*ArchiveLabelsRequest) Descriptor() ([]byte, []int) {
	return file_buf_registry_module_v1_label_service_proto_rawDescGZIP(), []int{8}
}

func (x *ArchiveLabelsRequest) GetLabelRefs() []*LabelRef {
	if x != nil {
		return x.LabelRefs
	}
	return nil
}

type ArchiveLabelsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ArchiveLabelsResponse) Reset() {
	*x = ArchiveLabelsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_registry_module_v1_label_service_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ArchiveLabelsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ArchiveLabelsResponse) ProtoMessage() {}

func (x *ArchiveLabelsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1_label_service_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ArchiveLabelsResponse.ProtoReflect.Descriptor instead.
func (*ArchiveLabelsResponse) Descriptor() ([]byte, []int) {
	return file_buf_registry_module_v1_label_service_proto_rawDescGZIP(), []int{9}
}

type UnarchiveLabelsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Labels to unarchive.
	LabelRefs []*LabelRef `protobuf:"bytes,1,rep,name=label_refs,json=labelRefs,proto3" json:"label_refs,omitempty"`
}

func (x *UnarchiveLabelsRequest) Reset() {
	*x = UnarchiveLabelsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_registry_module_v1_label_service_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UnarchiveLabelsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UnarchiveLabelsRequest) ProtoMessage() {}

func (x *UnarchiveLabelsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1_label_service_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UnarchiveLabelsRequest.ProtoReflect.Descriptor instead.
func (*UnarchiveLabelsRequest) Descriptor() ([]byte, []int) {
	return file_buf_registry_module_v1_label_service_proto_rawDescGZIP(), []int{10}
}

func (x *UnarchiveLabelsRequest) GetLabelRefs() []*LabelRef {
	if x != nil {
		return x.LabelRefs
	}
	return nil
}

type UnarchiveLabelsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *UnarchiveLabelsResponse) Reset() {
	*x = UnarchiveLabelsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_registry_module_v1_label_service_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UnarchiveLabelsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UnarchiveLabelsResponse) ProtoMessage() {}

func (x *UnarchiveLabelsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1_label_service_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UnarchiveLabelsResponse.ProtoReflect.Descriptor instead.
func (*UnarchiveLabelsResponse) Descriptor() ([]byte, []int) {
	return file_buf_registry_module_v1_label_service_proto_rawDescGZIP(), []int{11}
}

type ListLabelHistoryResponse_Value struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Commit.
	Commit *Commit `protobuf:"bytes,1,opt,name=commit,proto3" json:"commit,omitempty"`
	// The CommitCheckState for this Commit on this Label.
	CommitCheckState *CommitCheckState `protobuf:"bytes,2,opt,name=commit_check_state,json=commitCheckState,proto3" json:"commit_check_state,omitempty"`
}

func (x *ListLabelHistoryResponse_Value) Reset() {
	*x = ListLabelHistoryResponse_Value{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_registry_module_v1_label_service_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListLabelHistoryResponse_Value) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListLabelHistoryResponse_Value) ProtoMessage() {}

func (x *ListLabelHistoryResponse_Value) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1_label_service_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListLabelHistoryResponse_Value.ProtoReflect.Descriptor instead.
func (*ListLabelHistoryResponse_Value) Descriptor() ([]byte, []int) {
	return file_buf_registry_module_v1_label_service_proto_rawDescGZIP(), []int{5, 0}
}

func (x *ListLabelHistoryResponse_Value) GetCommit() *Commit {
	if x != nil {
		return x.Commit
	}
	return nil
}

func (x *ListLabelHistoryResponse_Value) GetCommitCheckState() *CommitCheckState {
	if x != nil {
		return x.CommitCheckState
	}
	return nil
}

// An individual request to create or update a Label.
type CreateOrUpdateLabelsRequest_Value struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Labels to create or update.
	LabelRef *LabelRef `protobuf:"bytes,1,opt,name=label_ref,json=labelRef,proto3" json:"label_ref,omitempty"`
	// The id of the Commit to associate with the Label.
	//
	// If the Label already existed, the Label will now point to this Commit, as long as this Commit
	// is newer than the Commit that the Label is currently pointing to, otherwise an error is
	// returned.
	// If the Label was archived, it will be unarchived.
	CommitId string `protobuf:"bytes,2,opt,name=commit_id,json=commitId,proto3" json:"commit_id,omitempty"`
}

func (x *CreateOrUpdateLabelsRequest_Value) Reset() {
	*x = CreateOrUpdateLabelsRequest_Value{}
	if protoimpl.UnsafeEnabled {
		mi := &file_buf_registry_module_v1_label_service_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateOrUpdateLabelsRequest_Value) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateOrUpdateLabelsRequest_Value) ProtoMessage() {}

func (x *CreateOrUpdateLabelsRequest_Value) ProtoReflect() protoreflect.Message {
	mi := &file_buf_registry_module_v1_label_service_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateOrUpdateLabelsRequest_Value.ProtoReflect.Descriptor instead.
func (*CreateOrUpdateLabelsRequest_Value) Descriptor() ([]byte, []int) {
	return file_buf_registry_module_v1_label_service_proto_rawDescGZIP(), []int{6, 0}
}

func (x *CreateOrUpdateLabelsRequest_Value) GetLabelRef() *LabelRef {
	if x != nil {
		return x.LabelRef
	}
	return nil
}

func (x *CreateOrUpdateLabelsRequest_Value) GetCommitId() string {
	if x != nil {
		return x.CommitId
	}
	return ""
}

var File_buf_registry_module_v1_label_service_proto protoreflect.FileDescriptor

var file_buf_registry_module_v1_label_service_proto_rawDesc = []byte{
	0x0a, 0x2a, 0x62, 0x75, 0x66, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2f, 0x6d,
	0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x16, 0x62, 0x75,
	0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64, 0x75, 0x6c,
	0x65, 0x2e, 0x76, 0x31, 0x1a, 0x23, 0x62, 0x75, 0x66, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x72, 0x79, 0x2f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6d,
	0x6d, 0x69, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x22, 0x62, 0x75, 0x66, 0x2f, 0x72,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2f, 0x76,
	0x31, 0x2f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x25, 0x62,
	0x75, 0x66, 0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2f, 0x6d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x62, 0x75, 0x66, 0x2f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61,
	0x74, 0x65, 0x2f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0x60, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4c, 0x0a, 0x0a, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x72,
	0x65, 0x66, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x62, 0x75, 0x66, 0x2e,
	0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x65, 0x66, 0x42, 0x0b, 0xba, 0x48, 0x08,
	0x92, 0x01, 0x05, 0x08, 0x01, 0x10, 0xfa, 0x01, 0x52, 0x09, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x52,
	0x65, 0x66, 0x73, 0x22, 0x54, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3f, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x42, 0x08, 0xba, 0x48, 0x05, 0x92, 0x01, 0x02, 0x08,
	0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x22, 0xa9, 0x06, 0x0a, 0x11, 0x4c, 0x69,
	0x73, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x25, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0d, 0x42, 0x08, 0xba, 0x48, 0x05, 0x2a, 0x03, 0x18, 0xfa, 0x01, 0x52, 0x08, 0x70, 0x61,
	0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x27, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x08, 0xba, 0x48, 0x05, 0x72,
	0x03, 0x18, 0x80, 0x20, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12,
	0x4e, 0x0a, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x72, 0x65, 0x66, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x66, 0x42, 0x06, 0xba, 0x48, 0x03, 0xc8,
	0x01, 0x01, 0x52, 0x0b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x66, 0x12,
	0x4f, 0x0a, 0x05, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f,
	0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x42,
	0x08, 0xba, 0x48, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x05, 0x6f, 0x72, 0x64, 0x65, 0x72,
	0x12, 0x71, 0x0a, 0x15, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x5f, 0x63, 0x68, 0x65, 0x63, 0x6b,
	0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0e, 0x32,
	0x29, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6d,
	0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x43,
	0x68, 0x65, 0x63, 0x6b, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x12, 0xba, 0x48, 0x0f, 0x92,
	0x01, 0x0c, 0x22, 0x0a, 0x82, 0x01, 0x07, 0x10, 0x01, 0x1a, 0x03, 0x01, 0x02, 0x05, 0x52, 0x13,
	0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x65, 0x73, 0x12, 0x27, 0x0a, 0x0a, 0x6e, 0x61, 0x6d, 0x65, 0x5f, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x08, 0xba, 0x48, 0x05, 0x72, 0x03, 0x18, 0xfa,
	0x01, 0x52, 0x09, 0x6e, 0x61, 0x6d, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x68, 0x0a, 0x0e,
	0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x37, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e,
	0x41, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x42, 0x08, 0xba,
	0x48, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x0d, 0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65,
	0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0x8c, 0x01, 0x0a, 0x05, 0x4f, 0x72, 0x64, 0x65, 0x72,
	0x12, 0x15, 0x0a, 0x11, 0x4f, 0x52, 0x44, 0x45, 0x52, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1a, 0x0a, 0x16, 0x4f, 0x52, 0x44, 0x45, 0x52,
	0x5f, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x5f, 0x44, 0x45, 0x53,
	0x43, 0x10, 0x01, 0x12, 0x19, 0x0a, 0x15, 0x4f, 0x52, 0x44, 0x45, 0x52, 0x5f, 0x43, 0x52, 0x45,
	0x41, 0x54, 0x45, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x5f, 0x41, 0x53, 0x43, 0x10, 0x02, 0x12, 0x1a,
	0x0a, 0x16, 0x4f, 0x52, 0x44, 0x45, 0x52, 0x5f, 0x55, 0x50, 0x44, 0x41, 0x54, 0x45, 0x5f, 0x54,
	0x49, 0x4d, 0x45, 0x5f, 0x44, 0x45, 0x53, 0x43, 0x10, 0x03, 0x12, 0x19, 0x0a, 0x15, 0x4f, 0x52,
	0x44, 0x45, 0x52, 0x5f, 0x55, 0x50, 0x44, 0x41, 0x54, 0x45, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x5f,
	0x41, 0x53, 0x43, 0x10, 0x04, 0x22, 0x8d, 0x01, 0x0a, 0x0d, 0x41, 0x72, 0x63, 0x68, 0x69, 0x76,
	0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1e, 0x0a, 0x1a, 0x41, 0x52, 0x43, 0x48, 0x49,
	0x56, 0x45, 0x5f, 0x46, 0x49, 0x4c, 0x54, 0x45, 0x52, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x22, 0x0a, 0x1e, 0x41, 0x52, 0x43, 0x48, 0x49,
	0x56, 0x45, 0x5f, 0x46, 0x49, 0x4c, 0x54, 0x45, 0x52, 0x5f, 0x55, 0x4e, 0x41, 0x52, 0x43, 0x48,
	0x49, 0x56, 0x45, 0x44, 0x5f, 0x4f, 0x4e, 0x4c, 0x59, 0x10, 0x01, 0x12, 0x20, 0x0a, 0x1c, 0x41,
	0x52, 0x43, 0x48, 0x49, 0x56, 0x45, 0x5f, 0x46, 0x49, 0x4c, 0x54, 0x45, 0x52, 0x5f, 0x41, 0x52,
	0x43, 0x48, 0x49, 0x56, 0x45, 0x44, 0x5f, 0x4f, 0x4e, 0x4c, 0x59, 0x10, 0x02, 0x12, 0x16, 0x0a,
	0x12, 0x41, 0x52, 0x43, 0x48, 0x49, 0x56, 0x45, 0x5f, 0x46, 0x49, 0x4c, 0x54, 0x45, 0x52, 0x5f,
	0x41, 0x4c, 0x4c, 0x10, 0x03, 0x22, 0x7d, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x30, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x08, 0xba, 0x48, 0x05, 0x72, 0x03, 0x18, 0x80, 0x20, 0x52, 0x0d,
	0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x35, 0x0a,
	0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1d, 0x2e,
	0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x06, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x22, 0xb3, 0x04, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x25, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0d, 0x42, 0x08, 0xba, 0x48, 0x05, 0x2a, 0x03, 0x18, 0xfa, 0x01, 0x52, 0x08, 0x70,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x27, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x08, 0xba, 0x48, 0x05,
	0x72, 0x03, 0x18, 0x80, 0x20, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x12, 0x45, 0x0a, 0x09, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x72, 0x65, 0x66, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x52, 0x65, 0x66, 0x42, 0x06, 0xba, 0x48, 0x03, 0xc8, 0x01, 0x01, 0x52, 0x08, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x52, 0x65, 0x66, 0x12, 0x55, 0x0a, 0x05, 0x6f, 0x72, 0x64, 0x65, 0x72,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x08, 0xba,
	0x48, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x05, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x12, 0x6c,
	0x0a, 0x15, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x5f, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x5f, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x29, 0x2e,
	0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x43, 0x68, 0x65,
	0x63, 0x6b, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x0d, 0xba, 0x48, 0x0a, 0x92, 0x01, 0x07,
	0x22, 0x05, 0x82, 0x01, 0x02, 0x10, 0x01, 0x52, 0x13, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x43,
	0x68, 0x65, 0x63, 0x6b, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x65, 0x73, 0x12, 0x33, 0x0a, 0x0f,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0b, 0xba, 0x48, 0x08, 0xd8, 0x01, 0x01, 0x72, 0x03, 0x88,
	0x02, 0x01, 0x52, 0x0d, 0x73, 0x74, 0x61, 0x72, 0x74, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x49,
	0x64, 0x12, 0x48, 0x0a, 0x21, 0x6f, 0x6e, 0x6c, 0x79, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74,
	0x73, 0x5f, 0x77, 0x69, 0x74, 0x68, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x5f, 0x64,
	0x69, 0x67, 0x65, 0x73, 0x74, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x1d, 0x6f, 0x6e,
	0x6c, 0x79, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x73, 0x57, 0x69, 0x74, 0x68, 0x43, 0x68, 0x61,
	0x6e, 0x67, 0x65, 0x64, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x73, 0x22, 0x3d, 0x0a, 0x05, 0x4f,
	0x72, 0x64, 0x65, 0x72, 0x12, 0x15, 0x0a, 0x11, 0x4f, 0x52, 0x44, 0x45, 0x52, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x4f,
	0x52, 0x44, 0x45, 0x52, 0x5f, 0x44, 0x45, 0x53, 0x43, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x4f,
	0x52, 0x44, 0x45, 0x52, 0x5f, 0x41, 0x53, 0x43, 0x10, 0x02, 0x22, 0xc6, 0x02, 0x0a, 0x18, 0x4c,
	0x69, 0x73, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x30, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x08, 0xba, 0x48, 0x05, 0x72, 0x03, 0x18, 0x80, 0x20, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74,
	0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x4e, 0x0a, 0x06, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x62, 0x75, 0x66, 0x2e,
	0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x48, 0x69, 0x73, 0x74,
	0x6f, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x1a, 0xa7, 0x01, 0x0a, 0x05, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x12, 0x3e, 0x0a, 0x06, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d,
	0x6d, 0x69, 0x74, 0x42, 0x06, 0xba, 0x48, 0x03, 0xc8, 0x01, 0x01, 0x52, 0x06, 0x63, 0x6f, 0x6d,
	0x6d, 0x69, 0x74, 0x12, 0x5e, 0x0a, 0x12, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x5f, 0x63, 0x68,
	0x65, 0x63, 0x6b, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x28, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6d,
	0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x43,
	0x68, 0x65, 0x63, 0x6b, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x06, 0xba, 0x48, 0x03, 0xc8, 0x01,
	0x01, 0x52, 0x10, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x22, 0xf7, 0x01, 0x0a, 0x1b, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4f, 0x72,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x5e, 0x0a, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x4f, 0x72, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x0b,
	0xba, 0x48, 0x08, 0x92, 0x01, 0x05, 0x08, 0x01, 0x10, 0xfa, 0x01, 0x52, 0x06, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x73, 0x1a, 0x78, 0x0a, 0x05, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x45, 0x0a, 0x09,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f, 0x72, 0x65, 0x66, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x20, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6d,
	0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x65,
	0x66, 0x42, 0x06, 0xba, 0x48, 0x03, 0xc8, 0x01, 0x01, 0x52, 0x08, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x52, 0x65, 0x66, 0x12, 0x28, 0x0a, 0x09, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x5f, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0b, 0xba, 0x48, 0x08, 0xc8, 0x01, 0x01, 0x72, 0x03,
	0x88, 0x02, 0x01, 0x52, 0x08, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x49, 0x64, 0x22, 0x5f, 0x0a,
	0x1c, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4f, 0x72, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3f, 0x0a,
	0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1d, 0x2e,
	0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x42, 0x08, 0xba, 0x48,
	0x05, 0x92, 0x01, 0x02, 0x08, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x22, 0x64,
	0x0a, 0x14, 0x41, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4c, 0x0a, 0x0a, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x5f,
	0x72, 0x65, 0x66, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x62, 0x75, 0x66,
	0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x65, 0x66, 0x42, 0x0b, 0xba, 0x48,
	0x08, 0x92, 0x01, 0x05, 0x08, 0x01, 0x10, 0xfa, 0x01, 0x52, 0x09, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x52, 0x65, 0x66, 0x73, 0x22, 0x17, 0x0a, 0x15, 0x41, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x66, 0x0a,
	0x16, 0x55, 0x6e, 0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4c, 0x0a, 0x0a, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x5f, 0x72, 0x65, 0x66, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x62, 0x75,
	0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64, 0x75, 0x6c,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x52, 0x65, 0x66, 0x42, 0x0b, 0xba,
	0x48, 0x08, 0x92, 0x01, 0x05, 0x08, 0x01, 0x10, 0xfa, 0x01, 0x52, 0x09, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x52, 0x65, 0x66, 0x73, 0x22, 0x19, 0x0a, 0x17, 0x55, 0x6e, 0x61, 0x72, 0x63, 0x68, 0x69,
	0x76, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x32, 0xd0, 0x05, 0x0a, 0x0c, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x12, 0x65, 0x0a, 0x09, 0x47, 0x65, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x28,
	0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6d, 0x6f,
	0x64, 0x75, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x47, 0x65, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x01, 0x12, 0x68, 0x0a, 0x0a, 0x4c, 0x69, 0x73, 0x74,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x29, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x2a, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79,
	0x2e, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90,
	0x02, 0x01, 0x12, 0x7a, 0x0a, 0x10, 0x4c, 0x69, 0x73, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x48,
	0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x2f, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72,
	0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x01, 0x12, 0x86,
	0x01, 0x0a, 0x14, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4f, 0x72, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x33, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65,
	0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4f, 0x72, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x62,
	0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64, 0x75,
	0x6c, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4f, 0x72, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x02, 0x12, 0x71, 0x0a, 0x0d, 0x41, 0x72, 0x63, 0x68, 0x69,
	0x76, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x2c, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72,
	0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x41, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03, 0x90, 0x02, 0x02, 0x12, 0x77, 0x0a, 0x0f, 0x55, 0x6e,
	0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x2e, 0x2e,
	0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x6e, 0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e,
	0x62, 0x75, 0x66, 0x2e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x6d, 0x6f, 0x64,
	0x75, 0x6c, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x6e, 0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x03,
	0x90, 0x02, 0x02, 0x42, 0x57, 0x5a, 0x55, 0x62, 0x75, 0x66, 0x2e, 0x62, 0x75, 0x69, 0x6c, 0x64,
	0x2f, 0x67, 0x65, 0x6e, 0x2f, 0x67, 0x6f, 0x2f, 0x62, 0x75, 0x66, 0x62, 0x75, 0x69, 0x6c, 0x64,
	0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63,
	0x6f, 0x6c, 0x62, 0x75, 0x66, 0x66, 0x65, 0x72, 0x73, 0x2f, 0x67, 0x6f, 0x2f, 0x62, 0x75, 0x66,
	0x2f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2f, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65,
	0x2f, 0x76, 0x31, 0x3b, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x76, 0x31, 0x62, 0x06, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_buf_registry_module_v1_label_service_proto_rawDescOnce sync.Once
	file_buf_registry_module_v1_label_service_proto_rawDescData = file_buf_registry_module_v1_label_service_proto_rawDesc
)

func file_buf_registry_module_v1_label_service_proto_rawDescGZIP() []byte {
	file_buf_registry_module_v1_label_service_proto_rawDescOnce.Do(func() {
		file_buf_registry_module_v1_label_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_buf_registry_module_v1_label_service_proto_rawDescData)
	})
	return file_buf_registry_module_v1_label_service_proto_rawDescData
}

var file_buf_registry_module_v1_label_service_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_buf_registry_module_v1_label_service_proto_msgTypes = make([]protoimpl.MessageInfo, 14)
var file_buf_registry_module_v1_label_service_proto_goTypes = []any{
	(ListLabelsRequest_Order)(0),              // 0: buf.registry.module.v1.ListLabelsRequest.Order
	(ListLabelsRequest_ArchiveFilter)(0),      // 1: buf.registry.module.v1.ListLabelsRequest.ArchiveFilter
	(ListLabelHistoryRequest_Order)(0),        // 2: buf.registry.module.v1.ListLabelHistoryRequest.Order
	(*GetLabelsRequest)(nil),                  // 3: buf.registry.module.v1.GetLabelsRequest
	(*GetLabelsResponse)(nil),                 // 4: buf.registry.module.v1.GetLabelsResponse
	(*ListLabelsRequest)(nil),                 // 5: buf.registry.module.v1.ListLabelsRequest
	(*ListLabelsResponse)(nil),                // 6: buf.registry.module.v1.ListLabelsResponse
	(*ListLabelHistoryRequest)(nil),           // 7: buf.registry.module.v1.ListLabelHistoryRequest
	(*ListLabelHistoryResponse)(nil),          // 8: buf.registry.module.v1.ListLabelHistoryResponse
	(*CreateOrUpdateLabelsRequest)(nil),       // 9: buf.registry.module.v1.CreateOrUpdateLabelsRequest
	(*CreateOrUpdateLabelsResponse)(nil),      // 10: buf.registry.module.v1.CreateOrUpdateLabelsResponse
	(*ArchiveLabelsRequest)(nil),              // 11: buf.registry.module.v1.ArchiveLabelsRequest
	(*ArchiveLabelsResponse)(nil),             // 12: buf.registry.module.v1.ArchiveLabelsResponse
	(*UnarchiveLabelsRequest)(nil),            // 13: buf.registry.module.v1.UnarchiveLabelsRequest
	(*UnarchiveLabelsResponse)(nil),           // 14: buf.registry.module.v1.UnarchiveLabelsResponse
	(*ListLabelHistoryResponse_Value)(nil),    // 15: buf.registry.module.v1.ListLabelHistoryResponse.Value
	(*CreateOrUpdateLabelsRequest_Value)(nil), // 16: buf.registry.module.v1.CreateOrUpdateLabelsRequest.Value
	(*LabelRef)(nil),                          // 17: buf.registry.module.v1.LabelRef
	(*Label)(nil),                             // 18: buf.registry.module.v1.Label
	(*ResourceRef)(nil),                       // 19: buf.registry.module.v1.ResourceRef
	(CommitCheckStatus)(0),                    // 20: buf.registry.module.v1.CommitCheckStatus
	(*Commit)(nil),                            // 21: buf.registry.module.v1.Commit
	(*CommitCheckState)(nil),                  // 22: buf.registry.module.v1.CommitCheckState
}
var file_buf_registry_module_v1_label_service_proto_depIdxs = []int32{
	17, // 0: buf.registry.module.v1.GetLabelsRequest.label_refs:type_name -> buf.registry.module.v1.LabelRef
	18, // 1: buf.registry.module.v1.GetLabelsResponse.labels:type_name -> buf.registry.module.v1.Label
	19, // 2: buf.registry.module.v1.ListLabelsRequest.resource_ref:type_name -> buf.registry.module.v1.ResourceRef
	0,  // 3: buf.registry.module.v1.ListLabelsRequest.order:type_name -> buf.registry.module.v1.ListLabelsRequest.Order
	20, // 4: buf.registry.module.v1.ListLabelsRequest.commit_check_statuses:type_name -> buf.registry.module.v1.CommitCheckStatus
	1,  // 5: buf.registry.module.v1.ListLabelsRequest.archive_filter:type_name -> buf.registry.module.v1.ListLabelsRequest.ArchiveFilter
	18, // 6: buf.registry.module.v1.ListLabelsResponse.labels:type_name -> buf.registry.module.v1.Label
	17, // 7: buf.registry.module.v1.ListLabelHistoryRequest.label_ref:type_name -> buf.registry.module.v1.LabelRef
	2,  // 8: buf.registry.module.v1.ListLabelHistoryRequest.order:type_name -> buf.registry.module.v1.ListLabelHistoryRequest.Order
	20, // 9: buf.registry.module.v1.ListLabelHistoryRequest.commit_check_statuses:type_name -> buf.registry.module.v1.CommitCheckStatus
	15, // 10: buf.registry.module.v1.ListLabelHistoryResponse.values:type_name -> buf.registry.module.v1.ListLabelHistoryResponse.Value
	16, // 11: buf.registry.module.v1.CreateOrUpdateLabelsRequest.values:type_name -> buf.registry.module.v1.CreateOrUpdateLabelsRequest.Value
	18, // 12: buf.registry.module.v1.CreateOrUpdateLabelsResponse.labels:type_name -> buf.registry.module.v1.Label
	17, // 13: buf.registry.module.v1.ArchiveLabelsRequest.label_refs:type_name -> buf.registry.module.v1.LabelRef
	17, // 14: buf.registry.module.v1.UnarchiveLabelsRequest.label_refs:type_name -> buf.registry.module.v1.LabelRef
	21, // 15: buf.registry.module.v1.ListLabelHistoryResponse.Value.commit:type_name -> buf.registry.module.v1.Commit
	22, // 16: buf.registry.module.v1.ListLabelHistoryResponse.Value.commit_check_state:type_name -> buf.registry.module.v1.CommitCheckState
	17, // 17: buf.registry.module.v1.CreateOrUpdateLabelsRequest.Value.label_ref:type_name -> buf.registry.module.v1.LabelRef
	3,  // 18: buf.registry.module.v1.LabelService.GetLabels:input_type -> buf.registry.module.v1.GetLabelsRequest
	5,  // 19: buf.registry.module.v1.LabelService.ListLabels:input_type -> buf.registry.module.v1.ListLabelsRequest
	7,  // 20: buf.registry.module.v1.LabelService.ListLabelHistory:input_type -> buf.registry.module.v1.ListLabelHistoryRequest
	9,  // 21: buf.registry.module.v1.LabelService.CreateOrUpdateLabels:input_type -> buf.registry.module.v1.CreateOrUpdateLabelsRequest
	11, // 22: buf.registry.module.v1.LabelService.ArchiveLabels:input_type -> buf.registry.module.v1.ArchiveLabelsRequest
	13, // 23: buf.registry.module.v1.LabelService.UnarchiveLabels:input_type -> buf.registry.module.v1.UnarchiveLabelsRequest
	4,  // 24: buf.registry.module.v1.LabelService.GetLabels:output_type -> buf.registry.module.v1.GetLabelsResponse
	6,  // 25: buf.registry.module.v1.LabelService.ListLabels:output_type -> buf.registry.module.v1.ListLabelsResponse
	8,  // 26: buf.registry.module.v1.LabelService.ListLabelHistory:output_type -> buf.registry.module.v1.ListLabelHistoryResponse
	10, // 27: buf.registry.module.v1.LabelService.CreateOrUpdateLabels:output_type -> buf.registry.module.v1.CreateOrUpdateLabelsResponse
	12, // 28: buf.registry.module.v1.LabelService.ArchiveLabels:output_type -> buf.registry.module.v1.ArchiveLabelsResponse
	14, // 29: buf.registry.module.v1.LabelService.UnarchiveLabels:output_type -> buf.registry.module.v1.UnarchiveLabelsResponse
	24, // [24:30] is the sub-list for method output_type
	18, // [18:24] is the sub-list for method input_type
	18, // [18:18] is the sub-list for extension type_name
	18, // [18:18] is the sub-list for extension extendee
	0,  // [0:18] is the sub-list for field type_name
}

func init() { file_buf_registry_module_v1_label_service_proto_init() }
func file_buf_registry_module_v1_label_service_proto_init() {
	if File_buf_registry_module_v1_label_service_proto != nil {
		return
	}
	file_buf_registry_module_v1_commit_proto_init()
	file_buf_registry_module_v1_label_proto_init()
	file_buf_registry_module_v1_resource_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_buf_registry_module_v1_label_service_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*GetLabelsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_registry_module_v1_label_service_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*GetLabelsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_registry_module_v1_label_service_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*ListLabelsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_registry_module_v1_label_service_proto_msgTypes[3].Exporter = func(v any, i int) any {
			switch v := v.(*ListLabelsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_registry_module_v1_label_service_proto_msgTypes[4].Exporter = func(v any, i int) any {
			switch v := v.(*ListLabelHistoryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_registry_module_v1_label_service_proto_msgTypes[5].Exporter = func(v any, i int) any {
			switch v := v.(*ListLabelHistoryResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_registry_module_v1_label_service_proto_msgTypes[6].Exporter = func(v any, i int) any {
			switch v := v.(*CreateOrUpdateLabelsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_registry_module_v1_label_service_proto_msgTypes[7].Exporter = func(v any, i int) any {
			switch v := v.(*CreateOrUpdateLabelsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_registry_module_v1_label_service_proto_msgTypes[8].Exporter = func(v any, i int) any {
			switch v := v.(*ArchiveLabelsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_registry_module_v1_label_service_proto_msgTypes[9].Exporter = func(v any, i int) any {
			switch v := v.(*ArchiveLabelsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_registry_module_v1_label_service_proto_msgTypes[10].Exporter = func(v any, i int) any {
			switch v := v.(*UnarchiveLabelsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_registry_module_v1_label_service_proto_msgTypes[11].Exporter = func(v any, i int) any {
			switch v := v.(*UnarchiveLabelsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_registry_module_v1_label_service_proto_msgTypes[12].Exporter = func(v any, i int) any {
			switch v := v.(*ListLabelHistoryResponse_Value); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_buf_registry_module_v1_label_service_proto_msgTypes[13].Exporter = func(v any, i int) any {
			switch v := v.(*CreateOrUpdateLabelsRequest_Value); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_buf_registry_module_v1_label_service_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   14,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_buf_registry_module_v1_label_service_proto_goTypes,
		DependencyIndexes: file_buf_registry_module_v1_label_service_proto_depIdxs,
		EnumInfos:         file_buf_registry_module_v1_label_service_proto_enumTypes,
		MessageInfos:      file_buf_registry_module_v1_label_service_proto_msgTypes,
	}.Build()
	File_buf_registry_module_v1_label_service_proto = out.File
	file_buf_registry_module_v1_label_service_proto_rawDesc = nil
	file_buf_registry_module_v1_label_service_proto_goTypes = nil
	file_buf_registry_module_v1_label_service_proto_depIdxs = nil
}
