// Copyright 2024 Prometheus Team
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// NOTE: This file is also available on https://buf.build/prometheus/prometheus/docs/main:io.prometheus.write.v2

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.10
// 	protoc        (unknown)
// source: io/prometheus/write/v2/types.proto

//go:build protoopaque

package writev2

import (
	_ "buf.build/gen/go/gogo/protobuf/protocolbuffers/go/gogoproto"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type Metadata_MetricType int32

const (
	Metadata_METRIC_TYPE_UNSPECIFIED    Metadata_MetricType = 0
	Metadata_METRIC_TYPE_COUNTER        Metadata_MetricType = 1
	Metadata_METRIC_TYPE_GAUGE          Metadata_MetricType = 2
	Metadata_METRIC_TYPE_HISTOGRAM      Metadata_MetricType = 3
	Metadata_METRIC_TYPE_GAUGEHISTOGRAM Metadata_MetricType = 4
	Metadata_METRIC_TYPE_SUMMARY        Metadata_MetricType = 5
	Metadata_METRIC_TYPE_INFO           Metadata_MetricType = 6
	Metadata_METRIC_TYPE_STATESET       Metadata_MetricType = 7
)

// Enum value maps for Metadata_MetricType.
var (
	Metadata_MetricType_name = map[int32]string{
		0: "METRIC_TYPE_UNSPECIFIED",
		1: "METRIC_TYPE_COUNTER",
		2: "METRIC_TYPE_GAUGE",
		3: "METRIC_TYPE_HISTOGRAM",
		4: "METRIC_TYPE_GAUGEHISTOGRAM",
		5: "METRIC_TYPE_SUMMARY",
		6: "METRIC_TYPE_INFO",
		7: "METRIC_TYPE_STATESET",
	}
	Metadata_MetricType_value = map[string]int32{
		"METRIC_TYPE_UNSPECIFIED":    0,
		"METRIC_TYPE_COUNTER":        1,
		"METRIC_TYPE_GAUGE":          2,
		"METRIC_TYPE_HISTOGRAM":      3,
		"METRIC_TYPE_GAUGEHISTOGRAM": 4,
		"METRIC_TYPE_SUMMARY":        5,
		"METRIC_TYPE_INFO":           6,
		"METRIC_TYPE_STATESET":       7,
	}
)

func (x Metadata_MetricType) Enum() *Metadata_MetricType {
	p := new(Metadata_MetricType)
	*p = x
	return p
}

func (x Metadata_MetricType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Metadata_MetricType) Descriptor() protoreflect.EnumDescriptor {
	return file_io_prometheus_write_v2_types_proto_enumTypes[0].Descriptor()
}

func (Metadata_MetricType) Type() protoreflect.EnumType {
	return &file_io_prometheus_write_v2_types_proto_enumTypes[0]
}

func (x Metadata_MetricType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

type Histogram_ResetHint int32

const (
	Histogram_RESET_HINT_UNSPECIFIED Histogram_ResetHint = 0 // Need to test for a counter reset explicitly.
	Histogram_RESET_HINT_YES         Histogram_ResetHint = 1 // This is the 1st histogram after a counter reset.
	Histogram_RESET_HINT_NO          Histogram_ResetHint = 2 // There was no counter reset between this and the previous Histogram.
	Histogram_RESET_HINT_GAUGE       Histogram_ResetHint = 3 // This is a gauge histogram where counter resets don't happen.
)

// Enum value maps for Histogram_ResetHint.
var (
	Histogram_ResetHint_name = map[int32]string{
		0: "RESET_HINT_UNSPECIFIED",
		1: "RESET_HINT_YES",
		2: "RESET_HINT_NO",
		3: "RESET_HINT_GAUGE",
	}
	Histogram_ResetHint_value = map[string]int32{
		"RESET_HINT_UNSPECIFIED": 0,
		"RESET_HINT_YES":         1,
		"RESET_HINT_NO":          2,
		"RESET_HINT_GAUGE":       3,
	}
)

func (x Histogram_ResetHint) Enum() *Histogram_ResetHint {
	p := new(Histogram_ResetHint)
	*p = x
	return p
}

func (x Histogram_ResetHint) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Histogram_ResetHint) Descriptor() protoreflect.EnumDescriptor {
	return file_io_prometheus_write_v2_types_proto_enumTypes[1].Descriptor()
}

func (Histogram_ResetHint) Type() protoreflect.EnumType {
	return &file_io_prometheus_write_v2_types_proto_enumTypes[1]
}

func (x Histogram_ResetHint) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Request represents a request to write the given timeseries to a remote destination.
// This message was introduced in the Remote Write 2.0 specification:
// https://prometheus.io/docs/concepts/remote_write_spec_2_0/
//
// The canonical Content-Type request header value for this message is
// "application/x-protobuf;proto=io.prometheus.write.v2.Request"
//
// Version: v2.0-rc.4
//
// NOTE: gogoproto options might change in future for this file, they
// are not part of the spec proto (they only modify the generated Go code, not
// the serialized message). See: https://github.com/prometheus/prometheus/issues/11908
type Request struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Symbols    []string               `protobuf:"bytes,4,rep,name=symbols,proto3"`
	xxx_hidden_Timeseries *[]*TimeSeries         `protobuf:"bytes,5,rep,name=timeseries,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *Request) Reset() {
	*x = Request{}
	mi := &file_io_prometheus_write_v2_types_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Request) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Request) ProtoMessage() {}

func (x *Request) ProtoReflect() protoreflect.Message {
	mi := &file_io_prometheus_write_v2_types_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Request) GetSymbols() []string {
	if x != nil {
		return x.xxx_hidden_Symbols
	}
	return nil
}

func (x *Request) GetTimeseries() []*TimeSeries {
	if x != nil {
		if x.xxx_hidden_Timeseries != nil {
			return *x.xxx_hidden_Timeseries
		}
	}
	return nil
}

func (x *Request) SetSymbols(v []string) {
	x.xxx_hidden_Symbols = v
}

func (x *Request) SetTimeseries(v []*TimeSeries) {
	x.xxx_hidden_Timeseries = &v
}

type Request_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// symbols contains a de-duplicated array of string elements used for various
	// items in a Request message, like labels and metadata items. For the sender's convenience
	// around empty values for optional fields like unit_ref, symbols array MUST start with
	// empty string.
	//
	// To decode each of the symbolized strings, referenced, by "ref(s)" suffix, you
	// need to lookup the actual string by index from symbols array. The order of
	// strings is up to the sender. The receiver should not assume any particular encoding.
	Symbols []string
	// timeseries represents an array of distinct series with 0 or more samples.
	Timeseries []*TimeSeries
}

func (b0 Request_builder) Build() *Request {
	m0 := &Request{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Symbols = b.Symbols
	x.xxx_hidden_Timeseries = &b.Timeseries
	return m0
}

// TimeSeries represents a single series.
type TimeSeries struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_LabelsRefs []uint32               `protobuf:"varint,1,rep,packed,name=labels_refs,json=labelsRefs,proto3"`
	xxx_hidden_Samples    *[]*Sample             `protobuf:"bytes,2,rep,name=samples,proto3"`
	xxx_hidden_Histograms *[]*Histogram          `protobuf:"bytes,3,rep,name=histograms,proto3"`
	xxx_hidden_Exemplars  *[]*Exemplar           `protobuf:"bytes,4,rep,name=exemplars,proto3"`
	xxx_hidden_Metadata   *Metadata              `protobuf:"bytes,5,opt,name=metadata,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *TimeSeries) Reset() {
	*x = TimeSeries{}
	mi := &file_io_prometheus_write_v2_types_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TimeSeries) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TimeSeries) ProtoMessage() {}

func (x *TimeSeries) ProtoReflect() protoreflect.Message {
	mi := &file_io_prometheus_write_v2_types_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *TimeSeries) GetLabelsRefs() []uint32 {
	if x != nil {
		return x.xxx_hidden_LabelsRefs
	}
	return nil
}

func (x *TimeSeries) GetSamples() []*Sample {
	if x != nil {
		if x.xxx_hidden_Samples != nil {
			return *x.xxx_hidden_Samples
		}
	}
	return nil
}

func (x *TimeSeries) GetHistograms() []*Histogram {
	if x != nil {
		if x.xxx_hidden_Histograms != nil {
			return *x.xxx_hidden_Histograms
		}
	}
	return nil
}

func (x *TimeSeries) GetExemplars() []*Exemplar {
	if x != nil {
		if x.xxx_hidden_Exemplars != nil {
			return *x.xxx_hidden_Exemplars
		}
	}
	return nil
}

func (x *TimeSeries) GetMetadata() *Metadata {
	if x != nil {
		return x.xxx_hidden_Metadata
	}
	return nil
}

func (x *TimeSeries) SetLabelsRefs(v []uint32) {
	x.xxx_hidden_LabelsRefs = v
}

func (x *TimeSeries) SetSamples(v []*Sample) {
	x.xxx_hidden_Samples = &v
}

func (x *TimeSeries) SetHistograms(v []*Histogram) {
	x.xxx_hidden_Histograms = &v
}

func (x *TimeSeries) SetExemplars(v []*Exemplar) {
	x.xxx_hidden_Exemplars = &v
}

func (x *TimeSeries) SetMetadata(v *Metadata) {
	x.xxx_hidden_Metadata = v
}

func (x *TimeSeries) HasMetadata() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Metadata != nil
}

func (x *TimeSeries) ClearMetadata() {
	x.xxx_hidden_Metadata = nil
}

type TimeSeries_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// labels_refs is a list of label name-value pair references, encoded
	// as indices to the Request.symbols array. This list's length is always
	// a multiple of two, and the underlying labels should be sorted lexicographically.
	//
	// Note that there might be multiple TimeSeries objects in the same
	// Requests with the same labels e.g. for different exemplars, metadata
	// or start timestamp.
	LabelsRefs []uint32
	// Timeseries messages can either specify samples or (native) histogram samples
	// (histogram field), but not both. For a typical sender (real-time metric
	// streaming), in healthy cases, there will be only one sample or histogram.
	//
	// Samples and histograms are sorted by timestamp (older first).
	Samples    []*Sample
	Histograms []*Histogram
	// exemplars represents an optional set of exemplars attached to this series' samples.
	Exemplars []*Exemplar
	// metadata represents the metadata associated with the given series' samples.
	Metadata *Metadata
}

func (b0 TimeSeries_builder) Build() *TimeSeries {
	m0 := &TimeSeries{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_LabelsRefs = b.LabelsRefs
	x.xxx_hidden_Samples = &b.Samples
	x.xxx_hidden_Histograms = &b.Histograms
	x.xxx_hidden_Exemplars = &b.Exemplars
	x.xxx_hidden_Metadata = b.Metadata
	return m0
}

// Exemplar is an additional information attached to some series' samples.
// It is typically used to attach an example trace or request ID associated with
// the metric changes.
type Exemplar struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_LabelsRefs []uint32               `protobuf:"varint,1,rep,packed,name=labels_refs,json=labelsRefs,proto3"`
	xxx_hidden_Value      float64                `protobuf:"fixed64,2,opt,name=value,proto3"`
	xxx_hidden_Timestamp  int64                  `protobuf:"varint,3,opt,name=timestamp,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *Exemplar) Reset() {
	*x = Exemplar{}
	mi := &file_io_prometheus_write_v2_types_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Exemplar) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Exemplar) ProtoMessage() {}

func (x *Exemplar) ProtoReflect() protoreflect.Message {
	mi := &file_io_prometheus_write_v2_types_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Exemplar) GetLabelsRefs() []uint32 {
	if x != nil {
		return x.xxx_hidden_LabelsRefs
	}
	return nil
}

func (x *Exemplar) GetValue() float64 {
	if x != nil {
		return x.xxx_hidden_Value
	}
	return 0
}

func (x *Exemplar) GetTimestamp() int64 {
	if x != nil {
		return x.xxx_hidden_Timestamp
	}
	return 0
}

func (x *Exemplar) SetLabelsRefs(v []uint32) {
	x.xxx_hidden_LabelsRefs = v
}

func (x *Exemplar) SetValue(v float64) {
	x.xxx_hidden_Value = v
}

func (x *Exemplar) SetTimestamp(v int64) {
	x.xxx_hidden_Timestamp = v
}

type Exemplar_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// labels_refs is an optional list of label name-value pair references, encoded
	// as indices to the Request.symbols array. This list's len is always
	// a multiple of 2, and the underlying labels should be sorted lexicographically.
	// If the exemplar references a trace it should use the `trace_id` label name, as a best practice.
	LabelsRefs []uint32
	// value represents an exact example value. This can be useful when the exemplar
	// is attached to a histogram, which only gives an estimated value through buckets.
	Value float64
	// timestamp represents the timestamp of the exemplar in ms.
	//
	// For Go, see github.com/prometheus/prometheus/model/timestamp/timestamp.go
	// for conversion from/to time.Time to Prometheus timestamp.
	Timestamp int64
}

func (b0 Exemplar_builder) Build() *Exemplar {
	m0 := &Exemplar{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_LabelsRefs = b.LabelsRefs
	x.xxx_hidden_Value = b.Value
	x.xxx_hidden_Timestamp = b.Timestamp
	return m0
}

// Sample represents series sample.
type Sample struct {
	state                     protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Value          float64                `protobuf:"fixed64,1,opt,name=value,proto3"`
	xxx_hidden_Timestamp      int64                  `protobuf:"varint,2,opt,name=timestamp,proto3"`
	xxx_hidden_StartTimestamp int64                  `protobuf:"varint,3,opt,name=start_timestamp,json=startTimestamp,proto3"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *Sample) Reset() {
	*x = Sample{}
	mi := &file_io_prometheus_write_v2_types_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Sample) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Sample) ProtoMessage() {}

func (x *Sample) ProtoReflect() protoreflect.Message {
	mi := &file_io_prometheus_write_v2_types_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Sample) GetValue() float64 {
	if x != nil {
		return x.xxx_hidden_Value
	}
	return 0
}

func (x *Sample) GetTimestamp() int64 {
	if x != nil {
		return x.xxx_hidden_Timestamp
	}
	return 0
}

func (x *Sample) GetStartTimestamp() int64 {
	if x != nil {
		return x.xxx_hidden_StartTimestamp
	}
	return 0
}

func (x *Sample) SetValue(v float64) {
	x.xxx_hidden_Value = v
}

func (x *Sample) SetTimestamp(v int64) {
	x.xxx_hidden_Timestamp = v
}

func (x *Sample) SetStartTimestamp(v int64) {
	x.xxx_hidden_StartTimestamp = v
}

type Sample_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// value of the sample.
	Value float64
	// timestamp represents timestamp of the sample in ms.
	//
	// For Go, see github.com/prometheus/prometheus/model/timestamp/timestamp.go
	// for conversion from/to time.Time to Prometheus timestamp.
	Timestamp int64
	// start_timestamp represents an optional start timestamp for the sample,
	// in ms format. This information is typically used for counter, histogram (cumulative)
	// or delta type metrics.
	//
	// For cumulative metrics, the start timestamp represents the time when the
	// counter started counting (sometimes referred to as start timestamp), which
	// can increase the accuracy of certain processing and query semantics (e.g. rates).
	//
	// Note:
	// * That some receivers might require start timestamps for certain metric
	// types; rejecting such samples within the Request as a result.
	// * start timestamp is the same as "created timestamp" name Prometheus used in the past.
	//
	// For Go, see github.com/prometheus/prometheus/model/timestamp/timestamp.go
	// for conversion from/to time.Time to Prometheus timestamp.
	//
	// Note that the "optional" keyword is omitted due to efficiency and consistency.
	// Zero value means value not set. If you need to use exactly zero value for
	// the timestamp, use 1 millisecond before or after.
	StartTimestamp int64
}

func (b0 Sample_builder) Build() *Sample {
	m0 := &Sample{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Value = b.Value
	x.xxx_hidden_Timestamp = b.Timestamp
	x.xxx_hidden_StartTimestamp = b.StartTimestamp
	return m0
}

// Metadata represents the metadata associated with the given series' samples.
type Metadata struct {
	state              protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Type    Metadata_MetricType    `protobuf:"varint,1,opt,name=type,proto3,enum=io.prometheus.write.v2.Metadata_MetricType"`
	xxx_hidden_HelpRef uint32                 `protobuf:"varint,3,opt,name=help_ref,json=helpRef,proto3"`
	xxx_hidden_UnitRef uint32                 `protobuf:"varint,4,opt,name=unit_ref,json=unitRef,proto3"`
	unknownFields      protoimpl.UnknownFields
	sizeCache          protoimpl.SizeCache
}

func (x *Metadata) Reset() {
	*x = Metadata{}
	mi := &file_io_prometheus_write_v2_types_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Metadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Metadata) ProtoMessage() {}

func (x *Metadata) ProtoReflect() protoreflect.Message {
	mi := &file_io_prometheus_write_v2_types_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Metadata) GetType() Metadata_MetricType {
	if x != nil {
		return x.xxx_hidden_Type
	}
	return Metadata_METRIC_TYPE_UNSPECIFIED
}

func (x *Metadata) GetHelpRef() uint32 {
	if x != nil {
		return x.xxx_hidden_HelpRef
	}
	return 0
}

func (x *Metadata) GetUnitRef() uint32 {
	if x != nil {
		return x.xxx_hidden_UnitRef
	}
	return 0
}

func (x *Metadata) SetType(v Metadata_MetricType) {
	x.xxx_hidden_Type = v
}

func (x *Metadata) SetHelpRef(v uint32) {
	x.xxx_hidden_HelpRef = v
}

func (x *Metadata) SetUnitRef(v uint32) {
	x.xxx_hidden_UnitRef = v
}

type Metadata_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Type Metadata_MetricType
	// help_ref is a reference to the Request.symbols array representing help
	// text for the metric. Help is optional, reference should point to an empty string in
	// such a case.
	HelpRef uint32
	// unit_ref is a reference to the Request.symbols array representing a unit
	// for the metric. Unit is optional, reference should point to an empty string in
	// such a case.
	UnitRef uint32
}

func (b0 Metadata_builder) Build() *Metadata {
	m0 := &Metadata{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Type = b.Type
	x.xxx_hidden_HelpRef = b.HelpRef
	x.xxx_hidden_UnitRef = b.UnitRef
	return m0
}

// A native histogram message, supporting
// * sparse exponential bucketing, custom bucketing.
// * float or integer histograms.
//
// See the full spec: https://prometheus.io/docs/specs/native_histograms/
type Histogram struct {
	state                     protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Count          isHistogram_Count      `protobuf_oneof:"count"`
	xxx_hidden_Sum            float64                `protobuf:"fixed64,3,opt,name=sum,proto3"`
	xxx_hidden_Schema         int32                  `protobuf:"zigzag32,4,opt,name=schema,proto3"`
	xxx_hidden_ZeroThreshold  float64                `protobuf:"fixed64,5,opt,name=zero_threshold,json=zeroThreshold,proto3"`
	xxx_hidden_ZeroCount      isHistogram_ZeroCount  `protobuf_oneof:"zero_count"`
	xxx_hidden_NegativeSpans  *[]*BucketSpan         `protobuf:"bytes,8,rep,name=negative_spans,json=negativeSpans,proto3"`
	xxx_hidden_NegativeDeltas []int64                `protobuf:"zigzag64,9,rep,packed,name=negative_deltas,json=negativeDeltas,proto3"`
	xxx_hidden_NegativeCounts []float64              `protobuf:"fixed64,10,rep,packed,name=negative_counts,json=negativeCounts,proto3"`
	xxx_hidden_PositiveSpans  *[]*BucketSpan         `protobuf:"bytes,11,rep,name=positive_spans,json=positiveSpans,proto3"`
	xxx_hidden_PositiveDeltas []int64                `protobuf:"zigzag64,12,rep,packed,name=positive_deltas,json=positiveDeltas,proto3"`
	xxx_hidden_PositiveCounts []float64              `protobuf:"fixed64,13,rep,packed,name=positive_counts,json=positiveCounts,proto3"`
	xxx_hidden_ResetHint      Histogram_ResetHint    `protobuf:"varint,14,opt,name=reset_hint,json=resetHint,proto3,enum=io.prometheus.write.v2.Histogram_ResetHint"`
	xxx_hidden_Timestamp      int64                  `protobuf:"varint,15,opt,name=timestamp,proto3"`
	xxx_hidden_CustomValues   []float64              `protobuf:"fixed64,16,rep,packed,name=custom_values,json=customValues,proto3"`
	xxx_hidden_StartTimestamp int64                  `protobuf:"varint,17,opt,name=start_timestamp,json=startTimestamp,proto3"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *Histogram) Reset() {
	*x = Histogram{}
	mi := &file_io_prometheus_write_v2_types_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Histogram) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Histogram) ProtoMessage() {}

func (x *Histogram) ProtoReflect() protoreflect.Message {
	mi := &file_io_prometheus_write_v2_types_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Histogram) GetCountInt() uint64 {
	if x != nil {
		if x, ok := x.xxx_hidden_Count.(*histogram_CountInt); ok {
			return x.CountInt
		}
	}
	return 0
}

func (x *Histogram) GetCountFloat() float64 {
	if x != nil {
		if x, ok := x.xxx_hidden_Count.(*histogram_CountFloat); ok {
			return x.CountFloat
		}
	}
	return 0
}

func (x *Histogram) GetSum() float64 {
	if x != nil {
		return x.xxx_hidden_Sum
	}
	return 0
}

func (x *Histogram) GetSchema() int32 {
	if x != nil {
		return x.xxx_hidden_Schema
	}
	return 0
}

func (x *Histogram) GetZeroThreshold() float64 {
	if x != nil {
		return x.xxx_hidden_ZeroThreshold
	}
	return 0
}

func (x *Histogram) GetZeroCountInt() uint64 {
	if x != nil {
		if x, ok := x.xxx_hidden_ZeroCount.(*histogram_ZeroCountInt); ok {
			return x.ZeroCountInt
		}
	}
	return 0
}

func (x *Histogram) GetZeroCountFloat() float64 {
	if x != nil {
		if x, ok := x.xxx_hidden_ZeroCount.(*histogram_ZeroCountFloat); ok {
			return x.ZeroCountFloat
		}
	}
	return 0
}

func (x *Histogram) GetNegativeSpans() []*BucketSpan {
	if x != nil {
		if x.xxx_hidden_NegativeSpans != nil {
			return *x.xxx_hidden_NegativeSpans
		}
	}
	return nil
}

func (x *Histogram) GetNegativeDeltas() []int64 {
	if x != nil {
		return x.xxx_hidden_NegativeDeltas
	}
	return nil
}

func (x *Histogram) GetNegativeCounts() []float64 {
	if x != nil {
		return x.xxx_hidden_NegativeCounts
	}
	return nil
}

func (x *Histogram) GetPositiveSpans() []*BucketSpan {
	if x != nil {
		if x.xxx_hidden_PositiveSpans != nil {
			return *x.xxx_hidden_PositiveSpans
		}
	}
	return nil
}

func (x *Histogram) GetPositiveDeltas() []int64 {
	if x != nil {
		return x.xxx_hidden_PositiveDeltas
	}
	return nil
}

func (x *Histogram) GetPositiveCounts() []float64 {
	if x != nil {
		return x.xxx_hidden_PositiveCounts
	}
	return nil
}

func (x *Histogram) GetResetHint() Histogram_ResetHint {
	if x != nil {
		return x.xxx_hidden_ResetHint
	}
	return Histogram_RESET_HINT_UNSPECIFIED
}

func (x *Histogram) GetTimestamp() int64 {
	if x != nil {
		return x.xxx_hidden_Timestamp
	}
	return 0
}

func (x *Histogram) GetCustomValues() []float64 {
	if x != nil {
		return x.xxx_hidden_CustomValues
	}
	return nil
}

func (x *Histogram) GetStartTimestamp() int64 {
	if x != nil {
		return x.xxx_hidden_StartTimestamp
	}
	return 0
}

func (x *Histogram) SetCountInt(v uint64) {
	x.xxx_hidden_Count = &histogram_CountInt{v}
}

func (x *Histogram) SetCountFloat(v float64) {
	x.xxx_hidden_Count = &histogram_CountFloat{v}
}

func (x *Histogram) SetSum(v float64) {
	x.xxx_hidden_Sum = v
}

func (x *Histogram) SetSchema(v int32) {
	x.xxx_hidden_Schema = v
}

func (x *Histogram) SetZeroThreshold(v float64) {
	x.xxx_hidden_ZeroThreshold = v
}

func (x *Histogram) SetZeroCountInt(v uint64) {
	x.xxx_hidden_ZeroCount = &histogram_ZeroCountInt{v}
}

func (x *Histogram) SetZeroCountFloat(v float64) {
	x.xxx_hidden_ZeroCount = &histogram_ZeroCountFloat{v}
}

func (x *Histogram) SetNegativeSpans(v []*BucketSpan) {
	x.xxx_hidden_NegativeSpans = &v
}

func (x *Histogram) SetNegativeDeltas(v []int64) {
	x.xxx_hidden_NegativeDeltas = v
}

func (x *Histogram) SetNegativeCounts(v []float64) {
	x.xxx_hidden_NegativeCounts = v
}

func (x *Histogram) SetPositiveSpans(v []*BucketSpan) {
	x.xxx_hidden_PositiveSpans = &v
}

func (x *Histogram) SetPositiveDeltas(v []int64) {
	x.xxx_hidden_PositiveDeltas = v
}

func (x *Histogram) SetPositiveCounts(v []float64) {
	x.xxx_hidden_PositiveCounts = v
}

func (x *Histogram) SetResetHint(v Histogram_ResetHint) {
	x.xxx_hidden_ResetHint = v
}

func (x *Histogram) SetTimestamp(v int64) {
	x.xxx_hidden_Timestamp = v
}

func (x *Histogram) SetCustomValues(v []float64) {
	x.xxx_hidden_CustomValues = v
}

func (x *Histogram) SetStartTimestamp(v int64) {
	x.xxx_hidden_StartTimestamp = v
}

func (x *Histogram) HasCount() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Count != nil
}

func (x *Histogram) HasCountInt() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Count.(*histogram_CountInt)
	return ok
}

func (x *Histogram) HasCountFloat() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Count.(*histogram_CountFloat)
	return ok
}

func (x *Histogram) HasZeroCount() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_ZeroCount != nil
}

func (x *Histogram) HasZeroCountInt() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_ZeroCount.(*histogram_ZeroCountInt)
	return ok
}

func (x *Histogram) HasZeroCountFloat() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_ZeroCount.(*histogram_ZeroCountFloat)
	return ok
}

func (x *Histogram) ClearCount() {
	x.xxx_hidden_Count = nil
}

func (x *Histogram) ClearCountInt() {
	if _, ok := x.xxx_hidden_Count.(*histogram_CountInt); ok {
		x.xxx_hidden_Count = nil
	}
}

func (x *Histogram) ClearCountFloat() {
	if _, ok := x.xxx_hidden_Count.(*histogram_CountFloat); ok {
		x.xxx_hidden_Count = nil
	}
}

func (x *Histogram) ClearZeroCount() {
	x.xxx_hidden_ZeroCount = nil
}

func (x *Histogram) ClearZeroCountInt() {
	if _, ok := x.xxx_hidden_ZeroCount.(*histogram_ZeroCountInt); ok {
		x.xxx_hidden_ZeroCount = nil
	}
}

func (x *Histogram) ClearZeroCountFloat() {
	if _, ok := x.xxx_hidden_ZeroCount.(*histogram_ZeroCountFloat); ok {
		x.xxx_hidden_ZeroCount = nil
	}
}

const Histogram_Count_not_set_case case_Histogram_Count = 0
const Histogram_CountInt_case case_Histogram_Count = 1
const Histogram_CountFloat_case case_Histogram_Count = 2

func (x *Histogram) WhichCount() case_Histogram_Count {
	if x == nil {
		return Histogram_Count_not_set_case
	}
	switch x.xxx_hidden_Count.(type) {
	case *histogram_CountInt:
		return Histogram_CountInt_case
	case *histogram_CountFloat:
		return Histogram_CountFloat_case
	default:
		return Histogram_Count_not_set_case
	}
}

const Histogram_ZeroCount_not_set_case case_Histogram_ZeroCount = 0
const Histogram_ZeroCountInt_case case_Histogram_ZeroCount = 6
const Histogram_ZeroCountFloat_case case_Histogram_ZeroCount = 7

func (x *Histogram) WhichZeroCount() case_Histogram_ZeroCount {
	if x == nil {
		return Histogram_ZeroCount_not_set_case
	}
	switch x.xxx_hidden_ZeroCount.(type) {
	case *histogram_ZeroCountInt:
		return Histogram_ZeroCountInt_case
	case *histogram_ZeroCountFloat:
		return Histogram_ZeroCountFloat_case
	default:
		return Histogram_ZeroCount_not_set_case
	}
}

type Histogram_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Fields of oneof xxx_hidden_Count:
	CountInt   *uint64
	CountFloat *float64
	// -- end of xxx_hidden_Count
	Sum float64
	// The schema defines the bucket schema. Currently, valid numbers
	// are -53 and numbers in range of -4 <= n <= 8. More valid numbers might be
	// added in future for new bucketing layouts.
	//
	// The schema equal to -53 means custom buckets. See
	// custom_values field description for more details.
	//
	// Values between -4 and 8 represent base-2 bucket schema, where 1
	// is a bucket boundary in each case, and then each power of two is
	// divided into 2^n (n is schema value) logarithmic buckets. Or in other words,
	// each bucket boundary is the previous boundary times 2^(2^-n).
	Schema        int32
	ZeroThreshold float64
	// Fields of oneof xxx_hidden_ZeroCount:
	ZeroCountInt   *uint64
	ZeroCountFloat *float64
	// -- end of xxx_hidden_ZeroCount
	// Negative Buckets.
	NegativeSpans []*BucketSpan
	// Use either "negative_deltas" or "negative_counts", the former for
	// regular histograms with integer counts, the latter for
	// float histograms.
	NegativeDeltas []int64
	NegativeCounts []float64
	// Positive Buckets.
	//
	// In case of custom buckets (-53 schema value) the positive buckets are interpreted as follows:
	// * The span offset+length points to an the index of the custom_values array
	// or +Inf if pointing to the len of the array.
	// * The counts and deltas have the same meaning as for exponential histograms.
	PositiveSpans []*BucketSpan
	// Use either "positive_deltas" or "positive_counts", the former for
	// regular histograms with integer counts, the latter for
	// float histograms.
	PositiveDeltas []int64
	PositiveCounts []float64
	ResetHint      Histogram_ResetHint
	// timestamp represents timestamp of the sample in ms.
	//
	// For Go, see github.com/prometheus/prometheus/model/timestamp/timestamp.go
	// for conversion from/to time.Time to Prometheus timestamp.
	Timestamp int64
	// custom_values is an additional field used by non-exponential bucketing layouts.
	//
	// For custom buckets (-53 schema value) custom_values specify monotonically
	// increasing upper inclusive boundaries for the bucket counts with arbitrary
	// widths for this histogram. In other words, custom_values represents custom,
	// explicit bucketing that could have been converted from the classic histograms.
	//
	// Those bounds are then referenced by spans in positive_spans with corresponding positive
	// counts of deltas (refer to positive_spans for more details). This way we can
	// have encode sparse histograms with custom bucketing (many buckets are often
	// not used).
	//
	// Note that for custom bounds, even negative observations are placed in the positive
	// counts to simplify the implementation and avoid ambiguity of where to place
	// an underflow bucket, e.g. (-2, 1]. Therefore negative buckets and
	// the zero bucket are unused, if the schema indicates custom bucketing.
	//
	// For each upper boundary the previous boundary represent the lower exclusive
	// boundary for that bucket. The first element is the upper inclusive boundary
	// for the first bucket, which implicitly has a lower inclusive bound of -Inf.
	// This is similar to "le" label semantics on classic histograms. You may add a
	// bucket with an upper bound of 0 to make sure that you really have no negative
	// observations, but in practice, native histogram rendering will show both with
	// or without first upper boundary 0 and no negative counts as the same case.
	//
	// The last element is not only the upper inclusive bound of the last regular
	// bucket, but implicitly the lower exclusive bound of the +Inf bucket.
	CustomValues []float64
	// start_timestamp represents an optional start timestamp for the histogram sample,
	// in ms format. The start timestamp represents the time when the histogram
	// started counting, which can increase the accuracy of certain processing and
	// query semantics (e.g. rates).
	//
	// Note:
	// * That some receivers might require start timestamps for certain metric
	// types; rejecting such samples within the Request as a result.
	// * start timestamp is the same as "created timestamp" name Prometheus used in the past.
	//
	// For Go, see github.com/prometheus/prometheus/model/timestamp/timestamp.go
	// for conversion from/to time.Time to Prometheus timestamp.
	//
	// Note that the "optional" keyword is omitted due to efficiency and consistency.
	// Zero value means value not set. If you need to use exactly zero value for
	// the timestamp, use 1 millisecond before or after.
	StartTimestamp int64
}

func (b0 Histogram_builder) Build() *Histogram {
	m0 := &Histogram{}
	b, x := &b0, m0
	_, _ = b, x
	if b.CountInt != nil {
		x.xxx_hidden_Count = &histogram_CountInt{*b.CountInt}
	}
	if b.CountFloat != nil {
		x.xxx_hidden_Count = &histogram_CountFloat{*b.CountFloat}
	}
	x.xxx_hidden_Sum = b.Sum
	x.xxx_hidden_Schema = b.Schema
	x.xxx_hidden_ZeroThreshold = b.ZeroThreshold
	if b.ZeroCountInt != nil {
		x.xxx_hidden_ZeroCount = &histogram_ZeroCountInt{*b.ZeroCountInt}
	}
	if b.ZeroCountFloat != nil {
		x.xxx_hidden_ZeroCount = &histogram_ZeroCountFloat{*b.ZeroCountFloat}
	}
	x.xxx_hidden_NegativeSpans = &b.NegativeSpans
	x.xxx_hidden_NegativeDeltas = b.NegativeDeltas
	x.xxx_hidden_NegativeCounts = b.NegativeCounts
	x.xxx_hidden_PositiveSpans = &b.PositiveSpans
	x.xxx_hidden_PositiveDeltas = b.PositiveDeltas
	x.xxx_hidden_PositiveCounts = b.PositiveCounts
	x.xxx_hidden_ResetHint = b.ResetHint
	x.xxx_hidden_Timestamp = b.Timestamp
	x.xxx_hidden_CustomValues = b.CustomValues
	x.xxx_hidden_StartTimestamp = b.StartTimestamp
	return m0
}

type case_Histogram_Count protoreflect.FieldNumber

func (x case_Histogram_Count) String() string {
	md := file_io_prometheus_write_v2_types_proto_msgTypes[5].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type case_Histogram_ZeroCount protoreflect.FieldNumber

func (x case_Histogram_ZeroCount) String() string {
	md := file_io_prometheus_write_v2_types_proto_msgTypes[5].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type isHistogram_Count interface {
	isHistogram_Count()
}

type histogram_CountInt struct {
	CountInt uint64 `protobuf:"varint,1,opt,name=count_int,json=countInt,proto3,oneof"`
}

type histogram_CountFloat struct {
	CountFloat float64 `protobuf:"fixed64,2,opt,name=count_float,json=countFloat,proto3,oneof"`
}

func (*histogram_CountInt) isHistogram_Count() {}

func (*histogram_CountFloat) isHistogram_Count() {}

type isHistogram_ZeroCount interface {
	isHistogram_ZeroCount()
}

type histogram_ZeroCountInt struct {
	ZeroCountInt uint64 `protobuf:"varint,6,opt,name=zero_count_int,json=zeroCountInt,proto3,oneof"`
}

type histogram_ZeroCountFloat struct {
	ZeroCountFloat float64 `protobuf:"fixed64,7,opt,name=zero_count_float,json=zeroCountFloat,proto3,oneof"`
}

func (*histogram_ZeroCountInt) isHistogram_ZeroCount() {}

func (*histogram_ZeroCountFloat) isHistogram_ZeroCount() {}

// A BucketSpan defines a number of consecutive buckets with their
// offset. Logically, it would be more straightforward to include the
// bucket counts in the Span. However, the protobuf representation is
// more compact in the way the data is structured here (with all the
// buckets in a single array separate from the Spans).
type BucketSpan struct {
	state             protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Offset int32                  `protobuf:"zigzag32,1,opt,name=offset,proto3"`
	xxx_hidden_Length uint32                 `protobuf:"varint,2,opt,name=length,proto3"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *BucketSpan) Reset() {
	*x = BucketSpan{}
	mi := &file_io_prometheus_write_v2_types_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BucketSpan) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BucketSpan) ProtoMessage() {}

func (x *BucketSpan) ProtoReflect() protoreflect.Message {
	mi := &file_io_prometheus_write_v2_types_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *BucketSpan) GetOffset() int32 {
	if x != nil {
		return x.xxx_hidden_Offset
	}
	return 0
}

func (x *BucketSpan) GetLength() uint32 {
	if x != nil {
		return x.xxx_hidden_Length
	}
	return 0
}

func (x *BucketSpan) SetOffset(v int32) {
	x.xxx_hidden_Offset = v
}

func (x *BucketSpan) SetLength(v uint32) {
	x.xxx_hidden_Length = v
}

type BucketSpan_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Offset int32
	Length uint32
}

func (b0 BucketSpan_builder) Build() *BucketSpan {
	m0 := &BucketSpan{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Offset = b.Offset
	x.xxx_hidden_Length = b.Length
	return m0
}

var File_io_prometheus_write_v2_types_proto protoreflect.FileDescriptor

const file_io_prometheus_write_v2_types_proto_rawDesc = "" +
	"\n" +
	"\"io/prometheus/write/v2/types.proto\x12\x16io.prometheus.write.v2\x1a\x14gogoproto/gogo.proto\"s\n" +
	"\aRequest\x12\x18\n" +
	"\asymbols\x18\x04 \x03(\tR\asymbols\x12H\n" +
	"\n" +
	"timeseries\x18\x05 \x03(\v2\".io.prometheus.write.v2.TimeSeriesB\x04\xc8\xde\x1f\x00R\n" +
	"timeseriesJ\x04\b\x01\x10\x04\"\xc6\x02\n" +
	"\n" +
	"TimeSeries\x12\x1f\n" +
	"\vlabels_refs\x18\x01 \x03(\rR\n" +
	"labelsRefs\x12>\n" +
	"\asamples\x18\x02 \x03(\v2\x1e.io.prometheus.write.v2.SampleB\x04\xc8\xde\x1f\x00R\asamples\x12G\n" +
	"\n" +
	"histograms\x18\x03 \x03(\v2!.io.prometheus.write.v2.HistogramB\x04\xc8\xde\x1f\x00R\n" +
	"histograms\x12D\n" +
	"\texemplars\x18\x04 \x03(\v2 .io.prometheus.write.v2.ExemplarB\x04\xc8\xde\x1f\x00R\texemplars\x12B\n" +
	"\bmetadata\x18\x05 \x01(\v2 .io.prometheus.write.v2.MetadataB\x04\xc8\xde\x1f\x00R\bmetadataJ\x04\b\x06\x10\a\"_\n" +
	"\bExemplar\x12\x1f\n" +
	"\vlabels_refs\x18\x01 \x03(\rR\n" +
	"labelsRefs\x12\x14\n" +
	"\x05value\x18\x02 \x01(\x01R\x05value\x12\x1c\n" +
	"\ttimestamp\x18\x03 \x01(\x03R\ttimestamp\"e\n" +
	"\x06Sample\x12\x14\n" +
	"\x05value\x18\x01 \x01(\x01R\x05value\x12\x1c\n" +
	"\ttimestamp\x18\x02 \x01(\x03R\ttimestamp\x12'\n" +
	"\x0fstart_timestamp\x18\x03 \x01(\x03R\x0estartTimestamp\"\xe1\x02\n" +
	"\bMetadata\x12?\n" +
	"\x04type\x18\x01 \x01(\x0e2+.io.prometheus.write.v2.Metadata.MetricTypeR\x04type\x12\x19\n" +
	"\bhelp_ref\x18\x03 \x01(\rR\ahelpRef\x12\x19\n" +
	"\bunit_ref\x18\x04 \x01(\rR\aunitRef\"\xdd\x01\n" +
	"\n" +
	"MetricType\x12\x1b\n" +
	"\x17METRIC_TYPE_UNSPECIFIED\x10\x00\x12\x17\n" +
	"\x13METRIC_TYPE_COUNTER\x10\x01\x12\x15\n" +
	"\x11METRIC_TYPE_GAUGE\x10\x02\x12\x19\n" +
	"\x15METRIC_TYPE_HISTOGRAM\x10\x03\x12\x1e\n" +
	"\x1aMETRIC_TYPE_GAUGEHISTOGRAM\x10\x04\x12\x17\n" +
	"\x13METRIC_TYPE_SUMMARY\x10\x05\x12\x14\n" +
	"\x10METRIC_TYPE_INFO\x10\x06\x12\x18\n" +
	"\x14METRIC_TYPE_STATESET\x10\a\"\xed\x06\n" +
	"\tHistogram\x12\x1d\n" +
	"\tcount_int\x18\x01 \x01(\x04H\x00R\bcountInt\x12!\n" +
	"\vcount_float\x18\x02 \x01(\x01H\x00R\n" +
	"countFloat\x12\x10\n" +
	"\x03sum\x18\x03 \x01(\x01R\x03sum\x12\x16\n" +
	"\x06schema\x18\x04 \x01(\x11R\x06schema\x12%\n" +
	"\x0ezero_threshold\x18\x05 \x01(\x01R\rzeroThreshold\x12&\n" +
	"\x0ezero_count_int\x18\x06 \x01(\x04H\x01R\fzeroCountInt\x12*\n" +
	"\x10zero_count_float\x18\a \x01(\x01H\x01R\x0ezeroCountFloat\x12O\n" +
	"\x0enegative_spans\x18\b \x03(\v2\".io.prometheus.write.v2.BucketSpanB\x04\xc8\xde\x1f\x00R\rnegativeSpans\x12'\n" +
	"\x0fnegative_deltas\x18\t \x03(\x12R\x0enegativeDeltas\x12'\n" +
	"\x0fnegative_counts\x18\n" +
	" \x03(\x01R\x0enegativeCounts\x12O\n" +
	"\x0epositive_spans\x18\v \x03(\v2\".io.prometheus.write.v2.BucketSpanB\x04\xc8\xde\x1f\x00R\rpositiveSpans\x12'\n" +
	"\x0fpositive_deltas\x18\f \x03(\x12R\x0epositiveDeltas\x12'\n" +
	"\x0fpositive_counts\x18\r \x03(\x01R\x0epositiveCounts\x12J\n" +
	"\n" +
	"reset_hint\x18\x0e \x01(\x0e2+.io.prometheus.write.v2.Histogram.ResetHintR\tresetHint\x12\x1c\n" +
	"\ttimestamp\x18\x0f \x01(\x03R\ttimestamp\x12#\n" +
	"\rcustom_values\x18\x10 \x03(\x01R\fcustomValues\x12'\n" +
	"\x0fstart_timestamp\x18\x11 \x01(\x03R\x0estartTimestamp\"d\n" +
	"\tResetHint\x12\x1a\n" +
	"\x16RESET_HINT_UNSPECIFIED\x10\x00\x12\x12\n" +
	"\x0eRESET_HINT_YES\x10\x01\x12\x11\n" +
	"\rRESET_HINT_NO\x10\x02\x12\x14\n" +
	"\x10RESET_HINT_GAUGE\x10\x03B\a\n" +
	"\x05countB\f\n" +
	"\n" +
	"zero_count\"<\n" +
	"\n" +
	"BucketSpan\x12\x16\n" +
	"\x06offset\x18\x01 \x01(\x11R\x06offset\x12\x16\n" +
	"\x06length\x18\x02 \x01(\rR\x06lengthBZZXbuf.build/gen/go/prometheus/prometheus/protocolbuffers/go/io/prometheus/write/v2;writev2b\x06proto3"

var file_io_prometheus_write_v2_types_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_io_prometheus_write_v2_types_proto_msgTypes = make([]protoimpl.MessageInfo, 7)
var file_io_prometheus_write_v2_types_proto_goTypes = []any{
	(Metadata_MetricType)(0), // 0: io.prometheus.write.v2.Metadata.MetricType
	(Histogram_ResetHint)(0), // 1: io.prometheus.write.v2.Histogram.ResetHint
	(*Request)(nil),          // 2: io.prometheus.write.v2.Request
	(*TimeSeries)(nil),       // 3: io.prometheus.write.v2.TimeSeries
	(*Exemplar)(nil),         // 4: io.prometheus.write.v2.Exemplar
	(*Sample)(nil),           // 5: io.prometheus.write.v2.Sample
	(*Metadata)(nil),         // 6: io.prometheus.write.v2.Metadata
	(*Histogram)(nil),        // 7: io.prometheus.write.v2.Histogram
	(*BucketSpan)(nil),       // 8: io.prometheus.write.v2.BucketSpan
}
var file_io_prometheus_write_v2_types_proto_depIdxs = []int32{
	3, // 0: io.prometheus.write.v2.Request.timeseries:type_name -> io.prometheus.write.v2.TimeSeries
	5, // 1: io.prometheus.write.v2.TimeSeries.samples:type_name -> io.prometheus.write.v2.Sample
	7, // 2: io.prometheus.write.v2.TimeSeries.histograms:type_name -> io.prometheus.write.v2.Histogram
	4, // 3: io.prometheus.write.v2.TimeSeries.exemplars:type_name -> io.prometheus.write.v2.Exemplar
	6, // 4: io.prometheus.write.v2.TimeSeries.metadata:type_name -> io.prometheus.write.v2.Metadata
	0, // 5: io.prometheus.write.v2.Metadata.type:type_name -> io.prometheus.write.v2.Metadata.MetricType
	8, // 6: io.prometheus.write.v2.Histogram.negative_spans:type_name -> io.prometheus.write.v2.BucketSpan
	8, // 7: io.prometheus.write.v2.Histogram.positive_spans:type_name -> io.prometheus.write.v2.BucketSpan
	1, // 8: io.prometheus.write.v2.Histogram.reset_hint:type_name -> io.prometheus.write.v2.Histogram.ResetHint
	9, // [9:9] is the sub-list for method output_type
	9, // [9:9] is the sub-list for method input_type
	9, // [9:9] is the sub-list for extension type_name
	9, // [9:9] is the sub-list for extension extendee
	0, // [0:9] is the sub-list for field type_name
}

func init() { file_io_prometheus_write_v2_types_proto_init() }
func file_io_prometheus_write_v2_types_proto_init() {
	if File_io_prometheus_write_v2_types_proto != nil {
		return
	}
	file_io_prometheus_write_v2_types_proto_msgTypes[5].OneofWrappers = []any{
		(*histogram_CountInt)(nil),
		(*histogram_CountFloat)(nil),
		(*histogram_ZeroCountInt)(nil),
		(*histogram_ZeroCountFloat)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_io_prometheus_write_v2_types_proto_rawDesc), len(file_io_prometheus_write_v2_types_proto_rawDesc)),
			NumEnums:      2,
			NumMessages:   7,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_io_prometheus_write_v2_types_proto_goTypes,
		DependencyIndexes: file_io_prometheus_write_v2_types_proto_depIdxs,
		EnumInfos:         file_io_prometheus_write_v2_types_proto_enumTypes,
		MessageInfos:      file_io_prometheus_write_v2_types_proto_msgTypes,
	}.Build()
	File_io_prometheus_write_v2_types_proto = out.File
	file_io_prometheus_write_v2_types_proto_goTypes = nil
	file_io_prometheus_write_v2_types_proto_depIdxs = nil
}
