#include <errno.h>
#include <string.h>
#include "outbuf.h"
#include "byte.h"

static num allwrite(num (*op)(num,const char *,num),num fd,const char *buf,num len)
{
  num w;

  while (len) {
    w = op(fd,buf,len);
    if (w == -1) {
      if (errno == EINTR) continue;
      return -1; /* note that some data may have been written */
    }
    if (w == 0)
      ;
    buf += w;
    len -= w;
  }
  return 0;
}

num outbuf_flush(outbuf *s)
{
  num p;
 
  p = s->p;
  if (!p) return 0;
  s->p = 0;
  return allwrite(s->op,s->fd,s->x,p);
}

num outbuf_putalign(outbuf *s,const char *buf,num len)
{
  num n;
 
  while (len > (n = s->n - s->p)) {
    byte_copy(s->x + s->p,n,buf); s->p += n; buf += n; len -= n;
    if (outbuf_flush(s) == -1) return -1;
  }
  /* now len <= s->n - s->p */
  byte_copy(s->x + s->p,len,buf);
  s->p += len;
  return 0;
}

num outbuf_put(outbuf *s,const char *buf,num len)
{
  num n;
 
  n = s->n;
  if (len > n - s->p) {
    if (outbuf_flush(s) == -1) return -1;
    /* now s->p == 0 */
    if (n < OUTBUF_SIZE) n = OUTBUF_SIZE;
    while (len > s->n) {
      if (n > len) n = len;
      if (allwrite(s->op,s->fd,buf,n) == -1) return -1;
      buf += n;
      len -= n;
    }
  }
  /* now len <= s->n - s->p */
  byte_copy(s->x + s->p,len,buf);
  s->p += len;
  return 0;
}

num outbuf_putflush(outbuf *s,const char *buf,num len)
{
  if (outbuf_flush(s) == -1) return -1;
  return allwrite(s->op,s->fd,buf,len);
}

num outbuf_putsalign(outbuf *s,const char *buf)
{
  return outbuf_putalign(s,buf,strlen(buf));
}

num outbuf_puts(outbuf *s,const char *buf)
{
  return outbuf_put(s,buf,strlen(buf));
}

num outbuf_putsflush(outbuf *s,const char *buf)
{
  return outbuf_putflush(s,buf,strlen(buf));
}
