/*** DTB_USER_CODE_START vvv Add file header below vvv ***/
/*
 * CDE - Common Desktop Environment
 *
 * Copyright (c) 1993-2012, The Open Group. All rights reserved.
 *
 * These libraries and programs are free software; you can
 * redistribute them and/or modify them under the terms of the GNU
 * Lesser General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * These libraries and programs are distributed in the hope that
 * they will be useful, but WITHOUT ANY WARRANTY; without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with these libraries and programs; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301 USA
 */
/*** DTB_USER_CODE_END   ^^^ Add file header above ^^^ ***/

/*
 * File: panedwin_ed_stubs.c
 * Contains: Module callbacks and connection functions
 *
 * This file was generated by dtcodegen, from module panedwin_ed
 *
 * Any text may be added between the DTB_USER_CODE_START and
 * DTB_USER_CODE_END comments (even non-C code). Descriptive comments
 * are provided only as an aid.
 *
 *  ** EDIT ONLY WITHIN SECTIONS MARKED WITH DTB_USER_CODE COMMENTS.  **
 *  ** ALL OTHER MODIFICATIONS WILL BE OVERWRITTEN. DO NOT MODIFY OR  **
 *  ** DELETE THE GENERATED COMMENTS!                                 **
 */

#include <stdint.h>
#include <stdio.h>
#include <Xm/Xm.h>
#include "dtb_utils.h"
#include "dtbuilder.h"
#include "panedwin_ed_ui.h"


/**************************************************************************
 *** DTB_USER_CODE_START
 ***
 *** All necessary header files have been included.
 ***
 *** Add include files, types, macros, externs, and user functions here.
 ***/

#include <Xm/List.h>
#include <ab_private/ab.h>
#include <ab_private/prop.h>
#include <ab_private/proj.h>
#include <ab_private/abobj.h>
#include <ab_private/abobj_set.h>
#include <ab_private/abobj_list.h>
#include <ab_private/ui_util.h>
#include <ab_private/obj_notify.h>
#include <ab_private/objxm.h>
#include "dtb_utils.h"
#include "dtbuilder.h"
#include "panedwin_ed_ui.h"

typedef struct  PANEDWIN_EDITOR_SETTINGS
{
    Widget                      prop_sheet;
    PropFieldSettingRec         name;
    PropGeometrySettingRec      geometry;
    PropGeometrySettingRec      min_max_geo;
    ABObj                       current_pw_obj;
    ABObj                       current_pane_obj;
} PanedWinEditorSettingsRec, *PanedWinEditorSettings;

/*
 * Declarations of global widgets used by callbacks.
 */
ABObj		current_pw_child = NULL;
/*
 * End declarations of global widgets
 */

/*************************************************************************
**                                                                      **
**       Private Function Declarations                                  **
**                                                                      **
**************************************************************************/

static Widget	panedwin_editor_init(
                    DtbPanedwinEdDialogInfo	pw_cgen,
		    Widget			parent
                );
static int	panedwin_editor_load(
		    ABObj	project
                );
static int	panedwin_editor_clear();
static int 	panedwin_editor_clear_geom();

static int	panedwin_editor_activate(
		    BOOL 	 active
		);
static int	panedwin_editor_apply();
static BOOL     panedwin_editor_pending();
static void 	panedwinEdP_init();
static void     pw_objlist_load(
                   Widget      list
                );
static BOOL     pw_objlist_test_func(
                    ABObj test_obj
                );
static BOOL 	pw_child_test_func(
		    ABObj test_obj
		);
static BOOL	verify_editor();
static void	turnoff_changebars();

/*
 * Callbacks
 */
static int 	pw_obj_reparentedOCB(
		    ObjEvReparentInfo	info
		);
static int      pw_obj_updateOCB(
                    ObjEvUpdateInfo     info
                );
static int      pw_obj_destroyedOCB(
                    ObjEvDestroyInfo    info
                );
static int      pw_obj_renamedOCB(
                    ObjEvAttChangeInfo	info
                );
static void     pw_objlist_selectCB(
                    Widget      	widget,
                    XtPointer   	client_data,
                    XmListCallbackStruct *listdata
                );
static void 	pw_panelist_selectCB(
		    Widget      	widget,
		    XtPointer   	client_data,
		    XmListCallbackStruct *listdata
		);

/*************************************************************************
**                                                                      **
**       Data 		                                                **
**                                                                      **
**************************************************************************/

PanedWinEditorSettingsRec    pw_editor_settings_rec;

/*************************************************************************
**                                                                      **
**       Function Definitions                                           **
**                                                                      **
**************************************************************************/
 
void
panedwin_ed_show_dialog(
)
{
    /* If there is no Message Editor, create it */
    if (AB_panedWinEd_dialog == (Widget)NULL)
    {
        /* Create and manage the Paned Window Editor */
        AB_panedWinEd_dialog = 
		panedwin_editor_init(&dtb_panedwin_ed_dialog, AB_toplevel);

	/* Hack to make panes list have nice layout */
	XtVaSetValues(XtParent(dtb_panedwin_ed_dialog.panelist_scrolledwin), 
		XmNrightAttachment,	XmATTACH_FORM,
		XmNrightOffset,		100,
		NULL);

	/* Add Update, Rename, and Destroy object callbacks */
        panedwinEdP_init();

        /* Load in the panedWindow object list */
        pw_objlist_load(dtb_panedwin_ed_dialog.objlist);

	/* Add Callback to load panedWin object when selected from list */
	XtAddCallback(dtb_panedwin_ed_dialog.objlist, 
		XmNbrowseSelectionCallback,
		(XtCallbackProc)pw_objlist_selectCB, (XtPointer)NULL);

	/* Add Callback to load panes when a paned window obj is
	 * selected from list. */
	XtAddCallback(dtb_panedwin_ed_dialog.panelist, 
		XmNbrowseSelectionCallback,
		(XtCallbackProc)pw_panelist_selectCB, (XtPointer)NULL);

        /*
         * Setup dialog to participate in dtbuilder window protocol
         */
        ab_register_window(AB_panedWinEd_dialog, AB_WIN_DIALOG, 
		WindowHidden, AB_toplevel, AB_WPOS_TILE_HORIZONTAL,
		NULL, NULL);
    }

    if (AB_panedWinEd_dialog != NULL)
        XtManageChild(AB_panedWinEd_dialog);
}

static Widget
panedwin_editor_init(
    DtbPanedwinEdDialogInfo	pw_cgen,
    Widget			parent
)
{
    PanedWinEditorSettingsRec   *pws = &pw_editor_settings_rec;

    /*                                
     * Create Dialog widgets...
     */
    dtbPanedwinEdDialogInfo_clear(pw_cgen);

    if (dtb_panedwin_ed_dialog_initialize(pw_cgen, parent) == 0)
    {
	pws->prop_sheet = pw_cgen->attrs_ctrlpanel;
        pws->current_pw_obj = NULL;
        pws->current_pane_obj = NULL;

	/* Name Field */
	prop_field_init(&(pws->name), pw_cgen->name_field_label,
			    pw_cgen->name_field, pw_cgen->name_cb);

	/* Pane Geometry Setting */
        prop_geomfield_init(&(pws->geometry), pw_cgen->geo_label,
                            NULL, NULL, NULL, NULL,
                            pw_cgen->width_field_label, pw_cgen->width_field,
                            pw_cgen->height_field_label, pw_cgen->height_field,
                            pw_cgen->geo_cb);

	ui_set_active(pw_cgen->width_field_label, False);
	ui_set_active(pw_cgen->width_field, False);
	ui_set_active(pw_cgen->height_field_label, False);
	ui_set_active(pw_cgen->height_field, False);

	/* REMIND: Make geometry textfields read-only for now */
	XtVaSetValues(pw_cgen->width_field, XmNeditable, False, NULL);
	XtVaSetValues(pw_cgen->height_field, XmNeditable, False, NULL);

        /* Pane Minimum/Maximum Setting */
        prop_geomfield_init(&(pws->min_max_geo), pw_cgen->pane_height_lbl, 
		NULL, NULL, NULL, NULL,
		pw_cgen->min_height_field_label, pw_cgen->min_height_field,
		pw_cgen->max_height_field_label, pw_cgen->max_height_field,
		pw_cgen->height_cb); 

	ui_set_active(pw_cgen->min_height_field_label, False);
	ui_set_active(pw_cgen->min_height_field, False);
	ui_set_active(pw_cgen->max_height_field_label, False);
	ui_set_active(pw_cgen->max_height_field, False);

	prop_changebars_cleared(pws->prop_sheet);

	return (pw_cgen->dialog_shellform);
    }
    else
	return NULL;

}  

static int
panedwin_editor_activate(
    BOOL	 active
)
{
    ui_set_active(pw_editor_settings_rec.prop_sheet, active);
    return OK;
}


static int
panedwin_editor_clear(
)
{
    PanedWinEditorSettingsRec   *pws = &pw_editor_settings_rec;

    /* Clear Name Field */
    prop_field_set_value(&(pws->name), "", False);

    /* Clear pane information */
    panedwin_editor_clear_geom();
 
    pws->current_pw_obj = NULL;
    pws->current_pane_obj = NULL;

    turnoff_changebars();

    return OK;
}

static int
panedwin_editor_clear_geom(
)
{
    PanedWinEditorSettingsRec   *pws = &pw_editor_settings_rec;

    /* Clear Pane Geometry Setting */
    prop_geomfield_clear(&(pws->geometry), GEOM_WIDTH);
    prop_geomfield_clear(&(pws->geometry), GEOM_HEIGHT);

    /* Clear Pane Minimum/Maximum Setting */
    prop_geomfield_clear(&(pws->min_max_geo), GEOM_WIDTH);
    prop_geomfield_clear(&(pws->min_max_geo), GEOM_HEIGHT);

    return OK;
}

/* This routine is called when a paned window child is
 * selected in the "Panes" list in the Paned Window
 * Editor.  It loads in the pane geometry and its min/max
 * height values.
 */
static int
panedwin_editor_load(
    ABObj    obj
)
{
    PanedWinEditorSettingsRec   *pws = &pw_editor_settings_rec;
    int				width = 0, height = 0;
 
    if (obj == NULL)
    {
        if (pws->current_pane_obj != NULL)
            obj = pws->current_pane_obj;
        else
            return ERROR;
    }
    else if (!obj_is_pane(obj) && !obj_is_layers(obj))
        return ERROR;
    else
        pws->current_pane_obj = obj;

    /* Pane Geometry Setting */
    width = abobj_get_actual_width(obj);
    height = abobj_get_actual_height(obj);
    prop_geomfield_set_value(&(pws->geometry), GEOM_WIDTH, width, False);
    prop_geomfield_set_value(&(pws->geometry), GEOM_HEIGHT, height, False);

    /* Pane Minimum/Maximum Setting */
    prop_geomfield_set_value(&(pws->min_max_geo), GEOM_WIDTH, 
			obj_get_pane_min(obj),False);
    prop_geomfield_set_value(&(pws->min_max_geo), GEOM_HEIGHT, 
			obj_get_pane_max(obj),False);

    turnoff_changebars();

    return OK;
}

/* This routine is called when the "Apply" button is
 * pressed.  It sets all the values of attributes that
 * have changed to their new values.
 */
int
panedwin_editor_apply(
)
{
    PanedWinEditorSettingsRec   *pws = &pw_editor_settings_rec;
    STRING			value;
    int				geom;

    if (!verify_editor())
        return ERROR;

    if (prop_changed(pws->name.changebar))
    {
        value = prop_field_get_value(&(pws->name));   
        abobj_set_name(pws->current_pw_obj, value);
        util_free(value);
    }
    if (prop_changed(pws->geometry.changebar))
    {
    }
    if (prop_changed(pws->min_max_geo.changebar))
    {
	geom = prop_geomfield_get_value(&(pws->min_max_geo), GEOM_WIDTH);
	abobj_set_pane_min(pws->current_pane_obj, geom);
	geom = prop_geomfield_get_value(&(pws->min_max_geo), GEOM_HEIGHT);
	abobj_set_pane_max(pws->current_pane_obj, geom);
    }

    if (pws->current_pw_obj != NULL)
	abobj_instantiate_changes(pws->current_pw_obj);

    if (pws->current_pane_obj != NULL)
	abobj_instantiate_changes(pws->current_pane_obj);

    turnoff_changebars();

    return OK;
}

static BOOL
panedwin_editor_pending(
)
{
    return(prop_changebars_pending(pw_editor_settings_rec.prop_sheet));
}

static BOOL
verify_editor(
)
{
    PanedWinEditorSettingsRec   *pws = &pw_editor_settings_rec;

    if (prop_changed(pws->name.changebar) && 
	!prop_name_ok(pws->current_pw_obj, pws->name.field))
        return False;
    else 
	return True;
}

static void
turnoff_changebars(
)
{
    PanedWinEditorSettingsRec   *pws = &pw_editor_settings_rec;

    prop_set_changebar(pws->name.changebar,    		PROP_CB_OFF);
    prop_set_changebar(pws->geometry.changebar,		PROP_CB_OFF);
    prop_set_changebar(pws->min_max_geo.changebar,  	PROP_CB_OFF);

    prop_changebars_cleared(pws->prop_sheet);
}

/* This routine is called when an item is selected from the
 * Paned Window Objects list in the Paned Window Editor.
 */
static void
pw_objlist_selectCB(
    Widget      widget,
    XtPointer   client_data,
    XmListCallbackStruct *listdata
)
{
    ABObj               module = NULL;
    ABObj               selected_obj = NULL;
    STRING              name = NULL;
    Widget		panelist = dtb_panedwin_ed_dialog.panelist;
    PanedWinEditorSettingsRec   *pws = &pw_editor_settings_rec;

    name = objxm_xmstr_to_str(listdata->item);
    if (name)
    {
        abobj_moduled_name_extract(name, &module, &selected_obj);
        util_free(name);

        if (selected_obj)
        {
            /* An Object is loaded with pending changes...*/
	    /* REMIND: Need to add code to deal with pending changes.*/
	
	    /* Clear out the panes list first */
	    XmListDeleteAllItems(panelist);
        
	    /* Populate the panes list in the editor */
	    abobj_list_update(panelist, selected_obj, pw_child_test_func);
	    XtVaSetValues(panelist, XmNuserData, module, NULL);

	    /* Load  Name of paned window object */
	    prop_field_set_value(&(pws->name), 
			obj_get_name(selected_obj), False);

	    /* Set the current paned window object */
	    pws->current_pw_obj = selected_obj;
        }
    }
}

static void
pw_panelist_selectCB(
    Widget      widget,
    XtPointer   client_data,
    XmListCallbackStruct *listdata
)
{
    ABObj               module = NULL;
    ABObj               selected_obj = NULL;
    STRING              name = NULL;

    name = objxm_xmstr_to_str(listdata->item);
    if (name)
    {
	XtVaGetValues(widget, XmNuserData, &module, NULL);
	if (module != NULL)
	{
            ui_set_active(dtb_panedwin_ed_dialog.width_field_label, True);
            ui_set_active(dtb_panedwin_ed_dialog.width_field, True);
            ui_set_active(dtb_panedwin_ed_dialog.height_field_label, True);
            ui_set_active(dtb_panedwin_ed_dialog.height_field, True);
	    ui_set_active(dtb_panedwin_ed_dialog.min_height_field_label, True);
            ui_set_active(dtb_panedwin_ed_dialog.min_height_field, True);
	    ui_set_active(dtb_panedwin_ed_dialog.max_height_field_label, True);
            ui_set_active(dtb_panedwin_ed_dialog.max_height_field, True);

	    selected_obj = obj_scoped_find_by_name(module, name);
	    panedwin_editor_load(selected_obj);
	    current_pw_child = selected_obj;
	}
	util_free(name);
    }
}

/*
 * Traverse the project and load all panedWindow objects.
 */
static void
pw_objlist_load(
   Widget      list
)
{
    ABObj           proj = proj_get_project();
    int             num_items = 0;
 
    if (proj == NULL || list == NULL)
        return;
 
    num_items = abobj_list_load(list, proj, pw_objlist_test_func);
}

/*
 * Test whether an object should be loaded into the
 * Paned Window Editor object list.
 */
static BOOL
pw_objlist_test_func(
    ABObj test_obj
)
{
    ABObj       module = NULL;
 
    if ((module = obj_get_module(test_obj)) == NULL)
        return(False);
 
    if (obj_is_paned_win(test_obj) &&
        obj_has_flag(module, MappedFlag))
    {
        return(True);
    }
    else
        return(False);
}

/* Test whether the object is a module and if so test
 * if it is mapped (showing).
 */
static BOOL
module_test_func(
    ABObj test_obj
)
{
    if (!obj_is_module(test_obj))
        return(False);

    if (obj_has_flag(test_obj, MappedFlag))
    {
        return(True);
    }
    else
        return(False);
}

/*
 * Test whether an object should be loaded into the
 * list of panes in the Paned Window Editor.
 */
static BOOL
pw_child_test_func(
    ABObj test_obj
)
{
    ABObj       module = NULL;
    ABObj	parent = NULL;

    if ((module = obj_get_module(test_obj)) == NULL)
        return(False);

    parent = obj_get_parent(test_obj);
    if ( (obj_is_pane(test_obj) || obj_is_layers(test_obj))
	&& obj_is_paned_win(parent) && obj_has_flag(module, MappedFlag))
    {
        return(True);
    }
    else
        return(False);
}

/*
 * obj-callback: Called when a new project is opened or
 *               when a new module is created or imported
 *               or when an existing module is shown or hidden.
 */
static int
pw_obj_updateOCB(
    ObjEvUpdateInfo     info
)
{
    Widget	list = dtb_panedwin_ed_dialog.objlist;
    int		ret = 0;

    if (AB_panedWinEd_dialog != NULL)
    {
        if (!obj_is_project(info->obj) && !obj_is_module(info->obj)
	    && !obj_is_paned_win(info->obj))
            return 0;

        /* Populate the Paned Window Editor list */
	ret = abobj_list_obj_updated(list, info, pw_objlist_test_func);
    }
    return (ret);
}

/*
 * obj-callback: object is being destroyed - remove from Paned
 *		 Window Editor object list.
 */
static int
pw_obj_destroyedOCB(
    ObjEvDestroyInfo    info
)
{
    Widget      list = dtb_panedwin_ed_dialog.objlist;
    Widget	panelist = dtb_panedwin_ed_dialog.panelist;
    ABObj	parent = NULL;
    STRING	name = NULL;
    XmStringTable sel_item = NULL;
    int         ret = 0;
                     
    if (AB_panedWinEd_dialog != NULL)
    {
        if (!obj_is_project(info->obj) && !obj_is_paned_win(info->obj)
	    && !obj_is_pane(info->obj) && !obj_is_layers(info->obj))
            return 0;
 
        if (obj_is_project(info->obj))
        {
            /* Clear the Paned Window Editor and make it inactive */
            panedwin_editor_clear();

            ui_set_active(dtb_panedwin_ed_dialog.width_field_label, False);
	    ui_set_active(dtb_panedwin_ed_dialog.width_field, False);
            ui_set_active(dtb_panedwin_ed_dialog.height_field_label, False);
            ui_set_active(dtb_panedwin_ed_dialog.height_field, False);

            ui_set_active(dtb_panedwin_ed_dialog.min_height_field_label,False);
            ui_set_active(dtb_panedwin_ed_dialog.min_height_field, False);
            ui_set_active(dtb_panedwin_ed_dialog.max_height_field_label,False);
            ui_set_active(dtb_panedwin_ed_dialog.max_height_field, False);
        }
        else if (obj_is_paned_win(info->obj))
        {
	    /* Clear out the paned window editor if the paned window
	     * being destroyed is the one which is currently loaded.
	     */
	    XtVaGetValues(list, XmNselectedItems, &sel_item, NULL);
	    if (sel_item != NULL)
	    {
		name = abobj_get_moduled_name(info->obj);
		if (strcmp(name, objxm_xmstr_to_str(sel_item[0])) == 0)
		    panedwin_editor_clear();
	    }
	    ret = abobj_list_obj_destroyed(list, info->obj, 
				pw_objlist_test_func);
        }
	else /* Object is a pane OR a layer */
	{
	    parent = obj_get_parent(info->obj);
	    if ( ((parent = obj_get_parent(info->obj)) != NULL) &&
		obj_is_paned_win(parent))
	    {
		XtVaGetValues(panelist, XmNselectedItems, &sel_item, NULL);
		if (sel_item != NULL)
		{
                    name = abobj_get_moduled_name(info->obj);
                    if (strcmp(name, objxm_xmstr_to_str(sel_item[0])) == 0)
			panedwin_editor_clear_geom();
		}
		ret = abobj_list_obj_destroyed(panelist, info->obj, 
				pw_child_test_func);
	    }
	}
    }
    return (ret);
}

static int
pw_obj_renamedOCB(
    ObjEvAttChangeInfo    info
)
{
    Widget      list = dtb_panedwin_ed_dialog.objlist;
    Widget      panelist = dtb_panedwin_ed_dialog.panelist;
    ABObj       parent = NULL,
                sel_module = NULL,
                selected_obj = NULL;
    XmStringTable sel_item = NULL;
    STRING	mod_name = NULL;
    int         ret = 0;

    if (!obj_is_module(info->obj) && !obj_is_paned_win(info->obj)
	&& !obj_is_pane(info->obj) && !obj_is_layers(info->obj))
	return 0;

    if (AB_panedWinEd_dialog != NULL)
    {
	if (obj_is_module(info->obj))
	{
	    mod_name = obj_get_name(info->obj);
	    if (mod_name == NULL)
		return -1;
     
	    if (info->old_name != NULL)
	    {
		/* Change the module prefix in the objlist */
		abobj_list_obj_renamed(list, info->obj, 
			istr_string(info->old_name), module_test_func);

		/* Change the module prefix in the panes list */
		abobj_list_obj_renamed(panelist, info->obj, 
			istr_string(info->old_name), module_test_func);
	    }
	}
        else if (obj_is_paned_win(info->obj))
        {
            /* Check if the panedWindow obj is being created.
             * If not, then simply replace the old name with
             * the new name.  Otherwise let the pw_obj_updateOCB
             * handle adding a newly created panedWindow object.
             */
            if (info->old_name != NULL)
            {  
                ret = abobj_list_obj_renamed(list, info->obj,
                        istr_string(info->old_name), pw_objlist_test_func);
            }
        }
	else	/* obj is a pane OR a layer */
	{
	    if (info->old_name == NULL)
	    {
		/* This is a new pane dropped on an existing
		 * paned window object OR this is a new layer
		 * being created.  To make sure, check the 
		 * obj's parent.
		 */  
		parent = obj_get_parent(info->obj);
		if ( (parent != NULL) && obj_is_paned_win(parent) )
		{
		    XtVaGetValues(list, XmNselectedItems, &sel_item, NULL);
		    if (sel_item != NULL)
		    {
			abobj_moduled_name_extract(
				objxm_xmstr_to_str(sel_item[0]),
                                 &sel_module, &selected_obj);
			if (selected_obj == parent)
			    ret = abobj_list_update(panelist, parent,
					pw_child_test_func);
		    }
		}
	    }
	    /* The pane's name has changed */
	    else
		ret = abobj_list_obj_renamed(panelist, info->obj,
                        istr_string(info->old_name), pw_child_test_func);
	}
    }
    return (ret);
}

/* This callback gets called when a pane child is being
 * parented to a different object, as when "Unmake Paned
 * Window" or "Make Paned Window" is chosen from the popup 
 * menu.
 */
static int
pw_obj_reparentedOCB(
    ObjEvReparentInfo     info
)
{
    Widget      list = dtb_panedwin_ed_dialog.objlist;
    Widget	panelist = dtb_panedwin_ed_dialog.panelist;
    ABObj	parent = NULL,
		sel_module = NULL,
		selected_obj = NULL;
    XmStringTable sel_item = NULL;
    STRING	name = NULL;
    int		ret = 0;

    if (AB_panedWinEd_dialog != NULL)
    {
        if (!obj_is_pane(info->obj) && !obj_is_layers(info->obj))
            return 0;

	/* If the pane name is NULL, then that means it is a 
	 * new pane, one which was dragged from the palette 
	 * onto an existing paned window. In that case, let 
	 * the pw_obj_renamedOCB callback handle it (i.e. add 
	 * it to the pane list).
	 */
	parent = obj_get_parent(info->obj);
	if (obj_get_name(info->obj) != NULL)
	{
	    /* Either a new paned window obj was created (via
	     * the "Make Paned Window" popup menu OR a paned
	     * window obj is being destroyed (via the "Unmake
	     * Paned Window" popup menu) and therefore its
	     * children are being reparented to the paned window's
	     * parent.  If a new paned window was created, we don't
	     * need to update the panes list because that will happen
	     * when the new paned window obj is selected. 
	     */
	    if ((info->old_parent != NULL) && 
		obj_is_paned_win(info->old_parent))
	    {
		if (current_pw_child == info->obj)
		    panedwin_editor_clear_geom();
		ret = abobj_list_obj_reparented(panelist, info, 
				pw_child_test_func);
	    }
	}
    }
    return (ret);
}

static void
panedwinEdP_init()
{
    obj_add_reparent_callback(pw_obj_reparentedOCB, "panedwinEdP_init");
    obj_add_rename_callback(pw_obj_renamedOCB, "panedwinEdP_init");
    obj_add_update_callback(pw_obj_updateOCB, "panedwinEdP_init");
    obj_add_destroy_callback(pw_obj_destroyedOCB, "panedwinEdP_init");
}

/*** DTB_USER_CODE_END
 ***
 *** End of user code section
 ***
 **************************************************************************/




/**************************************************************************
 *** DTB_USER_CODE_START
 ***
 *** All automatically-generated data and functions have been defined.
 ***
 *** Add new functions here, or at the top of the file.
 ***/
/*** DTB_USER_CODE_END
 ***
 *** End of user code section
 ***
 **************************************************************************/


