.\" $XConsortium: dtcalc.man /main/2 1995/07/17 10:50:28 drk $
.TH DTCALC 1X "" "" "" ""
.ds ]W CDE 1.0 (2/94)
.na
.SH NAME
\fBdtcalc \(em The Common Desktop Environment Calculator.\fP
.sp 1
.SH SYNOPSIS
\fBdtcalc\fP
[-a accuracy] [-m mode] [-b numeric_base] [-notation display_notation]
[-trig trigonometric_type] [-session session_file] [-no_menu_bar]
.sp 1
.SH DESCRIPTION
The \fIDtcalc\fP program is a calculator for use within the Common 
Desktop Environment.  It provides an easy to use interface designed to
give access to common arithmetic and financial calculations.
.P
The calculator is designed to operate in much the same way as many 
hand-held calculators.  It provides three modes of operation: scientific,
financial, and logical.  The default operation is scientific, but with
the easy to use GUI changing to the modes of operation are easy.  When
the operation mode is changed, a number of the keys change for the new
operations.  
.P
.P
.P
.sp 1
.SH OPTIONS
\fIDtcalc\fP defines a number of command-line options which allow the user
to configure how the calculator displays itself.  Command-line options have a
higher precedence then resources.  By using command-line options
a user can override anything specified in a resource file. 
.IP "\fB-a \fP\fI<accuracy>\fP"
.br
This is the initial number of digits displayed after the numeric point.
This value must be in the range 0 to 9.  The default value is 2.
.IP "\fB-m \fP\fI<mode>\fP"
.br
This determines which mode the calculator will display itself in.  
There are three modes of operation: scientific, financial, or logical.
Some of the calculator keys change when it changes between different
modes.
.IP "\fB-b \fP\fI<numeric_base>\fP"
.br
This determines which numeric base the calculator will use when it does
calculations. There are four bases the calculator supports: binary (base 2), 
octal (base 8), decimal (base 10), or hexidecimal (base 16).  The default
is decimal.
.IP "\fB-notation \fP\fI<display_notation>\fP"
.br
This determines how the answers are to be display on the calculator.
There are three ways of displaying answers on the calculator: scientific,
engineering, and fixed.  The default is fixed. 
.IP "\fB-trig \fP\fI<trigonometric_type>\fP"
.br
This determines how answers are presented when the calculator is in 
scientific mode. There are three trigonometric ways to present the answers:
degrees, radians, or gradients.  The default is degrees.
.IP "\fB-no_menu_bar\fP"
.br
This option makes the calculator come up with no menubar.
.IP "\fB-session \fP\fI<session_file>\fP"
.br
This option takes the name of a session file as an additional parameter.
\fIDtcalc\fP is run with the specified session file name.  This session 
file is a file that was previously saved by \fIdtcalc\fP during a session
shutdown.
.sp 1
.SH RESOURCES
.P
The Calculator supports a number of resources which make it much more 
configurable. Following is the list of supported resources and their default 
values. 
.sp 2
.TS
center;
CB sss
lB lB lB lB
l l l l .
Client Resource Set
Name	Class	Type	Default
_
postMenuBar	PostMenuBar	Boolean	True
accuracy	accuracy	int	2
base	Base	string	decimal
display	Display	string	fixed
mode	Mode	string	scientific
trigType	TrigType	string	degrees
.TE
.ps
.sp 1
.IP "\fBDtcalc*postMenuBar:\fP"
Specifies wheither the menu bar should appear or not.
.IP "\fBDtcalc*accuracy:\fP"
Specifies wheither the menu bar should appear or not.
.IP "\fBDtcalc*base:\fP"
This resource allows the user to change the default for the numeric base
the calculator uses when it does its calculations.  The default is "decimal" 
which is base 10.  Possible values are:
.br
.sp 1
\fBbinary (or bin):\fP do calculations in base 2.
.br
.sp 1
\fBoctal (or oct):\fP do calculations in base 8.
.br
.sp 1
\fBdecimal (or dec):\fP do calculations in base 10.
.br
.sp 1
\fBhexidecimal (or hex):\fP do calculations in base 16.
.IP "\fBDtcalc*display:\fP"
This resource allows the user to change the default for the way answers are
display on the calculator.  The default is "fixed".  Possible values are:
.br
.sp 1
\fBfixed (or fix):\fP display in fixed mode.
.br
.sp 1
\fBscientific (or sci):\fP display in scientific mode.
.br
.sp 1
\fBengineering (or eng):\fP display in engineering mode.
.br
.sp 1
\fBhexidecimal:\fP do calculations in base 16.
.sp 2
.SH FEATURES
.P
.IP "\fBMemory Register\fP"
.IP "\fBFinancial Register\fP"
.IP "\fBASCII Converter\fP"
.IP "\fBFunctions\fP"
.IP "\fBConstants\fP"
.IP "\fBHelp\fP"
.IP "\fBPopup Menu Support\fP"
.SH COPYRIGHT
(c) Copyright 1994 Hewlett-Packard Company
.IP
(c) Copyright 1994 International Business Machines Corp.
.IP
(c) Copyright 1994 Sun Microsystems, Inc.
.sp 1
.SH ORIGIN
Hewlett-Packard Company, WTD-CV.
