module Main (main) where

import Control.Monad (unless)
import Data.Word (Word8, Word16)
import qualified Data.Char.Patterns as C
import qualified Data.Word8.Patterns as W8
import qualified Data.Word16.Patterns as W16

main :: IO ()
main = do
    print word8s
    unless (word8s == [0..127]) $ fail "something wrong"

    print word16s
    unless (word16s == [0..127]) $ fail "something wrong"

    print chars
    unless (chars == ['\NUL'..'\DEL']) $ fail "something wrong"

word8s :: [Word8]
word8s =
    [ W8.NUL
    , W8.SOH
    , W8.STX
    , W8.ETX
    , W8.EOT
    , W8.ENQ
    , W8.ACK
    , W8.BEL
    , W8.BS
    , W8.TAB
    , W8.LF
    , W8.VT
    , W8.FF
    , W8.CR
    , W8.SO
    , W8.SI
    , W8.DLE
    , W8.DC1
    , W8.DC2
    , W8.DC3
    , W8.DC4
    , W8.NAK
    , W8.SYN
    , W8.ETB
    , W8.CAN
    , W8.EOM
    , W8.SUB
    , W8.ESC
    , W8.FS
    , W8.GS
    , W8.RS
    , W8.US
    , W8.SPACE
    , W8.EXCLAM
    , W8.DOUBLE_QUOTE
    , W8.NUMBER
    , W8.DOLLAR
    , W8.PERCENT
    , W8.AMPERSAND
    , W8.SINGLE_QUOTE
    , W8.LEFT_PAREN
    , W8.RIGHT_PAREN
    , W8.ASTERISK
    , W8.PLUS
    , W8.COMMA
    , W8.HYPHEN
    , W8.PERIOD
    , W8.SLASH
    , W8.DIGIT_0
    , W8.DIGIT_1
    , W8.DIGIT_2
    , W8.DIGIT_3
    , W8.DIGIT_4
    , W8.DIGIT_5
    , W8.DIGIT_6
    , W8.DIGIT_7
    , W8.DIGIT_8
    , W8.DIGIT_9
    , W8.COLON
    , W8.SEMICOLON
    , W8.LESS
    , W8.EQUAL
    , W8.GREATER
    , W8.QUESTION
    , W8.AT
    , W8.UPPER_A
    , W8.UPPER_B
    , W8.UPPER_C
    , W8.UPPER_D
    , W8.UPPER_E
    , W8.UPPER_F
    , W8.UPPER_G
    , W8.UPPER_H
    , W8.UPPER_I
    , W8.UPPER_J
    , W8.UPPER_K
    , W8.UPPER_L
    , W8.UPPER_M
    , W8.UPPER_N
    , W8.UPPER_O
    , W8.UPPER_P
    , W8.UPPER_Q
    , W8.UPPER_R
    , W8.UPPER_S
    , W8.UPPER_T
    , W8.UPPER_U
    , W8.UPPER_V
    , W8.UPPER_W
    , W8.UPPER_X
    , W8.UPPER_Y
    , W8.UPPER_Z
    , W8.LEFT_SQUARE
    , W8.BACKSLASH
    , W8.RIGHT_SQUARE
    , W8.CIRCUM
    , W8.UNDERSCORE
    , W8.GRAVE
    , W8.LOWER_A
    , W8.LOWER_B
    , W8.LOWER_C
    , W8.LOWER_D
    , W8.LOWER_E
    , W8.LOWER_F
    , W8.LOWER_G
    , W8.LOWER_H
    , W8.LOWER_I
    , W8.LOWER_J
    , W8.LOWER_K
    , W8.LOWER_L
    , W8.LOWER_M
    , W8.LOWER_N
    , W8.LOWER_O
    , W8.LOWER_P
    , W8.LOWER_Q
    , W8.LOWER_R
    , W8.LOWER_S
    , W8.LOWER_T
    , W8.LOWER_U
    , W8.LOWER_V
    , W8.LOWER_W
    , W8.LOWER_X
    , W8.LOWER_Y
    , W8.LOWER_Z
    , W8.LEFT_CURLY
    , W8.BAR
    , W8.RIGHT_CURLY
    , W8.TILDE
    , W8.DEL
    ]

word16s :: [Word16]
word16s =
    [ W16.NUL
    , W16.SOH
    , W16.STX
    , W16.ETX
    , W16.EOT
    , W16.ENQ
    , W16.ACK
    , W16.BEL
    , W16.BS
    , W16.TAB
    , W16.LF
    , W16.VT
    , W16.FF
    , W16.CR
    , W16.SO
    , W16.SI
    , W16.DLE
    , W16.DC1
    , W16.DC2
    , W16.DC3
    , W16.DC4
    , W16.NAK
    , W16.SYN
    , W16.ETB
    , W16.CAN
    , W16.EOM
    , W16.SUB
    , W16.ESC
    , W16.FS
    , W16.GS
    , W16.RS
    , W16.US
    , W16.SPACE
    , W16.EXCLAM
    , W16.DOUBLE_QUOTE
    , W16.NUMBER
    , W16.DOLLAR
    , W16.PERCENT
    , W16.AMPERSAND
    , W16.SINGLE_QUOTE
    , W16.LEFT_PAREN
    , W16.RIGHT_PAREN
    , W16.ASTERISK
    , W16.PLUS
    , W16.COMMA
    , W16.HYPHEN
    , W16.PERIOD
    , W16.SLASH
    , W16.DIGIT_0
    , W16.DIGIT_1
    , W16.DIGIT_2
    , W16.DIGIT_3
    , W16.DIGIT_4
    , W16.DIGIT_5
    , W16.DIGIT_6
    , W16.DIGIT_7
    , W16.DIGIT_8
    , W16.DIGIT_9
    , W16.COLON
    , W16.SEMICOLON
    , W16.LESS
    , W16.EQUAL
    , W16.GREATER
    , W16.QUESTION
    , W16.AT
    , W16.UPPER_A
    , W16.UPPER_B
    , W16.UPPER_C
    , W16.UPPER_D
    , W16.UPPER_E
    , W16.UPPER_F
    , W16.UPPER_G
    , W16.UPPER_H
    , W16.UPPER_I
    , W16.UPPER_J
    , W16.UPPER_K
    , W16.UPPER_L
    , W16.UPPER_M
    , W16.UPPER_N
    , W16.UPPER_O
    , W16.UPPER_P
    , W16.UPPER_Q
    , W16.UPPER_R
    , W16.UPPER_S
    , W16.UPPER_T
    , W16.UPPER_U
    , W16.UPPER_V
    , W16.UPPER_W
    , W16.UPPER_X
    , W16.UPPER_Y
    , W16.UPPER_Z
    , W16.LEFT_SQUARE
    , W16.BACKSLASH
    , W16.RIGHT_SQUARE
    , W16.CIRCUM
    , W16.UNDERSCORE
    , W16.GRAVE
    , W16.LOWER_A
    , W16.LOWER_B
    , W16.LOWER_C
    , W16.LOWER_D
    , W16.LOWER_E
    , W16.LOWER_F
    , W16.LOWER_G
    , W16.LOWER_H
    , W16.LOWER_I
    , W16.LOWER_J
    , W16.LOWER_K
    , W16.LOWER_L
    , W16.LOWER_M
    , W16.LOWER_N
    , W16.LOWER_O
    , W16.LOWER_P
    , W16.LOWER_Q
    , W16.LOWER_R
    , W16.LOWER_S
    , W16.LOWER_T
    , W16.LOWER_U
    , W16.LOWER_V
    , W16.LOWER_W
    , W16.LOWER_X
    , W16.LOWER_Y
    , W16.LOWER_Z
    , W16.LEFT_CURLY
    , W16.BAR
    , W16.RIGHT_CURLY
    , W16.TILDE
    , W16.DEL
    ]

chars :: [Char]
chars =
    [ C.NUL
    , C.SOH
    , C.STX
    , C.ETX
    , C.EOT
    , C.ENQ
    , C.ACK
    , C.BEL
    , C.BS
    , C.TAB
    , C.LF
    , C.VT
    , C.FF
    , C.CR
    , C.SO
    , C.SI
    , C.DLE
    , C.DC1
    , C.DC2
    , C.DC3
    , C.DC4
    , C.NAK
    , C.SYN
    , C.ETB
    , C.CAN
    , C.EOM
    , C.SUB
    , C.ESC
    , C.FS
    , C.GS
    , C.RS
    , C.US
    , C.SPACE
    , C.EXCLAM
    , C.DOUBLE_QUOTE
    , C.NUMBER
    , C.DOLLAR
    , C.PERCENT
    , C.AMPERSAND
    , C.SINGLE_QUOTE
    , C.LEFT_PAREN
    , C.RIGHT_PAREN
    , C.ASTERISK
    , C.PLUS
    , C.COMMA
    , C.HYPHEN
    , C.PERIOD
    , C.SLASH
    , C.DIGIT_0
    , C.DIGIT_1
    , C.DIGIT_2
    , C.DIGIT_3
    , C.DIGIT_4
    , C.DIGIT_5
    , C.DIGIT_6
    , C.DIGIT_7
    , C.DIGIT_8
    , C.DIGIT_9
    , C.COLON
    , C.SEMICOLON
    , C.LESS
    , C.EQUAL
    , C.GREATER
    , C.QUESTION
    , C.AT
    , C.UPPER_A
    , C.UPPER_B
    , C.UPPER_C
    , C.UPPER_D
    , C.UPPER_E
    , C.UPPER_F
    , C.UPPER_G
    , C.UPPER_H
    , C.UPPER_I
    , C.UPPER_J
    , C.UPPER_K
    , C.UPPER_L
    , C.UPPER_M
    , C.UPPER_N
    , C.UPPER_O
    , C.UPPER_P
    , C.UPPER_Q
    , C.UPPER_R
    , C.UPPER_S
    , C.UPPER_T
    , C.UPPER_U
    , C.UPPER_V
    , C.UPPER_W
    , C.UPPER_X
    , C.UPPER_Y
    , C.UPPER_Z
    , C.LEFT_SQUARE
    , C.BACKSLASH
    , C.RIGHT_SQUARE
    , C.CIRCUM
    , C.UNDERSCORE
    , C.GRAVE
    , C.LOWER_A
    , C.LOWER_B
    , C.LOWER_C
    , C.LOWER_D
    , C.LOWER_E
    , C.LOWER_F
    , C.LOWER_G
    , C.LOWER_H
    , C.LOWER_I
    , C.LOWER_J
    , C.LOWER_K
    , C.LOWER_L
    , C.LOWER_M
    , C.LOWER_N
    , C.LOWER_O
    , C.LOWER_P
    , C.LOWER_Q
    , C.LOWER_R
    , C.LOWER_S
    , C.LOWER_T
    , C.LOWER_U
    , C.LOWER_V
    , C.LOWER_W
    , C.LOWER_X
    , C.LOWER_Y
    , C.LOWER_Z
    , C.LEFT_CURLY
    , C.BAR
    , C.RIGHT_CURLY
    , C.TILDE
    , C.DEL
    ]
