#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 3301
#define LARGE_STATE_COUNT 2006
#define SYMBOL_COUNT 481
#define ALIAS_COUNT 1
#define TOKEN_COUNT 342
#define EXTERNAL_TOKEN_COUNT 6
#define FIELD_COUNT 54
#define MAX_ALIAS_SEQUENCE_LENGTH 6
#define PRODUCTION_ID_COUNT 93

enum {
  sym_command_name = 1,
  sym__whitespace = 2,
  sym_line_comment = 3,
  anon_sym_BSLASHiffalse = 4,
  anon_sym_BSLASHfi = 5,
  anon_sym_LBRACK = 6,
  anon_sym_RBRACK = 7,
  anon_sym_COMMA = 8,
  anon_sym_EQ = 9,
  anon_sym_LPAREN = 10,
  anon_sym_RPAREN = 11,
  anon_sym_BSLASHpart = 12,
  anon_sym_BSLASHpart_STAR = 13,
  anon_sym_BSLASHaddpart = 14,
  anon_sym_BSLASHaddpart_STAR = 15,
  anon_sym_BSLASHchapter = 16,
  anon_sym_BSLASHchapter_STAR = 17,
  anon_sym_BSLASHaddchap = 18,
  anon_sym_BSLASHaddchap_STAR = 19,
  anon_sym_BSLASHsection = 20,
  anon_sym_BSLASHsection_STAR = 21,
  anon_sym_BSLASHaddsec = 22,
  anon_sym_BSLASHaddsec_STAR = 23,
  anon_sym_BSLASHsubsection = 24,
  anon_sym_BSLASHsubsection_STAR = 25,
  anon_sym_BSLASHsubsubsection = 26,
  anon_sym_BSLASHsubsubsection_STAR = 27,
  anon_sym_BSLASHparagraph = 28,
  anon_sym_BSLASHparagraph_STAR = 29,
  anon_sym_BSLASHsubparagraph = 30,
  anon_sym_BSLASHsubparagraph_STAR = 31,
  anon_sym_BSLASHitem = 32,
  anon_sym_BSLASHitem_STAR = 33,
  anon_sym_LBRACE = 34,
  anon_sym_RBRACE = 35,
  anon_sym_BSLASHand = 36,
  sym_word = 37,
  sym_placeholder = 38,
  sym_path = 39,
  sym_argc = 40,
  aux_sym__glob_pattern_fragment_token1 = 41,
  anon_sym_PLUS = 42,
  anon_sym_DASH = 43,
  anon_sym_STAR = 44,
  anon_sym_SLASH = 45,
  anon_sym_LT = 46,
  anon_sym_GT = 47,
  anon_sym_BANG = 48,
  anon_sym_PIPE = 49,
  anon_sym_COLON = 50,
  anon_sym_SQUOTE = 51,
  anon_sym__ = 52,
  anon_sym_CARET = 53,
  anon_sym_DOLLAR_DOLLAR = 54,
  anon_sym_BSLASH_LBRACK = 55,
  anon_sym_BSLASH_RBRACK = 56,
  anon_sym_DOLLAR = 57,
  anon_sym_BSLASH_LPAREN = 58,
  anon_sym_BSLASH_RPAREN = 59,
  anon_sym_BSLASHbegin = 60,
  anon_sym_BSLASHend = 61,
  anon_sym_comment = 62,
  anon_sym_verbatim = 63,
  anon_sym_lstlisting = 64,
  anon_sym_minted = 65,
  anon_sym_pycode = 66,
  anon_sym_displaymath = 67,
  anon_sym_displaymath_STAR = 68,
  anon_sym_equation = 69,
  anon_sym_equation_STAR = 70,
  anon_sym_multline = 71,
  anon_sym_multline_STAR = 72,
  anon_sym_eqnarray = 73,
  anon_sym_eqnarray_STAR = 74,
  anon_sym_align = 75,
  anon_sym_align_STAR = 76,
  anon_sym_array = 77,
  anon_sym_array_STAR = 78,
  anon_sym_split = 79,
  anon_sym_split_STAR = 80,
  anon_sym_alignat = 81,
  anon_sym_alignat_STAR = 82,
  anon_sym_gather = 83,
  anon_sym_gather_STAR = 84,
  anon_sym_flalign = 85,
  anon_sym_flalign_STAR = 86,
  anon_sym_BSLASHtitle = 87,
  anon_sym_BSLASHauthor = 88,
  anon_sym_BSLASHusepackage = 89,
  anon_sym_BSLASHRequirePackage = 90,
  anon_sym_BSLASHdocumentclass = 91,
  anon_sym_BSLASHinclude = 92,
  anon_sym_BSLASHsubfileinclude = 93,
  anon_sym_BSLASHinput = 94,
  anon_sym_BSLASHsubfile = 95,
  anon_sym_BSLASHaddbibresource = 96,
  anon_sym_BSLASHbibliography = 97,
  anon_sym_BSLASHincludegraphics = 98,
  anon_sym_BSLASHincludesvg = 99,
  anon_sym_BSLASHincludeinkscape = 100,
  anon_sym_BSLASHverbatiminput = 101,
  anon_sym_BSLASHVerbatimInput = 102,
  anon_sym_BSLASHimport = 103,
  anon_sym_BSLASHsubimport = 104,
  anon_sym_BSLASHinputfrom = 105,
  anon_sym_BSLASHsubimportfrom = 106,
  anon_sym_BSLASHincludefrom = 107,
  anon_sym_BSLASHsubincludefrom = 108,
  anon_sym_BSLASHcaption = 109,
  anon_sym_BSLASHcite = 110,
  anon_sym_BSLASHcite_STAR = 111,
  anon_sym_BSLASHCite = 112,
  anon_sym_BSLASHnocite = 113,
  anon_sym_BSLASHcitet = 114,
  anon_sym_BSLASHcitep = 115,
  anon_sym_BSLASHcitet_STAR = 116,
  anon_sym_BSLASHcitep_STAR = 117,
  anon_sym_BSLASHciteauthor = 118,
  anon_sym_BSLASHciteauthor_STAR = 119,
  anon_sym_BSLASHCiteauthor = 120,
  anon_sym_BSLASHCiteauthor_STAR = 121,
  anon_sym_BSLASHcitetitle = 122,
  anon_sym_BSLASHcitetitle_STAR = 123,
  anon_sym_BSLASHciteyear = 124,
  anon_sym_BSLASHciteyear_STAR = 125,
  anon_sym_BSLASHcitedate = 126,
  anon_sym_BSLASHcitedate_STAR = 127,
  anon_sym_BSLASHciteurl = 128,
  anon_sym_BSLASHfullcite = 129,
  anon_sym_BSLASHciteyearpar = 130,
  anon_sym_BSLASHcitealt = 131,
  anon_sym_BSLASHcitealp = 132,
  anon_sym_BSLASHcitetext = 133,
  anon_sym_BSLASHparencite = 134,
  anon_sym_BSLASHparencite_STAR = 135,
  anon_sym_BSLASHParencite = 136,
  anon_sym_BSLASHfootcite = 137,
  anon_sym_BSLASHfootfullcite = 138,
  anon_sym_BSLASHfootcitetext = 139,
  anon_sym_BSLASHtextcite = 140,
  anon_sym_BSLASHTextcite = 141,
  anon_sym_BSLASHsmartcite = 142,
  anon_sym_BSLASHSmartcite = 143,
  anon_sym_BSLASHsupercite = 144,
  anon_sym_BSLASHautocite = 145,
  anon_sym_BSLASHAutocite = 146,
  anon_sym_BSLASHautocite_STAR = 147,
  anon_sym_BSLASHAutocite_STAR = 148,
  anon_sym_BSLASHvolcite = 149,
  anon_sym_BSLASHVolcite = 150,
  anon_sym_BSLASHpvolcite = 151,
  anon_sym_BSLASHPvolcite = 152,
  anon_sym_BSLASHfvolcite = 153,
  anon_sym_BSLASHftvolcite = 154,
  anon_sym_BSLASHsvolcite = 155,
  anon_sym_BSLASHSvolcite = 156,
  anon_sym_BSLASHtvolcite = 157,
  anon_sym_BSLASHTvolcite = 158,
  anon_sym_BSLASHavolcite = 159,
  anon_sym_BSLASHAvolcite = 160,
  anon_sym_BSLASHnotecite = 161,
  anon_sym_BSLASHNotecite = 162,
  anon_sym_BSLASHpnotecite = 163,
  anon_sym_BSLASHPnotecite = 164,
  anon_sym_BSLASHfnotecite = 165,
  anon_sym_BSLASHlabel = 166,
  anon_sym_BSLASHref = 167,
  anon_sym_BSLASHeqref = 168,
  anon_sym_BSLASHvref = 169,
  anon_sym_BSLASHVref = 170,
  anon_sym_BSLASHautoref = 171,
  anon_sym_BSLASHpageref = 172,
  anon_sym_BSLASHcref = 173,
  anon_sym_BSLASHCref = 174,
  anon_sym_BSLASHcref_STAR = 175,
  anon_sym_BSLASHCref_STAR = 176,
  anon_sym_BSLASHnamecref = 177,
  anon_sym_BSLASHnameCref = 178,
  anon_sym_BSLASHlcnamecref = 179,
  anon_sym_BSLASHnamecrefs = 180,
  anon_sym_BSLASHnameCrefs = 181,
  anon_sym_BSLASHlcnamecrefs = 182,
  anon_sym_BSLASHlabelcref = 183,
  anon_sym_BSLASHlabelcpageref = 184,
  anon_sym_BSLASHcrefrange = 185,
  anon_sym_BSLASHcrefrange_STAR = 186,
  anon_sym_BSLASHCrefrange = 187,
  anon_sym_BSLASHCrefrange_STAR = 188,
  anon_sym_BSLASHnewlabel = 189,
  anon_sym_BSLASHnewcommand = 190,
  anon_sym_BSLASHnewcommand_STAR = 191,
  anon_sym_BSLASHrenewcommand = 192,
  anon_sym_BSLASHrenewcommand_STAR = 193,
  anon_sym_BSLASHDeclareRobustCommand = 194,
  anon_sym_BSLASHDeclareRobustCommand_STAR = 195,
  anon_sym_BSLASHDeclareMathOperator = 196,
  anon_sym_BSLASHDeclareMathOperator_STAR = 197,
  anon_sym_BSLASHNewDocumentCommand = 198,
  anon_sym_BSLASHRenewDocumentCommand = 199,
  anon_sym_BSLASHProvideDocumentCommand = 200,
  anon_sym_BSLASHDeclareDocumentCommand = 201,
  anon_sym_BSLASHNewExpandableDocumentCommand = 202,
  anon_sym_BSLASHRenewExpandableDocumentCommand = 203,
  anon_sym_BSLASHProvideExpandableDocumentCommand = 204,
  anon_sym_BSLASHDeclareExpandableDocumentCommand = 205,
  anon_sym_BSLASHdef = 206,
  anon_sym_BSLASHlet = 207,
  anon_sym_BSLASHleft = 208,
  anon_sym_BSLASHbig = 209,
  anon_sym_BSLASHBig = 210,
  anon_sym_BSLASHbigg = 211,
  anon_sym_BSLASHBigg = 212,
  anon_sym_BSLASHbigl = 213,
  anon_sym_BSLASHBigl = 214,
  anon_sym_BSLASHbiggl = 215,
  anon_sym_BSLASHBiggl = 216,
  anon_sym_BSLASHright = 217,
  anon_sym_BSLASHbigr = 218,
  anon_sym_BSLASHBigr = 219,
  anon_sym_BSLASHbiggr = 220,
  anon_sym_BSLASHBiggr = 221,
  anon_sym_BSLASHDeclarePairedDelimiter = 222,
  anon_sym_BSLASHDeclarePairedDelimiterX = 223,
  anon_sym_BSLASHnewenvironment = 224,
  anon_sym_BSLASHrenewenvironment = 225,
  anon_sym_BSLASHNewDocumentEnvironment = 226,
  anon_sym_BSLASHRenewDocumentEnvironment = 227,
  anon_sym_BSLASHProvideDocumentEnvironment = 228,
  anon_sym_BSLASHDeclareDocumentEnvironment = 229,
  anon_sym_BSLASHnewglossaryentry = 230,
  anon_sym_BSLASHgls = 231,
  anon_sym_BSLASHGls = 232,
  anon_sym_BSLASHGLS = 233,
  anon_sym_BSLASHglspl = 234,
  anon_sym_BSLASHGlspl = 235,
  anon_sym_BSLASHGLSpl = 236,
  anon_sym_BSLASHglsdisp = 237,
  anon_sym_BSLASHglslink = 238,
  anon_sym_BSLASHglstext = 239,
  anon_sym_BSLASHGlstext = 240,
  anon_sym_BSLASHGLStext = 241,
  anon_sym_BSLASHglsfirst = 242,
  anon_sym_BSLASHGlsfirst = 243,
  anon_sym_BSLASHGLSfirst = 244,
  anon_sym_BSLASHglsplural = 245,
  anon_sym_BSLASHGlsplural = 246,
  anon_sym_BSLASHGLSplural = 247,
  anon_sym_BSLASHglsfirstplural = 248,
  anon_sym_BSLASHGlsfirstplural = 249,
  anon_sym_BSLASHGLSfirstplural = 250,
  anon_sym_BSLASHglsname = 251,
  anon_sym_BSLASHGlsname = 252,
  anon_sym_BSLASHGLSname = 253,
  anon_sym_BSLASHglssymbol = 254,
  anon_sym_BSLASHGlssymbol = 255,
  anon_sym_BSLASHglsdesc = 256,
  anon_sym_BSLASHGlsdesc = 257,
  anon_sym_BSLASHGLSdesc = 258,
  anon_sym_BSLASHglsuseri = 259,
  anon_sym_BSLASHGlsuseri = 260,
  anon_sym_BSLASHGLSuseri = 261,
  anon_sym_BSLASHglsuserii = 262,
  anon_sym_BSLASHGlsuserii = 263,
  anon_sym_BSLASHGLSuserii = 264,
  anon_sym_BSLASHglsuseriii = 265,
  anon_sym_BSLASHGlsuseriii = 266,
  anon_sym_BSLASHGLSuseriii = 267,
  anon_sym_BSLASHglsuseriv = 268,
  anon_sym_BSLASHGlsuseriv = 269,
  anon_sym_BSLASHGLSuseriv = 270,
  anon_sym_BSLASHglsuserv = 271,
  anon_sym_BSLASHGlsuserv = 272,
  anon_sym_BSLASHGLSuserv = 273,
  anon_sym_BSLASHglsuservi = 274,
  anon_sym_BSLASHGlsuservi = 275,
  anon_sym_BSLASHGLSuservi = 276,
  anon_sym_BSLASHnewacronym = 277,
  anon_sym_BSLASHacrshort = 278,
  anon_sym_BSLASHAcrshort = 279,
  anon_sym_BSLASHACRshort = 280,
  anon_sym_BSLASHacrshortpl = 281,
  anon_sym_BSLASHAcrshortpl = 282,
  anon_sym_BSLASHACRshortpl = 283,
  anon_sym_BSLASHacrlong = 284,
  anon_sym_BSLASHAcrlong = 285,
  anon_sym_BSLASHACRlong = 286,
  anon_sym_BSLASHacrlongpl = 287,
  anon_sym_BSLASHAcrlongpl = 288,
  anon_sym_BSLASHACRlongpl = 289,
  anon_sym_BSLASHacrfull = 290,
  anon_sym_BSLASHAcrfull = 291,
  anon_sym_BSLASHACRfull = 292,
  anon_sym_BSLASHacrfullpl = 293,
  anon_sym_BSLASHAcrfullpl = 294,
  anon_sym_BSLASHACRfullpl = 295,
  anon_sym_BSLASHacs = 296,
  anon_sym_BSLASHAcs = 297,
  anon_sym_BSLASHacsp = 298,
  anon_sym_BSLASHAcsp = 299,
  anon_sym_BSLASHacl = 300,
  anon_sym_BSLASHAcl = 301,
  anon_sym_BSLASHaclp = 302,
  anon_sym_BSLASHAclp = 303,
  anon_sym_BSLASHacf = 304,
  anon_sym_BSLASHAcf = 305,
  anon_sym_BSLASHacfp = 306,
  anon_sym_BSLASHAcfp = 307,
  anon_sym_BSLASHac = 308,
  anon_sym_BSLASHAc = 309,
  anon_sym_BSLASHacp = 310,
  anon_sym_BSLASHglsentrylong = 311,
  anon_sym_BSLASHGlsentrylong = 312,
  anon_sym_BSLASHglsentrylongpl = 313,
  anon_sym_BSLASHGlsentrylongpl = 314,
  anon_sym_BSLASHglsentryshort = 315,
  anon_sym_BSLASHGlsentryshort = 316,
  anon_sym_BSLASHglsentryshortpl = 317,
  anon_sym_BSLASHGlsentryshortpl = 318,
  anon_sym_BSLASHglsentryfullpl = 319,
  anon_sym_BSLASHGlsentryfullpl = 320,
  anon_sym_BSLASHnewtheorem = 321,
  anon_sym_BSLASHnewtheorem_STAR = 322,
  anon_sym_BSLASHdeclaretheorem = 323,
  anon_sym_BSLASHdeclaretheorem_STAR = 324,
  anon_sym_BSLASHdefinecolor = 325,
  anon_sym_BSLASHdefinecolorset = 326,
  anon_sym_BSLASHcolor = 327,
  anon_sym_BSLASHcolorbox = 328,
  anon_sym_BSLASHtextcolor = 329,
  anon_sym_BSLASHpagecolor = 330,
  anon_sym_BSLASHusepgflibrary = 331,
  anon_sym_BSLASHusetikzlibrary = 332,
  anon_sym_BSLASHtext = 333,
  anon_sym_BSLASHintertext = 334,
  anon_sym_shortintertext = 335,
  sym__trivia_raw_fi = 336,
  sym__trivia_raw_env_comment = 337,
  sym__trivia_raw_env_verbatim = 338,
  sym__trivia_raw_env_listing = 339,
  sym__trivia_raw_env_minted = 340,
  sym__trivia_raw_env_pycode = 341,
  sym_source_file = 342,
  sym_block_comment = 343,
  sym__root_content = 344,
  sym__flat_content = 345,
  sym__text_with_env_content = 346,
  sym__text_content = 347,
  sym__section = 348,
  sym__section_part = 349,
  sym__part_declaration = 350,
  sym_part = 351,
  sym__chapter_declaration = 352,
  sym_chapter = 353,
  sym__section_declaration = 354,
  sym_section = 355,
  sym__subsection_declaration = 356,
  sym_subsection = 357,
  sym__subsubsection_declaration = 358,
  sym_subsubsection = 359,
  sym__paragraph_declaration = 360,
  sym_paragraph = 361,
  sym__subparagraph_declaration = 362,
  sym_subparagraph = 363,
  sym__enum_itemdeclaration = 364,
  sym_enum_item = 365,
  sym_curly_group = 366,
  sym_curly_group_text = 367,
  sym_curly_group_text_list = 368,
  sym_curly_group_path = 369,
  sym_curly_group_path_list = 370,
  sym_curly_group_command_name = 371,
  sym_curly_group_key_value = 372,
  sym_curly_group_glob_pattern = 373,
  sym_curly_group_impl = 374,
  sym_curly_group_author_list = 375,
  sym_brack_group = 376,
  sym_brack_group_text = 377,
  sym_brack_group_argc = 378,
  sym_brack_group_key_value = 379,
  sym_text = 380,
  sym_glob_pattern = 381,
  sym__glob_pattern_fragment = 382,
  sym_operator = 383,
  sym_subscript = 384,
  sym_superscript = 385,
  sym_key_value_pair = 386,
  sym_value = 387,
  sym_displayed_equation = 388,
  sym_inline_formula = 389,
  sym_begin = 390,
  sym_end = 391,
  sym_generic_environment = 392,
  sym_comment_environment = 393,
  sym__comment_environment_begin = 394,
  sym__comment_environment_end = 395,
  sym__comment_environment_group = 396,
  sym__comment_environment_name = 397,
  sym_verbatim_environment = 398,
  sym__verbatim_environment_begin = 399,
  sym__verbatim_environment_end = 400,
  sym__verbatim_environment_group = 401,
  sym__verbatim_environment_name = 402,
  sym_listing_environment = 403,
  sym__listing_environment_begin = 404,
  sym__listing_environment_end = 405,
  sym__listing_environment_group = 406,
  sym__listing_environment_name = 407,
  sym_minted_environment = 408,
  sym__minted_environment_begin = 409,
  sym__minted_environment_end = 410,
  sym__minted_environment_group = 411,
  sym__minted_environment_name = 412,
  sym_pycode_environment = 413,
  sym__pycode_environment_begin = 414,
  sym__pycode_environment_end = 415,
  sym__pycode_environment_group = 416,
  sym__pycode_environment_name = 417,
  sym_math_environment = 418,
  sym__math_environment_begin = 419,
  sym__math_environment_end = 420,
  sym__math_environment_group = 421,
  sym__math_environment_name = 422,
  sym__command = 423,
  sym_generic_command = 424,
  sym_title_declaration = 425,
  sym_author_declaration = 426,
  sym_package_include = 427,
  sym_class_include = 428,
  sym_latex_include = 429,
  sym_biblatex_include = 430,
  sym_bibtex_include = 431,
  sym_graphics_include = 432,
  sym_svg_include = 433,
  sym_inkscape_include = 434,
  sym_verbatim_include = 435,
  sym_import_include = 436,
  sym_caption = 437,
  sym_citation = 438,
  sym_label_definition = 439,
  sym_label_reference = 440,
  sym_label_reference_range = 441,
  sym_label_number = 442,
  sym_new_command_definition = 443,
  sym_old_command_definition = 444,
  sym_let_command_definition = 445,
  sym__math_delimiter_part = 446,
  sym_math_delimiter = 447,
  sym_paired_delimiter_definition = 448,
  sym_environment_definition = 449,
  sym_glossary_entry_definition = 450,
  sym_glossary_entry_reference = 451,
  sym_acronym_definition = 452,
  sym_acronym_reference = 453,
  sym_theorem_definition = 454,
  sym_color_definition = 455,
  sym_color_set_definition = 456,
  sym_color_reference = 457,
  sym_tikz_library_import = 458,
  sym_text_mode = 459,
  aux_sym_source_file_repeat1 = 460,
  aux_sym__section_repeat1 = 461,
  aux_sym__section_repeat2 = 462,
  aux_sym__section_repeat3 = 463,
  aux_sym__section_repeat4 = 464,
  aux_sym__section_repeat5 = 465,
  aux_sym__section_repeat6 = 466,
  aux_sym__section_repeat7 = 467,
  aux_sym__section_repeat8 = 468,
  aux_sym_part_repeat1 = 469,
  aux_sym_curly_group_text_list_repeat1 = 470,
  aux_sym_curly_group_path_list_repeat1 = 471,
  aux_sym_curly_group_key_value_repeat1 = 472,
  aux_sym_curly_group_impl_repeat1 = 473,
  aux_sym_curly_group_author_list_repeat1 = 474,
  aux_sym_curly_group_author_list_repeat2 = 475,
  aux_sym_brack_group_repeat1 = 476,
  aux_sym_text_repeat1 = 477,
  aux_sym_glob_pattern_repeat1 = 478,
  aux_sym_value_repeat1 = 479,
  aux_sym_generic_command_repeat1 = 480,
  alias_sym_author = 481,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_command_name] = "command_name",
  [sym__whitespace] = "_whitespace",
  [sym_line_comment] = "line_comment",
  [anon_sym_BSLASHiffalse] = "\\iffalse",
  [anon_sym_BSLASHfi] = "\\fi",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_COMMA] = ",",
  [anon_sym_EQ] = "=",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_BSLASHpart] = "\\part",
  [anon_sym_BSLASHpart_STAR] = "\\part*",
  [anon_sym_BSLASHaddpart] = "\\addpart",
  [anon_sym_BSLASHaddpart_STAR] = "\\addpart*",
  [anon_sym_BSLASHchapter] = "\\chapter",
  [anon_sym_BSLASHchapter_STAR] = "\\chapter*",
  [anon_sym_BSLASHaddchap] = "\\addchap",
  [anon_sym_BSLASHaddchap_STAR] = "\\addchap*",
  [anon_sym_BSLASHsection] = "\\section",
  [anon_sym_BSLASHsection_STAR] = "\\section*",
  [anon_sym_BSLASHaddsec] = "\\addsec",
  [anon_sym_BSLASHaddsec_STAR] = "\\addsec*",
  [anon_sym_BSLASHsubsection] = "\\subsection",
  [anon_sym_BSLASHsubsection_STAR] = "\\subsection*",
  [anon_sym_BSLASHsubsubsection] = "\\subsubsection",
  [anon_sym_BSLASHsubsubsection_STAR] = "\\subsubsection*",
  [anon_sym_BSLASHparagraph] = "\\paragraph",
  [anon_sym_BSLASHparagraph_STAR] = "\\paragraph*",
  [anon_sym_BSLASHsubparagraph] = "\\subparagraph",
  [anon_sym_BSLASHsubparagraph_STAR] = "\\subparagraph*",
  [anon_sym_BSLASHitem] = "\\item",
  [anon_sym_BSLASHitem_STAR] = "\\item*",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_BSLASHand] = "command_name",
  [sym_word] = "word",
  [sym_placeholder] = "placeholder",
  [sym_path] = "path",
  [sym_argc] = "argc",
  [aux_sym__glob_pattern_fragment_token1] = "_glob_pattern_fragment_token1",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_BANG] = "!",
  [anon_sym_PIPE] = "|",
  [anon_sym_COLON] = ":",
  [anon_sym_SQUOTE] = "'",
  [anon_sym__] = "_",
  [anon_sym_CARET] = "^",
  [anon_sym_DOLLAR_DOLLAR] = "$$",
  [anon_sym_BSLASH_LBRACK] = "\\[",
  [anon_sym_BSLASH_RBRACK] = "\\]",
  [anon_sym_DOLLAR] = "$",
  [anon_sym_BSLASH_LPAREN] = "\\(",
  [anon_sym_BSLASH_RPAREN] = "\\)",
  [anon_sym_BSLASHbegin] = "\\begin",
  [anon_sym_BSLASHend] = "\\end",
  [anon_sym_comment] = "word",
  [anon_sym_verbatim] = "word",
  [anon_sym_lstlisting] = "word",
  [anon_sym_minted] = "word",
  [anon_sym_pycode] = "word",
  [anon_sym_displaymath] = "word",
  [anon_sym_displaymath_STAR] = "word",
  [anon_sym_equation] = "word",
  [anon_sym_equation_STAR] = "word",
  [anon_sym_multline] = "word",
  [anon_sym_multline_STAR] = "word",
  [anon_sym_eqnarray] = "word",
  [anon_sym_eqnarray_STAR] = "word",
  [anon_sym_align] = "word",
  [anon_sym_align_STAR] = "word",
  [anon_sym_array] = "word",
  [anon_sym_array_STAR] = "word",
  [anon_sym_split] = "word",
  [anon_sym_split_STAR] = "word",
  [anon_sym_alignat] = "word",
  [anon_sym_alignat_STAR] = "word",
  [anon_sym_gather] = "word",
  [anon_sym_gather_STAR] = "word",
  [anon_sym_flalign] = "word",
  [anon_sym_flalign_STAR] = "word",
  [anon_sym_BSLASHtitle] = "\\title",
  [anon_sym_BSLASHauthor] = "\\author",
  [anon_sym_BSLASHusepackage] = "\\usepackage",
  [anon_sym_BSLASHRequirePackage] = "\\RequirePackage",
  [anon_sym_BSLASHdocumentclass] = "\\documentclass",
  [anon_sym_BSLASHinclude] = "\\include",
  [anon_sym_BSLASHsubfileinclude] = "\\subfileinclude",
  [anon_sym_BSLASHinput] = "\\input",
  [anon_sym_BSLASHsubfile] = "\\subfile",
  [anon_sym_BSLASHaddbibresource] = "\\addbibresource",
  [anon_sym_BSLASHbibliography] = "\\bibliography",
  [anon_sym_BSLASHincludegraphics] = "\\includegraphics",
  [anon_sym_BSLASHincludesvg] = "\\includesvg",
  [anon_sym_BSLASHincludeinkscape] = "\\includeinkscape",
  [anon_sym_BSLASHverbatiminput] = "\\verbatiminput",
  [anon_sym_BSLASHVerbatimInput] = "\\VerbatimInput",
  [anon_sym_BSLASHimport] = "\\import",
  [anon_sym_BSLASHsubimport] = "\\subimport",
  [anon_sym_BSLASHinputfrom] = "\\inputfrom",
  [anon_sym_BSLASHsubimportfrom] = "\\subimportfrom",
  [anon_sym_BSLASHincludefrom] = "\\includefrom",
  [anon_sym_BSLASHsubincludefrom] = "\\subincludefrom",
  [anon_sym_BSLASHcaption] = "\\caption",
  [anon_sym_BSLASHcite] = "\\cite",
  [anon_sym_BSLASHcite_STAR] = "\\cite*",
  [anon_sym_BSLASHCite] = "\\Cite",
  [anon_sym_BSLASHnocite] = "\\nocite",
  [anon_sym_BSLASHcitet] = "\\citet",
  [anon_sym_BSLASHcitep] = "\\citep",
  [anon_sym_BSLASHcitet_STAR] = "\\citet*",
  [anon_sym_BSLASHcitep_STAR] = "\\citep*",
  [anon_sym_BSLASHciteauthor] = "\\citeauthor",
  [anon_sym_BSLASHciteauthor_STAR] = "\\citeauthor*",
  [anon_sym_BSLASHCiteauthor] = "\\Citeauthor",
  [anon_sym_BSLASHCiteauthor_STAR] = "\\Citeauthor*",
  [anon_sym_BSLASHcitetitle] = "\\citetitle",
  [anon_sym_BSLASHcitetitle_STAR] = "\\citetitle*",
  [anon_sym_BSLASHciteyear] = "\\citeyear",
  [anon_sym_BSLASHciteyear_STAR] = "\\citeyear*",
  [anon_sym_BSLASHcitedate] = "\\citedate",
  [anon_sym_BSLASHcitedate_STAR] = "\\citedate*",
  [anon_sym_BSLASHciteurl] = "\\citeurl",
  [anon_sym_BSLASHfullcite] = "\\fullcite",
  [anon_sym_BSLASHciteyearpar] = "\\citeyearpar",
  [anon_sym_BSLASHcitealt] = "\\citealt",
  [anon_sym_BSLASHcitealp] = "\\citealp",
  [anon_sym_BSLASHcitetext] = "\\citetext",
  [anon_sym_BSLASHparencite] = "\\parencite",
  [anon_sym_BSLASHparencite_STAR] = "\\parencite*",
  [anon_sym_BSLASHParencite] = "\\Parencite",
  [anon_sym_BSLASHfootcite] = "\\footcite",
  [anon_sym_BSLASHfootfullcite] = "\\footfullcite",
  [anon_sym_BSLASHfootcitetext] = "\\footcitetext",
  [anon_sym_BSLASHtextcite] = "\\textcite",
  [anon_sym_BSLASHTextcite] = "\\Textcite",
  [anon_sym_BSLASHsmartcite] = "\\smartcite",
  [anon_sym_BSLASHSmartcite] = "\\Smartcite",
  [anon_sym_BSLASHsupercite] = "\\supercite",
  [anon_sym_BSLASHautocite] = "\\autocite",
  [anon_sym_BSLASHAutocite] = "\\Autocite",
  [anon_sym_BSLASHautocite_STAR] = "\\autocite*",
  [anon_sym_BSLASHAutocite_STAR] = "\\Autocite*",
  [anon_sym_BSLASHvolcite] = "\\volcite",
  [anon_sym_BSLASHVolcite] = "\\Volcite",
  [anon_sym_BSLASHpvolcite] = "\\pvolcite",
  [anon_sym_BSLASHPvolcite] = "\\Pvolcite",
  [anon_sym_BSLASHfvolcite] = "\\fvolcite",
  [anon_sym_BSLASHftvolcite] = "\\ftvolcite",
  [anon_sym_BSLASHsvolcite] = "\\svolcite",
  [anon_sym_BSLASHSvolcite] = "\\Svolcite",
  [anon_sym_BSLASHtvolcite] = "\\tvolcite",
  [anon_sym_BSLASHTvolcite] = "\\Tvolcite",
  [anon_sym_BSLASHavolcite] = "\\avolcite",
  [anon_sym_BSLASHAvolcite] = "\\Avolcite",
  [anon_sym_BSLASHnotecite] = "\\notecite",
  [anon_sym_BSLASHNotecite] = "\\Notecite",
  [anon_sym_BSLASHpnotecite] = "\\pnotecite",
  [anon_sym_BSLASHPnotecite] = "\\Pnotecite",
  [anon_sym_BSLASHfnotecite] = "\\fnotecite",
  [anon_sym_BSLASHlabel] = "\\label",
  [anon_sym_BSLASHref] = "\\ref",
  [anon_sym_BSLASHeqref] = "\\eqref",
  [anon_sym_BSLASHvref] = "\\vref",
  [anon_sym_BSLASHVref] = "\\Vref",
  [anon_sym_BSLASHautoref] = "\\autoref",
  [anon_sym_BSLASHpageref] = "\\pageref",
  [anon_sym_BSLASHcref] = "\\cref",
  [anon_sym_BSLASHCref] = "\\Cref",
  [anon_sym_BSLASHcref_STAR] = "\\cref*",
  [anon_sym_BSLASHCref_STAR] = "\\Cref*",
  [anon_sym_BSLASHnamecref] = "\\namecref",
  [anon_sym_BSLASHnameCref] = "\\nameCref",
  [anon_sym_BSLASHlcnamecref] = "\\lcnamecref",
  [anon_sym_BSLASHnamecrefs] = "\\namecrefs",
  [anon_sym_BSLASHnameCrefs] = "\\nameCrefs",
  [anon_sym_BSLASHlcnamecrefs] = "\\lcnamecrefs",
  [anon_sym_BSLASHlabelcref] = "\\labelcref",
  [anon_sym_BSLASHlabelcpageref] = "\\labelcpageref",
  [anon_sym_BSLASHcrefrange] = "\\crefrange",
  [anon_sym_BSLASHcrefrange_STAR] = "\\crefrange*",
  [anon_sym_BSLASHCrefrange] = "\\Crefrange",
  [anon_sym_BSLASHCrefrange_STAR] = "\\Crefrange*",
  [anon_sym_BSLASHnewlabel] = "\\newlabel",
  [anon_sym_BSLASHnewcommand] = "\\newcommand",
  [anon_sym_BSLASHnewcommand_STAR] = "\\newcommand*",
  [anon_sym_BSLASHrenewcommand] = "\\renewcommand",
  [anon_sym_BSLASHrenewcommand_STAR] = "\\renewcommand*",
  [anon_sym_BSLASHDeclareRobustCommand] = "\\DeclareRobustCommand",
  [anon_sym_BSLASHDeclareRobustCommand_STAR] = "\\DeclareRobustCommand*",
  [anon_sym_BSLASHDeclareMathOperator] = "\\DeclareMathOperator",
  [anon_sym_BSLASHDeclareMathOperator_STAR] = "\\DeclareMathOperator*",
  [anon_sym_BSLASHNewDocumentCommand] = "\\NewDocumentCommand",
  [anon_sym_BSLASHRenewDocumentCommand] = "\\RenewDocumentCommand",
  [anon_sym_BSLASHProvideDocumentCommand] = "\\ProvideDocumentCommand",
  [anon_sym_BSLASHDeclareDocumentCommand] = "\\DeclareDocumentCommand",
  [anon_sym_BSLASHNewExpandableDocumentCommand] = "\\NewExpandableDocumentCommand",
  [anon_sym_BSLASHRenewExpandableDocumentCommand] = "\\RenewExpandableDocumentCommand",
  [anon_sym_BSLASHProvideExpandableDocumentCommand] = "\\ProvideExpandableDocumentCommand",
  [anon_sym_BSLASHDeclareExpandableDocumentCommand] = "\\DeclareExpandableDocumentCommand",
  [anon_sym_BSLASHdef] = "\\def",
  [anon_sym_BSLASHlet] = "\\let",
  [anon_sym_BSLASHleft] = "\\left",
  [anon_sym_BSLASHbig] = "\\big",
  [anon_sym_BSLASHBig] = "\\Big",
  [anon_sym_BSLASHbigg] = "\\bigg",
  [anon_sym_BSLASHBigg] = "\\Bigg",
  [anon_sym_BSLASHbigl] = "\\bigl",
  [anon_sym_BSLASHBigl] = "\\Bigl",
  [anon_sym_BSLASHbiggl] = "\\biggl",
  [anon_sym_BSLASHBiggl] = "\\Biggl",
  [anon_sym_BSLASHright] = "\\right",
  [anon_sym_BSLASHbigr] = "\\bigr",
  [anon_sym_BSLASHBigr] = "\\Bigr",
  [anon_sym_BSLASHbiggr] = "\\biggr",
  [anon_sym_BSLASHBiggr] = "\\Biggr",
  [anon_sym_BSLASHDeclarePairedDelimiter] = "\\DeclarePairedDelimiter",
  [anon_sym_BSLASHDeclarePairedDelimiterX] = "\\DeclarePairedDelimiterX",
  [anon_sym_BSLASHnewenvironment] = "\\newenvironment",
  [anon_sym_BSLASHrenewenvironment] = "\\renewenvironment",
  [anon_sym_BSLASHNewDocumentEnvironment] = "\\NewDocumentEnvironment",
  [anon_sym_BSLASHRenewDocumentEnvironment] = "\\RenewDocumentEnvironment",
  [anon_sym_BSLASHProvideDocumentEnvironment] = "\\ProvideDocumentEnvironment",
  [anon_sym_BSLASHDeclareDocumentEnvironment] = "\\DeclareDocumentEnvironment",
  [anon_sym_BSLASHnewglossaryentry] = "\\newglossaryentry",
  [anon_sym_BSLASHgls] = "\\gls",
  [anon_sym_BSLASHGls] = "\\Gls",
  [anon_sym_BSLASHGLS] = "\\GLS",
  [anon_sym_BSLASHglspl] = "\\glspl",
  [anon_sym_BSLASHGlspl] = "\\Glspl",
  [anon_sym_BSLASHGLSpl] = "\\GLSpl",
  [anon_sym_BSLASHglsdisp] = "\\glsdisp",
  [anon_sym_BSLASHglslink] = "\\glslink",
  [anon_sym_BSLASHglstext] = "\\glstext",
  [anon_sym_BSLASHGlstext] = "\\Glstext",
  [anon_sym_BSLASHGLStext] = "\\GLStext",
  [anon_sym_BSLASHglsfirst] = "\\glsfirst",
  [anon_sym_BSLASHGlsfirst] = "\\Glsfirst",
  [anon_sym_BSLASHGLSfirst] = "\\GLSfirst",
  [anon_sym_BSLASHglsplural] = "\\glsplural",
  [anon_sym_BSLASHGlsplural] = "\\Glsplural",
  [anon_sym_BSLASHGLSplural] = "\\GLSplural",
  [anon_sym_BSLASHglsfirstplural] = "\\glsfirstplural",
  [anon_sym_BSLASHGlsfirstplural] = "\\Glsfirstplural",
  [anon_sym_BSLASHGLSfirstplural] = "\\GLSfirstplural",
  [anon_sym_BSLASHglsname] = "\\glsname",
  [anon_sym_BSLASHGlsname] = "\\Glsname",
  [anon_sym_BSLASHGLSname] = "\\GLSname",
  [anon_sym_BSLASHglssymbol] = "\\glssymbol",
  [anon_sym_BSLASHGlssymbol] = "\\Glssymbol",
  [anon_sym_BSLASHglsdesc] = "\\glsdesc",
  [anon_sym_BSLASHGlsdesc] = "\\Glsdesc",
  [anon_sym_BSLASHGLSdesc] = "\\GLSdesc",
  [anon_sym_BSLASHglsuseri] = "\\glsuseri",
  [anon_sym_BSLASHGlsuseri] = "\\Glsuseri",
  [anon_sym_BSLASHGLSuseri] = "\\GLSuseri",
  [anon_sym_BSLASHglsuserii] = "\\glsuserii",
  [anon_sym_BSLASHGlsuserii] = "\\Glsuserii",
  [anon_sym_BSLASHGLSuserii] = "\\GLSuserii",
  [anon_sym_BSLASHglsuseriii] = "\\glsuseriii",
  [anon_sym_BSLASHGlsuseriii] = "\\Glsuseriii",
  [anon_sym_BSLASHGLSuseriii] = "\\GLSuseriii",
  [anon_sym_BSLASHglsuseriv] = "\\glsuseriv",
  [anon_sym_BSLASHGlsuseriv] = "\\Glsuseriv",
  [anon_sym_BSLASHGLSuseriv] = "\\GLSuseriv",
  [anon_sym_BSLASHglsuserv] = "\\glsuserv",
  [anon_sym_BSLASHGlsuserv] = "\\Glsuserv",
  [anon_sym_BSLASHGLSuserv] = "\\GLSuserv",
  [anon_sym_BSLASHglsuservi] = "\\glsuservi",
  [anon_sym_BSLASHGlsuservi] = "\\Glsuservi",
  [anon_sym_BSLASHGLSuservi] = "\\GLSuservi",
  [anon_sym_BSLASHnewacronym] = "\\newacronym",
  [anon_sym_BSLASHacrshort] = "\\acrshort",
  [anon_sym_BSLASHAcrshort] = "\\Acrshort",
  [anon_sym_BSLASHACRshort] = "\\ACRshort",
  [anon_sym_BSLASHacrshortpl] = "\\acrshortpl",
  [anon_sym_BSLASHAcrshortpl] = "\\Acrshortpl",
  [anon_sym_BSLASHACRshortpl] = "\\ACRshortpl",
  [anon_sym_BSLASHacrlong] = "\\acrlong",
  [anon_sym_BSLASHAcrlong] = "\\Acrlong",
  [anon_sym_BSLASHACRlong] = "\\ACRlong",
  [anon_sym_BSLASHacrlongpl] = "\\acrlongpl",
  [anon_sym_BSLASHAcrlongpl] = "\\Acrlongpl",
  [anon_sym_BSLASHACRlongpl] = "\\ACRlongpl",
  [anon_sym_BSLASHacrfull] = "\\acrfull",
  [anon_sym_BSLASHAcrfull] = "\\Acrfull",
  [anon_sym_BSLASHACRfull] = "\\ACRfull",
  [anon_sym_BSLASHacrfullpl] = "\\acrfullpl",
  [anon_sym_BSLASHAcrfullpl] = "\\Acrfullpl",
  [anon_sym_BSLASHACRfullpl] = "\\ACRfullpl",
  [anon_sym_BSLASHacs] = "\\acs",
  [anon_sym_BSLASHAcs] = "\\Acs",
  [anon_sym_BSLASHacsp] = "\\acsp",
  [anon_sym_BSLASHAcsp] = "\\Acsp",
  [anon_sym_BSLASHacl] = "\\acl",
  [anon_sym_BSLASHAcl] = "\\Acl",
  [anon_sym_BSLASHaclp] = "\\aclp",
  [anon_sym_BSLASHAclp] = "\\Aclp",
  [anon_sym_BSLASHacf] = "\\acf",
  [anon_sym_BSLASHAcf] = "\\Acf",
  [anon_sym_BSLASHacfp] = "\\acfp",
  [anon_sym_BSLASHAcfp] = "\\Acfp",
  [anon_sym_BSLASHac] = "\\ac",
  [anon_sym_BSLASHAc] = "\\Ac",
  [anon_sym_BSLASHacp] = "\\acp",
  [anon_sym_BSLASHglsentrylong] = "\\glsentrylong",
  [anon_sym_BSLASHGlsentrylong] = "\\Glsentrylong",
  [anon_sym_BSLASHglsentrylongpl] = "\\glsentrylongpl",
  [anon_sym_BSLASHGlsentrylongpl] = "\\Glsentrylongpl",
  [anon_sym_BSLASHglsentryshort] = "\\glsentryshort",
  [anon_sym_BSLASHGlsentryshort] = "\\Glsentryshort",
  [anon_sym_BSLASHglsentryshortpl] = "\\glsentryshortpl",
  [anon_sym_BSLASHGlsentryshortpl] = "\\Glsentryshortpl",
  [anon_sym_BSLASHglsentryfullpl] = "\\glsentryfullpl",
  [anon_sym_BSLASHGlsentryfullpl] = "\\Glsentryfullpl",
  [anon_sym_BSLASHnewtheorem] = "\\newtheorem",
  [anon_sym_BSLASHnewtheorem_STAR] = "\\newtheorem*",
  [anon_sym_BSLASHdeclaretheorem] = "\\declaretheorem",
  [anon_sym_BSLASHdeclaretheorem_STAR] = "\\declaretheorem*",
  [anon_sym_BSLASHdefinecolor] = "\\definecolor",
  [anon_sym_BSLASHdefinecolorset] = "\\definecolorset",
  [anon_sym_BSLASHcolor] = "\\color",
  [anon_sym_BSLASHcolorbox] = "\\colorbox",
  [anon_sym_BSLASHtextcolor] = "\\textcolor",
  [anon_sym_BSLASHpagecolor] = "\\pagecolor",
  [anon_sym_BSLASHusepgflibrary] = "\\usepgflibrary",
  [anon_sym_BSLASHusetikzlibrary] = "\\usetikzlibrary",
  [anon_sym_BSLASHtext] = "\\text",
  [anon_sym_BSLASHintertext] = "\\intertext",
  [anon_sym_shortintertext] = "shortintertext",
  [sym__trivia_raw_fi] = "comment",
  [sym__trivia_raw_env_comment] = "comment",
  [sym__trivia_raw_env_verbatim] = "comment",
  [sym__trivia_raw_env_listing] = "source_code",
  [sym__trivia_raw_env_minted] = "source_code",
  [sym__trivia_raw_env_pycode] = "source_code",
  [sym_source_file] = "source_file",
  [sym_block_comment] = "block_comment",
  [sym__root_content] = "_root_content",
  [sym__flat_content] = "_flat_content",
  [sym__text_with_env_content] = "_text_with_env_content",
  [sym__text_content] = "_text_content",
  [sym__section] = "_section",
  [sym__section_part] = "_section_part",
  [sym__part_declaration] = "_part_declaration",
  [sym_part] = "part",
  [sym__chapter_declaration] = "_chapter_declaration",
  [sym_chapter] = "chapter",
  [sym__section_declaration] = "_section_declaration",
  [sym_section] = "section",
  [sym__subsection_declaration] = "_subsection_declaration",
  [sym_subsection] = "subsection",
  [sym__subsubsection_declaration] = "_subsubsection_declaration",
  [sym_subsubsection] = "subsubsection",
  [sym__paragraph_declaration] = "_paragraph_declaration",
  [sym_paragraph] = "paragraph",
  [sym__subparagraph_declaration] = "_subparagraph_declaration",
  [sym_subparagraph] = "subparagraph",
  [sym__enum_itemdeclaration] = "_enum_itemdeclaration",
  [sym_enum_item] = "enum_item",
  [sym_curly_group] = "curly_group",
  [sym_curly_group_text] = "curly_group_text",
  [sym_curly_group_text_list] = "curly_group_text_list",
  [sym_curly_group_path] = "curly_group_path",
  [sym_curly_group_path_list] = "curly_group_path_list",
  [sym_curly_group_command_name] = "curly_group_command_name",
  [sym_curly_group_key_value] = "curly_group_key_value",
  [sym_curly_group_glob_pattern] = "curly_group_glob_pattern",
  [sym_curly_group_impl] = "curly_group_impl",
  [sym_curly_group_author_list] = "curly_group_author_list",
  [sym_brack_group] = "brack_group",
  [sym_brack_group_text] = "brack_group_text",
  [sym_brack_group_argc] = "brack_group_argc",
  [sym_brack_group_key_value] = "brack_group_key_value",
  [sym_text] = "text",
  [sym_glob_pattern] = "glob_pattern",
  [sym__glob_pattern_fragment] = "_glob_pattern_fragment",
  [sym_operator] = "operator",
  [sym_subscript] = "subscript",
  [sym_superscript] = "superscript",
  [sym_key_value_pair] = "key_value_pair",
  [sym_value] = "value",
  [sym_displayed_equation] = "displayed_equation",
  [sym_inline_formula] = "inline_formula",
  [sym_begin] = "begin",
  [sym_end] = "end",
  [sym_generic_environment] = "generic_environment",
  [sym_comment_environment] = "comment_environment",
  [sym__comment_environment_begin] = "begin",
  [sym__comment_environment_end] = "end",
  [sym__comment_environment_group] = "curly_group_text",
  [sym__comment_environment_name] = "text",
  [sym_verbatim_environment] = "verbatim_environment",
  [sym__verbatim_environment_begin] = "begin",
  [sym__verbatim_environment_end] = "end",
  [sym__verbatim_environment_group] = "curly_group_text",
  [sym__verbatim_environment_name] = "text",
  [sym_listing_environment] = "listing_environment",
  [sym__listing_environment_begin] = "begin",
  [sym__listing_environment_end] = "end",
  [sym__listing_environment_group] = "curly_group_text",
  [sym__listing_environment_name] = "text",
  [sym_minted_environment] = "minted_environment",
  [sym__minted_environment_begin] = "begin",
  [sym__minted_environment_end] = "end",
  [sym__minted_environment_group] = "curly_group_text",
  [sym__minted_environment_name] = "text",
  [sym_pycode_environment] = "pycode_environment",
  [sym__pycode_environment_begin] = "begin",
  [sym__pycode_environment_end] = "end",
  [sym__pycode_environment_group] = "curly_group_text",
  [sym__pycode_environment_name] = "text",
  [sym_math_environment] = "math_environment",
  [sym__math_environment_begin] = "begin",
  [sym__math_environment_end] = "end",
  [sym__math_environment_group] = "curly_group_text",
  [sym__math_environment_name] = "text",
  [sym__command] = "_command",
  [sym_generic_command] = "generic_command",
  [sym_title_declaration] = "title_declaration",
  [sym_author_declaration] = "author_declaration",
  [sym_package_include] = "package_include",
  [sym_class_include] = "class_include",
  [sym_latex_include] = "latex_include",
  [sym_biblatex_include] = "biblatex_include",
  [sym_bibtex_include] = "bibtex_include",
  [sym_graphics_include] = "graphics_include",
  [sym_svg_include] = "svg_include",
  [sym_inkscape_include] = "inkscape_include",
  [sym_verbatim_include] = "verbatim_include",
  [sym_import_include] = "import_include",
  [sym_caption] = "caption",
  [sym_citation] = "citation",
  [sym_label_definition] = "label_definition",
  [sym_label_reference] = "label_reference",
  [sym_label_reference_range] = "label_reference_range",
  [sym_label_number] = "label_number",
  [sym_new_command_definition] = "new_command_definition",
  [sym_old_command_definition] = "old_command_definition",
  [sym_let_command_definition] = "let_command_definition",
  [sym__math_delimiter_part] = "_math_delimiter_part",
  [sym_math_delimiter] = "math_delimiter",
  [sym_paired_delimiter_definition] = "paired_delimiter_definition",
  [sym_environment_definition] = "environment_definition",
  [sym_glossary_entry_definition] = "glossary_entry_definition",
  [sym_glossary_entry_reference] = "glossary_entry_reference",
  [sym_acronym_definition] = "acronym_definition",
  [sym_acronym_reference] = "acronym_reference",
  [sym_theorem_definition] = "theorem_definition",
  [sym_color_definition] = "color_definition",
  [sym_color_set_definition] = "color_set_definition",
  [sym_color_reference] = "color_reference",
  [sym_tikz_library_import] = "tikz_library_import",
  [sym_text_mode] = "text_mode",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym__section_repeat1] = "_section_repeat1",
  [aux_sym__section_repeat2] = "_section_repeat2",
  [aux_sym__section_repeat3] = "_section_repeat3",
  [aux_sym__section_repeat4] = "_section_repeat4",
  [aux_sym__section_repeat5] = "_section_repeat5",
  [aux_sym__section_repeat6] = "_section_repeat6",
  [aux_sym__section_repeat7] = "_section_repeat7",
  [aux_sym__section_repeat8] = "_section_repeat8",
  [aux_sym_part_repeat1] = "part_repeat1",
  [aux_sym_curly_group_text_list_repeat1] = "curly_group_text_list_repeat1",
  [aux_sym_curly_group_path_list_repeat1] = "curly_group_path_list_repeat1",
  [aux_sym_curly_group_key_value_repeat1] = "curly_group_key_value_repeat1",
  [aux_sym_curly_group_impl_repeat1] = "curly_group_impl_repeat1",
  [aux_sym_curly_group_author_list_repeat1] = "curly_group_author_list_repeat1",
  [aux_sym_curly_group_author_list_repeat2] = "curly_group_author_list_repeat2",
  [aux_sym_brack_group_repeat1] = "brack_group_repeat1",
  [aux_sym_text_repeat1] = "text_repeat1",
  [aux_sym_glob_pattern_repeat1] = "glob_pattern_repeat1",
  [aux_sym_value_repeat1] = "value_repeat1",
  [aux_sym_generic_command_repeat1] = "generic_command_repeat1",
  [alias_sym_author] = "author",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_command_name] = sym_command_name,
  [sym__whitespace] = sym__whitespace,
  [sym_line_comment] = sym_line_comment,
  [anon_sym_BSLASHiffalse] = anon_sym_BSLASHiffalse,
  [anon_sym_BSLASHfi] = anon_sym_BSLASHfi,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_BSLASHpart] = anon_sym_BSLASHpart,
  [anon_sym_BSLASHpart_STAR] = anon_sym_BSLASHpart_STAR,
  [anon_sym_BSLASHaddpart] = anon_sym_BSLASHaddpart,
  [anon_sym_BSLASHaddpart_STAR] = anon_sym_BSLASHaddpart_STAR,
  [anon_sym_BSLASHchapter] = anon_sym_BSLASHchapter,
  [anon_sym_BSLASHchapter_STAR] = anon_sym_BSLASHchapter_STAR,
  [anon_sym_BSLASHaddchap] = anon_sym_BSLASHaddchap,
  [anon_sym_BSLASHaddchap_STAR] = anon_sym_BSLASHaddchap_STAR,
  [anon_sym_BSLASHsection] = anon_sym_BSLASHsection,
  [anon_sym_BSLASHsection_STAR] = anon_sym_BSLASHsection_STAR,
  [anon_sym_BSLASHaddsec] = anon_sym_BSLASHaddsec,
  [anon_sym_BSLASHaddsec_STAR] = anon_sym_BSLASHaddsec_STAR,
  [anon_sym_BSLASHsubsection] = anon_sym_BSLASHsubsection,
  [anon_sym_BSLASHsubsection_STAR] = anon_sym_BSLASHsubsection_STAR,
  [anon_sym_BSLASHsubsubsection] = anon_sym_BSLASHsubsubsection,
  [anon_sym_BSLASHsubsubsection_STAR] = anon_sym_BSLASHsubsubsection_STAR,
  [anon_sym_BSLASHparagraph] = anon_sym_BSLASHparagraph,
  [anon_sym_BSLASHparagraph_STAR] = anon_sym_BSLASHparagraph_STAR,
  [anon_sym_BSLASHsubparagraph] = anon_sym_BSLASHsubparagraph,
  [anon_sym_BSLASHsubparagraph_STAR] = anon_sym_BSLASHsubparagraph_STAR,
  [anon_sym_BSLASHitem] = anon_sym_BSLASHitem,
  [anon_sym_BSLASHitem_STAR] = anon_sym_BSLASHitem_STAR,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_BSLASHand] = sym_command_name,
  [sym_word] = sym_word,
  [sym_placeholder] = sym_placeholder,
  [sym_path] = sym_path,
  [sym_argc] = sym_argc,
  [aux_sym__glob_pattern_fragment_token1] = aux_sym__glob_pattern_fragment_token1,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [anon_sym__] = anon_sym__,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_DOLLAR_DOLLAR] = anon_sym_DOLLAR_DOLLAR,
  [anon_sym_BSLASH_LBRACK] = anon_sym_BSLASH_LBRACK,
  [anon_sym_BSLASH_RBRACK] = anon_sym_BSLASH_RBRACK,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [anon_sym_BSLASH_LPAREN] = anon_sym_BSLASH_LPAREN,
  [anon_sym_BSLASH_RPAREN] = anon_sym_BSLASH_RPAREN,
  [anon_sym_BSLASHbegin] = anon_sym_BSLASHbegin,
  [anon_sym_BSLASHend] = anon_sym_BSLASHend,
  [anon_sym_comment] = sym_word,
  [anon_sym_verbatim] = sym_word,
  [anon_sym_lstlisting] = sym_word,
  [anon_sym_minted] = sym_word,
  [anon_sym_pycode] = sym_word,
  [anon_sym_displaymath] = sym_word,
  [anon_sym_displaymath_STAR] = sym_word,
  [anon_sym_equation] = sym_word,
  [anon_sym_equation_STAR] = sym_word,
  [anon_sym_multline] = sym_word,
  [anon_sym_multline_STAR] = sym_word,
  [anon_sym_eqnarray] = sym_word,
  [anon_sym_eqnarray_STAR] = sym_word,
  [anon_sym_align] = sym_word,
  [anon_sym_align_STAR] = sym_word,
  [anon_sym_array] = sym_word,
  [anon_sym_array_STAR] = sym_word,
  [anon_sym_split] = sym_word,
  [anon_sym_split_STAR] = sym_word,
  [anon_sym_alignat] = sym_word,
  [anon_sym_alignat_STAR] = sym_word,
  [anon_sym_gather] = sym_word,
  [anon_sym_gather_STAR] = sym_word,
  [anon_sym_flalign] = sym_word,
  [anon_sym_flalign_STAR] = sym_word,
  [anon_sym_BSLASHtitle] = anon_sym_BSLASHtitle,
  [anon_sym_BSLASHauthor] = anon_sym_BSLASHauthor,
  [anon_sym_BSLASHusepackage] = anon_sym_BSLASHusepackage,
  [anon_sym_BSLASHRequirePackage] = anon_sym_BSLASHRequirePackage,
  [anon_sym_BSLASHdocumentclass] = anon_sym_BSLASHdocumentclass,
  [anon_sym_BSLASHinclude] = anon_sym_BSLASHinclude,
  [anon_sym_BSLASHsubfileinclude] = anon_sym_BSLASHsubfileinclude,
  [anon_sym_BSLASHinput] = anon_sym_BSLASHinput,
  [anon_sym_BSLASHsubfile] = anon_sym_BSLASHsubfile,
  [anon_sym_BSLASHaddbibresource] = anon_sym_BSLASHaddbibresource,
  [anon_sym_BSLASHbibliography] = anon_sym_BSLASHbibliography,
  [anon_sym_BSLASHincludegraphics] = anon_sym_BSLASHincludegraphics,
  [anon_sym_BSLASHincludesvg] = anon_sym_BSLASHincludesvg,
  [anon_sym_BSLASHincludeinkscape] = anon_sym_BSLASHincludeinkscape,
  [anon_sym_BSLASHverbatiminput] = anon_sym_BSLASHverbatiminput,
  [anon_sym_BSLASHVerbatimInput] = anon_sym_BSLASHVerbatimInput,
  [anon_sym_BSLASHimport] = anon_sym_BSLASHimport,
  [anon_sym_BSLASHsubimport] = anon_sym_BSLASHsubimport,
  [anon_sym_BSLASHinputfrom] = anon_sym_BSLASHinputfrom,
  [anon_sym_BSLASHsubimportfrom] = anon_sym_BSLASHsubimportfrom,
  [anon_sym_BSLASHincludefrom] = anon_sym_BSLASHincludefrom,
  [anon_sym_BSLASHsubincludefrom] = anon_sym_BSLASHsubincludefrom,
  [anon_sym_BSLASHcaption] = anon_sym_BSLASHcaption,
  [anon_sym_BSLASHcite] = anon_sym_BSLASHcite,
  [anon_sym_BSLASHcite_STAR] = anon_sym_BSLASHcite_STAR,
  [anon_sym_BSLASHCite] = anon_sym_BSLASHCite,
  [anon_sym_BSLASHnocite] = anon_sym_BSLASHnocite,
  [anon_sym_BSLASHcitet] = anon_sym_BSLASHcitet,
  [anon_sym_BSLASHcitep] = anon_sym_BSLASHcitep,
  [anon_sym_BSLASHcitet_STAR] = anon_sym_BSLASHcitet_STAR,
  [anon_sym_BSLASHcitep_STAR] = anon_sym_BSLASHcitep_STAR,
  [anon_sym_BSLASHciteauthor] = anon_sym_BSLASHciteauthor,
  [anon_sym_BSLASHciteauthor_STAR] = anon_sym_BSLASHciteauthor_STAR,
  [anon_sym_BSLASHCiteauthor] = anon_sym_BSLASHCiteauthor,
  [anon_sym_BSLASHCiteauthor_STAR] = anon_sym_BSLASHCiteauthor_STAR,
  [anon_sym_BSLASHcitetitle] = anon_sym_BSLASHcitetitle,
  [anon_sym_BSLASHcitetitle_STAR] = anon_sym_BSLASHcitetitle_STAR,
  [anon_sym_BSLASHciteyear] = anon_sym_BSLASHciteyear,
  [anon_sym_BSLASHciteyear_STAR] = anon_sym_BSLASHciteyear_STAR,
  [anon_sym_BSLASHcitedate] = anon_sym_BSLASHcitedate,
  [anon_sym_BSLASHcitedate_STAR] = anon_sym_BSLASHcitedate_STAR,
  [anon_sym_BSLASHciteurl] = anon_sym_BSLASHciteurl,
  [anon_sym_BSLASHfullcite] = anon_sym_BSLASHfullcite,
  [anon_sym_BSLASHciteyearpar] = anon_sym_BSLASHciteyearpar,
  [anon_sym_BSLASHcitealt] = anon_sym_BSLASHcitealt,
  [anon_sym_BSLASHcitealp] = anon_sym_BSLASHcitealp,
  [anon_sym_BSLASHcitetext] = anon_sym_BSLASHcitetext,
  [anon_sym_BSLASHparencite] = anon_sym_BSLASHparencite,
  [anon_sym_BSLASHparencite_STAR] = anon_sym_BSLASHparencite_STAR,
  [anon_sym_BSLASHParencite] = anon_sym_BSLASHParencite,
  [anon_sym_BSLASHfootcite] = anon_sym_BSLASHfootcite,
  [anon_sym_BSLASHfootfullcite] = anon_sym_BSLASHfootfullcite,
  [anon_sym_BSLASHfootcitetext] = anon_sym_BSLASHfootcitetext,
  [anon_sym_BSLASHtextcite] = anon_sym_BSLASHtextcite,
  [anon_sym_BSLASHTextcite] = anon_sym_BSLASHTextcite,
  [anon_sym_BSLASHsmartcite] = anon_sym_BSLASHsmartcite,
  [anon_sym_BSLASHSmartcite] = anon_sym_BSLASHSmartcite,
  [anon_sym_BSLASHsupercite] = anon_sym_BSLASHsupercite,
  [anon_sym_BSLASHautocite] = anon_sym_BSLASHautocite,
  [anon_sym_BSLASHAutocite] = anon_sym_BSLASHAutocite,
  [anon_sym_BSLASHautocite_STAR] = anon_sym_BSLASHautocite_STAR,
  [anon_sym_BSLASHAutocite_STAR] = anon_sym_BSLASHAutocite_STAR,
  [anon_sym_BSLASHvolcite] = anon_sym_BSLASHvolcite,
  [anon_sym_BSLASHVolcite] = anon_sym_BSLASHVolcite,
  [anon_sym_BSLASHpvolcite] = anon_sym_BSLASHpvolcite,
  [anon_sym_BSLASHPvolcite] = anon_sym_BSLASHPvolcite,
  [anon_sym_BSLASHfvolcite] = anon_sym_BSLASHfvolcite,
  [anon_sym_BSLASHftvolcite] = anon_sym_BSLASHftvolcite,
  [anon_sym_BSLASHsvolcite] = anon_sym_BSLASHsvolcite,
  [anon_sym_BSLASHSvolcite] = anon_sym_BSLASHSvolcite,
  [anon_sym_BSLASHtvolcite] = anon_sym_BSLASHtvolcite,
  [anon_sym_BSLASHTvolcite] = anon_sym_BSLASHTvolcite,
  [anon_sym_BSLASHavolcite] = anon_sym_BSLASHavolcite,
  [anon_sym_BSLASHAvolcite] = anon_sym_BSLASHAvolcite,
  [anon_sym_BSLASHnotecite] = anon_sym_BSLASHnotecite,
  [anon_sym_BSLASHNotecite] = anon_sym_BSLASHNotecite,
  [anon_sym_BSLASHpnotecite] = anon_sym_BSLASHpnotecite,
  [anon_sym_BSLASHPnotecite] = anon_sym_BSLASHPnotecite,
  [anon_sym_BSLASHfnotecite] = anon_sym_BSLASHfnotecite,
  [anon_sym_BSLASHlabel] = anon_sym_BSLASHlabel,
  [anon_sym_BSLASHref] = anon_sym_BSLASHref,
  [anon_sym_BSLASHeqref] = anon_sym_BSLASHeqref,
  [anon_sym_BSLASHvref] = anon_sym_BSLASHvref,
  [anon_sym_BSLASHVref] = anon_sym_BSLASHVref,
  [anon_sym_BSLASHautoref] = anon_sym_BSLASHautoref,
  [anon_sym_BSLASHpageref] = anon_sym_BSLASHpageref,
  [anon_sym_BSLASHcref] = anon_sym_BSLASHcref,
  [anon_sym_BSLASHCref] = anon_sym_BSLASHCref,
  [anon_sym_BSLASHcref_STAR] = anon_sym_BSLASHcref_STAR,
  [anon_sym_BSLASHCref_STAR] = anon_sym_BSLASHCref_STAR,
  [anon_sym_BSLASHnamecref] = anon_sym_BSLASHnamecref,
  [anon_sym_BSLASHnameCref] = anon_sym_BSLASHnameCref,
  [anon_sym_BSLASHlcnamecref] = anon_sym_BSLASHlcnamecref,
  [anon_sym_BSLASHnamecrefs] = anon_sym_BSLASHnamecrefs,
  [anon_sym_BSLASHnameCrefs] = anon_sym_BSLASHnameCrefs,
  [anon_sym_BSLASHlcnamecrefs] = anon_sym_BSLASHlcnamecrefs,
  [anon_sym_BSLASHlabelcref] = anon_sym_BSLASHlabelcref,
  [anon_sym_BSLASHlabelcpageref] = anon_sym_BSLASHlabelcpageref,
  [anon_sym_BSLASHcrefrange] = anon_sym_BSLASHcrefrange,
  [anon_sym_BSLASHcrefrange_STAR] = anon_sym_BSLASHcrefrange_STAR,
  [anon_sym_BSLASHCrefrange] = anon_sym_BSLASHCrefrange,
  [anon_sym_BSLASHCrefrange_STAR] = anon_sym_BSLASHCrefrange_STAR,
  [anon_sym_BSLASHnewlabel] = anon_sym_BSLASHnewlabel,
  [anon_sym_BSLASHnewcommand] = anon_sym_BSLASHnewcommand,
  [anon_sym_BSLASHnewcommand_STAR] = anon_sym_BSLASHnewcommand_STAR,
  [anon_sym_BSLASHrenewcommand] = anon_sym_BSLASHrenewcommand,
  [anon_sym_BSLASHrenewcommand_STAR] = anon_sym_BSLASHrenewcommand_STAR,
  [anon_sym_BSLASHDeclareRobustCommand] = anon_sym_BSLASHDeclareRobustCommand,
  [anon_sym_BSLASHDeclareRobustCommand_STAR] = anon_sym_BSLASHDeclareRobustCommand_STAR,
  [anon_sym_BSLASHDeclareMathOperator] = anon_sym_BSLASHDeclareMathOperator,
  [anon_sym_BSLASHDeclareMathOperator_STAR] = anon_sym_BSLASHDeclareMathOperator_STAR,
  [anon_sym_BSLASHNewDocumentCommand] = anon_sym_BSLASHNewDocumentCommand,
  [anon_sym_BSLASHRenewDocumentCommand] = anon_sym_BSLASHRenewDocumentCommand,
  [anon_sym_BSLASHProvideDocumentCommand] = anon_sym_BSLASHProvideDocumentCommand,
  [anon_sym_BSLASHDeclareDocumentCommand] = anon_sym_BSLASHDeclareDocumentCommand,
  [anon_sym_BSLASHNewExpandableDocumentCommand] = anon_sym_BSLASHNewExpandableDocumentCommand,
  [anon_sym_BSLASHRenewExpandableDocumentCommand] = anon_sym_BSLASHRenewExpandableDocumentCommand,
  [anon_sym_BSLASHProvideExpandableDocumentCommand] = anon_sym_BSLASHProvideExpandableDocumentCommand,
  [anon_sym_BSLASHDeclareExpandableDocumentCommand] = anon_sym_BSLASHDeclareExpandableDocumentCommand,
  [anon_sym_BSLASHdef] = anon_sym_BSLASHdef,
  [anon_sym_BSLASHlet] = anon_sym_BSLASHlet,
  [anon_sym_BSLASHleft] = anon_sym_BSLASHleft,
  [anon_sym_BSLASHbig] = anon_sym_BSLASHbig,
  [anon_sym_BSLASHBig] = anon_sym_BSLASHBig,
  [anon_sym_BSLASHbigg] = anon_sym_BSLASHbigg,
  [anon_sym_BSLASHBigg] = anon_sym_BSLASHBigg,
  [anon_sym_BSLASHbigl] = anon_sym_BSLASHbigl,
  [anon_sym_BSLASHBigl] = anon_sym_BSLASHBigl,
  [anon_sym_BSLASHbiggl] = anon_sym_BSLASHbiggl,
  [anon_sym_BSLASHBiggl] = anon_sym_BSLASHBiggl,
  [anon_sym_BSLASHright] = anon_sym_BSLASHright,
  [anon_sym_BSLASHbigr] = anon_sym_BSLASHbigr,
  [anon_sym_BSLASHBigr] = anon_sym_BSLASHBigr,
  [anon_sym_BSLASHbiggr] = anon_sym_BSLASHbiggr,
  [anon_sym_BSLASHBiggr] = anon_sym_BSLASHBiggr,
  [anon_sym_BSLASHDeclarePairedDelimiter] = anon_sym_BSLASHDeclarePairedDelimiter,
  [anon_sym_BSLASHDeclarePairedDelimiterX] = anon_sym_BSLASHDeclarePairedDelimiterX,
  [anon_sym_BSLASHnewenvironment] = anon_sym_BSLASHnewenvironment,
  [anon_sym_BSLASHrenewenvironment] = anon_sym_BSLASHrenewenvironment,
  [anon_sym_BSLASHNewDocumentEnvironment] = anon_sym_BSLASHNewDocumentEnvironment,
  [anon_sym_BSLASHRenewDocumentEnvironment] = anon_sym_BSLASHRenewDocumentEnvironment,
  [anon_sym_BSLASHProvideDocumentEnvironment] = anon_sym_BSLASHProvideDocumentEnvironment,
  [anon_sym_BSLASHDeclareDocumentEnvironment] = anon_sym_BSLASHDeclareDocumentEnvironment,
  [anon_sym_BSLASHnewglossaryentry] = anon_sym_BSLASHnewglossaryentry,
  [anon_sym_BSLASHgls] = anon_sym_BSLASHgls,
  [anon_sym_BSLASHGls] = anon_sym_BSLASHGls,
  [anon_sym_BSLASHGLS] = anon_sym_BSLASHGLS,
  [anon_sym_BSLASHglspl] = anon_sym_BSLASHglspl,
  [anon_sym_BSLASHGlspl] = anon_sym_BSLASHGlspl,
  [anon_sym_BSLASHGLSpl] = anon_sym_BSLASHGLSpl,
  [anon_sym_BSLASHglsdisp] = anon_sym_BSLASHglsdisp,
  [anon_sym_BSLASHglslink] = anon_sym_BSLASHglslink,
  [anon_sym_BSLASHglstext] = anon_sym_BSLASHglstext,
  [anon_sym_BSLASHGlstext] = anon_sym_BSLASHGlstext,
  [anon_sym_BSLASHGLStext] = anon_sym_BSLASHGLStext,
  [anon_sym_BSLASHglsfirst] = anon_sym_BSLASHglsfirst,
  [anon_sym_BSLASHGlsfirst] = anon_sym_BSLASHGlsfirst,
  [anon_sym_BSLASHGLSfirst] = anon_sym_BSLASHGLSfirst,
  [anon_sym_BSLASHglsplural] = anon_sym_BSLASHglsplural,
  [anon_sym_BSLASHGlsplural] = anon_sym_BSLASHGlsplural,
  [anon_sym_BSLASHGLSplural] = anon_sym_BSLASHGLSplural,
  [anon_sym_BSLASHglsfirstplural] = anon_sym_BSLASHglsfirstplural,
  [anon_sym_BSLASHGlsfirstplural] = anon_sym_BSLASHGlsfirstplural,
  [anon_sym_BSLASHGLSfirstplural] = anon_sym_BSLASHGLSfirstplural,
  [anon_sym_BSLASHglsname] = anon_sym_BSLASHglsname,
  [anon_sym_BSLASHGlsname] = anon_sym_BSLASHGlsname,
  [anon_sym_BSLASHGLSname] = anon_sym_BSLASHGLSname,
  [anon_sym_BSLASHglssymbol] = anon_sym_BSLASHglssymbol,
  [anon_sym_BSLASHGlssymbol] = anon_sym_BSLASHGlssymbol,
  [anon_sym_BSLASHglsdesc] = anon_sym_BSLASHglsdesc,
  [anon_sym_BSLASHGlsdesc] = anon_sym_BSLASHGlsdesc,
  [anon_sym_BSLASHGLSdesc] = anon_sym_BSLASHGLSdesc,
  [anon_sym_BSLASHglsuseri] = anon_sym_BSLASHglsuseri,
  [anon_sym_BSLASHGlsuseri] = anon_sym_BSLASHGlsuseri,
  [anon_sym_BSLASHGLSuseri] = anon_sym_BSLASHGLSuseri,
  [anon_sym_BSLASHglsuserii] = anon_sym_BSLASHglsuserii,
  [anon_sym_BSLASHGlsuserii] = anon_sym_BSLASHGlsuserii,
  [anon_sym_BSLASHGLSuserii] = anon_sym_BSLASHGLSuserii,
  [anon_sym_BSLASHglsuseriii] = anon_sym_BSLASHglsuseriii,
  [anon_sym_BSLASHGlsuseriii] = anon_sym_BSLASHGlsuseriii,
  [anon_sym_BSLASHGLSuseriii] = anon_sym_BSLASHGLSuseriii,
  [anon_sym_BSLASHglsuseriv] = anon_sym_BSLASHglsuseriv,
  [anon_sym_BSLASHGlsuseriv] = anon_sym_BSLASHGlsuseriv,
  [anon_sym_BSLASHGLSuseriv] = anon_sym_BSLASHGLSuseriv,
  [anon_sym_BSLASHglsuserv] = anon_sym_BSLASHglsuserv,
  [anon_sym_BSLASHGlsuserv] = anon_sym_BSLASHGlsuserv,
  [anon_sym_BSLASHGLSuserv] = anon_sym_BSLASHGLSuserv,
  [anon_sym_BSLASHglsuservi] = anon_sym_BSLASHglsuservi,
  [anon_sym_BSLASHGlsuservi] = anon_sym_BSLASHGlsuservi,
  [anon_sym_BSLASHGLSuservi] = anon_sym_BSLASHGLSuservi,
  [anon_sym_BSLASHnewacronym] = anon_sym_BSLASHnewacronym,
  [anon_sym_BSLASHacrshort] = anon_sym_BSLASHacrshort,
  [anon_sym_BSLASHAcrshort] = anon_sym_BSLASHAcrshort,
  [anon_sym_BSLASHACRshort] = anon_sym_BSLASHACRshort,
  [anon_sym_BSLASHacrshortpl] = anon_sym_BSLASHacrshortpl,
  [anon_sym_BSLASHAcrshortpl] = anon_sym_BSLASHAcrshortpl,
  [anon_sym_BSLASHACRshortpl] = anon_sym_BSLASHACRshortpl,
  [anon_sym_BSLASHacrlong] = anon_sym_BSLASHacrlong,
  [anon_sym_BSLASHAcrlong] = anon_sym_BSLASHAcrlong,
  [anon_sym_BSLASHACRlong] = anon_sym_BSLASHACRlong,
  [anon_sym_BSLASHacrlongpl] = anon_sym_BSLASHacrlongpl,
  [anon_sym_BSLASHAcrlongpl] = anon_sym_BSLASHAcrlongpl,
  [anon_sym_BSLASHACRlongpl] = anon_sym_BSLASHACRlongpl,
  [anon_sym_BSLASHacrfull] = anon_sym_BSLASHacrfull,
  [anon_sym_BSLASHAcrfull] = anon_sym_BSLASHAcrfull,
  [anon_sym_BSLASHACRfull] = anon_sym_BSLASHACRfull,
  [anon_sym_BSLASHacrfullpl] = anon_sym_BSLASHacrfullpl,
  [anon_sym_BSLASHAcrfullpl] = anon_sym_BSLASHAcrfullpl,
  [anon_sym_BSLASHACRfullpl] = anon_sym_BSLASHACRfullpl,
  [anon_sym_BSLASHacs] = anon_sym_BSLASHacs,
  [anon_sym_BSLASHAcs] = anon_sym_BSLASHAcs,
  [anon_sym_BSLASHacsp] = anon_sym_BSLASHacsp,
  [anon_sym_BSLASHAcsp] = anon_sym_BSLASHAcsp,
  [anon_sym_BSLASHacl] = anon_sym_BSLASHacl,
  [anon_sym_BSLASHAcl] = anon_sym_BSLASHAcl,
  [anon_sym_BSLASHaclp] = anon_sym_BSLASHaclp,
  [anon_sym_BSLASHAclp] = anon_sym_BSLASHAclp,
  [anon_sym_BSLASHacf] = anon_sym_BSLASHacf,
  [anon_sym_BSLASHAcf] = anon_sym_BSLASHAcf,
  [anon_sym_BSLASHacfp] = anon_sym_BSLASHacfp,
  [anon_sym_BSLASHAcfp] = anon_sym_BSLASHAcfp,
  [anon_sym_BSLASHac] = anon_sym_BSLASHac,
  [anon_sym_BSLASHAc] = anon_sym_BSLASHAc,
  [anon_sym_BSLASHacp] = anon_sym_BSLASHacp,
  [anon_sym_BSLASHglsentrylong] = anon_sym_BSLASHglsentrylong,
  [anon_sym_BSLASHGlsentrylong] = anon_sym_BSLASHGlsentrylong,
  [anon_sym_BSLASHglsentrylongpl] = anon_sym_BSLASHglsentrylongpl,
  [anon_sym_BSLASHGlsentrylongpl] = anon_sym_BSLASHGlsentrylongpl,
  [anon_sym_BSLASHglsentryshort] = anon_sym_BSLASHglsentryshort,
  [anon_sym_BSLASHGlsentryshort] = anon_sym_BSLASHGlsentryshort,
  [anon_sym_BSLASHglsentryshortpl] = anon_sym_BSLASHglsentryshortpl,
  [anon_sym_BSLASHGlsentryshortpl] = anon_sym_BSLASHGlsentryshortpl,
  [anon_sym_BSLASHglsentryfullpl] = anon_sym_BSLASHglsentryfullpl,
  [anon_sym_BSLASHGlsentryfullpl] = anon_sym_BSLASHGlsentryfullpl,
  [anon_sym_BSLASHnewtheorem] = anon_sym_BSLASHnewtheorem,
  [anon_sym_BSLASHnewtheorem_STAR] = anon_sym_BSLASHnewtheorem_STAR,
  [anon_sym_BSLASHdeclaretheorem] = anon_sym_BSLASHdeclaretheorem,
  [anon_sym_BSLASHdeclaretheorem_STAR] = anon_sym_BSLASHdeclaretheorem_STAR,
  [anon_sym_BSLASHdefinecolor] = anon_sym_BSLASHdefinecolor,
  [anon_sym_BSLASHdefinecolorset] = anon_sym_BSLASHdefinecolorset,
  [anon_sym_BSLASHcolor] = anon_sym_BSLASHcolor,
  [anon_sym_BSLASHcolorbox] = anon_sym_BSLASHcolorbox,
  [anon_sym_BSLASHtextcolor] = anon_sym_BSLASHtextcolor,
  [anon_sym_BSLASHpagecolor] = anon_sym_BSLASHpagecolor,
  [anon_sym_BSLASHusepgflibrary] = anon_sym_BSLASHusepgflibrary,
  [anon_sym_BSLASHusetikzlibrary] = anon_sym_BSLASHusetikzlibrary,
  [anon_sym_BSLASHtext] = anon_sym_BSLASHtext,
  [anon_sym_BSLASHintertext] = anon_sym_BSLASHintertext,
  [anon_sym_shortintertext] = anon_sym_shortintertext,
  [sym__trivia_raw_fi] = sym__trivia_raw_fi,
  [sym__trivia_raw_env_comment] = sym__trivia_raw_fi,
  [sym__trivia_raw_env_verbatim] = sym__trivia_raw_fi,
  [sym__trivia_raw_env_listing] = sym__trivia_raw_env_listing,
  [sym__trivia_raw_env_minted] = sym__trivia_raw_env_listing,
  [sym__trivia_raw_env_pycode] = sym__trivia_raw_env_listing,
  [sym_source_file] = sym_source_file,
  [sym_block_comment] = sym_block_comment,
  [sym__root_content] = sym__root_content,
  [sym__flat_content] = sym__flat_content,
  [sym__text_with_env_content] = sym__text_with_env_content,
  [sym__text_content] = sym__text_content,
  [sym__section] = sym__section,
  [sym__section_part] = sym__section_part,
  [sym__part_declaration] = sym__part_declaration,
  [sym_part] = sym_part,
  [sym__chapter_declaration] = sym__chapter_declaration,
  [sym_chapter] = sym_chapter,
  [sym__section_declaration] = sym__section_declaration,
  [sym_section] = sym_section,
  [sym__subsection_declaration] = sym__subsection_declaration,
  [sym_subsection] = sym_subsection,
  [sym__subsubsection_declaration] = sym__subsubsection_declaration,
  [sym_subsubsection] = sym_subsubsection,
  [sym__paragraph_declaration] = sym__paragraph_declaration,
  [sym_paragraph] = sym_paragraph,
  [sym__subparagraph_declaration] = sym__subparagraph_declaration,
  [sym_subparagraph] = sym_subparagraph,
  [sym__enum_itemdeclaration] = sym__enum_itemdeclaration,
  [sym_enum_item] = sym_enum_item,
  [sym_curly_group] = sym_curly_group,
  [sym_curly_group_text] = sym_curly_group_text,
  [sym_curly_group_text_list] = sym_curly_group_text_list,
  [sym_curly_group_path] = sym_curly_group_path,
  [sym_curly_group_path_list] = sym_curly_group_path_list,
  [sym_curly_group_command_name] = sym_curly_group_command_name,
  [sym_curly_group_key_value] = sym_curly_group_key_value,
  [sym_curly_group_glob_pattern] = sym_curly_group_glob_pattern,
  [sym_curly_group_impl] = sym_curly_group_impl,
  [sym_curly_group_author_list] = sym_curly_group_author_list,
  [sym_brack_group] = sym_brack_group,
  [sym_brack_group_text] = sym_brack_group_text,
  [sym_brack_group_argc] = sym_brack_group_argc,
  [sym_brack_group_key_value] = sym_brack_group_key_value,
  [sym_text] = sym_text,
  [sym_glob_pattern] = sym_glob_pattern,
  [sym__glob_pattern_fragment] = sym__glob_pattern_fragment,
  [sym_operator] = sym_operator,
  [sym_subscript] = sym_subscript,
  [sym_superscript] = sym_superscript,
  [sym_key_value_pair] = sym_key_value_pair,
  [sym_value] = sym_value,
  [sym_displayed_equation] = sym_displayed_equation,
  [sym_inline_formula] = sym_inline_formula,
  [sym_begin] = sym_begin,
  [sym_end] = sym_end,
  [sym_generic_environment] = sym_generic_environment,
  [sym_comment_environment] = sym_comment_environment,
  [sym__comment_environment_begin] = sym_begin,
  [sym__comment_environment_end] = sym_end,
  [sym__comment_environment_group] = sym_curly_group_text,
  [sym__comment_environment_name] = sym_text,
  [sym_verbatim_environment] = sym_verbatim_environment,
  [sym__verbatim_environment_begin] = sym_begin,
  [sym__verbatim_environment_end] = sym_end,
  [sym__verbatim_environment_group] = sym_curly_group_text,
  [sym__verbatim_environment_name] = sym_text,
  [sym_listing_environment] = sym_listing_environment,
  [sym__listing_environment_begin] = sym_begin,
  [sym__listing_environment_end] = sym_end,
  [sym__listing_environment_group] = sym_curly_group_text,
  [sym__listing_environment_name] = sym_text,
  [sym_minted_environment] = sym_minted_environment,
  [sym__minted_environment_begin] = sym_begin,
  [sym__minted_environment_end] = sym_end,
  [sym__minted_environment_group] = sym_curly_group_text,
  [sym__minted_environment_name] = sym_text,
  [sym_pycode_environment] = sym_pycode_environment,
  [sym__pycode_environment_begin] = sym_begin,
  [sym__pycode_environment_end] = sym_end,
  [sym__pycode_environment_group] = sym_curly_group_text,
  [sym__pycode_environment_name] = sym_text,
  [sym_math_environment] = sym_math_environment,
  [sym__math_environment_begin] = sym_begin,
  [sym__math_environment_end] = sym_end,
  [sym__math_environment_group] = sym_curly_group_text,
  [sym__math_environment_name] = sym_text,
  [sym__command] = sym__command,
  [sym_generic_command] = sym_generic_command,
  [sym_title_declaration] = sym_title_declaration,
  [sym_author_declaration] = sym_author_declaration,
  [sym_package_include] = sym_package_include,
  [sym_class_include] = sym_class_include,
  [sym_latex_include] = sym_latex_include,
  [sym_biblatex_include] = sym_biblatex_include,
  [sym_bibtex_include] = sym_bibtex_include,
  [sym_graphics_include] = sym_graphics_include,
  [sym_svg_include] = sym_svg_include,
  [sym_inkscape_include] = sym_inkscape_include,
  [sym_verbatim_include] = sym_verbatim_include,
  [sym_import_include] = sym_import_include,
  [sym_caption] = sym_caption,
  [sym_citation] = sym_citation,
  [sym_label_definition] = sym_label_definition,
  [sym_label_reference] = sym_label_reference,
  [sym_label_reference_range] = sym_label_reference_range,
  [sym_label_number] = sym_label_number,
  [sym_new_command_definition] = sym_new_command_definition,
  [sym_old_command_definition] = sym_old_command_definition,
  [sym_let_command_definition] = sym_let_command_definition,
  [sym__math_delimiter_part] = sym__math_delimiter_part,
  [sym_math_delimiter] = sym_math_delimiter,
  [sym_paired_delimiter_definition] = sym_paired_delimiter_definition,
  [sym_environment_definition] = sym_environment_definition,
  [sym_glossary_entry_definition] = sym_glossary_entry_definition,
  [sym_glossary_entry_reference] = sym_glossary_entry_reference,
  [sym_acronym_definition] = sym_acronym_definition,
  [sym_acronym_reference] = sym_acronym_reference,
  [sym_theorem_definition] = sym_theorem_definition,
  [sym_color_definition] = sym_color_definition,
  [sym_color_set_definition] = sym_color_set_definition,
  [sym_color_reference] = sym_color_reference,
  [sym_tikz_library_import] = sym_tikz_library_import,
  [sym_text_mode] = sym_text_mode,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym__section_repeat1] = aux_sym__section_repeat1,
  [aux_sym__section_repeat2] = aux_sym__section_repeat2,
  [aux_sym__section_repeat3] = aux_sym__section_repeat3,
  [aux_sym__section_repeat4] = aux_sym__section_repeat4,
  [aux_sym__section_repeat5] = aux_sym__section_repeat5,
  [aux_sym__section_repeat6] = aux_sym__section_repeat6,
  [aux_sym__section_repeat7] = aux_sym__section_repeat7,
  [aux_sym__section_repeat8] = aux_sym__section_repeat8,
  [aux_sym_part_repeat1] = aux_sym_part_repeat1,
  [aux_sym_curly_group_text_list_repeat1] = aux_sym_curly_group_text_list_repeat1,
  [aux_sym_curly_group_path_list_repeat1] = aux_sym_curly_group_path_list_repeat1,
  [aux_sym_curly_group_key_value_repeat1] = aux_sym_curly_group_key_value_repeat1,
  [aux_sym_curly_group_impl_repeat1] = aux_sym_curly_group_impl_repeat1,
  [aux_sym_curly_group_author_list_repeat1] = aux_sym_curly_group_author_list_repeat1,
  [aux_sym_curly_group_author_list_repeat2] = aux_sym_curly_group_author_list_repeat2,
  [aux_sym_brack_group_repeat1] = aux_sym_brack_group_repeat1,
  [aux_sym_text_repeat1] = aux_sym_text_repeat1,
  [aux_sym_glob_pattern_repeat1] = aux_sym_glob_pattern_repeat1,
  [aux_sym_value_repeat1] = aux_sym_value_repeat1,
  [aux_sym_generic_command_repeat1] = aux_sym_generic_command_repeat1,
  [alias_sym_author] = alias_sym_author,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_command_name] = {
    .visible = true,
    .named = true,
  },
  [sym__whitespace] = {
    .visible = false,
    .named = true,
  },
  [sym_line_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASHiffalse] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHfi] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHpart] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHpart_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHaddpart] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHaddpart_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHchapter] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHchapter_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHaddchap] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHaddchap_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsection] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsection_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHaddsec] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHaddsec_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsubsection] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsubsection_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsubsubsection] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsubsubsection_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHparagraph] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHparagraph_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsubparagraph] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsubparagraph_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHitem] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHitem_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHand] = {
    .visible = true,
    .named = true,
  },
  [sym_word] = {
    .visible = true,
    .named = true,
  },
  [sym_placeholder] = {
    .visible = true,
    .named = true,
  },
  [sym_path] = {
    .visible = true,
    .named = true,
  },
  [sym_argc] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__glob_pattern_fragment_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASH_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASH_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASH_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASH_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHbegin] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHend] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_verbatim] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_lstlisting] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_minted] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_pycode] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_displaymath] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_displaymath_STAR] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_equation] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_equation_STAR] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_multline] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_multline_STAR] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_eqnarray] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_eqnarray_STAR] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_align] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_align_STAR] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_array] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_array_STAR] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_split] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_split_STAR] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_alignat] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_alignat_STAR] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_gather] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_gather_STAR] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_flalign] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_flalign_STAR] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASHtitle] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHauthor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHusepackage] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHRequirePackage] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHdocumentclass] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHinclude] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsubfileinclude] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHinput] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsubfile] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHaddbibresource] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHbibliography] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHincludegraphics] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHincludesvg] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHincludeinkscape] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHverbatiminput] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHVerbatimInput] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHimport] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsubimport] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHinputfrom] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsubimportfrom] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHincludefrom] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsubincludefrom] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcaption] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcite_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHCite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHnocite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcitet] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcitep] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcitet_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcitep_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHciteauthor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHciteauthor_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHCiteauthor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHCiteauthor_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcitetitle] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcitetitle_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHciteyear] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHciteyear_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcitedate] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcitedate_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHciteurl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHfullcite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHciteyearpar] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcitealt] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcitealp] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcitetext] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHparencite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHparencite_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHParencite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHfootcite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHfootfullcite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHfootcitetext] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHtextcite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHTextcite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsmartcite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHSmartcite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsupercite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHautocite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHAutocite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHautocite_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHAutocite_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHvolcite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHVolcite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHpvolcite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHPvolcite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHfvolcite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHftvolcite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHsvolcite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHSvolcite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHtvolcite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHTvolcite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHavolcite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHAvolcite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHnotecite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHNotecite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHpnotecite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHPnotecite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHfnotecite] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHlabel] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHref] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHeqref] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHvref] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHVref] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHautoref] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHpageref] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcref] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHCref] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcref_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHCref_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHnamecref] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHnameCref] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHlcnamecref] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHnamecrefs] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHnameCrefs] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHlcnamecrefs] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHlabelcref] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHlabelcpageref] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcrefrange] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcrefrange_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHCrefrange] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHCrefrange_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHnewlabel] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHnewcommand] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHnewcommand_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHrenewcommand] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHrenewcommand_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHDeclareRobustCommand] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHDeclareRobustCommand_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHDeclareMathOperator] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHDeclareMathOperator_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHNewDocumentCommand] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHRenewDocumentCommand] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHProvideDocumentCommand] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHDeclareDocumentCommand] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHNewExpandableDocumentCommand] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHRenewExpandableDocumentCommand] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHProvideExpandableDocumentCommand] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHDeclareExpandableDocumentCommand] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHdef] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHlet] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHleft] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHbig] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHBig] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHbigg] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHBigg] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHbigl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHBigl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHbiggl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHBiggl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHright] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHbigr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHBigr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHbiggr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHBiggr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHDeclarePairedDelimiter] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHDeclarePairedDelimiterX] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHnewenvironment] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHrenewenvironment] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHNewDocumentEnvironment] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHRenewDocumentEnvironment] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHProvideDocumentEnvironment] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHDeclareDocumentEnvironment] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHnewglossaryentry] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHgls] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGls] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGLS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHglspl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGlspl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGLSpl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHglsdisp] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHglslink] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHglstext] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGlstext] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGLStext] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHglsfirst] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGlsfirst] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGLSfirst] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHglsplural] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGlsplural] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGLSplural] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHglsfirstplural] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGlsfirstplural] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGLSfirstplural] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHglsname] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGlsname] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGLSname] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHglssymbol] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGlssymbol] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHglsdesc] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGlsdesc] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGLSdesc] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHglsuseri] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGlsuseri] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGLSuseri] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHglsuserii] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGlsuserii] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGLSuserii] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHglsuseriii] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGlsuseriii] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGLSuseriii] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHglsuseriv] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGlsuseriv] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGLSuseriv] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHglsuserv] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGlsuserv] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGLSuserv] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHglsuservi] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGlsuservi] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGLSuservi] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHnewacronym] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHacrshort] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHAcrshort] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHACRshort] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHacrshortpl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHAcrshortpl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHACRshortpl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHacrlong] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHAcrlong] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHACRlong] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHacrlongpl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHAcrlongpl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHACRlongpl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHacrfull] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHAcrfull] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHACRfull] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHacrfullpl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHAcrfullpl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHACRfullpl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHacs] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHAcs] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHacsp] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHAcsp] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHacl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHAcl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHaclp] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHAclp] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHacf] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHAcf] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHacfp] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHAcfp] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHac] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHAc] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHacp] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHglsentrylong] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGlsentrylong] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHglsentrylongpl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGlsentrylongpl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHglsentryshort] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGlsentryshort] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHglsentryshortpl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGlsentryshortpl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHglsentryfullpl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHGlsentryfullpl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHnewtheorem] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHnewtheorem_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHdeclaretheorem] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHdeclaretheorem_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHdefinecolor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHdefinecolorset] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcolor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHcolorbox] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHtextcolor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHpagecolor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHusepgflibrary] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHusetikzlibrary] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHtext] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHintertext] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_shortintertext] = {
    .visible = true,
    .named = false,
  },
  [sym__trivia_raw_fi] = {
    .visible = true,
    .named = true,
  },
  [sym__trivia_raw_env_comment] = {
    .visible = true,
    .named = true,
  },
  [sym__trivia_raw_env_verbatim] = {
    .visible = true,
    .named = true,
  },
  [sym__trivia_raw_env_listing] = {
    .visible = true,
    .named = true,
  },
  [sym__trivia_raw_env_minted] = {
    .visible = true,
    .named = true,
  },
  [sym__trivia_raw_env_pycode] = {
    .visible = true,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym_block_comment] = {
    .visible = true,
    .named = true,
  },
  [sym__root_content] = {
    .visible = false,
    .named = true,
  },
  [sym__flat_content] = {
    .visible = false,
    .named = true,
  },
  [sym__text_with_env_content] = {
    .visible = false,
    .named = true,
  },
  [sym__text_content] = {
    .visible = false,
    .named = true,
  },
  [sym__section] = {
    .visible = false,
    .named = true,
  },
  [sym__section_part] = {
    .visible = false,
    .named = true,
  },
  [sym__part_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_part] = {
    .visible = true,
    .named = true,
  },
  [sym__chapter_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_chapter] = {
    .visible = true,
    .named = true,
  },
  [sym__section_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_section] = {
    .visible = true,
    .named = true,
  },
  [sym__subsection_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_subsection] = {
    .visible = true,
    .named = true,
  },
  [sym__subsubsection_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_subsubsection] = {
    .visible = true,
    .named = true,
  },
  [sym__paragraph_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_paragraph] = {
    .visible = true,
    .named = true,
  },
  [sym__subparagraph_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_subparagraph] = {
    .visible = true,
    .named = true,
  },
  [sym__enum_itemdeclaration] = {
    .visible = false,
    .named = true,
  },
  [sym_enum_item] = {
    .visible = true,
    .named = true,
  },
  [sym_curly_group] = {
    .visible = true,
    .named = true,
  },
  [sym_curly_group_text] = {
    .visible = true,
    .named = true,
  },
  [sym_curly_group_text_list] = {
    .visible = true,
    .named = true,
  },
  [sym_curly_group_path] = {
    .visible = true,
    .named = true,
  },
  [sym_curly_group_path_list] = {
    .visible = true,
    .named = true,
  },
  [sym_curly_group_command_name] = {
    .visible = true,
    .named = true,
  },
  [sym_curly_group_key_value] = {
    .visible = true,
    .named = true,
  },
  [sym_curly_group_glob_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_curly_group_impl] = {
    .visible = true,
    .named = true,
  },
  [sym_curly_group_author_list] = {
    .visible = true,
    .named = true,
  },
  [sym_brack_group] = {
    .visible = true,
    .named = true,
  },
  [sym_brack_group_text] = {
    .visible = true,
    .named = true,
  },
  [sym_brack_group_argc] = {
    .visible = true,
    .named = true,
  },
  [sym_brack_group_key_value] = {
    .visible = true,
    .named = true,
  },
  [sym_text] = {
    .visible = true,
    .named = true,
  },
  [sym_glob_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym__glob_pattern_fragment] = {
    .visible = false,
    .named = true,
  },
  [sym_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript] = {
    .visible = true,
    .named = true,
  },
  [sym_superscript] = {
    .visible = true,
    .named = true,
  },
  [sym_key_value_pair] = {
    .visible = true,
    .named = true,
  },
  [sym_value] = {
    .visible = true,
    .named = true,
  },
  [sym_displayed_equation] = {
    .visible = true,
    .named = true,
  },
  [sym_inline_formula] = {
    .visible = true,
    .named = true,
  },
  [sym_begin] = {
    .visible = true,
    .named = true,
  },
  [sym_end] = {
    .visible = true,
    .named = true,
  },
  [sym_generic_environment] = {
    .visible = true,
    .named = true,
  },
  [sym_comment_environment] = {
    .visible = true,
    .named = true,
  },
  [sym__comment_environment_begin] = {
    .visible = true,
    .named = true,
  },
  [sym__comment_environment_end] = {
    .visible = true,
    .named = true,
  },
  [sym__comment_environment_group] = {
    .visible = true,
    .named = true,
  },
  [sym__comment_environment_name] = {
    .visible = true,
    .named = true,
  },
  [sym_verbatim_environment] = {
    .visible = true,
    .named = true,
  },
  [sym__verbatim_environment_begin] = {
    .visible = true,
    .named = true,
  },
  [sym__verbatim_environment_end] = {
    .visible = true,
    .named = true,
  },
  [sym__verbatim_environment_group] = {
    .visible = true,
    .named = true,
  },
  [sym__verbatim_environment_name] = {
    .visible = true,
    .named = true,
  },
  [sym_listing_environment] = {
    .visible = true,
    .named = true,
  },
  [sym__listing_environment_begin] = {
    .visible = true,
    .named = true,
  },
  [sym__listing_environment_end] = {
    .visible = true,
    .named = true,
  },
  [sym__listing_environment_group] = {
    .visible = true,
    .named = true,
  },
  [sym__listing_environment_name] = {
    .visible = true,
    .named = true,
  },
  [sym_minted_environment] = {
    .visible = true,
    .named = true,
  },
  [sym__minted_environment_begin] = {
    .visible = true,
    .named = true,
  },
  [sym__minted_environment_end] = {
    .visible = true,
    .named = true,
  },
  [sym__minted_environment_group] = {
    .visible = true,
    .named = true,
  },
  [sym__minted_environment_name] = {
    .visible = true,
    .named = true,
  },
  [sym_pycode_environment] = {
    .visible = true,
    .named = true,
  },
  [sym__pycode_environment_begin] = {
    .visible = true,
    .named = true,
  },
  [sym__pycode_environment_end] = {
    .visible = true,
    .named = true,
  },
  [sym__pycode_environment_group] = {
    .visible = true,
    .named = true,
  },
  [sym__pycode_environment_name] = {
    .visible = true,
    .named = true,
  },
  [sym_math_environment] = {
    .visible = true,
    .named = true,
  },
  [sym__math_environment_begin] = {
    .visible = true,
    .named = true,
  },
  [sym__math_environment_end] = {
    .visible = true,
    .named = true,
  },
  [sym__math_environment_group] = {
    .visible = true,
    .named = true,
  },
  [sym__math_environment_name] = {
    .visible = true,
    .named = true,
  },
  [sym__command] = {
    .visible = false,
    .named = true,
  },
  [sym_generic_command] = {
    .visible = true,
    .named = true,
  },
  [sym_title_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_author_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_package_include] = {
    .visible = true,
    .named = true,
  },
  [sym_class_include] = {
    .visible = true,
    .named = true,
  },
  [sym_latex_include] = {
    .visible = true,
    .named = true,
  },
  [sym_biblatex_include] = {
    .visible = true,
    .named = true,
  },
  [sym_bibtex_include] = {
    .visible = true,
    .named = true,
  },
  [sym_graphics_include] = {
    .visible = true,
    .named = true,
  },
  [sym_svg_include] = {
    .visible = true,
    .named = true,
  },
  [sym_inkscape_include] = {
    .visible = true,
    .named = true,
  },
  [sym_verbatim_include] = {
    .visible = true,
    .named = true,
  },
  [sym_import_include] = {
    .visible = true,
    .named = true,
  },
  [sym_caption] = {
    .visible = true,
    .named = true,
  },
  [sym_citation] = {
    .visible = true,
    .named = true,
  },
  [sym_label_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_label_reference] = {
    .visible = true,
    .named = true,
  },
  [sym_label_reference_range] = {
    .visible = true,
    .named = true,
  },
  [sym_label_number] = {
    .visible = true,
    .named = true,
  },
  [sym_new_command_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_old_command_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_let_command_definition] = {
    .visible = true,
    .named = true,
  },
  [sym__math_delimiter_part] = {
    .visible = false,
    .named = true,
  },
  [sym_math_delimiter] = {
    .visible = true,
    .named = true,
  },
  [sym_paired_delimiter_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_environment_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_glossary_entry_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_glossary_entry_reference] = {
    .visible = true,
    .named = true,
  },
  [sym_acronym_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_acronym_reference] = {
    .visible = true,
    .named = true,
  },
  [sym_theorem_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_color_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_color_set_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_color_reference] = {
    .visible = true,
    .named = true,
  },
  [sym_tikz_library_import] = {
    .visible = true,
    .named = true,
  },
  [sym_text_mode] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__section_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__section_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__section_repeat3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__section_repeat4] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__section_repeat5] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__section_repeat6] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__section_repeat7] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__section_repeat8] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_part_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_curly_group_text_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_curly_group_path_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_curly_group_key_value_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_curly_group_impl_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_curly_group_author_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_curly_group_author_list_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_brack_group_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_text_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_glob_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_value_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_generic_command_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_author] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_arg = 1,
  field_argc = 2,
  field_authors = 3,
  field_begin = 4,
  field_body = 5,
  field_code = 6,
  field_command = 7,
  field_comment = 8,
  field_content = 9,
  field_counter = 10,
  field_declaration = 11,
  field_default = 12,
  field_directory = 13,
  field_end = 14,
  field_file = 15,
  field_from = 16,
  field_glob = 17,
  field_head = 18,
  field_implementation = 19,
  field_key = 20,
  field_keys = 21,
  field_label = 22,
  field_language = 23,
  field_left = 24,
  field_left_command = 25,
  field_left_delimiter = 26,
  field_long = 27,
  field_model = 28,
  field_name = 29,
  field_names = 30,
  field_number = 31,
  field_options = 32,
  field_pair = 33,
  field_path = 34,
  field_paths = 35,
  field_pattern = 36,
  field_postnote = 37,
  field_prenote = 38,
  field_right = 39,
  field_right_command = 40,
  field_right_delimiter = 41,
  field_short = 42,
  field_spec = 43,
  field_subscript = 44,
  field_superscript = 45,
  field_tail = 46,
  field_text = 47,
  field_title = 48,
  field_to = 49,
  field_toc = 50,
  field_ty = 51,
  field_value = 52,
  field_verbatim = 53,
  field_word = 54,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_arg] = "arg",
  [field_argc] = "argc",
  [field_authors] = "authors",
  [field_begin] = "begin",
  [field_body] = "body",
  [field_code] = "code",
  [field_command] = "command",
  [field_comment] = "comment",
  [field_content] = "content",
  [field_counter] = "counter",
  [field_declaration] = "declaration",
  [field_default] = "default",
  [field_directory] = "directory",
  [field_end] = "end",
  [field_file] = "file",
  [field_from] = "from",
  [field_glob] = "glob",
  [field_head] = "head",
  [field_implementation] = "implementation",
  [field_key] = "key",
  [field_keys] = "keys",
  [field_label] = "label",
  [field_language] = "language",
  [field_left] = "left",
  [field_left_command] = "left_command",
  [field_left_delimiter] = "left_delimiter",
  [field_long] = "long",
  [field_model] = "model",
  [field_name] = "name",
  [field_names] = "names",
  [field_number] = "number",
  [field_options] = "options",
  [field_pair] = "pair",
  [field_path] = "path",
  [field_paths] = "paths",
  [field_pattern] = "pattern",
  [field_postnote] = "postnote",
  [field_prenote] = "prenote",
  [field_right] = "right",
  [field_right_command] = "right_command",
  [field_right_delimiter] = "right_delimiter",
  [field_short] = "short",
  [field_spec] = "spec",
  [field_subscript] = "subscript",
  [field_superscript] = "superscript",
  [field_tail] = "tail",
  [field_text] = "text",
  [field_title] = "title",
  [field_to] = "to",
  [field_toc] = "toc",
  [field_ty] = "ty",
  [field_value] = "value",
  [field_verbatim] = "verbatim",
  [field_word] = "word",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 1},
  [3] = {.index = 2, .length = 1},
  [4] = {.index = 3, .length = 3},
  [5] = {.index = 6, .length = 2},
  [6] = {.index = 8, .length = 1},
  [7] = {.index = 9, .length = 2},
  [8] = {.index = 11, .length = 2},
  [9] = {.index = 13, .length = 3},
  [10] = {.index = 16, .length = 1},
  [11] = {.index = 17, .length = 2},
  [12] = {.index = 19, .length = 1},
  [13] = {.index = 20, .length = 1},
  [14] = {.index = 21, .length = 2},
  [15] = {.index = 23, .length = 3},
  [16] = {.index = 26, .length = 1},
  [17] = {.index = 27, .length = 2},
  [18] = {.index = 29, .length = 2},
  [19] = {.index = 31, .length = 2},
  [20] = {.index = 33, .length = 2},
  [21] = {.index = 35, .length = 2},
  [22] = {.index = 37, .length = 1},
  [23] = {.index = 38, .length = 2},
  [24] = {.index = 40, .length = 2},
  [25] = {.index = 42, .length = 2},
  [26] = {.index = 44, .length = 2},
  [27] = {.index = 46, .length = 2},
  [28] = {.index = 48, .length = 6},
  [29] = {.index = 54, .length = 2},
  [30] = {.index = 56, .length = 3},
  [31] = {.index = 59, .length = 2},
  [32] = {.index = 61, .length = 3},
  [33] = {.index = 64, .length = 4},
  [34] = {.index = 68, .length = 2},
  [35] = {.index = 70, .length = 3},
  [36] = {.index = 73, .length = 1},
  [37] = {.index = 74, .length = 3},
  [38] = {.index = 77, .length = 3},
  [39] = {.index = 80, .length = 2},
  [40] = {.index = 82, .length = 3},
  [41] = {.index = 85, .length = 3},
  [42] = {.index = 88, .length = 3},
  [43] = {.index = 91, .length = 3},
  [44] = {.index = 94, .length = 3},
  [45] = {.index = 97, .length = 3},
  [46] = {.index = 100, .length = 3},
  [47] = {.index = 103, .length = 3},
  [48] = {.index = 106, .length = 2},
  [49] = {.index = 108, .length = 7},
  [50] = {.index = 115, .length = 7},
  [51] = {.index = 122, .length = 7},
  [52] = {.index = 129, .length = 9},
  [53] = {.index = 138, .length = 6},
  [54] = {.index = 144, .length = 1},
  [55] = {.index = 145, .length = 2},
  [56] = {.index = 147, .length = 5},
  [58] = {.index = 152, .length = 1},
  [59] = {.index = 153, .length = 1},
  [60] = {.index = 154, .length = 1},
  [61] = {.index = 155, .length = 4},
  [62] = {.index = 159, .length = 1},
  [63] = {.index = 160, .length = 4},
  [64] = {.index = 164, .length = 3},
  [65] = {.index = 167, .length = 4},
  [66] = {.index = 171, .length = 4},
  [67] = {.index = 175, .length = 4},
  [68] = {.index = 179, .length = 4},
  [69] = {.index = 183, .length = 4},
  [70] = {.index = 187, .length = 4},
  [71] = {.index = 191, .length = 4},
  [72] = {.index = 195, .length = 4},
  [73] = {.index = 199, .length = 2},
  [74] = {.index = 201, .length = 2},
  [75] = {.index = 203, .length = 2},
  [76] = {.index = 205, .length = 2},
  [77] = {.index = 207, .length = 2},
  [78] = {.index = 209, .length = 2},
  [79] = {.index = 211, .length = 2},
  [80] = {.index = 213, .length = 1},
  [81] = {.index = 214, .length = 5},
  [82] = {.index = 219, .length = 4},
  [83] = {.index = 223, .length = 5},
  [84] = {.index = 228, .length = 5},
  [85] = {.index = 233, .length = 5},
  [86] = {.index = 238, .length = 5},
  [87] = {.index = 243, .length = 5},
  [88] = {.index = 248, .length = 5},
  [89] = {.index = 253, .length = 4},
  [90] = {.index = 257, .length = 5},
  [91] = {.index = 262, .length = 6},
  [92] = {.index = 268, .length = 6},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_begin, 0},
  [1] =
    {field_command, 0},
  [2] =
    {field_word, 0},
  [3] =
    {field_command, 0, .inherited = true},
    {field_text, 0, .inherited = true},
    {field_toc, 0, .inherited = true},
  [6] =
    {field_command, 0, .inherited = true},
    {field_label, 0, .inherited = true},
  [8] =
    {field_word, 0, .inherited = true},
  [9] =
    {field_begin, 0},
    {field_comment, 1},
  [11] =
    {field_begin, 0},
    {field_end, 1},
  [13] =
    {field_command, 0},
    {field_text, 1, .inherited = true},
    {field_toc, 1, .inherited = true},
  [16] =
    {field_text, 0},
  [17] =
    {field_command, 0},
    {field_label, 1},
  [19] =
    {field_subscript, 1},
  [20] =
    {field_superscript, 1},
  [21] =
    {field_command, 0},
    {field_name, 1},
  [23] =
    {field_command, 0},
    {field_name, 1},
    {field_text, 1, .inherited = true},
  [26] =
    {field_arg, 0},
  [27] =
    {field_arg, 1, .inherited = true},
    {field_command, 0},
  [29] =
    {field_command, 0},
    {field_text, 1},
  [31] =
    {field_authors, 1},
    {field_command, 0},
  [33] =
    {field_command, 0},
    {field_paths, 1},
  [35] =
    {field_command, 0},
    {field_path, 1},
  [37] =
    {field_glob, 1},
  [38] =
    {field_command, 0},
    {field_long, 1},
  [40] =
    {field_command, 0},
    {field_keys, 1},
  [42] =
    {field_command, 0},
    {field_names, 1},
  [44] =
    {field_command, 0},
    {field_declaration, 1},
  [46] =
    {field_command, 0},
    {field_content, 1},
  [48] =
    {field_begin, 0},
    {field_command, 0, .inherited = true},
    {field_command, 1, .inherited = true},
    {field_end, 1},
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
  [54] =
    {field_word, 0, .inherited = true},
    {field_word, 1, .inherited = true},
  [56] =
    {field_begin, 0},
    {field_comment, 1},
    {field_end, 2},
  [59] =
    {field_text, 1},
    {field_toc, 0},
  [61] =
    {field_command, 0},
    {field_name, 1},
    {field_options, 2},
  [64] =
    {field_command, 0},
    {field_language, 2},
    {field_name, 1},
    {field_text, 1, .inherited = true},
  [68] =
    {field_arg, 0, .inherited = true},
    {field_arg, 1, .inherited = true},
  [70] =
    {field_command, 0},
    {field_options, 1},
    {field_text, 2},
  [73] =
    {field_key, 0},
  [74] =
    {field_command, 0},
    {field_options, 1},
    {field_paths, 2},
  [77] =
    {field_command, 0},
    {field_options, 1},
    {field_path, 2},
  [80] =
    {field_glob, 2},
    {field_options, 1},
  [82] =
    {field_command, 0},
    {field_directory, 1},
    {field_file, 2},
  [85] =
    {field_command, 0},
    {field_long, 2},
    {field_short, 1},
  [88] =
    {field_command, 0},
    {field_keys, 2},
    {field_prenote, 1},
  [91] =
    {field_command, 0},
    {field_from, 1},
    {field_to, 2},
  [94] =
    {field_command, 0},
    {field_name, 1},
    {field_number, 2},
  [97] =
    {field_command, 0},
    {field_declaration, 1},
    {field_implementation, 2},
  [100] =
    {field_command, 0},
    {field_name, 2},
    {field_options, 1},
  [103] =
    {field_command, 0},
    {field_name, 1},
    {field_title, 2},
  [106] =
    {field_begin, 0},
    {field_end, 2},
  [108] =
    {field_begin, 0},
    {field_command, 0, .inherited = true},
    {field_command, 2, .inherited = true},
    {field_comment, 1},
    {field_end, 2},
    {field_name, 0, .inherited = true},
    {field_name, 2, .inherited = true},
  [115] =
    {field_begin, 0},
    {field_command, 0, .inherited = true},
    {field_command, 2, .inherited = true},
    {field_end, 2},
    {field_name, 0, .inherited = true},
    {field_name, 2, .inherited = true},
    {field_verbatim, 1},
  [122] =
    {field_begin, 0},
    {field_code, 1},
    {field_command, 0, .inherited = true},
    {field_command, 2, .inherited = true},
    {field_end, 2},
    {field_name, 0, .inherited = true},
    {field_name, 2, .inherited = true},
  [129] =
    {field_begin, 0},
    {field_code, 1},
    {field_command, 0, .inherited = true},
    {field_command, 2, .inherited = true},
    {field_end, 2},
    {field_language, 0, .inherited = true},
    {field_name, 0, .inherited = true},
    {field_name, 2, .inherited = true},
    {field_options, 0, .inherited = true},
  [138] =
    {field_begin, 0},
    {field_command, 0, .inherited = true},
    {field_command, 2, .inherited = true},
    {field_end, 2},
    {field_name, 0, .inherited = true},
    {field_name, 2, .inherited = true},
  [144] =
    {field_text, 1},
  [145] =
    {field_text, 1},
    {field_word, 1, .inherited = true},
  [147] =
    {field_command, 0},
    {field_language, 3},
    {field_name, 1},
    {field_options, 2},
    {field_text, 1, .inherited = true},
  [152] =
    {field_pair, 1},
  [153] =
    {field_path, 1},
  [154] =
    {field_pattern, 1},
  [155] =
    {field_command, 0},
    {field_keys, 3},
    {field_postnote, 2},
    {field_prenote, 1},
  [159] =
    {field_command, 1},
  [160] =
    {field_argc, 2},
    {field_command, 0},
    {field_declaration, 1},
    {field_implementation, 3},
  [164] =
    {field_command, 0},
    {field_declaration, 1},
    {field_implementation, 3},
  [167] =
    {field_left_command, 0},
    {field_left_delimiter, 1},
    {field_right_command, 2},
    {field_right_delimiter, 3},
  [171] =
    {field_command, 0},
    {field_declaration, 1},
    {field_left, 2},
    {field_right, 3},
  [175] =
    {field_begin, 2},
    {field_command, 0},
    {field_end, 3},
    {field_name, 1},
  [179] =
    {field_command, 0},
    {field_long, 3},
    {field_name, 1},
    {field_short, 2},
  [183] =
    {field_command, 0},
    {field_counter, 3},
    {field_name, 1},
    {field_title, 2},
  [187] =
    {field_command, 0},
    {field_counter, 2},
    {field_name, 1},
    {field_title, 3},
  [191] =
    {field_command, 0},
    {field_name, 2},
    {field_options, 1},
    {field_title, 3},
  [195] =
    {field_command, 0},
    {field_model, 2},
    {field_name, 1},
    {field_spec, 3},
  [199] =
    {field_key, 0},
    {field_value, 2},
  [201] =
    {field_pair, 1},
    {field_pair, 2, .inherited = true},
  [203] =
    {field_pair, 0, .inherited = true},
    {field_pair, 1, .inherited = true},
  [205] =
    {field_path, 1},
    {field_path, 2, .inherited = true},
  [207] =
    {field_path, 0, .inherited = true},
    {field_path, 1, .inherited = true},
  [209] =
    {field_text, 1},
    {field_text, 2, .inherited = true},
  [211] =
    {field_text, 0, .inherited = true},
    {field_text, 1, .inherited = true},
  [213] =
    {field_value, 1},
  [214] =
    {field_argc, 2},
    {field_command, 0},
    {field_declaration, 1},
    {field_default, 3},
    {field_implementation, 4},
  [219] =
    {field_left_command, 0},
    {field_left_delimiter, 1},
    {field_right_command, 3},
    {field_right_delimiter, 4},
  [223] =
    {field_body, 4},
    {field_command, 0},
    {field_declaration, 1},
    {field_left, 2},
    {field_right, 3},
  [228] =
    {field_argc, 2},
    {field_command, 0},
    {field_declaration, 1},
    {field_left, 3},
    {field_right, 4},
  [233] =
    {field_argc, 2},
    {field_begin, 3},
    {field_command, 0},
    {field_end, 4},
    {field_name, 1},
  [238] =
    {field_command, 0},
    {field_long, 4},
    {field_name, 2},
    {field_options, 1},
    {field_short, 3},
  [243] =
    {field_command, 0},
    {field_counter, 4},
    {field_name, 2},
    {field_options, 1},
    {field_title, 3},
  [248] =
    {field_command, 0},
    {field_counter, 3},
    {field_name, 2},
    {field_options, 1},
    {field_title, 4},
  [253] =
    {field_command, 0},
    {field_model, 3},
    {field_name, 2},
    {field_spec, 4},
  [257] =
    {field_command, 0},
    {field_head, 2},
    {field_model, 1},
    {field_spec, 4},
    {field_tail, 3},
  [262] =
    {field_argc, 2},
    {field_body, 5},
    {field_command, 0},
    {field_declaration, 1},
    {field_left, 3},
    {field_right, 4},
  [268] =
    {field_command, 0},
    {field_head, 3},
    {field_model, 2},
    {field_spec, 5},
    {field_tail, 4},
    {field_ty, 1},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [57] = {
    [1] = alias_sym_author,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  aux_sym_curly_group_author_list_repeat1, 2,
    aux_sym_curly_group_author_list_repeat1,
    alias_sym_author,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 2,
  [4] = 4,
  [5] = 4,
  [6] = 2,
  [7] = 7,
  [8] = 2,
  [9] = 4,
  [10] = 2,
  [11] = 4,
  [12] = 4,
  [13] = 13,
  [14] = 2,
  [15] = 2,
  [16] = 4,
  [17] = 17,
  [18] = 2,
  [19] = 4,
  [20] = 20,
  [21] = 4,
  [22] = 22,
  [23] = 23,
  [24] = 2,
  [25] = 23,
  [26] = 23,
  [27] = 22,
  [28] = 28,
  [29] = 22,
  [30] = 23,
  [31] = 22,
  [32] = 23,
  [33] = 22,
  [34] = 22,
  [35] = 22,
  [36] = 23,
  [37] = 22,
  [38] = 23,
  [39] = 22,
  [40] = 23,
  [41] = 4,
  [42] = 23,
  [43] = 4,
  [44] = 22,
  [45] = 23,
  [46] = 2,
  [47] = 4,
  [48] = 23,
  [49] = 22,
  [50] = 2,
  [51] = 17,
  [52] = 13,
  [53] = 20,
  [54] = 17,
  [55] = 13,
  [56] = 7,
  [57] = 20,
  [58] = 7,
  [59] = 59,
  [60] = 60,
  [61] = 20,
  [62] = 60,
  [63] = 59,
  [64] = 7,
  [65] = 59,
  [66] = 28,
  [67] = 59,
  [68] = 60,
  [69] = 60,
  [70] = 60,
  [71] = 13,
  [72] = 17,
  [73] = 59,
  [74] = 59,
  [75] = 13,
  [76] = 17,
  [77] = 17,
  [78] = 7,
  [79] = 60,
  [80] = 20,
  [81] = 7,
  [82] = 7,
  [83] = 20,
  [84] = 20,
  [85] = 17,
  [86] = 7,
  [87] = 13,
  [88] = 13,
  [89] = 20,
  [90] = 13,
  [91] = 60,
  [92] = 17,
  [93] = 59,
  [94] = 20,
  [95] = 95,
  [96] = 96,
  [97] = 97,
  [98] = 98,
  [99] = 99,
  [100] = 100,
  [101] = 97,
  [102] = 102,
  [103] = 28,
  [104] = 99,
  [105] = 100,
  [106] = 98,
  [107] = 99,
  [108] = 97,
  [109] = 100,
  [110] = 102,
  [111] = 99,
  [112] = 97,
  [113] = 96,
  [114] = 17,
  [115] = 102,
  [116] = 13,
  [117] = 100,
  [118] = 98,
  [119] = 13,
  [120] = 96,
  [121] = 17,
  [122] = 97,
  [123] = 99,
  [124] = 7,
  [125] = 17,
  [126] = 20,
  [127] = 97,
  [128] = 98,
  [129] = 99,
  [130] = 28,
  [131] = 100,
  [132] = 102,
  [133] = 102,
  [134] = 96,
  [135] = 99,
  [136] = 98,
  [137] = 97,
  [138] = 7,
  [139] = 96,
  [140] = 100,
  [141] = 100,
  [142] = 98,
  [143] = 102,
  [144] = 13,
  [145] = 20,
  [146] = 102,
  [147] = 96,
  [148] = 100,
  [149] = 98,
  [150] = 98,
  [151] = 97,
  [152] = 99,
  [153] = 98,
  [154] = 100,
  [155] = 102,
  [156] = 97,
  [157] = 99,
  [158] = 97,
  [159] = 96,
  [160] = 28,
  [161] = 96,
  [162] = 98,
  [163] = 100,
  [164] = 99,
  [165] = 98,
  [166] = 7,
  [167] = 100,
  [168] = 102,
  [169] = 96,
  [170] = 99,
  [171] = 97,
  [172] = 96,
  [173] = 102,
  [174] = 174,
  [175] = 175,
  [176] = 174,
  [177] = 177,
  [178] = 175,
  [179] = 179,
  [180] = 175,
  [181] = 174,
  [182] = 174,
  [183] = 175,
  [184] = 174,
  [185] = 175,
  [186] = 177,
  [187] = 187,
  [188] = 179,
  [189] = 189,
  [190] = 179,
  [191] = 177,
  [192] = 177,
  [193] = 179,
  [194] = 179,
  [195] = 177,
  [196] = 196,
  [197] = 187,
  [198] = 198,
  [199] = 189,
  [200] = 189,
  [201] = 187,
  [202] = 189,
  [203] = 187,
  [204] = 189,
  [205] = 187,
  [206] = 196,
  [207] = 207,
  [208] = 208,
  [209] = 198,
  [210] = 196,
  [211] = 196,
  [212] = 198,
  [213] = 198,
  [214] = 196,
  [215] = 198,
  [216] = 216,
  [217] = 207,
  [218] = 218,
  [219] = 208,
  [220] = 208,
  [221] = 208,
  [222] = 207,
  [223] = 207,
  [224] = 207,
  [225] = 208,
  [226] = 216,
  [227] = 218,
  [228] = 228,
  [229] = 229,
  [230] = 218,
  [231] = 216,
  [232] = 216,
  [233] = 218,
  [234] = 218,
  [235] = 216,
  [236] = 236,
  [237] = 228,
  [238] = 238,
  [239] = 229,
  [240] = 240,
  [241] = 228,
  [242] = 229,
  [243] = 229,
  [244] = 229,
  [245] = 228,
  [246] = 228,
  [247] = 240,
  [248] = 236,
  [249] = 238,
  [250] = 236,
  [251] = 240,
  [252] = 240,
  [253] = 236,
  [254] = 236,
  [255] = 238,
  [256] = 238,
  [257] = 238,
  [258] = 240,
  [259] = 259,
  [260] = 260,
  [261] = 261,
  [262] = 261,
  [263] = 263,
  [264] = 263,
  [265] = 263,
  [266] = 263,
  [267] = 263,
  [268] = 263,
  [269] = 261,
  [270] = 261,
  [271] = 261,
  [272] = 261,
  [273] = 261,
  [274] = 263,
  [275] = 240,
  [276] = 276,
  [277] = 277,
  [278] = 260,
  [279] = 276,
  [280] = 276,
  [281] = 281,
  [282] = 281,
  [283] = 281,
  [284] = 259,
  [285] = 260,
  [286] = 259,
  [287] = 260,
  [288] = 259,
  [289] = 259,
  [290] = 260,
  [291] = 291,
  [292] = 292,
  [293] = 292,
  [294] = 294,
  [295] = 291,
  [296] = 291,
  [297] = 297,
  [298] = 291,
  [299] = 292,
  [300] = 292,
  [301] = 291,
  [302] = 291,
  [303] = 292,
  [304] = 292,
  [305] = 292,
  [306] = 291,
  [307] = 292,
  [308] = 291,
  [309] = 291,
  [310] = 292,
  [311] = 292,
  [312] = 292,
  [313] = 291,
  [314] = 291,
  [315] = 315,
  [316] = 316,
  [317] = 316,
  [318] = 315,
  [319] = 319,
  [320] = 320,
  [321] = 320,
  [322] = 320,
  [323] = 320,
  [324] = 320,
  [325] = 320,
  [326] = 320,
  [327] = 320,
  [328] = 320,
  [329] = 319,
  [330] = 320,
  [331] = 331,
  [332] = 332,
  [333] = 333,
  [334] = 333,
  [335] = 333,
  [336] = 333,
  [337] = 333,
  [338] = 333,
  [339] = 333,
  [340] = 333,
  [341] = 333,
  [342] = 333,
  [343] = 343,
  [344] = 259,
  [345] = 260,
  [346] = 260,
  [347] = 260,
  [348] = 259,
  [349] = 259,
  [350] = 259,
  [351] = 260,
  [352] = 352,
  [353] = 353,
  [354] = 354,
  [355] = 355,
  [356] = 356,
  [357] = 357,
  [358] = 358,
  [359] = 359,
  [360] = 360,
  [361] = 361,
  [362] = 362,
  [363] = 363,
  [364] = 364,
  [365] = 365,
  [366] = 366,
  [367] = 367,
  [368] = 368,
  [369] = 369,
  [370] = 370,
  [371] = 371,
  [372] = 372,
  [373] = 373,
  [374] = 374,
  [375] = 375,
  [376] = 376,
  [377] = 377,
  [378] = 378,
  [379] = 379,
  [380] = 380,
  [381] = 381,
  [382] = 382,
  [383] = 383,
  [384] = 384,
  [385] = 385,
  [386] = 386,
  [387] = 387,
  [388] = 388,
  [389] = 389,
  [390] = 390,
  [391] = 391,
  [392] = 392,
  [393] = 393,
  [394] = 394,
  [395] = 395,
  [396] = 396,
  [397] = 397,
  [398] = 398,
  [399] = 399,
  [400] = 400,
  [401] = 401,
  [402] = 402,
  [403] = 403,
  [404] = 404,
  [405] = 405,
  [406] = 406,
  [407] = 407,
  [408] = 408,
  [409] = 409,
  [410] = 410,
  [411] = 411,
  [412] = 412,
  [413] = 413,
  [414] = 414,
  [415] = 415,
  [416] = 416,
  [417] = 417,
  [418] = 418,
  [419] = 419,
  [420] = 420,
  [421] = 421,
  [422] = 422,
  [423] = 423,
  [424] = 424,
  [425] = 425,
  [426] = 426,
  [427] = 427,
  [428] = 428,
  [429] = 429,
  [430] = 430,
  [431] = 431,
  [432] = 432,
  [433] = 433,
  [434] = 434,
  [435] = 435,
  [436] = 436,
  [437] = 437,
  [438] = 438,
  [439] = 439,
  [440] = 440,
  [441] = 441,
  [442] = 442,
  [443] = 443,
  [444] = 444,
  [445] = 445,
  [446] = 446,
  [447] = 447,
  [448] = 358,
  [449] = 449,
  [450] = 450,
  [451] = 451,
  [452] = 452,
  [453] = 413,
  [454] = 412,
  [455] = 411,
  [456] = 410,
  [457] = 409,
  [458] = 408,
  [459] = 407,
  [460] = 406,
  [461] = 461,
  [462] = 462,
  [463] = 463,
  [464] = 405,
  [465] = 404,
  [466] = 403,
  [467] = 402,
  [468] = 468,
  [469] = 401,
  [470] = 400,
  [471] = 399,
  [472] = 398,
  [473] = 353,
  [474] = 396,
  [475] = 394,
  [476] = 393,
  [477] = 392,
  [478] = 391,
  [479] = 390,
  [480] = 389,
  [481] = 388,
  [482] = 482,
  [483] = 483,
  [484] = 484,
  [485] = 386,
  [486] = 486,
  [487] = 385,
  [488] = 384,
  [489] = 489,
  [490] = 383,
  [491] = 491,
  [492] = 492,
  [493] = 493,
  [494] = 494,
  [495] = 495,
  [496] = 496,
  [497] = 497,
  [498] = 498,
  [499] = 382,
  [500] = 381,
  [501] = 380,
  [502] = 379,
  [503] = 378,
  [504] = 362,
  [505] = 377,
  [506] = 506,
  [507] = 507,
  [508] = 376,
  [509] = 509,
  [510] = 414,
  [511] = 511,
  [512] = 512,
  [513] = 415,
  [514] = 417,
  [515] = 418,
  [516] = 516,
  [517] = 422,
  [518] = 518,
  [519] = 352,
  [520] = 429,
  [521] = 430,
  [522] = 421,
  [523] = 523,
  [524] = 419,
  [525] = 397,
  [526] = 526,
  [527] = 527,
  [528] = 528,
  [529] = 529,
  [530] = 530,
  [531] = 531,
  [532] = 532,
  [533] = 533,
  [534] = 534,
  [535] = 535,
  [536] = 536,
  [537] = 537,
  [538] = 538,
  [539] = 539,
  [540] = 540,
  [541] = 541,
  [542] = 542,
  [543] = 543,
  [544] = 544,
  [545] = 545,
  [546] = 546,
  [547] = 547,
  [548] = 548,
  [549] = 549,
  [550] = 550,
  [551] = 551,
  [552] = 552,
  [553] = 553,
  [554] = 554,
  [555] = 555,
  [556] = 556,
  [557] = 557,
  [558] = 558,
  [559] = 559,
  [560] = 560,
  [561] = 561,
  [562] = 562,
  [563] = 563,
  [564] = 423,
  [565] = 424,
  [566] = 354,
  [567] = 567,
  [568] = 568,
  [569] = 569,
  [570] = 570,
  [571] = 571,
  [572] = 572,
  [573] = 573,
  [574] = 574,
  [575] = 575,
  [576] = 426,
  [577] = 427,
  [578] = 428,
  [579] = 425,
  [580] = 580,
  [581] = 420,
  [582] = 582,
  [583] = 416,
  [584] = 395,
  [585] = 387,
  [586] = 586,
  [587] = 587,
  [588] = 588,
  [589] = 589,
  [590] = 590,
  [591] = 591,
  [592] = 592,
  [593] = 593,
  [594] = 594,
  [595] = 372,
  [596] = 366,
  [597] = 597,
  [598] = 598,
  [599] = 599,
  [600] = 600,
  [601] = 601,
  [602] = 602,
  [603] = 603,
  [604] = 604,
  [605] = 365,
  [606] = 375,
  [607] = 374,
  [608] = 373,
  [609] = 371,
  [610] = 370,
  [611] = 369,
  [612] = 368,
  [613] = 367,
  [614] = 614,
  [615] = 615,
  [616] = 616,
  [617] = 617,
  [618] = 618,
  [619] = 364,
  [620] = 620,
  [621] = 621,
  [622] = 622,
  [623] = 623,
  [624] = 624,
  [625] = 625,
  [626] = 363,
  [627] = 627,
  [628] = 628,
  [629] = 629,
  [630] = 630,
  [631] = 631,
  [632] = 632,
  [633] = 633,
  [634] = 634,
  [635] = 635,
  [636] = 636,
  [637] = 361,
  [638] = 360,
  [639] = 359,
  [640] = 357,
  [641] = 356,
  [642] = 355,
  [643] = 370,
  [644] = 373,
  [645] = 413,
  [646] = 412,
  [647] = 411,
  [648] = 410,
  [649] = 409,
  [650] = 408,
  [651] = 407,
  [652] = 406,
  [653] = 405,
  [654] = 404,
  [655] = 403,
  [656] = 402,
  [657] = 401,
  [658] = 400,
  [659] = 399,
  [660] = 398,
  [661] = 353,
  [662] = 396,
  [663] = 394,
  [664] = 393,
  [665] = 392,
  [666] = 391,
  [667] = 390,
  [668] = 389,
  [669] = 388,
  [670] = 386,
  [671] = 385,
  [672] = 384,
  [673] = 383,
  [674] = 382,
  [675] = 381,
  [676] = 380,
  [677] = 379,
  [678] = 378,
  [679] = 377,
  [680] = 376,
  [681] = 414,
  [682] = 415,
  [683] = 417,
  [684] = 418,
  [685] = 422,
  [686] = 416,
  [687] = 352,
  [688] = 429,
  [689] = 430,
  [690] = 421,
  [691] = 419,
  [692] = 397,
  [693] = 436,
  [694] = 358,
  [695] = 362,
  [696] = 363,
  [697] = 364,
  [698] = 365,
  [699] = 366,
  [700] = 372,
  [701] = 387,
  [702] = 354,
  [703] = 355,
  [704] = 356,
  [705] = 357,
  [706] = 359,
  [707] = 360,
  [708] = 361,
  [709] = 395,
  [710] = 416,
  [711] = 420,
  [712] = 425,
  [713] = 428,
  [714] = 427,
  [715] = 426,
  [716] = 424,
  [717] = 423,
  [718] = 424,
  [719] = 426,
  [720] = 427,
  [721] = 367,
  [722] = 368,
  [723] = 369,
  [724] = 370,
  [725] = 371,
  [726] = 373,
  [727] = 374,
  [728] = 375,
  [729] = 428,
  [730] = 423,
  [731] = 413,
  [732] = 412,
  [733] = 411,
  [734] = 410,
  [735] = 409,
  [736] = 408,
  [737] = 407,
  [738] = 375,
  [739] = 374,
  [740] = 373,
  [741] = 371,
  [742] = 406,
  [743] = 433,
  [744] = 425,
  [745] = 369,
  [746] = 420,
  [747] = 368,
  [748] = 367,
  [749] = 414,
  [750] = 415,
  [751] = 417,
  [752] = 418,
  [753] = 422,
  [754] = 352,
  [755] = 405,
  [756] = 404,
  [757] = 361,
  [758] = 435,
  [759] = 360,
  [760] = 359,
  [761] = 357,
  [762] = 356,
  [763] = 355,
  [764] = 354,
  [765] = 403,
  [766] = 402,
  [767] = 401,
  [768] = 400,
  [769] = 399,
  [770] = 398,
  [771] = 353,
  [772] = 376,
  [773] = 377,
  [774] = 378,
  [775] = 379,
  [776] = 380,
  [777] = 381,
  [778] = 382,
  [779] = 430,
  [780] = 383,
  [781] = 384,
  [782] = 385,
  [783] = 386,
  [784] = 388,
  [785] = 389,
  [786] = 395,
  [787] = 390,
  [788] = 391,
  [789] = 392,
  [790] = 393,
  [791] = 394,
  [792] = 387,
  [793] = 396,
  [794] = 353,
  [795] = 398,
  [796] = 399,
  [797] = 372,
  [798] = 400,
  [799] = 401,
  [800] = 402,
  [801] = 366,
  [802] = 403,
  [803] = 404,
  [804] = 365,
  [805] = 405,
  [806] = 364,
  [807] = 363,
  [808] = 432,
  [809] = 396,
  [810] = 362,
  [811] = 406,
  [812] = 407,
  [813] = 408,
  [814] = 409,
  [815] = 410,
  [816] = 411,
  [817] = 412,
  [818] = 413,
  [819] = 358,
  [820] = 394,
  [821] = 393,
  [822] = 392,
  [823] = 391,
  [824] = 397,
  [825] = 390,
  [826] = 419,
  [827] = 429,
  [828] = 389,
  [829] = 434,
  [830] = 388,
  [831] = 386,
  [832] = 354,
  [833] = 355,
  [834] = 356,
  [835] = 357,
  [836] = 359,
  [837] = 360,
  [838] = 361,
  [839] = 385,
  [840] = 384,
  [841] = 367,
  [842] = 368,
  [843] = 369,
  [844] = 370,
  [845] = 371,
  [846] = 383,
  [847] = 374,
  [848] = 375,
  [849] = 382,
  [850] = 381,
  [851] = 414,
  [852] = 415,
  [853] = 417,
  [854] = 418,
  [855] = 422,
  [856] = 352,
  [857] = 429,
  [858] = 421,
  [859] = 430,
  [860] = 421,
  [861] = 419,
  [862] = 397,
  [863] = 358,
  [864] = 362,
  [865] = 363,
  [866] = 364,
  [867] = 365,
  [868] = 366,
  [869] = 372,
  [870] = 387,
  [871] = 395,
  [872] = 416,
  [873] = 420,
  [874] = 425,
  [875] = 428,
  [876] = 427,
  [877] = 426,
  [878] = 424,
  [879] = 423,
  [880] = 380,
  [881] = 379,
  [882] = 378,
  [883] = 377,
  [884] = 376,
  [885] = 431,
  [886] = 434,
  [887] = 442,
  [888] = 435,
  [889] = 436,
  [890] = 433,
  [891] = 441,
  [892] = 440,
  [893] = 436,
  [894] = 435,
  [895] = 439,
  [896] = 432,
  [897] = 431,
  [898] = 434,
  [899] = 433,
  [900] = 431,
  [901] = 436,
  [902] = 437,
  [903] = 432,
  [904] = 438,
  [905] = 433,
  [906] = 434,
  [907] = 435,
  [908] = 432,
  [909] = 431,
  [910] = 570,
  [911] = 442,
  [912] = 543,
  [913] = 544,
  [914] = 545,
  [915] = 546,
  [916] = 547,
  [917] = 549,
  [918] = 451,
  [919] = 452,
  [920] = 461,
  [921] = 440,
  [922] = 462,
  [923] = 437,
  [924] = 439,
  [925] = 441,
  [926] = 438,
  [927] = 550,
  [928] = 551,
  [929] = 445,
  [930] = 636,
  [931] = 635,
  [932] = 634,
  [933] = 633,
  [934] = 632,
  [935] = 631,
  [936] = 442,
  [937] = 630,
  [938] = 463,
  [939] = 542,
  [940] = 523,
  [941] = 530,
  [942] = 535,
  [943] = 539,
  [944] = 629,
  [945] = 628,
  [946] = 540,
  [947] = 444,
  [948] = 548,
  [949] = 552,
  [950] = 553,
  [951] = 627,
  [952] = 438,
  [953] = 560,
  [954] = 562,
  [955] = 482,
  [956] = 516,
  [957] = 518,
  [958] = 563,
  [959] = 489,
  [960] = 439,
  [961] = 498,
  [962] = 497,
  [963] = 496,
  [964] = 567,
  [965] = 559,
  [966] = 568,
  [967] = 512,
  [968] = 449,
  [969] = 571,
  [970] = 437,
  [971] = 572,
  [972] = 569,
  [973] = 574,
  [974] = 575,
  [975] = 580,
  [976] = 582,
  [977] = 483,
  [978] = 509,
  [979] = 541,
  [980] = 441,
  [981] = 440,
  [982] = 437,
  [983] = 586,
  [984] = 587,
  [985] = 588,
  [986] = 625,
  [987] = 446,
  [988] = 589,
  [989] = 447,
  [990] = 590,
  [991] = 438,
  [992] = 507,
  [993] = 591,
  [994] = 486,
  [995] = 592,
  [996] = 624,
  [997] = 593,
  [998] = 594,
  [999] = 506,
  [1000] = 528,
  [1001] = 529,
  [1002] = 442,
  [1003] = 531,
  [1004] = 511,
  [1005] = 532,
  [1006] = 533,
  [1007] = 534,
  [1008] = 1008,
  [1009] = 536,
  [1010] = 537,
  [1011] = 538,
  [1012] = 573,
  [1013] = 554,
  [1014] = 597,
  [1015] = 598,
  [1016] = 599,
  [1017] = 441,
  [1018] = 600,
  [1019] = 484,
  [1020] = 623,
  [1021] = 601,
  [1022] = 602,
  [1023] = 622,
  [1024] = 440,
  [1025] = 526,
  [1026] = 439,
  [1027] = 468,
  [1028] = 604,
  [1029] = 491,
  [1030] = 443,
  [1031] = 614,
  [1032] = 615,
  [1033] = 616,
  [1034] = 617,
  [1035] = 618,
  [1036] = 450,
  [1037] = 621,
  [1038] = 561,
  [1039] = 555,
  [1040] = 492,
  [1041] = 557,
  [1042] = 493,
  [1043] = 494,
  [1044] = 495,
  [1045] = 527,
  [1046] = 556,
  [1047] = 620,
  [1048] = 558,
  [1049] = 603,
  [1050] = 497,
  [1051] = 548,
  [1052] = 589,
  [1053] = 586,
  [1054] = 587,
  [1055] = 582,
  [1056] = 580,
  [1057] = 516,
  [1058] = 518,
  [1059] = 574,
  [1060] = 563,
  [1061] = 489,
  [1062] = 498,
  [1063] = 573,
  [1064] = 538,
  [1065] = 572,
  [1066] = 496,
  [1067] = 575,
  [1068] = 567,
  [1069] = 568,
  [1070] = 569,
  [1071] = 570,
  [1072] = 571,
  [1073] = 572,
  [1074] = 573,
  [1075] = 574,
  [1076] = 575,
  [1077] = 580,
  [1078] = 582,
  [1079] = 586,
  [1080] = 587,
  [1081] = 588,
  [1082] = 589,
  [1083] = 590,
  [1084] = 591,
  [1085] = 592,
  [1086] = 593,
  [1087] = 594,
  [1088] = 530,
  [1089] = 590,
  [1090] = 570,
  [1091] = 482,
  [1092] = 562,
  [1093] = 560,
  [1094] = 553,
  [1095] = 552,
  [1096] = 548,
  [1097] = 571,
  [1098] = 444,
  [1099] = 540,
  [1100] = 539,
  [1101] = 535,
  [1102] = 622,
  [1103] = 523,
  [1104] = 542,
  [1105] = 512,
  [1106] = 463,
  [1107] = 462,
  [1108] = 461,
  [1109] = 452,
  [1110] = 451,
  [1111] = 450,
  [1112] = 449,
  [1113] = 443,
  [1114] = 506,
  [1115] = 592,
  [1116] = 507,
  [1117] = 593,
  [1118] = 447,
  [1119] = 528,
  [1120] = 529,
  [1121] = 531,
  [1122] = 532,
  [1123] = 533,
  [1124] = 534,
  [1125] = 536,
  [1126] = 537,
  [1127] = 538,
  [1128] = 468,
  [1129] = 527,
  [1130] = 495,
  [1131] = 494,
  [1132] = 493,
  [1133] = 554,
  [1134] = 492,
  [1135] = 555,
  [1136] = 597,
  [1137] = 598,
  [1138] = 599,
  [1139] = 600,
  [1140] = 601,
  [1141] = 602,
  [1142] = 603,
  [1143] = 604,
  [1144] = 539,
  [1145] = 491,
  [1146] = 526,
  [1147] = 446,
  [1148] = 614,
  [1149] = 615,
  [1150] = 616,
  [1151] = 617,
  [1152] = 618,
  [1153] = 509,
  [1154] = 620,
  [1155] = 556,
  [1156] = 557,
  [1157] = 558,
  [1158] = 559,
  [1159] = 561,
  [1160] = 621,
  [1161] = 622,
  [1162] = 623,
  [1163] = 624,
  [1164] = 569,
  [1165] = 486,
  [1166] = 511,
  [1167] = 625,
  [1168] = 541,
  [1169] = 627,
  [1170] = 628,
  [1171] = 629,
  [1172] = 630,
  [1173] = 631,
  [1174] = 632,
  [1175] = 633,
  [1176] = 634,
  [1177] = 635,
  [1178] = 636,
  [1179] = 1179,
  [1180] = 568,
  [1181] = 567,
  [1182] = 543,
  [1183] = 496,
  [1184] = 497,
  [1185] = 498,
  [1186] = 489,
  [1187] = 1187,
  [1188] = 544,
  [1189] = 468,
  [1190] = 554,
  [1191] = 563,
  [1192] = 545,
  [1193] = 546,
  [1194] = 547,
  [1195] = 549,
  [1196] = 550,
  [1197] = 551,
  [1198] = 445,
  [1199] = 594,
  [1200] = 518,
  [1201] = 516,
  [1202] = 597,
  [1203] = 483,
  [1204] = 484,
  [1205] = 636,
  [1206] = 635,
  [1207] = 634,
  [1208] = 598,
  [1209] = 599,
  [1210] = 633,
  [1211] = 632,
  [1212] = 631,
  [1213] = 630,
  [1214] = 629,
  [1215] = 628,
  [1216] = 627,
  [1217] = 625,
  [1218] = 511,
  [1219] = 600,
  [1220] = 601,
  [1221] = 602,
  [1222] = 486,
  [1223] = 624,
  [1224] = 623,
  [1225] = 603,
  [1226] = 604,
  [1227] = 533,
  [1228] = 491,
  [1229] = 534,
  [1230] = 614,
  [1231] = 615,
  [1232] = 616,
  [1233] = 617,
  [1234] = 618,
  [1235] = 620,
  [1236] = 556,
  [1237] = 557,
  [1238] = 558,
  [1239] = 559,
  [1240] = 527,
  [1241] = 561,
  [1242] = 621,
  [1243] = 622,
  [1244] = 623,
  [1245] = 600,
  [1246] = 624,
  [1247] = 621,
  [1248] = 561,
  [1249] = 559,
  [1250] = 558,
  [1251] = 557,
  [1252] = 556,
  [1253] = 620,
  [1254] = 618,
  [1255] = 617,
  [1256] = 616,
  [1257] = 615,
  [1258] = 614,
  [1259] = 526,
  [1260] = 491,
  [1261] = 482,
  [1262] = 562,
  [1263] = 560,
  [1264] = 591,
  [1265] = 553,
  [1266] = 552,
  [1267] = 588,
  [1268] = 444,
  [1269] = 540,
  [1270] = 542,
  [1271] = 535,
  [1272] = 530,
  [1273] = 523,
  [1274] = 604,
  [1275] = 512,
  [1276] = 463,
  [1277] = 462,
  [1278] = 461,
  [1279] = 452,
  [1280] = 451,
  [1281] = 450,
  [1282] = 449,
  [1283] = 603,
  [1284] = 443,
  [1285] = 506,
  [1286] = 536,
  [1287] = 602,
  [1288] = 507,
  [1289] = 447,
  [1290] = 446,
  [1291] = 509,
  [1292] = 541,
  [1293] = 543,
  [1294] = 544,
  [1295] = 545,
  [1296] = 546,
  [1297] = 547,
  [1298] = 601,
  [1299] = 549,
  [1300] = 518,
  [1301] = 550,
  [1302] = 599,
  [1303] = 551,
  [1304] = 598,
  [1305] = 486,
  [1306] = 597,
  [1307] = 625,
  [1308] = 555,
  [1309] = 492,
  [1310] = 554,
  [1311] = 493,
  [1312] = 494,
  [1313] = 495,
  [1314] = 527,
  [1315] = 468,
  [1316] = 538,
  [1317] = 537,
  [1318] = 536,
  [1319] = 627,
  [1320] = 628,
  [1321] = 534,
  [1322] = 533,
  [1323] = 629,
  [1324] = 532,
  [1325] = 531,
  [1326] = 630,
  [1327] = 631,
  [1328] = 445,
  [1329] = 529,
  [1330] = 528,
  [1331] = 594,
  [1332] = 593,
  [1333] = 592,
  [1334] = 591,
  [1335] = 590,
  [1336] = 589,
  [1337] = 588,
  [1338] = 587,
  [1339] = 483,
  [1340] = 484,
  [1341] = 586,
  [1342] = 582,
  [1343] = 580,
  [1344] = 575,
  [1345] = 574,
  [1346] = 573,
  [1347] = 572,
  [1348] = 571,
  [1349] = 570,
  [1350] = 569,
  [1351] = 568,
  [1352] = 567,
  [1353] = 496,
  [1354] = 497,
  [1355] = 498,
  [1356] = 489,
  [1357] = 563,
  [1358] = 516,
  [1359] = 537,
  [1360] = 482,
  [1361] = 562,
  [1362] = 560,
  [1363] = 632,
  [1364] = 553,
  [1365] = 633,
  [1366] = 552,
  [1367] = 548,
  [1368] = 495,
  [1369] = 494,
  [1370] = 493,
  [1371] = 444,
  [1372] = 492,
  [1373] = 555,
  [1374] = 540,
  [1375] = 634,
  [1376] = 635,
  [1377] = 539,
  [1378] = 535,
  [1379] = 530,
  [1380] = 523,
  [1381] = 636,
  [1382] = 542,
  [1383] = 512,
  [1384] = 526,
  [1385] = 484,
  [1386] = 463,
  [1387] = 462,
  [1388] = 461,
  [1389] = 483,
  [1390] = 452,
  [1391] = 532,
  [1392] = 451,
  [1393] = 450,
  [1394] = 449,
  [1395] = 443,
  [1396] = 506,
  [1397] = 531,
  [1398] = 529,
  [1399] = 1399,
  [1400] = 507,
  [1401] = 447,
  [1402] = 446,
  [1403] = 509,
  [1404] = 511,
  [1405] = 541,
  [1406] = 528,
  [1407] = 543,
  [1408] = 544,
  [1409] = 545,
  [1410] = 546,
  [1411] = 547,
  [1412] = 549,
  [1413] = 550,
  [1414] = 551,
  [1415] = 445,
  [1416] = 259,
  [1417] = 260,
  [1418] = 1418,
  [1419] = 1418,
  [1420] = 1420,
  [1421] = 1418,
  [1422] = 1418,
  [1423] = 1418,
  [1424] = 1418,
  [1425] = 1418,
  [1426] = 1418,
  [1427] = 1418,
  [1428] = 1418,
  [1429] = 1429,
  [1430] = 1429,
  [1431] = 1429,
  [1432] = 1429,
  [1433] = 1429,
  [1434] = 1434,
  [1435] = 1429,
  [1436] = 1429,
  [1437] = 1429,
  [1438] = 1434,
  [1439] = 1429,
  [1440] = 1429,
  [1441] = 1441,
  [1442] = 1441,
  [1443] = 1443,
  [1444] = 1441,
  [1445] = 1443,
  [1446] = 1443,
  [1447] = 1441,
  [1448] = 1443,
  [1449] = 1441,
  [1450] = 1443,
  [1451] = 1441,
  [1452] = 1443,
  [1453] = 1441,
  [1454] = 1443,
  [1455] = 1441,
  [1456] = 1441,
  [1457] = 1443,
  [1458] = 1458,
  [1459] = 1441,
  [1460] = 1443,
  [1461] = 1443,
  [1462] = 1441,
  [1463] = 431,
  [1464] = 432,
  [1465] = 436,
  [1466] = 434,
  [1467] = 433,
  [1468] = 435,
  [1469] = 439,
  [1470] = 436,
  [1471] = 432,
  [1472] = 440,
  [1473] = 435,
  [1474] = 433,
  [1475] = 433,
  [1476] = 441,
  [1477] = 432,
  [1478] = 434,
  [1479] = 437,
  [1480] = 435,
  [1481] = 431,
  [1482] = 434,
  [1483] = 442,
  [1484] = 431,
  [1485] = 436,
  [1486] = 516,
  [1487] = 555,
  [1488] = 437,
  [1489] = 483,
  [1490] = 445,
  [1491] = 509,
  [1492] = 446,
  [1493] = 447,
  [1494] = 507,
  [1495] = 439,
  [1496] = 506,
  [1497] = 443,
  [1498] = 449,
  [1499] = 450,
  [1500] = 451,
  [1501] = 452,
  [1502] = 461,
  [1503] = 462,
  [1504] = 463,
  [1505] = 468,
  [1506] = 527,
  [1507] = 495,
  [1508] = 494,
  [1509] = 493,
  [1510] = 512,
  [1511] = 492,
  [1512] = 542,
  [1513] = 523,
  [1514] = 530,
  [1515] = 535,
  [1516] = 539,
  [1517] = 540,
  [1518] = 444,
  [1519] = 548,
  [1520] = 552,
  [1521] = 553,
  [1522] = 526,
  [1523] = 440,
  [1524] = 560,
  [1525] = 562,
  [1526] = 482,
  [1527] = 518,
  [1528] = 563,
  [1529] = 441,
  [1530] = 498,
  [1531] = 497,
  [1532] = 496,
  [1533] = 567,
  [1534] = 484,
  [1535] = 569,
  [1536] = 570,
  [1537] = 571,
  [1538] = 572,
  [1539] = 573,
  [1540] = 574,
  [1541] = 511,
  [1542] = 575,
  [1543] = 442,
  [1544] = 580,
  [1545] = 1545,
  [1546] = 582,
  [1547] = 586,
  [1548] = 587,
  [1549] = 588,
  [1550] = 589,
  [1551] = 590,
  [1552] = 591,
  [1553] = 592,
  [1554] = 593,
  [1555] = 594,
  [1556] = 528,
  [1557] = 529,
  [1558] = 531,
  [1559] = 532,
  [1560] = 533,
  [1561] = 534,
  [1562] = 536,
  [1563] = 537,
  [1564] = 538,
  [1565] = 554,
  [1566] = 597,
  [1567] = 598,
  [1568] = 599,
  [1569] = 600,
  [1570] = 601,
  [1571] = 602,
  [1572] = 603,
  [1573] = 604,
  [1574] = 491,
  [1575] = 614,
  [1576] = 442,
  [1577] = 615,
  [1578] = 616,
  [1579] = 617,
  [1580] = 618,
  [1581] = 620,
  [1582] = 556,
  [1583] = 557,
  [1584] = 558,
  [1585] = 559,
  [1586] = 561,
  [1587] = 621,
  [1588] = 622,
  [1589] = 623,
  [1590] = 624,
  [1591] = 486,
  [1592] = 625,
  [1593] = 627,
  [1594] = 628,
  [1595] = 629,
  [1596] = 441,
  [1597] = 630,
  [1598] = 568,
  [1599] = 632,
  [1600] = 633,
  [1601] = 634,
  [1602] = 440,
  [1603] = 635,
  [1604] = 636,
  [1605] = 437,
  [1606] = 631,
  [1607] = 439,
  [1608] = 618,
  [1609] = 630,
  [1610] = 599,
  [1611] = 598,
  [1612] = 597,
  [1613] = 568,
  [1614] = 468,
  [1615] = 567,
  [1616] = 553,
  [1617] = 552,
  [1618] = 496,
  [1619] = 497,
  [1620] = 498,
  [1621] = 563,
  [1622] = 518,
  [1623] = 516,
  [1624] = 482,
  [1625] = 562,
  [1626] = 560,
  [1627] = 468,
  [1628] = 527,
  [1629] = 495,
  [1630] = 494,
  [1631] = 493,
  [1632] = 602,
  [1633] = 492,
  [1634] = 553,
  [1635] = 601,
  [1636] = 594,
  [1637] = 593,
  [1638] = 592,
  [1639] = 591,
  [1640] = 590,
  [1641] = 589,
  [1642] = 588,
  [1643] = 552,
  [1644] = 548,
  [1645] = 526,
  [1646] = 444,
  [1647] = 587,
  [1648] = 586,
  [1649] = 582,
  [1650] = 548,
  [1651] = 580,
  [1652] = 540,
  [1653] = 575,
  [1654] = 444,
  [1655] = 1179,
  [1656] = 451,
  [1657] = 539,
  [1658] = 535,
  [1659] = 574,
  [1660] = 573,
  [1661] = 572,
  [1662] = 571,
  [1663] = 530,
  [1664] = 539,
  [1665] = 511,
  [1666] = 570,
  [1667] = 535,
  [1668] = 569,
  [1669] = 568,
  [1670] = 567,
  [1671] = 523,
  [1672] = 542,
  [1673] = 512,
  [1674] = 498,
  [1675] = 563,
  [1676] = 463,
  [1677] = 562,
  [1678] = 530,
  [1679] = 523,
  [1680] = 542,
  [1681] = 512,
  [1682] = 462,
  [1683] = 463,
  [1684] = 462,
  [1685] = 461,
  [1686] = 461,
  [1687] = 452,
  [1688] = 452,
  [1689] = 615,
  [1690] = 450,
  [1691] = 449,
  [1692] = 451,
  [1693] = 450,
  [1694] = 449,
  [1695] = 511,
  [1696] = 443,
  [1697] = 447,
  [1698] = 446,
  [1699] = 509,
  [1700] = 445,
  [1701] = 589,
  [1702] = 590,
  [1703] = 591,
  [1704] = 483,
  [1705] = 484,
  [1706] = 592,
  [1707] = 593,
  [1708] = 594,
  [1709] = 528,
  [1710] = 529,
  [1711] = 531,
  [1712] = 435,
  [1713] = 532,
  [1714] = 533,
  [1715] = 443,
  [1716] = 506,
  [1717] = 534,
  [1718] = 507,
  [1719] = 447,
  [1720] = 446,
  [1721] = 509,
  [1722] = 445,
  [1723] = 536,
  [1724] = 537,
  [1725] = 538,
  [1726] = 554,
  [1727] = 486,
  [1728] = 555,
  [1729] = 597,
  [1730] = 598,
  [1731] = 599,
  [1732] = 600,
  [1733] = 601,
  [1734] = 602,
  [1735] = 603,
  [1736] = 604,
  [1737] = 491,
  [1738] = 614,
  [1739] = 615,
  [1740] = 616,
  [1741] = 491,
  [1742] = 617,
  [1743] = 618,
  [1744] = 620,
  [1745] = 436,
  [1746] = 560,
  [1747] = 556,
  [1748] = 603,
  [1749] = 483,
  [1750] = 484,
  [1751] = 604,
  [1752] = 557,
  [1753] = 558,
  [1754] = 559,
  [1755] = 561,
  [1756] = 621,
  [1757] = 622,
  [1758] = 623,
  [1759] = 624,
  [1760] = 569,
  [1761] = 570,
  [1762] = 486,
  [1763] = 625,
  [1764] = 627,
  [1765] = 628,
  [1766] = 629,
  [1767] = 600,
  [1768] = 631,
  [1769] = 632,
  [1770] = 633,
  [1771] = 634,
  [1772] = 635,
  [1773] = 636,
  [1774] = 526,
  [1775] = 614,
  [1776] = 588,
  [1777] = 527,
  [1778] = 496,
  [1779] = 497,
  [1780] = 540,
  [1781] = 586,
  [1782] = 482,
  [1783] = 636,
  [1784] = 635,
  [1785] = 634,
  [1786] = 633,
  [1787] = 632,
  [1788] = 631,
  [1789] = 630,
  [1790] = 616,
  [1791] = 617,
  [1792] = 587,
  [1793] = 629,
  [1794] = 628,
  [1795] = 627,
  [1796] = 571,
  [1797] = 625,
  [1798] = 582,
  [1799] = 572,
  [1800] = 580,
  [1801] = 507,
  [1802] = 620,
  [1803] = 506,
  [1804] = 573,
  [1805] = 574,
  [1806] = 575,
  [1807] = 624,
  [1808] = 621,
  [1809] = 1187,
  [1810] = 622,
  [1811] = 623,
  [1812] = 432,
  [1813] = 434,
  [1814] = 431,
  [1815] = 1179,
  [1816] = 1187,
  [1817] = 433,
  [1818] = 441,
  [1819] = 439,
  [1820] = 442,
  [1821] = 498,
  [1822] = 437,
  [1823] = 440,
  [1824] = 527,
  [1825] = 509,
  [1826] = 535,
  [1827] = 582,
  [1828] = 634,
  [1829] = 633,
  [1830] = 632,
  [1831] = 631,
  [1832] = 630,
  [1833] = 629,
  [1834] = 628,
  [1835] = 627,
  [1836] = 491,
  [1837] = 486,
  [1838] = 497,
  [1839] = 625,
  [1840] = 506,
  [1841] = 507,
  [1842] = 484,
  [1843] = 483,
  [1844] = 1844,
  [1845] = 624,
  [1846] = 445,
  [1847] = 623,
  [1848] = 622,
  [1849] = 621,
  [1850] = 620,
  [1851] = 618,
  [1852] = 617,
  [1853] = 616,
  [1854] = 615,
  [1855] = 614,
  [1856] = 446,
  [1857] = 604,
  [1858] = 603,
  [1859] = 602,
  [1860] = 468,
  [1861] = 601,
  [1862] = 600,
  [1863] = 599,
  [1864] = 598,
  [1865] = 597,
  [1866] = 447,
  [1867] = 594,
  [1868] = 593,
  [1869] = 592,
  [1870] = 526,
  [1871] = 591,
  [1872] = 590,
  [1873] = 589,
  [1874] = 588,
  [1875] = 587,
  [1876] = 586,
  [1877] = 635,
  [1878] = 580,
  [1879] = 575,
  [1880] = 574,
  [1881] = 573,
  [1882] = 572,
  [1883] = 571,
  [1884] = 570,
  [1885] = 511,
  [1886] = 569,
  [1887] = 568,
  [1888] = 567,
  [1889] = 482,
  [1890] = 563,
  [1891] = 562,
  [1892] = 560,
  [1893] = 553,
  [1894] = 552,
  [1895] = 548,
  [1896] = 444,
  [1897] = 540,
  [1898] = 539,
  [1899] = 443,
  [1900] = 530,
  [1901] = 523,
  [1902] = 542,
  [1903] = 512,
  [1904] = 463,
  [1905] = 462,
  [1906] = 461,
  [1907] = 452,
  [1908] = 636,
  [1909] = 496,
  [1910] = 451,
  [1911] = 450,
  [1912] = 449,
  [1913] = 435,
  [1914] = 436,
  [1915] = 433,
  [1916] = 434,
  [1917] = 431,
  [1918] = 527,
  [1919] = 432,
  [1920] = 509,
  [1921] = 442,
  [1922] = 441,
  [1923] = 440,
  [1924] = 498,
  [1925] = 439,
  [1926] = 526,
  [1927] = 437,
  [1928] = 511,
  [1929] = 443,
  [1930] = 617,
  [1931] = 634,
  [1932] = 636,
  [1933] = 635,
  [1934] = 483,
  [1935] = 633,
  [1936] = 632,
  [1937] = 631,
  [1938] = 630,
  [1939] = 629,
  [1940] = 628,
  [1941] = 627,
  [1942] = 625,
  [1943] = 624,
  [1944] = 623,
  [1945] = 622,
  [1946] = 621,
  [1947] = 620,
  [1948] = 618,
  [1949] = 616,
  [1950] = 615,
  [1951] = 614,
  [1952] = 604,
  [1953] = 603,
  [1954] = 602,
  [1955] = 601,
  [1956] = 600,
  [1957] = 599,
  [1958] = 598,
  [1959] = 597,
  [1960] = 594,
  [1961] = 593,
  [1962] = 592,
  [1963] = 591,
  [1964] = 590,
  [1965] = 589,
  [1966] = 588,
  [1967] = 587,
  [1968] = 586,
  [1969] = 582,
  [1970] = 580,
  [1971] = 575,
  [1972] = 574,
  [1973] = 573,
  [1974] = 572,
  [1975] = 571,
  [1976] = 570,
  [1977] = 569,
  [1978] = 568,
  [1979] = 567,
  [1980] = 563,
  [1981] = 562,
  [1982] = 560,
  [1983] = 553,
  [1984] = 552,
  [1985] = 548,
  [1986] = 444,
  [1987] = 540,
  [1988] = 539,
  [1989] = 535,
  [1990] = 530,
  [1991] = 523,
  [1992] = 542,
  [1993] = 512,
  [1994] = 463,
  [1995] = 462,
  [1996] = 461,
  [1997] = 452,
  [1998] = 451,
  [1999] = 450,
  [2000] = 449,
  [2001] = 447,
  [2002] = 446,
  [2003] = 445,
  [2004] = 484,
  [2005] = 468,
  [2006] = 2006,
  [2007] = 2006,
  [2008] = 2006,
  [2009] = 2006,
  [2010] = 2006,
  [2011] = 2006,
  [2012] = 2006,
  [2013] = 2013,
  [2014] = 2014,
  [2015] = 2014,
  [2016] = 2013,
  [2017] = 2017,
  [2018] = 2018,
  [2019] = 2013,
  [2020] = 2014,
  [2021] = 2018,
  [2022] = 2014,
  [2023] = 2018,
  [2024] = 2014,
  [2025] = 2017,
  [2026] = 2018,
  [2027] = 2027,
  [2028] = 2017,
  [2029] = 2018,
  [2030] = 2027,
  [2031] = 2017,
  [2032] = 2018,
  [2033] = 2014,
  [2034] = 2027,
  [2035] = 2027,
  [2036] = 2017,
  [2037] = 2013,
  [2038] = 2018,
  [2039] = 2014,
  [2040] = 2014,
  [2041] = 2014,
  [2042] = 2027,
  [2043] = 2013,
  [2044] = 2018,
  [2045] = 2017,
  [2046] = 2013,
  [2047] = 2013,
  [2048] = 2014,
  [2049] = 2013,
  [2050] = 2027,
  [2051] = 2027,
  [2052] = 2018,
  [2053] = 2017,
  [2054] = 2014,
  [2055] = 2018,
  [2056] = 2017,
  [2057] = 2018,
  [2058] = 2027,
  [2059] = 2027,
  [2060] = 2027,
  [2061] = 2061,
  [2062] = 2013,
  [2063] = 2017,
  [2064] = 2027,
  [2065] = 2065,
  [2066] = 2065,
  [2067] = 2065,
  [2068] = 2068,
  [2069] = 2069,
  [2070] = 2065,
  [2071] = 2069,
  [2072] = 2072,
  [2073] = 2072,
  [2074] = 2069,
  [2075] = 2068,
  [2076] = 2068,
  [2077] = 2072,
  [2078] = 2068,
  [2079] = 2079,
  [2080] = 2072,
  [2081] = 2081,
  [2082] = 2069,
  [2083] = 2068,
  [2084] = 2065,
  [2085] = 2072,
  [2086] = 2068,
  [2087] = 2065,
  [2088] = 2068,
  [2089] = 2069,
  [2090] = 2065,
  [2091] = 2068,
  [2092] = 2069,
  [2093] = 2069,
  [2094] = 2072,
  [2095] = 2072,
  [2096] = 2096,
  [2097] = 2072,
  [2098] = 2065,
  [2099] = 2069,
  [2100] = 2072,
  [2101] = 2069,
  [2102] = 2102,
  [2103] = 2065,
  [2104] = 2065,
  [2105] = 2068,
  [2106] = 2068,
  [2107] = 2069,
  [2108] = 2072,
  [2109] = 2109,
  [2110] = 2110,
  [2111] = 2111,
  [2112] = 2112,
  [2113] = 2113,
  [2114] = 2114,
  [2115] = 2115,
  [2116] = 2116,
  [2117] = 2117,
  [2118] = 2116,
  [2119] = 2119,
  [2120] = 2116,
  [2121] = 2117,
  [2122] = 2119,
  [2123] = 2123,
  [2124] = 2114,
  [2125] = 2113,
  [2126] = 2126,
  [2127] = 2127,
  [2128] = 2128,
  [2129] = 2112,
  [2130] = 2111,
  [2131] = 2109,
  [2132] = 2113,
  [2133] = 2114,
  [2134] = 2134,
  [2135] = 2115,
  [2136] = 2110,
  [2137] = 2123,
  [2138] = 2126,
  [2139] = 2139,
  [2140] = 2127,
  [2141] = 2141,
  [2142] = 2142,
  [2143] = 2142,
  [2144] = 2141,
  [2145] = 2139,
  [2146] = 2110,
  [2147] = 2134,
  [2148] = 2109,
  [2149] = 2126,
  [2150] = 2123,
  [2151] = 2115,
  [2152] = 2114,
  [2153] = 2113,
  [2154] = 2111,
  [2155] = 2155,
  [2156] = 2156,
  [2157] = 2128,
  [2158] = 2139,
  [2159] = 2123,
  [2160] = 2156,
  [2161] = 2141,
  [2162] = 2142,
  [2163] = 2111,
  [2164] = 2113,
  [2165] = 2114,
  [2166] = 2115,
  [2167] = 2109,
  [2168] = 2116,
  [2169] = 2123,
  [2170] = 2126,
  [2171] = 2128,
  [2172] = 2109,
  [2173] = 2127,
  [2174] = 2127,
  [2175] = 2128,
  [2176] = 2112,
  [2177] = 2109,
  [2178] = 2134,
  [2179] = 2110,
  [2180] = 2142,
  [2181] = 2141,
  [2182] = 2119,
  [2183] = 2139,
  [2184] = 2126,
  [2185] = 2123,
  [2186] = 2115,
  [2187] = 2114,
  [2188] = 2113,
  [2189] = 2134,
  [2190] = 2111,
  [2191] = 2112,
  [2192] = 2156,
  [2193] = 2110,
  [2194] = 2139,
  [2195] = 2141,
  [2196] = 2142,
  [2197] = 2119,
  [2198] = 2117,
  [2199] = 2142,
  [2200] = 2141,
  [2201] = 2119,
  [2202] = 2139,
  [2203] = 2126,
  [2204] = 2123,
  [2205] = 2116,
  [2206] = 2110,
  [2207] = 2115,
  [2208] = 2156,
  [2209] = 2134,
  [2210] = 2114,
  [2211] = 2113,
  [2212] = 2116,
  [2213] = 2139,
  [2214] = 2116,
  [2215] = 2109,
  [2216] = 2111,
  [2217] = 2117,
  [2218] = 2127,
  [2219] = 2111,
  [2220] = 2156,
  [2221] = 2112,
  [2222] = 2156,
  [2223] = 2110,
  [2224] = 2134,
  [2225] = 2109,
  [2226] = 2128,
  [2227] = 2127,
  [2228] = 2156,
  [2229] = 2119,
  [2230] = 2127,
  [2231] = 2117,
  [2232] = 2128,
  [2233] = 2134,
  [2234] = 2112,
  [2235] = 2128,
  [2236] = 2109,
  [2237] = 2112,
  [2238] = 2134,
  [2239] = 2156,
  [2240] = 2117,
  [2241] = 2126,
  [2242] = 2156,
  [2243] = 2156,
  [2244] = 2116,
  [2245] = 2110,
  [2246] = 2111,
  [2247] = 2142,
  [2248] = 2113,
  [2249] = 2114,
  [2250] = 2141,
  [2251] = 2115,
  [2252] = 2139,
  [2253] = 2123,
  [2254] = 2126,
  [2255] = 2139,
  [2256] = 2126,
  [2257] = 2141,
  [2258] = 2142,
  [2259] = 2123,
  [2260] = 2115,
  [2261] = 2114,
  [2262] = 2119,
  [2263] = 2134,
  [2264] = 2109,
  [2265] = 2113,
  [2266] = 2111,
  [2267] = 2112,
  [2268] = 2117,
  [2269] = 2112,
  [2270] = 2141,
  [2271] = 2142,
  [2272] = 2110,
  [2273] = 2119,
  [2274] = 2116,
  [2275] = 2117,
  [2276] = 2112,
  [2277] = 2117,
  [2278] = 2119,
  [2279] = 2128,
  [2280] = 2111,
  [2281] = 2113,
  [2282] = 2115,
  [2283] = 2116,
  [2284] = 2114,
  [2285] = 2115,
  [2286] = 2128,
  [2287] = 2123,
  [2288] = 2126,
  [2289] = 2127,
  [2290] = 2117,
  [2291] = 2119,
  [2292] = 2127,
  [2293] = 2128,
  [2294] = 2139,
  [2295] = 2141,
  [2296] = 2134,
  [2297] = 2127,
  [2298] = 2110,
  [2299] = 2142,
  [2300] = 2300,
  [2301] = 2301,
  [2302] = 2302,
  [2303] = 2302,
  [2304] = 2301,
  [2305] = 2305,
  [2306] = 2306,
  [2307] = 2307,
  [2308] = 2300,
  [2309] = 2301,
  [2310] = 2302,
  [2311] = 2311,
  [2312] = 2312,
  [2313] = 2313,
  [2314] = 2301,
  [2315] = 2315,
  [2316] = 2316,
  [2317] = 2305,
  [2318] = 2313,
  [2319] = 2316,
  [2320] = 2302,
  [2321] = 2307,
  [2322] = 2315,
  [2323] = 2305,
  [2324] = 2311,
  [2325] = 2306,
  [2326] = 2302,
  [2327] = 2327,
  [2328] = 2300,
  [2329] = 2307,
  [2330] = 2306,
  [2331] = 2331,
  [2332] = 2332,
  [2333] = 2333,
  [2334] = 2316,
  [2335] = 2300,
  [2336] = 2307,
  [2337] = 2300,
  [2338] = 2327,
  [2339] = 2305,
  [2340] = 2315,
  [2341] = 2341,
  [2342] = 2307,
  [2343] = 2313,
  [2344] = 2315,
  [2345] = 2316,
  [2346] = 2316,
  [2347] = 2313,
  [2348] = 2302,
  [2349] = 2349,
  [2350] = 2301,
  [2351] = 2315,
  [2352] = 2352,
  [2353] = 2302,
  [2354] = 2327,
  [2355] = 2355,
  [2356] = 2305,
  [2357] = 2352,
  [2358] = 2327,
  [2359] = 2301,
  [2360] = 2360,
  [2361] = 2305,
  [2362] = 2306,
  [2363] = 2327,
  [2364] = 2364,
  [2365] = 2365,
  [2366] = 2306,
  [2367] = 2307,
  [2368] = 2305,
  [2369] = 2300,
  [2370] = 2327,
  [2371] = 2301,
  [2372] = 2372,
  [2373] = 2313,
  [2374] = 2316,
  [2375] = 2315,
  [2376] = 2306,
  [2377] = 2302,
  [2378] = 2301,
  [2379] = 2313,
  [2380] = 2305,
  [2381] = 2306,
  [2382] = 2307,
  [2383] = 2300,
  [2384] = 2327,
  [2385] = 2313,
  [2386] = 2316,
  [2387] = 2315,
  [2388] = 2316,
  [2389] = 2302,
  [2390] = 2306,
  [2391] = 2315,
  [2392] = 2302,
  [2393] = 2315,
  [2394] = 2301,
  [2395] = 2305,
  [2396] = 2316,
  [2397] = 2313,
  [2398] = 2306,
  [2399] = 2301,
  [2400] = 2307,
  [2401] = 2305,
  [2402] = 2327,
  [2403] = 2300,
  [2404] = 2307,
  [2405] = 2306,
  [2406] = 2307,
  [2407] = 2300,
  [2408] = 2327,
  [2409] = 2300,
  [2410] = 2327,
  [2411] = 2313,
  [2412] = 2316,
  [2413] = 2315,
  [2414] = 2313,
  [2415] = 2415,
  [2416] = 2416,
  [2417] = 2417,
  [2418] = 2418,
  [2419] = 2419,
  [2420] = 2420,
  [2421] = 2416,
  [2422] = 2422,
  [2423] = 2423,
  [2424] = 2424,
  [2425] = 2425,
  [2426] = 2426,
  [2427] = 2427,
  [2428] = 2428,
  [2429] = 2429,
  [2430] = 2420,
  [2431] = 2431,
  [2432] = 2432,
  [2433] = 2433,
  [2434] = 2416,
  [2435] = 2435,
  [2436] = 2436,
  [2437] = 2422,
  [2438] = 2423,
  [2439] = 2439,
  [2440] = 2440,
  [2441] = 2432,
  [2442] = 2442,
  [2443] = 2443,
  [2444] = 2444,
  [2445] = 2445,
  [2446] = 2446,
  [2447] = 2447,
  [2448] = 2448,
  [2449] = 2449,
  [2450] = 2450,
  [2451] = 2451,
  [2452] = 2415,
  [2453] = 2453,
  [2454] = 2454,
  [2455] = 2455,
  [2456] = 2424,
  [2457] = 2457,
  [2458] = 2458,
  [2459] = 2459,
  [2460] = 2460,
  [2461] = 2461,
  [2462] = 2462,
  [2463] = 2463,
  [2464] = 2464,
  [2465] = 2465,
  [2466] = 2466,
  [2467] = 2467,
  [2468] = 2468,
  [2469] = 2469,
  [2470] = 2470,
  [2471] = 2440,
  [2472] = 2425,
  [2473] = 2465,
  [2474] = 2442,
  [2475] = 2475,
  [2476] = 2476,
  [2477] = 2477,
  [2478] = 2478,
  [2479] = 2443,
  [2480] = 2480,
  [2481] = 2481,
  [2482] = 2482,
  [2483] = 2483,
  [2484] = 2484,
  [2485] = 2425,
  [2486] = 2486,
  [2487] = 2487,
  [2488] = 2486,
  [2489] = 2487,
  [2490] = 2484,
  [2491] = 2480,
  [2492] = 2478,
  [2493] = 2483,
  [2494] = 2482,
  [2495] = 2481,
  [2496] = 2475,
  [2497] = 2444,
  [2498] = 2498,
  [2499] = 2499,
  [2500] = 2420,
  [2501] = 2470,
  [2502] = 2502,
  [2503] = 2428,
  [2504] = 2429,
  [2505] = 2435,
  [2506] = 2439,
  [2507] = 2457,
  [2508] = 2418,
  [2509] = 2419,
  [2510] = 2426,
  [2511] = 2427,
  [2512] = 2416,
  [2513] = 2466,
  [2514] = 2431,
  [2515] = 2433,
  [2516] = 2464,
  [2517] = 2436,
  [2518] = 2463,
  [2519] = 2450,
  [2520] = 2451,
  [2521] = 2469,
  [2522] = 2454,
  [2523] = 2455,
  [2524] = 2422,
  [2525] = 2459,
  [2526] = 2465,
  [2527] = 2467,
  [2528] = 2468,
  [2529] = 2529,
  [2530] = 2417,
  [2531] = 2423,
  [2532] = 2424,
  [2533] = 2425,
  [2534] = 2462,
  [2535] = 2461,
  [2536] = 2420,
  [2537] = 2416,
  [2538] = 2460,
  [2539] = 2422,
  [2540] = 2423,
  [2541] = 2458,
  [2542] = 2424,
  [2543] = 2425,
  [2544] = 2422,
  [2545] = 2432,
  [2546] = 2453,
  [2547] = 2449,
  [2548] = 2448,
  [2549] = 2447,
  [2550] = 2446,
  [2551] = 2420,
  [2552] = 2445,
  [2553] = 2440,
  [2554] = 2416,
  [2555] = 2442,
  [2556] = 2443,
  [2557] = 2444,
  [2558] = 2445,
  [2559] = 2446,
  [2560] = 2447,
  [2561] = 2448,
  [2562] = 2449,
  [2563] = 2444,
  [2564] = 2443,
  [2565] = 2442,
  [2566] = 2453,
  [2567] = 2445,
  [2568] = 2440,
  [2569] = 2446,
  [2570] = 2424,
  [2571] = 2458,
  [2572] = 2432,
  [2573] = 2460,
  [2574] = 2461,
  [2575] = 2462,
  [2576] = 2463,
  [2577] = 2464,
  [2578] = 2423,
  [2579] = 2466,
  [2580] = 2451,
  [2581] = 2422,
  [2582] = 2448,
  [2583] = 2416,
  [2584] = 2420,
  [2585] = 2425,
  [2586] = 2475,
  [2587] = 2424,
  [2588] = 2423,
  [2589] = 2478,
  [2590] = 2422,
  [2591] = 2480,
  [2592] = 2449,
  [2593] = 2417,
  [2594] = 2529,
  [2595] = 2484,
  [2596] = 2468,
  [2597] = 2467,
  [2598] = 2487,
  [2599] = 2486,
  [2600] = 2422,
  [2601] = 2483,
  [2602] = 2459,
  [2603] = 2455,
  [2604] = 2483,
  [2605] = 2482,
  [2606] = 2481,
  [2607] = 2454,
  [2608] = 2423,
  [2609] = 2424,
  [2610] = 2417,
  [2611] = 2529,
  [2612] = 2470,
  [2613] = 2468,
  [2614] = 2428,
  [2615] = 2429,
  [2616] = 2435,
  [2617] = 2439,
  [2618] = 2457,
  [2619] = 2418,
  [2620] = 2419,
  [2621] = 2426,
  [2622] = 2427,
  [2623] = 2467,
  [2624] = 2415,
  [2625] = 2431,
  [2626] = 2433,
  [2627] = 2451,
  [2628] = 2436,
  [2629] = 2465,
  [2630] = 2450,
  [2631] = 2451,
  [2632] = 2415,
  [2633] = 2454,
  [2634] = 2455,
  [2635] = 2459,
  [2636] = 2459,
  [2637] = 2465,
  [2638] = 2467,
  [2639] = 2468,
  [2640] = 2529,
  [2641] = 2417,
  [2642] = 2455,
  [2643] = 2425,
  [2644] = 2450,
  [2645] = 2416,
  [2646] = 2420,
  [2647] = 2416,
  [2648] = 2436,
  [2649] = 2433,
  [2650] = 2650,
  [2651] = 2651,
  [2652] = 2431,
  [2653] = 2499,
  [2654] = 2498,
  [2655] = 2420,
  [2656] = 2432,
  [2657] = 2427,
  [2658] = 2477,
  [2659] = 2426,
  [2660] = 2423,
  [2661] = 2424,
  [2662] = 2419,
  [2663] = 2440,
  [2664] = 2664,
  [2665] = 2442,
  [2666] = 2443,
  [2667] = 2444,
  [2668] = 2445,
  [2669] = 2446,
  [2670] = 2447,
  [2671] = 2448,
  [2672] = 2449,
  [2673] = 2418,
  [2674] = 2457,
  [2675] = 2439,
  [2676] = 2453,
  [2677] = 2435,
  [2678] = 2454,
  [2679] = 2429,
  [2680] = 2458,
  [2681] = 2428,
  [2682] = 2460,
  [2683] = 2461,
  [2684] = 2462,
  [2685] = 2463,
  [2686] = 2464,
  [2687] = 2470,
  [2688] = 2466,
  [2689] = 2415,
  [2690] = 2476,
  [2691] = 2425,
  [2692] = 2425,
  [2693] = 2693,
  [2694] = 2481,
  [2695] = 2475,
  [2696] = 2482,
  [2697] = 2461,
  [2698] = 2478,
  [2699] = 2424,
  [2700] = 2480,
  [2701] = 2486,
  [2702] = 2487,
  [2703] = 2484,
  [2704] = 2484,
  [2705] = 2480,
  [2706] = 2478,
  [2707] = 2487,
  [2708] = 2486,
  [2709] = 2469,
  [2710] = 2475,
  [2711] = 2423,
  [2712] = 2466,
  [2713] = 2483,
  [2714] = 2482,
  [2715] = 2481,
  [2716] = 2464,
  [2717] = 2450,
  [2718] = 2463,
  [2719] = 2470,
  [2720] = 2462,
  [2721] = 2428,
  [2722] = 2429,
  [2723] = 2435,
  [2724] = 2439,
  [2725] = 2457,
  [2726] = 2418,
  [2727] = 2419,
  [2728] = 2426,
  [2729] = 2427,
  [2730] = 2436,
  [2731] = 2428,
  [2732] = 2431,
  [2733] = 2433,
  [2734] = 2460,
  [2735] = 2436,
  [2736] = 2450,
  [2737] = 2451,
  [2738] = 2415,
  [2739] = 2454,
  [2740] = 2458,
  [2741] = 2664,
  [2742] = 2693,
  [2743] = 2453,
  [2744] = 2449,
  [2745] = 2448,
  [2746] = 2447,
  [2747] = 2446,
  [2748] = 2445,
  [2749] = 2475,
  [2750] = 2444,
  [2751] = 2432,
  [2752] = 2443,
  [2753] = 2753,
  [2754] = 2442,
  [2755] = 2755,
  [2756] = 2440,
  [2757] = 2440,
  [2758] = 2433,
  [2759] = 2442,
  [2760] = 2443,
  [2761] = 2444,
  [2762] = 2422,
  [2763] = 2432,
  [2764] = 2529,
  [2765] = 2453,
  [2766] = 2420,
  [2767] = 2431,
  [2768] = 2447,
  [2769] = 2458,
  [2770] = 2425,
  [2771] = 2460,
  [2772] = 2461,
  [2773] = 2462,
  [2774] = 2463,
  [2775] = 2424,
  [2776] = 2466,
  [2777] = 2777,
  [2778] = 2423,
  [2779] = 2422,
  [2780] = 2427,
  [2781] = 2426,
  [2782] = 2651,
  [2783] = 2475,
  [2784] = 2453,
  [2785] = 2417,
  [2786] = 2478,
  [2787] = 2529,
  [2788] = 2480,
  [2789] = 2468,
  [2790] = 2467,
  [2791] = 2465,
  [2792] = 2484,
  [2793] = 2459,
  [2794] = 2455,
  [2795] = 2487,
  [2796] = 2486,
  [2797] = 2797,
  [2798] = 2454,
  [2799] = 2415,
  [2800] = 2451,
  [2801] = 2483,
  [2802] = 2482,
  [2803] = 2481,
  [2804] = 2419,
  [2805] = 2418,
  [2806] = 2457,
  [2807] = 2470,
  [2808] = 2439,
  [2809] = 2428,
  [2810] = 2429,
  [2811] = 2435,
  [2812] = 2439,
  [2813] = 2457,
  [2814] = 2418,
  [2815] = 2419,
  [2816] = 2426,
  [2817] = 2427,
  [2818] = 2450,
  [2819] = 526,
  [2820] = 2431,
  [2821] = 2433,
  [2822] = 2436,
  [2823] = 2436,
  [2824] = 2450,
  [2825] = 2451,
  [2826] = 2415,
  [2827] = 2454,
  [2828] = 2828,
  [2829] = 2650,
  [2830] = 2435,
  [2831] = 2433,
  [2832] = 2499,
  [2833] = 2498,
  [2834] = 2431,
  [2835] = 2432,
  [2836] = 2427,
  [2837] = 2477,
  [2838] = 2426,
  [2839] = 2419,
  [2840] = 2440,
  [2841] = 2429,
  [2842] = 2442,
  [2843] = 2443,
  [2844] = 2444,
  [2845] = 2418,
  [2846] = 2457,
  [2847] = 2439,
  [2848] = 2453,
  [2849] = 2428,
  [2850] = 2435,
  [2851] = 2458,
  [2852] = 2429,
  [2853] = 2460,
  [2854] = 2461,
  [2855] = 2462,
  [2856] = 2463,
  [2857] = 2478,
  [2858] = 2466,
  [2859] = 2470,
  [2860] = 2470,
  [2861] = 2460,
  [2862] = 2469,
  [2863] = 2461,
  [2864] = 2476,
  [2865] = 2475,
  [2866] = 2462,
  [2867] = 2463,
  [2868] = 2478,
  [2869] = 2650,
  [2870] = 2480,
  [2871] = 2481,
  [2872] = 2482,
  [2873] = 2483,
  [2874] = 2484,
  [2875] = 2651,
  [2876] = 2486,
  [2877] = 2487,
  [2878] = 2486,
  [2879] = 2487,
  [2880] = 2484,
  [2881] = 2480,
  [2882] = 2468,
  [2883] = 2483,
  [2884] = 2482,
  [2885] = 2664,
  [2886] = 2693,
  [2887] = 2475,
  [2888] = 2470,
  [2889] = 2476,
  [2890] = 2428,
  [2891] = 2429,
  [2892] = 2435,
  [2893] = 2439,
  [2894] = 2457,
  [2895] = 2418,
  [2896] = 2419,
  [2897] = 2426,
  [2898] = 2427,
  [2899] = 2899,
  [2900] = 2900,
  [2901] = 2431,
  [2902] = 2433,
  [2903] = 2903,
  [2904] = 2436,
  [2905] = 2450,
  [2906] = 2451,
  [2907] = 2415,
  [2908] = 2454,
  [2909] = 2466,
  [2910] = 2464,
  [2911] = 2463,
  [2912] = 2462,
  [2913] = 2753,
  [2914] = 2755,
  [2915] = 2461,
  [2916] = 2432,
  [2917] = 2460,
  [2918] = 2777,
  [2919] = 2797,
  [2920] = 2458,
  [2921] = 2440,
  [2922] = 2828,
  [2923] = 2442,
  [2924] = 2443,
  [2925] = 2444,
  [2926] = 2464,
  [2927] = 2453,
  [2928] = 2449,
  [2929] = 2453,
  [2930] = 2650,
  [2931] = 2448,
  [2932] = 2458,
  [2933] = 2447,
  [2934] = 2460,
  [2935] = 2461,
  [2936] = 2462,
  [2937] = 2463,
  [2938] = 2446,
  [2939] = 2466,
  [2940] = 2499,
  [2941] = 2481,
  [2942] = 2482,
  [2943] = 2483,
  [2944] = 2498,
  [2945] = 2445,
  [2946] = 2444,
  [2947] = 2828,
  [2948] = 2797,
  [2949] = 2777,
  [2950] = 2755,
  [2951] = 2477,
  [2952] = 2443,
  [2953] = 2753,
  [2954] = 2469,
  [2955] = 2442,
  [2956] = 2664,
  [2957] = 2693,
  [2958] = 2958,
  [2959] = 2440,
  [2960] = 2432,
  [2961] = 2651,
  [2962] = 2651,
  [2963] = 2651,
  [2964] = 2651,
  [2965] = 2651,
  [2966] = 2693,
  [2967] = 2664,
  [2968] = 2651,
  [2969] = 2417,
  [2970] = 2469,
  [2971] = 2477,
  [2972] = 2498,
  [2973] = 2499,
  [2974] = 2529,
  [2975] = 2753,
  [2976] = 2650,
  [2977] = 2899,
  [2978] = 2900,
  [2979] = 2903,
  [2980] = 2958,
  [2981] = 2420,
  [2982] = 2416,
  [2983] = 2828,
  [2984] = 2797,
  [2985] = 2777,
  [2986] = 2755,
  [2987] = 2478,
  [2988] = 2651,
  [2989] = 2753,
  [2990] = 2467,
  [2991] = 2465,
  [2992] = 2753,
  [2993] = 2755,
  [2994] = 2777,
  [2995] = 2459,
  [2996] = 2797,
  [2997] = 2458,
  [2998] = 2828,
  [2999] = 2958,
  [3000] = 2455,
  [3001] = 2454,
  [3002] = 2693,
  [3003] = 2664,
  [3004] = 2755,
  [3005] = 2415,
  [3006] = 2469,
  [3007] = 2477,
  [3008] = 2498,
  [3009] = 2499,
  [3010] = 2451,
  [3011] = 2650,
  [3012] = 2899,
  [3013] = 2900,
  [3014] = 2903,
  [3015] = 2958,
  [3016] = 2828,
  [3017] = 2797,
  [3018] = 2777,
  [3019] = 2755,
  [3020] = 2903,
  [3021] = 2450,
  [3022] = 2753,
  [3023] = 2900,
  [3024] = 2899,
  [3025] = 2650,
  [3026] = 2499,
  [3027] = 2498,
  [3028] = 2777,
  [3029] = 2477,
  [3030] = 2436,
  [3031] = 2797,
  [3032] = 2486,
  [3033] = 2433,
  [3034] = 2431,
  [3035] = 2693,
  [3036] = 2664,
  [3037] = 2487,
  [3038] = 2427,
  [3039] = 2469,
  [3040] = 2477,
  [3041] = 2498,
  [3042] = 2499,
  [3043] = 2426,
  [3044] = 2650,
  [3045] = 2899,
  [3046] = 2900,
  [3047] = 2903,
  [3048] = 2958,
  [3049] = 2828,
  [3050] = 2797,
  [3051] = 2777,
  [3052] = 2755,
  [3053] = 2419,
  [3054] = 2753,
  [3055] = 2418,
  [3056] = 2457,
  [3057] = 2439,
  [3058] = 2828,
  [3059] = 2435,
  [3060] = 2429,
  [3061] = 2693,
  [3062] = 2664,
  [3063] = 2484,
  [3064] = 2428,
  [3065] = 2469,
  [3066] = 2477,
  [3067] = 2498,
  [3068] = 2499,
  [3069] = 3069,
  [3070] = 2650,
  [3071] = 2899,
  [3072] = 2900,
  [3073] = 2903,
  [3074] = 2958,
  [3075] = 2828,
  [3076] = 2797,
  [3077] = 2777,
  [3078] = 2755,
  [3079] = 2470,
  [3080] = 2753,
  [3081] = 511,
  [3082] = 2476,
  [3083] = 2466,
  [3084] = 3084,
  [3085] = 2481,
  [3086] = 2693,
  [3087] = 2664,
  [3088] = 2482,
  [3089] = 2469,
  [3090] = 2477,
  [3091] = 2498,
  [3092] = 2499,
  [3093] = 2483,
  [3094] = 2650,
  [3095] = 2899,
  [3096] = 2900,
  [3097] = 2903,
  [3098] = 2958,
  [3099] = 2828,
  [3100] = 2797,
  [3101] = 2777,
  [3102] = 2755,
  [3103] = 2486,
  [3104] = 2753,
  [3105] = 2487,
  [3106] = 2484,
  [3107] = 2480,
  [3108] = 2480,
  [3109] = 2478,
  [3110] = 2693,
  [3111] = 2664,
  [3112] = 2475,
  [3113] = 3113,
  [3114] = 3114,
  [3115] = 3115,
  [3116] = 3116,
  [3117] = 3114,
  [3118] = 3118,
  [3119] = 3119,
  [3120] = 3118,
  [3121] = 3119,
  [3122] = 3115,
  [3123] = 3116,
  [3124] = 3124,
  [3125] = 3115,
  [3126] = 3126,
  [3127] = 3116,
  [3128] = 3124,
  [3129] = 3124,
  [3130] = 3126,
  [3131] = 3114,
  [3132] = 3126,
  [3133] = 3118,
  [3134] = 3119,
  [3135] = 3135,
  [3136] = 3126,
  [3137] = 3124,
  [3138] = 3116,
  [3139] = 3115,
  [3140] = 3119,
  [3141] = 3118,
  [3142] = 3114,
  [3143] = 3143,
  [3144] = 3114,
  [3145] = 3126,
  [3146] = 3124,
  [3147] = 3114,
  [3148] = 3116,
  [3149] = 3115,
  [3150] = 3126,
  [3151] = 3119,
  [3152] = 3118,
  [3153] = 3114,
  [3154] = 3126,
  [3155] = 3124,
  [3156] = 3116,
  [3157] = 3115,
  [3158] = 3119,
  [3159] = 3118,
  [3160] = 3114,
  [3161] = 3161,
  [3162] = 3162,
  [3163] = 3118,
  [3164] = 3119,
  [3165] = 3115,
  [3166] = 3166,
  [3167] = 3114,
  [3168] = 3168,
  [3169] = 3169,
  [3170] = 3126,
  [3171] = 3116,
  [3172] = 3161,
  [3173] = 3126,
  [3174] = 3124,
  [3175] = 3175,
  [3176] = 3176,
  [3177] = 3177,
  [3178] = 3143,
  [3179] = 3179,
  [3180] = 3166,
  [3181] = 3168,
  [3182] = 3169,
  [3183] = 3161,
  [3184] = 3135,
  [3185] = 3143,
  [3186] = 3186,
  [3187] = 3114,
  [3188] = 3188,
  [3189] = 3166,
  [3190] = 3126,
  [3191] = 3168,
  [3192] = 3169,
  [3193] = 3193,
  [3194] = 3194,
  [3195] = 3186,
  [3196] = 3196,
  [3197] = 3161,
  [3198] = 3135,
  [3199] = 3143,
  [3200] = 3166,
  [3201] = 3168,
  [3202] = 3169,
  [3203] = 3203,
  [3204] = 3193,
  [3205] = 3205,
  [3206] = 3194,
  [3207] = 3203,
  [3208] = 3196,
  [3209] = 3161,
  [3210] = 3135,
  [3211] = 3135,
  [3212] = 3212,
  [3213] = 3213,
  [3214] = 3143,
  [3215] = 3215,
  [3216] = 3216,
  [3217] = 3217,
  [3218] = 3161,
  [3219] = 3196,
  [3220] = 3186,
  [3221] = 3166,
  [3222] = 3168,
  [3223] = 3169,
  [3224] = 3194,
  [3225] = 3203,
  [3226] = 3193,
  [3227] = 3205,
  [3228] = 3194,
  [3229] = 3186,
  [3230] = 3196,
  [3231] = 3161,
  [3232] = 3135,
  [3233] = 3205,
  [3234] = 3193,
  [3235] = 3166,
  [3236] = 3236,
  [3237] = 3237,
  [3238] = 3169,
  [3239] = 3143,
  [3240] = 3168,
  [3241] = 3241,
  [3242] = 3242,
  [3243] = 3243,
  [3244] = 3166,
  [3245] = 3168,
  [3246] = 3169,
  [3247] = 3203,
  [3248] = 3193,
  [3249] = 3205,
  [3250] = 3194,
  [3251] = 3186,
  [3252] = 3196,
  [3253] = 3161,
  [3254] = 3135,
  [3255] = 3255,
  [3256] = 3143,
  [3257] = 3166,
  [3258] = 3168,
  [3259] = 3169,
  [3260] = 3203,
  [3261] = 3193,
  [3262] = 3205,
  [3263] = 3194,
  [3264] = 3186,
  [3265] = 3196,
  [3266] = 3161,
  [3267] = 3135,
  [3268] = 495,
  [3269] = 494,
  [3270] = 493,
  [3271] = 492,
  [3272] = 3143,
  [3273] = 3143,
  [3274] = 3274,
  [3275] = 3166,
  [3276] = 3168,
  [3277] = 3169,
  [3278] = 3203,
  [3279] = 3193,
  [3280] = 3205,
  [3281] = 3194,
  [3282] = 3186,
  [3283] = 3196,
  [3284] = 3161,
  [3285] = 3135,
  [3286] = 3286,
  [3287] = 527,
  [3288] = 3166,
  [3289] = 3168,
  [3290] = 3169,
  [3291] = 3203,
  [3292] = 3193,
  [3293] = 3205,
  [3294] = 3194,
  [3295] = 3186,
  [3296] = 3196,
  [3297] = 3161,
  [3298] = 3135,
  [3299] = 3299,
  [3300] = 3143,
};

static inline bool sym_word_character_set_1(int32_t c) {
  return (c < '('
    ? (c < '\r'
      ? (c < '\t'
        ? c == 0
        : c <= '\n')
      : (c <= '\r' || (c < '#'
        ? c == ' '
        : c <= '%')))
    : (c <= '-' || (c < '['
      ? (c < '='
        ? c == '/'
        : c <= '=')
      : (c <= '_' || (c < '}'
        ? c == '{'
        : c <= '}')))));
}

static inline bool sym_path_character_set_1(int32_t c) {
  return (c < ':'
    ? (c < '*'
      ? (c < '"'
        ? c == 0
        : c <= '"')
      : (c <= '*' || c == ','))
    : (c <= '<' || (c < ']'
      ? (c < '['
        ? c == '>'
        : c <= '[')
      : (c <= ']' || (c >= '{' && c <= '|')))));
}

static inline bool sym_path_character_set_2(int32_t c) {
  return (c < ':'
    ? (c < '*'
      ? (c < '"'
        ? c == 0
        : c <= '"')
      : (c <= '*' || c == ','))
    : (c <= '<' || (c < ']'
      ? (c < '['
        ? c == '>'
        : c <= '[')
      : (c <= ']' || (c >= '{' && c <= '}')))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(40);
      if (lookahead == '!') ADVANCE(189);
      if (lookahead == '#') ADVANCE(34);
      if (lookahead == '$') ADVANCE(198);
      if (lookahead == '%') ADVANCE(46);
      if (lookahead == '\'') ADVANCE(192);
      if (lookahead == '(') ADVANCE(53);
      if (lookahead == ')') ADVANCE(54);
      if (lookahead == '*') ADVANCE(185);
      if (lookahead == '+') ADVANCE(183);
      if (lookahead == ',') ADVANCE(51);
      if (lookahead == '-') ADVANCE(184);
      if (lookahead == '/') ADVANCE(186);
      if (lookahead == ':') ADVANCE(191);
      if (lookahead == '<') ADVANCE(187);
      if (lookahead == '=') ADVANCE(52);
      if (lookahead == '>') ADVANCE(188);
      if (lookahead == '[') ADVANCE(49);
      if (lookahead == '\\') ADVANCE(229);
      if (lookahead == ']') ADVANCE(50);
      if (lookahead == '^') ADVANCE(194);
      if (lookahead == '_') ADVANCE(193);
      if (lookahead == 'a') ADVANCE(120);
      if (lookahead == 'c') ADVANCE(141);
      if (lookahead == 'd') ADVANCE(111);
      if (lookahead == 'e') ADVANCE(147);
      if (lookahead == 'f') ADVANCE(121);
      if (lookahead == 'g') ADVANCE(81);
      if (lookahead == 'l') ADVANCE(156);
      if (lookahead == 'm') ADVANCE(109);
      if (lookahead == 'p') ADVANCE(174);
      if (lookahead == 's') ADVANCE(106);
      if (lookahead == 'v') ADVANCE(97);
      if (lookahead == '{') ADVANCE(77);
      if (lookahead == '|') ADVANCE(190);
      if (lookahead == '}') ADVANCE(78);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(41);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(178);
      if (lookahead != 0) ADVANCE(178);
      END_STATE();
    case 1:
      if (lookahead == '!') ADVANCE(189);
      if (lookahead == '#') ADVANCE(34);
      if (lookahead == '$') ADVANCE(198);
      if (lookahead == '%') ADVANCE(46);
      if (lookahead == '\'') ADVANCE(192);
      if (lookahead == '(') ADVANCE(53);
      if (lookahead == ')') ADVANCE(54);
      if (lookahead == '*') ADVANCE(185);
      if (lookahead == '+') ADVANCE(183);
      if (lookahead == ',') ADVANCE(51);
      if (lookahead == '-') ADVANCE(184);
      if (lookahead == '/') ADVANCE(186);
      if (lookahead == ':') ADVANCE(191);
      if (lookahead == '<') ADVANCE(187);
      if (lookahead == '=') ADVANCE(52);
      if (lookahead == '>') ADVANCE(188);
      if (lookahead == '[') ADVANCE(49);
      if (lookahead == '\\') ADVANCE(230);
      if (lookahead == ']') ADVANCE(50);
      if (lookahead == '^') ADVANCE(194);
      if (lookahead == '_') ADVANCE(193);
      if (lookahead == 's') ADVANCE(107);
      if (lookahead == '{') ADVANCE(77);
      if (lookahead == '|') ADVANCE(190);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(41);
      if (lookahead != 0 &&
          lookahead != '}') ADVANCE(178);
      END_STATE();
    case 2:
      if (lookahead == '!') ADVANCE(189);
      if (lookahead == '#') ADVANCE(34);
      if (lookahead == '$') ADVANCE(198);
      if (lookahead == '%') ADVANCE(46);
      if (lookahead == '\'') ADVANCE(192);
      if (lookahead == '(') ADVANCE(53);
      if (lookahead == ')') ADVANCE(54);
      if (lookahead == '*') ADVANCE(185);
      if (lookahead == '+') ADVANCE(183);
      if (lookahead == ',') ADVANCE(51);
      if (lookahead == '-') ADVANCE(184);
      if (lookahead == '/') ADVANCE(186);
      if (lookahead == ':') ADVANCE(191);
      if (lookahead == '<') ADVANCE(187);
      if (lookahead == '=') ADVANCE(52);
      if (lookahead == '>') ADVANCE(188);
      if (lookahead == '[') ADVANCE(49);
      if (lookahead == '\\') ADVANCE(236);
      if (lookahead == ']') ADVANCE(50);
      if (lookahead == '^') ADVANCE(194);
      if (lookahead == '_') ADVANCE(193);
      if (lookahead == 's') ADVANCE(107);
      if (lookahead == '{') ADVANCE(77);
      if (lookahead == '|') ADVANCE(190);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(41);
      if (lookahead != 0 &&
          lookahead != '}') ADVANCE(178);
      END_STATE();
    case 3:
      if (lookahead == '!') ADVANCE(189);
      if (lookahead == '#') ADVANCE(34);
      if (lookahead == '$') ADVANCE(198);
      if (lookahead == '%') ADVANCE(46);
      if (lookahead == '\'') ADVANCE(192);
      if (lookahead == '(') ADVANCE(53);
      if (lookahead == ')') ADVANCE(54);
      if (lookahead == '*') ADVANCE(185);
      if (lookahead == '+') ADVANCE(183);
      if (lookahead == ',') ADVANCE(51);
      if (lookahead == '-') ADVANCE(184);
      if (lookahead == '/') ADVANCE(186);
      if (lookahead == ':') ADVANCE(191);
      if (lookahead == '<') ADVANCE(187);
      if (lookahead == '=') ADVANCE(52);
      if (lookahead == '>') ADVANCE(188);
      if (lookahead == '[') ADVANCE(49);
      if (lookahead == '\\') ADVANCE(231);
      if (lookahead == ']') ADVANCE(50);
      if (lookahead == '^') ADVANCE(194);
      if (lookahead == '_') ADVANCE(193);
      if (lookahead == 's') ADVANCE(107);
      if (lookahead == '{') ADVANCE(77);
      if (lookahead == '|') ADVANCE(190);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(41);
      if (lookahead != 0 &&
          lookahead != '}') ADVANCE(178);
      END_STATE();
    case 4:
      if (lookahead == '!') ADVANCE(189);
      if (lookahead == '#') ADVANCE(34);
      if (lookahead == '$') ADVANCE(198);
      if (lookahead == '%') ADVANCE(46);
      if (lookahead == '\'') ADVANCE(192);
      if (lookahead == '(') ADVANCE(53);
      if (lookahead == ')') ADVANCE(54);
      if (lookahead == '*') ADVANCE(185);
      if (lookahead == '+') ADVANCE(183);
      if (lookahead == ',') ADVANCE(51);
      if (lookahead == '-') ADVANCE(184);
      if (lookahead == '/') ADVANCE(186);
      if (lookahead == ':') ADVANCE(191);
      if (lookahead == '<') ADVANCE(187);
      if (lookahead == '=') ADVANCE(52);
      if (lookahead == '>') ADVANCE(188);
      if (lookahead == '[') ADVANCE(49);
      if (lookahead == '\\') ADVANCE(237);
      if (lookahead == ']') ADVANCE(50);
      if (lookahead == '^') ADVANCE(194);
      if (lookahead == '_') ADVANCE(193);
      if (lookahead == 's') ADVANCE(107);
      if (lookahead == '{') ADVANCE(77);
      if (lookahead == '|') ADVANCE(190);
      if (lookahead == '}') ADVANCE(78);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(41);
      if (lookahead != 0) ADVANCE(178);
      END_STATE();
    case 5:
      if (lookahead == '!') ADVANCE(189);
      if (lookahead == '#') ADVANCE(34);
      if (lookahead == '$') ADVANCE(198);
      if (lookahead == '%') ADVANCE(46);
      if (lookahead == '\'') ADVANCE(192);
      if (lookahead == '(') ADVANCE(53);
      if (lookahead == ')') ADVANCE(54);
      if (lookahead == '*') ADVANCE(185);
      if (lookahead == '+') ADVANCE(183);
      if (lookahead == ',') ADVANCE(51);
      if (lookahead == '-') ADVANCE(184);
      if (lookahead == '/') ADVANCE(186);
      if (lookahead == ':') ADVANCE(191);
      if (lookahead == '<') ADVANCE(187);
      if (lookahead == '=') ADVANCE(52);
      if (lookahead == '>') ADVANCE(188);
      if (lookahead == '[') ADVANCE(49);
      if (lookahead == '\\') ADVANCE(232);
      if (lookahead == ']') ADVANCE(50);
      if (lookahead == '^') ADVANCE(194);
      if (lookahead == '_') ADVANCE(193);
      if (lookahead == 's') ADVANCE(107);
      if (lookahead == '{') ADVANCE(77);
      if (lookahead == '|') ADVANCE(190);
      if (lookahead == '}') ADVANCE(78);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(41);
      if (lookahead != 0) ADVANCE(178);
      END_STATE();
    case 6:
      if (lookahead == '!') ADVANCE(189);
      if (lookahead == '#') ADVANCE(34);
      if (lookahead == '$') ADVANCE(198);
      if (lookahead == '%') ADVANCE(46);
      if (lookahead == '\'') ADVANCE(192);
      if (lookahead == '(') ADVANCE(53);
      if (lookahead == ')') ADVANCE(54);
      if (lookahead == '*') ADVANCE(185);
      if (lookahead == '+') ADVANCE(183);
      if (lookahead == ',') ADVANCE(51);
      if (lookahead == '-') ADVANCE(184);
      if (lookahead == '/') ADVANCE(186);
      if (lookahead == ':') ADVANCE(191);
      if (lookahead == '<') ADVANCE(187);
      if (lookahead == '=') ADVANCE(52);
      if (lookahead == '>') ADVANCE(188);
      if (lookahead == '[') ADVANCE(49);
      if (lookahead == '\\') ADVANCE(241);
      if (lookahead == ']') ADVANCE(50);
      if (lookahead == '^') ADVANCE(194);
      if (lookahead == '_') ADVANCE(193);
      if (lookahead == 's') ADVANCE(107);
      if (lookahead == '{') ADVANCE(77);
      if (lookahead == '|') ADVANCE(190);
      if (lookahead == '}') ADVANCE(78);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(41);
      if (lookahead != 0) ADVANCE(178);
      END_STATE();
    case 7:
      if (lookahead == '!') ADVANCE(189);
      if (lookahead == '#') ADVANCE(34);
      if (lookahead == '$') ADVANCE(198);
      if (lookahead == '%') ADVANCE(46);
      if (lookahead == '\'') ADVANCE(192);
      if (lookahead == '(') ADVANCE(53);
      if (lookahead == ')') ADVANCE(54);
      if (lookahead == '*') ADVANCE(185);
      if (lookahead == '+') ADVANCE(183);
      if (lookahead == ',') ADVANCE(51);
      if (lookahead == '-') ADVANCE(184);
      if (lookahead == '/') ADVANCE(186);
      if (lookahead == ':') ADVANCE(191);
      if (lookahead == '<') ADVANCE(187);
      if (lookahead == '=') ADVANCE(52);
      if (lookahead == '>') ADVANCE(188);
      if (lookahead == '[') ADVANCE(49);
      if (lookahead == '\\') ADVANCE(238);
      if (lookahead == ']') ADVANCE(50);
      if (lookahead == '^') ADVANCE(194);
      if (lookahead == '_') ADVANCE(193);
      if (lookahead == 's') ADVANCE(107);
      if (lookahead == '{') ADVANCE(77);
      if (lookahead == '|') ADVANCE(190);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(41);
      if (lookahead != 0 &&
          lookahead != '}') ADVANCE(178);
      END_STATE();
    case 8:
      if (lookahead == '!') ADVANCE(189);
      if (lookahead == '#') ADVANCE(34);
      if (lookahead == '$') ADVANCE(198);
      if (lookahead == '%') ADVANCE(46);
      if (lookahead == '\'') ADVANCE(192);
      if (lookahead == '(') ADVANCE(53);
      if (lookahead == ')') ADVANCE(54);
      if (lookahead == '*') ADVANCE(185);
      if (lookahead == '+') ADVANCE(183);
      if (lookahead == ',') ADVANCE(51);
      if (lookahead == '-') ADVANCE(184);
      if (lookahead == '/') ADVANCE(186);
      if (lookahead == ':') ADVANCE(191);
      if (lookahead == '<') ADVANCE(187);
      if (lookahead == '=') ADVANCE(52);
      if (lookahead == '>') ADVANCE(188);
      if (lookahead == '[') ADVANCE(49);
      if (lookahead == '\\') ADVANCE(233);
      if (lookahead == ']') ADVANCE(50);
      if (lookahead == '^') ADVANCE(194);
      if (lookahead == '_') ADVANCE(193);
      if (lookahead == 's') ADVANCE(107);
      if (lookahead == '{') ADVANCE(77);
      if (lookahead == '|') ADVANCE(190);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(41);
      if (lookahead != 0 &&
          lookahead != '}') ADVANCE(178);
      END_STATE();
    case 9:
      if (lookahead == '!') ADVANCE(189);
      if (lookahead == '#') ADVANCE(34);
      if (lookahead == '$') ADVANCE(198);
      if (lookahead == '%') ADVANCE(46);
      if (lookahead == '\'') ADVANCE(192);
      if (lookahead == '(') ADVANCE(53);
      if (lookahead == ')') ADVANCE(54);
      if (lookahead == '*') ADVANCE(185);
      if (lookahead == '+') ADVANCE(183);
      if (lookahead == ',') ADVANCE(51);
      if (lookahead == '-') ADVANCE(184);
      if (lookahead == '/') ADVANCE(186);
      if (lookahead == ':') ADVANCE(191);
      if (lookahead == '<') ADVANCE(187);
      if (lookahead == '=') ADVANCE(52);
      if (lookahead == '>') ADVANCE(188);
      if (lookahead == '[') ADVANCE(49);
      if (lookahead == '\\') ADVANCE(242);
      if (lookahead == ']') ADVANCE(50);
      if (lookahead == '^') ADVANCE(194);
      if (lookahead == '_') ADVANCE(193);
      if (lookahead == 's') ADVANCE(107);
      if (lookahead == '{') ADVANCE(77);
      if (lookahead == '|') ADVANCE(190);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(41);
      if (lookahead != 0 &&
          lookahead != '}') ADVANCE(178);
      END_STATE();
    case 10:
      if (lookahead == '!') ADVANCE(189);
      if (lookahead == '#') ADVANCE(34);
      if (lookahead == '$') ADVANCE(198);
      if (lookahead == '%') ADVANCE(46);
      if (lookahead == '\'') ADVANCE(192);
      if (lookahead == '(') ADVANCE(53);
      if (lookahead == ')') ADVANCE(54);
      if (lookahead == '*') ADVANCE(185);
      if (lookahead == '+') ADVANCE(183);
      if (lookahead == ',') ADVANCE(51);
      if (lookahead == '-') ADVANCE(184);
      if (lookahead == '/') ADVANCE(186);
      if (lookahead == ':') ADVANCE(191);
      if (lookahead == '<') ADVANCE(187);
      if (lookahead == '=') ADVANCE(52);
      if (lookahead == '>') ADVANCE(188);
      if (lookahead == '[') ADVANCE(49);
      if (lookahead == '\\') ADVANCE(246);
      if (lookahead == ']') ADVANCE(50);
      if (lookahead == '^') ADVANCE(194);
      if (lookahead == '_') ADVANCE(193);
      if (lookahead == 's') ADVANCE(107);
      if (lookahead == '{') ADVANCE(77);
      if (lookahead == '|') ADVANCE(190);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(41);
      if (lookahead != 0 &&
          lookahead != '}') ADVANCE(178);
      END_STATE();
    case 11:
      if (lookahead == '!') ADVANCE(189);
      if (lookahead == '#') ADVANCE(34);
      if (lookahead == '$') ADVANCE(198);
      if (lookahead == '%') ADVANCE(46);
      if (lookahead == '\'') ADVANCE(192);
      if (lookahead == '(') ADVANCE(53);
      if (lookahead == ')') ADVANCE(54);
      if (lookahead == '*') ADVANCE(185);
      if (lookahead == '+') ADVANCE(183);
      if (lookahead == ',') ADVANCE(51);
      if (lookahead == '-') ADVANCE(184);
      if (lookahead == '/') ADVANCE(186);
      if (lookahead == ':') ADVANCE(191);
      if (lookahead == '<') ADVANCE(187);
      if (lookahead == '=') ADVANCE(52);
      if (lookahead == '>') ADVANCE(188);
      if (lookahead == '[') ADVANCE(49);
      if (lookahead == '\\') ADVANCE(234);
      if (lookahead == ']') ADVANCE(50);
      if (lookahead == '^') ADVANCE(194);
      if (lookahead == '_') ADVANCE(193);
      if (lookahead == 's') ADVANCE(107);
      if (lookahead == '{') ADVANCE(77);
      if (lookahead == '|') ADVANCE(190);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(41);
      if (lookahead != 0 &&
          lookahead != '}') ADVANCE(178);
      END_STATE();
    case 12:
      if (lookahead == '!') ADVANCE(189);
      if (lookahead == '#') ADVANCE(34);
      if (lookahead == '$') ADVANCE(198);
      if (lookahead == '%') ADVANCE(46);
      if (lookahead == '\'') ADVANCE(192);
      if (lookahead == '(') ADVANCE(53);
      if (lookahead == ')') ADVANCE(54);
      if (lookahead == '*') ADVANCE(185);
      if (lookahead == '+') ADVANCE(183);
      if (lookahead == ',') ADVANCE(51);
      if (lookahead == '-') ADVANCE(184);
      if (lookahead == '/') ADVANCE(186);
      if (lookahead == ':') ADVANCE(191);
      if (lookahead == '<') ADVANCE(187);
      if (lookahead == '=') ADVANCE(52);
      if (lookahead == '>') ADVANCE(188);
      if (lookahead == '[') ADVANCE(49);
      if (lookahead == '\\') ADVANCE(243);
      if (lookahead == ']') ADVANCE(50);
      if (lookahead == '^') ADVANCE(194);
      if (lookahead == '_') ADVANCE(193);
      if (lookahead == 's') ADVANCE(107);
      if (lookahead == '{') ADVANCE(77);
      if (lookahead == '|') ADVANCE(190);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(41);
      if (lookahead != 0 &&
          lookahead != '}') ADVANCE(178);
      END_STATE();
    case 13:
      if (lookahead == '!') ADVANCE(189);
      if (lookahead == '#') ADVANCE(34);
      if (lookahead == '$') ADVANCE(198);
      if (lookahead == '%') ADVANCE(46);
      if (lookahead == '\'') ADVANCE(192);
      if (lookahead == '(') ADVANCE(53);
      if (lookahead == ')') ADVANCE(54);
      if (lookahead == '*') ADVANCE(185);
      if (lookahead == '+') ADVANCE(183);
      if (lookahead == ',') ADVANCE(51);
      if (lookahead == '-') ADVANCE(184);
      if (lookahead == '/') ADVANCE(186);
      if (lookahead == ':') ADVANCE(191);
      if (lookahead == '<') ADVANCE(187);
      if (lookahead == '=') ADVANCE(52);
      if (lookahead == '>') ADVANCE(188);
      if (lookahead == '[') ADVANCE(49);
      if (lookahead == '\\') ADVANCE(252);
      if (lookahead == ']') ADVANCE(50);
      if (lookahead == '^') ADVANCE(194);
      if (lookahead == '_') ADVANCE(193);
      if (lookahead == 's') ADVANCE(107);
      if (lookahead == '{') ADVANCE(77);
      if (lookahead == '|') ADVANCE(190);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(41);
      if (lookahead != 0 &&
          lookahead != '}') ADVANCE(178);
      END_STATE();
    case 14:
      if (lookahead == '!') ADVANCE(189);
      if (lookahead == '#') ADVANCE(34);
      if (lookahead == '$') ADVANCE(198);
      if (lookahead == '%') ADVANCE(46);
      if (lookahead == '\'') ADVANCE(192);
      if (lookahead == '(') ADVANCE(53);
      if (lookahead == ')') ADVANCE(54);
      if (lookahead == '*') ADVANCE(185);
      if (lookahead == '+') ADVANCE(183);
      if (lookahead == ',') ADVANCE(51);
      if (lookahead == '-') ADVANCE(184);
      if (lookahead == '/') ADVANCE(186);
      if (lookahead == ':') ADVANCE(191);
      if (lookahead == '<') ADVANCE(187);
      if (lookahead == '=') ADVANCE(52);
      if (lookahead == '>') ADVANCE(188);
      if (lookahead == '[') ADVANCE(49);
      if (lookahead == '\\') ADVANCE(254);
      if (lookahead == ']') ADVANCE(50);
      if (lookahead == '^') ADVANCE(194);
      if (lookahead == '_') ADVANCE(193);
      if (lookahead == 's') ADVANCE(107);
      if (lookahead == '{') ADVANCE(77);
      if (lookahead == '|') ADVANCE(190);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(41);
      if (lookahead != 0 &&
          lookahead != '}') ADVANCE(178);
      END_STATE();
    case 15:
      if (lookahead == '!') ADVANCE(189);
      if (lookahead == '#') ADVANCE(34);
      if (lookahead == '$') ADVANCE(198);
      if (lookahead == '%') ADVANCE(46);
      if (lookahead == '\'') ADVANCE(192);
      if (lookahead == '(') ADVANCE(53);
      if (lookahead == ')') ADVANCE(54);
      if (lookahead == '*') ADVANCE(185);
      if (lookahead == '+') ADVANCE(183);
      if (lookahead == ',') ADVANCE(51);
      if (lookahead == '-') ADVANCE(184);
      if (lookahead == '/') ADVANCE(186);
      if (lookahead == ':') ADVANCE(191);
      if (lookahead == '<') ADVANCE(187);
      if (lookahead == '=') ADVANCE(52);
      if (lookahead == '>') ADVANCE(188);
      if (lookahead == '[') ADVANCE(49);
      if (lookahead == '\\') ADVANCE(250);
      if (lookahead == ']') ADVANCE(50);
      if (lookahead == '^') ADVANCE(194);
      if (lookahead == '_') ADVANCE(193);
      if (lookahead == 's') ADVANCE(107);
      if (lookahead == '{') ADVANCE(77);
      if (lookahead == '|') ADVANCE(190);
      if (lookahead == '}') ADVANCE(78);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(41);
      if (lookahead != 0) ADVANCE(178);
      END_STATE();
    case 16:
      if (lookahead == '!') ADVANCE(189);
      if (lookahead == '#') ADVANCE(34);
      if (lookahead == '$') ADVANCE(198);
      if (lookahead == '%') ADVANCE(46);
      if (lookahead == '\'') ADVANCE(192);
      if (lookahead == '(') ADVANCE(53);
      if (lookahead == ')') ADVANCE(54);
      if (lookahead == '*') ADVANCE(185);
      if (lookahead == '+') ADVANCE(183);
      if (lookahead == ',') ADVANCE(51);
      if (lookahead == '-') ADVANCE(184);
      if (lookahead == '/') ADVANCE(186);
      if (lookahead == ':') ADVANCE(191);
      if (lookahead == '<') ADVANCE(187);
      if (lookahead == '=') ADVANCE(52);
      if (lookahead == '>') ADVANCE(188);
      if (lookahead == '[') ADVANCE(49);
      if (lookahead == '\\') ADVANCE(239);
      if (lookahead == ']') ADVANCE(50);
      if (lookahead == '^') ADVANCE(194);
      if (lookahead == '_') ADVANCE(193);
      if (lookahead == 's') ADVANCE(107);
      if (lookahead == '{') ADVANCE(77);
      if (lookahead == '|') ADVANCE(190);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(41);
      if (lookahead != 0 &&
          lookahead != '}') ADVANCE(178);
      END_STATE();
    case 17:
      if (lookahead == '!') ADVANCE(189);
      if (lookahead == '#') ADVANCE(34);
      if (lookahead == '$') ADVANCE(198);
      if (lookahead == '%') ADVANCE(46);
      if (lookahead == '\'') ADVANCE(192);
      if (lookahead == '(') ADVANCE(53);
      if (lookahead == ')') ADVANCE(54);
      if (lookahead == '*') ADVANCE(185);
      if (lookahead == '+') ADVANCE(183);
      if (lookahead == ',') ADVANCE(51);
      if (lookahead == '-') ADVANCE(184);
      if (lookahead == '/') ADVANCE(186);
      if (lookahead == ':') ADVANCE(191);
      if (lookahead == '<') ADVANCE(187);
      if (lookahead == '=') ADVANCE(52);
      if (lookahead == '>') ADVANCE(188);
      if (lookahead == '[') ADVANCE(49);
      if (lookahead == '\\') ADVANCE(245);
      if (lookahead == ']') ADVANCE(50);
      if (lookahead == '^') ADVANCE(194);
      if (lookahead == '_') ADVANCE(193);
      if (lookahead == 's') ADVANCE(107);
      if (lookahead == '{') ADVANCE(77);
      if (lookahead == '|') ADVANCE(190);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(41);
      if (lookahead != 0 &&
          lookahead != '}') ADVANCE(178);
      END_STATE();
    case 18:
      if (lookahead == '!') ADVANCE(189);
      if (lookahead == '#') ADVANCE(34);
      if (lookahead == '$') ADVANCE(198);
      if (lookahead == '%') ADVANCE(46);
      if (lookahead == '\'') ADVANCE(192);
      if (lookahead == '(') ADVANCE(53);
      if (lookahead == ')') ADVANCE(54);
      if (lookahead == '*') ADVANCE(185);
      if (lookahead == '+') ADVANCE(183);
      if (lookahead == ',') ADVANCE(51);
      if (lookahead == '-') ADVANCE(184);
      if (lookahead == '/') ADVANCE(186);
      if (lookahead == ':') ADVANCE(191);
      if (lookahead == '<') ADVANCE(187);
      if (lookahead == '=') ADVANCE(52);
      if (lookahead == '>') ADVANCE(188);
      if (lookahead == '[') ADVANCE(49);
      if (lookahead == '\\') ADVANCE(251);
      if (lookahead == ']') ADVANCE(50);
      if (lookahead == '^') ADVANCE(194);
      if (lookahead == '_') ADVANCE(193);
      if (lookahead == 's') ADVANCE(107);
      if (lookahead == '{') ADVANCE(77);
      if (lookahead == '|') ADVANCE(190);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(41);
      if (lookahead != 0 &&
          lookahead != '}') ADVANCE(178);
      END_STATE();
    case 19:
      if (lookahead == '!') ADVANCE(189);
      if (lookahead == '#') ADVANCE(34);
      if (lookahead == '$') ADVANCE(198);
      if (lookahead == '%') ADVANCE(46);
      if (lookahead == '\'') ADVANCE(192);
      if (lookahead == '(') ADVANCE(53);
      if (lookahead == ')') ADVANCE(54);
      if (lookahead == '*') ADVANCE(185);
      if (lookahead == '+') ADVANCE(183);
      if (lookahead == ',') ADVANCE(51);
      if (lookahead == '-') ADVANCE(184);
      if (lookahead == '/') ADVANCE(186);
      if (lookahead == ':') ADVANCE(191);
      if (lookahead == '<') ADVANCE(187);
      if (lookahead == '=') ADVANCE(52);
      if (lookahead == '>') ADVANCE(188);
      if (lookahead == '[') ADVANCE(49);
      if (lookahead == '\\') ADVANCE(253);
      if (lookahead == ']') ADVANCE(50);
      if (lookahead == '^') ADVANCE(194);
      if (lookahead == '_') ADVANCE(193);
      if (lookahead == 's') ADVANCE(107);
      if (lookahead == '{') ADVANCE(77);
      if (lookahead == '|') ADVANCE(190);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(41);
      if (lookahead != 0 &&
          lookahead != '}') ADVANCE(178);
      END_STATE();
    case 20:
      if (lookahead == '!') ADVANCE(189);
      if (lookahead == '#') ADVANCE(34);
      if (lookahead == '$') ADVANCE(198);
      if (lookahead == '%') ADVANCE(46);
      if (lookahead == '\'') ADVANCE(192);
      if (lookahead == '(') ADVANCE(53);
      if (lookahead == ')') ADVANCE(54);
      if (lookahead == '*') ADVANCE(185);
      if (lookahead == '+') ADVANCE(183);
      if (lookahead == ',') ADVANCE(51);
      if (lookahead == '-') ADVANCE(184);
      if (lookahead == '/') ADVANCE(186);
      if (lookahead == ':') ADVANCE(191);
      if (lookahead == '<') ADVANCE(187);
      if (lookahead == '=') ADVANCE(52);
      if (lookahead == '>') ADVANCE(188);
      if (lookahead == '[') ADVANCE(49);
      if (lookahead == '\\') ADVANCE(249);
      if (lookahead == ']') ADVANCE(50);
      if (lookahead == '^') ADVANCE(194);
      if (lookahead == '_') ADVANCE(193);
      if (lookahead == 's') ADVANCE(107);
      if (lookahead == '{') ADVANCE(77);
      if (lookahead == '|') ADVANCE(190);
      if (lookahead == '}') ADVANCE(78);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(41);
      if (lookahead != 0) ADVANCE(178);
      END_STATE();
    case 21:
      if (lookahead == '!') ADVANCE(189);
      if (lookahead == '#') ADVANCE(34);
      if (lookahead == '$') ADVANCE(198);
      if (lookahead == '%') ADVANCE(46);
      if (lookahead == '\'') ADVANCE(192);
      if (lookahead == '(') ADVANCE(53);
      if (lookahead == ')') ADVANCE(54);
      if (lookahead == '*') ADVANCE(185);
      if (lookahead == '+') ADVANCE(183);
      if (lookahead == '-') ADVANCE(184);
      if (lookahead == '/') ADVANCE(186);
      if (lookahead == ':') ADVANCE(191);
      if (lookahead == '<') ADVANCE(187);
      if (lookahead == '>') ADVANCE(188);
      if (lookahead == '[') ADVANCE(49);
      if (lookahead == '\\') ADVANCE(256);
      if (lookahead == '^') ADVANCE(194);
      if (lookahead == '_') ADVANCE(193);
      if (lookahead == 's') ADVANCE(107);
      if (lookahead == '{') ADVANCE(77);
      if (lookahead == '|') ADVANCE(190);
      if (lookahead == '}') ADVANCE(78);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(41);
      if (lookahead != 0 &&
          lookahead != ',' &&
          lookahead != '=' &&
          lookahead != ']') ADVANCE(178);
      END_STATE();
    case 22:
      if (lookahead == '!') ADVANCE(189);
      if (lookahead == '#') ADVANCE(34);
      if (lookahead == '$') ADVANCE(198);
      if (lookahead == '%') ADVANCE(46);
      if (lookahead == '\'') ADVANCE(192);
      if (lookahead == '(') ADVANCE(53);
      if (lookahead == ')') ADVANCE(54);
      if (lookahead == '*') ADVANCE(185);
      if (lookahead == '+') ADVANCE(183);
      if (lookahead == '-') ADVANCE(184);
      if (lookahead == '/') ADVANCE(186);
      if (lookahead == ':') ADVANCE(191);
      if (lookahead == '<') ADVANCE(187);
      if (lookahead == '>') ADVANCE(188);
      if (lookahead == '\\') ADVANCE(255);
      if (lookahead == '^') ADVANCE(194);
      if (lookahead == '_') ADVANCE(193);
      if (lookahead == 's') ADVANCE(107);
      if (lookahead == '{') ADVANCE(77);
      if (lookahead == '|') ADVANCE(190);
      if (lookahead == '}') ADVANCE(78);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(41);
      if (lookahead != 0 &&
          lookahead != ',' &&
          lookahead != '=' &&
          (lookahead < '[' || ']' < lookahead)) ADVANCE(178);
      END_STATE();
    case 23:
      if (lookahead == '!') ADVANCE(189);
      if (lookahead == '#') ADVANCE(34);
      if (lookahead == '%') ADVANCE(46);
      if (lookahead == '\'') ADVANCE(192);
      if (lookahead == '*') ADVANCE(185);
      if (lookahead == '+') ADVANCE(183);
      if (lookahead == ',') ADVANCE(51);
      if (lookahead == '-') ADVANCE(184);
      if (lookahead == '/') ADVANCE(186);
      if (lookahead == ':') ADVANCE(191);
      if (lookahead == '<') ADVANCE(187);
      if (lookahead == '=') ADVANCE(52);
      if (lookahead == '>') ADVANCE(188);
      if (lookahead == '[') ADVANCE(49);
      if (lookahead == '\\') ADVANCE(1342);
      if (lookahead == ']') ADVANCE(50);
      if (lookahead == '^') ADVANCE(194);
      if (lookahead == '_') ADVANCE(193);
      if (lookahead == '{') ADVANCE(77);
      if (lookahead == '|') ADVANCE(190);
      if (lookahead == '}') ADVANCE(78);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(41);
      if (lookahead != 0 &&
          lookahead != '$' &&
          lookahead != '(' &&
          lookahead != ')') ADVANCE(178);
      END_STATE();
    case 24:
      if (lookahead == '!') ADVANCE(189);
      if (lookahead == '#') ADVANCE(34);
      if (lookahead == '%') ADVANCE(46);
      if (lookahead == '\'') ADVANCE(192);
      if (lookahead == '*') ADVANCE(185);
      if (lookahead == '+') ADVANCE(183);
      if (lookahead == ',') ADVANCE(51);
      if (lookahead == '-') ADVANCE(184);
      if (lookahead == '/') ADVANCE(186);
      if (lookahead == ':') ADVANCE(191);
      if (lookahead == '<') ADVANCE(187);
      if (lookahead == '=') ADVANCE(52);
      if (lookahead == '>') ADVANCE(188);
      if (lookahead == '\\') ADVANCE(1341);
      if (lookahead == ']') ADVANCE(50);
      if (lookahead == '^') ADVANCE(194);
      if (lookahead == '_') ADVANCE(193);
      if (lookahead == '|') ADVANCE(190);
      if (lookahead == '}') ADVANCE(78);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(41);
      if (lookahead != 0 &&
          lookahead != '$' &&
          lookahead != '(' &&
          lookahead != ')' &&
          lookahead != '[' &&
          lookahead != '{') ADVANCE(178);
      END_STATE();
    case 25:
      if (lookahead == '!') ADVANCE(189);
      if (lookahead == '#') ADVANCE(34);
      if (lookahead == '%') ADVANCE(46);
      if (lookahead == '\'') ADVANCE(192);
      if (lookahead == '*') ADVANCE(185);
      if (lookahead == '+') ADVANCE(183);
      if (lookahead == '-') ADVANCE(184);
      if (lookahead == '/') ADVANCE(186);
      if (lookahead == ':') ADVANCE(191);
      if (lookahead == '<') ADVANCE(187);
      if (lookahead == '>') ADVANCE(188);
      if (lookahead == '\\') ADVANCE(1342);
      if (lookahead == '^') ADVANCE(194);
      if (lookahead == '_') ADVANCE(193);
      if (lookahead == 'a') ADVANCE(120);
      if (lookahead == 'c') ADVANCE(141);
      if (lookahead == 'd') ADVANCE(111);
      if (lookahead == 'e') ADVANCE(147);
      if (lookahead == 'f') ADVANCE(121);
      if (lookahead == 'g') ADVANCE(81);
      if (lookahead == 'l') ADVANCE(156);
      if (lookahead == 'm') ADVANCE(109);
      if (lookahead == 'p') ADVANCE(174);
      if (lookahead == 's') ADVANCE(145);
      if (lookahead == 'v') ADVANCE(97);
      if (lookahead == '|') ADVANCE(190);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(41);
      if (lookahead != 0 &&
          lookahead != '$' &&
          (lookahead < '(' || ',' < lookahead) &&
          lookahead != '=' &&
          (lookahead < '[' || ']' < lookahead) &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(178);
      END_STATE();
    case 26:
      if (lookahead == '%') ADVANCE(46);
      if (lookahead == '(') ADVANCE(53);
      if (lookahead == ')') ADVANCE(54);
      if (lookahead == '=') ADVANCE(52);
      if (lookahead == '[') ADVANCE(49);
      if (lookahead == '\\') ADVANCE(1343);
      if (lookahead == ']') ADVANCE(50);
      if (lookahead == '{') ADVANCE(77);
      if (lookahead == '|') ADVANCE(190);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(41);
      if (lookahead != 0 &&
          lookahead != '#' &&
          lookahead != '$' &&
          (lookahead < '*' || '-' < lookahead) &&
          lookahead != '/' &&
          lookahead != '^' &&
          lookahead != '_' &&
          lookahead != '}') ADVANCE(178);
      END_STATE();
    case 27:
      if (lookahead == '%') ADVANCE(46);
      if (lookahead == '\\') ADVANCE(1343);
      if (lookahead == '{') ADVANCE(77);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(41);
      if (lookahead != 0 &&
          lookahead != '#' &&
          lookahead != '$' &&
          (lookahead < '(' || '-' < lookahead) &&
          lookahead != '/' &&
          lookahead != '=' &&
          (lookahead < '[' || '_' < lookahead) &&
          lookahead != '}') ADVANCE(178);
      END_STATE();
    case 28:
      if (lookahead == '%') ADVANCE(46);
      if (lookahead == '\\') ADVANCE(31);
      if (lookahead == '}') ADVANCE(78);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(41);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(181);
      END_STATE();
    case 29:
      if (lookahead == '%') ADVANCE(44);
      if (lookahead == '{') ADVANCE(77);
      if (lookahead == '}') ADVANCE(78);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(42);
      if (lookahead != 0 &&
          lookahead != '"' &&
          (lookahead < ':' || '<' < lookahead) &&
          lookahead != '>' &&
          lookahead != '[' &&
          lookahead != ']' &&
          lookahead != '|') ADVANCE(182);
      END_STATE();
    case 30:
      if (lookahead == '%') ADVANCE(45);
      if (lookahead == '}') ADVANCE(78);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(43);
      if (!sym_path_character_set_1(lookahead)) ADVANCE(180);
      END_STATE();
    case 31:
      if (lookahead == 'a') ADVANCE(33);
      END_STATE();
    case 32:
      if (lookahead == 'd') ADVANCE(79);
      END_STATE();
    case 33:
      if (lookahead == 'n') ADVANCE(32);
      END_STATE();
    case 34:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(179);
      END_STATE();
    case 35:
      if (eof) ADVANCE(40);
      if (lookahead == '!') ADVANCE(189);
      if (lookahead == '#') ADVANCE(34);
      if (lookahead == '$') ADVANCE(198);
      if (lookahead == '%') ADVANCE(46);
      if (lookahead == '\'') ADVANCE(192);
      if (lookahead == '(') ADVANCE(53);
      if (lookahead == ')') ADVANCE(54);
      if (lookahead == '*') ADVANCE(185);
      if (lookahead == '+') ADVANCE(183);
      if (lookahead == ',') ADVANCE(51);
      if (lookahead == '-') ADVANCE(184);
      if (lookahead == '/') ADVANCE(186);
      if (lookahead == ':') ADVANCE(191);
      if (lookahead == '<') ADVANCE(187);
      if (lookahead == '=') ADVANCE(52);
      if (lookahead == '>') ADVANCE(188);
      if (lookahead == '[') ADVANCE(49);
      if (lookahead == '\\') ADVANCE(248);
      if (lookahead == ']') ADVANCE(50);
      if (lookahead == '^') ADVANCE(194);
      if (lookahead == '_') ADVANCE(193);
      if (lookahead == 's') ADVANCE(107);
      if (lookahead == '{') ADVANCE(77);
      if (lookahead == '|') ADVANCE(190);
      if (lookahead == '}') ADVANCE(78);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(41);
      if (lookahead != 0) ADVANCE(178);
      END_STATE();
    case 36:
      if (eof) ADVANCE(40);
      if (lookahead == '!') ADVANCE(189);
      if (lookahead == '#') ADVANCE(34);
      if (lookahead == '$') ADVANCE(198);
      if (lookahead == '%') ADVANCE(46);
      if (lookahead == '\'') ADVANCE(192);
      if (lookahead == '(') ADVANCE(53);
      if (lookahead == ')') ADVANCE(54);
      if (lookahead == '*') ADVANCE(185);
      if (lookahead == '+') ADVANCE(183);
      if (lookahead == ',') ADVANCE(51);
      if (lookahead == '-') ADVANCE(184);
      if (lookahead == '/') ADVANCE(186);
      if (lookahead == ':') ADVANCE(191);
      if (lookahead == '<') ADVANCE(187);
      if (lookahead == '=') ADVANCE(52);
      if (lookahead == '>') ADVANCE(188);
      if (lookahead == '[') ADVANCE(49);
      if (lookahead == '\\') ADVANCE(240);
      if (lookahead == ']') ADVANCE(50);
      if (lookahead == '^') ADVANCE(194);
      if (lookahead == '_') ADVANCE(193);
      if (lookahead == 's') ADVANCE(107);
      if (lookahead == '{') ADVANCE(77);
      if (lookahead == '|') ADVANCE(190);
      if (lookahead == '}') ADVANCE(78);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(41);
      if (lookahead != 0) ADVANCE(178);
      END_STATE();
    case 37:
      if (eof) ADVANCE(40);
      if (lookahead == '!') ADVANCE(189);
      if (lookahead == '#') ADVANCE(34);
      if (lookahead == '$') ADVANCE(198);
      if (lookahead == '%') ADVANCE(46);
      if (lookahead == '\'') ADVANCE(192);
      if (lookahead == '(') ADVANCE(53);
      if (lookahead == ')') ADVANCE(54);
      if (lookahead == '*') ADVANCE(185);
      if (lookahead == '+') ADVANCE(183);
      if (lookahead == ',') ADVANCE(51);
      if (lookahead == '-') ADVANCE(184);
      if (lookahead == '/') ADVANCE(186);
      if (lookahead == ':') ADVANCE(191);
      if (lookahead == '<') ADVANCE(187);
      if (lookahead == '=') ADVANCE(52);
      if (lookahead == '>') ADVANCE(188);
      if (lookahead == '[') ADVANCE(49);
      if (lookahead == '\\') ADVANCE(235);
      if (lookahead == ']') ADVANCE(50);
      if (lookahead == '^') ADVANCE(194);
      if (lookahead == '_') ADVANCE(193);
      if (lookahead == 's') ADVANCE(107);
      if (lookahead == '{') ADVANCE(77);
      if (lookahead == '|') ADVANCE(190);
      if (lookahead == '}') ADVANCE(78);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(41);
      if (lookahead != 0) ADVANCE(178);
      END_STATE();
    case 38:
      if (eof) ADVANCE(40);
      if (lookahead == '!') ADVANCE(189);
      if (lookahead == '#') ADVANCE(34);
      if (lookahead == '$') ADVANCE(198);
      if (lookahead == '%') ADVANCE(46);
      if (lookahead == '\'') ADVANCE(192);
      if (lookahead == '(') ADVANCE(53);
      if (lookahead == ')') ADVANCE(54);
      if (lookahead == '*') ADVANCE(185);
      if (lookahead == '+') ADVANCE(183);
      if (lookahead == ',') ADVANCE(51);
      if (lookahead == '-') ADVANCE(184);
      if (lookahead == '/') ADVANCE(186);
      if (lookahead == ':') ADVANCE(191);
      if (lookahead == '<') ADVANCE(187);
      if (lookahead == '=') ADVANCE(52);
      if (lookahead == '>') ADVANCE(188);
      if (lookahead == '[') ADVANCE(49);
      if (lookahead == '\\') ADVANCE(244);
      if (lookahead == ']') ADVANCE(50);
      if (lookahead == '^') ADVANCE(194);
      if (lookahead == '_') ADVANCE(193);
      if (lookahead == 's') ADVANCE(107);
      if (lookahead == '{') ADVANCE(77);
      if (lookahead == '|') ADVANCE(190);
      if (lookahead == '}') ADVANCE(78);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(41);
      if (lookahead != 0) ADVANCE(178);
      END_STATE();
    case 39:
      if (eof) ADVANCE(40);
      if (lookahead == '!') ADVANCE(189);
      if (lookahead == '#') ADVANCE(34);
      if (lookahead == '$') ADVANCE(198);
      if (lookahead == '%') ADVANCE(46);
      if (lookahead == '\'') ADVANCE(192);
      if (lookahead == '(') ADVANCE(53);
      if (lookahead == ')') ADVANCE(54);
      if (lookahead == '*') ADVANCE(185);
      if (lookahead == '+') ADVANCE(183);
      if (lookahead == ',') ADVANCE(51);
      if (lookahead == '-') ADVANCE(184);
      if (lookahead == '/') ADVANCE(186);
      if (lookahead == ':') ADVANCE(191);
      if (lookahead == '<') ADVANCE(187);
      if (lookahead == '=') ADVANCE(52);
      if (lookahead == '>') ADVANCE(188);
      if (lookahead == '[') ADVANCE(49);
      if (lookahead == '\\') ADVANCE(247);
      if (lookahead == ']') ADVANCE(50);
      if (lookahead == '^') ADVANCE(194);
      if (lookahead == '_') ADVANCE(193);
      if (lookahead == 's') ADVANCE(107);
      if (lookahead == '{') ADVANCE(77);
      if (lookahead == '|') ADVANCE(190);
      if (lookahead == '}') ADVANCE(78);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(41);
      if (lookahead != 0) ADVANCE(178);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(sym__whitespace);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(41);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(sym__whitespace);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(42);
      if (lookahead != 0 &&
          lookahead != '"' &&
          (lookahead < ':' || '<' < lookahead) &&
          lookahead != '>' &&
          lookahead != '[' &&
          lookahead != ']' &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(182);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(sym__whitespace);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(43);
      if (!sym_path_character_set_2(lookahead)) ADVANCE(180);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(sym_line_comment);
      if (lookahead == '\n' ||
          lookahead == '\r') ADVANCE(182);
      if (lookahead == '"' ||
          (':' <= lookahead && lookahead <= '<') ||
          lookahead == '>' ||
          lookahead == '[' ||
          lookahead == ']' ||
          ('{' <= lookahead && lookahead <= '}')) ADVANCE(46);
      if (lookahead != 0) ADVANCE(44);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(sym_line_comment);
      if (lookahead == '\n' ||
          lookahead == '\r') ADVANCE(180);
      if (lookahead == '"' ||
          lookahead == '*' ||
          lookahead == ',' ||
          (':' <= lookahead && lookahead <= '<') ||
          lookahead == '>' ||
          lookahead == '[' ||
          lookahead == ']' ||
          ('{' <= lookahead && lookahead <= '}')) ADVANCE(46);
      if (lookahead != 0) ADVANCE(45);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(sym_line_comment);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(46);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(anon_sym_BSLASHiffalse);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(anon_sym_BSLASHfi);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_BSLASHpart);
      if (lookahead == '*') ADVANCE(56);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_BSLASHpart_STAR);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_BSLASHaddpart);
      if (lookahead == '*') ADVANCE(58);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym_BSLASHaddpart_STAR);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_BSLASHchapter);
      if (lookahead == '*') ADVANCE(60);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_BSLASHchapter_STAR);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(anon_sym_BSLASHaddchap);
      if (lookahead == '*') ADVANCE(62);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(anon_sym_BSLASHaddchap_STAR);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(anon_sym_BSLASHsection);
      if (lookahead == '*') ADVANCE(64);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(anon_sym_BSLASHsection_STAR);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(anon_sym_BSLASHaddsec);
      if (lookahead == '*') ADVANCE(66);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_BSLASHaddsec_STAR);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_BSLASHsubsection);
      if (lookahead == '*') ADVANCE(68);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_BSLASHsubsection_STAR);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_BSLASHsubsubsection);
      if (lookahead == '*') ADVANCE(70);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_BSLASHsubsubsection_STAR);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_BSLASHparagraph);
      if (lookahead == '*') ADVANCE(72);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_BSLASHparagraph_STAR);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_BSLASHsubparagraph);
      if (lookahead == '*') ADVANCE(74);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_BSLASHsubparagraph_STAR);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_BSLASHitem);
      if (lookahead == '*') ADVANCE(76);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_BSLASHitem_STAR);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_BSLASHand);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_BSLASHand);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'a') ADVANCE(158);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'a') ADVANCE(175);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'a') ADVANCE(177);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'a') ADVANCE(126);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'a') ADVANCE(176);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'a') ADVANCE(154);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'a') ADVANCE(165);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'a') ADVANCE(163);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'a') ADVANCE(170);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'b') ADVANCE(89);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'c') ADVANCE(142);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'd') ADVANCE(206);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'd') ADVANCE(94);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'e') ADVANCE(207);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'e') ADVANCE(212);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'e') ADVANCE(173);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'e') ADVANCE(148);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'e') ADVANCE(92);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'e') ADVANCE(149);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'e') ADVANCE(139);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'e') ADVANCE(153);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'g') ADVANCE(205);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'g') ADVANCE(132);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'g') ADVANCE(133);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'h') ADVANCE(208);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'h') ADVANCE(143);
      if (lookahead == 'p') ADVANCE(122);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'h') ADVANCE(143);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'h') ADVANCE(99);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'i') ADVANCE(136);
      if (lookahead == 'u') ADVANCE(127);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'i') ADVANCE(103);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'i') ADVANCE(155);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'i') ADVANCE(144);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'i') ADVANCE(128);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'i') ADVANCE(138);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'i') ADVANCE(159);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'i') ADVANCE(135);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'i') ADVANCE(157);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'i') ADVANCE(104);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'i') ADVANCE(140);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'l') ADVANCE(110);
      if (lookahead == 'r') ADVANCE(150);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'l') ADVANCE(84);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'l') ADVANCE(115);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'l') ADVANCE(114);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'l') ADVANCE(83);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'l') ADVANCE(117);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'l') ADVANCE(118);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'l') ADVANCE(168);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'm') ADVANCE(204);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'm') ADVANCE(100);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'm') ADVANCE(129);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'm') ADVANCE(88);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'n') ADVANCE(216);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'n') ADVANCE(226);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'n') ADVANCE(210);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'n') ADVANCE(102);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'n') ADVANCE(164);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'n') ADVANCE(86);
      if (lookahead == 'u') ADVANCE(87);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'n') ADVANCE(95);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'n') ADVANCE(161);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'n') ADVANCE(172);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'o') ADVANCE(130);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'o') ADVANCE(93);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'o') ADVANCE(151);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'o') ADVANCE(134);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'p') ADVANCE(122);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'p') ADVANCE(124);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'q') ADVANCE(137);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'r') ADVANCE(90);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'r') ADVANCE(224);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'r') ADVANCE(82);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'r') ADVANCE(167);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'r') ADVANCE(85);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'r') ADVANCE(169);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'r') ADVANCE(152);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 's') ADVANCE(146);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 's') ADVANCE(166);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 's') ADVANCE(171);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 't') ADVANCE(108);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 't') ADVANCE(220);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 't') ADVANCE(222);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 't') ADVANCE(203);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 't') ADVANCE(1596);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 't') ADVANCE(105);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 't') ADVANCE(98);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 't') ADVANCE(112);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 't') ADVANCE(125);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 't') ADVANCE(119);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 't') ADVANCE(123);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 't') ADVANCE(96);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 't') ADVANCE(113);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 't') ADVANCE(116);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 't') ADVANCE(101);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'x') ADVANCE(162);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'y') ADVANCE(91);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'y') ADVANCE(218);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'y') ADVANCE(214);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(sym_word);
      if (lookahead == 'y') ADVANCE(131);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(sym_word);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(sym_placeholder);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(sym_path);
      if (!sym_path_character_set_2(lookahead)) ADVANCE(180);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(sym_argc);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(aux_sym__glob_pattern_fragment_token1);
      if (lookahead != 0 &&
          lookahead != '"' &&
          (lookahead < ':' || '<' < lookahead) &&
          lookahead != '>' &&
          lookahead != '[' &&
          lookahead != ']' &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(182);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(anon_sym_SLASH);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(anon_sym_LT);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(anon_sym_GT);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(anon_sym__);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(anon_sym_DOLLAR_DOLLAR);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(anon_sym_BSLASH_LBRACK);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(anon_sym_BSLASH_RBRACK);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      if (lookahead == '$') ADVANCE(195);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(anon_sym_BSLASH_LPAREN);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(anon_sym_BSLASH_RPAREN);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(anon_sym_BSLASHbegin);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(anon_sym_BSLASHend);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(anon_sym_comment);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(anon_sym_verbatim);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(anon_sym_lstlisting);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(anon_sym_minted);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(anon_sym_pycode);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(anon_sym_displaymath);
      if (lookahead == '*') ADVANCE(209);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(anon_sym_displaymath_STAR);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(anon_sym_equation);
      if (lookahead == '*') ADVANCE(211);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(anon_sym_equation_STAR);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(anon_sym_multline);
      if (lookahead == '*') ADVANCE(213);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(anon_sym_multline_STAR);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(anon_sym_eqnarray);
      if (lookahead == '*') ADVANCE(215);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(anon_sym_eqnarray_STAR);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(anon_sym_align);
      if (lookahead == '*') ADVANCE(217);
      if (lookahead == 'a') ADVANCE(160);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(anon_sym_align_STAR);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(anon_sym_array);
      if (lookahead == '*') ADVANCE(219);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(anon_sym_array_STAR);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(anon_sym_split);
      if (lookahead == '*') ADVANCE(221);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(anon_sym_split_STAR);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(anon_sym_alignat);
      if (lookahead == '*') ADVANCE(223);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(anon_sym_alignat_STAR);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(anon_sym_gather);
      if (lookahead == '*') ADVANCE(225);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(anon_sym_gather_STAR);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(anon_sym_flalign);
      if (lookahead == '*') ADVANCE(227);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(anon_sym_flalign_STAR);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(sym_command_name);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '(') ADVANCE(199);
      if (lookahead == ')') ADVANCE(200);
      if (lookahead == 'A') ADVANCE(257);
      if (lookahead == 'B') ADVANCE(679);
      if (lookahead == 'C') ADVANCE(685);
      if (lookahead == 'D') ADVANCE(470);
      if (lookahead == 'G') ADVANCE(278);
      if (lookahead == 'N') ADVANCE(471);
      if (lookahead == 'P') ADVANCE(283);
      if (lookahead == 'R') ADVANCE(528);
      if (lookahead == 'S') ADVANCE(836);
      if (lookahead == 'T') ADVANCE(472);
      if (lookahead == 'V') ADVANCE(531);
      if (lookahead == '[') ADVANCE(196);
      if (lookahead == ']') ADVANCE(197);
      if (lookahead == 'a') ADVANCE(379);
      if (lookahead == 'b') ADVANCE(529);
      if (lookahead == 'c') ADVANCE(284);
      if (lookahead == 'd') ADVANCE(473);
      if (lookahead == 'e') ADVANCE(900);
      if (lookahead == 'f') ADVANCE(680);
      if (lookahead == 'g') ADVANCE(786);
      if (lookahead == 'i') ADVANCE(615);
      if (lookahead == 'l') ADVANCE(286);
      if (lookahead == 'n') ADVANCE(288);
      if (lookahead == 'p') ADVANCE(289);
      if (lookahead == 'r') ADVANCE(474);
      if (lookahead == 's') ADVANCE(536);
      if (lookahead == 't') ADVANCE(571);
      if (lookahead == 'u') ADVANCE(1152);
      if (lookahead == 'v') ADVANCE(600);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(228);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '(') ADVANCE(199);
      if (lookahead == ')') ADVANCE(200);
      if (lookahead == 'A') ADVANCE(257);
      if (lookahead == 'B') ADVANCE(679);
      if (lookahead == 'C') ADVANCE(685);
      if (lookahead == 'D') ADVANCE(470);
      if (lookahead == 'G') ADVANCE(278);
      if (lookahead == 'N') ADVANCE(471);
      if (lookahead == 'P') ADVANCE(283);
      if (lookahead == 'R') ADVANCE(528);
      if (lookahead == 'S') ADVANCE(836);
      if (lookahead == 'T') ADVANCE(472);
      if (lookahead == 'V') ADVANCE(531);
      if (lookahead == '[') ADVANCE(196);
      if (lookahead == 'a') ADVANCE(380);
      if (lookahead == 'b') ADVANCE(529);
      if (lookahead == 'c') ADVANCE(284);
      if (lookahead == 'd') ADVANCE(473);
      if (lookahead == 'e') ADVANCE(1068);
      if (lookahead == 'f') ADVANCE(960);
      if (lookahead == 'g') ADVANCE(786);
      if (lookahead == 'i') ADVANCE(615);
      if (lookahead == 'l') ADVANCE(286);
      if (lookahead == 'n') ADVANCE(288);
      if (lookahead == 'p') ADVANCE(289);
      if (lookahead == 'r') ADVANCE(474);
      if (lookahead == 's') ADVANCE(536);
      if (lookahead == 't') ADVANCE(571);
      if (lookahead == 'u') ADVANCE(1152);
      if (lookahead == 'v') ADVANCE(600);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(228);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '(') ADVANCE(199);
      if (lookahead == ')') ADVANCE(200);
      if (lookahead == 'A') ADVANCE(257);
      if (lookahead == 'B') ADVANCE(697);
      if (lookahead == 'C') ADVANCE(685);
      if (lookahead == 'D') ADVANCE(470);
      if (lookahead == 'G') ADVANCE(278);
      if (lookahead == 'N') ADVANCE(471);
      if (lookahead == 'P') ADVANCE(283);
      if (lookahead == 'R') ADVANCE(528);
      if (lookahead == 'S') ADVANCE(836);
      if (lookahead == 'T') ADVANCE(472);
      if (lookahead == 'V') ADVANCE(531);
      if (lookahead == '[') ADVANCE(196);
      if (lookahead == ']') ADVANCE(197);
      if (lookahead == 'a') ADVANCE(380);
      if (lookahead == 'b') ADVANCE(530);
      if (lookahead == 'c') ADVANCE(284);
      if (lookahead == 'd') ADVANCE(473);
      if (lookahead == 'e') ADVANCE(1068);
      if (lookahead == 'f') ADVANCE(960);
      if (lookahead == 'g') ADVANCE(786);
      if (lookahead == 'i') ADVANCE(615);
      if (lookahead == 'l') ADVANCE(286);
      if (lookahead == 'n') ADVANCE(288);
      if (lookahead == 'p') ADVANCE(289);
      if (lookahead == 'r') ADVANCE(475);
      if (lookahead == 's') ADVANCE(536);
      if (lookahead == 't') ADVANCE(571);
      if (lookahead == 'u') ADVANCE(1152);
      if (lookahead == 'v') ADVANCE(600);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(228);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '(') ADVANCE(199);
      if (lookahead == ')') ADVANCE(200);
      if (lookahead == 'A') ADVANCE(257);
      if (lookahead == 'B') ADVANCE(697);
      if (lookahead == 'C') ADVANCE(685);
      if (lookahead == 'D') ADVANCE(470);
      if (lookahead == 'G') ADVANCE(278);
      if (lookahead == 'N') ADVANCE(471);
      if (lookahead == 'P') ADVANCE(283);
      if (lookahead == 'R') ADVANCE(528);
      if (lookahead == 'S') ADVANCE(836);
      if (lookahead == 'T') ADVANCE(472);
      if (lookahead == 'V') ADVANCE(531);
      if (lookahead == '[') ADVANCE(196);
      if (lookahead == 'a') ADVANCE(379);
      if (lookahead == 'b') ADVANCE(530);
      if (lookahead == 'c') ADVANCE(284);
      if (lookahead == 'd') ADVANCE(473);
      if (lookahead == 'e') ADVANCE(1068);
      if (lookahead == 'f') ADVANCE(960);
      if (lookahead == 'g') ADVANCE(786);
      if (lookahead == 'i') ADVANCE(615);
      if (lookahead == 'l') ADVANCE(286);
      if (lookahead == 'n') ADVANCE(288);
      if (lookahead == 'p') ADVANCE(289);
      if (lookahead == 'r') ADVANCE(475);
      if (lookahead == 's') ADVANCE(536);
      if (lookahead == 't') ADVANCE(571);
      if (lookahead == 'u') ADVANCE(1152);
      if (lookahead == 'v') ADVANCE(600);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(228);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '(') ADVANCE(199);
      if (lookahead == ')') ADVANCE(200);
      if (lookahead == 'A') ADVANCE(257);
      if (lookahead == 'B') ADVANCE(697);
      if (lookahead == 'C') ADVANCE(685);
      if (lookahead == 'D') ADVANCE(470);
      if (lookahead == 'G') ADVANCE(278);
      if (lookahead == 'N') ADVANCE(471);
      if (lookahead == 'P') ADVANCE(283);
      if (lookahead == 'R') ADVANCE(528);
      if (lookahead == 'S') ADVANCE(836);
      if (lookahead == 'T') ADVANCE(472);
      if (lookahead == 'V') ADVANCE(531);
      if (lookahead == '[') ADVANCE(196);
      if (lookahead == 'a') ADVANCE(380);
      if (lookahead == 'b') ADVANCE(530);
      if (lookahead == 'c') ADVANCE(284);
      if (lookahead == 'd') ADVANCE(473);
      if (lookahead == 'e') ADVANCE(900);
      if (lookahead == 'f') ADVANCE(960);
      if (lookahead == 'g') ADVANCE(786);
      if (lookahead == 'i') ADVANCE(615);
      if (lookahead == 'l') ADVANCE(286);
      if (lookahead == 'n') ADVANCE(288);
      if (lookahead == 'p') ADVANCE(289);
      if (lookahead == 'r') ADVANCE(475);
      if (lookahead == 's') ADVANCE(536);
      if (lookahead == 't') ADVANCE(571);
      if (lookahead == 'u') ADVANCE(1152);
      if (lookahead == 'v') ADVANCE(600);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(228);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '(') ADVANCE(199);
      if (lookahead == ')') ADVANCE(200);
      if (lookahead == 'A') ADVANCE(257);
      if (lookahead == 'B') ADVANCE(697);
      if (lookahead == 'C') ADVANCE(685);
      if (lookahead == 'D') ADVANCE(470);
      if (lookahead == 'G') ADVANCE(278);
      if (lookahead == 'N') ADVANCE(471);
      if (lookahead == 'P') ADVANCE(283);
      if (lookahead == 'R') ADVANCE(528);
      if (lookahead == 'S') ADVANCE(836);
      if (lookahead == 'T') ADVANCE(472);
      if (lookahead == 'V') ADVANCE(531);
      if (lookahead == '[') ADVANCE(196);
      if (lookahead == 'a') ADVANCE(380);
      if (lookahead == 'b') ADVANCE(530);
      if (lookahead == 'c') ADVANCE(284);
      if (lookahead == 'd') ADVANCE(473);
      if (lookahead == 'e') ADVANCE(1068);
      if (lookahead == 'f') ADVANCE(680);
      if (lookahead == 'g') ADVANCE(786);
      if (lookahead == 'i') ADVANCE(615);
      if (lookahead == 'l') ADVANCE(286);
      if (lookahead == 'n') ADVANCE(288);
      if (lookahead == 'p') ADVANCE(289);
      if (lookahead == 'r') ADVANCE(475);
      if (lookahead == 's') ADVANCE(536);
      if (lookahead == 't') ADVANCE(571);
      if (lookahead == 'u') ADVANCE(1152);
      if (lookahead == 'v') ADVANCE(600);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(228);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '(') ADVANCE(199);
      if (lookahead == ')') ADVANCE(200);
      if (lookahead == 'A') ADVANCE(257);
      if (lookahead == 'B') ADVANCE(697);
      if (lookahead == 'C') ADVANCE(685);
      if (lookahead == 'D') ADVANCE(470);
      if (lookahead == 'G') ADVANCE(278);
      if (lookahead == 'N') ADVANCE(471);
      if (lookahead == 'P') ADVANCE(283);
      if (lookahead == 'R') ADVANCE(528);
      if (lookahead == 'S') ADVANCE(836);
      if (lookahead == 'T') ADVANCE(472);
      if (lookahead == 'V') ADVANCE(531);
      if (lookahead == '[') ADVANCE(196);
      if (lookahead == 'a') ADVANCE(380);
      if (lookahead == 'b') ADVANCE(530);
      if (lookahead == 'c') ADVANCE(284);
      if (lookahead == 'd') ADVANCE(473);
      if (lookahead == 'e') ADVANCE(1068);
      if (lookahead == 'f') ADVANCE(960);
      if (lookahead == 'g') ADVANCE(786);
      if (lookahead == 'i') ADVANCE(615);
      if (lookahead == 'l') ADVANCE(286);
      if (lookahead == 'n') ADVANCE(288);
      if (lookahead == 'p') ADVANCE(289);
      if (lookahead == 'r') ADVANCE(475);
      if (lookahead == 's') ADVANCE(536);
      if (lookahead == 't') ADVANCE(571);
      if (lookahead == 'u') ADVANCE(1152);
      if (lookahead == 'v') ADVANCE(600);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(228);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '(') ADVANCE(199);
      if (lookahead == 'A') ADVANCE(257);
      if (lookahead == 'B') ADVANCE(679);
      if (lookahead == 'C') ADVANCE(685);
      if (lookahead == 'D') ADVANCE(470);
      if (lookahead == 'G') ADVANCE(278);
      if (lookahead == 'N') ADVANCE(471);
      if (lookahead == 'P') ADVANCE(283);
      if (lookahead == 'R') ADVANCE(528);
      if (lookahead == 'S') ADVANCE(836);
      if (lookahead == 'T') ADVANCE(472);
      if (lookahead == 'V') ADVANCE(531);
      if (lookahead == '[') ADVANCE(196);
      if (lookahead == ']') ADVANCE(197);
      if (lookahead == 'a') ADVANCE(380);
      if (lookahead == 'b') ADVANCE(529);
      if (lookahead == 'c') ADVANCE(284);
      if (lookahead == 'd') ADVANCE(473);
      if (lookahead == 'e') ADVANCE(1068);
      if (lookahead == 'f') ADVANCE(960);
      if (lookahead == 'g') ADVANCE(786);
      if (lookahead == 'i') ADVANCE(615);
      if (lookahead == 'l') ADVANCE(286);
      if (lookahead == 'n') ADVANCE(288);
      if (lookahead == 'p') ADVANCE(289);
      if (lookahead == 'r') ADVANCE(474);
      if (lookahead == 's') ADVANCE(536);
      if (lookahead == 't') ADVANCE(571);
      if (lookahead == 'u') ADVANCE(1152);
      if (lookahead == 'v') ADVANCE(600);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(228);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '(') ADVANCE(199);
      if (lookahead == 'A') ADVANCE(257);
      if (lookahead == 'B') ADVANCE(679);
      if (lookahead == 'C') ADVANCE(685);
      if (lookahead == 'D') ADVANCE(470);
      if (lookahead == 'G') ADVANCE(278);
      if (lookahead == 'N') ADVANCE(471);
      if (lookahead == 'P') ADVANCE(283);
      if (lookahead == 'R') ADVANCE(528);
      if (lookahead == 'S') ADVANCE(836);
      if (lookahead == 'T') ADVANCE(472);
      if (lookahead == 'V') ADVANCE(531);
      if (lookahead == '[') ADVANCE(196);
      if (lookahead == 'a') ADVANCE(379);
      if (lookahead == 'b') ADVANCE(529);
      if (lookahead == 'c') ADVANCE(284);
      if (lookahead == 'd') ADVANCE(473);
      if (lookahead == 'e') ADVANCE(1068);
      if (lookahead == 'f') ADVANCE(960);
      if (lookahead == 'g') ADVANCE(786);
      if (lookahead == 'i') ADVANCE(615);
      if (lookahead == 'l') ADVANCE(286);
      if (lookahead == 'n') ADVANCE(288);
      if (lookahead == 'p') ADVANCE(289);
      if (lookahead == 'r') ADVANCE(474);
      if (lookahead == 's') ADVANCE(536);
      if (lookahead == 't') ADVANCE(571);
      if (lookahead == 'u') ADVANCE(1152);
      if (lookahead == 'v') ADVANCE(600);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(228);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '(') ADVANCE(199);
      if (lookahead == 'A') ADVANCE(257);
      if (lookahead == 'B') ADVANCE(679);
      if (lookahead == 'C') ADVANCE(685);
      if (lookahead == 'D') ADVANCE(470);
      if (lookahead == 'G') ADVANCE(278);
      if (lookahead == 'N') ADVANCE(471);
      if (lookahead == 'P') ADVANCE(283);
      if (lookahead == 'R') ADVANCE(528);
      if (lookahead == 'S') ADVANCE(836);
      if (lookahead == 'T') ADVANCE(472);
      if (lookahead == 'V') ADVANCE(531);
      if (lookahead == '[') ADVANCE(196);
      if (lookahead == 'a') ADVANCE(380);
      if (lookahead == 'b') ADVANCE(529);
      if (lookahead == 'c') ADVANCE(284);
      if (lookahead == 'd') ADVANCE(473);
      if (lookahead == 'e') ADVANCE(900);
      if (lookahead == 'f') ADVANCE(960);
      if (lookahead == 'g') ADVANCE(786);
      if (lookahead == 'i') ADVANCE(615);
      if (lookahead == 'l') ADVANCE(286);
      if (lookahead == 'n') ADVANCE(288);
      if (lookahead == 'p') ADVANCE(289);
      if (lookahead == 'r') ADVANCE(474);
      if (lookahead == 's') ADVANCE(536);
      if (lookahead == 't') ADVANCE(571);
      if (lookahead == 'u') ADVANCE(1152);
      if (lookahead == 'v') ADVANCE(600);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(228);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '(') ADVANCE(199);
      if (lookahead == 'A') ADVANCE(257);
      if (lookahead == 'B') ADVANCE(679);
      if (lookahead == 'C') ADVANCE(685);
      if (lookahead == 'D') ADVANCE(470);
      if (lookahead == 'G') ADVANCE(278);
      if (lookahead == 'N') ADVANCE(471);
      if (lookahead == 'P') ADVANCE(283);
      if (lookahead == 'R') ADVANCE(528);
      if (lookahead == 'S') ADVANCE(836);
      if (lookahead == 'T') ADVANCE(472);
      if (lookahead == 'V') ADVANCE(531);
      if (lookahead == '[') ADVANCE(196);
      if (lookahead == 'a') ADVANCE(380);
      if (lookahead == 'b') ADVANCE(529);
      if (lookahead == 'c') ADVANCE(284);
      if (lookahead == 'd') ADVANCE(473);
      if (lookahead == 'e') ADVANCE(1068);
      if (lookahead == 'f') ADVANCE(680);
      if (lookahead == 'g') ADVANCE(786);
      if (lookahead == 'i') ADVANCE(615);
      if (lookahead == 'l') ADVANCE(286);
      if (lookahead == 'n') ADVANCE(288);
      if (lookahead == 'p') ADVANCE(289);
      if (lookahead == 'r') ADVANCE(474);
      if (lookahead == 's') ADVANCE(536);
      if (lookahead == 't') ADVANCE(571);
      if (lookahead == 'u') ADVANCE(1152);
      if (lookahead == 'v') ADVANCE(600);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(228);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '(') ADVANCE(199);
      if (lookahead == 'A') ADVANCE(257);
      if (lookahead == 'B') ADVANCE(679);
      if (lookahead == 'C') ADVANCE(685);
      if (lookahead == 'D') ADVANCE(470);
      if (lookahead == 'G') ADVANCE(278);
      if (lookahead == 'N') ADVANCE(471);
      if (lookahead == 'P') ADVANCE(283);
      if (lookahead == 'R') ADVANCE(528);
      if (lookahead == 'S') ADVANCE(836);
      if (lookahead == 'T') ADVANCE(472);
      if (lookahead == 'V') ADVANCE(531);
      if (lookahead == '[') ADVANCE(196);
      if (lookahead == 'a') ADVANCE(380);
      if (lookahead == 'b') ADVANCE(529);
      if (lookahead == 'c') ADVANCE(284);
      if (lookahead == 'd') ADVANCE(473);
      if (lookahead == 'e') ADVANCE(1068);
      if (lookahead == 'f') ADVANCE(960);
      if (lookahead == 'g') ADVANCE(786);
      if (lookahead == 'i') ADVANCE(615);
      if (lookahead == 'l') ADVANCE(286);
      if (lookahead == 'n') ADVANCE(288);
      if (lookahead == 'p') ADVANCE(289);
      if (lookahead == 'r') ADVANCE(474);
      if (lookahead == 's') ADVANCE(536);
      if (lookahead == 't') ADVANCE(571);
      if (lookahead == 'u') ADVANCE(1152);
      if (lookahead == 'v') ADVANCE(600);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(228);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '(') ADVANCE(199);
      if (lookahead == 'A') ADVANCE(257);
      if (lookahead == 'B') ADVANCE(697);
      if (lookahead == 'C') ADVANCE(685);
      if (lookahead == 'D') ADVANCE(470);
      if (lookahead == 'G') ADVANCE(278);
      if (lookahead == 'N') ADVANCE(471);
      if (lookahead == 'P') ADVANCE(283);
      if (lookahead == 'R') ADVANCE(528);
      if (lookahead == 'S') ADVANCE(836);
      if (lookahead == 'T') ADVANCE(472);
      if (lookahead == 'V') ADVANCE(531);
      if (lookahead == '[') ADVANCE(196);
      if (lookahead == ']') ADVANCE(197);
      if (lookahead == 'a') ADVANCE(379);
      if (lookahead == 'b') ADVANCE(530);
      if (lookahead == 'c') ADVANCE(284);
      if (lookahead == 'd') ADVANCE(473);
      if (lookahead == 'e') ADVANCE(1068);
      if (lookahead == 'f') ADVANCE(960);
      if (lookahead == 'g') ADVANCE(786);
      if (lookahead == 'i') ADVANCE(615);
      if (lookahead == 'l') ADVANCE(286);
      if (lookahead == 'n') ADVANCE(288);
      if (lookahead == 'p') ADVANCE(289);
      if (lookahead == 'r') ADVANCE(475);
      if (lookahead == 's') ADVANCE(536);
      if (lookahead == 't') ADVANCE(571);
      if (lookahead == 'u') ADVANCE(1152);
      if (lookahead == 'v') ADVANCE(600);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(228);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '(') ADVANCE(199);
      if (lookahead == 'A') ADVANCE(257);
      if (lookahead == 'B') ADVANCE(697);
      if (lookahead == 'C') ADVANCE(685);
      if (lookahead == 'D') ADVANCE(470);
      if (lookahead == 'G') ADVANCE(278);
      if (lookahead == 'N') ADVANCE(471);
      if (lookahead == 'P') ADVANCE(283);
      if (lookahead == 'R') ADVANCE(528);
      if (lookahead == 'S') ADVANCE(836);
      if (lookahead == 'T') ADVANCE(472);
      if (lookahead == 'V') ADVANCE(531);
      if (lookahead == '[') ADVANCE(196);
      if (lookahead == ']') ADVANCE(197);
      if (lookahead == 'a') ADVANCE(380);
      if (lookahead == 'b') ADVANCE(530);
      if (lookahead == 'c') ADVANCE(284);
      if (lookahead == 'd') ADVANCE(473);
      if (lookahead == 'e') ADVANCE(900);
      if (lookahead == 'f') ADVANCE(960);
      if (lookahead == 'g') ADVANCE(786);
      if (lookahead == 'i') ADVANCE(615);
      if (lookahead == 'l') ADVANCE(286);
      if (lookahead == 'n') ADVANCE(288);
      if (lookahead == 'p') ADVANCE(289);
      if (lookahead == 'r') ADVANCE(475);
      if (lookahead == 's') ADVANCE(536);
      if (lookahead == 't') ADVANCE(571);
      if (lookahead == 'u') ADVANCE(1152);
      if (lookahead == 'v') ADVANCE(600);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(228);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '(') ADVANCE(199);
      if (lookahead == 'A') ADVANCE(257);
      if (lookahead == 'B') ADVANCE(697);
      if (lookahead == 'C') ADVANCE(685);
      if (lookahead == 'D') ADVANCE(470);
      if (lookahead == 'G') ADVANCE(278);
      if (lookahead == 'N') ADVANCE(471);
      if (lookahead == 'P') ADVANCE(283);
      if (lookahead == 'R') ADVANCE(528);
      if (lookahead == 'S') ADVANCE(836);
      if (lookahead == 'T') ADVANCE(472);
      if (lookahead == 'V') ADVANCE(531);
      if (lookahead == '[') ADVANCE(196);
      if (lookahead == ']') ADVANCE(197);
      if (lookahead == 'a') ADVANCE(380);
      if (lookahead == 'b') ADVANCE(530);
      if (lookahead == 'c') ADVANCE(284);
      if (lookahead == 'd') ADVANCE(473);
      if (lookahead == 'e') ADVANCE(1068);
      if (lookahead == 'f') ADVANCE(680);
      if (lookahead == 'g') ADVANCE(786);
      if (lookahead == 'i') ADVANCE(615);
      if (lookahead == 'l') ADVANCE(286);
      if (lookahead == 'n') ADVANCE(288);
      if (lookahead == 'p') ADVANCE(289);
      if (lookahead == 'r') ADVANCE(475);
      if (lookahead == 's') ADVANCE(536);
      if (lookahead == 't') ADVANCE(571);
      if (lookahead == 'u') ADVANCE(1152);
      if (lookahead == 'v') ADVANCE(600);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(228);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '(') ADVANCE(199);
      if (lookahead == 'A') ADVANCE(257);
      if (lookahead == 'B') ADVANCE(697);
      if (lookahead == 'C') ADVANCE(685);
      if (lookahead == 'D') ADVANCE(470);
      if (lookahead == 'G') ADVANCE(278);
      if (lookahead == 'N') ADVANCE(471);
      if (lookahead == 'P') ADVANCE(283);
      if (lookahead == 'R') ADVANCE(528);
      if (lookahead == 'S') ADVANCE(836);
      if (lookahead == 'T') ADVANCE(472);
      if (lookahead == 'V') ADVANCE(531);
      if (lookahead == '[') ADVANCE(196);
      if (lookahead == ']') ADVANCE(197);
      if (lookahead == 'a') ADVANCE(380);
      if (lookahead == 'b') ADVANCE(530);
      if (lookahead == 'c') ADVANCE(284);
      if (lookahead == 'd') ADVANCE(473);
      if (lookahead == 'e') ADVANCE(1068);
      if (lookahead == 'f') ADVANCE(960);
      if (lookahead == 'g') ADVANCE(786);
      if (lookahead == 'i') ADVANCE(615);
      if (lookahead == 'l') ADVANCE(286);
      if (lookahead == 'n') ADVANCE(288);
      if (lookahead == 'p') ADVANCE(289);
      if (lookahead == 'r') ADVANCE(475);
      if (lookahead == 's') ADVANCE(536);
      if (lookahead == 't') ADVANCE(571);
      if (lookahead == 'u') ADVANCE(1152);
      if (lookahead == 'v') ADVANCE(600);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(228);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '(') ADVANCE(199);
      if (lookahead == 'A') ADVANCE(257);
      if (lookahead == 'B') ADVANCE(697);
      if (lookahead == 'C') ADVANCE(685);
      if (lookahead == 'D') ADVANCE(470);
      if (lookahead == 'G') ADVANCE(278);
      if (lookahead == 'N') ADVANCE(471);
      if (lookahead == 'P') ADVANCE(283);
      if (lookahead == 'R') ADVANCE(528);
      if (lookahead == 'S') ADVANCE(836);
      if (lookahead == 'T') ADVANCE(472);
      if (lookahead == 'V') ADVANCE(531);
      if (lookahead == '[') ADVANCE(196);
      if (lookahead == 'a') ADVANCE(380);
      if (lookahead == 'b') ADVANCE(530);
      if (lookahead == 'c') ADVANCE(284);
      if (lookahead == 'd') ADVANCE(473);
      if (lookahead == 'e') ADVANCE(900);
      if (lookahead == 'f') ADVANCE(680);
      if (lookahead == 'g') ADVANCE(786);
      if (lookahead == 'i') ADVANCE(615);
      if (lookahead == 'l') ADVANCE(286);
      if (lookahead == 'n') ADVANCE(288);
      if (lookahead == 'p') ADVANCE(289);
      if (lookahead == 'r') ADVANCE(475);
      if (lookahead == 's') ADVANCE(536);
      if (lookahead == 't') ADVANCE(571);
      if (lookahead == 'u') ADVANCE(1152);
      if (lookahead == 'v') ADVANCE(600);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(228);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '(') ADVANCE(199);
      if (lookahead == 'A') ADVANCE(257);
      if (lookahead == 'B') ADVANCE(697);
      if (lookahead == 'C') ADVANCE(685);
      if (lookahead == 'D') ADVANCE(470);
      if (lookahead == 'G') ADVANCE(278);
      if (lookahead == 'N') ADVANCE(471);
      if (lookahead == 'P') ADVANCE(283);
      if (lookahead == 'R') ADVANCE(528);
      if (lookahead == 'S') ADVANCE(836);
      if (lookahead == 'T') ADVANCE(472);
      if (lookahead == 'V') ADVANCE(531);
      if (lookahead == '[') ADVANCE(196);
      if (lookahead == 'a') ADVANCE(380);
      if (lookahead == 'b') ADVANCE(530);
      if (lookahead == 'c') ADVANCE(284);
      if (lookahead == 'd') ADVANCE(473);
      if (lookahead == 'e') ADVANCE(900);
      if (lookahead == 'f') ADVANCE(960);
      if (lookahead == 'g') ADVANCE(786);
      if (lookahead == 'i') ADVANCE(615);
      if (lookahead == 'l') ADVANCE(286);
      if (lookahead == 'n') ADVANCE(288);
      if (lookahead == 'p') ADVANCE(289);
      if (lookahead == 'r') ADVANCE(475);
      if (lookahead == 's') ADVANCE(536);
      if (lookahead == 't') ADVANCE(571);
      if (lookahead == 'u') ADVANCE(1152);
      if (lookahead == 'v') ADVANCE(600);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(228);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '(') ADVANCE(199);
      if (lookahead == 'A') ADVANCE(257);
      if (lookahead == 'B') ADVANCE(697);
      if (lookahead == 'C') ADVANCE(685);
      if (lookahead == 'D') ADVANCE(470);
      if (lookahead == 'G') ADVANCE(278);
      if (lookahead == 'N') ADVANCE(471);
      if (lookahead == 'P') ADVANCE(283);
      if (lookahead == 'R') ADVANCE(528);
      if (lookahead == 'S') ADVANCE(836);
      if (lookahead == 'T') ADVANCE(472);
      if (lookahead == 'V') ADVANCE(531);
      if (lookahead == '[') ADVANCE(196);
      if (lookahead == 'a') ADVANCE(380);
      if (lookahead == 'b') ADVANCE(530);
      if (lookahead == 'c') ADVANCE(284);
      if (lookahead == 'd') ADVANCE(473);
      if (lookahead == 'e') ADVANCE(1068);
      if (lookahead == 'f') ADVANCE(680);
      if (lookahead == 'g') ADVANCE(786);
      if (lookahead == 'i') ADVANCE(615);
      if (lookahead == 'l') ADVANCE(286);
      if (lookahead == 'n') ADVANCE(288);
      if (lookahead == 'p') ADVANCE(289);
      if (lookahead == 'r') ADVANCE(475);
      if (lookahead == 's') ADVANCE(536);
      if (lookahead == 't') ADVANCE(571);
      if (lookahead == 'u') ADVANCE(1152);
      if (lookahead == 'v') ADVANCE(600);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(228);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '(') ADVANCE(199);
      if (lookahead == 'A') ADVANCE(257);
      if (lookahead == 'B') ADVANCE(697);
      if (lookahead == 'C') ADVANCE(685);
      if (lookahead == 'D') ADVANCE(470);
      if (lookahead == 'G') ADVANCE(278);
      if (lookahead == 'N') ADVANCE(471);
      if (lookahead == 'P') ADVANCE(283);
      if (lookahead == 'R') ADVANCE(528);
      if (lookahead == 'S') ADVANCE(836);
      if (lookahead == 'T') ADVANCE(472);
      if (lookahead == 'V') ADVANCE(531);
      if (lookahead == '[') ADVANCE(196);
      if (lookahead == 'a') ADVANCE(380);
      if (lookahead == 'b') ADVANCE(530);
      if (lookahead == 'c') ADVANCE(284);
      if (lookahead == 'd') ADVANCE(473);
      if (lookahead == 'e') ADVANCE(1068);
      if (lookahead == 'f') ADVANCE(960);
      if (lookahead == 'g') ADVANCE(786);
      if (lookahead == 'i') ADVANCE(615);
      if (lookahead == 'l') ADVANCE(286);
      if (lookahead == 'n') ADVANCE(288);
      if (lookahead == 'p') ADVANCE(289);
      if (lookahead == 'r') ADVANCE(475);
      if (lookahead == 's') ADVANCE(536);
      if (lookahead == 't') ADVANCE(571);
      if (lookahead == 'u') ADVANCE(1152);
      if (lookahead == 'v') ADVANCE(600);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(228);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '(') ADVANCE(199);
      if (lookahead == 'A') ADVANCE(257);
      if (lookahead == 'B') ADVANCE(697);
      if (lookahead == 'C') ADVANCE(685);
      if (lookahead == 'D') ADVANCE(470);
      if (lookahead == 'G') ADVANCE(278);
      if (lookahead == 'N') ADVANCE(471);
      if (lookahead == 'P') ADVANCE(283);
      if (lookahead == 'R') ADVANCE(528);
      if (lookahead == 'S') ADVANCE(836);
      if (lookahead == 'T') ADVANCE(472);
      if (lookahead == 'V') ADVANCE(531);
      if (lookahead == '[') ADVANCE(196);
      if (lookahead == 'a') ADVANCE(382);
      if (lookahead == 'b') ADVANCE(686);
      if (lookahead == 'c') ADVANCE(285);
      if (lookahead == 'd') ADVANCE(473);
      if (lookahead == 'e') ADVANCE(1068);
      if (lookahead == 'f') ADVANCE(680);
      if (lookahead == 'g') ADVANCE(786);
      if (lookahead == 'i') ADVANCE(616);
      if (lookahead == 'l') ADVANCE(286);
      if (lookahead == 'n') ADVANCE(288);
      if (lookahead == 'p') ADVANCE(290);
      if (lookahead == 'r') ADVANCE(475);
      if (lookahead == 's') ADVANCE(893);
      if (lookahead == 't') ADVANCE(571);
      if (lookahead == 'u') ADVANCE(1152);
      if (lookahead == 'v') ADVANCE(600);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(228);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '(') ADVANCE(199);
      if (lookahead == 'A') ADVANCE(257);
      if (lookahead == 'B') ADVANCE(697);
      if (lookahead == 'C') ADVANCE(685);
      if (lookahead == 'D') ADVANCE(470);
      if (lookahead == 'G') ADVANCE(278);
      if (lookahead == 'N') ADVANCE(471);
      if (lookahead == 'P') ADVANCE(283);
      if (lookahead == 'R') ADVANCE(528);
      if (lookahead == 'S') ADVANCE(836);
      if (lookahead == 'T') ADVANCE(472);
      if (lookahead == 'V') ADVANCE(531);
      if (lookahead == '[') ADVANCE(196);
      if (lookahead == 'a') ADVANCE(382);
      if (lookahead == 'b') ADVANCE(686);
      if (lookahead == 'c') ADVANCE(285);
      if (lookahead == 'd') ADVANCE(473);
      if (lookahead == 'e') ADVANCE(1068);
      if (lookahead == 'f') ADVANCE(960);
      if (lookahead == 'g') ADVANCE(786);
      if (lookahead == 'i') ADVANCE(616);
      if (lookahead == 'l') ADVANCE(286);
      if (lookahead == 'n') ADVANCE(288);
      if (lookahead == 'p') ADVANCE(290);
      if (lookahead == 'r') ADVANCE(475);
      if (lookahead == 's') ADVANCE(893);
      if (lookahead == 't') ADVANCE(571);
      if (lookahead == 'u') ADVANCE(1152);
      if (lookahead == 'v') ADVANCE(600);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(228);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '(') ADVANCE(199);
      if (lookahead == 'A') ADVANCE(257);
      if (lookahead == 'B') ADVANCE(697);
      if (lookahead == 'C') ADVANCE(685);
      if (lookahead == 'D') ADVANCE(470);
      if (lookahead == 'G') ADVANCE(278);
      if (lookahead == 'N') ADVANCE(471);
      if (lookahead == 'P') ADVANCE(283);
      if (lookahead == 'R') ADVANCE(528);
      if (lookahead == 'S') ADVANCE(836);
      if (lookahead == 'T') ADVANCE(472);
      if (lookahead == 'V') ADVANCE(531);
      if (lookahead == '[') ADVANCE(196);
      if (lookahead == 'a') ADVANCE(382);
      if (lookahead == 'b') ADVANCE(530);
      if (lookahead == 'c') ADVANCE(285);
      if (lookahead == 'd') ADVANCE(473);
      if (lookahead == 'e') ADVANCE(900);
      if (lookahead == 'f') ADVANCE(680);
      if (lookahead == 'g') ADVANCE(786);
      if (lookahead == 'i') ADVANCE(616);
      if (lookahead == 'l') ADVANCE(286);
      if (lookahead == 'n') ADVANCE(288);
      if (lookahead == 'p') ADVANCE(290);
      if (lookahead == 'r') ADVANCE(475);
      if (lookahead == 's') ADVANCE(893);
      if (lookahead == 't') ADVANCE(571);
      if (lookahead == 'u') ADVANCE(1152);
      if (lookahead == 'v') ADVANCE(600);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(228);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '(') ADVANCE(199);
      if (lookahead == 'A') ADVANCE(257);
      if (lookahead == 'B') ADVANCE(697);
      if (lookahead == 'C') ADVANCE(685);
      if (lookahead == 'D') ADVANCE(470);
      if (lookahead == 'G') ADVANCE(278);
      if (lookahead == 'N') ADVANCE(471);
      if (lookahead == 'P') ADVANCE(283);
      if (lookahead == 'R') ADVANCE(528);
      if (lookahead == 'S') ADVANCE(836);
      if (lookahead == 'T') ADVANCE(472);
      if (lookahead == 'V') ADVANCE(531);
      if (lookahead == '[') ADVANCE(196);
      if (lookahead == 'a') ADVANCE(382);
      if (lookahead == 'b') ADVANCE(530);
      if (lookahead == 'c') ADVANCE(285);
      if (lookahead == 'd') ADVANCE(473);
      if (lookahead == 'e') ADVANCE(900);
      if (lookahead == 'f') ADVANCE(960);
      if (lookahead == 'g') ADVANCE(786);
      if (lookahead == 'i') ADVANCE(616);
      if (lookahead == 'l') ADVANCE(286);
      if (lookahead == 'n') ADVANCE(288);
      if (lookahead == 'p') ADVANCE(290);
      if (lookahead == 'r') ADVANCE(475);
      if (lookahead == 's') ADVANCE(893);
      if (lookahead == 't') ADVANCE(571);
      if (lookahead == 'u') ADVANCE(1152);
      if (lookahead == 'v') ADVANCE(600);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(228);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '(') ADVANCE(199);
      if (lookahead == 'A') ADVANCE(257);
      if (lookahead == 'B') ADVANCE(697);
      if (lookahead == 'C') ADVANCE(685);
      if (lookahead == 'D') ADVANCE(470);
      if (lookahead == 'G') ADVANCE(278);
      if (lookahead == 'N') ADVANCE(471);
      if (lookahead == 'P') ADVANCE(283);
      if (lookahead == 'R') ADVANCE(528);
      if (lookahead == 'S') ADVANCE(836);
      if (lookahead == 'T') ADVANCE(472);
      if (lookahead == 'V') ADVANCE(531);
      if (lookahead == '[') ADVANCE(196);
      if (lookahead == 'a') ADVANCE(382);
      if (lookahead == 'b') ADVANCE(530);
      if (lookahead == 'c') ADVANCE(285);
      if (lookahead == 'd') ADVANCE(473);
      if (lookahead == 'e') ADVANCE(1068);
      if (lookahead == 'f') ADVANCE(680);
      if (lookahead == 'g') ADVANCE(786);
      if (lookahead == 'i') ADVANCE(616);
      if (lookahead == 'l') ADVANCE(286);
      if (lookahead == 'n') ADVANCE(288);
      if (lookahead == 'p') ADVANCE(290);
      if (lookahead == 'r') ADVANCE(475);
      if (lookahead == 's') ADVANCE(893);
      if (lookahead == 't') ADVANCE(571);
      if (lookahead == 'u') ADVANCE(1152);
      if (lookahead == 'v') ADVANCE(600);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(228);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '(') ADVANCE(199);
      if (lookahead == 'A') ADVANCE(257);
      if (lookahead == 'B') ADVANCE(697);
      if (lookahead == 'C') ADVANCE(685);
      if (lookahead == 'D') ADVANCE(470);
      if (lookahead == 'G') ADVANCE(278);
      if (lookahead == 'N') ADVANCE(471);
      if (lookahead == 'P') ADVANCE(283);
      if (lookahead == 'R') ADVANCE(528);
      if (lookahead == 'S') ADVANCE(836);
      if (lookahead == 'T') ADVANCE(472);
      if (lookahead == 'V') ADVANCE(531);
      if (lookahead == '[') ADVANCE(196);
      if (lookahead == 'a') ADVANCE(382);
      if (lookahead == 'b') ADVANCE(530);
      if (lookahead == 'c') ADVANCE(285);
      if (lookahead == 'd') ADVANCE(473);
      if (lookahead == 'e') ADVANCE(1068);
      if (lookahead == 'f') ADVANCE(960);
      if (lookahead == 'g') ADVANCE(786);
      if (lookahead == 'i') ADVANCE(616);
      if (lookahead == 'l') ADVANCE(286);
      if (lookahead == 'n') ADVANCE(288);
      if (lookahead == 'p') ADVANCE(290);
      if (lookahead == 'r') ADVANCE(475);
      if (lookahead == 's') ADVANCE(893);
      if (lookahead == 't') ADVANCE(571);
      if (lookahead == 'u') ADVANCE(1152);
      if (lookahead == 'v') ADVANCE(600);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(228);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '(') ADVANCE(199);
      if (lookahead == 'A') ADVANCE(257);
      if (lookahead == 'B') ADVANCE(697);
      if (lookahead == 'C') ADVANCE(685);
      if (lookahead == 'D') ADVANCE(470);
      if (lookahead == 'G') ADVANCE(278);
      if (lookahead == 'N') ADVANCE(471);
      if (lookahead == 'P') ADVANCE(283);
      if (lookahead == 'R') ADVANCE(528);
      if (lookahead == 'S') ADVANCE(836);
      if (lookahead == 'T') ADVANCE(472);
      if (lookahead == 'V') ADVANCE(531);
      if (lookahead == '[') ADVANCE(196);
      if (lookahead == 'a') ADVANCE(381);
      if (lookahead == 'b') ADVANCE(686);
      if (lookahead == 'c') ADVANCE(285);
      if (lookahead == 'd') ADVANCE(473);
      if (lookahead == 'e') ADVANCE(1068);
      if (lookahead == 'f') ADVANCE(680);
      if (lookahead == 'g') ADVANCE(786);
      if (lookahead == 'i') ADVANCE(616);
      if (lookahead == 'l') ADVANCE(286);
      if (lookahead == 'n') ADVANCE(288);
      if (lookahead == 'p') ADVANCE(290);
      if (lookahead == 'r') ADVANCE(475);
      if (lookahead == 's') ADVANCE(893);
      if (lookahead == 't') ADVANCE(571);
      if (lookahead == 'u') ADVANCE(1152);
      if (lookahead == 'v') ADVANCE(600);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(228);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '(') ADVANCE(199);
      if (lookahead == 'A') ADVANCE(257);
      if (lookahead == 'B') ADVANCE(697);
      if (lookahead == 'C') ADVANCE(685);
      if (lookahead == 'D') ADVANCE(470);
      if (lookahead == 'G') ADVANCE(278);
      if (lookahead == 'N') ADVANCE(471);
      if (lookahead == 'P') ADVANCE(283);
      if (lookahead == 'R') ADVANCE(528);
      if (lookahead == 'S') ADVANCE(836);
      if (lookahead == 'T') ADVANCE(472);
      if (lookahead == 'V') ADVANCE(531);
      if (lookahead == '[') ADVANCE(196);
      if (lookahead == 'a') ADVANCE(381);
      if (lookahead == 'b') ADVANCE(686);
      if (lookahead == 'c') ADVANCE(285);
      if (lookahead == 'd') ADVANCE(473);
      if (lookahead == 'e') ADVANCE(1068);
      if (lookahead == 'f') ADVANCE(960);
      if (lookahead == 'g') ADVANCE(786);
      if (lookahead == 'i') ADVANCE(616);
      if (lookahead == 'l') ADVANCE(286);
      if (lookahead == 'n') ADVANCE(288);
      if (lookahead == 'p') ADVANCE(290);
      if (lookahead == 'r') ADVANCE(475);
      if (lookahead == 's') ADVANCE(893);
      if (lookahead == 't') ADVANCE(571);
      if (lookahead == 'u') ADVANCE(1152);
      if (lookahead == 'v') ADVANCE(600);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(228);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'C') ADVANCE(281);
      if (lookahead == 'c') ADVANCE(1570);
      if (lookahead == 'u') ADVANCE(1205);
      if (lookahead == 'v') ADVANCE(1025);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'C') ADVANCE(1115);
      if (lookahead == 'c') ADVANCE(1116);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'C') ADVANCE(1011);
      if (lookahead == 'E') ADVANCE(956);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'C') ADVANCE(1013);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'C') ADVANCE(1015);
      if (lookahead == 'E') ADVANCE(957);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'C') ADVANCE(1017);
      if (lookahead == 'E') ADVANCE(958);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'C') ADVANCE(1019);
      if (lookahead == 'E') ADVANCE(959);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'C') ADVANCE(1020);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'C') ADVANCE(1021);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'C') ADVANCE(1022);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'C') ADVANCE(1023);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'D') ADVANCE(1024);
      if (lookahead == 'E') ADVANCE(1316);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'D') ADVANCE(578);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'D') ADVANCE(1026);
      if (lookahead == 'E') ADVANCE(1326);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'D') ADVANCE(1028);
      if (lookahead == 'E') ADVANCE(1327);
      if (lookahead == 'M') ADVANCE(315);
      if (lookahead == 'P') ADVANCE(347);
      if (lookahead == 'R') ADVANCE(969);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'D') ADVANCE(1030);
      if (lookahead == 'E') ADVANCE(1328);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'D') ADVANCE(1032);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'D') ADVANCE(1040);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'D') ADVANCE(1042);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'D') ADVANCE(1044);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'I') ADVANCE(910);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'L') ADVANCE(282);
      if (lookahead == 'l') ADVANCE(1147);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'O') ADVANCE(1058);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'P') ADVANCE(349);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'R') ADVANCE(632);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'S') ADVANCE(1494);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(1091);
      if (lookahead == 'n') ADVANCE(1039);
      if (lookahead == 'r') ADVANCE(964);
      if (lookahead == 'v') ADVANCE(1027);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(1051);
      if (lookahead == 'h') ADVANCE(327);
      if (lookahead == 'i') ADVANCE(1211);
      if (lookahead == 'o') ADVANCE(788);
      if (lookahead == 'r') ADVANCE(541);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(1051);
      if (lookahead == 'i') ADVANCE(1211);
      if (lookahead == 'o') ADVANCE(788);
      if (lookahead == 'r') ADVANCE(541);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(367);
      if (lookahead == 'c') ADVANCE(901);
      if (lookahead == 'e') ADVANCE(633);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(367);
      if (lookahead == 'c') ADVANCE(901);
      if (lookahead == 'e') ADVANCE(1171);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(848);
      if (lookahead == 'e') ADVANCE(1312);
      if (lookahead == 'o') ADVANCE(389);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(653);
      if (lookahead == 'n') ADVANCE(1043);
      if (lookahead == 'v') ADVANCE(1035);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(654);
      if (lookahead == 'n') ADVANCE(1043);
      if (lookahead == 'v') ADVANCE(1035);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(1145);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(856);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(652);
      if (lookahead == 'e') ADVANCE(946);
      if (lookahead == 't') ADVANCE(55);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(1046);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(394);
      if (lookahead == 'c') ADVANCE(967);
      if (lookahead == 'e') ADVANCE(933);
      if (lookahead == 'g') ADVANCE(794);
      if (lookahead == 'l') ADVANCE(328);
      if (lookahead == 't') ADVANCE(670);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(1049);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(390);
      if (lookahead == 'g') ADVANCE(637);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(1052);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(372);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(909);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(904);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(906);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(1073);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 304:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(766);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 305:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(767);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 306:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(1085);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 307:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(908);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 308:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(1078);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 309:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(911);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 310:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(913);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 311:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(771);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 312:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(916);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 313:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(917);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 314:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(919);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 315:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(1206);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 316:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(1087);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 317:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(920);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 318:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(1089);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 319:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(921);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 320:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(922);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 321:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(923);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 322:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(776);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 323:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(779);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 324:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(782);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 325:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(810);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 326:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(1252);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 327:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(1061);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 328:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(369);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 329:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(1156);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 330:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(1210);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 331:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(1053);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 332:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(1059);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 333:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(1094);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 334:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(934);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 335:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(1110);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 336:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(850);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 337:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(1100);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 338:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(1212);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 339:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(1054);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 340:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(657);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 341:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(851);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 342:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(658);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 343:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(1114);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 344:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(852);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 345:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(659);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 346:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(1229);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 347:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(713);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 348:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(661);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 349:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(433);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 350:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(1146);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 351:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(376);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 352:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(377);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 353:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(378);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 354:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(961);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 355:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(962);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 356:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(963);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 357:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'b') ADVANCE(634);
      if (lookahead == 'p') ADVANCE(545);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 358:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'b') ADVANCE(635);
      if (lookahead == 'p') ADVANCE(545);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 359:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'b') ADVANCE(791);
      if (lookahead == 'g') ADVANCE(1466);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 360:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'b') ADVANCE(791);
      if (lookahead == 'g') ADVANCE(1467);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 361:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'b') ADVANCE(791);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 362:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'b') ADVANCE(687);
      if (lookahead == 'c') ADVANCE(667);
      if (lookahead == 'p') ADVANCE(337);
      if (lookahead == 's') ADVANCE(544);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 363:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'b') ADVANCE(687);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 364:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'b') ADVANCE(330);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 365:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'b') ADVANCE(1287);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 366:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'b') ADVANCE(1169);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 367:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'b') ADVANCE(555);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 368:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'b') ADVANCE(1131);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 369:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'b') ADVANCE(567);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 370:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'b') ADVANCE(990);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 371:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'b') ADVANCE(993);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 372:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'b') ADVANCE(806);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 373:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'b') ADVANCE(1117);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 374:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'b') ADVANCE(338);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 375:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'b') ADVANCE(1135);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 376:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'b') ADVANCE(833);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 377:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'b') ADVANCE(834);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 378:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'b') ADVANCE(835);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 379:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'c') ADVANCE(1569);
      if (lookahead == 'd') ADVANCE(446);
      if (lookahead == 'n') ADVANCE(447);
      if (lookahead == 'u') ADVANCE(1170);
      if (lookahead == 'v') ADVANCE(1033);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 380:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'c') ADVANCE(1569);
      if (lookahead == 'd') ADVANCE(446);
      if (lookahead == 'u') ADVANCE(1170);
      if (lookahead == 'v') ADVANCE(1033);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 381:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'c') ADVANCE(1569);
      if (lookahead == 'd') ADVANCE(461);
      if (lookahead == 'n') ADVANCE(447);
      if (lookahead == 'u') ADVANCE(1170);
      if (lookahead == 'v') ADVANCE(1033);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 382:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'c') ADVANCE(1569);
      if (lookahead == 'd') ADVANCE(461);
      if (lookahead == 'u') ADVANCE(1170);
      if (lookahead == 'v') ADVANCE(1033);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 383:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'c') ADVANCE(727);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 384:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'c') ADVANCE(65);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 385:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'c') ADVANCE(1519);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 386:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'c') ADVANCE(1518);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 387:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'c') ADVANCE(1517);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 388:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'c') ADVANCE(1281);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 389:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'c') ADVANCE(704);
      if (lookahead == 't') ADVANCE(596);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 390:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'c') ADVANCE(751);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 391:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'c') ADVANCE(789);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 392:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'c') ADVANCE(790);
      if (lookahead == 'p') ADVANCE(1275);
      if (lookahead == 't') ADVANCE(542);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 393:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'c') ADVANCE(790);
      if (lookahead == 'p') ADVANCE(1275);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 394:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'c') ADVANCE(1133);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 395:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'c') ADVANCE(1150);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 396:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'c') ADVANCE(332);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 397:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'c') ADVANCE(525);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 398:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'c') ADVANCE(997);
      if (lookahead == 'r') ADVANCE(549);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 399:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'c') ADVANCE(801);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 400:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'c') ADVANCE(1118);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 401:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'c') ADVANCE(706);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 402:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'c') ADVANCE(813);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 403:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'c') ADVANCE(999);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 404:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'c') ADVANCE(708);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 405:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'c') ADVANCE(815);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 406:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'c') ADVANCE(709);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 407:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'c') ADVANCE(711);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 408:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'c') ADVANCE(712);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 409:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'c') ADVANCE(714);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 410:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'c') ADVANCE(716);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 411:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'c') ADVANCE(717);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 412:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'c') ADVANCE(718);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 413:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'c') ADVANCE(719);
      if (lookahead == 'r') ADVANCE(548);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 414:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'c') ADVANCE(720);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 415:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'c') ADVANCE(721);
      if (lookahead == 'f') ADVANCE(1298);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 416:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'c') ADVANCE(722);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 417:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'c') ADVANCE(723);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 418:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'c') ADVANCE(724);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 419:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'c') ADVANCE(725);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 420:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'c') ADVANCE(726);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 421:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'c') ADVANCE(728);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 422:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'c') ADVANCE(729);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 423:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'c') ADVANCE(730);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 424:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'c') ADVANCE(731);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 425:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'c') ADVANCE(732);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 426:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'c') ADVANCE(733);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 427:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'c') ADVANCE(734);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 428:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'c') ADVANCE(735);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 429:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'c') ADVANCE(736);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 430:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'c') ADVANCE(737);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 431:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'c') ADVANCE(738);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 432:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'c') ADVANCE(1293);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 433:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'c') ADVANCE(752);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 434:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'c') ADVANCE(812);
      if (lookahead == 'f') ADVANCE(1463);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 435:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'c') ADVANCE(1254);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 436:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'c') ADVANCE(1008);
      if (lookahead == 'e') ADVANCE(955);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 437:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'c') ADVANCE(1294);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 438:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'c') ADVANCE(1256);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 439:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'c') ADVANCE(1257);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 440:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'c') ADVANCE(1295);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 441:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'c') ADVANCE(1296);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 442:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'c') ADVANCE(1297);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 443:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'c') ADVANCE(1299);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 444:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'c') ADVANCE(1300);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 445:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'c') ADVANCE(1301);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 446:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'd') ADVANCE(362);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 447:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'd') ADVANCE(80);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 448:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'd') ADVANCE(202);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 449:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'd') ADVANCE(1447);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 450:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'd') ADVANCE(1449);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 451:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'd') ADVANCE(269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 452:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'd') ADVANCE(1455);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 453:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'd') ADVANCE(1451);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 454:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'd') ADVANCE(1456);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 455:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'd') ADVANCE(1458);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 456:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'd') ADVANCE(1457);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 457:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'd') ADVANCE(1459);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 458:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'd') ADVANCE(1460);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 459:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'd') ADVANCE(1462);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 460:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'd') ADVANCE(1461);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 461:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'd') ADVANCE(363);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 462:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'd') ADVANCE(299);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 463:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'd') ADVANCE(611);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 464:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'd') ADVANCE(489);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 465:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'd') ADVANCE(562);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 466:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'd') ADVANCE(526);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 467:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'd') ADVANCE(351);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 468:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'd') ADVANCE(352);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 469:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'd') ADVANCE(353);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 470:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(391);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 471:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1311);
      if (lookahead == 'o') ADVANCE(1249);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 472:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1317);
      if (lookahead == 'v') ADVANCE(1031);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 473:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(434);
      if (lookahead == 'o') ADVANCE(388);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 474:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(618);
      if (lookahead == 'i') ADVANCE(643);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 475:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(618);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 476:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1045);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 477:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1369);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 478:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1367);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 479:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(258);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 480:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1344);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 481:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1370);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 482:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(271);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 483:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1514);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 484:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1513);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 485:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(280);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 486:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1407);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 487:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1512);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 488:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(47);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 489:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1349);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 490:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1352);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 491:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1406);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 492:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1403);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 493:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1417);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 494:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1419);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 495:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1409);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 496:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1413);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 497:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1398);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 498:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1415);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 499:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1402);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 500:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1416);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 501:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1383);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 502:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1394);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 503:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1386);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 504:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1410);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 505:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1418);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 506:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1408);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 507:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1412);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 508:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1397);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 509:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1414);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 510:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1444);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 511:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1393);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 512:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1421);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 513:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1400);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 514:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1379);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 515:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1442);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 516:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1422);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 517:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1411);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 518:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1391);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 519:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1420);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 520:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1399);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 521:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1401);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 522:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1346);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 523:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1395);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 524:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1347);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 525:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1353);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 526:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1350);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 527:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1357);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 528:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(914);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 529:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(651);
      if (lookahead == 'i') ADVANCE(359);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 530:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(651);
      if (lookahead == 'i') ADVANCE(360);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 531:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1082);
      if (lookahead == 'o') ADVANCE(787);
      if (lookahead == 'r') ADVANCE(538);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 532:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(619);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 533:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(837);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 534:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(398);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 535:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(273);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 536:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(435);
      if (lookahead == 'm') ADVANCE(350);
      if (lookahead == 'u') ADVANCE(357);
      if (lookahead == 'v') ADVANCE(1036);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 537:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1313);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 538:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(620);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 539:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(945);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 540:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1153);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 541:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(621);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 542:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1132);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 543:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(622);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 544:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(384);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 545:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1144);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 546:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(623);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 547:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(451);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 548:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(624);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 549:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(625);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 550:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1159);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 551:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(403);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 552:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(626);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 553:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(627);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 554:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(841);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 555:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(756);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 556:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(400);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 557:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1071);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 558:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(628);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 559:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(629);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 560:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1005);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 561:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1084);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 562:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(636);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 563:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(844);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 564:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1072);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 565:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(630);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 566:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1086);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 567:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(761);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 568:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1259);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 569:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1081);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 570:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1197);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 571:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1318);
      if (lookahead == 'i') ADVANCE(1207);
      if (lookahead == 'v') ADVANCE(1037);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 572:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(924);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 573:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1155);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 574:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(303);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 575:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1319);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 576:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(925);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 577:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1157);
      if (lookahead == 'i') ADVANCE(1151);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 578:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(798);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 579:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1320);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 580:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(926);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 581:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1321);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 582:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(927);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 583:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(949);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 584:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1323);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 585:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(928);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 586:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1324);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 587:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(929);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 588:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1325);
      if (lookahead == 'i') ADVANCE(1207);
      if (lookahead == 'v') ADVANCE(1037);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 589:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(930);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 590:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(931);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 591:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1121);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 592:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1107);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 593:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(935);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 594:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1006);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 595:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(408);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 596:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(418);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 597:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(423);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 598:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(425);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 599:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(428);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 600:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1137);
      if (lookahead == 'o') ADVANCE(817);
      if (lookahead == 'r') ADVANCE(543);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 601:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(438);
      if (lookahead == 'u') ADVANCE(366);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 602:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(946);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 603:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(948);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 604:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(439);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 605:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(950);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 606:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(952);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 607:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(951);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 608:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(953);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 609:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(954);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 610:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(274);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 611:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(272);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 612:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(275);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 613:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(276);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 614:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'e') ADVANCE(1314);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 615:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'f') ADVANCE(631);
      if (lookahead == 'm') ADVANCE(1050);
      if (lookahead == 'n') ADVANCE(392);
      if (lookahead == 't') ADVANCE(533);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 616:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'f') ADVANCE(631);
      if (lookahead == 'm') ADVANCE(1050);
      if (lookahead == 'n') ADVANCE(392);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 617:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'f') ADVANCE(631);
      if (lookahead == 'm') ADVANCE(1050);
      if (lookahead == 'n') ADVANCE(393);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 618:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'f') ADVANCE(1424);
      if (lookahead == 'n') ADVANCE(537);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 619:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'f') ADVANCE(1431);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 620:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'f') ADVANCE(1427);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 621:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'f') ADVANCE(1430);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 622:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'f') ADVANCE(1426);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 623:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'f') ADVANCE(1425);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 624:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'f') ADVANCE(1428);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 625:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'f') ADVANCE(1429);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 626:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'f') ADVANCE(1435);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 627:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'f') ADVANCE(1434);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 628:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'f') ADVANCE(1440);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 629:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'f') ADVANCE(1436);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 630:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'f') ADVANCE(1441);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 631:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'f') ADVANCE(325);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 632:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'f') ADVANCE(1276);
      if (lookahead == 'l') ADVANCE(970);
      if (lookahead == 's') ADVANCE(673);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 633:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'f') ADVANCE(1172);
      if (lookahead == 't') ADVANCE(1464);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 634:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'f') ADVANCE(701);
      if (lookahead == 'i') ADVANCE(886);
      if (lookahead == 'p') ADVANCE(333);
      if (lookahead == 's') ADVANCE(601);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 635:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'f') ADVANCE(701);
      if (lookahead == 'i') ADVANCE(886);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 636:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'f') ADVANCE(1106);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 637:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'f') ADVANCE(795);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 638:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'f') ADVANCE(1283);
      if (lookahead == 'l') ADVANCE(973);
      if (lookahead == 's') ADVANCE(675);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 639:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'f') ADVANCE(1285);
      if (lookahead == 'l') ADVANCE(974);
      if (lookahead == 's') ADVANCE(676);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 640:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'f') ADVANCE(1288);
      if (lookahead == 'l') ADVANCE(987);
      if (lookahead == 's') ADVANCE(677);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 641:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'f') ADVANCE(1289);
      if (lookahead == 'l') ADVANCE(989);
      if (lookahead == 's') ADVANCE(678);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 642:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'g') ADVANCE(1468);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 643:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'g') ADVANCE(668);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 644:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'g') ADVANCE(1547);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 645:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'g') ADVANCE(1546);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 646:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'g') ADVANCE(1545);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 647:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'g') ADVANCE(1356);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 648:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'g') ADVANCE(1573);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 649:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'g') ADVANCE(1572);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 650:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'g') ADVANCE(1469);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 651:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'g') ADVANCE(689);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 652:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'g') ADVANCE(1092);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 653:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'g') ADVANCE(534);
      if (lookahead == 'r') ADVANCE(293);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 654:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'g') ADVANCE(534);
      if (lookahead == 'r') ADVANCE(602);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 655:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'g') ADVANCE(510);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 656:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'g') ADVANCE(515);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 657:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'g') ADVANCE(591);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 658:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'g') ADVANCE(522);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 659:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'g') ADVANCE(524);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 660:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'g') ADVANCE(1102);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 661:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'g') ADVANCE(1128);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 662:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'h') ADVANCE(71);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 663:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'h') ADVANCE(279);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 664:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'h') ADVANCE(73);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 665:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'h') ADVANCE(1329);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 666:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'h') ADVANCE(972);
      if (lookahead == 'o') ADVANCE(413);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 667:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'h') ADVANCE(294);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 668:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'h') ADVANCE(1175);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 669:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'h') ADVANCE(698);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 670:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'h') ADVANCE(560);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 671:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'h') ADVANCE(986);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 672:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'h') ADVANCE(988);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 673:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'h') ADVANCE(998);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 674:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'h') ADVANCE(594);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 675:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'h') ADVANCE(1000);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 676:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'h') ADVANCE(1001);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 677:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'h') ADVANCE(1003);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 678:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'h') ADVANCE(1004);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 679:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(642);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 680:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(48);
      if (lookahead == 'n') ADVANCE(1041);
      if (lookahead == 'o') ADVANCE(971);
      if (lookahead == 't') ADVANCE(1310);
      if (lookahead == 'u') ADVANCE(831);
      if (lookahead == 'v') ADVANCE(1034);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 681:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(748);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 682:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(1522);
      if (lookahead == 'v') ADVANCE(1534);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 683:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(1521);
      if (lookahead == 'v') ADVANCE(1533);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 684:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(1520);
      if (lookahead == 'v') ADVANCE(1532);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 685:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(1209);
      if (lookahead == 'r') ADVANCE(532);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 686:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(360);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 687:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(373);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 688:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(463);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 689:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(894);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 690:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(368);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 691:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(1088);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 692:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(838);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 693:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(853);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 694:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(361);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 695:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(899);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 696:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(1007);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 697:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(650);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 698:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(395);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 699:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(885);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 700:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(1123);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 701:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(804);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 702:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(1126);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 703:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(1112);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 704:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(1216);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 705:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(976);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 706:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(1218);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 707:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(978);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 708:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(1219);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 709:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(1220);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 710:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(985);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 711:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(1221);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 712:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(1222);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 713:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(1120);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 714:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(1223);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 715:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(991);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 716:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(1224);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 717:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(1225);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 718:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(1226);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 719:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(1227);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 720:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(1228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 721:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(1230);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 722:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(1231);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 723:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(1232);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 724:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(1233);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 725:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(1234);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 726:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(1235);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 727:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(1236);
      if (lookahead == 'o') ADVANCE(808);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 728:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(1237);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 729:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(1238);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 730:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(1239);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 731:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(1240);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 732:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(1241);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 733:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(1242);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 734:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(1243);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 735:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(1244);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 736:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(1245);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 737:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(1246);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 738:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(1247);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 739:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(1248);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 740:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(1136);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 741:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(937);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 742:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(375);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 743:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(1139);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 744:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(1140);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 745:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(1141);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 746:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(1142);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 747:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(1143);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 748:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'k') ADVANCE(1339);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 749:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'k') ADVANCE(1499);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 750:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'k') ADVANCE(1158);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 751:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'k') ADVANCE(342);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 752:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'k') ADVANCE(345);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 753:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(1497);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 754:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(1496);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 755:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(1495);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 756:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(1423);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 757:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(1553);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 758:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(1552);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 759:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(1551);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 760:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(1385);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 761:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(1446);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 762:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(1556);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 763:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(1550);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 764:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(1555);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 765:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(1549);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 766:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(1508);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 767:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(1507);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 768:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(1516);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 769:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(1554);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 770:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(1548);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 771:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(1506);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 772:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(1515);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 773:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(1544);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 774:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(1543);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 775:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(1542);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 776:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(1511);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 777:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(1581);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 778:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(1575);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 779:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(1510);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 780:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(1580);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 781:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(1574);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 782:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(1509);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 783:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(1579);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 784:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(1578);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 785:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(1047);
      if (lookahead == 'u') ADVANCE(1255);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 786:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(1148);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 787:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(401);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 788:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(966);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 789:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(335);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 790:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(1282);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 791:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(696);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 792:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(1290);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 793:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(1056);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 794:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(968);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 795:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(690);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 796:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(757);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 797:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(758);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 798:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(699);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 799:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(759);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 800:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(982);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 801:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(329);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 802:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(480);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 803:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(793);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 804:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(490);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 805:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(514);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 806:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(535);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 807:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(1057);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 808:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(984);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 809:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(807);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 810:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(1167);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 811:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(992);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 812:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(343);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 813:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(1284);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 814:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(1291);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 815:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(1286);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 816:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(1292);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 817:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(404);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 818:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(742);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 819:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(407);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 820:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(409);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 821:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(410);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 822:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(412);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 823:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(414);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 824:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(416);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 825:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(417);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 826:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(419);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 827:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(420);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 828:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(421);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 829:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(426);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 830:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(431);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 831:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(824);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 832:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(830);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 833:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(610);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 834:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(612);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 835:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(613);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 836:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'm') ADVANCE(291);
      if (lookahead == 'v') ADVANCE(1029);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 837:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'm') ADVANCE(75);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 838:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'm') ADVANCE(277);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 839:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'm') ADVANCE(1362);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 840:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'm') ADVANCE(1538);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 841:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'm') ADVANCE(1582);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 842:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'm') ADVANCE(1364);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 843:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'm') ADVANCE(1363);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 844:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'm') ADVANCE(1584);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 845:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'm') ADVANCE(1365);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 846:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'm') ADVANCE(370);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 847:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'm') ADVANCE(854);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 848:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'm') ADVANCE(479);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 849:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'm') ADVANCE(572);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 850:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'm') ADVANCE(483);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 851:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'm') ADVANCE(484);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 852:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'm') ADVANCE(487);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 853:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'm') ADVANCE(741);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 854:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'm') ADVANCE(302);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 855:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'm') ADVANCE(307);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 856:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'm') ADVANCE(556);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 857:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'm') ADVANCE(309);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 858:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'm') ADVANCE(310);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 859:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'm') ADVANCE(312);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 860:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'm') ADVANCE(313);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 861:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'm') ADVANCE(314);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 862:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'm') ADVANCE(317);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 863:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'm') ADVANCE(319);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 864:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'm') ADVANCE(320);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 865:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'm') ADVANCE(321);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 866:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'm') ADVANCE(371);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 867:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'm') ADVANCE(855);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 868:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'm') ADVANCE(576);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 869:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'm') ADVANCE(857);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 870:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'm') ADVANCE(580);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 871:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'm') ADVANCE(858);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 872:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'm') ADVANCE(582);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 873:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'm') ADVANCE(859);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 874:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'm') ADVANCE(583);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 875:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'm') ADVANCE(860);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 876:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'm') ADVANCE(585);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 877:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'm') ADVANCE(861);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 878:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'm') ADVANCE(587);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 879:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'm') ADVANCE(862);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 880:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'm') ADVANCE(589);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 881:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'm') ADVANCE(863);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 882:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'm') ADVANCE(590);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 883:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'm') ADVANCE(864);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 884:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'm') ADVANCE(865);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 885:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'm') ADVANCE(739);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 886:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'm') ADVANCE(1064);
      if (lookahead == 'n') ADVANCE(402);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 887:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'm') ADVANCE(603);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 888:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'm') ADVANCE(605);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 889:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'm') ADVANCE(606);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 890:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'm') ADVANCE(607);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 891:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'm') ADVANCE(608);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 892:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'm') ADVANCE(609);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 893:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'm') ADVANCE(350);
      if (lookahead == 'u') ADVANCE(358);
      if (lookahead == 'v') ADVANCE(1036);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 894:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(201);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 895:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(1366);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 896:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(63);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 897:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(67);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 898:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(69);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 899:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(749);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 900:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(448);
      if (lookahead == 'q') ADVANCE(1093);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 901:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(292);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 902:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(750);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 903:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(644);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 904:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(462);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 905:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(645);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 906:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(449);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 907:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(646);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 908:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(450);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 909:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(655);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 910:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(1062);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 911:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(452);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 912:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(648);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 913:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(453);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 914:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(614);
      if (lookahead == 'q') ADVANCE(1274);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 915:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(649);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 916:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(454);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 917:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(455);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 918:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(1213);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 919:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(456);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 920:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(457);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 921:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(458);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 922:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(459);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 923:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(460);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 924:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(1253);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 925:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(1190);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 926:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(1198);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 927:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(1199);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 928:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(1200);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 929:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(1201);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 930:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(1202);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 931:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(1203);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 932:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(1334);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 933:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(1304);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 934:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(656);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 935:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(1217);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 936:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(551);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 937:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(1063);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 938:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(870);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 939:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(872);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 940:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(876);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 941:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(878);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 942:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(880);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 943:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(882);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 944:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(405);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 945:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(422);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 946:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(427);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 947:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(1260);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 948:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(1264);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 949:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(1265);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 950:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(1266);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 951:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(1267);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 952:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(1269);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 953:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(1270);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 954:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(1272);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 955:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(1305);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 956:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(1306);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 957:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(1307);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 958:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(1308);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 959:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(1309);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 960:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(1041);
      if (lookahead == 'o') ADVANCE(971);
      if (lookahead == 't') ADVANCE(1310);
      if (lookahead == 'u') ADVANCE(831);
      if (lookahead == 'v') ADVANCE(1034);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 961:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(467);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 962:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(468);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 963:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'n') ADVANCE(469);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 964:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(1302);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 965:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(1315);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 966:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(1069);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 967:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(847);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 968:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(1154);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 969:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(365);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 970:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(903);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 971:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(1204);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 972:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(1070);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 973:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(905);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 974:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(907);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 975:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(839);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 976:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(895);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 977:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(842);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 978:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(896);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 979:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(843);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 980:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(932);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 981:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(845);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 982:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(1074);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 983:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(938);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 984:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(1075);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 985:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(897);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 986:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(1076);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 987:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(912);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 988:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(1077);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 989:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(915);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 990:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(768);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 991:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(898);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 992:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(1079);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 993:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(772);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 994:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(1080);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 995:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(1095);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 996:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(1278);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 997:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(800);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 998:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(1103);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 999:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(811);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1000:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(1105);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1001:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(1108);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1002:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(1109);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1003:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(1111);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1004:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(1113);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1005:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(1119);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1006:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(1122);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1007:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(660);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1008:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(867);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1009:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(939);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1010:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(406);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1011:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(869);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1012:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(940);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1013:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(871);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1014:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(941);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1015:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(873);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1016:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(942);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1017:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(875);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1018:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(943);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1019:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(877);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1020:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(879);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1021:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(881);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1022:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(883);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1023:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(884);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1024:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(432);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1025:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(819);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1026:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(440);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1027:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(820);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1028:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(441);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1029:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(821);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1030:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(442);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1031:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(822);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1032:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(437);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1033:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(823);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1034:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(825);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1035:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(826);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1036:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(827);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1037:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(828);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1038:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(829);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1039:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(1268);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1040:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(443);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1041:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(1271);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1042:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(444);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1043:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(1273);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1044:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'o') ADVANCE(445);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1045:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'p') ADVANCE(297);
      if (lookahead == 't') ADVANCE(681);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1046:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'p') ADVANCE(61);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1047:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'p') ADVANCE(1389);
      if (lookahead == 't') ADVANCE(1388);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1048:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'p') ADVANCE(1498);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1049:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'p') ADVANCE(662);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1050:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'p') ADVANCE(995);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1051:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'p') ADVANCE(1208);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1052:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'p') ADVANCE(665);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1053:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'p') ADVANCE(669);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1054:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'p') ADVANCE(664);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1055:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'p') ADVANCE(340);
      if (lookahead == 'r') ADVANCE(558);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1056:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'p') ADVANCE(777);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1057:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'p') ADVANCE(780);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1058:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'p') ADVANCE(592);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1059:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'p') ADVANCE(527);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1060:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'p') ADVANCE(301);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1061:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'p') ADVANCE(1215);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1062:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'p') ADVANCE(1279);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1063:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'p') ADVANCE(1280);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1064:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'p') ADVANCE(1002);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1065:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'p') ADVANCE(354);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1066:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'p') ADVANCE(355);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1067:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'p') ADVANCE(356);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1068:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'q') ADVANCE(1093);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1069:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(1588);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1070:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(1345);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1071:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(682);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1072:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(59);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1073:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(1381);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1074:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(1591);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1075:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(1590);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1076:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(1377);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1077:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(1375);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1078:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(1387);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1079:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(1586);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1080:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(1453);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1081:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(1483);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1082:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(364);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1083:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(1336);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1084:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(683);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1085:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(1335);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1086:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(684);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1087:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(1330);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1088:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(1160);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1089:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(1331);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1090:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(1332);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1091:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(539);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1092:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(296);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1093:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(546);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1094:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(348);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1095:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(1176);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1096:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(397);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1097:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(304);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1098:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(975);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1099:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(760);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1100:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(1179);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1101:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(977);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1102:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(298);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1103:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(1181);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1104:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(979);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1105:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(1182);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1106:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(981);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1107:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(326);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1108:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(1185);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1109:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(1189);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1110:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(482);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1111:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(1193);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1112:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(485);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1113:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(1195);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1114:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(568);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1115:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(552);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1116:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(553);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1117:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(550);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1118:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(559);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1119:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(554);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1120:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(547);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1121:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(565);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1122:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(563);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1123:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(1162);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1124:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(305);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1125:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(331);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1126:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(1164);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1127:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(311);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1128:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(339);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1129:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(322);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1130:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(323);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1131:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(316);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1132:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(1258);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1133:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(980);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1134:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(324);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1135:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(318);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1136:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(983);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1137:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(374);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1138:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(1337);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1139:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(1009);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1140:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(1012);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1141:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(1014);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1142:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(1016);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1143:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(1018);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1144:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(430);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1145:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(1262);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1146:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'r') ADVANCE(1263);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1147:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 's') ADVANCE(1493);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1148:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 's') ADVANCE(1492);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1149:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 's') ADVANCE(1348);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1150:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 's') ADVANCE(1355);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1151:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 's') ADVANCE(1048);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1152:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 's') ADVANCE(476);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1153:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 's') ADVANCE(385);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1154:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 's') ADVANCE(1168);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1155:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 's') ADVANCE(386);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1156:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 's') ADVANCE(1149);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1157:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 's') ADVANCE(387);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1158:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 's') ADVANCE(396);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1159:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 's') ADVANCE(996);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1160:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 's') ADVANCE(1183);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1161:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 's') ADVANCE(557);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1162:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 's') ADVANCE(1184);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1163:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 's') ADVANCE(561);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1164:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 's') ADVANCE(1187);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1165:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 's') ADVANCE(566);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1166:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 's') ADVANCE(1192);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1167:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 's') ADVANCE(488);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1168:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 's') ADVANCE(306);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1169:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 's') ADVANCE(604);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1170:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(666);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1171:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(1464);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1172:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(1465);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1173:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(1594);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1174:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(1351);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1175:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(1478);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1176:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(1360);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1177:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(1502);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1178:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(1501);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1179:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(57);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1180:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(1500);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1181:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(1541);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1182:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(1540);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1183:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(1505);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1184:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(1504);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1185:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(1539);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1186:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(1390);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1187:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(1503);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1188:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(1595);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1189:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(1361);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1190:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(259);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1191:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(1396);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1192:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(260);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1193:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(1577);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1194:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(1359);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1195:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(1576);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1196:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(1358);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1197:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(1587);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1198:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(1485);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1199:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(1486);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1200:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(1487);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1201:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(1488);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1202:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(1490);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1203:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(1489);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1204:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(415);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1205:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(1010);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1206:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(663);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1207:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(802);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1208:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(705);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1209:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(477);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1210:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(692);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1211:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(478);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1212:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(693);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1213:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(1083);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1214:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(383);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1215:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(564);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1216:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(481);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1217:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(1090);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1218:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(486);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1219:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(491);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1220:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(492);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1221:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(493);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1222:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(494);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1223:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(495);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1224:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(496);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1225:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(497);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1226:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(498);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1227:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(499);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1228:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(500);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1229:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(501);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1230:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(502);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1231:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(503);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1232:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(504);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1233:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(505);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1234:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(506);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1235:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(507);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1236:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(508);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1237:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(509);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1238:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(511);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1239:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(512);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1240:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(513);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1241:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(516);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1242:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(517);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1243:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(518);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1244:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(519);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1245:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(520);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1246:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(521);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1247:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(523);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1248:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(569);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1249:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(595);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1250:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(671);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1251:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(805);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1252:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(994);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1253:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(399);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1254:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(707);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1255:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(672);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1256:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(710);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1257:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(715);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1258:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(584);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1259:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(674);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1260:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(1138);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1261:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(411);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1262:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(424);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1263:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(429);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1264:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(261);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1265:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(264);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1266:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(262);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1267:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(265);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1268:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(597);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1269:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(263);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1270:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(266);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1271:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(598);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1272:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(267);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1273:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(599);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1274:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'u') ADVANCE(703);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1275:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'u') ADVANCE(1174);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1276:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'u') ADVANCE(796);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1277:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'u') ADVANCE(1250);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1278:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'u') ADVANCE(1096);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1279:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'u') ADVANCE(1194);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1280:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'u') ADVANCE(1196);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1281:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'u') ADVANCE(849);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1282:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'u') ADVANCE(464);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1283:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'u') ADVANCE(797);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1284:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'u') ADVANCE(465);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1285:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'u') ADVANCE(799);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1286:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'u') ADVANCE(466);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1287:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'u') ADVANCE(1166);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1288:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'u') ADVANCE(803);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1289:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'u') ADVANCE(809);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1290:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'u') ADVANCE(1129);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1291:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'u') ADVANCE(1130);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1292:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'u') ADVANCE(1134);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1293:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'u') ADVANCE(868);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1294:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'u') ADVANCE(874);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1295:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'u') ADVANCE(887);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1296:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'u') ADVANCE(888);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1297:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'u') ADVANCE(889);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1298:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'u') ADVANCE(832);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1299:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'u') ADVANCE(890);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1300:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'u') ADVANCE(891);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1301:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'u') ADVANCE(892);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1302:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'v') ADVANCE(688);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1303:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'v') ADVANCE(647);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1304:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'v') ADVANCE(740);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1305:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'v') ADVANCE(743);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1306:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'v') ADVANCE(744);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1307:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'v') ADVANCE(745);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1308:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'v') ADVANCE(746);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1309:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'v') ADVANCE(747);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1310:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'v') ADVANCE(1038);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1311:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'w') ADVANCE(268);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1312:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'w') ADVANCE(295);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1313:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'w') ADVANCE(436);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1314:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'w') ADVANCE(270);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1315:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'x') ADVANCE(1589);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1316:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'x') ADVANCE(1060);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1317:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'x') ADVANCE(1261);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1318:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'x') ADVANCE(1173);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1319:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'x') ADVANCE(1177);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1320:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'x') ADVANCE(1178);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1321:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'x') ADVANCE(1180);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1322:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'x') ADVANCE(1186);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1323:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'x') ADVANCE(1188);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1324:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'x') ADVANCE(1191);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1325:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'x') ADVANCE(1214);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1326:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'x') ADVANCE(1065);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1327:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'x') ADVANCE(1066);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1328:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'x') ADVANCE(1067);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1329:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'y') ADVANCE(1354);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1330:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'y') ADVANCE(1592);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1331:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'y') ADVANCE(1593);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1332:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'y') ADVANCE(1491);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1333:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'y') ADVANCE(846);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1334:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'y') ADVANCE(840);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1335:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'y') ADVANCE(593);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1336:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'y') ADVANCE(640);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1337:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'y') ADVANCE(641);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1338:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'y') ADVANCE(866);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1339:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'z') ADVANCE(818);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'y')) ADVANCE(1340);
      END_STATE();
    case 1340:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1341:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == 'A') ADVANCE(257);
      if (lookahead == 'C') ADVANCE(685);
      if (lookahead == 'D') ADVANCE(470);
      if (lookahead == 'G') ADVANCE(278);
      if (lookahead == 'N') ADVANCE(471);
      if (lookahead == 'P') ADVANCE(283);
      if (lookahead == 'R') ADVANCE(528);
      if (lookahead == 'S') ADVANCE(836);
      if (lookahead == 'T') ADVANCE(472);
      if (lookahead == 'V') ADVANCE(531);
      if (lookahead == 'a') ADVANCE(382);
      if (lookahead == 'b') ADVANCE(694);
      if (lookahead == 'c') ADVANCE(285);
      if (lookahead == 'd') ADVANCE(473);
      if (lookahead == 'e') ADVANCE(1068);
      if (lookahead == 'f') ADVANCE(680);
      if (lookahead == 'g') ADVANCE(786);
      if (lookahead == 'i') ADVANCE(617);
      if (lookahead == 'l') ADVANCE(287);
      if (lookahead == 'n') ADVANCE(288);
      if (lookahead == 'p') ADVANCE(290);
      if (lookahead == 'r') ADVANCE(475);
      if (lookahead == 's') ADVANCE(893);
      if (lookahead == 't') ADVANCE(588);
      if (lookahead == 'u') ADVANCE(1152);
      if (lookahead == 'v') ADVANCE(600);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(228);
      END_STATE();
    case 1342:
      ACCEPT_TOKEN(sym_command_name);
      if (lookahead == 'A') ADVANCE(257);
      if (lookahead == 'C') ADVANCE(685);
      if (lookahead == 'D') ADVANCE(470);
      if (lookahead == 'G') ADVANCE(278);
      if (lookahead == 'N') ADVANCE(471);
      if (lookahead == 'P') ADVANCE(283);
      if (lookahead == 'R') ADVANCE(528);
      if (lookahead == 'S') ADVANCE(836);
      if (lookahead == 'T') ADVANCE(472);
      if (lookahead == 'V') ADVANCE(531);
      if (lookahead == 'a') ADVANCE(382);
      if (lookahead == 'b') ADVANCE(694);
      if (lookahead == 'c') ADVANCE(285);
      if (lookahead == 'd') ADVANCE(473);
      if (lookahead == 'e') ADVANCE(1068);
      if (lookahead == 'f') ADVANCE(960);
      if (lookahead == 'g') ADVANCE(786);
      if (lookahead == 'i') ADVANCE(617);
      if (lookahead == 'l') ADVANCE(287);
      if (lookahead == 'n') ADVANCE(288);
      if (lookahead == 'p') ADVANCE(290);
      if (lookahead == 'r') ADVANCE(475);
      if (lookahead == 's') ADVANCE(893);
      if (lookahead == 't') ADVANCE(588);
      if (lookahead == 'u') ADVANCE(1152);
      if (lookahead == 'v') ADVANCE(600);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('h' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(228);
      END_STATE();
    case 1343:
      ACCEPT_TOKEN(sym_command_name);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(228);
      END_STATE();
    case 1344:
      ACCEPT_TOKEN(anon_sym_BSLASHtitle);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1345:
      ACCEPT_TOKEN(anon_sym_BSLASHauthor);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1346:
      ACCEPT_TOKEN(anon_sym_BSLASHusepackage);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1347:
      ACCEPT_TOKEN(anon_sym_BSLASHRequirePackage);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1348:
      ACCEPT_TOKEN(anon_sym_BSLASHdocumentclass);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1349:
      ACCEPT_TOKEN(anon_sym_BSLASHinclude);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'f') ADVANCE(1101);
      if (lookahead == 'g') ADVANCE(1125);
      if (lookahead == 'i') ADVANCE(902);
      if (lookahead == 's') ADVANCE(1303);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1350:
      ACCEPT_TOKEN(anon_sym_BSLASHsubfileinclude);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1351:
      ACCEPT_TOKEN(anon_sym_BSLASHinput);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'f') ADVANCE(1098);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1352:
      ACCEPT_TOKEN(anon_sym_BSLASHsubfile);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(944);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1353:
      ACCEPT_TOKEN(anon_sym_BSLASHaddbibresource);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1354:
      ACCEPT_TOKEN(anon_sym_BSLASHbibliography);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1355:
      ACCEPT_TOKEN(anon_sym_BSLASHincludegraphics);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1356:
      ACCEPT_TOKEN(anon_sym_BSLASHincludesvg);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1357:
      ACCEPT_TOKEN(anon_sym_BSLASHincludeinkscape);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1358:
      ACCEPT_TOKEN(anon_sym_BSLASHverbatiminput);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1359:
      ACCEPT_TOKEN(anon_sym_BSLASHVerbatimInput);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1360:
      ACCEPT_TOKEN(anon_sym_BSLASHimport);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1361:
      ACCEPT_TOKEN(anon_sym_BSLASHsubimport);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'f') ADVANCE(1104);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1362:
      ACCEPT_TOKEN(anon_sym_BSLASHinputfrom);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1363:
      ACCEPT_TOKEN(anon_sym_BSLASHsubimportfrom);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1364:
      ACCEPT_TOKEN(anon_sym_BSLASHincludefrom);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1365:
      ACCEPT_TOKEN(anon_sym_BSLASHsubincludefrom);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1366:
      ACCEPT_TOKEN(anon_sym_BSLASHcaption);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1367:
      ACCEPT_TOKEN(anon_sym_BSLASHcite);
      if (lookahead == '*') ADVANCE(1368);
      if (lookahead == 'a') ADVANCE(785);
      if (lookahead == 'd') ADVANCE(346);
      if (lookahead == 'p') ADVANCE(1372);
      if (lookahead == 't') ADVANCE(1371);
      if (lookahead == 'u') ADVANCE(1099);
      if (lookahead == 'y') ADVANCE(574);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1368:
      ACCEPT_TOKEN(anon_sym_BSLASHcite_STAR);
      END_STATE();
    case 1369:
      ACCEPT_TOKEN(anon_sym_BSLASHCite);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'a') ADVANCE(1277);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1370:
      ACCEPT_TOKEN(anon_sym_BSLASHnocite);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1371:
      ACCEPT_TOKEN(anon_sym_BSLASHcitet);
      if (lookahead == '*') ADVANCE(1373);
      if (lookahead == 'e') ADVANCE(1322);
      if (lookahead == 'i') ADVANCE(1251);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1372:
      ACCEPT_TOKEN(anon_sym_BSLASHcitep);
      if (lookahead == '*') ADVANCE(1374);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1373:
      ACCEPT_TOKEN(anon_sym_BSLASHcitet_STAR);
      END_STATE();
    case 1374:
      ACCEPT_TOKEN(anon_sym_BSLASHcitep_STAR);
      END_STATE();
    case 1375:
      ACCEPT_TOKEN(anon_sym_BSLASHciteauthor);
      if (lookahead == '*') ADVANCE(1376);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1376:
      ACCEPT_TOKEN(anon_sym_BSLASHciteauthor_STAR);
      END_STATE();
    case 1377:
      ACCEPT_TOKEN(anon_sym_BSLASHCiteauthor);
      if (lookahead == '*') ADVANCE(1378);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1378:
      ACCEPT_TOKEN(anon_sym_BSLASHCiteauthor_STAR);
      END_STATE();
    case 1379:
      ACCEPT_TOKEN(anon_sym_BSLASHcitetitle);
      if (lookahead == '*') ADVANCE(1380);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1380:
      ACCEPT_TOKEN(anon_sym_BSLASHcitetitle_STAR);
      END_STATE();
    case 1381:
      ACCEPT_TOKEN(anon_sym_BSLASHciteyear);
      if (lookahead == '*') ADVANCE(1382);
      if (lookahead == 'p') ADVANCE(308);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1382:
      ACCEPT_TOKEN(anon_sym_BSLASHciteyear_STAR);
      END_STATE();
    case 1383:
      ACCEPT_TOKEN(anon_sym_BSLASHcitedate);
      if (lookahead == '*') ADVANCE(1384);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1384:
      ACCEPT_TOKEN(anon_sym_BSLASHcitedate_STAR);
      END_STATE();
    case 1385:
      ACCEPT_TOKEN(anon_sym_BSLASHciteurl);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1386:
      ACCEPT_TOKEN(anon_sym_BSLASHfullcite);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1387:
      ACCEPT_TOKEN(anon_sym_BSLASHciteyearpar);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1388:
      ACCEPT_TOKEN(anon_sym_BSLASHcitealt);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1389:
      ACCEPT_TOKEN(anon_sym_BSLASHcitealp);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1390:
      ACCEPT_TOKEN(anon_sym_BSLASHcitetext);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1391:
      ACCEPT_TOKEN(anon_sym_BSLASHparencite);
      if (lookahead == '*') ADVANCE(1392);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1392:
      ACCEPT_TOKEN(anon_sym_BSLASHparencite_STAR);
      END_STATE();
    case 1393:
      ACCEPT_TOKEN(anon_sym_BSLASHParencite);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1394:
      ACCEPT_TOKEN(anon_sym_BSLASHfootcite);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 't') ADVANCE(586);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1395:
      ACCEPT_TOKEN(anon_sym_BSLASHfootfullcite);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1396:
      ACCEPT_TOKEN(anon_sym_BSLASHfootcitetext);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1397:
      ACCEPT_TOKEN(anon_sym_BSLASHtextcite);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1398:
      ACCEPT_TOKEN(anon_sym_BSLASHTextcite);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1399:
      ACCEPT_TOKEN(anon_sym_BSLASHsmartcite);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1400:
      ACCEPT_TOKEN(anon_sym_BSLASHSmartcite);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1401:
      ACCEPT_TOKEN(anon_sym_BSLASHsupercite);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1402:
      ACCEPT_TOKEN(anon_sym_BSLASHautocite);
      if (lookahead == '*') ADVANCE(1404);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1403:
      ACCEPT_TOKEN(anon_sym_BSLASHAutocite);
      if (lookahead == '*') ADVANCE(1405);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1404:
      ACCEPT_TOKEN(anon_sym_BSLASHautocite_STAR);
      END_STATE();
    case 1405:
      ACCEPT_TOKEN(anon_sym_BSLASHAutocite_STAR);
      END_STATE();
    case 1406:
      ACCEPT_TOKEN(anon_sym_BSLASHvolcite);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1407:
      ACCEPT_TOKEN(anon_sym_BSLASHVolcite);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1408:
      ACCEPT_TOKEN(anon_sym_BSLASHpvolcite);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1409:
      ACCEPT_TOKEN(anon_sym_BSLASHPvolcite);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1410:
      ACCEPT_TOKEN(anon_sym_BSLASHfvolcite);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1411:
      ACCEPT_TOKEN(anon_sym_BSLASHftvolcite);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1412:
      ACCEPT_TOKEN(anon_sym_BSLASHsvolcite);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1413:
      ACCEPT_TOKEN(anon_sym_BSLASHSvolcite);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1414:
      ACCEPT_TOKEN(anon_sym_BSLASHtvolcite);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1415:
      ACCEPT_TOKEN(anon_sym_BSLASHTvolcite);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1416:
      ACCEPT_TOKEN(anon_sym_BSLASHavolcite);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1417:
      ACCEPT_TOKEN(anon_sym_BSLASHAvolcite);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1418:
      ACCEPT_TOKEN(anon_sym_BSLASHnotecite);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1419:
      ACCEPT_TOKEN(anon_sym_BSLASHNotecite);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1420:
      ACCEPT_TOKEN(anon_sym_BSLASHpnotecite);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1421:
      ACCEPT_TOKEN(anon_sym_BSLASHPnotecite);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1422:
      ACCEPT_TOKEN(anon_sym_BSLASHfnotecite);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1423:
      ACCEPT_TOKEN(anon_sym_BSLASHlabel);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'c') ADVANCE(1055);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1424:
      ACCEPT_TOKEN(anon_sym_BSLASHref);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1425:
      ACCEPT_TOKEN(anon_sym_BSLASHeqref);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1426:
      ACCEPT_TOKEN(anon_sym_BSLASHvref);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1427:
      ACCEPT_TOKEN(anon_sym_BSLASHVref);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1428:
      ACCEPT_TOKEN(anon_sym_BSLASHautoref);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1429:
      ACCEPT_TOKEN(anon_sym_BSLASHpageref);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1430:
      ACCEPT_TOKEN(anon_sym_BSLASHcref);
      if (lookahead == '*') ADVANCE(1432);
      if (lookahead == 'r') ADVANCE(334);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1431:
      ACCEPT_TOKEN(anon_sym_BSLASHCref);
      if (lookahead == '*') ADVANCE(1433);
      if (lookahead == 'r') ADVANCE(300);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1432:
      ACCEPT_TOKEN(anon_sym_BSLASHcref_STAR);
      END_STATE();
    case 1433:
      ACCEPT_TOKEN(anon_sym_BSLASHCref_STAR);
      END_STATE();
    case 1434:
      ACCEPT_TOKEN(anon_sym_BSLASHnamecref);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 's') ADVANCE(1437);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1435:
      ACCEPT_TOKEN(anon_sym_BSLASHnameCref);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 's') ADVANCE(1438);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1436:
      ACCEPT_TOKEN(anon_sym_BSLASHlcnamecref);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 's') ADVANCE(1439);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1437:
      ACCEPT_TOKEN(anon_sym_BSLASHnamecrefs);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1438:
      ACCEPT_TOKEN(anon_sym_BSLASHnameCrefs);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1439:
      ACCEPT_TOKEN(anon_sym_BSLASHlcnamecrefs);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1440:
      ACCEPT_TOKEN(anon_sym_BSLASHlabelcref);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1441:
      ACCEPT_TOKEN(anon_sym_BSLASHlabelcpageref);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1442:
      ACCEPT_TOKEN(anon_sym_BSLASHcrefrange);
      if (lookahead == '*') ADVANCE(1443);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1443:
      ACCEPT_TOKEN(anon_sym_BSLASHcrefrange_STAR);
      END_STATE();
    case 1444:
      ACCEPT_TOKEN(anon_sym_BSLASHCrefrange);
      if (lookahead == '*') ADVANCE(1445);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1445:
      ACCEPT_TOKEN(anon_sym_BSLASHCrefrange_STAR);
      END_STATE();
    case 1446:
      ACCEPT_TOKEN(anon_sym_BSLASHnewlabel);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1447:
      ACCEPT_TOKEN(anon_sym_BSLASHnewcommand);
      if (lookahead == '*') ADVANCE(1448);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1448:
      ACCEPT_TOKEN(anon_sym_BSLASHnewcommand_STAR);
      END_STATE();
    case 1449:
      ACCEPT_TOKEN(anon_sym_BSLASHrenewcommand);
      if (lookahead == '*') ADVANCE(1450);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1450:
      ACCEPT_TOKEN(anon_sym_BSLASHrenewcommand_STAR);
      END_STATE();
    case 1451:
      ACCEPT_TOKEN(anon_sym_BSLASHDeclareRobustCommand);
      if (lookahead == '*') ADVANCE(1452);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1452:
      ACCEPT_TOKEN(anon_sym_BSLASHDeclareRobustCommand_STAR);
      END_STATE();
    case 1453:
      ACCEPT_TOKEN(anon_sym_BSLASHDeclareMathOperator);
      if (lookahead == '*') ADVANCE(1454);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1454:
      ACCEPT_TOKEN(anon_sym_BSLASHDeclareMathOperator_STAR);
      END_STATE();
    case 1455:
      ACCEPT_TOKEN(anon_sym_BSLASHNewDocumentCommand);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1456:
      ACCEPT_TOKEN(anon_sym_BSLASHRenewDocumentCommand);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1457:
      ACCEPT_TOKEN(anon_sym_BSLASHProvideDocumentCommand);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1458:
      ACCEPT_TOKEN(anon_sym_BSLASHDeclareDocumentCommand);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1459:
      ACCEPT_TOKEN(anon_sym_BSLASHNewExpandableDocumentCommand);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1460:
      ACCEPT_TOKEN(anon_sym_BSLASHRenewExpandableDocumentCommand);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1461:
      ACCEPT_TOKEN(anon_sym_BSLASHProvideExpandableDocumentCommand);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1462:
      ACCEPT_TOKEN(anon_sym_BSLASHDeclareExpandableDocumentCommand);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1463:
      ACCEPT_TOKEN(anon_sym_BSLASHdef);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(936);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1464:
      ACCEPT_TOKEN(anon_sym_BSLASHlet);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1465:
      ACCEPT_TOKEN(anon_sym_BSLASHleft);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1466:
      ACCEPT_TOKEN(anon_sym_BSLASHbig);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'g') ADVANCE(1470);
      if (lookahead == 'l') ADVANCE(1474);
      if (lookahead == 'r') ADVANCE(1479);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1467:
      ACCEPT_TOKEN(anon_sym_BSLASHbig);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'g') ADVANCE(1471);
      if (lookahead == 'l') ADVANCE(1474);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1468:
      ACCEPT_TOKEN(anon_sym_BSLASHBig);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'g') ADVANCE(1472);
      if (lookahead == 'l') ADVANCE(1475);
      if (lookahead == 'r') ADVANCE(1480);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1469:
      ACCEPT_TOKEN(anon_sym_BSLASHBig);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'g') ADVANCE(1473);
      if (lookahead == 'l') ADVANCE(1475);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1470:
      ACCEPT_TOKEN(anon_sym_BSLASHbigg);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(1476);
      if (lookahead == 'r') ADVANCE(1481);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1471:
      ACCEPT_TOKEN(anon_sym_BSLASHbigg);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(1476);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1472:
      ACCEPT_TOKEN(anon_sym_BSLASHBigg);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(1477);
      if (lookahead == 'r') ADVANCE(1482);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1473:
      ACCEPT_TOKEN(anon_sym_BSLASHBigg);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'l') ADVANCE(1477);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1474:
      ACCEPT_TOKEN(anon_sym_BSLASHbigl);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1475:
      ACCEPT_TOKEN(anon_sym_BSLASHBigl);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1476:
      ACCEPT_TOKEN(anon_sym_BSLASHbiggl);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1477:
      ACCEPT_TOKEN(anon_sym_BSLASHBiggl);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1478:
      ACCEPT_TOKEN(anon_sym_BSLASHright);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1479:
      ACCEPT_TOKEN(anon_sym_BSLASHbigr);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1480:
      ACCEPT_TOKEN(anon_sym_BSLASHBigr);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1481:
      ACCEPT_TOKEN(anon_sym_BSLASHbiggr);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1482:
      ACCEPT_TOKEN(anon_sym_BSLASHBiggr);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1483:
      ACCEPT_TOKEN(anon_sym_BSLASHDeclarePairedDelimiter);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'X') ADVANCE(1484);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1484:
      ACCEPT_TOKEN(anon_sym_BSLASHDeclarePairedDelimiterX);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1485:
      ACCEPT_TOKEN(anon_sym_BSLASHnewenvironment);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1486:
      ACCEPT_TOKEN(anon_sym_BSLASHrenewenvironment);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1487:
      ACCEPT_TOKEN(anon_sym_BSLASHNewDocumentEnvironment);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1488:
      ACCEPT_TOKEN(anon_sym_BSLASHRenewDocumentEnvironment);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1489:
      ACCEPT_TOKEN(anon_sym_BSLASHProvideDocumentEnvironment);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1490:
      ACCEPT_TOKEN(anon_sym_BSLASHDeclareDocumentEnvironment);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1491:
      ACCEPT_TOKEN(anon_sym_BSLASHnewglossaryentry);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1492:
      ACCEPT_TOKEN(anon_sym_BSLASHgls);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'd') ADVANCE(577);
      if (lookahead == 'e') ADVANCE(947);
      if (lookahead == 'f') ADVANCE(702);
      if (lookahead == 'l') ADVANCE(695);
      if (lookahead == 'n') ADVANCE(344);
      if (lookahead == 'p') ADVANCE(755);
      if (lookahead == 's') ADVANCE(1338);
      if (lookahead == 't') ADVANCE(581);
      if (lookahead == 'u') ADVANCE(1165);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1493:
      ACCEPT_TOKEN(anon_sym_BSLASHGls);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'd') ADVANCE(573);
      if (lookahead == 'e') ADVANCE(918);
      if (lookahead == 'f') ADVANCE(700);
      if (lookahead == 'n') ADVANCE(341);
      if (lookahead == 'p') ADVANCE(754);
      if (lookahead == 's') ADVANCE(1333);
      if (lookahead == 't') ADVANCE(579);
      if (lookahead == 'u') ADVANCE(1163);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1494:
      ACCEPT_TOKEN(anon_sym_BSLASHGLS);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'd') ADVANCE(540);
      if (lookahead == 'f') ADVANCE(691);
      if (lookahead == 'n') ADVANCE(336);
      if (lookahead == 'p') ADVANCE(753);
      if (lookahead == 't') ADVANCE(575);
      if (lookahead == 'u') ADVANCE(1161);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1495:
      ACCEPT_TOKEN(anon_sym_BSLASHglspl);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'u') ADVANCE(1127);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1496:
      ACCEPT_TOKEN(anon_sym_BSLASHGlspl);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'u') ADVANCE(1124);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1497:
      ACCEPT_TOKEN(anon_sym_BSLASHGLSpl);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'u') ADVANCE(1097);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1498:
      ACCEPT_TOKEN(anon_sym_BSLASHglsdisp);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1499:
      ACCEPT_TOKEN(anon_sym_BSLASHglslink);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1500:
      ACCEPT_TOKEN(anon_sym_BSLASHglstext);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1501:
      ACCEPT_TOKEN(anon_sym_BSLASHGlstext);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1502:
      ACCEPT_TOKEN(anon_sym_BSLASHGLStext);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1503:
      ACCEPT_TOKEN(anon_sym_BSLASHglsfirst);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'p') ADVANCE(816);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1504:
      ACCEPT_TOKEN(anon_sym_BSLASHGlsfirst);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'p') ADVANCE(814);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1505:
      ACCEPT_TOKEN(anon_sym_BSLASHGLSfirst);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'p') ADVANCE(792);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1506:
      ACCEPT_TOKEN(anon_sym_BSLASHglsplural);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1507:
      ACCEPT_TOKEN(anon_sym_BSLASHGlsplural);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1508:
      ACCEPT_TOKEN(anon_sym_BSLASHGLSplural);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1509:
      ACCEPT_TOKEN(anon_sym_BSLASHglsfirstplural);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1510:
      ACCEPT_TOKEN(anon_sym_BSLASHGlsfirstplural);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1511:
      ACCEPT_TOKEN(anon_sym_BSLASHGLSfirstplural);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1512:
      ACCEPT_TOKEN(anon_sym_BSLASHglsname);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1513:
      ACCEPT_TOKEN(anon_sym_BSLASHGlsname);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1514:
      ACCEPT_TOKEN(anon_sym_BSLASHGLSname);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1515:
      ACCEPT_TOKEN(anon_sym_BSLASHglssymbol);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1516:
      ACCEPT_TOKEN(anon_sym_BSLASHGlssymbol);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1517:
      ACCEPT_TOKEN(anon_sym_BSLASHglsdesc);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1518:
      ACCEPT_TOKEN(anon_sym_BSLASHGlsdesc);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1519:
      ACCEPT_TOKEN(anon_sym_BSLASHGLSdesc);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1520:
      ACCEPT_TOKEN(anon_sym_BSLASHglsuseri);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(1523);
      if (lookahead == 'v') ADVANCE(1529);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1521:
      ACCEPT_TOKEN(anon_sym_BSLASHGlsuseri);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(1524);
      if (lookahead == 'v') ADVANCE(1530);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1522:
      ACCEPT_TOKEN(anon_sym_BSLASHGLSuseri);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(1525);
      if (lookahead == 'v') ADVANCE(1531);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1523:
      ACCEPT_TOKEN(anon_sym_BSLASHglsuserii);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(1526);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1524:
      ACCEPT_TOKEN(anon_sym_BSLASHGlsuserii);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(1527);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1525:
      ACCEPT_TOKEN(anon_sym_BSLASHGLSuserii);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(1528);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1526:
      ACCEPT_TOKEN(anon_sym_BSLASHglsuseriii);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1527:
      ACCEPT_TOKEN(anon_sym_BSLASHGlsuseriii);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1528:
      ACCEPT_TOKEN(anon_sym_BSLASHGLSuseriii);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1529:
      ACCEPT_TOKEN(anon_sym_BSLASHglsuseriv);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1530:
      ACCEPT_TOKEN(anon_sym_BSLASHGlsuseriv);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1531:
      ACCEPT_TOKEN(anon_sym_BSLASHGLSuseriv);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1532:
      ACCEPT_TOKEN(anon_sym_BSLASHglsuserv);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(1535);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1533:
      ACCEPT_TOKEN(anon_sym_BSLASHGlsuserv);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(1536);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1534:
      ACCEPT_TOKEN(anon_sym_BSLASHGLSuserv);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'i') ADVANCE(1537);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1535:
      ACCEPT_TOKEN(anon_sym_BSLASHglsuservi);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1536:
      ACCEPT_TOKEN(anon_sym_BSLASHGlsuservi);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1537:
      ACCEPT_TOKEN(anon_sym_BSLASHGLSuservi);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1538:
      ACCEPT_TOKEN(anon_sym_BSLASHnewacronym);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1539:
      ACCEPT_TOKEN(anon_sym_BSLASHacrshort);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'p') ADVANCE(775);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1540:
      ACCEPT_TOKEN(anon_sym_BSLASHAcrshort);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'p') ADVANCE(774);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1541:
      ACCEPT_TOKEN(anon_sym_BSLASHACRshort);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'p') ADVANCE(773);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1542:
      ACCEPT_TOKEN(anon_sym_BSLASHacrshortpl);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1543:
      ACCEPT_TOKEN(anon_sym_BSLASHAcrshortpl);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1544:
      ACCEPT_TOKEN(anon_sym_BSLASHACRshortpl);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1545:
      ACCEPT_TOKEN(anon_sym_BSLASHacrlong);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'p') ADVANCE(770);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1546:
      ACCEPT_TOKEN(anon_sym_BSLASHAcrlong);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'p') ADVANCE(765);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1547:
      ACCEPT_TOKEN(anon_sym_BSLASHACRlong);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'p') ADVANCE(763);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1548:
      ACCEPT_TOKEN(anon_sym_BSLASHacrlongpl);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1549:
      ACCEPT_TOKEN(anon_sym_BSLASHAcrlongpl);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1550:
      ACCEPT_TOKEN(anon_sym_BSLASHACRlongpl);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1551:
      ACCEPT_TOKEN(anon_sym_BSLASHacrfull);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'p') ADVANCE(769);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1552:
      ACCEPT_TOKEN(anon_sym_BSLASHAcrfull);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'p') ADVANCE(764);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1553:
      ACCEPT_TOKEN(anon_sym_BSLASHACRfull);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'p') ADVANCE(762);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1554:
      ACCEPT_TOKEN(anon_sym_BSLASHacrfullpl);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1555:
      ACCEPT_TOKEN(anon_sym_BSLASHAcrfullpl);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1556:
      ACCEPT_TOKEN(anon_sym_BSLASHACRfullpl);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1557:
      ACCEPT_TOKEN(anon_sym_BSLASHacs);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'p') ADVANCE(1559);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1558:
      ACCEPT_TOKEN(anon_sym_BSLASHAcs);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'p') ADVANCE(1560);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1559:
      ACCEPT_TOKEN(anon_sym_BSLASHacsp);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1560:
      ACCEPT_TOKEN(anon_sym_BSLASHAcsp);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1561:
      ACCEPT_TOKEN(anon_sym_BSLASHacl);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'p') ADVANCE(1563);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1562:
      ACCEPT_TOKEN(anon_sym_BSLASHAcl);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'p') ADVANCE(1564);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1563:
      ACCEPT_TOKEN(anon_sym_BSLASHaclp);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1564:
      ACCEPT_TOKEN(anon_sym_BSLASHAclp);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1565:
      ACCEPT_TOKEN(anon_sym_BSLASHacf);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'p') ADVANCE(1567);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1566:
      ACCEPT_TOKEN(anon_sym_BSLASHAcf);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'p') ADVANCE(1568);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1567:
      ACCEPT_TOKEN(anon_sym_BSLASHacfp);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1568:
      ACCEPT_TOKEN(anon_sym_BSLASHAcfp);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1569:
      ACCEPT_TOKEN(anon_sym_BSLASHac);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'f') ADVANCE(1565);
      if (lookahead == 'l') ADVANCE(1561);
      if (lookahead == 'p') ADVANCE(1571);
      if (lookahead == 'r') ADVANCE(639);
      if (lookahead == 's') ADVANCE(1557);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1570:
      ACCEPT_TOKEN(anon_sym_BSLASHAc);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'f') ADVANCE(1566);
      if (lookahead == 'l') ADVANCE(1562);
      if (lookahead == 'r') ADVANCE(638);
      if (lookahead == 's') ADVANCE(1558);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1571:
      ACCEPT_TOKEN(anon_sym_BSLASHacp);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1572:
      ACCEPT_TOKEN(anon_sym_BSLASHglsentrylong);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'p') ADVANCE(781);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1573:
      ACCEPT_TOKEN(anon_sym_BSLASHGlsentrylong);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'p') ADVANCE(778);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1574:
      ACCEPT_TOKEN(anon_sym_BSLASHglsentrylongpl);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1575:
      ACCEPT_TOKEN(anon_sym_BSLASHGlsentrylongpl);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1576:
      ACCEPT_TOKEN(anon_sym_BSLASHglsentryshort);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'p') ADVANCE(784);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1577:
      ACCEPT_TOKEN(anon_sym_BSLASHGlsentryshort);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'p') ADVANCE(783);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1578:
      ACCEPT_TOKEN(anon_sym_BSLASHglsentryshortpl);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1579:
      ACCEPT_TOKEN(anon_sym_BSLASHGlsentryshortpl);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1580:
      ACCEPT_TOKEN(anon_sym_BSLASHglsentryfullpl);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1581:
      ACCEPT_TOKEN(anon_sym_BSLASHGlsentryfullpl);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1582:
      ACCEPT_TOKEN(anon_sym_BSLASHnewtheorem);
      if (lookahead == '*') ADVANCE(1583);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1583:
      ACCEPT_TOKEN(anon_sym_BSLASHnewtheorem_STAR);
      END_STATE();
    case 1584:
      ACCEPT_TOKEN(anon_sym_BSLASHdeclaretheorem);
      if (lookahead == '*') ADVANCE(1585);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1585:
      ACCEPT_TOKEN(anon_sym_BSLASHdeclaretheorem_STAR);
      END_STATE();
    case 1586:
      ACCEPT_TOKEN(anon_sym_BSLASHdefinecolor);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 's') ADVANCE(570);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1587:
      ACCEPT_TOKEN(anon_sym_BSLASHdefinecolorset);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1588:
      ACCEPT_TOKEN(anon_sym_BSLASHcolor);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'b') ADVANCE(965);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1589:
      ACCEPT_TOKEN(anon_sym_BSLASHcolorbox);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1590:
      ACCEPT_TOKEN(anon_sym_BSLASHtextcolor);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1591:
      ACCEPT_TOKEN(anon_sym_BSLASHpagecolor);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1592:
      ACCEPT_TOKEN(anon_sym_BSLASHusepgflibrary);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1593:
      ACCEPT_TOKEN(anon_sym_BSLASHusetikzlibrary);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1594:
      ACCEPT_TOKEN(anon_sym_BSLASHtext);
      if (lookahead == '*') ADVANCE(228);
      if (lookahead == 'c') ADVANCE(727);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1595:
      ACCEPT_TOKEN(anon_sym_BSLASHintertext);
      if (lookahead == '*') ADVANCE(228);
      if (('@' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(1340);
      END_STATE();
    case 1596:
      ACCEPT_TOKEN(anon_sym_shortintertext);
      if (!sym_word_character_set_1(lookahead)) ADVANCE(178);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 35},
  [2] = {.lex_state = 4},
  [3] = {.lex_state = 36},
  [4] = {.lex_state = 36},
  [5] = {.lex_state = 4},
  [6] = {.lex_state = 7},
  [7] = {.lex_state = 1},
  [8] = {.lex_state = 2},
  [9] = {.lex_state = 7},
  [10] = {.lex_state = 1},
  [11] = {.lex_state = 1},
  [12] = {.lex_state = 7},
  [13] = {.lex_state = 1},
  [14] = {.lex_state = 36},
  [15] = {.lex_state = 7},
  [16] = {.lex_state = 2},
  [17] = {.lex_state = 2},
  [18] = {.lex_state = 36},
  [19] = {.lex_state = 36},
  [20] = {.lex_state = 2},
  [21] = {.lex_state = 36},
  [22] = {.lex_state = 36},
  [23] = {.lex_state = 36},
  [24] = {.lex_state = 36},
  [25] = {.lex_state = 36},
  [26] = {.lex_state = 36},
  [27] = {.lex_state = 36},
  [28] = {.lex_state = 36},
  [29] = {.lex_state = 36},
  [30] = {.lex_state = 36},
  [31] = {.lex_state = 36},
  [32] = {.lex_state = 36},
  [33] = {.lex_state = 36},
  [34] = {.lex_state = 36},
  [35] = {.lex_state = 36},
  [36] = {.lex_state = 36},
  [37] = {.lex_state = 36},
  [38] = {.lex_state = 36},
  [39] = {.lex_state = 36},
  [40] = {.lex_state = 36},
  [41] = {.lex_state = 36},
  [42] = {.lex_state = 36},
  [43] = {.lex_state = 36},
  [44] = {.lex_state = 36},
  [45] = {.lex_state = 36},
  [46] = {.lex_state = 36},
  [47] = {.lex_state = 36},
  [48] = {.lex_state = 36},
  [49] = {.lex_state = 36},
  [50] = {.lex_state = 36},
  [51] = {.lex_state = 6},
  [52] = {.lex_state = 5},
  [53] = {.lex_state = 6},
  [54] = {.lex_state = 38},
  [55] = {.lex_state = 37},
  [56] = {.lex_state = 5},
  [57] = {.lex_state = 38},
  [58] = {.lex_state = 37},
  [59] = {.lex_state = 10},
  [60] = {.lex_state = 10},
  [61] = {.lex_state = 38},
  [62] = {.lex_state = 10},
  [63] = {.lex_state = 10},
  [64] = {.lex_state = 37},
  [65] = {.lex_state = 10},
  [66] = {.lex_state = 35},
  [67] = {.lex_state = 10},
  [68] = {.lex_state = 10},
  [69] = {.lex_state = 10},
  [70] = {.lex_state = 10},
  [71] = {.lex_state = 37},
  [72] = {.lex_state = 38},
  [73] = {.lex_state = 10},
  [74] = {.lex_state = 10},
  [75] = {.lex_state = 8},
  [76] = {.lex_state = 9},
  [77] = {.lex_state = 3},
  [78] = {.lex_state = 3},
  [79] = {.lex_state = 10},
  [80] = {.lex_state = 9},
  [81] = {.lex_state = 37},
  [82] = {.lex_state = 8},
  [83] = {.lex_state = 38},
  [84] = {.lex_state = 9},
  [85] = {.lex_state = 38},
  [86] = {.lex_state = 8},
  [87] = {.lex_state = 37},
  [88] = {.lex_state = 8},
  [89] = {.lex_state = 3},
  [90] = {.lex_state = 3},
  [91] = {.lex_state = 10},
  [92] = {.lex_state = 9},
  [93] = {.lex_state = 10},
  [94] = {.lex_state = 38},
  [95] = {.lex_state = 35},
  [96] = {.lex_state = 35},
  [97] = {.lex_state = 38},
  [98] = {.lex_state = 37},
  [99] = {.lex_state = 37},
  [100] = {.lex_state = 38},
  [101] = {.lex_state = 38},
  [102] = {.lex_state = 35},
  [103] = {.lex_state = 10},
  [104] = {.lex_state = 37},
  [105] = {.lex_state = 38},
  [106] = {.lex_state = 37},
  [107] = {.lex_state = 37},
  [108] = {.lex_state = 38},
  [109] = {.lex_state = 38},
  [110] = {.lex_state = 35},
  [111] = {.lex_state = 37},
  [112] = {.lex_state = 38},
  [113] = {.lex_state = 35},
  [114] = {.lex_state = 38},
  [115] = {.lex_state = 35},
  [116] = {.lex_state = 37},
  [117] = {.lex_state = 38},
  [118] = {.lex_state = 37},
  [119] = {.lex_state = 37},
  [120] = {.lex_state = 35},
  [121] = {.lex_state = 38},
  [122] = {.lex_state = 38},
  [123] = {.lex_state = 37},
  [124] = {.lex_state = 37},
  [125] = {.lex_state = 38},
  [126] = {.lex_state = 38},
  [127] = {.lex_state = 38},
  [128] = {.lex_state = 37},
  [129] = {.lex_state = 37},
  [130] = {.lex_state = 38},
  [131] = {.lex_state = 38},
  [132] = {.lex_state = 35},
  [133] = {.lex_state = 35},
  [134] = {.lex_state = 35},
  [135] = {.lex_state = 37},
  [136] = {.lex_state = 37},
  [137] = {.lex_state = 38},
  [138] = {.lex_state = 37},
  [139] = {.lex_state = 35},
  [140] = {.lex_state = 38},
  [141] = {.lex_state = 38},
  [142] = {.lex_state = 37},
  [143] = {.lex_state = 35},
  [144] = {.lex_state = 37},
  [145] = {.lex_state = 38},
  [146] = {.lex_state = 35},
  [147] = {.lex_state = 35},
  [148] = {.lex_state = 38},
  [149] = {.lex_state = 37},
  [150] = {.lex_state = 37},
  [151] = {.lex_state = 38},
  [152] = {.lex_state = 37},
  [153] = {.lex_state = 37},
  [154] = {.lex_state = 38},
  [155] = {.lex_state = 35},
  [156] = {.lex_state = 38},
  [157] = {.lex_state = 37},
  [158] = {.lex_state = 38},
  [159] = {.lex_state = 35},
  [160] = {.lex_state = 37},
  [161] = {.lex_state = 35},
  [162] = {.lex_state = 37},
  [163] = {.lex_state = 38},
  [164] = {.lex_state = 37},
  [165] = {.lex_state = 37},
  [166] = {.lex_state = 37},
  [167] = {.lex_state = 38},
  [168] = {.lex_state = 35},
  [169] = {.lex_state = 35},
  [170] = {.lex_state = 37},
  [171] = {.lex_state = 38},
  [172] = {.lex_state = 35},
  [173] = {.lex_state = 35},
  [174] = {.lex_state = 36},
  [175] = {.lex_state = 36},
  [176] = {.lex_state = 35},
  [177] = {.lex_state = 36},
  [178] = {.lex_state = 35},
  [179] = {.lex_state = 36},
  [180] = {.lex_state = 37},
  [181] = {.lex_state = 37},
  [182] = {.lex_state = 10},
  [183] = {.lex_state = 10},
  [184] = {.lex_state = 38},
  [185] = {.lex_state = 38},
  [186] = {.lex_state = 35},
  [187] = {.lex_state = 36},
  [188] = {.lex_state = 35},
  [189] = {.lex_state = 36},
  [190] = {.lex_state = 10},
  [191] = {.lex_state = 37},
  [192] = {.lex_state = 38},
  [193] = {.lex_state = 38},
  [194] = {.lex_state = 37},
  [195] = {.lex_state = 10},
  [196] = {.lex_state = 36},
  [197] = {.lex_state = 35},
  [198] = {.lex_state = 36},
  [199] = {.lex_state = 35},
  [200] = {.lex_state = 38},
  [201] = {.lex_state = 10},
  [202] = {.lex_state = 37},
  [203] = {.lex_state = 37},
  [204] = {.lex_state = 10},
  [205] = {.lex_state = 38},
  [206] = {.lex_state = 35},
  [207] = {.lex_state = 36},
  [208] = {.lex_state = 36},
  [209] = {.lex_state = 35},
  [210] = {.lex_state = 10},
  [211] = {.lex_state = 38},
  [212] = {.lex_state = 37},
  [213] = {.lex_state = 10},
  [214] = {.lex_state = 37},
  [215] = {.lex_state = 38},
  [216] = {.lex_state = 36},
  [217] = {.lex_state = 35},
  [218] = {.lex_state = 36},
  [219] = {.lex_state = 35},
  [220] = {.lex_state = 37},
  [221] = {.lex_state = 38},
  [222] = {.lex_state = 10},
  [223] = {.lex_state = 37},
  [224] = {.lex_state = 38},
  [225] = {.lex_state = 10},
  [226] = {.lex_state = 35},
  [227] = {.lex_state = 35},
  [228] = {.lex_state = 36},
  [229] = {.lex_state = 36},
  [230] = {.lex_state = 10},
  [231] = {.lex_state = 37},
  [232] = {.lex_state = 38},
  [233] = {.lex_state = 38},
  [234] = {.lex_state = 37},
  [235] = {.lex_state = 10},
  [236] = {.lex_state = 36},
  [237] = {.lex_state = 35},
  [238] = {.lex_state = 36},
  [239] = {.lex_state = 35},
  [240] = {.lex_state = 36},
  [241] = {.lex_state = 37},
  [242] = {.lex_state = 37},
  [243] = {.lex_state = 10},
  [244] = {.lex_state = 38},
  [245] = {.lex_state = 10},
  [246] = {.lex_state = 38},
  [247] = {.lex_state = 35},
  [248] = {.lex_state = 35},
  [249] = {.lex_state = 35},
  [250] = {.lex_state = 37},
  [251] = {.lex_state = 10},
  [252] = {.lex_state = 38},
  [253] = {.lex_state = 38},
  [254] = {.lex_state = 10},
  [255] = {.lex_state = 38},
  [256] = {.lex_state = 10},
  [257] = {.lex_state = 37},
  [258] = {.lex_state = 37},
  [259] = {.lex_state = 36},
  [260] = {.lex_state = 36},
  [261] = {.lex_state = 13},
  [262] = {.lex_state = 13},
  [263] = {.lex_state = 13},
  [264] = {.lex_state = 13},
  [265] = {.lex_state = 13},
  [266] = {.lex_state = 13},
  [267] = {.lex_state = 13},
  [268] = {.lex_state = 13},
  [269] = {.lex_state = 13},
  [270] = {.lex_state = 13},
  [271] = {.lex_state = 13},
  [272] = {.lex_state = 13},
  [273] = {.lex_state = 13},
  [274] = {.lex_state = 13},
  [275] = {.lex_state = 13},
  [276] = {.lex_state = 14},
  [277] = {.lex_state = 14},
  [278] = {.lex_state = 35},
  [279] = {.lex_state = 14},
  [280] = {.lex_state = 14},
  [281] = {.lex_state = 14},
  [282] = {.lex_state = 14},
  [283] = {.lex_state = 14},
  [284] = {.lex_state = 35},
  [285] = {.lex_state = 37},
  [286] = {.lex_state = 38},
  [287] = {.lex_state = 10},
  [288] = {.lex_state = 37},
  [289] = {.lex_state = 10},
  [290] = {.lex_state = 38},
  [291] = {.lex_state = 15},
  [292] = {.lex_state = 15},
  [293] = {.lex_state = 15},
  [294] = {.lex_state = 25},
  [295] = {.lex_state = 15},
  [296] = {.lex_state = 15},
  [297] = {.lex_state = 15},
  [298] = {.lex_state = 15},
  [299] = {.lex_state = 15},
  [300] = {.lex_state = 15},
  [301] = {.lex_state = 15},
  [302] = {.lex_state = 15},
  [303] = {.lex_state = 15},
  [304] = {.lex_state = 15},
  [305] = {.lex_state = 15},
  [306] = {.lex_state = 15},
  [307] = {.lex_state = 15},
  [308] = {.lex_state = 15},
  [309] = {.lex_state = 15},
  [310] = {.lex_state = 15},
  [311] = {.lex_state = 15},
  [312] = {.lex_state = 15},
  [313] = {.lex_state = 15},
  [314] = {.lex_state = 15},
  [315] = {.lex_state = 15},
  [316] = {.lex_state = 15},
  [317] = {.lex_state = 15},
  [318] = {.lex_state = 15},
  [319] = {.lex_state = 15},
  [320] = {.lex_state = 21},
  [321] = {.lex_state = 21},
  [322] = {.lex_state = 21},
  [323] = {.lex_state = 21},
  [324] = {.lex_state = 21},
  [325] = {.lex_state = 21},
  [326] = {.lex_state = 21},
  [327] = {.lex_state = 21},
  [328] = {.lex_state = 21},
  [329] = {.lex_state = 15},
  [330] = {.lex_state = 21},
  [331] = {.lex_state = 21},
  [332] = {.lex_state = 21},
  [333] = {.lex_state = 15},
  [334] = {.lex_state = 15},
  [335] = {.lex_state = 15},
  [336] = {.lex_state = 15},
  [337] = {.lex_state = 15},
  [338] = {.lex_state = 15},
  [339] = {.lex_state = 15},
  [340] = {.lex_state = 15},
  [341] = {.lex_state = 15},
  [342] = {.lex_state = 15},
  [343] = {.lex_state = 15},
  [344] = {.lex_state = 13},
  [345] = {.lex_state = 13},
  [346] = {.lex_state = 15},
  [347] = {.lex_state = 14},
  [348] = {.lex_state = 15},
  [349] = {.lex_state = 14},
  [350] = {.lex_state = 21},
  [351] = {.lex_state = 21},
  [352] = {.lex_state = 36},
  [353] = {.lex_state = 36},
  [354] = {.lex_state = 36},
  [355] = {.lex_state = 36},
  [356] = {.lex_state = 36},
  [357] = {.lex_state = 36},
  [358] = {.lex_state = 36},
  [359] = {.lex_state = 36},
  [360] = {.lex_state = 36},
  [361] = {.lex_state = 36},
  [362] = {.lex_state = 36},
  [363] = {.lex_state = 36},
  [364] = {.lex_state = 36},
  [365] = {.lex_state = 36},
  [366] = {.lex_state = 36},
  [367] = {.lex_state = 36},
  [368] = {.lex_state = 36},
  [369] = {.lex_state = 36},
  [370] = {.lex_state = 36},
  [371] = {.lex_state = 36},
  [372] = {.lex_state = 36},
  [373] = {.lex_state = 36},
  [374] = {.lex_state = 36},
  [375] = {.lex_state = 36},
  [376] = {.lex_state = 36},
  [377] = {.lex_state = 36},
  [378] = {.lex_state = 36},
  [379] = {.lex_state = 36},
  [380] = {.lex_state = 36},
  [381] = {.lex_state = 36},
  [382] = {.lex_state = 36},
  [383] = {.lex_state = 36},
  [384] = {.lex_state = 36},
  [385] = {.lex_state = 36},
  [386] = {.lex_state = 36},
  [387] = {.lex_state = 36},
  [388] = {.lex_state = 36},
  [389] = {.lex_state = 36},
  [390] = {.lex_state = 36},
  [391] = {.lex_state = 36},
  [392] = {.lex_state = 36},
  [393] = {.lex_state = 36},
  [394] = {.lex_state = 36},
  [395] = {.lex_state = 36},
  [396] = {.lex_state = 36},
  [397] = {.lex_state = 36},
  [398] = {.lex_state = 36},
  [399] = {.lex_state = 36},
  [400] = {.lex_state = 36},
  [401] = {.lex_state = 36},
  [402] = {.lex_state = 36},
  [403] = {.lex_state = 36},
  [404] = {.lex_state = 36},
  [405] = {.lex_state = 36},
  [406] = {.lex_state = 36},
  [407] = {.lex_state = 36},
  [408] = {.lex_state = 36},
  [409] = {.lex_state = 36},
  [410] = {.lex_state = 36},
  [411] = {.lex_state = 36},
  [412] = {.lex_state = 36},
  [413] = {.lex_state = 36},
  [414] = {.lex_state = 36},
  [415] = {.lex_state = 36},
  [416] = {.lex_state = 36},
  [417] = {.lex_state = 36},
  [418] = {.lex_state = 36},
  [419] = {.lex_state = 36},
  [420] = {.lex_state = 36},
  [421] = {.lex_state = 36},
  [422] = {.lex_state = 36},
  [423] = {.lex_state = 36},
  [424] = {.lex_state = 36},
  [425] = {.lex_state = 36},
  [426] = {.lex_state = 36},
  [427] = {.lex_state = 36},
  [428] = {.lex_state = 36},
  [429] = {.lex_state = 36},
  [430] = {.lex_state = 36},
  [431] = {.lex_state = 36},
  [432] = {.lex_state = 16, .external_lex_state = 2},
  [433] = {.lex_state = 36},
  [434] = {.lex_state = 36},
  [435] = {.lex_state = 36},
  [436] = {.lex_state = 36},
  [437] = {.lex_state = 16},
  [438] = {.lex_state = 36},
  [439] = {.lex_state = 36},
  [440] = {.lex_state = 36},
  [441] = {.lex_state = 36},
  [442] = {.lex_state = 36},
  [443] = {.lex_state = 36},
  [444] = {.lex_state = 36},
  [445] = {.lex_state = 36},
  [446] = {.lex_state = 36},
  [447] = {.lex_state = 36},
  [448] = {.lex_state = 35},
  [449] = {.lex_state = 36},
  [450] = {.lex_state = 36},
  [451] = {.lex_state = 36},
  [452] = {.lex_state = 36},
  [453] = {.lex_state = 35},
  [454] = {.lex_state = 35},
  [455] = {.lex_state = 35},
  [456] = {.lex_state = 35},
  [457] = {.lex_state = 35},
  [458] = {.lex_state = 35},
  [459] = {.lex_state = 35},
  [460] = {.lex_state = 35},
  [461] = {.lex_state = 36},
  [462] = {.lex_state = 36},
  [463] = {.lex_state = 36},
  [464] = {.lex_state = 35},
  [465] = {.lex_state = 35},
  [466] = {.lex_state = 35},
  [467] = {.lex_state = 35},
  [468] = {.lex_state = 36},
  [469] = {.lex_state = 35},
  [470] = {.lex_state = 35},
  [471] = {.lex_state = 35},
  [472] = {.lex_state = 35},
  [473] = {.lex_state = 35},
  [474] = {.lex_state = 35},
  [475] = {.lex_state = 35},
  [476] = {.lex_state = 35},
  [477] = {.lex_state = 35},
  [478] = {.lex_state = 35},
  [479] = {.lex_state = 35},
  [480] = {.lex_state = 35},
  [481] = {.lex_state = 35},
  [482] = {.lex_state = 36},
  [483] = {.lex_state = 36},
  [484] = {.lex_state = 36},
  [485] = {.lex_state = 35},
  [486] = {.lex_state = 36},
  [487] = {.lex_state = 35},
  [488] = {.lex_state = 35},
  [489] = {.lex_state = 36},
  [490] = {.lex_state = 35},
  [491] = {.lex_state = 36},
  [492] = {.lex_state = 36},
  [493] = {.lex_state = 36},
  [494] = {.lex_state = 36},
  [495] = {.lex_state = 36},
  [496] = {.lex_state = 36},
  [497] = {.lex_state = 36},
  [498] = {.lex_state = 36},
  [499] = {.lex_state = 35},
  [500] = {.lex_state = 35},
  [501] = {.lex_state = 35},
  [502] = {.lex_state = 35},
  [503] = {.lex_state = 35},
  [504] = {.lex_state = 35},
  [505] = {.lex_state = 35},
  [506] = {.lex_state = 36},
  [507] = {.lex_state = 36},
  [508] = {.lex_state = 35},
  [509] = {.lex_state = 36},
  [510] = {.lex_state = 35},
  [511] = {.lex_state = 36},
  [512] = {.lex_state = 36},
  [513] = {.lex_state = 35},
  [514] = {.lex_state = 35},
  [515] = {.lex_state = 35},
  [516] = {.lex_state = 36},
  [517] = {.lex_state = 35},
  [518] = {.lex_state = 36},
  [519] = {.lex_state = 35},
  [520] = {.lex_state = 35},
  [521] = {.lex_state = 35},
  [522] = {.lex_state = 35},
  [523] = {.lex_state = 36},
  [524] = {.lex_state = 35},
  [525] = {.lex_state = 35},
  [526] = {.lex_state = 36},
  [527] = {.lex_state = 36},
  [528] = {.lex_state = 36},
  [529] = {.lex_state = 36},
  [530] = {.lex_state = 36},
  [531] = {.lex_state = 36},
  [532] = {.lex_state = 36},
  [533] = {.lex_state = 36},
  [534] = {.lex_state = 36},
  [535] = {.lex_state = 36},
  [536] = {.lex_state = 36},
  [537] = {.lex_state = 36},
  [538] = {.lex_state = 36},
  [539] = {.lex_state = 36},
  [540] = {.lex_state = 36},
  [541] = {.lex_state = 36},
  [542] = {.lex_state = 36},
  [543] = {.lex_state = 36},
  [544] = {.lex_state = 36},
  [545] = {.lex_state = 36},
  [546] = {.lex_state = 36},
  [547] = {.lex_state = 36},
  [548] = {.lex_state = 36},
  [549] = {.lex_state = 36},
  [550] = {.lex_state = 36},
  [551] = {.lex_state = 36},
  [552] = {.lex_state = 36},
  [553] = {.lex_state = 36},
  [554] = {.lex_state = 36},
  [555] = {.lex_state = 36},
  [556] = {.lex_state = 36},
  [557] = {.lex_state = 36},
  [558] = {.lex_state = 36},
  [559] = {.lex_state = 36},
  [560] = {.lex_state = 36},
  [561] = {.lex_state = 36},
  [562] = {.lex_state = 36},
  [563] = {.lex_state = 36},
  [564] = {.lex_state = 35},
  [565] = {.lex_state = 35},
  [566] = {.lex_state = 35},
  [567] = {.lex_state = 36},
  [568] = {.lex_state = 36},
  [569] = {.lex_state = 36},
  [570] = {.lex_state = 36},
  [571] = {.lex_state = 36},
  [572] = {.lex_state = 36},
  [573] = {.lex_state = 36},
  [574] = {.lex_state = 36},
  [575] = {.lex_state = 36},
  [576] = {.lex_state = 35},
  [577] = {.lex_state = 35},
  [578] = {.lex_state = 35},
  [579] = {.lex_state = 35},
  [580] = {.lex_state = 36},
  [581] = {.lex_state = 35},
  [582] = {.lex_state = 36},
  [583] = {.lex_state = 35},
  [584] = {.lex_state = 35},
  [585] = {.lex_state = 35},
  [586] = {.lex_state = 36},
  [587] = {.lex_state = 36},
  [588] = {.lex_state = 36},
  [589] = {.lex_state = 36},
  [590] = {.lex_state = 36},
  [591] = {.lex_state = 36},
  [592] = {.lex_state = 36},
  [593] = {.lex_state = 36},
  [594] = {.lex_state = 36},
  [595] = {.lex_state = 35},
  [596] = {.lex_state = 35},
  [597] = {.lex_state = 36},
  [598] = {.lex_state = 36},
  [599] = {.lex_state = 36},
  [600] = {.lex_state = 36},
  [601] = {.lex_state = 36},
  [602] = {.lex_state = 36},
  [603] = {.lex_state = 36},
  [604] = {.lex_state = 36},
  [605] = {.lex_state = 35},
  [606] = {.lex_state = 35},
  [607] = {.lex_state = 35},
  [608] = {.lex_state = 35},
  [609] = {.lex_state = 35},
  [610] = {.lex_state = 35},
  [611] = {.lex_state = 35},
  [612] = {.lex_state = 35},
  [613] = {.lex_state = 35},
  [614] = {.lex_state = 36},
  [615] = {.lex_state = 36},
  [616] = {.lex_state = 36},
  [617] = {.lex_state = 36},
  [618] = {.lex_state = 36},
  [619] = {.lex_state = 35},
  [620] = {.lex_state = 36},
  [621] = {.lex_state = 36},
  [622] = {.lex_state = 36},
  [623] = {.lex_state = 36},
  [624] = {.lex_state = 36},
  [625] = {.lex_state = 36},
  [626] = {.lex_state = 35},
  [627] = {.lex_state = 36},
  [628] = {.lex_state = 36},
  [629] = {.lex_state = 36},
  [630] = {.lex_state = 36},
  [631] = {.lex_state = 36},
  [632] = {.lex_state = 36},
  [633] = {.lex_state = 36},
  [634] = {.lex_state = 36},
  [635] = {.lex_state = 36},
  [636] = {.lex_state = 36},
  [637] = {.lex_state = 35},
  [638] = {.lex_state = 35},
  [639] = {.lex_state = 35},
  [640] = {.lex_state = 35},
  [641] = {.lex_state = 35},
  [642] = {.lex_state = 35},
  [643] = {.lex_state = 10},
  [644] = {.lex_state = 38},
  [645] = {.lex_state = 10},
  [646] = {.lex_state = 10},
  [647] = {.lex_state = 10},
  [648] = {.lex_state = 10},
  [649] = {.lex_state = 10},
  [650] = {.lex_state = 10},
  [651] = {.lex_state = 10},
  [652] = {.lex_state = 10},
  [653] = {.lex_state = 10},
  [654] = {.lex_state = 10},
  [655] = {.lex_state = 10},
  [656] = {.lex_state = 10},
  [657] = {.lex_state = 10},
  [658] = {.lex_state = 10},
  [659] = {.lex_state = 10},
  [660] = {.lex_state = 10},
  [661] = {.lex_state = 10},
  [662] = {.lex_state = 10},
  [663] = {.lex_state = 10},
  [664] = {.lex_state = 10},
  [665] = {.lex_state = 10},
  [666] = {.lex_state = 10},
  [667] = {.lex_state = 10},
  [668] = {.lex_state = 10},
  [669] = {.lex_state = 10},
  [670] = {.lex_state = 10},
  [671] = {.lex_state = 10},
  [672] = {.lex_state = 10},
  [673] = {.lex_state = 10},
  [674] = {.lex_state = 10},
  [675] = {.lex_state = 10},
  [676] = {.lex_state = 10},
  [677] = {.lex_state = 10},
  [678] = {.lex_state = 10},
  [679] = {.lex_state = 10},
  [680] = {.lex_state = 10},
  [681] = {.lex_state = 10},
  [682] = {.lex_state = 10},
  [683] = {.lex_state = 10},
  [684] = {.lex_state = 10},
  [685] = {.lex_state = 10},
  [686] = {.lex_state = 38},
  [687] = {.lex_state = 10},
  [688] = {.lex_state = 10},
  [689] = {.lex_state = 10},
  [690] = {.lex_state = 10},
  [691] = {.lex_state = 10},
  [692] = {.lex_state = 10},
  [693] = {.lex_state = 35},
  [694] = {.lex_state = 10},
  [695] = {.lex_state = 10},
  [696] = {.lex_state = 10},
  [697] = {.lex_state = 10},
  [698] = {.lex_state = 10},
  [699] = {.lex_state = 10},
  [700] = {.lex_state = 10},
  [701] = {.lex_state = 10},
  [702] = {.lex_state = 37},
  [703] = {.lex_state = 37},
  [704] = {.lex_state = 37},
  [705] = {.lex_state = 37},
  [706] = {.lex_state = 37},
  [707] = {.lex_state = 37},
  [708] = {.lex_state = 37},
  [709] = {.lex_state = 10},
  [710] = {.lex_state = 10},
  [711] = {.lex_state = 10},
  [712] = {.lex_state = 10},
  [713] = {.lex_state = 10},
  [714] = {.lex_state = 10},
  [715] = {.lex_state = 10},
  [716] = {.lex_state = 10},
  [717] = {.lex_state = 38},
  [718] = {.lex_state = 38},
  [719] = {.lex_state = 38},
  [720] = {.lex_state = 38},
  [721] = {.lex_state = 37},
  [722] = {.lex_state = 37},
  [723] = {.lex_state = 37},
  [724] = {.lex_state = 37},
  [725] = {.lex_state = 37},
  [726] = {.lex_state = 37},
  [727] = {.lex_state = 37},
  [728] = {.lex_state = 37},
  [729] = {.lex_state = 38},
  [730] = {.lex_state = 10},
  [731] = {.lex_state = 38},
  [732] = {.lex_state = 38},
  [733] = {.lex_state = 38},
  [734] = {.lex_state = 38},
  [735] = {.lex_state = 38},
  [736] = {.lex_state = 38},
  [737] = {.lex_state = 38},
  [738] = {.lex_state = 10},
  [739] = {.lex_state = 10},
  [740] = {.lex_state = 10},
  [741] = {.lex_state = 10},
  [742] = {.lex_state = 38},
  [743] = {.lex_state = 35},
  [744] = {.lex_state = 38},
  [745] = {.lex_state = 10},
  [746] = {.lex_state = 38},
  [747] = {.lex_state = 10},
  [748] = {.lex_state = 10},
  [749] = {.lex_state = 38},
  [750] = {.lex_state = 38},
  [751] = {.lex_state = 38},
  [752] = {.lex_state = 38},
  [753] = {.lex_state = 38},
  [754] = {.lex_state = 38},
  [755] = {.lex_state = 38},
  [756] = {.lex_state = 38},
  [757] = {.lex_state = 10},
  [758] = {.lex_state = 35},
  [759] = {.lex_state = 10},
  [760] = {.lex_state = 10},
  [761] = {.lex_state = 10},
  [762] = {.lex_state = 10},
  [763] = {.lex_state = 10},
  [764] = {.lex_state = 10},
  [765] = {.lex_state = 38},
  [766] = {.lex_state = 38},
  [767] = {.lex_state = 38},
  [768] = {.lex_state = 38},
  [769] = {.lex_state = 38},
  [770] = {.lex_state = 38},
  [771] = {.lex_state = 38},
  [772] = {.lex_state = 37},
  [773] = {.lex_state = 37},
  [774] = {.lex_state = 37},
  [775] = {.lex_state = 37},
  [776] = {.lex_state = 37},
  [777] = {.lex_state = 37},
  [778] = {.lex_state = 37},
  [779] = {.lex_state = 38},
  [780] = {.lex_state = 37},
  [781] = {.lex_state = 37},
  [782] = {.lex_state = 37},
  [783] = {.lex_state = 37},
  [784] = {.lex_state = 37},
  [785] = {.lex_state = 37},
  [786] = {.lex_state = 38},
  [787] = {.lex_state = 37},
  [788] = {.lex_state = 37},
  [789] = {.lex_state = 37},
  [790] = {.lex_state = 37},
  [791] = {.lex_state = 37},
  [792] = {.lex_state = 38},
  [793] = {.lex_state = 37},
  [794] = {.lex_state = 37},
  [795] = {.lex_state = 37},
  [796] = {.lex_state = 37},
  [797] = {.lex_state = 38},
  [798] = {.lex_state = 37},
  [799] = {.lex_state = 37},
  [800] = {.lex_state = 37},
  [801] = {.lex_state = 38},
  [802] = {.lex_state = 37},
  [803] = {.lex_state = 37},
  [804] = {.lex_state = 38},
  [805] = {.lex_state = 37},
  [806] = {.lex_state = 38},
  [807] = {.lex_state = 38},
  [808] = {.lex_state = 39, .external_lex_state = 2},
  [809] = {.lex_state = 38},
  [810] = {.lex_state = 38},
  [811] = {.lex_state = 37},
  [812] = {.lex_state = 37},
  [813] = {.lex_state = 37},
  [814] = {.lex_state = 37},
  [815] = {.lex_state = 37},
  [816] = {.lex_state = 37},
  [817] = {.lex_state = 37},
  [818] = {.lex_state = 37},
  [819] = {.lex_state = 38},
  [820] = {.lex_state = 38},
  [821] = {.lex_state = 38},
  [822] = {.lex_state = 38},
  [823] = {.lex_state = 38},
  [824] = {.lex_state = 38},
  [825] = {.lex_state = 38},
  [826] = {.lex_state = 38},
  [827] = {.lex_state = 38},
  [828] = {.lex_state = 38},
  [829] = {.lex_state = 35},
  [830] = {.lex_state = 38},
  [831] = {.lex_state = 38},
  [832] = {.lex_state = 38},
  [833] = {.lex_state = 38},
  [834] = {.lex_state = 38},
  [835] = {.lex_state = 38},
  [836] = {.lex_state = 38},
  [837] = {.lex_state = 38},
  [838] = {.lex_state = 38},
  [839] = {.lex_state = 38},
  [840] = {.lex_state = 38},
  [841] = {.lex_state = 38},
  [842] = {.lex_state = 38},
  [843] = {.lex_state = 38},
  [844] = {.lex_state = 38},
  [845] = {.lex_state = 38},
  [846] = {.lex_state = 38},
  [847] = {.lex_state = 38},
  [848] = {.lex_state = 38},
  [849] = {.lex_state = 38},
  [850] = {.lex_state = 38},
  [851] = {.lex_state = 37},
  [852] = {.lex_state = 37},
  [853] = {.lex_state = 37},
  [854] = {.lex_state = 37},
  [855] = {.lex_state = 37},
  [856] = {.lex_state = 37},
  [857] = {.lex_state = 37},
  [858] = {.lex_state = 38},
  [859] = {.lex_state = 37},
  [860] = {.lex_state = 37},
  [861] = {.lex_state = 37},
  [862] = {.lex_state = 37},
  [863] = {.lex_state = 37},
  [864] = {.lex_state = 37},
  [865] = {.lex_state = 37},
  [866] = {.lex_state = 37},
  [867] = {.lex_state = 37},
  [868] = {.lex_state = 37},
  [869] = {.lex_state = 37},
  [870] = {.lex_state = 37},
  [871] = {.lex_state = 37},
  [872] = {.lex_state = 37},
  [873] = {.lex_state = 37},
  [874] = {.lex_state = 37},
  [875] = {.lex_state = 37},
  [876] = {.lex_state = 37},
  [877] = {.lex_state = 37},
  [878] = {.lex_state = 37},
  [879] = {.lex_state = 37},
  [880] = {.lex_state = 38},
  [881] = {.lex_state = 38},
  [882] = {.lex_state = 38},
  [883] = {.lex_state = 38},
  [884] = {.lex_state = 38},
  [885] = {.lex_state = 35},
  [886] = {.lex_state = 10},
  [887] = {.lex_state = 35},
  [888] = {.lex_state = 38},
  [889] = {.lex_state = 37},
  [890] = {.lex_state = 10},
  [891] = {.lex_state = 35},
  [892] = {.lex_state = 35},
  [893] = {.lex_state = 10},
  [894] = {.lex_state = 10},
  [895] = {.lex_state = 35},
  [896] = {.lex_state = 11, .external_lex_state = 2},
  [897] = {.lex_state = 10},
  [898] = {.lex_state = 37},
  [899] = {.lex_state = 38},
  [900] = {.lex_state = 38},
  [901] = {.lex_state = 38},
  [902] = {.lex_state = 39},
  [903] = {.lex_state = 17, .external_lex_state = 2},
  [904] = {.lex_state = 35},
  [905] = {.lex_state = 37},
  [906] = {.lex_state = 38},
  [907] = {.lex_state = 37},
  [908] = {.lex_state = 12, .external_lex_state = 2},
  [909] = {.lex_state = 37},
  [910] = {.lex_state = 35},
  [911] = {.lex_state = 10},
  [912] = {.lex_state = 35},
  [913] = {.lex_state = 35},
  [914] = {.lex_state = 35},
  [915] = {.lex_state = 35},
  [916] = {.lex_state = 35},
  [917] = {.lex_state = 35},
  [918] = {.lex_state = 35},
  [919] = {.lex_state = 35},
  [920] = {.lex_state = 35},
  [921] = {.lex_state = 37},
  [922] = {.lex_state = 35},
  [923] = {.lex_state = 12},
  [924] = {.lex_state = 37},
  [925] = {.lex_state = 37},
  [926] = {.lex_state = 38},
  [927] = {.lex_state = 35},
  [928] = {.lex_state = 35},
  [929] = {.lex_state = 35},
  [930] = {.lex_state = 35},
  [931] = {.lex_state = 35},
  [932] = {.lex_state = 35},
  [933] = {.lex_state = 35},
  [934] = {.lex_state = 35},
  [935] = {.lex_state = 35},
  [936] = {.lex_state = 37},
  [937] = {.lex_state = 35},
  [938] = {.lex_state = 35},
  [939] = {.lex_state = 35},
  [940] = {.lex_state = 35},
  [941] = {.lex_state = 35},
  [942] = {.lex_state = 35},
  [943] = {.lex_state = 35},
  [944] = {.lex_state = 35},
  [945] = {.lex_state = 35},
  [946] = {.lex_state = 35},
  [947] = {.lex_state = 35},
  [948] = {.lex_state = 35},
  [949] = {.lex_state = 35},
  [950] = {.lex_state = 35},
  [951] = {.lex_state = 35},
  [952] = {.lex_state = 10},
  [953] = {.lex_state = 35},
  [954] = {.lex_state = 35},
  [955] = {.lex_state = 35},
  [956] = {.lex_state = 35},
  [957] = {.lex_state = 35},
  [958] = {.lex_state = 35},
  [959] = {.lex_state = 35},
  [960] = {.lex_state = 38},
  [961] = {.lex_state = 35},
  [962] = {.lex_state = 35},
  [963] = {.lex_state = 35},
  [964] = {.lex_state = 35},
  [965] = {.lex_state = 35},
  [966] = {.lex_state = 35},
  [967] = {.lex_state = 35},
  [968] = {.lex_state = 35},
  [969] = {.lex_state = 35},
  [970] = {.lex_state = 17},
  [971] = {.lex_state = 35},
  [972] = {.lex_state = 35},
  [973] = {.lex_state = 35},
  [974] = {.lex_state = 35},
  [975] = {.lex_state = 35},
  [976] = {.lex_state = 35},
  [977] = {.lex_state = 35},
  [978] = {.lex_state = 35},
  [979] = {.lex_state = 35},
  [980] = {.lex_state = 10},
  [981] = {.lex_state = 10},
  [982] = {.lex_state = 11},
  [983] = {.lex_state = 35},
  [984] = {.lex_state = 35},
  [985] = {.lex_state = 35},
  [986] = {.lex_state = 35},
  [987] = {.lex_state = 35},
  [988] = {.lex_state = 35},
  [989] = {.lex_state = 35},
  [990] = {.lex_state = 35},
  [991] = {.lex_state = 37},
  [992] = {.lex_state = 35},
  [993] = {.lex_state = 35},
  [994] = {.lex_state = 35},
  [995] = {.lex_state = 35},
  [996] = {.lex_state = 35},
  [997] = {.lex_state = 35},
  [998] = {.lex_state = 35},
  [999] = {.lex_state = 35},
  [1000] = {.lex_state = 35},
  [1001] = {.lex_state = 35},
  [1002] = {.lex_state = 38},
  [1003] = {.lex_state = 35},
  [1004] = {.lex_state = 35},
  [1005] = {.lex_state = 35},
  [1006] = {.lex_state = 35},
  [1007] = {.lex_state = 35},
  [1008] = {.lex_state = 10},
  [1009] = {.lex_state = 35},
  [1010] = {.lex_state = 35},
  [1011] = {.lex_state = 35},
  [1012] = {.lex_state = 35},
  [1013] = {.lex_state = 35},
  [1014] = {.lex_state = 35},
  [1015] = {.lex_state = 35},
  [1016] = {.lex_state = 35},
  [1017] = {.lex_state = 38},
  [1018] = {.lex_state = 35},
  [1019] = {.lex_state = 35},
  [1020] = {.lex_state = 35},
  [1021] = {.lex_state = 35},
  [1022] = {.lex_state = 35},
  [1023] = {.lex_state = 35},
  [1024] = {.lex_state = 38},
  [1025] = {.lex_state = 35},
  [1026] = {.lex_state = 10},
  [1027] = {.lex_state = 35},
  [1028] = {.lex_state = 35},
  [1029] = {.lex_state = 35},
  [1030] = {.lex_state = 35},
  [1031] = {.lex_state = 35},
  [1032] = {.lex_state = 35},
  [1033] = {.lex_state = 35},
  [1034] = {.lex_state = 35},
  [1035] = {.lex_state = 35},
  [1036] = {.lex_state = 35},
  [1037] = {.lex_state = 35},
  [1038] = {.lex_state = 35},
  [1039] = {.lex_state = 35},
  [1040] = {.lex_state = 35},
  [1041] = {.lex_state = 35},
  [1042] = {.lex_state = 35},
  [1043] = {.lex_state = 35},
  [1044] = {.lex_state = 35},
  [1045] = {.lex_state = 35},
  [1046] = {.lex_state = 35},
  [1047] = {.lex_state = 35},
  [1048] = {.lex_state = 35},
  [1049] = {.lex_state = 35},
  [1050] = {.lex_state = 10},
  [1051] = {.lex_state = 38},
  [1052] = {.lex_state = 38},
  [1053] = {.lex_state = 38},
  [1054] = {.lex_state = 38},
  [1055] = {.lex_state = 38},
  [1056] = {.lex_state = 38},
  [1057] = {.lex_state = 10},
  [1058] = {.lex_state = 10},
  [1059] = {.lex_state = 38},
  [1060] = {.lex_state = 10},
  [1061] = {.lex_state = 10},
  [1062] = {.lex_state = 10},
  [1063] = {.lex_state = 38},
  [1064] = {.lex_state = 38},
  [1065] = {.lex_state = 38},
  [1066] = {.lex_state = 10},
  [1067] = {.lex_state = 38},
  [1068] = {.lex_state = 10},
  [1069] = {.lex_state = 10},
  [1070] = {.lex_state = 10},
  [1071] = {.lex_state = 10},
  [1072] = {.lex_state = 10},
  [1073] = {.lex_state = 10},
  [1074] = {.lex_state = 10},
  [1075] = {.lex_state = 10},
  [1076] = {.lex_state = 10},
  [1077] = {.lex_state = 10},
  [1078] = {.lex_state = 10},
  [1079] = {.lex_state = 10},
  [1080] = {.lex_state = 10},
  [1081] = {.lex_state = 10},
  [1082] = {.lex_state = 10},
  [1083] = {.lex_state = 10},
  [1084] = {.lex_state = 10},
  [1085] = {.lex_state = 10},
  [1086] = {.lex_state = 10},
  [1087] = {.lex_state = 10},
  [1088] = {.lex_state = 10},
  [1089] = {.lex_state = 38},
  [1090] = {.lex_state = 38},
  [1091] = {.lex_state = 10},
  [1092] = {.lex_state = 10},
  [1093] = {.lex_state = 10},
  [1094] = {.lex_state = 10},
  [1095] = {.lex_state = 10},
  [1096] = {.lex_state = 10},
  [1097] = {.lex_state = 38},
  [1098] = {.lex_state = 10},
  [1099] = {.lex_state = 10},
  [1100] = {.lex_state = 10},
  [1101] = {.lex_state = 10},
  [1102] = {.lex_state = 37},
  [1103] = {.lex_state = 10},
  [1104] = {.lex_state = 10},
  [1105] = {.lex_state = 10},
  [1106] = {.lex_state = 10},
  [1107] = {.lex_state = 10},
  [1108] = {.lex_state = 10},
  [1109] = {.lex_state = 10},
  [1110] = {.lex_state = 10},
  [1111] = {.lex_state = 10},
  [1112] = {.lex_state = 10},
  [1113] = {.lex_state = 10},
  [1114] = {.lex_state = 10},
  [1115] = {.lex_state = 38},
  [1116] = {.lex_state = 10},
  [1117] = {.lex_state = 38},
  [1118] = {.lex_state = 10},
  [1119] = {.lex_state = 10},
  [1120] = {.lex_state = 10},
  [1121] = {.lex_state = 10},
  [1122] = {.lex_state = 10},
  [1123] = {.lex_state = 10},
  [1124] = {.lex_state = 10},
  [1125] = {.lex_state = 10},
  [1126] = {.lex_state = 10},
  [1127] = {.lex_state = 10},
  [1128] = {.lex_state = 10},
  [1129] = {.lex_state = 37},
  [1130] = {.lex_state = 37},
  [1131] = {.lex_state = 37},
  [1132] = {.lex_state = 37},
  [1133] = {.lex_state = 10},
  [1134] = {.lex_state = 37},
  [1135] = {.lex_state = 37},
  [1136] = {.lex_state = 10},
  [1137] = {.lex_state = 10},
  [1138] = {.lex_state = 10},
  [1139] = {.lex_state = 10},
  [1140] = {.lex_state = 10},
  [1141] = {.lex_state = 10},
  [1142] = {.lex_state = 10},
  [1143] = {.lex_state = 10},
  [1144] = {.lex_state = 38},
  [1145] = {.lex_state = 10},
  [1146] = {.lex_state = 37},
  [1147] = {.lex_state = 10},
  [1148] = {.lex_state = 10},
  [1149] = {.lex_state = 10},
  [1150] = {.lex_state = 10},
  [1151] = {.lex_state = 10},
  [1152] = {.lex_state = 10},
  [1153] = {.lex_state = 10},
  [1154] = {.lex_state = 10},
  [1155] = {.lex_state = 10},
  [1156] = {.lex_state = 10},
  [1157] = {.lex_state = 10},
  [1158] = {.lex_state = 10},
  [1159] = {.lex_state = 10},
  [1160] = {.lex_state = 10},
  [1161] = {.lex_state = 10},
  [1162] = {.lex_state = 10},
  [1163] = {.lex_state = 10},
  [1164] = {.lex_state = 38},
  [1165] = {.lex_state = 10},
  [1166] = {.lex_state = 37},
  [1167] = {.lex_state = 10},
  [1168] = {.lex_state = 10},
  [1169] = {.lex_state = 10},
  [1170] = {.lex_state = 10},
  [1171] = {.lex_state = 10},
  [1172] = {.lex_state = 10},
  [1173] = {.lex_state = 10},
  [1174] = {.lex_state = 10},
  [1175] = {.lex_state = 10},
  [1176] = {.lex_state = 10},
  [1177] = {.lex_state = 10},
  [1178] = {.lex_state = 10},
  [1179] = {.lex_state = 10},
  [1180] = {.lex_state = 38},
  [1181] = {.lex_state = 38},
  [1182] = {.lex_state = 10},
  [1183] = {.lex_state = 38},
  [1184] = {.lex_state = 38},
  [1185] = {.lex_state = 38},
  [1186] = {.lex_state = 38},
  [1187] = {.lex_state = 10},
  [1188] = {.lex_state = 10},
  [1189] = {.lex_state = 38},
  [1190] = {.lex_state = 38},
  [1191] = {.lex_state = 38},
  [1192] = {.lex_state = 10},
  [1193] = {.lex_state = 10},
  [1194] = {.lex_state = 10},
  [1195] = {.lex_state = 10},
  [1196] = {.lex_state = 10},
  [1197] = {.lex_state = 10},
  [1198] = {.lex_state = 10},
  [1199] = {.lex_state = 38},
  [1200] = {.lex_state = 38},
  [1201] = {.lex_state = 38},
  [1202] = {.lex_state = 38},
  [1203] = {.lex_state = 10},
  [1204] = {.lex_state = 10},
  [1205] = {.lex_state = 37},
  [1206] = {.lex_state = 37},
  [1207] = {.lex_state = 37},
  [1208] = {.lex_state = 38},
  [1209] = {.lex_state = 38},
  [1210] = {.lex_state = 37},
  [1211] = {.lex_state = 37},
  [1212] = {.lex_state = 37},
  [1213] = {.lex_state = 37},
  [1214] = {.lex_state = 37},
  [1215] = {.lex_state = 37},
  [1216] = {.lex_state = 37},
  [1217] = {.lex_state = 37},
  [1218] = {.lex_state = 38},
  [1219] = {.lex_state = 38},
  [1220] = {.lex_state = 38},
  [1221] = {.lex_state = 38},
  [1222] = {.lex_state = 37},
  [1223] = {.lex_state = 37},
  [1224] = {.lex_state = 37},
  [1225] = {.lex_state = 38},
  [1226] = {.lex_state = 38},
  [1227] = {.lex_state = 38},
  [1228] = {.lex_state = 38},
  [1229] = {.lex_state = 38},
  [1230] = {.lex_state = 38},
  [1231] = {.lex_state = 38},
  [1232] = {.lex_state = 38},
  [1233] = {.lex_state = 38},
  [1234] = {.lex_state = 38},
  [1235] = {.lex_state = 38},
  [1236] = {.lex_state = 38},
  [1237] = {.lex_state = 38},
  [1238] = {.lex_state = 38},
  [1239] = {.lex_state = 38},
  [1240] = {.lex_state = 10},
  [1241] = {.lex_state = 38},
  [1242] = {.lex_state = 38},
  [1243] = {.lex_state = 38},
  [1244] = {.lex_state = 38},
  [1245] = {.lex_state = 37},
  [1246] = {.lex_state = 38},
  [1247] = {.lex_state = 37},
  [1248] = {.lex_state = 37},
  [1249] = {.lex_state = 37},
  [1250] = {.lex_state = 37},
  [1251] = {.lex_state = 37},
  [1252] = {.lex_state = 37},
  [1253] = {.lex_state = 37},
  [1254] = {.lex_state = 37},
  [1255] = {.lex_state = 37},
  [1256] = {.lex_state = 37},
  [1257] = {.lex_state = 37},
  [1258] = {.lex_state = 37},
  [1259] = {.lex_state = 38},
  [1260] = {.lex_state = 37},
  [1261] = {.lex_state = 38},
  [1262] = {.lex_state = 38},
  [1263] = {.lex_state = 38},
  [1264] = {.lex_state = 38},
  [1265] = {.lex_state = 38},
  [1266] = {.lex_state = 38},
  [1267] = {.lex_state = 38},
  [1268] = {.lex_state = 38},
  [1269] = {.lex_state = 38},
  [1270] = {.lex_state = 38},
  [1271] = {.lex_state = 38},
  [1272] = {.lex_state = 38},
  [1273] = {.lex_state = 38},
  [1274] = {.lex_state = 37},
  [1275] = {.lex_state = 38},
  [1276] = {.lex_state = 38},
  [1277] = {.lex_state = 38},
  [1278] = {.lex_state = 38},
  [1279] = {.lex_state = 38},
  [1280] = {.lex_state = 38},
  [1281] = {.lex_state = 38},
  [1282] = {.lex_state = 38},
  [1283] = {.lex_state = 37},
  [1284] = {.lex_state = 38},
  [1285] = {.lex_state = 38},
  [1286] = {.lex_state = 38},
  [1287] = {.lex_state = 37},
  [1288] = {.lex_state = 38},
  [1289] = {.lex_state = 38},
  [1290] = {.lex_state = 38},
  [1291] = {.lex_state = 38},
  [1292] = {.lex_state = 38},
  [1293] = {.lex_state = 38},
  [1294] = {.lex_state = 38},
  [1295] = {.lex_state = 38},
  [1296] = {.lex_state = 38},
  [1297] = {.lex_state = 38},
  [1298] = {.lex_state = 37},
  [1299] = {.lex_state = 38},
  [1300] = {.lex_state = 37},
  [1301] = {.lex_state = 38},
  [1302] = {.lex_state = 37},
  [1303] = {.lex_state = 38},
  [1304] = {.lex_state = 37},
  [1305] = {.lex_state = 38},
  [1306] = {.lex_state = 37},
  [1307] = {.lex_state = 38},
  [1308] = {.lex_state = 38},
  [1309] = {.lex_state = 38},
  [1310] = {.lex_state = 37},
  [1311] = {.lex_state = 38},
  [1312] = {.lex_state = 38},
  [1313] = {.lex_state = 38},
  [1314] = {.lex_state = 38},
  [1315] = {.lex_state = 37},
  [1316] = {.lex_state = 37},
  [1317] = {.lex_state = 37},
  [1318] = {.lex_state = 37},
  [1319] = {.lex_state = 38},
  [1320] = {.lex_state = 38},
  [1321] = {.lex_state = 37},
  [1322] = {.lex_state = 37},
  [1323] = {.lex_state = 38},
  [1324] = {.lex_state = 37},
  [1325] = {.lex_state = 37},
  [1326] = {.lex_state = 38},
  [1327] = {.lex_state = 38},
  [1328] = {.lex_state = 38},
  [1329] = {.lex_state = 37},
  [1330] = {.lex_state = 37},
  [1331] = {.lex_state = 37},
  [1332] = {.lex_state = 37},
  [1333] = {.lex_state = 37},
  [1334] = {.lex_state = 37},
  [1335] = {.lex_state = 37},
  [1336] = {.lex_state = 37},
  [1337] = {.lex_state = 37},
  [1338] = {.lex_state = 37},
  [1339] = {.lex_state = 38},
  [1340] = {.lex_state = 38},
  [1341] = {.lex_state = 37},
  [1342] = {.lex_state = 37},
  [1343] = {.lex_state = 37},
  [1344] = {.lex_state = 37},
  [1345] = {.lex_state = 37},
  [1346] = {.lex_state = 37},
  [1347] = {.lex_state = 37},
  [1348] = {.lex_state = 37},
  [1349] = {.lex_state = 37},
  [1350] = {.lex_state = 37},
  [1351] = {.lex_state = 37},
  [1352] = {.lex_state = 37},
  [1353] = {.lex_state = 37},
  [1354] = {.lex_state = 37},
  [1355] = {.lex_state = 37},
  [1356] = {.lex_state = 37},
  [1357] = {.lex_state = 37},
  [1358] = {.lex_state = 37},
  [1359] = {.lex_state = 38},
  [1360] = {.lex_state = 37},
  [1361] = {.lex_state = 37},
  [1362] = {.lex_state = 37},
  [1363] = {.lex_state = 38},
  [1364] = {.lex_state = 37},
  [1365] = {.lex_state = 38},
  [1366] = {.lex_state = 37},
  [1367] = {.lex_state = 37},
  [1368] = {.lex_state = 10},
  [1369] = {.lex_state = 10},
  [1370] = {.lex_state = 10},
  [1371] = {.lex_state = 37},
  [1372] = {.lex_state = 10},
  [1373] = {.lex_state = 10},
  [1374] = {.lex_state = 37},
  [1375] = {.lex_state = 38},
  [1376] = {.lex_state = 38},
  [1377] = {.lex_state = 37},
  [1378] = {.lex_state = 37},
  [1379] = {.lex_state = 37},
  [1380] = {.lex_state = 37},
  [1381] = {.lex_state = 38},
  [1382] = {.lex_state = 37},
  [1383] = {.lex_state = 37},
  [1384] = {.lex_state = 10},
  [1385] = {.lex_state = 37},
  [1386] = {.lex_state = 37},
  [1387] = {.lex_state = 37},
  [1388] = {.lex_state = 37},
  [1389] = {.lex_state = 37},
  [1390] = {.lex_state = 37},
  [1391] = {.lex_state = 38},
  [1392] = {.lex_state = 37},
  [1393] = {.lex_state = 37},
  [1394] = {.lex_state = 37},
  [1395] = {.lex_state = 37},
  [1396] = {.lex_state = 37},
  [1397] = {.lex_state = 38},
  [1398] = {.lex_state = 38},
  [1399] = {.lex_state = 10},
  [1400] = {.lex_state = 37},
  [1401] = {.lex_state = 37},
  [1402] = {.lex_state = 37},
  [1403] = {.lex_state = 37},
  [1404] = {.lex_state = 10},
  [1405] = {.lex_state = 37},
  [1406] = {.lex_state = 38},
  [1407] = {.lex_state = 37},
  [1408] = {.lex_state = 37},
  [1409] = {.lex_state = 37},
  [1410] = {.lex_state = 37},
  [1411] = {.lex_state = 37},
  [1412] = {.lex_state = 37},
  [1413] = {.lex_state = 37},
  [1414] = {.lex_state = 37},
  [1415] = {.lex_state = 37},
  [1416] = {.lex_state = 23},
  [1417] = {.lex_state = 23},
  [1418] = {.lex_state = 23},
  [1419] = {.lex_state = 23},
  [1420] = {.lex_state = 23},
  [1421] = {.lex_state = 23},
  [1422] = {.lex_state = 23},
  [1423] = {.lex_state = 23},
  [1424] = {.lex_state = 23},
  [1425] = {.lex_state = 23},
  [1426] = {.lex_state = 23},
  [1427] = {.lex_state = 23},
  [1428] = {.lex_state = 23},
  [1429] = {.lex_state = 23},
  [1430] = {.lex_state = 23},
  [1431] = {.lex_state = 23},
  [1432] = {.lex_state = 23},
  [1433] = {.lex_state = 23},
  [1434] = {.lex_state = 23},
  [1435] = {.lex_state = 23},
  [1436] = {.lex_state = 23},
  [1437] = {.lex_state = 23},
  [1438] = {.lex_state = 23},
  [1439] = {.lex_state = 23},
  [1440] = {.lex_state = 23},
  [1441] = {.lex_state = 23},
  [1442] = {.lex_state = 23},
  [1443] = {.lex_state = 23},
  [1444] = {.lex_state = 23},
  [1445] = {.lex_state = 23},
  [1446] = {.lex_state = 23},
  [1447] = {.lex_state = 23},
  [1448] = {.lex_state = 23},
  [1449] = {.lex_state = 23},
  [1450] = {.lex_state = 23},
  [1451] = {.lex_state = 23},
  [1452] = {.lex_state = 23},
  [1453] = {.lex_state = 23},
  [1454] = {.lex_state = 23},
  [1455] = {.lex_state = 23},
  [1456] = {.lex_state = 23},
  [1457] = {.lex_state = 23},
  [1458] = {.lex_state = 23},
  [1459] = {.lex_state = 23},
  [1460] = {.lex_state = 23},
  [1461] = {.lex_state = 23},
  [1462] = {.lex_state = 23},
  [1463] = {.lex_state = 13},
  [1464] = {.lex_state = 18, .external_lex_state = 2},
  [1465] = {.lex_state = 13},
  [1466] = {.lex_state = 13},
  [1467] = {.lex_state = 13},
  [1468] = {.lex_state = 13},
  [1469] = {.lex_state = 13},
  [1470] = {.lex_state = 15},
  [1471] = {.lex_state = 19, .external_lex_state = 2},
  [1472] = {.lex_state = 13},
  [1473] = {.lex_state = 14},
  [1474] = {.lex_state = 15},
  [1475] = {.lex_state = 14},
  [1476] = {.lex_state = 13},
  [1477] = {.lex_state = 20, .external_lex_state = 2},
  [1478] = {.lex_state = 14},
  [1479] = {.lex_state = 18},
  [1480] = {.lex_state = 15},
  [1481] = {.lex_state = 14},
  [1482] = {.lex_state = 15},
  [1483] = {.lex_state = 13},
  [1484] = {.lex_state = 15},
  [1485] = {.lex_state = 14},
  [1486] = {.lex_state = 13},
  [1487] = {.lex_state = 13},
  [1488] = {.lex_state = 20},
  [1489] = {.lex_state = 13},
  [1490] = {.lex_state = 13},
  [1491] = {.lex_state = 13},
  [1492] = {.lex_state = 13},
  [1493] = {.lex_state = 13},
  [1494] = {.lex_state = 13},
  [1495] = {.lex_state = 14},
  [1496] = {.lex_state = 13},
  [1497] = {.lex_state = 13},
  [1498] = {.lex_state = 13},
  [1499] = {.lex_state = 13},
  [1500] = {.lex_state = 13},
  [1501] = {.lex_state = 13},
  [1502] = {.lex_state = 13},
  [1503] = {.lex_state = 13},
  [1504] = {.lex_state = 13},
  [1505] = {.lex_state = 13},
  [1506] = {.lex_state = 13},
  [1507] = {.lex_state = 13},
  [1508] = {.lex_state = 13},
  [1509] = {.lex_state = 13},
  [1510] = {.lex_state = 13},
  [1511] = {.lex_state = 13},
  [1512] = {.lex_state = 13},
  [1513] = {.lex_state = 13},
  [1514] = {.lex_state = 13},
  [1515] = {.lex_state = 13},
  [1516] = {.lex_state = 13},
  [1517] = {.lex_state = 13},
  [1518] = {.lex_state = 13},
  [1519] = {.lex_state = 13},
  [1520] = {.lex_state = 13},
  [1521] = {.lex_state = 13},
  [1522] = {.lex_state = 13},
  [1523] = {.lex_state = 14},
  [1524] = {.lex_state = 13},
  [1525] = {.lex_state = 13},
  [1526] = {.lex_state = 13},
  [1527] = {.lex_state = 13},
  [1528] = {.lex_state = 13},
  [1529] = {.lex_state = 14},
  [1530] = {.lex_state = 13},
  [1531] = {.lex_state = 13},
  [1532] = {.lex_state = 13},
  [1533] = {.lex_state = 13},
  [1534] = {.lex_state = 13},
  [1535] = {.lex_state = 13},
  [1536] = {.lex_state = 13},
  [1537] = {.lex_state = 13},
  [1538] = {.lex_state = 13},
  [1539] = {.lex_state = 13},
  [1540] = {.lex_state = 13},
  [1541] = {.lex_state = 13},
  [1542] = {.lex_state = 13},
  [1543] = {.lex_state = 14},
  [1544] = {.lex_state = 13},
  [1545] = {.lex_state = 13},
  [1546] = {.lex_state = 13},
  [1547] = {.lex_state = 13},
  [1548] = {.lex_state = 13},
  [1549] = {.lex_state = 13},
  [1550] = {.lex_state = 13},
  [1551] = {.lex_state = 13},
  [1552] = {.lex_state = 13},
  [1553] = {.lex_state = 13},
  [1554] = {.lex_state = 13},
  [1555] = {.lex_state = 13},
  [1556] = {.lex_state = 13},
  [1557] = {.lex_state = 13},
  [1558] = {.lex_state = 13},
  [1559] = {.lex_state = 13},
  [1560] = {.lex_state = 13},
  [1561] = {.lex_state = 13},
  [1562] = {.lex_state = 13},
  [1563] = {.lex_state = 13},
  [1564] = {.lex_state = 13},
  [1565] = {.lex_state = 13},
  [1566] = {.lex_state = 13},
  [1567] = {.lex_state = 13},
  [1568] = {.lex_state = 13},
  [1569] = {.lex_state = 13},
  [1570] = {.lex_state = 13},
  [1571] = {.lex_state = 13},
  [1572] = {.lex_state = 13},
  [1573] = {.lex_state = 13},
  [1574] = {.lex_state = 13},
  [1575] = {.lex_state = 13},
  [1576] = {.lex_state = 15},
  [1577] = {.lex_state = 13},
  [1578] = {.lex_state = 13},
  [1579] = {.lex_state = 13},
  [1580] = {.lex_state = 13},
  [1581] = {.lex_state = 13},
  [1582] = {.lex_state = 13},
  [1583] = {.lex_state = 13},
  [1584] = {.lex_state = 13},
  [1585] = {.lex_state = 13},
  [1586] = {.lex_state = 13},
  [1587] = {.lex_state = 13},
  [1588] = {.lex_state = 13},
  [1589] = {.lex_state = 13},
  [1590] = {.lex_state = 13},
  [1591] = {.lex_state = 13},
  [1592] = {.lex_state = 13},
  [1593] = {.lex_state = 13},
  [1594] = {.lex_state = 13},
  [1595] = {.lex_state = 13},
  [1596] = {.lex_state = 15},
  [1597] = {.lex_state = 13},
  [1598] = {.lex_state = 13},
  [1599] = {.lex_state = 13},
  [1600] = {.lex_state = 13},
  [1601] = {.lex_state = 13},
  [1602] = {.lex_state = 15},
  [1603] = {.lex_state = 13},
  [1604] = {.lex_state = 13},
  [1605] = {.lex_state = 19},
  [1606] = {.lex_state = 13},
  [1607] = {.lex_state = 15},
  [1608] = {.lex_state = 15},
  [1609] = {.lex_state = 14},
  [1610] = {.lex_state = 15},
  [1611] = {.lex_state = 15},
  [1612] = {.lex_state = 15},
  [1613] = {.lex_state = 14},
  [1614] = {.lex_state = 15},
  [1615] = {.lex_state = 14},
  [1616] = {.lex_state = 15},
  [1617] = {.lex_state = 15},
  [1618] = {.lex_state = 14},
  [1619] = {.lex_state = 14},
  [1620] = {.lex_state = 14},
  [1621] = {.lex_state = 14},
  [1622] = {.lex_state = 14},
  [1623] = {.lex_state = 14},
  [1624] = {.lex_state = 14},
  [1625] = {.lex_state = 14},
  [1626] = {.lex_state = 14},
  [1627] = {.lex_state = 14},
  [1628] = {.lex_state = 14},
  [1629] = {.lex_state = 14},
  [1630] = {.lex_state = 14},
  [1631] = {.lex_state = 14},
  [1632] = {.lex_state = 15},
  [1633] = {.lex_state = 14},
  [1634] = {.lex_state = 14},
  [1635] = {.lex_state = 15},
  [1636] = {.lex_state = 15},
  [1637] = {.lex_state = 15},
  [1638] = {.lex_state = 15},
  [1639] = {.lex_state = 15},
  [1640] = {.lex_state = 15},
  [1641] = {.lex_state = 15},
  [1642] = {.lex_state = 15},
  [1643] = {.lex_state = 14},
  [1644] = {.lex_state = 15},
  [1645] = {.lex_state = 14},
  [1646] = {.lex_state = 15},
  [1647] = {.lex_state = 15},
  [1648] = {.lex_state = 15},
  [1649] = {.lex_state = 15},
  [1650] = {.lex_state = 14},
  [1651] = {.lex_state = 15},
  [1652] = {.lex_state = 15},
  [1653] = {.lex_state = 15},
  [1654] = {.lex_state = 14},
  [1655] = {.lex_state = 14},
  [1656] = {.lex_state = 14},
  [1657] = {.lex_state = 14},
  [1658] = {.lex_state = 14},
  [1659] = {.lex_state = 15},
  [1660] = {.lex_state = 15},
  [1661] = {.lex_state = 15},
  [1662] = {.lex_state = 15},
  [1663] = {.lex_state = 14},
  [1664] = {.lex_state = 15},
  [1665] = {.lex_state = 14},
  [1666] = {.lex_state = 15},
  [1667] = {.lex_state = 15},
  [1668] = {.lex_state = 15},
  [1669] = {.lex_state = 15},
  [1670] = {.lex_state = 15},
  [1671] = {.lex_state = 14},
  [1672] = {.lex_state = 14},
  [1673] = {.lex_state = 14},
  [1674] = {.lex_state = 15},
  [1675] = {.lex_state = 15},
  [1676] = {.lex_state = 14},
  [1677] = {.lex_state = 15},
  [1678] = {.lex_state = 15},
  [1679] = {.lex_state = 15},
  [1680] = {.lex_state = 15},
  [1681] = {.lex_state = 15},
  [1682] = {.lex_state = 14},
  [1683] = {.lex_state = 15},
  [1684] = {.lex_state = 15},
  [1685] = {.lex_state = 14},
  [1686] = {.lex_state = 15},
  [1687] = {.lex_state = 15},
  [1688] = {.lex_state = 14},
  [1689] = {.lex_state = 15},
  [1690] = {.lex_state = 14},
  [1691] = {.lex_state = 14},
  [1692] = {.lex_state = 15},
  [1693] = {.lex_state = 15},
  [1694] = {.lex_state = 15},
  [1695] = {.lex_state = 15},
  [1696] = {.lex_state = 15},
  [1697] = {.lex_state = 15},
  [1698] = {.lex_state = 15},
  [1699] = {.lex_state = 15},
  [1700] = {.lex_state = 15},
  [1701] = {.lex_state = 14},
  [1702] = {.lex_state = 14},
  [1703] = {.lex_state = 14},
  [1704] = {.lex_state = 15},
  [1705] = {.lex_state = 15},
  [1706] = {.lex_state = 14},
  [1707] = {.lex_state = 14},
  [1708] = {.lex_state = 14},
  [1709] = {.lex_state = 14},
  [1710] = {.lex_state = 14},
  [1711] = {.lex_state = 14},
  [1712] = {.lex_state = 21},
  [1713] = {.lex_state = 14},
  [1714] = {.lex_state = 14},
  [1715] = {.lex_state = 14},
  [1716] = {.lex_state = 14},
  [1717] = {.lex_state = 14},
  [1718] = {.lex_state = 14},
  [1719] = {.lex_state = 14},
  [1720] = {.lex_state = 14},
  [1721] = {.lex_state = 14},
  [1722] = {.lex_state = 14},
  [1723] = {.lex_state = 14},
  [1724] = {.lex_state = 14},
  [1725] = {.lex_state = 14},
  [1726] = {.lex_state = 14},
  [1727] = {.lex_state = 15},
  [1728] = {.lex_state = 14},
  [1729] = {.lex_state = 14},
  [1730] = {.lex_state = 14},
  [1731] = {.lex_state = 14},
  [1732] = {.lex_state = 14},
  [1733] = {.lex_state = 14},
  [1734] = {.lex_state = 14},
  [1735] = {.lex_state = 14},
  [1736] = {.lex_state = 14},
  [1737] = {.lex_state = 14},
  [1738] = {.lex_state = 14},
  [1739] = {.lex_state = 14},
  [1740] = {.lex_state = 14},
  [1741] = {.lex_state = 15},
  [1742] = {.lex_state = 14},
  [1743] = {.lex_state = 14},
  [1744] = {.lex_state = 14},
  [1745] = {.lex_state = 21},
  [1746] = {.lex_state = 15},
  [1747] = {.lex_state = 14},
  [1748] = {.lex_state = 15},
  [1749] = {.lex_state = 14},
  [1750] = {.lex_state = 14},
  [1751] = {.lex_state = 15},
  [1752] = {.lex_state = 14},
  [1753] = {.lex_state = 14},
  [1754] = {.lex_state = 14},
  [1755] = {.lex_state = 14},
  [1756] = {.lex_state = 14},
  [1757] = {.lex_state = 14},
  [1758] = {.lex_state = 14},
  [1759] = {.lex_state = 14},
  [1760] = {.lex_state = 14},
  [1761] = {.lex_state = 14},
  [1762] = {.lex_state = 14},
  [1763] = {.lex_state = 14},
  [1764] = {.lex_state = 14},
  [1765] = {.lex_state = 14},
  [1766] = {.lex_state = 14},
  [1767] = {.lex_state = 15},
  [1768] = {.lex_state = 14},
  [1769] = {.lex_state = 14},
  [1770] = {.lex_state = 14},
  [1771] = {.lex_state = 14},
  [1772] = {.lex_state = 14},
  [1773] = {.lex_state = 14},
  [1774] = {.lex_state = 15},
  [1775] = {.lex_state = 15},
  [1776] = {.lex_state = 14},
  [1777] = {.lex_state = 15},
  [1778] = {.lex_state = 15},
  [1779] = {.lex_state = 15},
  [1780] = {.lex_state = 14},
  [1781] = {.lex_state = 14},
  [1782] = {.lex_state = 15},
  [1783] = {.lex_state = 15},
  [1784] = {.lex_state = 15},
  [1785] = {.lex_state = 15},
  [1786] = {.lex_state = 15},
  [1787] = {.lex_state = 15},
  [1788] = {.lex_state = 15},
  [1789] = {.lex_state = 15},
  [1790] = {.lex_state = 15},
  [1791] = {.lex_state = 15},
  [1792] = {.lex_state = 14},
  [1793] = {.lex_state = 15},
  [1794] = {.lex_state = 15},
  [1795] = {.lex_state = 15},
  [1796] = {.lex_state = 14},
  [1797] = {.lex_state = 15},
  [1798] = {.lex_state = 14},
  [1799] = {.lex_state = 14},
  [1800] = {.lex_state = 14},
  [1801] = {.lex_state = 15},
  [1802] = {.lex_state = 15},
  [1803] = {.lex_state = 15},
  [1804] = {.lex_state = 14},
  [1805] = {.lex_state = 14},
  [1806] = {.lex_state = 14},
  [1807] = {.lex_state = 15},
  [1808] = {.lex_state = 15},
  [1809] = {.lex_state = 14},
  [1810] = {.lex_state = 15},
  [1811] = {.lex_state = 15},
  [1812] = {.lex_state = 22, .external_lex_state = 2},
  [1813] = {.lex_state = 21},
  [1814] = {.lex_state = 21},
  [1815] = {.lex_state = 15},
  [1816] = {.lex_state = 15},
  [1817] = {.lex_state = 21},
  [1818] = {.lex_state = 21},
  [1819] = {.lex_state = 21},
  [1820] = {.lex_state = 21},
  [1821] = {.lex_state = 21},
  [1822] = {.lex_state = 22},
  [1823] = {.lex_state = 21},
  [1824] = {.lex_state = 21},
  [1825] = {.lex_state = 21},
  [1826] = {.lex_state = 21},
  [1827] = {.lex_state = 21},
  [1828] = {.lex_state = 21},
  [1829] = {.lex_state = 21},
  [1830] = {.lex_state = 21},
  [1831] = {.lex_state = 21},
  [1832] = {.lex_state = 21},
  [1833] = {.lex_state = 21},
  [1834] = {.lex_state = 21},
  [1835] = {.lex_state = 21},
  [1836] = {.lex_state = 21},
  [1837] = {.lex_state = 21},
  [1838] = {.lex_state = 21},
  [1839] = {.lex_state = 21},
  [1840] = {.lex_state = 21},
  [1841] = {.lex_state = 21},
  [1842] = {.lex_state = 21},
  [1843] = {.lex_state = 21},
  [1844] = {.lex_state = 21},
  [1845] = {.lex_state = 21},
  [1846] = {.lex_state = 21},
  [1847] = {.lex_state = 21},
  [1848] = {.lex_state = 21},
  [1849] = {.lex_state = 21},
  [1850] = {.lex_state = 21},
  [1851] = {.lex_state = 21},
  [1852] = {.lex_state = 21},
  [1853] = {.lex_state = 21},
  [1854] = {.lex_state = 21},
  [1855] = {.lex_state = 21},
  [1856] = {.lex_state = 21},
  [1857] = {.lex_state = 21},
  [1858] = {.lex_state = 21},
  [1859] = {.lex_state = 21},
  [1860] = {.lex_state = 21},
  [1861] = {.lex_state = 21},
  [1862] = {.lex_state = 21},
  [1863] = {.lex_state = 21},
  [1864] = {.lex_state = 21},
  [1865] = {.lex_state = 21},
  [1866] = {.lex_state = 21},
  [1867] = {.lex_state = 21},
  [1868] = {.lex_state = 21},
  [1869] = {.lex_state = 21},
  [1870] = {.lex_state = 21},
  [1871] = {.lex_state = 21},
  [1872] = {.lex_state = 21},
  [1873] = {.lex_state = 21},
  [1874] = {.lex_state = 21},
  [1875] = {.lex_state = 21},
  [1876] = {.lex_state = 21},
  [1877] = {.lex_state = 21},
  [1878] = {.lex_state = 21},
  [1879] = {.lex_state = 21},
  [1880] = {.lex_state = 21},
  [1881] = {.lex_state = 21},
  [1882] = {.lex_state = 21},
  [1883] = {.lex_state = 21},
  [1884] = {.lex_state = 21},
  [1885] = {.lex_state = 21},
  [1886] = {.lex_state = 21},
  [1887] = {.lex_state = 21},
  [1888] = {.lex_state = 21},
  [1889] = {.lex_state = 21},
  [1890] = {.lex_state = 21},
  [1891] = {.lex_state = 21},
  [1892] = {.lex_state = 21},
  [1893] = {.lex_state = 21},
  [1894] = {.lex_state = 21},
  [1895] = {.lex_state = 21},
  [1896] = {.lex_state = 21},
  [1897] = {.lex_state = 21},
  [1898] = {.lex_state = 21},
  [1899] = {.lex_state = 21},
  [1900] = {.lex_state = 21},
  [1901] = {.lex_state = 21},
  [1902] = {.lex_state = 21},
  [1903] = {.lex_state = 21},
  [1904] = {.lex_state = 21},
  [1905] = {.lex_state = 21},
  [1906] = {.lex_state = 21},
  [1907] = {.lex_state = 21},
  [1908] = {.lex_state = 21},
  [1909] = {.lex_state = 21},
  [1910] = {.lex_state = 21},
  [1911] = {.lex_state = 21},
  [1912] = {.lex_state = 21},
  [1913] = {.lex_state = 23},
  [1914] = {.lex_state = 23},
  [1915] = {.lex_state = 23},
  [1916] = {.lex_state = 23},
  [1917] = {.lex_state = 23},
  [1918] = {.lex_state = 23},
  [1919] = {.lex_state = 24, .external_lex_state = 2},
  [1920] = {.lex_state = 23},
  [1921] = {.lex_state = 23},
  [1922] = {.lex_state = 23},
  [1923] = {.lex_state = 23},
  [1924] = {.lex_state = 23},
  [1925] = {.lex_state = 23},
  [1926] = {.lex_state = 23},
  [1927] = {.lex_state = 24},
  [1928] = {.lex_state = 23},
  [1929] = {.lex_state = 23},
  [1930] = {.lex_state = 23},
  [1931] = {.lex_state = 23},
  [1932] = {.lex_state = 23},
  [1933] = {.lex_state = 23},
  [1934] = {.lex_state = 23},
  [1935] = {.lex_state = 23},
  [1936] = {.lex_state = 23},
  [1937] = {.lex_state = 23},
  [1938] = {.lex_state = 23},
  [1939] = {.lex_state = 23},
  [1940] = {.lex_state = 23},
  [1941] = {.lex_state = 23},
  [1942] = {.lex_state = 23},
  [1943] = {.lex_state = 23},
  [1944] = {.lex_state = 23},
  [1945] = {.lex_state = 23},
  [1946] = {.lex_state = 23},
  [1947] = {.lex_state = 23},
  [1948] = {.lex_state = 23},
  [1949] = {.lex_state = 23},
  [1950] = {.lex_state = 23},
  [1951] = {.lex_state = 23},
  [1952] = {.lex_state = 23},
  [1953] = {.lex_state = 23},
  [1954] = {.lex_state = 23},
  [1955] = {.lex_state = 23},
  [1956] = {.lex_state = 23},
  [1957] = {.lex_state = 23},
  [1958] = {.lex_state = 23},
  [1959] = {.lex_state = 23},
  [1960] = {.lex_state = 23},
  [1961] = {.lex_state = 23},
  [1962] = {.lex_state = 23},
  [1963] = {.lex_state = 23},
  [1964] = {.lex_state = 23},
  [1965] = {.lex_state = 23},
  [1966] = {.lex_state = 23},
  [1967] = {.lex_state = 23},
  [1968] = {.lex_state = 23},
  [1969] = {.lex_state = 23},
  [1970] = {.lex_state = 23},
  [1971] = {.lex_state = 23},
  [1972] = {.lex_state = 23},
  [1973] = {.lex_state = 23},
  [1974] = {.lex_state = 23},
  [1975] = {.lex_state = 23},
  [1976] = {.lex_state = 23},
  [1977] = {.lex_state = 23},
  [1978] = {.lex_state = 23},
  [1979] = {.lex_state = 23},
  [1980] = {.lex_state = 23},
  [1981] = {.lex_state = 23},
  [1982] = {.lex_state = 23},
  [1983] = {.lex_state = 23},
  [1984] = {.lex_state = 23},
  [1985] = {.lex_state = 23},
  [1986] = {.lex_state = 23},
  [1987] = {.lex_state = 23},
  [1988] = {.lex_state = 23},
  [1989] = {.lex_state = 23},
  [1990] = {.lex_state = 23},
  [1991] = {.lex_state = 23},
  [1992] = {.lex_state = 23},
  [1993] = {.lex_state = 23},
  [1994] = {.lex_state = 23},
  [1995] = {.lex_state = 23},
  [1996] = {.lex_state = 23},
  [1997] = {.lex_state = 23},
  [1998] = {.lex_state = 23},
  [1999] = {.lex_state = 23},
  [2000] = {.lex_state = 23},
  [2001] = {.lex_state = 23},
  [2002] = {.lex_state = 23},
  [2003] = {.lex_state = 23},
  [2004] = {.lex_state = 23},
  [2005] = {.lex_state = 23},
  [2006] = {.lex_state = 0},
  [2007] = {.lex_state = 0},
  [2008] = {.lex_state = 0},
  [2009] = {.lex_state = 0},
  [2010] = {.lex_state = 0},
  [2011] = {.lex_state = 0},
  [2012] = {.lex_state = 0},
  [2013] = {.lex_state = 26},
  [2014] = {.lex_state = 26},
  [2015] = {.lex_state = 26},
  [2016] = {.lex_state = 26},
  [2017] = {.lex_state = 26},
  [2018] = {.lex_state = 26},
  [2019] = {.lex_state = 26},
  [2020] = {.lex_state = 26},
  [2021] = {.lex_state = 26},
  [2022] = {.lex_state = 26},
  [2023] = {.lex_state = 26},
  [2024] = {.lex_state = 26},
  [2025] = {.lex_state = 26},
  [2026] = {.lex_state = 26},
  [2027] = {.lex_state = 26},
  [2028] = {.lex_state = 26},
  [2029] = {.lex_state = 26},
  [2030] = {.lex_state = 26},
  [2031] = {.lex_state = 26},
  [2032] = {.lex_state = 26},
  [2033] = {.lex_state = 26},
  [2034] = {.lex_state = 26},
  [2035] = {.lex_state = 26},
  [2036] = {.lex_state = 26},
  [2037] = {.lex_state = 26},
  [2038] = {.lex_state = 26},
  [2039] = {.lex_state = 26},
  [2040] = {.lex_state = 26},
  [2041] = {.lex_state = 26},
  [2042] = {.lex_state = 26},
  [2043] = {.lex_state = 26},
  [2044] = {.lex_state = 26},
  [2045] = {.lex_state = 26},
  [2046] = {.lex_state = 26},
  [2047] = {.lex_state = 26},
  [2048] = {.lex_state = 26},
  [2049] = {.lex_state = 26},
  [2050] = {.lex_state = 26},
  [2051] = {.lex_state = 26},
  [2052] = {.lex_state = 26},
  [2053] = {.lex_state = 26},
  [2054] = {.lex_state = 26},
  [2055] = {.lex_state = 26},
  [2056] = {.lex_state = 26},
  [2057] = {.lex_state = 26},
  [2058] = {.lex_state = 26},
  [2059] = {.lex_state = 26},
  [2060] = {.lex_state = 26},
  [2061] = {.lex_state = 0},
  [2062] = {.lex_state = 26},
  [2063] = {.lex_state = 26},
  [2064] = {.lex_state = 26},
  [2065] = {.lex_state = 29},
  [2066] = {.lex_state = 29},
  [2067] = {.lex_state = 29},
  [2068] = {.lex_state = 26},
  [2069] = {.lex_state = 27},
  [2070] = {.lex_state = 29},
  [2071] = {.lex_state = 27},
  [2072] = {.lex_state = 27},
  [2073] = {.lex_state = 27},
  [2074] = {.lex_state = 27},
  [2075] = {.lex_state = 26},
  [2076] = {.lex_state = 26},
  [2077] = {.lex_state = 27},
  [2078] = {.lex_state = 26},
  [2079] = {.lex_state = 29},
  [2080] = {.lex_state = 27},
  [2081] = {.lex_state = 29},
  [2082] = {.lex_state = 27},
  [2083] = {.lex_state = 26},
  [2084] = {.lex_state = 29},
  [2085] = {.lex_state = 27},
  [2086] = {.lex_state = 26},
  [2087] = {.lex_state = 29},
  [2088] = {.lex_state = 26},
  [2089] = {.lex_state = 27},
  [2090] = {.lex_state = 29},
  [2091] = {.lex_state = 26},
  [2092] = {.lex_state = 27},
  [2093] = {.lex_state = 27},
  [2094] = {.lex_state = 27},
  [2095] = {.lex_state = 27},
  [2096] = {.lex_state = 29},
  [2097] = {.lex_state = 27},
  [2098] = {.lex_state = 29},
  [2099] = {.lex_state = 27},
  [2100] = {.lex_state = 27},
  [2101] = {.lex_state = 27},
  [2102] = {.lex_state = 29},
  [2103] = {.lex_state = 29},
  [2104] = {.lex_state = 29},
  [2105] = {.lex_state = 26},
  [2106] = {.lex_state = 26},
  [2107] = {.lex_state = 27},
  [2108] = {.lex_state = 27},
  [2109] = {.lex_state = 0},
  [2110] = {.lex_state = 0},
  [2111] = {.lex_state = 0},
  [2112] = {.lex_state = 0},
  [2113] = {.lex_state = 0},
  [2114] = {.lex_state = 0},
  [2115] = {.lex_state = 0},
  [2116] = {.lex_state = 0},
  [2117] = {.lex_state = 0},
  [2118] = {.lex_state = 0},
  [2119] = {.lex_state = 0},
  [2120] = {.lex_state = 0},
  [2121] = {.lex_state = 0},
  [2122] = {.lex_state = 0},
  [2123] = {.lex_state = 0},
  [2124] = {.lex_state = 0},
  [2125] = {.lex_state = 0},
  [2126] = {.lex_state = 0},
  [2127] = {.lex_state = 0},
  [2128] = {.lex_state = 0},
  [2129] = {.lex_state = 0},
  [2130] = {.lex_state = 0},
  [2131] = {.lex_state = 0},
  [2132] = {.lex_state = 0},
  [2133] = {.lex_state = 0},
  [2134] = {.lex_state = 0},
  [2135] = {.lex_state = 0},
  [2136] = {.lex_state = 0},
  [2137] = {.lex_state = 0},
  [2138] = {.lex_state = 0},
  [2139] = {.lex_state = 0},
  [2140] = {.lex_state = 0},
  [2141] = {.lex_state = 0},
  [2142] = {.lex_state = 0},
  [2143] = {.lex_state = 0},
  [2144] = {.lex_state = 0},
  [2145] = {.lex_state = 0},
  [2146] = {.lex_state = 0},
  [2147] = {.lex_state = 0},
  [2148] = {.lex_state = 0},
  [2149] = {.lex_state = 0},
  [2150] = {.lex_state = 0},
  [2151] = {.lex_state = 0},
  [2152] = {.lex_state = 0},
  [2153] = {.lex_state = 0},
  [2154] = {.lex_state = 0},
  [2155] = {.lex_state = 0},
  [2156] = {.lex_state = 0},
  [2157] = {.lex_state = 0},
  [2158] = {.lex_state = 0},
  [2159] = {.lex_state = 0},
  [2160] = {.lex_state = 0},
  [2161] = {.lex_state = 0},
  [2162] = {.lex_state = 0},
  [2163] = {.lex_state = 0},
  [2164] = {.lex_state = 0},
  [2165] = {.lex_state = 0},
  [2166] = {.lex_state = 0},
  [2167] = {.lex_state = 0},
  [2168] = {.lex_state = 0},
  [2169] = {.lex_state = 0},
  [2170] = {.lex_state = 0},
  [2171] = {.lex_state = 0},
  [2172] = {.lex_state = 0},
  [2173] = {.lex_state = 0},
  [2174] = {.lex_state = 0},
  [2175] = {.lex_state = 0},
  [2176] = {.lex_state = 0},
  [2177] = {.lex_state = 0},
  [2178] = {.lex_state = 0},
  [2179] = {.lex_state = 0},
  [2180] = {.lex_state = 0},
  [2181] = {.lex_state = 0},
  [2182] = {.lex_state = 0},
  [2183] = {.lex_state = 0},
  [2184] = {.lex_state = 0},
  [2185] = {.lex_state = 0},
  [2186] = {.lex_state = 0},
  [2187] = {.lex_state = 0},
  [2188] = {.lex_state = 0},
  [2189] = {.lex_state = 0},
  [2190] = {.lex_state = 0},
  [2191] = {.lex_state = 0},
  [2192] = {.lex_state = 0},
  [2193] = {.lex_state = 0},
  [2194] = {.lex_state = 0},
  [2195] = {.lex_state = 0},
  [2196] = {.lex_state = 0},
  [2197] = {.lex_state = 0},
  [2198] = {.lex_state = 0},
  [2199] = {.lex_state = 0},
  [2200] = {.lex_state = 0},
  [2201] = {.lex_state = 0},
  [2202] = {.lex_state = 0},
  [2203] = {.lex_state = 0},
  [2204] = {.lex_state = 0},
  [2205] = {.lex_state = 0},
  [2206] = {.lex_state = 0},
  [2207] = {.lex_state = 0},
  [2208] = {.lex_state = 0},
  [2209] = {.lex_state = 0},
  [2210] = {.lex_state = 0},
  [2211] = {.lex_state = 0},
  [2212] = {.lex_state = 0},
  [2213] = {.lex_state = 0},
  [2214] = {.lex_state = 0},
  [2215] = {.lex_state = 0},
  [2216] = {.lex_state = 0},
  [2217] = {.lex_state = 0},
  [2218] = {.lex_state = 0},
  [2219] = {.lex_state = 0},
  [2220] = {.lex_state = 0},
  [2221] = {.lex_state = 0},
  [2222] = {.lex_state = 0},
  [2223] = {.lex_state = 0},
  [2224] = {.lex_state = 0},
  [2225] = {.lex_state = 0},
  [2226] = {.lex_state = 0},
  [2227] = {.lex_state = 0},
  [2228] = {.lex_state = 0},
  [2229] = {.lex_state = 0},
  [2230] = {.lex_state = 0},
  [2231] = {.lex_state = 0},
  [2232] = {.lex_state = 0},
  [2233] = {.lex_state = 0},
  [2234] = {.lex_state = 0},
  [2235] = {.lex_state = 0},
  [2236] = {.lex_state = 0},
  [2237] = {.lex_state = 0},
  [2238] = {.lex_state = 0},
  [2239] = {.lex_state = 0},
  [2240] = {.lex_state = 0},
  [2241] = {.lex_state = 0},
  [2242] = {.lex_state = 0},
  [2243] = {.lex_state = 0},
  [2244] = {.lex_state = 0},
  [2245] = {.lex_state = 0},
  [2246] = {.lex_state = 0},
  [2247] = {.lex_state = 0},
  [2248] = {.lex_state = 0},
  [2249] = {.lex_state = 0},
  [2250] = {.lex_state = 0},
  [2251] = {.lex_state = 0},
  [2252] = {.lex_state = 0},
  [2253] = {.lex_state = 0},
  [2254] = {.lex_state = 0},
  [2255] = {.lex_state = 0},
  [2256] = {.lex_state = 0},
  [2257] = {.lex_state = 0},
  [2258] = {.lex_state = 0},
  [2259] = {.lex_state = 0},
  [2260] = {.lex_state = 0},
  [2261] = {.lex_state = 0},
  [2262] = {.lex_state = 0},
  [2263] = {.lex_state = 0},
  [2264] = {.lex_state = 0},
  [2265] = {.lex_state = 0},
  [2266] = {.lex_state = 0},
  [2267] = {.lex_state = 0},
  [2268] = {.lex_state = 0},
  [2269] = {.lex_state = 0},
  [2270] = {.lex_state = 0},
  [2271] = {.lex_state = 0},
  [2272] = {.lex_state = 0},
  [2273] = {.lex_state = 0},
  [2274] = {.lex_state = 0},
  [2275] = {.lex_state = 0},
  [2276] = {.lex_state = 0},
  [2277] = {.lex_state = 0},
  [2278] = {.lex_state = 0},
  [2279] = {.lex_state = 0},
  [2280] = {.lex_state = 0},
  [2281] = {.lex_state = 0},
  [2282] = {.lex_state = 0},
  [2283] = {.lex_state = 0},
  [2284] = {.lex_state = 0},
  [2285] = {.lex_state = 0},
  [2286] = {.lex_state = 0},
  [2287] = {.lex_state = 0},
  [2288] = {.lex_state = 0},
  [2289] = {.lex_state = 0},
  [2290] = {.lex_state = 0},
  [2291] = {.lex_state = 0},
  [2292] = {.lex_state = 0},
  [2293] = {.lex_state = 0},
  [2294] = {.lex_state = 0},
  [2295] = {.lex_state = 0},
  [2296] = {.lex_state = 0},
  [2297] = {.lex_state = 0},
  [2298] = {.lex_state = 0},
  [2299] = {.lex_state = 0},
  [2300] = {.lex_state = 0},
  [2301] = {.lex_state = 0},
  [2302] = {.lex_state = 26},
  [2303] = {.lex_state = 26},
  [2304] = {.lex_state = 0},
  [2305] = {.lex_state = 0},
  [2306] = {.lex_state = 26},
  [2307] = {.lex_state = 28},
  [2308] = {.lex_state = 0},
  [2309] = {.lex_state = 0},
  [2310] = {.lex_state = 26},
  [2311] = {.lex_state = 0},
  [2312] = {.lex_state = 29},
  [2313] = {.lex_state = 26},
  [2314] = {.lex_state = 0},
  [2315] = {.lex_state = 0},
  [2316] = {.lex_state = 0},
  [2317] = {.lex_state = 0},
  [2318] = {.lex_state = 26},
  [2319] = {.lex_state = 0},
  [2320] = {.lex_state = 26},
  [2321] = {.lex_state = 28},
  [2322] = {.lex_state = 0},
  [2323] = {.lex_state = 0},
  [2324] = {.lex_state = 0},
  [2325] = {.lex_state = 26},
  [2326] = {.lex_state = 26},
  [2327] = {.lex_state = 0},
  [2328] = {.lex_state = 0},
  [2329] = {.lex_state = 28},
  [2330] = {.lex_state = 26},
  [2331] = {.lex_state = 0},
  [2332] = {.lex_state = 0},
  [2333] = {.lex_state = 26},
  [2334] = {.lex_state = 0},
  [2335] = {.lex_state = 0},
  [2336] = {.lex_state = 28},
  [2337] = {.lex_state = 0},
  [2338] = {.lex_state = 0},
  [2339] = {.lex_state = 0},
  [2340] = {.lex_state = 0},
  [2341] = {.lex_state = 29},
  [2342] = {.lex_state = 28},
  [2343] = {.lex_state = 26},
  [2344] = {.lex_state = 0},
  [2345] = {.lex_state = 0},
  [2346] = {.lex_state = 0},
  [2347] = {.lex_state = 26},
  [2348] = {.lex_state = 26},
  [2349] = {.lex_state = 0},
  [2350] = {.lex_state = 0},
  [2351] = {.lex_state = 0},
  [2352] = {.lex_state = 0},
  [2353] = {.lex_state = 26},
  [2354] = {.lex_state = 0},
  [2355] = {.lex_state = 0},
  [2356] = {.lex_state = 0},
  [2357] = {.lex_state = 0},
  [2358] = {.lex_state = 0},
  [2359] = {.lex_state = 0},
  [2360] = {.lex_state = 0},
  [2361] = {.lex_state = 0},
  [2362] = {.lex_state = 26},
  [2363] = {.lex_state = 0},
  [2364] = {.lex_state = 26},
  [2365] = {.lex_state = 0},
  [2366] = {.lex_state = 26},
  [2367] = {.lex_state = 28},
  [2368] = {.lex_state = 0},
  [2369] = {.lex_state = 0},
  [2370] = {.lex_state = 0},
  [2371] = {.lex_state = 0},
  [2372] = {.lex_state = 28},
  [2373] = {.lex_state = 26},
  [2374] = {.lex_state = 0},
  [2375] = {.lex_state = 0},
  [2376] = {.lex_state = 26},
  [2377] = {.lex_state = 26},
  [2378] = {.lex_state = 0},
  [2379] = {.lex_state = 26},
  [2380] = {.lex_state = 0},
  [2381] = {.lex_state = 26},
  [2382] = {.lex_state = 28},
  [2383] = {.lex_state = 0},
  [2384] = {.lex_state = 0},
  [2385] = {.lex_state = 26},
  [2386] = {.lex_state = 0},
  [2387] = {.lex_state = 0},
  [2388] = {.lex_state = 0},
  [2389] = {.lex_state = 26},
  [2390] = {.lex_state = 26},
  [2391] = {.lex_state = 0},
  [2392] = {.lex_state = 26},
  [2393] = {.lex_state = 0},
  [2394] = {.lex_state = 0},
  [2395] = {.lex_state = 0},
  [2396] = {.lex_state = 0},
  [2397] = {.lex_state = 26},
  [2398] = {.lex_state = 26},
  [2399] = {.lex_state = 0},
  [2400] = {.lex_state = 28},
  [2401] = {.lex_state = 0},
  [2402] = {.lex_state = 0},
  [2403] = {.lex_state = 0},
  [2404] = {.lex_state = 28},
  [2405] = {.lex_state = 26},
  [2406] = {.lex_state = 28},
  [2407] = {.lex_state = 0},
  [2408] = {.lex_state = 0},
  [2409] = {.lex_state = 0},
  [2410] = {.lex_state = 0},
  [2411] = {.lex_state = 26},
  [2412] = {.lex_state = 0},
  [2413] = {.lex_state = 0},
  [2414] = {.lex_state = 26},
  [2415] = {.lex_state = 0},
  [2416] = {.lex_state = 0},
  [2417] = {.lex_state = 0},
  [2418] = {.lex_state = 0},
  [2419] = {.lex_state = 0},
  [2420] = {.lex_state = 0},
  [2421] = {.lex_state = 0},
  [2422] = {.lex_state = 0},
  [2423] = {.lex_state = 0},
  [2424] = {.lex_state = 0},
  [2425] = {.lex_state = 0},
  [2426] = {.lex_state = 0},
  [2427] = {.lex_state = 0},
  [2428] = {.lex_state = 30},
  [2429] = {.lex_state = 0},
  [2430] = {.lex_state = 0},
  [2431] = {.lex_state = 0},
  [2432] = {.lex_state = 0},
  [2433] = {.lex_state = 0},
  [2434] = {.lex_state = 0},
  [2435] = {.lex_state = 0},
  [2436] = {.lex_state = 26},
  [2437] = {.lex_state = 0},
  [2438] = {.lex_state = 0},
  [2439] = {.lex_state = 0},
  [2440] = {.lex_state = 0},
  [2441] = {.lex_state = 0},
  [2442] = {.lex_state = 0},
  [2443] = {.lex_state = 0},
  [2444] = {.lex_state = 0},
  [2445] = {.lex_state = 0},
  [2446] = {.lex_state = 0},
  [2447] = {.lex_state = 0},
  [2448] = {.lex_state = 0},
  [2449] = {.lex_state = 0},
  [2450] = {.lex_state = 0},
  [2451] = {.lex_state = 0},
  [2452] = {.lex_state = 0},
  [2453] = {.lex_state = 0},
  [2454] = {.lex_state = 0},
  [2455] = {.lex_state = 0},
  [2456] = {.lex_state = 0},
  [2457] = {.lex_state = 0},
  [2458] = {.lex_state = 0},
  [2459] = {.lex_state = 0},
  [2460] = {.lex_state = 0},
  [2461] = {.lex_state = 0},
  [2462] = {.lex_state = 0},
  [2463] = {.lex_state = 0},
  [2464] = {.lex_state = 0},
  [2465] = {.lex_state = 0},
  [2466] = {.lex_state = 0},
  [2467] = {.lex_state = 0},
  [2468] = {.lex_state = 0},
  [2469] = {.lex_state = 0},
  [2470] = {.lex_state = 0},
  [2471] = {.lex_state = 0},
  [2472] = {.lex_state = 0},
  [2473] = {.lex_state = 0},
  [2474] = {.lex_state = 0},
  [2475] = {.lex_state = 0},
  [2476] = {.lex_state = 0},
  [2477] = {.lex_state = 0},
  [2478] = {.lex_state = 0},
  [2479] = {.lex_state = 0},
  [2480] = {.lex_state = 0},
  [2481] = {.lex_state = 0},
  [2482] = {.lex_state = 0},
  [2483] = {.lex_state = 0},
  [2484] = {.lex_state = 0},
  [2485] = {.lex_state = 0},
  [2486] = {.lex_state = 0},
  [2487] = {.lex_state = 0},
  [2488] = {.lex_state = 0},
  [2489] = {.lex_state = 0},
  [2490] = {.lex_state = 0},
  [2491] = {.lex_state = 0},
  [2492] = {.lex_state = 0},
  [2493] = {.lex_state = 0},
  [2494] = {.lex_state = 0},
  [2495] = {.lex_state = 0},
  [2496] = {.lex_state = 0},
  [2497] = {.lex_state = 0},
  [2498] = {.lex_state = 0},
  [2499] = {.lex_state = 0},
  [2500] = {.lex_state = 0},
  [2501] = {.lex_state = 0},
  [2502] = {.lex_state = 0},
  [2503] = {.lex_state = 30},
  [2504] = {.lex_state = 0},
  [2505] = {.lex_state = 0},
  [2506] = {.lex_state = 0},
  [2507] = {.lex_state = 0},
  [2508] = {.lex_state = 0},
  [2509] = {.lex_state = 0},
  [2510] = {.lex_state = 0},
  [2511] = {.lex_state = 0},
  [2512] = {.lex_state = 0},
  [2513] = {.lex_state = 0},
  [2514] = {.lex_state = 0},
  [2515] = {.lex_state = 0},
  [2516] = {.lex_state = 0},
  [2517] = {.lex_state = 26},
  [2518] = {.lex_state = 0},
  [2519] = {.lex_state = 0},
  [2520] = {.lex_state = 0},
  [2521] = {.lex_state = 0},
  [2522] = {.lex_state = 0},
  [2523] = {.lex_state = 0},
  [2524] = {.lex_state = 0},
  [2525] = {.lex_state = 0},
  [2526] = {.lex_state = 0},
  [2527] = {.lex_state = 0},
  [2528] = {.lex_state = 0},
  [2529] = {.lex_state = 0},
  [2530] = {.lex_state = 0},
  [2531] = {.lex_state = 0},
  [2532] = {.lex_state = 0},
  [2533] = {.lex_state = 0},
  [2534] = {.lex_state = 0},
  [2535] = {.lex_state = 0},
  [2536] = {.lex_state = 0},
  [2537] = {.lex_state = 0},
  [2538] = {.lex_state = 0},
  [2539] = {.lex_state = 0},
  [2540] = {.lex_state = 0},
  [2541] = {.lex_state = 0},
  [2542] = {.lex_state = 0},
  [2543] = {.lex_state = 0},
  [2544] = {.lex_state = 0},
  [2545] = {.lex_state = 0},
  [2546] = {.lex_state = 0},
  [2547] = {.lex_state = 0},
  [2548] = {.lex_state = 0},
  [2549] = {.lex_state = 0},
  [2550] = {.lex_state = 0},
  [2551] = {.lex_state = 0},
  [2552] = {.lex_state = 0},
  [2553] = {.lex_state = 0},
  [2554] = {.lex_state = 0},
  [2555] = {.lex_state = 0},
  [2556] = {.lex_state = 0},
  [2557] = {.lex_state = 0},
  [2558] = {.lex_state = 0},
  [2559] = {.lex_state = 0},
  [2560] = {.lex_state = 0},
  [2561] = {.lex_state = 0},
  [2562] = {.lex_state = 0},
  [2563] = {.lex_state = 0},
  [2564] = {.lex_state = 0},
  [2565] = {.lex_state = 0},
  [2566] = {.lex_state = 0},
  [2567] = {.lex_state = 0},
  [2568] = {.lex_state = 0},
  [2569] = {.lex_state = 0},
  [2570] = {.lex_state = 0},
  [2571] = {.lex_state = 0},
  [2572] = {.lex_state = 0},
  [2573] = {.lex_state = 0},
  [2574] = {.lex_state = 0},
  [2575] = {.lex_state = 0},
  [2576] = {.lex_state = 0},
  [2577] = {.lex_state = 0},
  [2578] = {.lex_state = 0},
  [2579] = {.lex_state = 0},
  [2580] = {.lex_state = 0},
  [2581] = {.lex_state = 0},
  [2582] = {.lex_state = 0},
  [2583] = {.lex_state = 0},
  [2584] = {.lex_state = 0},
  [2585] = {.lex_state = 0},
  [2586] = {.lex_state = 0},
  [2587] = {.lex_state = 0},
  [2588] = {.lex_state = 0},
  [2589] = {.lex_state = 0},
  [2590] = {.lex_state = 0},
  [2591] = {.lex_state = 0},
  [2592] = {.lex_state = 0},
  [2593] = {.lex_state = 0},
  [2594] = {.lex_state = 0},
  [2595] = {.lex_state = 0},
  [2596] = {.lex_state = 0},
  [2597] = {.lex_state = 0},
  [2598] = {.lex_state = 0},
  [2599] = {.lex_state = 0},
  [2600] = {.lex_state = 0},
  [2601] = {.lex_state = 0},
  [2602] = {.lex_state = 0},
  [2603] = {.lex_state = 0},
  [2604] = {.lex_state = 0},
  [2605] = {.lex_state = 0},
  [2606] = {.lex_state = 0},
  [2607] = {.lex_state = 0},
  [2608] = {.lex_state = 0},
  [2609] = {.lex_state = 0},
  [2610] = {.lex_state = 0},
  [2611] = {.lex_state = 0},
  [2612] = {.lex_state = 0},
  [2613] = {.lex_state = 0},
  [2614] = {.lex_state = 30},
  [2615] = {.lex_state = 0},
  [2616] = {.lex_state = 0},
  [2617] = {.lex_state = 0},
  [2618] = {.lex_state = 0},
  [2619] = {.lex_state = 0},
  [2620] = {.lex_state = 0},
  [2621] = {.lex_state = 0},
  [2622] = {.lex_state = 0},
  [2623] = {.lex_state = 0},
  [2624] = {.lex_state = 0},
  [2625] = {.lex_state = 0},
  [2626] = {.lex_state = 0},
  [2627] = {.lex_state = 0},
  [2628] = {.lex_state = 26},
  [2629] = {.lex_state = 0},
  [2630] = {.lex_state = 0},
  [2631] = {.lex_state = 0},
  [2632] = {.lex_state = 0},
  [2633] = {.lex_state = 0},
  [2634] = {.lex_state = 0},
  [2635] = {.lex_state = 0},
  [2636] = {.lex_state = 0},
  [2637] = {.lex_state = 0},
  [2638] = {.lex_state = 0},
  [2639] = {.lex_state = 0},
  [2640] = {.lex_state = 0},
  [2641] = {.lex_state = 0},
  [2642] = {.lex_state = 0},
  [2643] = {.lex_state = 0},
  [2644] = {.lex_state = 0},
  [2645] = {.lex_state = 0},
  [2646] = {.lex_state = 0},
  [2647] = {.lex_state = 0},
  [2648] = {.lex_state = 26},
  [2649] = {.lex_state = 0},
  [2650] = {.lex_state = 0},
  [2651] = {.lex_state = 0},
  [2652] = {.lex_state = 0},
  [2653] = {.lex_state = 0},
  [2654] = {.lex_state = 0},
  [2655] = {.lex_state = 0},
  [2656] = {.lex_state = 0},
  [2657] = {.lex_state = 0},
  [2658] = {.lex_state = 0},
  [2659] = {.lex_state = 0},
  [2660] = {.lex_state = 0},
  [2661] = {.lex_state = 0},
  [2662] = {.lex_state = 0},
  [2663] = {.lex_state = 0},
  [2664] = {.lex_state = 0},
  [2665] = {.lex_state = 0},
  [2666] = {.lex_state = 0},
  [2667] = {.lex_state = 0},
  [2668] = {.lex_state = 0},
  [2669] = {.lex_state = 0},
  [2670] = {.lex_state = 0},
  [2671] = {.lex_state = 0},
  [2672] = {.lex_state = 0},
  [2673] = {.lex_state = 0},
  [2674] = {.lex_state = 0},
  [2675] = {.lex_state = 0},
  [2676] = {.lex_state = 0},
  [2677] = {.lex_state = 0},
  [2678] = {.lex_state = 0},
  [2679] = {.lex_state = 0},
  [2680] = {.lex_state = 0},
  [2681] = {.lex_state = 30},
  [2682] = {.lex_state = 0},
  [2683] = {.lex_state = 0},
  [2684] = {.lex_state = 0},
  [2685] = {.lex_state = 0},
  [2686] = {.lex_state = 0},
  [2687] = {.lex_state = 0},
  [2688] = {.lex_state = 0},
  [2689] = {.lex_state = 0},
  [2690] = {.lex_state = 0},
  [2691] = {.lex_state = 0},
  [2692] = {.lex_state = 0},
  [2693] = {.lex_state = 0},
  [2694] = {.lex_state = 0},
  [2695] = {.lex_state = 0},
  [2696] = {.lex_state = 0},
  [2697] = {.lex_state = 0},
  [2698] = {.lex_state = 0},
  [2699] = {.lex_state = 0},
  [2700] = {.lex_state = 0},
  [2701] = {.lex_state = 0},
  [2702] = {.lex_state = 0},
  [2703] = {.lex_state = 0},
  [2704] = {.lex_state = 0},
  [2705] = {.lex_state = 0},
  [2706] = {.lex_state = 0},
  [2707] = {.lex_state = 0},
  [2708] = {.lex_state = 0},
  [2709] = {.lex_state = 0},
  [2710] = {.lex_state = 0},
  [2711] = {.lex_state = 0},
  [2712] = {.lex_state = 0},
  [2713] = {.lex_state = 0},
  [2714] = {.lex_state = 0},
  [2715] = {.lex_state = 0},
  [2716] = {.lex_state = 0},
  [2717] = {.lex_state = 0},
  [2718] = {.lex_state = 0},
  [2719] = {.lex_state = 0},
  [2720] = {.lex_state = 0},
  [2721] = {.lex_state = 30},
  [2722] = {.lex_state = 0},
  [2723] = {.lex_state = 0},
  [2724] = {.lex_state = 0},
  [2725] = {.lex_state = 0},
  [2726] = {.lex_state = 0},
  [2727] = {.lex_state = 0},
  [2728] = {.lex_state = 0},
  [2729] = {.lex_state = 0},
  [2730] = {.lex_state = 26},
  [2731] = {.lex_state = 30},
  [2732] = {.lex_state = 0},
  [2733] = {.lex_state = 0},
  [2734] = {.lex_state = 0},
  [2735] = {.lex_state = 26},
  [2736] = {.lex_state = 0},
  [2737] = {.lex_state = 0},
  [2738] = {.lex_state = 0},
  [2739] = {.lex_state = 0},
  [2740] = {.lex_state = 0},
  [2741] = {.lex_state = 0},
  [2742] = {.lex_state = 0},
  [2743] = {.lex_state = 0},
  [2744] = {.lex_state = 0},
  [2745] = {.lex_state = 0},
  [2746] = {.lex_state = 0},
  [2747] = {.lex_state = 0},
  [2748] = {.lex_state = 0},
  [2749] = {.lex_state = 0},
  [2750] = {.lex_state = 0},
  [2751] = {.lex_state = 0},
  [2752] = {.lex_state = 0},
  [2753] = {.lex_state = 0},
  [2754] = {.lex_state = 0},
  [2755] = {.lex_state = 0},
  [2756] = {.lex_state = 0},
  [2757] = {.lex_state = 0},
  [2758] = {.lex_state = 0},
  [2759] = {.lex_state = 0},
  [2760] = {.lex_state = 0},
  [2761] = {.lex_state = 0},
  [2762] = {.lex_state = 0},
  [2763] = {.lex_state = 0},
  [2764] = {.lex_state = 0},
  [2765] = {.lex_state = 0},
  [2766] = {.lex_state = 0},
  [2767] = {.lex_state = 0},
  [2768] = {.lex_state = 0},
  [2769] = {.lex_state = 0},
  [2770] = {.lex_state = 0},
  [2771] = {.lex_state = 0},
  [2772] = {.lex_state = 0},
  [2773] = {.lex_state = 0},
  [2774] = {.lex_state = 0},
  [2775] = {.lex_state = 0},
  [2776] = {.lex_state = 0},
  [2777] = {.lex_state = 0},
  [2778] = {.lex_state = 0},
  [2779] = {.lex_state = 0},
  [2780] = {.lex_state = 0},
  [2781] = {.lex_state = 0},
  [2782] = {.lex_state = 0},
  [2783] = {.lex_state = 0},
  [2784] = {.lex_state = 0},
  [2785] = {.lex_state = 0},
  [2786] = {.lex_state = 0},
  [2787] = {.lex_state = 0},
  [2788] = {.lex_state = 0},
  [2789] = {.lex_state = 0},
  [2790] = {.lex_state = 0},
  [2791] = {.lex_state = 0},
  [2792] = {.lex_state = 0},
  [2793] = {.lex_state = 0},
  [2794] = {.lex_state = 0},
  [2795] = {.lex_state = 0},
  [2796] = {.lex_state = 0},
  [2797] = {.lex_state = 0},
  [2798] = {.lex_state = 0},
  [2799] = {.lex_state = 0},
  [2800] = {.lex_state = 0},
  [2801] = {.lex_state = 0},
  [2802] = {.lex_state = 0},
  [2803] = {.lex_state = 0},
  [2804] = {.lex_state = 0},
  [2805] = {.lex_state = 0},
  [2806] = {.lex_state = 0},
  [2807] = {.lex_state = 0},
  [2808] = {.lex_state = 0},
  [2809] = {.lex_state = 30},
  [2810] = {.lex_state = 0},
  [2811] = {.lex_state = 0},
  [2812] = {.lex_state = 0},
  [2813] = {.lex_state = 0},
  [2814] = {.lex_state = 0},
  [2815] = {.lex_state = 0},
  [2816] = {.lex_state = 0},
  [2817] = {.lex_state = 0},
  [2818] = {.lex_state = 0},
  [2819] = {.lex_state = 26},
  [2820] = {.lex_state = 0},
  [2821] = {.lex_state = 0},
  [2822] = {.lex_state = 26},
  [2823] = {.lex_state = 26},
  [2824] = {.lex_state = 0},
  [2825] = {.lex_state = 0},
  [2826] = {.lex_state = 0},
  [2827] = {.lex_state = 0},
  [2828] = {.lex_state = 0},
  [2829] = {.lex_state = 0},
  [2830] = {.lex_state = 0},
  [2831] = {.lex_state = 0},
  [2832] = {.lex_state = 0},
  [2833] = {.lex_state = 0},
  [2834] = {.lex_state = 0},
  [2835] = {.lex_state = 0},
  [2836] = {.lex_state = 0},
  [2837] = {.lex_state = 0},
  [2838] = {.lex_state = 0},
  [2839] = {.lex_state = 0},
  [2840] = {.lex_state = 0},
  [2841] = {.lex_state = 0},
  [2842] = {.lex_state = 0},
  [2843] = {.lex_state = 0},
  [2844] = {.lex_state = 0},
  [2845] = {.lex_state = 0},
  [2846] = {.lex_state = 0},
  [2847] = {.lex_state = 0},
  [2848] = {.lex_state = 0},
  [2849] = {.lex_state = 30},
  [2850] = {.lex_state = 0},
  [2851] = {.lex_state = 0},
  [2852] = {.lex_state = 0},
  [2853] = {.lex_state = 0},
  [2854] = {.lex_state = 0},
  [2855] = {.lex_state = 0},
  [2856] = {.lex_state = 0},
  [2857] = {.lex_state = 0},
  [2858] = {.lex_state = 0},
  [2859] = {.lex_state = 0},
  [2860] = {.lex_state = 0},
  [2861] = {.lex_state = 0},
  [2862] = {.lex_state = 0},
  [2863] = {.lex_state = 0},
  [2864] = {.lex_state = 0},
  [2865] = {.lex_state = 0},
  [2866] = {.lex_state = 0},
  [2867] = {.lex_state = 0},
  [2868] = {.lex_state = 0},
  [2869] = {.lex_state = 0},
  [2870] = {.lex_state = 0},
  [2871] = {.lex_state = 0},
  [2872] = {.lex_state = 0},
  [2873] = {.lex_state = 0},
  [2874] = {.lex_state = 0},
  [2875] = {.lex_state = 0},
  [2876] = {.lex_state = 0},
  [2877] = {.lex_state = 0},
  [2878] = {.lex_state = 0},
  [2879] = {.lex_state = 0},
  [2880] = {.lex_state = 0},
  [2881] = {.lex_state = 0},
  [2882] = {.lex_state = 0},
  [2883] = {.lex_state = 0},
  [2884] = {.lex_state = 0},
  [2885] = {.lex_state = 0},
  [2886] = {.lex_state = 0},
  [2887] = {.lex_state = 0},
  [2888] = {.lex_state = 0},
  [2889] = {.lex_state = 0},
  [2890] = {.lex_state = 30},
  [2891] = {.lex_state = 0},
  [2892] = {.lex_state = 0},
  [2893] = {.lex_state = 0},
  [2894] = {.lex_state = 0},
  [2895] = {.lex_state = 0},
  [2896] = {.lex_state = 0},
  [2897] = {.lex_state = 0},
  [2898] = {.lex_state = 0},
  [2899] = {.lex_state = 0},
  [2900] = {.lex_state = 0},
  [2901] = {.lex_state = 0},
  [2902] = {.lex_state = 0},
  [2903] = {.lex_state = 0},
  [2904] = {.lex_state = 26},
  [2905] = {.lex_state = 0},
  [2906] = {.lex_state = 0},
  [2907] = {.lex_state = 0},
  [2908] = {.lex_state = 0},
  [2909] = {.lex_state = 0},
  [2910] = {.lex_state = 0},
  [2911] = {.lex_state = 0},
  [2912] = {.lex_state = 0},
  [2913] = {.lex_state = 0},
  [2914] = {.lex_state = 0},
  [2915] = {.lex_state = 0},
  [2916] = {.lex_state = 0},
  [2917] = {.lex_state = 0},
  [2918] = {.lex_state = 0},
  [2919] = {.lex_state = 0},
  [2920] = {.lex_state = 0},
  [2921] = {.lex_state = 0},
  [2922] = {.lex_state = 0},
  [2923] = {.lex_state = 0},
  [2924] = {.lex_state = 0},
  [2925] = {.lex_state = 0},
  [2926] = {.lex_state = 0},
  [2927] = {.lex_state = 0},
  [2928] = {.lex_state = 0},
  [2929] = {.lex_state = 0},
  [2930] = {.lex_state = 0},
  [2931] = {.lex_state = 0},
  [2932] = {.lex_state = 0},
  [2933] = {.lex_state = 0},
  [2934] = {.lex_state = 0},
  [2935] = {.lex_state = 0},
  [2936] = {.lex_state = 0},
  [2937] = {.lex_state = 0},
  [2938] = {.lex_state = 0},
  [2939] = {.lex_state = 0},
  [2940] = {.lex_state = 0},
  [2941] = {.lex_state = 0},
  [2942] = {.lex_state = 0},
  [2943] = {.lex_state = 0},
  [2944] = {.lex_state = 0},
  [2945] = {.lex_state = 0},
  [2946] = {.lex_state = 0},
  [2947] = {.lex_state = 0},
  [2948] = {.lex_state = 0},
  [2949] = {.lex_state = 0},
  [2950] = {.lex_state = 0},
  [2951] = {.lex_state = 0},
  [2952] = {.lex_state = 0},
  [2953] = {.lex_state = 0},
  [2954] = {.lex_state = 0},
  [2955] = {.lex_state = 0},
  [2956] = {.lex_state = 0},
  [2957] = {.lex_state = 0},
  [2958] = {.lex_state = 0},
  [2959] = {.lex_state = 0},
  [2960] = {.lex_state = 0},
  [2961] = {.lex_state = 0},
  [2962] = {.lex_state = 0},
  [2963] = {.lex_state = 0},
  [2964] = {.lex_state = 0},
  [2965] = {.lex_state = 0},
  [2966] = {.lex_state = 0},
  [2967] = {.lex_state = 0},
  [2968] = {.lex_state = 0},
  [2969] = {.lex_state = 0},
  [2970] = {.lex_state = 0},
  [2971] = {.lex_state = 0},
  [2972] = {.lex_state = 0},
  [2973] = {.lex_state = 0},
  [2974] = {.lex_state = 0},
  [2975] = {.lex_state = 0},
  [2976] = {.lex_state = 0},
  [2977] = {.lex_state = 0},
  [2978] = {.lex_state = 0},
  [2979] = {.lex_state = 0},
  [2980] = {.lex_state = 0},
  [2981] = {.lex_state = 0},
  [2982] = {.lex_state = 0},
  [2983] = {.lex_state = 0},
  [2984] = {.lex_state = 0},
  [2985] = {.lex_state = 0},
  [2986] = {.lex_state = 0},
  [2987] = {.lex_state = 0},
  [2988] = {.lex_state = 0},
  [2989] = {.lex_state = 0},
  [2990] = {.lex_state = 0},
  [2991] = {.lex_state = 0},
  [2992] = {.lex_state = 0},
  [2993] = {.lex_state = 0},
  [2994] = {.lex_state = 0},
  [2995] = {.lex_state = 0},
  [2996] = {.lex_state = 0},
  [2997] = {.lex_state = 0},
  [2998] = {.lex_state = 0},
  [2999] = {.lex_state = 0},
  [3000] = {.lex_state = 0},
  [3001] = {.lex_state = 0},
  [3002] = {.lex_state = 0},
  [3003] = {.lex_state = 0},
  [3004] = {.lex_state = 0},
  [3005] = {.lex_state = 0},
  [3006] = {.lex_state = 0},
  [3007] = {.lex_state = 0},
  [3008] = {.lex_state = 0},
  [3009] = {.lex_state = 0},
  [3010] = {.lex_state = 0},
  [3011] = {.lex_state = 0},
  [3012] = {.lex_state = 0},
  [3013] = {.lex_state = 0},
  [3014] = {.lex_state = 0},
  [3015] = {.lex_state = 0},
  [3016] = {.lex_state = 0},
  [3017] = {.lex_state = 0},
  [3018] = {.lex_state = 0},
  [3019] = {.lex_state = 0},
  [3020] = {.lex_state = 0},
  [3021] = {.lex_state = 0},
  [3022] = {.lex_state = 0},
  [3023] = {.lex_state = 0},
  [3024] = {.lex_state = 0},
  [3025] = {.lex_state = 0},
  [3026] = {.lex_state = 0},
  [3027] = {.lex_state = 0},
  [3028] = {.lex_state = 0},
  [3029] = {.lex_state = 0},
  [3030] = {.lex_state = 26},
  [3031] = {.lex_state = 0},
  [3032] = {.lex_state = 0},
  [3033] = {.lex_state = 0},
  [3034] = {.lex_state = 0},
  [3035] = {.lex_state = 0},
  [3036] = {.lex_state = 0},
  [3037] = {.lex_state = 0},
  [3038] = {.lex_state = 0},
  [3039] = {.lex_state = 0},
  [3040] = {.lex_state = 0},
  [3041] = {.lex_state = 0},
  [3042] = {.lex_state = 0},
  [3043] = {.lex_state = 0},
  [3044] = {.lex_state = 0},
  [3045] = {.lex_state = 0},
  [3046] = {.lex_state = 0},
  [3047] = {.lex_state = 0},
  [3048] = {.lex_state = 0},
  [3049] = {.lex_state = 0},
  [3050] = {.lex_state = 0},
  [3051] = {.lex_state = 0},
  [3052] = {.lex_state = 0},
  [3053] = {.lex_state = 0},
  [3054] = {.lex_state = 0},
  [3055] = {.lex_state = 0},
  [3056] = {.lex_state = 0},
  [3057] = {.lex_state = 0},
  [3058] = {.lex_state = 0},
  [3059] = {.lex_state = 0},
  [3060] = {.lex_state = 0},
  [3061] = {.lex_state = 0},
  [3062] = {.lex_state = 0},
  [3063] = {.lex_state = 0},
  [3064] = {.lex_state = 30},
  [3065] = {.lex_state = 0},
  [3066] = {.lex_state = 0},
  [3067] = {.lex_state = 0},
  [3068] = {.lex_state = 0},
  [3069] = {.lex_state = 0},
  [3070] = {.lex_state = 0},
  [3071] = {.lex_state = 0},
  [3072] = {.lex_state = 0},
  [3073] = {.lex_state = 0},
  [3074] = {.lex_state = 0},
  [3075] = {.lex_state = 0},
  [3076] = {.lex_state = 0},
  [3077] = {.lex_state = 0},
  [3078] = {.lex_state = 0},
  [3079] = {.lex_state = 0},
  [3080] = {.lex_state = 0},
  [3081] = {.lex_state = 26},
  [3082] = {.lex_state = 0},
  [3083] = {.lex_state = 0},
  [3084] = {.lex_state = 0},
  [3085] = {.lex_state = 0},
  [3086] = {.lex_state = 0},
  [3087] = {.lex_state = 0},
  [3088] = {.lex_state = 0},
  [3089] = {.lex_state = 0},
  [3090] = {.lex_state = 0},
  [3091] = {.lex_state = 0},
  [3092] = {.lex_state = 0},
  [3093] = {.lex_state = 0},
  [3094] = {.lex_state = 0},
  [3095] = {.lex_state = 0},
  [3096] = {.lex_state = 0},
  [3097] = {.lex_state = 0},
  [3098] = {.lex_state = 0},
  [3099] = {.lex_state = 0},
  [3100] = {.lex_state = 0},
  [3101] = {.lex_state = 0},
  [3102] = {.lex_state = 0},
  [3103] = {.lex_state = 0},
  [3104] = {.lex_state = 0},
  [3105] = {.lex_state = 0},
  [3106] = {.lex_state = 0},
  [3107] = {.lex_state = 0},
  [3108] = {.lex_state = 0},
  [3109] = {.lex_state = 0},
  [3110] = {.lex_state = 0},
  [3111] = {.lex_state = 0},
  [3112] = {.lex_state = 0},
  [3113] = {.lex_state = 0, .external_lex_state = 3},
  [3114] = {.lex_state = 26},
  [3115] = {.lex_state = 0, .external_lex_state = 4},
  [3116] = {.lex_state = 0, .external_lex_state = 3},
  [3117] = {.lex_state = 26},
  [3118] = {.lex_state = 0, .external_lex_state = 5},
  [3119] = {.lex_state = 0, .external_lex_state = 6},
  [3120] = {.lex_state = 0, .external_lex_state = 5},
  [3121] = {.lex_state = 0, .external_lex_state = 6},
  [3122] = {.lex_state = 0, .external_lex_state = 4},
  [3123] = {.lex_state = 0, .external_lex_state = 3},
  [3124] = {.lex_state = 0, .external_lex_state = 7},
  [3125] = {.lex_state = 0, .external_lex_state = 4},
  [3126] = {.lex_state = 30},
  [3127] = {.lex_state = 0, .external_lex_state = 3},
  [3128] = {.lex_state = 0, .external_lex_state = 7},
  [3129] = {.lex_state = 0, .external_lex_state = 7},
  [3130] = {.lex_state = 30},
  [3131] = {.lex_state = 26},
  [3132] = {.lex_state = 30},
  [3133] = {.lex_state = 0, .external_lex_state = 5},
  [3134] = {.lex_state = 0, .external_lex_state = 6},
  [3135] = {.lex_state = 0},
  [3136] = {.lex_state = 30},
  [3137] = {.lex_state = 0, .external_lex_state = 7},
  [3138] = {.lex_state = 0, .external_lex_state = 3},
  [3139] = {.lex_state = 0, .external_lex_state = 4},
  [3140] = {.lex_state = 0, .external_lex_state = 6},
  [3141] = {.lex_state = 0, .external_lex_state = 5},
  [3142] = {.lex_state = 26},
  [3143] = {.lex_state = 26},
  [3144] = {.lex_state = 26},
  [3145] = {.lex_state = 30},
  [3146] = {.lex_state = 0, .external_lex_state = 7},
  [3147] = {.lex_state = 26},
  [3148] = {.lex_state = 0, .external_lex_state = 3},
  [3149] = {.lex_state = 0, .external_lex_state = 4},
  [3150] = {.lex_state = 30},
  [3151] = {.lex_state = 0, .external_lex_state = 6},
  [3152] = {.lex_state = 0, .external_lex_state = 5},
  [3153] = {.lex_state = 26},
  [3154] = {.lex_state = 30},
  [3155] = {.lex_state = 0, .external_lex_state = 7},
  [3156] = {.lex_state = 0, .external_lex_state = 3},
  [3157] = {.lex_state = 0, .external_lex_state = 4},
  [3158] = {.lex_state = 0, .external_lex_state = 6},
  [3159] = {.lex_state = 0, .external_lex_state = 5},
  [3160] = {.lex_state = 26},
  [3161] = {.lex_state = 0},
  [3162] = {.lex_state = 0},
  [3163] = {.lex_state = 0, .external_lex_state = 5},
  [3164] = {.lex_state = 0, .external_lex_state = 6},
  [3165] = {.lex_state = 0, .external_lex_state = 4},
  [3166] = {.lex_state = 26},
  [3167] = {.lex_state = 26},
  [3168] = {.lex_state = 0},
  [3169] = {.lex_state = 0},
  [3170] = {.lex_state = 30},
  [3171] = {.lex_state = 0, .external_lex_state = 3},
  [3172] = {.lex_state = 0},
  [3173] = {.lex_state = 30},
  [3174] = {.lex_state = 0, .external_lex_state = 7},
  [3175] = {.lex_state = 0, .external_lex_state = 5},
  [3176] = {.lex_state = 0, .external_lex_state = 6},
  [3177] = {.lex_state = 0, .external_lex_state = 4},
  [3178] = {.lex_state = 26},
  [3179] = {.lex_state = 0, .external_lex_state = 7},
  [3180] = {.lex_state = 26},
  [3181] = {.lex_state = 0},
  [3182] = {.lex_state = 0},
  [3183] = {.lex_state = 0},
  [3184] = {.lex_state = 0},
  [3185] = {.lex_state = 26},
  [3186] = {.lex_state = 0},
  [3187] = {.lex_state = 26},
  [3188] = {.lex_state = 26},
  [3189] = {.lex_state = 26},
  [3190] = {.lex_state = 30},
  [3191] = {.lex_state = 0},
  [3192] = {.lex_state = 0},
  [3193] = {.lex_state = 0},
  [3194] = {.lex_state = 0},
  [3195] = {.lex_state = 0},
  [3196] = {.lex_state = 0},
  [3197] = {.lex_state = 0},
  [3198] = {.lex_state = 0},
  [3199] = {.lex_state = 26},
  [3200] = {.lex_state = 26},
  [3201] = {.lex_state = 0},
  [3202] = {.lex_state = 0},
  [3203] = {.lex_state = 0},
  [3204] = {.lex_state = 0},
  [3205] = {.lex_state = 0},
  [3206] = {.lex_state = 0},
  [3207] = {.lex_state = 0},
  [3208] = {.lex_state = 0},
  [3209] = {.lex_state = 0},
  [3210] = {.lex_state = 0},
  [3211] = {.lex_state = 0},
  [3212] = {.lex_state = 0},
  [3213] = {.lex_state = 0},
  [3214] = {.lex_state = 26},
  [3215] = {.lex_state = 0},
  [3216] = {.lex_state = 0},
  [3217] = {.lex_state = 0},
  [3218] = {.lex_state = 0},
  [3219] = {.lex_state = 0},
  [3220] = {.lex_state = 0},
  [3221] = {.lex_state = 26},
  [3222] = {.lex_state = 0},
  [3223] = {.lex_state = 0},
  [3224] = {.lex_state = 0},
  [3225] = {.lex_state = 0},
  [3226] = {.lex_state = 0},
  [3227] = {.lex_state = 0},
  [3228] = {.lex_state = 0},
  [3229] = {.lex_state = 0},
  [3230] = {.lex_state = 0},
  [3231] = {.lex_state = 0},
  [3232] = {.lex_state = 0},
  [3233] = {.lex_state = 0},
  [3234] = {.lex_state = 0},
  [3235] = {.lex_state = 26},
  [3236] = {.lex_state = 0, .external_lex_state = 3},
  [3237] = {.lex_state = 0},
  [3238] = {.lex_state = 0},
  [3239] = {.lex_state = 26},
  [3240] = {.lex_state = 0},
  [3241] = {.lex_state = 0},
  [3242] = {.lex_state = 0},
  [3243] = {.lex_state = 28},
  [3244] = {.lex_state = 26},
  [3245] = {.lex_state = 0},
  [3246] = {.lex_state = 0},
  [3247] = {.lex_state = 0},
  [3248] = {.lex_state = 0},
  [3249] = {.lex_state = 0},
  [3250] = {.lex_state = 0},
  [3251] = {.lex_state = 0},
  [3252] = {.lex_state = 0},
  [3253] = {.lex_state = 0},
  [3254] = {.lex_state = 0},
  [3255] = {.lex_state = 0},
  [3256] = {.lex_state = 26},
  [3257] = {.lex_state = 26},
  [3258] = {.lex_state = 0},
  [3259] = {.lex_state = 0},
  [3260] = {.lex_state = 0},
  [3261] = {.lex_state = 0},
  [3262] = {.lex_state = 0},
  [3263] = {.lex_state = 0},
  [3264] = {.lex_state = 0},
  [3265] = {.lex_state = 0},
  [3266] = {.lex_state = 0},
  [3267] = {.lex_state = 0},
  [3268] = {.lex_state = 0, .external_lex_state = 5},
  [3269] = {.lex_state = 0, .external_lex_state = 6},
  [3270] = {.lex_state = 0, .external_lex_state = 4},
  [3271] = {.lex_state = 0, .external_lex_state = 7},
  [3272] = {.lex_state = 26},
  [3273] = {.lex_state = 26},
  [3274] = {.lex_state = 30},
  [3275] = {.lex_state = 26},
  [3276] = {.lex_state = 0},
  [3277] = {.lex_state = 0},
  [3278] = {.lex_state = 0},
  [3279] = {.lex_state = 0},
  [3280] = {.lex_state = 0},
  [3281] = {.lex_state = 0},
  [3282] = {.lex_state = 0},
  [3283] = {.lex_state = 0},
  [3284] = {.lex_state = 0},
  [3285] = {.lex_state = 0},
  [3286] = {.lex_state = 0},
  [3287] = {.lex_state = 0, .external_lex_state = 3},
  [3288] = {.lex_state = 26},
  [3289] = {.lex_state = 0},
  [3290] = {.lex_state = 0},
  [3291] = {.lex_state = 0},
  [3292] = {.lex_state = 0},
  [3293] = {.lex_state = 0},
  [3294] = {.lex_state = 0},
  [3295] = {.lex_state = 0},
  [3296] = {.lex_state = 0},
  [3297] = {.lex_state = 0},
  [3298] = {.lex_state = 0},
  [3299] = {.lex_state = 0},
  [3300] = {.lex_state = 26},
};

enum {
  ts_external_token__trivia_raw_fi = 0,
  ts_external_token__trivia_raw_env_comment = 1,
  ts_external_token__trivia_raw_env_verbatim = 2,
  ts_external_token__trivia_raw_env_listing = 3,
  ts_external_token__trivia_raw_env_minted = 4,
  ts_external_token__trivia_raw_env_pycode = 5,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token__trivia_raw_fi] = sym__trivia_raw_fi,
  [ts_external_token__trivia_raw_env_comment] = sym__trivia_raw_env_comment,
  [ts_external_token__trivia_raw_env_verbatim] = sym__trivia_raw_env_verbatim,
  [ts_external_token__trivia_raw_env_listing] = sym__trivia_raw_env_listing,
  [ts_external_token__trivia_raw_env_minted] = sym__trivia_raw_env_minted,
  [ts_external_token__trivia_raw_env_pycode] = sym__trivia_raw_env_pycode,
};

static const bool ts_external_scanner_states[8][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token__trivia_raw_fi] = true,
    [ts_external_token__trivia_raw_env_comment] = true,
    [ts_external_token__trivia_raw_env_verbatim] = true,
    [ts_external_token__trivia_raw_env_listing] = true,
    [ts_external_token__trivia_raw_env_minted] = true,
    [ts_external_token__trivia_raw_env_pycode] = true,
  },
  [2] = {
    [ts_external_token__trivia_raw_fi] = true,
  },
  [3] = {
    [ts_external_token__trivia_raw_env_minted] = true,
  },
  [4] = {
    [ts_external_token__trivia_raw_env_listing] = true,
  },
  [5] = {
    [ts_external_token__trivia_raw_env_comment] = true,
  },
  [6] = {
    [ts_external_token__trivia_raw_env_verbatim] = true,
  },
  [7] = {
    [ts_external_token__trivia_raw_env_pycode] = true,
  },
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_command_name] = ACTIONS(1),
    [sym__whitespace] = ACTIONS(3),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_BSLASHiffalse] = ACTIONS(1),
    [anon_sym_BSLASHfi] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_BSLASHpart] = ACTIONS(1),
    [anon_sym_BSLASHpart_STAR] = ACTIONS(1),
    [anon_sym_BSLASHaddpart] = ACTIONS(1),
    [anon_sym_BSLASHaddpart_STAR] = ACTIONS(1),
    [anon_sym_BSLASHchapter] = ACTIONS(1),
    [anon_sym_BSLASHchapter_STAR] = ACTIONS(1),
    [anon_sym_BSLASHaddchap] = ACTIONS(1),
    [anon_sym_BSLASHaddchap_STAR] = ACTIONS(1),
    [anon_sym_BSLASHsection] = ACTIONS(1),
    [anon_sym_BSLASHsection_STAR] = ACTIONS(1),
    [anon_sym_BSLASHaddsec] = ACTIONS(1),
    [anon_sym_BSLASHaddsec_STAR] = ACTIONS(1),
    [anon_sym_BSLASHsubsection] = ACTIONS(1),
    [anon_sym_BSLASHsubsection_STAR] = ACTIONS(1),
    [anon_sym_BSLASHsubsubsection] = ACTIONS(1),
    [anon_sym_BSLASHsubsubsection_STAR] = ACTIONS(1),
    [anon_sym_BSLASHparagraph] = ACTIONS(1),
    [anon_sym_BSLASHparagraph_STAR] = ACTIONS(1),
    [anon_sym_BSLASHsubparagraph] = ACTIONS(1),
    [anon_sym_BSLASHsubparagraph_STAR] = ACTIONS(1),
    [anon_sym_BSLASHitem] = ACTIONS(1),
    [anon_sym_BSLASHitem_STAR] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_BSLASHand] = ACTIONS(1),
    [sym_word] = ACTIONS(1),
    [sym_placeholder] = ACTIONS(1),
    [sym_argc] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym__] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(1),
    [anon_sym_BSLASH_LBRACK] = ACTIONS(1),
    [anon_sym_BSLASH_RBRACK] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [anon_sym_BSLASH_LPAREN] = ACTIONS(1),
    [anon_sym_BSLASH_RPAREN] = ACTIONS(1),
    [anon_sym_BSLASHbegin] = ACTIONS(1),
    [anon_sym_BSLASHend] = ACTIONS(1),
    [anon_sym_comment] = ACTIONS(1),
    [anon_sym_verbatim] = ACTIONS(1),
    [anon_sym_lstlisting] = ACTIONS(1),
    [anon_sym_minted] = ACTIONS(1),
    [anon_sym_pycode] = ACTIONS(1),
    [anon_sym_displaymath] = ACTIONS(1),
    [anon_sym_displaymath_STAR] = ACTIONS(1),
    [anon_sym_equation] = ACTIONS(1),
    [anon_sym_equation_STAR] = ACTIONS(1),
    [anon_sym_multline] = ACTIONS(1),
    [anon_sym_multline_STAR] = ACTIONS(1),
    [anon_sym_eqnarray] = ACTIONS(1),
    [anon_sym_eqnarray_STAR] = ACTIONS(1),
    [anon_sym_align] = ACTIONS(1),
    [anon_sym_align_STAR] = ACTIONS(1),
    [anon_sym_array] = ACTIONS(1),
    [anon_sym_array_STAR] = ACTIONS(1),
    [anon_sym_split] = ACTIONS(1),
    [anon_sym_split_STAR] = ACTIONS(1),
    [anon_sym_alignat] = ACTIONS(1),
    [anon_sym_alignat_STAR] = ACTIONS(1),
    [anon_sym_gather] = ACTIONS(1),
    [anon_sym_gather_STAR] = ACTIONS(1),
    [anon_sym_flalign] = ACTIONS(1),
    [anon_sym_flalign_STAR] = ACTIONS(1),
    [anon_sym_BSLASHtitle] = ACTIONS(1),
    [anon_sym_BSLASHauthor] = ACTIONS(1),
    [anon_sym_BSLASHusepackage] = ACTIONS(1),
    [anon_sym_BSLASHRequirePackage] = ACTIONS(1),
    [anon_sym_BSLASHdocumentclass] = ACTIONS(1),
    [anon_sym_BSLASHinclude] = ACTIONS(1),
    [anon_sym_BSLASHsubfileinclude] = ACTIONS(1),
    [anon_sym_BSLASHinput] = ACTIONS(1),
    [anon_sym_BSLASHsubfile] = ACTIONS(1),
    [anon_sym_BSLASHaddbibresource] = ACTIONS(1),
    [anon_sym_BSLASHbibliography] = ACTIONS(1),
    [anon_sym_BSLASHincludegraphics] = ACTIONS(1),
    [anon_sym_BSLASHincludesvg] = ACTIONS(1),
    [anon_sym_BSLASHincludeinkscape] = ACTIONS(1),
    [anon_sym_BSLASHverbatiminput] = ACTIONS(1),
    [anon_sym_BSLASHVerbatimInput] = ACTIONS(1),
    [anon_sym_BSLASHimport] = ACTIONS(1),
    [anon_sym_BSLASHsubimport] = ACTIONS(1),
    [anon_sym_BSLASHinputfrom] = ACTIONS(1),
    [anon_sym_BSLASHsubimportfrom] = ACTIONS(1),
    [anon_sym_BSLASHincludefrom] = ACTIONS(1),
    [anon_sym_BSLASHsubincludefrom] = ACTIONS(1),
    [anon_sym_BSLASHcaption] = ACTIONS(1),
    [anon_sym_BSLASHcite] = ACTIONS(1),
    [anon_sym_BSLASHcite_STAR] = ACTIONS(1),
    [anon_sym_BSLASHCite] = ACTIONS(1),
    [anon_sym_BSLASHnocite] = ACTIONS(1),
    [anon_sym_BSLASHcitet] = ACTIONS(1),
    [anon_sym_BSLASHcitep] = ACTIONS(1),
    [anon_sym_BSLASHcitet_STAR] = ACTIONS(1),
    [anon_sym_BSLASHcitep_STAR] = ACTIONS(1),
    [anon_sym_BSLASHciteauthor] = ACTIONS(1),
    [anon_sym_BSLASHciteauthor_STAR] = ACTIONS(1),
    [anon_sym_BSLASHCiteauthor] = ACTIONS(1),
    [anon_sym_BSLASHCiteauthor_STAR] = ACTIONS(1),
    [anon_sym_BSLASHcitetitle] = ACTIONS(1),
    [anon_sym_BSLASHcitetitle_STAR] = ACTIONS(1),
    [anon_sym_BSLASHciteyear] = ACTIONS(1),
    [anon_sym_BSLASHciteyear_STAR] = ACTIONS(1),
    [anon_sym_BSLASHcitedate] = ACTIONS(1),
    [anon_sym_BSLASHcitedate_STAR] = ACTIONS(1),
    [anon_sym_BSLASHciteurl] = ACTIONS(1),
    [anon_sym_BSLASHfullcite] = ACTIONS(1),
    [anon_sym_BSLASHciteyearpar] = ACTIONS(1),
    [anon_sym_BSLASHcitealt] = ACTIONS(1),
    [anon_sym_BSLASHcitealp] = ACTIONS(1),
    [anon_sym_BSLASHcitetext] = ACTIONS(1),
    [anon_sym_BSLASHparencite] = ACTIONS(1),
    [anon_sym_BSLASHparencite_STAR] = ACTIONS(1),
    [anon_sym_BSLASHParencite] = ACTIONS(1),
    [anon_sym_BSLASHfootcite] = ACTIONS(1),
    [anon_sym_BSLASHfootfullcite] = ACTIONS(1),
    [anon_sym_BSLASHfootcitetext] = ACTIONS(1),
    [anon_sym_BSLASHtextcite] = ACTIONS(1),
    [anon_sym_BSLASHTextcite] = ACTIONS(1),
    [anon_sym_BSLASHsmartcite] = ACTIONS(1),
    [anon_sym_BSLASHSmartcite] = ACTIONS(1),
    [anon_sym_BSLASHsupercite] = ACTIONS(1),
    [anon_sym_BSLASHautocite] = ACTIONS(1),
    [anon_sym_BSLASHAutocite] = ACTIONS(1),
    [anon_sym_BSLASHautocite_STAR] = ACTIONS(1),
    [anon_sym_BSLASHAutocite_STAR] = ACTIONS(1),
    [anon_sym_BSLASHvolcite] = ACTIONS(1),
    [anon_sym_BSLASHVolcite] = ACTIONS(1),
    [anon_sym_BSLASHpvolcite] = ACTIONS(1),
    [anon_sym_BSLASHPvolcite] = ACTIONS(1),
    [anon_sym_BSLASHfvolcite] = ACTIONS(1),
    [anon_sym_BSLASHftvolcite] = ACTIONS(1),
    [anon_sym_BSLASHsvolcite] = ACTIONS(1),
    [anon_sym_BSLASHSvolcite] = ACTIONS(1),
    [anon_sym_BSLASHtvolcite] = ACTIONS(1),
    [anon_sym_BSLASHTvolcite] = ACTIONS(1),
    [anon_sym_BSLASHavolcite] = ACTIONS(1),
    [anon_sym_BSLASHAvolcite] = ACTIONS(1),
    [anon_sym_BSLASHnotecite] = ACTIONS(1),
    [anon_sym_BSLASHNotecite] = ACTIONS(1),
    [anon_sym_BSLASHpnotecite] = ACTIONS(1),
    [anon_sym_BSLASHPnotecite] = ACTIONS(1),
    [anon_sym_BSLASHfnotecite] = ACTIONS(1),
    [anon_sym_BSLASHlabel] = ACTIONS(1),
    [anon_sym_BSLASHref] = ACTIONS(1),
    [anon_sym_BSLASHeqref] = ACTIONS(1),
    [anon_sym_BSLASHvref] = ACTIONS(1),
    [anon_sym_BSLASHVref] = ACTIONS(1),
    [anon_sym_BSLASHautoref] = ACTIONS(1),
    [anon_sym_BSLASHpageref] = ACTIONS(1),
    [anon_sym_BSLASHcref] = ACTIONS(1),
    [anon_sym_BSLASHCref] = ACTIONS(1),
    [anon_sym_BSLASHcref_STAR] = ACTIONS(1),
    [anon_sym_BSLASHCref_STAR] = ACTIONS(1),
    [anon_sym_BSLASHnamecref] = ACTIONS(1),
    [anon_sym_BSLASHnameCref] = ACTIONS(1),
    [anon_sym_BSLASHlcnamecref] = ACTIONS(1),
    [anon_sym_BSLASHnamecrefs] = ACTIONS(1),
    [anon_sym_BSLASHnameCrefs] = ACTIONS(1),
    [anon_sym_BSLASHlcnamecrefs] = ACTIONS(1),
    [anon_sym_BSLASHlabelcref] = ACTIONS(1),
    [anon_sym_BSLASHlabelcpageref] = ACTIONS(1),
    [anon_sym_BSLASHcrefrange] = ACTIONS(1),
    [anon_sym_BSLASHcrefrange_STAR] = ACTIONS(1),
    [anon_sym_BSLASHCrefrange] = ACTIONS(1),
    [anon_sym_BSLASHCrefrange_STAR] = ACTIONS(1),
    [anon_sym_BSLASHnewlabel] = ACTIONS(1),
    [anon_sym_BSLASHnewcommand] = ACTIONS(1),
    [anon_sym_BSLASHnewcommand_STAR] = ACTIONS(1),
    [anon_sym_BSLASHrenewcommand] = ACTIONS(1),
    [anon_sym_BSLASHrenewcommand_STAR] = ACTIONS(1),
    [anon_sym_BSLASHDeclareRobustCommand] = ACTIONS(1),
    [anon_sym_BSLASHDeclareRobustCommand_STAR] = ACTIONS(1),
    [anon_sym_BSLASHDeclareMathOperator] = ACTIONS(1),
    [anon_sym_BSLASHDeclareMathOperator_STAR] = ACTIONS(1),
    [anon_sym_BSLASHNewDocumentCommand] = ACTIONS(1),
    [anon_sym_BSLASHRenewDocumentCommand] = ACTIONS(1),
    [anon_sym_BSLASHProvideDocumentCommand] = ACTIONS(1),
    [anon_sym_BSLASHDeclareDocumentCommand] = ACTIONS(1),
    [anon_sym_BSLASHNewExpandableDocumentCommand] = ACTIONS(1),
    [anon_sym_BSLASHRenewExpandableDocumentCommand] = ACTIONS(1),
    [anon_sym_BSLASHProvideExpandableDocumentCommand] = ACTIONS(1),
    [anon_sym_BSLASHDeclareExpandableDocumentCommand] = ACTIONS(1),
    [anon_sym_BSLASHdef] = ACTIONS(1),
    [anon_sym_BSLASHlet] = ACTIONS(1),
    [anon_sym_BSLASHleft] = ACTIONS(1),
    [anon_sym_BSLASHbig] = ACTIONS(1),
    [anon_sym_BSLASHBig] = ACTIONS(1),
    [anon_sym_BSLASHbigg] = ACTIONS(1),
    [anon_sym_BSLASHBigg] = ACTIONS(1),
    [anon_sym_BSLASHbigl] = ACTIONS(1),
    [anon_sym_BSLASHBigl] = ACTIONS(1),
    [anon_sym_BSLASHbiggl] = ACTIONS(1),
    [anon_sym_BSLASHBiggl] = ACTIONS(1),
    [anon_sym_BSLASHright] = ACTIONS(1),
    [anon_sym_BSLASHbigr] = ACTIONS(1),
    [anon_sym_BSLASHBigr] = ACTIONS(1),
    [anon_sym_BSLASHbiggr] = ACTIONS(1),
    [anon_sym_BSLASHBiggr] = ACTIONS(1),
    [anon_sym_BSLASHDeclarePairedDelimiter] = ACTIONS(1),
    [anon_sym_BSLASHDeclarePairedDelimiterX] = ACTIONS(1),
    [anon_sym_BSLASHnewenvironment] = ACTIONS(1),
    [anon_sym_BSLASHrenewenvironment] = ACTIONS(1),
    [anon_sym_BSLASHNewDocumentEnvironment] = ACTIONS(1),
    [anon_sym_BSLASHRenewDocumentEnvironment] = ACTIONS(1),
    [anon_sym_BSLASHProvideDocumentEnvironment] = ACTIONS(1),
    [anon_sym_BSLASHDeclareDocumentEnvironment] = ACTIONS(1),
    [anon_sym_BSLASHnewglossaryentry] = ACTIONS(1),
    [anon_sym_BSLASHgls] = ACTIONS(1),
    [anon_sym_BSLASHGls] = ACTIONS(1),
    [anon_sym_BSLASHGLS] = ACTIONS(1),
    [anon_sym_BSLASHglspl] = ACTIONS(1),
    [anon_sym_BSLASHGlspl] = ACTIONS(1),
    [anon_sym_BSLASHGLSpl] = ACTIONS(1),
    [anon_sym_BSLASHglsdisp] = ACTIONS(1),
    [anon_sym_BSLASHglslink] = ACTIONS(1),
    [anon_sym_BSLASHglstext] = ACTIONS(1),
    [anon_sym_BSLASHGlstext] = ACTIONS(1),
    [anon_sym_BSLASHGLStext] = ACTIONS(1),
    [anon_sym_BSLASHglsfirst] = ACTIONS(1),
    [anon_sym_BSLASHGlsfirst] = ACTIONS(1),
    [anon_sym_BSLASHGLSfirst] = ACTIONS(1),
    [anon_sym_BSLASHglsplural] = ACTIONS(1),
    [anon_sym_BSLASHGlsplural] = ACTIONS(1),
    [anon_sym_BSLASHGLSplural] = ACTIONS(1),
    [anon_sym_BSLASHglsfirstplural] = ACTIONS(1),
    [anon_sym_BSLASHGlsfirstplural] = ACTIONS(1),
    [anon_sym_BSLASHGLSfirstplural] = ACTIONS(1),
    [anon_sym_BSLASHglsname] = ACTIONS(1),
    [anon_sym_BSLASHGlsname] = ACTIONS(1),
    [anon_sym_BSLASHGLSname] = ACTIONS(1),
    [anon_sym_BSLASHglssymbol] = ACTIONS(1),
    [anon_sym_BSLASHGlssymbol] = ACTIONS(1),
    [anon_sym_BSLASHglsdesc] = ACTIONS(1),
    [anon_sym_BSLASHGlsdesc] = ACTIONS(1),
    [anon_sym_BSLASHGLSdesc] = ACTIONS(1),
    [anon_sym_BSLASHglsuseri] = ACTIONS(1),
    [anon_sym_BSLASHGlsuseri] = ACTIONS(1),
    [anon_sym_BSLASHGLSuseri] = ACTIONS(1),
    [anon_sym_BSLASHglsuserii] = ACTIONS(1),
    [anon_sym_BSLASHGlsuserii] = ACTIONS(1),
    [anon_sym_BSLASHGLSuserii] = ACTIONS(1),
    [anon_sym_BSLASHglsuseriii] = ACTIONS(1),
    [anon_sym_BSLASHGlsuseriii] = ACTIONS(1),
    [anon_sym_BSLASHGLSuseriii] = ACTIONS(1),
    [anon_sym_BSLASHglsuseriv] = ACTIONS(1),
    [anon_sym_BSLASHGlsuseriv] = ACTIONS(1),
    [anon_sym_BSLASHGLSuseriv] = ACTIONS(1),
    [anon_sym_BSLASHglsuserv] = ACTIONS(1),
    [anon_sym_BSLASHGlsuserv] = ACTIONS(1),
    [anon_sym_BSLASHGLSuserv] = ACTIONS(1),
    [anon_sym_BSLASHglsuservi] = ACTIONS(1),
    [anon_sym_BSLASHGlsuservi] = ACTIONS(1),
    [anon_sym_BSLASHGLSuservi] = ACTIONS(1),
    [anon_sym_BSLASHnewacronym] = ACTIONS(1),
    [anon_sym_BSLASHacrshort] = ACTIONS(1),
    [anon_sym_BSLASHAcrshort] = ACTIONS(1),
    [anon_sym_BSLASHACRshort] = ACTIONS(1),
    [anon_sym_BSLASHacrshortpl] = ACTIONS(1),
    [anon_sym_BSLASHAcrshortpl] = ACTIONS(1),
    [anon_sym_BSLASHACRshortpl] = ACTIONS(1),
    [anon_sym_BSLASHacrlong] = ACTIONS(1),
    [anon_sym_BSLASHAcrlong] = ACTIONS(1),
    [anon_sym_BSLASHACRlong] = ACTIONS(1),
    [anon_sym_BSLASHacrlongpl] = ACTIONS(1),
    [anon_sym_BSLASHAcrlongpl] = ACTIONS(1),
    [anon_sym_BSLASHACRlongpl] = ACTIONS(1),
    [anon_sym_BSLASHacrfull] = ACTIONS(1),
    [anon_sym_BSLASHAcrfull] = ACTIONS(1),
    [anon_sym_BSLASHACRfull] = ACTIONS(1),
    [anon_sym_BSLASHacrfullpl] = ACTIONS(1),
    [anon_sym_BSLASHAcrfullpl] = ACTIONS(1),
    [anon_sym_BSLASHACRfullpl] = ACTIONS(1),
    [anon_sym_BSLASHacs] = ACTIONS(1),
    [anon_sym_BSLASHAcs] = ACTIONS(1),
    [anon_sym_BSLASHacsp] = ACTIONS(1),
    [anon_sym_BSLASHAcsp] = ACTIONS(1),
    [anon_sym_BSLASHacl] = ACTIONS(1),
    [anon_sym_BSLASHAcl] = ACTIONS(1),
    [anon_sym_BSLASHaclp] = ACTIONS(1),
    [anon_sym_BSLASHAclp] = ACTIONS(1),
    [anon_sym_BSLASHacf] = ACTIONS(1),
    [anon_sym_BSLASHAcf] = ACTIONS(1),
    [anon_sym_BSLASHacfp] = ACTIONS(1),
    [anon_sym_BSLASHAcfp] = ACTIONS(1),
    [anon_sym_BSLASHac] = ACTIONS(1),
    [anon_sym_BSLASHAc] = ACTIONS(1),
    [anon_sym_BSLASHacp] = ACTIONS(1),
    [anon_sym_BSLASHglsentrylong] = ACTIONS(1),
    [anon_sym_BSLASHGlsentrylong] = ACTIONS(1),
    [anon_sym_BSLASHglsentrylongpl] = ACTIONS(1),
    [anon_sym_BSLASHGlsentrylongpl] = ACTIONS(1),
    [anon_sym_BSLASHglsentryshort] = ACTIONS(1),
    [anon_sym_BSLASHGlsentryshort] = ACTIONS(1),
    [anon_sym_BSLASHglsentryshortpl] = ACTIONS(1),
    [anon_sym_BSLASHGlsentryshortpl] = ACTIONS(1),
    [anon_sym_BSLASHglsentryfullpl] = ACTIONS(1),
    [anon_sym_BSLASHGlsentryfullpl] = ACTIONS(1),
    [anon_sym_BSLASHnewtheorem] = ACTIONS(1),
    [anon_sym_BSLASHnewtheorem_STAR] = ACTIONS(1),
    [anon_sym_BSLASHdeclaretheorem] = ACTIONS(1),
    [anon_sym_BSLASHdeclaretheorem_STAR] = ACTIONS(1),
    [anon_sym_BSLASHdefinecolor] = ACTIONS(1),
    [anon_sym_BSLASHdefinecolorset] = ACTIONS(1),
    [anon_sym_BSLASHcolor] = ACTIONS(1),
    [anon_sym_BSLASHcolorbox] = ACTIONS(1),
    [anon_sym_BSLASHtextcolor] = ACTIONS(1),
    [anon_sym_BSLASHpagecolor] = ACTIONS(1),
    [anon_sym_BSLASHusepgflibrary] = ACTIONS(1),
    [anon_sym_BSLASHusetikzlibrary] = ACTIONS(1),
    [anon_sym_BSLASHtext] = ACTIONS(1),
    [anon_sym_BSLASHintertext] = ACTIONS(1),
    [anon_sym_shortintertext] = ACTIONS(1),
    [sym__trivia_raw_fi] = ACTIONS(1),
    [sym__trivia_raw_env_comment] = ACTIONS(1),
    [sym__trivia_raw_env_verbatim] = ACTIONS(1),
    [sym__trivia_raw_env_listing] = ACTIONS(1),
    [sym__trivia_raw_env_minted] = ACTIONS(1),
    [sym__trivia_raw_env_pycode] = ACTIONS(1),
  },
  [1] = {
    [sym_source_file] = STATE(3162),
    [sym_block_comment] = STATE(95),
    [sym__root_content] = STATE(95),
    [sym__flat_content] = STATE(95),
    [sym__text_with_env_content] = STATE(95),
    [sym__text_content] = STATE(95),
    [sym__section] = STATE(95),
    [sym__part_declaration] = STATE(178),
    [sym_part] = STATE(613),
    [sym__chapter_declaration] = STATE(186),
    [sym_chapter] = STATE(612),
    [sym__section_declaration] = STATE(197),
    [sym_section] = STATE(611),
    [sym__subsection_declaration] = STATE(206),
    [sym_subsection] = STATE(610),
    [sym__subsubsection_declaration] = STATE(217),
    [sym_subsubsection] = STATE(609),
    [sym__paragraph_declaration] = STATE(227),
    [sym_paragraph] = STATE(608),
    [sym__subparagraph_declaration] = STATE(237),
    [sym_subparagraph] = STATE(607),
    [sym__enum_itemdeclaration] = STATE(249),
    [sym_enum_item] = STATE(606),
    [sym_curly_group] = STATE(95),
    [sym_text] = STATE(95),
    [sym_operator] = STATE(1019),
    [sym_subscript] = STATE(1019),
    [sym_superscript] = STATE(1019),
    [sym_displayed_equation] = STATE(95),
    [sym_inline_formula] = STATE(95),
    [sym_begin] = STATE(63),
    [sym_generic_environment] = STATE(95),
    [sym_comment_environment] = STATE(95),
    [sym__comment_environment_begin] = STATE(3163),
    [sym_verbatim_environment] = STATE(95),
    [sym__verbatim_environment_begin] = STATE(3164),
    [sym_listing_environment] = STATE(95),
    [sym__listing_environment_begin] = STATE(3165),
    [sym_minted_environment] = STATE(95),
    [sym__minted_environment_begin] = STATE(3171),
    [sym_pycode_environment] = STATE(95),
    [sym__pycode_environment_begin] = STATE(3174),
    [sym_math_environment] = STATE(95),
    [sym__math_environment_begin] = STATE(273),
    [sym__command] = STATE(95),
    [sym_generic_command] = STATE(95),
    [sym_title_declaration] = STATE(95),
    [sym_author_declaration] = STATE(95),
    [sym_package_include] = STATE(95),
    [sym_class_include] = STATE(95),
    [sym_latex_include] = STATE(95),
    [sym_biblatex_include] = STATE(95),
    [sym_bibtex_include] = STATE(95),
    [sym_graphics_include] = STATE(95),
    [sym_svg_include] = STATE(95),
    [sym_inkscape_include] = STATE(95),
    [sym_verbatim_include] = STATE(95),
    [sym_import_include] = STATE(95),
    [sym_caption] = STATE(95),
    [sym_citation] = STATE(95),
    [sym_label_definition] = STATE(95),
    [sym_label_reference] = STATE(95),
    [sym_label_reference_range] = STATE(95),
    [sym_label_number] = STATE(95),
    [sym_new_command_definition] = STATE(95),
    [sym_old_command_definition] = STATE(95),
    [sym_let_command_definition] = STATE(95),
    [sym_math_delimiter] = STATE(95),
    [sym_paired_delimiter_definition] = STATE(95),
    [sym_environment_definition] = STATE(95),
    [sym_glossary_entry_definition] = STATE(95),
    [sym_glossary_entry_reference] = STATE(95),
    [sym_acronym_definition] = STATE(95),
    [sym_acronym_reference] = STATE(95),
    [sym_theorem_definition] = STATE(95),
    [sym_color_definition] = STATE(95),
    [sym_color_set_definition] = STATE(95),
    [sym_color_reference] = STATE(95),
    [sym_tikz_library_import] = STATE(95),
    [sym_text_mode] = STATE(95),
    [aux_sym_source_file_repeat1] = STATE(95),
    [aux_sym__section_repeat1] = STATE(613),
    [aux_sym__section_repeat2] = STATE(612),
    [aux_sym__section_repeat3] = STATE(611),
    [aux_sym__section_repeat4] = STATE(610),
    [aux_sym__section_repeat5] = STATE(609),
    [aux_sym__section_repeat6] = STATE(608),
    [aux_sym__section_repeat7] = STATE(607),
    [aux_sym__section_repeat8] = STATE(606),
    [aux_sym_text_repeat1] = STATE(284),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_command_name] = ACTIONS(7),
    [sym__whitespace] = ACTIONS(3),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_BSLASHiffalse] = ACTIONS(9),
    [anon_sym_LBRACK] = ACTIONS(11),
    [anon_sym_RBRACK] = ACTIONS(11),
    [anon_sym_COMMA] = ACTIONS(11),
    [anon_sym_EQ] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(11),
    [anon_sym_RPAREN] = ACTIONS(11),
    [anon_sym_BSLASHpart] = ACTIONS(13),
    [anon_sym_BSLASHpart_STAR] = ACTIONS(15),
    [anon_sym_BSLASHaddpart] = ACTIONS(13),
    [anon_sym_BSLASHaddpart_STAR] = ACTIONS(15),
    [anon_sym_BSLASHchapter] = ACTIONS(17),
    [anon_sym_BSLASHchapter_STAR] = ACTIONS(19),
    [anon_sym_BSLASHaddchap] = ACTIONS(17),
    [anon_sym_BSLASHaddchap_STAR] = ACTIONS(19),
    [anon_sym_BSLASHsection] = ACTIONS(21),
    [anon_sym_BSLASHsection_STAR] = ACTIONS(23),
    [anon_sym_BSLASHaddsec] = ACTIONS(21),
    [anon_sym_BSLASHaddsec_STAR] = ACTIONS(23),
    [anon_sym_BSLASHsubsection] = ACTIONS(25),
    [anon_sym_BSLASHsubsection_STAR] = ACTIONS(27),
    [anon_sym_BSLASHsubsubsection] = ACTIONS(29),
    [anon_sym_BSLASHsubsubsection_STAR] = ACTIONS(31),
    [anon_sym_BSLASHparagraph] = ACTIONS(33),
    [anon_sym_BSLASHparagraph_STAR] = ACTIONS(35),
    [anon_sym_BSLASHsubparagraph] = ACTIONS(37),
    [anon_sym_BSLASHsubparagraph_STAR] = ACTIONS(39),
    [anon_sym_BSLASHitem] = ACTIONS(41),
    [anon_sym_BSLASHitem_STAR] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(45),
    [sym_word] = ACTIONS(47),
    [sym_placeholder] = ACTIONS(49),
    [anon_sym_PLUS] = ACTIONS(51),
    [anon_sym_DASH] = ACTIONS(51),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_SLASH] = ACTIONS(51),
    [anon_sym_LT] = ACTIONS(53),
    [anon_sym_GT] = ACTIONS(53),
    [anon_sym_BANG] = ACTIONS(53),
    [anon_sym_PIPE] = ACTIONS(53),
    [anon_sym_COLON] = ACTIONS(53),
    [anon_sym_SQUOTE] = ACTIONS(53),
    [anon_sym__] = ACTIONS(55),
    [anon_sym_CARET] = ACTIONS(57),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(59),
    [anon_sym_BSLASH_LBRACK] = ACTIONS(59),
    [anon_sym_DOLLAR] = ACTIONS(61),
    [anon_sym_BSLASH_LPAREN] = ACTIONS(63),
    [anon_sym_BSLASHbegin] = ACTIONS(65),
    [anon_sym_BSLASHtitle] = ACTIONS(67),
    [anon_sym_BSLASHauthor] = ACTIONS(69),
    [anon_sym_BSLASHusepackage] = ACTIONS(71),
    [anon_sym_BSLASHRequirePackage] = ACTIONS(71),
    [anon_sym_BSLASHdocumentclass] = ACTIONS(73),
    [anon_sym_BSLASHinclude] = ACTIONS(75),
    [anon_sym_BSLASHsubfileinclude] = ACTIONS(75),
    [anon_sym_BSLASHinput] = ACTIONS(75),
    [anon_sym_BSLASHsubfile] = ACTIONS(75),
    [anon_sym_BSLASHaddbibresource] = ACTIONS(77),
    [anon_sym_BSLASHbibliography] = ACTIONS(79),
    [anon_sym_BSLASHincludegraphics] = ACTIONS(81),
    [anon_sym_BSLASHincludesvg] = ACTIONS(83),
    [anon_sym_BSLASHincludeinkscape] = ACTIONS(85),
    [anon_sym_BSLASHverbatiminput] = ACTIONS(87),
    [anon_sym_BSLASHVerbatimInput] = ACTIONS(87),
    [anon_sym_BSLASHimport] = ACTIONS(89),
    [anon_sym_BSLASHsubimport] = ACTIONS(89),
    [anon_sym_BSLASHinputfrom] = ACTIONS(89),
    [anon_sym_BSLASHsubimportfrom] = ACTIONS(89),
    [anon_sym_BSLASHincludefrom] = ACTIONS(89),
    [anon_sym_BSLASHsubincludefrom] = ACTIONS(89),
    [anon_sym_BSLASHcaption] = ACTIONS(91),
    [anon_sym_BSLASHcite] = ACTIONS(93),
    [anon_sym_BSLASHcite_STAR] = ACTIONS(95),
    [anon_sym_BSLASHCite] = ACTIONS(93),
    [anon_sym_BSLASHnocite] = ACTIONS(93),
    [anon_sym_BSLASHcitet] = ACTIONS(93),
    [anon_sym_BSLASHcitep] = ACTIONS(93),
    [anon_sym_BSLASHcitet_STAR] = ACTIONS(95),
    [anon_sym_BSLASHcitep_STAR] = ACTIONS(95),
    [anon_sym_BSLASHciteauthor] = ACTIONS(93),
    [anon_sym_BSLASHciteauthor_STAR] = ACTIONS(95),
    [anon_sym_BSLASHCiteauthor] = ACTIONS(93),
    [anon_sym_BSLASHCiteauthor_STAR] = ACTIONS(95),
    [anon_sym_BSLASHcitetitle] = ACTIONS(93),
    [anon_sym_BSLASHcitetitle_STAR] = ACTIONS(95),
    [anon_sym_BSLASHciteyear] = ACTIONS(93),
    [anon_sym_BSLASHciteyear_STAR] = ACTIONS(95),
    [anon_sym_BSLASHcitedate] = ACTIONS(93),
    [anon_sym_BSLASHcitedate_STAR] = ACTIONS(95),
    [anon_sym_BSLASHciteurl] = ACTIONS(93),
    [anon_sym_BSLASHfullcite] = ACTIONS(93),
    [anon_sym_BSLASHciteyearpar] = ACTIONS(93),
    [anon_sym_BSLASHcitealt] = ACTIONS(93),
    [anon_sym_BSLASHcitealp] = ACTIONS(93),
    [anon_sym_BSLASHcitetext] = ACTIONS(93),
    [anon_sym_BSLASHparencite] = ACTIONS(93),
    [anon_sym_BSLASHparencite_STAR] = ACTIONS(95),
    [anon_sym_BSLASHParencite] = ACTIONS(93),
    [anon_sym_BSLASHfootcite] = ACTIONS(93),
    [anon_sym_BSLASHfootfullcite] = ACTIONS(93),
    [anon_sym_BSLASHfootcitetext] = ACTIONS(93),
    [anon_sym_BSLASHtextcite] = ACTIONS(93),
    [anon_sym_BSLASHTextcite] = ACTIONS(93),
    [anon_sym_BSLASHsmartcite] = ACTIONS(93),
    [anon_sym_BSLASHSmartcite] = ACTIONS(93),
    [anon_sym_BSLASHsupercite] = ACTIONS(93),
    [anon_sym_BSLASHautocite] = ACTIONS(93),
    [anon_sym_BSLASHAutocite] = ACTIONS(93),
    [anon_sym_BSLASHautocite_STAR] = ACTIONS(95),
    [anon_sym_BSLASHAutocite_STAR] = ACTIONS(95),
    [anon_sym_BSLASHvolcite] = ACTIONS(93),
    [anon_sym_BSLASHVolcite] = ACTIONS(93),
    [anon_sym_BSLASHpvolcite] = ACTIONS(93),
    [anon_sym_BSLASHPvolcite] = ACTIONS(93),
    [anon_sym_BSLASHfvolcite] = ACTIONS(93),
    [anon_sym_BSLASHftvolcite] = ACTIONS(93),
    [anon_sym_BSLASHsvolcite] = ACTIONS(93),
    [anon_sym_BSLASHSvolcite] = ACTIONS(93),
    [anon_sym_BSLASHtvolcite] = ACTIONS(93),
    [anon_sym_BSLASHTvolcite] = ACTIONS(93),
    [anon_sym_BSLASHavolcite] = ACTIONS(93),
    [anon_sym_BSLASHAvolcite] = ACTIONS(93),
    [anon_sym_BSLASHnotecite] = ACTIONS(93),
    [anon_sym_BSLASHNotecite] = ACTIONS(93),
    [anon_sym_BSLASHpnotecite] = ACTIONS(93),
    [anon_sym_BSLASHPnotecite] = ACTIONS(93),
    [anon_sym_BSLASHfnotecite] = ACTIONS(93),
    [anon_sym_BSLASHlabel] = ACTIONS(97),
    [anon_sym_BSLASHref] = ACTIONS(99),
    [anon_sym_BSLASHeqref] = ACTIONS(99),
    [anon_sym_BSLASHvref] = ACTIONS(99),
    [anon_sym_BSLASHVref] = ACTIONS(99),
    [anon_sym_BSLASHautoref] = ACTIONS(99),
    [anon_sym_BSLASHpageref] = ACTIONS(99),
    [anon_sym_BSLASHcref] = ACTIONS(99),
    [anon_sym_BSLASHCref] = ACTIONS(99),
    [anon_sym_BSLASHcref_STAR] = ACTIONS(101),
    [anon_sym_BSLASHCref_STAR] = ACTIONS(101),
    [anon_sym_BSLASHnamecref] = ACTIONS(99),
    [anon_sym_BSLASHnameCref] = ACTIONS(99),
    [anon_sym_BSLASHlcnamecref] = ACTIONS(99),
    [anon_sym_BSLASHnamecrefs] = ACTIONS(99),
    [anon_sym_BSLASHnameCrefs] = ACTIONS(99),
    [anon_sym_BSLASHlcnamecrefs] = ACTIONS(99),
    [anon_sym_BSLASHlabelcref] = ACTIONS(99),
    [anon_sym_BSLASHlabelcpageref] = ACTIONS(99),
    [anon_sym_BSLASHcrefrange] = ACTIONS(103),
    [anon_sym_BSLASHcrefrange_STAR] = ACTIONS(105),
    [anon_sym_BSLASHCrefrange] = ACTIONS(103),
    [anon_sym_BSLASHCrefrange_STAR] = ACTIONS(105),
    [anon_sym_BSLASHnewlabel] = ACTIONS(107),
    [anon_sym_BSLASHnewcommand] = ACTIONS(109),
    [anon_sym_BSLASHnewcommand_STAR] = ACTIONS(111),
    [anon_sym_BSLASHrenewcommand] = ACTIONS(109),
    [anon_sym_BSLASHrenewcommand_STAR] = ACTIONS(111),
    [anon_sym_BSLASHDeclareRobustCommand] = ACTIONS(109),
    [anon_sym_BSLASHDeclareRobustCommand_STAR] = ACTIONS(111),
    [anon_sym_BSLASHDeclareMathOperator] = ACTIONS(109),
    [anon_sym_BSLASHDeclareMathOperator_STAR] = ACTIONS(111),
    [anon_sym_BSLASHNewDocumentCommand] = ACTIONS(109),
    [anon_sym_BSLASHRenewDocumentCommand] = ACTIONS(109),
    [anon_sym_BSLASHProvideDocumentCommand] = ACTIONS(109),
    [anon_sym_BSLASHDeclareDocumentCommand] = ACTIONS(109),
    [anon_sym_BSLASHNewExpandableDocumentCommand] = ACTIONS(109),
    [anon_sym_BSLASHRenewExpandableDocumentCommand] = ACTIONS(109),
    [anon_sym_BSLASHProvideExpandableDocumentCommand] = ACTIONS(109),
    [anon_sym_BSLASHDeclareExpandableDocumentCommand] = ACTIONS(109),
    [anon_sym_BSLASHdef] = ACTIONS(113),
    [anon_sym_BSLASHlet] = ACTIONS(115),
    [anon_sym_BSLASHleft] = ACTIONS(117),
    [anon_sym_BSLASHbig] = ACTIONS(117),
    [anon_sym_BSLASHBig] = ACTIONS(117),
    [anon_sym_BSLASHbigg] = ACTIONS(117),
    [anon_sym_BSLASHBigg] = ACTIONS(117),
    [anon_sym_BSLASHbigl] = ACTIONS(117),
    [anon_sym_BSLASHBigl] = ACTIONS(117),
    [anon_sym_BSLASHbiggl] = ACTIONS(117),
    [anon_sym_BSLASHBiggl] = ACTIONS(117),
    [anon_sym_BSLASHDeclarePairedDelimiter] = ACTIONS(119),
    [anon_sym_BSLASHDeclarePairedDelimiterX] = ACTIONS(119),
    [anon_sym_BSLASHnewenvironment] = ACTIONS(121),
    [anon_sym_BSLASHrenewenvironment] = ACTIONS(121),
    [anon_sym_BSLASHNewDocumentEnvironment] = ACTIONS(121),
    [anon_sym_BSLASHRenewDocumentEnvironment] = ACTIONS(121),
    [anon_sym_BSLASHProvideDocumentEnvironment] = ACTIONS(121),
    [anon_sym_BSLASHDeclareDocumentEnvironment] = ACTIONS(121),
    [anon_sym_BSLASHnewglossaryentry] = ACTIONS(123),
    [anon_sym_BSLASHgls] = ACTIONS(125),
    [anon_sym_BSLASHGls] = ACTIONS(125),
    [anon_sym_BSLASHGLS] = ACTIONS(125),
    [anon_sym_BSLASHglspl] = ACTIONS(125),
    [anon_sym_BSLASHGlspl] = ACTIONS(125),
    [anon_sym_BSLASHGLSpl] = ACTIONS(125),
    [anon_sym_BSLASHglsdisp] = ACTIONS(125),
    [anon_sym_BSLASHglslink] = ACTIONS(125),
    [anon_sym_BSLASHglstext] = ACTIONS(125),
    [anon_sym_BSLASHGlstext] = ACTIONS(125),
    [anon_sym_BSLASHGLStext] = ACTIONS(125),
    [anon_sym_BSLASHglsfirst] = ACTIONS(125),
    [anon_sym_BSLASHGlsfirst] = ACTIONS(125),
    [anon_sym_BSLASHGLSfirst] = ACTIONS(125),
    [anon_sym_BSLASHglsplural] = ACTIONS(125),
    [anon_sym_BSLASHGlsplural] = ACTIONS(125),
    [anon_sym_BSLASHGLSplural] = ACTIONS(125),
    [anon_sym_BSLASHglsfirstplural] = ACTIONS(125),
    [anon_sym_BSLASHGlsfirstplural] = ACTIONS(125),
    [anon_sym_BSLASHGLSfirstplural] = ACTIONS(125),
    [anon_sym_BSLASHglsname] = ACTIONS(125),
    [anon_sym_BSLASHGlsname] = ACTIONS(125),
    [anon_sym_BSLASHGLSname] = ACTIONS(125),
    [anon_sym_BSLASHglssymbol] = ACTIONS(125),
    [anon_sym_BSLASHGlssymbol] = ACTIONS(125),
    [anon_sym_BSLASHglsdesc] = ACTIONS(125),
    [anon_sym_BSLASHGlsdesc] = ACTIONS(125),
    [anon_sym_BSLASHGLSdesc] = ACTIONS(125),
    [anon_sym_BSLASHglsuseri] = ACTIONS(125),
    [anon_sym_BSLASHGlsuseri] = ACTIONS(125),
    [anon_sym_BSLASHGLSuseri] = ACTIONS(125),
    [anon_sym_BSLASHglsuserii] = ACTIONS(125),
    [anon_sym_BSLASHGlsuserii] = ACTIONS(125),
    [anon_sym_BSLASHGLSuserii] = ACTIONS(125),
    [anon_sym_BSLASHglsuseriii] = ACTIONS(125),
    [anon_sym_BSLASHGlsuseriii] = ACTIONS(125),
    [anon_sym_BSLASHGLSuseriii] = ACTIONS(125),
    [anon_sym_BSLASHglsuseriv] = ACTIONS(125),
    [anon_sym_BSLASHGlsuseriv] = ACTIONS(125),
    [anon_sym_BSLASHGLSuseriv] = ACTIONS(125),
    [anon_sym_BSLASHglsuserv] = ACTIONS(125),
    [anon_sym_BSLASHGlsuserv] = ACTIONS(125),
    [anon_sym_BSLASHGLSuserv] = ACTIONS(125),
    [anon_sym_BSLASHglsuservi] = ACTIONS(125),
    [anon_sym_BSLASHGlsuservi] = ACTIONS(125),
    [anon_sym_BSLASHGLSuservi] = ACTIONS(125),
    [anon_sym_BSLASHnewacronym] = ACTIONS(127),
    [anon_sym_BSLASHacrshort] = ACTIONS(129),
    [anon_sym_BSLASHAcrshort] = ACTIONS(129),
    [anon_sym_BSLASHACRshort] = ACTIONS(129),
    [anon_sym_BSLASHacrshortpl] = ACTIONS(129),
    [anon_sym_BSLASHAcrshortpl] = ACTIONS(129),
    [anon_sym_BSLASHACRshortpl] = ACTIONS(129),
    [anon_sym_BSLASHacrlong] = ACTIONS(129),
    [anon_sym_BSLASHAcrlong] = ACTIONS(129),
    [anon_sym_BSLASHACRlong] = ACTIONS(129),
    [anon_sym_BSLASHacrlongpl] = ACTIONS(129),
    [anon_sym_BSLASHAcrlongpl] = ACTIONS(129),
    [anon_sym_BSLASHACRlongpl] = ACTIONS(129),
    [anon_sym_BSLASHacrfull] = ACTIONS(129),
    [anon_sym_BSLASHAcrfull] = ACTIONS(129),
    [anon_sym_BSLASHACRfull] = ACTIONS(129),
    [anon_sym_BSLASHacrfullpl] = ACTIONS(129),
    [anon_sym_BSLASHAcrfullpl] = ACTIONS(129),
    [anon_sym_BSLASHACRfullpl] = ACTIONS(129),
    [anon_sym_BSLASHacs] = ACTIONS(129),
    [anon_sym_BSLASHAcs] = ACTIONS(129),
    [anon_sym_BSLASHacsp] = ACTIONS(129),
    [anon_sym_BSLASHAcsp] = ACTIONS(129),
    [anon_sym_BSLASHacl] = ACTIONS(129),
    [anon_sym_BSLASHAcl] = ACTIONS(129),
    [anon_sym_BSLASHaclp] = ACTIONS(129),
    [anon_sym_BSLASHAclp] = ACTIONS(129),
    [anon_sym_BSLASHacf] = ACTIONS(129),
    [anon_sym_BSLASHAcf] = ACTIONS(129),
    [anon_sym_BSLASHacfp] = ACTIONS(129),
    [anon_sym_BSLASHAcfp] = ACTIONS(129),
    [anon_sym_BSLASHac] = ACTIONS(129),
    [anon_sym_BSLASHAc] = ACTIONS(129),
    [anon_sym_BSLASHacp] = ACTIONS(129),
    [anon_sym_BSLASHglsentrylong] = ACTIONS(129),
    [anon_sym_BSLASHGlsentrylong] = ACTIONS(129),
    [anon_sym_BSLASHglsentrylongpl] = ACTIONS(129),
    [anon_sym_BSLASHGlsentrylongpl] = ACTIONS(129),
    [anon_sym_BSLASHglsentryshort] = ACTIONS(129),
    [anon_sym_BSLASHGlsentryshort] = ACTIONS(129),
    [anon_sym_BSLASHglsentryshortpl] = ACTIONS(129),
    [anon_sym_BSLASHGlsentryshortpl] = ACTIONS(129),
    [anon_sym_BSLASHglsentryfullpl] = ACTIONS(129),
    [anon_sym_BSLASHGlsentryfullpl] = ACTIONS(129),
    [anon_sym_BSLASHnewtheorem] = ACTIONS(131),
    [anon_sym_BSLASHnewtheorem_STAR] = ACTIONS(133),
    [anon_sym_BSLASHdeclaretheorem] = ACTIONS(131),
    [anon_sym_BSLASHdeclaretheorem_STAR] = ACTIONS(133),
    [anon_sym_BSLASHdefinecolor] = ACTIONS(135),
    [anon_sym_BSLASHdefinecolorset] = ACTIONS(137),
    [anon_sym_BSLASHcolor] = ACTIONS(139),
    [anon_sym_BSLASHcolorbox] = ACTIONS(139),
    [anon_sym_BSLASHtextcolor] = ACTIONS(139),
    [anon_sym_BSLASHpagecolor] = ACTIONS(139),
    [anon_sym_BSLASHusepgflibrary] = ACTIONS(141),
    [anon_sym_BSLASHusetikzlibrary] = ACTIONS(141),
    [anon_sym_BSLASHtext] = ACTIONS(143),
    [anon_sym_BSLASHintertext] = ACTIONS(143),
    [anon_sym_shortintertext] = ACTIONS(143),
  },
  [2] = {
    [sym_block_comment] = STATE(27),
    [sym__root_content] = STATE(27),
    [sym__flat_content] = STATE(27),
    [sym__text_with_env_content] = STATE(27),
    [sym__text_content] = STATE(27),
    [sym__section] = STATE(27),
    [sym__part_declaration] = STATE(175),
    [sym_part] = STATE(367),
    [sym__chapter_declaration] = STATE(177),
    [sym_chapter] = STATE(368),
    [sym__section_declaration] = STATE(187),
    [sym_section] = STATE(369),
    [sym__subsection_declaration] = STATE(196),
    [sym_subsection] = STATE(370),
    [sym__subsubsection_declaration] = STATE(207),
    [sym_subsubsection] = STATE(371),
    [sym__paragraph_declaration] = STATE(218),
    [sym_paragraph] = STATE(373),
    [sym__subparagraph_declaration] = STATE(228),
    [sym_subparagraph] = STATE(374),
    [sym__enum_itemdeclaration] = STATE(238),
    [sym_enum_item] = STATE(375),
    [sym_curly_group] = STATE(27),
    [sym_text] = STATE(27),
    [sym_operator] = STATE(484),
    [sym_subscript] = STATE(484),
    [sym_superscript] = STATE(484),
    [sym_displayed_equation] = STATE(27),
    [sym_inline_formula] = STATE(27),
    [sym_begin] = STATE(65),
    [sym_generic_environment] = STATE(27),
    [sym_comment_environment] = STATE(27),
    [sym__comment_environment_begin] = STATE(3120),
    [sym_verbatim_environment] = STATE(27),
    [sym__verbatim_environment_begin] = STATE(3121),
    [sym_listing_environment] = STATE(27),
    [sym__listing_environment_begin] = STATE(3122),
    [sym_minted_environment] = STATE(27),
    [sym__minted_environment_begin] = STATE(3123),
    [sym_pycode_environment] = STATE(27),
    [sym__pycode_environment_begin] = STATE(3124),
    [sym_math_environment] = STATE(27),
    [sym__math_environment_begin] = STATE(269),
    [sym__command] = STATE(27),
    [sym_generic_command] = STATE(27),
    [sym_title_declaration] = STATE(27),
    [sym_author_declaration] = STATE(27),
    [sym_package_include] = STATE(27),
    [sym_class_include] = STATE(27),
    [sym_latex_include] = STATE(27),
    [sym_biblatex_include] = STATE(27),
    [sym_bibtex_include] = STATE(27),
    [sym_graphics_include] = STATE(27),
    [sym_svg_include] = STATE(27),
    [sym_inkscape_include] = STATE(27),
    [sym_verbatim_include] = STATE(27),
    [sym_import_include] = STATE(27),
    [sym_caption] = STATE(27),
    [sym_citation] = STATE(27),
    [sym_label_definition] = STATE(27),
    [sym_label_reference] = STATE(27),
    [sym_label_reference_range] = STATE(27),
    [sym_label_number] = STATE(27),
    [sym_new_command_definition] = STATE(27),
    [sym_old_command_definition] = STATE(27),
    [sym_let_command_definition] = STATE(27),
    [sym_math_delimiter] = STATE(27),
    [sym_paired_delimiter_definition] = STATE(27),
    [sym_environment_definition] = STATE(27),
    [sym_glossary_entry_definition] = STATE(27),
    [sym_glossary_entry_reference] = STATE(27),
    [sym_acronym_definition] = STATE(27),
    [sym_acronym_reference] = STATE(27),
    [sym_theorem_definition] = STATE(27),
    [sym_color_definition] = STATE(27),
    [sym_color_set_definition] = STATE(27),
    [sym_color_reference] = STATE(27),
    [sym_tikz_library_import] = STATE(27),
    [sym_text_mode] = STATE(27),
    [aux_sym_source_file_repeat1] = STATE(27),
    [aux_sym__section_repeat1] = STATE(367),
    [aux_sym__section_repeat2] = STATE(368),
    [aux_sym__section_repeat3] = STATE(369),
    [aux_sym__section_repeat4] = STATE(370),
    [aux_sym__section_repeat5] = STATE(371),
    [aux_sym__section_repeat6] = STATE(373),
    [aux_sym__section_repeat7] = STATE(374),
    [aux_sym__section_repeat8] = STATE(375),
    [aux_sym_text_repeat1] = STATE(259),
    [sym_command_name] = ACTIONS(145),
    [sym__whitespace] = ACTIONS(3),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_BSLASHiffalse] = ACTIONS(145),
    [anon_sym_LBRACK] = ACTIONS(147),
    [anon_sym_RBRACK] = ACTIONS(147),
    [anon_sym_COMMA] = ACTIONS(147),
    [anon_sym_EQ] = ACTIONS(147),
    [anon_sym_LPAREN] = ACTIONS(149),
    [anon_sym_RPAREN] = ACTIONS(149),
    [anon_sym_BSLASHpart] = ACTIONS(151),
    [anon_sym_BSLASHpart_STAR] = ACTIONS(153),
    [anon_sym_BSLASHaddpart] = ACTIONS(151),
    [anon_sym_BSLASHaddpart_STAR] = ACTIONS(153),
    [anon_sym_BSLASHchapter] = ACTIONS(155),
    [anon_sym_BSLASHchapter_STAR] = ACTIONS(157),
    [anon_sym_BSLASHaddchap] = ACTIONS(155),
    [anon_sym_BSLASHaddchap_STAR] = ACTIONS(157),
    [anon_sym_BSLASHsection] = ACTIONS(159),
    [anon_sym_BSLASHsection_STAR] = ACTIONS(161),
    [anon_sym_BSLASHaddsec] = ACTIONS(159),
    [anon_sym_BSLASHaddsec_STAR] = ACTIONS(161),
    [anon_sym_BSLASHsubsection] = ACTIONS(163),
    [anon_sym_BSLASHsubsection_STAR] = ACTIONS(165),
    [anon_sym_BSLASHsubsubsection] = ACTIONS(167),
    [anon_sym_BSLASHsubsubsection_STAR] = ACTIONS(169),
    [anon_sym_BSLASHparagraph] = ACTIONS(171),
    [anon_sym_BSLASHparagraph_STAR] = ACTIONS(173),
    [anon_sym_BSLASHsubparagraph] = ACTIONS(175),
    [anon_sym_BSLASHsubparagraph_STAR] = ACTIONS(177),
    [anon_sym_BSLASHitem] = ACTIONS(179),
    [anon_sym_BSLASHitem_STAR] = ACTIONS(181),
    [anon_sym_LBRACE] = ACTIONS(149),
    [anon_sym_RBRACE] = ACTIONS(149),
    [anon_sym_BSLASHand] = ACTIONS(145),
    [sym_word] = ACTIONS(145),
    [sym_placeholder] = ACTIONS(149),
    [anon_sym_PLUS] = ACTIONS(149),
    [anon_sym_DASH] = ACTIONS(149),
    [anon_sym_STAR] = ACTIONS(149),
    [anon_sym_SLASH] = ACTIONS(149),
    [anon_sym_LT] = ACTIONS(145),
    [anon_sym_GT] = ACTIONS(145),
    [anon_sym_BANG] = ACTIONS(145),
    [anon_sym_PIPE] = ACTIONS(145),
    [anon_sym_COLON] = ACTIONS(145),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [anon_sym__] = ACTIONS(149),
    [anon_sym_CARET] = ACTIONS(149),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(149),
    [anon_sym_BSLASH_LBRACK] = ACTIONS(149),
    [anon_sym_DOLLAR] = ACTIONS(145),
    [anon_sym_BSLASH_LPAREN] = ACTIONS(149),
    [anon_sym_BSLASHbegin] = ACTIONS(65),
    [anon_sym_BSLASHtitle] = ACTIONS(145),
    [anon_sym_BSLASHauthor] = ACTIONS(145),
    [anon_sym_BSLASHusepackage] = ACTIONS(145),
    [anon_sym_BSLASHRequirePackage] = ACTIONS(145),
    [anon_sym_BSLASHdocumentclass] = ACTIONS(145),
    [anon_sym_BSLASHinclude] = ACTIONS(145),
    [anon_sym_BSLASHsubfileinclude] = ACTIONS(145),
    [anon_sym_BSLASHinput] = ACTIONS(145),
    [anon_sym_BSLASHsubfile] = ACTIONS(145),
    [anon_sym_BSLASHaddbibresource] = ACTIONS(145),
    [anon_sym_BSLASHbibliography] = ACTIONS(145),
    [anon_sym_BSLASHincludegraphics] = ACTIONS(145),
    [anon_sym_BSLASHincludesvg] = ACTIONS(145),
    [anon_sym_BSLASHincludeinkscape] = ACTIONS(145),
    [anon_sym_BSLASHverbatiminput] = ACTIONS(145),
    [anon_sym_BSLASHVerbatimInput] = ACTIONS(145),
    [anon_sym_BSLASHimport] = ACTIONS(145),
    [anon_sym_BSLASHsubimport] = ACTIONS(145),
    [anon_sym_BSLASHinputfrom] = ACTIONS(145),
    [anon_sym_BSLASHsubimportfrom] = ACTIONS(145),
    [anon_sym_BSLASHincludefrom] = ACTIONS(145),
    [anon_sym_BSLASHsubincludefrom] = ACTIONS(145),
    [anon_sym_BSLASHcaption] = ACTIONS(145),
    [anon_sym_BSLASHcite] = ACTIONS(145),
    [anon_sym_BSLASHcite_STAR] = ACTIONS(149),
    [anon_sym_BSLASHCite] = ACTIONS(145),
    [anon_sym_BSLASHnocite] = ACTIONS(145),
    [anon_sym_BSLASHcitet] = ACTIONS(145),
    [anon_sym_BSLASHcitep] = ACTIONS(145),
    [anon_sym_BSLASHcitet_STAR] = ACTIONS(149),
    [anon_sym_BSLASHcitep_STAR] = ACTIONS(149),
    [anon_sym_BSLASHciteauthor] = ACTIONS(145),
    [anon_sym_BSLASHciteauthor_STAR] = ACTIONS(149),
    [anon_sym_BSLASHCiteauthor] = ACTIONS(145),
    [anon_sym_BSLASHCiteauthor_STAR] = ACTIONS(149),
    [anon_sym_BSLASHcitetitle] = ACTIONS(145),
    [anon_sym_BSLASHcitetitle_STAR] = ACTIONS(149),
    [anon_sym_BSLASHciteyear] = ACTIONS(145),
    [anon_sym_BSLASHciteyear_STAR] = ACTIONS(149),
    [anon_sym_BSLASHcitedate] = ACTIONS(145),
    [anon_sym_BSLASHcitedate_STAR] = ACTIONS(149),
    [anon_sym_BSLASHciteurl] = ACTIONS(145),
    [anon_sym_BSLASHfullcite] = ACTIONS(145),
    [anon_sym_BSLASHciteyearpar] = ACTIONS(145),
    [anon_sym_BSLASHcitealt] = ACTIONS(145),
    [anon_sym_BSLASHcitealp] = ACTIONS(145),
    [anon_sym_BSLASHcitetext] = ACTIONS(145),
    [anon_sym_BSLASHparencite] = ACTIONS(145),
    [anon_sym_BSLASHparencite_STAR] = ACTIONS(149),
    [anon_sym_BSLASHParencite] = ACTIONS(145),
    [anon_sym_BSLASHfootcite] = ACTIONS(145),
    [anon_sym_BSLASHfootfullcite] = ACTIONS(145),
    [anon_sym_BSLASHfootcitetext] = ACTIONS(145),
    [anon_sym_BSLASHtextcite] = ACTIONS(145),
    [anon_sym_BSLASHTextcite] = ACTIONS(145),
    [anon_sym_BSLASHsmartcite] = ACTIONS(145),
    [anon_sym_BSLASHSmartcite] = ACTIONS(145),
    [anon_sym_BSLASHsupercite] = ACTIONS(145),
    [anon_sym_BSLASHautocite] = ACTIONS(145),
    [anon_sym_BSLASHAutocite] = ACTIONS(145),
    [anon_sym_BSLASHautocite_STAR] = ACTIONS(149),
    [anon_sym_BSLASHAutocite_STAR] = ACTIONS(149),
    [anon_sym_BSLASHvolcite] = ACTIONS(145),
    [anon_sym_BSLASHVolcite] = ACTIONS(145),
    [anon_sym_BSLASHpvolcite] = ACTIONS(145),
    [anon_sym_BSLASHPvolcite] = ACTIONS(145),
    [anon_sym_BSLASHfvolcite] = ACTIONS(145),
    [anon_sym_BSLASHftvolcite] = ACTIONS(145),
    [anon_sym_BSLASHsvolcite] = ACTIONS(145),
    [anon_sym_BSLASHSvolcite] = ACTIONS(145),
    [anon_sym_BSLASHtvolcite] = ACTIONS(145),
    [anon_sym_BSLASHTvolcite] = ACTIONS(145),
    [anon_sym_BSLASHavolcite] = ACTIONS(145),
    [anon_sym_BSLASHAvolcite] = ACTIONS(145),
    [anon_sym_BSLASHnotecite] = ACTIONS(145),
    [anon_sym_BSLASHNotecite] = ACTIONS(145),
    [anon_sym_BSLASHpnotecite] = ACTIONS(145),
    [anon_sym_BSLASHPnotecite] = ACTIONS(145),
    [anon_sym_BSLASHfnotecite] = ACTIONS(145),
    [anon_sym_BSLASHlabel] = ACTIONS(145),
    [anon_sym_BSLASHref] = ACTIONS(145),
    [anon_sym_BSLASHeqref] = ACTIONS(145),
    [anon_sym_BSLASHvref] = ACTIONS(145),
    [anon_sym_BSLASHVref] = ACTIONS(145),
    [anon_sym_BSLASHautoref] = ACTIONS(145),
    [anon_sym_BSLASHpageref] = ACTIONS(145),
    [anon_sym_BSLASHcref] = ACTIONS(145),
    [anon_sym_BSLASHCref] = ACTIONS(145),
    [anon_sym_BSLASHcref_STAR] = ACTIONS(149),
    [anon_sym_BSLASHCref_STAR] = ACTIONS(149),
    [anon_sym_BSLASHnamecref] = ACTIONS(145),
    [anon_sym_BSLASHnameCref] = ACTIONS(145),
    [anon_sym_BSLASHlcnamecref] = ACTIONS(145),
    [anon_sym_BSLASHnamecrefs] = ACTIONS(145),
    [anon_sym_BSLASHnameCrefs] = ACTIONS(145),
    [anon_sym_BSLASHlcnamecrefs] = ACTIONS(145),
    [anon_sym_BSLASHlabelcref] = ACTIONS(145),
    [anon_sym_BSLASHlabelcpageref] = ACTIONS(145),
    [anon_sym_BSLASHcrefrange] = ACTIONS(145),
    [anon_sym_BSLASHcrefrange_STAR] = ACTIONS(149),
    [anon_sym_BSLASHCrefrange] = ACTIONS(145),
    [anon_sym_BSLASHCrefrange_STAR] = ACTIONS(149),
    [anon_sym_BSLASHnewlabel] = ACTIONS(145),
    [anon_sym_BSLASHnewcommand] = ACTIONS(145),
    [anon_sym_BSLASHnewcommand_STAR] = ACTIONS(149),
    [anon_sym_BSLASHrenewcommand] = ACTIONS(145),
    [anon_sym_BSLASHrenewcommand_STAR] = ACTIONS(149),
    [anon_sym_BSLASHDeclareRobustCommand] = ACTIONS(145),
    [anon_sym_BSLASHDeclareRobustCommand_STAR] = ACTIONS(149),
    [anon_sym_BSLASHDeclareMathOperator] = ACTIONS(145),
    [anon_sym_BSLASHDeclareMathOperator_STAR] = ACTIONS(149),
    [anon_sym_BSLASHNewDocumentCommand] = ACTIONS(145),
    [anon_sym_BSLASHRenewDocumentCommand] = ACTIONS(145),
    [anon_sym_BSLASHProvideDocumentCommand] = ACTIONS(145),
    [anon_sym_BSLASHDeclareDocumentCommand] = ACTIONS(145),
    [anon_sym_BSLASHNewExpandableDocumentCommand] = ACTIONS(145),
    [anon_sym_BSLASHRenewExpandableDocumentCommand] = ACTIONS(145),
    [anon_sym_BSLASHProvideExpandableDocumentCommand] = ACTIONS(145),
    [anon_sym_BSLASHDeclareExpandableDocumentCommand] = ACTIONS(145),
    [anon_sym_BSLASHdef] = ACTIONS(145),
    [anon_sym_BSLASHlet] = ACTIONS(145),
    [anon_sym_BSLASHleft] = ACTIONS(145),
    [anon_sym_BSLASHbig] = ACTIONS(145),
    [anon_sym_BSLASHBig] = ACTIONS(145),
    [anon_sym_BSLASHbigg] = ACTIONS(145),
    [anon_sym_BSLASHBigg] = ACTIONS(145),
    [anon_sym_BSLASHbigl] = ACTIONS(145),
    [anon_sym_BSLASHBigl] = ACTIONS(145),
    [anon_sym_BSLASHbiggl] = ACTIONS(145),
    [anon_sym_BSLASHBiggl] = ACTIONS(145),
    [anon_sym_BSLASHright] = ACTIONS(183),
    [anon_sym_BSLASHbigr] = ACTIONS(183),
    [anon_sym_BSLASHBigr] = ACTIONS(183),
    [anon_sym_BSLASHbiggr] = ACTIONS(183),
    [anon_sym_BSLASHBiggr] = ACTIONS(183),
    [anon_sym_BSLASHDeclarePairedDelimiter] = ACTIONS(145),
    [anon_sym_BSLASHDeclarePairedDelimiterX] = ACTIONS(145),
    [anon_sym_BSLASHnewenvironment] = ACTIONS(145),
    [anon_sym_BSLASHrenewenvironment] = ACTIONS(145),
    [anon_sym_BSLASHNewDocumentEnvironment] = ACTIONS(145),
    [anon_sym_BSLASHRenewDocumentEnvironment] = ACTIONS(145),
    [anon_sym_BSLASHProvideDocumentEnvironment] = ACTIONS(145),
    [anon_sym_BSLASHDeclareDocumentEnvironment] = ACTIONS(145),
    [anon_sym_BSLASHnewglossaryentry] = ACTIONS(145),
    [anon_sym_BSLASHgls] = ACTIONS(145),
    [anon_sym_BSLASHGls] = ACTIONS(145),
    [anon_sym_BSLASHGLS] = ACTIONS(145),
    [anon_sym_BSLASHglspl] = ACTIONS(145),
    [anon_sym_BSLASHGlspl] = ACTIONS(145),
    [anon_sym_BSLASHGLSpl] = ACTIONS(145),
    [anon_sym_BSLASHglsdisp] = ACTIONS(145),
    [anon_sym_BSLASHglslink] = ACTIONS(145),
    [anon_sym_BSLASHglstext] = ACTIONS(145),
    [anon_sym_BSLASHGlstext] = ACTIONS(145),
    [anon_sym_BSLASHGLStext] = ACTIONS(145),
    [anon_sym_BSLASHglsfirst] = ACTIONS(145),
    [anon_sym_BSLASHGlsfirst] = ACTIONS(145),
    [anon_sym_BSLASHGLSfirst] = ACTIONS(145),
    [anon_sym_BSLASHglsplural] = ACTIONS(145),
    [anon_sym_BSLASHGlsplural] = ACTIONS(145),
    [anon_sym_BSLASHGLSplural] = ACTIONS(145),
    [anon_sym_BSLASHglsfirstplural] = ACTIONS(145),
    [anon_sym_BSLASHGlsfirstplural] = ACTIONS(145),
    [anon_sym_BSLASHGLSfirstplural] = ACTIONS(145),
    [anon_sym_BSLASHglsname] = ACTIONS(145),
    [anon_sym_BSLASHGlsname] = ACTIONS(145),
    [anon_sym_BSLASHGLSname] = ACTIONS(145),
    [anon_sym_BSLASHglssymbol] = ACTIONS(145),
    [anon_sym_BSLASHGlssymbol] = ACTIONS(145),
    [anon_sym_BSLASHglsdesc] = ACTIONS(145),
    [anon_sym_BSLASHGlsdesc] = ACTIONS(145),
    [anon_sym_BSLASHGLSdesc] = ACTIONS(145),
    [anon_sym_BSLASHglsuseri] = ACTIONS(145),
    [anon_sym_BSLASHGlsuseri] = ACTIONS(145),
    [anon_sym_BSLASHGLSuseri] = ACTIONS(145),
    [anon_sym_BSLASHglsuserii] = ACTIONS(145),
    [anon_sym_BSLASHGlsuserii] = ACTIONS(145),
    [anon_sym_BSLASHGLSuserii] = ACTIONS(145),
    [anon_sym_BSLASHglsuseriii] = ACTIONS(145),
    [anon_sym_BSLASHGlsuseriii] = ACTIONS(145),
    [anon_sym_BSLASHGLSuseriii] = ACTIONS(145),
    [anon_sym_BSLASHglsuseriv] = ACTIONS(145),
    [anon_sym_BSLASHGlsuseriv] = ACTIONS(145),
    [anon_sym_BSLASHGLSuseriv] = ACTIONS(145),
    [anon_sym_BSLASHglsuserv] = ACTIONS(145),
    [anon_sym_BSLASHGlsuserv] = ACTIONS(145),
    [anon_sym_BSLASHGLSuserv] = ACTIONS(145),
    [anon_sym_BSLASHglsuservi] = ACTIONS(145),
    [anon_sym_BSLASHGlsuservi] = ACTIONS(145),
    [anon_sym_BSLASHGLSuservi] = ACTIONS(145),
    [anon_sym_BSLASHnewacronym] = ACTIONS(145),
    [anon_sym_BSLASHacrshort] = ACTIONS(145),
    [anon_sym_BSLASHAcrshort] = ACTIONS(145),
    [anon_sym_BSLASHACRshort] = ACTIONS(145),
    [anon_sym_BSLASHacrshortpl] = ACTIONS(145),
    [anon_sym_BSLASHAcrshortpl] = ACTIONS(145),
    [anon_sym_BSLASHACRshortpl] = ACTIONS(145),
    [anon_sym_BSLASHacrlong] = ACTIONS(145),
    [anon_sym_BSLASHAcrlong] = ACTIONS(145),
    [anon_sym_BSLASHACRlong] = ACTIONS(145),
    [anon_sym_BSLASHacrlongpl] = ACTIONS(145),
    [anon_sym_BSLASHAcrlongpl] = ACTIONS(145),
    [anon_sym_BSLASHACRlongpl] = ACTIONS(145),
    [anon_sym_BSLASHacrfull] = ACTIONS(145),
    [anon_sym_BSLASHAcrfull] = ACTIONS(145),
    [anon_sym_BSLASHACRfull] = ACTIONS(145),
    [anon_sym_BSLASHacrfullpl] = ACTIONS(145),
    [anon_sym_BSLASHAcrfullpl] = ACTIONS(145),
    [anon_sym_BSLASHACRfullpl] = ACTIONS(145),
    [anon_sym_BSLASHacs] = ACTIONS(145),
    [anon_sym_BSLASHAcs] = ACTIONS(145),
    [anon_sym_BSLASHacsp] = ACTIONS(145),
    [anon_sym_BSLASHAcsp] = ACTIONS(145),
    [anon_sym_BSLASHacl] = ACTIONS(145),
    [anon_sym_BSLASHAcl] = ACTIONS(145),
    [anon_sym_BSLASHaclp] = ACTIONS(145),
    [anon_sym_BSLASHAclp] = ACTIONS(145),
    [anon_sym_BSLASHacf] = ACTIONS(145),
    [anon_sym_BSLASHAcf] = ACTIONS(145),
    [anon_sym_BSLASHacfp] = ACTIONS(145),
    [anon_sym_BSLASHAcfp] = ACTIONS(145),
    [anon_sym_BSLASHac] = ACTIONS(145),
    [anon_sym_BSLASHAc] = ACTIONS(145),
    [anon_sym_BSLASHacp] = ACTIONS(145),
    [anon_sym_BSLASHglsentrylong] = ACTIONS(145),
    [anon_sym_BSLASHGlsentrylong] = ACTIONS(145),
    [anon_sym_BSLASHglsentrylongpl] = ACTIONS(145),
    [anon_sym_BSLASHGlsentrylongpl] = ACTIONS(145),
    [anon_sym_BSLASHglsentryshort] = ACTIONS(145),
    [anon_sym_BSLASHGlsentryshort] = ACTIONS(145),
    [anon_sym_BSLASHglsentryshortpl] = ACTIONS(145),
    [anon_sym_BSLASHGlsentryshortpl] = ACTIONS(145),
    [anon_sym_BSLASHglsentryfullpl] = ACTIONS(145),
    [anon_sym_BSLASHGlsentryfullpl] = ACTIONS(145),
    [anon_sym_BSLASHnewtheorem] = ACTIONS(145),
    [anon_sym_BSLASHnewtheorem_STAR] = ACTIONS(149),
    [anon_sym_BSLASHdeclaretheorem] = ACTIONS(145),
    [anon_sym_BSLASHdeclaretheorem_STAR] = ACTIONS(149),
    [anon_sym_BSLASHdefinecolor] = ACTIONS(145),
    [anon_sym_BSLASHdefinecolorset] = ACTIONS(145),
    [anon_sym_BSLASHcolor] = ACTIONS(145),
    [anon_sym_BSLASHcolorbox] = ACTIONS(145),
    [anon_sym_BSLASHtextcolor] = ACTIONS(145),
    [anon_sym_BSLASHpagecolor] = ACTIONS(145),
    [anon_sym_BSLASHusepgflibrary] = ACTIONS(145),
    [anon_sym_BSLASHusetikzlibrary] = ACTIONS(145),
    [anon_sym_BSLASHtext] = ACTIONS(145),
    [anon_sym_BSLASHintertext] = ACTIONS(145),
    [anon_sym_shortintertext] = ACTIONS(145),
  },
  [3] = {
    [sym_block_comment] = STATE(27),
    [sym__root_content] = STATE(27),
    [sym__flat_content] = STATE(27),
    [sym__text_with_env_content] = STATE(27),
    [sym__text_content] = STATE(27),
    [sym__section] = STATE(27),
    [sym__part_declaration] = STATE(175),
    [sym_part] = STATE(367),
    [sym__chapter_declaration] = STATE(177),
    [sym_chapter] = STATE(368),
    [sym__section_declaration] = STATE(187),
    [sym_section] = STATE(369),
    [sym__subsection_declaration] = STATE(196),
    [sym_subsection] = STATE(370),
    [sym__subsubsection_declaration] = STATE(207),
    [sym_subsubsection] = STATE(371),
    [sym__paragraph_declaration] = STATE(218),
    [sym_paragraph] = STATE(373),
    [sym__subparagraph_declaration] = STATE(228),
    [sym_subparagraph] = STATE(374),
    [sym__enum_itemdeclaration] = STATE(238),
    [sym_enum_item] = STATE(375),
    [sym_curly_group] = STATE(27),
    [sym_text] = STATE(27),
    [sym_operator] = STATE(484),
    [sym_subscript] = STATE(484),
    [sym_superscript] = STATE(484),
    [sym_displayed_equation] = STATE(27),
    [sym_inline_formula] = STATE(27),
    [sym_begin] = STATE(65),
    [sym_generic_environment] = STATE(27),
    [sym_comment_environment] = STATE(27),
    [sym__comment_environment_begin] = STATE(3120),
    [sym_verbatim_environment] = STATE(27),
    [sym__verbatim_environment_begin] = STATE(3121),
    [sym_listing_environment] = STATE(27),
    [sym__listing_environment_begin] = STATE(3122),
    [sym_minted_environment] = STATE(27),
    [sym__minted_environment_begin] = STATE(3123),
    [sym_pycode_environment] = STATE(27),
    [sym__pycode_environment_begin] = STATE(3124),
    [sym_math_environment] = STATE(27),
    [sym__math_environment_begin] = STATE(269),
    [sym__command] = STATE(27),
    [sym_generic_command] = STATE(27),
    [sym_title_declaration] = STATE(27),
    [sym_author_declaration] = STATE(27),
    [sym_package_include] = STATE(27),
    [sym_class_include] = STATE(27),
    [sym_latex_include] = STATE(27),
    [sym_biblatex_include] = STATE(27),
    [sym_bibtex_include] = STATE(27),
    [sym_graphics_include] = STATE(27),
    [sym_svg_include] = STATE(27),
    [sym_inkscape_include] = STATE(27),
    [sym_verbatim_include] = STATE(27),
    [sym_import_include] = STATE(27),
    [sym_caption] = STATE(27),
    [sym_citation] = STATE(27),
    [sym_label_definition] = STATE(27),
    [sym_label_reference] = STATE(27),
    [sym_label_reference_range] = STATE(27),
    [sym_label_number] = STATE(27),
    [sym_new_command_definition] = STATE(27),
    [sym_old_command_definition] = STATE(27),
    [sym_let_command_definition] = STATE(27),
    [sym_math_delimiter] = STATE(27),
    [sym_paired_delimiter_definition] = STATE(27),
    [sym_environment_definition] = STATE(27),
    [sym_glossary_entry_definition] = STATE(27),
    [sym_glossary_entry_reference] = STATE(27),
    [sym_acronym_definition] = STATE(27),
    [sym_acronym_reference] = STATE(27),
    [sym_theorem_definition] = STATE(27),
    [sym_color_definition] = STATE(27),
    [sym_color_set_definition] = STATE(27),
    [sym_color_reference] = STATE(27),
    [sym_tikz_library_import] = STATE(27),
    [sym_text_mode] = STATE(27),
    [aux_sym_source_file_repeat1] = STATE(27),
    [aux_sym__section_repeat1] = STATE(367),
    [aux_sym__section_repeat2] = STATE(368),
    [aux_sym__section_repeat3] = STATE(369),
    [aux_sym__section_repeat4] = STATE(370),
    [aux_sym__section_repeat5] = STATE(371),
    [aux_sym__section_repeat6] = STATE(373),
    [aux_sym__section_repeat7] = STATE(374),
    [aux_sym__section_repeat8] = STATE(375),
    [aux_sym_text_repeat1] = STATE(259),
    [ts_builtin_sym_end] = ACTIONS(149),
    [sym_command_name] = ACTIONS(145),
    [sym__whitespace] = ACTIONS(3),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_BSLASHiffalse] = ACTIONS(145),
    [anon_sym_LBRACK] = ACTIONS(149),
    [anon_sym_RBRACK] = ACTIONS(149),
    [anon_sym_COMMA] = ACTIONS(149),
    [anon_sym_EQ] = ACTIONS(149),
    [anon_sym_LPAREN] = ACTIONS(149),
    [anon_sym_RPAREN] = ACTIONS(149),
    [anon_sym_BSLASHpart] = ACTIONS(145),
    [anon_sym_BSLASHpart_STAR] = ACTIONS(149),
    [anon_sym_BSLASHaddpart] = ACTIONS(145),
    [anon_sym_BSLASHaddpart_STAR] = ACTIONS(149),
    [anon_sym_BSLASHchapter] = ACTIONS(145),
    [anon_sym_BSLASHchapter_STAR] = ACTIONS(149),
    [anon_sym_BSLASHaddchap] = ACTIONS(145),
    [anon_sym_BSLASHaddchap_STAR] = ACTIONS(149),
    [anon_sym_BSLASHsection] = ACTIONS(145),
    [anon_sym_BSLASHsection_STAR] = ACTIONS(149),
    [anon_sym_BSLASHaddsec] = ACTIONS(145),
    [anon_sym_BSLASHaddsec_STAR] = ACTIONS(149),
    [anon_sym_BSLASHsubsection] = ACTIONS(145),
    [anon_sym_BSLASHsubsection_STAR] = ACTIONS(149),
    [anon_sym_BSLASHsubsubsection] = ACTIONS(145),
    [anon_sym_BSLASHsubsubsection_STAR] = ACTIONS(149),
    [anon_sym_BSLASHparagraph] = ACTIONS(145),
    [anon_sym_BSLASHparagraph_STAR] = ACTIONS(149),
    [anon_sym_BSLASHsubparagraph] = ACTIONS(145),
    [anon_sym_BSLASHsubparagraph_STAR] = ACTIONS(149),
    [anon_sym_BSLASHitem] = ACTIONS(145),
    [anon_sym_BSLASHitem_STAR] = ACTIONS(149),
    [anon_sym_LBRACE] = ACTIONS(149),
    [anon_sym_RBRACE] = ACTIONS(149),
    [sym_word] = ACTIONS(145),
    [sym_placeholder] = ACTIONS(149),
    [anon_sym_PLUS] = ACTIONS(149),
    [anon_sym_DASH] = ACTIONS(149),
    [anon_sym_STAR] = ACTIONS(149),
    [anon_sym_SLASH] = ACTIONS(149),
    [anon_sym_LT] = ACTIONS(145),
    [anon_sym_GT] = ACTIONS(145),
    [anon_sym_BANG] = ACTIONS(145),
    [anon_sym_PIPE] = ACTIONS(145),
    [anon_sym_COLON] = ACTIONS(145),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [anon_sym__] = ACTIONS(149),
    [anon_sym_CARET] = ACTIONS(149),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(149),
    [anon_sym_BSLASH_LBRACK] = ACTIONS(149),
    [anon_sym_DOLLAR] = ACTIONS(145),
    [anon_sym_BSLASH_LPAREN] = ACTIONS(149),
    [anon_sym_BSLASHbegin] = ACTIONS(145),
    [anon_sym_BSLASHtitle] = ACTIONS(145),
    [anon_sym_BSLASHauthor] = ACTIONS(145),
    [anon_sym_BSLASHusepackage] = ACTIONS(145),
    [anon_sym_BSLASHRequirePackage] = ACTIONS(145),
    [anon_sym_BSLASHdocumentclass] = ACTIONS(145),
    [anon_sym_BSLASHinclude] = ACTIONS(145),
    [anon_sym_BSLASHsubfileinclude] = ACTIONS(145),
    [anon_sym_BSLASHinput] = ACTIONS(145),
    [anon_sym_BSLASHsubfile] = ACTIONS(145),
    [anon_sym_BSLASHaddbibresource] = ACTIONS(145),
    [anon_sym_BSLASHbibliography] = ACTIONS(145),
    [anon_sym_BSLASHincludegraphics] = ACTIONS(145),
    [anon_sym_BSLASHincludesvg] = ACTIONS(145),
    [anon_sym_BSLASHincludeinkscape] = ACTIONS(145),
    [anon_sym_BSLASHverbatiminput] = ACTIONS(145),
    [anon_sym_BSLASHVerbatimInput] = ACTIONS(145),
    [anon_sym_BSLASHimport] = ACTIONS(145),
    [anon_sym_BSLASHsubimport] = ACTIONS(145),
    [anon_sym_BSLASHinputfrom] = ACTIONS(145),
    [anon_sym_BSLASHsubimportfrom] = ACTIONS(145),
    [anon_sym_BSLASHincludefrom] = ACTIONS(145),
    [anon_sym_BSLASHsubincludefrom] = ACTIONS(145),
    [anon_sym_BSLASHcaption] = ACTIONS(145),
    [anon_sym_BSLASHcite] = ACTIONS(145),
    [anon_sym_BSLASHcite_STAR] = ACTIONS(149),
    [anon_sym_BSLASHCite] = ACTIONS(145),
    [anon_sym_BSLASHnocite] = ACTIONS(145),
    [anon_sym_BSLASHcitet] = ACTIONS(145),
    [anon_sym_BSLASHcitep] = ACTIONS(145),
    [anon_sym_BSLASHcitet_STAR] = ACTIONS(149),
    [anon_sym_BSLASHcitep_STAR] = ACTIONS(149),
    [anon_sym_BSLASHciteauthor] = ACTIONS(145),
    [anon_sym_BSLASHciteauthor_STAR] = ACTIONS(149),
    [anon_sym_BSLASHCiteauthor] = ACTIONS(145),
    [anon_sym_BSLASHCiteauthor_STAR] = ACTIONS(149),
    [anon_sym_BSLASHcitetitle] = ACTIONS(145),
    [anon_sym_BSLASHcitetitle_STAR] = ACTIONS(149),
    [anon_sym_BSLASHciteyear] = ACTIONS(145),
    [anon_sym_BSLASHciteyear_STAR] = ACTIONS(149),
    [anon_sym_BSLASHcitedate] = ACTIONS(145),
    [anon_sym_BSLASHcitedate_STAR] = ACTIONS(149),
    [anon_sym_BSLASHciteurl] = ACTIONS(145),
    [anon_sym_BSLASHfullcite] = ACTIONS(145),
    [anon_sym_BSLASHciteyearpar] = ACTIONS(145),
    [anon_sym_BSLASHcitealt] = ACTIONS(145),
    [anon_sym_BSLASHcitealp] = ACTIONS(145),
    [anon_sym_BSLASHcitetext] = ACTIONS(145),
    [anon_sym_BSLASHparencite] = ACTIONS(145),
    [anon_sym_BSLASHparencite_STAR] = ACTIONS(149),
    [anon_sym_BSLASHParencite] = ACTIONS(145),
    [anon_sym_BSLASHfootcite] = ACTIONS(145),
    [anon_sym_BSLASHfootfullcite] = ACTIONS(145),
    [anon_sym_BSLASHfootcitetext] = ACTIONS(145),
    [anon_sym_BSLASHtextcite] = ACTIONS(145),
    [anon_sym_BSLASHTextcite] = ACTIONS(145),
    [anon_sym_BSLASHsmartcite] = ACTIONS(145),
    [anon_sym_BSLASHSmartcite] = ACTIONS(145),
    [anon_sym_BSLASHsupercite] = ACTIONS(145),
    [anon_sym_BSLASHautocite] = ACTIONS(145),
    [anon_sym_BSLASHAutocite] = ACTIONS(145),
    [anon_sym_BSLASHautocite_STAR] = ACTIONS(149),
    [anon_sym_BSLASHAutocite_STAR] = ACTIONS(149),
    [anon_sym_BSLASHvolcite] = ACTIONS(145),
    [anon_sym_BSLASHVolcite] = ACTIONS(145),
    [anon_sym_BSLASHpvolcite] = ACTIONS(145),
    [anon_sym_BSLASHPvolcite] = ACTIONS(145),
    [anon_sym_BSLASHfvolcite] = ACTIONS(145),
    [anon_sym_BSLASHftvolcite] = ACTIONS(145),
    [anon_sym_BSLASHsvolcite] = ACTIONS(145),
    [anon_sym_BSLASHSvolcite] = ACTIONS(145),
    [anon_sym_BSLASHtvolcite] = ACTIONS(145),
    [anon_sym_BSLASHTvolcite] = ACTIONS(145),
    [anon_sym_BSLASHavolcite] = ACTIONS(145),
    [anon_sym_BSLASHAvolcite] = ACTIONS(145),
    [anon_sym_BSLASHnotecite] = ACTIONS(145),
    [anon_sym_BSLASHNotecite] = ACTIONS(145),
    [anon_sym_BSLASHpnotecite] = ACTIONS(145),
    [anon_sym_BSLASHPnotecite] = ACTIONS(145),
    [anon_sym_BSLASHfnotecite] = ACTIONS(145),
    [anon_sym_BSLASHlabel] = ACTIONS(145),
    [anon_sym_BSLASHref] = ACTIONS(145),
    [anon_sym_BSLASHeqref] = ACTIONS(145),
    [anon_sym_BSLASHvref] = ACTIONS(145),
    [anon_sym_BSLASHVref] = ACTIONS(145),
    [anon_sym_BSLASHautoref] = ACTIONS(145),
    [anon_sym_BSLASHpageref] = ACTIONS(145),
    [anon_sym_BSLASHcref] = ACTIONS(145),
    [anon_sym_BSLASHCref] = ACTIONS(145),
    [anon_sym_BSLASHcref_STAR] = ACTIONS(149),
    [anon_sym_BSLASHCref_STAR] = ACTIONS(149),
    [anon_sym_BSLASHnamecref] = ACTIONS(145),
    [anon_sym_BSLASHnameCref] = ACTIONS(145),
    [anon_sym_BSLASHlcnamecref] = ACTIONS(145),
    [anon_sym_BSLASHnamecrefs] = ACTIONS(145),
    [anon_sym_BSLASHnameCrefs] = ACTIONS(145),
    [anon_sym_BSLASHlcnamecrefs] = ACTIONS(145),
    [anon_sym_BSLASHlabelcref] = ACTIONS(145),
    [anon_sym_BSLASHlabelcpageref] = ACTIONS(145),
    [anon_sym_BSLASHcrefrange] = ACTIONS(145),
    [anon_sym_BSLASHcrefrange_STAR] = ACTIONS(149),
    [anon_sym_BSLASHCrefrange] = ACTIONS(145),
    [anon_sym_BSLASHCrefrange_STAR] = ACTIONS(149),
    [anon_sym_BSLASHnewlabel] = ACTIONS(145),
    [anon_sym_BSLASHnewcommand] = ACTIONS(145),
    [anon_sym_BSLASHnewcommand_STAR] = ACTIONS(149),
    [anon_sym_BSLASHrenewcommand] = ACTIONS(145),
    [anon_sym_BSLASHrenewcommand_STAR] = ACTIONS(149),
    [anon_sym_BSLASHDeclareRobustCommand] = ACTIONS(145),
    [anon_sym_BSLASHDeclareRobustCommand_STAR] = ACTIONS(149),
    [anon_sym_BSLASHDeclareMathOperator] = ACTIONS(145),
    [anon_sym_BSLASHDeclareMathOperator_STAR] = ACTIONS(149),
    [anon_sym_BSLASHNewDocumentCommand] = ACTIONS(145),
    [anon_sym_BSLASHRenewDocumentCommand] = ACTIONS(145),
    [anon_sym_BSLASHProvideDocumentCommand] = ACTIONS(145),
    [anon_sym_BSLASHDeclareDocumentCommand] = ACTIONS(145),
    [anon_sym_BSLASHNewExpandableDocumentCommand] = ACTIONS(145),
    [anon_sym_BSLASHRenewExpandableDocumentCommand] = ACTIONS(145),
    [anon_sym_BSLASHProvideExpandableDocumentCommand] = ACTIONS(145),
    [anon_sym_BSLASHDeclareExpandableDocumentCommand] = ACTIONS(145),
    [anon_sym_BSLASHdef] = ACTIONS(145),
    [anon_sym_BSLASHlet] = ACTIONS(145),
    [anon_sym_BSLASHleft] = ACTIONS(145),
    [anon_sym_BSLASHbig] = ACTIONS(145),
    [anon_sym_BSLASHBig] = ACTIONS(145),
    [anon_sym_BSLASHbigg] = ACTIONS(145),
    [anon_sym_BSLASHBigg] = ACTIONS(145),
    [anon_sym_BSLASHbigl] = ACTIONS(145),
    [anon_sym_BSLASHBigl] = ACTIONS(145),
    [anon_sym_BSLASHbiggl] = ACTIONS(145),
    [anon_sym_BSLASHBiggl] = ACTIONS(145),
    [anon_sym_BSLASHright] = ACTIONS(183),
    [anon_sym_BSLASHbigr] = ACTIONS(183),
    [anon_sym_BSLASHBigr] = ACTIONS(183),
    [anon_sym_BSLASHbiggr] = ACTIONS(183),
    [anon_sym_BSLASHBiggr] = ACTIONS(183),
    [anon_sym_BSLASHDeclarePairedDelimiter] = ACTIONS(145),
    [anon_sym_BSLASHDeclarePairedDelimiterX] = ACTIONS(145),
    [anon_sym_BSLASHnewenvironment] = ACTIONS(145),
    [anon_sym_BSLASHrenewenvironment] = ACTIONS(145),
    [anon_sym_BSLASHNewDocumentEnvironment] = ACTIONS(145),
    [anon_sym_BSLASHRenewDocumentEnvironment] = ACTIONS(145),
    [anon_sym_BSLASHProvideDocumentEnvironment] = ACTIONS(145),
    [anon_sym_BSLASHDeclareDocumentEnvironment] = ACTIONS(145),
    [anon_sym_BSLASHnewglossaryentry] = ACTIONS(145),
    [anon_sym_BSLASHgls] = ACTIONS(145),
    [anon_sym_BSLASHGls] = ACTIONS(145),
    [anon_sym_BSLASHGLS] = ACTIONS(145),
    [anon_sym_BSLASHglspl] = ACTIONS(145),
    [anon_sym_BSLASHGlspl] = ACTIONS(145),
    [anon_sym_BSLASHGLSpl] = ACTIONS(145),
    [anon_sym_BSLASHglsdisp] = ACTIONS(145),
    [anon_sym_BSLASHglslink] = ACTIONS(145),
    [anon_sym_BSLASHglstext] = ACTIONS(145),
    [anon_sym_BSLASHGlstext] = ACTIONS(145),
    [anon_sym_BSLASHGLStext] = ACTIONS(145),
    [anon_sym_BSLASHglsfirst] = ACTIONS(145),
    [anon_sym_BSLASHGlsfirst] = ACTIONS(145),
    [anon_sym_BSLASHGLSfirst] = ACTIONS(145),
    [anon_sym_BSLASHglsplural] = ACTIONS(145),
    [anon_sym_BSLASHGlsplural] = ACTIONS(145),
    [anon_sym_BSLASHGLSplural] = ACTIONS(145),
    [anon_sym_BSLASHglsfirstplural] = ACTIONS(145),
    [anon_sym_BSLASHGlsfirstplural] = ACTIONS(145),
    [anon_sym_BSLASHGLSfirstplural] = ACTIONS(145),
    [anon_sym_BSLASHglsname] = ACTIONS(145),
    [anon_sym_BSLASHGlsname] = ACTIONS(145),
    [anon_sym_BSLASHGLSname] = ACTIONS(145),
    [anon_sym_BSLASHglssymbol] = ACTIONS(145),
    [anon_sym_BSLASHGlssymbol] = ACTIONS(145),
    [anon_sym_BSLASHglsdesc] = ACTIONS(145),
    [anon_sym_BSLASHGlsdesc] = ACTIONS(145),
    [anon_sym_BSLASHGLSdesc] = ACTIONS(145),
    [anon_sym_BSLASHglsuseri] = ACTIONS(145),
    [anon_sym_BSLASHGlsuseri] = ACTIONS(145),
    [anon_sym_BSLASHGLSuseri] = ACTIONS(145),
    [anon_sym_BSLASHglsuserii] = ACTIONS(145),
    [anon_sym_BSLASHGlsuserii] = ACTIONS(145),
    [anon_sym_BSLASHGLSuserii] = ACTIONS(145),
    [anon_sym_BSLASHglsuseriii] = ACTIONS(145),
    [anon_sym_BSLASHGlsuseriii] = ACTIONS(145),
    [anon_sym_BSLASHGLSuseriii] = ACTIONS(145),
    [anon_sym_BSLASHglsuseriv] = ACTIONS(145),
    [anon_sym_BSLASHGlsuseriv] = ACTIONS(145),
    [anon_sym_BSLASHGLSuseriv] = ACTIONS(145),
    [anon_sym_BSLASHglsuserv] = ACTIONS(145),
    [anon_sym_BSLASHGlsuserv] = ACTIONS(145),
    [anon_sym_BSLASHGLSuserv] = ACTIONS(145),
    [anon_sym_BSLASHglsuservi] = ACTIONS(145),
    [anon_sym_BSLASHGlsuservi] = ACTIONS(145),
    [anon_sym_BSLASHGLSuservi] = ACTIONS(145),
    [anon_sym_BSLASHnewacronym] = ACTIONS(145),
    [anon_sym_BSLASHacrshort] = ACTIONS(145),
    [anon_sym_BSLASHAcrshort] = ACTIONS(145),
    [anon_sym_BSLASHACRshort] = ACTIONS(145),
    [anon_sym_BSLASHacrshortpl] = ACTIONS(145),
    [anon_sym_BSLASHAcrshortpl] = ACTIONS(145),
    [anon_sym_BSLASHACRshortpl] = ACTIONS(145),
    [anon_sym_BSLASHacrlong] = ACTIONS(145),
    [anon_sym_BSLASHAcrlong] = ACTIONS(145),
    [anon_sym_BSLASHACRlong] = ACTIONS(145),
    [anon_sym_BSLASHacrlongpl] = ACTIONS(145),
    [anon_sym_BSLASHAcrlongpl] = ACTIONS(145),
    [anon_sym_BSLASHACRlongpl] = ACTIONS(145),
    [anon_sym_BSLASHacrfull] = ACTIONS(145),
    [anon_sym_BSLASHAcrfull] = ACTIONS(145),
    [anon_sym_BSLASHACRfull] = ACTIONS(145),
    [anon_sym_BSLASHacrfullpl] = ACTIONS(145),
    [anon_sym_BSLASHAcrfullpl] = ACTIONS(145),
    [anon_sym_BSLASHACRfullpl] = ACTIONS(145),
    [anon_sym_BSLASHacs] = ACTIONS(145),
    [anon_sym_BSLASHAcs] = ACTIONS(145),
    [anon_sym_BSLASHacsp] = ACTIONS(145),
    [anon_sym_BSLASHAcsp] = ACTIONS(145),
    [anon_sym_BSLASHacl] = ACTIONS(145),
    [anon_sym_BSLASHAcl] = ACTIONS(145),
    [anon_sym_BSLASHaclp] = ACTIONS(145),
    [anon_sym_BSLASHAclp] = ACTIONS(145),
    [anon_sym_BSLASHacf] = ACTIONS(145),
    [anon_sym_BSLASHAcf] = ACTIONS(145),
    [anon_sym_BSLASHacfp] = ACTIONS(145),
    [anon_sym_BSLASHAcfp] = ACTIONS(145),
    [anon_sym_BSLASHac] = ACTIONS(145),
    [anon_sym_BSLASHAc] = ACTIONS(145),
    [anon_sym_BSLASHacp] = ACTIONS(145),
    [anon_sym_BSLASHglsentrylong] = ACTIONS(145),
    [anon_sym_BSLASHGlsentrylong] = ACTIONS(145),
    [anon_sym_BSLASHglsentrylongpl] = ACTIONS(145),
    [anon_sym_BSLASHGlsentrylongpl] = ACTIONS(145),
    [anon_sym_BSLASHglsentryshort] = ACTIONS(145),
    [anon_sym_BSLASHGlsentryshort] = ACTIONS(145),
    [anon_sym_BSLASHglsentryshortpl] = ACTIONS(145),
    [anon_sym_BSLASHGlsentryshortpl] = ACTIONS(145),
    [anon_sym_BSLASHglsentryfullpl] = ACTIONS(145),
    [anon_sym_BSLASHGlsentryfullpl] = ACTIONS(145),
    [anon_sym_BSLASHnewtheorem] = ACTIONS(145),
    [anon_sym_BSLASHnewtheorem_STAR] = ACTIONS(149),
    [anon_sym_BSLASHdeclaretheorem] = ACTIONS(145),
    [anon_sym_BSLASHdeclaretheorem_STAR] = ACTIONS(149),
    [anon_sym_BSLASHdefinecolor] = ACTIONS(145),
    [anon_sym_BSLASHdefinecolorset] = ACTIONS(145),
    [anon_sym_BSLASHcolor] = ACTIONS(145),
    [anon_sym_BSLASHcolorbox] = ACTIONS(145),
    [anon_sym_BSLASHtextcolor] = ACTIONS(145),
    [anon_sym_BSLASHpagecolor] = ACTIONS(145),
    [anon_sym_BSLASHusepgflibrary] = ACTIONS(145),
    [anon_sym_BSLASHusetikzlibrary] = ACTIONS(145),
    [anon_sym_BSLASHtext] = ACTIONS(145),
    [anon_sym_BSLASHintertext] = ACTIONS(145),
    [anon_sym_shortintertext] = ACTIONS(145),
  },
  [4] = {
    [sym_block_comment] = STATE(27),
    [sym__root_content] = STATE(27),
    [sym__flat_content] = STATE(27),
    [sym__text_with_env_content] = STATE(27),
    [sym__text_content] = STATE(27),
    [sym__section] = STATE(27),
    [sym__part_declaration] = STATE(175),
    [sym_part] = STATE(367),
    [sym__chapter_declaration] = STATE(177),
    [sym_chapter] = STATE(368),
    [sym__section_declaration] = STATE(187),
    [sym_section] = STATE(369),
    [sym__subsection_declaration] = STATE(196),
    [sym_subsection] = STATE(370),
    [sym__subsubsection_declaration] = STATE(207),
    [sym_subsubsection] = STATE(371),
    [sym__paragraph_declaration] = STATE(218),
    [sym_paragraph] = STATE(373),
    [sym__subparagraph_declaration] = STATE(228),
    [sym_subparagraph] = STATE(374),
    [sym__enum_itemdeclaration] = STATE(238),
    [sym_enum_item] = STATE(375),
    [sym_curly_group] = STATE(27),
    [sym_text] = STATE(27),
    [sym_operator] = STATE(484),
    [sym_subscript] = STATE(484),
    [sym_superscript] = STATE(484),
    [sym_displayed_equation] = STATE(27),
    [sym_inline_formula] = STATE(27),
    [sym_begin] = STATE(65),
    [sym_generic_environment] = STATE(27),
    [sym_comment_environment] = STATE(27),
    [sym__comment_environment_begin] = STATE(3120),
    [sym_verbatim_environment] = STATE(27),
    [sym__verbatim_environment_begin] = STATE(3121),
    [sym_listing_environment] = STATE(27),
    [sym__listing_environment_begin] = STATE(3122),
    [sym_minted_environment] = STATE(27),
    [sym__minted_environment_begin] = STATE(3123),
    [sym_pycode_environment] = STATE(27),
    [sym__pycode_environment_begin] = STATE(3124),
    [sym_math_environment] = STATE(27),
    [sym__math_environment_begin] = STATE(269),
    [sym__command] = STATE(27),
    [sym_generic_command] = STATE(27),
    [sym_title_declaration] = STATE(27),
    [sym_author_declaration] = STATE(27),
    [sym_package_include] = STATE(27),
    [sym_class_include] = STATE(27),
    [sym_latex_include] = STATE(27),
    [sym_biblatex_include] = STATE(27),
    [sym_bibtex_include] = STATE(27),
    [sym_graphics_include] = STATE(27),
    [sym_svg_include] = STATE(27),
    [sym_inkscape_include] = STATE(27),
    [sym_verbatim_include] = STATE(27),
    [sym_import_include] = STATE(27),
    [sym_caption] = STATE(27),
    [sym_citation] = STATE(27),
    [sym_label_definition] = STATE(27),
    [sym_label_reference] = STATE(27),
    [sym_label_reference_range] = STATE(27),
    [sym_label_number] = STATE(27),
    [sym_new_command_definition] = STATE(27),
    [sym_old_command_definition] = STATE(27),
    [sym_let_command_definition] = STATE(27),
    [sym_math_delimiter] = STATE(27),
    [sym_paired_delimiter_definition] = STATE(27),
    [sym_environment_definition] = STATE(27),
    [sym_glossary_entry_definition] = STATE(27),
    [sym_glossary_entry_reference] = STATE(27),
    [sym_acronym_definition] = STATE(27),
    [sym_acronym_reference] = STATE(27),
    [sym_theorem_definition] = STATE(27),
    [sym_color_definition] = STATE(27),
    [sym_color_set_definition] = STATE(27),
    [sym_color_reference] = STATE(27),
    [sym_tikz_library_import] = STATE(27),
    [sym_text_mode] = STATE(27),
    [aux_sym_source_file_repeat1] = STATE(27),
    [aux_sym__section_repeat1] = STATE(367),
    [aux_sym__section_repeat2] = STATE(368),
    [aux_sym__section_repeat3] = STATE(369),
    [aux_sym__section_repeat4] = STATE(370),
    [aux_sym__section_repeat5] = STATE(371),
    [aux_sym__section_repeat6] = STATE(373),
    [aux_sym__section_repeat7] = STATE(374),
    [aux_sym__section_repeat8] = STATE(375),
    [aux_sym_text_repeat1] = STATE(259),
    [ts_builtin_sym_end] = ACTIONS(185),
    [sym_command_name] = ACTIONS(187),
    [sym__whitespace] = ACTIONS(3),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_BSLASHiffalse] = ACTIONS(187),
    [anon_sym_LBRACK] = ACTIONS(185),
    [anon_sym_RBRACK] = ACTIONS(185),
    [anon_sym_COMMA] = ACTIONS(185),
    [anon_sym_EQ] = ACTIONS(185),
    [anon_sym_LPAREN] = ACTIONS(185),
    [anon_sym_RPAREN] = ACTIONS(185),
    [anon_sym_BSLASHpart] = ACTIONS(187),
    [anon_sym_BSLASHpart_STAR] = ACTIONS(185),
    [anon_sym_BSLASHaddpart] = ACTIONS(187),
    [anon_sym_BSLASHaddpart_STAR] = ACTIONS(185),
    [anon_sym_BSLASHchapter] = ACTIONS(187),
    [anon_sym_BSLASHchapter_STAR] = ACTIONS(185),
    [anon_sym_BSLASHaddchap] = ACTIONS(187),
    [anon_sym_BSLASHaddchap_STAR] = ACTIONS(185),
    [anon_sym_BSLASHsection] = ACTIONS(187),
    [anon_sym_BSLASHsection_STAR] = ACTIONS(185),
    [anon_sym_BSLASHaddsec] = ACTIONS(187),
    [anon_sym_BSLASHaddsec_STAR] = ACTIONS(185),
    [anon_sym_BSLASHsubsection] = ACTIONS(187),
    [anon_sym_BSLASHsubsection_STAR] = ACTIONS(185),
    [anon_sym_BSLASHsubsubsection] = ACTIONS(187),
    [anon_sym_BSLASHsubsubsection_STAR] = ACTIONS(185),
    [anon_sym_BSLASHparagraph] = ACTIONS(187),
    [anon_sym_BSLASHparagraph_STAR] = ACTIONS(185),
    [anon_sym_BSLASHsubparagraph] = ACTIONS(187),
    [anon_sym_BSLASHsubparagraph_STAR] = ACTIONS(185),
    [anon_sym_BSLASHitem] = ACTIONS(187),
    [anon_sym_BSLASHitem_STAR] = ACTIONS(185),
    [anon_sym_LBRACE] = ACTIONS(185),
    [anon_sym_RBRACE] = ACTIONS(185),
    [sym_word] = ACTIONS(187),
    [sym_placeholder] = ACTIONS(185),
    [anon_sym_PLUS] = ACTIONS(185),
    [anon_sym_DASH] = ACTIONS(185),
    [anon_sym_STAR] = ACTIONS(185),
    [anon_sym_SLASH] = ACTIONS(185),
    [anon_sym_LT] = ACTIONS(187),
    [anon_sym_GT] = ACTIONS(187),
    [anon_sym_BANG] = ACTIONS(187),
    [anon_sym_PIPE] = ACTIONS(187),
    [anon_sym_COLON] = ACTIONS(187),
    [anon_sym_SQUOTE] = ACTIONS(187),
    [anon_sym__] = ACTIONS(185),
    [anon_sym_CARET] = ACTIONS(185),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(185),
    [anon_sym_BSLASH_LBRACK] = ACTIONS(185),
    [anon_sym_DOLLAR] = ACTIONS(187),
    [anon_sym_BSLASH_LPAREN] = ACTIONS(185),
    [anon_sym_BSLASHbegin] = ACTIONS(187),
    [anon_sym_BSLASHtitle] = ACTIONS(187),
    [anon_sym_BSLASHauthor] = ACTIONS(187),
    [anon_sym_BSLASHusepackage] = ACTIONS(187),
    [anon_sym_BSLASHRequirePackage] = ACTIONS(187),
    [anon_sym_BSLASHdocumentclass] = ACTIONS(187),
    [anon_sym_BSLASHinclude] = ACTIONS(187),
    [anon_sym_BSLASHsubfileinclude] = ACTIONS(187),
    [anon_sym_BSLASHinput] = ACTIONS(187),
    [anon_sym_BSLASHsubfile] = ACTIONS(187),
    [anon_sym_BSLASHaddbibresource] = ACTIONS(187),
    [anon_sym_BSLASHbibliography] = ACTIONS(187),
    [anon_sym_BSLASHincludegraphics] = ACTIONS(187),
    [anon_sym_BSLASHincludesvg] = ACTIONS(187),
    [anon_sym_BSLASHincludeinkscape] = ACTIONS(187),
    [anon_sym_BSLASHverbatiminput] = ACTIONS(187),
    [anon_sym_BSLASHVerbatimInput] = ACTIONS(187),
    [anon_sym_BSLASHimport] = ACTIONS(187),
    [anon_sym_BSLASHsubimport] = ACTIONS(187),
    [anon_sym_BSLASHinputfrom] = ACTIONS(187),
    [anon_sym_BSLASHsubimportfrom] = ACTIONS(187),
    [anon_sym_BSLASHincludefrom] = ACTIONS(187),
    [anon_sym_BSLASHsubincludefrom] = ACTIONS(187),
    [anon_sym_BSLASHcaption] = ACTIONS(187),
    [anon_sym_BSLASHcite] = ACTIONS(187),
    [anon_sym_BSLASHcite_STAR] = ACTIONS(185),
    [anon_sym_BSLASHCite] = ACTIONS(187),
    [anon_sym_BSLASHnocite] = ACTIONS(187),
    [anon_sym_BSLASHcitet] = ACTIONS(187),
    [anon_sym_BSLASHcitep] = ACTIONS(187),
    [anon_sym_BSLASHcitet_STAR] = ACTIONS(185),
    [anon_sym_BSLASHcitep_STAR] = ACTIONS(185),
    [anon_sym_BSLASHciteauthor] = ACTIONS(187),
    [anon_sym_BSLASHciteauthor_STAR] = ACTIONS(185),
    [anon_sym_BSLASHCiteauthor] = ACTIONS(187),
    [anon_sym_BSLASHCiteauthor_STAR] = ACTIONS(185),
    [anon_sym_BSLASHcitetitle] = ACTIONS(187),
    [anon_sym_BSLASHcitetitle_STAR] = ACTIONS(185),
    [anon_sym_BSLASHciteyear] = ACTIONS(187),
    [anon_sym_BSLASHciteyear_STAR] = ACTIONS(185),
    [anon_sym_BSLASHcitedate] = ACTIONS(187),
    [anon_sym_BSLASHcitedate_STAR] = ACTIONS(185),
    [anon_sym_BSLASHciteurl] = ACTIONS(187),
    [anon_sym_BSLASHfullcite] = ACTIONS(187),
    [anon_sym_BSLASHciteyearpar] = ACTIONS(187),
    [anon_sym_BSLASHcitealt] = ACTIONS(187),
    [anon_sym_BSLASHcitealp] = ACTIONS(187),
    [anon_sym_BSLASHcitetext] = ACTIONS(187),
    [anon_sym_BSLASHparencite] = ACTIONS(187),
    [anon_sym_BSLASHparencite_STAR] = ACTIONS(185),
    [anon_sym_BSLASHParencite] = ACTIONS(187),
    [anon_sym_BSLASHfootcite] = ACTIONS(187),
    [anon_sym_BSLASHfootfullcite] = ACTIONS(187),
    [anon_sym_BSLASHfootcitetext] = ACTIONS(187),
    [anon_sym_BSLASHtextcite] = ACTIONS(187),
    [anon_sym_BSLASHTextcite] = ACTIONS(187),
    [anon_sym_BSLASHsmartcite] = ACTIONS(187),
    [anon_sym_BSLASHSmartcite] = ACTIONS(187),
    [anon_sym_BSLASHsupercite] = ACTIONS(187),
    [anon_sym_BSLASHautocite] = ACTIONS(187),
    [anon_sym_BSLASHAutocite] = ACTIONS(187),
    [anon_sym_BSLASHautocite_STAR] = ACTIONS(185),
    [anon_sym_BSLASHAutocite_STAR] = ACTIONS(185),
    [anon_sym_BSLASHvolcite] = ACTIONS(187),
    [anon_sym_BSLASHVolcite] = ACTIONS(187),
    [anon_sym_BSLASHpvolcite] = ACTIONS(187),
    [anon_sym_BSLASHPvolcite] = ACTIONS(187),
    [anon_sym_BSLASHfvolcite] = ACTIONS(187),
    [anon_sym_BSLASHftvolcite] = ACTIONS(187),
    [anon_sym_BSLASHsvolcite] = ACTIONS(187),
    [anon_sym_BSLASHSvolcite] = ACTIONS(187),
    [anon_sym_BSLASHtvolcite] = ACTIONS(187),
    [anon_sym_BSLASHTvolcite] = ACTIONS(187),
    [anon_sym_BSLASHavolcite] = ACTIONS(187),
    [anon_sym_BSLASHAvolcite] = ACTIONS(187),
    [anon_sym_BSLASHnotecite] = ACTIONS(187),
    [anon_sym_BSLASHNotecite] = ACTIONS(187),
    [anon_sym_BSLASHpnotecite] = ACTIONS(187),
    [anon_sym_BSLASHPnotecite] = ACTIONS(187),
    [anon_sym_BSLASHfnotecite] = ACTIONS(187),
    [anon_sym_BSLASHlabel] = ACTIONS(187),
    [anon_sym_BSLASHref] = ACTIONS(187),
    [anon_sym_BSLASHeqref] = ACTIONS(187),
    [anon_sym_BSLASHvref] = ACTIONS(187),
    [anon_sym_BSLASHVref] = ACTIONS(187),
    [anon_sym_BSLASHautoref] = ACTIONS(187),
    [anon_sym_BSLASHpageref] = ACTIONS(187),
    [anon_sym_BSLASHcref] = ACTIONS(187),
    [anon_sym_BSLASHCref] = ACTIONS(187),
    [anon_sym_BSLASHcref_STAR] = ACTIONS(185),
    [anon_sym_BSLASHCref_STAR] = ACTIONS(185),
    [anon_sym_BSLASHnamecref] = ACTIONS(187),
    [anon_sym_BSLASHnameCref] = ACTIONS(187),
    [anon_sym_BSLASHlcnamecref] = ACTIONS(187),
    [anon_sym_BSLASHnamecrefs] = ACTIONS(187),
    [anon_sym_BSLASHnameCrefs] = ACTIONS(187),
    [anon_sym_BSLASHlcnamecrefs] = ACTIONS(187),
    [anon_sym_BSLASHlabelcref] = ACTIONS(187),
    [anon_sym_BSLASHlabelcpageref] = ACTIONS(187),
    [anon_sym_BSLASHcrefrange] = ACTIONS(187),
    [anon_sym_BSLASHcrefrange_STAR] = ACTIONS(185),
    [anon_sym_BSLASHCrefrange] = ACTIONS(187),
    [anon_sym_BSLASHCrefrange_STAR] = ACTIONS(185),
    [anon_sym_BSLASHnewlabel] = ACTIONS(187),
    [anon_sym_BSLASHnewcommand] = ACTIONS(187),
    [anon_sym_BSLASHnewcommand_STAR] = ACTIONS(185),
    [anon_sym_BSLASHrenewcommand] = ACTIONS(187),
    [anon_sym_BSLASHrenewcommand_STAR] = ACTIONS(185),
    [anon_sym_BSLASHDeclareRobustCommand] = ACTIONS(187),
    [anon_sym_BSLASHDeclareRobustCommand_STAR] = ACTIONS(185),
    [anon_sym_BSLASHDeclareMathOperator] = ACTIONS(187),
    [anon_sym_BSLASHDeclareMathOperator_STAR] = ACTIONS(185),
    [anon_sym_BSLASHNewDocumentCommand] = ACTIONS(187),
    [anon_sym_BSLASHRenewDocumentCommand] = ACTIONS(187),
    [anon_sym_BSLASHProvideDocumentCommand] = ACTIONS(187),
    [anon_sym_BSLASHDeclareDocumentCommand] = ACTIONS(187),
    [anon_sym_BSLASHNewExpandableDocumentCommand] = ACTIONS(187),
    [anon_sym_BSLASHRenewExpandableDocumentCommand] = ACTIONS(187),
    [anon_sym_BSLASHProvideExpandableDocumentCommand] = ACTIONS(187),
    [anon_sym_BSLASHDeclareExpandableDocumentCommand] = ACTIONS(187),
    [anon_sym_BSLASHdef] = ACTIONS(187),
    [anon_sym_BSLASHlet] = ACTIONS(187),
    [anon_sym_BSLASHleft] = ACTIONS(187),
    [anon_sym_BSLASHbig] = ACTIONS(187),
    [anon_sym_BSLASHBig] = ACTIONS(187),
    [anon_sym_BSLASHbigg] = ACTIONS(187),
    [anon_sym_BSLASHBigg] = ACTIONS(187),
    [anon_sym_BSLASHbigl] = ACTIONS(187),
    [anon_sym_BSLASHBigl] = ACTIONS(187),
    [anon_sym_BSLASHbiggl] = ACTIONS(187),
    [anon_sym_BSLASHBiggl] = ACTIONS(187),
    [anon_sym_BSLASHright] = ACTIONS(183),
    [anon_sym_BSLASHbigr] = ACTIONS(183),
    [anon_sym_BSLASHBigr] = ACTIONS(183),
    [anon_sym_BSLASHbiggr] = ACTIONS(183),
    [anon_sym_BSLASHBiggr] = ACTIONS(183),
    [anon_sym_BSLASHDeclarePairedDelimiter] = ACTIONS(187),
    [anon_sym_BSLASHDeclarePairedDelimiterX] = ACTIONS(187),
    [anon_sym_BSLASHnewenvironment] = ACTIONS(187),
    [anon_sym_BSLASHrenewenvironment] = ACTIONS(187),
    [anon_sym_BSLASHNewDocumentEnvironment] = ACTIONS(187),
    [anon_sym_BSLASHRenewDocumentEnvironment] = ACTIONS(187),
    [anon_sym_BSLASHProvideDocumentEnvironment] = ACTIONS(187),
    [anon_sym_BSLASHDeclareDocumentEnvironment] = ACTIONS(187),
    [anon_sym_BSLASHnewglossaryentry] = ACTIONS(187),
    [anon_sym_BSLASHgls] = ACTIONS(187),
    [anon_sym_BSLASHGls] = ACTIONS(187),
    [anon_sym_BSLASHGLS] = ACTIONS(187),
    [anon_sym_BSLASHglspl] = ACTIONS(187),
    [anon_sym_BSLASHGlspl] = ACTIONS(187),
    [anon_sym_BSLASHGLSpl] = ACTIONS(187),
    [anon_sym_BSLASHglsdisp] = ACTIONS(187),
    [anon_sym_BSLASHglslink] = ACTIONS(187),
    [anon_sym_BSLASHglstext] = ACTIONS(187),
    [anon_sym_BSLASHGlstext] = ACTIONS(187),
    [anon_sym_BSLASHGLStext] = ACTIONS(187),
    [anon_sym_BSLASHglsfirst] = ACTIONS(187),
    [anon_sym_BSLASHGlsfirst] = ACTIONS(187),
    [anon_sym_BSLASHGLSfirst] = ACTIONS(187),
    [anon_sym_BSLASHglsplural] = ACTIONS(187),
    [anon_sym_BSLASHGlsplural] = ACTIONS(187),
    [anon_sym_BSLASHGLSplural] = ACTIONS(187),
    [anon_sym_BSLASHglsfirstplural] = ACTIONS(187),
    [anon_sym_BSLASHGlsfirstplural] = ACTIONS(187),
    [anon_sym_BSLASHGLSfirstplural] = ACTIONS(187),
    [anon_sym_BSLASHglsname] = ACTIONS(187),
    [anon_sym_BSLASHGlsname] = ACTIONS(187),
    [anon_sym_BSLASHGLSname] = ACTIONS(187),
    [anon_sym_BSLASHglssymbol] = ACTIONS(187),
    [anon_sym_BSLASHGlssymbol] = ACTIONS(187),
    [anon_sym_BSLASHglsdesc] = ACTIONS(187),
    [anon_sym_BSLASHGlsdesc] = ACTIONS(187),
    [anon_sym_BSLASHGLSdesc] = ACTIONS(187),
    [anon_sym_BSLASHglsuseri] = ACTIONS(187),
    [anon_sym_BSLASHGlsuseri] = ACTIONS(187),
    [anon_sym_BSLASHGLSuseri] = ACTIONS(187),
    [anon_sym_BSLASHglsuserii] = ACTIONS(187),
    [anon_sym_BSLASHGlsuserii] = ACTIONS(187),
    [anon_sym_BSLASHGLSuserii] = ACTIONS(187),
    [anon_sym_BSLASHglsuseriii] = ACTIONS(187),
    [anon_sym_BSLASHGlsuseriii] = ACTIONS(187),
    [anon_sym_BSLASHGLSuseriii] = ACTIONS(187),
    [anon_sym_BSLASHglsuseriv] = ACTIONS(187),
    [anon_sym_BSLASHGlsuseriv] = ACTIONS(187),
    [anon_sym_BSLASHGLSuseriv] = ACTIONS(187),
    [anon_sym_BSLASHglsuserv] = ACTIONS(187),
    [anon_sym_BSLASHGlsuserv] = ACTIONS(187),
    [anon_sym_BSLASHGLSuserv] = ACTIONS(187),
    [anon_sym_BSLASHglsuservi] = ACTIONS(187),
    [anon_sym_BSLASHGlsuservi] = ACTIONS(187),
    [anon_sym_BSLASHGLSuservi] = ACTIONS(187),
    [anon_sym_BSLASHnewacronym] = ACTIONS(187),
    [anon_sym_BSLASHacrshort] = ACTIONS(187),
    [anon_sym_BSLASHAcrshort] = ACTIONS(187),
    [anon_sym_BSLASHACRshort] = ACTIONS(187),
    [anon_sym_BSLASHacrshortpl] = ACTIONS(187),
    [anon_sym_BSLASHAcrshortpl] = ACTIONS(187),
    [anon_sym_BSLASHACRshortpl] = ACTIONS(187),
    [anon_sym_BSLASHacrlong] = ACTIONS(187),
    [anon_sym_BSLASHAcrlong] = ACTIONS(187),
    [anon_sym_BSLASHACRlong] = ACTIONS(187),
    [anon_sym_BSLASHacrlongpl] = ACTIONS(187),
    [anon_sym_BSLASHAcrlongpl] = ACTIONS(187),
    [anon_sym_BSLASHACRlongpl] = ACTIONS(187),
    [anon_sym_BSLASHacrfull] = ACTIONS(187),
    [anon_sym_BSLASHAcrfull] = ACTIONS(187),
    [anon_sym_BSLASHACRfull] = ACTIONS(187),
    [anon_sym_BSLASHacrfullpl] = ACTIONS(187),
    [anon_sym_BSLASHAcrfullpl] = ACTIONS(187),
    [anon_sym_BSLASHACRfullpl] = ACTIONS(187),
    [anon_sym_BSLASHacs] = ACTIONS(187),
    [anon_sym_BSLASHAcs] = ACTIONS(187),
    [anon_sym_BSLASHacsp] = ACTIONS(187),
    [anon_sym_BSLASHAcsp] = ACTIONS(187),
    [anon_sym_BSLASHacl] = ACTIONS(187),
    [anon_sym_BSLASHAcl] = ACTIONS(187),
    [anon_sym_BSLASHaclp] = ACTIONS(187),
    [anon_sym_BSLASHAclp] = ACTIONS(187),
    [anon_sym_BSLASHacf] = ACTIONS(187),
    [anon_sym_BSLASHAcf] = ACTIONS(187),
    [anon_sym_BSLASHacfp] = ACTIONS(187),
    [anon_sym_BSLASHAcfp] = ACTIONS(187),
    [anon_sym_BSLASHac] = ACTIONS(187),
    [anon_sym_BSLASHAc] = ACTIONS(187),
    [anon_sym_BSLASHacp] = ACTIONS(187),
    [anon_sym_BSLASHglsentrylong] = ACTIONS(187),
    [anon_sym_BSLASHGlsentrylong] = ACTIONS(187),
    [anon_sym_BSLASHglsentrylongpl] = ACTIONS(187),
    [anon_sym_BSLASHGlsentrylongpl] = ACTIONS(187),
    [anon_sym_BSLASHglsentryshort] = ACTIONS(187),
    [anon_sym_BSLASHGlsentryshort] = ACTIONS(187),
    [anon_sym_BSLASHglsentryshortpl] = ACTIONS(187),
    [anon_sym_BSLASHGlsentryshortpl] = ACTIONS(187),
    [anon_sym_BSLASHglsentryfullpl] = ACTIONS(187),
    [anon_sym_BSLASHGlsentryfullpl] = ACTIONS(187),
    [anon_sym_BSLASHnewtheorem] = ACTIONS(187),
    [anon_sym_BSLASHnewtheorem_STAR] = ACTIONS(185),
    [anon_sym_BSLASHdeclaretheorem] = ACTIONS(187),
    [anon_sym_BSLASHdeclaretheorem_STAR] = ACTIONS(185),
    [anon_sym_BSLASHdefinecolor] = ACTIONS(187),
    [anon_sym_BSLASHdefinecolorset] = ACTIONS(187),
    [anon_sym_BSLASHcolor] = ACTIONS(187),
    [anon_sym_BSLASHcolorbox] = ACTIONS(187),
    [anon_sym_BSLASHtextcolor] = ACTIONS(187),
    [anon_sym_BSLASHpagecolor] = ACTIONS(187),
    [anon_sym_BSLASHusepgflibrary] = ACTIONS(187),
    [anon_sym_BSLASHusetikzlibrary] = ACTIONS(187),
    [anon_sym_BSLASHtext] = ACTIONS(187),
    [anon_sym_BSLASHintertext] = ACTIONS(187),
    [anon_sym_shortintertext] = ACTIONS(187),
  },
  [5] = {
    [sym_block_comment] = STATE(27),
    [sym__root_content] = STATE(27),
    [sym__flat_content] = STATE(27),
    [sym__text_with_env_content] = STATE(27),
    [sym__text_content] = STATE(27),
    [sym__section] = STATE(27),
    [sym__part_declaration] = STATE(175),
    [sym_part] = STATE(367),
    [sym__chapter_declaration] = STATE(177),
    [sym_chapter] = STATE(368),
    [sym__section_declaration] = STATE(187),
    [sym_section] = STATE(369),
    [sym__subsection_declaration] = STATE(196),
    [sym_subsection] = STATE(370),
    [sym__subsubsection_declaration] = STATE(207),
    [sym_subsubsection] = STATE(371),
    [sym__paragraph_declaration] = STATE(218),
    [sym_paragraph] = STATE(373),
    [sym__subparagraph_declaration] = STATE(228),
    [sym_subparagraph] = STATE(374),
    [sym__enum_itemdeclaration] = STATE(238),
    [sym_enum_item] = STATE(375),
    [sym_curly_group] = STATE(27),
    [sym_text] = STATE(27),
    [sym_operator] = STATE(484),
    [sym_subscript] = STATE(484),
    [sym_superscript] = STATE(484),
    [sym_displayed_equation] = STATE(27),
    [sym_inline_formula] = STATE(27),
    [sym_begin] = STATE(65),
    [sym_generic_environment] = STATE(27),
    [sym_comment_environment] = STATE(27),
    [sym__comment_environment_begin] = STATE(3120),
    [sym_verbatim_environment] = STATE(27),
    [sym__verbatim_environment_begin] = STATE(3121),
    [sym_listing_environment] = STATE(27),
    [sym__listing_environment_begin] = STATE(3122),
    [sym_minted_environment] = STATE(27),
    [sym__minted_environment_begin] = STATE(3123),
    [sym_pycode_environment] = STATE(27),
    [sym__pycode_environment_begin] = STATE(3124),
    [sym_math_environment] = STATE(27),
    [sym__math_environment_begin] = STATE(269),
    [sym__command] = STATE(27),
    [sym_generic_command] = STATE(27),
    [sym_title_declaration] = STATE(27),
    [sym_author_declaration] = STATE(27),
    [sym_package_include] = STATE(27),
    [sym_class_include] = STATE(27),
    [sym_latex_include] = STATE(27),
    [sym_biblatex_include] = STATE(27),
    [sym_bibtex_include] = STATE(27),
    [sym_graphics_include] = STATE(27),
    [sym_svg_include] = STATE(27),
    [sym_inkscape_include] = STATE(27),
    [sym_verbatim_include] = STATE(27),
    [sym_import_include] = STATE(27),
    [sym_caption] = STATE(27),
    [sym_citation] = STATE(27),
    [sym_label_definition] = STATE(27),
    [sym_label_reference] = STATE(27),
    [sym_label_reference_range] = STATE(27),
    [sym_label_number] = STATE(27),
    [sym_new_command_definition] = STATE(27),
    [sym_old_command_definition] = STATE(27),
    [sym_let_command_definition] = STATE(27),
    [sym_math_delimiter] = STATE(27),
    [sym_paired_delimiter_definition] = STATE(27),
    [sym_environment_definition] = STATE(27),
    [sym_glossary_entry_definition] = STATE(27),
    [sym_glossary_entry_reference] = STATE(27),
    [sym_acronym_definition] = STATE(27),
    [sym_acronym_reference] = STATE(27),
    [sym_theorem_definition] = STATE(27),
    [sym_color_definition] = STATE(27),
    [sym_color_set_definition] = STATE(27),
    [sym_color_reference] = STATE(27),
    [sym_tikz_library_import] = STATE(27),
    [sym_text_mode] = STATE(27),
    [aux_sym_source_file_repeat1] = STATE(27),
    [aux_sym__section_repeat1] = STATE(367),
    [aux_sym__section_repeat2] = STATE(368),
    [aux_sym__section_repeat3] = STATE(369),
    [aux_sym__section_repeat4] = STATE(370),
    [aux_sym__section_repeat5] = STATE(371),
    [aux_sym__section_repeat6] = STATE(373),
    [aux_sym__section_repeat7] = STATE(374),
    [aux_sym__section_repeat8] = STATE(375),
    [aux_sym_text_repeat1] = STATE(259),
    [sym_command_name] = ACTIONS(187),
    [sym__whitespace] = ACTIONS(3),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_BSLASHiffalse] = ACTIONS(187),
    [anon_sym_LBRACK] = ACTIONS(147),
    [anon_sym_RBRACK] = ACTIONS(147),
    [anon_sym_COMMA] = ACTIONS(147),
    [anon_sym_EQ] = ACTIONS(147),
    [anon_sym_LPAREN] = ACTIONS(185),
    [anon_sym_RPAREN] = ACTIONS(185),
    [anon_sym_BSLASHpart] = ACTIONS(151),
    [anon_sym_BSLASHpart_STAR] = ACTIONS(153),
    [anon_sym_BSLASHaddpart] = ACTIONS(151),
    [anon_sym_BSLASHaddpart_STAR] = ACTIONS(153),
    [anon_sym_BSLASHchapter] = ACTIONS(155),
    [anon_sym_BSLASHchapter_STAR] = ACTIONS(157),
    [anon_sym_BSLASHaddchap] = ACTIONS(155),
    [anon_sym_BSLASHaddchap_STAR] = ACTIONS(157),
    [anon_sym_BSLASHsection] = ACTIONS(159),
    [anon_sym_BSLASHsection_STAR] = ACTIONS(161),
    [anon_sym_BSLASHaddsec] = ACTIONS(159),
    [anon_sym_BSLASHaddsec_STAR] = ACTIONS(161),
    [anon_sym_BSLASHsubsection] = ACTIONS(163),
    [anon_sym_BSLASHsubsection_STAR] = ACTIONS(165),
    [anon_sym_BSLASHsubsubsection] = ACTIONS(167),
    [anon_sym_BSLASHsubsubsection_STAR] = ACTIONS(169),
    [anon_sym_BSLASHparagraph] = ACTIONS(171),
    [anon_sym_BSLASHparagraph_STAR] = ACTIONS(173),
    [anon_sym_BSLASHsubparagraph] = ACTIONS(175),
    [anon_sym_BSLASHsubparagraph_STAR] = ACTIONS(177),
    [anon_sym_BSLASHitem] = ACTIONS(179),
    [anon_sym_BSLASHitem_STAR] = ACTIONS(181),
    [anon_sym_LBRACE] = ACTIONS(185),
    [anon_sym_RBRACE] = ACTIONS(185),
    [anon_sym_BSLASHand] = ACTIONS(187),
    [sym_word] = ACTIONS(187),
    [sym_placeholder] = ACTIONS(185),
    [anon_sym_PLUS] = ACTIONS(185),
    [anon_sym_DASH] = ACTIONS(185),
    [anon_sym_STAR] = ACTIONS(185),
    [anon_sym_SLASH] = ACTIONS(185),
    [anon_sym_LT] = ACTIONS(187),
    [anon_sym_GT] = ACTIONS(187),
    [anon_sym_BANG] = ACTIONS(187),
    [anon_sym_PIPE] = ACTIONS(187),
    [anon_sym_COLON] = ACTIONS(187),
    [anon_sym_SQUOTE] = ACTIONS(187),
    [anon_sym__] = ACTIONS(185),
    [anon_sym_CARET] = ACTIONS(185),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(185),
    [anon_sym_BSLASH_LBRACK] = ACTIONS(185),
    [anon_sym_DOLLAR] = ACTIONS(187),
    [anon_sym_BSLASH_LPAREN] = ACTIONS(185),
    [anon_sym_BSLASHbegin] = ACTIONS(65),
    [anon_sym_BSLASHtitle] = ACTIONS(187),
    [anon_sym_BSLASHauthor] = ACTIONS(187),
    [anon_sym_BSLASHusepackage] = ACTIONS(187),
    [anon_sym_BSLASHRequirePackage] = ACTIONS(187),
    [anon_sym_BSLASHdocumentclass] = ACTIONS(187),
    [anon_sym_BSLASHinclude] = ACTIONS(187),
    [anon_sym_BSLASHsubfileinclude] = ACTIONS(187),
    [anon_sym_BSLASHinput] = ACTIONS(187),
    [anon_sym_BSLASHsubfile] = ACTIONS(187),
    [anon_sym_BSLASHaddbibresource] = ACTIONS(187),
    [anon_sym_BSLASHbibliography] = ACTIONS(187),
    [anon_sym_BSLASHincludegraphics] = ACTIONS(187),
    [anon_sym_BSLASHincludesvg] = ACTIONS(187),
    [anon_sym_BSLASHincludeinkscape] = ACTIONS(187),
    [anon_sym_BSLASHverbatiminput] = ACTIONS(187),
    [anon_sym_BSLASHVerbatimInput] = ACTIONS(187),
    [anon_sym_BSLASHimport] = ACTIONS(187),
    [anon_sym_BSLASHsubimport] = ACTIONS(187),
    [anon_sym_BSLASHinputfrom] = ACTIONS(187),
    [anon_sym_BSLASHsubimportfrom] = ACTIONS(187),
    [anon_sym_BSLASHincludefrom] = ACTIONS(187),
    [anon_sym_BSLASHsubincludefrom] = ACTIONS(187),
    [anon_sym_BSLASHcaption] = ACTIONS(187),
    [anon_sym_BSLASHcite] = ACTIONS(187),
    [anon_sym_BSLASHcite_STAR] = ACTIONS(185),
    [anon_sym_BSLASHCite] = ACTIONS(187),
    [anon_sym_BSLASHnocite] = ACTIONS(187),
    [anon_sym_BSLASHcitet] = ACTIONS(187),
    [anon_sym_BSLASHcitep] = ACTIONS(187),
    [anon_sym_BSLASHcitet_STAR] = ACTIONS(185),
    [anon_sym_BSLASHcitep_STAR] = ACTIONS(185),
    [anon_sym_BSLASHciteauthor] = ACTIONS(187),
    [anon_sym_BSLASHciteauthor_STAR] = ACTIONS(185),
    [anon_sym_BSLASHCiteauthor] = ACTIONS(187),
    [anon_sym_BSLASHCiteauthor_STAR] = ACTIONS(185),
    [anon_sym_BSLASHcitetitle] = ACTIONS(187),
    [anon_sym_BSLASHcitetitle_STAR] = ACTIONS(185),
    [anon_sym_BSLASHciteyear] = ACTIONS(187),
    [anon_sym_BSLASHciteyear_STAR] = ACTIONS(185),
    [anon_sym_BSLASHcitedate] = ACTIONS(187),
    [anon_sym_BSLASHcitedate_STAR] = ACTIONS(185),
    [anon_sym_BSLASHciteurl] = ACTIONS(187),
    [anon_sym_BSLASHfullcite] = ACTIONS(187),
    [anon_sym_BSLASHciteyearpar] = ACTIONS(187),
    [anon_sym_BSLASHcitealt] = ACTIONS(187),
    [anon_sym_BSLASHcitealp] = ACTIONS(187),
    [anon_sym_BSLASHcitetext] = ACTIONS(187),
    [anon_sym_BSLASHparencite] = ACTIONS(187),
    [anon_sym_BSLASHparencite_STAR] = ACTIONS(185),
    [anon_sym_BSLASHParencite] = ACTIONS(187),
    [anon_sym_BSLASHfootcite] = ACTIONS(187),
    [anon_sym_BSLASHfootfullcite] = ACTIONS(187),
    [anon_sym_BSLASHfootcitetext] = ACTIONS(187),
    [anon_sym_BSLASHtextcite] = ACTIONS(187),
    [anon_sym_BSLASHTextcite] = ACTIONS(187),
    [anon_sym_BSLASHsmartcite] = ACTIONS(187),
    [anon_sym_BSLASHSmartcite] = ACTIONS(187),
    [anon_sym_BSLASHsupercite] = ACTIONS(187),
    [anon_sym_BSLASHautocite] = ACTIONS(187),
    [anon_sym_BSLASHAutocite] = ACTIONS(187),
    [anon_sym_BSLASHautocite_STAR] = ACTIONS(185),
    [anon_sym_BSLASHAutocite_STAR] = ACTIONS(185),
    [anon_sym_BSLASHvolcite] = ACTIONS(187),
    [anon_sym_BSLASHVolcite] = ACTIONS(187),
    [anon_sym_BSLASHpvolcite] = ACTIONS(187),
    [anon_sym_BSLASHPvolcite] = ACTIONS(187),
    [anon_sym_BSLASHfvolcite] = ACTIONS(187),
    [anon_sym_BSLASHftvolcite] = ACTIONS(187),
    [anon_sym_BSLASHsvolcite] = ACTIONS(187),
    [anon_sym_BSLASHSvolcite] = ACTIONS(187),
    [anon_sym_BSLASHtvolcite] = ACTIONS(187),
    [anon_sym_BSLASHTvolcite] = ACTIONS(187),
    [anon_sym_BSLASHavolcite] = ACTIONS(187),
    [anon_sym_BSLASHAvolcite] = ACTIONS(187),
    [anon_sym_BSLASHnotecite] = ACTIONS(187),
    [anon_sym_BSLASHNotecite] = ACTIONS(187),
    [anon_sym_BSLASHpnotecite] = ACTIONS(187),
    [anon_sym_BSLASHPnotecite] = ACTIONS(187),
    [anon_sym_BSLASHfnotecite] = ACTIONS(187),
    [anon_sym_BSLASHlabel] = ACTIONS(187),
    [anon_sym_BSLASHref] = ACTIONS(187),
    [anon_sym_BSLASHeqref] = ACTIONS(187),
    [anon_sym_BSLASHvref] = ACTIONS(187),
    [anon_sym_BSLASHVref] = ACTIONS(187),
    [anon_sym_BSLASHautoref] = ACTIONS(187),
    [anon_sym_BSLASHpageref] = ACTIONS(187),
    [anon_sym_BSLASHcref] = ACTIONS(187),
    [anon_sym_BSLASHCref] = ACTIONS(187),
    [anon_sym_BSLASHcref_STAR] = ACTIONS(185),
    [anon_sym_BSLASHCref_STAR] = ACTIONS(185),
    [anon_sym_BSLASHnamecref] = ACTIONS(187),
    [anon_sym_BSLASHnameCref] = ACTIONS(187),
    [anon_sym_BSLASHlcnamecref] = ACTIONS(187),
    [anon_sym_BSLASHnamecrefs] = ACTIONS(187),
    [anon_sym_BSLASHnameCrefs] = ACTIONS(187),
    [anon_sym_BSLASHlcnamecrefs] = ACTIONS(187),
    [anon_sym_BSLASHlabelcref] = ACTIONS(187),
    [anon_sym_BSLASHlabelcpageref] = ACTIONS(187),
    [anon_sym_BSLASHcrefrange] = ACTIONS(187),
    [anon_sym_BSLASHcrefrange_STAR] = ACTIONS(185),
    [anon_sym_BSLASHCrefrange] = ACTIONS(187),
    [anon_sym_BSLASHCrefrange_STAR] = ACTIONS(185),
    [anon_sym_BSLASHnewlabel] = ACTIONS(187),
    [anon_sym_BSLASHnewcommand] = ACTIONS(187),
    [anon_sym_BSLASHnewcommand_STAR] = ACTIONS(185),
    [anon_sym_BSLASHrenewcommand] = ACTIONS(187),
    [anon_sym_BSLASHrenewcommand_STAR] = ACTIONS(185),
    [anon_sym_BSLASHDeclareRobustCommand] = ACTIONS(187),
    [anon_sym_BSLASHDeclareRobustCommand_STAR] = ACTIONS(185),
    [anon_sym_BSLASHDeclareMathOperator] = ACTIONS(187),
    [anon_sym_BSLASHDeclareMathOperator_STAR] = ACTIONS(185),
    [anon_sym_BSLASHNewDocumentCommand] = ACTIONS(187),
    [anon_sym_BSLASHRenewDocumentCommand] = ACTIONS(187),
    [anon_sym_BSLASHProvideDocumentCommand] = ACTIONS(187),
    [anon_sym_BSLASHDeclareDocumentCommand] = ACTIONS(187),
    [anon_sym_BSLASHNewExpandableDocumentCommand] = ACTIONS(187),
    [anon_sym_BSLASHRenewExpandableDocumentCommand] = ACTIONS(187),
    [anon_sym_BSLASHProvideExpandableDocumentCommand] = ACTIONS(187),
    [anon_sym_BSLASHDeclareExpandableDocumentCommand] = ACTIONS(187),
    [anon_sym_BSLASHdef] = ACTIONS(187),
    [anon_sym_BSLASHlet] = ACTIONS(187),
    [anon_sym_BSLASHleft] = ACTIONS(187),
    [anon_sym_BSLASHbig] = ACTIONS(187),
    [anon_sym_BSLASHBig] = ACTIONS(187),
    [anon_sym_BSLASHbigg] = ACTIONS(187),
    [anon_sym_BSLASHBigg] = ACTIONS(187),
    [anon_sym_BSLASHbigl] = ACTIONS(187),
    [anon_sym_BSLASHBigl] = ACTIONS(187),
    [anon_sym_BSLASHbiggl] = ACTIONS(187),
    [anon_sym_BSLASHBiggl] = ACTIONS(187),
    [anon_sym_BSLASHright] = ACTIONS(183),
    [anon_sym_BSLASHbigr] = ACTIONS(183),
    [anon_sym_BSLASHBigr] = ACTIONS(183),
    [anon_sym_BSLASHbiggr] = ACTIONS(183),
    [anon_sym_BSLASHBiggr] = ACTIONS(183),
    [anon_sym_BSLASHDeclarePairedDelimiter] = ACTIONS(187),
    [anon_sym_BSLASHDeclarePairedDelimiterX] = ACTIONS(187),
    [anon_sym_BSLASHnewenvironment] = ACTIONS(187),
    [anon_sym_BSLASHrenewenvironment] = ACTIONS(187),
    [anon_sym_BSLASHNewDocumentEnvironment] = ACTIONS(187),
    [anon_sym_BSLASHRenewDocumentEnvironment] = ACTIONS(187),
    [anon_sym_BSLASHProvideDocumentEnvironment] = ACTIONS(187),
    [anon_sym_BSLASHDeclareDocumentEnvironment] = ACTIONS(187),
    [anon_sym_BSLASHnewglossaryentry] = ACTIONS(187),
    [anon_sym_BSLASHgls] = ACTIONS(187),
    [anon_sym_BSLASHGls] = ACTIONS(187),
    [anon_sym_BSLASHGLS] = ACTIONS(187),
    [anon_sym_BSLASHglspl] = ACTIONS(187),
    [anon_sym_BSLASHGlspl] = ACTIONS(187),
    [anon_sym_BSLASHGLSpl] = ACTIONS(187),
    [anon_sym_BSLASHglsdisp] = ACTIONS(187),
    [anon_sym_BSLASHglslink] = ACTIONS(187),
    [anon_sym_BSLASHglstext] = ACTIONS(187),
    [anon_sym_BSLASHGlstext] = ACTIONS(187),
    [anon_sym_BSLASHGLStext] = ACTIONS(187),
    [anon_sym_BSLASHglsfirst] = ACTIONS(187),
    [anon_sym_BSLASHGlsfirst] = ACTIONS(187),
    [anon_sym_BSLASHGLSfirst] = ACTIONS(187),
    [anon_sym_BSLASHglsplural] = ACTIONS(187),
    [anon_sym_BSLASHGlsplural] = ACTIONS(187),
    [anon_sym_BSLASHGLSplural] = ACTIONS(187),
    [anon_sym_BSLASHglsfirstplural] = ACTIONS(187),
    [anon_sym_BSLASHGlsfirstplural] = ACTIONS(187),
    [anon_sym_BSLASHGLSfirstplural] = ACTIONS(187),
    [anon_sym_BSLASHglsname] = ACTIONS(187),
    [anon_sym_BSLASHGlsname] = ACTIONS(187),
    [anon_sym_BSLASHGLSname] = ACTIONS(187),
    [anon_sym_BSLASHglssymbol] = ACTIONS(187),
    [anon_sym_BSLASHGlssymbol] = ACTIONS(187),
    [anon_sym_BSLASHglsdesc] = ACTIONS(187),
    [anon_sym_BSLASHGlsdesc] = ACTIONS(187),
    [anon_sym_BSLASHGLSdesc] = ACTIONS(187),
    [anon_sym_BSLASHglsuseri] = ACTIONS(187),
    [anon_sym_BSLASHGlsuseri] = ACTIONS(187),
    [anon_sym_BSLASHGLSuseri] = ACTIONS(187),
    [anon_sym_BSLASHglsuserii] = ACTIONS(187),
    [anon_sym_BSLASHGlsuserii] = ACTIONS(187),
    [anon_sym_BSLASHGLSuserii] = ACTIONS(187),
    [anon_sym_BSLASHglsuseriii] = ACTIONS(187),
    [anon_sym_BSLASHGlsuseriii] = ACTIONS(187),
    [anon_sym_BSLASHGLSuseriii] = ACTIONS(187),
    [anon_sym_BSLASHglsuseriv] = ACTIONS(187),
    [anon_sym_BSLASHGlsuseriv] = ACTIONS(187),
    [anon_sym_BSLASHGLSuseriv] = ACTIONS(187),
    [anon_sym_BSLASHglsuserv] = ACTIONS(187),
    [anon_sym_BSLASHGlsuserv] = ACTIONS(187),
    [anon_sym_BSLASHGLSuserv] = ACTIONS(187),
    [anon_sym_BSLASHglsuservi] = ACTIONS(187),
    [anon_sym_BSLASHGlsuservi] = ACTIONS(187),
    [anon_sym_BSLASHGLSuservi] = ACTIONS(187),
    [anon_sym_BSLASHnewacronym] = ACTIONS(187),
    [anon_sym_BSLASHacrshort] = ACTIONS(187),
    [anon_sym_BSLASHAcrshort] = ACTIONS(187),
    [anon_sym_BSLASHACRshort] = ACTIONS(187),
    [anon_sym_BSLASHacrshortpl] = ACTIONS(187),
    [anon_sym_BSLASHAcrshortpl] = ACTIONS(187),
    [anon_sym_BSLASHACRshortpl] = ACTIONS(187),
    [anon_sym_BSLASHacrlong] = ACTIONS(187),
    [anon_sym_BSLASHAcrlong] = ACTIONS(187),
    [anon_sym_BSLASHACRlong] = ACTIONS(187),
    [anon_sym_BSLASHacrlongpl] = ACTIONS(187),
    [anon_sym_BSLASHAcrlongpl] = ACTIONS(187),
    [anon_sym_BSLASHACRlongpl] = ACTIONS(187),
    [anon_sym_BSLASHacrfull] = ACTIONS(187),
    [anon_sym_BSLASHAcrfull] = ACTIONS(187),
    [anon_sym_BSLASHACRfull] = ACTIONS(187),
    [anon_sym_BSLASHacrfullpl] = ACTIONS(187),
    [anon_sym_BSLASHAcrfullpl] = ACTIONS(187),
    [anon_sym_BSLASHACRfullpl] = ACTIONS(187),
    [anon_sym_BSLASHacs] = ACTIONS(187),
    [anon_sym_BSLASHAcs] = ACTIONS(187),
    [anon_sym_BSLASHacsp] = ACTIONS(187),
    [anon_sym_BSLASHAcsp] = ACTIONS(187),
    [anon_sym_BSLASHacl] = ACTIONS(187),
    [anon_sym_BSLASHAcl] = ACTIONS(187),
    [anon_sym_BSLASHaclp] = ACTIONS(187),
    [anon_sym_BSLASHAclp] = ACTIONS(187),
    [anon_sym_BSLASHacf] = ACTIONS(187),
    [anon_sym_BSLASHAcf] = ACTIONS(187),
    [anon_sym_BSLASHacfp] = ACTIONS(187),
    [anon_sym_BSLASHAcfp] = ACTIONS(187),
    [anon_sym_BSLASHac] = ACTIONS(187),
    [anon_sym_BSLASHAc] = ACTIONS(187),
    [anon_sym_BSLASHacp] = ACTIONS(187),
    [anon_sym_BSLASHglsentrylong] = ACTIONS(187),
    [anon_sym_BSLASHGlsentrylong] = ACTIONS(187),
    [anon_sym_BSLASHglsentrylongpl] = ACTIONS(187),
    [anon_sym_BSLASHGlsentrylongpl] = ACTIONS(187),
    [anon_sym_BSLASHglsentryshort] = ACTIONS(187),
    [anon_sym_BSLASHGlsentryshort] = ACTIONS(187),
    [anon_sym_BSLASHglsentryshortpl] = ACTIONS(187),
    [anon_sym_BSLASHGlsentryshortpl] = ACTIONS(187),
    [anon_sym_BSLASHglsentryfullpl] = ACTIONS(187),
    [anon_sym_BSLASHGlsentryfullpl] = ACTIONS(187),
    [anon_sym_BSLASHnewtheorem] = ACTIONS(187),
    [anon_sym_BSLASHnewtheorem_STAR] = ACTIONS(185),
    [anon_sym_BSLASHdeclaretheorem] = ACTIONS(187),
    [anon_sym_BSLASHdeclaretheorem_STAR] = ACTIONS(185),
    [anon_sym_BSLASHdefinecolor] = ACTIONS(187),
    [anon_sym_BSLASHdefinecolorset] = ACTIONS(187),
    [anon_sym_BSLASHcolor] = ACTIONS(187),
    [anon_sym_BSLASHcolorbox] = ACTIONS(187),
    [anon_sym_BSLASHtextcolor] = ACTIONS(187),
    [anon_sym_BSLASHpagecolor] = ACTIONS(187),
    [anon_sym_BSLASHusepgflibrary] = ACTIONS(187),
    [anon_sym_BSLASHusetikzlibrary] = ACTIONS(187),
    [anon_sym_BSLASHtext] = ACTIONS(187),
    [anon_sym_BSLASHintertext] = ACTIONS(187),
    [anon_sym_shortintertext] = ACTIONS(187),
  },
  [6] = {
    [sym_block_comment] = STATE(27),
    [sym__root_content] = STATE(27),
    [sym__flat_content] = STATE(27),
    [sym__text_with_env_content] = STATE(27),
    [sym__text_content] = STATE(27),
    [sym__section] = STATE(27),
    [sym__part_declaration] = STATE(175),
    [sym_part] = STATE(367),
    [sym__chapter_declaration] = STATE(177),
    [sym_chapter] = STATE(368),
    [sym__section_declaration] = STATE(187),
    [sym_section] = STATE(369),
    [sym__subsection_declaration] = STATE(196),
    [sym_subsection] = STATE(370),
    [sym__subsubsection_declaration] = STATE(207),
    [sym_subsubsection] = STATE(371),
    [sym__paragraph_declaration] = STATE(218),
    [sym_paragraph] = STATE(373),
    [sym__subparagraph_declaration] = STATE(228),
    [sym_subparagraph] = STATE(374),
    [sym__enum_itemdeclaration] = STATE(238),
    [sym_enum_item] = STATE(375),
    [sym_curly_group] = STATE(27),
    [sym_text] = STATE(27),
    [sym_operator] = STATE(484),
    [sym_subscript] = STATE(484),
    [sym_superscript] = STATE(484),
    [sym_displayed_equation] = STATE(27),
    [sym_inline_formula] = STATE(27),
    [sym_begin] = STATE(65),
    [sym_generic_environment] = STATE(27),
    [sym_comment_environment] = STATE(27),
    [sym__comment_environment_begin] = STATE(3120),
    [sym_verbatim_environment] = STATE(27),
    [sym__verbatim_environment_begin] = STATE(3121),
    [sym_listing_environment] = STATE(27),
    [sym__listing_environment_begin] = STATE(3122),
    [sym_minted_environment] = STATE(27),
    [sym__minted_environment_begin] = STATE(3123),
    [sym_pycode_environment] = STATE(27),
    [sym__pycode_environment_begin] = STATE(3124),
    [sym_math_environment] = STATE(27),
    [sym__math_environment_begin] = STATE(269),
    [sym__command] = STATE(27),
    [sym_generic_command] = STATE(27),
    [sym_title_declaration] = STATE(27),
    [sym_author_declaration] = STATE(27),
    [sym_package_include] = STATE(27),
    [sym_class_include] = STATE(27),
    [sym_latex_include] = STATE(27),
    [sym_biblatex_include] = STATE(27),
    [sym_bibtex_include] = STATE(27),
    [sym_graphics_include] = STATE(27),
    [sym_svg_include] = STATE(27),
    [sym_inkscape_include] = STATE(27),
    [sym_verbatim_include] = STATE(27),
    [sym_import_include] = STATE(27),
    [sym_caption] = STATE(27),
    [sym_citation] = STATE(27),
    [sym_label_definition] = STATE(27),
    [sym_label_reference] = STATE(27),
    [sym_label_reference_range] = STATE(27),
    [sym_label_number] = STATE(27),
    [sym_new_command_definition] = STATE(27),
    [sym_old_command_definition] = STATE(27),
    [sym_let_command_definition] = STATE(27),
    [sym_math_delimiter] = STATE(27),
    [sym_paired_delimiter_definition] = STATE(27),
    [sym_environment_definition] = STATE(27),
    [sym_glossary_entry_definition] = STATE(27),
    [sym_glossary_entry_reference] = STATE(27),
    [sym_acronym_definition] = STATE(27),
    [sym_acronym_reference] = STATE(27),
    [sym_theorem_definition] = STATE(27),
    [sym_color_definition] = STATE(27),
    [sym_color_set_definition] = STATE(27),
    [sym_color_reference] = STATE(27),
    [sym_tikz_library_import] = STATE(27),
    [sym_text_mode] = STATE(27),
    [aux_sym_source_file_repeat1] = STATE(27),
    [aux_sym__section_repeat1] = STATE(367),
    [aux_sym__section_repeat2] = STATE(368),
    [aux_sym__section_repeat3] = STATE(369),
    [aux_sym__section_repeat4] = STATE(370),
    [aux_sym__section_repeat5] = STATE(371),
    [aux_sym__section_repeat6] = STATE(373),
    [aux_sym__section_repeat7] = STATE(374),
    [aux_sym__section_repeat8] = STATE(375),
    [aux_sym_text_repeat1] = STATE(259),
    [sym_command_name] = ACTIONS(145),
    [sym__whitespace] = ACTIONS(3),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_BSLASHiffalse] = ACTIONS(145),
    [anon_sym_LBRACK] = ACTIONS(149),
    [anon_sym_RBRACK] = ACTIONS(149),
    [anon_sym_COMMA] = ACTIONS(149),
    [anon_sym_EQ] = ACTIONS(149),
    [anon_sym_LPAREN] = ACTIONS(149),
    [anon_sym_RPAREN] = ACTIONS(149),
    [anon_sym_BSLASHpart] = ACTIONS(151),
    [anon_sym_BSLASHpart_STAR] = ACTIONS(153),
    [anon_sym_BSLASHaddpart] = ACTIONS(151),
    [anon_sym_BSLASHaddpart_STAR] = ACTIONS(153),
    [anon_sym_BSLASHchapter] = ACTIONS(155),
    [anon_sym_BSLASHchapter_STAR] = ACTIONS(157),
    [anon_sym_BSLASHaddchap] = ACTIONS(155),
    [anon_sym_BSLASHaddchap_STAR] = ACTIONS(157),
    [anon_sym_BSLASHsection] = ACTIONS(159),
    [anon_sym_BSLASHsection_STAR] = ACTIONS(161),
    [anon_sym_BSLASHaddsec] = ACTIONS(159),
    [anon_sym_BSLASHaddsec_STAR] = ACTIONS(161),
    [anon_sym_BSLASHsubsection] = ACTIONS(163),
    [anon_sym_BSLASHsubsection_STAR] = ACTIONS(165),
    [anon_sym_BSLASHsubsubsection] = ACTIONS(167),
    [anon_sym_BSLASHsubsubsection_STAR] = ACTIONS(169),
    [anon_sym_BSLASHparagraph] = ACTIONS(171),
    [anon_sym_BSLASHparagraph_STAR] = ACTIONS(173),
    [anon_sym_BSLASHsubparagraph] = ACTIONS(175),
    [anon_sym_BSLASHsubparagraph_STAR] = ACTIONS(177),
    [anon_sym_BSLASHitem] = ACTIONS(179),
    [anon_sym_BSLASHitem_STAR] = ACTIONS(181),
    [anon_sym_LBRACE] = ACTIONS(149),
    [sym_word] = ACTIONS(145),
    [sym_placeholder] = ACTIONS(149),
    [anon_sym_PLUS] = ACTIONS(149),
    [anon_sym_DASH] = ACTIONS(149),
    [anon_sym_STAR] = ACTIONS(149),
    [anon_sym_SLASH] = ACTIONS(149),
    [anon_sym_LT] = ACTIONS(145),
    [anon_sym_GT] = ACTIONS(145),
    [anon_sym_BANG] = ACTIONS(145),
    [anon_sym_PIPE] = ACTIONS(145),
    [anon_sym_COLON] = ACTIONS(145),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [anon_sym__] = ACTIONS(149),
    [anon_sym_CARET] = ACTIONS(149),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(149),
    [anon_sym_BSLASH_LBRACK] = ACTIONS(149),
    [anon_sym_DOLLAR] = ACTIONS(145),
    [anon_sym_BSLASH_LPAREN] = ACTIONS(149),
    [anon_sym_BSLASHbegin] = ACTIONS(145),
    [anon_sym_BSLASHend] = ACTIONS(145),
    [anon_sym_BSLASHtitle] = ACTIONS(145),
    [anon_sym_BSLASHauthor] = ACTIONS(145),
    [anon_sym_BSLASHusepackage] = ACTIONS(145),
    [anon_sym_BSLASHRequirePackage] = ACTIONS(145),
    [anon_sym_BSLASHdocumentclass] = ACTIONS(145),
    [anon_sym_BSLASHinclude] = ACTIONS(145),
    [anon_sym_BSLASHsubfileinclude] = ACTIONS(145),
    [anon_sym_BSLASHinput] = ACTIONS(145),
    [anon_sym_BSLASHsubfile] = ACTIONS(145),
    [anon_sym_BSLASHaddbibresource] = ACTIONS(145),
    [anon_sym_BSLASHbibliography] = ACTIONS(145),
    [anon_sym_BSLASHincludegraphics] = ACTIONS(145),
    [anon_sym_BSLASHincludesvg] = ACTIONS(145),
    [anon_sym_BSLASHincludeinkscape] = ACTIONS(145),
    [anon_sym_BSLASHverbatiminput] = ACTIONS(145),
    [anon_sym_BSLASHVerbatimInput] = ACTIONS(145),
    [anon_sym_BSLASHimport] = ACTIONS(145),
    [anon_sym_BSLASHsubimport] = ACTIONS(145),
    [anon_sym_BSLASHinputfrom] = ACTIONS(145),
    [anon_sym_BSLASHsubimportfrom] = ACTIONS(145),
    [anon_sym_BSLASHincludefrom] = ACTIONS(145),
    [anon_sym_BSLASHsubincludefrom] = ACTIONS(145),
    [anon_sym_BSLASHcaption] = ACTIONS(145),
    [anon_sym_BSLASHcite] = ACTIONS(145),
    [anon_sym_BSLASHcite_STAR] = ACTIONS(149),
    [anon_sym_BSLASHCite] = ACTIONS(145),
    [anon_sym_BSLASHnocite] = ACTIONS(145),
    [anon_sym_BSLASHcitet] = ACTIONS(145),
    [anon_sym_BSLASHcitep] = ACTIONS(145),
    [anon_sym_BSLASHcitet_STAR] = ACTIONS(149),
    [anon_sym_BSLASHcitep_STAR] = ACTIONS(149),
    [anon_sym_BSLASHciteauthor] = ACTIONS(145),
    [anon_sym_BSLASHciteauthor_STAR] = ACTIONS(149),
    [anon_sym_BSLASHCiteauthor] = ACTIONS(145),
    [anon_sym_BSLASHCiteauthor_STAR] = ACTIONS(149),
    [anon_sym_BSLASHcitetitle] = ACTIONS(145),
    [anon_sym_BSLASHcitetitle_STAR] = ACTIONS(149),
    [anon_sym_BSLASHciteyear] = ACTIONS(145),
    [anon_sym_BSLASHciteyear_STAR] = ACTIONS(149),
    [anon_sym_BSLASHcitedate] = ACTIONS(145),
    [anon_sym_BSLASHcitedate_STAR] = ACTIONS(149),
    [anon_sym_BSLASHciteurl] = ACTIONS(145),
    [anon_sym_BSLASHfullcite] = ACTIONS(145),
    [anon_sym_BSLASHciteyearpar] = ACTIONS(145),
    [anon_sym_BSLASHcitealt] = ACTIONS(145),
    [anon_sym_BSLASHcitealp] = ACTIONS(145),
    [anon_sym_BSLASHcitetext] = ACTIONS(145),
    [anon_sym_BSLASHparencite] = ACTIONS(145),
    [anon_sym_BSLASHparencite_STAR] = ACTIONS(149),
    [anon_sym_BSLASHParencite] = ACTIONS(145),
    [anon_sym_BSLASHfootcite] = ACTIONS(145),
    [anon_sym_BSLASHfootfullcite] = ACTIONS(145),
    [anon_sym_BSLASHfootcitetext] = ACTIONS(145),
    [anon_sym_BSLASHtextcite] = ACTIONS(145),
    [anon_sym_BSLASHTextcite] = ACTIONS(145),
    [anon_sym_BSLASHsmartcite] = ACTIONS(145),
    [anon_sym_BSLASHSmartcite] = ACTIONS(145),
    [anon_sym_BSLASHsupercite] = ACTIONS(145),
    [anon_sym_BSLASHautocite] = ACTIONS(145),
    [anon_sym_BSLASHAutocite] = ACTIONS(145),
    [anon_sym_BSLASHautocite_STAR] = ACTIONS(149),
    [anon_sym_BSLASHAutocite_STAR] = ACTIONS(149),
    [anon_sym_BSLASHvolcite] = ACTIONS(145),
    [anon_sym_BSLASHVolcite] = ACTIONS(145),
    [anon_sym_BSLASHpvolcite] = ACTIONS(145),
    [anon_sym_BSLASHPvolcite] = ACTIONS(145),
    [anon_sym_BSLASHfvolcite] = ACTIONS(145),
    [anon_sym_BSLASHftvolcite] = ACTIONS(145),
    [anon_sym_BSLASHsvolcite] = ACTIONS(145),
    [anon_sym_BSLASHSvolcite] = ACTIONS(145),
    [anon_sym_BSLASHtvolcite] = ACTIONS(145),
    [anon_sym_BSLASHTvolcite] = ACTIONS(145),
    [anon_sym_BSLASHavolcite] = ACTIONS(145),
    [anon_sym_BSLASHAvolcite] = ACTIONS(145),
    [anon_sym_BSLASHnotecite] = ACTIONS(145),
    [anon_sym_BSLASHNotecite] = ACTIONS(145),
    [anon_sym_BSLASHpnotecite] = ACTIONS(145),
    [anon_sym_BSLASHPnotecite] = ACTIONS(145),
    [anon_sym_BSLASHfnotecite] = ACTIONS(145),
    [anon_sym_BSLASHlabel] = ACTIONS(145),
    [anon_sym_BSLASHref] = ACTIONS(145),
    [anon_sym_BSLASHeqref] = ACTIONS(145),
    [anon_sym_BSLASHvref] = ACTIONS(145),
    [anon_sym_BSLASHVref] = ACTIONS(145),
    [anon_sym_BSLASHautoref] = ACTIONS(145),
    [anon_sym_BSLASHpageref] = ACTIONS(145),
    [anon_sym_BSLASHcref] = ACTIONS(145),
    [anon_sym_BSLASHCref] = ACTIONS(145),
    [anon_sym_BSLASHcref_STAR] = ACTIONS(149),
    [anon_sym_BSLASHCref_STAR] = ACTIONS(149),
    [anon_sym_BSLASHnamecref] = ACTIONS(145),
    [anon_sym_BSLASHnameCref] = ACTIONS(145),
    [anon_sym_BSLASHlcnamecref] = ACTIONS(145),
    [anon_sym_BSLASHnamecrefs] = ACTIONS(145),
    [anon_sym_BSLASHnameCrefs] = ACTIONS(145),
    [anon_sym_BSLASHlcnamecrefs] = ACTIONS(145),
    [anon_sym_BSLASHlabelcref] = ACTIONS(145),
    [anon_sym_BSLASHlabelcpageref] = ACTIONS(145),
    [anon_sym_BSLASHcrefrange] = ACTIONS(145),
    [anon_sym_BSLASHcrefrange_STAR] = ACTIONS(149),
    [anon_sym_BSLASHCrefrange] = ACTIONS(145),
    [anon_sym_BSLASHCrefrange_STAR] = ACTIONS(149),
    [anon_sym_BSLASHnewlabel] = ACTIONS(145),
    [anon_sym_BSLASHnewcommand] = ACTIONS(145),
    [anon_sym_BSLASHnewcommand_STAR] = ACTIONS(149),
    [anon_sym_BSLASHrenewcommand] = ACTIONS(145),
    [anon_sym_BSLASHrenewcommand_STAR] = ACTIONS(149),
    [anon_sym_BSLASHDeclareRobustCommand] = ACTIONS(145),
    [anon_sym_BSLASHDeclareRobustCommand_STAR] = ACTIONS(149),
    [anon_sym_BSLASHDeclareMathOperator] = ACTIONS(145),
    [anon_sym_BSLASHDeclareMathOperator_STAR] = ACTIONS(149),
    [anon_sym_BSLASHNewDocumentCommand] = ACTIONS(145),
    [anon_sym_BSLASHRenewDocumentCommand] = ACTIONS(145),
    [anon_sym_BSLASHProvideDocumentCommand] = ACTIONS(145),
    [anon_sym_BSLASHDeclareDocumentCommand] = ACTIONS(145),
    [anon_sym_BSLASHNewExpandableDocumentCommand] = ACTIONS(145),
    [anon_sym_BSLASHRenewExpandableDocumentCommand] = ACTIONS(145),
    [anon_sym_BSLASHProvideExpandableDocumentCommand] = ACTIONS(145),
    [anon_sym_BSLASHDeclareExpandableDocumentCommand] = ACTIONS(145),
    [anon_sym_BSLASHdef] = ACTIONS(145),
    [anon_sym_BSLASHlet] = ACTIONS(145),
    [anon_sym_BSLASHleft] = ACTIONS(145),
    [anon_sym_BSLASHbig] = ACTIONS(145),
    [anon_sym_BSLASHBig] = ACTIONS(145),
    [anon_sym_BSLASHbigg] = ACTIONS(145),
    [anon_sym_BSLASHBigg] = ACTIONS(145),
    [anon_sym_BSLASHbigl] = ACTIONS(145),
    [anon_sym_BSLASHBigl] = ACTIONS(145),
    [anon_sym_BSLASHbiggl] = ACTIONS(145),
    [anon_sym_BSLASHBiggl] = ACTIONS(145),
    [anon_sym_BSLASHright] = ACTIONS(183),
    [anon_sym_BSLASHbigr] = ACTIONS(183),
    [anon_sym_BSLASHBigr] = ACTIONS(183),
    [anon_sym_BSLASHbiggr] = ACTIONS(183),
    [anon_sym_BSLASHBiggr] = ACTIONS(183),
    [anon_sym_BSLASHDeclarePairedDelimiter] = ACTIONS(145),
    [anon_sym_BSLASHDeclarePairedDelimiterX] = ACTIONS(145),
    [anon_sym_BSLASHnewenvironment] = ACTIONS(145),
    [anon_sym_BSLASHrenewenvironment] = ACTIONS(145),
    [anon_sym_BSLASHNewDocumentEnvironment] = ACTIONS(145),
    [anon_sym_BSLASHRenewDocumentEnvironment] = ACTIONS(145),
    [anon_sym_BSLASHProvideDocumentEnvironment] = ACTIONS(145),
    [anon_sym_BSLASHDeclareDocumentEnvironment] = ACTIONS(145),
    [anon_sym_BSLASHnewglossaryentry] = ACTIONS(145),
    [anon_sym_BSLASHgls] = ACTIONS(145),
    [anon_sym_BSLASHGls] = ACTIONS(145),
    [anon_sym_BSLASHGLS] = ACTIONS(145),
    [anon_sym_BSLASHglspl] = ACTIONS(145),
    [anon_sym_BSLASHGlspl] = ACTIONS(145),
    [anon_sym_BSLASHGLSpl] = ACTIONS(145),
    [anon_sym_BSLASHglsdisp] = ACTIONS(145),
    [anon_sym_BSLASHglslink] = ACTIONS(145),
    [anon_sym_BSLASHglstext] = ACTIONS(145),
    [anon_sym_BSLASHGlstext] = ACTIONS(145),
    [anon_sym_BSLASHGLStext] = ACTIONS(145),
    [anon_sym_BSLASHglsfirst] = ACTIONS(145),
    [anon_sym_BSLASHGlsfirst] = ACTIONS(145),
    [anon_sym_BSLASHGLSfirst] = ACTIONS(145),
    [anon_sym_BSLASHglsplural] = ACTIONS(145),
    [anon_sym_BSLASHGlsplural] = ACTIONS(145),
    [anon_sym_BSLASHGLSplural] = ACTIONS(145),
    [anon_sym_BSLASHglsfirstplural] = ACTIONS(145),
    [anon_sym_BSLASHGlsfirstplural] = ACTIONS(145),
    [anon_sym_BSLASHGLSfirstplural] = ACTIONS(145),
    [anon_sym_BSLASHglsname] = ACTIONS(145),
    [anon_sym_BSLASHGlsname] = ACTIONS(145),
    [anon_sym_BSLASHGLSname] = ACTIONS(145),
    [anon_sym_BSLASHglssymbol] = ACTIONS(145),
    [anon_sym_BSLASHGlssymbol] = ACTIONS(145),
    [anon_sym_BSLASHglsdesc] = ACTIONS(145),
    [anon_sym_BSLASHGlsdesc] = ACTIONS(145),
    [anon_sym_BSLASHGLSdesc] = ACTIONS(145),
    [anon_sym_BSLASHglsuseri] = ACTIONS(145),
    [anon_sym_BSLASHGlsuseri] = ACTIONS(145),
    [anon_sym_BSLASHGLSuseri] = ACTIONS(145),
    [anon_sym_BSLASHglsuserii] = ACTIONS(145),
    [anon_sym_BSLASHGlsuserii] = ACTIONS(145),
    [anon_sym_BSLASHGLSuserii] = ACTIONS(145),
    [anon_sym_BSLASHglsuseriii] = ACTIONS(145),
    [anon_sym_BSLASHGlsuseriii] = ACTIONS(145),
    [anon_sym_BSLASHGLSuseriii] = ACTIONS(145),
    [anon_sym_BSLASHglsuseriv] = ACTIONS(145),
    [anon_sym_BSLASHGlsuseriv] = ACTIONS(145),
    [anon_sym_BSLASHGLSuseriv] = ACTIONS(145),
    [anon_sym_BSLASHglsuserv] = ACTIONS(145),
    [anon_sym_BSLASHGlsuserv] = ACTIONS(145),
    [anon_sym_BSLASHGLSuserv] = ACTIONS(145),
    [anon_sym_BSLASHglsuservi] = ACTIONS(145),
    [anon_sym_BSLASHGlsuservi] = ACTIONS(145),
    [anon_sym_BSLASHGLSuservi] = ACTIONS(145),
    [anon_sym_BSLASHnewacronym] = ACTIONS(145),
    [anon_sym_BSLASHacrshort] = ACTIONS(145),
    [anon_sym_BSLASHAcrshort] = ACTIONS(145),
    [anon_sym_BSLASHACRshort] = ACTIONS(145),
    [anon_sym_BSLASHacrshortpl] = ACTIONS(145),
    [anon_sym_BSLASHAcrshortpl] = ACTIONS(145),
    [anon_sym_BSLASHACRshortpl] = ACTIONS(145),
    [anon_sym_BSLASHacrlong] = ACTIONS(145),
    [anon_sym_BSLASHAcrlong] = ACTIONS(145),
    [anon_sym_BSLASHACRlong] = ACTIONS(145),
    [anon_sym_BSLASHacrlongpl] = ACTIONS(145),
    [anon_sym_BSLASHAcrlongpl] = ACTIONS(145),
    [anon_sym_BSLASHACRlongpl] = ACTIONS(145),
    [anon_sym_BSLASHacrfull] = ACTIONS(145),
    [anon_sym_BSLASHAcrfull] = ACTIONS(145),
    [anon_sym_BSLASHACRfull] = ACTIONS(145),
    [anon_sym_BSLASHacrfullpl] = ACTIONS(145),
    [anon_sym_BSLASHAcrfullpl] = ACTIONS(145),
    [anon_sym_BSLASHACRfullpl] = ACTIONS(145),
    [anon_sym_BSLASHacs] = ACTIONS(145),
    [anon_sym_BSLASHAcs] = ACTIONS(145),
    [anon_sym_BSLASHacsp] = ACTIONS(145),
    [anon_sym_BSLASHAcsp] = ACTIONS(145),
    [anon_sym_BSLASHacl] = ACTIONS(145),
    [anon_sym_BSLASHAcl] = ACTIONS(145),
    [anon_sym_BSLASHaclp] = ACTIONS(145),
    [anon_sym_BSLASHAclp] = ACTIONS(145),
    [anon_sym_BSLASHacf] = ACTIONS(145),
    [anon_sym_BSLASHAcf] = ACTIONS(145),
    [anon_sym_BSLASHacfp] = ACTIONS(145),
    [anon_sym_BSLASHAcfp] = ACTIONS(145),
    [anon_sym_BSLASHac] = ACTIONS(145),
    [anon_sym_BSLASHAc] = ACTIONS(145),
    [anon_sym_BSLASHacp] = ACTIONS(145),
    [anon_sym_BSLASHglsentrylong] = ACTIONS(145),
    [anon_sym_BSLASHGlsentrylong] = ACTIONS(145),
    [anon_sym_BSLASHglsentrylongpl] = ACTIONS(145),
    [anon_sym_BSLASHGlsentrylongpl] = ACTIONS(145),
    [anon_sym_BSLASHglsentryshort] = ACTIONS(145),
    [anon_sym_BSLASHGlsentryshort] = ACTIONS(145),
    [anon_sym_BSLASHglsentryshortpl] = ACTIONS(145),
    [anon_sym_BSLASHGlsentryshortpl] = ACTIONS(145),
    [anon_sym_BSLASHglsentryfullpl] = ACTIONS(145),
    [anon_sym_BSLASHGlsentryfullpl] = ACTIONS(145),
    [anon_sym_BSLASHnewtheorem] = ACTIONS(145),
    [anon_sym_BSLASHnewtheorem_STAR] = ACTIONS(149),
    [anon_sym_BSLASHdeclaretheorem] = ACTIONS(145),
    [anon_sym_BSLASHdeclaretheorem_STAR] = ACTIONS(149),
    [anon_sym_BSLASHdefinecolor] = ACTIONS(145),
    [anon_sym_BSLASHdefinecolorset] = ACTIONS(145),
    [anon_sym_BSLASHcolor] = ACTIONS(145),
    [anon_sym_BSLASHcolorbox] = ACTIONS(145),
    [anon_sym_BSLASHtextcolor] = ACTIONS(145),
    [anon_sym_BSLASHpagecolor] = ACTIONS(145),
    [anon_sym_BSLASHusepgflibrary] = ACTIONS(145),
    [anon_sym_BSLASHusetikzlibrary] = ACTIONS(145),
    [anon_sym_BSLASHtext] = ACTIONS(145),
    [anon_sym_BSLASHintertext] = ACTIONS(145),
    [anon_sym_shortintertext] = ACTIONS(145),
  },
  [7] = {
    [sym_block_comment] = STATE(165),
    [sym__root_content] = STATE(165),
    [sym__flat_content] = STATE(165),
    [sym__text_with_env_content] = STATE(165),
    [sym__text_content] = STATE(165),
    [sym__section] = STATE(165),
    [sym__part_declaration] = STATE(180),
    [sym_part] = STATE(721),
    [sym__chapter_declaration] = STATE(191),
    [sym_chapter] = STATE(722),
    [sym__section_declaration] = STATE(203),
    [sym_section] = STATE(723),
    [sym__subsection_declaration] = STATE(214),
    [sym_subsection] = STATE(724),
    [sym__subsubsection_declaration] = STATE(223),
    [sym_subsubsection] = STATE(725),
    [sym__paragraph_declaration] = STATE(234),
    [sym_paragraph] = STATE(726),
    [sym__subparagraph_declaration] = STATE(241),
    [sym_subparagraph] = STATE(727),
    [sym__enum_itemdeclaration] = STATE(257),
    [sym_enum_item] = STATE(728),
    [sym_curly_group] = STATE(165),
    [sym_text] = STATE(165),
    [sym_operator] = STATE(1385),
    [sym_subscript] = STATE(1385),
    [sym_superscript] = STATE(1385),
    [sym_displayed_equation] = STATE(165),
    [sym_inline_formula] = STATE(165),
    [sym_begin] = STATE(73),
    [sym_generic_environment] = STATE(165),
    [sym_comment_environment] = STATE(165),
    [sym__comment_environment_begin] = STATE(3152),
    [sym_verbatim_environment] = STATE(165),
    [sym__verbatim_environment_begin] = STATE(3151),
    [sym_listing_environment] = STATE(165),
    [sym__listing_environment_begin] = STATE(3149),
    [sym_minted_environment] = STATE(165),
    [sym__minted_environment_begin] = STATE(3148),
    [sym_pycode_environment] = STATE(165),
    [sym__pycode_environment_begin] = STATE(3146),
    [sym_math_environment] = STATE(165),
    [sym__math_environment_begin] = STATE(271),
    [sym__command] = STATE(165),
    [sym_generic_command] = STATE(165),
    [sym_title_declaration] = STATE(165),
    [sym_author_declaration] = STATE(165),
    [sym_package_include] = STATE(165),
    [sym_class_include] = STATE(165),
    [sym_latex_include] = STATE(165),
    [sym_biblatex_include] = STATE(165),
    [sym_bibtex_include] = STATE(165),
    [sym_graphics_include] = STATE(165),
    [sym_svg_include] = STATE(165),
    [sym_inkscape_include] = STATE(165),
    [sym_verbatim_include] = STATE(165),
    [sym_import_include] = STATE(165),
    [sym_caption] = STATE(165),
    [sym_citation] = STATE(165),
    [sym_label_definition] = STATE(165),
    [sym_label_reference] = STATE(165),
    [sym_label_reference_range] = STATE(165),
    [sym_label_number] = STATE(165),
    [sym_new_command_definition] = STATE(165),
    [sym_old_command_definition] = STATE(165),
    [sym_let_command_definition] = STATE(165),
    [sym_math_delimiter] = STATE(165),
    [sym_paired_delimiter_definition] = STATE(165),
    [sym_environment_definition] = STATE(165),
    [sym_glossary_entry_definition] = STATE(165),
    [sym_glossary_entry_reference] = STATE(165),
    [sym_acronym_definition] = STATE(165),
    [sym_acronym_reference] = STATE(165),
    [sym_theorem_definition] = STATE(165),
    [sym_color_definition] = STATE(165),
    [sym_color_set_definition] = STATE(165),
    [sym_color_reference] = STATE(165),
    [sym_tikz_library_import] = STATE(165),
    [sym_text_mode] = STATE(165),
    [aux_sym_source_file_repeat1] = STATE(165),
    [aux_sym__section_repeat1] = STATE(721),
    [aux_sym__section_repeat2] = STATE(722),
    [aux_sym__section_repeat3] = STATE(723),
    [aux_sym__section_repeat4] = STATE(724),
    [aux_sym__section_repeat5] = STATE(725),
    [aux_sym__section_repeat6] = STATE(726),
    [aux_sym__section_repeat7] = STATE(727),
    [aux_sym__section_repeat8] = STATE(728),
    [aux_sym_text_repeat1] = STATE(288),
    [sym_command_name] = ACTIONS(189),
    [sym__whitespace] = ACTIONS(3),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_BSLASHiffalse] = ACTIONS(189),
    [anon_sym_LBRACK] = ACTIONS(191),
    [anon_sym_RBRACK] = ACTIONS(191),
    [anon_sym_COMMA] = ACTIONS(191),
    [anon_sym_EQ] = ACTIONS(191),
    [anon_sym_LPAREN] = ACTIONS(191),
    [anon_sym_RPAREN] = ACTIONS(191),
    [anon_sym_BSLASHpart] = ACTIONS(189),
    [anon_sym_BSLASHpart_STAR] = ACTIONS(191),
    [anon_sym_BSLASHaddpart] = ACTIONS(189),
    [anon_sym_BSLASHaddpart_STAR] = ACTIONS(191),
    [anon_sym_BSLASHchapter] = ACTIONS(189),
    [anon_sym_BSLASHchapter_STAR] = ACTIONS(191),
    [anon_sym_BSLASHaddchap] = ACTIONS(189),
    [anon_sym_BSLASHaddchap_STAR] = ACTIONS(191),
    [anon_sym_BSLASHsection] = ACTIONS(189),
    [anon_sym_BSLASHsection_STAR] = ACTIONS(191),
    [anon_sym_BSLASHaddsec] = ACTIONS(189),
    [anon_sym_BSLASHaddsec_STAR] = ACTIONS(191),
    [anon_sym_BSLASHsubsection] = ACTIONS(189),
    [anon_sym_BSLASHsubsection_STAR] = ACTIONS(191),
    [anon_sym_BSLASHsubsubsection] = ACTIONS(189),
    [anon_sym_BSLASHsubsubsection_STAR] = ACTIONS(191),
    [anon_sym_BSLASHparagraph] = ACTIONS(189),
    [anon_sym_BSLASHparagraph_STAR] = ACTIONS(191),
    [anon_sym_BSLASHsubparagraph] = ACTIONS(189),
    [anon_sym_BSLASHsubparagraph_STAR] = ACTIONS(191),
    [anon_sym_BSLASHitem] = ACTIONS(189),
    [anon_sym_BSLASHitem_STAR] = ACTIONS(191),
    [anon_sym_LBRACE] = ACTIONS(191),
    [sym_word] = ACTIONS(189),
    [sym_placeholder] = ACTIONS(191),
    [anon_sym_PLUS] = ACTIONS(191),
    [anon_sym_DASH] = ACTIONS(191),
    [anon_sym_STAR] = ACTIONS(191),
    [anon_sym_SLASH] = ACTIONS(191),
    [anon_sym_LT] = ACTIONS(189),
    [anon_sym_GT] = ACTIONS(189),
    [anon_sym_BANG] = ACTIONS(189),
    [anon_sym_PIPE] = ACTIONS(189),
    [anon_sym_COLON] = ACTIONS(189),
    [anon_sym_SQUOTE] = ACTIONS(189),
    [anon_sym__] = ACTIONS(191),
    [anon_sym_CARET] = ACTIONS(191),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(191),
    [anon_sym_BSLASH_LBRACK] = ACTIONS(191),
    [anon_sym_DOLLAR] = ACTIONS(189),
    [anon_sym_BSLASH_LPAREN] = ACTIONS(191),
    [anon_sym_BSLASH_RPAREN] = ACTIONS(193),
    [anon_sym_BSLASHbegin] = ACTIONS(189),
    [anon_sym_BSLASHtitle] = ACTIONS(189),
    [anon_sym_BSLASHauthor] = ACTIONS(189),
    [anon_sym_BSLASHusepackage] = ACTIONS(189),
    [anon_sym_BSLASHRequirePackage] = ACTIONS(189),
    [anon_sym_BSLASHdocumentclass] = ACTIONS(189),
    [anon_sym_BSLASHinclude] = ACTIONS(189),
    [anon_sym_BSLASHsubfileinclude] = ACTIONS(189),
    [anon_sym_BSLASHinput] = ACTIONS(189),
    [anon_sym_BSLASHsubfile] = ACTIONS(189),
    [anon_sym_BSLASHaddbibresource] = ACTIONS(189),
    [anon_sym_BSLASHbibliography] = ACTIONS(189),
    [anon_sym_BSLASHincludegraphics] = ACTIONS(189),
    [anon_sym_BSLASHincludesvg] = ACTIONS(189),
    [anon_sym_BSLASHincludeinkscape] = ACTIONS(189),
    [anon_sym_BSLASHverbatiminput] = ACTIONS(189),
    [anon_sym_BSLASHVerbatimInput] = ACTIONS(189),
    [anon_sym_BSLASHimport] = ACTIONS(189),
    [anon_sym_BSLASHsubimport] = ACTIONS(189),
    [anon_sym_BSLASHinputfrom] = ACTIONS(189),
    [anon_sym_BSLASHsubimportfrom] = ACTIONS(189),
    [anon_sym_BSLASHincludefrom] = ACTIONS(189),
    [anon_sym_BSLASHsubincludefrom] = ACTIONS(189),
    [anon_sym_BSLASHcaption] = ACTIONS(189),
    [anon_sym_BSLASHcite] = ACTIONS(189),
    [anon_sym_BSLASHcite_STAR] = ACTIONS(191),
    [anon_sym_BSLASHCite] = ACTIONS(189),
    [anon_sym_BSLASHnocite] = ACTIONS(189),
    [anon_sym_BSLASHcitet] = ACTIONS(189),
    [anon_sym_BSLASHcitep] = ACTIONS(189),
    [anon_sym_BSLASHcitet_STAR] = ACTIONS(191),
    [anon_sym_BSLASHcitep_STAR] = ACTIONS(191),
    [anon_sym_BSLASHciteauthor] = ACTIONS(189),
    [anon_sym_BSLASHciteauthor_STAR] = ACTIONS(191),
    [anon_sym_BSLASHCiteauthor] = ACTIONS(189),
    [anon_sym_BSLASHCiteauthor_STAR] = ACTIONS(191),
    [anon_sym_BSLASHcitetitle] = ACTIONS(189),
    [anon_sym_BSLASHcitetitle_STAR] = ACTIONS(191),
    [anon_sym_BSLASHciteyear] = ACTIONS(189),
    [anon_sym_BSLASHciteyear_STAR] = ACTIONS(191),
    [anon_sym_BSLASHcitedate] = ACTIONS(189),
    [anon_sym_BSLASHcitedate_STAR] = ACTIONS(191),
    [anon_sym_BSLASHciteurl] = ACTIONS(189),
    [anon_sym_BSLASHfullcite] = ACTIONS(189),
    [anon_sym_BSLASHciteyearpar] = ACTIONS(189),
    [anon_sym_BSLASHcitealt] = ACTIONS(189),
    [anon_sym_BSLASHcitealp] = ACTIONS(189),
    [anon_sym_BSLASHcitetext] = ACTIONS(189),
    [anon_sym_BSLASHparencite] = ACTIONS(189),
    [anon_sym_BSLASHparencite_STAR] = ACTIONS(191),
    [anon_sym_BSLASHParencite] = ACTIONS(189),
    [anon_sym_BSLASHfootcite] = ACTIONS(189),
    [anon_sym_BSLASHfootfullcite] = ACTIONS(189),
    [anon_sym_BSLASHfootcitetext] = ACTIONS(189),
    [anon_sym_BSLASHtextcite] = ACTIONS(189),
    [anon_sym_BSLASHTextcite] = ACTIONS(189),
    [anon_sym_BSLASHsmartcite] = ACTIONS(189),
    [anon_sym_BSLASHSmartcite] = ACTIONS(189),
    [anon_sym_BSLASHsupercite] = ACTIONS(189),
    [anon_sym_BSLASHautocite] = ACTIONS(189),
    [anon_sym_BSLASHAutocite] = ACTIONS(189),
    [anon_sym_BSLASHautocite_STAR] = ACTIONS(191),
    [anon_sym_BSLASHAutocite_STAR] = ACTIONS(191),
    [anon_sym_BSLASHvolcite] = ACTIONS(189),
    [anon_sym_BSLASHVolcite] = ACTIONS(189),
    [anon_sym_BSLASHpvolcite] = ACTIONS(189),
    [anon_sym_BSLASHPvolcite] = ACTIONS(189),
    [anon_sym_BSLASHfvolcite] = ACTIONS(189),
    [anon_sym_BSLASHftvolcite] = ACTIONS(189),
    [anon_sym_BSLASHsvolcite] = ACTIONS(189),
    [anon_sym_BSLASHSvolcite] = ACTIONS(189),
    [anon_sym_BSLASHtvolcite] = ACTIONS(189),
    [anon_sym_BSLASHTvolcite] = ACTIONS(189),
    [anon_sym_BSLASHavolcite] = ACTIONS(189),
    [anon_sym_BSLASHAvolcite] = ACTIONS(189),
    [anon_sym_BSLASHnotecite] = ACTIONS(189),
    [anon_sym_BSLASHNotecite] = ACTIONS(189),
    [anon_sym_BSLASHpnotecite] = ACTIONS(189),
    [anon_sym_BSLASHPnotecite] = ACTIONS(189),
    [anon_sym_BSLASHfnotecite] = ACTIONS(189),
    [anon_sym_BSLASHlabel] = ACTIONS(189),
    [anon_sym_BSLASHref] = ACTIONS(189),
    [anon_sym_BSLASHeqref] = ACTIONS(189),
    [anon_sym_BSLASHvref] = ACTIONS(189),
    [anon_sym_BSLASHVref] = ACTIONS(189),
    [anon_sym_BSLASHautoref] = ACTIONS(189),
    [anon_sym_BSLASHpageref] = ACTIONS(189),
    [anon_sym_BSLASHcref] = ACTIONS(189),
    [anon_sym_BSLASHCref] = ACTIONS(189),
    [anon_sym_BSLASHcref_STAR] = ACTIONS(191),
    [anon_sym_BSLASHCref_STAR] = ACTIONS(191),
    [anon_sym_BSLASHnamecref] = ACTIONS(189),
    [anon_sym_BSLASHnameCref] = ACTIONS(189),
    [anon_sym_BSLASHlcnamecref] = ACTIONS(189),
    [anon_sym_BSLASHnamecrefs] = ACTIONS(189),
    [anon_sym_BSLASHnameCrefs] = ACTIONS(189),
    [anon_sym_BSLASHlcnamecrefs] = ACTIONS(189),
    [anon_sym_BSLASHlabelcref] = ACTIONS(189),
    [anon_sym_BSLASHlabelcpageref] = ACTIONS(189),
    [anon_sym_BSLASHcrefrange] = ACTIONS(189),
    [anon_sym_BSLASHcrefrange_STAR] = ACTIONS(191),
    [anon_sym_BSLASHCrefrange] = ACTIONS(189),
    [anon_sym_BSLASHCrefrange_STAR] = ACTIONS(191),
    [anon_sym_BSLASHnewlabel] = ACTIONS(189),
    [anon_sym_BSLASHnewcommand] = ACTIONS(189),
    [anon_sym_BSLASHnewcommand_STAR] = ACTIONS(191),
    [anon_sym_BSLASHrenewcommand] = ACTIONS(189),
    [anon_sym_BSLASHrenewcommand_STAR] = ACTIONS(191),
    [anon_sym_BSLASHDeclareRobustCommand] = ACTIONS(189),
    [anon_sym_BSLASHDeclareRobustCommand_STAR] = ACTIONS(191),
    [anon_sym_BSLASHDeclareMathOperator] = ACTIONS(189),
    [anon_sym_BSLASHDeclareMathOperator_STAR] = ACTIONS(191),
    [anon_sym_BSLASHNewDocumentCommand] = ACTIONS(189),
    [anon_sym_BSLASHRenewDocumentCommand] = ACTIONS(189),
    [anon_sym_BSLASHProvideDocumentCommand] = ACTIONS(189),
    [anon_sym_BSLASHDeclareDocumentCommand] = ACTIONS(189),
    [anon_sym_BSLASHNewExpandableDocumentCommand] = ACTIONS(189),
    [anon_sym_BSLASHRenewExpandableDocumentCommand] = ACTIONS(189),
    [anon_sym_BSLASHProvideExpandableDocumentCommand] = ACTIONS(189),
    [anon_sym_BSLASHDeclareExpandableDocumentCommand] = ACTIONS(189),
    [anon_sym_BSLASHdef] = ACTIONS(189),
    [anon_sym_BSLASHlet] = ACTIONS(189),
    [anon_sym_BSLASHleft] = ACTIONS(189),
    [anon_sym_BSLASHbig] = ACTIONS(189),
    [anon_sym_BSLASHBig] = ACTIONS(189),
    [anon_sym_BSLASHbigg] = ACTIONS(189),
    [anon_sym_BSLASHBigg] = ACTIONS(189),
    [anon_sym_BSLASHbigl] = ACTIONS(189),
    [anon_sym_BSLASHBigl] = ACTIONS(189),
    [anon_sym_BSLASHbiggl] = ACTIONS(189),
    [anon_sym_BSLASHBiggl] = ACTIONS(189),
    [anon_sym_BSLASHright] = ACTIONS(189),
    [anon_sym_BSLASHbigr] = ACTIONS(189),
    [anon_sym_BSLASHBigr] = ACTIONS(189),
    [anon_sym_BSLASHbiggr] = ACTIONS(189),
    [anon_sym_BSLASHBiggr] = ACTIONS(189),
    [anon_sym_BSLASHDeclarePairedDelimiter] = ACTIONS(189),
    [anon_sym_BSLASHDeclarePairedDelimiterX] = ACTIONS(189),
    [anon_sym_BSLASHnewenvironment] = ACTIONS(189),
    [anon_sym_BSLASHrenewenvironment] = ACTIONS(189),
    [anon_sym_BSLASHNewDocumentEnvironment] = ACTIONS(189),
    [anon_sym_BSLASHRenewDocumentEnvironment] = ACTIONS(189),
    [anon_sym_BSLASHProvideDocumentEnvironment] = ACTIONS(189),
    [anon_sym_BSLASHDeclareDocumentEnvironment] = ACTIONS(189),
    [anon_sym_BSLASHnewglossaryentry] = ACTIONS(189),
    [anon_sym_BSLASHgls] = ACTIONS(189),
    [anon_sym_BSLASHGls] = ACTIONS(189),
    [anon_sym_BSLASHGLS] = ACTIONS(189),
    [anon_sym_BSLASHglspl] = ACTIONS(189),
    [anon_sym_BSLASHGlspl] = ACTIONS(189),
    [anon_sym_BSLASHGLSpl] = ACTIONS(189),
    [anon_sym_BSLASHglsdisp] = ACTIONS(189),
    [anon_sym_BSLASHglslink] = ACTIONS(189),
    [anon_sym_BSLASHglstext] = ACTIONS(189),
    [anon_sym_BSLASHGlstext] = ACTIONS(189),
    [anon_sym_BSLASHGLStext] = ACTIONS(189),
    [anon_sym_BSLASHglsfirst] = ACTIONS(189),
    [anon_sym_BSLASHGlsfirst] = ACTIONS(189),
    [anon_sym_BSLASHGLSfirst] = ACTIONS(189),
    [anon_sym_BSLASHglsplural] = ACTIONS(189),
    [anon_sym_BSLASHGlsplural] = ACTIONS(189),
    [anon_sym_BSLASHGLSplural] = ACTIONS(189),
    [anon_sym_BSLASHglsfirstplural] = ACTIONS(189),
    [anon_sym_BSLASHGlsfirstplural] = ACTIONS(189),
    [anon_sym_BSLASHGLSfirstplural] = ACTIONS(189),
    [anon_sym_BSLASHglsname] = ACTIONS(189),
    [anon_sym_BSLASHGlsname] = ACTIONS(189),
    [anon_sym_BSLASHGLSname] = ACTIONS(189),
    [anon_sym_BSLASHglssymbol] = ACTIONS(189),
    [anon_sym_BSLASHGlssymbol] = ACTIONS(189),
    [anon_sym_BSLASHglsdesc] = ACTIONS(189),
    [anon_sym_BSLASHGlsdesc] = ACTIONS(189),
    [anon_sym_BSLASHGLSdesc] = ACTIONS(189),
    [anon_sym_BSLASHglsuseri] = ACTIONS(189),
    [anon_sym_BSLASHGlsuseri] = ACTIONS(189),
    [anon_sym_BSLASHGLSuseri] = ACTIONS(189),
    [anon_sym_BSLASHglsuserii] = ACTIONS(189),
    [anon_sym_BSLASHGlsuserii] = ACTIONS(189),
    [anon_sym_BSLASHGLSuserii] = ACTIONS(189),
    [anon_sym_BSLASHglsuseriii] = ACTIONS(189),
    [anon_sym_BSLASHGlsuseriii] = ACTIONS(189),
    [anon_sym_BSLASHGLSuseriii] = ACTIONS(189),
    [anon_sym_BSLASHglsuseriv] = ACTIONS(189),
    [anon_sym_BSLASHGlsuseriv] = ACTIONS(189),
    [anon_sym_BSLASHGLSuseriv] = ACTIONS(189),
    [anon_sym_BSLASHglsuserv] = ACTIONS(189),
    [anon_sym_BSLASHGlsuserv] = ACTIONS(189),
    [anon_sym_BSLASHGLSuserv] = ACTIONS(189),
    [anon_sym_BSLASHglsuservi] = ACTIONS(189),
    [anon_sym_BSLASHGlsuservi] = ACTIONS(189),
    [anon_sym_BSLASHGLSuservi] = ACTIONS(189),
    [anon_sym_BSLASHnewacronym] = ACTIONS(189),
    [anon_sym_BSLASHacrshort] = ACTIONS(189),
    [anon_sym_BSLASHAcrshort] = ACTIONS(189),
    [anon_sym_BSLASHACRshort] = ACTIONS(189),
    [anon_sym_BSLASHacrshortpl] = ACTIONS(189),
    [anon_sym_BSLASHAcrshortpl] = ACTIONS(189),
    [anon_sym_BSLASHACRshortpl] = ACTIONS(189),
    [anon_sym_BSLASHacrlong] = ACTIONS(189),
    [anon_sym_BSLASHAcrlong] = ACTIONS(189),
    [anon_sym_BSLASHACRlong] = ACTIONS(189),
    [anon_sym_BSLASHacrlongpl] = ACTIONS(189),
    [anon_sym_BSLASHAcrlongpl] = ACTIONS(189),
    [anon_sym_BSLASHACRlongpl] = ACTIONS(189),
    [anon_sym_BSLASHacrfull] = ACTIONS(189),
    [anon_sym_BSLASHAcrfull] = ACTIONS(189),
    [anon_sym_BSLASHACRfull] = ACTIONS(189),
    [anon_sym_BSLASHacrfullpl] = ACTIONS(189),
    [anon_sym_BSLASHAcrfullpl] = ACTIONS(189),
    [anon_sym_BSLASHACRfullpl] = ACTIONS(189),
    [anon_sym_BSLASHacs] = ACTIONS(189),
    [anon_sym_BSLASHAcs] = ACTIONS(189),
    [anon_sym_BSLASHacsp] = ACTIONS(189),
    [anon_sym_BSLASHAcsp] = ACTIONS(189),
    [anon_sym_BSLASHacl] = ACTIONS(189),
    [anon_sym_BSLASHAcl] = ACTIONS(189),
    [anon_sym_BSLASHaclp] = ACTIONS(189),
    [anon_sym_BSLASHAclp] = ACTIONS(189),
    [anon_sym_BSLASHacf] = ACTIONS(189),
    [anon_sym_BSLASHAcf] = ACTIONS(189),
    [anon_sym_BSLASHacfp] = ACTIONS(189),
    [anon_sym_BSLASHAcfp] = ACTIONS(189),
    [anon_sym_BSLASHac] = ACTIONS(189),
    [anon_sym_BSLASHAc] = ACTIONS(189),
    [anon_sym_BSLASHacp] = ACTIONS(189),
    [anon_sym_BSLASHglsentrylong] = ACTIONS(189),
    [anon_sym_BSLASHGlsentrylong] = ACTIONS(189),
    [anon_sym_BSLASHglsentrylongpl] = ACTIONS(189),
    [anon_sym_BSLASHGlsentrylongpl] = ACTIONS(189),
    [anon_sym_BSLASHglsentryshort] = ACTIONS(189),
    [anon_sym_BSLASHGlsentryshort] = ACTIONS(189),
    [anon_sym_BSLASHglsentryshortpl] = ACTIONS(189),
    [anon_sym_BSLASHGlsentryshortpl] = ACTIONS(189),
    [anon_sym_BSLASHglsentryfullpl] = ACTIONS(189),
    [anon_sym_BSLASHGlsentryfullpl] = ACTIONS(189),
    [anon_sym_BSLASHnewtheorem] = ACTIONS(189),
    [anon_sym_BSLASHnewtheorem_STAR] = ACTIONS(191),
    [anon_sym_BSLASHdeclaretheorem] = ACTIONS(189),
    [anon_sym_BSLASHdeclaretheorem_STAR] = ACTIONS(191),
    [anon_sym_BSLASHdefinecolor] = ACTIONS(189),
    [anon_sym_BSLASHdefinecolorset] = ACTIONS(189),
    [anon_sym_BSLASHcolor] = ACTIONS(189),
    [anon_sym_BSLASHcolorbox] = ACTIONS(189),
    [anon_sym_BSLASHtextcolor] = ACTIONS(189),
    [anon_sym_BSLASHpagecolor] = ACTIONS(189),
    [anon_sym_BSLASHusepgflibrary] = ACTIONS(189),
    [anon_sym_BSLASHusetikzlibrary] = ACTIONS(189),
    [anon_sym_BSLASHtext] = ACTIONS(189),
    [anon_sym_BSLASHintertext] = ACTIONS(189),
    [anon_sym_shortintertext] = ACTIONS(189),
  },
  [8] = {
    [sym_block_comment] = STATE(27),
    [sym__root_content] = STATE(27),
    [sym__flat_content] = STATE(27),
    [sym__text_with_env_content] = STATE(27),
    [sym__text_content] = STATE(27),
    [sym__section] = STATE(27),
    [sym__part_declaration] = STATE(175),
    [sym_part] = STATE(367),
    [sym__chapter_declaration] = STATE(177),
    [sym_chapter] = STATE(368),
    [sym__section_declaration] = STATE(187),
    [sym_section] = STATE(369),
    [sym__subsection_declaration] = STATE(196),
    [sym_subsection] = STATE(370),
    [sym__subsubsection_declaration] = STATE(207),
    [sym_subsubsection] = STATE(371),
    [sym__paragraph_declaration] = STATE(218),
    [sym_paragraph] = STATE(373),
    [sym__subparagraph_declaration] = STATE(228),
    [sym_subparagraph] = STATE(374),
    [sym__enum_itemdeclaration] = STATE(238),
    [sym_enum_item] = STATE(375),
    [sym_curly_group] = STATE(27),
    [sym_text] = STATE(27),
    [sym_operator] = STATE(484),
    [sym_subscript] = STATE(484),
    [sym_superscript] = STATE(484),
    [sym_displayed_equation] = STATE(27),
    [sym_inline_formula] = STATE(27),
    [sym_begin] = STATE(65),
    [sym_generic_environment] = STATE(27),
    [sym_comment_environment] = STATE(27),
    [sym__comment_environment_begin] = STATE(3120),
    [sym_verbatim_environment] = STATE(27),
    [sym__verbatim_environment_begin] = STATE(3121),
    [sym_listing_environment] = STATE(27),
    [sym__listing_environment_begin] = STATE(3122),
    [sym_minted_environment] = STATE(27),
    [sym__minted_environment_begin] = STATE(3123),
    [sym_pycode_environment] = STATE(27),
    [sym__pycode_environment_begin] = STATE(3124),
    [sym_math_environment] = STATE(27),
    [sym__math_environment_begin] = STATE(269),
    [sym__command] = STATE(27),
    [sym_generic_command] = STATE(27),
    [sym_title_declaration] = STATE(27),
    [sym_author_declaration] = STATE(27),
    [sym_package_include] = STATE(27),
    [sym_class_include] = STATE(27),
    [sym_latex_include] = STATE(27),
    [sym_biblatex_include] = STATE(27),
    [sym_bibtex_include] = STATE(27),
    [sym_graphics_include] = STATE(27),
    [sym_svg_include] = STATE(27),
    [sym_inkscape_include] = STATE(27),
    [sym_verbatim_include] = STATE(27),
    [sym_import_include] = STATE(27),
    [sym_caption] = STATE(27),
    [sym_citation] = STATE(27),
    [sym_label_definition] = STATE(27),
    [sym_label_reference] = STATE(27),
    [sym_label_reference_range] = STATE(27),
    [sym_label_number] = STATE(27),
    [sym_new_command_definition] = STATE(27),
    [sym_old_command_definition] = STATE(27),
    [sym_let_command_definition] = STATE(27),
    [sym_math_delimiter] = STATE(27),
    [sym_paired_delimiter_definition] = STATE(27),
    [sym_environment_definition] = STATE(27),
    [sym_glossary_entry_definition] = STATE(27),
    [sym_glossary_entry_reference] = STATE(27),
    [sym_acronym_definition] = STATE(27),
    [sym_acronym_reference] = STATE(27),
    [sym_theorem_definition] = STATE(27),
    [sym_color_definition] = STATE(27),
    [sym_color_set_definition] = STATE(27),
    [sym_color_reference] = STATE(27),
    [sym_tikz_library_import] = STATE(27),
    [sym_text_mode] = STATE(27),
    [aux_sym_source_file_repeat1] = STATE(27),
    [aux_sym__section_repeat1] = STATE(367),
    [aux_sym__section_repeat2] = STATE(368),
    [aux_sym__section_repeat3] = STATE(369),
    [aux_sym__section_repeat4] = STATE(370),
    [aux_sym__section_repeat5] = STATE(371),
    [aux_sym__section_repeat6] = STATE(373),
    [aux_sym__section_repeat7] = STATE(374),
    [aux_sym__section_repeat8] = STATE(375),
    [aux_sym_text_repeat1] = STATE(259),
    [sym_command_name] = ACTIONS(145),
    [sym__whitespace] = ACTIONS(3),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_BSLASHiffalse] = ACTIONS(145),
    [anon_sym_LBRACK] = ACTIONS(149),
    [anon_sym_RBRACK] = ACTIONS(149),
    [anon_sym_COMMA] = ACTIONS(149),
    [anon_sym_EQ] = ACTIONS(149),
    [anon_sym_LPAREN] = ACTIONS(149),
    [anon_sym_RPAREN] = ACTIONS(149),
    [anon_sym_BSLASHpart] = ACTIONS(145),
    [anon_sym_BSLASHpart_STAR] = ACTIONS(149),
    [anon_sym_BSLASHaddpart] = ACTIONS(145),
    [anon_sym_BSLASHaddpart_STAR] = ACTIONS(149),
    [anon_sym_BSLASHchapter] = ACTIONS(145),
    [anon_sym_BSLASHchapter_STAR] = ACTIONS(149),
    [anon_sym_BSLASHaddchap] = ACTIONS(145),
    [anon_sym_BSLASHaddchap_STAR] = ACTIONS(149),
    [anon_sym_BSLASHsection] = ACTIONS(145),
    [anon_sym_BSLASHsection_STAR] = ACTIONS(149),
    [anon_sym_BSLASHaddsec] = ACTIONS(145),
    [anon_sym_BSLASHaddsec_STAR] = ACTIONS(149),
    [anon_sym_BSLASHsubsection] = ACTIONS(145),
    [anon_sym_BSLASHsubsection_STAR] = ACTIONS(149),
    [anon_sym_BSLASHsubsubsection] = ACTIONS(145),
    [anon_sym_BSLASHsubsubsection_STAR] = ACTIONS(149),
    [anon_sym_BSLASHparagraph] = ACTIONS(145),
    [anon_sym_BSLASHparagraph_STAR] = ACTIONS(149),
    [anon_sym_BSLASHsubparagraph] = ACTIONS(145),
    [anon_sym_BSLASHsubparagraph_STAR] = ACTIONS(149),
    [anon_sym_BSLASHitem] = ACTIONS(145),
    [anon_sym_BSLASHitem_STAR] = ACTIONS(149),
    [anon_sym_LBRACE] = ACTIONS(149),
    [sym_word] = ACTIONS(145),
    [sym_placeholder] = ACTIONS(149),
    [anon_sym_PLUS] = ACTIONS(149),
    [anon_sym_DASH] = ACTIONS(149),
    [anon_sym_STAR] = ACTIONS(149),
    [anon_sym_SLASH] = ACTIONS(149),
    [anon_sym_LT] = ACTIONS(145),
    [anon_sym_GT] = ACTIONS(145),
    [anon_sym_BANG] = ACTIONS(145),
    [anon_sym_PIPE] = ACTIONS(145),
    [anon_sym_COLON] = ACTIONS(145),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [anon_sym__] = ACTIONS(149),
    [anon_sym_CARET] = ACTIONS(149),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(149),
    [anon_sym_BSLASH_LBRACK] = ACTIONS(149),
    [anon_sym_BSLASH_RBRACK] = ACTIONS(149),
    [anon_sym_DOLLAR] = ACTIONS(145),
    [anon_sym_BSLASH_LPAREN] = ACTIONS(149),
    [anon_sym_BSLASHbegin] = ACTIONS(145),
    [anon_sym_BSLASHtitle] = ACTIONS(145),
    [anon_sym_BSLASHauthor] = ACTIONS(145),
    [anon_sym_BSLASHusepackage] = ACTIONS(145),
    [anon_sym_BSLASHRequirePackage] = ACTIONS(145),
    [anon_sym_BSLASHdocumentclass] = ACTIONS(145),
    [anon_sym_BSLASHinclude] = ACTIONS(145),
    [anon_sym_BSLASHsubfileinclude] = ACTIONS(145),
    [anon_sym_BSLASHinput] = ACTIONS(145),
    [anon_sym_BSLASHsubfile] = ACTIONS(145),
    [anon_sym_BSLASHaddbibresource] = ACTIONS(145),
    [anon_sym_BSLASHbibliography] = ACTIONS(145),
    [anon_sym_BSLASHincludegraphics] = ACTIONS(145),
    [anon_sym_BSLASHincludesvg] = ACTIONS(145),
    [anon_sym_BSLASHincludeinkscape] = ACTIONS(145),
    [anon_sym_BSLASHverbatiminput] = ACTIONS(145),
    [anon_sym_BSLASHVerbatimInput] = ACTIONS(145),
    [anon_sym_BSLASHimport] = ACTIONS(145),
    [anon_sym_BSLASHsubimport] = ACTIONS(145),
    [anon_sym_BSLASHinputfrom] = ACTIONS(145),
    [anon_sym_BSLASHsubimportfrom] = ACTIONS(145),
    [anon_sym_BSLASHincludefrom] = ACTIONS(145),
    [anon_sym_BSLASHsubincludefrom] = ACTIONS(145),
    [anon_sym_BSLASHcaption] = ACTIONS(145),
    [anon_sym_BSLASHcite] = ACTIONS(145),
    [anon_sym_BSLASHcite_STAR] = ACTIONS(149),
    [anon_sym_BSLASHCite] = ACTIONS(145),
    [anon_sym_BSLASHnocite] = ACTIONS(145),
    [anon_sym_BSLASHcitet] = ACTIONS(145),
    [anon_sym_BSLASHcitep] = ACTIONS(145),
    [anon_sym_BSLASHcitet_STAR] = ACTIONS(149),
    [anon_sym_BSLASHcitep_STAR] = ACTIONS(149),
    [anon_sym_BSLASHciteauthor] = ACTIONS(145),
    [anon_sym_BSLASHciteauthor_STAR] = ACTIONS(149),
    [anon_sym_BSLASHCiteauthor] = ACTIONS(145),
    [anon_sym_BSLASHCiteauthor_STAR] = ACTIONS(149),
    [anon_sym_BSLASHcitetitle] = ACTIONS(145),
    [anon_sym_BSLASHcitetitle_STAR] = ACTIONS(149),
    [anon_sym_BSLASHciteyear] = ACTIONS(145),
    [anon_sym_BSLASHciteyear_STAR] = ACTIONS(149),
    [anon_sym_BSLASHcitedate] = ACTIONS(145),
    [anon_sym_BSLASHcitedate_STAR] = ACTIONS(149),
    [anon_sym_BSLASHciteurl] = ACTIONS(145),
    [anon_sym_BSLASHfullcite] = ACTIONS(145),
    [anon_sym_BSLASHciteyearpar] = ACTIONS(145),
    [anon_sym_BSLASHcitealt] = ACTIONS(145),
    [anon_sym_BSLASHcitealp] = ACTIONS(145),
    [anon_sym_BSLASHcitetext] = ACTIONS(145),
    [anon_sym_BSLASHparencite] = ACTIONS(145),
    [anon_sym_BSLASHparencite_STAR] = ACTIONS(149),
    [anon_sym_BSLASHParencite] = ACTIONS(145),
    [anon_sym_BSLASHfootcite] = ACTIONS(145),
    [anon_sym_BSLASHfootfullcite] = ACTIONS(145),
    [anon_sym_BSLASHfootcitetext] = ACTIONS(145),
    [anon_sym_BSLASHtextcite] = ACTIONS(145),
    [anon_sym_BSLASHTextcite] = ACTIONS(145),
    [anon_sym_BSLASHsmartcite] = ACTIONS(145),
    [anon_sym_BSLASHSmartcite] = ACTIONS(145),
    [anon_sym_BSLASHsupercite] = ACTIONS(145),
    [anon_sym_BSLASHautocite] = ACTIONS(145),
    [anon_sym_BSLASHAutocite] = ACTIONS(145),
    [anon_sym_BSLASHautocite_STAR] = ACTIONS(149),
    [anon_sym_BSLASHAutocite_STAR] = ACTIONS(149),
    [anon_sym_BSLASHvolcite] = ACTIONS(145),
    [anon_sym_BSLASHVolcite] = ACTIONS(145),
    [anon_sym_BSLASHpvolcite] = ACTIONS(145),
    [anon_sym_BSLASHPvolcite] = ACTIONS(145),
    [anon_sym_BSLASHfvolcite] = ACTIONS(145),
    [anon_sym_BSLASHftvolcite] = ACTIONS(145),
    [anon_sym_BSLASHsvolcite] = ACTIONS(145),
    [anon_sym_BSLASHSvolcite] = ACTIONS(145),
    [anon_sym_BSLASHtvolcite] = ACTIONS(145),
    [anon_sym_BSLASHTvolcite] = ACTIONS(145),
    [anon_sym_BSLASHavolcite] = ACTIONS(145),
    [anon_sym_BSLASHAvolcite] = ACTIONS(145),
    [anon_sym_BSLASHnotecite] = ACTIONS(145),
    [anon_sym_BSLASHNotecite] = ACTIONS(145),
    [anon_sym_BSLASHpnotecite] = ACTIONS(145),
    [anon_sym_BSLASHPnotecite] = ACTIONS(145),
    [anon_sym_BSLASHfnotecite] = ACTIONS(145),
    [anon_sym_BSLASHlabel] = ACTIONS(145),
    [anon_sym_BSLASHref] = ACTIONS(145),
    [anon_sym_BSLASHeqref] = ACTIONS(145),
    [anon_sym_BSLASHvref] = ACTIONS(145),
    [anon_sym_BSLASHVref] = ACTIONS(145),
    [anon_sym_BSLASHautoref] = ACTIONS(145),
    [anon_sym_BSLASHpageref] = ACTIONS(145),
    [anon_sym_BSLASHcref] = ACTIONS(145),
    [anon_sym_BSLASHCref] = ACTIONS(145),
    [anon_sym_BSLASHcref_STAR] = ACTIONS(149),
    [anon_sym_BSLASHCref_STAR] = ACTIONS(149),
    [anon_sym_BSLASHnamecref] = ACTIONS(145),
    [anon_sym_BSLASHnameCref] = ACTIONS(145),
    [anon_sym_BSLASHlcnamecref] = ACTIONS(145),
    [anon_sym_BSLASHnamecrefs] = ACTIONS(145),
    [anon_sym_BSLASHnameCrefs] = ACTIONS(145),
    [anon_sym_BSLASHlcnamecrefs] = ACTIONS(145),
    [anon_sym_BSLASHlabelcref] = ACTIONS(145),
    [anon_sym_BSLASHlabelcpageref] = ACTIONS(145),
    [anon_sym_BSLASHcrefrange] = ACTIONS(145),
    [anon_sym_BSLASHcrefrange_STAR] = ACTIONS(149),
    [anon_sym_BSLASHCrefrange] = ACTIONS(145),
    [anon_sym_BSLASHCrefrange_STAR] = ACTIONS(149),
    [anon_sym_BSLASHnewlabel] = ACTIONS(145),
    [anon_sym_BSLASHnewcommand] = ACTIONS(145),
    [anon_sym_BSLASHnewcommand_STAR] = ACTIONS(149),
    [anon_sym_BSLASHrenewcommand] = ACTIONS(145),
    [anon_sym_BSLASHrenewcommand_STAR] = ACTIONS(149),
    [anon_sym_BSLASHDeclareRobustCommand] = ACTIONS(145),
    [anon_sym_BSLASHDeclareRobustCommand_STAR] = ACTIONS(149),
    [anon_sym_BSLASHDeclareMathOperator] = ACTIONS(145),
    [anon_sym_BSLASHDeclareMathOperator_STAR] = ACTIONS(149),
    [anon_sym_BSLASHNewDocumentCommand] = ACTIONS(145),
    [anon_sym_BSLASHRenewDocumentCommand] = ACTIONS(145),
    [anon_sym_BSLASHProvideDocumentCommand] = ACTIONS(145),
    [anon_sym_BSLASHDeclareDocumentCommand] = ACTIONS(145),
    [anon_sym_BSLASHNewExpandableDocumentCommand] = ACTIONS(145),
    [anon_sym_BSLASHRenewExpandableDocumentCommand] = ACTIONS(145),
    [anon_sym_BSLASHProvideExpandableDocumentCommand] = ACTIONS(145),
    [anon_sym_BSLASHDeclareExpandableDocumentCommand] = ACTIONS(145),
    [anon_sym_BSLASHdef] = ACTIONS(145),
    [anon_sym_BSLASHlet] = ACTIONS(145),
    [anon_sym_BSLASHleft] = ACTIONS(145),
    [anon_sym_BSLASHbig] = ACTIONS(145),
    [anon_sym_BSLASHBig] = ACTIONS(145),
    [anon_sym_BSLASHbigg] = ACTIONS(145),
    [anon_sym_BSLASHBigg] = ACTIONS(145),
    [anon_sym_BSLASHbigl] = ACTIONS(145),
    [anon_sym_BSLASHBigl] = ACTIONS(145),
    [anon_sym_BSLASHbiggl] = ACTIONS(145),
    [anon_sym_BSLASHBiggl] = ACTIONS(145),
    [anon_sym_BSLASHright] = ACTIONS(183),
    [anon_sym_BSLASHbigr] = ACTIONS(183),
    [anon_sym_BSLASHBigr] = ACTIONS(183),
    [anon_sym_BSLASHbiggr] = ACTIONS(183),
    [anon_sym_BSLASHBiggr] = ACTIONS(183),
    [anon_sym_BSLASHDeclarePairedDelimiter] = ACTIONS(145),
    [anon_sym_BSLASHDeclarePairedDelimiterX] = ACTIONS(145),
    [anon_sym_BSLASHnewenvironment] = ACTIONS(145),
    [anon_sym_BSLASHrenewenvironment] = ACTIONS(145),
    [anon_sym_BSLASHNewDocumentEnvironment] = ACTIONS(145),
    [anon_sym_BSLASHRenewDocumentEnvironment] = ACTIONS(145),
    [anon_sym_BSLASHProvideDocumentEnvironment] = ACTIONS(145),
    [anon_sym_BSLASHDeclareDocumentEnvironment] = ACTIONS(145),
    [anon_sym_BSLASHnewglossaryentry] = ACTIONS(145),
    [anon_sym_BSLASHgls] = ACTIONS(145),
    [anon_sym_BSLASHGls] = ACTIONS(145),
    [anon_sym_BSLASHGLS] = ACTIONS(145),
    [anon_sym_BSLASHglspl] = ACTIONS(145),
    [anon_sym_BSLASHGlspl] = ACTIONS(145),
    [anon_sym_BSLASHGLSpl] = ACTIONS(145),
    [anon_sym_BSLASHglsdisp] = ACTIONS(145),
    [anon_sym_BSLASHglslink] = ACTIONS(145),
    [anon_sym_BSLASHglstext] = ACTIONS(145),
    [anon_sym_BSLASHGlstext] = ACTIONS(145),
    [anon_sym_BSLASHGLStext] = ACTIONS(145),
    [anon_sym_BSLASHglsfirst] = ACTIONS(145),
    [anon_sym_BSLASHGlsfirst] = ACTIONS(145),
    [anon_sym_BSLASHGLSfirst] = ACTIONS(145),
    [anon_sym_BSLASHglsplural] = ACTIONS(145),
    [anon_sym_BSLASHGlsplural] = ACTIONS(145),
    [anon_sym_BSLASHGLSplural] = ACTIONS(145),
    [anon_sym_BSLASHglsfirstplural] = ACTIONS(145),
    [anon_sym_BSLASHGlsfirstplural] = ACTIONS(145),
    [anon_sym_BSLASHGLSfirstplural] = ACTIONS(145),
    [anon_sym_BSLASHglsname] = ACTIONS(145),
    [anon_sym_BSLASHGlsname] = ACTIONS(145),
    [anon_sym_BSLASHGLSname] = ACTIONS(145),
    [anon_sym_BSLASHglssymbol] = ACTIONS(145),
    [anon_sym_BSLASHGlssymbol] = ACTIONS(145),
    [anon_sym_BSLASHglsdesc] = ACTIONS(145),
    [anon_sym_BSLASHGlsdesc] = ACTIONS(145),
    [anon_sym_BSLASHGLSdesc] = ACTIONS(145),
    [anon_sym_BSLASHglsuseri] = ACTIONS(145),
    [anon_sym_BSLASHGlsuseri] = ACTIONS(145),
    [anon_sym_BSLASHGLSuseri] = ACTIONS(145),
    [anon_sym_BSLASHglsuserii] = ACTIONS(145),
    [anon_sym_BSLASHGlsuserii] = ACTIONS(145),
    [anon_sym_BSLASHGLSuserii] = ACTIONS(145),
    [anon_sym_BSLASHglsuseriii] = ACTIONS(145),
    [anon_sym_BSLASHGlsuseriii] = ACTIONS(145),
    [anon_sym_BSLASHGLSuseriii] = ACTIONS(145),
    [anon_sym_BSLASHglsuseriv] = ACTIONS(145),
    [anon_sym_BSLASHGlsuseriv] = ACTIONS(145),
    [anon_sym_BSLASHGLSuseriv] = ACTIONS(145),
    [anon_sym_BSLASHglsuserv] = ACTIONS(145),
    [anon_sym_BSLASHGlsuserv] = ACTIONS(145),
    [anon_sym_BSLASHGLSuserv] = ACTIONS(145),
    [anon_sym_BSLASHglsuservi] = ACTIONS(145),
    [anon_sym_BSLASHGlsuservi] = ACTIONS(145),
    [anon_sym_BSLASHGLSuservi] = ACTIONS(145),
    [anon_sym_BSLASHnewacronym] = ACTIONS(145),
    [anon_sym_BSLASHacrshort] = ACTIONS(145),
    [anon_sym_BSLASHAcrshort] = ACTIONS(145),
    [anon_sym_BSLASHACRshort] = ACTIONS(145),
    [anon_sym_BSLASHacrshortpl] = ACTIONS(145),
    [anon_sym_BSLASHAcrshortpl] = ACTIONS(145),
    [anon_sym_BSLASHACRshortpl] = ACTIONS(145),
    [anon_sym_BSLASHacrlong] = ACTIONS(145),
    [anon_sym_BSLASHAcrlong] = ACTIONS(145),
    [anon_sym_BSLASHACRlong] = ACTIONS(145),
    [anon_sym_BSLASHacrlongpl] = ACTIONS(145),
    [anon_sym_BSLASHAcrlongpl] = ACTIONS(145),
    [anon_sym_BSLASHACRlongpl] = ACTIONS(145),
    [anon_sym_BSLASHacrfull] = ACTIONS(145),
    [anon_sym_BSLASHAcrfull] = ACTIONS(145),
    [anon_sym_BSLASHACRfull] = ACTIONS(145),
    [anon_sym_BSLASHacrfullpl] = ACTIONS(145),
    [anon_sym_BSLASHAcrfullpl] = ACTIONS(145),
    [anon_sym_BSLASHACRfullpl] = ACTIONS(145),
    [anon_sym_BSLASHacs] = ACTIONS(145),
    [anon_sym_BSLASHAcs] = ACTIONS(145),
    [anon_sym_BSLASHacsp] = ACTIONS(145),
    [anon_sym_BSLASHAcsp] = ACTIONS(145),
    [anon_sym_BSLASHacl] = ACTIONS(145),
    [anon_sym_BSLASHAcl] = ACTIONS(145),
    [anon_sym_BSLASHaclp] = ACTIONS(145),
    [anon_sym_BSLASHAclp] = ACTIONS(145),
    [anon_sym_BSLASHacf] = ACTIONS(145),
    [anon_sym_BSLASHAcf] = ACTIONS(145),
    [anon_sym_BSLASHacfp] = ACTIONS(145),
    [anon_sym_BSLASHAcfp] = ACTIONS(145),
    [anon_sym_BSLASHac] = ACTIONS(145),
    [anon_sym_BSLASHAc] = ACTIONS(145),
    [anon_sym_BSLASHacp] = ACTIONS(145),
    [anon_sym_BSLASHglsentrylong] = ACTIONS(145),
    [anon_sym_BSLASHGlsentrylong] = ACTIONS(145),
    [anon_sym_BSLASHglsentrylongpl] = ACTIONS(145),
    [anon_sym_BSLASHGlsentrylongpl] = ACTIONS(145),
    [anon_sym_BSLASHglsentryshort] = ACTIONS(145),
    [anon_sym_BSLASHGlsentryshort] = ACTIONS(145),
    [anon_sym_BSLASHglsentryshortpl] = ACTIONS(145),
    [anon_sym_BSLASHGlsentryshortpl] = ACTIONS(145),
    [anon_sym_BSLASHglsentryfullpl] = ACTIONS(145),
    [anon_sym_BSLASHGlsentryfullpl] = ACTIONS(145),
    [anon_sym_BSLASHnewtheorem] = ACTIONS(145),
    [anon_sym_BSLASHnewtheorem_STAR] = ACTIONS(149),
    [anon_sym_BSLASHdeclaretheorem] = ACTIONS(145),
    [anon_sym_BSLASHdeclaretheorem_STAR] = ACTIONS(149),
    [anon_sym_BSLASHdefinecolor] = ACTIONS(145),
    [anon_sym_BSLASHdefinecolorset] = ACTIONS(145),
    [anon_sym_BSLASHcolor] = ACTIONS(145),
    [anon_sym_BSLASHcolorbox] = ACTIONS(145),
    [anon_sym_BSLASHtextcolor] = ACTIONS(145),
    [anon_sym_BSLASHpagecolor] = ACTIONS(145),
    [anon_sym_BSLASHusepgflibrary] = ACTIONS(145),
    [anon_sym_BSLASHusetikzlibrary] = ACTIONS(145),
    [anon_sym_BSLASHtext] = ACTIONS(145),
    [anon_sym_BSLASHintertext] = ACTIONS(145),
    [anon_sym_shortintertext] = ACTIONS(145),
  },
  [9] = {
    [sym_block_comment] = STATE(27),
    [sym__root_content] = STATE(27),
    [sym__flat_content] = STATE(27),
    [sym__text_with_env_content] = STATE(27),
    [sym__text_content] = STATE(27),
    [sym__section] = STATE(27),
    [sym__part_declaration] = STATE(175),
    [sym_part] = STATE(367),
    [sym__chapter_declaration] = STATE(177),
    [sym_chapter] = STATE(368),
    [sym__section_declaration] = STATE(187),
    [sym_section] = STATE(369),
    [sym__subsection_declaration] = STATE(196),
    [sym_subsection] = STATE(370),
    [sym__subsubsection_declaration] = STATE(207),
    [sym_subsubsection] = STATE(371),
    [sym__paragraph_declaration] = STATE(218),
    [sym_paragraph] = STATE(373),
    [sym__subparagraph_declaration] = STATE(228),
    [sym_subparagraph] = STATE(374),
    [sym__enum_itemdeclaration] = STATE(238),
    [sym_enum_item] = STATE(375),
    [sym_curly_group] = STATE(27),
    [sym_text] = STATE(27),
    [sym_operator] = STATE(484),
    [sym_subscript] = STATE(484),
    [sym_superscript] = STATE(484),
    [sym_displayed_equation] = STATE(27),
    [sym_inline_formula] = STATE(27),
    [sym_begin] = STATE(65),
    [sym_generic_environment] = STATE(27),
    [sym_comment_environment] = STATE(27),
    [sym__comment_environment_begin] = STATE(3120),
    [sym_verbatim_environment] = STATE(27),
    [sym__verbatim_environment_begin] = STATE(3121),
    [sym_listing_environment] = STATE(27),
    [sym__listing_environment_begin] = STATE(3122),
    [sym_minted_environment] = STATE(27),
    [sym__minted_environment_begin] = STATE(3123),
    [sym_pycode_environment] = STATE(27),
    [sym__pycode_environment_begin] = STATE(3124),
    [sym_math_environment] = STATE(27),
    [sym__math_environment_begin] = STATE(269),
    [sym__command] = STATE(27),
    [sym_generic_command] = STATE(27),
    [sym_title_declaration] = STATE(27),
    [sym_author_declaration] = STATE(27),
    [sym_package_include] = STATE(27),
    [sym_class_include] = STATE(27),
    [sym_latex_include] = STATE(27),
    [sym_biblatex_include] = STATE(27),
    [sym_bibtex_include] = STATE(27),
    [sym_graphics_include] = STATE(27),
    [sym_svg_include] = STATE(27),
    [sym_inkscape_include] = STATE(27),
    [sym_verbatim_include] = STATE(27),
    [sym_import_include] = STATE(27),
    [sym_caption] = STATE(27),
    [sym_citation] = STATE(27),
    [sym_label_definition] = STATE(27),
    [sym_label_reference] = STATE(27),
    [sym_label_reference_range] = STATE(27),
    [sym_label_number] = STATE(27),
    [sym_new_command_definition] = STATE(27),
    [sym_old_command_definition] = STATE(27),
    [sym_let_command_definition] = STATE(27),
    [sym_math_delimiter] = STATE(27),
    [sym_paired_delimiter_definition] = STATE(27),
    [sym_environment_definition] = STATE(27),
    [sym_glossary_entry_definition] = STATE(27),
    [sym_glossary_entry_reference] = STATE(27),
    [sym_acronym_definition] = STATE(27),
    [sym_acronym_reference] = STATE(27),
    [sym_theorem_definition] = STATE(27),
    [sym_color_definition] = STATE(27),
    [sym_color_set_definition] = STATE(27),
    [sym_color_reference] = STATE(27),
    [sym_tikz_library_import] = STATE(27),
    [sym_text_mode] = STATE(27),
    [aux_sym_source_file_repeat1] = STATE(27),
    [aux_sym__section_repeat1] = STATE(367),
    [aux_sym__section_repeat2] = STATE(368),
    [aux_sym__section_repeat3] = STATE(369),
    [aux_sym__section_repeat4] = STATE(370),
    [aux_sym__section_repeat5] = STATE(371),
    [aux_sym__section_repeat6] = STATE(373),
    [aux_sym__section_repeat7] = STATE(374),
    [aux_sym__section_repeat8] = STATE(375),
    [aux_sym_text_repeat1] = STATE(259),
    [sym_command_name] = ACTIONS(187),
    [sym__whitespace] = ACTIONS(3),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_BSLASHiffalse] = ACTIONS(187),
    [anon_sym_LBRACK] = ACTIONS(185),
    [anon_sym_RBRACK] = ACTIONS(185),
    [anon_sym_COMMA] = ACTIONS(185),
    [anon_sym_EQ] = ACTIONS(185),
    [anon_sym_LPAREN] = ACTIONS(185),
    [anon_sym_RPAREN] = ACTIONS(185),
    [anon_sym_BSLASHpart] = ACTIONS(187),
    [anon_sym_BSLASHpart_STAR] = ACTIONS(185),
    [anon_sym_BSLASHaddpart] = ACTIONS(187),
    [anon_sym_BSLASHaddpart_STAR] = ACTIONS(185),
    [anon_sym_BSLASHchapter] = ACTIONS(187),
    [anon_sym_BSLASHchapter_STAR] = ACTIONS(185),
    [anon_sym_BSLASHaddchap] = ACTIONS(187),
    [anon_sym_BSLASHaddchap_STAR] = ACTIONS(185),
    [anon_sym_BSLASHsection] = ACTIONS(187),
    [anon_sym_BSLASHsection_STAR] = ACTIONS(185),
    [anon_sym_BSLASHaddsec] = ACTIONS(187),
    [anon_sym_BSLASHaddsec_STAR] = ACTIONS(185),
    [anon_sym_BSLASHsubsection] = ACTIONS(187),
    [anon_sym_BSLASHsubsection_STAR] = ACTIONS(185),
    [anon_sym_BSLASHsubsubsection] = ACTIONS(187),
    [anon_sym_BSLASHsubsubsection_STAR] = ACTIONS(185),
    [anon_sym_BSLASHparagraph] = ACTIONS(187),
    [anon_sym_BSLASHparagraph_STAR] = ACTIONS(185),
    [anon_sym_BSLASHsubparagraph] = ACTIONS(187),
    [anon_sym_BSLASHsubparagraph_STAR] = ACTIONS(185),
    [anon_sym_BSLASHitem] = ACTIONS(187),
    [anon_sym_BSLASHitem_STAR] = ACTIONS(185),
    [anon_sym_LBRACE] = ACTIONS(185),
    [sym_word] = ACTIONS(187),
    [sym_placeholder] = ACTIONS(185),
    [anon_sym_PLUS] = ACTIONS(185),
    [anon_sym_DASH] = ACTIONS(185),
    [anon_sym_STAR] = ACTIONS(185),
    [anon_sym_SLASH] = ACTIONS(185),
    [anon_sym_LT] = ACTIONS(187),
    [anon_sym_GT] = ACTIONS(187),
    [anon_sym_BANG] = ACTIONS(187),
    [anon_sym_PIPE] = ACTIONS(187),
    [anon_sym_COLON] = ACTIONS(187),
    [anon_sym_SQUOTE] = ACTIONS(187),
    [anon_sym__] = ACTIONS(185),
    [anon_sym_CARET] = ACTIONS(185),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(185),
    [anon_sym_BSLASH_LBRACK] = ACTIONS(185),
    [anon_sym_DOLLAR] = ACTIONS(187),
    [anon_sym_BSLASH_LPAREN] = ACTIONS(185),
    [anon_sym_BSLASHbegin] = ACTIONS(187),
    [anon_sym_BSLASHend] = ACTIONS(187),
    [anon_sym_BSLASHtitle] = ACTIONS(187),
    [anon_sym_BSLASHauthor] = ACTIONS(187),
    [anon_sym_BSLASHusepackage] = ACTIONS(187),
    [anon_sym_BSLASHRequirePackage] = ACTIONS(187),
    [anon_sym_BSLASHdocumentclass] = ACTIONS(187),
    [anon_sym_BSLASHinclude] = ACTIONS(187),
    [anon_sym_BSLASHsubfileinclude] = ACTIONS(187),
    [anon_sym_BSLASHinput] = ACTIONS(187),
    [anon_sym_BSLASHsubfile] = ACTIONS(187),
    [anon_sym_BSLASHaddbibresource] = ACTIONS(187),
    [anon_sym_BSLASHbibliography] = ACTIONS(187),
    [anon_sym_BSLASHincludegraphics] = ACTIONS(187),
    [anon_sym_BSLASHincludesvg] = ACTIONS(187),
    [anon_sym_BSLASHincludeinkscape] = ACTIONS(187),
    [anon_sym_BSLASHverbatiminput] = ACTIONS(187),
    [anon_sym_BSLASHVerbatimInput] = ACTIONS(187),
    [anon_sym_BSLASHimport] = ACTIONS(187),
    [anon_sym_BSLASHsubimport] = ACTIONS(187),
    [anon_sym_BSLASHinputfrom] = ACTIONS(187),
    [anon_sym_BSLASHsubimportfrom] = ACTIONS(187),
    [anon_sym_BSLASHincludefrom] = ACTIONS(187),
    [anon_sym_BSLASHsubincludefrom] = ACTIONS(187),
    [anon_sym_BSLASHcaption] = ACTIONS(187),
    [anon_sym_BSLASHcite] = ACTIONS(187),
    [anon_sym_BSLASHcite_STAR] = ACTIONS(185),
    [anon_sym_BSLASHCite] = ACTIONS(187),
    [anon_sym_BSLASHnocite] = ACTIONS(187),
    [anon_sym_BSLASHcitet] = ACTIONS(187),
    [anon_sym_BSLASHcitep] = ACTIONS(187),
    [anon_sym_BSLASHcitet_STAR] = ACTIONS(185),
    [anon_sym_BSLASHcitep_STAR] = ACTIONS(185),
    [anon_sym_BSLASHciteauthor] = ACTIONS(187),
    [anon_sym_BSLASHciteauthor_STAR] = ACTIONS(185),
    [anon_sym_BSLASHCiteauthor] = ACTIONS(187),
    [anon_sym_BSLASHCiteauthor_STAR] = ACTIONS(185),
    [anon_sym_BSLASHcitetitle] = ACTIONS(187),
    [anon_sym_BSLASHcitetitle_STAR] = ACTIONS(185),
    [anon_sym_BSLASHciteyear] = ACTIONS(187),
    [anon_sym_BSLASHciteyear_STAR] = ACTIONS(185),
    [anon_sym_BSLASHcitedate] = ACTIONS(187),
    [anon_sym_BSLASHcitedate_STAR] = ACTIONS(185),
    [anon_sym_BSLASHciteurl] = ACTIONS(187),
    [anon_sym_BSLASHfullcite] = ACTIONS(187),
    [anon_sym_BSLASHciteyearpar] = ACTIONS(187),
    [anon_sym_BSLASHcitealt] = ACTIONS(187),
    [anon_sym_BSLASHcitealp] = ACTIONS(187),
    [anon_sym_BSLASHcitetext] = ACTIONS(187),
    [anon_sym_BSLASHparencite] = ACTIONS(187),
    [anon_sym_BSLASHparencite_STAR] = ACTIONS(185),
    [anon_sym_BSLASHParencite] = ACTIONS(187),
    [anon_sym_BSLASHfootcite] = ACTIONS(187),
    [anon_sym_BSLASHfootfullcite] = ACTIONS(187),
    [anon_sym_BSLASHfootcitetext] = ACTIONS(187),
    [anon_sym_BSLASHtextcite] = ACTIONS(187),
    [anon_sym_BSLASHTextcite] = ACTIONS(187),
    [anon_sym_BSLASHsmartcite] = ACTIONS(187),
    [anon_sym_BSLASHSmartcite] = ACTIONS(187),
    [anon_sym_BSLASHsupercite] = ACTIONS(187),
    [anon_sym_BSLASHautocite] = ACTIONS(187),
    [anon_sym_BSLASHAutocite] = ACTIONS(187),
    [anon_sym_BSLASHautocite_STAR] = ACTIONS(185),
    [anon_sym_BSLASHAutocite_STAR] = ACTIONS(185),
    [anon_sym_BSLASHvolcite] = ACTIONS(187),
    [anon_sym_BSLASHVolcite] = ACTIONS(187),
    [anon_sym_BSLASHpvolcite] = ACTIONS(187),
    [anon_sym_BSLASHPvolcite] = ACTIONS(187),
    [anon_sym_BSLASHfvolcite] = ACTIONS(187),
    [anon_sym_BSLASHftvolcite] = ACTIONS(187),
    [anon_sym_BSLASHsvolcite] = ACTIONS(187),
    [anon_sym_BSLASHSvolcite] = ACTIONS(187),
    [anon_sym_BSLASHtvolcite] = ACTIONS(187),
    [anon_sym_BSLASHTvolcite] = ACTIONS(187),
    [anon_sym_BSLASHavolcite] = ACTIONS(187),
    [anon_sym_BSLASHAvolcite] = ACTIONS(187),
    [anon_sym_BSLASHnotecite] = ACTIONS(187),
    [anon_sym_BSLASHNotecite] = ACTIONS(187),
    [anon_sym_BSLASHpnotecite] = ACTIONS(187),
    [anon_sym_BSLASHPnotecite] = ACTIONS(187),
    [anon_sym_BSLASHfnotecite] = ACTIONS(187),
    [anon_sym_BSLASHlabel] = ACTIONS(187),
    [anon_sym_BSLASHref] = ACTIONS(187),
    [anon_sym_BSLASHeqref] = ACTIONS(187),
    [anon_sym_BSLASHvref] = ACTIONS(187),
    [anon_sym_BSLASHVref] = ACTIONS(187),
    [anon_sym_BSLASHautoref] = ACTIONS(187),
    [anon_sym_BSLASHpageref] = ACTIONS(187),
    [anon_sym_BSLASHcref] = ACTIONS(187),
    [anon_sym_BSLASHCref] = ACTIONS(187),
    [anon_sym_BSLASHcref_STAR] = ACTIONS(185),
    [anon_sym_BSLASHCref_STAR] = ACTIONS(185),
    [anon_sym_BSLASHnamecref] = ACTIONS(187),
    [anon_sym_BSLASHnameCref] = ACTIONS(187),
    [anon_sym_BSLASHlcnamecref] = ACTIONS(187),
    [anon_sym_BSLASHnamecrefs] = ACTIONS(187),
    [anon_sym_BSLASHnameCrefs] = ACTIONS(187),
    [anon_sym_BSLASHlcnamecrefs] = ACTIONS(187),
    [anon_sym_BSLASHlabelcref] = ACTIONS(187),
    [anon_sym_BSLASHlabelcpageref] = ACTIONS(187),
    [anon_sym_BSLASHcrefrange] = ACTIONS(187),
    [anon_sym_BSLASHcrefrange_STAR] = ACTIONS(185),
    [anon_sym_BSLASHCrefrange] = ACTIONS(187),
    [anon_sym_BSLASHCrefrange_STAR] = ACTIONS(185),
    [anon_sym_BSLASHnewlabel] = ACTIONS(187),
    [anon_sym_BSLASHnewcommand] = ACTIONS(187),
    [anon_sym_BSLASHnewcommand_STAR] = ACTIONS(185),
    [anon_sym_BSLASHrenewcommand] = ACTIONS(187),
    [anon_sym_BSLASHrenewcommand_STAR] = ACTIONS(185),
    [anon_sym_BSLASHDeclareRobustCommand] = ACTIONS(187),
    [anon_sym_BSLASHDeclareRobustCommand_STAR] = ACTIONS(185),
    [anon_sym_BSLASHDeclareMathOperator] = ACTIONS(187),
    [anon_sym_BSLASHDeclareMathOperator_STAR] = ACTIONS(185),
    [anon_sym_BSLASHNewDocumentCommand] = ACTIONS(187),
    [anon_sym_BSLASHRenewDocumentCommand] = ACTIONS(187),
    [anon_sym_BSLASHProvideDocumentCommand] = ACTIONS(187),
    [anon_sym_BSLASHDeclareDocumentCommand] = ACTIONS(187),
    [anon_sym_BSLASHNewExpandableDocumentCommand] = ACTIONS(187),
    [anon_sym_BSLASHRenewExpandableDocumentCommand] = ACTIONS(187),
    [anon_sym_BSLASHProvideExpandableDocumentCommand] = ACTIONS(187),
    [anon_sym_BSLASHDeclareExpandableDocumentCommand] = ACTIONS(187),
    [anon_sym_BSLASHdef] = ACTIONS(187),
    [anon_sym_BSLASHlet] = ACTIONS(187),
    [anon_sym_BSLASHleft] = ACTIONS(187),
    [anon_sym_BSLASHbig] = ACTIONS(187),
    [anon_sym_BSLASHBig] = ACTIONS(187),
    [anon_sym_BSLASHbigg] = ACTIONS(187),
    [anon_sym_BSLASHBigg] = ACTIONS(187),
    [anon_sym_BSLASHbigl] = ACTIONS(187),
    [anon_sym_BSLASHBigl] = ACTIONS(187),
    [anon_sym_BSLASHbiggl] = ACTIONS(187),
    [anon_sym_BSLASHBiggl] = ACTIONS(187),
    [anon_sym_BSLASHright] = ACTIONS(183),
    [anon_sym_BSLASHbigr] = ACTIONS(183),
    [anon_sym_BSLASHBigr] = ACTIONS(183),
    [anon_sym_BSLASHbiggr] = ACTIONS(183),
    [anon_sym_BSLASHBiggr] = ACTIONS(183),
    [anon_sym_BSLASHDeclarePairedDelimiter] = ACTIONS(187),
    [anon_sym_BSLASHDeclarePairedDelimiterX] = ACTIONS(187),
    [anon_sym_BSLASHnewenvironment] = ACTIONS(187),
    [anon_sym_BSLASHrenewenvironment] = ACTIONS(187),
    [anon_sym_BSLASHNewDocumentEnvironment] = ACTIONS(187),
    [anon_sym_BSLASHRenewDocumentEnvironment] = ACTIONS(187),
    [anon_sym_BSLASHProvideDocumentEnvironment] = ACTIONS(187),
    [anon_sym_BSLASHDeclareDocumentEnvironment] = ACTIONS(187),
    [anon_sym_BSLASHnewglossaryentry] = ACTIONS(187),
    [anon_sym_BSLASHgls] = ACTIONS(187),
    [anon_sym_BSLASHGls] = ACTIONS(187),
    [anon_sym_BSLASHGLS] = ACTIONS(187),
    [anon_sym_BSLASHglspl] = ACTIONS(187),
    [anon_sym_BSLASHGlspl] = ACTIONS(187),
    [anon_sym_BSLASHGLSpl] = ACTIONS(187),
    [anon_sym_BSLASHglsdisp] = ACTIONS(187),
    [anon_sym_BSLASHglslink] = ACTIONS(187),
    [anon_sym_BSLASHglstext] = ACTIONS(187),
    [anon_sym_BSLASHGlstext] = ACTIONS(187),
    [anon_sym_BSLASHGLStext] = ACTIONS(187),
    [anon_sym_BSLASHglsfirst] = ACTIONS(187),
    [anon_sym_BSLASHGlsfirst] = ACTIONS(187),
    [anon_sym_BSLASHGLSfirst] = ACTIONS(187),
    [anon_sym_BSLASHglsplural] = ACTIONS(187),
    [anon_sym_BSLASHGlsplural] = ACTIONS(187),
    [anon_sym_BSLASHGLSplural] = ACTIONS(187),
    [anon_sym_BSLASHglsfirstplural] = ACTIONS(187),
    [anon_sym_BSLASHGlsfirstplural] = ACTIONS(187),
    [anon_sym_BSLASHGLSfirstplural] = ACTIONS(187),
    [anon_sym_BSLASHglsname] = ACTIONS(187),
    [anon_sym_BSLASHGlsname] = ACTIONS(187),
    [anon_sym_BSLASHGLSname] = ACTIONS(187),
    [anon_sym_BSLASHglssymbol] = ACTIONS(187),
    [anon_sym_BSLASHGlssymbol] = ACTIONS(187),
    [anon_sym_BSLASHglsdesc] = ACTIONS(187),
    [anon_sym_BSLASHGlsdesc] = ACTIONS(187),
    [anon_sym_BSLASHGLSdesc] = ACTIONS(187),
    [anon_sym_BSLASHglsuseri] = ACTIONS(187),
    [anon_sym_BSLASHGlsuseri] = ACTIONS(187),
    [anon_sym_BSLASHGLSuseri] = ACTIONS(187),
    [anon_sym_BSLASHglsuserii] = ACTIONS(187),
    [anon_sym_BSLASHGlsuserii] = ACTIONS(187),
    [anon_sym_BSLASHGLSuserii] = ACTIONS(187),
    [anon_sym_BSLASHglsuseriii] = ACTIONS(187),
    [anon_sym_BSLASHGlsuseriii] = ACTIONS(187),
    [anon_sym_BSLASHGLSuseriii] = ACTIONS(187),
    [anon_sym_BSLASHglsuseriv] = ACTIONS(187),
    [anon_sym_BSLASHGlsuseriv] = ACTIONS(187),
    [anon_sym_BSLASHGLSuseriv] = ACTIONS(187),
    [anon_sym_BSLASHglsuserv] = ACTIONS(187),
    [anon_sym_BSLASHGlsuserv] = ACTIONS(187),
    [anon_sym_BSLASHGLSuserv] = ACTIONS(187),
    [anon_sym_BSLASHglsuservi] = ACTIONS(187),
    [anon_sym_BSLASHGlsuservi] = ACTIONS(187),
    [anon_sym_BSLASHGLSuservi] = ACTIONS(187),
    [anon_sym_BSLASHnewacronym] = ACTIONS(187),
    [anon_sym_BSLASHacrshort] = ACTIONS(187),
    [anon_sym_BSLASHAcrshort] = ACTIONS(187),
    [anon_sym_BSLASHACRshort] = ACTIONS(187),
    [anon_sym_BSLASHacrshortpl] = ACTIONS(187),
    [anon_sym_BSLASHAcrshortpl] = ACTIONS(187),
    [anon_sym_BSLASHACRshortpl] = ACTIONS(187),
    [anon_sym_BSLASHacrlong] = ACTIONS(187),
    [anon_sym_BSLASHAcrlong] = ACTIONS(187),
    [anon_sym_BSLASHACRlong] = ACTIONS(187),
    [anon_sym_BSLASHacrlongpl] = ACTIONS(187),
    [anon_sym_BSLASHAcrlongpl] = ACTIONS(187),
    [anon_sym_BSLASHACRlongpl] = ACTIONS(187),
    [anon_sym_BSLASHacrfull] = ACTIONS(187),
    [anon_sym_BSLASHAcrfull] = ACTIONS(187),
    [anon_sym_BSLASHACRfull] = ACTIONS(187),
    [anon_sym_BSLASHacrfullpl] = ACTIONS(187),
    [anon_sym_BSLASHAcrfullpl] = ACTIONS(187),
    [anon_sym_BSLASHACRfullpl] = ACTIONS(187),
    [anon_sym_BSLASHacs] = ACTIONS(187),
    [anon_sym_BSLASHAcs] = ACTIONS(187),
    [anon_sym_BSLASHacsp] = ACTIONS(187),
    [anon_sym_BSLASHAcsp] = ACTIONS(187),
    [anon_sym_BSLASHacl] = ACTIONS(187),
    [anon_sym_BSLASHAcl] = ACTIONS(187),
    [anon_sym_BSLASHaclp] = ACTIONS(187),
    [anon_sym_BSLASHAclp] = ACTIONS(187),
    [anon_sym_BSLASHacf] = ACTIONS(187),
    [anon_sym_BSLASHAcf] = ACTIONS(187),
    [anon_sym_BSLASHacfp] = ACTIONS(187),
    [anon_sym_BSLASHAcfp] = ACTIONS(187),
    [anon_sym_BSLASHac] = ACTIONS(187),
    [anon_sym_BSLASHAc] = ACTIONS(187),
    [anon_sym_BSLASHacp] = ACTIONS(187),
    [anon_sym_BSLASHglsentrylong] = ACTIONS(187),
    [anon_sym_BSLASHGlsentrylong] = ACTIONS(187),
    [anon_sym_BSLASHglsentrylongpl] = ACTIONS(187),
    [anon_sym_BSLASHGlsentrylongpl] = ACTIONS(187),
    [anon_sym_BSLASHglsentryshort] = ACTIONS(187),
    [anon_sym_BSLASHGlsentryshort] = ACTIONS(187),
    [anon_sym_BSLASHglsentryshortpl] = ACTIONS(187),
    [anon_sym_BSLASHGlsentryshortpl] = ACTIONS(187),
    [anon_sym_BSLASHglsentryfullpl] = ACTIONS(187),
    [anon_sym_BSLASHGlsentryfullpl] = ACTIONS(187),
    [anon_sym_BSLASHnewtheorem] = ACTIONS(187),
    [anon_sym_BSLASHnewtheorem_STAR] = ACTIONS(185),
    [anon_sym_BSLASHdeclaretheorem] = ACTIONS(187),
    [anon_sym_BSLASHdeclaretheorem_STAR] = ACTIONS(185),
    [anon_sym_BSLASHdefinecolor] = ACTIONS(187),
    [anon_sym_BSLASHdefinecolorset] = ACTIONS(187),
    [anon_sym_BSLASHcolor] = ACTIONS(187),
    [anon_sym_BSLASHcolorbox] = ACTIONS(187),
    [anon_sym_BSLASHtextcolor] = ACTIONS(187),
    [anon_sym_BSLASHpagecolor] = ACTIONS(187),
    [anon_sym_BSLASHusepgflibrary] = ACTIONS(187),
    [anon_sym_BSLASHusetikzlibrary] = ACTIONS(187),
    [anon_sym_BSLASHtext] = ACTIONS(187),
    [anon_sym_BSLASHintertext] = ACTIONS(187),
    [anon_sym_shortintertext] = ACTIONS(187),
  },
  [10] = {
    [sym_block_comment] = STATE(27),
    [sym__root_content] = STATE(27),
    [sym__flat_content] = STATE(27),
    [sym__text_with_env_content] = STATE(27),
    [sym__text_content] = STATE(27),
    [sym__section] = STATE(27),
    [sym__part_declaration] = STATE(175),
    [sym_part] = STATE(367),
    [sym__chapter_declaration] = STATE(177),
    [sym_chapter] = STATE(368),
    [sym__section_declaration] = STATE(187),
    [sym_section] = STATE(369),
    [sym__subsection_declaration] = STATE(196),
    [sym_subsection] = STATE(370),
    [sym__subsubsection_declaration] = STATE(207),
    [sym_subsubsection] = STATE(371),
    [sym__paragraph_declaration] = STATE(218),
    [sym_paragraph] = STATE(373),
    [sym__subparagraph_declaration] = STATE(228),
    [sym_subparagraph] = STATE(374),
    [sym__enum_itemdeclaration] = STATE(238),
    [sym_enum_item] = STATE(375),
    [sym_curly_group] = STATE(27),
    [sym_text] = STATE(27),
    [sym_operator] = STATE(484),
    [sym_subscript] = STATE(484),
    [sym_superscript] = STATE(484),
    [sym_displayed_equation] = STATE(27),
    [sym_inline_formula] = STATE(27),
    [sym_begin] = STATE(65),
    [sym_generic_environment] = STATE(27),
    [sym_comment_environment] = STATE(27),
    [sym__comment_environment_begin] = STATE(3120),
    [sym_verbatim_environment] = STATE(27),
    [sym__verbatim_environment_begin] = STATE(3121),
    [sym_listing_environment] = STATE(27),
    [sym__listing_environment_begin] = STATE(3122),
    [sym_minted_environment] = STATE(27),
    [sym__minted_environment_begin] = STATE(3123),
    [sym_pycode_environment] = STATE(27),
    [sym__pycode_environment_begin] = STATE(3124),
    [sym_math_environment] = STATE(27),
    [sym__math_environment_begin] = STATE(269),
    [sym__command] = STATE(27),
    [sym_generic_command] = STATE(27),
    [sym_title_declaration] = STATE(27),
    [sym_author_declaration] = STATE(27),
    [sym_package_include] = STATE(27),
    [sym_class_include] = STATE(27),
    [sym_latex_include] = STATE(27),
    [sym_biblatex_include] = STATE(27),
    [sym_bibtex_include] = STATE(27),
    [sym_graphics_include] = STATE(27),
    [sym_svg_include] = STATE(27),
    [sym_inkscape_include] = STATE(27),
    [sym_verbatim_include] = STATE(27),
    [sym_import_include] = STATE(27),
    [sym_caption] = STATE(27),
    [sym_citation] = STATE(27),
    [sym_label_definition] = STATE(27),
    [sym_label_reference] = STATE(27),
    [sym_label_reference_range] = STATE(27),
    [sym_label_number] = STATE(27),
    [sym_new_command_definition] = STATE(27),
    [sym_old_command_definition] = STATE(27),
    [sym_let_command_definition] = STATE(27),
    [sym_math_delimiter] = STATE(27),
    [sym_paired_delimiter_definition] = STATE(27),
    [sym_environment_definition] = STATE(27),
    [sym_glossary_entry_definition] = STATE(27),
    [sym_glossary_entry_reference] = STATE(27),
    [sym_acronym_definition] = STATE(27),
    [sym_acronym_reference] = STATE(27),
    [sym_theorem_definition] = STATE(27),
    [sym_color_definition] = STATE(27),
    [sym_color_set_definition] = STATE(27),
    [sym_color_reference] = STATE(27),
    [sym_tikz_library_import] = STATE(27),
    [sym_text_mode] = STATE(27),
    [aux_sym_source_file_repeat1] = STATE(27),
    [aux_sym__section_repeat1] = STATE(367),
    [aux_sym__section_repeat2] = STATE(368),
    [aux_sym__section_repeat3] = STATE(369),
    [aux_sym__section_repeat4] = STATE(370),
    [aux_sym__section_repeat5] = STATE(371),
    [aux_sym__section_repeat6] = STATE(373),
    [aux_sym__section_repeat7] = STATE(374),
    [aux_sym__section_repeat8] = STATE(375),
    [aux_sym_text_repeat1] = STATE(259),
    [sym_command_name] = ACTIONS(145),
    [sym__whitespace] = ACTIONS(3),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_BSLASHiffalse] = ACTIONS(145),
    [anon_sym_LBRACK] = ACTIONS(149),
    [anon_sym_RBRACK] = ACTIONS(149),
    [anon_sym_COMMA] = ACTIONS(149),
    [anon_sym_EQ] = ACTIONS(149),
    [anon_sym_LPAREN] = ACTIONS(149),
    [anon_sym_RPAREN] = ACTIONS(149),
    [anon_sym_BSLASHpart] = ACTIONS(145),
    [anon_sym_BSLASHpart_STAR] = ACTIONS(149),
    [anon_sym_BSLASHaddpart] = ACTIONS(145),
    [anon_sym_BSLASHaddpart_STAR] = ACTIONS(149),
    [anon_sym_BSLASHchapter] = ACTIONS(145),
    [anon_sym_BSLASHchapter_STAR] = ACTIONS(149),
    [anon_sym_BSLASHaddchap] = ACTIONS(145),
    [anon_sym_BSLASHaddchap_STAR] = ACTIONS(149),
    [anon_sym_BSLASHsection] = ACTIONS(145),
    [anon_sym_BSLASHsection_STAR] = ACTIONS(149),
    [anon_sym_BSLASHaddsec] = ACTIONS(145),
    [anon_sym_BSLASHaddsec_STAR] = ACTIONS(149),
    [anon_sym_BSLASHsubsection] = ACTIONS(145),
    [anon_sym_BSLASHsubsection_STAR] = ACTIONS(149),
    [anon_sym_BSLASHsubsubsection] = ACTIONS(145),
    [anon_sym_BSLASHsubsubsection_STAR] = ACTIONS(149),
    [anon_sym_BSLASHparagraph] = ACTIONS(145),
    [anon_sym_BSLASHparagraph_STAR] = ACTIONS(149),
    [anon_sym_BSLASHsubparagraph] = ACTIONS(145),
    [anon_sym_BSLASHsubparagraph_STAR] = ACTIONS(149),
    [anon_sym_BSLASHitem] = ACTIONS(145),
    [anon_sym_BSLASHitem_STAR] = ACTIONS(149),
    [anon_sym_LBRACE] = ACTIONS(149),
    [sym_word] = ACTIONS(145),
    [sym_placeholder] = ACTIONS(149),
    [anon_sym_PLUS] = ACTIONS(149),
    [anon_sym_DASH] = ACTIONS(149),
    [anon_sym_STAR] = ACTIONS(149),
    [anon_sym_SLASH] = ACTIONS(149),
    [anon_sym_LT] = ACTIONS(145),
    [anon_sym_GT] = ACTIONS(145),
    [anon_sym_BANG] = ACTIONS(145),
    [anon_sym_PIPE] = ACTIONS(145),
    [anon_sym_COLON] = ACTIONS(145),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [anon_sym__] = ACTIONS(149),
    [anon_sym_CARET] = ACTIONS(149),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(149),
    [anon_sym_BSLASH_LBRACK] = ACTIONS(149),
    [anon_sym_DOLLAR] = ACTIONS(145),
    [anon_sym_BSLASH_LPAREN] = ACTIONS(149),
    [anon_sym_BSLASH_RPAREN] = ACTIONS(149),
    [anon_sym_BSLASHbegin] = ACTIONS(145),
    [anon_sym_BSLASHtitle] = ACTIONS(145),
    [anon_sym_BSLASHauthor] = ACTIONS(145),
    [anon_sym_BSLASHusepackage] = ACTIONS(145),
    [anon_sym_BSLASHRequirePackage] = ACTIONS(145),
    [anon_sym_BSLASHdocumentclass] = ACTIONS(145),
    [anon_sym_BSLASHinclude] = ACTIONS(145),
    [anon_sym_BSLASHsubfileinclude] = ACTIONS(145),
    [anon_sym_BSLASHinput] = ACTIONS(145),
    [anon_sym_BSLASHsubfile] = ACTIONS(145),
    [anon_sym_BSLASHaddbibresource] = ACTIONS(145),
    [anon_sym_BSLASHbibliography] = ACTIONS(145),
    [anon_sym_BSLASHincludegraphics] = ACTIONS(145),
    [anon_sym_BSLASHincludesvg] = ACTIONS(145),
    [anon_sym_BSLASHincludeinkscape] = ACTIONS(145),
    [anon_sym_BSLASHverbatiminput] = ACTIONS(145),
    [anon_sym_BSLASHVerbatimInput] = ACTIONS(145),
    [anon_sym_BSLASHimport] = ACTIONS(145),
    [anon_sym_BSLASHsubimport] = ACTIONS(145),
    [anon_sym_BSLASHinputfrom] = ACTIONS(145),
    [anon_sym_BSLASHsubimportfrom] = ACTIONS(145),
    [anon_sym_BSLASHincludefrom] = ACTIONS(145),
    [anon_sym_BSLASHsubincludefrom] = ACTIONS(145),
    [anon_sym_BSLASHcaption] = ACTIONS(145),
    [anon_sym_BSLASHcite] = ACTIONS(145),
    [anon_sym_BSLASHcite_STAR] = ACTIONS(149),
    [anon_sym_BSLASHCite] = ACTIONS(145),
    [anon_sym_BSLASHnocite] = ACTIONS(145),
    [anon_sym_BSLASHcitet] = ACTIONS(145),
    [anon_sym_BSLASHcitep] = ACTIONS(145),
    [anon_sym_BSLASHcitet_STAR] = ACTIONS(149),
    [anon_sym_BSLASHcitep_STAR] = ACTIONS(149),
    [anon_sym_BSLASHciteauthor] = ACTIONS(145),
    [anon_sym_BSLASHciteauthor_STAR] = ACTIONS(149),
    [anon_sym_BSLASHCiteauthor] = ACTIONS(145),
    [anon_sym_BSLASHCiteauthor_STAR] = ACTIONS(149),
    [anon_sym_BSLASHcitetitle] = ACTIONS(145),
    [anon_sym_BSLASHcitetitle_STAR] = ACTIONS(149),
    [anon_sym_BSLASHciteyear] = ACTIONS(145),
    [anon_sym_BSLASHciteyear_STAR] = ACTIONS(149),
    [anon_sym_BSLASHcitedate] = ACTIONS(145),
    [anon_sym_BSLASHcitedate_STAR] = ACTIONS(149),
    [anon_sym_BSLASHciteurl] = ACTIONS(145),
    [anon_sym_BSLASHfullcite] = ACTIONS(145),
    [anon_sym_BSLASHciteyearpar] = ACTIONS(145),
    [anon_sym_BSLASHcitealt] = ACTIONS(145),
    [anon_sym_BSLASHcitealp] = ACTIONS(145),
    [anon_sym_BSLASHcitetext] = ACTIONS(145),
    [anon_sym_BSLASHparencite] = ACTIONS(145),
    [anon_sym_BSLASHparencite_STAR] = ACTIONS(149),
    [anon_sym_BSLASHParencite] = ACTIONS(145),
    [anon_sym_BSLASHfootcite] = ACTIONS(145),
    [anon_sym_BSLASHfootfullcite] = ACTIONS(145),
    [anon_sym_BSLASHfootcitetext] = ACTIONS(145),
    [anon_sym_BSLASHtextcite] = ACTIONS(145),
    [anon_sym_BSLASHTextcite] = ACTIONS(145),
    [anon_sym_BSLASHsmartcite] = ACTIONS(145),
    [anon_sym_BSLASHSmartcite] = ACTIONS(145),
    [anon_sym_BSLASHsupercite] = ACTIONS(145),
    [anon_sym_BSLASHautocite] = ACTIONS(145),
    [anon_sym_BSLASHAutocite] = ACTIONS(145),
    [anon_sym_BSLASHautocite_STAR] = ACTIONS(149),
    [anon_sym_BSLASHAutocite_STAR] = ACTIONS(149),
    [anon_sym_BSLASHvolcite] = ACTIONS(145),
    [anon_sym_BSLASHVolcite] = ACTIONS(145),
    [anon_sym_BSLASHpvolcite] = ACTIONS(145),
    [anon_sym_BSLASHPvolcite] = ACTIONS(145),
    [anon_sym_BSLASHfvolcite] = ACTIONS(145),
    [anon_sym_BSLASHftvolcite] = ACTIONS(145),
    [anon_sym_BSLASHsvolcite] = ACTIONS(145),
    [anon_sym_BSLASHSvolcite] = ACTIONS(145),
    [anon_sym_BSLASHtvolcite] = ACTIONS(145),
    [anon_sym_BSLASHTvolcite] = ACTIONS(145),
    [anon_sym_BSLASHavolcite] = ACTIONS(145),
    [anon_sym_BSLASHAvolcite] = ACTIONS(145),
    [anon_sym_BSLASHnotecite] = ACTIONS(145),
    [anon_sym_BSLASHNotecite] = ACTIONS(145),
    [anon_sym_BSLASHpnotecite] = ACTIONS(145),
    [anon_sym_BSLASHPnotecite] = ACTIONS(145),
    [anon_sym_BSLASHfnotecite] = ACTIONS(145),
    [anon_sym_BSLASHlabel] = ACTIONS(145),
    [anon_sym_BSLASHref] = ACTIONS(145),
    [anon_sym_BSLASHeqref] = ACTIONS(145),
    [anon_sym_BSLASHvref] = ACTIONS(145),
    [anon_sym_BSLASHVref] = ACTIONS(145),
    [anon_sym_BSLASHautoref] = ACTIONS(145),
    [anon_sym_BSLASHpageref] = ACTIONS(145),
    [anon_sym_BSLASHcref] = ACTIONS(145),
    [anon_sym_BSLASHCref] = ACTIONS(145),
    [anon_sym_BSLASHcref_STAR] = ACTIONS(149),
    [anon_sym_BSLASHCref_STAR] = ACTIONS(149),
    [anon_sym_BSLASHnamecref] = ACTIONS(145),
    [anon_sym_BSLASHnameCref] = ACTIONS(145),
    [anon_sym_BSLASHlcnamecref] = ACTIONS(145),
    [anon_sym_BSLASHnamecrefs] = ACTIONS(145),
    [anon_sym_BSLASHnameCrefs] = ACTIONS(145),
    [anon_sym_BSLASHlcnamecrefs] = ACTIONS(145),
    [anon_sym_BSLASHlabelcref] = ACTIONS(145),
    [anon_sym_BSLASHlabelcpageref] = ACTIONS(145),
    [anon_sym_BSLASHcrefrange] = ACTIONS(145),
    [anon_sym_BSLASHcrefrange_STAR] = ACTIONS(149),
    [anon_sym_BSLASHCrefrange] = ACTIONS(145),
    [anon_sym_BSLASHCrefrange_STAR] = ACTIONS(149),
    [anon_sym_BSLASHnewlabel] = ACTIONS(145),
    [anon_sym_BSLASHnewcommand] = ACTIONS(145),
    [anon_sym_BSLASHnewcommand_STAR] = ACTIONS(149),
    [anon_sym_BSLASHrenewcommand] = ACTIONS(145),
    [anon_sym_BSLASHrenewcommand_STAR] = ACTIONS(149),
    [anon_sym_BSLASHDeclareRobustCommand] = ACTIONS(145),
    [anon_sym_BSLASHDeclareRobustCommand_STAR] = ACTIONS(149),
    [anon_sym_BSLASHDeclareMathOperator] = ACTIONS(145),
    [anon_sym_BSLASHDeclareMathOperator_STAR] = ACTIONS(149),
    [anon_sym_BSLASHNewDocumentCommand] = ACTIONS(145),
    [anon_sym_BSLASHRenewDocumentCommand] = ACTIONS(145),
    [anon_sym_BSLASHProvideDocumentCommand] = ACTIONS(145),
    [anon_sym_BSLASHDeclareDocumentCommand] = ACTIONS(145),
    [anon_sym_BSLASHNewExpandableDocumentCommand] = ACTIONS(145),
    [anon_sym_BSLASHRenewExpandableDocumentCommand] = ACTIONS(145),
    [anon_sym_BSLASHProvideExpandableDocumentCommand] = ACTIONS(145),
    [anon_sym_BSLASHDeclareExpandableDocumentCommand] = ACTIONS(145),
    [anon_sym_BSLASHdef] = ACTIONS(145),
    [anon_sym_BSLASHlet] = ACTIONS(145),
    [anon_sym_BSLASHleft] = ACTIONS(145),
    [anon_sym_BSLASHbig] = ACTIONS(145),
    [anon_sym_BSLASHBig] = ACTIONS(145),
    [anon_sym_BSLASHbigg] = ACTIONS(145),
    [anon_sym_BSLASHBigg] = ACTIONS(145),
    [anon_sym_BSLASHbigl] = ACTIONS(145),
    [anon_sym_BSLASHBigl] = ACTIONS(145),
    [anon_sym_BSLASHbiggl] = ACTIONS(145),
    [anon_sym_BSLASHBiggl] = ACTIONS(145),
    [anon_sym_BSLASHright] = ACTIONS(183),
    [anon_sym_BSLASHbigr] = ACTIONS(183),
    [anon_sym_BSLASHBigr] = ACTIONS(183),
    [anon_sym_BSLASHbiggr] = ACTIONS(183),
    [anon_sym_BSLASHBiggr] = ACTIONS(183),
    [anon_sym_BSLASHDeclarePairedDelimiter] = ACTIONS(145),
    [anon_sym_BSLASHDeclarePairedDelimiterX] = ACTIONS(145),
    [anon_sym_BSLASHnewenvironment] = ACTIONS(145),
    [anon_sym_BSLASHrenewenvironment] = ACTIONS(145),
    [anon_sym_BSLASHNewDocumentEnvironment] = ACTIONS(145),
    [anon_sym_BSLASHRenewDocumentEnvironment] = ACTIONS(145),
    [anon_sym_BSLASHProvideDocumentEnvironment] = ACTIONS(145),
    [anon_sym_BSLASHDeclareDocumentEnvironment] = ACTIONS(145),
    [anon_sym_BSLASHnewglossaryentry] = ACTIONS(145),
    [anon_sym_BSLASHgls] = ACTIONS(145),
    [anon_sym_BSLASHGls] = ACTIONS(145),
    [anon_sym_BSLASHGLS] = ACTIONS(145),
    [anon_sym_BSLASHglspl] = ACTIONS(145),
    [anon_sym_BSLASHGlspl] = ACTIONS(145),
    [anon_sym_BSLASHGLSpl] = ACTIONS(145),
    [anon_sym_BSLASHglsdisp] = ACTIONS(145),
    [anon_sym_BSLASHglslink] = ACTIONS(145),
    [anon_sym_BSLASHglstext] = ACTIONS(145),
    [anon_sym_BSLASHGlstext] = ACTIONS(145),
    [anon_sym_BSLASHGLStext] = ACTIONS(145),
    [anon_sym_BSLASHglsfirst] = ACTIONS(145),
    [anon_sym_BSLASHGlsfirst] = ACTIONS(145),
    [anon_sym_BSLASHGLSfirst] = ACTIONS(145),
    [anon_sym_BSLASHglsplural] = ACTIONS(145),
    [anon_sym_BSLASHGlsplural] = ACTIONS(145),
    [anon_sym_BSLASHGLSplural] = ACTIONS(145),
    [anon_sym_BSLASHglsfirstplural] = ACTIONS(145),
    [anon_sym_BSLASHGlsfirstplural] = ACTIONS(145),
    [anon_sym_BSLASHGLSfirstplural] = ACTIONS(145),
    [anon_sym_BSLASHglsname] = ACTIONS(145),
    [anon_sym_BSLASHGlsname] = ACTIONS(145),
    [anon_sym_BSLASHGLSname] = ACTIONS(145),
    [anon_sym_BSLASHglssymbol] = ACTIONS(145),
    [anon_sym_BSLASHGlssymbol] = ACTIONS(145),
    [anon_sym_BSLASHglsdesc] = ACTIONS(145),
    [anon_sym_BSLASHGlsdesc] = ACTIONS(145),
    [anon_sym_BSLASHGLSdesc] = ACTIONS(145),
    [anon_sym_BSLASHglsuseri] = ACTIONS(145),
    [anon_sym_BSLASHGlsuseri] = ACTIONS(145),
    [anon_sym_BSLASHGLSuseri] = ACTIONS(145),
    [anon_sym_BSLASHglsuserii] = ACTIONS(145),
    [anon_sym_BSLASHGlsuserii] = ACTIONS(145),
    [anon_sym_BSLASHGLSuserii] = ACTIONS(145),
    [anon_sym_BSLASHglsuseriii] = ACTIONS(145),
    [anon_sym_BSLASHGlsuseriii] = ACTIONS(145),
    [anon_sym_BSLASHGLSuseriii] = ACTIONS(145),
    [anon_sym_BSLASHglsuseriv] = ACTIONS(145),
    [anon_sym_BSLASHGlsuseriv] = ACTIONS(145),
    [anon_sym_BSLASHGLSuseriv] = ACTIONS(145),
    [anon_sym_BSLASHglsuserv] = ACTIONS(145),
    [anon_sym_BSLASHGlsuserv] = ACTIONS(145),
    [anon_sym_BSLASHGLSuserv] = ACTIONS(145),
    [anon_sym_BSLASHglsuservi] = ACTIONS(145),
    [anon_sym_BSLASHGlsuservi] = ACTIONS(145),
    [anon_sym_BSLASHGLSuservi] = ACTIONS(145),
    [anon_sym_BSLASHnewacronym] = ACTIONS(145),
    [anon_sym_BSLASHacrshort] = ACTIONS(145),
    [anon_sym_BSLASHAcrshort] = ACTIONS(145),
    [anon_sym_BSLASHACRshort] = ACTIONS(145),
    [anon_sym_BSLASHacrshortpl] = ACTIONS(145),
    [anon_sym_BSLASHAcrshortpl] = ACTIONS(145),
    [anon_sym_BSLASHACRshortpl] = ACTIONS(145),
    [anon_sym_BSLASHacrlong] = ACTIONS(145),
    [anon_sym_BSLASHAcrlong] = ACTIONS(145),
    [anon_sym_BSLASHACRlong] = ACTIONS(145),
    [anon_sym_BSLASHacrlongpl] = ACTIONS(145),
    [anon_sym_BSLASHAcrlongpl] = ACTIONS(145),
    [anon_sym_BSLASHACRlongpl] = ACTIONS(145),
    [anon_sym_BSLASHacrfull] = ACTIONS(145),
    [anon_sym_BSLASHAcrfull] = ACTIONS(145),
    [anon_sym_BSLASHACRfull] = ACTIONS(145),
    [anon_sym_BSLASHacrfullpl] = ACTIONS(145),
    [anon_sym_BSLASHAcrfullpl] = ACTIONS(145),
    [anon_sym_BSLASHACRfullpl] = ACTIONS(145),
    [anon_sym_BSLASHacs] = ACTIONS(145),
    [anon_sym_BSLASHAcs] = ACTIONS(145),
    [anon_sym_BSLASHacsp] = ACTIONS(145),
    [anon_sym_BSLASHAcsp] = ACTIONS(145),
    [anon_sym_BSLASHacl] = ACTIONS(145),
    [anon_sym_BSLASHAcl] = ACTIONS(145),
    [anon_sym_BSLASHaclp] = ACTIONS(145),
    [anon_sym_BSLASHAclp] = ACTIONS(145),
    [anon_sym_BSLASHacf] = ACTIONS(145),
    [anon_sym_BSLASHAcf] = ACTIONS(145),
    [anon_sym_BSLASHacfp] = ACTIONS(145),
    [anon_sym_BSLASHAcfp] = ACTIONS(145),
    [anon_sym_BSLASHac] = ACTIONS(145),
    [anon_sym_BSLASHAc] = ACTIONS(145),
    [anon_sym_BSLASHacp] = ACTIONS(145),
    [anon_sym_BSLASHglsentrylong] = ACTIONS(145),
    [anon_sym_BSLASHGlsentrylong] = ACTIONS(145),
    [anon_sym_BSLASHglsentrylongpl] = ACTIONS(145),
    [anon_sym_BSLASHGlsentrylongpl] = ACTIONS(145),
    [anon_sym_BSLASHglsentryshort] = ACTIONS(145),
    [anon_sym_BSLASHGlsentryshort] = ACTIONS(145),
    [anon_sym_BSLASHglsentryshortpl] = ACTIONS(145),
    [anon_sym_BSLASHGlsentryshortpl] = ACTIONS(145),
    [anon_sym_BSLASHglsentryfullpl] = ACTIONS(145),
    [anon_sym_BSLASHGlsentryfullpl] = ACTIONS(145),
    [anon_sym_BSLASHnewtheorem] = ACTIONS(145),
    [anon_sym_BSLASHnewtheorem_STAR] = ACTIONS(149),
    [anon_sym_BSLASHdeclaretheorem] = ACTIONS(145),
    [anon_sym_BSLASHdeclaretheorem_STAR] = ACTIONS(149),
    [anon_sym_BSLASHdefinecolor] = ACTIONS(145),
    [anon_sym_BSLASHdefinecolorset] = ACTIONS(145),
    [anon_sym_BSLASHcolor] = ACTIONS(145),
    [anon_sym_BSLASHcolorbox] = ACTIONS(145),
    [anon_sym_BSLASHtextcolor] = ACTIONS(145),
    [anon_sym_BSLASHpagecolor] = ACTIONS(145),
    [anon_sym_BSLASHusepgflibrary] = ACTIONS(145),
    [anon_sym_BSLASHusetikzlibrary] = ACTIONS(145),
    [anon_sym_BSLASHtext] = ACTIONS(145),
    [anon_sym_BSLASHintertext] = ACTIONS(145),
    [anon_sym_shortintertext] = ACTIONS(145),
  },
  [11] = {
    [sym_block_comment] = STATE(27),
    [sym__root_content] = STATE(27),
    [sym__flat_content] = STATE(27),
    [sym__text_with_env_content] = STATE(27),
    [sym__text_content] = STATE(27),
    [sym__section] = STATE(27),
    [sym__part_declaration] = STATE(175),
    [sym_part] = STATE(367),
    [sym__chapter_declaration] = STATE(177),
    [sym_chapter] = STATE(368),
    [sym__section_declaration] = STATE(187),
    [sym_section] = STATE(369),
    [sym__subsection_declaration] = STATE(196),
    [sym_subsection] = STATE(370),
    [sym__subsubsection_declaration] = STATE(207),
    [sym_subsubsection] = STATE(371),
    [sym__paragraph_declaration] = STATE(218),
    [sym_paragraph] = STATE(373),
    [sym__subparagraph_declaration] = STATE(228),
    [sym_subparagraph] = STATE(374),
    [sym__enum_itemdeclaration] = STATE(238),
    [sym_enum_item] = STATE(375),
    [sym_curly_group] = STATE(27),
    [sym_text] = STATE(27),
    [sym_operator] = STATE(484),
    [sym_subscript] = STATE(484),
    [sym_superscript] = STATE(484),
    [sym_displayed_equation] = STATE(27),
    [sym_inline_formula] = STATE(27),
    [sym_begin] = STATE(65),
    [sym_generic_environment] = STATE(27),
    [sym_comment_environment] = STATE(27),
    [sym__comment_environment_begin] = STATE(3120),
    [sym_verbatim_environment] = STATE(27),
    [sym__verbatim_environment_begin] = STATE(3121),
    [sym_listing_environment] = STATE(27),
    [sym__listing_environment_begin] = STATE(3122),
    [sym_minted_environment] = STATE(27),
    [sym__minted_environment_begin] = STATE(3123),
    [sym_pycode_environment] = STATE(27),
    [sym__pycode_environment_begin] = STATE(3124),
    [sym_math_environment] = STATE(27),
    [sym__math_environment_begin] = STATE(269),
    [sym__command] = STATE(27),
    [sym_generic_command] = STATE(27),
    [sym_title_declaration] = STATE(27),
    [sym_author_declaration] = STATE(27),
    [sym_package_include] = STATE(27),
    [sym_class_include] = STATE(27),
    [sym_latex_include] = STATE(27),
    [sym_biblatex_include] = STATE(27),
    [sym_bibtex_include] = STATE(27),
    [sym_graphics_include] = STATE(27),
    [sym_svg_include] = STATE(27),
    [sym_inkscape_include] = STATE(27),
    [sym_verbatim_include] = STATE(27),
    [sym_import_include] = STATE(27),
    [sym_caption] = STATE(27),
    [sym_citation] = STATE(27),
    [sym_label_definition] = STATE(27),
    [sym_label_reference] = STATE(27),
    [sym_label_reference_range] = STATE(27),
    [sym_label_number] = STATE(27),
    [sym_new_command_definition] = STATE(27),
    [sym_old_command_definition] = STATE(27),
    [sym_let_command_definition] = STATE(27),
    [sym_math_delimiter] = STATE(27),
    [sym_paired_delimiter_definition] = STATE(27),
    [sym_environment_definition] = STATE(27),
    [sym_glossary_entry_definition] = STATE(27),
    [sym_glossary_entry_reference] = STATE(27),
    [sym_acronym_definition] = STATE(27),
    [sym_acronym_reference] = STATE(27),
    [sym_theorem_definition] = STATE(27),
    [sym_color_definition] = STATE(27),
    [sym_color_set_definition] = STATE(27),
    [sym_color_reference] = STATE(27),
    [sym_tikz_library_import] = STATE(27),
    [sym_text_mode] = STATE(27),
    [aux_sym_source_file_repeat1] = STATE(27),
    [aux_sym__section_repeat1] = STATE(367),
    [aux_sym__section_repeat2] = STATE(368),
    [aux_sym__section_repeat3] = STATE(369),
    [aux_sym__section_repeat4] = STATE(370),
    [aux_sym__section_repeat5] = STATE(371),
    [aux_sym__section_repeat6] = STATE(373),
    [aux_sym__section_repeat7] = STATE(374),
    [aux_sym__section_repeat8] = STATE(375),
    [aux_sym_text_repeat1] = STATE(259),
    [sym_command_name] = ACTIONS(187),
    [sym__whitespace] = ACTIONS(3),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_BSLASHiffalse] = ACTIONS(187),
    [anon_sym_LBRACK] = ACTIONS(185),
    [anon_sym_RBRACK] = ACTIONS(185),
    [anon_sym_COMMA] = ACTIONS(185),
    [anon_sym_EQ] = ACTIONS(185),
    [anon_sym_LPAREN] = ACTIONS(185),
    [anon_sym_RPAREN] = ACTIONS(185),
    [anon_sym_BSLASHpart] = ACTIONS(187),
    [anon_sym_BSLASHpart_STAR] = ACTIONS(185),
    [anon_sym_BSLASHaddpart] = ACTIONS(187),
    [anon_sym_BSLASHaddpart_STAR] = ACTIONS(185),
    [anon_sym_BSLASHchapter] = ACTIONS(187),
    [anon_sym_BSLASHchapter_STAR] = ACTIONS(185),
    [anon_sym_BSLASHaddchap] = ACTIONS(187),
    [anon_sym_BSLASHaddchap_STAR] = ACTIONS(185),
    [anon_sym_BSLASHsection] = ACTIONS(187),
    [anon_sym_BSLASHsection_STAR] = ACTIONS(185),
    [anon_sym_BSLASHaddsec] = ACTIONS(187),
    [anon_sym_BSLASHaddsec_STAR] = ACTIONS(185),
    [anon_sym_BSLASHsubsection] = ACTIONS(187),
    [anon_sym_BSLASHsubsection_STAR] = ACTIONS(185),
    [anon_sym_BSLASHsubsubsection] = ACTIONS(187),
    [anon_sym_BSLASHsubsubsection_STAR] = ACTIONS(185),
    [anon_sym_BSLASHparagraph] = ACTIONS(187),
    [anon_sym_BSLASHparagraph_STAR] = ACTIONS(185),
    [anon_sym_BSLASHsubparagraph] = ACTIONS(187),
    [anon_sym_BSLASHsubparagraph_STAR] = ACTIONS(185),
    [anon_sym_BSLASHitem] = ACTIONS(187),
    [anon_sym_BSLASHitem_STAR] = ACTIONS(185),
    [anon_sym_LBRACE] = ACTIONS(185),
    [sym_word] = ACTIONS(187),
    [sym_placeholder] = ACTIONS(185),
    [anon_sym_PLUS] = ACTIONS(185),
    [anon_sym_DASH] = ACTIONS(185),
    [anon_sym_STAR] = ACTIONS(185),
    [anon_sym_SLASH] = ACTIONS(185),
    [anon_sym_LT] = ACTIONS(187),
    [anon_sym_GT] = ACTIONS(187),
    [anon_sym_BANG] = ACTIONS(187),
    [anon_sym_PIPE] = ACTIONS(187),
    [anon_sym_COLON] = ACTIONS(187),
    [anon_sym_SQUOTE] = ACTIONS(187),
    [anon_sym__] = ACTIONS(185),
    [anon_sym_CARET] = ACTIONS(185),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(185),
    [anon_sym_BSLASH_LBRACK] = ACTIONS(185),
    [anon_sym_DOLLAR] = ACTIONS(187),
    [anon_sym_BSLASH_LPAREN] = ACTIONS(185),
    [anon_sym_BSLASH_RPAREN] = ACTIONS(185),
    [anon_sym_BSLASHbegin] = ACTIONS(187),
    [anon_sym_BSLASHtitle] = ACTIONS(187),
    [anon_sym_BSLASHauthor] = ACTIONS(187),
    [anon_sym_BSLASHusepackage] = ACTIONS(187),
    [anon_sym_BSLASHRequirePackage] = ACTIONS(187),
    [anon_sym_BSLASHdocumentclass] = ACTIONS(187),
    [anon_sym_BSLASHinclude] = ACTIONS(187),
    [anon_sym_BSLASHsubfileinclude] = ACTIONS(187),
    [anon_sym_BSLASHinput] = ACTIONS(187),
    [anon_sym_BSLASHsubfile] = ACTIONS(187),
    [anon_sym_BSLASHaddbibresource] = ACTIONS(187),
    [anon_sym_BSLASHbibliography] = ACTIONS(187),
    [anon_sym_BSLASHincludegraphics] = ACTIONS(187),
    [anon_sym_BSLASHincludesvg] = ACTIONS(187),
    [anon_sym_BSLASHincludeinkscape] = ACTIONS(187),
    [anon_sym_BSLASHverbatiminput] = ACTIONS(187),
    [anon_sym_BSLASHVerbatimInput] = ACTIONS(187),
    [anon_sym_BSLASHimport] = ACTIONS(187),
    [anon_sym_BSLASHsubimport] = ACTIONS(187),
    [anon_sym_BSLASHinputfrom] = ACTIONS(187),
    [anon_sym_BSLASHsubimportfrom] = ACTIONS(187),
    [anon_sym_BSLASHincludefrom] = ACTIONS(187),
    [anon_sym_BSLASHsubincludefrom] = ACTIONS(187),
    [anon_sym_BSLASHcaption] = ACTIONS(187),
    [anon_sym_BSLASHcite] = ACTIONS(187),
    [anon_sym_BSLASHcite_STAR] = ACTIONS(185),
    [anon_sym_BSLASHCite] = ACTIONS(187),
    [anon_sym_BSLASHnocite] = ACTIONS(187),
    [anon_sym_BSLASHcitet] = ACTIONS(187),
    [anon_sym_BSLASHcitep] = ACTIONS(187),
    [anon_sym_BSLASHcitet_STAR] = ACTIONS(185),
    [anon_sym_BSLASHcitep_STAR] = ACTIONS(185),
    [anon_sym_BSLASHciteauthor] = ACTIONS(187),
    [anon_sym_BSLASHciteauthor_STAR] = ACTIONS(185),
    [anon_sym_BSLASHCiteauthor] = ACTIONS(187),
    [anon_sym_BSLASHCiteauthor_STAR] = ACTIONS(185),
    [anon_sym_BSLASHcitetitle] = ACTIONS(187),
    [anon_sym_BSLASHcitetitle_STAR] = ACTIONS(185),
    [anon_sym_BSLASHciteyear] = ACTIONS(187),
    [anon_sym_BSLASHciteyear_STAR] = ACTIONS(185),
    [anon_sym_BSLASHcitedate] = ACTIONS(187),
    [anon_sym_BSLASHcitedate_STAR] = ACTIONS(185),
    [anon_sym_BSLASHciteurl] = ACTIONS(187),
    [anon_sym_BSLASHfullcite] = ACTIONS(187),
    [anon_sym_BSLASHciteyearpar] = ACTIONS(187),
    [anon_sym_BSLASHcitealt] = ACTIONS(187),
    [anon_sym_BSLASHcitealp] = ACTIONS(187),
    [anon_sym_BSLASHcitetext] = ACTIONS(187),
    [anon_sym_BSLASHparencite] = ACTIONS(187),
    [anon_sym_BSLASHparencite_STAR] = ACTIONS(185),
    [anon_sym_BSLASHParencite] = ACTIONS(187),
    [anon_sym_BSLASHfootcite] = ACTIONS(187),
    [anon_sym_BSLASHfootfullcite] = ACTIONS(187),
    [anon_sym_BSLASHfootcitetext] = ACTIONS(187),
    [anon_sym_BSLASHtextcite] = ACTIONS(187),
    [anon_sym_BSLASHTextcite] = ACTIONS(187),
    [anon_sym_BSLASHsmartcite] = ACTIONS(187),
    [anon_sym_BSLASHSmartcite] = ACTIONS(187),
    [anon_sym_BSLASHsupercite] = ACTIONS(187),
    [anon_sym_BSLASHautocite] = ACTIONS(187),
    [anon_sym_BSLASHAutocite] = ACTIONS(187),
    [anon_sym_BSLASHautocite_STAR] = ACTIONS(185),
    [anon_sym_BSLASHAutocite_STAR] = ACTIONS(185),
    [anon_sym_BSLASHvolcite] = ACTIONS(187),
    [anon_sym_BSLASHVolcite] = ACTIONS(187),
    [anon_sym_BSLASHpvolcite] = ACTIONS(187),
    [anon_sym_BSLASHPvolcite] = ACTIONS(187),
    [anon_sym_BSLASHfvolcite] = ACTIONS(187),
    [anon_sym_BSLASHftvolcite] = ACTIONS(187),
    [anon_sym_BSLASHsvolcite] = ACTIONS(187),
    [anon_sym_BSLASHSvolcite] = ACTIONS(187),
    [anon_sym_BSLASHtvolcite] = ACTIONS(187),
    [anon_sym_BSLASHTvolcite] = ACTIONS(187),
    [anon_sym_BSLASHavolcite] = ACTIONS(187),
    [anon_sym_BSLASHAvolcite] = ACTIONS(187),
    [anon_sym_BSLASHnotecite] = ACTIONS(187),
    [anon_sym_BSLASHNotecite] = ACTIONS(187),
    [anon_sym_BSLASHpnotecite] = ACTIONS(187),
    [anon_sym_BSLASHPnotecite] = ACTIONS(187),
    [anon_sym_BSLASHfnotecite] = ACTIONS(187),
    [anon_sym_BSLASHlabel] = ACTIONS(187),
    [anon_sym_BSLASHref] = ACTIONS(187),
    [anon_sym_BSLASHeqref] = ACTIONS(187),
    [anon_sym_BSLASHvref] = ACTIONS(187),
    [anon_sym_BSLASHVref] = ACTIONS(187),
    [anon_sym_BSLASHautoref] = ACTIONS(187),
    [anon_sym_BSLASHpageref] = ACTIONS(187),
    [anon_sym_BSLASHcref] = ACTIONS(187),
    [anon_sym_BSLASHCref] = ACTIONS(187),
    [anon_sym_BSLASHcref_STAR] = ACTIONS(185),
    [anon_sym_BSLASHCref_STAR] = ACTIONS(185),
    [anon_sym_BSLASHnamecref] = ACTIONS(187),
    [anon_sym_BSLASHnameCref] = ACTIONS(187),
    [anon_sym_BSLASHlcnamecref] = ACTIONS(187),
    [anon_sym_BSLASHnamecrefs] = ACTIONS(187),
    [anon_sym_BSLASHnameCrefs] = ACTIONS(187),
    [anon_sym_BSLASHlcnamecrefs] = ACTIONS(187),
    [anon_sym_BSLASHlabelcref] = ACTIONS(187),
    [anon_sym_BSLASHlabelcpageref] = ACTIONS(187),
    [anon_sym_BSLASHcrefrange] = ACTIONS(187),
    [anon_sym_BSLASHcrefrange_STAR] = ACTIONS(185),
    [anon_sym_BSLASHCrefrange] = ACTIONS(187),
    [anon_sym_BSLASHCrefrange_STAR] = ACTIONS(185),
    [anon_sym_BSLASHnewlabel] = ACTIONS(187),
    [anon_sym_BSLASHnewcommand] = ACTIONS(187),
    [anon_sym_BSLASHnewcommand_STAR] = ACTIONS(185),
    [anon_sym_BSLASHrenewcommand] = ACTIONS(187),
    [anon_sym_BSLASHrenewcommand_STAR] = ACTIONS(185),
    [anon_sym_BSLASHDeclareRobustCommand] = ACTIONS(187),
    [anon_sym_BSLASHDeclareRobustCommand_STAR] = ACTIONS(185),
    [anon_sym_BSLASHDeclareMathOperator] = ACTIONS(187),
    [anon_sym_BSLASHDeclareMathOperator_STAR] = ACTIONS(185),
    [anon_sym_BSLASHNewDocumentCommand] = ACTIONS(187),
    [anon_sym_BSLASHRenewDocumentCommand] = ACTIONS(187),
    [anon_sym_BSLASHProvideDocumentCommand] = ACTIONS(187),
    [anon_sym_BSLASHDeclareDocumentCommand] = ACTIONS(187),
    [anon_sym_BSLASHNewExpandableDocumentCommand] = ACTIONS(187),
    [anon_sym_BSLASHRenewExpandableDocumentCommand] = ACTIONS(187),
    [anon_sym_BSLASHProvideExpandableDocumentCommand] = ACTIONS(187),
    [anon_sym_BSLASHDeclareExpandableDocumentCommand] = ACTIONS(187),
    [anon_sym_BSLASHdef] = ACTIONS(187),
    [anon_sym_BSLASHlet] = ACTIONS(187),
    [anon_sym_BSLASHleft] = ACTIONS(187),
    [anon_sym_BSLASHbig] = ACTIONS(187),
    [anon_sym_BSLASHBig] = ACTIONS(187),
    [anon_sym_BSLASHbigg] = ACTIONS(187),
    [anon_sym_BSLASHBigg] = ACTIONS(187),
    [anon_sym_BSLASHbigl] = ACTIONS(187),
    [anon_sym_BSLASHBigl] = ACTIONS(187),
    [anon_sym_BSLASHbiggl] = ACTIONS(187),
    [anon_sym_BSLASHBiggl] = ACTIONS(187),
    [anon_sym_BSLASHright] = ACTIONS(183),
    [anon_sym_BSLASHbigr] = ACTIONS(183),
    [anon_sym_BSLASHBigr] = ACTIONS(183),
    [anon_sym_BSLASHbiggr] = ACTIONS(183),
    [anon_sym_BSLASHBiggr] = ACTIONS(183),
    [anon_sym_BSLASHDeclarePairedDelimiter] = ACTIONS(187),
    [anon_sym_BSLASHDeclarePairedDelimiterX] = ACTIONS(187),
    [anon_sym_BSLASHnewenvironment] = ACTIONS(187),
    [anon_sym_BSLASHrenewenvironment] = ACTIONS(187),
    [anon_sym_BSLASHNewDocumentEnvironment] = ACTIONS(187),
    [anon_sym_BSLASHRenewDocumentEnvironment] = ACTIONS(187),
    [anon_sym_BSLASHProvideDocumentEnvironment] = ACTIONS(187),
    [anon_sym_BSLASHDeclareDocumentEnvironment] = ACTIONS(187),
    [anon_sym_BSLASHnewglossaryentry] = ACTIONS(187),
    [anon_sym_BSLASHgls] = ACTIONS(187),
    [anon_sym_BSLASHGls] = ACTIONS(187),
    [anon_sym_BSLASHGLS] = ACTIONS(187),
    [anon_sym_BSLASHglspl] = ACTIONS(187),
    [anon_sym_BSLASHGlspl] = ACTIONS(187),
    [anon_sym_BSLASHGLSpl] = ACTIONS(187),
    [anon_sym_BSLASHglsdisp] = ACTIONS(187),
    [anon_sym_BSLASHglslink] = ACTIONS(187),
    [anon_sym_BSLASHglstext] = ACTIONS(187),
    [anon_sym_BSLASHGlstext] = ACTIONS(187),
    [anon_sym_BSLASHGLStext] = ACTIONS(187),
    [anon_sym_BSLASHglsfirst] = ACTIONS(187),
    [anon_sym_BSLASHGlsfirst] = ACTIONS(187),
    [anon_sym_BSLASHGLSfirst] = ACTIONS(187),
    [anon_sym_BSLASHglsplural] = ACTIONS(187),
    [anon_sym_BSLASHGlsplural] = ACTIONS(187),
    [anon_sym_BSLASHGLSplural] = ACTIONS(187),
    [anon_sym_BSLASHglsfirstplural] = ACTIONS(187),
    [anon_sym_BSLASHGlsfirstplural] = ACTIONS(187),
    [anon_sym_BSLASHGLSfirstplural] = ACTIONS(187),
    [anon_sym_BSLASHglsname] = ACTIONS(187),
    [anon_sym_BSLASHGlsname] = ACTIONS(187),
    [anon_sym_BSLASHGLSname] = ACTIONS(187),
    [anon_sym_BSLASHglssymbol] = ACTIONS(187),
    [anon_sym_BSLASHGlssymbol] = ACTIONS(187),
    [anon_sym_BSLASHglsdesc] = ACTIONS(187),
    [anon_sym_BSLASHGlsdesc] = ACTIONS(187),
    [anon_sym_BSLASHGLSdesc] = ACTIONS(187),
    [anon_sym_BSLASHglsuseri] = ACTIONS(187),
    [anon_sym_BSLASHGlsuseri] = ACTIONS(187),
    [anon_sym_BSLASHGLSuseri] = ACTIONS(187),
    [anon_sym_BSLASHglsuserii] = ACTIONS(187),
    [anon_sym_BSLASHGlsuserii] = ACTIONS(187),
    [anon_sym_BSLASHGLSuserii] = ACTIONS(187),
    [anon_sym_BSLASHglsuseriii] = ACTIONS(187),
    [anon_sym_BSLASHGlsuseriii] = ACTIONS(187),
    [anon_sym_BSLASHGLSuseriii] = ACTIONS(187),
    [anon_sym_BSLASHglsuseriv] = ACTIONS(187),
    [anon_sym_BSLASHGlsuseriv] = ACTIONS(187),
    [anon_sym_BSLASHGLSuseriv] = ACTIONS(187),
    [anon_sym_BSLASHglsuserv] = ACTIONS(187),
    [anon_sym_BSLASHGlsuserv] = ACTIONS(187),
    [anon_sym_BSLASHGLSuserv] = ACTIONS(187),
    [anon_sym_BSLASHglsuservi] = ACTIONS(187),
    [anon_sym_BSLASHGlsuservi] = ACTIONS(187),
    [anon_sym_BSLASHGLSuservi] = ACTIONS(187),
    [anon_sym_BSLASHnewacronym] = ACTIONS(187),
    [anon_sym_BSLASHacrshort] = ACTIONS(187),
    [anon_sym_BSLASHAcrshort] = ACTIONS(187),
    [anon_sym_BSLASHACRshort] = ACTIONS(187),
    [anon_sym_BSLASHacrshortpl] = ACTIONS(187),
    [anon_sym_BSLASHAcrshortpl] = ACTIONS(187),
    [anon_sym_BSLASHACRshortpl] = ACTIONS(187),
    [anon_sym_BSLASHacrlong] = ACTIONS(187),
    [anon_sym_BSLASHAcrlong] = ACTIONS(187),
    [anon_sym_BSLASHACRlong] = ACTIONS(187),
    [anon_sym_BSLASHacrlongpl] = ACTIONS(187),
    [anon_sym_BSLASHAcrlongpl] = ACTIONS(187),
    [anon_sym_BSLASHACRlongpl] = ACTIONS(187),
    [anon_sym_BSLASHacrfull] = ACTIONS(187),
    [anon_sym_BSLASHAcrfull] = ACTIONS(187),
    [anon_sym_BSLASHACRfull] = ACTIONS(187),
    [anon_sym_BSLASHacrfullpl] = ACTIONS(187),
    [anon_sym_BSLASHAcrfullpl] = ACTIONS(187),
    [anon_sym_BSLASHACRfullpl] = ACTIONS(187),
    [anon_sym_BSLASHacs] = ACTIONS(187),
    [anon_sym_BSLASHAcs] = ACTIONS(187),
    [anon_sym_BSLASHacsp] = ACTIONS(187),
    [anon_sym_BSLASHAcsp] = ACTIONS(187),
    [anon_sym_BSLASHacl] = ACTIONS(187),
    [anon_sym_BSLASHAcl] = ACTIONS(187),
    [anon_sym_BSLASHaclp] = ACTIONS(187),
    [anon_sym_BSLASHAclp] = ACTIONS(187),
    [anon_sym_BSLASHacf] = ACTIONS(187),
    [anon_sym_BSLASHAcf] = ACTIONS(187),
    [anon_sym_BSLASHacfp] = ACTIONS(187),
    [anon_sym_BSLASHAcfp] = ACTIONS(187),
    [anon_sym_BSLASHac] = ACTIONS(187),
    [anon_sym_BSLASHAc] = ACTIONS(187),
    [anon_sym_BSLASHacp] = ACTIONS(187),
    [anon_sym_BSLASHglsentrylong] = ACTIONS(187),
    [anon_sym_BSLASHGlsentrylong] = ACTIONS(187),
    [anon_sym_BSLASHglsentrylongpl] = ACTIONS(187),
    [anon_sym_BSLASHGlsentrylongpl] = ACTIONS(187),
    [anon_sym_BSLASHglsentryshort] = ACTIONS(187),
    [anon_sym_BSLASHGlsentryshort] = ACTIONS(187),
    [anon_sym_BSLASHglsentryshortpl] = ACTIONS(187),
    [anon_sym_BSLASHGlsentryshortpl] = ACTIONS(187),
    [anon_sym_BSLASHglsentryfullpl] = ACTIONS(187),
    [anon_sym_BSLASHGlsentryfullpl] = ACTIONS(187),
    [anon_sym_BSLASHnewtheorem] = ACTIONS(187),
    [anon_sym_BSLASHnewtheorem_STAR] = ACTIONS(185),
    [anon_sym_BSLASHdeclaretheorem] = ACTIONS(187),
    [anon_sym_BSLASHdeclaretheorem_STAR] = ACTIONS(185),
    [anon_sym_BSLASHdefinecolor] = ACTIONS(187),
    [anon_sym_BSLASHdefinecolorset] = ACTIONS(187),
    [anon_sym_BSLASHcolor] = ACTIONS(187),
    [anon_sym_BSLASHcolorbox] = ACTIONS(187),
    [anon_sym_BSLASHtextcolor] = ACTIONS(187),
    [anon_sym_BSLASHpagecolor] = ACTIONS(187),
    [anon_sym_BSLASHusepgflibrary] = ACTIONS(187),
    [anon_sym_BSLASHusetikzlibrary] = ACTIONS(187),
    [anon_sym_BSLASHtext] = ACTIONS(187),
    [anon_sym_BSLASHintertext] = ACTIONS(187),
    [anon_sym_shortintertext] = ACTIONS(187),
  },
  [12] = {
    [sym_block_comment] = STATE(27),
    [sym__root_content] = STATE(27),
    [sym__flat_content] = STATE(27),
    [sym__text_with_env_content] = STATE(27),
    [sym__text_content] = STATE(27),
    [sym__section] = STATE(27),
    [sym__part_declaration] = STATE(175),
    [sym_part] = STATE(367),
    [sym__chapter_declaration] = STATE(177),
    [sym_chapter] = STATE(368),
    [sym__section_declaration] = STATE(187),
    [sym_section] = STATE(369),
    [sym__subsection_declaration] = STATE(196),
    [sym_subsection] = STATE(370),
    [sym__subsubsection_declaration] = STATE(207),
    [sym_subsubsection] = STATE(371),
    [sym__paragraph_declaration] = STATE(218),
    [sym_paragraph] = STATE(373),
    [sym__subparagraph_declaration] = STATE(228),
    [sym_subparagraph] = STATE(374),
    [sym__enum_itemdeclaration] = STATE(238),
    [sym_enum_item] = STATE(375),
    [sym_curly_group] = STATE(27),
    [sym_text] = STATE(27),
    [sym_operator] = STATE(484),
    [sym_subscript] = STATE(484),
    [sym_superscript] = STATE(484),
    [sym_displayed_equation] = STATE(27),
    [sym_inline_formula] = STATE(27),
    [sym_begin] = STATE(65),
    [sym_generic_environment] = STATE(27),
    [sym_comment_environment] = STATE(27),
    [sym__comment_environment_begin] = STATE(3120),
    [sym_verbatim_environment] = STATE(27),
    [sym__verbatim_environment_begin] = STATE(3121),
    [sym_listing_environment] = STATE(27),
    [sym__listing_environment_begin] = STATE(3122),
    [sym_minted_environment] = STATE(27),
    [sym__minted_environment_begin] = STATE(3123),
    [sym_pycode_environment] = STATE(27),
    [sym__pycode_environment_begin] = STATE(3124),
    [sym_math_environment] = STATE(27),
    [sym__math_environment_begin] = STATE(269),
    [sym__command] = STATE(27),
    [sym_generic_command] = STATE(27),
    [sym_title_declaration] = STATE(27),
    [sym_author_declaration] = STATE(27),
    [sym_package_include] = STATE(27),
    [sym_class_include] = STATE(27),
    [sym_latex_include] = STATE(27),
    [sym_biblatex_include] = STATE(27),
    [sym_bibtex_include] = STATE(27),
    [sym_graphics_include] = STATE(27),
    [sym_svg_include] = STATE(27),
    [sym_inkscape_include] = STATE(27),
    [sym_verbatim_include] = STATE(27),
    [sym_import_include] = STATE(27),
    [sym_caption] = STATE(27),
    [sym_citation] = STATE(27),
    [sym_label_definition] = STATE(27),
    [sym_label_reference] = STATE(27),
    [sym_label_reference_range] = STATE(27),
    [sym_label_number] = STATE(27),
    [sym_new_command_definition] = STATE(27),
    [sym_old_command_definition] = STATE(27),
    [sym_let_command_definition] = STATE(27),
    [sym_math_delimiter] = STATE(27),
    [sym_paired_delimiter_definition] = STATE(27),
    [sym_environment_definition] = STATE(27),
    [sym_glossary_entry_definition] = STATE(27),
    [sym_glossary_entry_reference] = STATE(27),
    [sym_acronym_definition] = STATE(27),
    [sym_acronym_reference] = STATE(27),
    [sym_theorem_definition] = STATE(27),
    [sym_color_definition] = STATE(27),
    [sym_color_set_definition] = STATE(27),
    [sym_color_reference] = STATE(27),
    [sym_tikz_library_import] = STATE(27),
    [sym_text_mode] = STATE(27),
    [aux_sym_source_file_repeat1] = STATE(27),
    [aux_sym__section_repeat1] = STATE(367),
    [aux_sym__section_repeat2] = STATE(368),
    [aux_sym__section_repeat3] = STATE(369),
    [aux_sym__section_repeat4] = STATE(370),
    [aux_sym__section_repeat5] = STATE(371),
    [aux_sym__section_repeat6] = STATE(373),
    [aux_sym__section_repeat7] = STATE(374),
    [aux_sym__section_repeat8] = STATE(375),
    [aux_sym_text_repeat1] = STATE(259),
    [sym_command_name] = ACTIONS(187),
    [sym__whitespace] = ACTIONS(3),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_BSLASHiffalse] = ACTIONS(187),
    [anon_sym_LBRACK] = ACTIONS(185),
    [anon_sym_RBRACK] = ACTIONS(185),
    [anon_sym_COMMA] = ACTIONS(185),
    [anon_sym_EQ] = ACTIONS(185),
    [anon_sym_LPAREN] = ACTIONS(185),
    [anon_sym_RPAREN] = ACTIONS(185),
    [anon_sym_BSLASHpart] = ACTIONS(151),
    [anon_sym_BSLASHpart_STAR] = ACTIONS(153),
    [anon_sym_BSLASHaddpart] = ACTIONS(151),
    [anon_sym_BSLASHaddpart_STAR] = ACTIONS(153),
    [anon_sym_BSLASHchapter] = ACTIONS(155),
    [anon_sym_BSLASHchapter_STAR] = ACTIONS(157),
    [anon_sym_BSLASHaddchap] = ACTIONS(155),
    [anon_sym_BSLASHaddchap_STAR] = ACTIONS(157),
    [anon_sym_BSLASHsection] = ACTIONS(159),
    [anon_sym_BSLASHsection_STAR] = ACTIONS(161),
    [anon_sym_BSLASHaddsec] = ACTIONS(159),
    [anon_sym_BSLASHaddsec_STAR] = ACTIONS(161),
    [anon_sym_BSLASHsubsection] = ACTIONS(163),
    [anon_sym_BSLASHsubsection_STAR] = ACTIONS(165),
    [anon_sym_BSLASHsubsubsection] = ACTIONS(167),
    [anon_sym_BSLASHsubsubsection_STAR] = ACTIONS(169),
    [anon_sym_BSLASHparagraph] = ACTIONS(171),
    [anon_sym_BSLASHparagraph_STAR] = ACTIONS(173),
    [anon_sym_BSLASHsubparagraph] = ACTIONS(175),
    [anon_sym_BSLASHsubparagraph_STAR] = ACTIONS(177),
    [anon_sym_BSLASHitem] = ACTIONS(179),
    [anon_sym_BSLASHitem_STAR] = ACTIONS(181),
    [anon_sym_LBRACE] = ACTIONS(185),
    [sym_word] = ACTIONS(187),
    [sym_placeholder] = ACTIONS(185),
    [anon_sym_PLUS] = ACTIONS(185),
    [anon_sym_DASH] = ACTIONS(185),
    [anon_sym_STAR] = ACTIONS(185),
    [anon_sym_SLASH] = ACTIONS(185),
    [anon_sym_LT] = ACTIONS(187),
    [anon_sym_GT] = ACTIONS(187),
    [anon_sym_BANG] = ACTIONS(187),
    [anon_sym_PIPE] = ACTIONS(187),
    [anon_sym_COLON] = ACTIONS(187),
    [anon_sym_SQUOTE] = ACTIONS(187),
    [anon_sym__] = ACTIONS(185),
    [anon_sym_CARET] = ACTIONS(185),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(185),
    [anon_sym_BSLASH_LBRACK] = ACTIONS(185),
    [anon_sym_DOLLAR] = ACTIONS(187),
    [anon_sym_BSLASH_LPAREN] = ACTIONS(185),
    [anon_sym_BSLASHbegin] = ACTIONS(187),
    [anon_sym_BSLASHend] = ACTIONS(187),
    [anon_sym_BSLASHtitle] = ACTIONS(187),
    [anon_sym_BSLASHauthor] = ACTIONS(187),
    [anon_sym_BSLASHusepackage] = ACTIONS(187),
    [anon_sym_BSLASHRequirePackage] = ACTIONS(187),
    [anon_sym_BSLASHdocumentclass] = ACTIONS(187),
    [anon_sym_BSLASHinclude] = ACTIONS(187),
    [anon_sym_BSLASHsubfileinclude] = ACTIONS(187),
    [anon_sym_BSLASHinput] = ACTIONS(187),
    [anon_sym_BSLASHsubfile] = ACTIONS(187),
    [anon_sym_BSLASHaddbibresource] = ACTIONS(187),
    [anon_sym_BSLASHbibliography] = ACTIONS(187),
    [anon_sym_BSLASHincludegraphics] = ACTIONS(187),
    [anon_sym_BSLASHincludesvg] = ACTIONS(187),
    [anon_sym_BSLASHincludeinkscape] = ACTIONS(187),
    [anon_sym_BSLASHverbatiminput] = ACTIONS(187),
    [anon_sym_BSLASHVerbatimInput] = ACTIONS(187),
    [anon_sym_BSLASHimport] = ACTIONS(187),
    [anon_sym_BSLASHsubimport] = ACTIONS(187),
    [anon_sym_BSLASHinputfrom] = ACTIONS(187),
    [anon_sym_BSLASHsubimportfrom] = ACTIONS(187),
    [anon_sym_BSLASHincludefrom] = ACTIONS(187),
    [anon_sym_BSLASHsubincludefrom] = ACTIONS(187),
    [anon_sym_BSLASHcaption] = ACTIONS(187),
    [anon_sym_BSLASHcite] = ACTIONS(187),
    [anon_sym_BSLASHcite_STAR] = ACTIONS(185),
    [anon_sym_BSLASHCite] = ACTIONS(187),
    [anon_sym_BSLASHnocite] = ACTIONS(187),
    [anon_sym_BSLASHcitet] = ACTIONS(187),
    [anon_sym_BSLASHcitep] = ACTIONS(187),
    [anon_sym_BSLASHcitet_STAR] = ACTIONS(185),
    [anon_sym_BSLASHcitep_STAR] = ACTIONS(185),
    [anon_sym_BSLASHciteauthor] = ACTIONS(187),
    [anon_sym_BSLASHciteauthor_STAR] = ACTIONS(185),
    [anon_sym_BSLASHCiteauthor] = ACTIONS(187),
    [anon_sym_BSLASHCiteauthor_STAR] = ACTIONS(185),
    [anon_sym_BSLASHcitetitle] = ACTIONS(187),
    [anon_sym_BSLASHcitetitle_STAR] = ACTIONS(185),
    [anon_sym_BSLASHciteyear] = ACTIONS(187),
    [anon_sym_BSLASHciteyear_STAR] = ACTIONS(185),
    [anon_sym_BSLASHcitedate] = ACTIONS(187),
    [anon_sym_BSLASHcitedate_STAR] = ACTIONS(185),
    [anon_sym_BSLASHciteurl] = ACTIONS(187),
    [anon_sym_BSLASHfullcite] = ACTIONS(187),
    [anon_sym_BSLASHciteyearpar] = ACTIONS(187),
    [anon_sym_BSLASHcitealt] = ACTIONS(187),
    [anon_sym_BSLASHcitealp] = ACTIONS(187),
    [anon_sym_BSLASHcitetext] = ACTIONS(187),
    [anon_sym_BSLASHparencite] = ACTIONS(187),
    [anon_sym_BSLASHparencite_STAR] = ACTIONS(185),
    [anon_sym_BSLASHParencite] = ACTIONS(187),
    [anon_sym_BSLASHfootcite] = ACTIONS(187),
    [anon_sym_BSLASHfootfullcite] = ACTIONS(187),
    [anon_sym_BSLASHfootcitetext] = ACTIONS(187),
    [anon_sym_BSLASHtextcite] = ACTIONS(187),
    [anon_sym_BSLASHTextcite] = ACTIONS(187),
    [anon_sym_BSLASHsmartcite] = ACTIONS(187),
    [anon_sym_BSLASHSmartcite] = ACTIONS(187),
    [anon_sym_BSLASHsupercite] = ACTIONS(187),
    [anon_sym_BSLASHautocite] = ACTIONS(187),
    [anon_sym_BSLASHAutocite] = ACTIONS(187),
    [anon_sym_BSLASHautocite_STAR] = ACTIONS(185),
    [anon_sym_BSLASHAutocite_STAR] = ACTIONS(185),
    [anon_sym_BSLASHvolcite] = ACTIONS(187),
    [anon_sym_BSLASHVolcite] = ACTIONS(187),
    [anon_sym_BSLASHpvolcite] = ACTIONS(187),
    [anon_sym_BSLASHPvolcite] = ACTIONS(187),
    [anon_sym_BSLASHfvolcite] = ACTIONS(187),
    [anon_sym_BSLASHftvolcite] = ACTIONS(187),
    [anon_sym_BSLASHsvolcite] = ACTIONS(187),
    [anon_sym_BSLASHSvolcite] = ACTIONS(187),
    [anon_sym_BSLASHtvolcite] = ACTIONS(187),
    [anon_sym_BSLASHTvolcite] = ACTIONS(187),
    [anon_sym_BSLASHavolcite] = ACTIONS(187),
    [anon_sym_BSLASHAvolcite] = ACTIONS(187),
    [anon_sym_BSLASHnotecite] = ACTIONS(187),
    [anon_sym_BSLASHNotecite] = ACTIONS(187),
    [anon_sym_BSLASHpnotecite] = ACTIONS(187),
    [anon_sym_BSLASHPnotecite] = ACTIONS(187),
    [anon_sym_BSLASHfnotecite] = ACTIONS(187),
    [anon_sym_BSLASHlabel] = ACTIONS(187),
    [anon_sym_BSLASHref] = ACTIONS(187),
    [anon_sym_BSLASHeqref] = ACTIONS(187),
    [anon_sym_BSLASHvref] = ACTIONS(187),
    [anon_sym_BSLASHVref] = ACTIONS(187),
    [anon_sym_BSLASHautoref] = ACTIONS(187),
    [anon_sym_BSLASHpageref] = ACTIONS(187),
    [anon_sym_BSLASHcref] = ACTIONS(187),
    [anon_sym_BSLASHCref] = ACTIONS(187),
    [anon_sym_BSLASHcref_STAR] = ACTIONS(185),
    [anon_sym_BSLASHCref_STAR] = ACTIONS(185),
    [anon_sym_BSLASHnamecref] = ACTIONS(187),
    [anon_sym_BSLASHnameCref] = ACTIONS(187),
    [anon_sym_BSLASHlcnamecref] = ACTIONS(187),
    [anon_sym_BSLASHnamecrefs] = ACTIONS(187),
    [anon_sym_BSLASHnameCrefs] = ACTIONS(187),
    [anon_sym_BSLASHlcnamecrefs] = ACTIONS(187),
    [anon_sym_BSLASHlabelcref] = ACTIONS(187),
    [anon_sym_BSLASHlabelcpageref] = ACTIONS(187),
    [anon_sym_BSLASHcrefrange] = ACTIONS(187),
    [anon_sym_BSLASHcrefrange_STAR] = ACTIONS(185),
    [anon_sym_BSLASHCrefrange] = ACTIONS(187),
    [anon_sym_BSLASHCrefrange_STAR] = ACTIONS(185),
    [anon_sym_BSLASHnewlabel] = ACTIONS(187),
    [anon_sym_BSLASHnewcommand] = ACTIONS(187),
    [anon_sym_BSLASHnewcommand_STAR] = ACTIONS(185),
    [anon_sym_BSLASHrenewcommand] = ACTIONS(187),
    [anon_sym_BSLASHrenewcommand_STAR] = ACTIONS(185),
    [anon_sym_BSLASHDeclareRobustCommand] = ACTIONS(187),
    [anon_sym_BSLASHDeclareRobustCommand_STAR] = ACTIONS(185),
    [anon_sym_BSLASHDeclareMathOperator] = ACTIONS(187),
    [anon_sym_BSLASHDeclareMathOperator_STAR] = ACTIONS(185),
    [anon_sym_BSLASHNewDocumentCommand] = ACTIONS(187),
    [anon_sym_BSLASHRenewDocumentCommand] = ACTIONS(187),
    [anon_sym_BSLASHProvideDocumentCommand] = ACTIONS(187),
    [anon_sym_BSLASHDeclareDocumentCommand] = ACTIONS(187),
    [anon_sym_BSLASHNewExpandableDocumentCommand] = ACTIONS(187),
    [anon_sym_BSLASHRenewExpandableDocumentCommand] = ACTIONS(187),
    [anon_sym_BSLASHProvideExpandableDocumentCommand] = ACTIONS(187),
    [anon_sym_BSLASHDeclareExpandableDocumentCommand] = ACTIONS(187),
    [anon_sym_BSLASHdef] = ACTIONS(187),
    [anon_sym_BSLASHlet] = ACTIONS(187),
    [anon_sym_BSLASHleft] = ACTIONS(187),
    [anon_sym_BSLASHbig] = ACTIONS(187),
    [anon_sym_BSLASHBig] = ACTIONS(187),
    [anon_sym_BSLASHbigg] = ACTIONS(187),
    [anon_sym_BSLASHBigg] = ACTIONS(187),
    [anon_sym_BSLASHbigl] = ACTIONS(187),
    [anon_sym_BSLASHBigl] = ACTIONS(187),
    [anon_sym_BSLASHbiggl] = ACTIONS(187),
    [anon_sym_BSLASHBiggl] = ACTIONS(187),
    [anon_sym_BSLASHright] = ACTIONS(183),
    [anon_sym_BSLASHbigr] = ACTIONS(183),
    [anon_sym_BSLASHBigr] = ACTIONS(183),
    [anon_sym_BSLASHbiggr] = ACTIONS(183),
    [anon_sym_BSLASHBiggr] = ACTIONS(183),
    [anon_sym_BSLASHDeclarePairedDelimiter] = ACTIONS(187),
    [anon_sym_BSLASHDeclarePairedDelimiterX] = ACTIONS(187),
    [anon_sym_BSLASHnewenvironment] = ACTIONS(187),
    [anon_sym_BSLASHrenewenvironment] = ACTIONS(187),
    [anon_sym_BSLASHNewDocumentEnvironment] = ACTIONS(187),
    [anon_sym_BSLASHRenewDocumentEnvironment] = ACTIONS(187),
    [anon_sym_BSLASHProvideDocumentEnvironment] = ACTIONS(187),
    [anon_sym_BSLASHDeclareDocumentEnvironment] = ACTIONS(187),
    [anon_sym_BSLASHnewglossaryentry] = ACTIONS(187),
    [anon_sym_BSLASHgls] = ACTIONS(187),
    [anon_sym_BSLASHGls] = ACTIONS(187),
    [anon_sym_BSLASHGLS] = ACTIONS(187),
    [anon_sym_BSLASHglspl] = ACTIONS(187),
    [anon_sym_BSLASHGlspl] = ACTIONS(187),
    [anon_sym_BSLASHGLSpl] = ACTIONS(187),
    [anon_sym_BSLASHglsdisp] = ACTIONS(187),
    [anon_sym_BSLASHglslink] = ACTIONS(187),
    [anon_sym_BSLASHglstext] = ACTIONS(187),
    [anon_sym_BSLASHGlstext] = ACTIONS(187),
    [anon_sym_BSLASHGLStext] = ACTIONS(187),
    [anon_sym_BSLASHglsfirst] = ACTIONS(187),
    [anon_sym_BSLASHGlsfirst] = ACTIONS(187),
    [anon_sym_BSLASHGLSfirst] = ACTIONS(187),
    [anon_sym_BSLASHglsplural] = ACTIONS(187),
    [anon_sym_BSLASHGlsplural] = ACTIONS(187),
    [anon_sym_BSLASHGLSplural] = ACTIONS(187),
    [anon_sym_BSLASHglsfirstplural] = ACTIONS(187),
    [anon_sym_BSLASHGlsfirstplural] = ACTIONS(187),
    [anon_sym_BSLASHGLSfirstplural] = ACTIONS(187),
    [anon_sym_BSLASHglsname] = ACTIONS(187),
    [anon_sym_BSLASHGlsname] = ACTIONS(187),
    [anon_sym_BSLASHGLSname] = ACTIONS(187),
    [anon_sym_BSLASHglssymbol] = ACTIONS(187),
    [anon_sym_BSLASHGlssymbol] = ACTIONS(187),
    [anon_sym_BSLASHglsdesc] = ACTIONS(187),
    [anon_sym_BSLASHGlsdesc] = ACTIONS(187),
    [anon_sym_BSLASHGLSdesc] = ACTIONS(187),
    [anon_sym_BSLASHglsuseri] = ACTIONS(187),
    [anon_sym_BSLASHGlsuseri] = ACTIONS(187),
    [anon_sym_BSLASHGLSuseri] = ACTIONS(187),
    [anon_sym_BSLASHglsuserii] = ACTIONS(187),
    [anon_sym_BSLASHGlsuserii] = ACTIONS(187),
    [anon_sym_BSLASHGLSuserii] = ACTIONS(187),
    [anon_sym_BSLASHglsuseriii] = ACTIONS(187),
    [anon_sym_BSLASHGlsuseriii] = ACTIONS(187),
    [anon_sym_BSLASHGLSuseriii] = ACTIONS(187),
    [anon_sym_BSLASHglsuseriv] = ACTIONS(187),
    [anon_sym_BSLASHGlsuseriv] = ACTIONS(187),
    [anon_sym_BSLASHGLSuseriv] = ACTIONS(187),
    [anon_sym_BSLASHglsuserv] = ACTIONS(187),
    [anon_sym_BSLASHGlsuserv] = ACTIONS(187),
    [anon_sym_BSLASHGLSuserv] = ACTIONS(187),
    [anon_sym_BSLASHglsuservi] = ACTIONS(187),
    [anon_sym_BSLASHGlsuservi] = ACTIONS(187),
    [anon_sym_BSLASHGLSuservi] = ACTIONS(187),
    [anon_sym_BSLASHnewacronym] = ACTIONS(187),
    [anon_sym_BSLASHacrshort] = ACTIONS(187),
    [anon_sym_BSLASHAcrshort] = ACTIONS(187),
    [anon_sym_BSLASHACRshort] = ACTIONS(187),
    [anon_sym_BSLASHacrshortpl] = ACTIONS(187),
    [anon_sym_BSLASHAcrshortpl] = ACTIONS(187),
    [anon_sym_BSLASHACRshortpl] = ACTIONS(187),
    [anon_sym_BSLASHacrlong] = ACTIONS(187),
    [anon_sym_BSLASHAcrlong] = ACTIONS(187),
    [anon_sym_BSLASHACRlong] = ACTIONS(187),
    [anon_sym_BSLASHacrlongpl] = ACTIONS(187),
    [anon_sym_BSLASHAcrlongpl] = ACTIONS(187),
    [anon_sym_BSLASHACRlongpl] = ACTIONS(187),
    [anon_sym_BSLASHacrfull] = ACTIONS(187),
    [anon_sym_BSLASHAcrfull] = ACTIONS(187),
    [anon_sym_BSLASHACRfull] = ACTIONS(187),
    [anon_sym_BSLASHacrfullpl] = ACTIONS(187),
    [anon_sym_BSLASHAcrfullpl] = ACTIONS(187),
    [anon_sym_BSLASHACRfullpl] = ACTIONS(187),
    [anon_sym_BSLASHacs] = ACTIONS(187),
    [anon_sym_BSLASHAcs] = ACTIONS(187),
    [anon_sym_BSLASHacsp] = ACTIONS(187),
    [anon_sym_BSLASHAcsp] = ACTIONS(187),
    [anon_sym_BSLASHacl] = ACTIONS(187),
    [anon_sym_BSLASHAcl] = ACTIONS(187),
    [anon_sym_BSLASHaclp] = ACTIONS(187),
    [anon_sym_BSLASHAclp] = ACTIONS(187),
    [anon_sym_BSLASHacf] = ACTIONS(187),
    [anon_sym_BSLASHAcf] = ACTIONS(187),
    [anon_sym_BSLASHacfp] = ACTIONS(187),
    [anon_sym_BSLASHAcfp] = ACTIONS(187),
    [anon_sym_BSLASHac] = ACTIONS(187),
    [anon_sym_BSLASHAc] = ACTIONS(187),
    [anon_sym_BSLASHacp] = ACTIONS(187),
    [anon_sym_BSLASHglsentrylong] = ACTIONS(187),
    [anon_sym_BSLASHGlsentrylong] = ACTIONS(187),
    [anon_sym_BSLASHglsentrylongpl] = ACTIONS(187),
    [anon_sym_BSLASHGlsentrylongpl] = ACTIONS(187),
    [anon_sym_BSLASHglsentryshort] = ACTIONS(187),
    [anon_sym_BSLASHGlsentryshort] = ACTIONS(187),
    [anon_sym_BSLASHglsentryshortpl] = ACTIONS(187),
    [anon_sym_BSLASHGlsentryshortpl] = ACTIONS(187),
    [anon_sym_BSLASHglsentryfullpl] = ACTIONS(187),
    [anon_sym_BSLASHGlsentryfullpl] = ACTIONS(187),
    [anon_sym_BSLASHnewtheorem] = ACTIONS(187),
    [anon_sym_BSLASHnewtheorem_STAR] = ACTIONS(185),
    [anon_sym_BSLASHdeclaretheorem] = ACTIONS(187),
    [anon_sym_BSLASHdeclaretheorem_STAR] = ACTIONS(185),
    [anon_sym_BSLASHdefinecolor] = ACTIONS(187),
    [anon_sym_BSLASHdefinecolorset] = ACTIONS(187),
    [anon_sym_BSLASHcolor] = ACTIONS(187),
    [anon_sym_BSLASHcolorbox] = ACTIONS(187),
    [anon_sym_BSLASHtextcolor] = ACTIONS(187),
    [anon_sym_BSLASHpagecolor] = ACTIONS(187),
    [anon_sym_BSLASHusepgflibrary] = ACTIONS(187),
    [anon_sym_BSLASHusetikzlibrary] = ACTIONS(187),
    [anon_sym_BSLASHtext] = ACTIONS(187),
    [anon_sym_BSLASHintertext] = ACTIONS(187),
    [anon_sym_shortintertext] = ACTIONS(187),
  },
  [13] = {
    [sym_block_comment] = STATE(165),
    [sym__root_content] = STATE(165),
    [sym__flat_content] = STATE(165),
    [sym__text_with_env_content] = STATE(165),
    [sym__text_content] = STATE(165),
    [sym__section] = STATE(165),
    [sym__part_declaration] = STATE(180),
    [sym_part] = STATE(721),
    [sym__chapter_declaration] = STATE(191),
    [sym_chapter] = STATE(722),
    [sym__section_declaration] = STATE(203),
    [sym_section] = STATE(723),
    [sym__subsection_declaration] = STATE(214),
    [sym_subsection] = STATE(724),
    [sym__subsubsection_declaration] = STATE(223),
    [sym_subsubsection] = STATE(725),
    [sym__paragraph_declaration] = STATE(234),
    [sym_paragraph] = STATE(726),
    [sym__subparagraph_declaration] = STATE(241),
    [sym_subparagraph] = STATE(727),
    [sym__enum_itemdeclaration] = STATE(257),
    [sym_enum_item] = STATE(728),
    [sym_curly_group] = STATE(165),
    [sym_text] = STATE(165),
    [sym_operator] = STATE(1385),
    [sym_subscript] = STATE(1385),
    [sym_superscript] = STATE(1385),
    [sym_displayed_equation] = STATE(165),
    [sym_inline_formula] = STATE(165),
    [sym_begin] = STATE(73),
    [sym_generic_environment] = STATE(165),
    [sym_comment_environment] = STATE(165),
    [sym__comment_environment_begin] = STATE(3152),
    [sym_verbatim_environment] = STATE(165),
    [sym__verbatim_environment_begin] = STATE(3151),
    [sym_listing_environment] = STATE(165),
    [sym__listing_environment_begin] = STATE(3149),
    [sym_minted_environment] = STATE(165),
    [sym__minted_environment_begin] = STATE(3148),
    [sym_pycode_environment] = STATE(165),
    [sym__pycode_environment_begin] = STATE(3146),
    [sym_math_environment] = STATE(165),
    [sym__math_environment_begin] = STATE(271),
    [sym__command] = STATE(165),
    [sym_generic_command] = STATE(165),
    [sym_title_declaration] = STATE(165),
    [sym_author_declaration] = STATE(165),
    [sym_package_include] = STATE(165),
    [sym_class_include] = STATE(165),
    [sym_latex_include] = STATE(165),
    [sym_biblatex_include] = STATE(165),
    [sym_bibtex_include] = STATE(165),
    [sym_graphics_include] = STATE(165),
    [sym_svg_include] = STATE(165),
    [sym_inkscape_include] = STATE(165),
    [sym_verbatim_include] = STATE(165),
    [sym_import_include] = STATE(165),
    [sym_caption] = STATE(165),
    [sym_citation] = STATE(165),
    [sym_label_definition] = STATE(165),
    [sym_label_reference] = STATE(165),
    [sym_label_reference_range] = STATE(165),
    [sym_label_number] = STATE(165),
    [sym_new_command_definition] = STATE(165),
    [sym_old_command_definition] = STATE(165),
    [sym_let_command_definition] = STATE(165),
    [sym_math_delimiter] = STATE(165),
    [sym_paired_delimiter_definition] = STATE(165),
    [sym_environment_definition] = STATE(165),
    [sym_glossary_entry_definition] = STATE(165),
    [sym_glossary_entry_reference] = STATE(165),
    [sym_acronym_definition] = STATE(165),
    [sym_acronym_reference] = STATE(165),
    [sym_theorem_definition] = STATE(165),
    [sym_color_definition] = STATE(165),
    [sym_color_set_definition] = STATE(165),
    [sym_color_reference] = STATE(165),
    [sym_tikz_library_import] = STATE(165),
    [sym_text_mode] = STATE(165),
    [aux_sym_source_file_repeat1] = STATE(165),
    [aux_sym__section_repeat1] = STATE(721),
    [aux_sym__section_repeat2] = STATE(722),
    [aux_sym__section_repeat3] = STATE(723),
    [aux_sym__section_repeat4] = STATE(724),
    [aux_sym__section_repeat5] = STATE(725),
    [aux_sym__section_repeat6] = STATE(726),
    [aux_sym__section_repeat7] = STATE(727),
    [aux_sym__section_repeat8] = STATE(728),
    [aux_sym_text_repeat1] = STATE(288),
    [sym_command_name] = ACTIONS(195),
    [sym__whitespace] = ACTIONS(3),
    [sym_line_comment] = ACTIONS(3),
    [anon_sym_BSLASHiffalse] = ACTIONS(195),
    [anon_sym_LBRACK] = ACTIONS(197),
    [anon_sym_RBRACK] = ACTIONS(197),
    [anon_sym_COMMA] = ACTIONS(197),
    [anon_sym_EQ] = ACTIONS(197),
    [anon_sym_LPAREN] = ACTIONS(197),
    [anon_sym_RPAREN] = ACTIONS(197),
    [anon_sym_BSLASHpart] = ACTIONS(195),
    [anon_sym_BSLASHpart_STAR] = ACTIONS(197),
    [anon_sym_BSLASHaddpart] = ACTIONS(195),
    [anon_sym_BSLASHaddpart_STAR] = ACTIONS(197),
    [anon_sym_BSLASHchapter] = ACTIONS(195),
    [anon_sym_BSLASHchapter_STAR] = ACTIONS(197),
    [anon_sym_BSLASHaddchap] = ACTIONS(195),
    [anon_sym_BSLASHaddchap_STAR] = ACTIONS(197),
    [anon_sym_BSLASHsection] = ACTIONS(195),
    [anon_sym_BSLASHsection_STAR] = ACTIONS(197),
    [anon_sym_BSLASHaddsec] = ACTIONS(195),
    [anon_sym_BSLASHaddsec_STAR] = ACTIONS(197),
    [anon_sym_BSLASHsubsection] = ACTIONS(195),
    [anon_sym_BSLASHsubsection_STAR] = ACTIONS(197),
    [anon_sym_BSLASHsubsubsection] = ACTIONS(195),
    [anon_sym_BSLASHsubsubsection_STAR] = ACTIONS(197),
    [anon_sym_BSLASHparagraph] = ACTIONS(195),
    [anon_sym_BSLASHparagraph_STAR] = ACTIONS(197),
    [anon_sym_BSLASHsubparagraph] = ACTIONS(195),
    [anon_sym_BSLASHsubparagraph_STAR] = ACTIONS(197),
    [anon_sym_BSLASHitem] = ACTIONS(195),
    [anon_sym_BSLASHitem_STAR] = ACTIONS(197),
    [anon_sym_LBRACE] = ACTIONS(197),
    [sym_word] = ACTIONS(195),
    [sym_placeholder] = ACTIONS(197),
    [anon_sym_PLUS] = ACTIONS(197),
    [anon_sym_DASH] = ACTIONS(197),
    [anon_sym_STAR] = ACTIONS(197),
    [anon_sym_SLASH] = ACTIONS(197),
    [anon_sym_LT] = ACTIONS(195),
    [anon_sym_GT] = ACTIONS(195),
    [anon_sym_BANG] = ACTIONS(195),
    [anon_sym_PIPE] = ACTIONS(195),
    [anon_sym_COLON] = ACTIONS(195),
    [anon_sym_SQUOTE] = ACTIONS(195),
    [anon_sym__] = ACTIONS(197),
    [anon_sym_CARET] = ACTIONS(197),
    [anon_sym_DOLLAR_DOLLAR] = ACTIONS(197),
    [anon_sym_BSLASH_LBRACK] = ACTIONS(197),
    [anon_sym_DOLLAR] = ACTIONS(195),
    [anon_sym_BSLASH_LPAREN] = ACTIONS(197),
    [anon_sym_BSLASH_RPAREN] = ACTIONS(193),
    [anon_sym_BSLASHbegin] = ACTIONS(195),
    [anon_sym_BSLASHtitle] = ACTIONS(195),
    [anon_sym_BSLASHauthor] = ACTIONS(195),
    [anon_sym_BSLASHusepackage] = ACTIONS(195),
    [anon_sym_BSLASHRequirePackage] = ACTIONS(195),
    [anon_sym_BSLASHdocumentclass] = ACTIONS(195),
    [anon_sym_BSLASHinclude] = ACTIONS(195),
    [anon_sym_BSLASHsubfileinclude] = ACTIONS(195),
    [anon_sym_BSLASHinput] = ACTIONS(195),
    [anon_sym_BSLASHsubfile] = ACTIONS(195),
    [anon_sym_BSLASHaddbibresource] = ACTIONS(195),
    [anon_sym_BSLASHbibliography] = ACTIONS(195),
    [anon_sym_BSLASHincludegraphics] = ACTIONS(195),
    [anon_sym_BSLASHincludesvg] = ACTIONS(195),
    [anon_sym_BSLASHincludeinkscape] = ACTIONS(195),
    [anon_sym_BSLASHverbatiminput] = ACTIONS(195),
    [anon_sym_BSLASHVerbatimInput] = ACTIONS(195),
    [anon_sym_BSLASHimport] = ACTIONS(195),
    [anon_sym_BSLASHsubimport] = ACTIONS(195),
    [anon_sym_BSLASHinputfrom] = ACTIONS(195),
    [anon_sym_BSLASHsubimportfrom] = ACTIONS(195),
    [anon_sym_BSLASHincludefrom] = ACTIONS(195),
    [anon_sym_BSLASHsubincludefrom] = ACTIONS(195),
    [anon_sym_BSLASHcaption] = ACTIONS(195),
    [anon_sym_BSLASHcite] = ACTIONS(195),
    [anon_sym_BSLASHcite_STAR] = ACTIONS(197),
    [anon_sym_BSLASHCite] = ACTIONS(195),
    [anon_sym_BSLASHnocite] = ACTIONS(195),
    [anon_sym_BSLASHcitet] = ACTIONS(195),
    [anon_sym_BSLASHcitep] = ACTIONS(195),
    [anon_sym_BSLASHcitet_STAR] = ACTIONS(197),
    [anon_sym_BSLASHcitep_STAR] = ACTIONS(197),
    [anon_sym_BSLASHciteauthor] = ACTIONS(195),
    [anon_sym_BSLASHciteauthor_STAR] = ACTIONS(197),
    [anon_sym_BSLASHCiteauthor] = ACTIONS(195),
    [anon_sym_BSLASHCiteauthor_STAR] = ACTIONS(197),
    [anon_sym_BSLASHcitetitle] = ACTIONS(195),
    [anon_sym_BSLASHcitetitle_STAR] = ACTIONS(197),
    [anon_sym_BSLASHciteyear] = ACTIONS(195),
    [anon_sym_BSLASHciteyear_STAR] = ACTIONS(197),
    [anon_sym_BSLASHcitedate] = ACTIONS(195),
    [anon_sym_BSLASHcitedate_STAR] = ACTIONS(197),
    [anon_sym_BSLASHciteurl] = ACTIONS(195),
    [anon_sym_BSLASHfullcite] = ACTIONS(195),
    [anon_sym_BSLASHciteyearpar] = ACTIONS(195),
    [anon_sym_BSLASHcitealt] = ACTIONS(195),
    [anon_sym_BSLASHcitealp] = ACTIONS(195),
    [anon_sym_BSLASHcitetext] = ACTIONS(195),
    [anon_sym_BSLASHparencite] = ACTIONS(195),
    [anon_sym_BSLASHparencite_STAR] = ACTIONS(197),
    [anon_sym_BSLASHParencite] = ACTIONS(195),
    [anon_sym_BSLASHfootcite] = ACTIONS(195),
    [anon_sym_BSLASHfootfullcite] = ACTIONS(195),
    [anon_sym_BSLASHfootcitetext] = ACTIONS(195),
    [anon_sym_BSLASHtextcite] = ACTIONS(195),
    [anon_sym_BSLASHTextcite] = ACTIONS(195),
    [anon_sym_BSLASHsmartcite] = ACTIONS(195),
    [anon_sym_BSLASHSmartcite] = ACTIONS(195),
    [anon_sym_BSLASHsupercite] = ACTIONS(195),
    [anon_sym_BSLASHautocite] = ACTIONS(195),
    [anon_sym_BSLASHAutocite] = ACTIONS(195),
    [anon_sym_BSLASHautocite_STAR] = ACTIONS(197),
    [anon_sym_BSLASHAutocite_STAR] = ACTIONS(197),
    [anon_sym_BSLASHvolcite] = ACTIONS(195),
    [anon_sym_BSLASHVolcite] = ACTIONS(195),
    [anon_sym_BSLASHpvolcite] = ACTIONS(195),
    [anon_sym_BSLASHPvolcite] = ACTIONS(195),
    [anon_sym_BSLASHfvolcite] = ACTIONS(195),
    [anon_sym_BSLASHftvolcite] = ACTIONS(195),
    [anon_sym_BSLASHsvolcite] = ACTIONS(195),
    [anon_sym_BSLASHSvolcite] = ACTIONS(195),
    [anon_sym_BSLASHtvolcite] = ACTIONS(195),
    [anon_sym_BSLASHTvolcite] = ACTIONS(195),
    [anon_sym_BSLASHavolcite] = ACTIONS(195),
    [anon_sym_BSLASHAvolcite] = ACTIONS(195),
    [anon_sym_BSLASHnotecite] = ACTIONS(195),
    [anon_sym_BSLASHNotecite] = ACTIONS(195),
    [anon_sym_BSLASHpnotecite] = ACTIONS(195),
    [anon_sym_BSLASHPnotecite] = ACTIONS(195),
    [anon_sym_BSLASHfnotecite] = ACTIONS(195),
    [anon_sym_BSLASHlabel] = ACTIONS(195),
    [anon_sym_BSLASHref] = ACTIONS(195),
    [anon_sym_BSLASHeqref] = ACTIONS(195),
    [anon_sym_BSLASHvref] = ACTIONS(195),
    [anon_sym_BSLASHVref] = ACTIONS(195),
    [anon_sym_BSLASHautoref] = ACTIONS(195),
    [anon_sym_BSLASHpageref] = ACTIONS(195),
    [anon_sym_BSLASHcref] = ACTIONS(195),
    [anon_sym_BSLASHCref] = ACTIONS(195),
    [anon_sym_BSLASHcref_STAR] = ACTIONS(197),
    [anon_sym_BSLASHCref_STAR] = ACTIONS(197),
    [anon_sym_BSLASHnamecref] = ACTIONS(195),
    [anon_sym_BSLASHnameCref] = ACTIONS(195),
    [anon_sym_BSLASHlcnamecref] = ACTIONS(195),
    [anon_sym_BSLASHnamecrefs] = ACTIONS(195),
    [anon_sym_BSLASHnameCrefs] = ACTIONS(195),
    [anon_sym_BSLASHlcnamecrefs] = ACTIONS(195),
    [anon_sym_BSLASHlabelcref] = ACTIONS(195),
    [anon_sym_BSLASHlabelcpageref] = ACTIONS(195),
    [anon_sym_BSLASHcrefrange] = ACTIONS(195),
    [anon_sym_BSLASHcrefrange_STAR] = ACTIONS(197),
    [anon_sym_BSLASHCrefrange] = ACTIONS(195),
    [anon_sym_BSLASHCrefrange_STAR] = ACTIONS(197),
    [anon_sym_BSLASHnewlabel] = ACTIONS(195),
    [anon_sym_BSLASHnewcommand] = ACTIONS(195),
    [anon_sym_BSLASHnewcommand_STAR] = ACTIONS(197),
    [anon_sym_BSLASHrenewcommand] = ACTIONS(195),
    [anon_sym_BSLASHrenewcommand_STAR] = ACTIONS(197),
    [anon_sym_BSLASHDeclareRobustCommand] = ACTIONS(195),
    [anon_sym_BSLASHDeclareRobustCommand_STAR] = ACTIONS(197),
    [anon_sym_BSLASHDeclareMathOperator] = ACTIONS(195),
    [anon_sym_BSLASHDeclareMathOperator_STAR] = ACTIONS(197),
    [anon_sym_BSLASHNewDocumentCommand] = ACTIONS(195),
    [anon_sym_BSLASHRenewDocumentCommand] = ACTIONS(195),
    [anon_sym_BSLASHProvideDocumentCommand] = ACTIONS(195),
    [anon_sym_BSLASHDeclareDocumentCommand] = ACTIONS(195),
    [anon_sym_BSLASHNewExpandableDocumentCommand] = ACTIONS(195),
    [anon_sym_BSLASHRenewExpandableDocumentCommand] = ACTIONS(195),
    [anon_sym_BSLASHProvideExpandableDocumentCommand] = ACTIONS(195),
    [anon_sym_BSLASHDeclareExpandableDocumentCommand] = ACTIONS(195),
    [anon_sym_BSLASHdef] = ACTIONS(195),
    [anon_sym_BSLASHlet] = ACTIONS(195),
    [anon_sym_BSLASHleft] = ACTIONS(195),
    [anon_sym_BSLASHbig] = ACTIONS(195),
    [anon_sym_BSLASHBig] = ACTIONS(195),
    [anon_sym_BSLASHbigg] = ACTIONS(195),
    [anon_sym_BSLASHBigg] = ACTIONS(195),
    [anon_sym_BSLASHbigl] = ACTIONS(195),
    [anon_sym_BSLASHBigl] = ACTIONS(195),
    [anon_sym_BSLASHbiggl] = ACTIONS(195),
    [anon_sym_BSLASHBiggl] = ACTIONS(195),
    [anon_sym_BSLASHright] = ACTIONS(195),
    [anon_sym_BSLASHbigr] = ACTIONS(195),
    [anon_sym_BSLASHBigr] = ACTIONS(195),
    [anon_sym_BSLASHbiggr] = ACTIONS(195),
    [anon_sym_BSLASHBiggr] = ACTIONS(195),
    [anon_sym_BSLASHDeclarePairedDelimiter] = ACTIONS(195),
    [anon_sym_BSLASHDeclarePairedDelimiterX] = ACTIONS(195),
    [anon_sym_BSLASHnewenvironment] = ACTIONS(195),
    [anon_sym_BSLASHrenewenvironment] = ACTIONS(195),
    [anon_sym_BSLASHNewDocumentEnvironment] = ACTIONS(195),
    [anon_sym_BSLASHRenewDocumentEnvironment] = ACTIONS(195),
    [anon_sym_BSLASHProvideDocumentEnvironment] = ACTIONS(195),
    [anon_sym_BSLASHDeclareDocumentEnvironment] = ACTIONS(195),
    [anon_sym_BSLASHnewglossaryentry] = ACTIONS(195),
    [anon_sym_BSLASHgls] = ACTIONS(195),
    [anon_sym_BSLASHGls] = ACTIONS(195),
    [anon_sym_BSLASHGLS] = ACTIONS(195),
    [anon_sym_BSLASHglspl] = ACTIONS(195),
    [anon_sym_BSLASHGlspl] = ACTIONS(195),
    [anon_sym_BSLASHGLSpl] = ACTIONS(195),
    [anon_sym_BSLASHglsdisp] = ACTIONS(195),
    [anon_sym_BSLASHglslink] = ACTIONS(195),
    [anon_sym_BSLASHglstext] = ACTIONS(195),
    [anon_sym_BSLASHGlstext] = ACTIONS(195),
    [anon_sym_BSLASHGLStext] = ACTIONS(195),
    [anon_sym_BSLASHglsfirst] = ACTIONS(195),
    [anon_sym_BSLASHGlsfirst] = ACTIONS(195),
    [anon_sym_BSLASHGLSfirst] = ACTIONS(195),
    [anon_sym_BSLASHglsplural] = ACTIONS(195),
    [anon_sym_BSLASHGlsplural] = ACTIONS(195),
    [anon_sym_BSLASHGLSplural] = ACTIONS(195),
    [anon_sym_BSLASHglsfirstplural] = ACTIONS(195),
    [anon_sym_BSLASHGlsfirstplural] = ACTIONS(195),
    [anon_sym_BSLASHGLSfirstplural] = ACTIONS(195),
    [anon_sym_BSLASHglsname] = ACTIONS(195),
    [anon_sym_BSLASHGlsname] = ACTIONS(195),
    [anon_sym_BSLASHGLSname] = ACTIONS(195),
    [anon_sym_BSLASHglssymbol] = ACTIONS(195),
    [anon_sym_BSLASHGlssymbol] = ACTIONS(195),
    [anon_sym_BSLASHglsdesc] = ACTIONS(195),
    [anon_sym_BSLASHGlsdesc] = ACTIONS(195),
    [anon_sym_BSLASHGLSdesc] = ACTIONS(195),
    [anon_sym_BSLASHglsuseri] = ACTIONS(195),
    [anon_sym_BSLASHGlsuseri] = ACTIONS(195),
    [anon_sym_BSLASHGLSuseri] = ACTIONS(195),
    [anon_sym_BSLASHglsuserii] = ACTIONS(195),
    [anon_sym_BSLASHGlsuserii] = ACTIONS(195),
    [anon_sym_BSLASHGLSuserii] = ACTIONS(195),
    [anon_sym_BSLASHglsuseriii] = ACTIONS(195),
    [anon_sym_BSLASHGlsuseriii] = ACTIONS(195),
    [anon_sym_BSLASHGLSuseriii] = ACTIONS(195),
    [anon_sym_BSLASHglsuseriv] = ACTIONS(195),
    [anon_sym_BSLASHGlsuseriv] = ACTIONS(195),
    [anon_sym_BSLASHGLSuseriv] = ACTIONS(195),
    [anon_sym_BSLASHglsuserv] = ACTIONS(195),
    [anon_sym_BSLASHGlsuserv] = ACTIONS(195),
    [anon_sym_BSLASHGLSuserv] = ACTIONS(195),
    [anon_sym_BSLASHglsuservi] = ACTIONS(195),
    [anon_sym_BSLASHGlsuservi] = ACTIONS(195),
    [anon_sym_BSLASHGLSuservi] = ACTIONS(195),
    [anon_sym_BSLASHnewacronym] = ACTIONS(195),
    [anon_sym_BSLASHacrshort] = ACTIONS(195),
    [anon_sym_BSLASHAcrshort] = ACTIONS(195),
    [anon_sym_BSLASHACRshort] = ACTIONS(195),
    [anon_sym_BSLASHacrshortpl] = ACTIONS(195),
    [anon_sym_BSLASHAcrshortpl] = ACTIONS(195),
    [anon_sym_BSLASHACRshortpl] = ACTIONS(195),
    [anon_sym_BSLASHacrlong] = ACTIONS(195),
    [anon_sym_BSLASHAcrlong] = ACTIONS(195),
    [anon_sym_BSLASHACRlong] = ACTIONS(195),
    [anon_sym_BSLASHacrlongpl] = ACTIONS(195),
    [anon_sym_BSLASHAcrlongpl] = ACTIONS(195),
    [anon_sym_BSLASHACRlongpl] = ACTIONS(195),
    [anon_sym_BSLASHacrfull] = ACTIONS(195),
    [anon_sym_BSLASHAcrfull] = ACTIONS(195),
    [anon_sym_BSLASHACRfull] = ACTIONS(195),
    [anon_sym_BSLASHacrfullpl] = ACTIONS(195),
    [anon_sym_BSLASHAcrfullpl] = ACTIONS(195),
    [anon_sym_BSLASHACRfullpl] = ACTIONS(195),
    [anon_sym_BSLASHacs] = ACTIONS(195),
    [anon_sym_BSLASHAcs] = ACTIONS(195),
    [anon_sym_BSLASHacsp] = ACTIONS(195),
    [anon_sym_BSLASHAcsp] = ACTIONS(195),
    [anon_sym_BSLASHacl] = ACTIONS(195),
    [anon_sym_BSLASHAcl] = ACTIONS(195),
    [anon_sym_BSLASHaclp] = ACTIONS(195),
    [anon_sym_BSLASHAclp] = ACTIONS(195),
    [anon_sym_BSLASHacf] = ACTIONS(195),
    [anon_sym_BSLASHAcf] = ACTIONS(195),
    [anon_sym_BSLASHacfp] = ACTIONS(195),
    [anon_sym_BSLASHAcfp] = ACTIONS(195),
    [anon_sym_BSLASHac] = ACTIONS(195),
    [anon_sym_BSLASHAc] = ACTIONS(195),
    [anon_sym_BSLASHacp] = ACTIONS(195),
    [anon_sym_BSLASHglsentrylong] = ACTIONS(195),
    [anon_sym_BSLASHGlsentrylong] = ACTIONS(195),
    [anon_sym_BSLASHglsentrylongpl] = ACTIONS(195),
    [anon_sym_BSLASHGlsentrylongpl] = ACTIONS(195),
    [anon_sym_BSLASHglsentryshort] = ACTIONS(195),
    [anon_sym_BSLASHGlsentryshort] = ACTIONS(195),
    [anon_sym_BSLASHglsentryshortpl] = ACTIONS(195),
    [anon_sym_BSLASHGlsentryshortpl] = ACTIONS(195),
    [anon_sym_BSLASHglsentryfullpl] = ACTIONS(195),
    [anon_sym_BSLASHGlsentryfullpl] = ACTIONS(195),
    [anon_sym_BSLASHnewtheorem] = ACTIONS(195),
    [anon_sym_BSLASHnewtheorem_STAR] = ACTIONS(197),
    [anon_sym_BSLASHdeclaretheorem] = ACTIONS(195),
    [anon_sym_BSLASHdeclaretheorem_STAR] = ACTIONS(197),
    [anon_sym_BSLASHdefinecolor] = ACTIONS(195),
    [anon_sym_BSLASHdefinecolorset] = ACTIONS(195),
    [anon_sym_BSLASHcolor] = ACTIONS(195),
    [anon_sym_BSLASHcolorbox] = ACTIONS(195),
    [anon_sym_BSLASHtextcolor] = ACTIONS(195),
    [anon_sym_BSLASHpagecolor] = ACTIONS(195),
    [anon_sym_BSLASHusepgflibrary] = ACTIONS(195),
    [anon_sym_BSLASHusetikzlibrary] = ACTIONS(195),
    [anon_sym_BSLASHtext] = ACTIONS(195),
    [anon_sym_BSLASHintertext] = ACTIONS(195),
    [anon_sym_shortintertext] = ACTIONS(195),
  },
  [14] = {
    [sym_block_comment] = STATE(27),
    [sym__root_content] = STATE(27),
    [sym__flat_content] = STATE(27),
    [sym__text_with_env_content] = STATE(27),
    [sym__text_content] = STATE(27),
    [sym__section] = STATE(27),
    [sym__part_declaration] = STATE(175),
    [sym_part] = STATE(367),
    [sym__chapter_declaration] = STATE(177),
    [sym_chapter] = STATE(368),
    [sym__section_declaration] = STATE(187),
    [sym_section] = STATE(369),
    [sym__subsection_declaration] = STATE(196),
    [sym_subsection] = STATE(370),
    [sym__subsubsection_declaration] = STATE(207),
    [sym_subsubsection] = STATE(371),
    [sym__paragraph_declaration] = STATE(218),
    [sym_paragraph] = STATE(373),
    [sym__subparagraph_declaration] = STATE(228),
    [sym_subparagraph] = STATE(374),
    [sym__enum_itemdeclaration] = STATE(238),
    [sym_enum_item] = STATE(375),
    [sym_curly_group] = STATE(27),
    [sym_text] = STATE(27),
    [sym_operator] = STATE(484),
    [sym_subscript] = STATE(484),
    [sym_superscript] = STATE(484),
    [sym_displayed_equation] = STATE(27),
    [sym_inline_formula] = STATE(27),
    [sym_begin] = STATE(65),
    [sym_generic_environment] = STATE(27),
    [sym_comment_environment] = STATE(27),
    [sym__comment_environment_begin] = STATE(3120),
    [sym_verbatim_environment] = STATE(27),
    [sym__verbatim_environment_begin] = STATE(3121),
    [sym_listing_environment] = STATE(27),
    [sym__listing_environment_begin] = STATE(3122),
    [sym_minted_environment] = STATE(27),
    [sym__minted_environment_begin] = STATE(3123),
    [sym_pycode_environment] = STATE(27),
    [sym__pycode_environment_begin] = STATE(3124),
    [sym_math_environment] = STATE(27),
    [sym__math_environment_begin] = STATE(269),
    [sym__command] = STATE(27),
    [sym_generic_command] = STATE(27),
    [sym_title_declaration] = STATE(27),
    [sym_author_declaration] = STATE(27),
    [sym_package_include] = STATE(27),
    [sym_class_include] = STATE(27),
    [sym_latex_include]