#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#ifdef _MSC_VER
#pragma optimize("", off)
#elif defined(__clang__)
#pragma clang optimize off
#elif defined(__GNUC__)
#pragma GCC optimize ("O0")
#endif

#define LANGUAGE_VERSION 13
#define STATE_COUNT 508
#define LARGE_STATE_COUNT 15
#define SYMBOL_COUNT 159
#define ALIAS_COUNT 20
#define TOKEN_COUNT 81
#define EXTERNAL_TOKEN_COUNT 1
#define FIELD_COUNT 0
#define MAX_ALIAS_SEQUENCE_LENGTH 7
#define PRODUCTION_ID_COUNT 27

enum {
  anon_sym_ATimport = 1,
  anon_sym_COMMA = 2,
  anon_sym_SEMI = 3,
  anon_sym_ATmedia = 4,
  anon_sym_ATcharset = 5,
  anon_sym_ATnamespace = 6,
  anon_sym_ATkeyframes = 7,
  aux_sym_keyframes_statement_token1 = 8,
  anon_sym_LBRACE = 9,
  anon_sym_RBRACE = 10,
  anon_sym_from = 11,
  sym_to = 12,
  anon_sym_ATsupports = 13,
  anon_sym_ATuse = 14,
  anon_sym_ATforward = 15,
  anon_sym_ATapply = 16,
  anon_sym_LPAREN = 17,
  anon_sym_RPAREN = 18,
  anon_sym_COLON = 19,
  anon_sym_ATmixin = 20,
  anon_sym_ATinclude = 21,
  anon_sym_LPAREN2 = 22,
  anon_sym_RPAREN2 = 23,
  anon_sym_PERCENT = 24,
  anon_sym_ATextend = 25,
  anon_sym_ATif = 26,
  anon_sym_ATelse = 27,
  anon_sym_if = 28,
  anon_sym_ATeach = 29,
  anon_sym_in = 30,
  anon_sym_ATfor = 31,
  anon_sym_through = 32,
  anon_sym_ATwhile = 33,
  anon_sym_ATfunction = 34,
  anon_sym_ATreturn = 35,
  anon_sym_ATat_DASHroot = 36,
  anon_sym_ATerror = 37,
  anon_sym_ATwarn = 38,
  anon_sym_ATdebug = 39,
  sym_nesting_selector = 40,
  anon_sym_STAR = 41,
  anon_sym_DOT = 42,
  anon_sym_COLON_COLON = 43,
  anon_sym_POUND = 44,
  anon_sym_LBRACK = 45,
  anon_sym_EQ = 46,
  anon_sym_TILDE_EQ = 47,
  anon_sym_CARET_EQ = 48,
  anon_sym_PIPE_EQ = 49,
  anon_sym_STAR_EQ = 50,
  anon_sym_DOLLAR_EQ = 51,
  anon_sym_RBRACK = 52,
  anon_sym_GT = 53,
  anon_sym_TILDE = 54,
  anon_sym_PLUS = 55,
  sym_important = 56,
  anon_sym_and = 57,
  anon_sym_or = 58,
  anon_sym_not = 59,
  anon_sym_only = 60,
  anon_sym_selector = 61,
  aux_sym_color_value_token1 = 62,
  sym_string_value = 63,
  aux_sym_integer_value_token1 = 64,
  aux_sym_float_value_token1 = 65,
  sym_unit = 66,
  anon_sym_DASH = 67,
  anon_sym_SLASH = 68,
  anon_sym_EQ_EQ = 69,
  anon_sym_LT = 70,
  anon_sym_BANG_EQ = 71,
  anon_sym_LT_EQ = 72,
  anon_sym_GT_EQ = 73,
  sym_identifier = 74,
  sym_variable_identifier = 75,
  sym_at_keyword = 76,
  sym_comment = 77,
  sym_single_line_comment = 78,
  sym_plain_value = 79,
  sym__descendant_operator = 80,
  sym_stylesheet = 81,
  sym_import_statement = 82,
  sym_media_statement = 83,
  sym_charset_statement = 84,
  sym_namespace_statement = 85,
  sym_keyframes_statement = 86,
  sym_keyframe_block_list = 87,
  sym_keyframe_block = 88,
  sym_from = 89,
  sym_supports_statement = 90,
  sym_at_rule = 91,
  sym_use_statement = 92,
  sym_forward_statement = 93,
  sym_apply_statement = 94,
  sym_parameters = 95,
  sym_parameter = 96,
  sym_mixin_statement = 97,
  sym_include_statement = 98,
  sym_include_arguments = 99,
  sym_include_argument = 100,
  sym_placeholder = 101,
  sym_extend_statement = 102,
  sym_if_statement = 103,
  sym_if_clause = 104,
  sym_else_if_clause = 105,
  sym_else_clause = 106,
  sym_each_statement = 107,
  sym_for_statement = 108,
  sym_while_statement = 109,
  sym_function_statement = 110,
  sym_return_statement = 111,
  sym_at_root_statement = 112,
  sym_error_statement = 113,
  sym_warn_statement = 114,
  sym_debug_statement = 115,
  sym_rule_set = 116,
  sym_selectors = 117,
  sym_block = 118,
  sym__selector = 119,
  sym_universal_selector = 120,
  sym_class_selector = 121,
  sym_pseudo_class_selector = 122,
  sym_pseudo_element_selector = 123,
  sym_id_selector = 124,
  sym_attribute_selector = 125,
  sym_child_selector = 126,
  sym_descendant_selector = 127,
  sym_sibling_selector = 128,
  sym_adjacent_sibling_selector = 129,
  sym_pseudo_class_arguments = 130,
  sym_declaration = 131,
  sym_last_declaration = 132,
  sym__query = 133,
  sym_feature_query = 134,
  sym_parenthesized_query = 135,
  sym_binary_query = 136,
  sym_unary_query = 137,
  sym_selector_query = 138,
  sym__value = 139,
  sym_parenthesized_value = 140,
  sym_color_value = 141,
  sym_integer_value = 142,
  sym_float_value = 143,
  sym_call_expression = 144,
  sym_binary_expression = 145,
  sym_arguments = 146,
  aux_sym_stylesheet_repeat1 = 147,
  aux_sym_import_statement_repeat1 = 148,
  aux_sym_keyframe_block_list_repeat1 = 149,
  aux_sym_apply_statement_repeat1 = 150,
  aux_sym_parameters_repeat1 = 151,
  aux_sym_include_arguments_repeat1 = 152,
  aux_sym_if_statement_repeat1 = 153,
  aux_sym_selectors_repeat1 = 154,
  aux_sym_block_repeat1 = 155,
  aux_sym_pseudo_class_arguments_repeat1 = 156,
  aux_sym_declaration_repeat1 = 157,
  aux_sym_arguments_repeat1 = 158,
  alias_sym_argument_name = 159,
  alias_sym_argument_value = 160,
  alias_sym_attribute_name = 161,
  alias_sym_class_name = 162,
  alias_sym_condition = 163,
  alias_sym_default_value = 164,
  alias_sym_feature_name = 165,
  alias_sym_function_name = 166,
  alias_sym_id_name = 167,
  alias_sym_key = 168,
  alias_sym_keyframes_name = 169,
  alias_sym_keyword_query = 170,
  alias_sym_name = 171,
  alias_sym_namespace_name = 172,
  alias_sym_property_name = 173,
  alias_sym_tag_name = 174,
  alias_sym_through = 175,
  alias_sym_value = 176,
  alias_sym_variable = 177,
  alias_sym_variable_value = 178,
};

static const char *ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [anon_sym_ATimport] = "@import",
  [anon_sym_COMMA] = ",",
  [anon_sym_SEMI] = ";",
  [anon_sym_ATmedia] = "@media",
  [anon_sym_ATcharset] = "@charset",
  [anon_sym_ATnamespace] = "@namespace",
  [anon_sym_ATkeyframes] = "@keyframes",
  [aux_sym_keyframes_statement_token1] = "at_keyword",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_from] = "from",
  [sym_to] = "to",
  [anon_sym_ATsupports] = "@supports",
  [anon_sym_ATuse] = "@use",
  [anon_sym_ATforward] = "@forward",
  [anon_sym_ATapply] = "@apply",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_COLON] = ":",
  [anon_sym_ATmixin] = "@mixin",
  [anon_sym_ATinclude] = "@include",
  [anon_sym_LPAREN2] = "(",
  [anon_sym_RPAREN2] = ")",
  [anon_sym_PERCENT] = "%",
  [anon_sym_ATextend] = "@extend",
  [anon_sym_ATif] = "@if",
  [anon_sym_ATelse] = "@else",
  [anon_sym_if] = "if",
  [anon_sym_ATeach] = "@each",
  [anon_sym_in] = "in",
  [anon_sym_ATfor] = "@for",
  [anon_sym_through] = "through",
  [anon_sym_ATwhile] = "@while",
  [anon_sym_ATfunction] = "@function",
  [anon_sym_ATreturn] = "@return",
  [anon_sym_ATat_DASHroot] = "@at-root",
  [anon_sym_ATerror] = "@error",
  [anon_sym_ATwarn] = "@warn",
  [anon_sym_ATdebug] = "@debug",
  [sym_nesting_selector] = "nesting_selector",
  [anon_sym_STAR] = "*",
  [anon_sym_DOT] = ".",
  [anon_sym_COLON_COLON] = "::",
  [anon_sym_POUND] = "#",
  [anon_sym_LBRACK] = "[",
  [anon_sym_EQ] = "=",
  [anon_sym_TILDE_EQ] = "~=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_DOLLAR_EQ] = "$=",
  [anon_sym_RBRACK] = "]",
  [anon_sym_GT] = ">",
  [anon_sym_TILDE] = "~",
  [anon_sym_PLUS] = "+",
  [sym_important] = "important",
  [anon_sym_and] = "and",
  [anon_sym_or] = "or",
  [anon_sym_not] = "not",
  [anon_sym_only] = "only",
  [anon_sym_selector] = "selector",
  [aux_sym_color_value_token1] = "color_value_token1",
  [sym_string_value] = "string_value",
  [aux_sym_integer_value_token1] = "integer_value_token1",
  [aux_sym_float_value_token1] = "float_value_token1",
  [sym_unit] = "unit",
  [anon_sym_DASH] = "-",
  [anon_sym_SLASH] = "/",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_LT] = "<",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_GT_EQ] = ">=",
  [sym_identifier] = "identifier",
  [sym_variable_identifier] = "variable_name",
  [sym_at_keyword] = "at_keyword",
  [sym_comment] = "comment",
  [sym_single_line_comment] = "single_line_comment",
  [sym_plain_value] = "plain_value",
  [sym__descendant_operator] = "_descendant_operator",
  [sym_stylesheet] = "stylesheet",
  [sym_import_statement] = "import_statement",
  [sym_media_statement] = "media_statement",
  [sym_charset_statement] = "charset_statement",
  [sym_namespace_statement] = "namespace_statement",
  [sym_keyframes_statement] = "keyframes_statement",
  [sym_keyframe_block_list] = "keyframe_block_list",
  [sym_keyframe_block] = "keyframe_block",
  [sym_from] = "from",
  [sym_supports_statement] = "supports_statement",
  [sym_at_rule] = "at_rule",
  [sym_use_statement] = "use_statement",
  [sym_forward_statement] = "forward_statement",
  [sym_apply_statement] = "apply_statement",
  [sym_parameters] = "parameters",
  [sym_parameter] = "parameter",
  [sym_mixin_statement] = "mixin_statement",
  [sym_include_statement] = "include_statement",
  [sym_include_arguments] = "arguments",
  [sym_include_argument] = "argument",
  [sym_placeholder] = "placeholder",
  [sym_extend_statement] = "extend_statement",
  [sym_if_statement] = "if_statement",
  [sym_if_clause] = "if_clause",
  [sym_else_if_clause] = "else_if_clause",
  [sym_else_clause] = "else_clause",
  [sym_each_statement] = "each_statement",
  [sym_for_statement] = "for_statement",
  [sym_while_statement] = "while_statement",
  [sym_function_statement] = "function_statement",
  [sym_return_statement] = "return_statement",
  [sym_at_root_statement] = "at_root_statement",
  [sym_error_statement] = "error_statement",
  [sym_warn_statement] = "warn_statement",
  [sym_debug_statement] = "debug_statement",
  [sym_rule_set] = "rule_set",
  [sym_selectors] = "selectors",
  [sym_block] = "block",
  [sym__selector] = "_selector",
  [sym_universal_selector] = "universal_selector",
  [sym_class_selector] = "class_selector",
  [sym_pseudo_class_selector] = "pseudo_class_selector",
  [sym_pseudo_element_selector] = "pseudo_element_selector",
  [sym_id_selector] = "id_selector",
  [sym_attribute_selector] = "attribute_selector",
  [sym_child_selector] = "child_selector",
  [sym_descendant_selector] = "descendant_selector",
  [sym_sibling_selector] = "sibling_selector",
  [sym_adjacent_sibling_selector] = "adjacent_sibling_selector",
  [sym_pseudo_class_arguments] = "arguments",
  [sym_declaration] = "declaration",
  [sym_last_declaration] = "declaration",
  [sym__query] = "_query",
  [sym_feature_query] = "feature_query",
  [sym_parenthesized_query] = "parenthesized_query",
  [sym_binary_query] = "binary_query",
  [sym_unary_query] = "unary_query",
  [sym_selector_query] = "selector_query",
  [sym__value] = "_value",
  [sym_parenthesized_value] = "parenthesized_value",
  [sym_color_value] = "color_value",
  [sym_integer_value] = "integer_value",
  [sym_float_value] = "float_value",
  [sym_call_expression] = "call_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_arguments] = "arguments",
  [aux_sym_stylesheet_repeat1] = "stylesheet_repeat1",
  [aux_sym_import_statement_repeat1] = "import_statement_repeat1",
  [aux_sym_keyframe_block_list_repeat1] = "keyframe_block_list_repeat1",
  [aux_sym_apply_statement_repeat1] = "apply_statement_repeat1",
  [aux_sym_parameters_repeat1] = "parameters_repeat1",
  [aux_sym_include_arguments_repeat1] = "include_arguments_repeat1",
  [aux_sym_if_statement_repeat1] = "if_statement_repeat1",
  [aux_sym_selectors_repeat1] = "selectors_repeat1",
  [aux_sym_block_repeat1] = "block_repeat1",
  [aux_sym_pseudo_class_arguments_repeat1] = "pseudo_class_arguments_repeat1",
  [aux_sym_declaration_repeat1] = "declaration_repeat1",
  [aux_sym_arguments_repeat1] = "arguments_repeat1",
  [alias_sym_argument_name] = "argument_name",
  [alias_sym_argument_value] = "argument_value",
  [alias_sym_attribute_name] = "attribute_name",
  [alias_sym_class_name] = "class_name",
  [alias_sym_condition] = "condition",
  [alias_sym_default_value] = "default_value",
  [alias_sym_feature_name] = "feature_name",
  [alias_sym_function_name] = "function_name",
  [alias_sym_id_name] = "id_name",
  [alias_sym_key] = "key",
  [alias_sym_keyframes_name] = "keyframes_name",
  [alias_sym_keyword_query] = "keyword_query",
  [alias_sym_name] = "name",
  [alias_sym_namespace_name] = "namespace_name",
  [alias_sym_property_name] = "property_name",
  [alias_sym_tag_name] = "tag_name",
  [alias_sym_through] = "through",
  [alias_sym_value] = "value",
  [alias_sym_variable] = "variable",
  [alias_sym_variable_value] = "variable_value",
};

static TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [anon_sym_ATimport] = anon_sym_ATimport,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_ATmedia] = anon_sym_ATmedia,
  [anon_sym_ATcharset] = anon_sym_ATcharset,
  [anon_sym_ATnamespace] = anon_sym_ATnamespace,
  [anon_sym_ATkeyframes] = anon_sym_ATkeyframes,
  [aux_sym_keyframes_statement_token1] = sym_at_keyword,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_from] = anon_sym_from,
  [sym_to] = sym_to,
  [anon_sym_ATsupports] = anon_sym_ATsupports,
  [anon_sym_ATuse] = anon_sym_ATuse,
  [anon_sym_ATforward] = anon_sym_ATforward,
  [anon_sym_ATapply] = anon_sym_ATapply,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_ATmixin] = anon_sym_ATmixin,
  [anon_sym_ATinclude] = anon_sym_ATinclude,
  [anon_sym_LPAREN2] = anon_sym_LPAREN,
  [anon_sym_RPAREN2] = anon_sym_RPAREN,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_ATextend] = anon_sym_ATextend,
  [anon_sym_ATif] = anon_sym_ATif,
  [anon_sym_ATelse] = anon_sym_ATelse,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_ATeach] = anon_sym_ATeach,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_ATfor] = anon_sym_ATfor,
  [anon_sym_through] = anon_sym_through,
  [anon_sym_ATwhile] = anon_sym_ATwhile,
  [anon_sym_ATfunction] = anon_sym_ATfunction,
  [anon_sym_ATreturn] = anon_sym_ATreturn,
  [anon_sym_ATat_DASHroot] = anon_sym_ATat_DASHroot,
  [anon_sym_ATerror] = anon_sym_ATerror,
  [anon_sym_ATwarn] = anon_sym_ATwarn,
  [anon_sym_ATdebug] = anon_sym_ATdebug,
  [sym_nesting_selector] = sym_nesting_selector,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [anon_sym_POUND] = anon_sym_POUND,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_TILDE_EQ] = anon_sym_TILDE_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_DOLLAR_EQ] = anon_sym_DOLLAR_EQ,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [sym_important] = sym_important,
  [anon_sym_and] = anon_sym_and,
  [anon_sym_or] = anon_sym_or,
  [anon_sym_not] = anon_sym_not,
  [anon_sym_only] = anon_sym_only,
  [anon_sym_selector] = anon_sym_selector,
  [aux_sym_color_value_token1] = aux_sym_color_value_token1,
  [sym_string_value] = sym_string_value,
  [aux_sym_integer_value_token1] = aux_sym_integer_value_token1,
  [aux_sym_float_value_token1] = aux_sym_float_value_token1,
  [sym_unit] = sym_unit,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [sym_identifier] = sym_identifier,
  [sym_variable_identifier] = sym_variable_identifier,
  [sym_at_keyword] = sym_at_keyword,
  [sym_comment] = sym_comment,
  [sym_single_line_comment] = sym_single_line_comment,
  [sym_plain_value] = sym_plain_value,
  [sym__descendant_operator] = sym__descendant_operator,
  [sym_stylesheet] = sym_stylesheet,
  [sym_import_statement] = sym_import_statement,
  [sym_media_statement] = sym_media_statement,
  [sym_charset_statement] = sym_charset_statement,
  [sym_namespace_statement] = sym_namespace_statement,
  [sym_keyframes_statement] = sym_keyframes_statement,
  [sym_keyframe_block_list] = sym_keyframe_block_list,
  [sym_keyframe_block] = sym_keyframe_block,
  [sym_from] = sym_from,
  [sym_supports_statement] = sym_supports_statement,
  [sym_at_rule] = sym_at_rule,
  [sym_use_statement] = sym_use_statement,
  [sym_forward_statement] = sym_forward_statement,
  [sym_apply_statement] = sym_apply_statement,
  [sym_parameters] = sym_parameters,
  [sym_parameter] = sym_parameter,
  [sym_mixin_statement] = sym_mixin_statement,
  [sym_include_statement] = sym_include_statement,
  [sym_include_arguments] = sym_arguments,
  [sym_include_argument] = sym_include_argument,
  [sym_placeholder] = sym_placeholder,
  [sym_extend_statement] = sym_extend_statement,
  [sym_if_statement] = sym_if_statement,
  [sym_if_clause] = sym_if_clause,
  [sym_else_if_clause] = sym_else_if_clause,
  [sym_else_clause] = sym_else_clause,
  [sym_each_statement] = sym_each_statement,
  [sym_for_statement] = sym_for_statement,
  [sym_while_statement] = sym_while_statement,
  [sym_function_statement] = sym_function_statement,
  [sym_return_statement] = sym_return_statement,
  [sym_at_root_statement] = sym_at_root_statement,
  [sym_error_statement] = sym_error_statement,
  [sym_warn_statement] = sym_warn_statement,
  [sym_debug_statement] = sym_debug_statement,
  [sym_rule_set] = sym_rule_set,
  [sym_selectors] = sym_selectors,
  [sym_block] = sym_block,
  [sym__selector] = sym__selector,
  [sym_universal_selector] = sym_universal_selector,
  [sym_class_selector] = sym_class_selector,
  [sym_pseudo_class_selector] = sym_pseudo_class_selector,
  [sym_pseudo_element_selector] = sym_pseudo_element_selector,
  [sym_id_selector] = sym_id_selector,
  [sym_attribute_selector] = sym_attribute_selector,
  [sym_child_selector] = sym_child_selector,
  [sym_descendant_selector] = sym_descendant_selector,
  [sym_sibling_selector] = sym_sibling_selector,
  [sym_adjacent_sibling_selector] = sym_adjacent_sibling_selector,
  [sym_pseudo_class_arguments] = sym_arguments,
  [sym_declaration] = sym_declaration,
  [sym_last_declaration] = sym_declaration,
  [sym__query] = sym__query,
  [sym_feature_query] = sym_feature_query,
  [sym_parenthesized_query] = sym_parenthesized_query,
  [sym_binary_query] = sym_binary_query,
  [sym_unary_query] = sym_unary_query,
  [sym_selector_query] = sym_selector_query,
  [sym__value] = sym__value,
  [sym_parenthesized_value] = sym_parenthesized_value,
  [sym_color_value] = sym_color_value,
  [sym_integer_value] = sym_integer_value,
  [sym_float_value] = sym_float_value,
  [sym_call_expression] = sym_call_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_arguments] = sym_arguments,
  [aux_sym_stylesheet_repeat1] = aux_sym_stylesheet_repeat1,
  [aux_sym_import_statement_repeat1] = aux_sym_import_statement_repeat1,
  [aux_sym_keyframe_block_list_repeat1] = aux_sym_keyframe_block_list_repeat1,
  [aux_sym_apply_statement_repeat1] = aux_sym_apply_statement_repeat1,
  [aux_sym_parameters_repeat1] = aux_sym_parameters_repeat1,
  [aux_sym_include_arguments_repeat1] = aux_sym_include_arguments_repeat1,
  [aux_sym_if_statement_repeat1] = aux_sym_if_statement_repeat1,
  [aux_sym_selectors_repeat1] = aux_sym_selectors_repeat1,
  [aux_sym_block_repeat1] = aux_sym_block_repeat1,
  [aux_sym_pseudo_class_arguments_repeat1] = aux_sym_pseudo_class_arguments_repeat1,
  [aux_sym_declaration_repeat1] = aux_sym_declaration_repeat1,
  [aux_sym_arguments_repeat1] = aux_sym_arguments_repeat1,
  [alias_sym_argument_name] = alias_sym_argument_name,
  [alias_sym_argument_value] = alias_sym_argument_value,
  [alias_sym_attribute_name] = alias_sym_attribute_name,
  [alias_sym_class_name] = alias_sym_class_name,
  [alias_sym_condition] = alias_sym_condition,
  [alias_sym_default_value] = alias_sym_default_value,
  [alias_sym_feature_name] = alias_sym_feature_name,
  [alias_sym_function_name] = alias_sym_function_name,
  [alias_sym_id_name] = alias_sym_id_name,
  [alias_sym_key] = alias_sym_key,
  [alias_sym_keyframes_name] = alias_sym_keyframes_name,
  [alias_sym_keyword_query] = alias_sym_keyword_query,
  [alias_sym_name] = alias_sym_name,
  [alias_sym_namespace_name] = alias_sym_namespace_name,
  [alias_sym_property_name] = alias_sym_property_name,
  [alias_sym_tag_name] = alias_sym_tag_name,
  [alias_sym_through] = alias_sym_through,
  [alias_sym_value] = alias_sym_value,
  [alias_sym_variable] = alias_sym_variable,
  [alias_sym_variable_value] = alias_sym_variable_value,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_ATimport] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATmedia] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATcharset] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATnamespace] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATkeyframes] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_keyframes_statement_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_from] = {
    .visible = true,
    .named = false,
  },
  [sym_to] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ATsupports] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATuse] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATforward] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATapply] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATmixin] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATinclude] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATextend] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATif] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATelse] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATeach] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATfor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_through] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATwhile] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATfunction] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATreturn] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATat_DASHroot] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATerror] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATwarn] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ATdebug] = {
    .visible = true,
    .named = false,
  },
  [sym_nesting_selector] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [sym_important] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_and] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_not] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_only] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_selector] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_color_value_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_string_value] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_integer_value_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_float_value_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_unit] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_at_keyword] = {
    .visible = true,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_single_line_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_plain_value] = {
    .visible = true,
    .named = true,
  },
  [sym__descendant_operator] = {
    .visible = false,
    .named = true,
  },
  [sym_stylesheet] = {
    .visible = true,
    .named = true,
  },
  [sym_import_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_media_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_charset_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_namespace_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_keyframes_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_keyframe_block_list] = {
    .visible = true,
    .named = true,
  },
  [sym_keyframe_block] = {
    .visible = true,
    .named = true,
  },
  [sym_from] = {
    .visible = true,
    .named = true,
  },
  [sym_supports_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_at_rule] = {
    .visible = true,
    .named = true,
  },
  [sym_use_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_forward_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_apply_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_mixin_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_include_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_include_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_include_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_placeholder] = {
    .visible = true,
    .named = true,
  },
  [sym_extend_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_if_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_else_if_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_else_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_each_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_function_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_at_root_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_error_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_warn_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_debug_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_rule_set] = {
    .visible = true,
    .named = true,
  },
  [sym_selectors] = {
    .visible = true,
    .named = true,
  },
  [sym_block] = {
    .visible = true,
    .named = true,
  },
  [sym__selector] = {
    .visible = false,
    .named = true,
  },
  [sym_universal_selector] = {
    .visible = true,
    .named = true,
  },
  [sym_class_selector] = {
    .visible = true,
    .named = true,
  },
  [sym_pseudo_class_selector] = {
    .visible = true,
    .named = true,
  },
  [sym_pseudo_element_selector] = {
    .visible = true,
    .named = true,
  },
  [sym_id_selector] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute_selector] = {
    .visible = true,
    .named = true,
  },
  [sym_child_selector] = {
    .visible = true,
    .named = true,
  },
  [sym_descendant_selector] = {
    .visible = true,
    .named = true,
  },
  [sym_sibling_selector] = {
    .visible = true,
    .named = true,
  },
  [sym_adjacent_sibling_selector] = {
    .visible = true,
    .named = true,
  },
  [sym_pseudo_class_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_last_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__query] = {
    .visible = false,
    .named = true,
  },
  [sym_feature_query] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_query] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_query] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_query] = {
    .visible = true,
    .named = true,
  },
  [sym_selector_query] = {
    .visible = true,
    .named = true,
  },
  [sym__value] = {
    .visible = false,
    .named = true,
  },
  [sym_parenthesized_value] = {
    .visible = true,
    .named = true,
  },
  [sym_color_value] = {
    .visible = true,
    .named = true,
  },
  [sym_integer_value] = {
    .visible = true,
    .named = true,
  },
  [sym_float_value] = {
    .visible = true,
    .named = true,
  },
  [sym_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_stylesheet_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_import_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_keyframe_block_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_apply_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_include_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_selectors_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pseudo_class_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_argument_name] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_argument_value] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_attribute_name] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_class_name] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_condition] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_default_value] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_feature_name] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_function_name] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_id_name] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_key] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_keyframes_name] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_keyword_query] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_name] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_namespace_name] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_property_name] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_tag_name] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_through] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_value] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_variable] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_variable_value] = {
    .visible = true,
    .named = true,
  },
};

static TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = alias_sym_tag_name,
  },
  [2] = {
    [0] = sym_plain_value,
  },
  [3] = {
    [0] = alias_sym_variable_value,
  },
  [4] = {
    [0] = alias_sym_keyword_query,
  },
  [5] = {
    [1] = alias_sym_class_name,
  },
  [6] = {
    [1] = alias_sym_tag_name,
  },
  [7] = {
    [1] = alias_sym_id_name,
  },
  [8] = {
    [0] = alias_sym_function_name,
  },
  [9] = {
    [1] = alias_sym_keyframes_name,
  },
  [10] = {
    [1] = alias_sym_name,
  },
  [11] = {
    [1] = alias_sym_condition,
  },
  [12] = {
    [1] = alias_sym_attribute_name,
  },
  [13] = {
    [2] = alias_sym_class_name,
  },
  [14] = {
    [2] = alias_sym_tag_name,
  },
  [15] = {
    [2] = alias_sym_id_name,
  },
  [16] = {
    [1] = alias_sym_namespace_name,
  },
  [17] = {
    [0] = alias_sym_argument_value,
  },
  [18] = {
    [0] = alias_sym_property_name,
  },
  [19] = {
    [2] = alias_sym_attribute_name,
  },
  [20] = {
    [1] = alias_sym_value,
  },
  [21] = {
    [2] = alias_sym_condition,
  },
  [22] = {
    [1] = alias_sym_feature_name,
  },
  [23] = {
    [2] = alias_sym_default_value,
  },
  [24] = {
    [0] = alias_sym_argument_name,
    [2] = alias_sym_argument_value,
  },
  [25] = {
    [1] = alias_sym_key,
    [3] = alias_sym_value,
  },
  [26] = {
    [1] = alias_sym_variable,
    [3] = sym_from,
    [5] = alias_sym_through,
  },
};

static uint16_t ts_non_terminal_alias_map[] = {
  sym__value, 6,
    sym__value,
    alias_sym_argument_value,
    alias_sym_condition,
    alias_sym_default_value,
    alias_sym_through,
    sym_from,
  0,
};

static inline bool sym_identifier_character_set_1(int32_t c) {
  return (c < ','
    ? (c < '&'
      ? (c < '$'
        ? c == ' '
        : c <= '$')
      : (c <= '&' || (c >= '(' && c <= ')')))
    : (c <= '.' || (c < '_'
      ? (c < 'A'
        ? (c >= '0' && c <= '9')
        : c <= 'Z')
      : (c <= '_' || (c >= 'a' && c <= 'z')))));
}

static inline bool sym_single_line_comment_character_set_1(int32_t c) {
  return (c < ';'
    ? (c < ' '
      ? (c < '\r'
        ? c == '\t'
        : c <= '\r')
      : (c <= '!' || (c < ','
        ? (c >= '(' && c <= ')')
        : c <= ',')))
    : (c <= ';' || (c < '{'
      ? (c < ']'
        ? c == '['
        : c <= ']')
      : (c <= '{' || c == '}'))));
}

static inline bool sym_single_line_comment_character_set_2(int32_t c) {
  return (c < ';'
    ? (c < ' '
      ? (c < '\r'
        ? c == '\t'
        : c <= '\r')
      : (c <= '!' || (c < ','
        ? (c >= '(' && c <= '*')
        : c <= ',')))
    : (c <= ';' || (c < '{'
      ? (c < ']'
        ? c == '['
        : c <= ']')
      : (c <= '{' || c == '}'))));
}

static inline bool sym_plain_value_character_set_1(int32_t c) {
  return (c < ','
    ? (c < '\r'
      ? (c < '\t'
        ? c == 0
        : c <= '\n')
      : (c <= '\r' || (c < '('
        ? (c >= ' ' && c <= '!')
        : c <= '*')))
    : (c <= ',' || (c < ']'
      ? (c < '['
        ? c == ';'
        : c <= '[')
      : (c <= ']' || (c < '}'
        ? c == '{'
        : c <= '}')))));
}

static inline bool sym_plain_value_character_set_2(int32_t c) {
  return (c < ','
    ? (c < '\r'
      ? (c < '\t'
        ? c == 0
        : c <= '\n')
      : (c <= '\r' || (c < '('
        ? (c >= ' ' && c <= '!')
        : c <= ')')))
    : (c <= ',' || (c < ']'
      ? (c < '['
        ? c == ';'
        : c <= '[')
      : (c <= ']' || (c < '}'
        ? c == '{'
        : c <= '}')))));
}

static inline bool sym_plain_value_character_set_3(int32_t c) {
  return (c < ','
    ? (c < '\r'
      ? (c < '\t'
        ? c == 0
        : c <= '\n')
      : (c <= '\r' || (c < '('
        ? (c >= ' ' && c <= '!')
        : c <= ')')))
    : (c <= ',' || (c < ']'
      ? (c < '['
        ? c == ';'
        : c <= '[')
      : (c <= ']' || c == '}'))));
}

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(102);
      if (lookahead == '!') ADVANCE(36);
      if (lookahead == '"') ADVANCE(22);
      if (lookahead == '#') ADVANCE(151);
      if (lookahead == '$') ADVANCE(37);
      if (lookahead == '%') ADVANCE(127);
      if (lookahead == '&') ADVANCE(145);
      if (lookahead == '\'') ADVANCE(27);
      if (lookahead == '(') ADVANCE(125);
      if (lookahead == ')') ADVANCE(126);
      if (lookahead == '*') ADVANCE(147);
      if (lookahead == '+') ADVANCE(167);
      if (lookahead == ',') ADVANCE(104);
      if (lookahead == '-') ADVANCE(245);
      if (lookahead == '.') ADVANCE(149);
      if (lookahead == '/') ADVANCE(248);
      if (lookahead == ':') ADVANCE(122);
      if (lookahead == ';') ADVANCE(105);
      if (lookahead == '<') ADVANCE(251);
      if (lookahead == '=') ADVANCE(155);
      if (lookahead == '>') ADVANCE(163);
      if (lookahead == '@') ADVANCE(43);
      if (lookahead == '[') ADVANCE(153);
      if (lookahead == ']') ADVANCE(161);
      if (lookahead == '^') ADVANCE(40);
      if (lookahead == 'a') ADVANCE(63);
      if (lookahead == 'f') ADVANCE(76);
      if (lookahead == 'i') ADVANCE(53);
      if (lookahead == 'n') ADVANCE(66);
      if (lookahead == 'o') ADVANCE(64);
      if (lookahead == 's') ADVANCE(52);
      if (lookahead == 't') ADVANCE(56);
      if (lookahead == '{') ADVANCE(111);
      if (lookahead == '|') ADVANCE(41);
      if (lookahead == '}') ADVANCE(112);
      if (lookahead == '~') ADVANCE(165);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(31);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(98)
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('b' <= lookahead && lookahead <= 'd')) ADVANCE(91);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(215);
      END_STATE();
    case 1:
      if (lookahead == '!') ADVANCE(36);
      if (lookahead == '"') ADVANCE(22);
      if (lookahead == '#') ADVANCE(152);
      if (lookahead == '$') ADVANCE(92);
      if (lookahead == '%') ADVANCE(243);
      if (lookahead == '\'') ADVANCE(27);
      if (lookahead == '(') ADVANCE(119);
      if (lookahead == ')') ADVANCE(120);
      if (lookahead == '*') ADVANCE(146);
      if (lookahead == '+') ADVANCE(167);
      if (lookahead == ',') ADVANCE(104);
      if (lookahead == '-') ADVANCE(246);
      if (lookahead == '.') ADVANCE(87);
      if (lookahead == '/') ADVANCE(249);
      if (lookahead == ';') ADVANCE(105);
      if (lookahead == '<') ADVANCE(251);
      if (lookahead == '=') ADVANCE(39);
      if (lookahead == '>') ADVANCE(163);
      if (lookahead == '_') ADVANCE(255);
      if (lookahead == '}') ADVANCE(112);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(234);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(4)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(213);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(235);
      END_STATE();
    case 2:
      if (lookahead == '!') ADVANCE(36);
      if (lookahead == '"') ADVANCE(22);
      if (lookahead == '#') ADVANCE(152);
      if (lookahead == '$') ADVANCE(92);
      if (lookahead == '&') ADVANCE(145);
      if (lookahead == '\'') ADVANCE(27);
      if (lookahead == '(') ADVANCE(125);
      if (lookahead == ')') ADVANCE(120);
      if (lookahead == '*') ADVANCE(146);
      if (lookahead == '+') ADVANCE(167);
      if (lookahead == ',') ADVANCE(104);
      if (lookahead == '-') ADVANCE(246);
      if (lookahead == '.') ADVANCE(149);
      if (lookahead == '/') ADVANCE(249);
      if (lookahead == ':') ADVANCE(122);
      if (lookahead == ';') ADVANCE(105);
      if (lookahead == '<') ADVANCE(251);
      if (lookahead == '=') ADVANCE(39);
      if (lookahead == '>') ADVANCE(163);
      if (lookahead == '[') ADVANCE(153);
      if (lookahead == '_') ADVANCE(255);
      if (lookahead == '}') ADVANCE(112);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(273);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(3)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(213);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(275);
      END_STATE();
    case 3:
      if (lookahead == '!') ADVANCE(36);
      if (lookahead == '"') ADVANCE(22);
      if (lookahead == '#') ADVANCE(152);
      if (lookahead == '$') ADVANCE(92);
      if (lookahead == '&') ADVANCE(145);
      if (lookahead == '\'') ADVANCE(27);
      if (lookahead == '(') ADVANCE(119);
      if (lookahead == ')') ADVANCE(120);
      if (lookahead == '*') ADVANCE(146);
      if (lookahead == '+') ADVANCE(167);
      if (lookahead == ',') ADVANCE(104);
      if (lookahead == '-') ADVANCE(246);
      if (lookahead == '.') ADVANCE(149);
      if (lookahead == '/') ADVANCE(249);
      if (lookahead == ':') ADVANCE(122);
      if (lookahead == ';') ADVANCE(105);
      if (lookahead == '<') ADVANCE(251);
      if (lookahead == '=') ADVANCE(39);
      if (lookahead == '>') ADVANCE(163);
      if (lookahead == '[') ADVANCE(153);
      if (lookahead == '_') ADVANCE(255);
      if (lookahead == '}') ADVANCE(112);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(273);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(3)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(213);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(275);
      END_STATE();
    case 4:
      if (lookahead == '!') ADVANCE(36);
      if (lookahead == '"') ADVANCE(22);
      if (lookahead == '#') ADVANCE(152);
      if (lookahead == '$') ADVANCE(92);
      if (lookahead == '\'') ADVANCE(27);
      if (lookahead == '(') ADVANCE(119);
      if (lookahead == ')') ADVANCE(120);
      if (lookahead == '*') ADVANCE(146);
      if (lookahead == '+') ADVANCE(167);
      if (lookahead == ',') ADVANCE(104);
      if (lookahead == '-') ADVANCE(246);
      if (lookahead == '.') ADVANCE(87);
      if (lookahead == '/') ADVANCE(249);
      if (lookahead == ';') ADVANCE(105);
      if (lookahead == '<') ADVANCE(251);
      if (lookahead == '=') ADVANCE(39);
      if (lookahead == '>') ADVANCE(163);
      if (lookahead == '_') ADVANCE(255);
      if (lookahead == '}') ADVANCE(112);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(273);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(4)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(213);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(275);
      END_STATE();
    case 5:
      if (lookahead == '!') ADVANCE(35);
      if (lookahead == '#') ADVANCE(151);
      if (lookahead == '&') ADVANCE(145);
      if (lookahead == '(') ADVANCE(125);
      if (lookahead == ')') ADVANCE(120);
      if (lookahead == '*') ADVANCE(146);
      if (lookahead == '+') ADVANCE(166);
      if (lookahead == ',') ADVANCE(104);
      if (lookahead == '-') ADVANCE(244);
      if (lookahead == '.') ADVANCE(148);
      if (lookahead == '/') ADVANCE(248);
      if (lookahead == ':') ADVANCE(122);
      if (lookahead == ';') ADVANCE(105);
      if (lookahead == '<') ADVANCE(251);
      if (lookahead == '=') ADVANCE(39);
      if (lookahead == '>') ADVANCE(163);
      if (lookahead == '[') ADVANCE(153);
      if (lookahead == ']') ADVANCE(161);
      if (lookahead == 'a') ADVANCE(63);
      if (lookahead == 'o') ADVANCE(73);
      if (lookahead == 't') ADVANCE(55);
      if (lookahead == '{') ADVANCE(111);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(6)
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('b' <= lookahead && lookahead <= 'f')) ADVANCE(91);
      END_STATE();
    case 6:
      if (lookahead == '!') ADVANCE(35);
      if (lookahead == '#') ADVANCE(151);
      if (lookahead == '&') ADVANCE(145);
      if (lookahead == ')') ADVANCE(120);
      if (lookahead == '*') ADVANCE(146);
      if (lookahead == '+') ADVANCE(166);
      if (lookahead == ',') ADVANCE(104);
      if (lookahead == '-') ADVANCE(244);
      if (lookahead == '.') ADVANCE(148);
      if (lookahead == '/') ADVANCE(248);
      if (lookahead == ':') ADVANCE(122);
      if (lookahead == ';') ADVANCE(105);
      if (lookahead == '<') ADVANCE(251);
      if (lookahead == '=') ADVANCE(39);
      if (lookahead == '>') ADVANCE(163);
      if (lookahead == '[') ADVANCE(153);
      if (lookahead == ']') ADVANCE(161);
      if (lookahead == 'a') ADVANCE(62);
      if (lookahead == 'o') ADVANCE(73);
      if (lookahead == 't') ADVANCE(55);
      if (lookahead == '{') ADVANCE(111);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(6)
      END_STATE();
    case 7:
      if (lookahead == '!') ADVANCE(35);
      if (lookahead == '#') ADVANCE(85);
      if (lookahead == '%') ADVANCE(243);
      if (lookahead == '(') ADVANCE(119);
      if (lookahead == '*') ADVANCE(146);
      if (lookahead == '+') ADVANCE(166);
      if (lookahead == '-') ADVANCE(247);
      if (lookahead == '/') ADVANCE(248);
      if (lookahead == ';') ADVANCE(105);
      if (lookahead == '<') ADVANCE(251);
      if (lookahead == '=') ADVANCE(39);
      if (lookahead == '>') ADVANCE(163);
      if (lookahead == '_') ADVANCE(272);
      if (lookahead == 'n') ADVANCE(227);
      if (lookahead == 'o') ADVANCE(226);
      if (lookahead == 's') ADVANCE(223);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(10)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(233);
      END_STATE();
    case 8:
      if (lookahead == '!') ADVANCE(35);
      if (lookahead == '#') ADVANCE(85);
      if (lookahead == '(') ADVANCE(125);
      if (lookahead == '*') ADVANCE(146);
      if (lookahead == '+') ADVANCE(166);
      if (lookahead == '-') ADVANCE(247);
      if (lookahead == '/') ADVANCE(248);
      if (lookahead == ';') ADVANCE(105);
      if (lookahead == '<') ADVANCE(251);
      if (lookahead == '=') ADVANCE(39);
      if (lookahead == '>') ADVANCE(163);
      if (lookahead == 'n') ADVANCE(264);
      if (lookahead == 'o') ADVANCE(263);
      if (lookahead == 's') ADVANCE(260);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(10)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(272);
      END_STATE();
    case 9:
      if (lookahead == '!') ADVANCE(35);
      if (lookahead == '#') ADVANCE(85);
      if (lookahead == '(') ADVANCE(119);
      if (lookahead == '*') ADVANCE(146);
      if (lookahead == '+') ADVANCE(166);
      if (lookahead == '-') ADVANCE(247);
      if (lookahead == '/') ADVANCE(248);
      if (lookahead == ';') ADVANCE(105);
      if (lookahead == '<') ADVANCE(251);
      if (lookahead == '=') ADVANCE(39);
      if (lookahead == '>') ADVANCE(163);
      if (lookahead == 'n') ADVANCE(264);
      if (lookahead == 'o') ADVANCE(263);
      if (lookahead == 's') ADVANCE(260);
      if (lookahead == '{') ADVANCE(111);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(9)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(272);
      END_STATE();
    case 10:
      if (lookahead == '!') ADVANCE(35);
      if (lookahead == '#') ADVANCE(85);
      if (lookahead == '(') ADVANCE(119);
      if (lookahead == '*') ADVANCE(146);
      if (lookahead == '+') ADVANCE(166);
      if (lookahead == '-') ADVANCE(247);
      if (lookahead == '/') ADVANCE(248);
      if (lookahead == ';') ADVANCE(105);
      if (lookahead == '<') ADVANCE(251);
      if (lookahead == '=') ADVANCE(39);
      if (lookahead == '>') ADVANCE(163);
      if (lookahead == 'n') ADVANCE(264);
      if (lookahead == 'o') ADVANCE(263);
      if (lookahead == 's') ADVANCE(260);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(10)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(272);
      END_STATE();
    case 11:
      if (lookahead == '!') ADVANCE(35);
      if (lookahead == '(') ADVANCE(125);
      if (lookahead == ')') ADVANCE(126);
      if (lookahead == '*') ADVANCE(146);
      if (lookahead == '+') ADVANCE(166);
      if (lookahead == ',') ADVANCE(104);
      if (lookahead == '-') ADVANCE(244);
      if (lookahead == '/') ADVANCE(248);
      if (lookahead == ':') ADVANCE(121);
      if (lookahead == '<') ADVANCE(251);
      if (lookahead == '=') ADVANCE(39);
      if (lookahead == '>') ADVANCE(163);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(14)
      if (lookahead == '%' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(243);
      END_STATE();
    case 12:
      if (lookahead == '!') ADVANCE(35);
      if (lookahead == ')') ADVANCE(120);
      if (lookahead == '*') ADVANCE(146);
      if (lookahead == '+') ADVANCE(166);
      if (lookahead == ',') ADVANCE(104);
      if (lookahead == '-') ADVANCE(244);
      if (lookahead == '/') ADVANCE(248);
      if (lookahead == ';') ADVANCE(105);
      if (lookahead == '<') ADVANCE(251);
      if (lookahead == '=') ADVANCE(39);
      if (lookahead == '>') ADVANCE(163);
      if (lookahead == ']') ADVANCE(161);
      if (lookahead == '{') ADVANCE(111);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(12)
      END_STATE();
    case 13:
      if (lookahead == '!') ADVANCE(35);
      if (lookahead == ')') ADVANCE(120);
      if (lookahead == '*') ADVANCE(146);
      if (lookahead == '+') ADVANCE(166);
      if (lookahead == ',') ADVANCE(104);
      if (lookahead == '-') ADVANCE(244);
      if (lookahead == '/') ADVANCE(248);
      if (lookahead == ';') ADVANCE(105);
      if (lookahead == '<') ADVANCE(251);
      if (lookahead == '=') ADVANCE(39);
      if (lookahead == '>') ADVANCE(163);
      if (lookahead == ']') ADVANCE(161);
      if (lookahead == '{') ADVANCE(111);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(12)
      if (lookahead == '%' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(243);
      END_STATE();
    case 14:
      if (lookahead == '!') ADVANCE(35);
      if (lookahead == '*') ADVANCE(146);
      if (lookahead == '+') ADVANCE(166);
      if (lookahead == ',') ADVANCE(104);
      if (lookahead == '-') ADVANCE(244);
      if (lookahead == '/') ADVANCE(248);
      if (lookahead == ':') ADVANCE(121);
      if (lookahead == '<') ADVANCE(251);
      if (lookahead == '=') ADVANCE(39);
      if (lookahead == '>') ADVANCE(163);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(14)
      END_STATE();
    case 15:
      if (lookahead == '!') ADVANCE(35);
      if (lookahead == '*') ADVANCE(146);
      if (lookahead == '+') ADVANCE(166);
      if (lookahead == '-') ADVANCE(244);
      if (lookahead == '/') ADVANCE(248);
      if (lookahead == '<') ADVANCE(251);
      if (lookahead == '=') ADVANCE(39);
      if (lookahead == '>') ADVANCE(163);
      if (lookahead == 't') ADVANCE(238);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(16)
      if (lookahead == '%' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(243);
      END_STATE();
    case 16:
      if (lookahead == '!') ADVANCE(35);
      if (lookahead == '*') ADVANCE(146);
      if (lookahead == '+') ADVANCE(166);
      if (lookahead == '-') ADVANCE(244);
      if (lookahead == '/') ADVANCE(248);
      if (lookahead == '<') ADVANCE(251);
      if (lookahead == '=') ADVANCE(39);
      if (lookahead == '>') ADVANCE(163);
      if (lookahead == 't') ADVANCE(55);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(16)
      END_STATE();
    case 17:
      if (lookahead == '"') ADVANCE(22);
      if (lookahead == '#') ADVANCE(152);
      if (lookahead == '$') ADVANCE(92);
      if (lookahead == '&') ADVANCE(145);
      if (lookahead == '\'') ADVANCE(27);
      if (lookahead == '(') ADVANCE(119);
      if (lookahead == ')') ADVANCE(126);
      if (lookahead == '*') ADVANCE(146);
      if (lookahead == ',') ADVANCE(104);
      if (lookahead == '-') ADVANCE(93);
      if (lookahead == '.') ADVANCE(148);
      if (lookahead == '/') ADVANCE(28);
      if (lookahead == ':') ADVANCE(122);
      if (lookahead == '@') ADVANCE(48);
      if (lookahead == '[') ADVANCE(153);
      if (lookahead == '{') ADVANCE(111);
      if (lookahead == '}') ADVANCE(112);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(18)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(256);
      END_STATE();
    case 18:
      if (lookahead == '"') ADVANCE(22);
      if (lookahead == '#') ADVANCE(152);
      if (lookahead == '$') ADVANCE(92);
      if (lookahead == '&') ADVANCE(145);
      if (lookahead == '\'') ADVANCE(27);
      if (lookahead == '(') ADVANCE(119);
      if (lookahead == '*') ADVANCE(146);
      if (lookahead == ',') ADVANCE(104);
      if (lookahead == '-') ADVANCE(93);
      if (lookahead == '.') ADVANCE(148);
      if (lookahead == '/') ADVANCE(28);
      if (lookahead == ':') ADVANCE(122);
      if (lookahead == '@') ADVANCE(48);
      if (lookahead == '[') ADVANCE(153);
      if (lookahead == '{') ADVANCE(111);
      if (lookahead == '}') ADVANCE(112);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(18)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(256);
      END_STATE();
    case 19:
      if (lookahead == '"') ADVANCE(22);
      if (lookahead == '#') ADVANCE(152);
      if (lookahead == '$') ADVANCE(92);
      if (lookahead == '&') ADVANCE(145);
      if (lookahead == '\'') ADVANCE(27);
      if (lookahead == '*') ADVANCE(146);
      if (lookahead == '-') ADVANCE(93);
      if (lookahead == '.') ADVANCE(148);
      if (lookahead == '/') ADVANCE(28);
      if (lookahead == ':') ADVANCE(122);
      if (lookahead == '@') ADVANCE(47);
      if (lookahead == '[') ADVANCE(153);
      if (lookahead == '}') ADVANCE(112);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(19)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(256);
      END_STATE();
    case 20:
      if (lookahead == '"') ADVANCE(22);
      if (lookahead == '#') ADVANCE(152);
      if (lookahead == '&') ADVANCE(145);
      if (lookahead == '\'') ADVANCE(27);
      if (lookahead == '(') ADVANCE(125);
      if (lookahead == ')') ADVANCE(120);
      if (lookahead == '*') ADVANCE(146);
      if (lookahead == '+') ADVANCE(166);
      if (lookahead == ',') ADVANCE(104);
      if (lookahead == '-') ADVANCE(93);
      if (lookahead == '.') ADVANCE(148);
      if (lookahead == '/') ADVANCE(28);
      if (lookahead == ':') ADVANCE(122);
      if (lookahead == '>') ADVANCE(162);
      if (lookahead == '[') ADVANCE(153);
      if (lookahead == '{') ADVANCE(111);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(21)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(272);
      END_STATE();
    case 21:
      if (lookahead == '"') ADVANCE(22);
      if (lookahead == '#') ADVANCE(152);
      if (lookahead == '&') ADVANCE(145);
      if (lookahead == '\'') ADVANCE(27);
      if (lookahead == ')') ADVANCE(120);
      if (lookahead == '*') ADVANCE(146);
      if (lookahead == '+') ADVANCE(166);
      if (lookahead == ',') ADVANCE(104);
      if (lookahead == '-') ADVANCE(93);
      if (lookahead == '.') ADVANCE(148);
      if (lookahead == '/') ADVANCE(28);
      if (lookahead == ':') ADVANCE(122);
      if (lookahead == '>') ADVANCE(162);
      if (lookahead == '[') ADVANCE(153);
      if (lookahead == '{') ADVANCE(111);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(21)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(272);
      END_STATE();
    case 22:
      if (lookahead == '"') ADVANCE(210);
      if (lookahead == '\\') ADVANCE(96);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(22);
      END_STATE();
    case 23:
      if (lookahead == '#') ADVANCE(85);
      if (lookahead == '-') ADVANCE(93);
      if (lookahead == '/') ADVANCE(28);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(24)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(91);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(271);
      if (('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(272);
      END_STATE();
    case 24:
      if (lookahead == '#') ADVANCE(85);
      if (lookahead == '-') ADVANCE(93);
      if (lookahead == '/') ADVANCE(28);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(24)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(272);
      END_STATE();
    case 25:
      if (lookahead == '$') ADVANCE(37);
      if (lookahead == '*') ADVANCE(38);
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(89);
      if (lookahead == '/') ADVANCE(28);
      if (lookahead == '=') ADVANCE(154);
      if (lookahead == ']') ADVANCE(161);
      if (lookahead == '^') ADVANCE(40);
      if (lookahead == 'f') ADVANCE(75);
      if (lookahead == 't') ADVANCE(67);
      if (lookahead == '|') ADVANCE(41);
      if (lookahead == '}') ADVANCE(112);
      if (lookahead == '~') ADVANCE(42);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(25)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(216);
      END_STATE();
    case 26:
      if (lookahead == '$') ADVANCE(92);
      END_STATE();
    case 27:
      if (lookahead == '\'') ADVANCE(210);
      if (lookahead == '\\') ADVANCE(97);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(27);
      END_STATE();
    case 28:
      if (lookahead == '*') ADVANCE(30);
      if (lookahead == '/') ADVANCE(397);
      END_STATE();
    case 29:
      if (lookahead == '*') ADVANCE(29);
      if (lookahead == '/') ADVANCE(392);
      if (lookahead != 0) ADVANCE(30);
      END_STATE();
    case 30:
      if (lookahead == '*') ADVANCE(29);
      if (lookahead != 0) ADVANCE(30);
      END_STATE();
    case 31:
      if (lookahead == '-') ADVANCE(88);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(220);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(90);
      END_STATE();
    case 32:
      if (lookahead == '-') ADVANCE(88);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(219);
      END_STATE();
    case 33:
      if (lookahead == '-') ADVANCE(88);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(204);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(209);
      END_STATE();
    case 34:
      if (lookahead == '/') ADVANCE(94);
      if (lookahead == '-' ||
          lookahead == '_') ADVANCE(34);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(401);
      END_STATE();
    case 35:
      if (lookahead == '=') ADVANCE(252);
      END_STATE();
    case 36:
      if (lookahead == '=') ADVANCE(252);
      if (lookahead == 'i') ADVANCE(60);
      END_STATE();
    case 37:
      if (lookahead == '=') ADVANCE(160);
      END_STATE();
    case 38:
      if (lookahead == '=') ADVANCE(159);
      END_STATE();
    case 39:
      if (lookahead == '=') ADVANCE(250);
      END_STATE();
    case 40:
      if (lookahead == '=') ADVANCE(157);
      END_STATE();
    case 41:
      if (lookahead == '=') ADVANCE(158);
      END_STATE();
    case 42:
      if (lookahead == '=') ADVANCE(156);
      END_STATE();
    case 43:
      if (lookahead == 'a') ADVANCE(347);
      if (lookahead == 'c') ADVANCE(322);
      if (lookahead == 'd') ADVANCE(302);
      if (lookahead == 'e') ADVANCE(281);
      if (lookahead == 'f') ADVANCE(339);
      if (lookahead == 'i') ADVANCE(317);
      if (lookahead == 'k') ADVANCE(303);
      if (lookahead == 'm') ADVANCE(304);
      if (lookahead == 'n') ADVANCE(285);
      if (lookahead == 'r') ADVANCE(311);
      if (lookahead == 's') ADVANCE(383);
      if (lookahead == 'u') ADVANCE(370);
      if (lookahead == 'w') ADVANCE(287);
      if (lookahead == '-' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 44:
      if (lookahead == 'a') ADVANCE(65);
      END_STATE();
    case 45:
      if (lookahead == 'a') ADVANCE(348);
      if (lookahead == 'c') ADVANCE(322);
      if (lookahead == 'd') ADVANCE(302);
      if (lookahead == 'e') ADVANCE(284);
      if (lookahead == 'f') ADVANCE(339);
      if (lookahead == 'i') ADVANCE(317);
      if (lookahead == 'k') ADVANCE(303);
      if (lookahead == 'm') ADVANCE(304);
      if (lookahead == 'n') ADVANCE(285);
      if (lookahead == 's') ADVANCE(383);
      if (lookahead == 'u') ADVANCE(370);
      if (lookahead == 'w') ADVANCE(287);
      if (lookahead == '-' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 46:
      if (lookahead == 'a') ADVANCE(348);
      if (lookahead == 'c') ADVANCE(322);
      if (lookahead == 'd') ADVANCE(302);
      if (lookahead == 'e') ADVANCE(282);
      if (lookahead == 'f') ADVANCE(339);
      if (lookahead == 'i') ADVANCE(317);
      if (lookahead == 'k') ADVANCE(303);
      if (lookahead == 'm') ADVANCE(304);
      if (lookahead == 'n') ADVANCE(285);
      if (lookahead == 's') ADVANCE(383);
      if (lookahead == 'u') ADVANCE(370);
      if (lookahead == 'w') ADVANCE(287);
      if (lookahead == '-' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 47:
      if (lookahead == 'a') ADVANCE(374);
      if (lookahead == 'c') ADVANCE(322);
      if (lookahead == 'd') ADVANCE(302);
      if (lookahead == 'e') ADVANCE(281);
      if (lookahead == 'f') ADVANCE(346);
      if (lookahead == 'i') ADVANCE(317);
      if (lookahead == 'k') ADVANCE(303);
      if (lookahead == 'm') ADVANCE(304);
      if (lookahead == 'n') ADVANCE(285);
      if (lookahead == 'r') ADVANCE(311);
      if (lookahead == 's') ADVANCE(383);
      if (lookahead == 'w') ADVANCE(287);
      if (lookahead == '-' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 48:
      if (lookahead == 'a') ADVANCE(374);
      if (lookahead == 'c') ADVANCE(322);
      if (lookahead == 'd') ADVANCE(302);
      if (lookahead == 'e') ADVANCE(283);
      if (lookahead == 'f') ADVANCE(346);
      if (lookahead == 'i') ADVANCE(317);
      if (lookahead == 'k') ADVANCE(303);
      if (lookahead == 'm') ADVANCE(304);
      if (lookahead == 'n') ADVANCE(285);
      if (lookahead == 'r') ADVANCE(311);
      if (lookahead == 's') ADVANCE(383);
      if (lookahead == 'w') ADVANCE(287);
      if (lookahead == '-' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 49:
      if (lookahead == 'c') ADVANCE(82);
      END_STATE();
    case 50:
      if (lookahead == 'd') ADVANCE(169);
      END_STATE();
    case 51:
      if (lookahead == 'e') ADVANCE(49);
      END_STATE();
    case 52:
      if (lookahead == 'e') ADVANCE(59);
      END_STATE();
    case 53:
      if (lookahead == 'f') ADVANCE(131);
      if (lookahead == 'n') ADVANCE(133);
      END_STATE();
    case 54:
      if (lookahead == 'g') ADVANCE(57);
      END_STATE();
    case 55:
      if (lookahead == 'h') ADVANCE(77);
      END_STATE();
    case 56:
      if (lookahead == 'h') ADVANCE(77);
      if (lookahead == 'o') ADVANCE(114);
      END_STATE();
    case 57:
      if (lookahead == 'h') ADVANCE(136);
      END_STATE();
    case 58:
      if (lookahead == 'l') ADVANCE(84);
      END_STATE();
    case 59:
      if (lookahead == 'l') ADVANCE(51);
      END_STATE();
    case 60:
      if (lookahead == 'm') ADVANCE(72);
      END_STATE();
    case 61:
      if (lookahead == 'm') ADVANCE(113);
      END_STATE();
    case 62:
      if (lookahead == 'n') ADVANCE(50);
      END_STATE();
    case 63:
      if (lookahead == 'n') ADVANCE(50);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(90);
      END_STATE();
    case 64:
      if (lookahead == 'n') ADVANCE(58);
      if (lookahead == 'r') ADVANCE(170);
      END_STATE();
    case 65:
      if (lookahead == 'n') ADVANCE(81);
      END_STATE();
    case 66:
      if (lookahead == 'o') ADVANCE(79);
      END_STATE();
    case 67:
      if (lookahead == 'o') ADVANCE(114);
      END_STATE();
    case 68:
      if (lookahead == 'o') ADVANCE(83);
      END_STATE();
    case 69:
      if (lookahead == 'o') ADVANCE(61);
      END_STATE();
    case 70:
      if (lookahead == 'o') ADVANCE(78);
      END_STATE();
    case 71:
      if (lookahead == 'o') ADVANCE(74);
      END_STATE();
    case 72:
      if (lookahead == 'p') ADVANCE(70);
      END_STATE();
    case 73:
      if (lookahead == 'r') ADVANCE(170);
      END_STATE();
    case 74:
      if (lookahead == 'r') ADVANCE(177);
      END_STATE();
    case 75:
      if (lookahead == 'r') ADVANCE(69);
      END_STATE();
    case 76:
      if (lookahead == 'r') ADVANCE(69);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(90);
      END_STATE();
    case 77:
      if (lookahead == 'r') ADVANCE(68);
      END_STATE();
    case 78:
      if (lookahead == 'r') ADVANCE(80);
      END_STATE();
    case 79:
      if (lookahead == 't') ADVANCE(171);
      END_STATE();
    case 80:
      if (lookahead == 't') ADVANCE(44);
      END_STATE();
    case 81:
      if (lookahead == 't') ADVANCE(168);
      END_STATE();
    case 82:
      if (lookahead == 't') ADVANCE(71);
      END_STATE();
    case 83:
      if (lookahead == 'u') ADVANCE(54);
      END_STATE();
    case 84:
      if (lookahead == 'y') ADVANCE(174);
      END_STATE();
    case 85:
      if (lookahead == '{') ADVANCE(86);
      END_STATE();
    case 86:
      if (lookahead == '}') ADVANCE(272);
      if (sym_identifier_character_set_1(lookahead)) ADVANCE(86);
      END_STATE();
    case 87:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(218);
      END_STATE();
    case 88:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(219);
      END_STATE();
    case 89:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(216);
      END_STATE();
    case 90:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(209);
      END_STATE();
    case 91:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(90);
      END_STATE();
    case 92:
      if (lookahead == '-' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(279);
      END_STATE();
    case 93:
      if (lookahead == '-' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(272);
      END_STATE();
    case 94:
      if (!sym_plain_value_character_set_1(lookahead)) ADVANCE(34);
      END_STATE();
    case 95:
      if (!sym_plain_value_character_set_1(lookahead)) ADVANCE(401);
      END_STATE();
    case 96:
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(22);
      if (lookahead == '"') ADVANCE(211);
      if (lookahead == '\\') ADVANCE(96);
      END_STATE();
    case 97:
      if (lookahead != 0 &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(27);
      if (lookahead == '\'') ADVANCE(212);
      if (lookahead == '\\') ADVANCE(97);
      END_STATE();
    case 98:
      if (eof) ADVANCE(102);
      if (lookahead == '!') ADVANCE(36);
      if (lookahead == '"') ADVANCE(22);
      if (lookahead == '#') ADVANCE(151);
      if (lookahead == '$') ADVANCE(37);
      if (lookahead == '%') ADVANCE(127);
      if (lookahead == '&') ADVANCE(145);
      if (lookahead == '\'') ADVANCE(27);
      if (lookahead == '(') ADVANCE(119);
      if (lookahead == ')') ADVANCE(120);
      if (lookahead == '*') ADVANCE(147);
      if (lookahead == '+') ADVANCE(167);
      if (lookahead == ',') ADVANCE(104);
      if (lookahead == '-') ADVANCE(245);
      if (lookahead == '.') ADVANCE(149);
      if (lookahead == '/') ADVANCE(248);
      if (lookahead == ':') ADVANCE(122);
      if (lookahead == ';') ADVANCE(105);
      if (lookahead == '<') ADVANCE(251);
      if (lookahead == '=') ADVANCE(155);
      if (lookahead == '>') ADVANCE(163);
      if (lookahead == '@') ADVANCE(43);
      if (lookahead == '[') ADVANCE(153);
      if (lookahead == ']') ADVANCE(161);
      if (lookahead == '^') ADVANCE(40);
      if (lookahead == 'a') ADVANCE(62);
      if (lookahead == 'f') ADVANCE(75);
      if (lookahead == 'i') ADVANCE(53);
      if (lookahead == 'n') ADVANCE(66);
      if (lookahead == 'o') ADVANCE(64);
      if (lookahead == 's') ADVANCE(52);
      if (lookahead == 't') ADVANCE(56);
      if (lookahead == '{') ADVANCE(111);
      if (lookahead == '|') ADVANCE(41);
      if (lookahead == '}') ADVANCE(112);
      if (lookahead == '~') ADVANCE(165);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(32);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(98)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(213);
      END_STATE();
    case 99:
      if (eof) ADVANCE(102);
      if (lookahead == '"') ADVANCE(22);
      if (lookahead == '#') ADVANCE(152);
      if (lookahead == '$') ADVANCE(92);
      if (lookahead == '%') ADVANCE(127);
      if (lookahead == '&') ADVANCE(145);
      if (lookahead == '\'') ADVANCE(27);
      if (lookahead == '(') ADVANCE(125);
      if (lookahead == ')') ADVANCE(120);
      if (lookahead == '*') ADVANCE(146);
      if (lookahead == '+') ADVANCE(166);
      if (lookahead == ',') ADVANCE(104);
      if (lookahead == '-') ADVANCE(93);
      if (lookahead == '.') ADVANCE(148);
      if (lookahead == '/') ADVANCE(28);
      if (lookahead == ':') ADVANCE(122);
      if (lookahead == ';') ADVANCE(105);
      if (lookahead == '>') ADVANCE(162);
      if (lookahead == '@') ADVANCE(45);
      if (lookahead == '[') ADVANCE(153);
      if (lookahead == '{') ADVANCE(111);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(100)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(256);
      END_STATE();
    case 100:
      if (eof) ADVANCE(102);
      if (lookahead == '"') ADVANCE(22);
      if (lookahead == '#') ADVANCE(152);
      if (lookahead == '$') ADVANCE(92);
      if (lookahead == '%') ADVANCE(127);
      if (lookahead == '&') ADVANCE(145);
      if (lookahead == '\'') ADVANCE(27);
      if (lookahead == ')') ADVANCE(120);
      if (lookahead == '*') ADVANCE(146);
      if (lookahead == '+') ADVANCE(166);
      if (lookahead == ',') ADVANCE(104);
      if (lookahead == '-') ADVANCE(93);
      if (lookahead == '.') ADVANCE(148);
      if (lookahead == '/') ADVANCE(28);
      if (lookahead == ':') ADVANCE(122);
      if (lookahead == ';') ADVANCE(105);
      if (lookahead == '>') ADVANCE(162);
      if (lookahead == '@') ADVANCE(45);
      if (lookahead == '[') ADVANCE(153);
      if (lookahead == '{') ADVANCE(111);
      if (lookahead == '~') ADVANCE(164);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(100)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(256);
      END_STATE();
    case 101:
      if (eof) ADVANCE(102);
      if (lookahead == '"') ADVANCE(22);
      if (lookahead == '#') ADVANCE(152);
      if (lookahead == '$') ADVANCE(92);
      if (lookahead == '%') ADVANCE(127);
      if (lookahead == '&') ADVANCE(145);
      if (lookahead == '\'') ADVANCE(27);
      if (lookahead == '*') ADVANCE(146);
      if (lookahead == '-') ADVANCE(93);
      if (lookahead == '.') ADVANCE(148);
      if (lookahead == '/') ADVANCE(28);
      if (lookahead == ':') ADVANCE(122);
      if (lookahead == '@') ADVANCE(46);
      if (lookahead == '[') ADVANCE(153);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(101)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(256);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_ATimport);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_ATmedia);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_ATcharset);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_ATnamespace);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_ATkeyframes);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(aux_sym_keyframes_statement_token1);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_from);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(sym_to);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_ATsupports);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_ATuse);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_ATforward);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_ATapply);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(150);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_ATmixin);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_ATinclude);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_LPAREN2);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_RPAREN2);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_ATextend);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_ATif);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_ATelse);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_ATeach);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_ATfor);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == 'w') ADVANCE(290);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_ATfor);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_through);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_through);
      if (lookahead == '%' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(243);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_ATwhile);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_ATfunction);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_ATreturn);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_ATat_DASHroot);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_ATerror);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_ATwarn);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_ATdebug);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(sym_nesting_selector);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '=') ADVANCE(159);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(218);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_POUND);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_POUND);
      if (lookahead == '{') ADVANCE(86);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(250);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_TILDE_EQ);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(anon_sym_DOLLAR_EQ);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(254);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(anon_sym_TILDE);
      if (lookahead == '=') ADVANCE(156);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '.') ADVANCE(87);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(32);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(213);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(sym_important);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(anon_sym_and);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_or);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(anon_sym_not);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(anon_sym_not);
      if (lookahead == '#') ADVANCE(85);
      if (lookahead == '%') ADVANCE(243);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(272);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(233);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(anon_sym_not);
      if (lookahead == '#') ADVANCE(85);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(272);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(anon_sym_only);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(anon_sym_only);
      if (lookahead == '#') ADVANCE(85);
      if (lookahead == '%') ADVANCE(243);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(272);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(233);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(anon_sym_only);
      if (lookahead == '#') ADVANCE(85);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(272);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(anon_sym_selector);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(anon_sym_selector);
      if (lookahead == '#') ADVANCE(85);
      if (lookahead == '%') ADVANCE(243);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(272);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(233);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(anon_sym_selector);
      if (lookahead == '#') ADVANCE(85);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(272);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(aux_sym_color_value_token1);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(aux_sym_color_value_token1);
      if (lookahead == '#') ADVANCE(85);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(186);
      if (lookahead == '-' ||
          ('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(272);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(aux_sym_color_value_token1);
      if (lookahead == '#') ADVANCE(85);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(181);
      if (lookahead == '-' ||
          ('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(272);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(aux_sym_color_value_token1);
      if (lookahead == '#') ADVANCE(85);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(182);
      if (lookahead == '-' ||
          ('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(272);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(aux_sym_color_value_token1);
      if (lookahead == '#') ADVANCE(85);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(183);
      if (lookahead == '-' ||
          ('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(272);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(aux_sym_color_value_token1);
      if (lookahead == '#') ADVANCE(85);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(184);
      if (lookahead == '-' ||
          ('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(272);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(aux_sym_color_value_token1);
      if (lookahead == '#') ADVANCE(85);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(272);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(aux_sym_color_value_token1);
      if (lookahead == '-') ADVANCE(88);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(219);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(aux_sym_color_value_token1);
      if (lookahead == '-') ADVANCE(88);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(199);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(180);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(aux_sym_color_value_token1);
      if (lookahead == '-') ADVANCE(88);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(202);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(206);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(aux_sym_color_value_token1);
      if (lookahead == '-') ADVANCE(88);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(200);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(205);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(aux_sym_color_value_token1);
      if (lookahead == '-') ADVANCE(88);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(201);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(207);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(aux_sym_color_value_token1);
      if (lookahead == '-') ADVANCE(88);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(203);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(208);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(aux_sym_color_value_token1);
      if (lookahead == '.') ADVANCE(87);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(32);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(213);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(aux_sym_color_value_token1);
      if (lookahead == '.') ADVANCE(87);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(187);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(180);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(193);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(aux_sym_color_value_token1);
      if (lookahead == '.') ADVANCE(87);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(189);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(207);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(196);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(aux_sym_color_value_token1);
      if (lookahead == '.') ADVANCE(87);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(190);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(206);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(197);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(aux_sym_color_value_token1);
      if (lookahead == '.') ADVANCE(87);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(188);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(205);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(194);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(aux_sym_color_value_token1);
      if (lookahead == '.') ADVANCE(87);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(191);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(208);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(195);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(aux_sym_color_value_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(219);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(aux_sym_color_value_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(199);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(180);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(aux_sym_color_value_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(202);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(206);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(aux_sym_color_value_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(200);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(205);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(aux_sym_color_value_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(201);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(207);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(aux_sym_color_value_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(203);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(208);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(aux_sym_color_value_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(180);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(aux_sym_color_value_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(205);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(aux_sym_color_value_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(206);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(aux_sym_color_value_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(207);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(aux_sym_color_value_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(208);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(sym_string_value);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(sym_string_value);
      if (lookahead == '"') ADVANCE(210);
      if (lookahead == '\\') ADVANCE(96);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(22);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(sym_string_value);
      if (lookahead == '\'') ADVANCE(210);
      if (lookahead == '\\') ADVANCE(97);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(27);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(aux_sym_integer_value_token1);
      if (lookahead == '.') ADVANCE(87);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(32);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(213);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(aux_sym_integer_value_token1);
      if (lookahead == '.') ADVANCE(87);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(192);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(209);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(198);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(aux_sym_integer_value_token1);
      if (lookahead == '.') ADVANCE(87);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(33);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(90);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(214);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(aux_sym_integer_value_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(216);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(aux_sym_float_value_token1);
      if (lookahead == '#') ADVANCE(399);
      if (lookahead == '/') ADVANCE(95);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(217);
      if (lookahead == '-' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(277);
      if (!sym_plain_value_character_set_2(lookahead)) ADVANCE(401);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(aux_sym_float_value_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(32);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(218);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(aux_sym_float_value_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(219);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(aux_sym_float_value_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(204);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(209);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(sym_unit);
      if (lookahead == '#') ADVANCE(85);
      if (lookahead == '%') ADVANCE(243);
      if (lookahead == 'c') ADVANCE(231);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(272);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(233);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(sym_unit);
      if (lookahead == '#') ADVANCE(85);
      if (lookahead == '%') ADVANCE(243);
      if (lookahead == 'e') ADVANCE(221);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(272);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(233);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(sym_unit);
      if (lookahead == '#') ADVANCE(85);
      if (lookahead == '%') ADVANCE(243);
      if (lookahead == 'e') ADVANCE(225);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(272);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(233);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(sym_unit);
      if (lookahead == '#') ADVANCE(85);
      if (lookahead == '%') ADVANCE(243);
      if (lookahead == 'l') ADVANCE(232);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(272);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(233);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(sym_unit);
      if (lookahead == '#') ADVANCE(85);
      if (lookahead == '%') ADVANCE(243);
      if (lookahead == 'l') ADVANCE(222);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(272);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(233);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(sym_unit);
      if (lookahead == '#') ADVANCE(85);
      if (lookahead == '%') ADVANCE(243);
      if (lookahead == 'n') ADVANCE(224);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(272);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(233);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(sym_unit);
      if (lookahead == '#') ADVANCE(85);
      if (lookahead == '%') ADVANCE(243);
      if (lookahead == 'o') ADVANCE(230);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(272);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(233);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(sym_unit);
      if (lookahead == '#') ADVANCE(85);
      if (lookahead == '%') ADVANCE(243);
      if (lookahead == 'o') ADVANCE(229);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(272);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(233);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(sym_unit);
      if (lookahead == '#') ADVANCE(85);
      if (lookahead == '%') ADVANCE(243);
      if (lookahead == 'r') ADVANCE(178);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(272);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(233);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(sym_unit);
      if (lookahead == '#') ADVANCE(85);
      if (lookahead == '%') ADVANCE(243);
      if (lookahead == 't') ADVANCE(172);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(272);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(233);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(sym_unit);
      if (lookahead == '#') ADVANCE(85);
      if (lookahead == '%') ADVANCE(243);
      if (lookahead == 't') ADVANCE(228);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(272);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(233);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(sym_unit);
      if (lookahead == '#') ADVANCE(85);
      if (lookahead == '%') ADVANCE(243);
      if (lookahead == 'y') ADVANCE(175);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(272);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(233);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(sym_unit);
      if (lookahead == '#') ADVANCE(85);
      if (lookahead == '%') ADVANCE(243);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(272);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(233);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(sym_unit);
      if (lookahead == '#') ADVANCE(399);
      if (lookahead == '%') ADVANCE(236);
      if (lookahead == '-') ADVANCE(276);
      if (lookahead == '.') ADVANCE(398);
      if (lookahead == '/') ADVANCE(95);
      if (lookahead == '_') ADVANCE(275);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(217);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(235);
      if (!sym_plain_value_character_set_2(lookahead)) ADVANCE(401);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(sym_unit);
      if (lookahead == '#') ADVANCE(399);
      if (lookahead == '%') ADVANCE(236);
      if (lookahead == '.') ADVANCE(398);
      if (lookahead == '/') ADVANCE(95);
      if (lookahead == '_') ADVANCE(275);
      if (('-' <= lookahead && lookahead <= '9')) ADVANCE(277);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(235);
      if (!sym_plain_value_character_set_2(lookahead)) ADVANCE(401);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(sym_unit);
      if (lookahead == '/') ADVANCE(95);
      if (lookahead == '%' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(236);
      if (!sym_plain_value_character_set_2(lookahead)) ADVANCE(401);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(sym_unit);
      if (lookahead == 'g') ADVANCE(239);
      if (lookahead == '%' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(243);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(sym_unit);
      if (lookahead == 'h') ADVANCE(241);
      if (lookahead == '%' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(243);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(sym_unit);
      if (lookahead == 'h') ADVANCE(137);
      if (lookahead == '%' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(243);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(sym_unit);
      if (lookahead == 'o') ADVANCE(242);
      if (lookahead == '%' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(243);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(sym_unit);
      if (lookahead == 'r') ADVANCE(240);
      if (lookahead == '%' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(243);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(sym_unit);
      if (lookahead == 'u') ADVANCE(237);
      if (lookahead == '%' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(243);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(sym_unit);
      if (lookahead == '%' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(243);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '.') ADVANCE(87);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(32);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(213);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-' ||
          lookahead == '_') ADVANCE(257);
      if (lookahead == '.') ADVANCE(87);
      if (lookahead == '/') ADVANCE(94);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(274);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(213);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(277);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(272);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(30);
      if (lookahead == '/') ADVANCE(397);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(30);
      if (lookahead == '/') ADVANCE(393);
      if (!sym_plain_value_character_set_2(lookahead)) ADVANCE(34);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '=') ADVANCE(253);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '#') ADVANCE(85);
      if (lookahead == '-') ADVANCE(257);
      if (lookahead == '.') ADVANCE(26);
      if (lookahead == '/') ADVANCE(94);
      if (lookahead == '_') ADVANCE(255);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(272);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(275);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '#') ADVANCE(85);
      if (lookahead == '.') ADVANCE(26);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(272);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(256);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '#') ADVANCE(85);
      if (lookahead == '/') ADVANCE(94);
      if (lookahead == '-' ||
          lookahead == '_') ADVANCE(257);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(272);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(277);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '#') ADVANCE(85);
      if (lookahead == 'c') ADVANCE(268);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(272);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '#') ADVANCE(85);
      if (lookahead == 'e') ADVANCE(258);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(272);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '#') ADVANCE(85);
      if (lookahead == 'e') ADVANCE(262);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(272);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '#') ADVANCE(85);
      if (lookahead == 'l') ADVANCE(269);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(272);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '#') ADVANCE(85);
      if (lookahead == 'l') ADVANCE(259);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(272);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '#') ADVANCE(85);
      if (lookahead == 'n') ADVANCE(261);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(272);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '#') ADVANCE(85);
      if (lookahead == 'o') ADVANCE(267);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(272);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '#') ADVANCE(85);
      if (lookahead == 'o') ADVANCE(266);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(272);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '#') ADVANCE(85);
      if (lookahead == 'r') ADVANCE(179);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(272);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '#') ADVANCE(85);
      if (lookahead == 't') ADVANCE(173);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(272);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '#') ADVANCE(85);
      if (lookahead == 't') ADVANCE(265);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(272);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '#') ADVANCE(85);
      if (lookahead == 'y') ADVANCE(176);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(272);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '#') ADVANCE(85);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(185);
      if (lookahead == '-' ||
          ('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(272);
      END_STATE();
    case 271:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '#') ADVANCE(85);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(270);
      if (lookahead == '-' ||
          ('G' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('g' <= lookahead && lookahead <= 'z')) ADVANCE(272);
      END_STATE();
    case 272:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '#') ADVANCE(85);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(272);
      END_STATE();
    case 273:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '#') ADVANCE(399);
      if (lookahead == '-') ADVANCE(276);
      if (lookahead == '.') ADVANCE(398);
      if (lookahead == '/') ADVANCE(95);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(217);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(275);
      if (!sym_plain_value_character_set_2(lookahead)) ADVANCE(401);
      END_STATE();
    case 274:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '#') ADVANCE(399);
      if (lookahead == '-') ADVANCE(276);
      if (lookahead == '/') ADVANCE(95);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(217);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(277);
      if (!sym_plain_value_character_set_2(lookahead)) ADVANCE(401);
      END_STATE();
    case 275:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '#') ADVANCE(399);
      if (lookahead == '.') ADVANCE(398);
      if (lookahead == '/') ADVANCE(95);
      if (('-' <= lookahead && lookahead <= '9')) ADVANCE(277);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(275);
      if (!sym_plain_value_character_set_2(lookahead)) ADVANCE(401);
      END_STATE();
    case 276:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '#') ADVANCE(399);
      if (lookahead == '/') ADVANCE(95);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(217);
      if (lookahead == '-' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(277);
      if (!sym_plain_value_character_set_2(lookahead)) ADVANCE(401);
      END_STATE();
    case 277:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '#') ADVANCE(399);
      if (lookahead == '/') ADVANCE(95);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(277);
      if (!sym_plain_value_character_set_2(lookahead)) ADVANCE(401);
      END_STATE();
    case 278:
      ACCEPT_TOKEN(sym_variable_identifier);
      if (lookahead == '/') ADVANCE(95);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(278);
      if (!sym_plain_value_character_set_2(lookahead)) ADVANCE(401);
      END_STATE();
    case 279:
      ACCEPT_TOKEN(sym_variable_identifier);
      if (lookahead == '-' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(279);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == '-') ADVANCE(359);
      if (lookahead == 'k') ADVANCE(316);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'a') ADVANCE(294);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == 'l') ADVANCE(372);
      if (lookahead == 'r') ADVANCE(354);
      if (lookahead == 'x') ADVANCE(381);
      if (lookahead == '-' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 282:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'a') ADVANCE(294);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == 'l') ADVANCE(372);
      if (lookahead == 'r') ADVANCE(354);
      if (lookahead == '-' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 283:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'a') ADVANCE(294);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == 'r') ADVANCE(354);
      if (lookahead == 'x') ADVANCE(381);
      if (lookahead == '-' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 284:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'a') ADVANCE(294);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == 'r') ADVANCE(354);
      if (lookahead == '-' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 285:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'a') ADVANCE(330);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == '-' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 286:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'a') ADVANCE(106);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == '-' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 287:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'a') ADVANCE(358);
      if (lookahead == 'h') ADVANCE(324);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == '-' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 288:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'a') ADVANCE(297);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == '-' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'a') ADVANCE(364);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == '-' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'a') ADVANCE(361);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == '-' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'a') ADVANCE(331);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == '-' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'a') ADVANCE(332);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == '-' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'b') ADVANCE(382);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 294:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'c') ADVANCE(321);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 295:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'c') ADVANCE(328);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 296:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'c') ADVANCE(380);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 297:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'c') ADVANCE(309);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'd') ADVANCE(128);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'd') ADVANCE(117);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 300:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'd') ADVANCE(323);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 301:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'd') ADVANCE(308);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'e') ADVANCE(293);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 303:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'e') ADVANCE(387);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 304:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'e') ADVANCE(300);
      if (lookahead == 'i') ADVANCE(386);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 305:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'e') ADVANCE(116);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 306:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'e') ADVANCE(130);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 307:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'e') ADVANCE(138);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 308:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'e') ADVANCE(124);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 309:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'e') ADVANCE(108);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 310:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'e') ADVANCE(371);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 311:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'e') ADVANCE(378);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 312:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'e') ADVANCE(337);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 313:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'e') ADVANCE(368);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 314:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'e') ADVANCE(369);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 315:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'e') ADVANCE(377);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 316:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'e') ADVANCE(389);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 317:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'f') ADVANCE(129);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == 'm') ADVANCE(351);
      if (lookahead == 'n') ADVANCE(295);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 318:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'f') ADVANCE(365);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 319:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'f') ADVANCE(366);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 320:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'g') ADVANCE(144);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 321:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'h') ADVANCE(132);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 322:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'h') ADVANCE(289);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 323:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'i') ADVANCE(286);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 324:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'i') ADVANCE(329);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 325:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'i') ADVANCE(334);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 326:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'i') ADVANCE(344);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 327:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == 'l') ADVANCE(388);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 328:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == 'l') ADVANCE(384);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 329:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == 'l') ADVANCE(307);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 330:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == 'm') ADVANCE(310);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 331:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == 'm') ADVANCE(313);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 332:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == 'm') ADVANCE(314);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 333:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == 'n') ADVANCE(143);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 334:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == 'n') ADVANCE(123);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 335:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == 'n') ADVANCE(140);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 336:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == 'n') ADVANCE(139);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 337:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == 'n') ADVANCE(298);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 338:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == 'n') ADVANCE(296);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 339:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == 'o') ADVANCE(355);
      if (lookahead == 'u') ADVANCE(338);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 340:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == 'o') ADVANCE(342);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 341:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == 'o') ADVANCE(356);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 342:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == 'o') ADVANCE(376);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 343:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == 'o') ADVANCE(360);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 344:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == 'o') ADVANCE(336);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 345:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == 'o') ADVANCE(363);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 346:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == 'o') ADVANCE(357);
      if (lookahead == 'u') ADVANCE(338);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 347:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == 'p') ADVANCE(349);
      if (lookahead == 't') ADVANCE(280);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 348:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == 'p') ADVANCE(349);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 349:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == 'p') ADVANCE(327);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 350:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == 'p') ADVANCE(288);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 351:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == 'p') ADVANCE(343);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 352:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == 'p') ADVANCE(345);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 353:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == 'p') ADVANCE(352);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 354:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == 'r') ADVANCE(341);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 355:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == 'r') ADVANCE(134);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 356:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == 'r') ADVANCE(142);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 357:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == 'r') ADVANCE(135);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 358:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == 'r') ADVANCE(333);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 359:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == 'r') ADVANCE(340);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 360:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == 'r') ADVANCE(375);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 361:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == 'r') ADVANCE(299);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 362:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == 'r') ADVANCE(335);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 363:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == 'r') ADVANCE(379);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 364:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == 'r') ADVANCE(373);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 365:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == 'r') ADVANCE(291);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 366:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == 'r') ADVANCE(292);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 367:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == 's') ADVANCE(115);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 368:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == 's') ADVANCE(109);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 369:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == 's') ADVANCE(110);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 370:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == 's') ADVANCE(305);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 371:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == 's') ADVANCE(350);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 372:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == 's') ADVANCE(306);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 373:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == 's') ADVANCE(315);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 374:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == 't') ADVANCE(280);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 375:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == 't') ADVANCE(103);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 376:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == 't') ADVANCE(141);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 377:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == 't') ADVANCE(107);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 378:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == 't') ADVANCE(385);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 379:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == 't') ADVANCE(367);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 380:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == 't') ADVANCE(326);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 381:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == 't') ADVANCE(312);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 382:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == 'u') ADVANCE(320);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 383:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == 'u') ADVANCE(353);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 384:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == 'u') ADVANCE(301);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 385:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == 'u') ADVANCE(362);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 386:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == 'x') ADVANCE(325);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 387:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == 'y') ADVANCE(318);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 388:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == 'y') ADVANCE(118);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 389:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == 'y') ADVANCE(319);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 390:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == 'k') ADVANCE(316);
      if (lookahead == '-' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(390);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_') ADVANCE(391);
      END_STATE();
    case 391:
      ACCEPT_TOKEN(sym_at_keyword);
      if (lookahead == '-' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(391);
      END_STATE();
    case 392:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 393:
      ACCEPT_TOKEN(sym_single_line_comment);
      if (lookahead == '/') ADVANCE(395);
      if (lookahead == '-' ||
          lookahead == '_') ADVANCE(393);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(394);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(397);
      END_STATE();
    case 394:
      ACCEPT_TOKEN(sym_single_line_comment);
      if (lookahead == '/') ADVANCE(396);
      if (sym_single_line_comment_character_set_1(lookahead)) ADVANCE(397);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(394);
      END_STATE();
    case 395:
      ACCEPT_TOKEN(sym_single_line_comment);
      if (sym_single_line_comment_character_set_2(lookahead)) ADVANCE(397);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(393);
      END_STATE();
    case 396:
      ACCEPT_TOKEN(sym_single_line_comment);
      if (sym_single_line_comment_character_set_2(lookahead)) ADVANCE(397);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(394);
      END_STATE();
    case 397:
      ACCEPT_TOKEN(sym_single_line_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(397);
      END_STATE();
    case 398:
      ACCEPT_TOKEN(sym_plain_value);
      if (lookahead == '$') ADVANCE(400);
      if (lookahead == '/') ADVANCE(95);
      if (!sym_plain_value_character_set_2(lookahead)) ADVANCE(401);
      END_STATE();
    case 399:
      ACCEPT_TOKEN(sym_plain_value);
      if (lookahead == '/') ADVANCE(95);
      if (lookahead == '{') ADVANCE(86);
      if (!sym_plain_value_character_set_3(lookahead)) ADVANCE(401);
      END_STATE();
    case 400:
      ACCEPT_TOKEN(sym_plain_value);
      if (lookahead == '/') ADVANCE(95);
      if (lookahead == '-' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(278);
      if (!sym_plain_value_character_set_2(lookahead)) ADVANCE(401);
      END_STATE();
    case 401:
      ACCEPT_TOKEN(sym_plain_value);
      if (lookahead == '/') ADVANCE(95);
      if (!sym_plain_value_character_set_2(lookahead)) ADVANCE(401);
      END_STATE();
    default:
      return false;
  }
}

static TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 99},
  [2] = {.lex_state = 99},
  [3] = {.lex_state = 99},
  [4] = {.lex_state = 17},
  [5] = {.lex_state = 17},
  [6] = {.lex_state = 17},
  [7] = {.lex_state = 17},
  [8] = {.lex_state = 17},
  [9] = {.lex_state = 17},
  [10] = {.lex_state = 17},
  [11] = {.lex_state = 17},
  [12] = {.lex_state = 17},
  [13] = {.lex_state = 17},
  [14] = {.lex_state = 17},
  [15] = {.lex_state = 101},
  [16] = {.lex_state = 101},
  [17] = {.lex_state = 19},
  [18] = {.lex_state = 19},
  [19] = {.lex_state = 101},
  [20] = {.lex_state = 19},
  [21] = {.lex_state = 101},
  [22] = {.lex_state = 3},
  [23] = {.lex_state = 101},
  [24] = {.lex_state = 101},
  [25] = {.lex_state = 101},
  [26] = {.lex_state = 101},
  [27] = {.lex_state = 99},
  [28] = {.lex_state = 3},
  [29] = {.lex_state = 99},
  [30] = {.lex_state = 99},
  [31] = {.lex_state = 99},
  [32] = {.lex_state = 99},
  [33] = {.lex_state = 99},
  [34] = {.lex_state = 99},
  [35] = {.lex_state = 99},
  [36] = {.lex_state = 99},
  [37] = {.lex_state = 99},
  [38] = {.lex_state = 99},
  [39] = {.lex_state = 99},
  [40] = {.lex_state = 99},
  [41] = {.lex_state = 99},
  [42] = {.lex_state = 99},
  [43] = {.lex_state = 99},
  [44] = {.lex_state = 99},
  [45] = {.lex_state = 99},
  [46] = {.lex_state = 99},
  [47] = {.lex_state = 99},
  [48] = {.lex_state = 19},
  [49] = {.lex_state = 99},
  [50] = {.lex_state = 99},
  [51] = {.lex_state = 99},
  [52] = {.lex_state = 99},
  [53] = {.lex_state = 99},
  [54] = {.lex_state = 99},
  [55] = {.lex_state = 99},
  [56] = {.lex_state = 99},
  [57] = {.lex_state = 99},
  [58] = {.lex_state = 99},
  [59] = {.lex_state = 99},
  [60] = {.lex_state = 99},
  [61] = {.lex_state = 99},
  [62] = {.lex_state = 99},
  [63] = {.lex_state = 99},
  [64] = {.lex_state = 99},
  [65] = {.lex_state = 99},
  [66] = {.lex_state = 19},
  [67] = {.lex_state = 99},
  [68] = {.lex_state = 99},
  [69] = {.lex_state = 99},
  [70] = {.lex_state = 99},
  [71] = {.lex_state = 19},
  [72] = {.lex_state = 19},
  [73] = {.lex_state = 19},
  [74] = {.lex_state = 99},
  [75] = {.lex_state = 99},
  [76] = {.lex_state = 99},
  [77] = {.lex_state = 99},
  [78] = {.lex_state = 99},
  [79] = {.lex_state = 17},
  [80] = {.lex_state = 17},
  [81] = {.lex_state = 17},
  [82] = {.lex_state = 17},
  [83] = {.lex_state = 17},
  [84] = {.lex_state = 17},
  [85] = {.lex_state = 17},
  [86] = {.lex_state = 17},
  [87] = {.lex_state = 17},
  [88] = {.lex_state = 17},
  [89] = {.lex_state = 17},
  [90] = {.lex_state = 17},
  [91] = {.lex_state = 17},
  [92] = {.lex_state = 17},
  [93] = {.lex_state = 17},
  [94] = {.lex_state = 17},
  [95] = {.lex_state = 17},
  [96] = {.lex_state = 17},
  [97] = {.lex_state = 17},
  [98] = {.lex_state = 17},
  [99] = {.lex_state = 17},
  [100] = {.lex_state = 17},
  [101] = {.lex_state = 17},
  [102] = {.lex_state = 17},
  [103] = {.lex_state = 17},
  [104] = {.lex_state = 17},
  [105] = {.lex_state = 17},
  [106] = {.lex_state = 17},
  [107] = {.lex_state = 17},
  [108] = {.lex_state = 17},
  [109] = {.lex_state = 17},
  [110] = {.lex_state = 17},
  [111] = {.lex_state = 17},
  [112] = {.lex_state = 17},
  [113] = {.lex_state = 17},
  [114] = {.lex_state = 17},
  [115] = {.lex_state = 17},
  [116] = {.lex_state = 17},
  [117] = {.lex_state = 17},
  [118] = {.lex_state = 17},
  [119] = {.lex_state = 17},
  [120] = {.lex_state = 17},
  [121] = {.lex_state = 17},
  [122] = {.lex_state = 3},
  [123] = {.lex_state = 17},
  [124] = {.lex_state = 3},
  [125] = {.lex_state = 3},
  [126] = {.lex_state = 3},
  [127] = {.lex_state = 3},
  [128] = {.lex_state = 3},
  [129] = {.lex_state = 2, .external_lex_state = 1},
  [130] = {.lex_state = 3, .external_lex_state = 1},
  [131] = {.lex_state = 2},
  [132] = {.lex_state = 1},
  [133] = {.lex_state = 1},
  [134] = {.lex_state = 3},
  [135] = {.lex_state = 3},
  [136] = {.lex_state = 3},
  [137] = {.lex_state = 3},
  [138] = {.lex_state = 3},
  [139] = {.lex_state = 3},
  [140] = {.lex_state = 3},
  [141] = {.lex_state = 3},
  [142] = {.lex_state = 3},
  [143] = {.lex_state = 3},
  [144] = {.lex_state = 3},
  [145] = {.lex_state = 3},
  [146] = {.lex_state = 9},
  [147] = {.lex_state = 3},
  [148] = {.lex_state = 9},
  [149] = {.lex_state = 3},
  [150] = {.lex_state = 5, .external_lex_state = 1},
  [151] = {.lex_state = 3},
  [152] = {.lex_state = 20},
  [153] = {.lex_state = 20},
  [154] = {.lex_state = 20},
  [155] = {.lex_state = 3},
  [156] = {.lex_state = 3},
  [157] = {.lex_state = 20},
  [158] = {.lex_state = 20},
  [159] = {.lex_state = 3},
  [160] = {.lex_state = 3},
  [161] = {.lex_state = 3},
  [162] = {.lex_state = 20},
  [163] = {.lex_state = 3},
  [164] = {.lex_state = 3},
  [165] = {.lex_state = 5, .external_lex_state = 1},
  [166] = {.lex_state = 3},
  [167] = {.lex_state = 3},
  [168] = {.lex_state = 3},
  [169] = {.lex_state = 3},
  [170] = {.lex_state = 3},
  [171] = {.lex_state = 5},
  [172] = {.lex_state = 3},
  [173] = {.lex_state = 8},
  [174] = {.lex_state = 3},
  [175] = {.lex_state = 3},
  [176] = {.lex_state = 3},
  [177] = {.lex_state = 3},
  [178] = {.lex_state = 3},
  [179] = {.lex_state = 9},
  [180] = {.lex_state = 7},
  [181] = {.lex_state = 3},
  [182] = {.lex_state = 3},
  [183] = {.lex_state = 7},
  [184] = {.lex_state = 5},
  [185] = {.lex_state = 5},
  [186] = {.lex_state = 9},
  [187] = {.lex_state = 9},
  [188] = {.lex_state = 9},
  [189] = {.lex_state = 5},
  [190] = {.lex_state = 5},
  [191] = {.lex_state = 9},
  [192] = {.lex_state = 9},
  [193] = {.lex_state = 9},
  [194] = {.lex_state = 5},
  [195] = {.lex_state = 3},
  [196] = {.lex_state = 5},
  [197] = {.lex_state = 9},
  [198] = {.lex_state = 5},
  [199] = {.lex_state = 5},
  [200] = {.lex_state = 3},
  [201] = {.lex_state = 13},
  [202] = {.lex_state = 5},
  [203] = {.lex_state = 5},
  [204] = {.lex_state = 9},
  [205] = {.lex_state = 9},
  [206] = {.lex_state = 3},
  [207] = {.lex_state = 5},
  [208] = {.lex_state = 9},
  [209] = {.lex_state = 13},
  [210] = {.lex_state = 3},
  [211] = {.lex_state = 3},
  [212] = {.lex_state = 3},
  [213] = {.lex_state = 3},
  [214] = {.lex_state = 3},
  [215] = {.lex_state = 3},
  [216] = {.lex_state = 3},
  [217] = {.lex_state = 99, .external_lex_state = 1},
  [218] = {.lex_state = 3},
  [219] = {.lex_state = 3},
  [220] = {.lex_state = 3},
  [221] = {.lex_state = 3},
  [222] = {.lex_state = 3},
  [223] = {.lex_state = 3},
  [224] = {.lex_state = 3},
  [225] = {.lex_state = 3},
  [226] = {.lex_state = 3},
  [227] = {.lex_state = 3},
  [228] = {.lex_state = 3},
  [229] = {.lex_state = 3},
  [230] = {.lex_state = 3},
  [231] = {.lex_state = 3},
  [232] = {.lex_state = 3},
  [233] = {.lex_state = 3},
  [234] = {.lex_state = 3},
  [235] = {.lex_state = 3},
  [236] = {.lex_state = 3},
  [237] = {.lex_state = 3},
  [238] = {.lex_state = 3},
  [239] = {.lex_state = 3},
  [240] = {.lex_state = 3},
  [241] = {.lex_state = 3},
  [242] = {.lex_state = 3},
  [243] = {.lex_state = 3},
  [244] = {.lex_state = 3},
  [245] = {.lex_state = 3},
  [246] = {.lex_state = 3},
  [247] = {.lex_state = 3},
  [248] = {.lex_state = 3},
  [249] = {.lex_state = 3},
  [250] = {.lex_state = 3},
  [251] = {.lex_state = 3},
  [252] = {.lex_state = 3},
  [253] = {.lex_state = 3},
  [254] = {.lex_state = 3},
  [255] = {.lex_state = 3},
  [256] = {.lex_state = 99, .external_lex_state = 1},
  [257] = {.lex_state = 3},
  [258] = {.lex_state = 3},
  [259] = {.lex_state = 3},
  [260] = {.lex_state = 20, .external_lex_state = 1},
  [261] = {.lex_state = 99, .external_lex_state = 1},
  [262] = {.lex_state = 9},
  [263] = {.lex_state = 11},
  [264] = {.lex_state = 9},
  [265] = {.lex_state = 99, .external_lex_state = 1},
  [266] = {.lex_state = 99, .external_lex_state = 1},
  [267] = {.lex_state = 99, .external_lex_state = 1},
  [268] = {.lex_state = 99, .external_lex_state = 1},
  [269] = {.lex_state = 99, .external_lex_state = 1},
  [270] = {.lex_state = 11},
  [271] = {.lex_state = 99, .external_lex_state = 1},
  [272] = {.lex_state = 99, .external_lex_state = 1},
  [273] = {.lex_state = 99, .external_lex_state = 1},
  [274] = {.lex_state = 99, .external_lex_state = 1},
  [275] = {.lex_state = 99, .external_lex_state = 1},
  [276] = {.lex_state = 99, .external_lex_state = 1},
  [277] = {.lex_state = 99, .external_lex_state = 1},
  [278] = {.lex_state = 99, .external_lex_state = 1},
  [279] = {.lex_state = 99, .external_lex_state = 1},
  [280] = {.lex_state = 99, .external_lex_state = 1},
  [281] = {.lex_state = 99, .external_lex_state = 1},
  [282] = {.lex_state = 99, .external_lex_state = 1},
  [283] = {.lex_state = 99, .external_lex_state = 1},
  [284] = {.lex_state = 99, .external_lex_state = 1},
  [285] = {.lex_state = 11},
  [286] = {.lex_state = 99, .external_lex_state = 1},
  [287] = {.lex_state = 99, .external_lex_state = 1},
  [288] = {.lex_state = 99, .external_lex_state = 1},
  [289] = {.lex_state = 11},
  [290] = {.lex_state = 11},
  [291] = {.lex_state = 5},
  [292] = {.lex_state = 11},
  [293] = {.lex_state = 99, .external_lex_state = 1},
  [294] = {.lex_state = 99, .external_lex_state = 1},
  [295] = {.lex_state = 11},
  [296] = {.lex_state = 99, .external_lex_state = 1},
  [297] = {.lex_state = 11},
  [298] = {.lex_state = 5},
  [299] = {.lex_state = 15},
  [300] = {.lex_state = 11},
  [301] = {.lex_state = 11},
  [302] = {.lex_state = 11},
  [303] = {.lex_state = 99, .external_lex_state = 1},
  [304] = {.lex_state = 11},
  [305] = {.lex_state = 99, .external_lex_state = 1},
  [306] = {.lex_state = 5},
  [307] = {.lex_state = 5},
  [308] = {.lex_state = 11},
  [309] = {.lex_state = 5},
  [310] = {.lex_state = 5},
  [311] = {.lex_state = 5},
  [312] = {.lex_state = 5},
  [313] = {.lex_state = 11},
  [314] = {.lex_state = 15},
  [315] = {.lex_state = 11},
  [316] = {.lex_state = 11},
  [317] = {.lex_state = 5},
  [318] = {.lex_state = 11},
  [319] = {.lex_state = 5},
  [320] = {.lex_state = 5},
  [321] = {.lex_state = 5},
  [322] = {.lex_state = 5},
  [323] = {.lex_state = 5},
  [324] = {.lex_state = 99, .external_lex_state = 1},
  [325] = {.lex_state = 5},
  [326] = {.lex_state = 5},
  [327] = {.lex_state = 9},
  [328] = {.lex_state = 9},
  [329] = {.lex_state = 5},
  [330] = {.lex_state = 5},
  [331] = {.lex_state = 5},
  [332] = {.lex_state = 5},
  [333] = {.lex_state = 5},
  [334] = {.lex_state = 5},
  [335] = {.lex_state = 9},
  [336] = {.lex_state = 5},
  [337] = {.lex_state = 5},
  [338] = {.lex_state = 5},
  [339] = {.lex_state = 5},
  [340] = {.lex_state = 9},
  [341] = {.lex_state = 9},
  [342] = {.lex_state = 9},
  [343] = {.lex_state = 9},
  [344] = {.lex_state = 5},
  [345] = {.lex_state = 5},
  [346] = {.lex_state = 99, .external_lex_state = 1},
  [347] = {.lex_state = 5},
  [348] = {.lex_state = 5},
  [349] = {.lex_state = 9},
  [350] = {.lex_state = 5},
  [351] = {.lex_state = 5},
  [352] = {.lex_state = 5},
  [353] = {.lex_state = 5},
  [354] = {.lex_state = 99, .external_lex_state = 1},
  [355] = {.lex_state = 25},
  [356] = {.lex_state = 25},
  [357] = {.lex_state = 25},
  [358] = {.lex_state = 25},
  [359] = {.lex_state = 25},
  [360] = {.lex_state = 25},
  [361] = {.lex_state = 25},
  [362] = {.lex_state = 0},
  [363] = {.lex_state = 0},
  [364] = {.lex_state = 5},
  [365] = {.lex_state = 5},
  [366] = {.lex_state = 5},
  [367] = {.lex_state = 5},
  [368] = {.lex_state = 0},
  [369] = {.lex_state = 5},
  [370] = {.lex_state = 5},
  [371] = {.lex_state = 0},
  [372] = {.lex_state = 0},
  [373] = {.lex_state = 20},
  [374] = {.lex_state = 0},
  [375] = {.lex_state = 0},
  [376] = {.lex_state = 20},
  [377] = {.lex_state = 0},
  [378] = {.lex_state = 0},
  [379] = {.lex_state = 0},
  [380] = {.lex_state = 0},
  [381] = {.lex_state = 5},
  [382] = {.lex_state = 0},
  [383] = {.lex_state = 99},
  [384] = {.lex_state = 17},
  [385] = {.lex_state = 99},
  [386] = {.lex_state = 17},
  [387] = {.lex_state = 0},
  [388] = {.lex_state = 99},
  [389] = {.lex_state = 17},
  [390] = {.lex_state = 99},
  [391] = {.lex_state = 0},
  [392] = {.lex_state = 99},
  [393] = {.lex_state = 25},
  [394] = {.lex_state = 25},
  [395] = {.lex_state = 25},
  [396] = {.lex_state = 25},
  [397] = {.lex_state = 0},
  [398] = {.lex_state = 0},
  [399] = {.lex_state = 17},
  [400] = {.lex_state = 0},
  [401] = {.lex_state = 0},
  [402] = {.lex_state = 0},
  [403] = {.lex_state = 20},
  [404] = {.lex_state = 17},
  [405] = {.lex_state = 99},
  [406] = {.lex_state = 99},
  [407] = {.lex_state = 0},
  [408] = {.lex_state = 0},
  [409] = {.lex_state = 17},
  [410] = {.lex_state = 99},
  [411] = {.lex_state = 0},
  [412] = {.lex_state = 0},
  [413] = {.lex_state = 99},
  [414] = {.lex_state = 0},
  [415] = {.lex_state = 99},
  [416] = {.lex_state = 99},
  [417] = {.lex_state = 5},
  [418] = {.lex_state = 17},
  [419] = {.lex_state = 20},
  [420] = {.lex_state = 0},
  [421] = {.lex_state = 0},
  [422] = {.lex_state = 99},
  [423] = {.lex_state = 17},
  [424] = {.lex_state = 0},
  [425] = {.lex_state = 0},
  [426] = {.lex_state = 0},
  [427] = {.lex_state = 0},
  [428] = {.lex_state = 0},
  [429] = {.lex_state = 0},
  [430] = {.lex_state = 0},
  [431] = {.lex_state = 23},
  [432] = {.lex_state = 13},
  [433] = {.lex_state = 0},
  [434] = {.lex_state = 0},
  [435] = {.lex_state = 99},
  [436] = {.lex_state = 0},
  [437] = {.lex_state = 0},
  [438] = {.lex_state = 23},
  [439] = {.lex_state = 0},
  [440] = {.lex_state = 0},
  [441] = {.lex_state = 99},
  [442] = {.lex_state = 0},
  [443] = {.lex_state = 0},
  [444] = {.lex_state = 20},
  [445] = {.lex_state = 0},
  [446] = {.lex_state = 0},
  [447] = {.lex_state = 0},
  [448] = {.lex_state = 0},
  [449] = {.lex_state = 0},
  [450] = {.lex_state = 0},
  [451] = {.lex_state = 0},
  [452] = {.lex_state = 0},
  [453] = {.lex_state = 5},
  [454] = {.lex_state = 0},
  [455] = {.lex_state = 0},
  [456] = {.lex_state = 20},
  [457] = {.lex_state = 99},
  [458] = {.lex_state = 0},
  [459] = {.lex_state = 0},
  [460] = {.lex_state = 5},
  [461] = {.lex_state = 0},
  [462] = {.lex_state = 0},
  [463] = {.lex_state = 17},
  [464] = {.lex_state = 0},
  [465] = {.lex_state = 0},
  [466] = {.lex_state = 0},
  [467] = {.lex_state = 0},
  [468] = {.lex_state = 0},
  [469] = {.lex_state = 5},
  [470] = {.lex_state = 0},
  [471] = {.lex_state = 0},
  [472] = {.lex_state = 0},
  [473] = {.lex_state = 0},
  [474] = {.lex_state = 0},
  [475] = {.lex_state = 0},
  [476] = {.lex_state = 0},
  [477] = {.lex_state = 20},
  [478] = {.lex_state = 0},
  [479] = {.lex_state = 20},
  [480] = {.lex_state = 20},
  [481] = {.lex_state = 0},
  [482] = {.lex_state = 20},
  [483] = {.lex_state = 20},
  [484] = {.lex_state = 20},
  [485] = {.lex_state = 20},
  [486] = {.lex_state = 20},
  [487] = {.lex_state = 20},
  [488] = {.lex_state = 5},
  [489] = {.lex_state = 99},
  [490] = {.lex_state = 99},
  [491] = {.lex_state = 20},
  [492] = {.lex_state = 20},
  [493] = {.lex_state = 0},
  [494] = {.lex_state = 20},
  [495] = {.lex_state = 20},
  [496] = {.lex_state = 0},
  [497] = {.lex_state = 20},
  [498] = {.lex_state = 0},
  [499] = {.lex_state = 0},
  [500] = {.lex_state = 20},
  [501] = {.lex_state = 0},
  [502] = {.lex_state = 20},
  [503] = {.lex_state = 99},
  [504] = {.lex_state = 99},
  [505] = {.lex_state = 20},
  [506] = {.lex_state = 0},
  [507] = {.lex_state = 99},
};

enum {
  ts_external_token__descendant_operator = 0,
};

static TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token__descendant_operator] = sym__descendant_operator,
};

static bool ts_external_scanner_states[2][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token__descendant_operator] = true,
  },
};

static uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [anon_sym_ATimport] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_ATmedia] = ACTIONS(1),
    [anon_sym_ATcharset] = ACTIONS(1),
    [anon_sym_ATnamespace] = ACTIONS(1),
    [anon_sym_ATkeyframes] = ACTIONS(1),
    [aux_sym_keyframes_statement_token1] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_from] = ACTIONS(1),
    [sym_to] = ACTIONS(1),
    [anon_sym_ATsupports] = ACTIONS(1),
    [anon_sym_ATuse] = ACTIONS(1),
    [anon_sym_ATforward] = ACTIONS(1),
    [anon_sym_ATapply] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_ATmixin] = ACTIONS(1),
    [anon_sym_ATinclude] = ACTIONS(1),
    [anon_sym_LPAREN2] = ACTIONS(1),
    [anon_sym_RPAREN2] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_ATextend] = ACTIONS(1),
    [anon_sym_ATif] = ACTIONS(1),
    [anon_sym_ATelse] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_ATeach] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_ATfor] = ACTIONS(1),
    [anon_sym_through] = ACTIONS(1),
    [anon_sym_ATwhile] = ACTIONS(1),
    [anon_sym_ATfunction] = ACTIONS(1),
    [anon_sym_ATreturn] = ACTIONS(1),
    [anon_sym_ATat_DASHroot] = ACTIONS(1),
    [anon_sym_ATerror] = ACTIONS(1),
    [anon_sym_ATwarn] = ACTIONS(1),
    [anon_sym_ATdebug] = ACTIONS(1),
    [sym_nesting_selector] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_TILDE_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_DOLLAR_EQ] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [sym_important] = ACTIONS(1),
    [anon_sym_and] = ACTIONS(1),
    [anon_sym_or] = ACTIONS(1),
    [anon_sym_not] = ACTIONS(1),
    [anon_sym_only] = ACTIONS(1),
    [anon_sym_selector] = ACTIONS(1),
    [aux_sym_color_value_token1] = ACTIONS(1),
    [sym_string_value] = ACTIONS(1),
    [aux_sym_integer_value_token1] = ACTIONS(1),
    [aux_sym_float_value_token1] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [sym_at_keyword] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [sym_single_line_comment] = ACTIONS(3),
    [sym__descendant_operator] = ACTIONS(1),
  },
  [1] = {
    [sym_stylesheet] = STATE(473),
    [sym_import_statement] = STATE(3),
    [sym_media_statement] = STATE(3),
    [sym_charset_statement] = STATE(3),
    [sym_namespace_statement] = STATE(3),
    [sym_keyframes_statement] = STATE(3),
    [sym_supports_statement] = STATE(3),
    [sym_at_rule] = STATE(3),
    [sym_use_statement] = STATE(3),
    [sym_forward_statement] = STATE(3),
    [sym_apply_statement] = STATE(3),
    [sym_mixin_statement] = STATE(3),
    [sym_include_statement] = STATE(3),
    [sym_placeholder] = STATE(3),
    [sym_if_statement] = STATE(3),
    [sym_if_clause] = STATE(15),
    [sym_each_statement] = STATE(3),
    [sym_for_statement] = STATE(3),
    [sym_while_statement] = STATE(3),
    [sym_function_statement] = STATE(3),
    [sym_error_statement] = STATE(3),
    [sym_warn_statement] = STATE(3),
    [sym_debug_statement] = STATE(3),
    [sym_rule_set] = STATE(3),
    [sym_selectors] = STATE(420),
    [sym__selector] = STATE(274),
    [sym_universal_selector] = STATE(274),
    [sym_class_selector] = STATE(274),
    [sym_pseudo_class_selector] = STATE(274),
    [sym_pseudo_element_selector] = STATE(274),
    [sym_id_selector] = STATE(274),
    [sym_attribute_selector] = STATE(274),
    [sym_child_selector] = STATE(274),
    [sym_descendant_selector] = STATE(274),
    [sym_sibling_selector] = STATE(274),
    [sym_adjacent_sibling_selector] = STATE(274),
    [sym_declaration] = STATE(3),
    [aux_sym_stylesheet_repeat1] = STATE(3),
    [ts_builtin_sym_end] = ACTIONS(5),
    [anon_sym_ATimport] = ACTIONS(7),
    [anon_sym_ATmedia] = ACTIONS(9),
    [anon_sym_ATcharset] = ACTIONS(11),
    [anon_sym_ATnamespace] = ACTIONS(13),
    [anon_sym_ATkeyframes] = ACTIONS(15),
    [aux_sym_keyframes_statement_token1] = ACTIONS(15),
    [anon_sym_ATsupports] = ACTIONS(17),
    [anon_sym_ATuse] = ACTIONS(19),
    [anon_sym_ATforward] = ACTIONS(21),
    [anon_sym_ATapply] = ACTIONS(23),
    [anon_sym_COLON] = ACTIONS(25),
    [anon_sym_ATmixin] = ACTIONS(27),
    [anon_sym_ATinclude] = ACTIONS(29),
    [anon_sym_PERCENT] = ACTIONS(31),
    [anon_sym_ATif] = ACTIONS(33),
    [anon_sym_ATeach] = ACTIONS(35),
    [anon_sym_ATfor] = ACTIONS(37),
    [anon_sym_ATwhile] = ACTIONS(39),
    [anon_sym_ATfunction] = ACTIONS(41),
    [anon_sym_ATerror] = ACTIONS(43),
    [anon_sym_ATwarn] = ACTIONS(45),
    [anon_sym_ATdebug] = ACTIONS(47),
    [sym_nesting_selector] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_DOT] = ACTIONS(53),
    [anon_sym_COLON_COLON] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [sym_string_value] = ACTIONS(61),
    [sym_identifier] = ACTIONS(63),
    [sym_variable_identifier] = ACTIONS(65),
    [sym_at_keyword] = ACTIONS(67),
    [sym_comment] = ACTIONS(3),
    [sym_single_line_comment] = ACTIONS(3),
  },
  [2] = {
    [sym_import_statement] = STATE(2),
    [sym_media_statement] = STATE(2),
    [sym_charset_statement] = STATE(2),
    [sym_namespace_statement] = STATE(2),
    [sym_keyframes_statement] = STATE(2),
    [sym_supports_statement] = STATE(2),
    [sym_at_rule] = STATE(2),
    [sym_use_statement] = STATE(2),
    [sym_forward_statement] = STATE(2),
    [sym_apply_statement] = STATE(2),
    [sym_mixin_statement] = STATE(2),
    [sym_include_statement] = STATE(2),
    [sym_placeholder] = STATE(2),
    [sym_if_statement] = STATE(2),
    [sym_if_clause] = STATE(15),
    [sym_each_statement] = STATE(2),
    [sym_for_statement] = STATE(2),
    [sym_while_statement] = STATE(2),
    [sym_function_statement] = STATE(2),
    [sym_error_statement] = STATE(2),
    [sym_warn_statement] = STATE(2),
    [sym_debug_statement] = STATE(2),
    [sym_rule_set] = STATE(2),
    [sym_selectors] = STATE(420),
    [sym__selector] = STATE(274),
    [sym_universal_selector] = STATE(274),
    [sym_class_selector] = STATE(274),
    [sym_pseudo_class_selector] = STATE(274),
    [sym_pseudo_element_selector] = STATE(274),
    [sym_id_selector] = STATE(274),
    [sym_attribute_selector] = STATE(274),
    [sym_child_selector] = STATE(274),
    [sym_descendant_selector] = STATE(274),
    [sym_sibling_selector] = STATE(274),
    [sym_adjacent_sibling_selector] = STATE(274),
    [sym_declaration] = STATE(2),
    [aux_sym_stylesheet_repeat1] = STATE(2),
    [ts_builtin_sym_end] = ACTIONS(69),
    [anon_sym_ATimport] = ACTIONS(71),
    [anon_sym_ATmedia] = ACTIONS(74),
    [anon_sym_ATcharset] = ACTIONS(77),
    [anon_sym_ATnamespace] = ACTIONS(80),
    [anon_sym_ATkeyframes] = ACTIONS(83),
    [aux_sym_keyframes_statement_token1] = ACTIONS(83),
    [anon_sym_ATsupports] = ACTIONS(86),
    [anon_sym_ATuse] = ACTIONS(89),
    [anon_sym_ATforward] = ACTIONS(92),
    [anon_sym_ATapply] = ACTIONS(95),
    [anon_sym_COLON] = ACTIONS(98),
    [anon_sym_ATmixin] = ACTIONS(101),
    [anon_sym_ATinclude] = ACTIONS(104),
    [anon_sym_PERCENT] = ACTIONS(107),
    [anon_sym_ATif] = ACTIONS(110),
    [anon_sym_ATeach] = ACTIONS(113),
    [anon_sym_ATfor] = ACTIONS(116),
    [anon_sym_ATwhile] = ACTIONS(119),
    [anon_sym_ATfunction] = ACTIONS(122),
    [anon_sym_ATerror] = ACTIONS(125),
    [anon_sym_ATwarn] = ACTIONS(128),
    [anon_sym_ATdebug] = ACTIONS(131),
    [sym_nesting_selector] = ACTIONS(134),
    [anon_sym_STAR] = ACTIONS(137),
    [anon_sym_DOT] = ACTIONS(140),
    [anon_sym_COLON_COLON] = ACTIONS(143),
    [anon_sym_POUND] = ACTIONS(146),
    [anon_sym_LBRACK] = ACTIONS(149),
    [sym_string_value] = ACTIONS(152),
    [sym_identifier] = ACTIONS(155),
    [sym_variable_identifier] = ACTIONS(158),
    [sym_at_keyword] = ACTIONS(161),
    [sym_comment] = ACTIONS(3),
    [sym_single_line_comment] = ACTIONS(3),
  },
  [3] = {
    [sym_import_statement] = STATE(2),
    [sym_media_statement] = STATE(2),
    [sym_charset_statement] = STATE(2),
    [sym_namespace_statement] = STATE(2),
    [sym_keyframes_statement] = STATE(2),
    [sym_supports_statement] = STATE(2),
    [sym_at_rule] = STATE(2),
    [sym_use_statement] = STATE(2),
    [sym_forward_statement] = STATE(2),
    [sym_apply_statement] = STATE(2),
    [sym_mixin_statement] = STATE(2),
    [sym_include_statement] = STATE(2),
    [sym_placeholder] = STATE(2),
    [sym_if_statement] = STATE(2),
    [sym_if_clause] = STATE(15),
    [sym_each_statement] = STATE(2),
    [sym_for_statement] = STATE(2),
    [sym_while_statement] = STATE(2),
    [sym_function_statement] = STATE(2),
    [sym_error_statement] = STATE(2),
    [sym_warn_statement] = STATE(2),
    [sym_debug_statement] = STATE(2),
    [sym_rule_set] = STATE(2),
    [sym_selectors] = STATE(420),
    [sym__selector] = STATE(274),
    [sym_universal_selector] = STATE(274),
    [sym_class_selector] = STATE(274),
    [sym_pseudo_class_selector] = STATE(274),
    [sym_pseudo_element_selector] = STATE(274),
    [sym_id_selector] = STATE(274),
    [sym_attribute_selector] = STATE(274),
    [sym_child_selector] = STATE(274),
    [sym_descendant_selector] = STATE(274),
    [sym_sibling_selector] = STATE(274),
    [sym_adjacent_sibling_selector] = STATE(274),
    [sym_declaration] = STATE(2),
    [aux_sym_stylesheet_repeat1] = STATE(2),
    [ts_builtin_sym_end] = ACTIONS(164),
    [anon_sym_ATimport] = ACTIONS(7),
    [anon_sym_ATmedia] = ACTIONS(9),
    [anon_sym_ATcharset] = ACTIONS(11),
    [anon_sym_ATnamespace] = ACTIONS(13),
    [anon_sym_ATkeyframes] = ACTIONS(15),
    [aux_sym_keyframes_statement_token1] = ACTIONS(15),
    [anon_sym_ATsupports] = ACTIONS(17),
    [anon_sym_ATuse] = ACTIONS(19),
    [anon_sym_ATforward] = ACTIONS(21),
    [anon_sym_ATapply] = ACTIONS(23),
    [anon_sym_COLON] = ACTIONS(25),
    [anon_sym_ATmixin] = ACTIONS(27),
    [anon_sym_ATinclude] = ACTIONS(29),
    [anon_sym_PERCENT] = ACTIONS(31),
    [anon_sym_ATif] = ACTIONS(33),
    [anon_sym_ATeach] = ACTIONS(35),
    [anon_sym_ATfor] = ACTIONS(37),
    [anon_sym_ATwhile] = ACTIONS(39),
    [anon_sym_ATfunction] = ACTIONS(41),
    [anon_sym_ATerror] = ACTIONS(43),
    [anon_sym_ATwarn] = ACTIONS(45),
    [anon_sym_ATdebug] = ACTIONS(47),
    [sym_nesting_selector] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_DOT] = ACTIONS(53),
    [anon_sym_COLON_COLON] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [sym_string_value] = ACTIONS(61),
    [sym_identifier] = ACTIONS(63),
    [sym_variable_identifier] = ACTIONS(65),
    [sym_at_keyword] = ACTIONS(67),
    [sym_comment] = ACTIONS(3),
    [sym_single_line_comment] = ACTIONS(3),
  },
  [4] = {
    [sym_import_statement] = STATE(14),
    [sym_media_statement] = STATE(14),
    [sym_charset_statement] = STATE(14),
    [sym_namespace_statement] = STATE(14),
    [sym_keyframes_statement] = STATE(14),
    [sym_supports_statement] = STATE(14),
    [sym_at_rule] = STATE(14),
    [sym_mixin_statement] = STATE(14),
    [sym_include_statement] = STATE(14),
    [sym_extend_statement] = STATE(14),
    [sym_if_statement] = STATE(14),
    [sym_if_clause] = STATE(17),
    [sym_each_statement] = STATE(14),
    [sym_for_statement] = STATE(14),
    [sym_while_statement] = STATE(14),
    [sym_function_statement] = STATE(14),
    [sym_return_statement] = STATE(14),
    [sym_at_root_statement] = STATE(14),
    [sym_error_statement] = STATE(14),
    [sym_warn_statement] = STATE(14),
    [sym_debug_statement] = STATE(14),
    [sym_rule_set] = STATE(14),
    [sym_selectors] = STATE(428),
    [sym__selector] = STATE(274),
    [sym_universal_selector] = STATE(274),
    [sym_class_selector] = STATE(274),
    [sym_pseudo_class_selector] = STATE(274),
    [sym_pseudo_element_selector] = STATE(274),
    [sym_id_selector] = STATE(274),
    [sym_attribute_selector] = STATE(274),
    [sym_child_selector] = STATE(274),
    [sym_descendant_selector] = STATE(274),
    [sym_sibling_selector] = STATE(274),
    [sym_adjacent_sibling_selector] = STATE(274),
    [sym_declaration] = STATE(14),
    [sym_last_declaration] = STATE(472),
    [aux_sym_block_repeat1] = STATE(14),
    [anon_sym_ATimport] = ACTIONS(166),
    [anon_sym_ATmedia] = ACTIONS(168),
    [anon_sym_ATcharset] = ACTIONS(170),
    [anon_sym_ATnamespace] = ACTIONS(172),
    [anon_sym_ATkeyframes] = ACTIONS(174),
    [aux_sym_keyframes_statement_token1] = ACTIONS(174),
    [anon_sym_RBRACE] = ACTIONS(176),
    [anon_sym_ATsupports] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(25),
    [anon_sym_ATmixin] = ACTIONS(180),
    [anon_sym_ATinclude] = ACTIONS(182),
    [anon_sym_ATextend] = ACTIONS(184),
    [anon_sym_ATif] = ACTIONS(186),
    [anon_sym_ATeach] = ACTIONS(188),
    [anon_sym_ATfor] = ACTIONS(190),
    [anon_sym_ATwhile] = ACTIONS(192),
    [anon_sym_ATfunction] = ACTIONS(194),
    [anon_sym_ATreturn] = ACTIONS(196),
    [anon_sym_ATat_DASHroot] = ACTIONS(198),
    [anon_sym_ATerror] = ACTIONS(200),
    [anon_sym_ATwarn] = ACTIONS(202),
    [anon_sym_ATdebug] = ACTIONS(204),
    [sym_nesting_selector] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_DOT] = ACTIONS(53),
    [anon_sym_COLON_COLON] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [sym_string_value] = ACTIONS(61),
    [sym_identifier] = ACTIONS(206),
    [sym_variable_identifier] = ACTIONS(208),
    [sym_at_keyword] = ACTIONS(210),
    [sym_comment] = ACTIONS(3),
    [sym_single_line_comment] = ACTIONS(3),
  },
  [5] = {
    [sym_import_statement] = STATE(9),
    [sym_media_statement] = STATE(9),
    [sym_charset_statement] = STATE(9),
    [sym_namespace_statement] = STATE(9),
    [sym_keyframes_statement] = STATE(9),
    [sym_supports_statement] = STATE(9),
    [sym_at_rule] = STATE(9),
    [sym_mixin_statement] = STATE(9),
    [sym_include_statement] = STATE(9),
    [sym_extend_statement] = STATE(9),
    [sym_if_statement] = STATE(9),
    [sym_if_clause] = STATE(17),
    [sym_each_statement] = STATE(9),
    [sym_for_statement] = STATE(9),
    [sym_while_statement] = STATE(9),
    [sym_function_statement] = STATE(9),
    [sym_return_statement] = STATE(9),
    [sym_at_root_statement] = STATE(9),
    [sym_error_statement] = STATE(9),
    [sym_warn_statement] = STATE(9),
    [sym_debug_statement] = STATE(9),
    [sym_rule_set] = STATE(9),
    [sym_selectors] = STATE(428),
    [sym__selector] = STATE(274),
    [sym_universal_selector] = STATE(274),
    [sym_class_selector] = STATE(274),
    [sym_pseudo_class_selector] = STATE(274),
    [sym_pseudo_element_selector] = STATE(274),
    [sym_id_selector] = STATE(274),
    [sym_attribute_selector] = STATE(274),
    [sym_child_selector] = STATE(274),
    [sym_descendant_selector] = STATE(274),
    [sym_sibling_selector] = STATE(274),
    [sym_adjacent_sibling_selector] = STATE(274),
    [sym_declaration] = STATE(9),
    [sym_last_declaration] = STATE(461),
    [aux_sym_block_repeat1] = STATE(9),
    [anon_sym_ATimport] = ACTIONS(166),
    [anon_sym_ATmedia] = ACTIONS(168),
    [anon_sym_ATcharset] = ACTIONS(170),
    [anon_sym_ATnamespace] = ACTIONS(172),
    [anon_sym_ATkeyframes] = ACTIONS(174),
    [aux_sym_keyframes_statement_token1] = ACTIONS(174),
    [anon_sym_RBRACE] = ACTIONS(212),
    [anon_sym_ATsupports] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(25),
    [anon_sym_ATmixin] = ACTIONS(180),
    [anon_sym_ATinclude] = ACTIONS(182),
    [anon_sym_ATextend] = ACTIONS(184),
    [anon_sym_ATif] = ACTIONS(186),
    [anon_sym_ATeach] = ACTIONS(188),
    [anon_sym_ATfor] = ACTIONS(190),
    [anon_sym_ATwhile] = ACTIONS(192),
    [anon_sym_ATfunction] = ACTIONS(194),
    [anon_sym_ATreturn] = ACTIONS(196),
    [anon_sym_ATat_DASHroot] = ACTIONS(198),
    [anon_sym_ATerror] = ACTIONS(200),
    [anon_sym_ATwarn] = ACTIONS(202),
    [anon_sym_ATdebug] = ACTIONS(204),
    [sym_nesting_selector] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_DOT] = ACTIONS(53),
    [anon_sym_COLON_COLON] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [sym_string_value] = ACTIONS(61),
    [sym_identifier] = ACTIONS(206),
    [sym_variable_identifier] = ACTIONS(208),
    [sym_at_keyword] = ACTIONS(210),
    [sym_comment] = ACTIONS(3),
    [sym_single_line_comment] = ACTIONS(3),
  },
  [6] = {
    [sym_import_statement] = STATE(14),
    [sym_media_statement] = STATE(14),
    [sym_charset_statement] = STATE(14),
    [sym_namespace_statement] = STATE(14),
    [sym_keyframes_statement] = STATE(14),
    [sym_supports_statement] = STATE(14),
    [sym_at_rule] = STATE(14),
    [sym_mixin_statement] = STATE(14),
    [sym_include_statement] = STATE(14),
    [sym_extend_statement] = STATE(14),
    [sym_if_statement] = STATE(14),
    [sym_if_clause] = STATE(17),
    [sym_each_statement] = STATE(14),
    [sym_for_statement] = STATE(14),
    [sym_while_statement] = STATE(14),
    [sym_function_statement] = STATE(14),
    [sym_return_statement] = STATE(14),
    [sym_at_root_statement] = STATE(14),
    [sym_error_statement] = STATE(14),
    [sym_warn_statement] = STATE(14),
    [sym_debug_statement] = STATE(14),
    [sym_rule_set] = STATE(14),
    [sym_selectors] = STATE(428),
    [sym__selector] = STATE(274),
    [sym_universal_selector] = STATE(274),
    [sym_class_selector] = STATE(274),
    [sym_pseudo_class_selector] = STATE(274),
    [sym_pseudo_element_selector] = STATE(274),
    [sym_id_selector] = STATE(274),
    [sym_attribute_selector] = STATE(274),
    [sym_child_selector] = STATE(274),
    [sym_descendant_selector] = STATE(274),
    [sym_sibling_selector] = STATE(274),
    [sym_adjacent_sibling_selector] = STATE(274),
    [sym_declaration] = STATE(14),
    [sym_last_declaration] = STATE(458),
    [aux_sym_block_repeat1] = STATE(14),
    [anon_sym_ATimport] = ACTIONS(166),
    [anon_sym_ATmedia] = ACTIONS(168),
    [anon_sym_ATcharset] = ACTIONS(170),
    [anon_sym_ATnamespace] = ACTIONS(172),
    [anon_sym_ATkeyframes] = ACTIONS(174),
    [aux_sym_keyframes_statement_token1] = ACTIONS(174),
    [anon_sym_RBRACE] = ACTIONS(214),
    [anon_sym_ATsupports] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(25),
    [anon_sym_ATmixin] = ACTIONS(180),
    [anon_sym_ATinclude] = ACTIONS(182),
    [anon_sym_ATextend] = ACTIONS(184),
    [anon_sym_ATif] = ACTIONS(186),
    [anon_sym_ATeach] = ACTIONS(188),
    [anon_sym_ATfor] = ACTIONS(190),
    [anon_sym_ATwhile] = ACTIONS(192),
    [anon_sym_ATfunction] = ACTIONS(194),
    [anon_sym_ATreturn] = ACTIONS(196),
    [anon_sym_ATat_DASHroot] = ACTIONS(198),
    [anon_sym_ATerror] = ACTIONS(200),
    [anon_sym_ATwarn] = ACTIONS(202),
    [anon_sym_ATdebug] = ACTIONS(204),
    [sym_nesting_selector] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_DOT] = ACTIONS(53),
    [anon_sym_COLON_COLON] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [sym_string_value] = ACTIONS(61),
    [sym_identifier] = ACTIONS(206),
    [sym_variable_identifier] = ACTIONS(208),
    [sym_at_keyword] = ACTIONS(210),
    [sym_comment] = ACTIONS(3),
    [sym_single_line_comment] = ACTIONS(3),
  },
  [7] = {
    [sym_import_statement] = STATE(13),
    [sym_media_statement] = STATE(13),
    [sym_charset_statement] = STATE(13),
    [sym_namespace_statement] = STATE(13),
    [sym_keyframes_statement] = STATE(13),
    [sym_supports_statement] = STATE(13),
    [sym_at_rule] = STATE(13),
    [sym_mixin_statement] = STATE(13),
    [sym_include_statement] = STATE(13),
    [sym_extend_statement] = STATE(13),
    [sym_if_statement] = STATE(13),
    [sym_if_clause] = STATE(17),
    [sym_each_statement] = STATE(13),
    [sym_for_statement] = STATE(13),
    [sym_while_statement] = STATE(13),
    [sym_function_statement] = STATE(13),
    [sym_return_statement] = STATE(13),
    [sym_at_root_statement] = STATE(13),
    [sym_error_statement] = STATE(13),
    [sym_warn_statement] = STATE(13),
    [sym_debug_statement] = STATE(13),
    [sym_rule_set] = STATE(13),
    [sym_selectors] = STATE(428),
    [sym__selector] = STATE(274),
    [sym_universal_selector] = STATE(274),
    [sym_class_selector] = STATE(274),
    [sym_pseudo_class_selector] = STATE(274),
    [sym_pseudo_element_selector] = STATE(274),
    [sym_id_selector] = STATE(274),
    [sym_attribute_selector] = STATE(274),
    [sym_child_selector] = STATE(274),
    [sym_descendant_selector] = STATE(274),
    [sym_sibling_selector] = STATE(274),
    [sym_adjacent_sibling_selector] = STATE(274),
    [sym_declaration] = STATE(13),
    [sym_last_declaration] = STATE(464),
    [aux_sym_block_repeat1] = STATE(13),
    [anon_sym_ATimport] = ACTIONS(166),
    [anon_sym_ATmedia] = ACTIONS(168),
    [anon_sym_ATcharset] = ACTIONS(170),
    [anon_sym_ATnamespace] = ACTIONS(172),
    [anon_sym_ATkeyframes] = ACTIONS(174),
    [aux_sym_keyframes_statement_token1] = ACTIONS(174),
    [anon_sym_RBRACE] = ACTIONS(216),
    [anon_sym_ATsupports] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(25),
    [anon_sym_ATmixin] = ACTIONS(180),
    [anon_sym_ATinclude] = ACTIONS(182),
    [anon_sym_ATextend] = ACTIONS(184),
    [anon_sym_ATif] = ACTIONS(186),
    [anon_sym_ATeach] = ACTIONS(188),
    [anon_sym_ATfor] = ACTIONS(190),
    [anon_sym_ATwhile] = ACTIONS(192),
    [anon_sym_ATfunction] = ACTIONS(194),
    [anon_sym_ATreturn] = ACTIONS(196),
    [anon_sym_ATat_DASHroot] = ACTIONS(198),
    [anon_sym_ATerror] = ACTIONS(200),
    [anon_sym_ATwarn] = ACTIONS(202),
    [anon_sym_ATdebug] = ACTIONS(204),
    [sym_nesting_selector] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_DOT] = ACTIONS(53),
    [anon_sym_COLON_COLON] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [sym_string_value] = ACTIONS(61),
    [sym_identifier] = ACTIONS(206),
    [sym_variable_identifier] = ACTIONS(208),
    [sym_at_keyword] = ACTIONS(210),
    [sym_comment] = ACTIONS(3),
    [sym_single_line_comment] = ACTIONS(3),
  },
  [8] = {
    [sym_import_statement] = STATE(14),
    [sym_media_statement] = STATE(14),
    [sym_charset_statement] = STATE(14),
    [sym_namespace_statement] = STATE(14),
    [sym_keyframes_statement] = STATE(14),
    [sym_supports_statement] = STATE(14),
    [sym_at_rule] = STATE(14),
    [sym_mixin_statement] = STATE(14),
    [sym_include_statement] = STATE(14),
    [sym_extend_statement] = STATE(14),
    [sym_if_statement] = STATE(14),
    [sym_if_clause] = STATE(17),
    [sym_each_statement] = STATE(14),
    [sym_for_statement] = STATE(14),
    [sym_while_statement] = STATE(14),
    [sym_function_statement] = STATE(14),
    [sym_return_statement] = STATE(14),
    [sym_at_root_statement] = STATE(14),
    [sym_error_statement] = STATE(14),
    [sym_warn_statement] = STATE(14),
    [sym_debug_statement] = STATE(14),
    [sym_rule_set] = STATE(14),
    [sym_selectors] = STATE(428),
    [sym__selector] = STATE(274),
    [sym_universal_selector] = STATE(274),
    [sym_class_selector] = STATE(274),
    [sym_pseudo_class_selector] = STATE(274),
    [sym_pseudo_element_selector] = STATE(274),
    [sym_id_selector] = STATE(274),
    [sym_attribute_selector] = STATE(274),
    [sym_child_selector] = STATE(274),
    [sym_descendant_selector] = STATE(274),
    [sym_sibling_selector] = STATE(274),
    [sym_adjacent_sibling_selector] = STATE(274),
    [sym_declaration] = STATE(14),
    [sym_last_declaration] = STATE(449),
    [aux_sym_block_repeat1] = STATE(14),
    [anon_sym_ATimport] = ACTIONS(166),
    [anon_sym_ATmedia] = ACTIONS(168),
    [anon_sym_ATcharset] = ACTIONS(170),
    [anon_sym_ATnamespace] = ACTIONS(172),
    [anon_sym_ATkeyframes] = ACTIONS(174),
    [aux_sym_keyframes_statement_token1] = ACTIONS(174),
    [anon_sym_RBRACE] = ACTIONS(218),
    [anon_sym_ATsupports] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(25),
    [anon_sym_ATmixin] = ACTIONS(180),
    [anon_sym_ATinclude] = ACTIONS(182),
    [anon_sym_ATextend] = ACTIONS(184),
    [anon_sym_ATif] = ACTIONS(186),
    [anon_sym_ATeach] = ACTIONS(188),
    [anon_sym_ATfor] = ACTIONS(190),
    [anon_sym_ATwhile] = ACTIONS(192),
    [anon_sym_ATfunction] = ACTIONS(194),
    [anon_sym_ATreturn] = ACTIONS(196),
    [anon_sym_ATat_DASHroot] = ACTIONS(198),
    [anon_sym_ATerror] = ACTIONS(200),
    [anon_sym_ATwarn] = ACTIONS(202),
    [anon_sym_ATdebug] = ACTIONS(204),
    [sym_nesting_selector] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_DOT] = ACTIONS(53),
    [anon_sym_COLON_COLON] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [sym_string_value] = ACTIONS(61),
    [sym_identifier] = ACTIONS(206),
    [sym_variable_identifier] = ACTIONS(208),
    [sym_at_keyword] = ACTIONS(210),
    [sym_comment] = ACTIONS(3),
    [sym_single_line_comment] = ACTIONS(3),
  },
  [9] = {
    [sym_import_statement] = STATE(14),
    [sym_media_statement] = STATE(14),
    [sym_charset_statement] = STATE(14),
    [sym_namespace_statement] = STATE(14),
    [sym_keyframes_statement] = STATE(14),
    [sym_supports_statement] = STATE(14),
    [sym_at_rule] = STATE(14),
    [sym_mixin_statement] = STATE(14),
    [sym_include_statement] = STATE(14),
    [sym_extend_statement] = STATE(14),
    [sym_if_statement] = STATE(14),
    [sym_if_clause] = STATE(17),
    [sym_each_statement] = STATE(14),
    [sym_for_statement] = STATE(14),
    [sym_while_statement] = STATE(14),
    [sym_function_statement] = STATE(14),
    [sym_return_statement] = STATE(14),
    [sym_at_root_statement] = STATE(14),
    [sym_error_statement] = STATE(14),
    [sym_warn_statement] = STATE(14),
    [sym_debug_statement] = STATE(14),
    [sym_rule_set] = STATE(14),
    [sym_selectors] = STATE(428),
    [sym__selector] = STATE(274),
    [sym_universal_selector] = STATE(274),
    [sym_class_selector] = STATE(274),
    [sym_pseudo_class_selector] = STATE(274),
    [sym_pseudo_element_selector] = STATE(274),
    [sym_id_selector] = STATE(274),
    [sym_attribute_selector] = STATE(274),
    [sym_child_selector] = STATE(274),
    [sym_descendant_selector] = STATE(274),
    [sym_sibling_selector] = STATE(274),
    [sym_adjacent_sibling_selector] = STATE(274),
    [sym_declaration] = STATE(14),
    [sym_last_declaration] = STATE(468),
    [aux_sym_block_repeat1] = STATE(14),
    [anon_sym_ATimport] = ACTIONS(166),
    [anon_sym_ATmedia] = ACTIONS(168),
    [anon_sym_ATcharset] = ACTIONS(170),
    [anon_sym_ATnamespace] = ACTIONS(172),
    [anon_sym_ATkeyframes] = ACTIONS(174),
    [aux_sym_keyframes_statement_token1] = ACTIONS(174),
    [anon_sym_RBRACE] = ACTIONS(220),
    [anon_sym_ATsupports] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(25),
    [anon_sym_ATmixin] = ACTIONS(180),
    [anon_sym_ATinclude] = ACTIONS(182),
    [anon_sym_ATextend] = ACTIONS(184),
    [anon_sym_ATif] = ACTIONS(186),
    [anon_sym_ATeach] = ACTIONS(188),
    [anon_sym_ATfor] = ACTIONS(190),
    [anon_sym_ATwhile] = ACTIONS(192),
    [anon_sym_ATfunction] = ACTIONS(194),
    [anon_sym_ATreturn] = ACTIONS(196),
    [anon_sym_ATat_DASHroot] = ACTIONS(198),
    [anon_sym_ATerror] = ACTIONS(200),
    [anon_sym_ATwarn] = ACTIONS(202),
    [anon_sym_ATdebug] = ACTIONS(204),
    [sym_nesting_selector] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_DOT] = ACTIONS(53),
    [anon_sym_COLON_COLON] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [sym_string_value] = ACTIONS(61),
    [sym_identifier] = ACTIONS(206),
    [sym_variable_identifier] = ACTIONS(208),
    [sym_at_keyword] = ACTIONS(210),
    [sym_comment] = ACTIONS(3),
    [sym_single_line_comment] = ACTIONS(3),
  },
  [10] = {
    [sym_import_statement] = STATE(4),
    [sym_media_statement] = STATE(4),
    [sym_charset_statement] = STATE(4),
    [sym_namespace_statement] = STATE(4),
    [sym_keyframes_statement] = STATE(4),
    [sym_supports_statement] = STATE(4),
    [sym_at_rule] = STATE(4),
    [sym_mixin_statement] = STATE(4),
    [sym_include_statement] = STATE(4),
    [sym_extend_statement] = STATE(4),
    [sym_if_statement] = STATE(4),
    [sym_if_clause] = STATE(17),
    [sym_each_statement] = STATE(4),
    [sym_for_statement] = STATE(4),
    [sym_while_statement] = STATE(4),
    [sym_function_statement] = STATE(4),
    [sym_return_statement] = STATE(4),
    [sym_at_root_statement] = STATE(4),
    [sym_error_statement] = STATE(4),
    [sym_warn_statement] = STATE(4),
    [sym_debug_statement] = STATE(4),
    [sym_rule_set] = STATE(4),
    [sym_selectors] = STATE(428),
    [sym__selector] = STATE(274),
    [sym_universal_selector] = STATE(274),
    [sym_class_selector] = STATE(274),
    [sym_pseudo_class_selector] = STATE(274),
    [sym_pseudo_element_selector] = STATE(274),
    [sym_id_selector] = STATE(274),
    [sym_attribute_selector] = STATE(274),
    [sym_child_selector] = STATE(274),
    [sym_descendant_selector] = STATE(274),
    [sym_sibling_selector] = STATE(274),
    [sym_adjacent_sibling_selector] = STATE(274),
    [sym_declaration] = STATE(4),
    [sym_last_declaration] = STATE(470),
    [aux_sym_block_repeat1] = STATE(4),
    [anon_sym_ATimport] = ACTIONS(166),
    [anon_sym_ATmedia] = ACTIONS(168),
    [anon_sym_ATcharset] = ACTIONS(170),
    [anon_sym_ATnamespace] = ACTIONS(172),
    [anon_sym_ATkeyframes] = ACTIONS(174),
    [aux_sym_keyframes_statement_token1] = ACTIONS(174),
    [anon_sym_RBRACE] = ACTIONS(222),
    [anon_sym_ATsupports] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(25),
    [anon_sym_ATmixin] = ACTIONS(180),
    [anon_sym_ATinclude] = ACTIONS(182),
    [anon_sym_ATextend] = ACTIONS(184),
    [anon_sym_ATif] = ACTIONS(186),
    [anon_sym_ATeach] = ACTIONS(188),
    [anon_sym_ATfor] = ACTIONS(190),
    [anon_sym_ATwhile] = ACTIONS(192),
    [anon_sym_ATfunction] = ACTIONS(194),
    [anon_sym_ATreturn] = ACTIONS(196),
    [anon_sym_ATat_DASHroot] = ACTIONS(198),
    [anon_sym_ATerror] = ACTIONS(200),
    [anon_sym_ATwarn] = ACTIONS(202),
    [anon_sym_ATdebug] = ACTIONS(204),
    [sym_nesting_selector] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_DOT] = ACTIONS(53),
    [anon_sym_COLON_COLON] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [sym_string_value] = ACTIONS(61),
    [sym_identifier] = ACTIONS(206),
    [sym_variable_identifier] = ACTIONS(208),
    [sym_at_keyword] = ACTIONS(210),
    [sym_comment] = ACTIONS(3),
    [sym_single_line_comment] = ACTIONS(3),
  },
  [11] = {
    [sym_import_statement] = STATE(6),
    [sym_media_statement] = STATE(6),
    [sym_charset_statement] = STATE(6),
    [sym_namespace_statement] = STATE(6),
    [sym_keyframes_statement] = STATE(6),
    [sym_supports_statement] = STATE(6),
    [sym_at_rule] = STATE(6),
    [sym_mixin_statement] = STATE(6),
    [sym_include_statement] = STATE(6),
    [sym_extend_statement] = STATE(6),
    [sym_if_statement] = STATE(6),
    [sym_if_clause] = STATE(17),
    [sym_each_statement] = STATE(6),
    [sym_for_statement] = STATE(6),
    [sym_while_statement] = STATE(6),
    [sym_function_statement] = STATE(6),
    [sym_return_statement] = STATE(6),
    [sym_at_root_statement] = STATE(6),
    [sym_error_statement] = STATE(6),
    [sym_warn_statement] = STATE(6),
    [sym_debug_statement] = STATE(6),
    [sym_rule_set] = STATE(6),
    [sym_selectors] = STATE(428),
    [sym__selector] = STATE(274),
    [sym_universal_selector] = STATE(274),
    [sym_class_selector] = STATE(274),
    [sym_pseudo_class_selector] = STATE(274),
    [sym_pseudo_element_selector] = STATE(274),
    [sym_id_selector] = STATE(274),
    [sym_attribute_selector] = STATE(274),
    [sym_child_selector] = STATE(274),
    [sym_descendant_selector] = STATE(274),
    [sym_sibling_selector] = STATE(274),
    [sym_adjacent_sibling_selector] = STATE(274),
    [sym_declaration] = STATE(6),
    [sym_last_declaration] = STATE(455),
    [aux_sym_block_repeat1] = STATE(6),
    [anon_sym_ATimport] = ACTIONS(166),
    [anon_sym_ATmedia] = ACTIONS(168),
    [anon_sym_ATcharset] = ACTIONS(170),
    [anon_sym_ATnamespace] = ACTIONS(172),
    [anon_sym_ATkeyframes] = ACTIONS(174),
    [aux_sym_keyframes_statement_token1] = ACTIONS(174),
    [anon_sym_RBRACE] = ACTIONS(224),
    [anon_sym_ATsupports] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(25),
    [anon_sym_ATmixin] = ACTIONS(180),
    [anon_sym_ATinclude] = ACTIONS(182),
    [anon_sym_ATextend] = ACTIONS(184),
    [anon_sym_ATif] = ACTIONS(186),
    [anon_sym_ATeach] = ACTIONS(188),
    [anon_sym_ATfor] = ACTIONS(190),
    [anon_sym_ATwhile] = ACTIONS(192),
    [anon_sym_ATfunction] = ACTIONS(194),
    [anon_sym_ATreturn] = ACTIONS(196),
    [anon_sym_ATat_DASHroot] = ACTIONS(198),
    [anon_sym_ATerror] = ACTIONS(200),
    [anon_sym_ATwarn] = ACTIONS(202),
    [anon_sym_ATdebug] = ACTIONS(204),
    [sym_nesting_selector] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_DOT] = ACTIONS(53),
    [anon_sym_COLON_COLON] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [sym_string_value] = ACTIONS(61),
    [sym_identifier] = ACTIONS(206),
    [sym_variable_identifier] = ACTIONS(208),
    [sym_at_keyword] = ACTIONS(210),
    [sym_comment] = ACTIONS(3),
    [sym_single_line_comment] = ACTIONS(3),
  },
  [12] = {
    [sym_import_statement] = STATE(8),
    [sym_media_statement] = STATE(8),
    [sym_charset_statement] = STATE(8),
    [sym_namespace_statement] = STATE(8),
    [sym_keyframes_statement] = STATE(8),
    [sym_supports_statement] = STATE(8),
    [sym_at_rule] = STATE(8),
    [sym_mixin_statement] = STATE(8),
    [sym_include_statement] = STATE(8),
    [sym_extend_statement] = STATE(8),
    [sym_if_statement] = STATE(8),
    [sym_if_clause] = STATE(17),
    [sym_each_statement] = STATE(8),
    [sym_for_statement] = STATE(8),
    [sym_while_statement] = STATE(8),
    [sym_function_statement] = STATE(8),
    [sym_return_statement] = STATE(8),
    [sym_at_root_statement] = STATE(8),
    [sym_error_statement] = STATE(8),
    [sym_warn_statement] = STATE(8),
    [sym_debug_statement] = STATE(8),
    [sym_rule_set] = STATE(8),
    [sym_selectors] = STATE(428),
    [sym__selector] = STATE(274),
    [sym_universal_selector] = STATE(274),
    [sym_class_selector] = STATE(274),
    [sym_pseudo_class_selector] = STATE(274),
    [sym_pseudo_element_selector] = STATE(274),
    [sym_id_selector] = STATE(274),
    [sym_attribute_selector] = STATE(274),
    [sym_child_selector] = STATE(274),
    [sym_descendant_selector] = STATE(274),
    [sym_sibling_selector] = STATE(274),
    [sym_adjacent_sibling_selector] = STATE(274),
    [sym_declaration] = STATE(8),
    [sym_last_declaration] = STATE(475),
    [aux_sym_block_repeat1] = STATE(8),
    [anon_sym_ATimport] = ACTIONS(166),
    [anon_sym_ATmedia] = ACTIONS(168),
    [anon_sym_ATcharset] = ACTIONS(170),
    [anon_sym_ATnamespace] = ACTIONS(172),
    [anon_sym_ATkeyframes] = ACTIONS(174),
    [aux_sym_keyframes_statement_token1] = ACTIONS(174),
    [anon_sym_RBRACE] = ACTIONS(226),
    [anon_sym_ATsupports] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(25),
    [anon_sym_ATmixin] = ACTIONS(180),
    [anon_sym_ATinclude] = ACTIONS(182),
    [anon_sym_ATextend] = ACTIONS(184),
    [anon_sym_ATif] = ACTIONS(186),
    [anon_sym_ATeach] = ACTIONS(188),
    [anon_sym_ATfor] = ACTIONS(190),
    [anon_sym_ATwhile] = ACTIONS(192),
    [anon_sym_ATfunction] = ACTIONS(194),
    [anon_sym_ATreturn] = ACTIONS(196),
    [anon_sym_ATat_DASHroot] = ACTIONS(198),
    [anon_sym_ATerror] = ACTIONS(200),
    [anon_sym_ATwarn] = ACTIONS(202),
    [anon_sym_ATdebug] = ACTIONS(204),
    [sym_nesting_selector] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_DOT] = ACTIONS(53),
    [anon_sym_COLON_COLON] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [sym_string_value] = ACTIONS(61),
    [sym_identifier] = ACTIONS(206),
    [sym_variable_identifier] = ACTIONS(208),
    [sym_at_keyword] = ACTIONS(210),
    [sym_comment] = ACTIONS(3),
    [sym_single_line_comment] = ACTIONS(3),
  },
  [13] = {
    [sym_import_statement] = STATE(14),
    [sym_media_statement] = STATE(14),
    [sym_charset_statement] = STATE(14),
    [sym_namespace_statement] = STATE(14),
    [sym_keyframes_statement] = STATE(14),
    [sym_supports_statement] = STATE(14),
    [sym_at_rule] = STATE(14),
    [sym_mixin_statement] = STATE(14),
    [sym_include_statement] = STATE(14),
    [sym_extend_statement] = STATE(14),
    [sym_if_statement] = STATE(14),
    [sym_if_clause] = STATE(17),
    [sym_each_statement] = STATE(14),
    [sym_for_statement] = STATE(14),
    [sym_while_statement] = STATE(14),
    [sym_function_statement] = STATE(14),
    [sym_return_statement] = STATE(14),
    [sym_at_root_statement] = STATE(14),
    [sym_error_statement] = STATE(14),
    [sym_warn_statement] = STATE(14),
    [sym_debug_statement] = STATE(14),
    [sym_rule_set] = STATE(14),
    [sym_selectors] = STATE(428),
    [sym__selector] = STATE(274),
    [sym_universal_selector] = STATE(274),
    [sym_class_selector] = STATE(274),
    [sym_pseudo_class_selector] = STATE(274),
    [sym_pseudo_element_selector] = STATE(274),
    [sym_id_selector] = STATE(274),
    [sym_attribute_selector] = STATE(274),
    [sym_child_selector] = STATE(274),
    [sym_descendant_selector] = STATE(274),
    [sym_sibling_selector] = STATE(274),
    [sym_adjacent_sibling_selector] = STATE(274),
    [sym_declaration] = STATE(14),
    [sym_last_declaration] = STATE(467),
    [aux_sym_block_repeat1] = STATE(14),
    [anon_sym_ATimport] = ACTIONS(166),
    [anon_sym_ATmedia] = ACTIONS(168),
    [anon_sym_ATcharset] = ACTIONS(170),
    [anon_sym_ATnamespace] = ACTIONS(172),
    [anon_sym_ATkeyframes] = ACTIONS(174),
    [aux_sym_keyframes_statement_token1] = ACTIONS(174),
    [anon_sym_RBRACE] = ACTIONS(228),
    [anon_sym_ATsupports] = ACTIONS(178),
    [anon_sym_COLON] = ACTIONS(25),
    [anon_sym_ATmixin] = ACTIONS(180),
    [anon_sym_ATinclude] = ACTIONS(182),
    [anon_sym_ATextend] = ACTIONS(184),
    [anon_sym_ATif] = ACTIONS(186),
    [anon_sym_ATeach] = ACTIONS(188),
    [anon_sym_ATfor] = ACTIONS(190),
    [anon_sym_ATwhile] = ACTIONS(192),
    [anon_sym_ATfunction] = ACTIONS(194),
    [anon_sym_ATreturn] = ACTIONS(196),
    [anon_sym_ATat_DASHroot] = ACTIONS(198),
    [anon_sym_ATerror] = ACTIONS(200),
    [anon_sym_ATwarn] = ACTIONS(202),
    [anon_sym_ATdebug] = ACTIONS(204),
    [sym_nesting_selector] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(51),
    [anon_sym_DOT] = ACTIONS(53),
    [anon_sym_COLON_COLON] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [sym_string_value] = ACTIONS(61),
    [sym_identifier] = ACTIONS(206),
    [sym_variable_identifier] = ACTIONS(208),
    [sym_at_keyword] = ACTIONS(210),
    [sym_comment] = ACTIONS(3),
    [sym_single_line_comment] = ACTIONS(3),
  },
  [14] = {
    [sym_import_statement] = STATE(14),
    [sym_media_statement] = STATE(14),
    [sym_charset_statement] = STATE(14),
    [sym_namespace_statement] = STATE(14),
    [sym_keyframes_statement] = STATE(14),
    [sym_supports_statement] = STATE(14),
    [sym_at_rule] = STATE(14),
    [sym_mixin_statement] = STATE(14),
    [sym_include_statement] = STATE(14),
    [sym_extend_statement] = STATE(14),
    [sym_if_statement] = STATE(14),
    [sym_if_clause] = STATE(17),
    [sym_each_statement] = STATE(14),
    [sym_for_statement] = STATE(14),
    [sym_while_statement] = STATE(14),
    [sym_function_statement] = STATE(14),
    [sym_return_statement] = STATE(14),
    [sym_at_root_statement] = STATE(14),
    [sym_error_statement] = STATE(14),
    [sym_warn_statement] = STATE(14),
    [sym_debug_statement] = STATE(14),
    [sym_rule_set] = STATE(14),
    [sym_selectors] = STATE(428),
    [sym__selector] = STATE(274),
    [sym_universal_selector] = STATE(274),
    [sym_class_selector] = STATE(274),
    [sym_pseudo_class_selector] = STATE(274),
    [sym_pseudo_element_selector] = STATE(274),
    [sym_id_selector] = STATE(274),
    [sym_attribute_selector] = STATE(274),
    [sym_child_selector] = STATE(274),
    [sym_descendant_selector] = STATE(274),
    [sym_sibling_selector] = STATE(274),
    [sym_adjacent_sibling_selector] = STATE(274),
    [sym_declaration] = STATE(14),
    [aux_sym_block_repeat1] = STATE(14),
    [anon_sym_ATimport] = ACTIONS(230),
    [anon_sym_ATmedia] = ACTIONS(233),
    [anon_sym_ATcharset] = ACTIONS(236),
    [anon_sym_ATnamespace] = ACTIONS(239),
    [anon_sym_ATkeyframes] = ACTIONS(242),
    [aux_sym_keyframes_statement_token1] = ACTIONS(242),
    [anon_sym_RBRACE] = ACTIONS(245),
    [anon_sym_ATsupports] = ACTIONS(247),
    [anon_sym_COLON] = ACTIONS(250),
    [anon_sym_ATmixin] = ACTIONS(253),
    [anon_sym_ATinclude] = ACTIONS(256),
    [anon_sym_ATextend] = ACTIONS(259),
    [anon_sym_ATif] = ACTIONS(262),
    [anon_sym_ATeach] = ACTIONS(265),
    [anon_sym_ATfor] = ACTIONS(268),
    [anon_sym_ATwhile] = ACTIONS(271),
    [anon_sym_ATfunction] = ACTIONS(274),
    [anon_sym_ATreturn] = ACTIONS(277),
    [anon_sym_ATat_DASHroot] = ACTIONS(280),
    [anon_sym_ATerror] = ACTIONS(283),
    [anon_sym_ATwarn] = ACTIONS(286),
    [anon_sym_ATdebug] = ACTIONS(289),
    [sym_nesting_selector] = ACTIONS(292),
    [anon_sym_STAR] = ACTIONS(295),
    [anon_sym_DOT] = ACTIONS(298),
    [anon_sym_COLON_COLON] = ACTIONS(301),
    [anon_sym_POUND] = ACTIONS(304),
    [anon_sym_LBRACK] = ACTIONS(307),
    [sym_string_value] = ACTIONS(310),
    [sym_identifier] = ACTIONS(313),
    [sym_variable_identifier] = ACTIONS(316),
    [sym_at_keyword] = ACTIONS(319),
    [sym_comment] = ACTIONS(3),
    [sym_single_line_comment] = ACTIONS(3),
  },
};

static uint16_t ts_small_parse_table[] = {
  [0] = 6,
    ACTIONS(326), 1,
      anon_sym_ATelse,
    STATE(74), 1,
      sym_else_clause,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(16), 2,
      sym_else_if_clause,
      aux_sym_if_statement_repeat1,
    ACTIONS(322), 9,
      ts_builtin_sym_end,
      anon_sym_PERCENT,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(324), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_ATuse,
      anon_sym_ATforward,
      anon_sym_ATapply,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [52] = 6,
    ACTIONS(326), 1,
      anon_sym_ATelse,
    STATE(44), 1,
      sym_else_clause,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(19), 2,
      sym_else_if_clause,
      aux_sym_if_statement_repeat1,
    ACTIONS(328), 9,
      ts_builtin_sym_end,
      anon_sym_PERCENT,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(330), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_ATuse,
      anon_sym_ATforward,
      anon_sym_ATapply,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [104] = 6,
    ACTIONS(332), 1,
      anon_sym_ATelse,
    STATE(120), 1,
      sym_else_clause,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(18), 2,
      sym_else_if_clause,
      aux_sym_if_statement_repeat1,
    ACTIONS(322), 8,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(324), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATextend,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATreturn,
      anon_sym_ATat_DASHroot,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [155] = 6,
    ACTIONS(332), 1,
      anon_sym_ATelse,
    STATE(91), 1,
      sym_else_clause,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(20), 2,
      sym_else_if_clause,
      aux_sym_if_statement_repeat1,
    ACTIONS(328), 8,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(330), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATextend,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATreturn,
      anon_sym_ATat_DASHroot,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [206] = 5,
    ACTIONS(338), 1,
      anon_sym_ATelse,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(19), 2,
      sym_else_if_clause,
      aux_sym_if_statement_repeat1,
    ACTIONS(334), 9,
      ts_builtin_sym_end,
      anon_sym_PERCENT,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(336), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_ATuse,
      anon_sym_ATforward,
      anon_sym_ATapply,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [255] = 5,
    ACTIONS(341), 1,
      anon_sym_ATelse,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(20), 2,
      sym_else_if_clause,
      aux_sym_if_statement_repeat1,
    ACTIONS(334), 8,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(336), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATextend,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATreturn,
      anon_sym_ATat_DASHroot,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [303] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(344), 9,
      ts_builtin_sym_end,
      anon_sym_PERCENT,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(346), 25,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_ATuse,
      anon_sym_ATforward,
      anon_sym_ATapply,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATif,
      anon_sym_ATelse,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [346] = 20,
    ACTIONS(25), 1,
      anon_sym_COLON,
    ACTIONS(49), 1,
      sym_nesting_selector,
    ACTIONS(51), 1,
      anon_sym_STAR,
    ACTIONS(55), 1,
      anon_sym_COLON_COLON,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(348), 1,
      anon_sym_LPAREN,
    ACTIONS(350), 1,
      anon_sym_RPAREN,
    ACTIONS(352), 1,
      anon_sym_DOT,
    ACTIONS(354), 1,
      anon_sym_POUND,
    ACTIONS(356), 1,
      sym_string_value,
    ACTIONS(358), 1,
      aux_sym_integer_value_token1,
    ACTIONS(360), 1,
      aux_sym_float_value_token1,
    ACTIONS(362), 1,
      sym_identifier,
    ACTIONS(364), 1,
      sym_variable_identifier,
    ACTIONS(366), 1,
      sym_plain_value,
    STATE(149), 1,
      sym__value,
    STATE(164), 1,
      aux_sym_apply_statement_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(141), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
    STATE(283), 11,
      sym__selector,
      sym_universal_selector,
      sym_class_selector,
      sym_pseudo_class_selector,
      sym_pseudo_element_selector,
      sym_id_selector,
      sym_attribute_selector,
      sym_child_selector,
      sym_descendant_selector,
      sym_sibling_selector,
      sym_adjacent_sibling_selector,
  [423] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(368), 9,
      ts_builtin_sym_end,
      anon_sym_PERCENT,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(370), 25,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_ATuse,
      anon_sym_ATforward,
      anon_sym_ATapply,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATif,
      anon_sym_ATelse,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [466] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(372), 9,
      ts_builtin_sym_end,
      anon_sym_PERCENT,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(374), 25,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_ATuse,
      anon_sym_ATforward,
      anon_sym_ATapply,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATif,
      anon_sym_ATelse,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [509] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(376), 9,
      ts_builtin_sym_end,
      anon_sym_PERCENT,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(378), 25,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_ATuse,
      anon_sym_ATforward,
      anon_sym_ATapply,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATif,
      anon_sym_ATelse,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [552] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(380), 9,
      ts_builtin_sym_end,
      anon_sym_PERCENT,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(382), 25,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_ATuse,
      anon_sym_ATforward,
      anon_sym_ATapply,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATif,
      anon_sym_ATelse,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [595] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(384), 9,
      ts_builtin_sym_end,
      anon_sym_PERCENT,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(386), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_ATuse,
      anon_sym_ATforward,
      anon_sym_ATapply,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [637] = 19,
    ACTIONS(25), 1,
      anon_sym_COLON,
    ACTIONS(49), 1,
      sym_nesting_selector,
    ACTIONS(51), 1,
      anon_sym_STAR,
    ACTIONS(55), 1,
      anon_sym_COLON_COLON,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(348), 1,
      anon_sym_LPAREN,
    ACTIONS(352), 1,
      anon_sym_DOT,
    ACTIONS(354), 1,
      anon_sym_POUND,
    ACTIONS(356), 1,
      sym_string_value,
    ACTIONS(358), 1,
      aux_sym_integer_value_token1,
    ACTIONS(360), 1,
      aux_sym_float_value_token1,
    ACTIONS(362), 1,
      sym_identifier,
    ACTIONS(364), 1,
      sym_variable_identifier,
    ACTIONS(366), 1,
      sym_plain_value,
    STATE(149), 1,
      sym__value,
    STATE(172), 1,
      aux_sym_apply_statement_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(141), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
    STATE(293), 11,
      sym__selector,
      sym_universal_selector,
      sym_class_selector,
      sym_pseudo_class_selector,
      sym_pseudo_element_selector,
      sym_id_selector,
      sym_attribute_selector,
      sym_child_selector,
      sym_descendant_selector,
      sym_sibling_selector,
      sym_adjacent_sibling_selector,
  [711] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(376), 9,
      ts_builtin_sym_end,
      anon_sym_PERCENT,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(378), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_ATuse,
      anon_sym_ATforward,
      anon_sym_ATapply,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [753] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(388), 9,
      ts_builtin_sym_end,
      anon_sym_PERCENT,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(390), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_ATuse,
      anon_sym_ATforward,
      anon_sym_ATapply,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [795] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(392), 9,
      ts_builtin_sym_end,
      anon_sym_PERCENT,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(394), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_ATuse,
      anon_sym_ATforward,
      anon_sym_ATapply,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [837] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(396), 9,
      ts_builtin_sym_end,
      anon_sym_PERCENT,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(398), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_ATuse,
      anon_sym_ATforward,
      anon_sym_ATapply,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [879] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(400), 9,
      ts_builtin_sym_end,
      anon_sym_PERCENT,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(402), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_ATuse,
      anon_sym_ATforward,
      anon_sym_ATapply,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [921] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(404), 9,
      ts_builtin_sym_end,
      anon_sym_PERCENT,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(406), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_ATuse,
      anon_sym_ATforward,
      anon_sym_ATapply,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [963] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(408), 9,
      ts_builtin_sym_end,
      anon_sym_PERCENT,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(410), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_ATuse,
      anon_sym_ATforward,
      anon_sym_ATapply,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [1005] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(412), 9,
      ts_builtin_sym_end,
      anon_sym_PERCENT,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(414), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_ATuse,
      anon_sym_ATforward,
      anon_sym_ATapply,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [1047] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(416), 9,
      ts_builtin_sym_end,
      anon_sym_PERCENT,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(418), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_ATuse,
      anon_sym_ATforward,
      anon_sym_ATapply,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [1089] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(420), 9,
      ts_builtin_sym_end,
      anon_sym_PERCENT,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(422), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_ATuse,
      anon_sym_ATforward,
      anon_sym_ATapply,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [1131] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(424), 9,
      ts_builtin_sym_end,
      anon_sym_PERCENT,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(426), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_ATuse,
      anon_sym_ATforward,
      anon_sym_ATapply,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [1173] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(428), 9,
      ts_builtin_sym_end,
      anon_sym_PERCENT,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(430), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_ATuse,
      anon_sym_ATforward,
      anon_sym_ATapply,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [1215] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(372), 9,
      ts_builtin_sym_end,
      anon_sym_PERCENT,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(374), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_ATuse,
      anon_sym_ATforward,
      anon_sym_ATapply,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [1257] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(432), 9,
      ts_builtin_sym_end,
      anon_sym_PERCENT,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(434), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_ATuse,
      anon_sym_ATforward,
      anon_sym_ATapply,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [1299] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(436), 9,
      ts_builtin_sym_end,
      anon_sym_PERCENT,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(438), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_ATuse,
      anon_sym_ATforward,
      anon_sym_ATapply,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [1341] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(440), 9,
      ts_builtin_sym_end,
      anon_sym_PERCENT,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(442), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_ATuse,
      anon_sym_ATforward,
      anon_sym_ATapply,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [1383] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(444), 9,
      ts_builtin_sym_end,
      anon_sym_PERCENT,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(446), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_ATuse,
      anon_sym_ATforward,
      anon_sym_ATapply,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [1425] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(448), 9,
      ts_builtin_sym_end,
      anon_sym_PERCENT,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(450), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_ATuse,
      anon_sym_ATforward,
      anon_sym_ATapply,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [1467] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(452), 9,
      ts_builtin_sym_end,
      anon_sym_PERCENT,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(454), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_ATuse,
      anon_sym_ATforward,
      anon_sym_ATapply,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [1509] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(380), 8,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(382), 25,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATextend,
      anon_sym_ATif,
      anon_sym_ATelse,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATreturn,
      anon_sym_ATat_DASHroot,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [1551] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(344), 9,
      ts_builtin_sym_end,
      anon_sym_PERCENT,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(346), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_ATuse,
      anon_sym_ATforward,
      anon_sym_ATapply,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [1593] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(456), 9,
      ts_builtin_sym_end,
      anon_sym_PERCENT,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(458), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_ATuse,
      anon_sym_ATforward,
      anon_sym_ATapply,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [1635] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(460), 9,
      ts_builtin_sym_end,
      anon_sym_PERCENT,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(462), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_ATuse,
      anon_sym_ATforward,
      anon_sym_ATapply,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [1677] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(464), 9,
      ts_builtin_sym_end,
      anon_sym_PERCENT,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(466), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_ATuse,
      anon_sym_ATforward,
      anon_sym_ATapply,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [1719] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(468), 9,
      ts_builtin_sym_end,
      anon_sym_PERCENT,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(470), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_ATuse,
      anon_sym_ATforward,
      anon_sym_ATapply,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [1761] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(472), 9,
      ts_builtin_sym_end,
      anon_sym_PERCENT,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(474), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_ATuse,
      anon_sym_ATforward,
      anon_sym_ATapply,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [1803] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(476), 9,
      ts_builtin_sym_end,
      anon_sym_PERCENT,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(478), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_ATuse,
      anon_sym_ATforward,
      anon_sym_ATapply,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [1845] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(480), 9,
      ts_builtin_sym_end,
      anon_sym_PERCENT,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(482), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_ATuse,
      anon_sym_ATforward,
      anon_sym_ATapply,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [1887] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(484), 9,
      ts_builtin_sym_end,
      anon_sym_PERCENT,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(486), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_ATuse,
      anon_sym_ATforward,
      anon_sym_ATapply,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [1929] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(488), 9,
      ts_builtin_sym_end,
      anon_sym_PERCENT,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(490), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_ATuse,
      anon_sym_ATforward,
      anon_sym_ATapply,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [1971] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(492), 9,
      ts_builtin_sym_end,
      anon_sym_PERCENT,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(494), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_ATuse,
      anon_sym_ATforward,
      anon_sym_ATapply,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [2013] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(496), 9,
      ts_builtin_sym_end,
      anon_sym_PERCENT,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(498), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_ATuse,
      anon_sym_ATforward,
      anon_sym_ATapply,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [2055] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(500), 9,
      ts_builtin_sym_end,
      anon_sym_PERCENT,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(502), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_ATuse,
      anon_sym_ATforward,
      anon_sym_ATapply,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [2097] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(504), 9,
      ts_builtin_sym_end,
      anon_sym_PERCENT,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(506), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_ATuse,
      anon_sym_ATforward,
      anon_sym_ATapply,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [2139] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(508), 9,
      ts_builtin_sym_end,
      anon_sym_PERCENT,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(510), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_ATuse,
      anon_sym_ATforward,
      anon_sym_ATapply,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [2181] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(512), 9,
      ts_builtin_sym_end,
      anon_sym_PERCENT,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(514), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_ATuse,
      anon_sym_ATforward,
      anon_sym_ATapply,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [2223] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(516), 9,
      ts_builtin_sym_end,
      anon_sym_PERCENT,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(518), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_ATuse,
      anon_sym_ATforward,
      anon_sym_ATapply,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [2265] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(368), 8,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(370), 25,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATextend,
      anon_sym_ATif,
      anon_sym_ATelse,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATreturn,
      anon_sym_ATat_DASHroot,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [2307] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(520), 9,
      ts_builtin_sym_end,
      anon_sym_PERCENT,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(522), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_ATuse,
      anon_sym_ATforward,
      anon_sym_ATapply,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [2349] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(524), 9,
      ts_builtin_sym_end,
      anon_sym_PERCENT,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(526), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_ATuse,
      anon_sym_ATforward,
      anon_sym_ATapply,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [2391] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(528), 9,
      ts_builtin_sym_end,
      anon_sym_PERCENT,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(530), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_ATuse,
      anon_sym_ATforward,
      anon_sym_ATapply,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [2433] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(532), 9,
      ts_builtin_sym_end,
      anon_sym_PERCENT,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(534), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_ATuse,
      anon_sym_ATforward,
      anon_sym_ATapply,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [2475] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(372), 8,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(374), 25,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATextend,
      anon_sym_ATif,
      anon_sym_ATelse,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATreturn,
      anon_sym_ATat_DASHroot,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [2517] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(376), 8,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(378), 25,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATextend,
      anon_sym_ATif,
      anon_sym_ATelse,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATreturn,
      anon_sym_ATat_DASHroot,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [2559] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(344), 8,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(346), 25,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATextend,
      anon_sym_ATif,
      anon_sym_ATelse,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATreturn,
      anon_sym_ATat_DASHroot,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [2601] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(328), 9,
      ts_builtin_sym_end,
      anon_sym_PERCENT,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(330), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_ATuse,
      anon_sym_ATforward,
      anon_sym_ATapply,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [2643] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(536), 9,
      ts_builtin_sym_end,
      anon_sym_PERCENT,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(538), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_ATuse,
      anon_sym_ATforward,
      anon_sym_ATapply,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [2685] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(540), 9,
      ts_builtin_sym_end,
      anon_sym_PERCENT,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(542), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_ATuse,
      anon_sym_ATforward,
      anon_sym_ATapply,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [2727] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(544), 9,
      ts_builtin_sym_end,
      anon_sym_PERCENT,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(546), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_ATuse,
      anon_sym_ATforward,
      anon_sym_ATapply,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [2769] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(548), 9,
      ts_builtin_sym_end,
      anon_sym_PERCENT,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(550), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_ATuse,
      anon_sym_ATforward,
      anon_sym_ATapply,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [2811] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(532), 8,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(534), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATextend,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATreturn,
      anon_sym_ATat_DASHroot,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [2852] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(554), 8,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(552), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATextend,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATreturn,
      anon_sym_ATat_DASHroot,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [2893] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(460), 8,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(462), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATextend,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATreturn,
      anon_sym_ATat_DASHroot,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [2934] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(456), 8,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(458), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATextend,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATreturn,
      anon_sym_ATat_DASHroot,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [2975] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(384), 8,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(386), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATextend,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATreturn,
      anon_sym_ATat_DASHroot,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [3016] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(444), 8,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(446), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATextend,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATreturn,
      anon_sym_ATat_DASHroot,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [3057] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(528), 8,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(530), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATextend,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATreturn,
      anon_sym_ATat_DASHroot,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [3098] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(544), 8,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(546), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATextend,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATreturn,
      anon_sym_ATat_DASHroot,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [3139] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(512), 8,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(514), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATextend,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATreturn,
      anon_sym_ATat_DASHroot,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [3180] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(508), 8,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(510), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATextend,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATreturn,
      anon_sym_ATat_DASHroot,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [3221] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(484), 8,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(486), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATextend,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATreturn,
      anon_sym_ATat_DASHroot,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [3262] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(480), 8,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(482), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATextend,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATreturn,
      anon_sym_ATat_DASHroot,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [3303] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(440), 8,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(442), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATextend,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATreturn,
      anon_sym_ATat_DASHroot,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [3344] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(436), 8,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(438), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATextend,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATreturn,
      anon_sym_ATat_DASHroot,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [3385] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(432), 8,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(434), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATextend,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATreturn,
      anon_sym_ATat_DASHroot,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [3426] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(372), 8,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(374), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATextend,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATreturn,
      anon_sym_ATat_DASHroot,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [3467] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(428), 8,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(430), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATextend,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATreturn,
      anon_sym_ATat_DASHroot,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [3508] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(376), 8,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(378), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATextend,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATreturn,
      anon_sym_ATat_DASHroot,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [3549] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(424), 8,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(426), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATextend,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATreturn,
      anon_sym_ATat_DASHroot,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [3590] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(540), 8,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(542), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATextend,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATreturn,
      anon_sym_ATat_DASHroot,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [3631] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(404), 8,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(406), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATextend,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATreturn,
      anon_sym_ATat_DASHroot,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [3672] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(420), 8,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(422), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATextend,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATreturn,
      anon_sym_ATat_DASHroot,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [3713] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(408), 8,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(410), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATextend,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATreturn,
      anon_sym_ATat_DASHroot,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [3754] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(396), 8,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(398), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATextend,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATreturn,
      anon_sym_ATat_DASHroot,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [3795] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(392), 8,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(394), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATextend,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATreturn,
      anon_sym_ATat_DASHroot,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [3836] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(416), 8,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(418), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATextend,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATreturn,
      anon_sym_ATat_DASHroot,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [3877] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(388), 8,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(390), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATextend,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATreturn,
      anon_sym_ATat_DASHroot,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [3918] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(524), 8,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(526), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATextend,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATreturn,
      anon_sym_ATat_DASHroot,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [3959] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(452), 8,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(454), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATextend,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATreturn,
      anon_sym_ATat_DASHroot,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [4000] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(344), 8,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(346), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATextend,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATreturn,
      anon_sym_ATat_DASHroot,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [4041] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(488), 8,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(490), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATextend,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATreturn,
      anon_sym_ATat_DASHroot,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [4082] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(520), 8,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(522), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATextend,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATreturn,
      anon_sym_ATat_DASHroot,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [4123] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(558), 8,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(556), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATextend,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATreturn,
      anon_sym_ATat_DASHroot,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [4164] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(516), 8,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(518), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATextend,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATreturn,
      anon_sym_ATat_DASHroot,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [4205] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(472), 8,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(474), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATextend,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATreturn,
      anon_sym_ATat_DASHroot,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [4246] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(448), 8,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(450), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATextend,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATreturn,
      anon_sym_ATat_DASHroot,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [4287] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(562), 8,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(560), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATextend,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATreturn,
      anon_sym_ATat_DASHroot,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [4328] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(412), 8,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(414), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATextend,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATreturn,
      anon_sym_ATat_DASHroot,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [4369] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(400), 8,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(402), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATextend,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATreturn,
      anon_sym_ATat_DASHroot,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [4410] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(548), 8,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(550), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATextend,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATreturn,
      anon_sym_ATat_DASHroot,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [4451] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(536), 8,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(538), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATextend,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATreturn,
      anon_sym_ATat_DASHroot,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [4492] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(328), 8,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(330), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATextend,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATreturn,
      anon_sym_ATat_DASHroot,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [4533] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(464), 8,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(466), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATextend,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATreturn,
      anon_sym_ATat_DASHroot,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [4574] = 19,
    ACTIONS(25), 1,
      anon_sym_COLON,
    ACTIONS(49), 1,
      sym_nesting_selector,
    ACTIONS(51), 1,
      anon_sym_STAR,
    ACTIONS(55), 1,
      anon_sym_COLON_COLON,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(352), 1,
      anon_sym_DOT,
    ACTIONS(564), 1,
      anon_sym_LPAREN,
    ACTIONS(566), 1,
      anon_sym_POUND,
    ACTIONS(568), 1,
      sym_string_value,
    ACTIONS(570), 1,
      aux_sym_integer_value_token1,
    ACTIONS(572), 1,
      aux_sym_float_value_token1,
    ACTIONS(574), 1,
      sym_identifier,
    ACTIONS(576), 1,
      sym_variable_identifier,
    ACTIONS(578), 1,
      sym_plain_value,
    STATE(324), 1,
      sym_class_selector,
    STATE(326), 1,
      sym__value,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(185), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
    STATE(354), 10,
      sym__selector,
      sym_universal_selector,
      sym_pseudo_class_selector,
      sym_pseudo_element_selector,
      sym_id_selector,
      sym_attribute_selector,
      sym_child_selector,
      sym_descendant_selector,
      sym_sibling_selector,
      sym_adjacent_sibling_selector,
  [4647] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(468), 8,
      anon_sym_RBRACE,
      sym_nesting_selector,
      anon_sym_STAR,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      sym_string_value,
      sym_variable_identifier,
    ACTIONS(470), 24,
      anon_sym_ATimport,
      anon_sym_ATmedia,
      anon_sym_ATcharset,
      anon_sym_ATnamespace,
      anon_sym_ATkeyframes,
      aux_sym_keyframes_statement_token1,
      anon_sym_ATsupports,
      anon_sym_COLON,
      anon_sym_ATmixin,
      anon_sym_ATinclude,
      anon_sym_ATextend,
      anon_sym_ATif,
      anon_sym_ATeach,
      anon_sym_ATfor,
      anon_sym_ATwhile,
      anon_sym_ATfunction,
      anon_sym_ATreturn,
      anon_sym_ATat_DASHroot,
      anon_sym_ATerror,
      anon_sym_ATwarn,
      anon_sym_ATdebug,
      anon_sym_POUND,
      sym_identifier,
      sym_at_keyword,
  [4688] = 18,
    ACTIONS(348), 1,
      anon_sym_LPAREN,
    ACTIONS(358), 1,
      aux_sym_integer_value_token1,
    ACTIONS(360), 1,
      aux_sym_float_value_token1,
    ACTIONS(364), 1,
      sym_variable_identifier,
    ACTIONS(366), 1,
      sym_plain_value,
    ACTIONS(580), 1,
      anon_sym_COMMA,
    ACTIONS(582), 1,
      anon_sym_SEMI,
    ACTIONS(584), 1,
      anon_sym_RBRACE,
    ACTIONS(588), 1,
      anon_sym_POUND,
    ACTIONS(592), 1,
      sym_important,
    ACTIONS(594), 1,
      sym_string_value,
    ACTIONS(596), 1,
      sym_identifier,
    STATE(145), 1,
      sym__value,
    STATE(151), 1,
      aux_sym_declaration_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(586), 5,
      anon_sym_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(590), 5,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
    STATE(141), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [4757] = 17,
    ACTIONS(348), 1,
      anon_sym_LPAREN,
    ACTIONS(358), 1,
      aux_sym_integer_value_token1,
    ACTIONS(360), 1,
      aux_sym_float_value_token1,
    ACTIONS(364), 1,
      sym_variable_identifier,
    ACTIONS(366), 1,
      sym_plain_value,
    ACTIONS(580), 1,
      anon_sym_COMMA,
    ACTIONS(588), 1,
      anon_sym_POUND,
    ACTIONS(594), 1,
      sym_string_value,
    ACTIONS(596), 1,
      sym_identifier,
    ACTIONS(598), 1,
      anon_sym_SEMI,
    ACTIONS(600), 1,
      sym_important,
    STATE(145), 1,
      sym__value,
    STATE(167), 1,
      aux_sym_declaration_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(586), 5,
      anon_sym_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(590), 5,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
    STATE(141), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [4823] = 17,
    ACTIONS(348), 1,
      anon_sym_LPAREN,
    ACTIONS(358), 1,
      aux_sym_integer_value_token1,
    ACTIONS(360), 1,
      aux_sym_float_value_token1,
    ACTIONS(364), 1,
      sym_variable_identifier,
    ACTIONS(366), 1,
      sym_plain_value,
    ACTIONS(580), 1,
      anon_sym_COMMA,
    ACTIONS(588), 1,
      anon_sym_POUND,
    ACTIONS(594), 1,
      sym_string_value,
    ACTIONS(596), 1,
      sym_identifier,
    ACTIONS(602), 1,
      anon_sym_SEMI,
    ACTIONS(604), 1,
      sym_important,
    STATE(145), 1,
      sym__value,
    STATE(166), 1,
      aux_sym_declaration_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(586), 5,
      anon_sym_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(590), 5,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
    STATE(141), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [4889] = 17,
    ACTIONS(348), 1,
      anon_sym_LPAREN,
    ACTIONS(358), 1,
      aux_sym_integer_value_token1,
    ACTIONS(360), 1,
      aux_sym_float_value_token1,
    ACTIONS(364), 1,
      sym_variable_identifier,
    ACTIONS(366), 1,
      sym_plain_value,
    ACTIONS(580), 1,
      anon_sym_COMMA,
    ACTIONS(588), 1,
      anon_sym_POUND,
    ACTIONS(594), 1,
      sym_string_value,
    ACTIONS(596), 1,
      sym_identifier,
    ACTIONS(606), 1,
      anon_sym_SEMI,
    ACTIONS(608), 1,
      sym_important,
    STATE(145), 1,
      sym__value,
    STATE(163), 1,
      aux_sym_declaration_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(586), 5,
      anon_sym_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(590), 5,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
    STATE(141), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [4955] = 17,
    ACTIONS(348), 1,
      anon_sym_LPAREN,
    ACTIONS(358), 1,
      aux_sym_integer_value_token1,
    ACTIONS(360), 1,
      aux_sym_float_value_token1,
    ACTIONS(364), 1,
      sym_variable_identifier,
    ACTIONS(366), 1,
      sym_plain_value,
    ACTIONS(580), 1,
      anon_sym_COMMA,
    ACTIONS(582), 1,
      anon_sym_SEMI,
    ACTIONS(588), 1,
      anon_sym_POUND,
    ACTIONS(594), 1,
      sym_string_value,
    ACTIONS(596), 1,
      sym_identifier,
    ACTIONS(610), 1,
      sym_important,
    STATE(145), 1,
      sym__value,
    STATE(169), 1,
      aux_sym_declaration_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(586), 5,
      anon_sym_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(590), 5,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
    STATE(141), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [5021] = 7,
    ACTIONS(618), 1,
      anon_sym_LPAREN2,
    STATE(143), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(616), 5,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_GT,
      anon_sym_PLUS,
    ACTIONS(620), 6,
      anon_sym_STAR,
      sym_string_value,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(612), 7,
      sym__descendant_operator,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      sym_nesting_selector,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      anon_sym_TILDE,
    ACTIONS(614), 9,
      anon_sym_LPAREN,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_variable_identifier,
      sym_plain_value,
  [5067] = 5,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(626), 5,
      anon_sym_COLON,
      anon_sym_DOT,
      anon_sym_POUND,
      anon_sym_GT,
      anon_sym_PLUS,
    ACTIONS(622), 7,
      sym__descendant_operator,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      sym_nesting_selector,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      anon_sym_TILDE,
    ACTIONS(624), 7,
      anon_sym_LPAREN,
      anon_sym_STAR,
      sym_string_value,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(628), 8,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_variable_identifier,
      sym_plain_value,
  [5107] = 5,
    ACTIONS(618), 1,
      anon_sym_LPAREN2,
    STATE(143), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(620), 11,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_RPAREN,
      anon_sym_STAR,
      sym_important,
      sym_string_value,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(614), 12,
      anon_sym_LPAREN,
      anon_sym_POUND,
      anon_sym_GT,
      anon_sym_PLUS,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_variable_identifier,
      sym_plain_value,
  [5145] = 4,
    ACTIONS(634), 1,
      sym_unit,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(632), 11,
      anon_sym_POUND,
      anon_sym_GT,
      anon_sym_PLUS,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_variable_identifier,
      sym_plain_value,
    ACTIONS(630), 12,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_STAR,
      sym_important,
      sym_string_value,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [5180] = 4,
    ACTIONS(640), 1,
      sym_unit,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(638), 11,
      anon_sym_POUND,
      anon_sym_GT,
      anon_sym_PLUS,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_variable_identifier,
      sym_plain_value,
    ACTIONS(636), 12,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_STAR,
      sym_important,
      sym_string_value,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [5215] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(644), 11,
      anon_sym_POUND,
      anon_sym_GT,
      anon_sym_PLUS,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_variable_identifier,
      sym_plain_value,
    ACTIONS(642), 12,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_STAR,
      sym_important,
      sym_string_value,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [5247] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(648), 11,
      anon_sym_POUND,
      anon_sym_GT,
      anon_sym_PLUS,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_variable_identifier,
      sym_plain_value,
    ACTIONS(646), 12,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_STAR,
      sym_important,
      sym_string_value,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [5279] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(652), 11,
      anon_sym_POUND,
      anon_sym_GT,
      anon_sym_PLUS,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_variable_identifier,
      sym_plain_value,
    ACTIONS(650), 12,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_STAR,
      sym_important,
      sym_string_value,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [5311] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(656), 11,
      anon_sym_POUND,
      anon_sym_GT,
      anon_sym_PLUS,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_variable_identifier,
      sym_plain_value,
    ACTIONS(654), 12,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_STAR,
      sym_important,
      sym_string_value,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [5343] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(660), 11,
      anon_sym_POUND,
      anon_sym_GT,
      anon_sym_PLUS,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_variable_identifier,
      sym_plain_value,
    ACTIONS(658), 12,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_STAR,
      sym_important,
      sym_string_value,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [5375] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(664), 11,
      anon_sym_POUND,
      anon_sym_GT,
      anon_sym_PLUS,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_variable_identifier,
      sym_plain_value,
    ACTIONS(662), 12,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_STAR,
      sym_important,
      sym_string_value,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [5407] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(668), 11,
      anon_sym_POUND,
      anon_sym_GT,
      anon_sym_PLUS,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_variable_identifier,
      sym_plain_value,
    ACTIONS(666), 12,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_STAR,
      sym_important,
      sym_string_value,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [5439] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(628), 11,
      anon_sym_POUND,
      anon_sym_GT,
      anon_sym_PLUS,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_variable_identifier,
      sym_plain_value,
    ACTIONS(624), 12,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_STAR,
      sym_important,
      sym_string_value,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [5471] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(672), 11,
      anon_sym_POUND,
      anon_sym_GT,
      anon_sym_PLUS,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_variable_identifier,
      sym_plain_value,
    ACTIONS(670), 12,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_STAR,
      sym_important,
      sym_string_value,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [5503] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(676), 11,
      anon_sym_POUND,
      anon_sym_GT,
      anon_sym_PLUS,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_variable_identifier,
      sym_plain_value,
    ACTIONS(674), 12,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_STAR,
      sym_important,
      sym_string_value,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [5535] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(680), 11,
      anon_sym_POUND,
      anon_sym_GT,
      anon_sym_PLUS,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
      sym_variable_identifier,
      sym_plain_value,
    ACTIONS(678), 12,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_STAR,
      sym_important,
      sym_string_value,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [5567] = 5,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(586), 5,
      anon_sym_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(590), 5,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(682), 6,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_important,
      sym_string_value,
    ACTIONS(684), 6,
      anon_sym_POUND,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      sym_identifier,
      sym_variable_identifier,
      sym_plain_value,
  [5602] = 9,
    ACTIONS(686), 1,
      anon_sym_SEMI,
    ACTIONS(688), 1,
      anon_sym_LPAREN,
    ACTIONS(696), 1,
      anon_sym_selector,
    ACTIONS(698), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(694), 2,
      anon_sym_not,
      anon_sym_only,
    ACTIONS(692), 4,
      anon_sym_GT,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(690), 6,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    STATE(378), 6,
      sym__query,
      sym_feature_query,
      sym_parenthesized_query,
      sym_binary_query,
      sym_unary_query,
      sym_selector_query,
  [5645] = 5,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(586), 5,
      anon_sym_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(590), 5,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(700), 6,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_LPAREN,
      sym_important,
      sym_string_value,
    ACTIONS(702), 6,
      anon_sym_POUND,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      sym_identifier,
      sym_variable_identifier,
      sym_plain_value,
  [5680] = 9,
    ACTIONS(688), 1,
      anon_sym_LPAREN,
    ACTIONS(696), 1,
      anon_sym_selector,
    ACTIONS(698), 1,
      sym_identifier,
    ACTIONS(704), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(694), 2,
      anon_sym_not,
      anon_sym_only,
    ACTIONS(692), 4,
      anon_sym_GT,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(690), 6,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    STATE(377), 6,
      sym__query,
      sym_feature_query,
      sym_parenthesized_query,
      sym_binary_query,
      sym_unary_query,
      sym_selector_query,
  [5723] = 5,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(586), 5,
      anon_sym_STAR,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(590), 5,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(706), 5,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_string_value,
    ACTIONS(708), 6,
      anon_sym_POUND,
      aux_sym_integer_value_token1,
      aux_sym_float_value_token1,
      sym_identifier,
      sym_variable_identifier,
      sym_plain_value,
  [5757] = 7,
    ACTIONS(710), 1,
      anon_sym_LPAREN2,
    STATE(207), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(614), 2,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(616), 2,
      anon_sym_COLON,
      anon_sym_GT,
    ACTIONS(620), 7,
      anon_sym_SEMI,
      anon_sym_STAR,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(612), 8,
      sym__descendant_operator,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_TILDE,
      anon_sym_PLUS,
  [5795] = 16,
    ACTIONS(348), 1,
      anon_sym_LPAREN,
    ACTIONS(358), 1,
      aux_sym_integer_value_token1,
    ACTIONS(360), 1,
      aux_sym_float_value_token1,
    ACTIONS(364), 1,
      sym_variable_identifier,
    ACTIONS(366), 1,
      sym_plain_value,
    ACTIONS(580), 1,
      anon_sym_COMMA,
    ACTIONS(588), 1,
      anon_sym_POUND,
    ACTIONS(594), 1,
      sym_string_value,
    ACTIONS(596), 1,
      sym_identifier,
    ACTIONS(712), 1,
      anon_sym_SEMI,
    ACTIONS(714), 1,
      anon_sym_RBRACE,
    ACTIONS(716), 1,
      sym_important,
    STATE(145), 1,
      sym__value,
    STATE(161), 1,
      aux_sym_declaration_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(141), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [5850] = 11,
    ACTIONS(25), 1,
      anon_sym_COLON,
    ACTIONS(49), 1,
      sym_nesting_selector,
    ACTIONS(51), 1,
      anon_sym_STAR,
    ACTIONS(53), 1,
      anon_sym_DOT,
    ACTIONS(55), 1,
      anon_sym_COLON_COLON,
    ACTIONS(57), 1,
      anon_sym_POUND,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(718), 1,
      sym_string_value,
    ACTIONS(720), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(305), 11,
      sym__selector,
      sym_universal_selector,
      sym_class_selector,
      sym_pseudo_class_selector,
      sym_pseudo_element_selector,
      sym_id_selector,
      sym_attribute_selector,
      sym_child_selector,
      sym_descendant_selector,
      sym_sibling_selector,
      sym_adjacent_sibling_selector,
  [5895] = 11,
    ACTIONS(25), 1,
      anon_sym_COLON,
    ACTIONS(49), 1,
      sym_nesting_selector,
    ACTIONS(51), 1,
      anon_sym_STAR,
    ACTIONS(53), 1,
      anon_sym_DOT,
    ACTIONS(55), 1,
      anon_sym_COLON_COLON,
    ACTIONS(57), 1,
      anon_sym_POUND,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(720), 1,
      sym_identifier,
    ACTIONS(722), 1,
      sym_string_value,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(288), 11,
      sym__selector,
      sym_universal_selector,
      sym_class_selector,
      sym_pseudo_class_selector,
      sym_pseudo_element_selector,
      sym_id_selector,
      sym_attribute_selector,
      sym_child_selector,
      sym_descendant_selector,
      sym_sibling_selector,
      sym_adjacent_sibling_selector,
  [5940] = 11,
    ACTIONS(25), 1,
      anon_sym_COLON,
    ACTIONS(49), 1,
      sym_nesting_selector,
    ACTIONS(51), 1,
      anon_sym_STAR,
    ACTIONS(53), 1,
      anon_sym_DOT,
    ACTIONS(55), 1,
      anon_sym_COLON_COLON,
    ACTIONS(57), 1,
      anon_sym_POUND,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(720), 1,
      sym_identifier,
    ACTIONS(724), 1,
      sym_string_value,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(281), 11,
      sym__selector,
      sym_universal_selector,
      sym_class_selector,
      sym_pseudo_class_selector,
      sym_pseudo_element_selector,
      sym_id_selector,
      sym_attribute_selector,
      sym_child_selector,
      sym_descendant_selector,
      sym_sibling_selector,
      sym_adjacent_sibling_selector,
  [5985] = 15,
    ACTIONS(348), 1,
      anon_sym_LPAREN,
    ACTIONS(358), 1,
      aux_sym_integer_value_token1,
    ACTIONS(360), 1,
      aux_sym_float_value_token1,
    ACTIONS(364), 1,
      sym_variable_identifier,
    ACTIONS(366), 1,
      sym_plain_value,
    ACTIONS(588), 1,
      anon_sym_POUND,
    ACTIONS(594), 1,
      sym_string_value,
    ACTIONS(596), 1,
      sym_identifier,
    ACTIONS(728), 1,
      anon_sym_RPAREN,
    STATE(149), 1,
      sym__value,
    STATE(168), 1,
      aux_sym_apply_statement_repeat1,
    STATE(390), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(726), 2,
      anon_sym_COMMA,
      anon_sym_SEMI,
    STATE(141), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [6038] = 15,
    ACTIONS(348), 1,
      anon_sym_LPAREN,
    ACTIONS(358), 1,
      aux_sym_integer_value_token1,
    ACTIONS(360), 1,
      aux_sym_float_value_token1,
    ACTIONS(364), 1,
      sym_variable_identifier,
    ACTIONS(366), 1,
      sym_plain_value,
    ACTIONS(588), 1,
      anon_sym_POUND,
    ACTIONS(594), 1,
      sym_string_value,
    ACTIONS(596), 1,
      sym_identifier,
    ACTIONS(730), 1,
      anon_sym_RPAREN,
    STATE(149), 1,
      sym__value,
    STATE(168), 1,
      aux_sym_apply_statement_repeat1,
    STATE(383), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(726), 2,
      anon_sym_COMMA,
      anon_sym_SEMI,
    STATE(141), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [6091] = 11,
    ACTIONS(25), 1,
      anon_sym_COLON,
    ACTIONS(49), 1,
      sym_nesting_selector,
    ACTIONS(51), 1,
      anon_sym_STAR,
    ACTIONS(53), 1,
      anon_sym_DOT,
    ACTIONS(55), 1,
      anon_sym_COLON_COLON,
    ACTIONS(57), 1,
      anon_sym_POUND,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(720), 1,
      sym_identifier,
    ACTIONS(732), 1,
      sym_string_value,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(346), 11,
      sym__selector,
      sym_universal_selector,
      sym_class_selector,
      sym_pseudo_class_selector,
      sym_pseudo_element_selector,
      sym_id_selector,
      sym_attribute_selector,
      sym_child_selector,
      sym_descendant_selector,
      sym_sibling_selector,
      sym_adjacent_sibling_selector,
  [6136] = 11,
    ACTIONS(25), 1,
      anon_sym_COLON,
    ACTIONS(49), 1,
      sym_nesting_selector,
    ACTIONS(51), 1,
      anon_sym_STAR,
    ACTIONS(53), 1,
      anon_sym_DOT,
    ACTIONS(55), 1,
      anon_sym_COLON_COLON,
    ACTIONS(57), 1,
      anon_sym_POUND,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(720), 1,
      sym_identifier,
    ACTIONS(734), 1,
      sym_string_value,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(277), 11,
      sym__selector,
      sym_universal_selector,
      sym_class_selector,
      sym_pseudo_class_selector,
      sym_pseudo_element_selector,
      sym_id_selector,
      sym_attribute_selector,
      sym_child_selector,
      sym_descendant_selector,
      sym_sibling_selector,
      sym_adjacent_sibling_selector,
  [6181] = 15,
    ACTIONS(348), 1,
      anon_sym_LPAREN,
    ACTIONS(358), 1,
      aux_sym_integer_value_token1,
    ACTIONS(360), 1,
      aux_sym_float_value_token1,
    ACTIONS(364), 1,
      sym_variable_identifier,
    ACTIONS(366), 1,
      sym_plain_value,
    ACTIONS(588), 1,
      anon_sym_POUND,
    ACTIONS(594), 1,
      sym_string_value,
    ACTIONS(596), 1,
      sym_identifier,
    ACTIONS(736), 1,
      anon_sym_RPAREN,
    STATE(149), 1,
      sym__value,
    STATE(168), 1,
      aux_sym_apply_statement_repeat1,
    STATE(388), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(726), 2,
      anon_sym_COMMA,
      anon_sym_SEMI,
    STATE(141), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [6234] = 15,
    ACTIONS(348), 1,
      anon_sym_LPAREN,
    ACTIONS(358), 1,
      aux_sym_integer_value_token1,
    ACTIONS(360), 1,
      aux_sym_float_value_token1,
    ACTIONS(364), 1,
      sym_variable_identifier,
    ACTIONS(366), 1,
      sym_plain_value,
    ACTIONS(588), 1,
      anon_sym_POUND,
    ACTIONS(594), 1,
      sym_string_value,
    ACTIONS(596), 1,
      sym_identifier,
    ACTIONS(738), 1,
      anon_sym_RPAREN,
    STATE(149), 1,
      sym__value,
    STATE(168), 1,
      aux_sym_apply_statement_repeat1,
    STATE(385), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(726), 2,
      anon_sym_COMMA,
      anon_sym_SEMI,
    STATE(141), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [6287] = 14,
    ACTIONS(740), 1,
      anon_sym_COMMA,
    ACTIONS(743), 1,
      anon_sym_LPAREN,
    ACTIONS(746), 1,
      anon_sym_POUND,
    ACTIONS(749), 1,
      sym_string_value,
    ACTIONS(752), 1,
      aux_sym_integer_value_token1,
    ACTIONS(755), 1,
      aux_sym_float_value_token1,
    ACTIONS(758), 1,
      sym_identifier,
    ACTIONS(761), 1,
      sym_variable_identifier,
    ACTIONS(764), 1,
      sym_plain_value,
    STATE(145), 1,
      sym__value,
    STATE(161), 1,
      aux_sym_declaration_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(700), 3,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      sym_important,
    STATE(141), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [6338] = 11,
    ACTIONS(25), 1,
      anon_sym_COLON,
    ACTIONS(49), 1,
      sym_nesting_selector,
    ACTIONS(51), 1,
      anon_sym_STAR,
    ACTIONS(53), 1,
      anon_sym_DOT,
    ACTIONS(55), 1,
      anon_sym_COLON_COLON,
    ACTIONS(57), 1,
      anon_sym_POUND,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(720), 1,
      sym_identifier,
    ACTIONS(767), 1,
      sym_string_value,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(280), 11,
      sym__selector,
      sym_universal_selector,
      sym_class_selector,
      sym_pseudo_class_selector,
      sym_pseudo_element_selector,
      sym_id_selector,
      sym_attribute_selector,
      sym_child_selector,
      sym_descendant_selector,
      sym_sibling_selector,
      sym_adjacent_sibling_selector,
  [6383] = 15,
    ACTIONS(348), 1,
      anon_sym_LPAREN,
    ACTIONS(358), 1,
      aux_sym_integer_value_token1,
    ACTIONS(360), 1,
      aux_sym_float_value_token1,
    ACTIONS(364), 1,
      sym_variable_identifier,
    ACTIONS(366), 1,
      sym_plain_value,
    ACTIONS(580), 1,
      anon_sym_COMMA,
    ACTIONS(588), 1,
      anon_sym_POUND,
    ACTIONS(594), 1,
      sym_string_value,
    ACTIONS(596), 1,
      sym_identifier,
    ACTIONS(769), 1,
      anon_sym_SEMI,
    ACTIONS(771), 1,
      sym_important,
    STATE(145), 1,
      sym__value,
    STATE(161), 1,
      aux_sym_declaration_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(141), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [6435] = 15,
    ACTIONS(348), 1,
      anon_sym_LPAREN,
    ACTIONS(358), 1,
      aux_sym_integer_value_token1,
    ACTIONS(360), 1,
      aux_sym_float_value_token1,
    ACTIONS(364), 1,
      sym_variable_identifier,
    ACTIONS(366), 1,
      sym_plain_value,
    ACTIONS(588), 1,
      anon_sym_POUND,
    ACTIONS(594), 1,
      sym_string_value,
    ACTIONS(596), 1,
      sym_identifier,
    ACTIONS(773), 1,
      anon_sym_COMMA,
    ACTIONS(775), 1,
      anon_sym_RPAREN,
    STATE(149), 1,
      sym__value,
    STATE(168), 1,
      aux_sym_apply_statement_repeat1,
    STATE(406), 1,
      aux_sym_pseudo_class_arguments_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(141), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [6487] = 5,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(626), 2,
      anon_sym_COLON,
      anon_sym_GT,
    ACTIONS(628), 2,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(624), 7,
      anon_sym_SEMI,
      anon_sym_STAR,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(622), 8,
      sym__descendant_operator,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_TILDE,
      anon_sym_PLUS,
  [6519] = 15,
    ACTIONS(348), 1,
      anon_sym_LPAREN,
    ACTIONS(358), 1,
      aux_sym_integer_value_token1,
    ACTIONS(360), 1,
      aux_sym_float_value_token1,
    ACTIONS(364), 1,
      sym_variable_identifier,
    ACTIONS(366), 1,
      sym_plain_value,
    ACTIONS(580), 1,
      anon_sym_COMMA,
    ACTIONS(588), 1,
      anon_sym_POUND,
    ACTIONS(594), 1,
      sym_string_value,
    ACTIONS(596), 1,
      sym_identifier,
    ACTIONS(777), 1,
      anon_sym_SEMI,
    ACTIONS(779), 1,
      sym_important,
    STATE(145), 1,
      sym__value,
    STATE(161), 1,
      aux_sym_declaration_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(141), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [6571] = 15,
    ACTIONS(348), 1,
      anon_sym_LPAREN,
    ACTIONS(358), 1,
      aux_sym_integer_value_token1,
    ACTIONS(360), 1,
      aux_sym_float_value_token1,
    ACTIONS(364), 1,
      sym_variable_identifier,
    ACTIONS(366), 1,
      sym_plain_value,
    ACTIONS(580), 1,
      anon_sym_COMMA,
    ACTIONS(588), 1,
      anon_sym_POUND,
    ACTIONS(594), 1,
      sym_string_value,
    ACTIONS(596), 1,
      sym_identifier,
    ACTIONS(781), 1,
      anon_sym_SEMI,
    ACTIONS(783), 1,
      sym_important,
    STATE(145), 1,
      sym__value,
    STATE(161), 1,
      aux_sym_declaration_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(141), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [6623] = 13,
    ACTIONS(787), 1,
      anon_sym_LPAREN,
    ACTIONS(790), 1,
      anon_sym_POUND,
    ACTIONS(793), 1,
      sym_string_value,
    ACTIONS(796), 1,
      aux_sym_integer_value_token1,
    ACTIONS(799), 1,
      aux_sym_float_value_token1,
    ACTIONS(802), 1,
      sym_identifier,
    ACTIONS(805), 1,
      sym_variable_identifier,
    ACTIONS(808), 1,
      sym_plain_value,
    STATE(149), 1,
      sym__value,
    STATE(168), 1,
      aux_sym_apply_statement_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(785), 3,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RPAREN,
    STATE(141), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [6671] = 15,
    ACTIONS(348), 1,
      anon_sym_LPAREN,
    ACTIONS(358), 1,
      aux_sym_integer_value_token1,
    ACTIONS(360), 1,
      aux_sym_float_value_token1,
    ACTIONS(364), 1,
      sym_variable_identifier,
    ACTIONS(366), 1,
      sym_plain_value,
    ACTIONS(580), 1,
      anon_sym_COMMA,
    ACTIONS(588), 1,
      anon_sym_POUND,
    ACTIONS(594), 1,
      sym_string_value,
    ACTIONS(596), 1,
      sym_identifier,
    ACTIONS(712), 1,
      anon_sym_SEMI,
    ACTIONS(811), 1,
      sym_important,
    STATE(145), 1,
      sym__value,
    STATE(161), 1,
      aux_sym_declaration_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(141), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [6723] = 13,
    ACTIONS(348), 1,
      anon_sym_LPAREN,
    ACTIONS(358), 1,
      aux_sym_integer_value_token1,
    ACTIONS(360), 1,
      aux_sym_float_value_token1,
    ACTIONS(364), 1,
      sym_variable_identifier,
    ACTIONS(366), 1,
      sym_plain_value,
    ACTIONS(588), 1,
      anon_sym_POUND,
    ACTIONS(594), 1,
      sym_string_value,
    ACTIONS(596), 1,
      sym_identifier,
    STATE(149), 1,
      sym__value,
    STATE(168), 1,
      aux_sym_apply_statement_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(813), 3,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_RPAREN,
    STATE(141), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [6771] = 5,
    ACTIONS(710), 1,
      anon_sym_LPAREN2,
    STATE(207), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(614), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(620), 13,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RPAREN,
      anon_sym_through,
      anon_sym_STAR,
      anon_sym_RBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [6802] = 13,
    ACTIONS(348), 1,
      anon_sym_LPAREN,
    ACTIONS(358), 1,
      aux_sym_integer_value_token1,
    ACTIONS(360), 1,
      aux_sym_float_value_token1,
    ACTIONS(364), 1,
      sym_variable_identifier,
    ACTIONS(366), 1,
      sym_plain_value,
    ACTIONS(588), 1,
      anon_sym_POUND,
    ACTIONS(594), 1,
      sym_string_value,
    ACTIONS(596), 1,
      sym_identifier,
    STATE(149), 1,
      sym__value,
    STATE(168), 1,
      aux_sym_apply_statement_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(815), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    STATE(141), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [6849] = 5,
    ACTIONS(817), 1,
      anon_sym_LPAREN2,
    STATE(193), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(620), 7,
      anon_sym_SEMI,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(614), 9,
      anon_sym_LPAREN,
      anon_sym_GT,
      anon_sym_not,
      anon_sym_only,
      anon_sym_selector,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
  [6880] = 13,
    ACTIONS(348), 1,
      anon_sym_LPAREN,
    ACTIONS(358), 1,
      aux_sym_integer_value_token1,
    ACTIONS(360), 1,
      aux_sym_float_value_token1,
    ACTIONS(364), 1,
      sym_variable_identifier,
    ACTIONS(366), 1,
      sym_plain_value,
    ACTIONS(588), 1,
      anon_sym_POUND,
    ACTIONS(594), 1,
      sym_string_value,
    ACTIONS(596), 1,
      sym_identifier,
    ACTIONS(819), 1,
      anon_sym_SEMI,
    STATE(149), 1,
      sym__value,
    STATE(175), 1,
      aux_sym_apply_statement_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(141), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [6926] = 13,
    ACTIONS(348), 1,
      anon_sym_LPAREN,
    ACTIONS(358), 1,
      aux_sym_integer_value_token1,
    ACTIONS(360), 1,
      aux_sym_float_value_token1,
    ACTIONS(364), 1,
      sym_variable_identifier,
    ACTIONS(366), 1,
      sym_plain_value,
    ACTIONS(588), 1,
      anon_sym_POUND,
    ACTIONS(594), 1,
      sym_string_value,
    ACTIONS(596), 1,
      sym_identifier,
    ACTIONS(821), 1,
      anon_sym_SEMI,
    STATE(149), 1,
      sym__value,
    STATE(168), 1,
      aux_sym_apply_statement_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(141), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [6972] = 13,
    ACTIONS(348), 1,
      anon_sym_LPAREN,
    ACTIONS(358), 1,
      aux_sym_integer_value_token1,
    ACTIONS(360), 1,
      aux_sym_float_value_token1,
    ACTIONS(364), 1,
      sym_variable_identifier,
    ACTIONS(366), 1,
      sym_plain_value,
    ACTIONS(588), 1,
      anon_sym_POUND,
    ACTIONS(594), 1,
      sym_string_value,
    ACTIONS(596), 1,
      sym_identifier,
    ACTIONS(823), 1,
      anon_sym_RPAREN,
    STATE(149), 1,
      sym__value,
    STATE(159), 1,
      aux_sym_apply_statement_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(141), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [7018] = 13,
    ACTIONS(348), 1,
      anon_sym_LPAREN,
    ACTIONS(358), 1,
      aux_sym_integer_value_token1,
    ACTIONS(360), 1,
      aux_sym_float_value_token1,
    ACTIONS(364), 1,
      sym_variable_identifier,
    ACTIONS(366), 1,
      sym_plain_value,
    ACTIONS(588), 1,
      anon_sym_POUND,
    ACTIONS(594), 1,
      sym_string_value,
    ACTIONS(596), 1,
      sym_identifier,
    ACTIONS(825), 1,
      anon_sym_RPAREN,
    STATE(149), 1,
      sym__value,
    STATE(160), 1,
      aux_sym_apply_statement_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(141), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [7064] = 13,
    ACTIONS(348), 1,
      anon_sym_LPAREN,
    ACTIONS(358), 1,
      aux_sym_integer_value_token1,
    ACTIONS(360), 1,
      aux_sym_float_value_token1,
    ACTIONS(364), 1,
      sym_variable_identifier,
    ACTIONS(366), 1,
      sym_plain_value,
    ACTIONS(588), 1,
      anon_sym_POUND,
    ACTIONS(594), 1,
      sym_string_value,
    ACTIONS(596), 1,
      sym_identifier,
    ACTIONS(827), 1,
      anon_sym_RPAREN,
    STATE(149), 1,
      sym__value,
    STATE(168), 1,
      aux_sym_apply_statement_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(141), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [7110] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(644), 8,
      anon_sym_GT,
      anon_sym_not,
      anon_sym_only,
      anon_sym_selector,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
    ACTIONS(642), 9,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [7136] = 4,
    ACTIONS(829), 1,
      sym_unit,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(636), 8,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(638), 8,
      anon_sym_GT,
      anon_sym_not,
      anon_sym_only,
      anon_sym_selector,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
  [7164] = 13,
    ACTIONS(348), 1,
      anon_sym_LPAREN,
    ACTIONS(358), 1,
      aux_sym_integer_value_token1,
    ACTIONS(360), 1,
      aux_sym_float_value_token1,
    ACTIONS(364), 1,
      sym_variable_identifier,
    ACTIONS(366), 1,
      sym_plain_value,
    ACTIONS(588), 1,
      anon_sym_POUND,
    ACTIONS(594), 1,
      sym_string_value,
    ACTIONS(596), 1,
      sym_identifier,
    ACTIONS(831), 1,
      anon_sym_RPAREN,
    STATE(149), 1,
      sym__value,
    STATE(155), 1,
      aux_sym_apply_statement_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(141), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [7210] = 13,
    ACTIONS(348), 1,
      anon_sym_LPAREN,
    ACTIONS(358), 1,
      aux_sym_integer_value_token1,
    ACTIONS(360), 1,
      aux_sym_float_value_token1,
    ACTIONS(364), 1,
      sym_variable_identifier,
    ACTIONS(366), 1,
      sym_plain_value,
    ACTIONS(588), 1,
      anon_sym_POUND,
    ACTIONS(594), 1,
      sym_string_value,
    ACTIONS(596), 1,
      sym_identifier,
    ACTIONS(833), 1,
      anon_sym_RPAREN,
    STATE(149), 1,
      sym__value,
    STATE(156), 1,
      aux_sym_apply_statement_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(141), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [7256] = 4,
    ACTIONS(835), 1,
      sym_unit,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(630), 8,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(632), 8,
      anon_sym_GT,
      anon_sym_not,
      anon_sym_only,
      anon_sym_selector,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
  [7284] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(668), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(666), 13,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RPAREN,
      anon_sym_through,
      anon_sym_STAR,
      anon_sym_RBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [7309] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(628), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(624), 13,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RPAREN,
      anon_sym_through,
      anon_sym_STAR,
      anon_sym_RBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [7334] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(670), 8,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(672), 8,
      anon_sym_GT,
      anon_sym_not,
      anon_sym_only,
      anon_sym_selector,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
  [7359] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(678), 8,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(680), 8,
      anon_sym_GT,
      anon_sym_not,
      anon_sym_only,
      anon_sym_selector,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
  [7384] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(666), 8,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(668), 8,
      anon_sym_GT,
      anon_sym_not,
      anon_sym_only,
      anon_sym_selector,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
  [7409] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(656), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(654), 13,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RPAREN,
      anon_sym_through,
      anon_sym_STAR,
      anon_sym_RBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [7434] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(652), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(650), 13,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RPAREN,
      anon_sym_through,
      anon_sym_STAR,
      anon_sym_RBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [7459] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(662), 8,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(664), 8,
      anon_sym_GT,
      anon_sym_not,
      anon_sym_only,
      anon_sym_selector,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
  [7484] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(624), 8,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(628), 8,
      anon_sym_GT,
      anon_sym_not,
      anon_sym_only,
      anon_sym_selector,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
  [7509] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(674), 8,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(676), 8,
      anon_sym_GT,
      anon_sym_not,
      anon_sym_only,
      anon_sym_selector,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
  [7534] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(648), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(646), 13,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RPAREN,
      anon_sym_through,
      anon_sym_STAR,
      anon_sym_RBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [7559] = 12,
    ACTIONS(348), 1,
      anon_sym_LPAREN,
    ACTIONS(358), 1,
      aux_sym_integer_value_token1,
    ACTIONS(360), 1,
      aux_sym_float_value_token1,
    ACTIONS(364), 1,
      sym_variable_identifier,
    ACTIONS(366), 1,
      sym_plain_value,
    ACTIONS(588), 1,
      anon_sym_POUND,
    ACTIONS(594), 1,
      sym_string_value,
    ACTIONS(596), 1,
      sym_identifier,
    STATE(149), 1,
      sym__value,
    STATE(178), 1,
      aux_sym_apply_statement_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(141), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [7602] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(672), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(670), 13,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RPAREN,
      anon_sym_through,
      anon_sym_STAR,
      anon_sym_RBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [7627] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(646), 8,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(648), 8,
      anon_sym_GT,
      anon_sym_not,
      anon_sym_only,
      anon_sym_selector,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
  [7652] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(680), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(678), 13,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RPAREN,
      anon_sym_through,
      anon_sym_STAR,
      anon_sym_RBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [7677] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(660), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(658), 13,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RPAREN,
      anon_sym_through,
      anon_sym_STAR,
      anon_sym_RBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [7702] = 12,
    ACTIONS(348), 1,
      anon_sym_LPAREN,
    ACTIONS(358), 1,
      aux_sym_integer_value_token1,
    ACTIONS(360), 1,
      aux_sym_float_value_token1,
    ACTIONS(364), 1,
      sym_variable_identifier,
    ACTIONS(366), 1,
      sym_plain_value,
    ACTIONS(588), 1,
      anon_sym_POUND,
    ACTIONS(594), 1,
      sym_string_value,
    ACTIONS(596), 1,
      sym_identifier,
    STATE(149), 1,
      sym__value,
    STATE(170), 1,
      aux_sym_apply_statement_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(141), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [7745] = 4,
    ACTIONS(837), 1,
      sym_unit,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(632), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(630), 12,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RPAREN,
      anon_sym_STAR,
      anon_sym_RBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [7772] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(664), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(662), 13,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RPAREN,
      anon_sym_through,
      anon_sym_STAR,
      anon_sym_RBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [7797] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(644), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(642), 13,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RPAREN,
      anon_sym_through,
      anon_sym_STAR,
      anon_sym_RBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [7822] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(654), 8,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(656), 8,
      anon_sym_GT,
      anon_sym_not,
      anon_sym_only,
      anon_sym_selector,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
  [7847] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(650), 8,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(652), 8,
      anon_sym_GT,
      anon_sym_not,
      anon_sym_only,
      anon_sym_selector,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
  [7872] = 12,
    ACTIONS(839), 1,
      anon_sym_LPAREN,
    ACTIONS(841), 1,
      anon_sym_POUND,
    ACTIONS(843), 1,
      sym_string_value,
    ACTIONS(845), 1,
      aux_sym_integer_value_token1,
    ACTIONS(847), 1,
      aux_sym_float_value_token1,
    ACTIONS(849), 1,
      sym_identifier,
    ACTIONS(851), 1,
      sym_variable_identifier,
    ACTIONS(853), 1,
      sym_plain_value,
    STATE(318), 1,
      sym__value,
    STATE(423), 1,
      sym_include_argument,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(300), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [7915] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(676), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(674), 13,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RPAREN,
      anon_sym_through,
      anon_sym_STAR,
      anon_sym_RBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [7940] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(658), 8,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(660), 8,
      anon_sym_GT,
      anon_sym_not,
      anon_sym_only,
      anon_sym_selector,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      sym_identifier,
  [7965] = 4,
    ACTIONS(855), 1,
      sym_unit,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(638), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(636), 12,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RPAREN,
      anon_sym_STAR,
      anon_sym_RBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [7992] = 12,
    ACTIONS(839), 1,
      anon_sym_LPAREN,
    ACTIONS(841), 1,
      anon_sym_POUND,
    ACTIONS(843), 1,
      sym_string_value,
    ACTIONS(845), 1,
      aux_sym_integer_value_token1,
    ACTIONS(847), 1,
      aux_sym_float_value_token1,
    ACTIONS(849), 1,
      sym_identifier,
    ACTIONS(851), 1,
      sym_variable_identifier,
    ACTIONS(853), 1,
      sym_plain_value,
    STATE(318), 1,
      sym__value,
    STATE(418), 1,
      sym_include_argument,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(300), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [8035] = 11,
    ACTIONS(564), 1,
      anon_sym_LPAREN,
    ACTIONS(570), 1,
      aux_sym_integer_value_token1,
    ACTIONS(572), 1,
      aux_sym_float_value_token1,
    ACTIONS(576), 1,
      sym_variable_identifier,
    ACTIONS(578), 1,
      sym_plain_value,
    ACTIONS(857), 1,
      anon_sym_POUND,
    ACTIONS(859), 1,
      sym_string_value,
    ACTIONS(861), 1,
      sym_identifier,
    STATE(331), 1,
      sym__value,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(185), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [8075] = 11,
    ACTIONS(564), 1,
      anon_sym_LPAREN,
    ACTIONS(576), 1,
      sym_variable_identifier,
    ACTIONS(578), 1,
      sym_plain_value,
    ACTIONS(857), 1,
      anon_sym_POUND,
    ACTIONS(859), 1,
      sym_string_value,
    ACTIONS(861), 1,
      sym_identifier,
    ACTIONS(863), 1,
      aux_sym_integer_value_token1,
    ACTIONS(865), 1,
      aux_sym_float_value_token1,
    STATE(194), 1,
      sym__value,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(185), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [8115] = 11,
    ACTIONS(564), 1,
      anon_sym_LPAREN,
    ACTIONS(570), 1,
      aux_sym_integer_value_token1,
    ACTIONS(572), 1,
      aux_sym_float_value_token1,
    ACTIONS(576), 1,
      sym_variable_identifier,
    ACTIONS(578), 1,
      sym_plain_value,
    ACTIONS(857), 1,
      anon_sym_POUND,
    ACTIONS(859), 1,
      sym_string_value,
    ACTIONS(861), 1,
      sym_identifier,
    STATE(194), 1,
      sym__value,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(185), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [8155] = 11,
    ACTIONS(564), 1,
      anon_sym_LPAREN,
    ACTIONS(576), 1,
      sym_variable_identifier,
    ACTIONS(578), 1,
      sym_plain_value,
    ACTIONS(857), 1,
      anon_sym_POUND,
    ACTIONS(859), 1,
      sym_string_value,
    ACTIONS(861), 1,
      sym_identifier,
    ACTIONS(863), 1,
      aux_sym_integer_value_token1,
    ACTIONS(865), 1,
      aux_sym_float_value_token1,
    STATE(330), 1,
      sym__value,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(185), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [8195] = 11,
    ACTIONS(564), 1,
      anon_sym_LPAREN,
    ACTIONS(570), 1,
      aux_sym_integer_value_token1,
    ACTIONS(572), 1,
      aux_sym_float_value_token1,
    ACTIONS(576), 1,
      sym_variable_identifier,
    ACTIONS(578), 1,
      sym_plain_value,
    ACTIONS(857), 1,
      anon_sym_POUND,
    ACTIONS(859), 1,
      sym_string_value,
    ACTIONS(861), 1,
      sym_identifier,
    STATE(353), 1,
      sym__value,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(185), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [8235] = 11,
    ACTIONS(564), 1,
      anon_sym_LPAREN,
    ACTIONS(570), 1,
      aux_sym_integer_value_token1,
    ACTIONS(572), 1,
      aux_sym_float_value_token1,
    ACTIONS(576), 1,
      sym_variable_identifier,
    ACTIONS(578), 1,
      sym_plain_value,
    ACTIONS(857), 1,
      anon_sym_POUND,
    ACTIONS(859), 1,
      sym_string_value,
    ACTIONS(861), 1,
      sym_identifier,
    STATE(350), 1,
      sym__value,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(185), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [8275] = 5,
    ACTIONS(869), 1,
      anon_sym_COLON,
    ACTIONS(871), 1,
      anon_sym_LPAREN2,
    STATE(279), 1,
      sym_pseudo_class_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(867), 12,
      sym__descendant_operator,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RPAREN,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_PLUS,
  [8303] = 11,
    ACTIONS(564), 1,
      anon_sym_LPAREN,
    ACTIONS(570), 1,
      aux_sym_integer_value_token1,
    ACTIONS(572), 1,
      aux_sym_float_value_token1,
    ACTIONS(576), 1,
      sym_variable_identifier,
    ACTIONS(578), 1,
      sym_plain_value,
    ACTIONS(857), 1,
      anon_sym_POUND,
    ACTIONS(859), 1,
      sym_string_value,
    ACTIONS(861), 1,
      sym_identifier,
    STATE(325), 1,
      sym__value,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(185), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [8343] = 11,
    ACTIONS(564), 1,
      anon_sym_LPAREN,
    ACTIONS(570), 1,
      aux_sym_integer_value_token1,
    ACTIONS(572), 1,
      aux_sym_float_value_token1,
    ACTIONS(576), 1,
      sym_variable_identifier,
    ACTIONS(578), 1,
      sym_plain_value,
    ACTIONS(857), 1,
      anon_sym_POUND,
    ACTIONS(859), 1,
      sym_string_value,
    ACTIONS(861), 1,
      sym_identifier,
    STATE(309), 1,
      sym__value,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(185), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [8383] = 11,
    ACTIONS(564), 1,
      anon_sym_LPAREN,
    ACTIONS(570), 1,
      aux_sym_integer_value_token1,
    ACTIONS(572), 1,
      aux_sym_float_value_token1,
    ACTIONS(576), 1,
      sym_variable_identifier,
    ACTIONS(578), 1,
      sym_plain_value,
    ACTIONS(857), 1,
      anon_sym_POUND,
    ACTIONS(859), 1,
      sym_string_value,
    ACTIONS(861), 1,
      sym_identifier,
    STATE(348), 1,
      sym__value,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(185), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [8423] = 11,
    ACTIONS(564), 1,
      anon_sym_LPAREN,
    ACTIONS(570), 1,
      aux_sym_integer_value_token1,
    ACTIONS(572), 1,
      aux_sym_float_value_token1,
    ACTIONS(576), 1,
      sym_variable_identifier,
    ACTIONS(578), 1,
      sym_plain_value,
    ACTIONS(857), 1,
      anon_sym_POUND,
    ACTIONS(859), 1,
      sym_string_value,
    ACTIONS(861), 1,
      sym_identifier,
    STATE(345), 1,
      sym__value,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(185), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [8463] = 11,
    ACTIONS(348), 1,
      anon_sym_LPAREN,
    ACTIONS(358), 1,
      aux_sym_integer_value_token1,
    ACTIONS(360), 1,
      aux_sym_float_value_token1,
    ACTIONS(364), 1,
      sym_variable_identifier,
    ACTIONS(366), 1,
      sym_plain_value,
    ACTIONS(588), 1,
      anon_sym_POUND,
    ACTIONS(594), 1,
      sym_string_value,
    ACTIONS(596), 1,
      sym_identifier,
    STATE(124), 1,
      sym__value,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(141), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [8503] = 11,
    ACTIONS(348), 1,
      anon_sym_LPAREN,
    ACTIONS(358), 1,
      aux_sym_integer_value_token1,
    ACTIONS(360), 1,
      aux_sym_float_value_token1,
    ACTIONS(364), 1,
      sym_variable_identifier,
    ACTIONS(366), 1,
      sym_plain_value,
    ACTIONS(588), 1,
      anon_sym_POUND,
    ACTIONS(594), 1,
      sym_string_value,
    ACTIONS(596), 1,
      sym_identifier,
    STATE(147), 1,
      sym__value,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(141), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [8543] = 11,
    ACTIONS(564), 1,
      anon_sym_LPAREN,
    ACTIONS(570), 1,
      aux_sym_integer_value_token1,
    ACTIONS(572), 1,
      aux_sym_float_value_token1,
    ACTIONS(576), 1,
      sym_variable_identifier,
    ACTIONS(578), 1,
      sym_plain_value,
    ACTIONS(857), 1,
      anon_sym_POUND,
    ACTIONS(859), 1,
      sym_string_value,
    ACTIONS(861), 1,
      sym_identifier,
    STATE(310), 1,
      sym__value,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(185), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [8583] = 11,
    ACTIONS(564), 1,
      anon_sym_LPAREN,
    ACTIONS(570), 1,
      aux_sym_integer_value_token1,
    ACTIONS(572), 1,
      aux_sym_float_value_token1,
    ACTIONS(576), 1,
      sym_variable_identifier,
    ACTIONS(578), 1,
      sym_plain_value,
    ACTIONS(857), 1,
      anon_sym_POUND,
    ACTIONS(859), 1,
      sym_string_value,
    ACTIONS(861), 1,
      sym_identifier,
    STATE(311), 1,
      sym__value,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(185), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [8623] = 11,
    ACTIONS(564), 1,
      anon_sym_LPAREN,
    ACTIONS(570), 1,
      aux_sym_integer_value_token1,
    ACTIONS(572), 1,
      aux_sym_float_value_token1,
    ACTIONS(576), 1,
      sym_variable_identifier,
    ACTIONS(578), 1,
      sym_plain_value,
    ACTIONS(857), 1,
      anon_sym_POUND,
    ACTIONS(859), 1,
      sym_string_value,
    ACTIONS(861), 1,
      sym_identifier,
    STATE(321), 1,
      sym__value,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(185), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [8663] = 11,
    ACTIONS(564), 1,
      anon_sym_LPAREN,
    ACTIONS(570), 1,
      aux_sym_integer_value_token1,
    ACTIONS(572), 1,
      aux_sym_float_value_token1,
    ACTIONS(576), 1,
      sym_variable_identifier,
    ACTIONS(578), 1,
      sym_plain_value,
    ACTIONS(857), 1,
      anon_sym_POUND,
    ACTIONS(859), 1,
      sym_string_value,
    ACTIONS(861), 1,
      sym_identifier,
    STATE(322), 1,
      sym__value,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(185), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [8703] = 11,
    ACTIONS(564), 1,
      anon_sym_LPAREN,
    ACTIONS(570), 1,
      aux_sym_integer_value_token1,
    ACTIONS(572), 1,
      aux_sym_float_value_token1,
    ACTIONS(576), 1,
      sym_variable_identifier,
    ACTIONS(578), 1,
      sym_plain_value,
    ACTIONS(857), 1,
      anon_sym_POUND,
    ACTIONS(859), 1,
      sym_string_value,
    ACTIONS(861), 1,
      sym_identifier,
    STATE(291), 1,
      sym__value,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(185), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [8743] = 11,
    ACTIONS(564), 1,
      anon_sym_LPAREN,
    ACTIONS(570), 1,
      aux_sym_integer_value_token1,
    ACTIONS(572), 1,
      aux_sym_float_value_token1,
    ACTIONS(576), 1,
      sym_variable_identifier,
    ACTIONS(578), 1,
      sym_plain_value,
    ACTIONS(857), 1,
      anon_sym_POUND,
    ACTIONS(859), 1,
      sym_string_value,
    ACTIONS(861), 1,
      sym_identifier,
    STATE(312), 1,
      sym__value,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(185), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [8783] = 11,
    ACTIONS(564), 1,
      anon_sym_LPAREN,
    ACTIONS(570), 1,
      aux_sym_integer_value_token1,
    ACTIONS(572), 1,
      aux_sym_float_value_token1,
    ACTIONS(576), 1,
      sym_variable_identifier,
    ACTIONS(578), 1,
      sym_plain_value,
    ACTIONS(857), 1,
      anon_sym_POUND,
    ACTIONS(859), 1,
      sym_string_value,
    ACTIONS(861), 1,
      sym_identifier,
    STATE(351), 1,
      sym__value,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(185), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [8823] = 11,
    ACTIONS(348), 1,
      anon_sym_LPAREN,
    ACTIONS(358), 1,
      aux_sym_integer_value_token1,
    ACTIONS(360), 1,
      aux_sym_float_value_token1,
    ACTIONS(364), 1,
      sym_variable_identifier,
    ACTIONS(366), 1,
      sym_plain_value,
    ACTIONS(588), 1,
      anon_sym_POUND,
    ACTIONS(594), 1,
      sym_string_value,
    ACTIONS(596), 1,
      sym_identifier,
    STATE(125), 1,
      sym__value,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(141), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [8863] = 11,
    ACTIONS(564), 1,
      anon_sym_LPAREN,
    ACTIONS(570), 1,
      aux_sym_integer_value_token1,
    ACTIONS(572), 1,
      aux_sym_float_value_token1,
    ACTIONS(576), 1,
      sym_variable_identifier,
    ACTIONS(578), 1,
      sym_plain_value,
    ACTIONS(857), 1,
      anon_sym_POUND,
    ACTIONS(859), 1,
      sym_string_value,
    ACTIONS(861), 1,
      sym_identifier,
    STATE(352), 1,
      sym__value,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(185), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [8903] = 11,
    ACTIONS(564), 1,
      anon_sym_LPAREN,
    ACTIONS(570), 1,
      aux_sym_integer_value_token1,
    ACTIONS(572), 1,
      aux_sym_float_value_token1,
    ACTIONS(576), 1,
      sym_variable_identifier,
    ACTIONS(578), 1,
      sym_plain_value,
    ACTIONS(857), 1,
      anon_sym_POUND,
    ACTIONS(859), 1,
      sym_string_value,
    ACTIONS(861), 1,
      sym_identifier,
    STATE(320), 1,
      sym__value,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(185), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [8943] = 11,
    ACTIONS(564), 1,
      anon_sym_LPAREN,
    ACTIONS(576), 1,
      sym_variable_identifier,
    ACTIONS(578), 1,
      sym_plain_value,
    ACTIONS(857), 1,
      anon_sym_POUND,
    ACTIONS(859), 1,
      sym_string_value,
    ACTIONS(861), 1,
      sym_identifier,
    ACTIONS(863), 1,
      aux_sym_integer_value_token1,
    ACTIONS(865), 1,
      aux_sym_float_value_token1,
    STATE(332), 1,
      sym__value,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(185), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [8983] = 11,
    ACTIONS(873), 1,
      anon_sym_LPAREN,
    ACTIONS(875), 1,
      anon_sym_POUND,
    ACTIONS(877), 1,
      sym_string_value,
    ACTIONS(879), 1,
      aux_sym_integer_value_token1,
    ACTIONS(881), 1,
      aux_sym_float_value_token1,
    ACTIONS(883), 1,
      sym_identifier,
    ACTIONS(885), 1,
      sym_variable_identifier,
    ACTIONS(887), 1,
      sym_plain_value,
    STATE(146), 1,
      sym__value,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(192), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [9023] = 11,
    ACTIONS(348), 1,
      anon_sym_LPAREN,
    ACTIONS(358), 1,
      aux_sym_integer_value_token1,
    ACTIONS(360), 1,
      aux_sym_float_value_token1,
    ACTIONS(364), 1,
      sym_variable_identifier,
    ACTIONS(366), 1,
      sym_plain_value,
    ACTIONS(588), 1,
      anon_sym_POUND,
    ACTIONS(594), 1,
      sym_string_value,
    ACTIONS(596), 1,
      sym_identifier,
    STATE(128), 1,
      sym__value,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(141), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [9063] = 11,
    ACTIONS(348), 1,
      anon_sym_LPAREN,
    ACTIONS(358), 1,
      aux_sym_integer_value_token1,
    ACTIONS(360), 1,
      aux_sym_float_value_token1,
    ACTIONS(364), 1,
      sym_variable_identifier,
    ACTIONS(366), 1,
      sym_plain_value,
    ACTIONS(588), 1,
      anon_sym_POUND,
    ACTIONS(594), 1,
      sym_string_value,
    ACTIONS(596), 1,
      sym_identifier,
    STATE(135), 1,
      sym__value,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(141), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [9103] = 11,
    ACTIONS(873), 1,
      anon_sym_LPAREN,
    ACTIONS(875), 1,
      anon_sym_POUND,
    ACTIONS(877), 1,
      sym_string_value,
    ACTIONS(879), 1,
      aux_sym_integer_value_token1,
    ACTIONS(881), 1,
      aux_sym_float_value_token1,
    ACTIONS(883), 1,
      sym_identifier,
    ACTIONS(885), 1,
      sym_variable_identifier,
    ACTIONS(887), 1,
      sym_plain_value,
    STATE(197), 1,
      sym__value,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(192), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [9143] = 11,
    ACTIONS(564), 1,
      anon_sym_LPAREN,
    ACTIONS(570), 1,
      aux_sym_integer_value_token1,
    ACTIONS(572), 1,
      aux_sym_float_value_token1,
    ACTIONS(576), 1,
      sym_variable_identifier,
    ACTIONS(578), 1,
      sym_plain_value,
    ACTIONS(857), 1,
      anon_sym_POUND,
    ACTIONS(859), 1,
      sym_string_value,
    ACTIONS(861), 1,
      sym_identifier,
    STATE(337), 1,
      sym__value,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(185), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [9183] = 11,
    ACTIONS(348), 1,
      anon_sym_LPAREN,
    ACTIONS(358), 1,
      aux_sym_integer_value_token1,
    ACTIONS(360), 1,
      aux_sym_float_value_token1,
    ACTIONS(364), 1,
      sym_variable_identifier,
    ACTIONS(366), 1,
      sym_plain_value,
    ACTIONS(588), 1,
      anon_sym_POUND,
    ACTIONS(594), 1,
      sym_string_value,
    ACTIONS(596), 1,
      sym_identifier,
    STATE(126), 1,
      sym__value,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(141), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [9223] = 11,
    ACTIONS(348), 1,
      anon_sym_LPAREN,
    ACTIONS(358), 1,
      aux_sym_integer_value_token1,
    ACTIONS(360), 1,
      aux_sym_float_value_token1,
    ACTIONS(364), 1,
      sym_variable_identifier,
    ACTIONS(366), 1,
      sym_plain_value,
    ACTIONS(588), 1,
      anon_sym_POUND,
    ACTIONS(594), 1,
      sym_string_value,
    ACTIONS(596), 1,
      sym_identifier,
    STATE(127), 1,
      sym__value,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(141), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [9263] = 11,
    ACTIONS(564), 1,
      anon_sym_LPAREN,
    ACTIONS(570), 1,
      aux_sym_integer_value_token1,
    ACTIONS(572), 1,
      aux_sym_float_value_token1,
    ACTIONS(576), 1,
      sym_variable_identifier,
    ACTIONS(578), 1,
      sym_plain_value,
    ACTIONS(857), 1,
      anon_sym_POUND,
    ACTIONS(859), 1,
      sym_string_value,
    ACTIONS(861), 1,
      sym_identifier,
    STATE(317), 1,
      sym__value,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(185), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [9303] = 11,
    ACTIONS(839), 1,
      anon_sym_LPAREN,
    ACTIONS(841), 1,
      anon_sym_POUND,
    ACTIONS(843), 1,
      sym_string_value,
    ACTIONS(845), 1,
      aux_sym_integer_value_token1,
    ACTIONS(847), 1,
      aux_sym_float_value_token1,
    ACTIONS(849), 1,
      sym_identifier,
    ACTIONS(853), 1,
      sym_plain_value,
    ACTIONS(889), 1,
      sym_variable_identifier,
    STATE(304), 1,
      sym__value,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(300), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [9343] = 11,
    ACTIONS(564), 1,
      anon_sym_LPAREN,
    ACTIONS(570), 1,
      aux_sym_integer_value_token1,
    ACTIONS(572), 1,
      aux_sym_float_value_token1,
    ACTIONS(576), 1,
      sym_variable_identifier,
    ACTIONS(578), 1,
      sym_plain_value,
    ACTIONS(857), 1,
      anon_sym_POUND,
    ACTIONS(859), 1,
      sym_string_value,
    ACTIONS(861), 1,
      sym_identifier,
    STATE(298), 1,
      sym__value,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(185), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [9383] = 11,
    ACTIONS(564), 1,
      anon_sym_LPAREN,
    ACTIONS(570), 1,
      aux_sym_integer_value_token1,
    ACTIONS(572), 1,
      aux_sym_float_value_token1,
    ACTIONS(576), 1,
      sym_variable_identifier,
    ACTIONS(578), 1,
      sym_plain_value,
    ACTIONS(857), 1,
      anon_sym_POUND,
    ACTIONS(859), 1,
      sym_string_value,
    ACTIONS(861), 1,
      sym_identifier,
    STATE(334), 1,
      sym__value,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(185), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [9423] = 11,
    ACTIONS(564), 1,
      anon_sym_LPAREN,
    ACTIONS(570), 1,
      aux_sym_integer_value_token1,
    ACTIONS(572), 1,
      aux_sym_float_value_token1,
    ACTIONS(576), 1,
      sym_variable_identifier,
    ACTIONS(578), 1,
      sym_plain_value,
    ACTIONS(857), 1,
      anon_sym_POUND,
    ACTIONS(859), 1,
      sym_string_value,
    ACTIONS(861), 1,
      sym_identifier,
    STATE(338), 1,
      sym__value,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(185), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [9463] = 11,
    ACTIONS(564), 1,
      anon_sym_LPAREN,
    ACTIONS(570), 1,
      aux_sym_integer_value_token1,
    ACTIONS(572), 1,
      aux_sym_float_value_token1,
    ACTIONS(576), 1,
      sym_variable_identifier,
    ACTIONS(578), 1,
      sym_plain_value,
    ACTIONS(857), 1,
      anon_sym_POUND,
    ACTIONS(859), 1,
      sym_string_value,
    ACTIONS(861), 1,
      sym_identifier,
    STATE(339), 1,
      sym__value,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(185), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [9503] = 11,
    ACTIONS(839), 1,
      anon_sym_LPAREN,
    ACTIONS(841), 1,
      anon_sym_POUND,
    ACTIONS(843), 1,
      sym_string_value,
    ACTIONS(845), 1,
      aux_sym_integer_value_token1,
    ACTIONS(847), 1,
      aux_sym_float_value_token1,
    ACTIONS(849), 1,
      sym_identifier,
    ACTIONS(853), 1,
      sym_plain_value,
    ACTIONS(889), 1,
      sym_variable_identifier,
    STATE(302), 1,
      sym__value,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(300), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [9543] = 11,
    ACTIONS(564), 1,
      anon_sym_LPAREN,
    ACTIONS(570), 1,
      aux_sym_integer_value_token1,
    ACTIONS(572), 1,
      aux_sym_float_value_token1,
    ACTIONS(576), 1,
      sym_variable_identifier,
    ACTIONS(578), 1,
      sym_plain_value,
    ACTIONS(857), 1,
      anon_sym_POUND,
    ACTIONS(859), 1,
      sym_string_value,
    ACTIONS(861), 1,
      sym_identifier,
    STATE(344), 1,
      sym__value,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(185), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [9583] = 11,
    ACTIONS(564), 1,
      anon_sym_LPAREN,
    ACTIONS(570), 1,
      aux_sym_integer_value_token1,
    ACTIONS(572), 1,
      aux_sym_float_value_token1,
    ACTIONS(576), 1,
      sym_variable_identifier,
    ACTIONS(578), 1,
      sym_plain_value,
    ACTIONS(857), 1,
      anon_sym_POUND,
    ACTIONS(859), 1,
      sym_string_value,
    ACTIONS(861), 1,
      sym_identifier,
    STATE(306), 1,
      sym__value,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(185), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [9623] = 11,
    ACTIONS(564), 1,
      anon_sym_LPAREN,
    ACTIONS(570), 1,
      aux_sym_integer_value_token1,
    ACTIONS(572), 1,
      aux_sym_float_value_token1,
    ACTIONS(576), 1,
      sym_variable_identifier,
    ACTIONS(578), 1,
      sym_plain_value,
    ACTIONS(857), 1,
      anon_sym_POUND,
    ACTIONS(859), 1,
      sym_string_value,
    ACTIONS(861), 1,
      sym_identifier,
    STATE(333), 1,
      sym__value,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(185), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [9663] = 11,
    ACTIONS(564), 1,
      anon_sym_LPAREN,
    ACTIONS(570), 1,
      aux_sym_integer_value_token1,
    ACTIONS(572), 1,
      aux_sym_float_value_token1,
    ACTIONS(576), 1,
      sym_variable_identifier,
    ACTIONS(578), 1,
      sym_plain_value,
    ACTIONS(857), 1,
      anon_sym_POUND,
    ACTIONS(859), 1,
      sym_string_value,
    ACTIONS(861), 1,
      sym_identifier,
    STATE(307), 1,
      sym__value,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(185), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [9703] = 11,
    ACTIONS(564), 1,
      anon_sym_LPAREN,
    ACTIONS(570), 1,
      aux_sym_integer_value_token1,
    ACTIONS(572), 1,
      aux_sym_float_value_token1,
    ACTIONS(576), 1,
      sym_variable_identifier,
    ACTIONS(578), 1,
      sym_plain_value,
    ACTIONS(857), 1,
      anon_sym_POUND,
    ACTIONS(859), 1,
      sym_string_value,
    ACTIONS(861), 1,
      sym_identifier,
    STATE(329), 1,
      sym__value,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(185), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [9743] = 11,
    ACTIONS(564), 1,
      anon_sym_LPAREN,
    ACTIONS(570), 1,
      aux_sym_integer_value_token1,
    ACTIONS(572), 1,
      aux_sym_float_value_token1,
    ACTIONS(576), 1,
      sym_variable_identifier,
    ACTIONS(578), 1,
      sym_plain_value,
    ACTIONS(857), 1,
      anon_sym_POUND,
    ACTIONS(859), 1,
      sym_string_value,
    ACTIONS(861), 1,
      sym_identifier,
    STATE(323), 1,
      sym__value,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(185), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [9783] = 11,
    ACTIONS(564), 1,
      anon_sym_LPAREN,
    ACTIONS(570), 1,
      aux_sym_integer_value_token1,
    ACTIONS(572), 1,
      aux_sym_float_value_token1,
    ACTIONS(576), 1,
      sym_variable_identifier,
    ACTIONS(578), 1,
      sym_plain_value,
    ACTIONS(857), 1,
      anon_sym_POUND,
    ACTIONS(859), 1,
      sym_string_value,
    ACTIONS(861), 1,
      sym_identifier,
    STATE(319), 1,
      sym__value,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(185), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [9823] = 5,
    ACTIONS(871), 1,
      anon_sym_LPAREN2,
    ACTIONS(893), 1,
      anon_sym_COLON,
    STATE(276), 1,
      sym_pseudo_class_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(891), 12,
      sym__descendant_operator,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RPAREN,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_PLUS,
  [9851] = 11,
    ACTIONS(564), 1,
      anon_sym_LPAREN,
    ACTIONS(570), 1,
      aux_sym_integer_value_token1,
    ACTIONS(572), 1,
      aux_sym_float_value_token1,
    ACTIONS(576), 1,
      sym_variable_identifier,
    ACTIONS(578), 1,
      sym_plain_value,
    ACTIONS(857), 1,
      anon_sym_POUND,
    ACTIONS(859), 1,
      sym_string_value,
    ACTIONS(861), 1,
      sym_identifier,
    STATE(347), 1,
      sym__value,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(185), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [9891] = 11,
    ACTIONS(564), 1,
      anon_sym_LPAREN,
    ACTIONS(570), 1,
      aux_sym_integer_value_token1,
    ACTIONS(572), 1,
      aux_sym_float_value_token1,
    ACTIONS(576), 1,
      sym_variable_identifier,
    ACTIONS(578), 1,
      sym_plain_value,
    ACTIONS(857), 1,
      anon_sym_POUND,
    ACTIONS(859), 1,
      sym_string_value,
    ACTIONS(861), 1,
      sym_identifier,
    STATE(336), 1,
      sym__value,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(185), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [9931] = 11,
    ACTIONS(873), 1,
      anon_sym_LPAREN,
    ACTIONS(875), 1,
      anon_sym_POUND,
    ACTIONS(877), 1,
      sym_string_value,
    ACTIONS(879), 1,
      aux_sym_integer_value_token1,
    ACTIONS(881), 1,
      aux_sym_float_value_token1,
    ACTIONS(883), 1,
      sym_identifier,
    ACTIONS(885), 1,
      sym_variable_identifier,
    ACTIONS(887), 1,
      sym_plain_value,
    STATE(148), 1,
      sym__value,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(192), 6,
      sym_parenthesized_value,
      sym_color_value,
      sym_integer_value,
      sym_float_value,
      sym_call_expression,
      sym_binary_expression,
  [9971] = 4,
    ACTIONS(895), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(626), 2,
      anon_sym_COLON,
      anon_sym_POUND,
    ACTIONS(622), 11,
      sym__descendant_operator,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RPAREN,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_PLUS,
  [9996] = 3,
    ACTIONS(899), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(897), 13,
      sym__descendant_operator,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RPAREN,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_PLUS,
  [10019] = 9,
    ACTIONS(688), 1,
      anon_sym_LPAREN,
    ACTIONS(696), 1,
      anon_sym_selector,
    ACTIONS(698), 1,
      sym_identifier,
    ACTIONS(901), 1,
      anon_sym_SEMI,
    ACTIONS(903), 1,
      anon_sym_LBRACE,
    STATE(106), 1,
      sym_block,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(694), 2,
      anon_sym_not,
      anon_sym_only,
    STATE(363), 6,
      sym__query,
      sym_feature_query,
      sym_parenthesized_query,
      sym_binary_query,
      sym_unary_query,
      sym_selector_query,
  [10054] = 5,
    ACTIONS(905), 1,
      anon_sym_LPAREN2,
    STATE(315), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(614), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(620), 9,
      anon_sym_COMMA,
      anon_sym_RPAREN2,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [10081] = 9,
    ACTIONS(688), 1,
      anon_sym_LPAREN,
    ACTIONS(696), 1,
      anon_sym_selector,
    ACTIONS(698), 1,
      sym_identifier,
    ACTIONS(907), 1,
      anon_sym_SEMI,
    ACTIONS(909), 1,
      anon_sym_LBRACE,
    STATE(68), 1,
      sym_block,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(694), 2,
      anon_sym_not,
      anon_sym_only,
    STATE(362), 6,
      sym__query,
      sym_feature_query,
      sym_parenthesized_query,
      sym_binary_query,
      sym_unary_query,
      sym_selector_query,
  [10116] = 3,
    ACTIONS(913), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(911), 13,
      sym__descendant_operator,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RPAREN,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_PLUS,
  [10139] = 3,
    ACTIONS(917), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(915), 12,
      sym__descendant_operator,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RPAREN,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_PLUS,
  [10161] = 3,
    ACTIONS(921), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(919), 12,
      sym__descendant_operator,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RPAREN,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_PLUS,
  [10183] = 3,
    ACTIONS(925), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(923), 12,
      sym__descendant_operator,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RPAREN,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_PLUS,
  [10205] = 3,
    ACTIONS(929), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(927), 12,
      sym__descendant_operator,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RPAREN,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_PLUS,
  [10227] = 4,
    ACTIONS(931), 1,
      sym_unit,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(638), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(636), 9,
      anon_sym_COMMA,
      anon_sym_RPAREN2,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [10251] = 3,
    ACTIONS(935), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(933), 12,
      sym__descendant_operator,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RPAREN,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_PLUS,
  [10273] = 3,
    ACTIONS(939), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(937), 12,
      sym__descendant_operator,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RPAREN,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_PLUS,
  [10295] = 3,
    ACTIONS(943), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(941), 12,
      sym__descendant_operator,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RPAREN,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_PLUS,
  [10317] = 13,
    ACTIONS(945), 1,
      anon_sym_COMMA,
    ACTIONS(947), 1,
      anon_sym_LBRACE,
    ACTIONS(949), 1,
      anon_sym_COLON,
    ACTIONS(953), 1,
      anon_sym_COLON_COLON,
    ACTIONS(955), 1,
      anon_sym_POUND,
    ACTIONS(957), 1,
      anon_sym_LBRACK,
    ACTIONS(959), 1,
      anon_sym_GT,
    ACTIONS(961), 1,
      anon_sym_TILDE,
    ACTIONS(963), 1,
      anon_sym_PLUS,
    ACTIONS(965), 1,
      sym__descendant_operator,
    STATE(402), 1,
      aux_sym_selectors_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(951), 2,
      sym_nesting_selector,
      anon_sym_DOT,
  [10359] = 3,
    ACTIONS(969), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(967), 12,
      sym__descendant_operator,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RPAREN,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_PLUS,
  [10381] = 3,
    ACTIONS(973), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(971), 12,
      sym__descendant_operator,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RPAREN,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_PLUS,
  [10403] = 4,
    ACTIONS(977), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(951), 2,
      sym_nesting_selector,
      anon_sym_DOT,
    ACTIONS(975), 10,
      sym__descendant_operator,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_PLUS,
  [10427] = 3,
    ACTIONS(981), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(979), 12,
      sym__descendant_operator,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RPAREN,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_PLUS,
  [10449] = 3,
    ACTIONS(985), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(983), 12,
      sym__descendant_operator,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RPAREN,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_PLUS,
  [10471] = 4,
    ACTIONS(989), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(951), 2,
      sym_nesting_selector,
      anon_sym_DOT,
    ACTIONS(987), 10,
      sym__descendant_operator,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_PLUS,
  [10495] = 4,
    ACTIONS(993), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(951), 2,
      sym_nesting_selector,
      anon_sym_DOT,
    ACTIONS(991), 10,
      sym__descendant_operator,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_PLUS,
  [10519] = 3,
    ACTIONS(997), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(995), 12,
      sym__descendant_operator,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RPAREN,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_PLUS,
  [10541] = 13,
    ACTIONS(773), 1,
      anon_sym_COMMA,
    ACTIONS(775), 1,
      anon_sym_RPAREN,
    ACTIONS(949), 1,
      anon_sym_COLON,
    ACTIONS(953), 1,
      anon_sym_COLON_COLON,
    ACTIONS(955), 1,
      anon_sym_POUND,
    ACTIONS(957), 1,
      anon_sym_LBRACK,
    ACTIONS(959), 1,
      anon_sym_GT,
    ACTIONS(961), 1,
      anon_sym_TILDE,
    ACTIONS(963), 1,
      anon_sym_PLUS,
    ACTIONS(965), 1,
      sym__descendant_operator,
    STATE(406), 1,
      aux_sym_pseudo_class_arguments_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(951), 2,
      sym_nesting_selector,
      anon_sym_DOT,
  [10583] = 3,
    ACTIONS(1001), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(999), 12,
      sym__descendant_operator,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RPAREN,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_PLUS,
  [10605] = 4,
    ACTIONS(1003), 1,
      sym_unit,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(632), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(630), 9,
      anon_sym_COMMA,
      anon_sym_RPAREN2,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [10629] = 3,
    ACTIONS(1007), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(1005), 12,
      sym__descendant_operator,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RPAREN,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_PLUS,
  [10651] = 3,
    ACTIONS(616), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(612), 12,
      sym__descendant_operator,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RPAREN,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_PLUS,
  [10673] = 4,
    ACTIONS(1011), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(951), 2,
      sym_nesting_selector,
      anon_sym_DOT,
    ACTIONS(1009), 10,
      sym__descendant_operator,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      anon_sym_RPAREN,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_PLUS,
  [10697] = 4,
    ACTIONS(1013), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(656), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(654), 9,
      anon_sym_COMMA,
      anon_sym_RPAREN2,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [10721] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(652), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(650), 9,
      anon_sym_COMMA,
      anon_sym_RPAREN2,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [10742] = 5,
    ACTIONS(903), 1,
      anon_sym_LBRACE,
    STATE(80), 1,
      sym_block,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(1017), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(1015), 7,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [10767] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(644), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(642), 9,
      anon_sym_COMMA,
      anon_sym_RPAREN2,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [10788] = 11,
    ACTIONS(949), 1,
      anon_sym_COLON,
    ACTIONS(953), 1,
      anon_sym_COLON_COLON,
    ACTIONS(955), 1,
      anon_sym_POUND,
    ACTIONS(957), 1,
      anon_sym_LBRACK,
    ACTIONS(959), 1,
      anon_sym_GT,
    ACTIONS(961), 1,
      anon_sym_TILDE,
    ACTIONS(963), 1,
      anon_sym_PLUS,
    ACTIONS(965), 1,
      sym__descendant_operator,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(815), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    ACTIONS(951), 2,
      sym_nesting_selector,
      anon_sym_DOT,
  [10825] = 3,
    ACTIONS(1019), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(612), 11,
      sym__descendant_operator,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_PLUS,
  [10846] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(668), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(666), 9,
      anon_sym_COMMA,
      anon_sym_RPAREN2,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [10867] = 3,
    ACTIONS(1022), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(612), 11,
      sym__descendant_operator,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_PLUS,
  [10888] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(656), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(654), 9,
      anon_sym_COMMA,
      anon_sym_RPAREN2,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [10909] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(1025), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    ACTIONS(1017), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(1015), 7,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [10932] = 4,
    ACTIONS(1027), 1,
      sym_unit,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(638), 4,
      anon_sym_through,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(636), 7,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [10955] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(628), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(624), 9,
      anon_sym_COMMA,
      anon_sym_RPAREN2,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [10976] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(660), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(658), 9,
      anon_sym_COMMA,
      anon_sym_RPAREN2,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [10997] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(1029), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN2,
    ACTIONS(1033), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(1031), 7,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [11020] = 3,
    ACTIONS(1035), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(612), 11,
      sym__descendant_operator,
      anon_sym_COMMA,
      anon_sym_LBRACE,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_PLUS,
  [11041] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(648), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(646), 9,
      anon_sym_COMMA,
      anon_sym_RPAREN2,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [11062] = 11,
    ACTIONS(949), 1,
      anon_sym_COLON,
    ACTIONS(953), 1,
      anon_sym_COLON_COLON,
    ACTIONS(955), 1,
      anon_sym_POUND,
    ACTIONS(957), 1,
      anon_sym_LBRACK,
    ACTIONS(959), 1,
      anon_sym_GT,
    ACTIONS(961), 1,
      anon_sym_TILDE,
    ACTIONS(963), 1,
      anon_sym_PLUS,
    ACTIONS(965), 1,
      sym__descendant_operator,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(951), 2,
      sym_nesting_selector,
      anon_sym_DOT,
    ACTIONS(1037), 2,
      anon_sym_COMMA,
      anon_sym_LBRACE,
  [11099] = 5,
    ACTIONS(909), 1,
      anon_sym_LBRACE,
    STATE(34), 1,
      sym_block,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(1017), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(1015), 7,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [11124] = 5,
    ACTIONS(909), 1,
      anon_sym_LBRACE,
    STATE(33), 1,
      sym_block,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(1017), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(1015), 7,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [11149] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(672), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(670), 9,
      anon_sym_COMMA,
      anon_sym_RPAREN2,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [11170] = 5,
    ACTIONS(903), 1,
      anon_sym_LBRACE,
    STATE(117), 1,
      sym_block,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(1017), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(1015), 7,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [11195] = 5,
    ACTIONS(903), 1,
      anon_sym_LBRACE,
    STATE(99), 1,
      sym_block,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(1017), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(1015), 7,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [11220] = 5,
    ACTIONS(1039), 1,
      anon_sym_LBRACE,
    STATE(48), 1,
      sym_block,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(1017), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(1015), 7,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [11245] = 5,
    ACTIONS(903), 1,
      anon_sym_LBRACE,
    STATE(79), 1,
      sym_block,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(1017), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(1015), 7,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [11270] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(680), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(678), 9,
      anon_sym_COMMA,
      anon_sym_RPAREN2,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [11291] = 4,
    ACTIONS(1041), 1,
      sym_unit,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(632), 4,
      anon_sym_through,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(630), 7,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [11314] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(676), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(674), 9,
      anon_sym_COMMA,
      anon_sym_RPAREN2,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [11335] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(664), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(662), 9,
      anon_sym_COMMA,
      anon_sym_RPAREN2,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [11356] = 5,
    ACTIONS(909), 1,
      anon_sym_LBRACE,
    STATE(54), 1,
      sym_block,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(1017), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(1015), 7,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [11381] = 4,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(1043), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN2,
    ACTIONS(1033), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(1031), 7,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [11404] = 5,
    ACTIONS(1039), 1,
      anon_sym_LBRACE,
    STATE(66), 1,
      sym_block,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(1017), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(1015), 7,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [11429] = 5,
    ACTIONS(1045), 1,
      anon_sym_LBRACE,
    STATE(23), 1,
      sym_block,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(1017), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(1015), 7,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [11454] = 5,
    ACTIONS(909), 1,
      anon_sym_LBRACE,
    STATE(70), 1,
      sym_block,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(1017), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(1015), 7,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [11479] = 5,
    ACTIONS(1045), 1,
      anon_sym_LBRACE,
    STATE(26), 1,
      sym_block,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(1017), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(1015), 7,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [11504] = 5,
    ACTIONS(903), 1,
      anon_sym_LBRACE,
    STATE(113), 1,
      sym_block,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(1017), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(1015), 7,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [11529] = 4,
    ACTIONS(626), 1,
      anon_sym_COLON,
    ACTIONS(1047), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(622), 9,
      sym__descendant_operator,
      sym_nesting_selector,
      anon_sym_DOT,
      anon_sym_COLON_COLON,
      anon_sym_POUND,
      anon_sym_LBRACK,
      anon_sym_GT,
      anon_sym_TILDE,
      anon_sym_PLUS,
  [11551] = 4,
    ACTIONS(1049), 1,
      anon_sym_RPAREN,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(1017), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(1015), 7,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [11573] = 4,
    ACTIONS(1047), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(1017), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(1015), 7,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [11595] = 6,
    ACTIONS(688), 1,
      anon_sym_LPAREN,
    ACTIONS(696), 1,
      anon_sym_selector,
    ACTIONS(698), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(694), 2,
      anon_sym_not,
      anon_sym_only,
    STATE(364), 6,
      sym__query,
      sym_feature_query,
      sym_parenthesized_query,
      sym_binary_query,
      sym_unary_query,
      sym_selector_query,
  [11621] = 6,
    ACTIONS(688), 1,
      anon_sym_LPAREN,
    ACTIONS(696), 1,
      anon_sym_selector,
    ACTIONS(698), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(694), 2,
      anon_sym_not,
      anon_sym_only,
    STATE(387), 6,
      sym__query,
      sym_feature_query,
      sym_parenthesized_query,
      sym_binary_query,
      sym_unary_query,
      sym_selector_query,
  [11647] = 4,
    ACTIONS(1051), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(1017), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(1015), 7,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [11669] = 4,
    ACTIONS(1053), 1,
      anon_sym_through,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(1057), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(1055), 7,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [11691] = 4,
    ACTIONS(1059), 1,
      anon_sym_RBRACK,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(1017), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(1015), 7,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [11713] = 4,
    ACTIONS(1061), 1,
      anon_sym_through,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(1057), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(1055), 7,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [11735] = 4,
    ACTIONS(1063), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(1017), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(1015), 7,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [11757] = 4,
    ACTIONS(1065), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(1017), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(1015), 7,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [11779] = 6,
    ACTIONS(688), 1,
      anon_sym_LPAREN,
    ACTIONS(696), 1,
      anon_sym_selector,
    ACTIONS(698), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(694), 2,
      anon_sym_not,
      anon_sym_only,
    STATE(398), 6,
      sym__query,
      sym_feature_query,
      sym_parenthesized_query,
      sym_binary_query,
      sym_unary_query,
      sym_selector_query,
  [11805] = 4,
    ACTIONS(1067), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(1017), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(1015), 7,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [11827] = 4,
    ACTIONS(1069), 1,
      anon_sym_RPAREN,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(1017), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(1015), 7,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [11849] = 4,
    ACTIONS(1071), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(1017), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(1015), 7,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [11871] = 4,
    ACTIONS(1073), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(1017), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(1015), 7,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [11893] = 6,
    ACTIONS(688), 1,
      anon_sym_LPAREN,
    ACTIONS(696), 1,
      anon_sym_selector,
    ACTIONS(698), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(694), 2,
      anon_sym_not,
      anon_sym_only,
    STATE(368), 6,
      sym__query,
      sym_feature_query,
      sym_parenthesized_query,
      sym_binary_query,
      sym_unary_query,
      sym_selector_query,
  [11919] = 6,
    ACTIONS(688), 1,
      anon_sym_LPAREN,
    ACTIONS(696), 1,
      anon_sym_selector,
    ACTIONS(698), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(694), 2,
      anon_sym_not,
      anon_sym_only,
    STATE(375), 6,
      sym__query,
      sym_feature_query,
      sym_parenthesized_query,
      sym_binary_query,
      sym_unary_query,
      sym_selector_query,
  [11945] = 6,
    ACTIONS(688), 1,
      anon_sym_LPAREN,
    ACTIONS(696), 1,
      anon_sym_selector,
    ACTIONS(698), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(694), 2,
      anon_sym_not,
      anon_sym_only,
    STATE(371), 6,
      sym__query,
      sym_feature_query,
      sym_parenthesized_query,
      sym_binary_query,
      sym_unary_query,
      sym_selector_query,
  [11971] = 6,
    ACTIONS(688), 1,
      anon_sym_LPAREN,
    ACTIONS(696), 1,
      anon_sym_selector,
    ACTIONS(1075), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(694), 2,
      anon_sym_not,
      anon_sym_only,
    STATE(417), 6,
      sym__query,
      sym_feature_query,
      sym_parenthesized_query,
      sym_binary_query,
      sym_unary_query,
      sym_selector_query,
  [11997] = 4,
    ACTIONS(1077), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(1017), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(1015), 7,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [12019] = 4,
    ACTIONS(1079), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(1017), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(1015), 7,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [12041] = 11,
    ACTIONS(949), 1,
      anon_sym_COLON,
    ACTIONS(953), 1,
      anon_sym_COLON_COLON,
    ACTIONS(955), 1,
      anon_sym_POUND,
    ACTIONS(957), 1,
      anon_sym_LBRACK,
    ACTIONS(959), 1,
      anon_sym_GT,
    ACTIONS(961), 1,
      anon_sym_TILDE,
    ACTIONS(963), 1,
      anon_sym_PLUS,
    ACTIONS(965), 1,
      sym__descendant_operator,
    ACTIONS(1081), 1,
      anon_sym_RPAREN,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(951), 2,
      sym_nesting_selector,
      anon_sym_DOT,
  [12077] = 4,
    ACTIONS(1083), 1,
      anon_sym_RPAREN,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(1017), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(1015), 7,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [12099] = 4,
    ACTIONS(1085), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(1017), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(1015), 7,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [12121] = 6,
    ACTIONS(688), 1,
      anon_sym_LPAREN,
    ACTIONS(696), 1,
      anon_sym_selector,
    ACTIONS(698), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(694), 2,
      anon_sym_not,
      anon_sym_only,
    STATE(369), 6,
      sym__query,
      sym_feature_query,
      sym_parenthesized_query,
      sym_binary_query,
      sym_unary_query,
      sym_selector_query,
  [12147] = 4,
    ACTIONS(1087), 1,
      anon_sym_RPAREN,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(1017), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(1015), 7,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [12169] = 4,
    ACTIONS(1089), 1,
      anon_sym_RBRACK,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(1017), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(1015), 7,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [12191] = 4,
    ACTIONS(1091), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(1017), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(1015), 7,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [12213] = 4,
    ACTIONS(1093), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(1017), 3,
      anon_sym_GT,
      anon_sym_SLASH,
      anon_sym_LT,
    ACTIONS(1015), 7,
      anon_sym_STAR,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [12235] = 10,
    ACTIONS(949), 1,
      anon_sym_COLON,
    ACTIONS(953), 1,
      anon_sym_COLON_COLON,
    ACTIONS(955), 1,
      anon_sym_POUND,
    ACTIONS(957), 1,
      anon_sym_LBRACK,
    ACTIONS(959), 1,
      anon_sym_GT,
    ACTIONS(961), 1,
      anon_sym_TILDE,
    ACTIONS(963), 1,
      anon_sym_PLUS,
    ACTIONS(965), 1,
      sym__descendant_operator,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(951), 2,
      sym_nesting_selector,
      anon_sym_DOT,
  [12268] = 7,
    ACTIONS(1095), 1,
      anon_sym_RBRACE,
    ACTIONS(1097), 1,
      anon_sym_from,
    ACTIONS(1099), 1,
      sym_to,
    ACTIONS(1101), 1,
      aux_sym_integer_value_token1,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(357), 2,
      sym_keyframe_block,
      aux_sym_keyframe_block_list_repeat1,
    STATE(436), 2,
      sym_from,
      sym_integer_value,
  [12293] = 7,
    ACTIONS(1097), 1,
      anon_sym_from,
    ACTIONS(1099), 1,
      sym_to,
    ACTIONS(1101), 1,
      aux_sym_integer_value_token1,
    ACTIONS(1103), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(355), 2,
      sym_keyframe_block,
      aux_sym_keyframe_block_list_repeat1,
    STATE(436), 2,
      sym_from,
      sym_integer_value,
  [12318] = 7,
    ACTIONS(1105), 1,
      anon_sym_RBRACE,
    ACTIONS(1107), 1,
      anon_sym_from,
    ACTIONS(1110), 1,
      sym_to,
    ACTIONS(1113), 1,
      aux_sym_integer_value_token1,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(357), 2,
      sym_keyframe_block,
      aux_sym_keyframe_block_list_repeat1,
    STATE(436), 2,
      sym_from,
      sym_integer_value,
  [12343] = 7,
    ACTIONS(1097), 1,
      anon_sym_from,
    ACTIONS(1099), 1,
      sym_to,
    ACTIONS(1101), 1,
      aux_sym_integer_value_token1,
    ACTIONS(1116), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(359), 2,
      sym_keyframe_block,
      aux_sym_keyframe_block_list_repeat1,
    STATE(436), 2,
      sym_from,
      sym_integer_value,
  [12368] = 7,
    ACTIONS(1097), 1,
      anon_sym_from,
    ACTIONS(1099), 1,
      sym_to,
    ACTIONS(1101), 1,
      aux_sym_integer_value_token1,
    ACTIONS(1118), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    STATE(357), 2,
      sym_keyframe_block,
      aux_sym_keyframe_block_list_repeat1,
    STATE(436), 2,
      sym_from,
      sym_integer_value,
  [12393] = 3,
    ACTIONS(1122), 1,
      anon_sym_RBRACK,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(1120), 6,
      anon_sym_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_STAR_EQ,
      anon_sym_DOLLAR_EQ,
  [12409] = 3,
    ACTIONS(1126), 1,
      anon_sym_RBRACK,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(1124), 6,
      anon_sym_EQ,
      anon_sym_TILDE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_STAR_EQ,
      anon_sym_DOLLAR_EQ,
  [12425] = 7,
    ACTIONS(909), 1,
      anon_sym_LBRACE,
    ACTIONS(1128), 1,
      anon_sym_COMMA,
    ACTIONS(1130), 1,
      anon_sym_SEMI,
    STATE(27), 1,
      sym_block,
    STATE(374), 1,
      aux_sym_import_statement_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(1132), 2,
      anon_sym_and,
      anon_sym_or,
  [12449] = 7,
    ACTIONS(903), 1,
      anon_sym_LBRACE,
    ACTIONS(1128), 1,
      anon_sym_COMMA,
    ACTIONS(1134), 1,
      anon_sym_SEMI,
    STATE(83), 1,
      sym_block,
    STATE(379), 1,
      aux_sym_import_statement_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(1132), 2,
      anon_sym_and,
      anon_sym_or,
  [12473] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(1136), 6,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RPAREN,
      anon_sym_and,
      anon_sym_or,
  [12486] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(1138), 6,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RPAREN,
      anon_sym_and,
      anon_sym_or,
  [12499] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(1140), 6,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RPAREN,
      anon_sym_and,
      anon_sym_or,
  [12512] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(1142), 6,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RPAREN,
      anon_sym_and,
      anon_sym_or,
  [12525] = 6,
    ACTIONS(903), 1,
      anon_sym_LBRACE,
    ACTIONS(1128), 1,
      anon_sym_COMMA,
    STATE(98), 1,
      sym_block,
    STATE(391), 1,
      aux_sym_import_statement_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(1132), 2,
      anon_sym_and,
      anon_sym_or,
  [12546] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(1144), 6,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RPAREN,
      anon_sym_and,
      anon_sym_or,
  [12559] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(1146), 6,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RPAREN,
      anon_sym_and,
      anon_sym_or,
  [12572] = 6,
    ACTIONS(909), 1,
      anon_sym_LBRACE,
    ACTIONS(1128), 1,
      anon_sym_COMMA,
    STATE(76), 1,
      sym_block,
    STATE(382), 1,
      aux_sym_import_statement_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(1132), 2,
      anon_sym_and,
      anon_sym_or,
  [12593] = 6,
    ACTIONS(909), 1,
      anon_sym_LBRACE,
    ACTIONS(1148), 1,
      anon_sym_SEMI,
    ACTIONS(1150), 1,
      anon_sym_LPAREN2,
    STATE(56), 1,
      sym_block,
    STATE(407), 1,
      sym_include_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [12613] = 6,
    ACTIONS(817), 1,
      anon_sym_LPAREN2,
    ACTIONS(1152), 1,
      sym_string_value,
    ACTIONS(1154), 1,
      sym_identifier,
    STATE(193), 1,
      sym_arguments,
    STATE(465), 1,
      sym_call_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [12633] = 6,
    ACTIONS(909), 1,
      anon_sym_LBRACE,
    ACTIONS(1128), 1,
      anon_sym_COMMA,
    ACTIONS(1156), 1,
      anon_sym_SEMI,
    STATE(47), 1,
      sym_block,
    STATE(397), 1,
      aux_sym_import_statement_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [12653] = 3,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(1132), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1158), 3,
      anon_sym_COMMA,
      anon_sym_SEMI,
      anon_sym_LBRACE,
  [12667] = 6,
    ACTIONS(817), 1,
      anon_sym_LPAREN2,
    ACTIONS(1154), 1,
      sym_identifier,
    ACTIONS(1160), 1,
      sym_string_value,
    STATE(193), 1,
      sym_arguments,
    STATE(459), 1,
      sym_call_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [12687] = 5,
    ACTIONS(1128), 1,
      anon_sym_COMMA,
    ACTIONS(1162), 1,
      anon_sym_SEMI,
    STATE(400), 1,
      aux_sym_import_statement_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(1132), 2,
      anon_sym_and,
      anon_sym_or,
  [12705] = 5,
    ACTIONS(1128), 1,
      anon_sym_COMMA,
    ACTIONS(1164), 1,
      anon_sym_SEMI,
    STATE(411), 1,
      aux_sym_import_statement_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(1132), 2,
      anon_sym_and,
      anon_sym_or,
  [12723] = 6,
    ACTIONS(903), 1,
      anon_sym_LBRACE,
    ACTIONS(1128), 1,
      anon_sym_COMMA,
    ACTIONS(1166), 1,
      anon_sym_SEMI,
    STATE(107), 1,
      sym_block,
    STATE(397), 1,
      aux_sym_import_statement_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [12743] = 6,
    ACTIONS(903), 1,
      anon_sym_LBRACE,
    ACTIONS(1150), 1,
      anon_sym_LPAREN2,
    ACTIONS(1168), 1,
      anon_sym_SEMI,
    STATE(90), 1,
      sym_block,
    STATE(412), 1,
      sym_include_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [12763] = 3,
    ACTIONS(1170), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(1138), 3,
      anon_sym_RPAREN,
      anon_sym_and,
      anon_sym_or,
  [12776] = 5,
    ACTIONS(909), 1,
      anon_sym_LBRACE,
    ACTIONS(1128), 1,
      anon_sym_COMMA,
    STATE(42), 1,
      sym_block,
    STATE(397), 1,
      aux_sym_import_statement_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [12793] = 4,
    ACTIONS(1172), 1,
      anon_sym_RPAREN,
    STATE(392), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(726), 2,
      anon_sym_COMMA,
      anon_sym_SEMI,
  [12808] = 5,
    ACTIONS(903), 1,
      anon_sym_LBRACE,
    ACTIONS(1174), 1,
      anon_sym_LPAREN,
    STATE(89), 1,
      sym_block,
    STATE(427), 1,
      sym_parameters,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [12825] = 4,
    ACTIONS(1176), 1,
      anon_sym_RPAREN,
    STATE(392), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(726), 2,
      anon_sym_COMMA,
      anon_sym_SEMI,
  [12840] = 5,
    ACTIONS(909), 1,
      anon_sym_LBRACE,
    ACTIONS(1174), 1,
      anon_sym_LPAREN,
    STATE(57), 1,
      sym_block,
    STATE(437), 1,
      sym_parameters,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [12857] = 4,
    ACTIONS(909), 1,
      anon_sym_LBRACE,
    STATE(63), 1,
      sym_block,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(1132), 2,
      anon_sym_and,
      anon_sym_or,
  [12872] = 4,
    ACTIONS(1178), 1,
      anon_sym_RPAREN,
    STATE(392), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(726), 2,
      anon_sym_COMMA,
      anon_sym_SEMI,
  [12887] = 5,
    ACTIONS(903), 1,
      anon_sym_LBRACE,
    ACTIONS(1174), 1,
      anon_sym_LPAREN,
    STATE(123), 1,
      sym_block,
    STATE(429), 1,
      sym_parameters,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [12904] = 4,
    ACTIONS(1180), 1,
      anon_sym_RPAREN,
    STATE(392), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(726), 2,
      anon_sym_COMMA,
      anon_sym_SEMI,
  [12919] = 5,
    ACTIONS(903), 1,
      anon_sym_LBRACE,
    ACTIONS(1128), 1,
      anon_sym_COMMA,
    STATE(93), 1,
      sym_block,
    STATE(397), 1,
      aux_sym_import_statement_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [12936] = 4,
    ACTIONS(813), 1,
      anon_sym_RPAREN,
    STATE(392), 1,
      aux_sym_arguments_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(1182), 2,
      anon_sym_COMMA,
      anon_sym_SEMI,
  [12951] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(1185), 4,
      anon_sym_RBRACE,
      anon_sym_from,
      sym_to,
      aux_sym_integer_value_token1,
  [12962] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(344), 4,
      anon_sym_RBRACE,
      anon_sym_from,
      sym_to,
      aux_sym_integer_value_token1,
  [12973] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(376), 4,
      anon_sym_RBRACE,
      anon_sym_from,
      sym_to,
      aux_sym_integer_value_token1,
  [12984] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(372), 4,
      anon_sym_RBRACE,
      anon_sym_from,
      sym_to,
      aux_sym_integer_value_token1,
  [12995] = 4,
    ACTIONS(1187), 1,
      anon_sym_COMMA,
    STATE(397), 1,
      aux_sym_import_statement_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(1158), 2,
      anon_sym_SEMI,
      anon_sym_LBRACE,
  [13010] = 4,
    ACTIONS(903), 1,
      anon_sym_LBRACE,
    STATE(88), 1,
      sym_block,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(1132), 2,
      anon_sym_and,
      anon_sym_or,
  [13025] = 5,
    ACTIONS(909), 1,
      anon_sym_LBRACE,
    ACTIONS(1174), 1,
      anon_sym_LPAREN,
    STATE(53), 1,
      sym_block,
    STATE(430), 1,
      sym_parameters,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13042] = 4,
    ACTIONS(1128), 1,
      anon_sym_COMMA,
    ACTIONS(1190), 1,
      anon_sym_SEMI,
    STATE(397), 1,
      aux_sym_import_statement_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13056] = 4,
    ACTIONS(1037), 1,
      anon_sym_LBRACE,
    ACTIONS(1192), 1,
      anon_sym_COMMA,
    STATE(401), 1,
      aux_sym_selectors_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13070] = 4,
    ACTIONS(945), 1,
      anon_sym_COMMA,
    ACTIONS(1195), 1,
      anon_sym_LBRACE,
    STATE(401), 1,
      aux_sym_selectors_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13084] = 4,
    ACTIONS(1197), 1,
      sym_string_value,
    ACTIONS(1199), 1,
      sym_identifier,
    STATE(454), 1,
      sym_call_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13098] = 4,
    ACTIONS(1201), 1,
      anon_sym_COMMA,
    ACTIONS(1203), 1,
      anon_sym_RPAREN2,
    STATE(409), 1,
      aux_sym_include_arguments_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13112] = 4,
    ACTIONS(1205), 1,
      anon_sym_COMMA,
    ACTIONS(1207), 1,
      anon_sym_RPAREN,
    STATE(416), 1,
      aux_sym_parameters_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13126] = 4,
    ACTIONS(773), 1,
      anon_sym_COMMA,
    ACTIONS(1209), 1,
      anon_sym_RPAREN,
    STATE(413), 1,
      aux_sym_pseudo_class_arguments_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13140] = 4,
    ACTIONS(909), 1,
      anon_sym_LBRACE,
    ACTIONS(1211), 1,
      anon_sym_SEMI,
    STATE(35), 1,
      sym_block,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13154] = 4,
    ACTIONS(909), 1,
      anon_sym_LBRACE,
    ACTIONS(1213), 1,
      anon_sym_if,
    STATE(45), 1,
      sym_block,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13168] = 4,
    ACTIONS(1215), 1,
      anon_sym_COMMA,
    ACTIONS(1218), 1,
      anon_sym_RPAREN2,
    STATE(409), 1,
      aux_sym_include_arguments_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13182] = 3,
    ACTIONS(1222), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(1220), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [13194] = 4,
    ACTIONS(1128), 1,
      anon_sym_COMMA,
    ACTIONS(1224), 1,
      anon_sym_SEMI,
    STATE(397), 1,
      aux_sym_import_statement_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13208] = 4,
    ACTIONS(903), 1,
      anon_sym_LBRACE,
    ACTIONS(1226), 1,
      anon_sym_SEMI,
    STATE(101), 1,
      sym_block,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13222] = 4,
    ACTIONS(815), 1,
      anon_sym_RPAREN,
    ACTIONS(1228), 1,
      anon_sym_COMMA,
    STATE(413), 1,
      aux_sym_pseudo_class_arguments_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13236] = 4,
    ACTIONS(903), 1,
      anon_sym_LBRACE,
    ACTIONS(1231), 1,
      anon_sym_if,
    STATE(84), 1,
      sym_block,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13250] = 4,
    ACTIONS(1205), 1,
      anon_sym_COMMA,
    ACTIONS(1233), 1,
      anon_sym_RPAREN,
    STATE(405), 1,
      aux_sym_parameters_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13264] = 4,
    ACTIONS(1235), 1,
      anon_sym_COMMA,
    ACTIONS(1238), 1,
      anon_sym_RPAREN,
    STATE(416), 1,
      aux_sym_parameters_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13278] = 3,
    ACTIONS(1240), 1,
      anon_sym_RPAREN,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(1132), 2,
      anon_sym_and,
      anon_sym_or,
  [13290] = 4,
    ACTIONS(1201), 1,
      anon_sym_COMMA,
    ACTIONS(1242), 1,
      anon_sym_RPAREN2,
    STATE(404), 1,
      aux_sym_include_arguments_repeat1,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13304] = 4,
    ACTIONS(1244), 1,
      sym_string_value,
    ACTIONS(1246), 1,
      sym_identifier,
    STATE(481), 1,
      sym_call_expression,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13318] = 3,
    ACTIONS(909), 1,
      anon_sym_LBRACE,
    STATE(75), 1,
      sym_block,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13329] = 3,
    ACTIONS(1248), 1,
      anon_sym_LBRACE,
    STATE(87), 1,
      sym_keyframe_block_list,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13340] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(1238), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [13349] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(1218), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN2,
  [13358] = 3,
    ACTIONS(1250), 1,
      anon_sym_COMMA,
    ACTIONS(1252), 1,
      anon_sym_in,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13369] = 3,
    ACTIONS(909), 1,
      anon_sym_LBRACE,
    STATE(55), 1,
      sym_block,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13380] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(1254), 2,
      anon_sym_SEMI,
      anon_sym_LBRACE,
  [13389] = 3,
    ACTIONS(903), 1,
      anon_sym_LBRACE,
    STATE(100), 1,
      sym_block,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13400] = 3,
    ACTIONS(903), 1,
      anon_sym_LBRACE,
    STATE(119), 1,
      sym_block,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13411] = 3,
    ACTIONS(903), 1,
      anon_sym_LBRACE,
    STATE(102), 1,
      sym_block,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13422] = 3,
    ACTIONS(909), 1,
      anon_sym_LBRACE,
    STATE(32), 1,
      sym_block,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13433] = 3,
    ACTIONS(1256), 1,
      aux_sym_color_value_token1,
    ACTIONS(1258), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13444] = 3,
    ACTIONS(630), 1,
      anon_sym_LBRACE,
    ACTIONS(1260), 1,
      sym_unit,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13455] = 2,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
    ACTIONS(1262), 2,
      anon_sym_SEMI,
      anon_sym_LBRACE,
  [13464] = 3,
    ACTIONS(817), 1,
      anon_sym_LPAREN2,
    STATE(193), 1,
      sym_arguments,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13475] = 3,
    ACTIONS(1264), 1,
      sym_variable_identifier,
    STATE(422), 1,
      sym_parameter,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13486] = 3,
    ACTIONS(1266), 1,
      anon_sym_LBRACE,
    STATE(393), 1,
      sym_block,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13497] = 3,
    ACTIONS(909), 1,
      anon_sym_LBRACE,
    STATE(38), 1,
      sym_block,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13508] = 3,
    ACTIONS(1258), 1,
      sym_identifier,
    ACTIONS(1268), 1,
      aux_sym_color_value_token1,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13519] = 3,
    ACTIONS(1270), 1,
      anon_sym_COMMA,
    ACTIONS(1272), 1,
      anon_sym_in,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13530] = 3,
    ACTIONS(712), 1,
      anon_sym_SEMI,
    ACTIONS(714), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13541] = 3,
    ACTIONS(1264), 1,
      sym_variable_identifier,
    STATE(415), 1,
      sym_parameter,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13552] = 3,
    ACTIONS(1274), 1,
      anon_sym_SEMI,
    ACTIONS(1276), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13563] = 3,
    ACTIONS(1278), 1,
      anon_sym_LBRACE,
    STATE(64), 1,
      sym_keyframe_block_list,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13574] = 2,
    ACTIONS(1280), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13582] = 2,
    ACTIONS(1282), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13590] = 2,
    ACTIONS(1284), 1,
      anon_sym_LBRACE,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13598] = 2,
    ACTIONS(712), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13606] = 2,
    ACTIONS(781), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13614] = 2,
    ACTIONS(1286), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13622] = 2,
    ACTIONS(1274), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13630] = 2,
    ACTIONS(1288), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13638] = 2,
    ACTIONS(1290), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13646] = 2,
    ACTIONS(1292), 1,
      aux_sym_color_value_token1,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13654] = 2,
    ACTIONS(1294), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13662] = 2,
    ACTIONS(214), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13670] = 2,
    ACTIONS(1296), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13678] = 2,
    ACTIONS(1298), 1,
      sym_variable_identifier,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13686] = 2,
    ACTIONS(1300), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13694] = 2,
    ACTIONS(1302), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13702] = 2,
    ACTIONS(1304), 1,
      aux_sym_color_value_token1,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13710] = 2,
    ACTIONS(220), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13718] = 2,
    ACTIONS(1306), 1,
      anon_sym_LBRACE,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13726] = 2,
    ACTIONS(1308), 1,
      anon_sym_LPAREN,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13734] = 2,
    ACTIONS(228), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13742] = 2,
    ACTIONS(1310), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13750] = 2,
    ACTIONS(1213), 1,
      anon_sym_if,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13758] = 2,
    ACTIONS(1312), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13766] = 2,
    ACTIONS(1314), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13774] = 2,
    ACTIONS(1316), 1,
      aux_sym_color_value_token1,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13782] = 2,
    ACTIONS(176), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13790] = 2,
    ACTIONS(777), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13798] = 2,
    ACTIONS(1318), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13806] = 2,
    ACTIONS(1320), 1,
      ts_builtin_sym_end,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13814] = 2,
    ACTIONS(1322), 1,
      anon_sym_LBRACE,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13822] = 2,
    ACTIONS(218), 1,
      anon_sym_RBRACE,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13830] = 2,
    ACTIONS(769), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13838] = 2,
    ACTIONS(1324), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13846] = 2,
    ACTIONS(1326), 1,
      anon_sym_in,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13854] = 2,
    ACTIONS(1328), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13862] = 2,
    ACTIONS(1330), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13870] = 2,
    ACTIONS(1332), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13878] = 2,
    ACTIONS(1334), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13886] = 2,
    ACTIONS(1336), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13894] = 2,
    ACTIONS(1338), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13902] = 2,
    ACTIONS(1340), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13910] = 2,
    ACTIONS(895), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13918] = 2,
    ACTIONS(1342), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13926] = 2,
    ACTIONS(1344), 1,
      aux_sym_color_value_token1,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13934] = 2,
    ACTIONS(1346), 1,
      sym_variable_identifier,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13942] = 2,
    ACTIONS(1348), 1,
      sym_variable_identifier,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13950] = 2,
    ACTIONS(1350), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13958] = 2,
    ACTIONS(1352), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13966] = 2,
    ACTIONS(1231), 1,
      anon_sym_if,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13974] = 2,
    ACTIONS(1354), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13982] = 2,
    ACTIONS(1356), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13990] = 2,
    ACTIONS(1358), 1,
      anon_sym_from,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [13998] = 2,
    ACTIONS(1360), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [14006] = 2,
    ACTIONS(1362), 1,
      anon_sym_SEMI,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [14014] = 2,
    ACTIONS(1364), 1,
      anon_sym_COLON,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [14022] = 2,
    ACTIONS(1366), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [14030] = 2,
    ACTIONS(1368), 1,
      anon_sym_in,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [14038] = 2,
    ACTIONS(1370), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [14046] = 2,
    ACTIONS(1372), 1,
      sym_variable_identifier,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [14054] = 2,
    ACTIONS(1374), 1,
      sym_variable_identifier,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [14062] = 2,
    ACTIONS(1376), 1,
      sym_identifier,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [14070] = 2,
    ACTIONS(1378), 1,
      anon_sym_from,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
  [14078] = 2,
    ACTIONS(1380), 1,
      sym_variable_identifier,
    ACTIONS(3), 2,
      sym_comment,
      sym_single_line_comment,
};

static uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(15)] = 0,
  [SMALL_STATE(16)] = 52,
  [SMALL_STATE(17)] = 104,
  [SMALL_STATE(18)] = 155,
  [SMALL_STATE(19)] = 206,
  [SMALL_STATE(20)] = 255,
  [SMALL_STATE(21)] = 303,
  [SMALL_STATE(22)] = 346,
  [SMALL_STATE(23)] = 423,
  [SMALL_STATE(24)] = 466,
  [SMALL_STATE(25)] = 509,
  [SMALL_STATE(26)] = 552,
  [SMALL_STATE(27)] = 595,
  [SMALL_STATE(28)] = 637,
  [SMALL_STATE(29)] = 711,
  [SMALL_STATE(30)] = 753,
  [SMALL_STATE(31)] = 795,
  [SMALL_STATE(32)] = 837,
  [SMALL_STATE(33)] = 879,
  [SMALL_STATE(34)] = 921,
  [SMALL_STATE(35)] = 963,
  [SMALL_STATE(36)] = 1005,
  [SMALL_STATE(37)] = 1047,
  [SMALL_STATE(38)] = 1089,
  [SMALL_STATE(39)] = 1131,
  [SMALL_STATE(40)] = 1173,
  [SMALL_STATE(41)] = 1215,
  [SMALL_STATE(42)] = 1257,
  [SMALL_STATE(43)] = 1299,
  [SMALL_STATE(44)] = 1341,
  [SMALL_STATE(45)] = 1383,
  [SMALL_STATE(46)] = 1425,
  [SMALL_STATE(47)] = 1467,
  [SMALL_STATE(48)] = 1509,
  [SMALL_STATE(49)] = 1551,
  [SMALL_STATE(50)] = 1593,
  [SMALL_STATE(51)] = 1635,
  [SMALL_STATE(52)] = 1677,
  [SMALL_STATE(53)] = 1719,
  [SMALL_STATE(54)] = 1761,
  [SMALL_STATE(55)] = 1803,
  [SMALL_STATE(56)] = 1845,
  [SMALL_STATE(57)] = 1887,
  [SMALL_STATE(58)] = 1929,
  [SMALL_STATE(59)] = 1971,
  [SMALL_STATE(60)] = 2013,
  [SMALL_STATE(61)] = 2055,
  [SMALL_STATE(62)] = 2097,
  [SMALL_STATE(63)] = 2139,
  [SMALL_STATE(64)] = 2181,
  [SMALL_STATE(65)] = 2223,
  [SMALL_STATE(66)] = 2265,
  [SMALL_STATE(67)] = 2307,
  [SMALL_STATE(68)] = 2349,
  [SMALL_STATE(69)] = 2391,
  [SMALL_STATE(70)] = 2433,
  [SMALL_STATE(71)] = 2475,
  [SMALL_STATE(72)] = 2517,
  [SMALL_STATE(73)] = 2559,
  [SMALL_STATE(74)] = 2601,
  [SMALL_STATE(75)] = 2643,
  [SMALL_STATE(76)] = 2685,
  [SMALL_STATE(77)] = 2727,
  [SMALL_STATE(78)] = 2769,
  [SMALL_STATE(79)] = 2811,
  [SMALL_STATE(80)] = 2852,
  [SMALL_STATE(81)] = 2893,
  [SMALL_STATE(82)] = 2934,
  [SMALL_STATE(83)] = 2975,
  [SMALL_STATE(84)] = 3016,
  [SMALL_STATE(85)] = 3057,
  [SMALL_STATE(86)] = 3098,
  [SMALL_STATE(87)] = 3139,
  [SMALL_STATE(88)] = 3180,
  [SMALL_STATE(89)] = 3221,
  [SMALL_STATE(90)] = 3262,
  [SMALL_STATE(91)] = 3303,
  [SMALL_STATE(92)] = 3344,
  [SMALL_STATE(93)] = 3385,
  [SMALL_STATE(94)] = 3426,
  [SMALL_STATE(95)] = 3467,
  [SMALL_STATE(96)] = 3508,
  [SMALL_STATE(97)] = 3549,
  [SMALL_STATE(98)] = 3590,
  [SMALL_STATE(99)] = 3631,
  [SMALL_STATE(100)] = 3672,
  [SMALL_STATE(101)] = 3713,
  [SMALL_STATE(102)] = 3754,
  [SMALL_STATE(103)] = 3795,
  [SMALL_STATE(104)] = 3836,
  [SMALL_STATE(105)] = 3877,
  [SMALL_STATE(106)] = 3918,
  [SMALL_STATE(107)] = 3959,
  [SMALL_STATE(108)] = 4000,
  [SMALL_STATE(109)] = 4041,
  [SMALL_STATE(110)] = 4082,
  [SMALL_STATE(111)] = 4123,
  [SMALL_STATE(112)] = 4164,
  [SMALL_STATE(113)] = 4205,
  [SMALL_STATE(114)] = 4246,
  [SMALL_STATE(115)] = 4287,
  [SMALL_STATE(116)] = 4328,
  [SMALL_STATE(117)] = 4369,
  [SMALL_STATE(118)] = 4410,
  [SMALL_STATE(119)] = 4451,
  [SMALL_STATE(120)] = 4492,
  [SMALL_STATE(121)] = 4533,
  [SMALL_STATE(122)] = 4574,
  [SMALL_STATE(123)] = 4647,
  [SMALL_STATE(124)] = 4688,
  [SMALL_STATE(125)] = 4757,
  [SMALL_STATE(126)] = 4823,
  [SMALL_STATE(127)] = 4889,
  [SMALL_STATE(128)] = 4955,
  [SMALL_STATE(129)] = 5021,
  [SMALL_STATE(130)] = 5067,
  [SMALL_STATE(131)] = 5107,
  [SMALL_STATE(132)] = 5145,
  [SMALL_STATE(133)] = 5180,
  [SMALL_STATE(134)] = 5215,
  [SMALL_STATE(135)] = 5247,
  [SMALL_STATE(136)] = 5279,
  [SMALL_STATE(137)] = 5311,
  [SMALL_STATE(138)] = 5343,
  [SMALL_STATE(139)] = 5375,
  [SMALL_STATE(140)] = 5407,
  [SMALL_STATE(141)] = 5439,
  [SMALL_STATE(142)] = 5471,
  [SMALL_STATE(143)] = 5503,
  [SMALL_STATE(144)] = 5535,
  [SMALL_STATE(145)] = 5567,
  [SMALL_STATE(146)] = 5602,
  [SMALL_STATE(147)] = 5645,
  [SMALL_STATE(148)] = 5680,
  [SMALL_STATE(149)] = 5723,
  [SMALL_STATE(150)] = 5757,
  [SMALL_STATE(151)] = 5795,
  [SMALL_STATE(152)] = 5850,
  [SMALL_STATE(153)] = 5895,
  [SMALL_STATE(154)] = 5940,
  [SMALL_STATE(155)] = 5985,
  [SMALL_STATE(156)] = 6038,
  [SMALL_STATE(157)] = 6091,
  [SMALL_STATE(158)] = 6136,
  [SMALL_STATE(159)] = 6181,
  [SMALL_STATE(160)] = 6234,
  [SMALL_STATE(161)] = 6287,
  [SMALL_STATE(162)] = 6338,
  [SMALL_STATE(163)] = 6383,
  [SMALL_STATE(164)] = 6435,
  [SMALL_STATE(165)] = 6487,
  [SMALL_STATE(166)] = 6519,
  [SMALL_STATE(167)] = 6571,
  [SMALL_STATE(168)] = 6623,
  [SMALL_STATE(169)] = 6671,
  [SMALL_STATE(170)] = 6723,
  [SMALL_STATE(171)] = 6771,
  [SMALL_STATE(172)] = 6802,
  [SMALL_STATE(173)] = 6849,
  [SMALL_STATE(174)] = 6880,
  [SMALL_STATE(175)] = 6926,
  [SMALL_STATE(176)] = 6972,
  [SMALL_STATE(177)] = 7018,
  [SMALL_STATE(178)] = 7064,
  [SMALL_STATE(179)] = 7110,
  [SMALL_STATE(180)] = 7136,
  [SMALL_STATE(181)] = 7164,
  [SMALL_STATE(182)] = 7210,
  [SMALL_STATE(183)] = 7256,
  [SMALL_STATE(184)] = 7284,
  [SMALL_STATE(185)] = 7309,
  [SMALL_STATE(186)] = 7334,
  [SMALL_STATE(187)] = 7359,
  [SMALL_STATE(188)] = 7384,
  [SMALL_STATE(189)] = 7409,
  [SMALL_STATE(190)] = 7434,
  [SMALL_STATE(191)] = 7459,
  [SMALL_STATE(192)] = 7484,
  [SMALL_STATE(193)] = 7509,
  [SMALL_STATE(194)] = 7534,
  [SMALL_STATE(195)] = 7559,
  [SMALL_STATE(196)] = 7602,
  [SMALL_STATE(197)] = 7627,
  [SMALL_STATE(198)] = 7652,
  [SMALL_STATE(199)] = 7677,
  [SMALL_STATE(200)] = 7702,
  [SMALL_STATE(201)] = 7745,
  [SMALL_STATE(202)] = 7772,
  [SMALL_STATE(203)] = 7797,
  [SMALL_STATE(204)] = 7822,
  [SMALL_STATE(205)] = 7847,
  [SMALL_STATE(206)] = 7872,
  [SMALL_STATE(207)] = 7915,
  [SMALL_STATE(208)] = 7940,
  [SMALL_STATE(209)] = 7965,
  [SMALL_STATE(210)] = 7992,
  [SMALL_STATE(211)] = 8035,
  [SMALL_STATE(212)] = 8075,
  [SMALL_STATE(213)] = 8115,
  [SMALL_STATE(214)] = 8155,
  [SMALL_STATE(215)] = 8195,
  [SMALL_STATE(216)] = 8235,
  [SMALL_STATE(217)] = 8275,
  [SMALL_STATE(218)] = 8303,
  [SMALL_STATE(219)] = 8343,
  [SMALL_STATE(220)] = 8383,
  [SMALL_STATE(221)] = 8423,
  [SMALL_STATE(222)] = 8463,
  [SMALL_STATE(223)] = 8503,
  [SMALL_STATE(224)] = 8543,
  [SMALL_STATE(225)] = 8583,
  [SMALL_STATE(226)] = 8623,
  [SMALL_STATE(227)] = 8663,
  [SMALL_STATE(228)] = 8703,
  [SMALL_STATE(229)] = 8743,
  [SMALL_STATE(230)] = 8783,
  [SMALL_STATE(231)] = 8823,
  [SMALL_STATE(232)] = 8863,
  [SMALL_STATE(233)] = 8903,
  [SMALL_STATE(234)] = 8943,
  [SMALL_STATE(235)] = 8983,
  [SMALL_STATE(236)] = 9023,
  [SMALL_STATE(237)] = 9063,
  [SMALL_STATE(238)] = 9103,
  [SMALL_STATE(239)] = 9143,
  [SMALL_STATE(240)] = 9183,
  [SMALL_STATE(241)] = 9223,
  [SMALL_STATE(242)] = 9263,
  [SMALL_STATE(243)] = 9303,
  [SMALL_STATE(244)] = 9343,
  [SMALL_STATE(245)] = 9383,
  [SMALL_STATE(246)] = 9423,
  [SMALL_STATE(247)] = 9463,
  [SMALL_STATE(248)] = 9503,
  [SMALL_STATE(249)] = 9543,
  [SMALL_STATE(250)] = 9583,
  [SMALL_STATE(251)] = 9623,
  [SMALL_STATE(252)] = 9663,
  [SMALL_STATE(253)] = 9703,
  [SMALL_STATE(254)] = 9743,
  [SMALL_STATE(255)] = 9783,
  [SMALL_STATE(256)] = 9823,
  [SMALL_STATE(257)] = 9851,
  [SMALL_STATE(258)] = 9891,
  [SMALL_STATE(259)] = 9931,
  [SMALL_STATE(260)] = 9971,
  [SMALL_STATE(261)] = 9996,
  [SMALL_STATE(262)] = 10019,
  [SMALL_STATE(263)] = 10054,
  [SMALL_STATE(264)] = 10081,
  [SMALL_STATE(265)] = 10116,
  [SMALL_STATE(266)] = 10139,
  [SMALL_STATE(267)] = 10161,
  [SMALL_STATE(268)] = 10183,
  [SMALL_STATE(269)] = 10205,
  [SMALL_STATE(270)] = 10227,
  [SMALL_STATE(271)] = 10251,
  [SMALL_STATE(272)] = 10273,
  [SMALL_STATE(273)] = 10295,
  [SMALL_STATE(274)] = 10317,
  [SMALL_STATE(275)] = 10359,
  [SMALL_STATE(276)] = 10381,
  [SMALL_STATE(277)] = 10403,
  [SMALL_STATE(278)] = 10427,
  [SMALL_STATE(279)] = 10449,
  [SMALL_STATE(280)] = 10471,
  [SMALL_STATE(281)] = 10495,
  [SMALL_STATE(282)] = 10519,
  [SMALL_STATE(283)] = 10541,
  [SMALL_STATE(284)] = 10583,
  [SMALL_STATE(285)] = 10605,
  [SMALL_STATE(286)] = 10629,
  [SMALL_STATE(287)] = 10651,
  [SMALL_STATE(288)] = 10673,
  [SMALL_STATE(289)] = 10697,
  [SMALL_STATE(290)] = 10721,
  [SMALL_STATE(291)] = 10742,
  [SMALL_STATE(292)] = 10767,
  [SMALL_STATE(293)] = 10788,
  [SMALL_STATE(294)] = 10825,
  [SMALL_STATE(295)] = 10846,
  [SMALL_STATE(296)] = 10867,
  [SMALL_STATE(297)] = 10888,
  [SMALL_STATE(298)] = 10909,
  [SMALL_STATE(299)] = 10932,
  [SMALL_STATE(300)] = 10955,
  [SMALL_STATE(301)] = 10976,
  [SMALL_STATE(302)] = 10997,
  [SMALL_STATE(303)] = 11020,
  [SMALL_STATE(304)] = 11041,
  [SMALL_STATE(305)] = 11062,
  [SMALL_STATE(306)] = 11099,
  [SMALL_STATE(307)] = 11124,
  [SMALL_STATE(308)] = 11149,
  [SMALL_STATE(309)] = 11170,
  [SMALL_STATE(310)] = 11195,
  [SMALL_STATE(311)] = 11220,
  [SMALL_STATE(312)] = 11245,
  [SMALL_STATE(313)] = 11270,
  [SMALL_STATE(314)] = 11291,
  [SMALL_STATE(315)] = 11314,
  [SMALL_STATE(316)] = 11335,
  [SMALL_STATE(317)] = 11356,
  [SMALL_STATE(318)] = 11381,
  [SMALL_STATE(319)] = 11404,
  [SMALL_STATE(320)] = 11429,
  [SMALL_STATE(321)] = 11454,
  [SMALL_STATE(322)] = 11479,
  [SMALL_STATE(323)] = 11504,
  [SMALL_STATE(324)] = 11529,
  [SMALL_STATE(325)] = 11551,
  [SMALL_STATE(326)] = 11573,
  [SMALL_STATE(327)] = 11595,
  [SMALL_STATE(328)] = 11621,
  [SMALL_STATE(329)] = 11647,
  [SMALL_STATE(330)] = 11669,
  [SMALL_STATE(331)] = 11691,
  [SMALL_STATE(332)] = 11713,
  [SMALL_STATE(333)] = 11735,
  [SMALL_STATE(334)] = 11757,
  [SMALL_STATE(335)] = 11779,
  [SMALL_STATE(336)] = 11805,
  [SMALL_STATE(337)] = 11827,
  [SMALL_STATE(338)] = 11849,
  [SMALL_STATE(339)] = 11871,
  [SMALL_STATE(340)] = 11893,
  [SMALL_STATE(341)] = 11919,
  [SMALL_STATE(342)] = 11945,
  [SMALL_STATE(343)] = 11971,
  [SMALL_STATE(344)] = 11997,
  [SMALL_STATE(345)] = 12019,
  [SMALL_STATE(346)] = 12041,
  [SMALL_STATE(347)] = 12077,
  [SMALL_STATE(348)] = 12099,
  [SMALL_STATE(349)] = 12121,
  [SMALL_STATE(350)] = 12147,
  [SMALL_STATE(351)] = 12169,
  [SMALL_STATE(352)] = 12191,
  [SMALL_STATE(353)] = 12213,
  [SMALL_STATE(354)] = 12235,
  [SMALL_STATE(355)] = 12268,
  [SMALL_STATE(356)] = 12293,
  [SMALL_STATE(357)] = 12318,
  [SMALL_STATE(358)] = 12343,
  [SMALL_STATE(359)] = 12368,
  [SMALL_STATE(360)] = 12393,
  [SMALL_STATE(361)] = 12409,
  [SMALL_STATE(362)] = 12425,
  [SMALL_STATE(363)] = 12449,
  [SMALL_STATE(364)] = 12473,
  [SMALL_STATE(365)] = 12486,
  [SMALL_STATE(366)] = 12499,
  [SMALL_STATE(367)] = 12512,
  [SMALL_STATE(368)] = 12525,
  [SMALL_STATE(369)] = 12546,
  [SMALL_STATE(370)] = 12559,
  [SMALL_STATE(371)] = 12572,
  [SMALL_STATE(372)] = 12593,
  [SMALL_STATE(373)] = 12613,
  [SMALL_STATE(374)] = 12633,
  [SMALL_STATE(375)] = 12653,
  [SMALL_STATE(376)] = 12667,
  [SMALL_STATE(377)] = 12687,
  [SMALL_STATE(378)] = 12705,
  [SMALL_STATE(379)] = 12723,
  [SMALL_STATE(380)] = 12743,
  [SMALL_STATE(381)] = 12763,
  [SMALL_STATE(382)] = 12776,
  [SMALL_STATE(383)] = 12793,
  [SMALL_STATE(384)] = 12808,
  [SMALL_STATE(385)] = 12825,
  [SMALL_STATE(386)] = 12840,
  [SMALL_STATE(387)] = 12857,
  [SMALL_STATE(388)] = 12872,
  [SMALL_STATE(389)] = 12887,
  [SMALL_STATE(390)] = 12904,
  [SMALL_STATE(391)] = 12919,
  [SMALL_STATE(392)] = 12936,
  [SMALL_STATE(393)] = 12951,
  [SMALL_STATE(394)] = 12962,
  [SMALL_STATE(395)] = 12973,
  [SMALL_STATE(396)] = 12984,
  [SMALL_STATE(397)] = 12995,
  [SMALL_STATE(398)] = 13010,
  [SMALL_STATE(399)] = 13025,
  [SMALL_STATE(400)] = 13042,
  [SMALL_STATE(401)] = 13056,
  [SMALL_STATE(402)] = 13070,
  [SMALL_STATE(403)] = 13084,
  [SMALL_STATE(404)] = 13098,
  [SMALL_STATE(405)] = 13112,
  [SMALL_STATE(406)] = 13126,
  [SMALL_STATE(407)] = 13140,
  [SMALL_STATE(408)] = 13154,
  [SMALL_STATE(409)] = 13168,
  [SMALL_STATE(410)] = 13182,
  [SMALL_STATE(411)] = 13194,
  [SMALL_STATE(412)] = 13208,
  [SMALL_STATE(413)] = 13222,
  [SMALL_STATE(414)] = 13236,
  [SMALL_STATE(415)] = 13250,
  [SMALL_STATE(416)] = 13264,
  [SMALL_STATE(417)] = 13278,
  [SMALL_STATE(418)] = 13290,
  [SMALL_STATE(419)] = 13304,
  [SMALL_STATE(420)] = 13318,
  [SMALL_STATE(421)] = 13329,
  [SMALL_STATE(422)] = 13340,
  [SMALL_STATE(423)] = 13349,
  [SMALL_STATE(424)] = 13358,
  [SMALL_STATE(425)] = 13369,
  [SMALL_STATE(426)] = 13380,
  [SMALL_STATE(427)] = 13389,
  [SMALL_STATE(428)] = 13400,
  [SMALL_STATE(429)] = 13411,
  [SMALL_STATE(430)] = 13422,
  [SMALL_STATE(431)] = 13433,
  [SMALL_STATE(432)] = 13444,
  [SMALL_STATE(433)] = 13455,
  [SMALL_STATE(434)] = 13464,
  [SMALL_STATE(435)] = 13475,
  [SMALL_STATE(436)] = 13486,
  [SMALL_STATE(437)] = 13497,
  [SMALL_STATE(438)] = 13508,
  [SMALL_STATE(439)] = 13519,
  [SMALL_STATE(440)] = 13530,
  [SMALL_STATE(441)] = 13541,
  [SMALL_STATE(442)] = 13552,
  [SMALL_STATE(443)] = 13563,
  [SMALL_STATE(444)] = 13574,
  [SMALL_STATE(445)] = 13582,
  [SMALL_STATE(446)] = 13590,
  [SMALL_STATE(447)] = 13598,
  [SMALL_STATE(448)] = 13606,
  [SMALL_STATE(449)] = 13614,
  [SMALL_STATE(450)] = 13622,
  [SMALL_STATE(451)] = 13630,
  [SMALL_STATE(452)] = 13638,
  [SMALL_STATE(453)] = 13646,
  [SMALL_STATE(454)] = 13654,
  [SMALL_STATE(455)] = 13662,
  [SMALL_STATE(456)] = 13670,
  [SMALL_STATE(457)] = 13678,
  [SMALL_STATE(458)] = 13686,
  [SMALL_STATE(459)] = 13694,
  [SMALL_STATE(460)] = 13702,
  [SMALL_STATE(461)] = 13710,
  [SMALL_STATE(462)] = 13718,
  [SMALL_STATE(463)] = 13726,
  [SMALL_STATE(464)] = 13734,
  [SMALL_STATE(465)] = 13742,
  [SMALL_STATE(466)] = 13750,
  [SMALL_STATE(467)] = 13758,
  [SMALL_STATE(468)] = 13766,
  [SMALL_STATE(469)] = 13774,
  [SMALL_STATE(470)] = 13782,
  [SMALL_STATE(471)] = 13790,
  [SMALL_STATE(472)] = 13798,
  [SMALL_STATE(473)] = 13806,
  [SMALL_STATE(474)] = 13814,
  [SMALL_STATE(475)] = 13822,
  [SMALL_STATE(476)] = 13830,
  [SMALL_STATE(477)] = 13838,
  [SMALL_STATE(478)] = 13846,
  [SMALL_STATE(479)] = 13854,
  [SMALL_STATE(480)] = 13862,
  [SMALL_STATE(481)] = 13870,
  [SMALL_STATE(482)] = 13878,
  [SMALL_STATE(483)] = 13886,
  [SMALL_STATE(484)] = 13894,
  [SMALL_STATE(485)] = 13902,
  [SMALL_STATE(486)] = 13910,
  [SMALL_STATE(487)] = 13918,
  [SMALL_STATE(488)] = 13926,
  [SMALL_STATE(489)] = 13934,
  [SMALL_STATE(490)] = 13942,
  [SMALL_STATE(491)] = 13950,
  [SMALL_STATE(492)] = 13958,
  [SMALL_STATE(493)] = 13966,
  [SMALL_STATE(494)] = 13974,
  [SMALL_STATE(495)] = 13982,
  [SMALL_STATE(496)] = 13990,
  [SMALL_STATE(497)] = 13998,
  [SMALL_STATE(498)] = 14006,
  [SMALL_STATE(499)] = 14014,
  [SMALL_STATE(500)] = 14022,
  [SMALL_STATE(501)] = 14030,
  [SMALL_STATE(502)] = 14038,
  [SMALL_STATE(503)] = 14046,
  [SMALL_STATE(504)] = 14054,
  [SMALL_STATE(505)] = 14062,
  [SMALL_STATE(506)] = 14070,
  [SMALL_STATE(507)] = 14078,
};

static TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [5] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_stylesheet, 0),
  [7] = {.entry = {.count = 1, .reusable = false}}, SHIFT(235),
  [9] = {.entry = {.count = 1, .reusable = false}}, SHIFT(342),
  [11] = {.entry = {.count = 1, .reusable = false}}, SHIFT(215),
  [13] = {.entry = {.count = 1, .reusable = false}}, SHIFT(403),
  [15] = {.entry = {.count = 1, .reusable = false}}, SHIFT(497),
  [17] = {.entry = {.count = 1, .reusable = false}}, SHIFT(328),
  [19] = {.entry = {.count = 1, .reusable = false}}, SHIFT(220),
  [21] = {.entry = {.count = 1, .reusable = false}}, SHIFT(221),
  [23] = {.entry = {.count = 1, .reusable = false}}, SHIFT(174),
  [25] = {.entry = {.count = 1, .reusable = false}}, SHIFT(495),
  [27] = {.entry = {.count = 1, .reusable = false}}, SHIFT(494),
  [29] = {.entry = {.count = 1, .reusable = false}}, SHIFT(492),
  [31] = {.entry = {.count = 1, .reusable = true}}, SHIFT(491),
  [33] = {.entry = {.count = 1, .reusable = false}}, SHIFT(233),
  [35] = {.entry = {.count = 1, .reusable = false}}, SHIFT(490),
  [37] = {.entry = {.count = 1, .reusable = false}}, SHIFT(489),
  [39] = {.entry = {.count = 1, .reusable = false}}, SHIFT(242),
  [41] = {.entry = {.count = 1, .reusable = false}}, SHIFT(487),
  [43] = {.entry = {.count = 1, .reusable = false}}, SHIFT(246),
  [45] = {.entry = {.count = 1, .reusable = false}}, SHIFT(247),
  [47] = {.entry = {.count = 1, .reusable = false}}, SHIFT(249),
  [49] = {.entry = {.count = 1, .reusable = true}}, SHIFT(260),
  [51] = {.entry = {.count = 1, .reusable = true}}, SHIFT(268),
  [53] = {.entry = {.count = 1, .reusable = true}}, SHIFT(486),
  [55] = {.entry = {.count = 1, .reusable = true}}, SHIFT(485),
  [57] = {.entry = {.count = 1, .reusable = false}}, SHIFT(484),
  [59] = {.entry = {.count = 1, .reusable = true}}, SHIFT(482),
  [61] = {.entry = {.count = 1, .reusable = true}}, SHIFT(274),
  [63] = {.entry = {.count = 1, .reusable = false}}, SHIFT(296),
  [65] = {.entry = {.count = 1, .reusable = true}}, SHIFT(445),
  [67] = {.entry = {.count = 1, .reusable = false}}, SHIFT(264),
  [69] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_stylesheet_repeat1, 2),
  [71] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_stylesheet_repeat1, 2), SHIFT_REPEAT(235),
  [74] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_stylesheet_repeat1, 2), SHIFT_REPEAT(342),
  [77] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_stylesheet_repeat1, 2), SHIFT_REPEAT(215),
  [80] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_stylesheet_repeat1, 2), SHIFT_REPEAT(403),
  [83] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_stylesheet_repeat1, 2), SHIFT_REPEAT(497),
  [86] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_stylesheet_repeat1, 2), SHIFT_REPEAT(328),
  [89] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_stylesheet_repeat1, 2), SHIFT_REPEAT(220),
  [92] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_stylesheet_repeat1, 2), SHIFT_REPEAT(221),
  [95] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_stylesheet_repeat1, 2), SHIFT_REPEAT(174),
  [98] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_stylesheet_repeat1, 2), SHIFT_REPEAT(495),
  [101] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_stylesheet_repeat1, 2), SHIFT_REPEAT(494),
  [104] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_stylesheet_repeat1, 2), SHIFT_REPEAT(492),
  [107] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_stylesheet_repeat1, 2), SHIFT_REPEAT(491),
  [110] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_stylesheet_repeat1, 2), SHIFT_REPEAT(233),
  [113] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_stylesheet_repeat1, 2), SHIFT_REPEAT(490),
  [116] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_stylesheet_repeat1, 2), SHIFT_REPEAT(489),
  [119] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_stylesheet_repeat1, 2), SHIFT_REPEAT(242),
  [122] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_stylesheet_repeat1, 2), SHIFT_REPEAT(487),
  [125] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_stylesheet_repeat1, 2), SHIFT_REPEAT(246),
  [128] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_stylesheet_repeat1, 2), SHIFT_REPEAT(247),
  [131] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_stylesheet_repeat1, 2), SHIFT_REPEAT(249),
  [134] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_stylesheet_repeat1, 2), SHIFT_REPEAT(260),
  [137] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_stylesheet_repeat1, 2), SHIFT_REPEAT(268),
  [140] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_stylesheet_repeat1, 2), SHIFT_REPEAT(486),
  [143] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_stylesheet_repeat1, 2), SHIFT_REPEAT(485),
  [146] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_stylesheet_repeat1, 2), SHIFT_REPEAT(484),
  [149] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_stylesheet_repeat1, 2), SHIFT_REPEAT(482),
  [152] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_stylesheet_repeat1, 2), SHIFT_REPEAT(274),
  [155] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_stylesheet_repeat1, 2), SHIFT_REPEAT(296),
  [158] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_stylesheet_repeat1, 2), SHIFT_REPEAT(445),
  [161] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_stylesheet_repeat1, 2), SHIFT_REPEAT(264),
  [164] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_stylesheet, 1),
  [166] = {.entry = {.count = 1, .reusable = false}}, SHIFT(259),
  [168] = {.entry = {.count = 1, .reusable = false}}, SHIFT(340),
  [170] = {.entry = {.count = 1, .reusable = false}}, SHIFT(258),
  [172] = {.entry = {.count = 1, .reusable = false}}, SHIFT(419),
  [174] = {.entry = {.count = 1, .reusable = false}}, SHIFT(477),
  [176] = {.entry = {.count = 1, .reusable = true}}, SHIFT(72),
  [178] = {.entry = {.count = 1, .reusable = false}}, SHIFT(335),
  [180] = {.entry = {.count = 1, .reusable = false}}, SHIFT(479),
  [182] = {.entry = {.count = 1, .reusable = false}}, SHIFT(480),
  [184] = {.entry = {.count = 1, .reusable = false}}, SHIFT(122),
  [186] = {.entry = {.count = 1, .reusable = false}}, SHIFT(255),
  [188] = {.entry = {.count = 1, .reusable = false}}, SHIFT(503),
  [190] = {.entry = {.count = 1, .reusable = false}}, SHIFT(507),
  [192] = {.entry = {.count = 1, .reusable = false}}, SHIFT(254),
  [194] = {.entry = {.count = 1, .reusable = false}}, SHIFT(483),
  [196] = {.entry = {.count = 1, .reusable = false}}, SHIFT(232),
  [198] = {.entry = {.count = 1, .reusable = false}}, SHIFT(228),
  [200] = {.entry = {.count = 1, .reusable = false}}, SHIFT(253),
  [202] = {.entry = {.count = 1, .reusable = false}}, SHIFT(251),
  [204] = {.entry = {.count = 1, .reusable = false}}, SHIFT(245),
  [206] = {.entry = {.count = 1, .reusable = false}}, SHIFT(303),
  [208] = {.entry = {.count = 1, .reusable = true}}, SHIFT(499),
  [210] = {.entry = {.count = 1, .reusable = false}}, SHIFT(262),
  [212] = {.entry = {.count = 1, .reusable = true}}, SHIFT(49),
  [214] = {.entry = {.count = 1, .reusable = true}}, SHIFT(96),
  [216] = {.entry = {.count = 1, .reusable = true}}, SHIFT(394),
  [218] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
  [220] = {.entry = {.count = 1, .reusable = true}}, SHIFT(29),
  [222] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [224] = {.entry = {.count = 1, .reusable = true}}, SHIFT(108),
  [226] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [228] = {.entry = {.count = 1, .reusable = true}}, SHIFT(395),
  [230] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_block_repeat1, 2), SHIFT_REPEAT(259),
  [233] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_block_repeat1, 2), SHIFT_REPEAT(340),
  [236] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_block_repeat1, 2), SHIFT_REPEAT(258),
  [239] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_block_repeat1, 2), SHIFT_REPEAT(419),
  [242] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_block_repeat1, 2), SHIFT_REPEAT(477),
  [245] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_block_repeat1, 2),
  [247] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_block_repeat1, 2), SHIFT_REPEAT(335),
  [250] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_block_repeat1, 2), SHIFT_REPEAT(495),
  [253] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_block_repeat1, 2), SHIFT_REPEAT(479),
  [256] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_block_repeat1, 2), SHIFT_REPEAT(480),
  [259] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_block_repeat1, 2), SHIFT_REPEAT(122),
  [262] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_block_repeat1, 2), SHIFT_REPEAT(255),
  [265] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_block_repeat1, 2), SHIFT_REPEAT(503),
  [268] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_block_repeat1, 2), SHIFT_REPEAT(507),
  [271] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_block_repeat1, 2), SHIFT_REPEAT(254),
  [274] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_block_repeat1, 2), SHIFT_REPEAT(483),
  [277] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_block_repeat1, 2), SHIFT_REPEAT(232),
  [280] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_block_repeat1, 2), SHIFT_REPEAT(228),
  [283] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_block_repeat1, 2), SHIFT_REPEAT(253),
  [286] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_block_repeat1, 2), SHIFT_REPEAT(251),
  [289] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_block_repeat1, 2), SHIFT_REPEAT(245),
  [292] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_block_repeat1, 2), SHIFT_REPEAT(260),
  [295] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_block_repeat1, 2), SHIFT_REPEAT(268),
  [298] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_block_repeat1, 2), SHIFT_REPEAT(486),
  [301] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_block_repeat1, 2), SHIFT_REPEAT(485),
  [304] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_block_repeat1, 2), SHIFT_REPEAT(484),
  [307] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_block_repeat1, 2), SHIFT_REPEAT(482),
  [310] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_block_repeat1, 2), SHIFT_REPEAT(274),
  [313] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_block_repeat1, 2), SHIFT_REPEAT(294),
  [316] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_block_repeat1, 2), SHIFT_REPEAT(499),
  [319] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_block_repeat1, 2), SHIFT_REPEAT(262),
  [322] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 1),
  [324] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 1),
  [326] = {.entry = {.count = 1, .reusable = false}}, SHIFT(408),
  [328] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 2),
  [330] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 2),
  [332] = {.entry = {.count = 1, .reusable = false}}, SHIFT(414),
  [334] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_if_statement_repeat1, 2),
  [336] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_if_statement_repeat1, 2),
  [338] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_if_statement_repeat1, 2), SHIFT_REPEAT(466),
  [341] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_if_statement_repeat1, 2), SHIFT_REPEAT(493),
  [344] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block, 2),
  [346] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block, 2),
  [348] = {.entry = {.count = 1, .reusable = true}}, SHIFT(218),
  [350] = {.entry = {.count = 1, .reusable = true}}, SHIFT(286),
  [352] = {.entry = {.count = 1, .reusable = false}}, SHIFT(486),
  [354] = {.entry = {.count = 1, .reusable = false}}, SHIFT(431),
  [356] = {.entry = {.count = 1, .reusable = true}}, SHIFT(130),
  [358] = {.entry = {.count = 1, .reusable = false}}, SHIFT(132),
  [360] = {.entry = {.count = 1, .reusable = false}}, SHIFT(133),
  [362] = {.entry = {.count = 1, .reusable = false}}, SHIFT(129),
  [364] = {.entry = {.count = 1, .reusable = false}}, SHIFT(137),
  [366] = {.entry = {.count = 1, .reusable = false}}, SHIFT(141),
  [368] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_clause, 3, .production_id = 11),
  [370] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_clause, 3, .production_id = 11),
  [372] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block, 4),
  [374] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block, 4),
  [376] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block, 3),
  [378] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block, 3),
  [380] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_else_if_clause, 4, .production_id = 21),
  [382] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_else_if_clause, 4, .production_id = 21),
  [384] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_at_rule, 3),
  [386] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_at_rule, 3),
  [388] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_declaration, 4),
  [390] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_declaration, 4),
  [392] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_declaration, 4, .production_id = 18),
  [394] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_declaration, 4, .production_id = 18),
  [396] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_statement, 4, .production_id = 10),
  [398] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_statement, 4, .production_id = 10),
  [400] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_statement, 7, .production_id = 26),
  [402] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_for_statement, 7, .production_id = 26),
  [404] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_each_statement, 7, .production_id = 25),
  [406] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_each_statement, 7, .production_id = 25),
  [408] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_include_statement, 4),
  [410] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_include_statement, 4),
  [412] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_declaration, 6),
  [414] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_declaration, 6),
  [416] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_declaration, 6, .production_id = 18),
  [418] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_declaration, 6, .production_id = 18),
  [420] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_mixin_statement, 4, .production_id = 10),
  [422] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_mixin_statement, 4, .production_id = 10),
  [424] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_keyframe_block_list, 2),
  [426] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_keyframe_block_list, 2),
  [428] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_namespace_statement, 4, .production_id = 16),
  [430] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_namespace_statement, 4, .production_id = 16),
  [432] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_media_statement, 4),
  [434] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_media_statement, 4),
  [436] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import_statement, 4),
  [438] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_import_statement, 4),
  [440] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 3),
  [442] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 3),
  [444] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_else_clause, 2),
  [446] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_else_clause, 2),
  [448] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_declaration, 5),
  [450] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_declaration, 5),
  [452] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_at_rule, 4),
  [454] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_at_rule, 4),
  [456] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_debug_statement, 3),
  [458] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_debug_statement, 3),
  [460] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_warn_statement, 3),
  [462] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_warn_statement, 3),
  [464] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_error_statement, 3),
  [466] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_error_statement, 3),
  [468] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_statement, 3, .production_id = 10),
  [470] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_statement, 3, .production_id = 10),
  [472] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_while_statement, 3),
  [474] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_while_statement, 3),
  [476] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_placeholder, 3, .production_id = 10),
  [478] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_placeholder, 3, .production_id = 10),
  [480] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_include_statement, 3),
  [482] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_include_statement, 3),
  [484] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_mixin_statement, 3, .production_id = 10),
  [486] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_mixin_statement, 3, .production_id = 10),
  [488] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import_statement, 5),
  [490] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_import_statement, 5),
  [492] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_apply_statement, 3),
  [494] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_apply_statement, 3),
  [496] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_forward_statement, 3),
  [498] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_forward_statement, 3),
  [500] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_use_statement, 3),
  [502] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_use_statement, 3),
  [504] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_apply_statement, 2),
  [506] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_apply_statement, 2),
  [508] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_supports_statement, 3),
  [510] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_supports_statement, 3),
  [512] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_keyframes_statement, 3, .production_id = 9),
  [514] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_keyframes_statement, 3, .production_id = 9),
  [516] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_declaration, 5, .production_id = 18),
  [518] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_declaration, 5, .production_id = 18),
  [520] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_keyframe_block_list, 3),
  [522] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_keyframe_block_list, 3),
  [524] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_at_rule, 2),
  [526] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_at_rule, 2),
  [528] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_charset_statement, 3),
  [530] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_charset_statement, 3),
  [532] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_each_statement, 5, .production_id = 20),
  [534] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_each_statement, 5, .production_id = 20),
  [536] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_rule_set, 2),
  [538] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_rule_set, 2),
  [540] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_media_statement, 3),
  [542] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_media_statement, 3),
  [544] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_namespace_statement, 3),
  [546] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_namespace_statement, 3),
  [548] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import_statement, 3),
  [550] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_import_statement, 3),
  [552] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_at_root_statement, 3),
  [554] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_at_root_statement, 3),
  [556] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_return_statement, 3),
  [558] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_return_statement, 3),
  [560] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_extend_statement, 3),
  [562] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_extend_statement, 3),
  [564] = {.entry = {.count = 1, .reusable = true}}, SHIFT(239),
  [566] = {.entry = {.count = 1, .reusable = false}}, SHIFT(438),
  [568] = {.entry = {.count = 1, .reusable = true}}, SHIFT(165),
  [570] = {.entry = {.count = 1, .reusable = false}}, SHIFT(201),
  [572] = {.entry = {.count = 1, .reusable = false}}, SHIFT(209),
  [574] = {.entry = {.count = 1, .reusable = false}}, SHIFT(150),
  [576] = {.entry = {.count = 1, .reusable = false}}, SHIFT(189),
  [578] = {.entry = {.count = 1, .reusable = false}}, SHIFT(185),
  [580] = {.entry = {.count = 1, .reusable = true}}, SHIFT(223),
  [582] = {.entry = {.count = 1, .reusable = true}}, SHIFT(103),
  [584] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_last_declaration, 3, .production_id = 18),
  [586] = {.entry = {.count = 1, .reusable = true}}, SHIFT(237),
  [588] = {.entry = {.count = 1, .reusable = false}}, SHIFT(453),
  [590] = {.entry = {.count = 1, .reusable = false}}, SHIFT(237),
  [592] = {.entry = {.count = 1, .reusable = true}}, SHIFT(440),
  [594] = {.entry = {.count = 1, .reusable = true}}, SHIFT(141),
  [596] = {.entry = {.count = 1, .reusable = false}}, SHIFT(131),
  [598] = {.entry = {.count = 1, .reusable = true}}, SHIFT(105),
  [600] = {.entry = {.count = 1, .reusable = true}}, SHIFT(448),
  [602] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [604] = {.entry = {.count = 1, .reusable = true}}, SHIFT(471),
  [606] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [608] = {.entry = {.count = 1, .reusable = true}}, SHIFT(476),
  [610] = {.entry = {.count = 1, .reusable = true}}, SHIFT(447),
  [612] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__selector, 1, .production_id = 1),
  [614] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__value, 1, .production_id = 2),
  [616] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__selector, 1, .production_id = 1),
  [618] = {.entry = {.count = 1, .reusable = true}}, SHIFT(182),
  [620] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__value, 1, .production_id = 2),
  [622] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__selector, 1),
  [624] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__value, 1),
  [626] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__selector, 1),
  [628] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__value, 1),
  [630] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_integer_value, 1),
  [632] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_integer_value, 1),
  [634] = {.entry = {.count = 1, .reusable = false}}, SHIFT(134),
  [636] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_float_value, 1),
  [638] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_float_value, 1),
  [640] = {.entry = {.count = 1, .reusable = false}}, SHIFT(139),
  [642] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_integer_value, 2),
  [644] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_integer_value, 2),
  [646] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binary_expression, 3),
  [648] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_binary_expression, 3),
  [650] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_color_value, 2),
  [652] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_color_value, 2),
  [654] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__value, 1, .production_id = 3),
  [656] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__value, 1, .production_id = 3),
  [658] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_arguments, 3),
  [660] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_arguments, 3),
  [662] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_float_value, 2),
  [664] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_float_value, 2),
  [666] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_arguments, 4),
  [668] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_arguments, 4),
  [670] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_arguments, 2),
  [672] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_arguments, 2),
  [674] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_call_expression, 2, .production_id = 8),
  [676] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_call_expression, 2, .production_id = 8),
  [678] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parenthesized_value, 3),
  [680] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parenthesized_value, 3),
  [682] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_declaration_repeat1, 1),
  [684] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_declaration_repeat1, 1),
  [686] = {.entry = {.count = 1, .reusable = true}}, SHIFT(78),
  [688] = {.entry = {.count = 1, .reusable = true}}, SHIFT(343),
  [690] = {.entry = {.count = 1, .reusable = true}}, SHIFT(238),
  [692] = {.entry = {.count = 1, .reusable = false}}, SHIFT(238),
  [694] = {.entry = {.count = 1, .reusable = false}}, SHIFT(349),
  [696] = {.entry = {.count = 1, .reusable = false}}, SHIFT(463),
  [698] = {.entry = {.count = 1, .reusable = false}}, SHIFT(365),
  [700] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_declaration_repeat1, 2),
  [702] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_declaration_repeat1, 2),
  [704] = {.entry = {.count = 1, .reusable = true}}, SHIFT(118),
  [706] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_apply_statement_repeat1, 1),
  [708] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_apply_statement_repeat1, 1),
  [710] = {.entry = {.count = 1, .reusable = true}}, SHIFT(181),
  [712] = {.entry = {.count = 1, .reusable = true}}, SHIFT(112),
  [714] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_last_declaration, 4, .production_id = 18),
  [716] = {.entry = {.count = 1, .reusable = true}}, SHIFT(442),
  [718] = {.entry = {.count = 1, .reusable = true}}, SHIFT(305),
  [720] = {.entry = {.count = 1, .reusable = true}}, SHIFT(287),
  [722] = {.entry = {.count = 1, .reusable = true}}, SHIFT(288),
  [724] = {.entry = {.count = 1, .reusable = true}}, SHIFT(281),
  [726] = {.entry = {.count = 1, .reusable = true}}, SHIFT(200),
  [728] = {.entry = {.count = 1, .reusable = true}}, SHIFT(199),
  [730] = {.entry = {.count = 1, .reusable = true}}, SHIFT(138),
  [732] = {.entry = {.count = 1, .reusable = true}}, SHIFT(346),
  [734] = {.entry = {.count = 1, .reusable = true}}, SHIFT(277),
  [736] = {.entry = {.count = 1, .reusable = true}}, SHIFT(208),
  [738] = {.entry = {.count = 1, .reusable = true}}, SHIFT(301),
  [740] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_declaration_repeat1, 2), SHIFT_REPEAT(223),
  [743] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_declaration_repeat1, 2), SHIFT_REPEAT(218),
  [746] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_declaration_repeat1, 2), SHIFT_REPEAT(453),
  [749] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_declaration_repeat1, 2), SHIFT_REPEAT(141),
  [752] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_declaration_repeat1, 2), SHIFT_REPEAT(132),
  [755] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_declaration_repeat1, 2), SHIFT_REPEAT(133),
  [758] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_declaration_repeat1, 2), SHIFT_REPEAT(131),
  [761] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_declaration_repeat1, 2), SHIFT_REPEAT(137),
  [764] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_declaration_repeat1, 2), SHIFT_REPEAT(141),
  [767] = {.entry = {.count = 1, .reusable = true}}, SHIFT(280),
  [769] = {.entry = {.count = 1, .reusable = true}}, SHIFT(65),
  [771] = {.entry = {.count = 1, .reusable = true}}, SHIFT(498),
  [773] = {.entry = {.count = 1, .reusable = true}}, SHIFT(28),
  [775] = {.entry = {.count = 1, .reusable = true}}, SHIFT(266),
  [777] = {.entry = {.count = 1, .reusable = true}}, SHIFT(46),
  [779] = {.entry = {.count = 1, .reusable = true}}, SHIFT(452),
  [781] = {.entry = {.count = 1, .reusable = true}}, SHIFT(114),
  [783] = {.entry = {.count = 1, .reusable = true}}, SHIFT(451),
  [785] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_apply_statement_repeat1, 2),
  [787] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_apply_statement_repeat1, 2), SHIFT_REPEAT(218),
  [790] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_apply_statement_repeat1, 2), SHIFT_REPEAT(453),
  [793] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_apply_statement_repeat1, 2), SHIFT_REPEAT(141),
  [796] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_apply_statement_repeat1, 2), SHIFT_REPEAT(132),
  [799] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_apply_statement_repeat1, 2), SHIFT_REPEAT(133),
  [802] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_apply_statement_repeat1, 2), SHIFT_REPEAT(131),
  [805] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_apply_statement_repeat1, 2), SHIFT_REPEAT(137),
  [808] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_apply_statement_repeat1, 2), SHIFT_REPEAT(141),
  [811] = {.entry = {.count = 1, .reusable = true}}, SHIFT(450),
  [813] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_arguments_repeat1, 2),
  [815] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_pseudo_class_arguments_repeat1, 2),
  [817] = {.entry = {.count = 1, .reusable = true}}, SHIFT(176),
  [819] = {.entry = {.count = 1, .reusable = true}}, SHIFT(62),
  [821] = {.entry = {.count = 1, .reusable = true}}, SHIFT(59),
  [823] = {.entry = {.count = 1, .reusable = true}}, SHIFT(186),
  [825] = {.entry = {.count = 1, .reusable = true}}, SHIFT(308),
  [827] = {.entry = {.count = 1, .reusable = true}}, SHIFT(366),
  [829] = {.entry = {.count = 1, .reusable = false}}, SHIFT(191),
  [831] = {.entry = {.count = 1, .reusable = true}}, SHIFT(196),
  [833] = {.entry = {.count = 1, .reusable = true}}, SHIFT(142),
  [835] = {.entry = {.count = 1, .reusable = false}}, SHIFT(179),
  [837] = {.entry = {.count = 1, .reusable = true}}, SHIFT(203),
  [839] = {.entry = {.count = 1, .reusable = true}}, SHIFT(216),
  [841] = {.entry = {.count = 1, .reusable = false}}, SHIFT(460),
  [843] = {.entry = {.count = 1, .reusable = true}}, SHIFT(300),
  [845] = {.entry = {.count = 1, .reusable = false}}, SHIFT(285),
  [847] = {.entry = {.count = 1, .reusable = false}}, SHIFT(270),
  [849] = {.entry = {.count = 1, .reusable = false}}, SHIFT(263),
  [851] = {.entry = {.count = 1, .reusable = false}}, SHIFT(289),
  [853] = {.entry = {.count = 1, .reusable = false}}, SHIFT(300),
  [855] = {.entry = {.count = 1, .reusable = true}}, SHIFT(202),
  [857] = {.entry = {.count = 1, .reusable = false}}, SHIFT(488),
  [859] = {.entry = {.count = 1, .reusable = true}}, SHIFT(185),
  [861] = {.entry = {.count = 1, .reusable = false}}, SHIFT(171),
  [863] = {.entry = {.count = 1, .reusable = false}}, SHIFT(314),
  [865] = {.entry = {.count = 1, .reusable = false}}, SHIFT(299),
  [867] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pseudo_class_selector, 3, .production_id = 13),
  [869] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pseudo_class_selector, 3, .production_id = 13),
  [871] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [873] = {.entry = {.count = 1, .reusable = true}}, SHIFT(257),
  [875] = {.entry = {.count = 1, .reusable = false}}, SHIFT(469),
  [877] = {.entry = {.count = 1, .reusable = true}}, SHIFT(192),
  [879] = {.entry = {.count = 1, .reusable = false}}, SHIFT(183),
  [881] = {.entry = {.count = 1, .reusable = false}}, SHIFT(180),
  [883] = {.entry = {.count = 1, .reusable = false}}, SHIFT(173),
  [885] = {.entry = {.count = 1, .reusable = false}}, SHIFT(204),
  [887] = {.entry = {.count = 1, .reusable = false}}, SHIFT(192),
  [889] = {.entry = {.count = 1, .reusable = false}}, SHIFT(297),
  [891] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pseudo_class_selector, 2, .production_id = 5),
  [893] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pseudo_class_selector, 2, .production_id = 5),
  [895] = {.entry = {.count = 1, .reusable = true}}, SHIFT(265),
  [897] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_class_selector, 3, .production_id = 13),
  [899] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_class_selector, 3, .production_id = 13),
  [901] = {.entry = {.count = 1, .reusable = true}}, SHIFT(106),
  [903] = {.entry = {.count = 1, .reusable = true}}, SHIFT(11),
  [905] = {.entry = {.count = 1, .reusable = true}}, SHIFT(177),
  [907] = {.entry = {.count = 1, .reusable = true}}, SHIFT(68),
  [909] = {.entry = {.count = 1, .reusable = true}}, SHIFT(5),
  [911] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_class_selector, 2, .production_id = 5),
  [913] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_class_selector, 2, .production_id = 5),
  [915] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pseudo_class_arguments, 3),
  [917] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pseudo_class_arguments, 3),
  [919] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attribute_selector, 3, .production_id = 12),
  [921] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_attribute_selector, 3, .production_id = 12),
  [923] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_universal_selector, 1),
  [925] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_universal_selector, 1),
  [927] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pseudo_class_arguments, 4),
  [929] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pseudo_class_arguments, 4),
  [931] = {.entry = {.count = 1, .reusable = true}}, SHIFT(316),
  [933] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attribute_selector, 6, .production_id = 19),
  [935] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_attribute_selector, 6, .production_id = 19),
  [937] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pseudo_element_selector, 2, .production_id = 6),
  [939] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pseudo_element_selector, 2, .production_id = 6),
  [941] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_id_selector, 2, .production_id = 7),
  [943] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_id_selector, 2, .production_id = 7),
  [945] = {.entry = {.count = 1, .reusable = true}}, SHIFT(152),
  [947] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_selectors, 1),
  [949] = {.entry = {.count = 1, .reusable = false}}, SHIFT(444),
  [951] = {.entry = {.count = 1, .reusable = true}}, SHIFT(500),
  [953] = {.entry = {.count = 1, .reusable = true}}, SHIFT(502),
  [955] = {.entry = {.count = 1, .reusable = true}}, SHIFT(505),
  [957] = {.entry = {.count = 1, .reusable = true}}, SHIFT(456),
  [959] = {.entry = {.count = 1, .reusable = true}}, SHIFT(162),
  [961] = {.entry = {.count = 1, .reusable = true}}, SHIFT(158),
  [963] = {.entry = {.count = 1, .reusable = true}}, SHIFT(153),
  [965] = {.entry = {.count = 1, .reusable = true}}, SHIFT(154),
  [967] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attribute_selector, 5, .production_id = 12),
  [969] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_attribute_selector, 5, .production_id = 12),
  [971] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pseudo_class_selector, 3, .production_id = 5),
  [973] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pseudo_class_selector, 3, .production_id = 5),
  [975] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sibling_selector, 3),
  [977] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sibling_selector, 3),
  [979] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attribute_selector, 4, .production_id = 19),
  [981] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_attribute_selector, 4, .production_id = 19),
  [983] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pseudo_class_selector, 4, .production_id = 13),
  [985] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pseudo_class_selector, 4, .production_id = 13),
  [987] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_child_selector, 3),
  [989] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_child_selector, 3),
  [991] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_descendant_selector, 3),
  [993] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_descendant_selector, 3),
  [995] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_id_selector, 3, .production_id = 15),
  [997] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_id_selector, 3, .production_id = 15),
  [999] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pseudo_element_selector, 3, .production_id = 14),
  [1001] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pseudo_element_selector, 3, .production_id = 14),
  [1003] = {.entry = {.count = 1, .reusable = true}}, SHIFT(292),
  [1005] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pseudo_class_arguments, 2),
  [1007] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_pseudo_class_arguments, 2),
  [1009] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_adjacent_sibling_selector, 3),
  [1011] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_adjacent_sibling_selector, 3),
  [1013] = {.entry = {.count = 1, .reusable = true}}, SHIFT(248),
  [1015] = {.entry = {.count = 1, .reusable = true}}, SHIFT(213),
  [1017] = {.entry = {.count = 1, .reusable = false}}, SHIFT(213),
  [1019] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym__selector, 1, .production_id = 1), SHIFT(236),
  [1022] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym__selector, 1, .production_id = 1), SHIFT(241),
  [1025] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter, 3, .production_id = 23),
  [1027] = {.entry = {.count = 1, .reusable = false}}, SHIFT(202),
  [1029] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_include_argument, 3, .production_id = 24),
  [1031] = {.entry = {.count = 1, .reusable = true}}, SHIFT(243),
  [1033] = {.entry = {.count = 1, .reusable = false}}, SHIFT(243),
  [1035] = {.entry = {.count = 1, .reusable = false}}, SHIFT(222),
  [1037] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_selectors_repeat1, 2),
  [1039] = {.entry = {.count = 1, .reusable = true}}, SHIFT(10),
  [1041] = {.entry = {.count = 1, .reusable = false}}, SHIFT(203),
  [1043] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_include_argument, 1, .production_id = 17),
  [1045] = {.entry = {.count = 1, .reusable = true}}, SHIFT(12),
  [1047] = {.entry = {.count = 1, .reusable = true}}, SHIFT(115),
  [1049] = {.entry = {.count = 1, .reusable = true}}, SHIFT(144),
  [1051] = {.entry = {.count = 1, .reusable = true}}, SHIFT(121),
  [1053] = {.entry = {.count = 1, .reusable = true}}, SHIFT(219),
  [1055] = {.entry = {.count = 1, .reusable = true}}, SHIFT(212),
  [1057] = {.entry = {.count = 1, .reusable = false}}, SHIFT(212),
  [1059] = {.entry = {.count = 1, .reusable = true}}, SHIFT(275),
  [1061] = {.entry = {.count = 1, .reusable = true}}, SHIFT(252),
  [1063] = {.entry = {.count = 1, .reusable = true}}, SHIFT(81),
  [1065] = {.entry = {.count = 1, .reusable = true}}, SHIFT(82),
  [1067] = {.entry = {.count = 1, .reusable = true}}, SHIFT(85),
  [1069] = {.entry = {.count = 1, .reusable = true}}, SHIFT(198),
  [1071] = {.entry = {.count = 1, .reusable = true}}, SHIFT(52),
  [1073] = {.entry = {.count = 1, .reusable = true}}, SHIFT(51),
  [1075] = {.entry = {.count = 1, .reusable = false}}, SHIFT(381),
  [1077] = {.entry = {.count = 1, .reusable = true}}, SHIFT(50),
  [1079] = {.entry = {.count = 1, .reusable = true}}, SHIFT(60),
  [1081] = {.entry = {.count = 1, .reusable = true}}, SHIFT(367),
  [1083] = {.entry = {.count = 1, .reusable = true}}, SHIFT(187),
  [1085] = {.entry = {.count = 1, .reusable = true}}, SHIFT(61),
  [1087] = {.entry = {.count = 1, .reusable = true}}, SHIFT(313),
  [1089] = {.entry = {.count = 1, .reusable = true}}, SHIFT(271),
  [1091] = {.entry = {.count = 1, .reusable = true}}, SHIFT(111),
  [1093] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [1095] = {.entry = {.count = 1, .reusable = true}}, SHIFT(110),
  [1097] = {.entry = {.count = 1, .reusable = true}}, SHIFT(462),
  [1099] = {.entry = {.count = 1, .reusable = true}}, SHIFT(436),
  [1101] = {.entry = {.count = 1, .reusable = true}}, SHIFT(432),
  [1103] = {.entry = {.count = 1, .reusable = true}}, SHIFT(97),
  [1105] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_keyframe_block_list_repeat1, 2),
  [1107] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_keyframe_block_list_repeat1, 2), SHIFT_REPEAT(462),
  [1110] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_keyframe_block_list_repeat1, 2), SHIFT_REPEAT(436),
  [1113] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_keyframe_block_list_repeat1, 2), SHIFT_REPEAT(432),
  [1116] = {.entry = {.count = 1, .reusable = true}}, SHIFT(39),
  [1118] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
  [1120] = {.entry = {.count = 1, .reusable = true}}, SHIFT(211),
  [1122] = {.entry = {.count = 1, .reusable = true}}, SHIFT(267),
  [1124] = {.entry = {.count = 1, .reusable = true}}, SHIFT(230),
  [1126] = {.entry = {.count = 1, .reusable = true}}, SHIFT(278),
  [1128] = {.entry = {.count = 1, .reusable = true}}, SHIFT(341),
  [1130] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [1132] = {.entry = {.count = 1, .reusable = true}}, SHIFT(327),
  [1134] = {.entry = {.count = 1, .reusable = true}}, SHIFT(83),
  [1136] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binary_query, 3),
  [1138] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__query, 1, .production_id = 4),
  [1140] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_feature_query, 5, .production_id = 22),
  [1142] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_selector_query, 4),
  [1144] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unary_query, 2),
  [1146] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parenthesized_query, 3),
  [1148] = {.entry = {.count = 1, .reusable = true}}, SHIFT(56),
  [1150] = {.entry = {.count = 1, .reusable = true}}, SHIFT(210),
  [1152] = {.entry = {.count = 1, .reusable = true}}, SHIFT(465),
  [1154] = {.entry = {.count = 1, .reusable = true}}, SHIFT(434),
  [1156] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [1158] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_import_statement_repeat1, 2),
  [1160] = {.entry = {.count = 1, .reusable = true}}, SHIFT(459),
  [1162] = {.entry = {.count = 1, .reusable = true}}, SHIFT(92),
  [1164] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [1166] = {.entry = {.count = 1, .reusable = true}}, SHIFT(107),
  [1168] = {.entry = {.count = 1, .reusable = true}}, SHIFT(90),
  [1170] = {.entry = {.count = 1, .reusable = true}}, SHIFT(195),
  [1172] = {.entry = {.count = 1, .reusable = true}}, SHIFT(140),
  [1174] = {.entry = {.count = 1, .reusable = true}}, SHIFT(441),
  [1176] = {.entry = {.count = 1, .reusable = true}}, SHIFT(295),
  [1178] = {.entry = {.count = 1, .reusable = true}}, SHIFT(188),
  [1180] = {.entry = {.count = 1, .reusable = true}}, SHIFT(184),
  [1182] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_arguments_repeat1, 2), SHIFT_REPEAT(200),
  [1185] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_keyframe_block, 2),
  [1187] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_import_statement_repeat1, 2), SHIFT_REPEAT(341),
  [1190] = {.entry = {.count = 1, .reusable = true}}, SHIFT(109),
  [1192] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_selectors_repeat1, 2), SHIFT_REPEAT(152),
  [1195] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_selectors, 2),
  [1197] = {.entry = {.count = 1, .reusable = true}}, SHIFT(454),
  [1199] = {.entry = {.count = 1, .reusable = true}}, SHIFT(376),
  [1201] = {.entry = {.count = 1, .reusable = true}}, SHIFT(206),
  [1203] = {.entry = {.count = 1, .reusable = true}}, SHIFT(426),
  [1205] = {.entry = {.count = 1, .reusable = true}}, SHIFT(435),
  [1207] = {.entry = {.count = 1, .reusable = true}}, SHIFT(474),
  [1209] = {.entry = {.count = 1, .reusable = true}}, SHIFT(269),
  [1211] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [1213] = {.entry = {.count = 1, .reusable = true}}, SHIFT(227),
  [1215] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_include_arguments_repeat1, 2), SHIFT_REPEAT(206),
  [1218] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_include_arguments_repeat1, 2),
  [1220] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter, 1),
  [1222] = {.entry = {.count = 1, .reusable = true}}, SHIFT(244),
  [1224] = {.entry = {.count = 1, .reusable = true}}, SHIFT(58),
  [1226] = {.entry = {.count = 1, .reusable = true}}, SHIFT(101),
  [1228] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_pseudo_class_arguments_repeat1, 2), SHIFT_REPEAT(28),
  [1231] = {.entry = {.count = 1, .reusable = true}}, SHIFT(225),
  [1233] = {.entry = {.count = 1, .reusable = true}}, SHIFT(446),
  [1235] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_parameters_repeat1, 2), SHIFT_REPEAT(435),
  [1238] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_parameters_repeat1, 2),
  [1240] = {.entry = {.count = 1, .reusable = true}}, SHIFT(370),
  [1242] = {.entry = {.count = 1, .reusable = true}}, SHIFT(433),
  [1244] = {.entry = {.count = 1, .reusable = true}}, SHIFT(481),
  [1246] = {.entry = {.count = 1, .reusable = true}}, SHIFT(373),
  [1248] = {.entry = {.count = 1, .reusable = true}}, SHIFT(356),
  [1250] = {.entry = {.count = 1, .reusable = true}}, SHIFT(457),
  [1252] = {.entry = {.count = 1, .reusable = true}}, SHIFT(226),
  [1254] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_include_arguments, 4),
  [1256] = {.entry = {.count = 1, .reusable = false}}, SHIFT(136),
  [1258] = {.entry = {.count = 1, .reusable = false}}, SHIFT(273),
  [1260] = {.entry = {.count = 1, .reusable = true}}, SHIFT(179),
  [1262] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_include_arguments, 3),
  [1264] = {.entry = {.count = 1, .reusable = true}}, SHIFT(410),
  [1266] = {.entry = {.count = 1, .reusable = true}}, SHIFT(7),
  [1268] = {.entry = {.count = 1, .reusable = false}}, SHIFT(190),
  [1270] = {.entry = {.count = 1, .reusable = true}}, SHIFT(504),
  [1272] = {.entry = {.count = 1, .reusable = true}}, SHIFT(229),
  [1274] = {.entry = {.count = 1, .reusable = true}}, SHIFT(104),
  [1276] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_last_declaration, 5, .production_id = 18),
  [1278] = {.entry = {.count = 1, .reusable = true}}, SHIFT(358),
  [1280] = {.entry = {.count = 1, .reusable = true}}, SHIFT(217),
  [1282] = {.entry = {.count = 1, .reusable = true}}, SHIFT(240),
  [1284] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameters, 3),
  [1286] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [1288] = {.entry = {.count = 1, .reusable = true}}, SHIFT(116),
  [1290] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [1292] = {.entry = {.count = 1, .reusable = true}}, SHIFT(136),
  [1294] = {.entry = {.count = 1, .reusable = true}}, SHIFT(77),
  [1296] = {.entry = {.count = 1, .reusable = true}}, SHIFT(361),
  [1298] = {.entry = {.count = 1, .reusable = true}}, SHIFT(478),
  [1300] = {.entry = {.count = 1, .reusable = true}}, SHIFT(94),
  [1302] = {.entry = {.count = 1, .reusable = true}}, SHIFT(40),
  [1304] = {.entry = {.count = 1, .reusable = true}}, SHIFT(290),
  [1306] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_from, 1),
  [1308] = {.entry = {.count = 1, .reusable = true}}, SHIFT(157),
  [1310] = {.entry = {.count = 1, .reusable = true}}, SHIFT(95),
  [1312] = {.entry = {.count = 1, .reusable = true}}, SHIFT(396),
  [1314] = {.entry = {.count = 1, .reusable = true}}, SHIFT(41),
  [1316] = {.entry = {.count = 1, .reusable = true}}, SHIFT(205),
  [1318] = {.entry = {.count = 1, .reusable = true}}, SHIFT(71),
  [1320] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [1322] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameters, 4),
  [1324] = {.entry = {.count = 1, .reusable = true}}, SHIFT(421),
  [1326] = {.entry = {.count = 1, .reusable = true}}, SHIFT(250),
  [1328] = {.entry = {.count = 1, .reusable = true}}, SHIFT(384),
  [1330] = {.entry = {.count = 1, .reusable = true}}, SHIFT(380),
  [1332] = {.entry = {.count = 1, .reusable = true}}, SHIFT(86),
  [1334] = {.entry = {.count = 1, .reusable = true}}, SHIFT(360),
  [1336] = {.entry = {.count = 1, .reusable = true}}, SHIFT(389),
  [1338] = {.entry = {.count = 1, .reusable = true}}, SHIFT(273),
  [1340] = {.entry = {.count = 1, .reusable = true}}, SHIFT(272),
  [1342] = {.entry = {.count = 1, .reusable = true}}, SHIFT(399),
  [1344] = {.entry = {.count = 1, .reusable = true}}, SHIFT(190),
  [1346] = {.entry = {.count = 1, .reusable = true}}, SHIFT(496),
  [1348] = {.entry = {.count = 1, .reusable = true}}, SHIFT(424),
  [1350] = {.entry = {.count = 1, .reusable = true}}, SHIFT(425),
  [1352] = {.entry = {.count = 1, .reusable = true}}, SHIFT(372),
  [1354] = {.entry = {.count = 1, .reusable = true}}, SHIFT(386),
  [1356] = {.entry = {.count = 1, .reusable = true}}, SHIFT(256),
  [1358] = {.entry = {.count = 1, .reusable = true}}, SHIFT(234),
  [1360] = {.entry = {.count = 1, .reusable = true}}, SHIFT(443),
  [1362] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
  [1364] = {.entry = {.count = 1, .reusable = true}}, SHIFT(231),
  [1366] = {.entry = {.count = 1, .reusable = true}}, SHIFT(261),
  [1368] = {.entry = {.count = 1, .reusable = true}}, SHIFT(224),
  [1370] = {.entry = {.count = 1, .reusable = true}}, SHIFT(284),
  [1372] = {.entry = {.count = 1, .reusable = true}}, SHIFT(439),
  [1374] = {.entry = {.count = 1, .reusable = true}}, SHIFT(501),
  [1376] = {.entry = {.count = 1, .reusable = true}}, SHIFT(282),
  [1378] = {.entry = {.count = 1, .reusable = true}}, SHIFT(214),
  [1380] = {.entry = {.count = 1, .reusable = true}}, SHIFT(506),
};

#ifdef __cplusplus
extern "C" {
#endif
void *tree_sitter_scss_external_scanner_create(void);
void tree_sitter_scss_external_scanner_destroy(void *);
bool tree_sitter_scss_external_scanner_scan(void *, TSLexer *, const bool *);
unsigned tree_sitter_scss_external_scanner_serialize(void *, char *);
void tree_sitter_scss_external_scanner_deserialize(void *, const char *, unsigned);

#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_scss(void) {
  static TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = (const uint16_t *)ts_parse_table,
    .small_parse_table = (const uint16_t *)ts_small_parse_table,
    .small_parse_table_map = (const uint32_t *)ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = (const TSSymbol *)ts_alias_sequences,
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .external_scanner = {
      (const bool *)ts_external_scanner_states,
      ts_external_scanner_symbol_map,
      tree_sitter_scss_external_scanner_create,
      tree_sitter_scss_external_scanner_destroy,
      tree_sitter_scss_external_scanner_scan,
      tree_sitter_scss_external_scanner_serialize,
      tree_sitter_scss_external_scanner_deserialize,
    },
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
