#include "solver.h"
#include "curve_editor.h"

void tomin::operator() (solver& s, float& x, float& dx) {
	float xd = x - s.lastx;
	float d = xd / s.deltax;
	int i = d;
  x = s.firstx + d - i;
	s.findseg (x);
}

void tomax::operator() (solver& s, float& x, float& dx) {
	float xd = s.firstx - x;
	float d = xd / s.deltax;
	int i = d;
  x = s.lastx - d + i;
	s.findseg (x);
}

void atmin::operator() (solver& s, float& x, float& dx) {
  x = s.firstx;
  s.setseg (0, 0);
}

void atmax::operator () (solver& s, float& x, float& dx) {
  x = s.lastx;
  s.setseg (s.last_curv, s.lastseg (s.last_curv));
}


void loopmin::operator() (solver& s, float& x, float& dx) {
  tomax::operator() (s, x, dx);
  //atmin::operator() (s, x, dx);
  //if (dx < 0) dx = -dx;
}

void loopmax::operator() (solver& s, float& x, float& dx) {
  tomin::operator() (s, x, dx);
  //if (dx < 0) dx = -dx;
}

void pongmax::operator () (solver& s, float& x, float& dx) {
	atmax::operator() (s, x, dx);
  if (dx > 0) dx = -dx;
}

void pongmin::operator () (solver& s, float& x, float& dx) {
	atmin::operator() (s, x, dx);
  if (dx < 0) dx = -dx;
}

gotog::gotog (float gg, curve_editor* e) : ed (e) {
	set (gg);
}

void gotog::set (float gg) {
	g = gg;
	ed->update_sustain (g);
}

void gotog::operator () (solver& s, float& x, float& dx) {
  x = g;
  if (!s.findseg (x)) {
    x = s.lastx;
		set (x);
  }
}
