#ifndef COMPRESSION_H
#define COMPRESSION_H  1


/* ========================================================================== */
/* Include files */

#include "config.h"


#if !CFG_CMPR_DISABLE


/*! \addtogroup COMPRESSION */
/*! @{ */


/* ========================================================================== */
/* Constants */

/*! \name Compression algorithms */
/*! @{ */
#  define CMPR_ALG_DEFLATE  0x0001U /*!< \brief DEFLATE according to RFC 1951 */
/*! @} */


/*! @} */


/* ========================================================================== */
/* Function prototypes */

struct cmpr_stream*  cmpr_stream_constructor(unsigned int, int,
                             ssize_t  (*tx_send)(int, const void*, size_t, int),
                             ssize_t  (*rx_recv)(int, void*, size_t, int) );
void  cmpr_stream_destructor(void*);
api_posix_ssize_t  cmpr_send(void*, const void*, size_t);
int  cmpr_flush(void*);
int  cmpr_terminate(void*);
api_posix_ssize_t  cmpr_recv(void*, void*, size_t, int);
int  cmpr_init(void);
void  cmpr_exit(void);


#endif  /* !CFG_CMPR_DISABLE */


#endif  /* COMPRESSION_H */

/* EOF */
