/*
 * Base 64 URL encoding and decoding functions
 *
 * SPDX-FileType: SOURCE
 * SPDX-FileCopyrightText: Michael Bäuerle
 * SPDX-License-Identifier: BSD-2-Clause
 */

#include "libbasexx-0/base64_url.h"


/* ========================================================================== */
void bxx0_base64_url_to(unsigned char *buf, const size_t len)
{
    size_t i = 0;

    for (; len > i; ++i)
    {
        if (0x2BU == buf[i])
            buf[i] = 0x2D;
        else if (0x2FU == buf[i])
            buf[i] = 0x5F;
    }
}


/* ========================================================================== */
void bxx0_base64_url_from(unsigned char *buf, const size_t len)
{
    size_t i = 0;

    for (; len > i; ++i)
    {
        if (0x2DU == buf[i])
            buf[i] = 0x2B;
        else if (0x5FU == buf[i])
            buf[i] = 0x2F;
    }
}
