/*
 * SPDX-FileType: SOURCE
 * SPDX-FileCopyrightText: Michael Bäuerle
 * SPDX-License-Identifier: BSD-2-Clause
 */

#ifndef JPIC0_I_ICONV_TABLE_H
#define JPIC0_I_ICONV_TABLE_H  1


/*
 * Header file for mapping tables
 *
 * This file is used by the library and will not be installed.
 */


#include "libjpiconv-0/iconv_table_ni.h"


#pragma GCC visibility push(internal)


/*! \cond DO_NOT_DOCUMENT */


/* Mapping table entry definition */
struct jpic0_i_iso2022_jp
{
   long int  jis;  /* JIS X 0208 codepoint */
   long int  uc;   /* Unicode codepoint */
};


/* Data type for mapping table entry */
typedef struct jpic0_i_iso2022_jp  jpic0_i_iso2022_jp;


/* JIS X 0208 to Unicode mapping table */
extern const jpic0_i_iso2022_jp jpic0_i_iso2022_jp_table[];


/*! \endcond */


#pragma GCC visibility pop


#endif  /* JPIC0_I_ICONV_TABLE_H */
