/*
 * SPDX-FileType: SOURCE
 * SPDX-FileCopyrightText: Michael Bäuerle
 * SPDX-License-Identifier: BSD-2-Clause
 */

#ifndef JPIC0_I_ICONV_UTF8_H
#define JPIC0_I_ICONV_UTF8_H  1


/*
 * Header file for Unicode UTF-8 encoder
 *
 * This file is used by the library and will not be installed.
 */

#include "libjpiconv-0/iconv_bool.h"


#pragma GCC visibility push(internal)


/*! \cond DO_NOT_DOCUMENT */


/* Minium size of buffer the caller must provide */
#define JPIC0_I_UTF8_BUFLEN  5U


/* Encode Unicode codepoint to UTF-8 */
jpic0_i_bool jpic0_i_encode_utf8(char *utf8_buf, long int ucp);


/*! \endcond */


#pragma GCC visibility pop


#endif  /* JPIC0_I_ICONV_UTF8_H */
