/*
 * Definition of pairs with encoding name and mapping table for libssiconv
 *
 * SPDX-FileType: SOURCE
 * SPDX-FileCopyrightText: Michael Bäuerle
 * SPDX-License-Identifier: BSD-2-Clause
 */

#include <stddef.h>

#include "libssiconv-0/iconv_name.h"
#include "libssiconv-0/iconv_table.h"


/* ========================================================================== */
/* IANA names supported as target encoding */
const ssic0_i_name_def ssic0_i_name_tgt[] =
{
    { "UTF-8",      ssic0_i_table_utf_8 },
    { "ISO-8859-1", ssic0_i_table_iso8859_1 },
    { "US-ASCII",   ssic0_i_table_us_ascii },

    { NULL, NULL }
};


/* ========================================================================== */
/* IANA names supported as source encoding only */
const ssic0_i_name_def ssic0_i_name_src[] =
{
    { "US-ASCII",     ssic0_i_table_us_ascii },
    { "ISO-8859-1",   ssic0_i_table_iso8859_1 },
    { "ISO-8859-2",   ssic0_i_table_iso8859_2 },
    { "ISO-8859-3",   ssic0_i_table_iso8859_3 },
    { "ISO-8859-4",   ssic0_i_table_iso8859_4 },
    { "ISO-8859-5",   ssic0_i_table_iso8859_5 },
    { "ISO-8859-6",   ssic0_i_table_iso8859_6 },
    { "ISO-8859-7",   ssic0_i_table_iso8859_7 },
    { "ISO-8859-8",   ssic0_i_table_iso8859_8 },
    { "ISO-8859-9",   ssic0_i_table_iso8859_9 },
    { "ISO-8859-10",  ssic0_i_table_iso8859_10 },
    { "TIS-620",      ssic0_i_table_iso8859_11 },
    /* Note: The proposed draft for ISO 8859-12 was released as ISO 8859-14 */
    { "ISO-8859-13",  ssic0_i_table_iso8859_13 },
    { "ISO-8859-14",  ssic0_i_table_iso8859_14 },
    { "ISO-8859-15",  ssic0_i_table_iso8859_15 },
    { "ISO-8859-16",  ssic0_i_table_iso8859_16 },
    { "MACINTOSH",    ssic0_i_table_mac_roman },
    { "WINDOWS-1250", ssic0_i_table_windows_1250 },
    { "WINDOWS-1251", ssic0_i_table_windows_1251 },
    { "WINDOWS-1252", ssic0_i_table_windows_1252 },
    { "WINDOWS-1253", ssic0_i_table_windows_1253 },
    { "WINDOWS-1254", ssic0_i_table_windows_1254 },
    { "WINDOWS-1255", ssic0_i_table_windows_1255 },
    { "WINDOWS-1256", ssic0_i_table_windows_1256 },
    { "WINDOWS-1257", ssic0_i_table_windows_1257 },
    { "WINDOWS-1258", ssic0_i_table_windows_1258 },
    { "KOI8-R",       ssic0_i_table_koi8r },
    { "KOI8-U",       ssic0_i_table_koi8u },
    { "IBM437",       ssic0_i_table_ibm437 },
    { "IBM775",       ssic0_i_table_ibm775 },
    { "IBM850",       ssic0_i_table_ibm850 },
    { "IBM852",       ssic0_i_table_ibm852 },
    { "IBM00858",     ssic0_i_table_ibm858 },

    { NULL, NULL }
};


#if SSIC0_I_NAME_ENABLE_ALIASES
/* ========================================================================== */
/* IANA aliases supported as source encoding only */
const ssic0_i_name_def ssic0_i_name_src_alias[] =
{
    /* US-ASCII */
    { "ANSI_X3.4-1968",   ssic0_i_table_us_ascii },
    { "ANSI_X3.4-1986",   ssic0_i_table_us_ascii },
    { "ISO-IR-6",         ssic0_i_table_us_ascii },
    { "ISO_646.IRV:1991", ssic0_i_table_us_ascii },
    { "ISO646-US",        ssic0_i_table_us_ascii },
    { "IBM367",           ssic0_i_table_us_ascii },
    { "CP367",            ssic0_i_table_us_ascii },
    { "CSASCII",          ssic0_i_table_us_ascii },
    { "US",               ssic0_i_table_us_ascii },

    /* ISO 8859-1 */
    { "ISO_8859-1:1987", ssic0_i_table_iso8859_1 },
    { "ISO_8859-1",      ssic0_i_table_iso8859_1 },
    { "ISO-IR-100",      ssic0_i_table_iso8859_1 },
    { "IBM819",          ssic0_i_table_iso8859_1 },
    { "CP819",           ssic0_i_table_iso8859_1 },
    { "CSISOLATIN1",     ssic0_i_table_iso8859_1 },
    { "LATIN1",          ssic0_i_table_iso8859_1 },
    { "L1",              ssic0_i_table_iso8859_1 },

    /* ISO 8859-2 */
    { "ISO_8859-2:1987", ssic0_i_table_iso8859_2 },
    { "ISO_8859-2",      ssic0_i_table_iso8859_2 },
    { "ISO-IR-101",      ssic0_i_table_iso8859_2 },
    { "CSISOLATIN2",     ssic0_i_table_iso8859_2 },
    { "LATIN2",          ssic0_i_table_iso8859_2 },
    { "L2",              ssic0_i_table_iso8859_2 },

    /* ISO 8859-3 */
    { "ISO_8859-3:1988", ssic0_i_table_iso8859_3 },
    { "ISO_8859-3",      ssic0_i_table_iso8859_3 },
    { "ISO-IR-109",      ssic0_i_table_iso8859_3 },
    { "CSISOLATIN3",     ssic0_i_table_iso8859_3 },
    { "LATIN3",          ssic0_i_table_iso8859_3 },
    { "L3",              ssic0_i_table_iso8859_3 },

    /* ISO 8859-4 */
    { "ISO_8859-4:1988", ssic0_i_table_iso8859_4 },
    { "ISO_8859-4",      ssic0_i_table_iso8859_4 },
    { "ISO-IR-110",      ssic0_i_table_iso8859_4 },
    { "CSISOLATIN4",     ssic0_i_table_iso8859_4 },
    { "LATIN4",          ssic0_i_table_iso8859_4 },
    { "L4",              ssic0_i_table_iso8859_4 },

    /* ISO 8859-5 */
    { "ISO_8859-5:1988",    ssic0_i_table_iso8859_5 },
    { "ISO_8859-5",         ssic0_i_table_iso8859_5 },
    { "ISO-IR-144",         ssic0_i_table_iso8859_5 },
    { "CSISOLATINCYRILLIC", ssic0_i_table_iso8859_5 },
    { "CYRILLIC",           ssic0_i_table_iso8859_5 },

    /* ISO 8859-6 */
    { "ISO_8859-6:1987",  ssic0_i_table_iso8859_6 },
    { "ISO_8859-6",       ssic0_i_table_iso8859_6 },
    { "ISO-IR-127",       ssic0_i_table_iso8859_6 },
    { "ECMA-114",         ssic0_i_table_iso8859_6 },
    { "ASMO-708",         ssic0_i_table_iso8859_6 },
    { "CSISOLATINARABIC", ssic0_i_table_iso8859_6 },
    { "ARABIC",           ssic0_i_table_iso8859_6 },

    /* ISO 8859-7 */
    { "ISO_8859-7:1987", ssic0_i_table_iso8859_7 },
    { "ISO_8859-7",      ssic0_i_table_iso8859_7 },
    { "ISO-IR-126",      ssic0_i_table_iso8859_7 },
    { "ECMA-118",        ssic0_i_table_iso8859_7 },
    { "ELOT_928",        ssic0_i_table_iso8859_7 },
    { "CSISOLATINGREEK", ssic0_i_table_iso8859_7 },
    { "GREEK8",          ssic0_i_table_iso8859_7 },
    { "GREEK",           ssic0_i_table_iso8859_7 },

    /* ISO 8859-8 */
    { "ISO_8859-8:1988",  ssic0_i_table_iso8859_8 },
    { "ISO_8859-8",       ssic0_i_table_iso8859_8 },
    { "CSISOLATIN8",      ssic0_i_table_iso8859_8 },
    { "LATIN8",           ssic0_i_table_iso8859_8 },
    { "L8",               ssic0_i_table_iso8859_8 },
    { "ISO-IR-138",       ssic0_i_table_iso8859_8 },
    { "HEBREW",           ssic0_i_table_iso8859_8 },
    { "CSISOLATINHEBREW", ssic0_i_table_iso8859_8 },

    /* ISO 8859-9 */
    { "ISO_8859-9:1989", ssic0_i_table_iso8859_9 },
    { "ISO_8859-9",      ssic0_i_table_iso8859_9 },
    { "ISO-IR-148",      ssic0_i_table_iso8859_9 },
    { "CSISOLATIN5",     ssic0_i_table_iso8859_9 },
    { "LATIN5",          ssic0_i_table_iso8859_9 },
    { "L5",              ssic0_i_table_iso8859_9 },

    /* ISO 8859-10 */
    { "ISO_8859-10:1992", ssic0_i_table_iso8859_10 },
    { "ISO-IR-157",       ssic0_i_table_iso8859_10 },
    { "CSISOLATIN6",      ssic0_i_table_iso8859_10 },
    { "LATIN6",           ssic0_i_table_iso8859_10 },
    { "L6",               ssic0_i_table_iso8859_10 },

    /* ISO 8859-11 */
    { "ISO-8859-11", ssic0_i_table_iso8859_11 },
    { "CSTIS620",    ssic0_i_table_iso8859_11 },

    /* ISO 8859-13 */
    { "CSISO885913", ssic0_i_table_iso8859_13 },

    /* ISO 8859-14 */
    { "ISO_8859-14:1998", ssic0_i_table_iso8859_14 },
    { "ISO_8859-14",      ssic0_i_table_iso8859_14 },
    { "ISO-IR-199",       ssic0_i_table_iso8859_14 },
    { "CSISO885914",      ssic0_i_table_iso8859_14 },
    { "ISO-CELTIC",       ssic0_i_table_iso8859_14 },
    { "LATIN8",           ssic0_i_table_iso8859_14 },
    { "L8",               ssic0_i_table_iso8859_14 },

    /* ISO 8859-15 */
    { "ISO_8859-15", ssic0_i_table_iso8859_15 },
    { "CSISO885915", ssic0_i_table_iso8859_15 },
    { "LATIN9",      ssic0_i_table_iso8859_15 },

    /* ISO 8859-16 */
    { "ISO_8859-16:2001", ssic0_i_table_iso8859_16 },
    { "ISO_8859-16",      ssic0_i_table_iso8859_16 },
    { "ISO-IR-226",       ssic0_i_table_iso8859_16 },
    { "CSISO885916",      ssic0_i_table_iso8859_16 },
    { "LATIN10",          ssic0_i_table_iso8859_16 },
    { "L10",              ssic0_i_table_iso8859_16 },

    /* KOI8-R */
    { "CSKOI8R", ssic0_i_table_koi8r },

    /* KOI8-U */
    { "CSKOI8U", ssic0_i_table_koi8u },

    /* Windows-1250 */
    { "CSWINDOWS1250", ssic0_i_table_windows_1250 },

    /* Windows-1251 */
    { "CSWINDOWS1251", ssic0_i_table_windows_1251 },

    /* Windows-1252 */
    { "CSWINDOWS1252", ssic0_i_table_windows_1252 },

    /* Windows-1253 */
    { "CSWINDOWS1253", ssic0_i_table_windows_1253 },

    /* Windows-1254 */
    { "CSWINDOWS1254", ssic0_i_table_windows_1254 },

    /* Windows-1255 */
    { "CSWINDOWS1255", ssic0_i_table_windows_1255 },

    /* Windows-1256 */
    { "CSWINDOWS1256", ssic0_i_table_windows_1256 },

    /* Windows-1257 */
    { "CSWINDOWS1257", ssic0_i_table_windows_1257 },

    /* Windows-1258 */
    { "CSWINDOWS1258", ssic0_i_table_windows_1258 },

    /* Macintosh Roman */
    { "CSMACINTOSH", ssic0_i_table_mac_roman },
    { "MAC",         ssic0_i_table_mac_roman },

    /* IBM437 */
    { "CSPC8CODEPAGE437", ssic0_i_table_ibm437 },
    { "CP437",            ssic0_i_table_ibm437 },
    { "437",              ssic0_i_table_ibm437 },

    /* IBM775 */
    { "CSPC775BALTIC", ssic0_i_table_ibm775 },
    { "CP775",         ssic0_i_table_ibm775 },

    /* IBM850 */
    { "CSPC850MULTILINGUAL", ssic0_i_table_ibm850 },
    { "CP850",               ssic0_i_table_ibm850 },
    { "850",                 ssic0_i_table_ibm850 },

    /* IBM852 */
    { "CSPCP852", ssic0_i_table_ibm852 },
    { "CP852",    ssic0_i_table_ibm852 },
    { "852",      ssic0_i_table_ibm852 },

    /* IBM00858 */
    { "PC-MULTILINGUAL-850+EURO", ssic0_i_table_ibm858 },
    { "CSIBM00858",               ssic0_i_table_ibm858 },
    { "CCSID00858",               ssic0_i_table_ibm858 },
    { "CP00858",                  ssic0_i_table_ibm858 },

    { NULL, NULL }
};
#endif  /* SSIC0_I_NAME_ENABLE_ALIASES */


#if SSIC0_I_NAME_ENABLE_NONSTANDARD
/* ========================================================================== */
/* Nonstandard aliases supported as source encoding only */
const ssic0_i_name_def ssic0_i_name_src_nonstd[] =
{
    /* US-ASCII */
    { "US_ASCII",   ssic0_i_table_us_ascii },

    /* ISO 8859-1 */
    { "ISO8859-1", ssic0_i_table_iso8859_1 },

    /* ISO 8859-2 */
    { "ISO8859-2", ssic0_i_table_iso8859_2 },

    /* ISO 8859-3 */
    { "ISO8859-3", ssic0_i_table_iso8859_3 },

    /* ISO 8859-4 */
    { "ISO8859-4", ssic0_i_table_iso8859_4 },

    /* ISO 8859-5 */
    { "ISO8859-5", ssic0_i_table_iso8859_5 },

    /* ISO 8859-6 */
    { "ISO8859-6", ssic0_i_table_iso8859_6 },

    /* ISO 8859-7 */
    { "ISO8859-7", ssic0_i_table_iso8859_7 },

    /* ISO 8859-8 */
    { "ISO8859-8", ssic0_i_table_iso8859_8 },

    /* ISO 8859-9 */
    { "ISO8859-9", ssic0_i_table_iso8859_9 },

    /* ISO 8859-10 */
    { "ISO8859-10", ssic0_i_table_iso8859_10 },

    /* ISO 8859-11 */
    { "ISO_8859-11", ssic0_i_table_iso8859_11 },
    { "ISO8859-11",  ssic0_i_table_iso8859_11 },

    /* ISO 8859-13 */
    { "ISO8859-13", ssic0_i_table_iso8859_13 },

    /* ISO 8859-14 */
    { "ISO8859-14", ssic0_i_table_iso8859_14 },

    /* ISO 8859-15 */
    { "ISO8859-15", ssic0_i_table_iso8859_15 },

    /* ISO 8859-16 */
    { "ISO8859-16", ssic0_i_table_iso8859_16 },

    /* Windows-1250 */
    { "CP1250", ssic0_i_table_windows_1250 },

    /* Windows-1251 */
    { "CP1251", ssic0_i_table_windows_1251 },

    /* Windows-1252 */
    { "CP1252", ssic0_i_table_windows_1252 },

    /* Windows-1253 */
    { "CP1253", ssic0_i_table_windows_1253 },

    /* Windows-1254 */
    { "CP1254", ssic0_i_table_windows_1254 },

    /* Windows-1255 */
    { "CP1255", ssic0_i_table_windows_1255 },

    /* Windows-1256 */
    { "CP1256", ssic0_i_table_windows_1256 },

    /* Windows-1257 */
    { "CP1257", ssic0_i_table_windows_1257 },

    /* Windows-1258 */
    { "CP1258", ssic0_i_table_windows_1258 },

    /* Macintosh Roman */
    { "MACROMAN"   , ssic0_i_table_mac_roman },
    { "X-MAC-ROMAN", ssic0_i_table_mac_roman },

    /* IBM437 */
    { "CP-437", ssic0_i_table_ibm437 },

    /* IBM775 */
    { "CP-775", ssic0_i_table_ibm775 },

    /* IBM850 */
    { "CP-850", ssic0_i_table_ibm850 },

    /* IBM852 */
    { "CP-852", ssic0_i_table_ibm852 },

    /* IBM858 */
    { "CP858",  ssic0_i_table_ibm858 },
    { "IBM858", ssic0_i_table_ibm858 },
    { "CP-858", ssic0_i_table_ibm858 },

    { NULL, NULL }
};
#endif  /* SSIC0_I_NAME_ENABLE_NONSTANDARD */
