install(TARGETS ${LIBS} ${EXES}
    EXPORT fsnotifierTargets  # note: preliminary step to exporting the project
    ARCHIVE DESTINATION ${CMAKE_INSTALL_LIBDIR} COMPONENT lib
    RUNTIME DESTINATION ${CMAKE_INSTALL_BINDIR} COMPONENT bin
    LIBRARY DESTINATION ${CMAKE_INSTALL_LIBDIR} COMPONENT lib)
install(FILES ${CMAKE_SOURCE_DIR}/fsnotifier.h
    TYPE INCLUDE COMPONENT include)

set(INCLUDE_INSTALL_DIR ${CMAKE_INSTALL_INCLUDEDIR})
set(LIB_INSTALL_DIR ${CMAKE_INSTALL_LIBDIR})
install(EXPORT fsnotifierTargets DESTINATION ${PROJECT_CMAKEDIR} NAMESPACE fsnotifier:: COMPONENT dev)
# Make using the library internally and externally equivalent
add_library(fsnotifier::fsnotifier_sharedlib ALIAS fsnotifier_sharedlib)
add_library(fsnotifier::fsnotifier_staticlib ALIAS fsnotifier_staticlib)
add_executable(fsnotifier::fsnotifier ALIAS fsnotifier)
add_executable(fsnotifier::fsnotifier-static ALIAS fsnotifier-static)
include(CMakePackageConfigHelpers)
write_basic_package_version_file(${PROJECT_BINARY_DIR}/${PROJECT_CMAKEDIR}/${PROJECT_NAME}ConfigVersion.cmake
    VERSION ${VERSION} COMPATIBILITY AnyNewerVersion)
configure_package_config_file(${PROJECT_SOURCE_DIR}/cmake/${PROJECT_NAME}Config.cmake.in
    ${PROJECT_BINARY_DIR}/${PROJECT_CMAKEDIR}/${PROJECT_NAME}Config.cmake
    INSTALL_DESTINATION ${PROJECT_CMAKEDIR}
    PATH_VARS INCLUDE_INSTALL_DIR LIB_INSTALL_DIR)
install(FILES ${PROJECT_BINARY_DIR}/${PROJECT_CMAKEDIR}/${PROJECT_NAME}Config.cmake
    ${PROJECT_BINARY_DIR}/${PROJECT_CMAKEDIR}/${PROJECT_NAME}ConfigVersion.cmake
    DESTINATION ${PROJECT_CMAKEDIR} COMPONENT dev)