(include "#.scm")

;;; These tests come from coverage statistics for part of _num.scm

(check-tail-exn type-exception? (lambda () (finite? 'a)))
(check-eqv? (finite? 0) #t)
(check-eqv? (finite? 1) #t)
(check-eqv? (finite? 99999999999999999999999999999999) #t)
(check-eqv? (finite? 1/2) #t)
(check-eqv? (finite? 0.) #t)
(check-eqv? (finite? 1.5) #t)
(check-eqv? (finite? +inf.0) #f)
(check-eqv? (finite? +nan.0) #f)
(check-eqv? (finite? 0) #t)
(check-eqv? (finite? +i) #t)
(check-eqv? (finite? +99999999999999999999999999999999i) #t)
(check-eqv? (finite? +1/2i) #t)
(check-eqv? (finite? +0.i) #t)
(check-eqv? (finite? +1.5i) #t)
(check-eqv? (finite? +inf.0i) #f)
(check-eqv? (finite? +nan.0i) #f)
(check-eqv? (finite? 1) #t)
(check-eqv? (finite? 1+i) #t)
(check-eqv? (finite? 1+99999999999999999999999999999999i) #t)
(check-eqv? (finite? 1+1/2i) #t)
(check-eqv? (finite? 1+0.i) #t)
(check-eqv? (finite? 1+1.5i) #t)
(check-eqv? (finite? 1+inf.0i) #f)
(check-eqv? (finite? 1+nan.0i) #f)
(check-eqv? (finite? 99999999999999999999999999999999) #t)
(check-eqv? (finite? 99999999999999999999999999999999+i) #t)
(check-eqv? (finite? 99999999999999999999999999999999+99999999999999999999999999999999i) #t)
(check-eqv? (finite? 99999999999999999999999999999999+1/2i) #t)
(check-eqv? (finite? 99999999999999999999999999999999+0.i) #t)
(check-eqv? (finite? 99999999999999999999999999999999+1.5i) #t)
(check-eqv? (finite? 99999999999999999999999999999999+inf.0i) #f)
(check-eqv? (finite? 99999999999999999999999999999999+nan.0i) #f)
(check-eqv? (finite? 1/2) #t)
(check-eqv? (finite? 1/2+i) #t)
(check-eqv? (finite? 1/2+99999999999999999999999999999999i) #t)
(check-eqv? (finite? 1/2+1/2i) #t)
(check-eqv? (finite? 1/2+0.i) #t)
(check-eqv? (finite? 1/2+1.5i) #t)
(check-eqv? (finite? 1/2+inf.0i) #f)
(check-eqv? (finite? 1/2+nan.0i) #f)
(check-eqv? (finite? 0.) #t)
(check-eqv? (finite? 0.+i) #t)
(check-eqv? (finite? 0.+99999999999999999999999999999999i) #t)
(check-eqv? (finite? 0.+1/2i) #t)
(check-eqv? (finite? 0.+0.i) #t)
(check-eqv? (finite? 0.+1.5i) #t)
(check-eqv? (finite? 0.+inf.0i) #f)
(check-eqv? (finite? 0.+nan.0i) #f)
(check-eqv? (finite? 1.5) #t)
(check-eqv? (finite? 1.5+i) #t)
(check-eqv? (finite? 1.5+99999999999999999999999999999999i) #t)
(check-eqv? (finite? 1.5+1/2i) #t)
(check-eqv? (finite? 1.5+0.i) #t)
(check-eqv? (finite? 1.5+1.5i) #t)
(check-eqv? (finite? 1.5+inf.0i) #f)
(check-eqv? (finite? 1.5+nan.0i) #f)
(check-eqv? (finite? +inf.0) #f)
(check-eqv? (finite? +inf.0+i) #f)
(check-eqv? (finite? +inf.0+99999999999999999999999999999999i) #f)
(check-eqv? (finite? +inf.0+1/2i) #f)
(check-eqv? (finite? +inf.0+0.i) #f)
(check-eqv? (finite? +inf.0+1.5i) #f)
(check-eqv? (finite? +inf.0+inf.0i) #f)
(check-eqv? (finite? +inf.0+nan.0i) #f)
(check-eqv? (finite? +nan.0) #f)
(check-eqv? (finite? +nan.0+i) #f)
(check-eqv? (finite? +nan.0+99999999999999999999999999999999i) #f)
(check-eqv? (finite? +nan.0+1/2i) #f)
(check-eqv? (finite? +nan.0+0.i) #f)
(check-eqv? (finite? +nan.0+1.5i) #f)
(check-eqv? (finite? +nan.0+inf.0i) #f)
(check-eqv? (finite? +nan.0+nan.0i) #f)

(check-tail-exn type-exception? (lambda () (infinite? 'a)))
(check-eqv? (infinite? 0) #f)
(check-eqv? (infinite? 1) #f)
(check-eqv? (infinite? 99999999999999999999999999999999) #f)
(check-eqv? (infinite? 1/2) #f)
(check-eqv? (infinite? 0.) #f)
(check-eqv? (infinite? 1.5) #f)
(check-eqv? (infinite? +inf.0) #t)
(check-eqv? (infinite? +nan.0) #f)
(check-eqv? (infinite? 0) #f)
(check-eqv? (infinite? +i) #f)
(check-eqv? (infinite? +99999999999999999999999999999999i) #f)
(check-eqv? (infinite? +1/2i) #f)
(check-eqv? (infinite? +0.i) #f)
(check-eqv? (infinite? +1.5i) #f)
(check-eqv? (infinite? +inf.0i) #t)
(check-eqv? (infinite? +nan.0i) #f)
(check-eqv? (infinite? 1) #f)
(check-eqv? (infinite? 1+i) #f)
(check-eqv? (infinite? 1+99999999999999999999999999999999i) #f)
(check-eqv? (infinite? 1+1/2i) #f)
(check-eqv? (infinite? 1+0.i) #f)
(check-eqv? (infinite? 1+1.5i) #f)
(check-eqv? (infinite? 1+inf.0i) #t)
(check-eqv? (infinite? 1+nan.0i) #f)
(check-eqv? (infinite? 99999999999999999999999999999999) #f)
(check-eqv? (infinite? 99999999999999999999999999999999+i) #f)
(check-eqv? (infinite? 99999999999999999999999999999999+99999999999999999999999999999999i) #f)
(check-eqv? (infinite? 99999999999999999999999999999999+1/2i) #f)
(check-eqv? (infinite? 99999999999999999999999999999999+0.i) #f)
(check-eqv? (infinite? 99999999999999999999999999999999+1.5i) #f)
(check-eqv? (infinite? 99999999999999999999999999999999+inf.0i) #t)
(check-eqv? (infinite? 99999999999999999999999999999999+nan.0i) #f)
(check-eqv? (infinite? 1/2) #f)
(check-eqv? (infinite? 1/2+i) #f)
(check-eqv? (infinite? 1/2+99999999999999999999999999999999i) #f)
(check-eqv? (infinite? 1/2+1/2i) #f)
(check-eqv? (infinite? 1/2+0.i) #f)
(check-eqv? (infinite? 1/2+1.5i) #f)
(check-eqv? (infinite? 1/2+inf.0i) #t)
(check-eqv? (infinite? 1/2+nan.0i) #f)
(check-eqv? (infinite? 0.) #f)
(check-eqv? (infinite? 0.+i) #f)
(check-eqv? (infinite? 0.+99999999999999999999999999999999i) #f)
(check-eqv? (infinite? 0.+1/2i) #f)
(check-eqv? (infinite? 0.+0.i) #f)
(check-eqv? (infinite? 0.+1.5i) #f)
(check-eqv? (infinite? 0.+inf.0i) #t)
(check-eqv? (infinite? 0.+nan.0i) #f)
(check-eqv? (infinite? 1.5) #f)
(check-eqv? (infinite? 1.5+i) #f)
(check-eqv? (infinite? 1.5+99999999999999999999999999999999i) #f)
(check-eqv? (infinite? 1.5+1/2i) #f)
(check-eqv? (infinite? 1.5+0.i) #f)
(check-eqv? (infinite? 1.5+1.5i) #f)
(check-eqv? (infinite? 1.5+inf.0i) #t)
(check-eqv? (infinite? 1.5+nan.0i) #f)
(check-eqv? (infinite? +inf.0) #t)
(check-eqv? (infinite? +inf.0+i) #t)
(check-eqv? (infinite? +inf.0+99999999999999999999999999999999i) #t)
(check-eqv? (infinite? +inf.0+1/2i) #t)
(check-eqv? (infinite? +inf.0+0.i) #t)
(check-eqv? (infinite? +inf.0+1.5i) #t)
(check-eqv? (infinite? +inf.0+inf.0i) #t)
(check-eqv? (infinite? +inf.0+nan.0i) #f)
(check-eqv? (infinite? +nan.0) #f)
(check-eqv? (infinite? +nan.0+i) #f)
(check-eqv? (infinite? +nan.0+99999999999999999999999999999999i) #f)
(check-eqv? (infinite? +nan.0+1/2i) #f)
(check-eqv? (infinite? +nan.0+0.i) #f)
(check-eqv? (infinite? +nan.0+1.5i) #f)
(check-eqv? (infinite? +nan.0+inf.0i) #f)
(check-eqv? (infinite? +nan.0+nan.0i) #f)

(check-tail-exn type-exception? (lambda () (nan? 'a)))
(check-eqv? (nan? 0) #f)
(check-eqv? (nan? 1) #f)
(check-eqv? (nan? 99999999999999999999999999999999) #f)
(check-eqv? (nan? 1/2) #f)
(check-eqv? (nan? 0.) #f)
(check-eqv? (nan? 1.5) #f)
(check-eqv? (nan? +inf.0) #f)
(check-eqv? (nan? +nan.0) #t)
(check-eqv? (nan? 0) #f)
(check-eqv? (nan? +i) #f)
(check-eqv? (nan? +99999999999999999999999999999999i) #f)
(check-eqv? (nan? +1/2i) #f)
(check-eqv? (nan? +0.i) #f)
(check-eqv? (nan? +1.5i) #f)
(check-eqv? (nan? +inf.0i) #f)
(check-eqv? (nan? +nan.0i) #t)
(check-eqv? (nan? 1) #f)
(check-eqv? (nan? 1+i) #f)
(check-eqv? (nan? 1+99999999999999999999999999999999i) #f)
(check-eqv? (nan? 1+1/2i) #f)
(check-eqv? (nan? 1+0.i) #f)
(check-eqv? (nan? 1+1.5i) #f)
(check-eqv? (nan? 1+inf.0i) #f)
(check-eqv? (nan? 1+nan.0i) #t)
(check-eqv? (nan? 99999999999999999999999999999999) #f)
(check-eqv? (nan? 99999999999999999999999999999999+i) #f)
(check-eqv? (nan? 99999999999999999999999999999999+99999999999999999999999999999999i) #f)
(check-eqv? (nan? 99999999999999999999999999999999+1/2i) #f)
(check-eqv? (nan? 99999999999999999999999999999999+0.i) #f)
(check-eqv? (nan? 99999999999999999999999999999999+1.5i) #f)
(check-eqv? (nan? 99999999999999999999999999999999+inf.0i) #f)
(check-eqv? (nan? 99999999999999999999999999999999+nan.0i) #t)
(check-eqv? (nan? 1/2) #f)
(check-eqv? (nan? 1/2+i) #f)
(check-eqv? (nan? 1/2+99999999999999999999999999999999i) #f)
(check-eqv? (nan? 1/2+1/2i) #f)
(check-eqv? (nan? 1/2+0.i) #f)
(check-eqv? (nan? 1/2+1.5i) #f)
(check-eqv? (nan? 1/2+inf.0i) #f)
(check-eqv? (nan? 1/2+nan.0i) #t)
(check-eqv? (nan? 0.) #f)
(check-eqv? (nan? 0.+i) #f)
(check-eqv? (nan? 0.+99999999999999999999999999999999i) #f)
(check-eqv? (nan? 0.+1/2i) #f)
(check-eqv? (nan? 0.+0.i) #f)
(check-eqv? (nan? 0.+1.5i) #f)
(check-eqv? (nan? 0.+inf.0i) #f)
(check-eqv? (nan? 0.+nan.0i) #t)
(check-eqv? (nan? 1.5) #f)
(check-eqv? (nan? 1.5+i) #f)
(check-eqv? (nan? 1.5+99999999999999999999999999999999i) #f)
(check-eqv? (nan? 1.5+1/2i) #f)
(check-eqv? (nan? 1.5+0.i) #f)
(check-eqv? (nan? 1.5+1.5i) #f)
(check-eqv? (nan? 1.5+inf.0i) #f)
(check-eqv? (nan? 1.5+nan.0i) #t)
(check-eqv? (nan? +inf.0) #f)
(check-eqv? (nan? +inf.0+i) #f)
(check-eqv? (nan? +inf.0+99999999999999999999999999999999i) #f)
(check-eqv? (nan? +inf.0+1/2i) #f)
(check-eqv? (nan? +inf.0+0.i) #f)
(check-eqv? (nan? +inf.0+1.5i) #f)
(check-eqv? (nan? +inf.0+inf.0i) #f)
(check-eqv? (nan? +inf.0+nan.0i) #t)
(check-eqv? (nan? +nan.0) #t)
(check-eqv? (nan? +nan.0+i) #t)
(check-eqv? (nan? +nan.0+99999999999999999999999999999999i) #t)
(check-eqv? (nan? +nan.0+1/2i) #t)
(check-eqv? (nan? +nan.0+0.i) #t)
(check-eqv? (nan? +nan.0+1.5i) #t)
(check-eqv? (nan? +nan.0+inf.0i) #t)
(check-eqv? (nan? +nan.0+nan.0i) #t)

(check-eqv? (number? 'a) #f)
(check-eqv? (number? +1+0.i) #t)
(check-eqv? (number? 1) #t)
(check-eqv? (number? 11111111111111111111111111111111) #t)
(check-eqv? (number? 2/3) #t)
(check-eqv? (number? 1.0) #t)
(check-eqv? (number? +nan.0) #t)
(check-eqv? (number? +inf.0) #t)
(check-eqv? (number? -inf.0) #t)

(check-eqv? (real? 'a) #f)
(check-eqv? (real? +1+0.i) #f)
(check-eqv? (real? 1) #t)
(check-eqv? (real? 11111111111111111111111111111111) #t)
(check-eqv? (real? 2/3) #t)
(check-eqv? (real? 1.0) #t)
(check-eqv? (real? +nan.0) #t)
(check-eqv? (real? +inf.0) #t)
(check-eqv? (real? -inf.0) #t)

#|

(check-eqv? (? 'a) #f)
(check-eqv? (? +1+0.i) #f)
(check-eqv? (? 1) #t)
(check-eqv? (? 11111111111111111111111111111111) #t)
(check-eqv? (? 2/3) #t)
(check-eqv? (? 1.0) #t)
(check-eqv? (? +nan.0) #t)
(check-eqv? (? +inf.0) #t)
(check-eqv? (? -inf.0) #t)
|#

(check-eqv? (rational? 'a) #f)
(check-eqv? (rational? +1+0.i) #f)
(check-eqv? (rational? 1) #t)
(check-eqv? (rational? 11111111111111111111111111111111) #t)
(check-eqv? (rational? 2/3) #t)
(check-eqv? (rational? 1.0) #t)
(check-eqv? (rational? +nan.0) #f)
(check-eqv? (rational? +inf.0) #f)
(check-eqv? (rational? -inf.0) #f)

(check-eqv? (integer? 'a) #f)
(check-eqv? (integer? +1+0.i) #f)
(check-eqv? (integer? 1) #t)
(check-eqv? (integer? 11111111111111111111111111111111) #t)
(check-eqv? (integer? 2/3) #f)
(check-eqv? (integer? 1.0) #t)
(check-eqv? (integer? 0.5) #f)
(check-eqv? (integer? +nan.0) #f)
(check-eqv? (integer? +inf.0) #f)
(check-eqv? (integer? -inf.0) #f)

(check-tail-exn type-exception? (lambda () (exact? 'a)))
(check-eqv? (exact? +1+0.i) #f)
(check-eqv? (exact? 1) #t)
(check-eqv? (exact? 11111111111111111111111111111111) #t)
(check-eqv? (exact? 2/3) #t)
(check-eqv? (exact? 1.0) #f)
(check-eqv? (exact? +nan.0) #f)
(check-eqv? (exact? +inf.0) #f)
(check-eqv? (exact? -inf.0) #f)

(check-tail-exn type-exception? (lambda () (= 1 'a)))
(check-tail-exn type-exception? (lambda () (= 'a 1)))
(check-eqv? (= 1 +1+0.i) #t)
(check-eqv? (= (expt 2. 100) (expt 2 100)) #t)
(check-eqv? (= (+ 1/3 1/3) 2/3) #t)
(check-eqv? (= 1.0 1) #t)
(check-eqv? (= +nan.0 1) #f)
(check-eqv? (let ((x +nan.0)) (= x x)) #f)
(check-eqv? (= +inf.0 +inf.0) #t)
(check-eqv? (= -inf.0 -inf.0) #t)
(check-eqv? (= (- +inf.0) -inf.0) #t)

(check-tail-exn type-exception? (lambda () (= 1 'a)))
(check-tail-exn type-exception? (lambda () (= 'a 1)))
(check-eqv? (+ 1 1) 2)
(check-eqv? (let ((x (- (* 3 (quotient ##min-fixnum 4)))))
	      (+ x x))
	    (* 3 (- (quotient ##min-fixnum 2))))

(check-tail-exn type-exception? (lambda () (square 'a)))
(check-eqv? (square 3) 9)
(check-eqv? (square (expt 2 1000)) (expt 2 2000))
(check-eqv? (square 2/3) 4/9)
(check-eqv? (square 0.25) 0.0625)
(check-=    (square 0.25+.125i) .046875+.0625i)
(check-eqv? (square +inf.0+inf.0i) 0.+inf.0i)

(check-tail-exn type-exception? (lambda () (sqrt 'a)))
(check-eqv? (sqrt 16) 4)
(check-eqv? (sqrt (expt 3 100)) (expt 3 50))
(check-eqv? (sqrt 4/9) 2/3)
(check-eqv? (sqrt 4.0) 2.0)
(check-eqv? (sqrt +2.0i) 1.0+1.0i)
(check-eqv? (sqrt -2.0i) 1.-1.i)
(check-eqv? (sqrt (+ (expt 2 1000) 1)) (expt 2. 500))
(check-eqv? (sqrt (+ (expt 3 60) 1)) 2.05891132094649e14)
;; The following argument exercises the (##fxnegative? r)
;; code path in ##exact-int.sqrt for 64-bit fixnums.
(check-eqv? (integer-sqrt 177929191730305443) 421816537)

(check-tail-exn type-exception? (lambda () (abs 'a)))
(check-eqv? (abs -1) 1)
(check-eqv? (abs 1) 1)
(check-eqv? (abs (- (expt 3 100))) (expt 3 100))
(check-eqv? (abs (expt 3 100)) (expt 3 100))
(check-eqv? (abs 2/3) 2/3)
(check-eqv? (abs -2/3) 2/3)
(check-eqv? (abs -1.) 1.)
(check-eqv? (abs 1.) 1.)
(check-tail-exn type-exception? (lambda () (abs 12.+5.i)))
(check-tail-exn type-exception? (lambda () (abs 12+5i)))

(check-tail-exn type-exception? (lambda () (magnitude 'a)))
(check-eqv? (magnitude -1) 1)
(check-eqv? (magnitude 1) 1)
(check-eqv? (magnitude (- (expt 3 100))) (expt 3 100))
(check-eqv? (magnitude (expt 3 100)) (expt 3 100))
(check-eqv? (magnitude 2/3) 2/3)
(check-eqv? (magnitude -2/3) 2/3)
(check-eqv? (magnitude -1.) 1.)
(check-eqv? (magnitude 1.) 1.)
(check-eqv? (magnitude 12.+5.i) 13.)
(check-eqv? (magnitude 12+5i) 13)

(check-eqv? (log (expt 2 10000)) (* 10000 (log 2)))
(check-eqv? (log +inf.0+0.0i) +inf.0+0.i)
(check-eqv? (log -inf.0+0.0i) (+ +inf.0 (log -1.0)))

(check-eqv? (atan +nan.0 0) +nan.0)
(check-eqv? (atan 0 +nan.0) +nan.0)
(check-eqv? (atan 2 0) (macro-inexact-+pi/2))
(check-eqv? (atan +inf.0 +inf.0) (macro-inexact-+pi/4))
(check-eqv? (atan -inf.0 +inf.0)  (- (macro-inexact-+pi/4)))
(check-eqv? (atan (expt 3 10000) (expt 3 10000)) (macro-inexact-+pi/4))

(check-eqv? (expt -4 1/2) +2i)
(check-eqv? (expt -4. 1/2) +2.i)
(check-eqv? (expt -4 3/2) -8i)
(check-eqv? (expt -4. 3/2) -8.i)
(check-eqv? (expt -8 1/3) (* 2 (macro-cpxnum-+1/2+sqrt3/2i)))
(check-eqv? (expt -8 2/3) (* 4 (macro-cpxnum--1/2+sqrt3/2i)))
(check-eqv? (expt -8 4/3) (* 16 (macro-cpxnum--1/2-sqrt3/2i)))
(check-eqv? (expt -8 5/3) (* 32 (macro-cpxnum-+1/2-sqrt3/2i)))
(check-eqv? (expt -64 1/6) (* 2 (macro-cpxnum-+sqrt3/2+1/2i)))
(check-eqv? (expt -64 5/6) (* 32 (macro-cpxnum--sqrt3/2+1/2i)))
(check-eqv? (expt -64 7/6) (* 128 (macro-cpxnum--sqrt3/2-1/2i)))
(check-eqv? (expt -64 11/6) (* 2048 (macro-cpxnum-+sqrt3/2-1/2i)))
(check-eqv? (expt 100 -1/4) (/ (sqrt (sqrt 100))))

;; On Windows with 32 bit MinGW, the following unit tests fail:
;;
;;(check-eqv? (expt 100/81 -1/4) (/ 3 (sqrt (sqrt 100))))
;;(check-eqv? (expt -1. (expt 3 1000)) -1.)
;;
;; They give these errors:
;;
;;"unit-tests\\04-coverage\\_num.scm"@174.1: FAILED (check-eqv? (expt 100/81 -1/4) (/ 3 (sqrt (sqrt 100)))) GOT .9486832980505139
;;"unit-tests\\04-coverage\\_num.scm"@175.1: FAILED (check-eqv? (expt -1. (expt 3 1000)) -1.) GOT +nan.0
;;
;; The problem occurs specifically in the appveyor environment.
;; Unfortunately it can't be reproduced elsewhere, so solving
;; this issue will have to wait until the issue appears in a
;; debugging environment we have access to.

(check-eqv? (expt 27/8 1/3) 3/2)
(check-eqv? (expt +2i 3/2) -2+2i)
(check-eqv? (expt +2i 1/2) 1+i)
(check-tail-exn range-exception? (lambda () (expt 0 -1+i)))
(check-tail-exn range-exception? (lambda () (expt 0 -3/4)))

(check-tail-exn type-exception? (lambda () (bitwise-and 1 'a)))
(check-tail-exn type-exception? (lambda () (bitwise-and 'a 1)))
(check-eqv? (bitwise-and 123443 17042360) (test-bitwise-and 123443 17042360))
(check-eqv? (bitwise-and 123443 902345798234656542928345617042360)
	    (test-bitwise-and 123443 902345798234656542928345617042360))
(check-eqv? (bitwise-and -123443 17042360) (test-bitwise-and -123443 17042360))
(check-eqv? (bitwise-and -123443 902345798234656542928345617042360)
	    (test-bitwise-and -123443 902345798234656542928345617042360))
(check-eqv? (bitwise-and 123443 -17042360)
	    (test-bitwise-and 123443 -17042360))
(check-eqv? (bitwise-and 123443 -902345798234656542928345617042360)
	    (test-bitwise-and 123443 -902345798234656542928345617042360))
(check-eqv? (bitwise-and -123443 -17042360)
	    (test-bitwise-and -123443 -17042360))
(check-eqv? (bitwise-and -123443 -902345798234656542928345617042360)
	    (test-bitwise-and -123443 -902345798234656542928345617042360))
(check-eqv? (bitwise-and 34572348562304523465432065423 234532485620943562345234958634)
	    (test-bitwise-and 34572348562304523465432065423 234532485620943562345234958634))
(check-eqv? (bitwise-and -34572348562304523465432065423 234532485620943562345234958634)
	    (test-bitwise-and -34572348562304523465432065423 234532485620943562345234958634))
(check-eqv? (bitwise-and 34572348562304523465432065423 -234532485620943562345234958634)
	    (test-bitwise-and 34572348562304523465432065423 -234532485620943562345234958634))
(check-eqv? (bitwise-and -34572348562304523465432065423 -234532485620943562345234958634)
	    (test-bitwise-and -34572348562304523465432065423 -234532485620943562345234958634))
(check-eqv? (bitwise-and  902345798234656542928345617042360 123443)
	    (test-bitwise-and  902345798234656542928345617042360 123443))

(check-tail-exn type-exception? (lambda () (bitwise-andc1 1 'a)))
(check-tail-exn type-exception? (lambda () (bitwise-andc1 'a 1)))
(check-eqv? (bitwise-andc1 123443 17042360) (test-bitwise-andc1 123443 17042360))
(check-eqv? (bitwise-andc1 123443 902345798234656542928345617042360)
	    (test-bitwise-andc1 123443 902345798234656542928345617042360))
(check-eqv? (bitwise-andc1 -123443 17042360) (test-bitwise-andc1 -123443 17042360))
(check-eqv? (bitwise-andc1 -123443 902345798234656542928345617042360)
	    (test-bitwise-andc1 -123443 902345798234656542928345617042360))
(check-eqv? (bitwise-andc1 123443 -17042360)
	    (test-bitwise-andc1 123443 -17042360))
(check-eqv? (bitwise-andc1 123443 -902345798234656542928345617042360)
	    (test-bitwise-andc1 123443 -902345798234656542928345617042360))
(check-eqv? (bitwise-andc1 -123443 -17042360)
	    (test-bitwise-andc1 -123443 -17042360))
(check-eqv? (bitwise-andc1 -123443 -902345798234656542928345617042360)
	    (test-bitwise-andc1 -123443 -902345798234656542928345617042360))
(check-eqv? (bitwise-andc1 34572348562304523465432065423 234532485620943562345234958634)
	    (test-bitwise-andc1 34572348562304523465432065423 234532485620943562345234958634))
(check-eqv? (bitwise-andc1 -34572348562304523465432065423 234532485620943562345234958634)
	    (test-bitwise-andc1 -34572348562304523465432065423 234532485620943562345234958634))
(check-eqv? (bitwise-andc1 34572348562304523465432065423 -234532485620943562345234958634)
	    (test-bitwise-andc1 34572348562304523465432065423 -234532485620943562345234958634))
(check-eqv? (bitwise-andc1 -34572348562304523465432065423 -234532485620943562345234958634)
	    (test-bitwise-andc1 -34572348562304523465432065423 -234532485620943562345234958634))
(check-eqv? (bitwise-andc1  902345798234656542928345617042360 123443)
	    (test-bitwise-andc1  902345798234656542928345617042360 123443))

(check-tail-exn type-exception? (lambda () (bitwise-andc2 1 'a)))
(check-tail-exn type-exception? (lambda () (bitwise-andc2 'a 1)))
(check-eqv? (bitwise-andc2 123443 17042360) (test-bitwise-andc2 123443 17042360))
(check-eqv? (bitwise-andc2 123443 902345798234656542928345617042360)
	    (test-bitwise-andc2 123443 902345798234656542928345617042360))
(check-eqv? (bitwise-andc2 -123443 17042360) (test-bitwise-andc2 -123443 17042360))
(check-eqv? (bitwise-andc2 -123443 902345798234656542928345617042360)
	    (test-bitwise-andc2 -123443 902345798234656542928345617042360))
(check-eqv? (bitwise-andc2 123443 -17042360)
	    (test-bitwise-andc2 123443 -17042360))
(check-eqv? (bitwise-andc2 123443 -902345798234656542928345617042360)
	    (test-bitwise-andc2 123443 -902345798234656542928345617042360))
(check-eqv? (bitwise-andc2 -123443 -17042360)
	    (test-bitwise-andc2 -123443 -17042360))
(check-eqv? (bitwise-andc2 -123443 -902345798234656542928345617042360)
	    (test-bitwise-andc2 -123443 -902345798234656542928345617042360))
(check-eqv? (bitwise-andc2 34572348562304523465432065423 234532485620943562345234958634)
	    (test-bitwise-andc2 34572348562304523465432065423 234532485620943562345234958634))
(check-eqv? (bitwise-andc2 -34572348562304523465432065423 234532485620943562345234958634)
	    (test-bitwise-andc2 -34572348562304523465432065423 234532485620943562345234958634))
(check-eqv? (bitwise-andc2 34572348562304523465432065423 -234532485620943562345234958634)
	    (test-bitwise-andc2 34572348562304523465432065423 -234532485620943562345234958634))
(check-eqv? (bitwise-andc2 -34572348562304523465432065423 -234532485620943562345234958634)
	    (test-bitwise-andc2 -34572348562304523465432065423 -234532485620943562345234958634))
(check-eqv? (bitwise-andc2  902345798234656542928345617042360 123443)
	    (test-bitwise-andc2  902345798234656542928345617042360 123443))

(check-tail-exn type-exception? (lambda () (bitwise-eqv 1 'a)))
(check-tail-exn type-exception? (lambda () (bitwise-eqv 'a 1)))
(check-eqv? (bitwise-eqv 123443 17042360) (test-bitwise-eqv 123443 17042360))
(check-eqv? (bitwise-eqv 123443 902345798234656542928345617042360)
	    (test-bitwise-eqv 123443 902345798234656542928345617042360))
(check-eqv? (bitwise-eqv -123443 17042360) (test-bitwise-eqv -123443 17042360))
(check-eqv? (bitwise-eqv -123443 902345798234656542928345617042360)
	    (test-bitwise-eqv -123443 902345798234656542928345617042360))
(check-eqv? (bitwise-eqv 123443 -17042360)
	    (test-bitwise-eqv 123443 -17042360))
(check-eqv? (bitwise-eqv 123443 -902345798234656542928345617042360)
	    (test-bitwise-eqv 123443 -902345798234656542928345617042360))
(check-eqv? (bitwise-eqv -123443 -17042360)
	    (test-bitwise-eqv -123443 -17042360))
(check-eqv? (bitwise-eqv -123443 -902345798234656542928345617042360)
	    (test-bitwise-eqv -123443 -902345798234656542928345617042360))
(check-eqv? (bitwise-eqv 34572348562304523465432065423 234532485620943562345234958634)
	    (test-bitwise-eqv 34572348562304523465432065423 234532485620943562345234958634))
(check-eqv? (bitwise-eqv -34572348562304523465432065423 234532485620943562345234958634)
	    (test-bitwise-eqv -34572348562304523465432065423 234532485620943562345234958634))
(check-eqv? (bitwise-eqv 34572348562304523465432065423 -234532485620943562345234958634)
	    (test-bitwise-eqv 34572348562304523465432065423 -234532485620943562345234958634))
(check-eqv? (bitwise-eqv -34572348562304523465432065423 -234532485620943562345234958634)
	    (test-bitwise-eqv -34572348562304523465432065423 -234532485620943562345234958634))
(check-eqv? (bitwise-eqv  902345798234656542928345617042360 123443)
	    (test-bitwise-eqv  902345798234656542928345617042360 123443))

(check-tail-exn type-exception? (lambda () (bitwise-ior 1 'a)))
(check-tail-exn type-exception? (lambda () (bitwise-ior 'a 1)))
(check-eqv? (bitwise-ior 123443 17042360) (test-bitwise-ior 123443 17042360))
(check-eqv? (bitwise-ior 123443 902345798234656542928345617042360)
	    (test-bitwise-ior 123443 902345798234656542928345617042360))
(check-eqv? (bitwise-ior -123443 17042360) (test-bitwise-ior -123443 17042360))
(check-eqv? (bitwise-ior -123443 902345798234656542928345617042360)
	    (test-bitwise-ior -123443 902345798234656542928345617042360))
(check-eqv? (bitwise-ior 123443 -17042360)
	    (test-bitwise-ior 123443 -17042360))
(check-eqv? (bitwise-ior 123443 -902345798234656542928345617042360)
	    (test-bitwise-ior 123443 -902345798234656542928345617042360))
(check-eqv? (bitwise-ior -123443 -17042360)
	    (test-bitwise-ior -123443 -17042360))
(check-eqv? (bitwise-ior -123443 -902345798234656542928345617042360)
	    (test-bitwise-ior -123443 -902345798234656542928345617042360))
(check-eqv? (bitwise-ior 34572348562304523465432065423 234532485620943562345234958634)
	    (test-bitwise-ior 34572348562304523465432065423 234532485620943562345234958634))
(check-eqv? (bitwise-ior -34572348562304523465432065423 234532485620943562345234958634)
	    (test-bitwise-ior -34572348562304523465432065423 234532485620943562345234958634))
(check-eqv? (bitwise-ior 34572348562304523465432065423 -234532485620943562345234958634)
	    (test-bitwise-ior 34572348562304523465432065423 -234532485620943562345234958634))
(check-eqv? (bitwise-ior -34572348562304523465432065423 -234532485620943562345234958634)
	    (test-bitwise-ior -34572348562304523465432065423 -234532485620943562345234958634))
(check-eqv? (bitwise-ior  902345798234656542928345617042360 123443)
	    (test-bitwise-ior  902345798234656542928345617042360 123443))

(check-tail-exn type-exception? (lambda () (bitwise-nand 1 'a)))
(check-tail-exn type-exception? (lambda () (bitwise-nand 'a 1)))
(check-eqv? (bitwise-nand 123443 17042360) (test-bitwise-nand 123443 17042360))
(check-eqv? (bitwise-nand 123443 902345798234656542928345617042360)
	    (test-bitwise-nand 123443 902345798234656542928345617042360))
(check-eqv? (bitwise-nand -123443 17042360) (test-bitwise-nand -123443 17042360))
(check-eqv? (bitwise-nand -123443 902345798234656542928345617042360)
	    (test-bitwise-nand -123443 902345798234656542928345617042360))
(check-eqv? (bitwise-nand 123443 -17042360)
	    (test-bitwise-nand 123443 -17042360))
(check-eqv? (bitwise-nand 123443 -902345798234656542928345617042360)
	    (test-bitwise-nand 123443 -902345798234656542928345617042360))
(check-eqv? (bitwise-nand -123443 -17042360)
	    (test-bitwise-nand -123443 -17042360))
(check-eqv? (bitwise-nand -123443 -902345798234656542928345617042360)
	    (test-bitwise-nand -123443 -902345798234656542928345617042360))
(check-eqv? (bitwise-nand 34572348562304523465432065423 234532485620943562345234958634)
	    (test-bitwise-nand 34572348562304523465432065423 234532485620943562345234958634))
(check-eqv? (bitwise-nand -34572348562304523465432065423 234532485620943562345234958634)
	    (test-bitwise-nand -34572348562304523465432065423 234532485620943562345234958634))
(check-eqv? (bitwise-nand 34572348562304523465432065423 -234532485620943562345234958634)
	    (test-bitwise-nand 34572348562304523465432065423 -234532485620943562345234958634))
(check-eqv? (bitwise-nand -34572348562304523465432065423 -234532485620943562345234958634)
	    (test-bitwise-nand -34572348562304523465432065423 -234532485620943562345234958634))
(check-eqv? (bitwise-nand  902345798234656542928345617042360 123443)
	    (test-bitwise-nand  902345798234656542928345617042360 123443))

(check-tail-exn type-exception? (lambda () (bitwise-nor 1 'a)))
(check-tail-exn type-exception? (lambda () (bitwise-nor 'a 1)))
(check-eqv? (bitwise-nor 123443 17042360) (test-bitwise-nor 123443 17042360))
(check-eqv? (bitwise-nor 123443 902345798234656542928345617042360)
	    (test-bitwise-nor 123443 902345798234656542928345617042360))
(check-eqv? (bitwise-nor -123443 17042360) (test-bitwise-nor -123443 17042360))
(check-eqv? (bitwise-nor -123443 902345798234656542928345617042360)
	    (test-bitwise-nor -123443 902345798234656542928345617042360))
(check-eqv? (bitwise-nor 123443 -17042360)
	    (test-bitwise-nor 123443 -17042360))
(check-eqv? (bitwise-nor 123443 -902345798234656542928345617042360)
	    (test-bitwise-nor 123443 -902345798234656542928345617042360))
(check-eqv? (bitwise-nor -123443 -17042360)
	    (test-bitwise-nor -123443 -17042360))
(check-eqv? (bitwise-nor -123443 -902345798234656542928345617042360)
	    (test-bitwise-nor -123443 -902345798234656542928345617042360))
(check-eqv? (bitwise-nor 34572348562304523465432065423 234532485620943562345234958634)
	    (test-bitwise-nor 34572348562304523465432065423 234532485620943562345234958634))
(check-eqv? (bitwise-nor -34572348562304523465432065423 234532485620943562345234958634)
	    (test-bitwise-nor -34572348562304523465432065423 234532485620943562345234958634))
(check-eqv? (bitwise-nor 34572348562304523465432065423 -234532485620943562345234958634)
	    (test-bitwise-nor 34572348562304523465432065423 -234532485620943562345234958634))
(check-eqv? (bitwise-nor -34572348562304523465432065423 -234532485620943562345234958634)
	    (test-bitwise-nor -34572348562304523465432065423 -234532485620943562345234958634))
(check-eqv? (bitwise-nor  902345798234656542928345617042360 123443)
	    (test-bitwise-nor  902345798234656542928345617042360 123443))

(check-tail-exn type-exception? (lambda () (bitwise-not 'a)))
(check-eqv? (bitwise-not 17042360) (test-bitwise-not 17042360))
(check-eqv? (bitwise-not -123443) (test-bitwise-not -123443))
(check-eqv? (bitwise-not 902345798234656542928345617042360)
	    (test-bitwise-not 902345798234656542928345617042360))
(check-eqv? (bitwise-not -902345798234656542928345617042360)
	    (test-bitwise-not -902345798234656542928345617042360))

(check-tail-exn type-exception? (lambda () (bitwise-orc1 1 'a)))
(check-tail-exn type-exception? (lambda () (bitwise-orc1 'a 1)))
(check-eqv? (bitwise-orc1 123443 17042360) (test-bitwise-orc1 123443 17042360))
(check-eqv? (bitwise-orc1 123443 902345798234656542928345617042360)
	    (test-bitwise-orc1 123443 902345798234656542928345617042360))
(check-eqv? (bitwise-orc1 -123443 17042360) (test-bitwise-orc1 -123443 17042360))
(check-eqv? (bitwise-orc1 -123443 902345798234656542928345617042360)
	    (test-bitwise-orc1 -123443 902345798234656542928345617042360))
(check-eqv? (bitwise-orc1 123443 -17042360)
	    (test-bitwise-orc1 123443 -17042360))
(check-eqv? (bitwise-orc1 123443 -902345798234656542928345617042360)
	    (test-bitwise-orc1 123443 -902345798234656542928345617042360))
(check-eqv? (bitwise-orc1 -123443 -17042360)
	    (test-bitwise-orc1 -123443 -17042360))
(check-eqv? (bitwise-orc1 -123443 -902345798234656542928345617042360)
	    (test-bitwise-orc1 -123443 -902345798234656542928345617042360))
(check-eqv? (bitwise-orc1 34572348562304523465432065423 234532485620943562345234958634)
	    (test-bitwise-orc1 34572348562304523465432065423 234532485620943562345234958634))
(check-eqv? (bitwise-orc1 -34572348562304523465432065423 234532485620943562345234958634)
	    (test-bitwise-orc1 -34572348562304523465432065423 234532485620943562345234958634))
(check-eqv? (bitwise-orc1 34572348562304523465432065423 -234532485620943562345234958634)
	    (test-bitwise-orc1 34572348562304523465432065423 -234532485620943562345234958634))
(check-eqv? (bitwise-orc1 -34572348562304523465432065423 -234532485620943562345234958634)
	    (test-bitwise-orc1 -34572348562304523465432065423 -234532485620943562345234958634))
(check-eqv? (bitwise-orc1  902345798234656542928345617042360 123443)
	    (test-bitwise-orc1  902345798234656542928345617042360 123443))

(check-tail-exn type-exception? (lambda () (bitwise-orc2 1 'a)))
(check-tail-exn type-exception? (lambda () (bitwise-orc2 'a 1)))
(check-eqv? (bitwise-orc2 123443 17042360) (test-bitwise-orc2 123443 17042360))
(check-eqv? (bitwise-orc2 123443 902345798234656542928345617042360)
	    (test-bitwise-orc2 123443 902345798234656542928345617042360))
(check-eqv? (bitwise-orc2 -123443 17042360) (test-bitwise-orc2 -123443 17042360))
(check-eqv? (bitwise-orc2 -123443 902345798234656542928345617042360)
	    (test-bitwise-orc2 -123443 902345798234656542928345617042360))
(check-eqv? (bitwise-orc2 123443 -17042360)
	    (test-bitwise-orc2 123443 -17042360))
(check-eqv? (bitwise-orc2 123443 -902345798234656542928345617042360)
	    (test-bitwise-orc2 123443 -902345798234656542928345617042360))
(check-eqv? (bitwise-orc2 -123443 -17042360)
	    (test-bitwise-orc2 -123443 -17042360))
(check-eqv? (bitwise-orc2 -123443 -902345798234656542928345617042360)
	    (test-bitwise-orc2 -123443 -902345798234656542928345617042360))
(check-eqv? (bitwise-orc2 34572348562304523465432065423 234532485620943562345234958634)
	    (test-bitwise-orc2 34572348562304523465432065423 234532485620943562345234958634))
(check-eqv? (bitwise-orc2 -34572348562304523465432065423 234532485620943562345234958634)
	    (test-bitwise-orc2 -34572348562304523465432065423 234532485620943562345234958634))
(check-eqv? (bitwise-orc2 34572348562304523465432065423 -234532485620943562345234958634)
	    (test-bitwise-orc2 34572348562304523465432065423 -234532485620943562345234958634))
(check-eqv? (bitwise-orc2 -34572348562304523465432065423 -234532485620943562345234958634)
	    (test-bitwise-orc2 -34572348562304523465432065423 -234532485620943562345234958634))
(check-eqv? (bitwise-orc2  902345798234656542928345617042360 123443)
	    (test-bitwise-orc2  902345798234656542928345617042360 123443))

(check-tail-exn type-exception? (lambda () (bitwise-xor 1 'a)))
(check-tail-exn type-exception? (lambda () (bitwise-xor 'a 1)))
(check-eqv? (bitwise-xor 123443 17042360) (test-bitwise-xor 123443 17042360))
(check-eqv? (bitwise-xor 123443 902345798234656542928345617042360)
	    (test-bitwise-xor 123443 902345798234656542928345617042360))
(check-eqv? (bitwise-xor -123443 17042360) (test-bitwise-xor -123443 17042360))
(check-eqv? (bitwise-xor -123443 902345798234656542928345617042360)
	    (test-bitwise-xor -123443 902345798234656542928345617042360))
(check-eqv? (bitwise-xor 123443 -17042360)
	    (test-bitwise-xor 123443 -17042360))
(check-eqv? (bitwise-xor 123443 -902345798234656542928345617042360)
	    (test-bitwise-xor 123443 -902345798234656542928345617042360))
(check-eqv? (bitwise-xor -123443 -17042360)
	    (test-bitwise-xor -123443 -17042360))
(check-eqv? (bitwise-xor -123443 -902345798234656542928345617042360)
	    (test-bitwise-xor -123443 -902345798234656542928345617042360))
(check-eqv? (bitwise-xor 34572348562304523465432065423 234532485620943562345234958634)
	    (test-bitwise-xor 34572348562304523465432065423 234532485620943562345234958634))
(check-eqv? (bitwise-xor -34572348562304523465432065423 234532485620943562345234958634)
	    (test-bitwise-xor -34572348562304523465432065423 234532485620943562345234958634))
(check-eqv? (bitwise-xor 34572348562304523465432065423 -234532485620943562345234958634)
	    (test-bitwise-xor 34572348562304523465432065423 -234532485620943562345234958634))
(check-eqv? (bitwise-xor -34572348562304523465432065423 -234532485620943562345234958634)
	    (test-bitwise-xor -34572348562304523465432065423 -234532485620943562345234958634))
(check-eqv? (bitwise-xor  902345798234656542928345617042360 123443)
	    (test-bitwise-xor  902345798234656542928345617042360 123443))

(check-tail-exn type-exception? (lambda () (bits 123)))
(check-tail-exn type-exception? (lambda () (bits "foo")))
(check-eqv? (bits) 0)
(check-eqv? (bits #f) 0)
(check-eqv? (bits #t) 1)
(check-eqv? (bits #f #t #f #t) 10)

(check-tail-exn type-exception? (lambda () (list->bits "foo")))
(check-tail-exn type-exception? (lambda () (list->bits '(123))))
(check-tail-exn type-exception? (lambda () (list->bits '("foo"))))
(check-tail-exn type-exception? (lambda () (list->bits '(#f . #f))))
(check-eqv? (list->bits '()) 0)
(check-eqv? (list->bits '(#f)) 0)
(check-eqv? (list->bits '(#t)) 1)
(check-eqv? (list->bits '(#t #t #t #f)) 7)
(check-eqv? (list->bits '(#f #t #f #t)) 10)

(check-tail-exn type-exception? (lambda () (vector->bits "foo")))
(check-tail-exn type-exception? (lambda () (vector->bits '#(123))))
(check-tail-exn type-exception? (lambda () (vector->bits '#("foo"))))
(check-eqv? (vector->bits '#()) 0)
(check-eqv? (vector->bits '#(#f)) 0)
(check-eqv? (vector->bits '#(#t)) 1)
(check-eqv? (vector->bits '#(#t #t #t #f)) 7)
(check-eqv? (vector->bits '#(#f #t #f #t)) 10)

(check-tail-exn type-exception? (lambda () (bits->vector "foo")))
(check-tail-exn type-exception? (lambda () (bits->vector 10 "foo")))
(check-equal? (bits->vector -9) '#(#t #t #t #f))
(check-equal? (bits->vector -1) '#())
(check-equal? (bits->vector 0) '#())
(check-equal? (bits->vector 1) '#(#t))
(check-equal? (bits->vector 10) '#(#f #t #f #t))
(check-equal? (bits->vector -9 3) '#(#t #t #t))
(check-equal? (bits->vector -1 3) '#(#t #t #t))
(check-equal? (bits->vector 0 3) '#(#f #f #f))
(check-equal? (bits->vector 1 3) '#(#t #f #f))
(check-equal? (bits->vector 10 3) '#(#f #t #f))

(check-tail-exn type-exception? (lambda () (bits->list "foo")))
(check-tail-exn type-exception? (lambda () (bits->list 10 "foo")))
(check-equal? (bits->list -9) '(#t #t #t #f))
(check-equal? (bits->list -1) '())
(check-equal? (bits->list 0) '())
(check-equal? (bits->list 1) '(#t))
(check-equal? (bits->list 10) '(#f #t #f #t))
(check-equal? (bits->list -9 3) '(#t #t #t))
(check-equal? (bits->list -1 3) '(#t #t #t))
(check-equal? (bits->list 0 3) '(#f #f #f))
(check-equal? (bits->list 1 3) '(#t #f #f))
(check-equal? (bits->list 10 3) '(#f #t #f))

;;;------------------------------------------------------------
;;; Minimal new tests for the remainder of SRFI 151 routines
;;;------------------------------------------------------------

(check-tail-exn type-exception? (lambda () (bitwise-if 'a 3 2)))
(check-tail-exn type-exception? (lambda () (bitwise-if 2 'a 3)))
(check-tail-exn type-exception? (lambda () (bitwise-if 2 2 'a)))
(check-eqv? (bitwise-if 3 1 8)  9)
(check-eqv? (bitwise-if 3 8 1)  0)
(check-eqv? (bitwise-if 1 1 2)  3)
(check-eqv? (bitwise-if #b00111100 #b11110000 #b00001111)  #b00110011)

(check-tail-exn type-exception? (lambda () (copy-bit 0 0 'a)))
(check-tail-exn type-exception? (lambda () (copy-bit 0 'a #f)))
(check-tail-exn type-exception? (lambda () (copy-bit 'a -1 #f)))
(check-tail-exn range-exception? (lambda () (copy-bit -1 -1 #f)))
(check-eqv? (copy-bit 0 0 #f) 0)
(check-eqv? (copy-bit 30 0 #f) 0)
(check-eqv? (copy-bit 31 0 #f) 0)
(check-eqv? (copy-bit 62 0 #f) 0)
(check-eqv? (copy-bit 63 0 #f) 0)
(check-eqv? (copy-bit 128 0 #f) 0)
(check-eqv? (copy-bit 0 -1 #t) -1)
(check-eqv? (copy-bit 30 -1 #t) -1)
(check-eqv? (copy-bit 31 -1 #t) -1)
(check-eqv? (copy-bit 62 -1 #t) -1)
(check-eqv? (copy-bit 63 -1 #t) -1)
(check-eqv? (copy-bit 128 -1 #t) -1)
(check-eqv? (copy-bit 0 0 #t) 1)
(check-eqv? (copy-bit 8 6 #t) 262)
(check-eqv? (copy-bit 8 6 #f) 6)
(check-eqv? (copy-bit 0 -1 #f) -2)
(check-eqv? (copy-bit 128 340282366920938463463374607431768211456 #f) 0)
(check-eqv?
 (copy-bit 128 340282366920938463463374607431768211456 #t)
 340282366920938463463374607431768211456)
(check-eqv?
 (copy-bit 64 340282366920938463463374607431768211456 #f)
 340282366920938463463374607431768211456)
(check-eqv?
 (copy-bit 64 -340282366920938463463374607431768211456 #f)
 -340282366920938463463374607431768211456)
(check-eqv?
 (copy-bit 256 -340282366920938463463374607431768211456 #t)
 -340282366920938463463374607431768211456)
(check-eqv? (copy-bit 2 0 #t) 4)
(check-eqv? (copy-bit 2 15 #f) 11)
(check-eqv? (copy-bit 0 0 #t) 1)

(check-tail-exn type-exception? (lambda () (bit-swap 1 2 'a)))
(check-tail-exn type-exception? (lambda () (bit-swap 1'a -1)))
(check-tail-exn range-exception? (lambda () (bit-swap 1 -1 -1)))
(check-tail-exn type-exception? (lambda () (bit-swap 'a 1 -1)))
(check-tail-exn range-exception? (lambda () (bit-swap -1 1 -1)))
(check-eqv? (bit-swap 1 2 13) 11)
(check-eqv? (bit-swap 2 1 13) 11)
(check-eqv? (bit-swap 0 1 13) 14)
(check-eqv? (bit-swap 3 10 13) 1029)
(check-eqv? (bit-swap 0 2 4) 1)

(check-tail-exn type-exception? (lambda () (any-bit-set? 'a 6)))
(check-tail-exn type-exception? (lambda () (any-bit-set?  6 'a)))
(check-eqv? (any-bit-set? 3 6) #t)
(check-eqv? (any-bit-set? 3 12) #f)
(check-eqv? (every-bit-set? 4 6) #t)
(check-eqv? (every-bit-set? 7 6) #f)

(check-tail-exn type-exception? (lambda () (every-bit-set? 'a 6)))
(check-tail-exn type-exception? (lambda () (every-bit-set?  6 'a)))
(check-eqv? (every-bit-set? 4 6) #t)
(check-eqv? (every-bit-set? 7 6) #f)

(check-tail-exn type-exception? (lambda () (bit-field 6 0 'a)))
(check-tail-exn type-exception? (lambda () (bit-field 6 'a 1)))
(check-tail-exn type-exception? (lambda () (bit-field 'a 0 1)))
(check-tail-exn range-exception? (lambda () (bit-field 6 0 -1)))
(check-tail-exn range-exception? (lambda () (bit-field 6 -1 1)))
(check-tail-exn range-exception? (lambda () (bit-field 6 2 1)))
(check-eqv? (bit-field 6 0 1) 0)
(check-eqv? (bit-field 6 1 3) 3)
(check-eqv? (bit-field 6 2 999) 1)
(check-eqv? (bit-field 340282366920938463463374607431768211456 128 129) 1)
(check-eqv? (bit-field 874 0 4) 10)
(check-eqv? (bit-field 874 3 9) 45)
(check-eqv? (bit-field 874 4 9) 22)
(check-eqv? (bit-field 874 4 10) 54)

(check-tail-exn type-exception? (lambda () (bit-field-any? 6 0 'a)))
(check-tail-exn type-exception? (lambda () (bit-field-any? 6 'a 1)))
(check-tail-exn type-exception? (lambda () (bit-field-any? 'a 0 1)))
(check-tail-exn range-exception? (lambda () (bit-field-any? 6 0 -1)))
(check-tail-exn range-exception? (lambda () (bit-field-any? 6 -1 1)))
(check-tail-exn range-exception? (lambda () (bit-field-any? 6 2 1)))
(check-eqv? (bit-field-any? 45 0 2) #t)
(check-eqv? (bit-field-any? 45 2 4) #t)
(check-eqv? (bit-field-any? 45 1 2) #f)


(check-tail-exn type-exception? (lambda () (bit-field-every? 6 0 'a)))
(check-tail-exn type-exception? (lambda () (bit-field-every? 6 'a 1)))
(check-tail-exn type-exception? (lambda () (bit-field-every? 'a 0 1)))
(check-tail-exn range-exception? (lambda () (bit-field-every? 6 0 -1)))
(check-tail-exn range-exception? (lambda () (bit-field-every? 6 -1 1)))
(check-tail-exn range-exception? (lambda () (bit-field-every? 6 2 1)))
(check-eqv? (bit-field-every? 45 0 2) #f)
(check-eqv? (bit-field-every? 45 2 4) #t)
(check-eqv? (bit-field-every? 45 0 1) #t)


(check-tail-exn type-exception? (lambda () (bit-field-clear 6 0 'a)))
(check-tail-exn type-exception? (lambda () (bit-field-clear 6 'a 1)))
(check-tail-exn type-exception? (lambda () (bit-field-clear 'a 0 1)))
(check-tail-exn range-exception? (lambda () (bit-field-clear 6 0 -1)))
(check-tail-exn range-exception? (lambda () (bit-field-clear 6 -1 1)))
(check-tail-exn range-exception? (lambda () (bit-field-clear 6 2 1)))
(check-eqv? (bit-field-clear 42 1 4) 32)

(check-tail-exn type-exception? (lambda () (bit-field-set 6 0 'a)))
(check-tail-exn type-exception? (lambda () (bit-field-set 6 'a 1)))
(check-tail-exn type-exception? (lambda () (bit-field-set 'a 0 1)))
(check-tail-exn range-exception? (lambda () (bit-field-set 6 0 -1)))
(check-tail-exn range-exception? (lambda () (bit-field-set 6 -1 1)))
(check-tail-exn range-exception? (lambda () (bit-field-set 6 2 1)))
(check-eqv? (bit-field-set 42 1 4) 46)

(check-tail-exn type-exception? (lambda () (bit-field-replace 'a 1 0 1)))
(check-tail-exn type-exception? (lambda () (bit-field-replace 6 'a 0 1)))
(check-tail-exn type-exception? (lambda () (bit-field-replace 6 1 'a 1)))
(check-tail-exn type-exception? (lambda () (bit-field-replace 6 1 0 'a)))
(check-tail-exn range-exception? (lambda () (bit-field-replace 6 1 -1 1)))
(check-tail-exn range-exception? (lambda () (bit-field-replace 6 1 0 -1)))
(check-tail-exn range-exception? (lambda () (bit-field-replace 6 1 2 1)))
(check-eqv? (bit-field-replace 6 1 0 1) 7)
(check-eqv? (bit-field-replace 6 1 1 2) 6)
(check-eqv? (bit-field-replace 6 1 1 3) 2)
(check-eqv? (bit-field-replace 42 2 1 4) 36)

(check-tail-exn type-exception? (lambda () (bit-field-replace-same 'a 1 0 1)))
(check-tail-exn type-exception? (lambda () (bit-field-replace-same 6 'a 0 1)))
(check-tail-exn type-exception? (lambda () (bit-field-replace-same 6 1 'a 1)))
(check-tail-exn type-exception? (lambda () (bit-field-replace-same 6 1 0 'a)))
(check-tail-exn range-exception? (lambda () (bit-field-replace-same 6 1 -1 1)))
(check-tail-exn range-exception? (lambda () (bit-field-replace-same 6 1 0 -1)))
(check-tail-exn range-exception? (lambda () (bit-field-replace-same 6 1 2 1)))
(check-eqv? (bit-field-replace-same 15 0 1 3) 9)


(check-tail-exn type-exception? (lambda () (bit-field-rotate 'a 0 0 10)))
(check-tail-exn type-exception? (lambda () (bit-field-rotate #b110 'a 0 10)))
(check-tail-exn type-exception? (lambda () (bit-field-rotate #b110 0 'a 10)))
(check-tail-exn type-exception? (lambda () (bit-field-rotate #b110 0 0 'a)))
(check-tail-exn range-exception? (lambda () (bit-field-rotate #b110 0 -1 10)))
(check-tail-exn range-exception? (lambda () (bit-field-rotate #b110 0 0 -1)))
(check-tail-exn range-exception? (lambda () (bit-field-rotate #b110 0 2 1)))
(check-eqv? (bit-field-rotate #b110 0 0 10)  #b110)
(check-eqv? (bit-field-rotate #b110 0 0 256)  #b110)
(check-eqv? (bit-field-rotate #x100000000000000000000000000000000 1 0 129)  1)
(check-eqv? (bit-field-rotate #b110 1 1 2)  #b110)
(check-eqv? (bit-field-rotate #b110 1 2 4)  #b1010)
(check-eqv? (bit-field-rotate #b0111 -1 1 4)  #b1011)


(check-tail-exn type-exception? (lambda () (bit-field-reverse 'a 1 4)))
(check-tail-exn type-exception? (lambda () (bit-field-reverse 6 'a 4)))
(check-tail-exn type-exception? (lambda () (bit-field-reverse 6 1 'a)))
(check-tail-exn range-exception? (lambda () (bit-field-reverse 6 -1 3)))
(check-tail-exn range-exception? (lambda () (bit-field-reverse 6 1 -1)))
(check-tail-exn range-exception? (lambda () (bit-field-reverse 6 3 1)))
(check-eqv? (bit-field-reverse 6 1 3)  6)
(check-eqv? (bit-field-reverse 6 1 4)  12)
(check-eqv? (bit-field-reverse 1 0 32)  #x80000000)
(check-eqv? (bit-field-reverse 1 0 31)  #x40000000)
(check-eqv? (bit-field-reverse 1 0 30)  #x20000000)
(check-eqv? (bit-field-reverse #x140000000000000000000000000000000 0 129)  5)

(check-tail-exn type-exception? (lambda () (bitwise-fold 'a '() #b1010111)))
(check-tail-exn type-exception? (lambda () (bitwise-fold cons '() 'a)))
(check-equal? (bitwise-fold cons '() #b1010111) '(#t #f #t #f #t #t #t))

(check-tail-exn type-exception? (lambda () (bitwise-for-each 'a #b1010111)))
(check-tail-exn type-exception? (lambda () (bitwise-for-each (lambda (b) #t) 'a)))
(check-eqv? (let ((count 0))
              (bitwise-for-each (lambda (b) (if b (set! count (+ count 1))))
                                #b1010111)
              count)
            5)

(check-tail-exn type-exception? (lambda ()
                                  (bitwise-unfold 'a
                                                  even?
                                                  (lambda (i) (+ i 1))
                                                  0)))
(check-tail-exn type-exception? (lambda ()
                                  (bitwise-unfold (lambda (i) (= i 10))
                                                  'a
                                                  (lambda (i) (+ i 1))
                                                  0)))(check-tail-exn type-exception? (lambda ()
                                  (bitwise-unfold (lambda (i) (= i 10))
                                                  even?
                                                  'a
                                                  0)))
(check-eqv? (bitwise-unfold (lambda (i) (= i 10))
                            even?
                            (lambda (i) (+ i 1))
                            0)
            #b101010101)

(check-tail-exn type-exception? (lambda () (make-bitwise-generator 1.)))
(let ((g (make-bitwise-generator #b110)))
  (check-eqv? (g) #f)
  (check-eqv? (g) #t)
  (check-eqv? (g) #t)
  (check-eqv? (g) #f))

;;;------------------------------------------------------------
;;; End of tests for the remainder of SRFI 151 routines
;;;------------------------------------------------------------

(if (##use-fast-bignum-algorithms?)
    (check-eqv? (expt 15 1000000) (* (expt 3 1000000) (expt 5 1000000))))

(check-eqv? (+ 1 1) 2)
(check-eqv? (+ 1 1267650600228229401496703205376) 1267650600228229401496703205377)
(check-eqv? (+ 1 1/2) 3/2)
(check-eqv? (+ 1 1.) 2.)
(check-eqv? (+ 1 1+i) 2+i)
(check-eqv? (+ 1267650600228229401496703205376 1) 1267650600228229401496703205377)
(check-eqv? (+ 1267650600228229401496703205376 1267650600228229401496703205376) 2535301200456458802993406410752)
(check-eqv? (+ 1267650600228229401496703205376 1/2) 2535301200456458802993406410753/2)
(check-eqv? (+ 1267650600228229401496703205376 1.) 1.2676506002282294e30)
(check-eqv? (+ 1267650600228229401496703205376 1+i) 1267650600228229401496703205377+i)
(check-eqv? (+ 1/2 1) 3/2)
(check-eqv? (+ 1/2 1267650600228229401496703205376) 2535301200456458802993406410753/2)
(check-eqv? (+ 1/2 1/2) 1)
(check-eqv? (+ 1/2 1.) 1.5)
(check-eqv? (+ 1/2 1+i) 3/2+i)
(check-eqv? (+ 1. 1) 2.)
(check-eqv? (+ 1. 1267650600228229401496703205376) 1.2676506002282294e30)
(check-eqv? (+ 1. 1/2) 1.5)
(check-eqv? (+ 1. 1.) 2.)
(check-eqv? (+ 1. 1+i) 2.+i)
(check-eqv? (+ 1+i 1) 2+i)
(check-eqv? (+ 1+i 1267650600228229401496703205376) 1267650600228229401496703205377+i)
(check-eqv? (+ 1+i 1/2) 3/2+i)
(check-eqv? (+ 1+i 1.) 2.+i)
(check-eqv? (+ 1+i 1+i) 2+2i)
(if (eqv? 0 (* 0 0.0))   ;; These tests exercise (macro-special-case-exact-zero?)
    (begin
      (check-eqv? (+ -0.0i 0) -0.0i)
      (check-eqv? (+ 0 -0.0) -0.0)))

(check-eqv? (- 1 1) 0)
(check-eqv? (- 1 1267650600228229401496703205376) -1267650600228229401496703205375)
(check-eqv? (- 1 1/2) 1/2)
(check-eqv? (- 1 1.) 0.)
(check-eqv? (- 1 1+i) -i)
(check-eqv? (- 1267650600228229401496703205376 1) 1267650600228229401496703205375)
(check-eqv? (- 1267650600228229401496703205376 1267650600228229401496703205376) 0)
(check-eqv? (- 1267650600228229401496703205376 1/2) 2535301200456458802993406410751/2)
(check-eqv? (- 1267650600228229401496703205376 1.) 1.2676506002282294e30)
(check-eqv? (- 1267650600228229401496703205376 1+i) 1267650600228229401496703205375-i)
(check-eqv? (- 1/2 1) -1/2)
(check-eqv? (- 1/2 1267650600228229401496703205376) -2535301200456458802993406410751/2)
(check-eqv? (- 1/2 1/2) 0)
(check-eqv? (- 1/2 1.) -.5)
(check-eqv? (- 1/2 1+i) -1/2-i)
(check-eqv? (- 1. 1) 0.)
(check-eqv? (- 1. 1267650600228229401496703205376) -1.2676506002282294e30)
(check-eqv? (- 1. 1/2) .5)
(check-eqv? (- 1. 1.) 0.)
(check-eqv? (- 1. 1+i) 0.-i)
(check-eqv? (- 1+i 1) +i)
(check-eqv? (- 1+i 1267650600228229401496703205376) -1267650600228229401496703205375+i)
(check-eqv? (- 1+i 1/2) 1/2+i)
(check-eqv? (- 1+i 1.) 0.+i)
(check-eqv? (- 1+i 1+i) 0)

(check-eqv? (* 1 1) 1)
(check-eqv? (* 1 1267650600228229401496703205376) 1267650600228229401496703205376)
(check-eqv? (* 1 1/2) 1/2)
(check-eqv? (* 1 1.) 1.)
(check-eqv? (* 1 1+i) 1+i)
(check-eqv? (* 1267650600228229401496703205376 1) 1267650600228229401496703205376)
(check-eqv? (* 1267650600228229401496703205376 1267650600228229401496703205376) 1606938044258990275541962092341162602522202993782792835301376)
(check-eqv? (* 1267650600228229401496703205376 1/2) 633825300114114700748351602688)
(check-eqv? (* 1267650600228229401496703205376 1.) 1.2676506002282294e30)
(check-eqv? (* 1267650600228229401496703205376 1+i) 1267650600228229401496703205376+1267650600228229401496703205376i)
(check-eqv? (* 1/2 1) 1/2)
(check-eqv? (* 1/2 1267650600228229401496703205376) 633825300114114700748351602688)
(check-eqv? (* 1/2 1/2) 1/4)
(check-eqv? (* 1/2 1.) .5)
(check-eqv? (* 1/2 1+i) 1/2+1/2i)
(check-eqv? (* 1. 1) 1.)
(check-eqv? (* 1. 1267650600228229401496703205376) 1.2676506002282294e30)
(check-eqv? (* 1. 1/2) .5)
(check-eqv? (* 1. 1.) 1.)
(check-eqv? (* 1. 1+i) 1.+1.i)
(check-eqv? (* 1+i 1) 1+i)
(check-eqv? (* 1+i 1267650600228229401496703205376) 1267650600228229401496703205376+1267650600228229401496703205376i)
(check-eqv? (* 1+i 1/2) 1/2+1/2i)
(check-eqv? (* 1+i 1.) 1.+1.i)
(check-eqv? (* 1+i 1+i) +2i)
(if (eqv? 0 (* 0 0.0))     ;; These tests exercise (macro-special-case-exact-zero?)
    (begin
      (check-eqv? (* 4.-0.i 2.) 8.-0.i)
      (check-eqv? (* 4.0 0) 0)))

(let ((arg 1)) (check-equal? arg (* 1 arg)))
(let ((arg 1)) (check-equal? arg (* arg 1)))
(let ((arg 1)) (check-equal? arg (+ 0 arg)))
(let ((arg 1)) (check-equal? arg (+ arg 0)))
(let ((arg 1)) (check-equal? arg (/ arg 1)))
(let ((arg 1)) (check-equal? arg (- arg 0)))
(let ((arg 1267650600228229401496703205376)) (check-equal? arg (* 1 arg)))
(let ((arg 1267650600228229401496703205376)) (check-equal? arg (* arg 1)))
(let ((arg 1267650600228229401496703205376)) (check-equal? arg (+ 0 arg)))
(let ((arg 1267650600228229401496703205376)) (check-equal? arg (+ arg 0)))
(let ((arg 1267650600228229401496703205376)) (check-equal? arg (/ arg 1)))
(let ((arg 1267650600228229401496703205376)) (check-equal? arg (- arg 0)))
(let ((arg 1/2)) (check-equal? arg (* 1 arg)))
(let ((arg 1/2)) (check-equal? arg (* arg 1)))
(let ((arg 1/2)) (check-equal? arg (+ 0 arg)))
(let ((arg 1/2)) (check-equal? arg (+ arg 0)))
(let ((arg 1/2)) (check-equal? arg (/ arg 1)))
(let ((arg 1/2)) (check-equal? arg (- arg 0)))
(let ((arg 1.)) (check-equal? arg (* 1 arg)))
(let ((arg 1.)) (check-equal? arg (* arg 1)))
(let ((arg 1.)) (check-equal? arg (+ 0 arg)))
(let ((arg 1.)) (check-equal? arg (+ arg 0)))
(let ((arg 1.)) (check-equal? arg (/ arg 1)))
(let ((arg 1.)) (check-equal? arg (- arg 0)))
(let ((arg 1+i)) (check-equal? arg (* 1 arg)))
(let ((arg 1+i)) (check-equal? arg (* arg 1)))
(let ((arg 1+i)) (check-equal? arg (+ 0 arg)))
(let ((arg 1+i)) (check-equal? arg (+ arg 0)))
(let ((arg 1+i)) (check-equal? arg (/ arg 1)))
(let ((arg 1+i)) (check-equal? arg (- arg 0)))

(check-tail-exn divide-by-zero-exception? (lambda () (/ 1 0)))
(check-tail-exn divide-by-zero-exception? (lambda () (/ 1267650600228229401496703205376 0)))
(check-tail-exn divide-by-zero-exception? (lambda () (/ 1/2 0)))
(check-tail-exn divide-by-zero-exception? (lambda () (/ 1. 0)))
(check-tail-exn divide-by-zero-exception? (lambda () (/ 1+i 0)))

(check-eqv? (+ ##max-fixnum 1) `,(+ ##max-fixnum 1))
(check-eqv? (+ 1 ##max-fixnum) `,(+ 1 ##max-fixnum))
(check-eqv? (* ##max-fixnum 2) `,(* ##max-fixnum 2))
(check-eqv? (* 2 ##max-fixnum) `,(* 2 ##max-fixnum))
(check-eqv? (- ##min-fixnum 1) `,(- ##min-fixnum 1))
(check-eqv? (- ##min-fixnum) `,(+ ##max-fixnum 1))

;;; I should include the programs to generate the arguments to the
;;; next tests
#;
(let ()

  ;; These are designed so that (a) each one is exactly representable
  ;; and (b) their sum, difference and product are exactly representable
  ;; But we need to check that.

  ;; Division (/) needs something different, which I'll work out later

  ;; This is incorrect, the result is not a ratnum.

     (define operands `(1             ; fixnum
			,(expt 2 70)  ; bignum
			3/4           ; ratnum
			,(expt 2. 35) ; flonum
			1+i           ; cpxnum
			))

  (for-each (lambda (op op-name)
	      (for-each (lambda (x)
			  (for-each (lambda (y)
				      ;; first check result is exactly representable
				      (for-each display (list "(check-=    ("
							      op-name
							      " "
							      x
							      " "
							      y
							      ") "
							      (op (inexact->exact x) (inexact->exact y))
							      ")\n"
							      ))
				      ;; then check result is eqv? (includes inexactness check)
				      (for-each display (list "(check-eqv? ("
							      op-name
							      " "
							      x
							      " "
							      y
							      ") "
							      (op x y)
							      ")\n"
							      ))
				      )
				    operands))
			operands)
	      
	      )
	    (list + - *) '(+ - *))

  )

(check-=    (+ 1 1) 2)
(check-eqv? (+ 1 1) 2)
(check-=    (+ 1 1180591620717411303424) 1180591620717411303425)
(check-eqv? (+ 1 1180591620717411303424) 1180591620717411303425)
(check-=    (+ 1 3/4) 7/4)
(check-eqv? (+ 1 3/4) 7/4)
(check-=    (+ 1 3.4359738368e10) 34359738369)
(check-eqv? (+ 1 3.4359738368e10) 3.4359738369e10)
(check-=    (+ 1 1+i) 2+i)
(check-eqv? (+ 1 1+i) 2+i)
(check-=    (+ 1180591620717411303424 1) 1180591620717411303425)
(check-eqv? (+ 1180591620717411303424 1) 1180591620717411303425)
(check-=    (+ 1180591620717411303424 1180591620717411303424) 2361183241434822606848)
(check-eqv? (+ 1180591620717411303424 1180591620717411303424) 2361183241434822606848)
(check-=    (+ 1180591620717411303424 3/4) 4722366482869645213699/4)
(check-eqv? (+ 1180591620717411303424 3/4) 4722366482869645213699/4)
(check-=    (+ 1180591620717411303424 3.4359738368e10) 1180591620751771041792)
(check-eqv? (+ 1180591620717411303424 3.4359738368e10) 1.180591620751771e21)
(check-=    (+ 1180591620717411303424 1+i) 1180591620717411303425+i)
(check-eqv? (+ 1180591620717411303424 1+i) 1180591620717411303425+i)
(check-=    (+ 3/4 1) 7/4)
(check-eqv? (+ 3/4 1) 7/4)
(check-=    (+ 3/4 1180591620717411303424) 4722366482869645213699/4)
(check-eqv? (+ 3/4 1180591620717411303424) 4722366482869645213699/4)
(check-=    (+ 3/4 3/4) 3/2)
(check-eqv? (+ 3/4 3/4) 3/2)
(check-=    (+ 3/4 3.4359738368e10) 137438953475/4)
(check-eqv? (+ 3/4 3.4359738368e10) 3.435973836875e10)
(check-=    (+ 3/4 1+i) 7/4+i)
(check-eqv? (+ 3/4 1+i) 7/4+i)
(check-=    (+ 3.4359738368e10 1) 34359738369)
(check-eqv? (+ 3.4359738368e10 1) 3.4359738369e10)
(check-=    (+ 3.4359738368e10 1180591620717411303424) 1180591620751771041792)
(check-eqv? (+ 3.4359738368e10 1180591620717411303424) 1.180591620751771e21)
(check-=    (+ 3.4359738368e10 3/4) 137438953475/4)
(check-eqv? (+ 3.4359738368e10 3/4) 3.435973836875e10)
(check-=    (+ 3.4359738368e10 3.4359738368e10) 68719476736)
(check-eqv? (+ 3.4359738368e10 3.4359738368e10) 6.8719476736e10)
(check-=    (+ 3.4359738368e10 1+i) 34359738369+i)
(check-eqv? (+ 3.4359738368e10 1+i) 3.4359738369e10+i)
(check-=    (+ 1+i 1) 2+i)
(check-eqv? (+ 1+i 1) 2+i)
(check-=    (+ 1+i 1180591620717411303424) 1180591620717411303425+i)
(check-eqv? (+ 1+i 1180591620717411303424) 1180591620717411303425+i)
(check-=    (+ 1+i 3/4) 7/4+i)
(check-eqv? (+ 1+i 3/4) 7/4+i)
(check-=    (+ 1+i 3.4359738368e10) 34359738369+i)
(check-eqv? (+ 1+i 3.4359738368e10) 3.4359738369e10+i)
(check-=    (+ 1+i 1+i) 2+2i)
(check-eqv? (+ 1+i 1+i) 2+2i)
(check-=    (- 1 1) 0)
(check-eqv? (- 1 1) 0)
(check-=    (- 1 1180591620717411303424) -1180591620717411303423)
(check-eqv? (- 1 1180591620717411303424) -1180591620717411303423)
(check-=    (- 1 3/4) 1/4)
(check-eqv? (- 1 3/4) 1/4)
(check-=    (- 1 3.4359738368e10) -34359738367)
(check-eqv? (- 1 3.4359738368e10) -3.4359738367e10)
(check-=    (- 1 1+i) -i)
(check-eqv? (- 1 1+i) -i)
(check-=    (- 1180591620717411303424 1) 1180591620717411303423)
(check-eqv? (- 1180591620717411303424 1) 1180591620717411303423)
(check-=    (- 1180591620717411303424 1180591620717411303424) 0)
(check-eqv? (- 1180591620717411303424 1180591620717411303424) 0)
(check-=    (- 1180591620717411303424 3/4) 4722366482869645213693/4)
(check-eqv? (- 1180591620717411303424 3/4) 4722366482869645213693/4)
(check-=    (- 1180591620717411303424 3.4359738368e10) 1180591620683051565056)
(check-eqv? (- 1180591620717411303424 3.4359738368e10) 1.1805916206830516e21)
(check-=    (- 1180591620717411303424 1+i) 1180591620717411303423-i)
(check-eqv? (- 1180591620717411303424 1+i) 1180591620717411303423-i)
(check-=    (- 3/4 1) -1/4)
(check-eqv? (- 3/4 1) -1/4)
(check-=    (- 3/4 1180591620717411303424) -4722366482869645213693/4)
(check-eqv? (- 3/4 1180591620717411303424) -4722366482869645213693/4)
(check-=    (- 3/4 3/4) 0)
(check-eqv? (- 3/4 3/4) 0)
(check-=    (- 3/4 3.4359738368e10) -137438953469/4)
(check-eqv? (- 3/4 3.4359738368e10) -3.435973836725e10)
(check-=    (- 3/4 1+i) -1/4-i)
(check-eqv? (- 3/4 1+i) -1/4-i)
(check-=    (- 3.4359738368e10 1) 34359738367)
(check-eqv? (- 3.4359738368e10 1) 3.4359738367e10)
(check-=    (- 3.4359738368e10 1180591620717411303424) -1180591620683051565056)
(check-eqv? (- 3.4359738368e10 1180591620717411303424) -1.1805916206830516e21)
(check-=    (- 3.4359738368e10 3/4) 137438953469/4)
(check-eqv? (- 3.4359738368e10 3/4) 3.435973836725e10)
(check-=    (- 3.4359738368e10 3.4359738368e10) 0)
(check-eqv? (- 3.4359738368e10 3.4359738368e10) 0.)
(check-=    (- 3.4359738368e10 1+i) 34359738367-i)
(check-eqv? (- 3.4359738368e10 1+i) 3.4359738367e10-i)
(check-=    (- 1+i 1) +i)
(check-eqv? (- 1+i 1) +i)
(check-=    (- 1+i 1180591620717411303424) -1180591620717411303423+i)
(check-eqv? (- 1+i 1180591620717411303424) -1180591620717411303423+i)
(check-=    (- 1+i 3/4) 1/4+i)
(check-eqv? (- 1+i 3/4) 1/4+i)
(check-=    (- 1+i 3.4359738368e10) -34359738367+i)
(check-eqv? (- 1+i 3.4359738368e10) -3.4359738367e10+i)
(check-=    (- 1+i 1+i) 0)
(check-eqv? (- 1+i 1+i) 0)
(check-=    (* 1 1) 1)
(check-eqv? (* 1 1) 1)
(check-=    (* 1 1180591620717411303424) 1180591620717411303424)
(check-eqv? (* 1 1180591620717411303424) 1180591620717411303424)
(check-=    (* 1 3/4) 3/4)
(check-eqv? (* 1 3/4) 3/4)
(check-=    (* 1 3.4359738368e10) 34359738368)
(check-eqv? (* 1 3.4359738368e10) 3.4359738368e10)
(check-=    (* 1 1+i) 1+i)
(check-eqv? (* 1 1+i) 1+i)
(check-=    (* 1180591620717411303424 1) 1180591620717411303424)
(check-eqv? (* 1180591620717411303424 1) 1180591620717411303424)
(check-=    (* 1180591620717411303424 1180591620717411303424) 1393796574908163946345982392040522594123776)
(check-eqv? (* 1180591620717411303424 1180591620717411303424) 1393796574908163946345982392040522594123776)
(check-=    (* 1180591620717411303424 3/4) 885443715538058477568)
(check-eqv? (* 1180591620717411303424 3/4) 885443715538058477568)
(check-=    (* 1180591620717411303424 3.4359738368e10) 40564819207303340847894502572032)
(check-eqv? (* 1180591620717411303424 3.4359738368e10) 4.056481920730334e31)
(check-=    (* 1180591620717411303424 1+i) 1180591620717411303424+1180591620717411303424i)
(check-eqv? (* 1180591620717411303424 1+i) 1180591620717411303424+1180591620717411303424i)
(check-=    (* 3/4 1) 3/4)
(check-eqv? (* 3/4 1) 3/4)
(check-=    (* 3/4 1180591620717411303424) 885443715538058477568)
(check-eqv? (* 3/4 1180591620717411303424) 885443715538058477568)
(check-=    (* 3/4 3/4) 9/16)
(check-eqv? (* 3/4 3/4) 9/16)
(check-=    (* 3/4 3.4359738368e10) 25769803776)
(check-eqv? (* 3/4 3.4359738368e10) 2.5769803776e10)
(check-=    (* 3/4 1+i) 3/4+3/4i)
(check-eqv? (* 3/4 1+i) 3/4+3/4i)
(check-=    (* 3.4359738368e10 1) 34359738368)
(check-eqv? (* 3.4359738368e10 1) 3.4359738368e10)
(check-=    (* 3.4359738368e10 1180591620717411303424) 40564819207303340847894502572032)
(check-eqv? (* 3.4359738368e10 1180591620717411303424) 4.056481920730334e31)
(check-=    (* 3.4359738368e10 3/4) 25769803776)
(check-eqv? (* 3.4359738368e10 3/4) 2.5769803776e10)
(check-=    (* 3.4359738368e10 3.4359738368e10) 1180591620717411303424)
(check-eqv? (* 3.4359738368e10 3.4359738368e10) 1.1805916207174113e21)
(check-=    (* 3.4359738368e10 1+i) 34359738368+34359738368i)
(check-eqv? (* 3.4359738368e10 1+i) 3.4359738368e10+3.4359738368e10i)
(check-=    (* 1+i 1) 1+i)
(check-eqv? (* 1+i 1) 1+i)
(check-=    (* 1+i 1180591620717411303424) 1180591620717411303424+1180591620717411303424i)
(check-eqv? (* 1+i 1180591620717411303424) 1180591620717411303424+1180591620717411303424i)
(check-=    (* 1+i 3/4) 3/4+3/4i)
(check-eqv? (* 1+i 3/4) 3/4+3/4i)
(check-=    (* 1+i 3.4359738368e10) 34359738368+34359738368i)
(check-eqv? (* 1+i 3.4359738368e10) 3.4359738368e10+3.4359738368e10i)
(check-=    (* 1+i 1+i) +2i)
(check-eqv? (* 1+i 1+i) +2i)


#;(let ()

  (define (make-symbol . args)
    (string->symbol (apply string-append (map (lambda (x) (if (symbol? x) (symbol->string x) x)) args))))

  (let ((ns (list (random-integer (expt 2 400))
		  (- (random-integer (expt 2 400)))
		  (random-integer ##max-fixnum)
		  (- (random-integer ##max-fixnum))))
	(sizes (list (random-integer 200)
		     (random-integer 20)))
	(positions (list (random-integer 200)
			 (random-integer 20))))
    (for-each (lambda (op-name)
		(for-each (lambda (n)
			    (for-each (lambda (size)
					(for-each (lambda (position)
						    (for-each display (list "(check-eqv? ("
									    op-name
									    " "
									    size
									    " "
									    position
									    " "
									    n
									    ") ("
									    (make-symbol 'test- op-name)
									    " "
									    size
									    " "
									    position
									    " "
									    n
									    "))\n")))
									    
						  positions))
				      sizes))
			  ns))
	      '(extract-bit-field test-bit-field? clear-bit-field))
    ))

(check-eqv? (extract-bit-field 79 109 819289025694944586759318860605577375432306836892969486208725872284023634378009092711199478706560747106627062245621894261)
            (test-extract-bit-field 79 109 819289025694944586759318860605577375432306836892969486208725872284023634378009092711199478706560747106627062245621894261))
(check-eqv? (extract-bit-field 79 13 819289025694944586759318860605577375432306836892969486208725872284023634378009092711199478706560747106627062245621894261)
            (test-extract-bit-field 79 13 819289025694944586759318860605577375432306836892969486208725872284023634378009092711199478706560747106627062245621894261))
(check-eqv? (extract-bit-field 4 109 819289025694944586759318860605577375432306836892969486208725872284023634378009092711199478706560747106627062245621894261)
            (test-extract-bit-field 4 109 819289025694944586759318860605577375432306836892969486208725872284023634378009092711199478706560747106627062245621894261))
(check-eqv? (extract-bit-field 4 13 819289025694944586759318860605577375432306836892969486208725872284023634378009092711199478706560747106627062245621894261)
            (test-extract-bit-field 4 13 819289025694944586759318860605577375432306836892969486208725872284023634378009092711199478706560747106627062245621894261))
(check-eqv? (extract-bit-field 79 109 -2560481503630520084802251286722070556183711270103420284967696348412255744250015987909211821032873931231996971794614933942)
            (test-extract-bit-field 79 109 -2560481503630520084802251286722070556183711270103420284967696348412255744250015987909211821032873931231996971794614933942))
(check-eqv? (extract-bit-field 79 13 -2560481503630520084802251286722070556183711270103420284967696348412255744250015987909211821032873931231996971794614933942)
            (test-extract-bit-field 79 13 -2560481503630520084802251286722070556183711270103420284967696348412255744250015987909211821032873931231996971794614933942))
(check-eqv? (extract-bit-field 4 109 -2560481503630520084802251286722070556183711270103420284967696348412255744250015987909211821032873931231996971794614933942)
            (test-extract-bit-field 4 109 -2560481503630520084802251286722070556183711270103420284967696348412255744250015987909211821032873931231996971794614933942))
(check-eqv? (extract-bit-field 4 13 -2560481503630520084802251286722070556183711270103420284967696348412255744250015987909211821032873931231996971794614933942)
            (test-extract-bit-field 4 13 -2560481503630520084802251286722070556183711270103420284967696348412255744250015987909211821032873931231996971794614933942))
(check-eqv? (extract-bit-field 79 109 103713854486608146) (test-extract-bit-field 79 109 103713854486608146))
(check-eqv? (extract-bit-field 79 13 103713854486608146) (test-extract-bit-field 79 13 103713854486608146))
(check-eqv? (extract-bit-field 4 109 103713854486608146) (test-extract-bit-field 4 109 103713854486608146))
(check-eqv? (extract-bit-field 4 13 103713854486608146) (test-extract-bit-field 4 13 103713854486608146))
(check-eqv? (extract-bit-field 79 109 -608462309321751311) (test-extract-bit-field 79 109 -608462309321751311))
(check-eqv? (extract-bit-field 79 13 -608462309321751311) (test-extract-bit-field 79 13 -608462309321751311))
(check-eqv? (extract-bit-field 4 109 -608462309321751311) (test-extract-bit-field 4 109 -608462309321751311))
(check-eqv? (extract-bit-field 4 13 -608462309321751311) (test-extract-bit-field 4 13 -608462309321751311))
(check-eqv? (test-bit-field? 79 109 819289025694944586759318860605577375432306836892969486208725872284023634378009092711199478706560747106627062245621894261)
            (test-test-bit-field? 79 109 819289025694944586759318860605577375432306836892969486208725872284023634378009092711199478706560747106627062245621894261))
(check-eqv? (test-bit-field? 79 13 819289025694944586759318860605577375432306836892969486208725872284023634378009092711199478706560747106627062245621894261)
            (test-test-bit-field? 79 13 819289025694944586759318860605577375432306836892969486208725872284023634378009092711199478706560747106627062245621894261))
(check-eqv? (test-bit-field? 4 109 819289025694944586759318860605577375432306836892969486208725872284023634378009092711199478706560747106627062245621894261)
            (test-test-bit-field? 4 109 819289025694944586759318860605577375432306836892969486208725872284023634378009092711199478706560747106627062245621894261))
(check-eqv? (test-bit-field? 4 13 819289025694944586759318860605577375432306836892969486208725872284023634378009092711199478706560747106627062245621894261)
            (test-test-bit-field? 4 13 819289025694944586759318860605577375432306836892969486208725872284023634378009092711199478706560747106627062245621894261))
(check-eqv? (test-bit-field? 79 109 -2560481503630520084802251286722070556183711270103420284967696348412255744250015987909211821032873931231996971794614933942)
            (test-test-bit-field? 79 109 -2560481503630520084802251286722070556183711270103420284967696348412255744250015987909211821032873931231996971794614933942))
(check-eqv? (test-bit-field? 79 13 -2560481503630520084802251286722070556183711270103420284967696348412255744250015987909211821032873931231996971794614933942)
            (test-test-bit-field? 79 13 -2560481503630520084802251286722070556183711270103420284967696348412255744250015987909211821032873931231996971794614933942))
(check-eqv? (test-bit-field? 4 109 -2560481503630520084802251286722070556183711270103420284967696348412255744250015987909211821032873931231996971794614933942)
            (test-test-bit-field? 4 109 -2560481503630520084802251286722070556183711270103420284967696348412255744250015987909211821032873931231996971794614933942))
(check-eqv? (test-bit-field? 4 13 -2560481503630520084802251286722070556183711270103420284967696348412255744250015987909211821032873931231996971794614933942)
            (test-test-bit-field? 4 13 -2560481503630520084802251286722070556183711270103420284967696348412255744250015987909211821032873931231996971794614933942))
(check-eqv? (test-bit-field? 79 109 103713854486608146) (test-test-bit-field? 79 109 103713854486608146))
(check-eqv? (test-bit-field? 79 13 103713854486608146) (test-test-bit-field? 79 13 103713854486608146))
(check-eqv? (test-bit-field? 4 109 103713854486608146) (test-test-bit-field? 4 109 103713854486608146))
(check-eqv? (test-bit-field? 4 13 103713854486608146) (test-test-bit-field? 4 13 103713854486608146))
(check-eqv? (test-bit-field? 79 109 -608462309321751311) (test-test-bit-field? 79 109 -608462309321751311))
(check-eqv? (test-bit-field? 79 13 -608462309321751311) (test-test-bit-field? 79 13 -608462309321751311))
(check-eqv? (test-bit-field? 4 109 -608462309321751311) (test-test-bit-field? 4 109 -608462309321751311))
(check-eqv? (test-bit-field? 4 13 -608462309321751311) (test-test-bit-field? 4 13 -608462309321751311))
(check-eqv? (clear-bit-field 79 109 819289025694944586759318860605577375432306836892969486208725872284023634378009092711199478706560747106627062245621894261)
            (test-clear-bit-field 79 109 819289025694944586759318860605577375432306836892969486208725872284023634378009092711199478706560747106627062245621894261))
(check-eqv? (clear-bit-field 79 13 819289025694944586759318860605577375432306836892969486208725872284023634378009092711199478706560747106627062245621894261)
            (test-clear-bit-field 79 13 819289025694944586759318860605577375432306836892969486208725872284023634378009092711199478706560747106627062245621894261))
(check-eqv? (clear-bit-field 4 109 819289025694944586759318860605577375432306836892969486208725872284023634378009092711199478706560747106627062245621894261)
            (test-clear-bit-field 4 109 819289025694944586759318860605577375432306836892969486208725872284023634378009092711199478706560747106627062245621894261))
(check-eqv? (clear-bit-field 4 13 819289025694944586759318860605577375432306836892969486208725872284023634378009092711199478706560747106627062245621894261)
            (test-clear-bit-field 4 13 819289025694944586759318860605577375432306836892969486208725872284023634378009092711199478706560747106627062245621894261))
(check-eqv? (clear-bit-field 79 109 -2560481503630520084802251286722070556183711270103420284967696348412255744250015987909211821032873931231996971794614933942)
            (test-clear-bit-field 79 109 -2560481503630520084802251286722070556183711270103420284967696348412255744250015987909211821032873931231996971794614933942))
(check-eqv? (clear-bit-field 79 13 -2560481503630520084802251286722070556183711270103420284967696348412255744250015987909211821032873931231996971794614933942)
            (test-clear-bit-field 79 13 -2560481503630520084802251286722070556183711270103420284967696348412255744250015987909211821032873931231996971794614933942))
(check-eqv? (clear-bit-field 4 109 -2560481503630520084802251286722070556183711270103420284967696348412255744250015987909211821032873931231996971794614933942)
            (test-clear-bit-field 4 109 -2560481503630520084802251286722070556183711270103420284967696348412255744250015987909211821032873931231996971794614933942))
(check-eqv? (clear-bit-field 4 13 -2560481503630520084802251286722070556183711270103420284967696348412255744250015987909211821032873931231996971794614933942)
            (test-clear-bit-field 4 13 -2560481503630520084802251286722070556183711270103420284967696348412255744250015987909211821032873931231996971794614933942))
(check-eqv? (clear-bit-field 79 109 103713854486608146) (test-clear-bit-field 79 109 103713854486608146))
(check-eqv? (clear-bit-field 79 13 103713854486608146) (test-clear-bit-field 79 13 103713854486608146))
(check-eqv? (clear-bit-field 4 109 103713854486608146) (test-clear-bit-field 4 109 103713854486608146))
(check-eqv? (clear-bit-field 4 13 103713854486608146) (test-clear-bit-field 4 13 103713854486608146))
(check-eqv? (clear-bit-field 79 109 -608462309321751311) (test-clear-bit-field 79 109 -608462309321751311))
(check-eqv? (clear-bit-field 79 13 -608462309321751311) (test-clear-bit-field 79 13 -608462309321751311))
(check-eqv? (clear-bit-field 4 109 -608462309321751311) (test-clear-bit-field 4 109 -608462309321751311))
(check-eqv? (clear-bit-field 4 13 -608462309321751311) (test-clear-bit-field 4 13 -608462309321751311))

;;; extract-bit-field

;;; Now some ad-hoc tests with size and position bignums

(check-eqv? (extract-bit-field 4 (expt 2 100) -1) 15)
(check-eqv? (extract-bit-field (expt 2 100) 0 15) 15)
(check-eqv? (extract-bit-field (expt 2 100) (expt 3 100) 15) 0)

;;; Have size be bigger than (integer-length x)

(check-eqv? (extract-bit-field 200 0 (expt 3 110)) (expt 3 110))

;;; This is a quality of implementation test:

(let ((x (expt 3 110)))
  (check-eq? (extract-bit-field 200 0 x) x))

;;; Some error tests.

;;; heap-overflow-exception? doesn't seem to exist in the universal back end.
;;; (check-exn heap-overflow-exception? (lambda () (extract-bit-field (expt 2 100) (expt 2 100) -1)))

(check-tail-exn type-exception? (lambda () (extract-bit-field -1 1 1)))
(check-tail-exn type-exception? (lambda () (extract-bit-field 1 -1 1)))
(check-tail-exn type-exception? (lambda () (extract-bit-field 'a 1 1)))
(check-tail-exn type-exception? (lambda () (extract-bit-field 1 'a 1)))
(check-tail-exn type-exception? (lambda () (extract-bit-field 1 1 'a)))

;;; test-bit-field

;;; Some ad-hoc tests

#| The following was generated with:

(for-each (lambda (n)
            (for-each (lambda (size)
                        (for-each (lambda (position)
                                    (pp `(check-eqv? (test-bit-field?      ,size ,position ,n)
                                                     (test-test-bit-field? ,size ,position ,n))))
                                  (iota 3 0)))
                      (iota 3 1)))
          (iota 9 -4))
|#

(check-eqv? (test-bit-field? 1 0 -4) (test-test-bit-field? 1 0 -4))
(check-eqv? (test-bit-field? 1 1 -4) (test-test-bit-field? 1 1 -4))
(check-eqv? (test-bit-field? 1 2 -4) (test-test-bit-field? 1 2 -4))
(check-eqv? (test-bit-field? 2 0 -4) (test-test-bit-field? 2 0 -4))
(check-eqv? (test-bit-field? 2 1 -4) (test-test-bit-field? 2 1 -4))
(check-eqv? (test-bit-field? 2 2 -4) (test-test-bit-field? 2 2 -4))
(check-eqv? (test-bit-field? 3 0 -4) (test-test-bit-field? 3 0 -4))
(check-eqv? (test-bit-field? 3 1 -4) (test-test-bit-field? 3 1 -4))
(check-eqv? (test-bit-field? 3 2 -4) (test-test-bit-field? 3 2 -4))
(check-eqv? (test-bit-field? 1 0 -3) (test-test-bit-field? 1 0 -3))
(check-eqv? (test-bit-field? 1 1 -3) (test-test-bit-field? 1 1 -3))
(check-eqv? (test-bit-field? 1 2 -3) (test-test-bit-field? 1 2 -3))
(check-eqv? (test-bit-field? 2 0 -3) (test-test-bit-field? 2 0 -3))
(check-eqv? (test-bit-field? 2 1 -3) (test-test-bit-field? 2 1 -3))
(check-eqv? (test-bit-field? 2 2 -3) (test-test-bit-field? 2 2 -3))
(check-eqv? (test-bit-field? 3 0 -3) (test-test-bit-field? 3 0 -3))
(check-eqv? (test-bit-field? 3 1 -3) (test-test-bit-field? 3 1 -3))
(check-eqv? (test-bit-field? 3 2 -3) (test-test-bit-field? 3 2 -3))
(check-eqv? (test-bit-field? 1 0 -2) (test-test-bit-field? 1 0 -2))
(check-eqv? (test-bit-field? 1 1 -2) (test-test-bit-field? 1 1 -2))
(check-eqv? (test-bit-field? 1 2 -2) (test-test-bit-field? 1 2 -2))
(check-eqv? (test-bit-field? 2 0 -2) (test-test-bit-field? 2 0 -2))
(check-eqv? (test-bit-field? 2 1 -2) (test-test-bit-field? 2 1 -2))
(check-eqv? (test-bit-field? 2 2 -2) (test-test-bit-field? 2 2 -2))
(check-eqv? (test-bit-field? 3 0 -2) (test-test-bit-field? 3 0 -2))
(check-eqv? (test-bit-field? 3 1 -2) (test-test-bit-field? 3 1 -2))
(check-eqv? (test-bit-field? 3 2 -2) (test-test-bit-field? 3 2 -2))
(check-eqv? (test-bit-field? 1 0 -1) (test-test-bit-field? 1 0 -1))
(check-eqv? (test-bit-field? 1 1 -1) (test-test-bit-field? 1 1 -1))
(check-eqv? (test-bit-field? 1 2 -1) (test-test-bit-field? 1 2 -1))
(check-eqv? (test-bit-field? 2 0 -1) (test-test-bit-field? 2 0 -1))
(check-eqv? (test-bit-field? 2 1 -1) (test-test-bit-field? 2 1 -1))
(check-eqv? (test-bit-field? 2 2 -1) (test-test-bit-field? 2 2 -1))
(check-eqv? (test-bit-field? 3 0 -1) (test-test-bit-field? 3 0 -1))
(check-eqv? (test-bit-field? 3 1 -1) (test-test-bit-field? 3 1 -1))
(check-eqv? (test-bit-field? 3 2 -1) (test-test-bit-field? 3 2 -1))
(check-eqv? (test-bit-field? 1 0 0) (test-test-bit-field? 1 0 0))
(check-eqv? (test-bit-field? 1 1 0) (test-test-bit-field? 1 1 0))
(check-eqv? (test-bit-field? 1 2 0) (test-test-bit-field? 1 2 0))
(check-eqv? (test-bit-field? 2 0 0) (test-test-bit-field? 2 0 0))
(check-eqv? (test-bit-field? 2 1 0) (test-test-bit-field? 2 1 0))
(check-eqv? (test-bit-field? 2 2 0) (test-test-bit-field? 2 2 0))
(check-eqv? (test-bit-field? 3 0 0) (test-test-bit-field? 3 0 0))
(check-eqv? (test-bit-field? 3 1 0) (test-test-bit-field? 3 1 0))
(check-eqv? (test-bit-field? 3 2 0) (test-test-bit-field? 3 2 0))
(check-eqv? (test-bit-field? 1 0 1) (test-test-bit-field? 1 0 1))
(check-eqv? (test-bit-field? 1 1 1) (test-test-bit-field? 1 1 1))
(check-eqv? (test-bit-field? 1 2 1) (test-test-bit-field? 1 2 1))
(check-eqv? (test-bit-field? 2 0 1) (test-test-bit-field? 2 0 1))
(check-eqv? (test-bit-field? 2 1 1) (test-test-bit-field? 2 1 1))
(check-eqv? (test-bit-field? 2 2 1) (test-test-bit-field? 2 2 1))
(check-eqv? (test-bit-field? 3 0 1) (test-test-bit-field? 3 0 1))
(check-eqv? (test-bit-field? 3 1 1) (test-test-bit-field? 3 1 1))
(check-eqv? (test-bit-field? 3 2 1) (test-test-bit-field? 3 2 1))
(check-eqv? (test-bit-field? 1 0 2) (test-test-bit-field? 1 0 2))
(check-eqv? (test-bit-field? 1 1 2) (test-test-bit-field? 1 1 2))
(check-eqv? (test-bit-field? 1 2 2) (test-test-bit-field? 1 2 2))
(check-eqv? (test-bit-field? 2 0 2) (test-test-bit-field? 2 0 2))
(check-eqv? (test-bit-field? 2 1 2) (test-test-bit-field? 2 1 2))
(check-eqv? (test-bit-field? 2 2 2) (test-test-bit-field? 2 2 2))
(check-eqv? (test-bit-field? 3 0 2) (test-test-bit-field? 3 0 2))
(check-eqv? (test-bit-field? 3 1 2) (test-test-bit-field? 3 1 2))
(check-eqv? (test-bit-field? 3 2 2) (test-test-bit-field? 3 2 2))
(check-eqv? (test-bit-field? 1 0 3) (test-test-bit-field? 1 0 3))
(check-eqv? (test-bit-field? 1 1 3) (test-test-bit-field? 1 1 3))
(check-eqv? (test-bit-field? 1 2 3) (test-test-bit-field? 1 2 3))
(check-eqv? (test-bit-field? 2 0 3) (test-test-bit-field? 2 0 3))
(check-eqv? (test-bit-field? 2 1 3) (test-test-bit-field? 2 1 3))
(check-eqv? (test-bit-field? 2 2 3) (test-test-bit-field? 2 2 3))
(check-eqv? (test-bit-field? 3 0 3) (test-test-bit-field? 3 0 3))
(check-eqv? (test-bit-field? 3 1 3) (test-test-bit-field? 3 1 3))
(check-eqv? (test-bit-field? 3 2 3) (test-test-bit-field? 3 2 3))
(check-eqv? (test-bit-field? 1 0 4) (test-test-bit-field? 1 0 4))
(check-eqv? (test-bit-field? 1 1 4) (test-test-bit-field? 1 1 4))
(check-eqv? (test-bit-field? 1 2 4) (test-test-bit-field? 1 2 4))
(check-eqv? (test-bit-field? 2 0 4) (test-test-bit-field? 2 0 4))
(check-eqv? (test-bit-field? 2 1 4) (test-test-bit-field? 2 1 4))
(check-eqv? (test-bit-field? 2 2 4) (test-test-bit-field? 2 2 4))
(check-eqv? (test-bit-field? 3 0 4) (test-test-bit-field? 3 0 4))
(check-eqv? (test-bit-field? 3 1 4) (test-test-bit-field? 3 1 4))
(check-eqv? (test-bit-field? 3 2 4) (test-test-bit-field? 3 2 4))

;;; the following should not overflow the heap.

(check-eqv? (test-bit-field? (expt 2 100) (expt 2 100) -1)
            #t)

;;; Some error tests

(check-tail-exn type-exception? (lambda () (test-bit-field? -1 1 1)))
(check-tail-exn type-exception? (lambda () (test-bit-field? 1 -1 1)))
(check-tail-exn type-exception? (lambda () (test-bit-field? 'a 1 1)))
(check-tail-exn type-exception? (lambda () (test-bit-field? 1 'a 1)))
(check-tail-exn type-exception? (lambda () (test-bit-field? 1 1 'a)))


#;(let ()

  (define (make-symbol . args)
    (string->symbol (apply string-append (map (lambda (x) (if (symbol? x) (symbol->string x) x)) args))))

  (let ((xs (list (random-integer (expt 2 400))
		  (- (random-integer (expt 2 400)))
		  (random-integer (integer-sqrt ##max-fixnum))
		  (- (random-integer (integer-sqrt ##max-fixnum)))))
	(shifts (list (random-integer 200)
		     (random-integer 20)
		     (- (random-integer 200))
		     (- (random-integer 20)))))
    (for-each (lambda (x)
		(for-each (lambda (shift)
					(for-each display (list "(check-eqv? ("
								'arithmetic-shift
								" "
								x
								" "
								shift
								") ("
								(make-symbol 'test- 'arithmetic-shift)
								" "
								x
								" "
								shift
								"))\n")))
				      
			  shifts))
	      xs)
    ))

(check-eqv? (arithmetic-shift 1510654584040625753730018974833480216667530151201555010392492426076866671982958500628614593424711863814629067143762706485 25)
            (test-arithmetic-shift 1510654584040625753730018974833480216667530151201555010392492426076866671982958500628614593424711863814629067143762706485 25))
(check-eqv? (arithmetic-shift 1510654584040625753730018974833480216667530151201555010392492426076866671982958500628614593424711863814629067143762706485 6)
            (test-arithmetic-shift 1510654584040625753730018974833480216667530151201555010392492426076866671982958500628614593424711863814629067143762706485 6))
(check-eqv? (arithmetic-shift 1510654584040625753730018974833480216667530151201555010392492426076866671982958500628614593424711863814629067143762706485 -85)
            (test-arithmetic-shift 1510654584040625753730018974833480216667530151201555010392492426076866671982958500628614593424711863814629067143762706485 -85))
(check-eqv? (arithmetic-shift 1510654584040625753730018974833480216667530151201555010392492426076866671982958500628614593424711863814629067143762706485 -7)
            (test-arithmetic-shift 1510654584040625753730018974833480216667530151201555010392492426076866671982958500628614593424711863814629067143762706485 -7))
(check-eqv? (arithmetic-shift -559642383537053245096412692765977685103422952228866058440690017354464196389779391618197852441636114137703871379414475911 25)
            (test-arithmetic-shift -559642383537053245096412692765977685103422952228866058440690017354464196389779391618197852441636114137703871379414475911 25))
(check-eqv? (arithmetic-shift -559642383537053245096412692765977685103422952228866058440690017354464196389779391618197852441636114137703871379414475911 6)
            (test-arithmetic-shift -559642383537053245096412692765977685103422952228866058440690017354464196389779391618197852441636114137703871379414475911 6))
(check-eqv? (arithmetic-shift -559642383537053245096412692765977685103422952228866058440690017354464196389779391618197852441636114137703871379414475911 -85)
            (test-arithmetic-shift -559642383537053245096412692765977685103422952228866058440690017354464196389779391618197852441636114137703871379414475911 -85))
(check-eqv? (arithmetic-shift -559642383537053245096412692765977685103422952228866058440690017354464196389779391618197852441636114137703871379414475911 -7)
            (test-arithmetic-shift -559642383537053245096412692765977685103422952228866058440690017354464196389779391618197852441636114137703871379414475911 -7))
(check-eqv? (arithmetic-shift 1069741397 25) (test-arithmetic-shift 1069741397 25))
(check-eqv? (arithmetic-shift 1069741397 6) (test-arithmetic-shift 1069741397 6))
(check-eqv? (arithmetic-shift 1069741397 -85) (test-arithmetic-shift 1069741397 -85))
(check-eqv? (arithmetic-shift 1069741397 -7) (test-arithmetic-shift 1069741397 -7))
(check-eqv? (arithmetic-shift -1094530198 25) (test-arithmetic-shift -1094530198 25))
(check-eqv? (arithmetic-shift -1094530198 6) (test-arithmetic-shift -1094530198 6))
(check-eqv? (arithmetic-shift -1094530198 -85) (test-arithmetic-shift -1094530198 -85))
(check-eqv? (arithmetic-shift -1094530198 -7) (test-arithmetic-shift -1094530198 -7))

#;(let ()

  ;; I'll visually inspect the results

  (let* ((args `(120                        ; fixnum
		 ,(expt 3 64)               ; bignum
		 ,(+ (expt 3 64) 1)         ; close to bignum
		 ,(expt 3 128)              ; bigger bignum (more adigits)
		 ,(+ (expt 3 128) 1)))      ; close to bigger bignum
	 (args (append args (map - args)))) ; and their negatives
    (for-each (lambda (x)
		(for-each (lambda (y)
			    (for-each (lambda (op op-name)
					(for-each display (list "(check-eq? ("
								op-name
								" "
								x
								" "
								y
								") "
								(op x y)
								")\n")))
				      (list < > =)
				      '(< > =)))
			  args))
	      args)))

(check-eq? (< 120 120) #f)
(check-eq? (> 120 120) #f)
(check-eq? (= 120 120) #t)
(check-eq? (< 120 3433683820292512484657849089281) #t)
(check-eq? (> 120 3433683820292512484657849089281) #f)
(check-eq? (= 120 3433683820292512484657849089281) #f)
(check-eq? (< 120 3433683820292512484657849089282) #t)
(check-eq? (> 120 3433683820292512484657849089282) #f)
(check-eq? (= 120 3433683820292512484657849089282) #f)
(check-eq? (< 120 11790184577738583171520872861412518665678211592275841109096961) #t)
(check-eq? (> 120 11790184577738583171520872861412518665678211592275841109096961) #f)
(check-eq? (= 120 11790184577738583171520872861412518665678211592275841109096961) #f)
(check-eq? (< 120 11790184577738583171520872861412518665678211592275841109096962) #t)
(check-eq? (> 120 11790184577738583171520872861412518665678211592275841109096962) #f)
(check-eq? (= 120 11790184577738583171520872861412518665678211592275841109096962) #f)
(check-eq? (< 120 -120) #f)
(check-eq? (> 120 -120) #t)
(check-eq? (= 120 -120) #f)
(check-eq? (< 120 -3433683820292512484657849089281) #f)
(check-eq? (> 120 -3433683820292512484657849089281) #t)
(check-eq? (= 120 -3433683820292512484657849089281) #f)
(check-eq? (< 120 -3433683820292512484657849089282) #f)
(check-eq? (> 120 -3433683820292512484657849089282) #t)
(check-eq? (= 120 -3433683820292512484657849089282) #f)
(check-eq? (< 120 -11790184577738583171520872861412518665678211592275841109096961) #f)
(check-eq? (> 120 -11790184577738583171520872861412518665678211592275841109096961) #t)
(check-eq? (= 120 -11790184577738583171520872861412518665678211592275841109096961) #f)
(check-eq? (< 120 -11790184577738583171520872861412518665678211592275841109096962) #f)
(check-eq? (> 120 -11790184577738583171520872861412518665678211592275841109096962) #t)
(check-eq? (= 120 -11790184577738583171520872861412518665678211592275841109096962) #f)
(check-eq? (< 3433683820292512484657849089281 120) #f)
(check-eq? (> 3433683820292512484657849089281 120) #t)
(check-eq? (= 3433683820292512484657849089281 120) #f)
(check-eq? (< 3433683820292512484657849089281 3433683820292512484657849089281) #f)
(check-eq? (> 3433683820292512484657849089281 3433683820292512484657849089281) #f)
(check-eq? (= 3433683820292512484657849089281 3433683820292512484657849089281) #t)
(check-eq? (< 3433683820292512484657849089281 3433683820292512484657849089282) #t)
(check-eq? (> 3433683820292512484657849089281 3433683820292512484657849089282) #f)
(check-eq? (= 3433683820292512484657849089281 3433683820292512484657849089282) #f)
(check-eq? (< 3433683820292512484657849089281 11790184577738583171520872861412518665678211592275841109096961) #t)
(check-eq? (> 3433683820292512484657849089281 11790184577738583171520872861412518665678211592275841109096961) #f)
(check-eq? (= 3433683820292512484657849089281 11790184577738583171520872861412518665678211592275841109096961) #f)
(check-eq? (< 3433683820292512484657849089281 11790184577738583171520872861412518665678211592275841109096962) #t)
(check-eq? (> 3433683820292512484657849089281 11790184577738583171520872861412518665678211592275841109096962) #f)
(check-eq? (= 3433683820292512484657849089281 11790184577738583171520872861412518665678211592275841109096962) #f)
(check-eq? (< 3433683820292512484657849089281 -120) #f)
(check-eq? (> 3433683820292512484657849089281 -120) #t)
(check-eq? (= 3433683820292512484657849089281 -120) #f)
(check-eq? (< 3433683820292512484657849089281 -3433683820292512484657849089281) #f)
(check-eq? (> 3433683820292512484657849089281 -3433683820292512484657849089281) #t)
(check-eq? (= 3433683820292512484657849089281 -3433683820292512484657849089281) #f)
(check-eq? (< 3433683820292512484657849089281 -3433683820292512484657849089282) #f)
(check-eq? (> 3433683820292512484657849089281 -3433683820292512484657849089282) #t)
(check-eq? (= 3433683820292512484657849089281 -3433683820292512484657849089282) #f)
(check-eq? (< 3433683820292512484657849089281 -11790184577738583171520872861412518665678211592275841109096961) #f)
(check-eq? (> 3433683820292512484657849089281 -11790184577738583171520872861412518665678211592275841109096961) #t)
(check-eq? (= 3433683820292512484657849089281 -11790184577738583171520872861412518665678211592275841109096961) #f)
(check-eq? (< 3433683820292512484657849089281 -11790184577738583171520872861412518665678211592275841109096962) #f)
(check-eq? (> 3433683820292512484657849089281 -11790184577738583171520872861412518665678211592275841109096962) #t)
(check-eq? (= 3433683820292512484657849089281 -11790184577738583171520872861412518665678211592275841109096962) #f)
(check-eq? (< 3433683820292512484657849089282 120) #f)
(check-eq? (> 3433683820292512484657849089282 120) #t)
(check-eq? (= 3433683820292512484657849089282 120) #f)
(check-eq? (< 3433683820292512484657849089282 3433683820292512484657849089281) #f)
(check-eq? (> 3433683820292512484657849089282 3433683820292512484657849089281) #t)
(check-eq? (= 3433683820292512484657849089282 3433683820292512484657849089281) #f)
(check-eq? (< 3433683820292512484657849089282 3433683820292512484657849089282) #f)
(check-eq? (> 3433683820292512484657849089282 3433683820292512484657849089282) #f)
(check-eq? (= 3433683820292512484657849089282 3433683820292512484657849089282) #t)
(check-eq? (< 3433683820292512484657849089282 11790184577738583171520872861412518665678211592275841109096961) #t)
(check-eq? (> 3433683820292512484657849089282 11790184577738583171520872861412518665678211592275841109096961) #f)
(check-eq? (= 3433683820292512484657849089282 11790184577738583171520872861412518665678211592275841109096961) #f)
(check-eq? (< 3433683820292512484657849089282 11790184577738583171520872861412518665678211592275841109096962) #t)
(check-eq? (> 3433683820292512484657849089282 11790184577738583171520872861412518665678211592275841109096962) #f)
(check-eq? (= 3433683820292512484657849089282 11790184577738583171520872861412518665678211592275841109096962) #f)
(check-eq? (< 3433683820292512484657849089282 -120) #f)
(check-eq? (> 3433683820292512484657849089282 -120) #t)
(check-eq? (= 3433683820292512484657849089282 -120) #f)
(check-eq? (< 3433683820292512484657849089282 -3433683820292512484657849089281) #f)
(check-eq? (> 3433683820292512484657849089282 -3433683820292512484657849089281) #t)
(check-eq? (= 3433683820292512484657849089282 -3433683820292512484657849089281) #f)
(check-eq? (< 3433683820292512484657849089282 -3433683820292512484657849089282) #f)
(check-eq? (> 3433683820292512484657849089282 -3433683820292512484657849089282) #t)
(check-eq? (= 3433683820292512484657849089282 -3433683820292512484657849089282) #f)
(check-eq? (< 3433683820292512484657849089282 -11790184577738583171520872861412518665678211592275841109096961) #f)
(check-eq? (> 3433683820292512484657849089282 -11790184577738583171520872861412518665678211592275841109096961) #t)
(check-eq? (= 3433683820292512484657849089282 -11790184577738583171520872861412518665678211592275841109096961) #f)
(check-eq? (< 3433683820292512484657849089282 -11790184577738583171520872861412518665678211592275841109096962) #f)
(check-eq? (> 3433683820292512484657849089282 -11790184577738583171520872861412518665678211592275841109096962) #t)
(check-eq? (= 3433683820292512484657849089282 -11790184577738583171520872861412518665678211592275841109096962) #f)
(check-eq? (< 11790184577738583171520872861412518665678211592275841109096961 120) #f)
(check-eq? (> 11790184577738583171520872861412518665678211592275841109096961 120) #t)
(check-eq? (= 11790184577738583171520872861412518665678211592275841109096961 120) #f)
(check-eq? (< 11790184577738583171520872861412518665678211592275841109096961 3433683820292512484657849089281) #f)
(check-eq? (> 11790184577738583171520872861412518665678211592275841109096961 3433683820292512484657849089281) #t)
(check-eq? (= 11790184577738583171520872861412518665678211592275841109096961 3433683820292512484657849089281) #f)
(check-eq? (< 11790184577738583171520872861412518665678211592275841109096961 3433683820292512484657849089282) #f)
(check-eq? (> 11790184577738583171520872861412518665678211592275841109096961 3433683820292512484657849089282) #t)
(check-eq? (= 11790184577738583171520872861412518665678211592275841109096961 3433683820292512484657849089282) #f)
(check-eq? (< 11790184577738583171520872861412518665678211592275841109096961 11790184577738583171520872861412518665678211592275841109096961) #f)
(check-eq? (> 11790184577738583171520872861412518665678211592275841109096961 11790184577738583171520872861412518665678211592275841109096961) #f)
(check-eq? (= 11790184577738583171520872861412518665678211592275841109096961 11790184577738583171520872861412518665678211592275841109096961) #t)
(check-eq? (< 11790184577738583171520872861412518665678211592275841109096961 11790184577738583171520872861412518665678211592275841109096962) #t)
(check-eq? (> 11790184577738583171520872861412518665678211592275841109096961 11790184577738583171520872861412518665678211592275841109096962) #f)
(check-eq? (= 11790184577738583171520872861412518665678211592275841109096961 11790184577738583171520872861412518665678211592275841109096962) #f)
(check-eq? (< 11790184577738583171520872861412518665678211592275841109096961 -120) #f)
(check-eq? (> 11790184577738583171520872861412518665678211592275841109096961 -120) #t)
(check-eq? (= 11790184577738583171520872861412518665678211592275841109096961 -120) #f)
(check-eq? (< 11790184577738583171520872861412518665678211592275841109096961 -3433683820292512484657849089281) #f)
(check-eq? (> 11790184577738583171520872861412518665678211592275841109096961 -3433683820292512484657849089281) #t)
(check-eq? (= 11790184577738583171520872861412518665678211592275841109096961 -3433683820292512484657849089281) #f)
(check-eq? (< 11790184577738583171520872861412518665678211592275841109096961 -3433683820292512484657849089282) #f)
(check-eq? (> 11790184577738583171520872861412518665678211592275841109096961 -3433683820292512484657849089282) #t)
(check-eq? (= 11790184577738583171520872861412518665678211592275841109096961 -3433683820292512484657849089282) #f)
(check-eq? (< 11790184577738583171520872861412518665678211592275841109096961 -11790184577738583171520872861412518665678211592275841109096961) #f)
(check-eq? (> 11790184577738583171520872861412518665678211592275841109096961 -11790184577738583171520872861412518665678211592275841109096961) #t)
(check-eq? (= 11790184577738583171520872861412518665678211592275841109096961 -11790184577738583171520872861412518665678211592275841109096961) #f)
(check-eq? (< 11790184577738583171520872861412518665678211592275841109096961 -11790184577738583171520872861412518665678211592275841109096962) #f)
(check-eq? (> 11790184577738583171520872861412518665678211592275841109096961 -11790184577738583171520872861412518665678211592275841109096962) #t)
(check-eq? (= 11790184577738583171520872861412518665678211592275841109096961 -11790184577738583171520872861412518665678211592275841109096962) #f)
(check-eq? (< 11790184577738583171520872861412518665678211592275841109096962 120) #f)
(check-eq? (> 11790184577738583171520872861412518665678211592275841109096962 120) #t)
(check-eq? (= 11790184577738583171520872861412518665678211592275841109096962 120) #f)
(check-eq? (< 11790184577738583171520872861412518665678211592275841109096962 3433683820292512484657849089281) #f)
(check-eq? (> 11790184577738583171520872861412518665678211592275841109096962 3433683820292512484657849089281) #t)
(check-eq? (= 11790184577738583171520872861412518665678211592275841109096962 3433683820292512484657849089281) #f)
(check-eq? (< 11790184577738583171520872861412518665678211592275841109096962 3433683820292512484657849089282) #f)
(check-eq? (> 11790184577738583171520872861412518665678211592275841109096962 3433683820292512484657849089282) #t)
(check-eq? (= 11790184577738583171520872861412518665678211592275841109096962 3433683820292512484657849089282) #f)
(check-eq? (< 11790184577738583171520872861412518665678211592275841109096962 11790184577738583171520872861412518665678211592275841109096961) #f)
(check-eq? (> 11790184577738583171520872861412518665678211592275841109096962 11790184577738583171520872861412518665678211592275841109096961) #t)
(check-eq? (= 11790184577738583171520872861412518665678211592275841109096962 11790184577738583171520872861412518665678211592275841109096961) #f)
(check-eq? (< 11790184577738583171520872861412518665678211592275841109096962 11790184577738583171520872861412518665678211592275841109096962) #f)
(check-eq? (> 11790184577738583171520872861412518665678211592275841109096962 11790184577738583171520872861412518665678211592275841109096962) #f)
(check-eq? (= 11790184577738583171520872861412518665678211592275841109096962 11790184577738583171520872861412518665678211592275841109096962) #t)
(check-eq? (< 11790184577738583171520872861412518665678211592275841109096962 -120) #f)
(check-eq? (> 11790184577738583171520872861412518665678211592275841109096962 -120) #t)
(check-eq? (= 11790184577738583171520872861412518665678211592275841109096962 -120) #f)
(check-eq? (< 11790184577738583171520872861412518665678211592275841109096962 -3433683820292512484657849089281) #f)
(check-eq? (> 11790184577738583171520872861412518665678211592275841109096962 -3433683820292512484657849089281) #t)
(check-eq? (= 11790184577738583171520872861412518665678211592275841109096962 -3433683820292512484657849089281) #f)
(check-eq? (< 11790184577738583171520872861412518665678211592275841109096962 -3433683820292512484657849089282) #f)
(check-eq? (> 11790184577738583171520872861412518665678211592275841109096962 -3433683820292512484657849089282) #t)
(check-eq? (= 11790184577738583171520872861412518665678211592275841109096962 -3433683820292512484657849089282) #f)
(check-eq? (< 11790184577738583171520872861412518665678211592275841109096962 -11790184577738583171520872861412518665678211592275841109096961) #f)
(check-eq? (> 11790184577738583171520872861412518665678211592275841109096962 -11790184577738583171520872861412518665678211592275841109096961) #t)
(check-eq? (= 11790184577738583171520872861412518665678211592275841109096962 -11790184577738583171520872861412518665678211592275841109096961) #f)
(check-eq? (< 11790184577738583171520872861412518665678211592275841109096962 -11790184577738583171520872861412518665678211592275841109096962) #f)
(check-eq? (> 11790184577738583171520872861412518665678211592275841109096962 -11790184577738583171520872861412518665678211592275841109096962) #t)
(check-eq? (= 11790184577738583171520872861412518665678211592275841109096962 -11790184577738583171520872861412518665678211592275841109096962) #f)
(check-eq? (< -120 120) #t)
(check-eq? (> -120 120) #f)
(check-eq? (= -120 120) #f)
(check-eq? (< -120 3433683820292512484657849089281) #t)
(check-eq? (> -120 3433683820292512484657849089281) #f)
(check-eq? (= -120 3433683820292512484657849089281) #f)
(check-eq? (< -120 3433683820292512484657849089282) #t)
(check-eq? (> -120 3433683820292512484657849089282) #f)
(check-eq? (= -120 3433683820292512484657849089282) #f)
(check-eq? (< -120 11790184577738583171520872861412518665678211592275841109096961) #t)
(check-eq? (> -120 11790184577738583171520872861412518665678211592275841109096961) #f)
(check-eq? (= -120 11790184577738583171520872861412518665678211592275841109096961) #f)
(check-eq? (< -120 11790184577738583171520872861412518665678211592275841109096962) #t)
(check-eq? (> -120 11790184577738583171520872861412518665678211592275841109096962) #f)
(check-eq? (= -120 11790184577738583171520872861412518665678211592275841109096962) #f)
(check-eq? (< -120 -120) #f)
(check-eq? (> -120 -120) #f)
(check-eq? (= -120 -120) #t)
(check-eq? (< -120 -3433683820292512484657849089281) #f)
(check-eq? (> -120 -3433683820292512484657849089281) #t)
(check-eq? (= -120 -3433683820292512484657849089281) #f)
(check-eq? (< -120 -3433683820292512484657849089282) #f)
(check-eq? (> -120 -3433683820292512484657849089282) #t)
(check-eq? (= -120 -3433683820292512484657849089282) #f)
(check-eq? (< -120 -11790184577738583171520872861412518665678211592275841109096961) #f)
(check-eq? (> -120 -11790184577738583171520872861412518665678211592275841109096961) #t)
(check-eq? (= -120 -11790184577738583171520872861412518665678211592275841109096961) #f)
(check-eq? (< -120 -11790184577738583171520872861412518665678211592275841109096962) #f)
(check-eq? (> -120 -11790184577738583171520872861412518665678211592275841109096962) #t)
(check-eq? (= -120 -11790184577738583171520872861412518665678211592275841109096962) #f)
(check-eq? (< -3433683820292512484657849089281 120) #t)
(check-eq? (> -3433683820292512484657849089281 120) #f)
(check-eq? (= -3433683820292512484657849089281 120) #f)
(check-eq? (< -3433683820292512484657849089281 3433683820292512484657849089281) #t)
(check-eq? (> -3433683820292512484657849089281 3433683820292512484657849089281) #f)
(check-eq? (= -3433683820292512484657849089281 3433683820292512484657849089281) #f)
(check-eq? (< -3433683820292512484657849089281 3433683820292512484657849089282) #t)
(check-eq? (> -3433683820292512484657849089281 3433683820292512484657849089282) #f)
(check-eq? (= -3433683820292512484657849089281 3433683820292512484657849089282) #f)
(check-eq? (< -3433683820292512484657849089281 11790184577738583171520872861412518665678211592275841109096961) #t)
(check-eq? (> -3433683820292512484657849089281 11790184577738583171520872861412518665678211592275841109096961) #f)
(check-eq? (= -3433683820292512484657849089281 11790184577738583171520872861412518665678211592275841109096961) #f)
(check-eq? (< -3433683820292512484657849089281 11790184577738583171520872861412518665678211592275841109096962) #t)
(check-eq? (> -3433683820292512484657849089281 11790184577738583171520872861412518665678211592275841109096962) #f)
(check-eq? (= -3433683820292512484657849089281 11790184577738583171520872861412518665678211592275841109096962) #f)
(check-eq? (< -3433683820292512484657849089281 -120) #t)
(check-eq? (> -3433683820292512484657849089281 -120) #f)
(check-eq? (= -3433683820292512484657849089281 -120) #f)
(check-eq? (< -3433683820292512484657849089281 -3433683820292512484657849089281) #f)
(check-eq? (> -3433683820292512484657849089281 -3433683820292512484657849089281) #f)
(check-eq? (= -3433683820292512484657849089281 -3433683820292512484657849089281) #t)
(check-eq? (< -3433683820292512484657849089281 -3433683820292512484657849089282) #f)
(check-eq? (> -3433683820292512484657849089281 -3433683820292512484657849089282) #t)
(check-eq? (= -3433683820292512484657849089281 -3433683820292512484657849089282) #f)
(check-eq? (< -3433683820292512484657849089281 -11790184577738583171520872861412518665678211592275841109096961) #f)
(check-eq? (> -3433683820292512484657849089281 -11790184577738583171520872861412518665678211592275841109096961) #t)
(check-eq? (= -3433683820292512484657849089281 -11790184577738583171520872861412518665678211592275841109096961) #f)
(check-eq? (< -3433683820292512484657849089281 -11790184577738583171520872861412518665678211592275841109096962) #f)
(check-eq? (> -3433683820292512484657849089281 -11790184577738583171520872861412518665678211592275841109096962) #t)
(check-eq? (= -3433683820292512484657849089281 -11790184577738583171520872861412518665678211592275841109096962) #f)
(check-eq? (< -3433683820292512484657849089282 120) #t)
(check-eq? (> -3433683820292512484657849089282 120) #f)
(check-eq? (= -3433683820292512484657849089282 120) #f)
(check-eq? (< -3433683820292512484657849089282 3433683820292512484657849089281) #t)
(check-eq? (> -3433683820292512484657849089282 3433683820292512484657849089281) #f)
(check-eq? (= -3433683820292512484657849089282 3433683820292512484657849089281) #f)
(check-eq? (< -3433683820292512484657849089282 3433683820292512484657849089282) #t)
(check-eq? (> -3433683820292512484657849089282 3433683820292512484657849089282) #f)
(check-eq? (= -3433683820292512484657849089282 3433683820292512484657849089282) #f)
(check-eq? (< -3433683820292512484657849089282 11790184577738583171520872861412518665678211592275841109096961) #t)
(check-eq? (> -3433683820292512484657849089282 11790184577738583171520872861412518665678211592275841109096961) #f)
(check-eq? (= -3433683820292512484657849089282 11790184577738583171520872861412518665678211592275841109096961) #f)
(check-eq? (< -3433683820292512484657849089282 11790184577738583171520872861412518665678211592275841109096962) #t)
(check-eq? (> -3433683820292512484657849089282 11790184577738583171520872861412518665678211592275841109096962) #f)
(check-eq? (= -3433683820292512484657849089282 11790184577738583171520872861412518665678211592275841109096962) #f)
(check-eq? (< -3433683820292512484657849089282 -120) #t)
(check-eq? (> -3433683820292512484657849089282 -120) #f)
(check-eq? (= -3433683820292512484657849089282 -120) #f)
(check-eq? (< -3433683820292512484657849089282 -3433683820292512484657849089281) #t)
(check-eq? (> -3433683820292512484657849089282 -3433683820292512484657849089281) #f)
(check-eq? (= -3433683820292512484657849089282 -3433683820292512484657849089281) #f)
(check-eq? (< -3433683820292512484657849089282 -3433683820292512484657849089282) #f)
(check-eq? (> -3433683820292512484657849089282 -3433683820292512484657849089282) #f)
(check-eq? (= -3433683820292512484657849089282 -3433683820292512484657849089282) #t)
(check-eq? (< -3433683820292512484657849089282 -11790184577738583171520872861412518665678211592275841109096961) #f)
(check-eq? (> -3433683820292512484657849089282 -11790184577738583171520872861412518665678211592275841109096961) #t)
(check-eq? (= -3433683820292512484657849089282 -11790184577738583171520872861412518665678211592275841109096961) #f)
(check-eq? (< -3433683820292512484657849089282 -11790184577738583171520872861412518665678211592275841109096962) #f)
(check-eq? (> -3433683820292512484657849089282 -11790184577738583171520872861412518665678211592275841109096962) #t)
(check-eq? (= -3433683820292512484657849089282 -11790184577738583171520872861412518665678211592275841109096962) #f)
(check-eq? (< -11790184577738583171520872861412518665678211592275841109096961 120) #t)
(check-eq? (> -11790184577738583171520872861412518665678211592275841109096961 120) #f)
(check-eq? (= -11790184577738583171520872861412518665678211592275841109096961 120) #f)
(check-eq? (< -11790184577738583171520872861412518665678211592275841109096961 3433683820292512484657849089281) #t)
(check-eq? (> -11790184577738583171520872861412518665678211592275841109096961 3433683820292512484657849089281) #f)
(check-eq? (= -11790184577738583171520872861412518665678211592275841109096961 3433683820292512484657849089281) #f)
(check-eq? (< -11790184577738583171520872861412518665678211592275841109096961 3433683820292512484657849089282) #t)
(check-eq? (> -11790184577738583171520872861412518665678211592275841109096961 3433683820292512484657849089282) #f)
(check-eq? (= -11790184577738583171520872861412518665678211592275841109096961 3433683820292512484657849089282) #f)
(check-eq? (< -11790184577738583171520872861412518665678211592275841109096961 11790184577738583171520872861412518665678211592275841109096961) #t)
(check-eq? (> -11790184577738583171520872861412518665678211592275841109096961 11790184577738583171520872861412518665678211592275841109096961) #f)
(check-eq? (= -11790184577738583171520872861412518665678211592275841109096961 11790184577738583171520872861412518665678211592275841109096961) #f)
(check-eq? (< -11790184577738583171520872861412518665678211592275841109096961 11790184577738583171520872861412518665678211592275841109096962) #t)
(check-eq? (> -11790184577738583171520872861412518665678211592275841109096961 11790184577738583171520872861412518665678211592275841109096962) #f)
(check-eq? (= -11790184577738583171520872861412518665678211592275841109096961 11790184577738583171520872861412518665678211592275841109096962) #f)
(check-eq? (< -11790184577738583171520872861412518665678211592275841109096961 -120) #t)
(check-eq? (> -11790184577738583171520872861412518665678211592275841109096961 -120) #f)
(check-eq? (= -11790184577738583171520872861412518665678211592275841109096961 -120) #f)
(check-eq? (< -11790184577738583171520872861412518665678211592275841109096961 -3433683820292512484657849089281) #t)
(check-eq? (> -11790184577738583171520872861412518665678211592275841109096961 -3433683820292512484657849089281) #f)
(check-eq? (= -11790184577738583171520872861412518665678211592275841109096961 -3433683820292512484657849089281) #f)
(check-eq? (< -11790184577738583171520872861412518665678211592275841109096961 -3433683820292512484657849089282) #t)
(check-eq? (> -11790184577738583171520872861412518665678211592275841109096961 -3433683820292512484657849089282) #f)
(check-eq? (= -11790184577738583171520872861412518665678211592275841109096961 -3433683820292512484657849089282) #f)
(check-eq? (< -11790184577738583171520872861412518665678211592275841109096961 -11790184577738583171520872861412518665678211592275841109096961) #f)
(check-eq? (> -11790184577738583171520872861412518665678211592275841109096961 -11790184577738583171520872861412518665678211592275841109096961) #f)
(check-eq? (= -11790184577738583171520872861412518665678211592275841109096961 -11790184577738583171520872861412518665678211592275841109096961) #t)
(check-eq? (< -11790184577738583171520872861412518665678211592275841109096961 -11790184577738583171520872861412518665678211592275841109096962) #f)
(check-eq? (> -11790184577738583171520872861412518665678211592275841109096961 -11790184577738583171520872861412518665678211592275841109096962) #t)
(check-eq? (= -11790184577738583171520872861412518665678211592275841109096961 -11790184577738583171520872861412518665678211592275841109096962) #f)
(check-eq? (< -11790184577738583171520872861412518665678211592275841109096962 120) #t)
(check-eq? (> -11790184577738583171520872861412518665678211592275841109096962 120) #f)
(check-eq? (= -11790184577738583171520872861412518665678211592275841109096962 120) #f)
(check-eq? (< -11790184577738583171520872861412518665678211592275841109096962 3433683820292512484657849089281) #t)
(check-eq? (> -11790184577738583171520872861412518665678211592275841109096962 3433683820292512484657849089281) #f)
(check-eq? (= -11790184577738583171520872861412518665678211592275841109096962 3433683820292512484657849089281) #f)
(check-eq? (< -11790184577738583171520872861412518665678211592275841109096962 3433683820292512484657849089282) #t)
(check-eq? (> -11790184577738583171520872861412518665678211592275841109096962 3433683820292512484657849089282) #f)
(check-eq? (= -11790184577738583171520872861412518665678211592275841109096962 3433683820292512484657849089282) #f)
(check-eq? (< -11790184577738583171520872861412518665678211592275841109096962 11790184577738583171520872861412518665678211592275841109096961) #t)
(check-eq? (> -11790184577738583171520872861412518665678211592275841109096962 11790184577738583171520872861412518665678211592275841109096961) #f)
(check-eq? (= -11790184577738583171520872861412518665678211592275841109096962 11790184577738583171520872861412518665678211592275841109096961) #f)
(check-eq? (< -11790184577738583171520872861412518665678211592275841109096962 11790184577738583171520872861412518665678211592275841109096962) #t)
(check-eq? (> -11790184577738583171520872861412518665678211592275841109096962 11790184577738583171520872861412518665678211592275841109096962) #f)
(check-eq? (= -11790184577738583171520872861412518665678211592275841109096962 11790184577738583171520872861412518665678211592275841109096962) #f)
(check-eq? (< -11790184577738583171520872861412518665678211592275841109096962 -120) #t)
(check-eq? (> -11790184577738583171520872861412518665678211592275841109096962 -120) #f)
(check-eq? (= -11790184577738583171520872861412518665678211592275841109096962 -120) #f)
(check-eq? (< -11790184577738583171520872861412518665678211592275841109096962 -3433683820292512484657849089281) #t)
(check-eq? (> -11790184577738583171520872861412518665678211592275841109096962 -3433683820292512484657849089281) #f)
(check-eq? (= -11790184577738583171520872861412518665678211592275841109096962 -3433683820292512484657849089281) #f)
(check-eq? (< -11790184577738583171520872861412518665678211592275841109096962 -3433683820292512484657849089282) #t)
(check-eq? (> -11790184577738583171520872861412518665678211592275841109096962 -3433683820292512484657849089282) #f)
(check-eq? (= -11790184577738583171520872861412518665678211592275841109096962 -3433683820292512484657849089282) #f)
(check-eq? (< -11790184577738583171520872861412518665678211592275841109096962 -11790184577738583171520872861412518665678211592275841109096961) #t)
(check-eq? (> -11790184577738583171520872861412518665678211592275841109096962 -11790184577738583171520872861412518665678211592275841109096961) #f)
(check-eq? (= -11790184577738583171520872861412518665678211592275841109096962 -11790184577738583171520872861412518665678211592275841109096961) #f)
(check-eq? (< -11790184577738583171520872861412518665678211592275841109096962 -11790184577738583171520872861412518665678211592275841109096962) #f)
(check-eq? (> -11790184577738583171520872861412518665678211592275841109096962 -11790184577738583171520872861412518665678211592275841109096962) #f)
(check-eq? (= -11790184577738583171520872861412518665678211592275841109096962 -11790184577738583171520872861412518665678211592275841109096962) #t)

;;; Some complex tests

(check-eq? (= 3/4+0.i .75) #t)
(check-eq? (= 3/4+i 3/4) #f)
(check-eq? (= +0.i 0) #t)
(check-eq? (= 3+0.i .8) #f)
