// Code generated by github.com/aws/aws-sdk-go-v2/internal/codegen/cmd/defaultsconfig. DO NOT EDIT.

package defaults

import (
	"fmt"
	"github.com/aws/aws-sdk-go-v2/aws"
	"time"
)

// v1TestResolver returns the default Configuration descriptor for the given mode.
//
// Supports the following modes: cross-region, in-region, mobile, standard
func v1TestResolver(mode aws.DefaultsMode) (Configuration, error) {
	var mv aws.DefaultsMode
	mv.SetFromString(string(mode))

	switch mv {
	case aws.DefaultsModeCrossRegion:
		settings := Configuration{
			ConnectTimeout:        aws.Duration(2800 * time.Millisecond),
			RetryMode:             aws.RetryMode("standard"),
			TLSNegotiationTimeout: aws.Duration(2800 * time.Millisecond),
		}
		return settings, nil
	case aws.DefaultsModeInRegion:
		settings := Configuration{
			ConnectTimeout:        aws.Duration(1000 * time.Millisecond),
			RetryMode:             aws.RetryMode("standard"),
			TLSNegotiationTimeout: aws.Duration(1000 * time.Millisecond),
		}
		return settings, nil
	case aws.DefaultsModeMobile:
		settings := Configuration{
			ConnectTimeout:        aws.Duration(10000 * time.Millisecond),
			RetryMode:             aws.RetryMode("adaptive"),
			TLSNegotiationTimeout: aws.Duration(11000 * time.Millisecond),
		}
		return settings, nil
	case aws.DefaultsModeStandard:
		settings := Configuration{
			ConnectTimeout:        aws.Duration(2000 * time.Millisecond),
			RetryMode:             aws.RetryMode("standard"),
			TLSNegotiationTimeout: aws.Duration(2000 * time.Millisecond),
		}
		return settings, nil
	default:
		return Configuration{}, fmt.Errorf("unsupported defaults mode: %v", mode)
	}
}
