// Copyright 2025 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package areainsights provides access to the Places Insights API.
//
// For product documentation, see: https://g3doc.corp.google.com/geo/platform/area_insights/README.md?cl=head
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/areainsights/v1"
//	...
//	ctx := context.Background()
//	areainsightsService, err := areainsights.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	areainsightsService, err := areainsights.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	areainsightsService, err := areainsights.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package areainsights // import "google.golang.org/api/areainsights/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "areainsights:v1"
const apiName = "areainsights"
const apiVersion = "v1"
const basePath = "https://areainsights.googleapis.com/"
const basePathTemplate = "https://areainsights.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://areainsights.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.V1 = NewV1Service(s)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.TODO(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	V1 *V1Service
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewV1Service(s *Service) *V1Service {
	rs := &V1Service{s: s}
	return rs
}

type V1Service struct {
	s *Service
}

// Circle: A circle is defined by a center point and radius in meters.
type Circle struct {
	// LatLng: The latitude and longitude of the center of the circle.
	LatLng *LatLng `json:"latLng,omitempty"`
	// Place: **Format:** Must be in the format `places/PLACE_ID`, where `PLACE_ID`
	// is the unique identifier of a place. For example:
	// `places/ChIJgUbEo8cfqokR5lP9_Wh_DaM`.
	Place string `json:"place,omitempty"`
	// Radius: Optional. The radius of the circle in meters
	Radius int64 `json:"radius,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LatLng") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LatLng") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Circle) MarshalJSON() ([]byte, error) {
	type NoMethod Circle
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ComputeInsightsRequest: Request for the ComputeInsights RPC.
type ComputeInsightsRequest struct {
	// Filter: Required. Insight filter.
	Filter *Filter `json:"filter,omitempty"`
	// Insights: Required. Insights to compute. Currently only INSIGHT_COUNT and
	// INSIGHT_PLACES are supported.
	//
	// Possible values:
	//   "INSIGHT_UNSPECIFIED" - Not Specified.
	//   "INSIGHT_COUNT" - Count insight. When this insight is specified
	// ComputeInsights returns the number of places that match the specified filter
	// criteria. Example request: ``` { "insights": ["INSIGHT_COUNT"], "filter": {
	// "locationFilter": { "region": { "place":
	// "places/ChIJPV4oX_65j4ARVW8IJ6IJUYs" } }, "typeFilter": { "includedTypes":
	// ["restaurant"] }, "operatingStatus": ["OPERATING_STATUS_OPERATIONAL"],
	// "priceLevels": [ "PRICE_LEVEL_FREE", "PRICE_LEVEL_INEXPENSIVE" ],
	// "ratingFilter": { "minRating": 4.0 } } } ``` Example response: ``` {
	// "count": 1234 } ```
	//   "INSIGHT_PLACES" - Return Places When this insight is specified
	// ComputeInsights returns places IDs that match the specified filter criteria.
	// Example request: ``` { "insights": ["INSIGHT_PLACES"], "filter": {
	// "locationFilter": { "region": { "place":
	// "places/ChIJPV4oX_65j4ARVW8IJ6IJUYs" } }, "typeFilter": { "includedTypes":
	// ["restaurant"] }, "operatingStatus": ["OPERATING_STATUS_OPERATIONAL"],
	// "priceLevels": [ "PRICE_LEVEL_FREE", "PRICE_LEVEL_INEXPENSIVE" ],
	// "ratingFilter": { "minRating": 4.0 } } } ``` Example response: ``` {
	// "placeInsights": [ {"place": "places/ABC"}, {"place": "places/PQR"},
	// {"place": "places/XYZ"} ] } ```
	Insights []string `json:"insights,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Filter") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Filter") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ComputeInsightsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ComputeInsightsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ComputeInsightsResponse: Response for the ComputeInsights RPC.
type ComputeInsightsResponse struct {
	// Count: Result for Insights.INSIGHT_COUNT.
	Count int64 `json:"count,omitempty,string"`
	// PlaceInsights: Result for Insights.INSIGHT_PLACES.
	PlaceInsights []*PlaceInsight `json:"placeInsights,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Count") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Count") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ComputeInsightsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ComputeInsightsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CustomArea: Custom Area.
type CustomArea struct {
	// Polygon: Required. The custom area represented as a polygon
	Polygon *Polygon `json:"polygon,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Polygon") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Polygon") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CustomArea) MarshalJSON() ([]byte, error) {
	type NoMethod CustomArea
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Filter: Filters for the ComputeInsights RPC.
type Filter struct {
	// LocationFilter: Required. Restricts results to places which are located in
	// the area specified by location filters.
	LocationFilter *LocationFilter `json:"locationFilter,omitempty"`
	// OperatingStatus: Optional. Restricts results to places whose operating
	// status is included on this list. If operating_status is not set,
	// OPERATING_STATUS_OPERATIONAL is used as default.
	//
	// Possible values:
	//   "OPERATING_STATUS_UNSPECIFIED" - Not specified. This value should not be
	// used.
	//   "OPERATING_STATUS_OPERATIONAL" - The place is operational and its open
	// during its defined hours.
	//   "OPERATING_STATUS_PERMANENTLY_CLOSED" - The Place is no longer in
	// business.
	//   "OPERATING_STATUS_TEMPORARILY_CLOSED" - The place is temporarily closed
	// and expected to reopen in the future.
	OperatingStatus []string `json:"operatingStatus,omitempty"`
	// PriceLevels: Optional. Restricts results to places whose price level is
	// included on this list. If `price_levels` is not set, all price levels are
	// included in the results.
	//
	// Possible values:
	//   "PRICE_LEVEL_UNSPECIFIED" - Not specified. This value should not be used.
	//   "PRICE_LEVEL_FREE" - Place provides free services.
	//   "PRICE_LEVEL_INEXPENSIVE" - Place provides inexpensive services.
	//   "PRICE_LEVEL_MODERATE" - Place provides moderately priced services.
	//   "PRICE_LEVEL_EXPENSIVE" - Place provides expensive services.
	//   "PRICE_LEVEL_VERY_EXPENSIVE" - Place provides very expensive services.
	PriceLevels []string `json:"priceLevels,omitempty"`
	// RatingFilter: Optional. Restricts results to places whose average user
	// ratings are in the range specified by rating_filter. If rating_filter is not
	// set, all ratings are included in the result.
	RatingFilter *RatingFilter `json:"ratingFilter,omitempty"`
	// TypeFilter: Required. Place type filters.
	TypeFilter *TypeFilter `json:"typeFilter,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LocationFilter") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LocationFilter") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Filter) MarshalJSON() ([]byte, error) {
	type NoMethod Filter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LatLng: An object that represents a latitude/longitude pair. This is
// expressed as a pair of doubles to represent degrees latitude and degrees
// longitude. Unless specified otherwise, this object must conform to the WGS84
// standard. Values must be within normalized ranges.
type LatLng struct {
	// Latitude: The latitude in degrees. It must be in the range [-90.0, +90.0].
	Latitude float64 `json:"latitude,omitempty"`
	// Longitude: The longitude in degrees. It must be in the range [-180.0,
	// +180.0].
	Longitude float64 `json:"longitude,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Latitude") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Latitude") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LatLng) MarshalJSON() ([]byte, error) {
	type NoMethod LatLng
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *LatLng) UnmarshalJSON(data []byte) error {
	type NoMethod LatLng
	var s1 struct {
		Latitude  gensupport.JSONFloat64 `json:"latitude"`
		Longitude gensupport.JSONFloat64 `json:"longitude"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Latitude = float64(s1.Latitude)
	s.Longitude = float64(s1.Longitude)
	return nil
}

// LocationFilter: Location filters. Specifies the area of interest for the
// insight.
type LocationFilter struct {
	// Circle: Area as a circle.
	Circle *Circle `json:"circle,omitempty"`
	// CustomArea: Custom area specified by a polygon.
	CustomArea *CustomArea `json:"customArea,omitempty"`
	// Region: Area as region.
	Region *Region `json:"region,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Circle") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Circle") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LocationFilter) MarshalJSON() ([]byte, error) {
	type NoMethod LocationFilter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PlaceInsight: Holds information about a place
type PlaceInsight struct {
	// Place: The unique identifier of the place. This resource name can be used to
	// retrieve details about the place using the Places API
	// (https://developers.google.com/maps/documentation/places/web-service/reference/rest/v1/places/get).
	Place string `json:"place,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Place") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Place") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PlaceInsight) MarshalJSON() ([]byte, error) {
	type NoMethod PlaceInsight
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Polygon: A polygon is represented by a series of connected coordinates in an
// counterclockwise ordered sequence. The coordinates form a closed loop and
// define a filled region. The first and last coordinates are equivalent, and
// they must contain identical values. The format is a simplified version of
// GeoJSON polygons (we only support one counterclockwise exterior ring).
type Polygon struct {
	// Coordinates: Optional. The coordinates that define the polygon.
	Coordinates []*LatLng `json:"coordinates,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Coordinates") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Coordinates") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Polygon) MarshalJSON() ([]byte, error) {
	type NoMethod Polygon
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RatingFilter: Average user rating filters.
type RatingFilter struct {
	// MaxRating: Optional. Restricts results to places whose average user rating
	// is strictly less than or equal to max_rating. Values must be between 1.0 and
	// 5.0.
	MaxRating float64 `json:"maxRating,omitempty"`
	// MinRating: Optional. Restricts results to places whose average user rating
	// is greater than or equal to min_rating. Values must be between 1.0 and 5.0.
	MinRating float64 `json:"minRating,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MaxRating") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MaxRating") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RatingFilter) MarshalJSON() ([]byte, error) {
	type NoMethod RatingFilter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *RatingFilter) UnmarshalJSON(data []byte) error {
	type NoMethod RatingFilter
	var s1 struct {
		MaxRating gensupport.JSONFloat64 `json:"maxRating"`
		MinRating gensupport.JSONFloat64 `json:"minRating"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.MaxRating = float64(s1.MaxRating)
	s.MinRating = float64(s1.MinRating)
	return nil
}

// Region: A region is a geographic boundary such as: cities, postal codes,
// counties, states, etc.
type Region struct {
	// Place: The unique identifier of a specific geographic region.
	Place string `json:"place,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Place") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Place") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Region) MarshalJSON() ([]byte, error) {
	type NoMethod Region
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TypeFilter: Place type filters. Only Place types from Table a
// (https://developers.google.com/maps/documentation/places/web-service/place-types#table-a)
// are supported. A place can only have a single primary type associated with
// it. For example, the primary type might be "mexican_restaurant" or
// "steak_house". Use included_primary_types and excluded_primary_types to
// filter the results on a place's primary type. A place can also have multiple
// type values associated with it. For example a restaurant might have the
// following types: "seafood_restaurant", "restaurant", "food",
// "point_of_interest", "establishment". Use included_types and excluded_types
// to filter the results on the list of types associated with a place. If a
// search is specified with multiple type restrictions, only places that
// satisfy all of the restrictions are returned. For example, if you specify
// {"included_types": ["restaurant"], "excluded_primary_types":
// ["steak_house"]}, the returned places provide "restaurant" related services
// but do not operate primarily as a "steak_house". If there are any
// conflicting types, i.e. a type appears in both included_types and
// excluded_types types or included_primary_types and excluded_primary_types,
// an INVALID_ARGUMENT error is returned. One of included_types or
// included_primary_types must be set.
type TypeFilter struct {
	// ExcludedPrimaryTypes: Optional. Excluded primary Place types.
	ExcludedPrimaryTypes []string `json:"excludedPrimaryTypes,omitempty"`
	// ExcludedTypes: Optional. Excluded Place types.
	ExcludedTypes []string `json:"excludedTypes,omitempty"`
	// IncludedPrimaryTypes: Optional. Included primary Place types.
	IncludedPrimaryTypes []string `json:"includedPrimaryTypes,omitempty"`
	// IncludedTypes: Optional. Included Place types.
	IncludedTypes []string `json:"includedTypes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExcludedPrimaryTypes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExcludedPrimaryTypes") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TypeFilter) MarshalJSON() ([]byte, error) {
	type NoMethod TypeFilter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type V1ComputeInsightsCall struct {
	s                      *Service
	computeinsightsrequest *ComputeInsightsRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// ComputeInsights: Compute Insights RPC This method lets you retrieve insights
// about areas using a variaty of filter such as: area, place type, operating
// status, price level and ratings. Currently "count" and "places" insights are
// supported. With "count" insights you can answer questions such as "How many
// restaurant are located in California that are operational, are inexpensive
// and have an average rating of at least 4 stars" (see `insight` enum for more
// details). With "places" insights, you can determine which places match the
// requested filter. Clients can then use those place resource names to fetch
// more details about each individual place using the Places API.
func (r *V1Service) ComputeInsights(computeinsightsrequest *ComputeInsightsRequest) *V1ComputeInsightsCall {
	c := &V1ComputeInsightsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.computeinsightsrequest = computeinsightsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *V1ComputeInsightsCall) Fields(s ...googleapi.Field) *V1ComputeInsightsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *V1ComputeInsightsCall) Context(ctx context.Context) *V1ComputeInsightsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *V1ComputeInsightsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *V1ComputeInsightsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.computeinsightsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1:computeInsights")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "areainsights.computeInsights", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "areainsights.computeInsights" call.
// Any non-2xx status code is an error. Response headers are in either
// *ComputeInsightsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *V1ComputeInsightsCall) Do(opts ...googleapi.CallOption) (*ComputeInsightsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ComputeInsightsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "areainsights.computeInsights", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}
