# Contributing Languages Examples

Some contributors guidelines on adding new languages examples.


-----

**Table of Contents**

<!-- MarkdownTOC autolink="true" bracket="round" autoanchor="false" lowercase="only_ascii" uri_encoding="true" levels="1,2,3" -->

- [Contributing](#contributing)
- [Examples' Goals](#examples-goals)
- [Adding Example Files](#adding-example-files)
    - [Naming Convention](#naming-convention)
    - [Commit Checklist](#commit-checklist)
    - [Using Third Party Code](#using-third-party-code)
    - [Examples Guidelines](#examples-guidelines)
- [Adding the Example to the HTML Preview Doc](#adding-the-example-to-the-html-preview-doc)
    - [Customizing Examples in HTML Preview Doc](#customizing-examples-in-html-preview-doc)
        - [Per-Language Custom Themes](#per-language-custom-themes)
        - [Font Ligatures Support](#font-ligatures-support)
- [External Resources](#external-resources)

<!-- /MarkdownTOC -->

-----

# Contributing

Ideally, the honour/burdern of providing an example would naturally go to creator of its langDef, or to its current maintanier. But since over a hundred syntax definitions have been contributed in the course of over 15 years, the original creators of a langDef might no longer be actively maintaining them.

Therefore, anyone fluent in a given language can contribute an example file for it, by either creating it from scratch or picking some third party code. Here follow some general guidelines on examples criteria.

# Examples' Goals

Beside offering a quick preview of how a language can be colorized by Highlight, examples files should also serve the following purposes:

- __Theme Design__ — Theme designers need test how a theme looks across various languages.
- __Theme Picking__ — A web designer might need to choose a theme that looks nice with a particular language.

These users don't necessarily know the language, so the example should be representative of how real code in that language looks like and cover the various syntax elements defined in its langDef.

The same theme will produce quite different results with different languages, depending on which syntax elements are dominant, present or absent, and which elements are more commonly associated to each other — i.e. each language will have a different distribution of the colors in the scheme.

For these reasons, it's important that an example provided a realistic preview of its language, and doesn't omit any of its syntax elements, so that it can offer a reliable theme preview.

Needless to say, providing an example that is short and at the same time covers all the syntax elements is an art.

# Adding Example Files

All examples sources are stored in the [`ex-src/`][ex-src] folder.
This folder should contain only the examples files, so that Highlight GUI (or a script) can blindly import all its contents without any non-examples files creeping in.


## Naming Convention

The preferred naming convention is `<lang-name.lang-ext>`, where `lang-name` is the name of its langDef, and `lang-ext` is the preferred extension registered in Highlight for that language.

Example: `python.py`

The idea is to make the example files usable in automated scripts by knowing the language's name and it's extension.

Also, there should be only one example per language, unless the language justifies creating a second example — for example, embeddable languages like PHP might benefit from a pure PHP code example plus an example of PHP embedded in HTML. In such cases, you'll have to resort to filenames and extensions that make sense in that context.

## Commit Checklist


Before committing a new example, you should check if you need to update the Git configuration files in this folder:

- [`.gitattributes`][.gitattributes]
- [`.gitignore`][.gitignore]

These are used to control at a local level EOL normalization and exclusion patterns, to prevent cluttering the project's main config files.

These control end-of-lines normalization and exclusion patterns, to ensure cross-platformness of the files and keep out of the project unwanted files generated by working tools. These Git configuration files are kept local to this directory for both practical reasons and to avoid cluttering the project's main settings files.

If your example source requires a specific EOL normalization (i.e. `LF` or `CRLF`), you should add its extension to the `.gitignore` file, to ensure that it will be editable on all OSs without problems.

If the editor/IDE you use to work on the example creates some configuration files, just add their extensions to the `.gitignore` file so that you can keep working without having to worry about unrelated files creeping into your commit.


## Using Third Party Code

Custom designed examples are preferable to third party code snippets because rarely you'll find some real code examples meeting the criteria mentioned in these guidelines.

Nevertheless, if you do find third party code that you deem fit to use, and you'd like to add it as an example, you must make sure that:

- The code license permits it.
- Its license is compatible with that of the Highlight project (GNU GPLv3).
- You include the full license text of the original code.
- You credit its original author(s) — even if the code is in the public domain.
- You provide a link back to the source file and/or its author (if possible).

Having said that, having an example that doesn't meet all the criteria is better than having no example at all, and a better example can always be added later on; so, adding examples from third party code is fine — especially if you come across a file intended as an example of that language or (even better) for testing a syntax highlighter.

Indeed, it would be of great help if contributors could find some nice examples to cover the languages which currently don't have one. At the end of this document you'll find some links to code examples resources.


## Examples Guidelines

Here is a list resuming the guidelines for designing a custom example.

- __Keep It Short__ — Examples shouldn't be huge in size and number of code lines. They are intended as a preview of the language, not as test files.
- __Syntactically Complete__ — An example should cover the various syntax elements defined in its langDef so that it can be used to test or design color themes for that language.
- __Valid Code__ — Example files should be error free in their natural use context (e.g. compiler, parser, etc.). They don't have to do anything meaningful, but they should be editable and error free in a IDE that supports the lang. This makes its maintenance easier.

These are guidelines, not rules set in stone. If you think that it would make more sense to take a different approach for a given example, go ahead.

# Adding the Example to the HTML Preview Doc

Once you've added your example source file to [`ex-src/`][ex-src], you should consider adding it to the [Examples HTML Preview] document by editing its AsciiDoc source file:

- [`_adoc/Highlight_Examples.adoc`][Examples adoc]

If you don't know AsciiDoc, looking at how the other language examples are structured in the document should be enough to get you going. Otherwise, consult [AsciiDoctor's documentation].


[AsciiDoctor's documentation]: https://asciidoctor.org/docs/user-manual/
[Examples HTML Preview]: ./Highlight_Examples.html
[Examples adoc]: ./_adoc/Highlight_Examples.adoc




## Customizing Examples in HTML Preview Doc

### Per-Language Custom Themes

The stylesheets of `Highlight_Examples.html` provide a default theme for Highlight code blocks, but also provides (and allows) some language specific themes.

In the [`_sass/`][_sass] folder you'll find all the tools and examples to customize the color theme of your example by adding a custom stylesheet for that specific language. For a practical example, look at:

- [`_sass/_purebasic.scss`](./_sass/_purebasic.scss)

The [Sass]  (SCSS) files provide some ready-to-use font family settings, color schemes and palettes to simplify the task.

### Font Ligatures Support

Also, if the language of your example supports well font ligatures, you can enable the [Fira Code] font for that language by adding to [`_fonts-ligatures.scss`][ligatures]:

```scss
// Change 'your-lang' with the lang of your example:
@include FiraCodeLigatures(your-lang);

```

Ligatures provide a better and more elegant code reading experience. The Fira Code web font is loaded by the CSS from internet, so end users don't need to have it installed locally to preview it.

To test ligatures support for a given language, you can use the
[`outhtml_ligature_fonts.lua`][ligature lua] plugin in Highlight GUI.

[ligature lua]: https://gitlab.com/saalen/highlight/blob/master/plugins/outhtml_ligature_fonts.lua


-------------------------------------------------------------------------------

# External Resources

Here are some links to collections of code examples in various languages.
The links are intended mainly as a source of inspiration.
Not all of these examples collections have clear license terms, or permissive licenses, so please don't include here any examples from them unless you've verified the license of the individual examples.

Code editors syntax test files:

- [Atom editor language examples] — ([MIT] license).
- [Kate editor syntax tests] — ([GPLv3] license).

Syntax highlighters test files:

- [github.com/micck/code-examples] — ([MIT] license).
- [github.com/zokugun/highlight-examples] — ([MIT] license).
- [polyglot-readme] — ([MIT] license).

Code examples collections:

- [Programmer's Guide to the Galaxy] — well organized, unclear license terms (apparently, [ISC]).
- [Rosetta Code] — huge collection ([GFDLv1.2] license).
- [99 Bottles of Beer] — one program in 1500 variations (no license).
- [github.com/davispuh/Source-Code] — ([Unlicense]).

Some "Hello World" collections:

- [github.com/knightking100/hello-worlds] — 300+ langs ([Unlicense]).
- [github.com/Mozilla-Campus-Club-IIT/Hello-World-Collection] — ([GPLv3] license)


<!-----------------------------------------------------------------------------
                               REFERENCE LINKS
------------------------------------------------------------------------------>

<!-- project files -->

[.gitattributes]: ./.gitattributes
[.gitignore]: ./.gitignore
[_sass]: ./_sass
[ex-src]: ./ex-src/
[ligatures]: ./_sass/_fonts-ligatures.scss



<!-- vendors -->

[Fira Code]: https://github.com/tonsky/FiraCode "Visit the Fira Code project on GitHub"

[Sass]: https://sass-lang.com "Visit Sass website"

<!-- syntax highlighters test files -->

[github.com/micck/code-examples]: https://github.com/micck/code-examples
[github.com/zokugun/highlight-examples]: https://github.com/zokugun/highlight-examples
[polyglot-readme]: https://www.npmjs.com/package/polyglot-readme

<!-- editors syntax test files -->

[Atom editor language examples]: https://github.com/atom/language-examples
[Kate editor syntax tests]: https://github.com/guoyunhe/kate-syntax/tree/master/tests


<!-- code examples collections -->

[Programmer's Guide to the Galaxy]: http://www.programmersguidetothegalaxy.com/
[Rosetta Code]: http://www.rosettacode.org
[99 Bottles of Beer]: http://www.99-bottles-of-beer.net/

[github.com/davispuh/Source-Code]: https://github.com/davispuh/Source-Code
[github.com/knightking100/hello-worlds]: https://github.com/knightking100/hello-worlds
[github.com/Mozilla-Campus-Club-IIT/Hello-World-Collection]: https://github.com/Mozilla-Campus-Club-IIT/Hello-World-Collection


<!-- licenses -->

[GFDLv1.2]: https://www.gnu.org/licenses/fdl-1.2.html "View the GNU Free Documentation License 1.2"
[GPLv3]: https://www.gnu.org/licenses/gpl-3.0.en.html "View the GNU General Public License v3.0"
[ISC]: https://www.isc.org/downloads/software-support-policy/isc-license/ "View the Internet Systems Consortium (ISC) license"
[MIT]: https://opensource.org/licenses/MIT "View the MIT License"
[Unlicense]: http://unlicense.org/ "View the Unlicense terms"


<!-- EOF -->
