#![allow(clippy::excessive_precision)]

pub const PCM_HPF_CHARGE_FACTOR: f64 = 0.9946028448191855;

pub const PCM_LPF_TAPS: usize = 61;

// (4 + 1) * ~32552 Hz = ~162760 Hz
pub const PCM_ZERO_PADDING: usize = 4;

pub const PCM_SHARP_LPF_COEFFICIENTS: [f64; PCM_LPF_TAPS] = [
    -0.0002476591189664718,
    -0.0007178234649954806,
    -0.001023501044250731,
    -0.001011183278590655,
    -0.0005330921152945209,
    0.0004406571848031522,
    0.001696154825817755,
    0.002734896626325264,
    0.002900116348875565,
    0.001672865600087411,
    -0.0009684966991503005,
    -0.004311893575241369,
    -0.006980957709984703,
    -0.007385011341979122,
    -0.004443982922721896,
    0.001692454806510654,
    0.009290839620619495,
    0.01532512792933765,
    0.0164607878116,
    0.0104723588737548,
    -0.002418820288973187,
    -0.01887637974989049,
    -0.03287504511295283,
    -0.03727371431984434,
    -0.02613639517789088,
    0.00295176026373258,
    0.04742590143440701,
    0.09977242432439719,
    0.149198413171309,
    0.1845105633136688,
    0.1973172675709608,
    0.1845105633136688,
    0.149198413171309,
    0.0997724243243972,
    0.047425901434407,
    0.00295176026373258,
    -0.02613639517789089,
    -0.03727371431984434,
    -0.03287504511295284,
    -0.0188763797498905,
    -0.002418820288973189,
    0.01047235887375481,
    0.01646078781160001,
    0.01532512792933765,
    0.009290839620619501,
    0.001692454806510655,
    -0.004443982922721898,
    -0.007385011341979121,
    -0.006980957709984706,
    -0.004311893575241372,
    -0.0009684966991503004,
    0.001672865600087412,
    0.002900116348875565,
    0.002734896626325264,
    0.001696154825817755,
    0.0004406571848031521,
    -0.0005330921152945206,
    -0.001011183278590655,
    -0.001023501044250731,
    -0.0007178234649954804,
    -0.0002476591189664718,
];

pub const PCM_MID_LPF_COEFFICIENTS: [f64; PCM_LPF_TAPS] = [
    0.0001661853973432747,
    -0.0002056058490018866,
    -0.0006238170781511747,
    -0.001067292262901986,
    -0.001465462254239752,
    -0.001690689944943216,
    -0.001577347926692951,
    -0.0009684596716436601,
    0.0002191679074915438,
    0.001929068108536144,
    0.003920853715710697,
    0.00576850605202871,
    0.006914211648526586,
    0.006777598694595718,
    0.004904764330648357,
    0.001127568335617566,
    -0.004304804740789543,
    -0.01066012767148542,
    -0.01675202919673794,
    -0.02107464997990632,
    -0.02203159922753475,
    -0.01822503425863249,
    -0.008753137546444164,
    0.00654359703563913,
    0.02694243242305504,
    0.05084329873014245,
    0.07593092182275513,
    0.09947608865540115,
    0.1187294725389587,
    0.1313410571497859,
    0.1357305301257379,
    0.131341057149786,
    0.1187294725389587,
    0.09947608865540115,
    0.07593092182275513,
    0.05084329873014246,
    0.02694243242305505,
    0.006543597035639131,
    -0.008753137546444165,
    -0.01822503425863249,
    -0.02203159922753476,
    -0.02107464997990633,
    -0.01675202919673795,
    -0.01066012767148542,
    -0.004304804740789545,
    0.001127568335617567,
    0.004904764330648359,
    0.006777598694595717,
    0.006914211648526588,
    0.005768506052028712,
    0.003920853715710697,
    0.001929068108536144,
    0.0002191679074915438,
    -0.0009684596716436601,
    -0.001577347926692952,
    -0.001690689944943216,
    -0.001465462254239751,
    -0.001067292262901986,
    -0.0006238170781511746,
    -0.0002056058490018865,
    0.0001661853973432747,
];

pub const PCM_SOFT_LPF_COEFFICIENTS: [f64; PCM_LPF_TAPS] = [
    -0.0007227135274911439,
    -0.0005640461589502051,
    -0.0003268055304776042,
    2.739631204692037e-05,
    0.0005306804636229019,
    0.001186172919310923,
    0.001947380084791694,
    0.002705986294279189,
    0.003293376797578129,
    0.003498866836223284,
    0.003104346862318467,
    0.001931415969881269,
    -0.0001062294991483699,
    -0.002954665787049559,
    -0.00638609060144375,
    -0.009988712773757633,
    -0.01318625594809301,
    -0.01528871057632633,
    -0.01557075229677142,
    -0.01336911366317958,
    -0.008186056731450479,
    0.0002162625763718191,
    0.0117457913466191,
    0.02594775956629884,
    0.04201720837906407,
    0.05885878752694022,
    0.07518884080953557,
    0.08966831576030002,
    0.1010500168608809,
    0.1083210105693349,
    0.1108210743174821,
    0.1083210105693349,
    0.1010500168608809,
    0.08966831576030003,
    0.07518884080953556,
    0.05885878752694022,
    0.04201720837906408,
    0.02594775956629884,
    0.01174579134661911,
    0.0002162625763718191,
    -0.008186056731450482,
    -0.01336911366317959,
    -0.01557075229677143,
    -0.01528871057632634,
    -0.01318625594809303,
    -0.009988712773757638,
    -0.006386090601443754,
    -0.002954665787049558,
    -0.0001062294991483699,
    0.00193141596988127,
    0.003104346862318467,
    0.003498866836223285,
    0.003293376797578129,
    0.002705986294279188,
    0.001947380084791695,
    0.001186172919310923,
    0.0005306804636229016,
    2.739631204692037e-05,
    -0.0003268055304776042,
    -0.000564046158950205,
    -0.0007227135274911439,
];

pub const PCM_VSOFT_LPF_COEFFICIENTS: [f64; PCM_LPF_TAPS] = [
    0.0005365744706938546,
    0.000397200778148031,
    0.0002265221223525072,
    -9.619025728753642e-06,
    -0.000347266275461121,
    -0.0008169451156270903,
    -0.001435759583967407,
    -0.002199913607935899,
    -0.003078607264247103,
    -0.004010183598708018,
    -0.004901228995225635,
    -0.005629072653296335,
    -0.006047811022739319,
    -0.005997630767840325,
    -0.005316853128884191,
    -0.003855808663594157,
    -0.001491407127773036,
    0.001858880220327686,
    0.006224940861575442,
    0.01157506801084829,
    0.01781114872010057,
    0.02476869405675936,
    0.0322220213432869,
    0.0398944639097927,
    0.04747304474465484,
    0.0546266471682853,
    0.06102638602061973,
    0.06636665848894883,
    0.07038525698235305,
    0.07288096824371997,
    0.07372726137712313,
    0.07288096824371997,
    0.07038525698235304,
    0.06636665848894886,
    0.06102638602061972,
    0.0546266471682853,
    0.04747304474465484,
    0.0398944639097927,
    0.0322220213432869,
    0.02476869405675937,
    0.01781114872010058,
    0.0115750680108483,
    0.006224940861575444,
    0.001858880220327687,
    -0.001491407127773038,
    -0.003855808663594158,
    -0.005316853128884193,
    -0.005997630767840325,
    -0.006047811022739321,
    -0.005629072653296339,
    -0.004901228995225633,
    -0.004010183598708019,
    -0.003078607264247103,
    -0.002199913607935899,
    -0.001435759583967407,
    -0.0008169451156270901,
    -0.0003472662754611209,
    -9.61902572875363e-06,
    0.0002265221223525072,
    0.000397200778148031,
    0.0005365744706938545,
];

pub const CD_HPF_CHARGE_FACTOR: f64 = 0.9960133089108504;

pub const CD_LPF_TAPS: usize = 65;

// (3 + 1) * 44100 Hz = 176400 Hz
pub const CD_ZERO_PADDING: usize = 3;

// Target cutoff frequency of ~17000 Hz with stopband edge frequency at ~22000 Hz
pub const CD_SHARP_LPF_COEFFICIENTS: [f64; CD_LPF_TAPS] = [
    0.0007724846888521482,
    0.0007682112072922425,
    0.0004555790308097805,
    -0.0001510190768824653,
    -0.000920214411283334,
    -0.001562731179025197,
    -0.00168406364753821,
    -0.0009590051136459547,
    0.0006286717155865221,
    0.002614892810648478,
    0.004098563246266427,
    0.004066057697784632,
    0.001914350685883511,
    -0.002057409921888866,
    -0.006476452194068397,
    -0.009245409267879357,
    -0.008388937029754391,
    -0.003104612837691745,
    0.005460949056604788,
    0.01417621519923759,
    0.01884605671824892,
    0.01589904765491168,
    0.004248005639814604,
    -0.01347302896502778,
    -0.03097147311713124,
    -0.03989352698307622,
    -0.03258005807043361,
    -0.005068605302591979,
    0.04079365060819871,
    0.09704337912333197,
    0.1514104291640245,
    0.1907723423439893,
    0.2051353210528657,
    0.1907723423439893,
    0.1514104291640245,
    0.09704337912333197,
    0.04079365060819872,
    -0.00506860530259198,
    -0.03258005807043361,
    -0.03989352698307623,
    -0.03097147311713125,
    -0.01347302896502778,
    0.004248005639814603,
    0.01589904765491168,
    0.01884605671824893,
    0.01417621519923759,
    0.00546094905660479,
    -0.003104612837691744,
    -0.008388937029754392,
    -0.009245409267879362,
    -0.006476452194068397,
    -0.002057409921888867,
    0.001914350685883511,
    0.004066057697784633,
    0.00409856324626643,
    0.002614892810648478,
    0.0006286717155865222,
    -0.0009590051136459556,
    -0.00168406364753821,
    -0.001562731179025198,
    -0.0009202144112833351,
    -0.0001510190768824653,
    0.0004555790308097808,
    0.0007682112072922425,
    0.0007724846888521481,
];

pub const CD_MID_LPF_COEFFICIENTS: [f64; CD_LPF_TAPS] = [
    -1.012320580542799e-05,
    -0.0003325047384201734,
    -0.0006742638146912146,
    -0.00101681828693209,
    -0.001307584634312355,
    -0.001456774355921196,
    -0.001350104235528636,
    -0.0008774937661487902,
    2.717206122053927e-05,
    0.001344533485694194,
    0.002938388276310205,
    0.004546196537215201,
    0.005799983426016844,
    0.006280292023777638,
    0.005598353480858326,
    0.003494089624340209,
    -6.83316391866389e-05,
    -0.004828376319043119,
    -0.01019999231953648,
    -0.01529917200142542,
    -0.01903260574581813,
    -0.02024041781626594,
    -0.01787469726682215,
    -0.01118663454355335,
    0.0001094912171527386,
    0.01572622704929361,
    0.03477073379418375,
    0.05580275788480375,
    0.07698045599410987,
    0.09627667076144591,
    0.1117355028869948,
    0.1217310002897334,
    0.1251880917925206,
    0.1217310002897334,
    0.1117355028869948,
    0.09627667076144591,
    0.07698045599410989,
    0.05580275788480375,
    0.03477073379418375,
    0.01572622704929362,
    0.0001094912171527386,
    -0.01118663454355335,
    -0.01787469726682214,
    -0.02024041781626595,
    -0.01903260574581814,
    -0.01529917200142542,
    -0.01019999231953648,
    -0.004828376319043119,
    -6.833163918663891e-05,
    0.003494089624340212,
    0.005598353480858326,
    0.006280292023777639,
    0.005799983426016842,
    0.004546196537215203,
    0.002938388276310208,
    0.001344533485694193,
    2.717206122053928e-05,
    -0.000877493766148791,
    -0.001350104235528637,
    -0.001456774355921197,
    -0.001307584634312356,
    -0.00101681828693209,
    -0.000674263814691215,
    -0.0003325047384201735,
    -1.012320580542799e-05,
];

pub const CD_SOFT_LPF_COEFFICIENTS: [f64; CD_LPF_TAPS] = [
    -0.0005964721421981219,
    -0.0004248214184896494,
    -0.0001936486613741346,
    0.0001242209570553068,
    0.0005500382325667014,
    0.001084681331664971,
    0.001695808972103277,
    0.002310044371543946,
    0.002813071940613707,
    0.003059372261197026,
    0.002891709797136369,
    0.002168666379889258,
    0.0007967797195745941,
    -0.001237495129833584,
    -0.003841470550210021,
    -0.006800886407651795,
    -0.009779855755571127,
    -0.01233859559910673,
    -0.01396905635555009,
    -0.01414592512014454,
    -0.01238796851430597,
    -0.008322686722152001,
    -0.001746102424546295,
    0.007330569861603662,
    0.01865455975959826,
    0.03173053888065226,
    0.04584709163881964,
    0.06012937989384885,
    0.07361333629277254,
    0.08533380324014281,
    0.09441699671997808,
    0.1001668170172683,
    0.1021349950662084,
    0.1001668170172683,
    0.09441699671997807,
    0.08533380324014281,
    0.07361333629277254,
    0.06012937989384885,
    0.04584709163881964,
    0.03173053888065227,
    0.01865455975959827,
    0.007330569861603665,
    -0.001746102424546295,
    -0.008322686722152001,
    -0.01238796851430597,
    -0.01414592512014454,
    -0.01396905635555009,
    -0.01233859559910673,
    -0.009779855755571132,
    -0.0068008864076518,
    -0.003841470550210022,
    -0.001237495129833584,
    0.0007967797195745939,
    0.002168666379889259,
    0.002891709797136371,
    0.003059372261197026,
    0.002813071940613708,
    0.002310044371543948,
    0.001695808972103277,
    0.001084681331664971,
    0.000550038232566702,
    0.0001242209570553068,
    -0.0001936486613741347,
    -0.0004248214184896494,
    -0.000596472142198122,
];

pub const CD_VSOFT_LPF_COEFFICIENTS: [f64; CD_LPF_TAPS] = [
    0.0004275237402644937,
    0.0002932807357793022,
    0.0001334970559026294,
    -7.746410180931289e-05,
    -0.0003659585833838167,
    -0.0007542758222566434,
    -0.001255606270768339,
    -0.001869269832259521,
    -0.002576725039905022,
    -0.003338842882590005,
    -0.00409484702424078,
    -0.004763199026953181,
    -0.005244552201622724,
    -0.005426723117933239,
    -0.005191449986449291,
    -0.004422537399402525,
    -0.003014842246353793,
    -0.0008834493135218979,
    0.002027672400841722,
    0.005738243604382497,
    0.01022613409781339,
    0.0154242520125964,
    0.02122024848497964,
    0.02745922795958993,
    0.03394943695024403,
    0.04047068149982173,
    0.04678501330714386,
    0.05264904340566782,
    0.0578271052149353,
    0.06210440727636737,
    0.065299297289764,
    0.06727380553208394,
    0.06794174456254383,
    0.06727380553208392,
    0.06529929728976398,
    0.06210440727636737,
    0.05782710521493532,
    0.05264904340566783,
    0.04678501330714386,
    0.04047068149982174,
    0.03394943695024402,
    0.02745922795958994,
    0.02122024848497964,
    0.0154242520125964,
    0.0102261340978134,
    0.005738243604382499,
    0.002027672400841723,
    -0.0008834493135218977,
    -0.003014842246353794,
    -0.004422537399402527,
    -0.005191449986449292,
    -0.005426723117933242,
    -0.005244552201622722,
    -0.004763199026953183,
    -0.004094847024240784,
    -0.003338842882590004,
    -0.002576725039905022,
    -0.001869269832259523,
    -0.001255606270768339,
    -0.0007542758222566435,
    -0.0003659585833838171,
    -7.746410180931285e-05,
    0.0001334970559026294,
    0.0002932807357793022,
    0.0004275237402644937,
];
