//
// THIS FILE IS GENERATED BY glfw.py
//
// SAVE YOURSELF SOME TIME, DO NOT MANUALLY EDIT
//

#pragma once
#include <stddef.h>
#include <stdint.h>
#include "monotonic.h"

#ifndef GFW_EXTERN
#define GFW_EXTERN extern
#endif


/*! @name GLFW version macros
 *  @{ */
/*! @brief The major version number of the GLFW library.
 *
 *  This is incremented when the API is changed in non-compatible ways.
 *  @ingroup init
 */
#define GLFW_VERSION_MAJOR          3
/*! @brief The minor version number of the GLFW library.
 *
 *  This is incremented when features are added to the API but it remains
 *  backward-compatible.
 *  @ingroup init
 */
#define GLFW_VERSION_MINOR          4
/*! @brief The revision number of the GLFW library.
 *
 *  This is incremented when a bug fix release is made that does not contain any
 *  API changes.
 *  @ingroup init
 */
#define GLFW_VERSION_REVISION       0
/*! @} */

/*! @defgroup hat_state Joystick hat states
 *  @brief Joystick hat states.
 *
 *  See [joystick hat input](@ref joystick_hat) for how these are used.
 *
 *  @ingroup input
 *  @{ */
#define GLFW_HAT_CENTERED           0
#define GLFW_HAT_UP                 1
#define GLFW_HAT_RIGHT              2
#define GLFW_HAT_DOWN               4
#define GLFW_HAT_LEFT               8
#define GLFW_HAT_RIGHT_UP           (GLFW_HAT_RIGHT | GLFW_HAT_UP)
#define GLFW_HAT_RIGHT_DOWN         (GLFW_HAT_RIGHT | GLFW_HAT_DOWN)
#define GLFW_HAT_LEFT_UP            (GLFW_HAT_LEFT  | GLFW_HAT_UP)
#define GLFW_HAT_LEFT_DOWN          (GLFW_HAT_LEFT  | GLFW_HAT_DOWN)
/*! @} */

/*! @defgroup keys Keyboard keys
 *  @brief Keyboard key IDs.
 *
 *  See [key input](@ref input_key) for how these are used.
 *
 *  These key codes are inspired by the _USB HID Usage Tables v1.12_ (p. 53-60),
 *  but re-arranged to map to 7-bit ASCII for printable keys (function keys are
 *  put in the 256+ range).
 *
 *  The naming of the key codes follow these rules:
 *   - The US keyboard layout is used
 *   - Names of printable alphanumeric characters are used (e.g. "A", "R",
 *     "3", etc.)
 *   - For non-alphanumeric characters, Unicode:ish names are used (e.g.
 *     "COMMA", "LEFT_SQUARE_BRACKET", etc.). Note that some names do not
 *     correspond to the Unicode standard (usually for brevity)
 *   - Keys that lack a clear US mapping are named "WORLD_x"
 *   - For non-printable keys, custom names are used (e.g. "F4",
 *     "BACKSPACE", etc.)
 *
 *  @ingroup input
 *  @{
 */

/* start functional key names (auto generated by gen-key-constants.py do not edit) */
typedef enum {
  GLFW_FKEY_FIRST = 0xe000u,
  GLFW_FKEY_ESCAPE = 0xe000u,
  GLFW_FKEY_ENTER = 0xe001u,
  GLFW_FKEY_TAB = 0xe002u,
  GLFW_FKEY_BACKSPACE = 0xe003u,
  GLFW_FKEY_INSERT = 0xe004u,
  GLFW_FKEY_DELETE = 0xe005u,
  GLFW_FKEY_LEFT = 0xe006u,
  GLFW_FKEY_RIGHT = 0xe007u,
  GLFW_FKEY_UP = 0xe008u,
  GLFW_FKEY_DOWN = 0xe009u,
  GLFW_FKEY_PAGE_UP = 0xe00au,
  GLFW_FKEY_PAGE_DOWN = 0xe00bu,
  GLFW_FKEY_HOME = 0xe00cu,
  GLFW_FKEY_END = 0xe00du,
  GLFW_FKEY_CAPS_LOCK = 0xe00eu,
  GLFW_FKEY_SCROLL_LOCK = 0xe00fu,
  GLFW_FKEY_NUM_LOCK = 0xe010u,
  GLFW_FKEY_PRINT_SCREEN = 0xe011u,
  GLFW_FKEY_PAUSE = 0xe012u,
  GLFW_FKEY_MENU = 0xe013u,
  GLFW_FKEY_F1 = 0xe014u,
  GLFW_FKEY_F2 = 0xe015u,
  GLFW_FKEY_F3 = 0xe016u,
  GLFW_FKEY_F4 = 0xe017u,
  GLFW_FKEY_F5 = 0xe018u,
  GLFW_FKEY_F6 = 0xe019u,
  GLFW_FKEY_F7 = 0xe01au,
  GLFW_FKEY_F8 = 0xe01bu,
  GLFW_FKEY_F9 = 0xe01cu,
  GLFW_FKEY_F10 = 0xe01du,
  GLFW_FKEY_F11 = 0xe01eu,
  GLFW_FKEY_F12 = 0xe01fu,
  GLFW_FKEY_F13 = 0xe020u,
  GLFW_FKEY_F14 = 0xe021u,
  GLFW_FKEY_F15 = 0xe022u,
  GLFW_FKEY_F16 = 0xe023u,
  GLFW_FKEY_F17 = 0xe024u,
  GLFW_FKEY_F18 = 0xe025u,
  GLFW_FKEY_F19 = 0xe026u,
  GLFW_FKEY_F20 = 0xe027u,
  GLFW_FKEY_F21 = 0xe028u,
  GLFW_FKEY_F22 = 0xe029u,
  GLFW_FKEY_F23 = 0xe02au,
  GLFW_FKEY_F24 = 0xe02bu,
  GLFW_FKEY_F25 = 0xe02cu,
  GLFW_FKEY_F26 = 0xe02du,
  GLFW_FKEY_F27 = 0xe02eu,
  GLFW_FKEY_F28 = 0xe02fu,
  GLFW_FKEY_F29 = 0xe030u,
  GLFW_FKEY_F30 = 0xe031u,
  GLFW_FKEY_F31 = 0xe032u,
  GLFW_FKEY_F32 = 0xe033u,
  GLFW_FKEY_F33 = 0xe034u,
  GLFW_FKEY_F34 = 0xe035u,
  GLFW_FKEY_F35 = 0xe036u,
  GLFW_FKEY_KP_0 = 0xe037u,
  GLFW_FKEY_KP_1 = 0xe038u,
  GLFW_FKEY_KP_2 = 0xe039u,
  GLFW_FKEY_KP_3 = 0xe03au,
  GLFW_FKEY_KP_4 = 0xe03bu,
  GLFW_FKEY_KP_5 = 0xe03cu,
  GLFW_FKEY_KP_6 = 0xe03du,
  GLFW_FKEY_KP_7 = 0xe03eu,
  GLFW_FKEY_KP_8 = 0xe03fu,
  GLFW_FKEY_KP_9 = 0xe040u,
  GLFW_FKEY_KP_DECIMAL = 0xe041u,
  GLFW_FKEY_KP_DIVIDE = 0xe042u,
  GLFW_FKEY_KP_MULTIPLY = 0xe043u,
  GLFW_FKEY_KP_SUBTRACT = 0xe044u,
  GLFW_FKEY_KP_ADD = 0xe045u,
  GLFW_FKEY_KP_ENTER = 0xe046u,
  GLFW_FKEY_KP_EQUAL = 0xe047u,
  GLFW_FKEY_KP_SEPARATOR = 0xe048u,
  GLFW_FKEY_KP_LEFT = 0xe049u,
  GLFW_FKEY_KP_RIGHT = 0xe04au,
  GLFW_FKEY_KP_UP = 0xe04bu,
  GLFW_FKEY_KP_DOWN = 0xe04cu,
  GLFW_FKEY_KP_PAGE_UP = 0xe04du,
  GLFW_FKEY_KP_PAGE_DOWN = 0xe04eu,
  GLFW_FKEY_KP_HOME = 0xe04fu,
  GLFW_FKEY_KP_END = 0xe050u,
  GLFW_FKEY_KP_INSERT = 0xe051u,
  GLFW_FKEY_KP_DELETE = 0xe052u,
  GLFW_FKEY_KP_BEGIN = 0xe053u,
  GLFW_FKEY_MEDIA_PLAY = 0xe054u,
  GLFW_FKEY_MEDIA_PAUSE = 0xe055u,
  GLFW_FKEY_MEDIA_PLAY_PAUSE = 0xe056u,
  GLFW_FKEY_MEDIA_REVERSE = 0xe057u,
  GLFW_FKEY_MEDIA_STOP = 0xe058u,
  GLFW_FKEY_MEDIA_FAST_FORWARD = 0xe059u,
  GLFW_FKEY_MEDIA_REWIND = 0xe05au,
  GLFW_FKEY_MEDIA_TRACK_NEXT = 0xe05bu,
  GLFW_FKEY_MEDIA_TRACK_PREVIOUS = 0xe05cu,
  GLFW_FKEY_MEDIA_RECORD = 0xe05du,
  GLFW_FKEY_LOWER_VOLUME = 0xe05eu,
  GLFW_FKEY_RAISE_VOLUME = 0xe05fu,
  GLFW_FKEY_MUTE_VOLUME = 0xe060u,
  GLFW_FKEY_LEFT_SHIFT = 0xe061u,
  GLFW_FKEY_LEFT_CONTROL = 0xe062u,
  GLFW_FKEY_LEFT_ALT = 0xe063u,
  GLFW_FKEY_LEFT_SUPER = 0xe064u,
  GLFW_FKEY_LEFT_HYPER = 0xe065u,
  GLFW_FKEY_LEFT_META = 0xe066u,
  GLFW_FKEY_RIGHT_SHIFT = 0xe067u,
  GLFW_FKEY_RIGHT_CONTROL = 0xe068u,
  GLFW_FKEY_RIGHT_ALT = 0xe069u,
  GLFW_FKEY_RIGHT_SUPER = 0xe06au,
  GLFW_FKEY_RIGHT_HYPER = 0xe06bu,
  GLFW_FKEY_RIGHT_META = 0xe06cu,
  GLFW_FKEY_ISO_LEVEL3_SHIFT = 0xe06du,
  GLFW_FKEY_ISO_LEVEL5_SHIFT = 0xe06eu,
  GLFW_FKEY_LAST = 0xe06eu
} GLFWFunctionKey;
/* end functional key names */

/*! @} */

/*! @defgroup mods Modifier key flags
 *  @brief Modifier key flags.
 *
 *  See [key input](@ref input_key) for how these are used.
 *
 *  @ingroup input
 *  @{ */

/*! @brief If this bit is set one or more Shift keys were held down.
 *
 *  If this bit is set one or more Shift keys were held down.
 */
#define GLFW_MOD_SHIFT           0x0001
/*! @brief If this bit is set one or more Alt keys were held down.
 *
 *  If this bit is set one or more Alt keys were held down.
 */
#define GLFW_MOD_ALT             0x0002
/*! @brief If this bit is set one or more Alt keys were held down.
 *
 *  If this bit is set one or more Alt keys were held down.
 */
#define GLFW_MOD_CONTROL         0x0004
/*! @brief If this bit is set one or more Super keys were held down.
 *
 *  If this bit is set one or more Super keys were held down.
 */
#define GLFW_MOD_SUPER           0x0008
/*! @brief If this bit is set one or more Hyper keys were held down.
 *
 *  If this bit is set one or more Hyper keys were held down.
 */
#define GLFW_MOD_HYPER           0x0010
/*! @brief If this bit is set one or more Meta keys were held down.
 *
 *  If this bit is set one or more Meta keys were held down.
 */
#define GLFW_MOD_META            0x0020
/*! @brief If this bit is set the Caps Lock key is enabled.
 *
 *  If this bit is set the Caps Lock key is enabled and the @ref
 *  GLFW_LOCK_KEY_MODS input mode is set.
 */
#define GLFW_MOD_CAPS_LOCK       0x0040
/*! @brief If this bit is set the Num Lock key is enabled.
 *
 *  If this bit is set the Num Lock key is enabled and the @ref
 *  GLFW_LOCK_KEY_MODS input mode is set.
 */
#define GLFW_MOD_NUM_LOCK        0x0080
#define GLFW_MOD_LAST            GLFW_MOD_NUM_LOCK
#define GLFW_LOCK_MASK           (GLFW_MOD_NUM_LOCK | GLFW_MOD_CAPS_LOCK)

/*! @} */

/*! @defgroup buttons Mouse buttons
 *  @brief Mouse button IDs.
 *
 *  See [mouse button input](@ref input_mouse_button) for how these are used.
 *
 *  @ingroup input
 *  @{ */
typedef enum GLFWMouseButton {
    GLFW_MOUSE_BUTTON_1 = 0,
    GLFW_MOUSE_BUTTON_LEFT = 0,
    GLFW_MOUSE_BUTTON_2 = 1,
    GLFW_MOUSE_BUTTON_RIGHT = 1,
    GLFW_MOUSE_BUTTON_3 = 2,
    GLFW_MOUSE_BUTTON_MIDDLE = 2,
    GLFW_MOUSE_BUTTON_4 = 3,
    GLFW_MOUSE_BUTTON_5 = 4,
    GLFW_MOUSE_BUTTON_6 = 5,
    GLFW_MOUSE_BUTTON_7 = 6,
    GLFW_MOUSE_BUTTON_8 = 7,
    GLFW_MOUSE_BUTTON_LAST = 7
} GLFWMouseButton;
/*! @} */

typedef enum GLFWColorScheme {
    GLFW_COLOR_SCHEME_NO_PREFERENCE = 0,
    GLFW_COLOR_SCHEME_DARK = 1,
    GLFW_COLOR_SCHEME_LIGHT = 2
} GLFWColorScheme;

/*! @defgroup joysticks Joysticks
 *  @brief Joystick IDs.
 *
 *  See [joystick input](@ref joystick) for how these are used.
 *
 *  @ingroup input
 *  @{ */
#define GLFW_JOYSTICK_1             0
#define GLFW_JOYSTICK_2             1
#define GLFW_JOYSTICK_3             2
#define GLFW_JOYSTICK_4             3
#define GLFW_JOYSTICK_5             4
#define GLFW_JOYSTICK_6             5
#define GLFW_JOYSTICK_7             6
#define GLFW_JOYSTICK_8             7
#define GLFW_JOYSTICK_9             8
#define GLFW_JOYSTICK_10            9
#define GLFW_JOYSTICK_11            10
#define GLFW_JOYSTICK_12            11
#define GLFW_JOYSTICK_13            12
#define GLFW_JOYSTICK_14            13
#define GLFW_JOYSTICK_15            14
#define GLFW_JOYSTICK_16            15
#define GLFW_JOYSTICK_LAST          GLFW_JOYSTICK_16
/*! @} */

/*! @defgroup gamepad_buttons Gamepad buttons
 *  @brief Gamepad buttons.
 *
 *  See @ref gamepad for how these are used.
 *
 *  @ingroup input
 *  @{ */
#define GLFW_GAMEPAD_BUTTON_A               0
#define GLFW_GAMEPAD_BUTTON_B               1
#define GLFW_GAMEPAD_BUTTON_X               2
#define GLFW_GAMEPAD_BUTTON_Y               3
#define GLFW_GAMEPAD_BUTTON_LEFT_BUMPER     4
#define GLFW_GAMEPAD_BUTTON_RIGHT_BUMPER    5
#define GLFW_GAMEPAD_BUTTON_BACK            6
#define GLFW_GAMEPAD_BUTTON_START           7
#define GLFW_GAMEPAD_BUTTON_GUIDE           8
#define GLFW_GAMEPAD_BUTTON_LEFT_THUMB      9
#define GLFW_GAMEPAD_BUTTON_RIGHT_THUMB     10
#define GLFW_GAMEPAD_BUTTON_DPAD_UP         11
#define GLFW_GAMEPAD_BUTTON_DPAD_RIGHT      12
#define GLFW_GAMEPAD_BUTTON_DPAD_DOWN       13
#define GLFW_GAMEPAD_BUTTON_DPAD_LEFT       14
#define GLFW_GAMEPAD_BUTTON_LAST            GLFW_GAMEPAD_BUTTON_DPAD_LEFT

#define GLFW_GAMEPAD_BUTTON_CROSS       GLFW_GAMEPAD_BUTTON_A
#define GLFW_GAMEPAD_BUTTON_CIRCLE      GLFW_GAMEPAD_BUTTON_B
#define GLFW_GAMEPAD_BUTTON_SQUARE      GLFW_GAMEPAD_BUTTON_X
#define GLFW_GAMEPAD_BUTTON_TRIANGLE    GLFW_GAMEPAD_BUTTON_Y
/*! @} */

/*! @defgroup gamepad_axes Gamepad axes
 *  @brief Gamepad axes.
 *
 *  See @ref gamepad for how these are used.
 *
 *  @ingroup input
 *  @{ */
#define GLFW_GAMEPAD_AXIS_LEFT_X        0
#define GLFW_GAMEPAD_AXIS_LEFT_Y        1
#define GLFW_GAMEPAD_AXIS_RIGHT_X       2
#define GLFW_GAMEPAD_AXIS_RIGHT_Y       3
#define GLFW_GAMEPAD_AXIS_LEFT_TRIGGER  4
#define GLFW_GAMEPAD_AXIS_RIGHT_TRIGGER 5
#define GLFW_GAMEPAD_AXIS_LAST          GLFW_GAMEPAD_AXIS_RIGHT_TRIGGER
/*! @} */

/*! @defgroup errors Error codes
 *  @brief Error codes.
 *
 *  See [error handling](@ref error_handling) for how these are used.
 *
 *  @ingroup init
 *  @{ */
/*! @brief No error has occurred.
 *
 *  No error has occurred.
 *
 *  @analysis Yay.
 */
#define GLFW_NO_ERROR               0
/*! @brief GLFW has not been initialized.
 *
 *  This occurs if a GLFW function was called that must not be called unless the
 *  library is [initialized](@ref intro_init).
 *
 *  @analysis Application programmer error.  Initialize GLFW before calling any
 *  function that requires initialization.
 */
#define GLFW_NOT_INITIALIZED        0x00010001
/*! @brief No context is current for this thread.
 *
 *  This occurs if a GLFW function was called that needs and operates on the
 *  current OpenGL or OpenGL ES context but no context is current on the calling
 *  thread.  One such function is @ref glfwSwapInterval.
 *
 *  @analysis Application programmer error.  Ensure a context is current before
 *  calling functions that require a current context.
 */
#define GLFW_NO_CURRENT_CONTEXT     0x00010002
/*! @brief One of the arguments to the function was an invalid enum value.
 *
 *  One of the arguments to the function was an invalid enum value, for example
 *  requesting @ref GLFW_RED_BITS with @ref glfwGetWindowAttrib.
 *
 *  @analysis Application programmer error.  Fix the offending call.
 */
#define GLFW_INVALID_ENUM           0x00010003
/*! @brief One of the arguments to the function was an invalid value.
 *
 *  One of the arguments to the function was an invalid value, for example
 *  requesting a non-existent OpenGL or OpenGL ES version like 2.7.
 *
 *  Requesting a valid but unavailable OpenGL or OpenGL ES version will instead
 *  result in a @ref GLFW_VERSION_UNAVAILABLE error.
 *
 *  @analysis Application programmer error.  Fix the offending call.
 */
#define GLFW_INVALID_VALUE          0x00010004
/*! @brief A memory allocation failed.
 *
 *  A memory allocation failed.
 *
 *  @analysis A bug in GLFW or the underlying operating system.  Report the bug
 *  to our [issue tracker](https://github.com/glfw/glfw/issues).
 */
#define GLFW_OUT_OF_MEMORY          0x00010005
/*! @brief GLFW could not find support for the requested API on the system.
 *
 *  GLFW could not find support for the requested API on the system.
 *
 *  @analysis The installed graphics driver does not support the requested
 *  API, or does not support it via the chosen context creation backend.
 *  Below are a few examples.
 *
 *  @par
 *  Some pre-installed Windows graphics drivers do not support OpenGL.  AMD only
 *  supports OpenGL ES via EGL, while Nvidia and Intel only support it via
 *  a WGL or GLX extension.  macOS does not provide OpenGL ES at all.  The Mesa
 *  EGL, OpenGL and OpenGL ES libraries do not interface with the Nvidia binary
 *  driver.  Older graphics drivers do not support Vulkan.
 */
#define GLFW_API_UNAVAILABLE        0x00010006
/*! @brief The requested OpenGL or OpenGL ES version is not available.
 *
 *  The requested OpenGL or OpenGL ES version (including any requested context
 *  or framebuffer hints) is not available on this machine.
 *
 *  @analysis The machine does not support your requirements.  If your
 *  application is sufficiently flexible, downgrade your requirements and try
 *  again.  Otherwise, inform the user that their machine does not match your
 *  requirements.
 *
 *  @par
 *  Future invalid OpenGL and OpenGL ES versions, for example OpenGL 4.8 if 5.0
 *  comes out before the 4.x series gets that far, also fail with this error and
 *  not @ref GLFW_INVALID_VALUE, because GLFW cannot know what future versions
 *  will exist.
 */
#define GLFW_VERSION_UNAVAILABLE    0x00010007
/*! @brief A platform-specific error occurred that does not match any of the
 *  more specific categories.
 *
 *  A platform-specific error occurred that does not match any of the more
 *  specific categories.
 *
 *  @analysis A bug or configuration error in GLFW, the underlying operating
 *  system or its drivers, or a lack of required resources.  Report the issue to
 *  our [issue tracker](https://github.com/glfw/glfw/issues).
 */
#define GLFW_PLATFORM_ERROR         0x00010008
/*! @brief The requested format is not supported or available.
 *
 *  If emitted during window creation, the requested pixel format is not
 *  supported.
 *
 *  If emitted when querying the clipboard, the contents of the clipboard could
 *  not be converted to the requested format.
 *
 *  @analysis If emitted during window creation, one or more
 *  [hard constraints](@ref window_hints_hard) did not match any of the
 *  available pixel formats.  If your application is sufficiently flexible,
 *  downgrade your requirements and try again.  Otherwise, inform the user that
 *  their machine does not match your requirements.
 *
 *  @par
 *  If emitted when querying the clipboard, ignore the error or report it to
 *  the user, as appropriate.
 */
#define GLFW_FORMAT_UNAVAILABLE     0x00010009
/*! @brief The specified window does not have an OpenGL or OpenGL ES context.
 *
 *  A window that does not have an OpenGL or OpenGL ES context was passed to
 *  a function that requires it to have one.
 *
 *  @analysis Application programmer error.  Fix the offending call.
 */
#define GLFW_NO_WINDOW_CONTEXT      0x0001000A
/*! @brief The requested feature is not provided by the platform.
 *
 *  The requested feature is not provided by the platform, so GLFW is unable to
 *  implement it.  The documentation for each function notes if it could emit
 *  this error.
 *
 *  @analysis Platform or platform version limitation.  The error can be ignored
 *  unless the feature is critical to the application.
 *
 *  @par
 *  A function call that emits this error has no effect other than the error and
 *  updating any existing out parameters.
 */
#define GLFW_FEATURE_UNAVAILABLE    0x0001000C
/*! @brief The requested feature is not implemented for the platform.
 *
 *  The requested feature has not yet been implemented in GLFW for this platform.
 *
 *  @analysis An incomplete implementation of GLFW for this platform, hopefully
 *  fixed in a future release.  The error can be ignored unless the feature is
 *  critical to the application.
 *
 *  @par
 *  A function call that emits this error has no effect other than the error and
 *  updating any existing out parameters.
 */
#define GLFW_FEATURE_UNIMPLEMENTED  0x0001000D
/*! @} */

/*! @addtogroup window
 *  @{ */
/*! @brief Input focus window hint and attribute
 *
 *  Input focus [window hint](@ref GLFW_FOCUSED_hint) or
 *  [window attribute](@ref GLFW_FOCUSED_attrib).
 */
#define GLFW_FOCUSED                0x00020001
/*! @brief Window iconification window attribute
 *
 *  Window iconification [window attribute](@ref GLFW_ICONIFIED_attrib).
 */
#define GLFW_ICONIFIED              0x00020002
/*! @brief Window resize-ability window hint and attribute
 *
 *  Window resize-ability [window hint](@ref GLFW_RESIZABLE_hint) and
 *  [window attribute](@ref GLFW_RESIZABLE_attrib).
 */
#define GLFW_RESIZABLE              0x00020003
/*! @brief Window visibility window hint and attribute
 *
 *  Window visibility [window hint](@ref GLFW_VISIBLE_hint) and
 *  [window attribute](@ref GLFW_VISIBLE_attrib).
 */
#define GLFW_VISIBLE                0x00020004
/*! @brief Window decoration window hint and attribute
 *
 *  Window decoration [window hint](@ref GLFW_DECORATED_hint) and
 *  [window attribute](@ref GLFW_DECORATED_attrib).
 */
#define GLFW_DECORATED              0x00020005
/*! @brief Window auto-iconification window hint and attribute
 *
 *  Window auto-iconification [window hint](@ref GLFW_AUTO_ICONIFY_hint) and
 *  [window attribute](@ref GLFW_AUTO_ICONIFY_attrib).
 */
#define GLFW_AUTO_ICONIFY           0x00020006
/*! @brief Window decoration window hint and attribute
 *
 *  Window decoration [window hint](@ref GLFW_FLOATING_hint) and
 *  [window attribute](@ref GLFW_FLOATING_attrib).
 */
#define GLFW_FLOATING               0x00020007
/*! @brief Window maximization window hint and attribute
 *
 *  Window maximization [window hint](@ref GLFW_MAXIMIZED_hint) and
 *  [window attribute](@ref GLFW_MAXIMIZED_attrib).
 */
#define GLFW_MAXIMIZED              0x00020008
/*! @brief Cursor centering window hint
 *
 *  Cursor centering [window hint](@ref GLFW_CENTER_CURSOR_hint).
 */
#define GLFW_CENTER_CURSOR          0x00020009
/*! @brief Window framebuffer transparency hint and attribute
 *
 *  Window framebuffer transparency
 *  [window hint](@ref GLFW_TRANSPARENT_FRAMEBUFFER_hint) and
 *  [window attribute](@ref GLFW_TRANSPARENT_FRAMEBUFFER_attrib).
 */
#define GLFW_TRANSPARENT_FRAMEBUFFER 0x0002000A
/*! @brief Mouse cursor hover window attribute.
 *
 *  Mouse cursor hover [window attribute](@ref GLFW_HOVERED_attrib).
 */
#define GLFW_HOVERED                0x0002000B
/*! @brief Input focus on calling show window hint and attribute
 *
 *  Input focus [window hint](@ref GLFW_FOCUS_ON_SHOW_hint) or
 *  [window attribute](@ref GLFW_FOCUS_ON_SHOW_attrib).
 */
#define GLFW_FOCUS_ON_SHOW          0x0002000C

/*! @brief Mouse input transparency window hint and attribute
 *
 *  Mouse input transparency [window hint](@ref GLFW_MOUSE_PASSTHROUGH_hint) or
 *  [window attribute](@ref GLFW_MOUSE_PASSTHROUGH_attrib).
 */
#define GLFW_MOUSE_PASSTHROUGH      0x0002000D

/*! @brief Occlusion window attribute
 *
 *  Occlusion [window attribute](@ref GLFW_OCCLUDED_attrib).
 */
#define GLFW_OCCLUDED               0x0002000E
/*! @brief Framebuffer bit depth hint.
 *
 *  Framebuffer bit depth [hint](@ref GLFW_RED_BITS).
 */
#define GLFW_RED_BITS               0x00021001
/*! @brief Framebuffer bit depth hint.
 *
 *  Framebuffer bit depth [hint](@ref GLFW_GREEN_BITS).
 */
#define GLFW_GREEN_BITS             0x00021002
/*! @brief Framebuffer bit depth hint.
 *
 *  Framebuffer bit depth [hint](@ref GLFW_BLUE_BITS).
 */
#define GLFW_BLUE_BITS              0x00021003
/*! @brief Framebuffer bit depth hint.
 *
 *  Framebuffer bit depth [hint](@ref GLFW_ALPHA_BITS).
 */
#define GLFW_ALPHA_BITS             0x00021004
/*! @brief Framebuffer bit depth hint.
 *
 *  Framebuffer bit depth [hint](@ref GLFW_DEPTH_BITS).
 */
#define GLFW_DEPTH_BITS             0x00021005
/*! @brief Framebuffer bit depth hint.
 *
 *  Framebuffer bit depth [hint](@ref GLFW_STENCIL_BITS).
 */
#define GLFW_STENCIL_BITS           0x00021006
/*! @brief Framebuffer bit depth hint.
 *
 *  Framebuffer bit depth [hint](@ref GLFW_ACCUM_RED_BITS).
 */
#define GLFW_ACCUM_RED_BITS         0x00021007
/*! @brief Framebuffer bit depth hint.
 *
 *  Framebuffer bit depth [hint](@ref GLFW_ACCUM_GREEN_BITS).
 */
#define GLFW_ACCUM_GREEN_BITS       0x00021008
/*! @brief Framebuffer bit depth hint.
 *
 *  Framebuffer bit depth [hint](@ref GLFW_ACCUM_BLUE_BITS).
 */
#define GLFW_ACCUM_BLUE_BITS        0x00021009
/*! @brief Framebuffer bit depth hint.
 *
 *  Framebuffer bit depth [hint](@ref GLFW_ACCUM_ALPHA_BITS).
 */
#define GLFW_ACCUM_ALPHA_BITS       0x0002100A
/*! @brief Framebuffer auxiliary buffer hint.
 *
 *  Framebuffer auxiliary buffer [hint](@ref GLFW_AUX_BUFFERS).
 */
#define GLFW_AUX_BUFFERS            0x0002100B
/*! @brief OpenGL stereoscopic rendering hint.
 *
 *  OpenGL stereoscopic rendering [hint](@ref GLFW_STEREO).
 */
#define GLFW_STEREO                 0x0002100C
/*! @brief Framebuffer MSAA samples hint.
 *
 *  Framebuffer MSAA samples [hint](@ref GLFW_SAMPLES).
 */
#define GLFW_SAMPLES                0x0002100D
/*! @brief Framebuffer sRGB hint.
 *
 *  Framebuffer sRGB [hint](@ref GLFW_SRGB_CAPABLE).
 */
#define GLFW_SRGB_CAPABLE           0x0002100E
/*! @brief Monitor refresh rate hint.
 *
 *  Monitor refresh rate [hint](@ref GLFW_REFRESH_RATE).
 */
#define GLFW_REFRESH_RATE           0x0002100F
/*! @brief Framebuffer double buffering hint.
 *
 *  Framebuffer double buffering [hint](@ref GLFW_DOUBLEBUFFER).
 */
#define GLFW_DOUBLEBUFFER           0x00021010

/*! @brief Context client API hint and attribute.
 *
 *  Context client API [hint](@ref GLFW_CLIENT_API_hint) and
 *  [attribute](@ref GLFW_CLIENT_API_attrib).
 */
#define GLFW_CLIENT_API             0x00022001
/*! @brief Context client API major version hint and attribute.
 *
 *  Context client API major version [hint](@ref GLFW_CONTEXT_VERSION_MAJOR_hint)
 *  and [attribute](@ref GLFW_CONTEXT_VERSION_MAJOR_attrib).
 */
#define GLFW_CONTEXT_VERSION_MAJOR  0x00022002
/*! @brief Context client API minor version hint and attribute.
 *
 *  Context client API minor version [hint](@ref GLFW_CONTEXT_VERSION_MINOR_hint)
 *  and [attribute](@ref GLFW_CONTEXT_VERSION_MINOR_attrib).
 */
#define GLFW_CONTEXT_VERSION_MINOR  0x00022003
/*! @brief Context client API revision number hint and attribute.
 *
 *  Context client API revision number
 *  [attribute](@ref GLFW_CONTEXT_REVISION_attrib).
 */
#define GLFW_CONTEXT_REVISION       0x00022004
/*! @brief Context robustness hint and attribute.
 *
 *  Context client API revision number [hint](@ref GLFW_CONTEXT_ROBUSTNESS_hint)
 *  and [attribute](@ref GLFW_CONTEXT_ROBUSTNESS_attrib).
 */
#define GLFW_CONTEXT_ROBUSTNESS     0x00022005
/*! @brief OpenGL forward-compatibility hint and attribute.
 *
 *  OpenGL forward-compatibility [hint](@ref GLFW_OPENGL_FORWARD_COMPAT_hint)
 *  and [attribute](@ref GLFW_OPENGL_FORWARD_COMPAT_attrib).
 */
#define GLFW_OPENGL_FORWARD_COMPAT  0x00022006
/*! @brief Debug mode context hint and attribute.
 *
 *  Debug mode context [hint](@ref GLFW_CONTEXT_DEBUG_hint) and
 *  [attribute](@ref GLFW_CONTEXT_DEBUG_attrib).
 */
#define GLFW_CONTEXT_DEBUG          0x00022007
/*! @brief Legacy name for compatibility.
 *
 *  This is an alias for compatibility with earlier versions.
 */
#define GLFW_OPENGL_DEBUG_CONTEXT   GLFW_CONTEXT_DEBUG
/*! @brief OpenGL profile hint and attribute.
 *
 *  OpenGL profile [hint](@ref GLFW_OPENGL_PROFILE_hint) and
 *  [attribute](@ref GLFW_OPENGL_PROFILE_attrib).
 */
#define GLFW_OPENGL_PROFILE         0x00022008
/*! @brief Context flush-on-release hint and attribute.
 *
 *  Context flush-on-release [hint](@ref GLFW_CONTEXT_RELEASE_BEHAVIOR_hint) and
 *  [attribute](@ref GLFW_CONTEXT_RELEASE_BEHAVIOR_attrib).
 */
#define GLFW_CONTEXT_RELEASE_BEHAVIOR 0x00022009
/*! @brief Context error suppression hint and attribute.
 *
 *  Context error suppression [hint](@ref GLFW_CONTEXT_NO_ERROR_hint) and
 *  [attribute](@ref GLFW_CONTEXT_NO_ERROR_attrib).
 */
#define GLFW_CONTEXT_NO_ERROR       0x0002200A
/*! @brief Context creation API hint and attribute.
 *
 *  Context creation API [hint](@ref GLFW_CONTEXT_CREATION_API_hint) and
 *  [attribute](@ref GLFW_CONTEXT_CREATION_API_attrib).
 */
#define GLFW_CONTEXT_CREATION_API   0x0002200B
/*! @brief Window content area scaling window
 *  [window hint](@ref GLFW_SCALE_TO_MONITOR).
 */
#define GLFW_SCALE_TO_MONITOR       0x0002200C
/*! @brief macOS specific
 *  [window hint](@ref GLFW_COCOA_RETINA_FRAMEBUFFER_hint).
 */
#define GLFW_COCOA_RETINA_FRAMEBUFFER 0x00023001
/*! @brief macOS specific
 *  [window hint](@ref GLFW_COCOA_FRAME_NAME_hint).
 */
#define GLFW_COCOA_FRAME_NAME         0x00023002
/*! @brief macOS specific
 *  [window hint](@ref GLFW_COCOA_GRAPHICS_SWITCHING_hint).
 */
#define GLFW_COCOA_GRAPHICS_SWITCHING 0x00023003
/*! @brief macOS specific
 *  [window hint](@ref GLFW_COCOA_COLOR_SPACE_hint).
 */
#define GLFW_COCOA_COLOR_SPACE 0x00023004
typedef enum {
    DEFAULT_COLORSPACE = 0,
    SRGB_COLORSPACE = 1,
    DISPLAY_P3_COLORSPACE = 2,
} GlfwCocoaColorSpaces;
/*! @brief Blur Radius. On macOS the actual radius is used. On Linux it is treated as a bool.
 *  [window hint](@ref GLFW_BLUR_RADIUS).
 */
#define GLFW_BLUR_RADIUS       0x0002305

/*! @brief X11 specific
 *  [window hint](@ref GLFW_X11_CLASS_NAME_hint).
 */
#define GLFW_X11_CLASS_NAME         0x00024001
/*! @brief X11 specific
 *  [window hint](@ref GLFW_X11_CLASS_NAME_hint).
 */
#define GLFW_X11_INSTANCE_NAME      0x00024002

#define GLFW_WAYLAND_APP_ID         0x00025001
#define GLFW_WAYLAND_BGCOLOR        0x00025002
/*! @} */

#define GLFW_NO_API                          0
#define GLFW_OPENGL_API             0x00030001
#define GLFW_OPENGL_ES_API          0x00030002

#define GLFW_NO_ROBUSTNESS                   0
#define GLFW_NO_RESET_NOTIFICATION  0x00031001
#define GLFW_LOSE_CONTEXT_ON_RESET  0x00031002

#define GLFW_OPENGL_ANY_PROFILE              0
#define GLFW_OPENGL_CORE_PROFILE    0x00032001
#define GLFW_OPENGL_COMPAT_PROFILE  0x00032002

#define GLFW_CURSOR                 0x00033001
#define GLFW_STICKY_KEYS            0x00033002
#define GLFW_STICKY_MOUSE_BUTTONS   0x00033003
#define GLFW_LOCK_KEY_MODS          0x00033004
#define GLFW_RAW_MOUSE_MOTION       0x00033005

#define GLFW_CURSOR_NORMAL          0x00034001
#define GLFW_CURSOR_HIDDEN          0x00034002
#define GLFW_CURSOR_DISABLED        0x00034003

#define GLFW_ANY_RELEASE_BEHAVIOR            0
#define GLFW_RELEASE_BEHAVIOR_FLUSH 0x00035001
#define GLFW_RELEASE_BEHAVIOR_NONE  0x00035002

#define GLFW_NATIVE_CONTEXT_API     0x00036001
#define GLFW_EGL_CONTEXT_API        0x00036002
#define GLFW_OSMESA_CONTEXT_API     0x00036003

#define GLFW_ANGLE_PLATFORM_TYPE_NONE    0x00037001
#define GLFW_ANGLE_PLATFORM_TYPE_OPENGL  0x00037002
#define GLFW_ANGLE_PLATFORM_TYPE_OPENGLES 0x00037003
#define GLFW_ANGLE_PLATFORM_TYPE_D3D9    0x00037004
#define GLFW_ANGLE_PLATFORM_TYPE_D3D11   0x00037005
#define GLFW_ANGLE_PLATFORM_TYPE_VULKAN  0x00037007
#define GLFW_ANGLE_PLATFORM_TYPE_METAL   0x00037008

/*! @defgroup shapes Standard cursor shapes
 *  @brief Standard system cursor shapes.
 *
 *  See [standard cursor creation](@ref cursor_standard) for how these are used.
 *
 *  @ingroup input
 *  @{ */

typedef enum {
/* start mouse cursor shapes (auto generated by gen-key-constants.py do not edit) */
    GLFW_DEFAULT_CURSOR,
    GLFW_TEXT_CURSOR,
    GLFW_POINTER_CURSOR,
    GLFW_HELP_CURSOR,
    GLFW_WAIT_CURSOR,
    GLFW_PROGRESS_CURSOR,
    GLFW_CROSSHAIR_CURSOR,
    GLFW_CELL_CURSOR,
    GLFW_VERTICAL_TEXT_CURSOR,
    GLFW_MOVE_CURSOR,
    GLFW_E_RESIZE_CURSOR,
    GLFW_NE_RESIZE_CURSOR,
    GLFW_NW_RESIZE_CURSOR,
    GLFW_N_RESIZE_CURSOR,
    GLFW_SE_RESIZE_CURSOR,
    GLFW_SW_RESIZE_CURSOR,
    GLFW_S_RESIZE_CURSOR,
    GLFW_W_RESIZE_CURSOR,
    GLFW_EW_RESIZE_CURSOR,
    GLFW_NS_RESIZE_CURSOR,
    GLFW_NESW_RESIZE_CURSOR,
    GLFW_NWSE_RESIZE_CURSOR,
    GLFW_ZOOM_IN_CURSOR,
    GLFW_ZOOM_OUT_CURSOR,
    GLFW_ALIAS_CURSOR,
    GLFW_COPY_CURSOR,
    GLFW_NOT_ALLOWED_CURSOR,
    GLFW_NO_DROP_CURSOR,
    GLFW_GRAB_CURSOR,
    GLFW_GRABBING_CURSOR,
    GLFW_INVALID_CURSOR,
/* end mouse cursor shapes */
} GLFWCursorShape;
/*! @} */

#define GLFW_CONNECTED              0x00040001
#define GLFW_DISCONNECTED           0x00040002

/*! @addtogroup init
 *  @{ */
/*! @brief Joystick hat buttons init hint.
 *
 *  Joystick hat buttons [init hint](@ref GLFW_JOYSTICK_HAT_BUTTONS).
 */
#define GLFW_JOYSTICK_HAT_BUTTONS   0x00050001
/*! @brief ANGLE rendering backend init hint.
 *
 *  ANGLE rendering backend [init hint](@ref GLFW_ANGLE_PLATFORM_TYPE_hint).
 */
#define GLFW_ANGLE_PLATFORM_TYPE    0x00050002
#define GLFW_DEBUG_KEYBOARD         0x00050003
#define GLFW_DEBUG_RENDERING        0x00050004
/*! @brief macOS specific init hint.
 *
 *  macOS specific [init hint](@ref GLFW_COCOA_CHDIR_RESOURCES_hint).
 */
#define GLFW_COCOA_CHDIR_RESOURCES  0x00051001
/*! @brief macOS specific init hint.
 *
 *  macOS specific [init hint](@ref GLFW_COCOA_MENUBAR_hint).
 */
#define GLFW_COCOA_MENUBAR          0x00051002
#define GLFW_WAYLAND_IME            0x00051003
/*! @} */

#define GLFW_DONT_CARE              -1


/*************************************************************************
 * GLFW API types
 *************************************************************************/

/*! @brief Client API function pointer type.
 *
 *  Generic function pointer used for returning client API function pointers
 *  without forcing a cast from a regular pointer.
 *
 *  @sa @ref context_glext
 *  @sa @ref glfwGetProcAddress
 *
 *  @since Added in version 3.0.
 *
 *  @ingroup context
 */
typedef void (*GLFWglproc)(void);

/*! @brief Vulkan API function pointer type.
 *
 *  Generic function pointer used for returning Vulkan API function pointers
 *  without forcing a cast from a regular pointer.
 *
 *  @sa @ref vulkan_proc
 *  @sa @ref glfwGetInstanceProcAddress
 *
 *  @since Added in version 3.2.
 *
 *  @ingroup vulkan
 */
typedef void (*GLFWvkproc)(void);

/*! @brief Opaque monitor object.
 *
 *  Opaque monitor object.
 *
 *  @see @ref monitor_object
 *
 *  @since Added in version 3.0.
 *
 *  @ingroup monitor
 */
typedef struct GLFWmonitor GLFWmonitor;

/*! @brief Opaque window object.
 *
 *  Opaque window object.
 *
 *  @see @ref window_object
 *
 *  @since Added in version 3.0.
 *
 *  @ingroup window
 */
typedef struct GLFWwindow GLFWwindow;

/*! @brief Opaque cursor object.
 *
 *  Opaque cursor object.
 *
 *  @see @ref cursor_object
 *
 *  @since Added in version 3.1.
 *
 *  @ingroup input
 */
typedef struct GLFWcursor GLFWcursor;

typedef enum {
    GLFW_RELEASE = 0,
    GLFW_PRESS = 1,
    GLFW_REPEAT = 2
} GLFWKeyAction;

typedef enum {
    GLFW_IME_NONE,
    GLFW_IME_PREEDIT_CHANGED,
    GLFW_IME_COMMIT_TEXT,
    GLFW_IME_WAYLAND_DONE_EVENT,
} GLFWIMEState;

typedef enum {
    GLFW_IME_UPDATE_FOCUS = 1,
    GLFW_IME_UPDATE_CURSOR_POSITION = 2
} GLFWIMEUpdateType;

typedef struct GLFWIMEUpdateEvent {
    GLFWIMEUpdateType type;
    const char *before_text, *at_text, *after_text;
    bool focused;
    struct {
        int left, top, width, height;
    } cursor;
} GLFWIMEUpdateEvent;


typedef struct GLFWkeyevent
{
    // The [keyboard key](@ref keys) that was pressed or released.
    uint32_t key, shifted_key, alternate_key;

    // The platform-specific identifier of the key.
    int native_key;

    // The event action. Either `GLFW_PRESS`, `GLFW_RELEASE` or `GLFW_REPEAT`.
    GLFWKeyAction action;

    // Bit field describing which [modifier keys](@ref mods) were held down.
    int mods;

    // UTF-8 encoded text generated by this key event or empty string or NULL
    const char *text;

    // Used for Input Method events. Zero for normal key events.
    //   A value of GLFW_IME_PREEDIT_CHANGED means the pre-edit text for the input event has been changed.
    //   A value of GLFW_IME_COMMIT_TEXT means the text should be committed.
    GLFWIMEState ime_state;

    // For internal use only. On Linux it is the actual keycode reported by the windowing system, in contrast
    // to native_key which can be the result of a compose operation. On macOS it is the same as native_key.
    uint32_t native_key_id;

    // True if this is a synthesized event on focus change
    bool fake_event_on_focus_change;
} GLFWkeyevent;

typedef enum { GLFW_LAYER_SHELL_NONE, GLFW_LAYER_SHELL_BACKGROUND, GLFW_LAYER_SHELL_PANEL, GLFW_LAYER_SHELL_TOP, GLFW_LAYER_SHELL_OVERLAY } GLFWLayerShellType;

typedef enum { GLFW_EDGE_TOP, GLFW_EDGE_BOTTOM, GLFW_EDGE_LEFT, GLFW_EDGE_RIGHT, GLFW_EDGE_CENTER, GLFW_EDGE_NONE } GLFWEdge;

typedef enum { GLFW_FOCUS_NOT_ALLOWED, GLFW_FOCUS_EXCLUSIVE, GLFW_FOCUS_ON_DEMAND} GLFWFocusPolicy;

typedef struct GLFWLayerShellConfig {
    GLFWLayerShellType type;
    GLFWEdge edge;
    char output_name[64];
    GLFWFocusPolicy focus_policy;
    unsigned x_size_in_cells;
    unsigned y_size_in_cells;
    unsigned requested_top_margin;
    unsigned requested_left_margin;
    unsigned requested_bottom_margin;
    unsigned requested_right_margin;
    int requested_exclusive_zone;
    unsigned override_exclusive_zone;
    void (*size_callback)(GLFWwindow *window, const struct GLFWLayerShellConfig *config, unsigned monitor_width, unsigned monitor_height, uint32_t *width, uint32_t *height);
} GLFWLayerShellConfig;

typedef struct GLFWDBUSNotificationData {
    const char *app_name, *icon, *summary, *body, *category, **actions; size_t num_actions;
    int32_t timeout; uint8_t urgency; uint32_t replaces; int muted;
} GLFWDBUSNotificationData;

/*! @brief The function pointer type for error callbacks.
 *
 *  This is the function pointer type for error callbacks.  An error callback
 *  function has the following signature:
 *  @code
 *  void callback_name(int error_code, const char* description)
 *  @endcode
 *
 *  @param[in] error_code An [error code](@ref errors).  Future releases may add
 *  more error codes.
 *  @param[in] description A UTF-8 encoded string describing the error.
 *
 *  @pointer_lifetime The error description string is valid until the callback
 *  function returns.
 *
 *  @sa @ref error_handling
 *  @sa @ref glfwSetErrorCallback
 *
 *  @since Added in version 3.0.
 *
 *  @ingroup init
 */
typedef void (* GLFWerrorfun)(int,const char*);

/*! @brief The function pointer type for window position callbacks.
 *
 *  This is the function pointer type for window position callbacks.  A window
 *  position callback function has the following signature:
 *  @code
 *  void callback_name(GLFWwindow* window, int xpos, int ypos)
 *  @endcode
 *
 *  @param[in] window The window that was moved.
 *  @param[in] xpos The new x-coordinate, in screen coordinates, of the
 *  upper-left corner of the content area of the window.
 *  @param[in] ypos The new y-coordinate, in screen coordinates, of the
 *  upper-left corner of the content area of the window.
 *
 *  @sa @ref window_pos
 *  @sa @ref glfwSetWindowPosCallback
 *
 *  @since Added in version 3.0.
 *
 *  @ingroup window
 */
typedef void (* GLFWwindowposfun)(GLFWwindow*,int,int);

/*! @brief The function pointer type for window size callbacks.
 *
 *  This is the function pointer type for window size callbacks.  A window size
 *  callback function has the following signature:
 *  @code
 *  void callback_name(GLFWwindow* window, int width, int height)
 *  @endcode
 *
 *  @param[in] window The window that was resized.
 *  @param[in] width The new width, in screen coordinates, of the window.
 *  @param[in] height The new height, in screen coordinates, of the window.
 *
 *  @sa @ref window_size
 *  @sa @ref glfwSetWindowSizeCallback
 *
 *  @since Added in version 1.0.
 *  @glfw3 Added window handle parameter.
 *
 *  @ingroup window
 */
typedef void (* GLFWwindowsizefun)(GLFWwindow*,int,int);

/*! @brief The function pointer type for window close callbacks.
 *
 *  This is the function pointer type for window close callbacks.  A window
 *  close callback function has the following signature:
 *  @code
 *  void function_name(GLFWwindow* window)
 *  @endcode
 *
 *  @param[in] window The window that the user attempted to close.
 *
 *  @sa @ref window_close
 *  @sa @ref glfwSetWindowCloseCallback
 *
 *  @since Added in version 2.5.
 *  @glfw3 Added window handle parameter.
 *
 *  @ingroup window
 */
typedef void (* GLFWwindowclosefun)(GLFWwindow*);

/*! @brief The function pointer type for application close callbacks.
 *
 *  This is the function pointer type for application close callbacks.  A application
 *  close callback function has the following signature:
 *  @code
 *  void function_name(int flags)
 *  @endcode
 *
 *  @param[in] flags 0 for a user requested application quit, 1 if a fatal error occurred and application should quit ASAP
 *
 *  @sa @ref glfwSetApplicationCloseCallback
 *
 *  @ingroup window
 */
typedef void (* GLFWapplicationclosefun)(int);

/*! @brief The function pointer type for system color theme change callbacks.
 *
 *  This is the function pointer type for system color theme changes.
 *  @code
 *  void function_name(GLFWColorScheme theme_type, bool is_initial_value)
 *  @endcode
 *
 *  @param[in] theme_type 0 for unknown, 1 for dark and 2 for light
 *  @param[in] is_initial_value true if this is the initial read of the color theme on systems where it is asynchronous such as Linux
 *
 *  @sa @ref glfwSetSystemColorThemeChangeCallback
 *
 *  @ingroup window
 */
typedef void (* GLFWsystemcolorthemechangefun)(GLFWColorScheme, bool);


/*! @brief The function pointer type for window content refresh callbacks.
 *
 *  This is the function pointer type for window content refresh callbacks.
 *  A window content refresh callback function has the following signature:
 *  @code
 *  void function_name(GLFWwindow* window);
 *  @endcode
 *
 *  @param[in] window The window whose content needs to be refreshed.
 *
 *  @sa @ref window_refresh
 *  @sa @ref glfwSetWindowRefreshCallback
 *
 *  @since Added in version 2.5.
 *  @glfw3 Added window handle parameter.
 *
 *  @ingroup window
 */
typedef void (* GLFWwindowrefreshfun)(GLFWwindow*);

/*! @brief The function pointer type for window focus callbacks.
 *
 *  This is the function pointer type for window focus callbacks.  A window
 *  focus callback function has the following signature:
 *  @code
 *  void function_name(GLFWwindow* window, int focused)
 *  @endcode
 *
 *  @param[in] window The window that gained or lost input focus.
 *  @param[in] focused `true` if the window was given input focus, or
 *  `false` if it lost it.
 *
 *  @sa @ref window_focus
 *  @sa @ref glfwSetWindowFocusCallback
 *
 *  @since Added in version 3.0.
 *
 *  @ingroup window
 */
typedef void (* GLFWwindowfocusfun)(GLFWwindow*,int);

/*! @brief The function signature for window occlusion callbacks.
 *
 *  This is the function signature for window occlusion callback functions.
 *
 *  @param[in] window The window whose occlusion state changed.
 *  @param[in] occluded `true` if the window was occluded, or `false`
 *  if the window is no longer occluded.
 *
 *  @sa @ref window_occlusion
 *  @sa @ref glfwSetWindowOcclusionCallback
 *
 *  @since Added in version 3.3.
 *
 *  @ingroup window
 */
typedef void (* GLFWwindowocclusionfun)(GLFWwindow*, bool);


/*! @brief The function pointer type for window iconify callbacks.
 *
 *  This is the function pointer type for window iconify callbacks.  A window
 *  iconify callback function has the following signature:
 *  @code
 *  void function_name(GLFWwindow* window, int iconified)
 *  @endcode
 *
 *  @param[in] window The window that was iconified or restored.
 *  @param[in] iconified `true` if the window was iconified, or
 *  `false` if it was restored.
 *
 *  @sa @ref window_iconify
 *  @sa @ref glfwSetWindowIconifyCallback
 *
 *  @since Added in version 3.0.
 *
 *  @ingroup window
 */
typedef void (* GLFWwindowiconifyfun)(GLFWwindow*,int);

/*! @brief The function pointer type for window maximize callbacks.
 *
 *  This is the function pointer type for window maximize callbacks.  A window
 *  maximize callback function has the following signature:
 *  @code
 *  void function_name(GLFWwindow* window, int maximized)
 *  @endcode
 *
 *  @param[in] window The window that was maximized or restored.
 *  @param[in] maximized `true` if the window was maximized, or
 *  `false` if it was restored.
 *
 *  @sa @ref window_maximize
 *  @sa glfwSetWindowMaximizeCallback
 *
 *  @since Added in version 3.3.
 *
 *  @ingroup window
 */
typedef void (* GLFWwindowmaximizefun)(GLFWwindow*,int);

/*! @brief The function pointer type for framebuffer size callbacks.
 *
 *  This is the function pointer type for framebuffer size callbacks.
 *  A framebuffer size callback function has the following signature:
 *  @code
 *  void function_name(GLFWwindow* window, int width, int height)
 *  @endcode
 *
 *  @param[in] window The window whose framebuffer was resized.
 *  @param[in] width The new width, in pixels, of the framebuffer.
 *  @param[in] height The new height, in pixels, of the framebuffer.
 *
 *  @sa @ref window_fbsize
 *  @sa @ref glfwSetFramebufferSizeCallback
 *
 *  @since Added in version 3.0.
 *
 *  @ingroup window
 */
typedef void (* GLFWframebuffersizefun)(GLFWwindow*,int,int);

/*! @brief The function pointer type for window content scale callbacks.
 *
 *  This is the function pointer type for window content scale callbacks.
 *  A window content scale callback function has the following signature:
 *  @code
 *  void function_name(GLFWwindow* window, float xscale, float yscale)
 *  @endcode
 *
 *  @param[in] window The window whose content scale changed.
 *  @param[in] xscale The new x-axis content scale of the window.
 *  @param[in] yscale The new y-axis content scale of the window.
 *
 *  @sa @ref window_scale
 *  @sa @ref glfwSetWindowContentScaleCallback
 *
 *  @since Added in version 3.3.
 *
 *  @ingroup window
 */
typedef void (* GLFWwindowcontentscalefun)(GLFWwindow*,float,float);

/*! @brief The function pointer type for mouse button callbacks.
 *
 *  This is the function pointer type for mouse button callback functions.
 *  A mouse button callback function has the following signature:
 *  @code
 *  void function_name(GLFWwindow* window, int button, int action, int mods)
 *  @endcode
 *
 *  @param[in] window The window that received the event.
 *  @param[in] button The [mouse button](@ref buttons) that was pressed or
 *  released.
 *  @param[in] action One of `GLFW_PRESS` or `GLFW_RELEASE`.  Future releases
 *  may add more actions.
 *  @param[in] mods Bit field describing which [modifier keys](@ref mods) were
 *  held down.
 *
 *  @sa @ref input_mouse_button
 *  @sa @ref glfwSetMouseButtonCallback
 *
 *  @since Added in version 1.0.
 *  @glfw3 Added window handle and modifier mask parameters.
 *
 *  @ingroup input
 */
typedef void (* GLFWmousebuttonfun)(GLFWwindow*,int,int,int);

/*! @brief The function pointer type for cursor position callbacks.
 *
 *  This is the function pointer type for cursor position callbacks.  A cursor
 *  position callback function has the following signature:
 *  @code
 *  void function_name(GLFWwindow* window, double xpos, double ypos);
 *  @endcode
 *
 *  @param[in] window The window that received the event.
 *  @param[in] xpos The new cursor x-coordinate, relative to the left edge of
 *  the content area.
 *  @param[in] ypos The new cursor y-coordinate, relative to the top edge of the
 *  content area.
 *
 *  @sa @ref cursor_pos
 *  @sa @ref glfwSetCursorPosCallback
 *
 *  @since Added in version 3.0.  Replaces `GLFWmouseposfun`.
 *
 *  @ingroup input
 */
typedef void (* GLFWcursorposfun)(GLFWwindow*,double,double);

/*! @brief The function pointer type for cursor enter/leave callbacks.
 *
 *  This is the function pointer type for cursor enter/leave callbacks.
 *  A cursor enter/leave callback function has the following signature:
 *  @code
 *  void function_name(GLFWwindow* window, int entered)
 *  @endcode
 *
 *  @param[in] window The window that received the event.
 *  @param[in] entered `true` if the cursor entered the window's content
 *  area, or `false` if it left it.
 *
 *  @sa @ref cursor_enter
 *  @sa @ref glfwSetCursorEnterCallback
 *
 *  @since Added in version 3.0.
 *
 *  @ingroup input
 */
typedef void (* GLFWcursorenterfun)(GLFWwindow*,int);

/*! @brief The function pointer type for scroll callbacks.
 *
 *  This is the function pointer type for scroll callbacks.  A scroll callback
 *  function has the following signature:
 *  @code
 *  void function_name(GLFWwindow* window, double xoffset, double yoffset)
 *  @endcode
 *
 *  @param[in] window The window that received the event.
 *  @param[in] xoffset The scroll offset along the x-axis.
 *  @param[in] yoffset The scroll offset along the y-axis.
 *  @param[in] flags A bit-mask providing extra data about the event.
 *  flags & 1 will be true if and only if the offset values are "high-precision",
 *  typically pixel values. Otherwise the offset values are number of lines.
 *  (flags >> 1) & 7 will have value 1 for the start of momentum scrolling,
 *  value 2 for stationary momentum scrolling, value 3 for momentum scrolling
 *  in progress, value 4 for momentum scrolling ended, value 5 for momentum
 *  scrolling cancelled and value 6 if scrolling may begin soon.
 *  @param[int] mods The keyboard modifiers
 *
 *  @sa @ref scrolling
 *  @sa @ref glfwSetScrollCallback
 *
 *  @since Added in version 3.0.  Replaces `GLFWmousewheelfun`.
 *  @since Changed in version 4.0.  Added `flags` parameter.
 *
 *  @ingroup input
 */
typedef void (* GLFWscrollfun)(GLFWwindow*,double,double,int,int);

/*! @brief The function pointer type for key callbacks.
 *
 *  This is the function pointer type for key callbacks.  A keyboard
 *  key callback function has the following signature:
 *  @code
 *  void function_name(GLFWwindow* window, uint32_t key, int native_key, int action, int mods)
 *  @endcode
 *  The semantics of this function are that the key that is interacted with on the
 *  keyboard is reported, and the text, if any generated by the key is reported.
 *  So, for example, if on a US-ASCII keyboard the user presses Shift+= GLFW
 *  will report the text "+" and the key as GLFW_KEY_EQUAL. The reported key takes into
 *  account any current keyboard maps defined in the OS. So with a dvorak mapping, pressing
 *  the "s" key will generate text "o" and GLFW_KEY_O.
 *
 *  @param[in] window The window that received the event.
 *  @param[in] ev The key event, see GLFWkeyevent. The data in this event is only valid for
 *  the lifetime of the callback.
 *
 *  @note On X11/Wayland if a modifier other than the modifiers GLFW reports
 *  (ctrl/shift/alt/super) is used, GLFW will report the shifted key rather
 *  than the unshifted key. So for example, if ISO_Shift_Level_5 is used to
 *  convert the key A into UP GLFW will report the key as UP with no modifiers.
 *
 *  @sa @ref input_key
 *  @sa @ref glfwSetKeyboardCallback
 *
 *  @since Added in version 4.0.
 *
 *  @ingroup input
 */
typedef void (* GLFWkeyboardfun)(GLFWwindow*, GLFWkeyevent*);

/*! @brief The function pointer type for drag and drop callbacks.
 *
 *  This is the function pointer type for drop callbacks. A drop
 *  callback function has the following signature:
 *  @code
 *  int function_name(GLFWwindow* window, const char* mime, const char* text)
 *  @endcode
 *
 *  @param[in] window The window that received the event.
 *  @param[in] mime The UTF-8 encoded drop mime-type
 *  @param[in] data The dropped data or NULL for drag enter events
 *  @param[in] sz The size of the dropped data
 *  @return For drag events should return the priority for the specified mime type. A priority of zero
 *  or lower means the mime type is not accepted. Highest priority will be the finally accepted mime-type.
 *
 *  @pointer_lifetime The text is valid until the
 *  callback function returns.
 *
 *  @sa @ref path_drop
 *  @sa @ref glfwSetDropCallback
 *
 *  @since Added in version 3.1.
 *
 *  @ingroup input
 */
typedef int (* GLFWdropfun)(GLFWwindow*, const char *, const char*, size_t);

typedef void (* GLFWliveresizefun)(GLFWwindow*, bool);

/*! @brief The function pointer type for monitor configuration callbacks.
 *
 *  This is the function pointer type for monitor configuration callbacks.
 *  A monitor callback function has the following signature:
 *  @code
 *  void function_name(GLFWmonitor* monitor, int event)
 *  @endcode
 *
 *  @param[in] monitor The monitor that was connected or disconnected.
 *  @param[in] event One of `GLFW_CONNECTED` or `GLFW_DISCONNECTED`.  Future
 *  releases may add more events.
 *
 *  @sa @ref monitor_event
 *  @sa @ref glfwSetMonitorCallback
 *
 *  @since Added in version 3.0.
 *
 *  @ingroup monitor
 */
typedef void (* GLFWmonitorfun)(GLFWmonitor*,int);

/*! @brief The function pointer type for joystick configuration callbacks.
 *
 *  This is the function pointer type for joystick configuration callbacks.
 *  A joystick configuration callback function has the following signature:
 *  @code
 *  void function_name(int jid, int event)
 *  @endcode
 *
 *  @param[in] jid The joystick that was connected or disconnected.
 *  @param[in] event One of `GLFW_CONNECTED` or `GLFW_DISCONNECTED`.  Future
 *  releases may add more events.
 *
 *  @sa @ref joystick_event
 *  @sa @ref glfwSetJoystickCallback
 *
 *  @since Added in version 3.2.
 *
 *  @ingroup input
 */
typedef void (* GLFWjoystickfun)(int,int);

typedef void (* GLFWuserdatafun)(unsigned long long, void*);
typedef void (* GLFWtickcallback)(void*);
typedef void (* GLFWactivationcallback)(GLFWwindow *window, const char *token, void *data);
typedef bool (* GLFWdrawtextfun)(GLFWwindow *window, const char *text, uint32_t fg, uint32_t bg, uint8_t *output_buf, size_t width, size_t height, float x_offset, float y_offset, size_t right_margin, bool is_single_glyph);
typedef char* (* GLFWcurrentselectionfun)(void);
typedef bool (* GLFWhascurrentselectionfun)(void);
typedef void (* GLFWclipboarddatafreefun)(void* data);
typedef struct GLFWDataChunk {
    const char *data;
    size_t sz;
    GLFWclipboarddatafreefun free;
    void *iter, *free_data;
} GLFWDataChunk;
typedef enum {
    GLFW_CLIPBOARD, GLFW_PRIMARY_SELECTION
} GLFWClipboardType;
typedef GLFWDataChunk (* GLFWclipboarditerfun)(const char *mime_type, void *iter, GLFWClipboardType ctype);
typedef bool (* GLFWclipboardwritedatafun)(void *object, const char *data, size_t sz);
typedef bool (* GLFWimecursorpositionfun)(GLFWwindow *window, GLFWIMEUpdateEvent *ev);

/*! @brief Video mode type.
 *
 *  This describes a single video mode.
 *
 *  @sa @ref monitor_modes
 *  @sa @ref glfwGetVideoMode
 *  @sa @ref glfwGetVideoModes
 *
 *  @since Added in version 1.0.
 *  @glfw3 Added refresh rate member.
 *
 *  @ingroup monitor
 */
typedef struct GLFWvidmode
{
    /*! The width, in screen coordinates, of the video mode.
     */
    int width;
    /*! The height, in screen coordinates, of the video mode.
     */
    int height;
    /*! The bit depth of the red channel of the video mode.
     */
    int redBits;
    /*! The bit depth of the green channel of the video mode.
     */
    int greenBits;
    /*! The bit depth of the blue channel of the video mode.
     */
    int blueBits;
    /*! The refresh rate, in Hz, of the video mode.
     */
    int refreshRate;
} GLFWvidmode;

/*! @brief Gamma ramp.
 *
 *  This describes the gamma ramp for a monitor.
 *
 *  @sa @ref monitor_gamma
 *  @sa @ref glfwGetGammaRamp
 *  @sa @ref glfwSetGammaRamp
 *
 *  @since Added in version 3.0.
 *
 *  @ingroup monitor
 */
typedef struct GLFWgammaramp
{
    /*! An array of value describing the response of the red channel.
     */
    unsigned short* red;
    /*! An array of value describing the response of the green channel.
     */
    unsigned short* green;
    /*! An array of value describing the response of the blue channel.
     */
    unsigned short* blue;
    /*! The number of elements in each array.
     */
    unsigned int size;
} GLFWgammaramp;

/*! @brief Image data.
 *
 *  This describes a single 2D image.  See the documentation for each related
 *  function what the expected pixel format is.
 *
 *  @sa @ref cursor_custom
 *  @sa @ref window_icon
 *
 *  @since Added in version 2.1.
 *  @glfw3 Removed format and bytes-per-pixel members.
 *
 *  @ingroup window
 */
typedef struct GLFWimage
{
    /*! The width, in pixels, of this image.
     */
    int width;
    /*! The height, in pixels, of this image.
     */
    int height;
    /*! The pixel data of this image, arranged left-to-right, top-to-bottom.
     */
    unsigned char* pixels;
} GLFWimage;

/*! @brief Gamepad input state
 *
 *  This describes the input state of a gamepad.
 *
 *  @sa @ref gamepad
 *  @sa @ref glfwGetGamepadState
 *
 *  @since Added in version 3.3.
 *
 *  @ingroup input
 */
typedef struct GLFWgamepadstate
{
    /*! The states of each [gamepad button](@ref gamepad_buttons), `GLFW_PRESS`
     *  or `GLFW_RELEASE`.
     */
    unsigned char buttons[15];
    /*! The states of each [gamepad axis](@ref gamepad_axes), in the range -1.0
     *  to 1.0 inclusive.
     */
    float axes[6];
} GLFWgamepadstate;


/*************************************************************************
 * GLFW API functions
 *************************************************************************/

/*! @brief Initializes the GLFW library.
 *
 *  This function initializes the GLFW library.  Before most GLFW functions can
 *  be used, GLFW must be initialized, and before an application terminates GLFW
 *  should be terminated in order to free any resources allocated during or
 *  after initialization.
 *
 *  If this function fails, it calls @ref glfwTerminate before returning.  If it
 *  succeeds, you should call @ref glfwTerminate before the application exits.
 *
 *  Additional calls to this function after successful initialization but before
 *  termination will return `true` immediately.
 *
 *  @return `true` if successful, or `false` if an
 *  [error](@ref error_handling) occurred.
 *
 *  @errors Possible errors include @ref GLFW_PLATFORM_ERROR.
 *
 *  @remark @macos This function will change the current directory of the
 *  application to the `Contents/Resources` subdirectory of the application's
 *  bundle, if present.  This can be disabled with the @ref
 *  GLFW_COCOA_CHDIR_RESOURCES init hint.
 *
 *  @thread_safety This function must only be called from the main thread.
 *
 *  @sa @ref intro_init
 *  @sa @ref glfwTerminate
 *
 *  @since Added in version 1.0.
 *
 *  @ingroup init
 */


typedef int (* GLFWcocoatextinputfilterfun)(int,int,unsigned int,unsigned long);
typedef bool (* GLFWapplicationshouldhandlereopenfun)(int);
typedef bool (* GLFWhandleurlopen)(const char*);
typedef void (* GLFWapplicationwillfinishlaunchingfun)(void);
typedef bool (* GLFWcocoatogglefullscreenfun)(GLFWwindow*);
typedef void (* GLFWcocoarenderframefun)(GLFWwindow*);
typedef void (*GLFWwaylandframecallbackfunc)(unsigned long long id);
typedef void (*GLFWDBusnotificationcreatedfun)(unsigned long long, uint32_t, void*);
typedef void (*GLFWDBusnotificationactivatedfun)(uint32_t, int, const char*);
typedef int (*glfwInit_func)(monotonic_t, bool*);
GFW_EXTERN glfwInit_func glfwInit_impl;
#define glfwInit glfwInit_impl

typedef void (*glfwRunMainLoop_func)(GLFWtickcallback, void*);
GFW_EXTERN glfwRunMainLoop_func glfwRunMainLoop_impl;
#define glfwRunMainLoop glfwRunMainLoop_impl

typedef void (*glfwStopMainLoop_func)(void);
GFW_EXTERN glfwStopMainLoop_func glfwStopMainLoop_impl;
#define glfwStopMainLoop glfwStopMainLoop_impl

typedef unsigned long long (*glfwAddTimer_func)(monotonic_t, bool, GLFWuserdatafun, void *, GLFWuserdatafun);
GFW_EXTERN glfwAddTimer_func glfwAddTimer_impl;
#define glfwAddTimer glfwAddTimer_impl

typedef void (*glfwUpdateTimer_func)(unsigned long long, monotonic_t, bool);
GFW_EXTERN glfwUpdateTimer_func glfwUpdateTimer_impl;
#define glfwUpdateTimer glfwUpdateTimer_impl

typedef void (*glfwRemoveTimer_func)(unsigned long);
GFW_EXTERN glfwRemoveTimer_func glfwRemoveTimer_impl;
#define glfwRemoveTimer glfwRemoveTimer_impl

typedef GLFWdrawtextfun (*glfwSetDrawTextFunction_func)(GLFWdrawtextfun);
GFW_EXTERN glfwSetDrawTextFunction_func glfwSetDrawTextFunction_impl;
#define glfwSetDrawTextFunction glfwSetDrawTextFunction_impl

typedef GLFWcurrentselectionfun (*glfwSetCurrentSelectionCallback_func)(GLFWcurrentselectionfun);
GFW_EXTERN glfwSetCurrentSelectionCallback_func glfwSetCurrentSelectionCallback_impl;
#define glfwSetCurrentSelectionCallback glfwSetCurrentSelectionCallback_impl

typedef GLFWhascurrentselectionfun (*glfwSetHasCurrentSelectionCallback_func)(GLFWhascurrentselectionfun);
GFW_EXTERN glfwSetHasCurrentSelectionCallback_func glfwSetHasCurrentSelectionCallback_impl;
#define glfwSetHasCurrentSelectionCallback glfwSetHasCurrentSelectionCallback_impl

typedef GLFWimecursorpositionfun (*glfwSetIMECursorPositionCallback_func)(GLFWimecursorpositionfun);
GFW_EXTERN glfwSetIMECursorPositionCallback_func glfwSetIMECursorPositionCallback_impl;
#define glfwSetIMECursorPositionCallback glfwSetIMECursorPositionCallback_impl

typedef void (*glfwTerminate_func)(void);
GFW_EXTERN glfwTerminate_func glfwTerminate_impl;
#define glfwTerminate glfwTerminate_impl

typedef void (*glfwInitHint_func)(int, int);
GFW_EXTERN glfwInitHint_func glfwInitHint_impl;
#define glfwInitHint glfwInitHint_impl

typedef void (*glfwGetVersion_func)(int*, int*, int*);
GFW_EXTERN glfwGetVersion_func glfwGetVersion_impl;
#define glfwGetVersion glfwGetVersion_impl

typedef const char* (*glfwGetVersionString_func)(void);
GFW_EXTERN glfwGetVersionString_func glfwGetVersionString_impl;
#define glfwGetVersionString glfwGetVersionString_impl

typedef int (*glfwGetError_func)(const char**);
GFW_EXTERN glfwGetError_func glfwGetError_impl;
#define glfwGetError glfwGetError_impl

typedef GLFWerrorfun (*glfwSetErrorCallback_func)(GLFWerrorfun);
GFW_EXTERN glfwSetErrorCallback_func glfwSetErrorCallback_impl;
#define glfwSetErrorCallback glfwSetErrorCallback_impl

typedef GLFWmonitor** (*glfwGetMonitors_func)(int*);
GFW_EXTERN glfwGetMonitors_func glfwGetMonitors_impl;
#define glfwGetMonitors glfwGetMonitors_impl

typedef GLFWmonitor* (*glfwGetPrimaryMonitor_func)(void);
GFW_EXTERN glfwGetPrimaryMonitor_func glfwGetPrimaryMonitor_impl;
#define glfwGetPrimaryMonitor glfwGetPrimaryMonitor_impl

typedef void (*glfwGetMonitorPos_func)(GLFWmonitor*, int*, int*);
GFW_EXTERN glfwGetMonitorPos_func glfwGetMonitorPos_impl;
#define glfwGetMonitorPos glfwGetMonitorPos_impl

typedef void (*glfwGetMonitorWorkarea_func)(GLFWmonitor*, int*, int*, int*, int*);
GFW_EXTERN glfwGetMonitorWorkarea_func glfwGetMonitorWorkarea_impl;
#define glfwGetMonitorWorkarea glfwGetMonitorWorkarea_impl

typedef void (*glfwGetMonitorPhysicalSize_func)(GLFWmonitor*, int*, int*);
GFW_EXTERN glfwGetMonitorPhysicalSize_func glfwGetMonitorPhysicalSize_impl;
#define glfwGetMonitorPhysicalSize glfwGetMonitorPhysicalSize_impl

typedef void (*glfwGetMonitorContentScale_func)(GLFWmonitor*, float*, float*);
GFW_EXTERN glfwGetMonitorContentScale_func glfwGetMonitorContentScale_impl;
#define glfwGetMonitorContentScale glfwGetMonitorContentScale_impl

typedef const char* (*glfwGetMonitorName_func)(GLFWmonitor*);
GFW_EXTERN glfwGetMonitorName_func glfwGetMonitorName_impl;
#define glfwGetMonitorName glfwGetMonitorName_impl

typedef void (*glfwSetMonitorUserPointer_func)(GLFWmonitor*, void*);
GFW_EXTERN glfwSetMonitorUserPointer_func glfwSetMonitorUserPointer_impl;
#define glfwSetMonitorUserPointer glfwSetMonitorUserPointer_impl

typedef void* (*glfwGetMonitorUserPointer_func)(GLFWmonitor*);
GFW_EXTERN glfwGetMonitorUserPointer_func glfwGetMonitorUserPointer_impl;
#define glfwGetMonitorUserPointer glfwGetMonitorUserPointer_impl

typedef GLFWmonitorfun (*glfwSetMonitorCallback_func)(GLFWmonitorfun);
GFW_EXTERN glfwSetMonitorCallback_func glfwSetMonitorCallback_impl;
#define glfwSetMonitorCallback glfwSetMonitorCallback_impl

typedef const GLFWvidmode* (*glfwGetVideoModes_func)(GLFWmonitor*, int*);
GFW_EXTERN glfwGetVideoModes_func glfwGetVideoModes_impl;
#define glfwGetVideoModes glfwGetVideoModes_impl

typedef const GLFWvidmode* (*glfwGetVideoMode_func)(GLFWmonitor*);
GFW_EXTERN glfwGetVideoMode_func glfwGetVideoMode_impl;
#define glfwGetVideoMode glfwGetVideoMode_impl

typedef void (*glfwSetGamma_func)(GLFWmonitor*, float);
GFW_EXTERN glfwSetGamma_func glfwSetGamma_impl;
#define glfwSetGamma glfwSetGamma_impl

typedef const GLFWgammaramp* (*glfwGetGammaRamp_func)(GLFWmonitor*);
GFW_EXTERN glfwGetGammaRamp_func glfwGetGammaRamp_impl;
#define glfwGetGammaRamp glfwGetGammaRamp_impl

typedef void (*glfwSetGammaRamp_func)(GLFWmonitor*, const GLFWgammaramp*);
GFW_EXTERN glfwSetGammaRamp_func glfwSetGammaRamp_impl;
#define glfwSetGammaRamp glfwSetGammaRamp_impl

typedef void (*glfwDefaultWindowHints_func)(void);
GFW_EXTERN glfwDefaultWindowHints_func glfwDefaultWindowHints_impl;
#define glfwDefaultWindowHints glfwDefaultWindowHints_impl

typedef void (*glfwWindowHint_func)(int, int);
GFW_EXTERN glfwWindowHint_func glfwWindowHint_impl;
#define glfwWindowHint glfwWindowHint_impl

typedef void (*glfwWindowHintString_func)(int, const char*);
GFW_EXTERN glfwWindowHintString_func glfwWindowHintString_impl;
#define glfwWindowHintString glfwWindowHintString_impl

typedef GLFWwindow* (*glfwCreateWindow_func)(int, int, const char*, GLFWmonitor*, GLFWwindow*);
GFW_EXTERN glfwCreateWindow_func glfwCreateWindow_impl;
#define glfwCreateWindow glfwCreateWindow_impl

typedef bool (*glfwToggleFullscreen_func)(GLFWwindow*, unsigned int);
GFW_EXTERN glfwToggleFullscreen_func glfwToggleFullscreen_impl;
#define glfwToggleFullscreen glfwToggleFullscreen_impl

typedef bool (*glfwIsFullscreen_func)(GLFWwindow*, unsigned int);
GFW_EXTERN glfwIsFullscreen_func glfwIsFullscreen_impl;
#define glfwIsFullscreen glfwIsFullscreen_impl

typedef bool (*glfwAreSwapsAllowed_func)(const GLFWwindow*);
GFW_EXTERN glfwAreSwapsAllowed_func glfwAreSwapsAllowed_impl;
#define glfwAreSwapsAllowed glfwAreSwapsAllowed_impl

typedef void (*glfwDestroyWindow_func)(GLFWwindow*);
GFW_EXTERN glfwDestroyWindow_func glfwDestroyWindow_impl;
#define glfwDestroyWindow glfwDestroyWindow_impl

typedef int (*glfwWindowShouldClose_func)(GLFWwindow*);
GFW_EXTERN glfwWindowShouldClose_func glfwWindowShouldClose_impl;
#define glfwWindowShouldClose glfwWindowShouldClose_impl

typedef void (*glfwSetWindowShouldClose_func)(GLFWwindow*, int);
GFW_EXTERN glfwSetWindowShouldClose_func glfwSetWindowShouldClose_impl;
#define glfwSetWindowShouldClose glfwSetWindowShouldClose_impl

typedef void (*glfwSetWindowTitle_func)(GLFWwindow*, const char*);
GFW_EXTERN glfwSetWindowTitle_func glfwSetWindowTitle_impl;
#define glfwSetWindowTitle glfwSetWindowTitle_impl

typedef void (*glfwSetWindowIcon_func)(GLFWwindow*, int, const GLFWimage*);
GFW_EXTERN glfwSetWindowIcon_func glfwSetWindowIcon_impl;
#define glfwSetWindowIcon glfwSetWindowIcon_impl

typedef void (*glfwGetWindowPos_func)(GLFWwindow*, int*, int*);
GFW_EXTERN glfwGetWindowPos_func glfwGetWindowPos_impl;
#define glfwGetWindowPos glfwGetWindowPos_impl

typedef void (*glfwSetWindowPos_func)(GLFWwindow*, int, int);
GFW_EXTERN glfwSetWindowPos_func glfwSetWindowPos_impl;
#define glfwSetWindowPos glfwSetWindowPos_impl

typedef void (*glfwGetWindowSize_func)(GLFWwindow*, int*, int*);
GFW_EXTERN glfwGetWindowSize_func glfwGetWindowSize_impl;
#define glfwGetWindowSize glfwGetWindowSize_impl

typedef void (*glfwSetWindowSizeLimits_func)(GLFWwindow*, int, int, int, int);
GFW_EXTERN glfwSetWindowSizeLimits_func glfwSetWindowSizeLimits_impl;
#define glfwSetWindowSizeLimits glfwSetWindowSizeLimits_impl

typedef void (*glfwSetWindowSizeIncrements_func)(GLFWwindow*, int, int);
GFW_EXTERN glfwSetWindowSizeIncrements_func glfwSetWindowSizeIncrements_impl;
#define glfwSetWindowSizeIncrements glfwSetWindowSizeIncrements_impl

typedef void (*glfwSetWindowAspectRatio_func)(GLFWwindow*, int, int);
GFW_EXTERN glfwSetWindowAspectRatio_func glfwSetWindowAspectRatio_impl;
#define glfwSetWindowAspectRatio glfwSetWindowAspectRatio_impl

typedef void (*glfwSetWindowSize_func)(GLFWwindow*, int, int);
GFW_EXTERN glfwSetWindowSize_func glfwSetWindowSize_impl;
#define glfwSetWindowSize glfwSetWindowSize_impl

typedef void (*glfwGetFramebufferSize_func)(GLFWwindow*, int*, int*);
GFW_EXTERN glfwGetFramebufferSize_func glfwGetFramebufferSize_impl;
#define glfwGetFramebufferSize glfwGetFramebufferSize_impl

typedef void (*glfwGetWindowFrameSize_func)(GLFWwindow*, int*, int*, int*, int*);
GFW_EXTERN glfwGetWindowFrameSize_func glfwGetWindowFrameSize_impl;
#define glfwGetWindowFrameSize glfwGetWindowFrameSize_impl

typedef void (*glfwGetWindowContentScale_func)(GLFWwindow*, float*, float*);
GFW_EXTERN glfwGetWindowContentScale_func glfwGetWindowContentScale_impl;
#define glfwGetWindowContentScale glfwGetWindowContentScale_impl

typedef monotonic_t (*glfwGetDoubleClickInterval_func)(GLFWwindow*);
GFW_EXTERN glfwGetDoubleClickInterval_func glfwGetDoubleClickInterval_impl;
#define glfwGetDoubleClickInterval glfwGetDoubleClickInterval_impl

typedef float (*glfwGetWindowOpacity_func)(GLFWwindow*);
GFW_EXTERN glfwGetWindowOpacity_func glfwGetWindowOpacity_impl;
#define glfwGetWindowOpacity glfwGetWindowOpacity_impl

typedef void (*glfwSetWindowOpacity_func)(GLFWwindow*, float);
GFW_EXTERN glfwSetWindowOpacity_func glfwSetWindowOpacity_impl;
#define glfwSetWindowOpacity glfwSetWindowOpacity_impl

typedef void (*glfwIconifyWindow_func)(GLFWwindow*);
GFW_EXTERN glfwIconifyWindow_func glfwIconifyWindow_impl;
#define glfwIconifyWindow glfwIconifyWindow_impl

typedef void (*glfwRestoreWindow_func)(GLFWwindow*);
GFW_EXTERN glfwRestoreWindow_func glfwRestoreWindow_impl;
#define glfwRestoreWindow glfwRestoreWindow_impl

typedef void (*glfwMaximizeWindow_func)(GLFWwindow*);
GFW_EXTERN glfwMaximizeWindow_func glfwMaximizeWindow_impl;
#define glfwMaximizeWindow glfwMaximizeWindow_impl

typedef void (*glfwShowWindow_func)(GLFWwindow*);
GFW_EXTERN glfwShowWindow_func glfwShowWindow_impl;
#define glfwShowWindow glfwShowWindow_impl

typedef void (*glfwHideWindow_func)(GLFWwindow*);
GFW_EXTERN glfwHideWindow_func glfwHideWindow_impl;
#define glfwHideWindow glfwHideWindow_impl

typedef void (*glfwFocusWindow_func)(GLFWwindow*);
GFW_EXTERN glfwFocusWindow_func glfwFocusWindow_impl;
#define glfwFocusWindow glfwFocusWindow_impl

typedef void (*glfwRequestWindowAttention_func)(GLFWwindow*);
GFW_EXTERN glfwRequestWindowAttention_func glfwRequestWindowAttention_impl;
#define glfwRequestWindowAttention glfwRequestWindowAttention_impl

typedef int (*glfwWindowBell_func)(GLFWwindow*);
GFW_EXTERN glfwWindowBell_func glfwWindowBell_impl;
#define glfwWindowBell glfwWindowBell_impl

typedef GLFWmonitor* (*glfwGetWindowMonitor_func)(GLFWwindow*);
GFW_EXTERN glfwGetWindowMonitor_func glfwGetWindowMonitor_impl;
#define glfwGetWindowMonitor glfwGetWindowMonitor_impl

typedef void (*glfwSetWindowMonitor_func)(GLFWwindow*, GLFWmonitor*, int, int, int, int, int);
GFW_EXTERN glfwSetWindowMonitor_func glfwSetWindowMonitor_impl;
#define glfwSetWindowMonitor glfwSetWindowMonitor_impl

typedef int (*glfwGetWindowAttrib_func)(GLFWwindow*, int);
GFW_EXTERN glfwGetWindowAttrib_func glfwGetWindowAttrib_impl;
#define glfwGetWindowAttrib glfwGetWindowAttrib_impl

typedef void (*glfwSetWindowAttrib_func)(GLFWwindow*, int, int);
GFW_EXTERN glfwSetWindowAttrib_func glfwSetWindowAttrib_impl;
#define glfwSetWindowAttrib glfwSetWindowAttrib_impl

typedef int (*glfwSetWindowBlur_func)(GLFWwindow*, int);
GFW_EXTERN glfwSetWindowBlur_func glfwSetWindowBlur_impl;
#define glfwSetWindowBlur glfwSetWindowBlur_impl

typedef void (*glfwSetWindowUserPointer_func)(GLFWwindow*, void*);
GFW_EXTERN glfwSetWindowUserPointer_func glfwSetWindowUserPointer_impl;
#define glfwSetWindowUserPointer glfwSetWindowUserPointer_impl

typedef void* (*glfwGetWindowUserPointer_func)(GLFWwindow*);
GFW_EXTERN glfwGetWindowUserPointer_func glfwGetWindowUserPointer_impl;
#define glfwGetWindowUserPointer glfwGetWindowUserPointer_impl

typedef GLFWwindowposfun (*glfwSetWindowPosCallback_func)(GLFWwindow*, GLFWwindowposfun);
GFW_EXTERN glfwSetWindowPosCallback_func glfwSetWindowPosCallback_impl;
#define glfwSetWindowPosCallback glfwSetWindowPosCallback_impl

typedef GLFWwindowsizefun (*glfwSetWindowSizeCallback_func)(GLFWwindow*, GLFWwindowsizefun);
GFW_EXTERN glfwSetWindowSizeCallback_func glfwSetWindowSizeCallback_impl;
#define glfwSetWindowSizeCallback glfwSetWindowSizeCallback_impl

typedef GLFWwindowclosefun (*glfwSetWindowCloseCallback_func)(GLFWwindow*, GLFWwindowclosefun);
GFW_EXTERN glfwSetWindowCloseCallback_func glfwSetWindowCloseCallback_impl;
#define glfwSetWindowCloseCallback glfwSetWindowCloseCallback_impl

typedef GLFWapplicationclosefun (*glfwSetApplicationCloseCallback_func)(GLFWapplicationclosefun);
GFW_EXTERN glfwSetApplicationCloseCallback_func glfwSetApplicationCloseCallback_impl;
#define glfwSetApplicationCloseCallback glfwSetApplicationCloseCallback_impl

typedef GLFWsystemcolorthemechangefun (*glfwSetSystemColorThemeChangeCallback_func)(GLFWsystemcolorthemechangefun);
GFW_EXTERN glfwSetSystemColorThemeChangeCallback_func glfwSetSystemColorThemeChangeCallback_impl;
#define glfwSetSystemColorThemeChangeCallback glfwSetSystemColorThemeChangeCallback_impl

typedef GLFWColorScheme (*glfwGetCurrentSystemColorTheme_func)(bool);
GFW_EXTERN glfwGetCurrentSystemColorTheme_func glfwGetCurrentSystemColorTheme_impl;
#define glfwGetCurrentSystemColorTheme glfwGetCurrentSystemColorTheme_impl

typedef GLFWwindowrefreshfun (*glfwSetWindowRefreshCallback_func)(GLFWwindow*, GLFWwindowrefreshfun);
GFW_EXTERN glfwSetWindowRefreshCallback_func glfwSetWindowRefreshCallback_impl;
#define glfwSetWindowRefreshCallback glfwSetWindowRefreshCallback_impl

typedef GLFWwindowfocusfun (*glfwSetWindowFocusCallback_func)(GLFWwindow*, GLFWwindowfocusfun);
GFW_EXTERN glfwSetWindowFocusCallback_func glfwSetWindowFocusCallback_impl;
#define glfwSetWindowFocusCallback glfwSetWindowFocusCallback_impl

typedef GLFWwindowocclusionfun (*glfwSetWindowOcclusionCallback_func)(GLFWwindow*, GLFWwindowocclusionfun);
GFW_EXTERN glfwSetWindowOcclusionCallback_func glfwSetWindowOcclusionCallback_impl;
#define glfwSetWindowOcclusionCallback glfwSetWindowOcclusionCallback_impl

typedef GLFWwindowiconifyfun (*glfwSetWindowIconifyCallback_func)(GLFWwindow*, GLFWwindowiconifyfun);
GFW_EXTERN glfwSetWindowIconifyCallback_func glfwSetWindowIconifyCallback_impl;
#define glfwSetWindowIconifyCallback glfwSetWindowIconifyCallback_impl

typedef GLFWwindowmaximizefun (*glfwSetWindowMaximizeCallback_func)(GLFWwindow*, GLFWwindowmaximizefun);
GFW_EXTERN glfwSetWindowMaximizeCallback_func glfwSetWindowMaximizeCallback_impl;
#define glfwSetWindowMaximizeCallback glfwSetWindowMaximizeCallback_impl

typedef GLFWframebuffersizefun (*glfwSetFramebufferSizeCallback_func)(GLFWwindow*, GLFWframebuffersizefun);
GFW_EXTERN glfwSetFramebufferSizeCallback_func glfwSetFramebufferSizeCallback_impl;
#define glfwSetFramebufferSizeCallback glfwSetFramebufferSizeCallback_impl

typedef GLFWwindowcontentscalefun (*glfwSetWindowContentScaleCallback_func)(GLFWwindow*, GLFWwindowcontentscalefun);
GFW_EXTERN glfwSetWindowContentScaleCallback_func glfwSetWindowContentScaleCallback_impl;
#define glfwSetWindowContentScaleCallback glfwSetWindowContentScaleCallback_impl

typedef void (*glfwPostEmptyEvent_func)(void);
GFW_EXTERN glfwPostEmptyEvent_func glfwPostEmptyEvent_impl;
#define glfwPostEmptyEvent glfwPostEmptyEvent_impl

typedef bool (*glfwGetIgnoreOSKeyboardProcessing_func)(void);
GFW_EXTERN glfwGetIgnoreOSKeyboardProcessing_func glfwGetIgnoreOSKeyboardProcessing_impl;
#define glfwGetIgnoreOSKeyboardProcessing glfwGetIgnoreOSKeyboardProcessing_impl

typedef void (*glfwSetIgnoreOSKeyboardProcessing_func)(bool);
GFW_EXTERN glfwSetIgnoreOSKeyboardProcessing_func glfwSetIgnoreOSKeyboardProcessing_impl;
#define glfwSetIgnoreOSKeyboardProcessing glfwSetIgnoreOSKeyboardProcessing_impl

typedef int (*glfwGetInputMode_func)(GLFWwindow*, int);
GFW_EXTERN glfwGetInputMode_func glfwGetInputMode_impl;
#define glfwGetInputMode glfwGetInputMode_impl

typedef void (*glfwSetInputMode_func)(GLFWwindow*, int, int);
GFW_EXTERN glfwSetInputMode_func glfwSetInputMode_impl;
#define glfwSetInputMode glfwSetInputMode_impl

typedef int (*glfwRawMouseMotionSupported_func)(void);
GFW_EXTERN glfwRawMouseMotionSupported_func glfwRawMouseMotionSupported_impl;
#define glfwRawMouseMotionSupported glfwRawMouseMotionSupported_impl

typedef const char* (*glfwGetKeyName_func)(uint32_t, int);
GFW_EXTERN glfwGetKeyName_func glfwGetKeyName_impl;
#define glfwGetKeyName glfwGetKeyName_impl

typedef int (*glfwGetNativeKeyForKey_func)(uint32_t);
GFW_EXTERN glfwGetNativeKeyForKey_func glfwGetNativeKeyForKey_impl;
#define glfwGetNativeKeyForKey glfwGetNativeKeyForKey_impl

typedef GLFWKeyAction (*glfwGetKey_func)(GLFWwindow*, uint32_t);
GFW_EXTERN glfwGetKey_func glfwGetKey_impl;
#define glfwGetKey glfwGetKey_impl

typedef int (*glfwGetMouseButton_func)(GLFWwindow*, int);
GFW_EXTERN glfwGetMouseButton_func glfwGetMouseButton_impl;
#define glfwGetMouseButton glfwGetMouseButton_impl

typedef void (*glfwGetCursorPos_func)(GLFWwindow*, double*, double*);
GFW_EXTERN glfwGetCursorPos_func glfwGetCursorPos_impl;
#define glfwGetCursorPos glfwGetCursorPos_impl

typedef void (*glfwSetCursorPos_func)(GLFWwindow*, double, double);
GFW_EXTERN glfwSetCursorPos_func glfwSetCursorPos_impl;
#define glfwSetCursorPos glfwSetCursorPos_impl

typedef GLFWcursor* (*glfwCreateCursor_func)(const GLFWimage*, int, int, int);
GFW_EXTERN glfwCreateCursor_func glfwCreateCursor_impl;
#define glfwCreateCursor glfwCreateCursor_impl

typedef GLFWcursor* (*glfwCreateStandardCursor_func)(GLFWCursorShape);
GFW_EXTERN glfwCreateStandardCursor_func glfwCreateStandardCursor_impl;
#define glfwCreateStandardCursor glfwCreateStandardCursor_impl

typedef void (*glfwDestroyCursor_func)(GLFWcursor*);
GFW_EXTERN glfwDestroyCursor_func glfwDestroyCursor_impl;
#define glfwDestroyCursor glfwDestroyCursor_impl

typedef void (*glfwSetCursor_func)(GLFWwindow*, GLFWcursor*);
GFW_EXTERN glfwSetCursor_func glfwSetCursor_impl;
#define glfwSetCursor glfwSetCursor_impl

typedef GLFWkeyboardfun (*glfwSetKeyboardCallback_func)(GLFWwindow*, GLFWkeyboardfun);
GFW_EXTERN glfwSetKeyboardCallback_func glfwSetKeyboardCallback_impl;
#define glfwSetKeyboardCallback glfwSetKeyboardCallback_impl

typedef void (*glfwUpdateIMEState_func)(GLFWwindow*, const GLFWIMEUpdateEvent*);
GFW_EXTERN glfwUpdateIMEState_func glfwUpdateIMEState_impl;
#define glfwUpdateIMEState glfwUpdateIMEState_impl

typedef GLFWmousebuttonfun (*glfwSetMouseButtonCallback_func)(GLFWwindow*, GLFWmousebuttonfun);
GFW_EXTERN glfwSetMouseButtonCallback_func glfwSetMouseButtonCallback_impl;
#define glfwSetMouseButtonCallback glfwSetMouseButtonCallback_impl

typedef GLFWcursorposfun (*glfwSetCursorPosCallback_func)(GLFWwindow*, GLFWcursorposfun);
GFW_EXTERN glfwSetCursorPosCallback_func glfwSetCursorPosCallback_impl;
#define glfwSetCursorPosCallback glfwSetCursorPosCallback_impl

typedef GLFWcursorenterfun (*glfwSetCursorEnterCallback_func)(GLFWwindow*, GLFWcursorenterfun);
GFW_EXTERN glfwSetCursorEnterCallback_func glfwSetCursorEnterCallback_impl;
#define glfwSetCursorEnterCallback glfwSetCursorEnterCallback_impl

typedef GLFWscrollfun (*glfwSetScrollCallback_func)(GLFWwindow*, GLFWscrollfun);
GFW_EXTERN glfwSetScrollCallback_func glfwSetScrollCallback_impl;
#define glfwSetScrollCallback glfwSetScrollCallback_impl

typedef GLFWdropfun (*glfwSetDropCallback_func)(GLFWwindow*, GLFWdropfun);
GFW_EXTERN glfwSetDropCallback_func glfwSetDropCallback_impl;
#define glfwSetDropCallback glfwSetDropCallback_impl

typedef GLFWliveresizefun (*glfwSetLiveResizeCallback_func)(GLFWwindow*, GLFWliveresizefun);
GFW_EXTERN glfwSetLiveResizeCallback_func glfwSetLiveResizeCallback_impl;
#define glfwSetLiveResizeCallback glfwSetLiveResizeCallback_impl

typedef int (*glfwJoystickPresent_func)(int);
GFW_EXTERN glfwJoystickPresent_func glfwJoystickPresent_impl;
#define glfwJoystickPresent glfwJoystickPresent_impl

typedef const float* (*glfwGetJoystickAxes_func)(int, int*);
GFW_EXTERN glfwGetJoystickAxes_func glfwGetJoystickAxes_impl;
#define glfwGetJoystickAxes glfwGetJoystickAxes_impl

typedef const unsigned char* (*glfwGetJoystickButtons_func)(int, int*);
GFW_EXTERN glfwGetJoystickButtons_func glfwGetJoystickButtons_impl;
#define glfwGetJoystickButtons glfwGetJoystickButtons_impl

typedef const unsigned char* (*glfwGetJoystickHats_func)(int, int*);
GFW_EXTERN glfwGetJoystickHats_func glfwGetJoystickHats_impl;
#define glfwGetJoystickHats glfwGetJoystickHats_impl

typedef const char* (*glfwGetJoystickName_func)(int);
GFW_EXTERN glfwGetJoystickName_func glfwGetJoystickName_impl;
#define glfwGetJoystickName glfwGetJoystickName_impl

typedef const char* (*glfwGetJoystickGUID_func)(int);
GFW_EXTERN glfwGetJoystickGUID_func glfwGetJoystickGUID_impl;
#define glfwGetJoystickGUID glfwGetJoystickGUID_impl

typedef void (*glfwSetJoystickUserPointer_func)(int, void*);
GFW_EXTERN glfwSetJoystickUserPointer_func glfwSetJoystickUserPointer_impl;
#define glfwSetJoystickUserPointer glfwSetJoystickUserPointer_impl

typedef void* (*glfwGetJoystickUserPointer_func)(int);
GFW_EXTERN glfwGetJoystickUserPointer_func glfwGetJoystickUserPointer_impl;
#define glfwGetJoystickUserPointer glfwGetJoystickUserPointer_impl

typedef int (*glfwJoystickIsGamepad_func)(int);
GFW_EXTERN glfwJoystickIsGamepad_func glfwJoystickIsGamepad_impl;
#define glfwJoystickIsGamepad glfwJoystickIsGamepad_impl

typedef GLFWjoystickfun (*glfwSetJoystickCallback_func)(GLFWjoystickfun);
GFW_EXTERN glfwSetJoystickCallback_func glfwSetJoystickCallback_impl;
#define glfwSetJoystickCallback glfwSetJoystickCallback_impl

typedef int (*glfwUpdateGamepadMappings_func)(const char*);
GFW_EXTERN glfwUpdateGamepadMappings_func glfwUpdateGamepadMappings_impl;
#define glfwUpdateGamepadMappings glfwUpdateGamepadMappings_impl

typedef const char* (*glfwGetGamepadName_func)(int);
GFW_EXTERN glfwGetGamepadName_func glfwGetGamepadName_impl;
#define glfwGetGamepadName glfwGetGamepadName_impl

typedef int (*glfwGetGamepadState_func)(int, GLFWgamepadstate*);
GFW_EXTERN glfwGetGamepadState_func glfwGetGamepadState_impl;
#define glfwGetGamepadState glfwGetGamepadState_impl

typedef void (*glfwSetClipboardDataTypes_func)(GLFWClipboardType, const char* const*, size_t, GLFWclipboarditerfun);
GFW_EXTERN glfwSetClipboardDataTypes_func glfwSetClipboardDataTypes_impl;
#define glfwSetClipboardDataTypes glfwSetClipboardDataTypes_impl

typedef void (*glfwGetClipboard_func)(GLFWClipboardType, const char*, GLFWclipboardwritedatafun, void*);
GFW_EXTERN glfwGetClipboard_func glfwGetClipboard_impl;
#define glfwGetClipboard glfwGetClipboard_impl

typedef monotonic_t (*glfwGetTime_func)(void);
GFW_EXTERN glfwGetTime_func glfwGetTime_impl;
#define glfwGetTime glfwGetTime_impl

typedef void (*glfwMakeContextCurrent_func)(GLFWwindow*);
GFW_EXTERN glfwMakeContextCurrent_func glfwMakeContextCurrent_impl;
#define glfwMakeContextCurrent glfwMakeContextCurrent_impl

typedef GLFWwindow* (*glfwGetCurrentContext_func)(void);
GFW_EXTERN glfwGetCurrentContext_func glfwGetCurrentContext_impl;
#define glfwGetCurrentContext glfwGetCurrentContext_impl

typedef void (*glfwSwapBuffers_func)(GLFWwindow*);
GFW_EXTERN glfwSwapBuffers_func glfwSwapBuffers_impl;
#define glfwSwapBuffers glfwSwapBuffers_impl

typedef void (*glfwSwapInterval_func)(int);
GFW_EXTERN glfwSwapInterval_func glfwSwapInterval_impl;
#define glfwSwapInterval glfwSwapInterval_impl

typedef int (*glfwExtensionSupported_func)(const char*);
GFW_EXTERN glfwExtensionSupported_func glfwExtensionSupported_impl;
#define glfwExtensionSupported glfwExtensionSupported_impl

typedef GLFWglproc (*glfwGetProcAddress_func)(const char*);
GFW_EXTERN glfwGetProcAddress_func glfwGetProcAddress_impl;
#define glfwGetProcAddress glfwGetProcAddress_impl

typedef int (*glfwVulkanSupported_func)(void);
GFW_EXTERN glfwVulkanSupported_func glfwVulkanSupported_impl;
#define glfwVulkanSupported glfwVulkanSupported_impl

typedef const char** (*glfwGetRequiredInstanceExtensions_func)(uint32_t*);
GFW_EXTERN glfwGetRequiredInstanceExtensions_func glfwGetRequiredInstanceExtensions_impl;
#define glfwGetRequiredInstanceExtensions glfwGetRequiredInstanceExtensions_impl

typedef void* (*glfwGetCocoaWindow_func)(GLFWwindow*);
GFW_EXTERN glfwGetCocoaWindow_func glfwGetCocoaWindow_impl;
#define glfwGetCocoaWindow glfwGetCocoaWindow_impl

typedef void* (*glfwGetNSGLContext_func)(GLFWwindow*);
GFW_EXTERN glfwGetNSGLContext_func glfwGetNSGLContext_impl;
#define glfwGetNSGLContext glfwGetNSGLContext_impl

typedef uint32_t (*glfwGetCocoaMonitor_func)(GLFWmonitor*);
GFW_EXTERN glfwGetCocoaMonitor_func glfwGetCocoaMonitor_impl;
#define glfwGetCocoaMonitor glfwGetCocoaMonitor_impl

typedef GLFWcocoatextinputfilterfun (*glfwSetCocoaTextInputFilter_func)(GLFWwindow*, GLFWcocoatextinputfilterfun);
GFW_EXTERN glfwSetCocoaTextInputFilter_func glfwSetCocoaTextInputFilter_impl;
#define glfwSetCocoaTextInputFilter glfwSetCocoaTextInputFilter_impl

typedef GLFWhandleurlopen (*glfwSetCocoaURLOpenCallback_func)(GLFWhandleurlopen);
GFW_EXTERN glfwSetCocoaURLOpenCallback_func glfwSetCocoaURLOpenCallback_impl;
#define glfwSetCocoaURLOpenCallback glfwSetCocoaURLOpenCallback_impl

typedef GLFWcocoatogglefullscreenfun (*glfwSetCocoaToggleFullscreenIntercept_func)(GLFWwindow*, GLFWcocoatogglefullscreenfun);
GFW_EXTERN glfwSetCocoaToggleFullscreenIntercept_func glfwSetCocoaToggleFullscreenIntercept_impl;
#define glfwSetCocoaToggleFullscreenIntercept glfwSetCocoaToggleFullscreenIntercept_impl

typedef GLFWapplicationshouldhandlereopenfun (*glfwSetApplicationShouldHandleReopen_func)(GLFWapplicationshouldhandlereopenfun);
GFW_EXTERN glfwSetApplicationShouldHandleReopen_func glfwSetApplicationShouldHandleReopen_impl;
#define glfwSetApplicationShouldHandleReopen glfwSetApplicationShouldHandleReopen_impl

typedef GLFWapplicationwillfinishlaunchingfun (*glfwSetApplicationWillFinishLaunching_func)(GLFWapplicationwillfinishlaunchingfun);
GFW_EXTERN glfwSetApplicationWillFinishLaunching_func glfwSetApplicationWillFinishLaunching_impl;
#define glfwSetApplicationWillFinishLaunching glfwSetApplicationWillFinishLaunching_impl

typedef uint32_t (*glfwGetCocoaKeyEquivalent_func)(uint32_t, int, int*);
GFW_EXTERN glfwGetCocoaKeyEquivalent_func glfwGetCocoaKeyEquivalent_impl;
#define glfwGetCocoaKeyEquivalent glfwGetCocoaKeyEquivalent_impl

typedef void (*glfwCocoaRequestRenderFrame_func)(GLFWwindow*, GLFWcocoarenderframefun);
GFW_EXTERN glfwCocoaRequestRenderFrame_func glfwCocoaRequestRenderFrame_impl;
#define glfwCocoaRequestRenderFrame glfwCocoaRequestRenderFrame_impl

typedef GLFWcocoarenderframefun (*glfwCocoaSetWindowResizeCallback_func)(GLFWwindow*, GLFWcocoarenderframefun);
GFW_EXTERN glfwCocoaSetWindowResizeCallback_func glfwCocoaSetWindowResizeCallback_impl;
#define glfwCocoaSetWindowResizeCallback glfwCocoaSetWindowResizeCallback_impl

typedef void* (*glfwGetX11Display_func)(void);
GFW_EXTERN glfwGetX11Display_func glfwGetX11Display_impl;
#define glfwGetX11Display glfwGetX11Display_impl

typedef unsigned long (*glfwGetX11Window_func)(GLFWwindow*);
GFW_EXTERN glfwGetX11Window_func glfwGetX11Window_impl;
#define glfwGetX11Window glfwGetX11Window_impl

typedef void (*glfwSetPrimarySelectionString_func)(GLFWwindow*, const char*);
GFW_EXTERN glfwSetPrimarySelectionString_func glfwSetPrimarySelectionString_impl;
#define glfwSetPrimarySelectionString glfwSetPrimarySelectionString_impl

typedef void (*glfwCocoaSetWindowChrome_func)(GLFWwindow*, unsigned int, bool, unsigned int, int, unsigned int, bool, int, float, bool);
GFW_EXTERN glfwCocoaSetWindowChrome_func glfwCocoaSetWindowChrome_impl;
#define glfwCocoaSetWindowChrome glfwCocoaSetWindowChrome_impl

typedef const char* (*glfwGetPrimarySelectionString_func)(GLFWwindow*);
GFW_EXTERN glfwGetPrimarySelectionString_func glfwGetPrimarySelectionString_impl;
#define glfwGetPrimarySelectionString glfwGetPrimarySelectionString_impl

typedef int (*glfwGetNativeKeyForName_func)(const char*, int);
GFW_EXTERN glfwGetNativeKeyForName_func glfwGetNativeKeyForName_impl;
#define glfwGetNativeKeyForName glfwGetNativeKeyForName_impl

typedef void (*glfwRequestWaylandFrameEvent_func)(GLFWwindow*, unsigned long long, GLFWwaylandframecallbackfunc);
GFW_EXTERN glfwRequestWaylandFrameEvent_func glfwRequestWaylandFrameEvent_impl;
#define glfwRequestWaylandFrameEvent glfwRequestWaylandFrameEvent_impl

typedef void (*glfwWaylandActivateWindow_func)(GLFWwindow*, const char*);
GFW_EXTERN glfwWaylandActivateWindow_func glfwWaylandActivateWindow_impl;
#define glfwWaylandActivateWindow glfwWaylandActivateWindow_impl

typedef const char* (*glfwWaylandMissingCapabilities_func)(void);
GFW_EXTERN glfwWaylandMissingCapabilities_func glfwWaylandMissingCapabilities_impl;
#define glfwWaylandMissingCapabilities glfwWaylandMissingCapabilities_impl

typedef void (*glfwWaylandRunWithActivationToken_func)(GLFWwindow*, GLFWactivationcallback, void*);
GFW_EXTERN glfwWaylandRunWithActivationToken_func glfwWaylandRunWithActivationToken_impl;
#define glfwWaylandRunWithActivationToken glfwWaylandRunWithActivationToken_impl

typedef bool (*glfwWaylandSetTitlebarColor_func)(GLFWwindow*, uint32_t, bool);
GFW_EXTERN glfwWaylandSetTitlebarColor_func glfwWaylandSetTitlebarColor_impl;
#define glfwWaylandSetTitlebarColor glfwWaylandSetTitlebarColor_impl

typedef void (*glfwWaylandRedrawCSDWindowTitle_func)(GLFWwindow*);
GFW_EXTERN glfwWaylandRedrawCSDWindowTitle_func glfwWaylandRedrawCSDWindowTitle_impl;
#define glfwWaylandRedrawCSDWindowTitle glfwWaylandRedrawCSDWindowTitle_impl

typedef void (*glfwWaylandSetupLayerShellForNextWindow_func)(const GLFWLayerShellConfig*);
GFW_EXTERN glfwWaylandSetupLayerShellForNextWindow_func glfwWaylandSetupLayerShellForNextWindow_impl;
#define glfwWaylandSetupLayerShellForNextWindow glfwWaylandSetupLayerShellForNextWindow_impl

typedef pid_t (*glfwWaylandCompositorPID_func)(void);
GFW_EXTERN glfwWaylandCompositorPID_func glfwWaylandCompositorPID_impl;
#define glfwWaylandCompositorPID glfwWaylandCompositorPID_impl

typedef unsigned long long (*glfwDBusUserNotify_func)(const GLFWDBUSNotificationData*, GLFWDBusnotificationcreatedfun, void*);
GFW_EXTERN glfwDBusUserNotify_func glfwDBusUserNotify_impl;
#define glfwDBusUserNotify glfwDBusUserNotify_impl

typedef void (*glfwDBusSetUserNotificationHandler_func)(GLFWDBusnotificationactivatedfun);
GFW_EXTERN glfwDBusSetUserNotificationHandler_func glfwDBusSetUserNotificationHandler_impl;
#define glfwDBusSetUserNotificationHandler glfwDBusSetUserNotificationHandler_impl

typedef int (*glfwSetX11LaunchCommand_func)(GLFWwindow*, char**, int);
GFW_EXTERN glfwSetX11LaunchCommand_func glfwSetX11LaunchCommand_impl;
#define glfwSetX11LaunchCommand glfwSetX11LaunchCommand_impl

typedef void (*glfwSetX11WindowAsDock_func)(int32_t);
GFW_EXTERN glfwSetX11WindowAsDock_func glfwSetX11WindowAsDock_impl;
#define glfwSetX11WindowAsDock glfwSetX11WindowAsDock_impl

typedef void (*glfwSetX11WindowStrut_func)(int32_t, uint32_t[12]);
GFW_EXTERN glfwSetX11WindowStrut_func glfwSetX11WindowStrut_impl;
#define glfwSetX11WindowStrut glfwSetX11WindowStrut_impl

const char* load_glfw(const char* path);
