
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2024 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQSurfaceFormat.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QSurfaceFormat>
#include "gsiQt.h"
#include "gsiQtGuiCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QSurfaceFormat

//  Constructor QSurfaceFormat::QSurfaceFormat()


static void _init_ctor_QSurfaceFormat_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QSurfaceFormat> ();
}

static void _call_ctor_QSurfaceFormat_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSurfaceFormat *> (new QSurfaceFormat ());
}


//  Constructor QSurfaceFormat::QSurfaceFormat(QFlags<QSurfaceFormat::FormatOption> options)


static void _init_ctor_QSurfaceFormat_3909 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("options");
  decl->add_arg<QFlags<QSurfaceFormat::FormatOption> > (argspec_0);
  decl->set_return_new<QSurfaceFormat> ();
}

static void _call_ctor_QSurfaceFormat_3909 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QSurfaceFormat::FormatOption> arg1 = gsi::arg_reader<QFlags<QSurfaceFormat::FormatOption> >() (args, heap);
  ret.write<QSurfaceFormat *> (new QSurfaceFormat (arg1));
}


//  Constructor QSurfaceFormat::QSurfaceFormat(const QSurfaceFormat &other)


static void _init_ctor_QSurfaceFormat_2724 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QSurfaceFormat & > (argspec_0);
  decl->set_return_new<QSurfaceFormat> ();
}

static void _call_ctor_QSurfaceFormat_2724 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSurfaceFormat &arg1 = gsi::arg_reader<const QSurfaceFormat & >() (args, heap);
  ret.write<QSurfaceFormat *> (new QSurfaceFormat (arg1));
}


// int QSurfaceFormat::alphaBufferSize()


static void _init_f_alphaBufferSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_alphaBufferSize_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QSurfaceFormat *)cls)->alphaBufferSize ());
}


// int QSurfaceFormat::blueBufferSize()


static void _init_f_blueBufferSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_blueBufferSize_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QSurfaceFormat *)cls)->blueBufferSize ());
}


// QSurfaceFormat::ColorSpace QSurfaceFormat::colorSpace()


static void _init_f_colorSpace_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QSurfaceFormat::ColorSpace>::target_type > ();
}

static void _call_f_colorSpace_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QSurfaceFormat::ColorSpace>::target_type > ((qt_gsi::Converter<QSurfaceFormat::ColorSpace>::target_type)qt_gsi::CppToQtAdaptor<QSurfaceFormat::ColorSpace>(((QSurfaceFormat *)cls)->colorSpace ()));
}


// int QSurfaceFormat::depthBufferSize()


static void _init_f_depthBufferSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_depthBufferSize_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QSurfaceFormat *)cls)->depthBufferSize ());
}


// int QSurfaceFormat::greenBufferSize()


static void _init_f_greenBufferSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_greenBufferSize_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QSurfaceFormat *)cls)->greenBufferSize ());
}


// bool QSurfaceFormat::hasAlpha()


static void _init_f_hasAlpha_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_hasAlpha_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QSurfaceFormat *)cls)->hasAlpha ());
}


// int QSurfaceFormat::majorVersion()


static void _init_f_majorVersion_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_majorVersion_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QSurfaceFormat *)cls)->majorVersion ());
}


// int QSurfaceFormat::minorVersion()


static void _init_f_minorVersion_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_minorVersion_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QSurfaceFormat *)cls)->minorVersion ());
}


// QSurfaceFormat &QSurfaceFormat::operator=(const QSurfaceFormat &other)


static void _init_f_operator_eq__2724 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QSurfaceFormat & > (argspec_0);
  decl->set_return<QSurfaceFormat & > ();
}

static void _call_f_operator_eq__2724 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSurfaceFormat &arg1 = gsi::arg_reader<const QSurfaceFormat & >() (args, heap);
  ret.write<QSurfaceFormat & > ((QSurfaceFormat &)((QSurfaceFormat *)cls)->operator= (arg1));
}


// QFlags<QSurfaceFormat::FormatOption> QSurfaceFormat::options()


static void _init_f_options_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<QSurfaceFormat::FormatOption> > ();
}

static void _call_f_options_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<QSurfaceFormat::FormatOption> > ((QFlags<QSurfaceFormat::FormatOption>)((QSurfaceFormat *)cls)->options ());
}


// QSurfaceFormat::OpenGLContextProfile QSurfaceFormat::profile()


static void _init_f_profile_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QSurfaceFormat::OpenGLContextProfile>::target_type > ();
}

static void _call_f_profile_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QSurfaceFormat::OpenGLContextProfile>::target_type > ((qt_gsi::Converter<QSurfaceFormat::OpenGLContextProfile>::target_type)qt_gsi::CppToQtAdaptor<QSurfaceFormat::OpenGLContextProfile>(((QSurfaceFormat *)cls)->profile ()));
}


// int QSurfaceFormat::redBufferSize()


static void _init_f_redBufferSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_redBufferSize_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QSurfaceFormat *)cls)->redBufferSize ());
}


// QSurfaceFormat::RenderableType QSurfaceFormat::renderableType()


static void _init_f_renderableType_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QSurfaceFormat::RenderableType>::target_type > ();
}

static void _call_f_renderableType_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QSurfaceFormat::RenderableType>::target_type > ((qt_gsi::Converter<QSurfaceFormat::RenderableType>::target_type)qt_gsi::CppToQtAdaptor<QSurfaceFormat::RenderableType>(((QSurfaceFormat *)cls)->renderableType ()));
}


// int QSurfaceFormat::samples()


static void _init_f_samples_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_samples_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QSurfaceFormat *)cls)->samples ());
}


// void QSurfaceFormat::setAlphaBufferSize(int size)


static void _init_f_setAlphaBufferSize_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("size");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAlphaBufferSize_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSurfaceFormat *)cls)->setAlphaBufferSize (arg1);
}


// void QSurfaceFormat::setBlueBufferSize(int size)


static void _init_f_setBlueBufferSize_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("size");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setBlueBufferSize_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSurfaceFormat *)cls)->setBlueBufferSize (arg1);
}


// void QSurfaceFormat::setColorSpace(QSurfaceFormat::ColorSpace colorSpace)


static void _init_f_setColorSpace_2966 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("colorSpace");
  decl->add_arg<const qt_gsi::Converter<QSurfaceFormat::ColorSpace>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setColorSpace_2966 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QSurfaceFormat::ColorSpace>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QSurfaceFormat::ColorSpace>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSurfaceFormat *)cls)->setColorSpace (qt_gsi::QtToCppAdaptor<QSurfaceFormat::ColorSpace>(arg1).cref());
}


// void QSurfaceFormat::setDepthBufferSize(int size)


static void _init_f_setDepthBufferSize_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("size");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDepthBufferSize_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSurfaceFormat *)cls)->setDepthBufferSize (arg1);
}


// void QSurfaceFormat::setGreenBufferSize(int size)


static void _init_f_setGreenBufferSize_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("size");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setGreenBufferSize_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSurfaceFormat *)cls)->setGreenBufferSize (arg1);
}


// void QSurfaceFormat::setMajorVersion(int majorVersion)


static void _init_f_setMajorVersion_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("majorVersion");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMajorVersion_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSurfaceFormat *)cls)->setMajorVersion (arg1);
}


// void QSurfaceFormat::setMinorVersion(int minorVersion)


static void _init_f_setMinorVersion_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("minorVersion");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMinorVersion_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSurfaceFormat *)cls)->setMinorVersion (arg1);
}


// void QSurfaceFormat::setOption(QFlags<QSurfaceFormat::FormatOption> opt)


static void _init_f_setOption_3909 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("opt");
  decl->add_arg<QFlags<QSurfaceFormat::FormatOption> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setOption_3909 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QSurfaceFormat::FormatOption> arg1 = gsi::arg_reader<QFlags<QSurfaceFormat::FormatOption> >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSurfaceFormat *)cls)->setOption (arg1);
}


// void QSurfaceFormat::setOption(QSurfaceFormat::FormatOption option, bool on)


static void _init_f_setOption_3969 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<const qt_gsi::Converter<QSurfaceFormat::FormatOption>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("on", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setOption_3969 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QSurfaceFormat::FormatOption>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QSurfaceFormat::FormatOption>::target_type & >() (args, heap);
  bool arg2 = args ? gsi::arg_reader<bool >() (args, heap) : gsi::arg_maker<bool >() (true, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSurfaceFormat *)cls)->setOption (qt_gsi::QtToCppAdaptor<QSurfaceFormat::FormatOption>(arg1).cref(), arg2);
}


// void QSurfaceFormat::setOptions(QFlags<QSurfaceFormat::FormatOption> options)


static void _init_f_setOptions_3909 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("options");
  decl->add_arg<QFlags<QSurfaceFormat::FormatOption> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setOptions_3909 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QSurfaceFormat::FormatOption> arg1 = gsi::arg_reader<QFlags<QSurfaceFormat::FormatOption> >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSurfaceFormat *)cls)->setOptions (arg1);
}


// void QSurfaceFormat::setProfile(QSurfaceFormat::OpenGLContextProfile profile)


static void _init_f_setProfile_3974 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("profile");
  decl->add_arg<const qt_gsi::Converter<QSurfaceFormat::OpenGLContextProfile>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setProfile_3974 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QSurfaceFormat::OpenGLContextProfile>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QSurfaceFormat::OpenGLContextProfile>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSurfaceFormat *)cls)->setProfile (qt_gsi::QtToCppAdaptor<QSurfaceFormat::OpenGLContextProfile>(arg1).cref());
}


// void QSurfaceFormat::setRedBufferSize(int size)


static void _init_f_setRedBufferSize_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("size");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setRedBufferSize_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSurfaceFormat *)cls)->setRedBufferSize (arg1);
}


// void QSurfaceFormat::setRenderableType(QSurfaceFormat::RenderableType type)


static void _init_f_setRenderableType_3393 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("type");
  decl->add_arg<const qt_gsi::Converter<QSurfaceFormat::RenderableType>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setRenderableType_3393 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QSurfaceFormat::RenderableType>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QSurfaceFormat::RenderableType>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSurfaceFormat *)cls)->setRenderableType (qt_gsi::QtToCppAdaptor<QSurfaceFormat::RenderableType>(arg1).cref());
}


// void QSurfaceFormat::setSamples(int numSamples)


static void _init_f_setSamples_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("numSamples");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSamples_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSurfaceFormat *)cls)->setSamples (arg1);
}


// void QSurfaceFormat::setStencilBufferSize(int size)


static void _init_f_setStencilBufferSize_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("size");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStencilBufferSize_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSurfaceFormat *)cls)->setStencilBufferSize (arg1);
}


// void QSurfaceFormat::setStereo(bool enable)


static void _init_f_setStereo_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enable");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStereo_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSurfaceFormat *)cls)->setStereo (arg1);
}


// void QSurfaceFormat::setSwapBehavior(QSurfaceFormat::SwapBehavior behavior)


static void _init_f_setSwapBehavior_3190 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("behavior");
  decl->add_arg<const qt_gsi::Converter<QSurfaceFormat::SwapBehavior>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSwapBehavior_3190 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QSurfaceFormat::SwapBehavior>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QSurfaceFormat::SwapBehavior>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSurfaceFormat *)cls)->setSwapBehavior (qt_gsi::QtToCppAdaptor<QSurfaceFormat::SwapBehavior>(arg1).cref());
}


// void QSurfaceFormat::setSwapInterval(int interval)


static void _init_f_setSwapInterval_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("interval");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSwapInterval_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSurfaceFormat *)cls)->setSwapInterval (arg1);
}


// void QSurfaceFormat::setVersion(int major, int minor)


static void _init_f_setVersion_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("major");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("minor");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setVersion_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QSurfaceFormat *)cls)->setVersion (arg1, arg2);
}


// int QSurfaceFormat::stencilBufferSize()


static void _init_f_stencilBufferSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_stencilBufferSize_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QSurfaceFormat *)cls)->stencilBufferSize ());
}


// bool QSurfaceFormat::stereo()


static void _init_f_stereo_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_stereo_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QSurfaceFormat *)cls)->stereo ());
}


// QSurfaceFormat::SwapBehavior QSurfaceFormat::swapBehavior()


static void _init_f_swapBehavior_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QSurfaceFormat::SwapBehavior>::target_type > ();
}

static void _call_f_swapBehavior_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QSurfaceFormat::SwapBehavior>::target_type > ((qt_gsi::Converter<QSurfaceFormat::SwapBehavior>::target_type)qt_gsi::CppToQtAdaptor<QSurfaceFormat::SwapBehavior>(((QSurfaceFormat *)cls)->swapBehavior ()));
}


// int QSurfaceFormat::swapInterval()


static void _init_f_swapInterval_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_swapInterval_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QSurfaceFormat *)cls)->swapInterval ());
}


// bool QSurfaceFormat::testOption(QFlags<QSurfaceFormat::FormatOption> opt)


static void _init_f_testOption_c3909 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("opt");
  decl->add_arg<QFlags<QSurfaceFormat::FormatOption> > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_testOption_c3909 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<QSurfaceFormat::FormatOption> arg1 = gsi::arg_reader<QFlags<QSurfaceFormat::FormatOption> >() (args, heap);
  ret.write<bool > ((bool)((QSurfaceFormat *)cls)->testOption (arg1));
}


// bool QSurfaceFormat::testOption(QSurfaceFormat::FormatOption option)


static void _init_f_testOption_c3213 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<const qt_gsi::Converter<QSurfaceFormat::FormatOption>::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_testOption_c3213 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QSurfaceFormat::FormatOption>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QSurfaceFormat::FormatOption>::target_type & >() (args, heap);
  ret.write<bool > ((bool)((QSurfaceFormat *)cls)->testOption (qt_gsi::QtToCppAdaptor<QSurfaceFormat::FormatOption>(arg1).cref()));
}


// QPair<int, int> QSurfaceFormat::version()


static void _init_f_version_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPair<int, int> > ();
}

static void _call_f_version_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPair<int, int> > ((QPair<int, int>)((QSurfaceFormat *)cls)->version ());
}


// static QSurfaceFormat QSurfaceFormat::defaultFormat()


static void _init_f_defaultFormat_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QSurfaceFormat > ();
}

static void _call_f_defaultFormat_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSurfaceFormat > ((QSurfaceFormat)QSurfaceFormat::defaultFormat ());
}


// static void QSurfaceFormat::setDefaultFormat(const QSurfaceFormat &format)


static void _init_f_setDefaultFormat_2724 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const QSurfaceFormat & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDefaultFormat_2724 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSurfaceFormat &arg1 = gsi::arg_reader<const QSurfaceFormat & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  QSurfaceFormat::setDefaultFormat (arg1);
}


//  bool ::operator==(const QSurfaceFormat &, const QSurfaceFormat &)
static bool op_QSurfaceFormat_operator_eq__eq__5340(const QSurfaceFormat *_self, const QSurfaceFormat &arg2) {
  return operator==(*_self, arg2);
}

//  bool ::operator!=(const QSurfaceFormat &, const QSurfaceFormat &)
static bool op_QSurfaceFormat_operator_excl__eq__5340(const QSurfaceFormat *_self, const QSurfaceFormat &arg2) {
  return operator!=(*_self, arg2);
}


namespace gsi
{

static gsi::Methods methods_QSurfaceFormat () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QSurfaceFormat::QSurfaceFormat()\nThis method creates an object of class QSurfaceFormat.", &_init_ctor_QSurfaceFormat_0, &_call_ctor_QSurfaceFormat_0);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QSurfaceFormat::QSurfaceFormat(QFlags<QSurfaceFormat::FormatOption> options)\nThis method creates an object of class QSurfaceFormat.", &_init_ctor_QSurfaceFormat_3909, &_call_ctor_QSurfaceFormat_3909);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QSurfaceFormat::QSurfaceFormat(const QSurfaceFormat &other)\nThis method creates an object of class QSurfaceFormat.", &_init_ctor_QSurfaceFormat_2724, &_call_ctor_QSurfaceFormat_2724);
  methods += new qt_gsi::GenericMethod (":alphaBufferSize", "@brief Method int QSurfaceFormat::alphaBufferSize()\n", true, &_init_f_alphaBufferSize_c0, &_call_f_alphaBufferSize_c0);
  methods += new qt_gsi::GenericMethod (":blueBufferSize", "@brief Method int QSurfaceFormat::blueBufferSize()\n", true, &_init_f_blueBufferSize_c0, &_call_f_blueBufferSize_c0);
  methods += new qt_gsi::GenericMethod (":colorSpace", "@brief Method QSurfaceFormat::ColorSpace QSurfaceFormat::colorSpace()\n", true, &_init_f_colorSpace_c0, &_call_f_colorSpace_c0);
  methods += new qt_gsi::GenericMethod (":depthBufferSize", "@brief Method int QSurfaceFormat::depthBufferSize()\n", true, &_init_f_depthBufferSize_c0, &_call_f_depthBufferSize_c0);
  methods += new qt_gsi::GenericMethod (":greenBufferSize", "@brief Method int QSurfaceFormat::greenBufferSize()\n", true, &_init_f_greenBufferSize_c0, &_call_f_greenBufferSize_c0);
  methods += new qt_gsi::GenericMethod ("hasAlpha", "@brief Method bool QSurfaceFormat::hasAlpha()\n", true, &_init_f_hasAlpha_c0, &_call_f_hasAlpha_c0);
  methods += new qt_gsi::GenericMethod (":majorVersion", "@brief Method int QSurfaceFormat::majorVersion()\n", true, &_init_f_majorVersion_c0, &_call_f_majorVersion_c0);
  methods += new qt_gsi::GenericMethod (":minorVersion", "@brief Method int QSurfaceFormat::minorVersion()\n", true, &_init_f_minorVersion_c0, &_call_f_minorVersion_c0);
  methods += new qt_gsi::GenericMethod ("assign", "@brief Method QSurfaceFormat &QSurfaceFormat::operator=(const QSurfaceFormat &other)\n", false, &_init_f_operator_eq__2724, &_call_f_operator_eq__2724);
  methods += new qt_gsi::GenericMethod (":options", "@brief Method QFlags<QSurfaceFormat::FormatOption> QSurfaceFormat::options()\n", true, &_init_f_options_c0, &_call_f_options_c0);
  methods += new qt_gsi::GenericMethod (":profile", "@brief Method QSurfaceFormat::OpenGLContextProfile QSurfaceFormat::profile()\n", true, &_init_f_profile_c0, &_call_f_profile_c0);
  methods += new qt_gsi::GenericMethod (":redBufferSize", "@brief Method int QSurfaceFormat::redBufferSize()\n", true, &_init_f_redBufferSize_c0, &_call_f_redBufferSize_c0);
  methods += new qt_gsi::GenericMethod (":renderableType", "@brief Method QSurfaceFormat::RenderableType QSurfaceFormat::renderableType()\n", true, &_init_f_renderableType_c0, &_call_f_renderableType_c0);
  methods += new qt_gsi::GenericMethod (":samples", "@brief Method int QSurfaceFormat::samples()\n", true, &_init_f_samples_c0, &_call_f_samples_c0);
  methods += new qt_gsi::GenericMethod ("setAlphaBufferSize|alphaBufferSize=", "@brief Method void QSurfaceFormat::setAlphaBufferSize(int size)\n", false, &_init_f_setAlphaBufferSize_767, &_call_f_setAlphaBufferSize_767);
  methods += new qt_gsi::GenericMethod ("setBlueBufferSize|blueBufferSize=", "@brief Method void QSurfaceFormat::setBlueBufferSize(int size)\n", false, &_init_f_setBlueBufferSize_767, &_call_f_setBlueBufferSize_767);
  methods += new qt_gsi::GenericMethod ("setColorSpace|colorSpace=", "@brief Method void QSurfaceFormat::setColorSpace(QSurfaceFormat::ColorSpace colorSpace)\n", false, &_init_f_setColorSpace_2966, &_call_f_setColorSpace_2966);
  methods += new qt_gsi::GenericMethod ("setDepthBufferSize|depthBufferSize=", "@brief Method void QSurfaceFormat::setDepthBufferSize(int size)\n", false, &_init_f_setDepthBufferSize_767, &_call_f_setDepthBufferSize_767);
  methods += new qt_gsi::GenericMethod ("setGreenBufferSize|greenBufferSize=", "@brief Method void QSurfaceFormat::setGreenBufferSize(int size)\n", false, &_init_f_setGreenBufferSize_767, &_call_f_setGreenBufferSize_767);
  methods += new qt_gsi::GenericMethod ("setMajorVersion|majorVersion=", "@brief Method void QSurfaceFormat::setMajorVersion(int majorVersion)\n", false, &_init_f_setMajorVersion_767, &_call_f_setMajorVersion_767);
  methods += new qt_gsi::GenericMethod ("setMinorVersion|minorVersion=", "@brief Method void QSurfaceFormat::setMinorVersion(int minorVersion)\n", false, &_init_f_setMinorVersion_767, &_call_f_setMinorVersion_767);
  methods += new qt_gsi::GenericMethod ("setOption", "@brief Method void QSurfaceFormat::setOption(QFlags<QSurfaceFormat::FormatOption> opt)\n", false, &_init_f_setOption_3909, &_call_f_setOption_3909);
  methods += new qt_gsi::GenericMethod ("setOption", "@brief Method void QSurfaceFormat::setOption(QSurfaceFormat::FormatOption option, bool on)\n", false, &_init_f_setOption_3969, &_call_f_setOption_3969);
  methods += new qt_gsi::GenericMethod ("setOptions|options=", "@brief Method void QSurfaceFormat::setOptions(QFlags<QSurfaceFormat::FormatOption> options)\n", false, &_init_f_setOptions_3909, &_call_f_setOptions_3909);
  methods += new qt_gsi::GenericMethod ("setProfile|profile=", "@brief Method void QSurfaceFormat::setProfile(QSurfaceFormat::OpenGLContextProfile profile)\n", false, &_init_f_setProfile_3974, &_call_f_setProfile_3974);
  methods += new qt_gsi::GenericMethod ("setRedBufferSize|redBufferSize=", "@brief Method void QSurfaceFormat::setRedBufferSize(int size)\n", false, &_init_f_setRedBufferSize_767, &_call_f_setRedBufferSize_767);
  methods += new qt_gsi::GenericMethod ("setRenderableType|renderableType=", "@brief Method void QSurfaceFormat::setRenderableType(QSurfaceFormat::RenderableType type)\n", false, &_init_f_setRenderableType_3393, &_call_f_setRenderableType_3393);
  methods += new qt_gsi::GenericMethod ("setSamples|samples=", "@brief Method void QSurfaceFormat::setSamples(int numSamples)\n", false, &_init_f_setSamples_767, &_call_f_setSamples_767);
  methods += new qt_gsi::GenericMethod ("setStencilBufferSize|stencilBufferSize=", "@brief Method void QSurfaceFormat::setStencilBufferSize(int size)\n", false, &_init_f_setStencilBufferSize_767, &_call_f_setStencilBufferSize_767);
  methods += new qt_gsi::GenericMethod ("setStereo|stereo=", "@brief Method void QSurfaceFormat::setStereo(bool enable)\n", false, &_init_f_setStereo_864, &_call_f_setStereo_864);
  methods += new qt_gsi::GenericMethod ("setSwapBehavior|swapBehavior=", "@brief Method void QSurfaceFormat::setSwapBehavior(QSurfaceFormat::SwapBehavior behavior)\n", false, &_init_f_setSwapBehavior_3190, &_call_f_setSwapBehavior_3190);
  methods += new qt_gsi::GenericMethod ("setSwapInterval|swapInterval=", "@brief Method void QSurfaceFormat::setSwapInterval(int interval)\n", false, &_init_f_setSwapInterval_767, &_call_f_setSwapInterval_767);
  methods += new qt_gsi::GenericMethod ("setVersion", "@brief Method void QSurfaceFormat::setVersion(int major, int minor)\n", false, &_init_f_setVersion_1426, &_call_f_setVersion_1426);
  methods += new qt_gsi::GenericMethod (":stencilBufferSize", "@brief Method int QSurfaceFormat::stencilBufferSize()\n", true, &_init_f_stencilBufferSize_c0, &_call_f_stencilBufferSize_c0);
  methods += new qt_gsi::GenericMethod (":stereo", "@brief Method bool QSurfaceFormat::stereo()\n", true, &_init_f_stereo_c0, &_call_f_stereo_c0);
  methods += new qt_gsi::GenericMethod (":swapBehavior", "@brief Method QSurfaceFormat::SwapBehavior QSurfaceFormat::swapBehavior()\n", true, &_init_f_swapBehavior_c0, &_call_f_swapBehavior_c0);
  methods += new qt_gsi::GenericMethod (":swapInterval", "@brief Method int QSurfaceFormat::swapInterval()\n", true, &_init_f_swapInterval_c0, &_call_f_swapInterval_c0);
  methods += new qt_gsi::GenericMethod ("testOption", "@brief Method bool QSurfaceFormat::testOption(QFlags<QSurfaceFormat::FormatOption> opt)\n", true, &_init_f_testOption_c3909, &_call_f_testOption_c3909);
  methods += new qt_gsi::GenericMethod ("testOption", "@brief Method bool QSurfaceFormat::testOption(QSurfaceFormat::FormatOption option)\n", true, &_init_f_testOption_c3213, &_call_f_testOption_c3213);
  methods += new qt_gsi::GenericMethod ("version", "@brief Method QPair<int, int> QSurfaceFormat::version()\n", true, &_init_f_version_c0, &_call_f_version_c0);
  methods += new qt_gsi::GenericStaticMethod (":defaultFormat", "@brief Static method QSurfaceFormat QSurfaceFormat::defaultFormat()\nThis method is static and can be called without an instance.", &_init_f_defaultFormat_0, &_call_f_defaultFormat_0);
  methods += new qt_gsi::GenericStaticMethod ("setDefaultFormat|defaultFormat=", "@brief Static method void QSurfaceFormat::setDefaultFormat(const QSurfaceFormat &format)\nThis method is static and can be called without an instance.", &_init_f_setDefaultFormat_2724, &_call_f_setDefaultFormat_2724);
  methods += gsi::method_ext("==", &::op_QSurfaceFormat_operator_eq__eq__5340, gsi::arg ("arg2"), "@brief Operator bool ::operator==(const QSurfaceFormat &, const QSurfaceFormat &)\nThis is the mapping of the global operator to the instance method.");
  methods += gsi::method_ext("!=", &::op_QSurfaceFormat_operator_excl__eq__5340, gsi::arg ("arg2"), "@brief Operator bool ::operator!=(const QSurfaceFormat &, const QSurfaceFormat &)\nThis is the mapping of the global operator to the instance method.");
  return methods;
}

gsi::Class<QSurfaceFormat> decl_QSurfaceFormat ("QtGui", "QSurfaceFormat",
  methods_QSurfaceFormat (),
  "@qt\n@brief Binding of QSurfaceFormat");


GSI_QTGUI_PUBLIC gsi::Class<QSurfaceFormat> &qtdecl_QSurfaceFormat () { return decl_QSurfaceFormat; }

}


//  Implementation of the enum wrapper class for QSurfaceFormat::ColorSpace
namespace qt_gsi
{

static gsi::Enum<QSurfaceFormat::ColorSpace> decl_QSurfaceFormat_ColorSpace_Enum ("QtGui", "QSurfaceFormat_ColorSpace",
    gsi::enum_const ("DefaultColorSpace", QSurfaceFormat::DefaultColorSpace, "@brief Enum constant QSurfaceFormat::DefaultColorSpace") +
    gsi::enum_const ("sRGBColorSpace", QSurfaceFormat::sRGBColorSpace, "@brief Enum constant QSurfaceFormat::sRGBColorSpace"),
  "@qt\n@brief This class represents the QSurfaceFormat::ColorSpace enum");

static gsi::QFlagsClass<QSurfaceFormat::ColorSpace > decl_QSurfaceFormat_ColorSpace_Enums ("QtGui", "QSurfaceFormat_QFlags_ColorSpace",
  "@qt\n@brief This class represents the QFlags<QSurfaceFormat::ColorSpace> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QSurfaceFormat> inject_QSurfaceFormat_ColorSpace_Enum_in_parent (decl_QSurfaceFormat_ColorSpace_Enum.defs ());
static gsi::ClassExt<QSurfaceFormat> decl_QSurfaceFormat_ColorSpace_Enum_as_child (decl_QSurfaceFormat_ColorSpace_Enum, "ColorSpace");
static gsi::ClassExt<QSurfaceFormat> decl_QSurfaceFormat_ColorSpace_Enums_as_child (decl_QSurfaceFormat_ColorSpace_Enums, "QFlags_ColorSpace");

}


//  Implementation of the enum wrapper class for QSurfaceFormat::FormatOption
namespace qt_gsi
{

static gsi::Enum<QSurfaceFormat::FormatOption> decl_QSurfaceFormat_FormatOption_Enum ("QtGui", "QSurfaceFormat_FormatOption",
    gsi::enum_const ("StereoBuffers", QSurfaceFormat::StereoBuffers, "@brief Enum constant QSurfaceFormat::StereoBuffers") +
    gsi::enum_const ("DebugContext", QSurfaceFormat::DebugContext, "@brief Enum constant QSurfaceFormat::DebugContext") +
    gsi::enum_const ("DeprecatedFunctions", QSurfaceFormat::DeprecatedFunctions, "@brief Enum constant QSurfaceFormat::DeprecatedFunctions") +
    gsi::enum_const ("ResetNotification", QSurfaceFormat::ResetNotification, "@brief Enum constant QSurfaceFormat::ResetNotification"),
  "@qt\n@brief This class represents the QSurfaceFormat::FormatOption enum");

static gsi::QFlagsClass<QSurfaceFormat::FormatOption > decl_QSurfaceFormat_FormatOption_Enums ("QtGui", "QSurfaceFormat_QFlags_FormatOption",
  "@qt\n@brief This class represents the QFlags<QSurfaceFormat::FormatOption> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QSurfaceFormat> inject_QSurfaceFormat_FormatOption_Enum_in_parent (decl_QSurfaceFormat_FormatOption_Enum.defs ());
static gsi::ClassExt<QSurfaceFormat> decl_QSurfaceFormat_FormatOption_Enum_as_child (decl_QSurfaceFormat_FormatOption_Enum, "FormatOption");
static gsi::ClassExt<QSurfaceFormat> decl_QSurfaceFormat_FormatOption_Enums_as_child (decl_QSurfaceFormat_FormatOption_Enums, "QFlags_FormatOption");

}


//  Implementation of the enum wrapper class for QSurfaceFormat::OpenGLContextProfile
namespace qt_gsi
{

static gsi::Enum<QSurfaceFormat::OpenGLContextProfile> decl_QSurfaceFormat_OpenGLContextProfile_Enum ("QtGui", "QSurfaceFormat_OpenGLContextProfile",
    gsi::enum_const ("NoProfile", QSurfaceFormat::NoProfile, "@brief Enum constant QSurfaceFormat::NoProfile") +
    gsi::enum_const ("CoreProfile", QSurfaceFormat::CoreProfile, "@brief Enum constant QSurfaceFormat::CoreProfile") +
    gsi::enum_const ("CompatibilityProfile", QSurfaceFormat::CompatibilityProfile, "@brief Enum constant QSurfaceFormat::CompatibilityProfile"),
  "@qt\n@brief This class represents the QSurfaceFormat::OpenGLContextProfile enum");

static gsi::QFlagsClass<QSurfaceFormat::OpenGLContextProfile > decl_QSurfaceFormat_OpenGLContextProfile_Enums ("QtGui", "QSurfaceFormat_QFlags_OpenGLContextProfile",
  "@qt\n@brief This class represents the QFlags<QSurfaceFormat::OpenGLContextProfile> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QSurfaceFormat> inject_QSurfaceFormat_OpenGLContextProfile_Enum_in_parent (decl_QSurfaceFormat_OpenGLContextProfile_Enum.defs ());
static gsi::ClassExt<QSurfaceFormat> decl_QSurfaceFormat_OpenGLContextProfile_Enum_as_child (decl_QSurfaceFormat_OpenGLContextProfile_Enum, "OpenGLContextProfile");
static gsi::ClassExt<QSurfaceFormat> decl_QSurfaceFormat_OpenGLContextProfile_Enums_as_child (decl_QSurfaceFormat_OpenGLContextProfile_Enums, "QFlags_OpenGLContextProfile");

}


//  Implementation of the enum wrapper class for QSurfaceFormat::RenderableType
namespace qt_gsi
{

static gsi::Enum<QSurfaceFormat::RenderableType> decl_QSurfaceFormat_RenderableType_Enum ("QtGui", "QSurfaceFormat_RenderableType",
    gsi::enum_const ("DefaultRenderableType", QSurfaceFormat::DefaultRenderableType, "@brief Enum constant QSurfaceFormat::DefaultRenderableType") +
    gsi::enum_const ("OpenGL", QSurfaceFormat::OpenGL, "@brief Enum constant QSurfaceFormat::OpenGL") +
    gsi::enum_const ("OpenGLES", QSurfaceFormat::OpenGLES, "@brief Enum constant QSurfaceFormat::OpenGLES") +
    gsi::enum_const ("OpenVG", QSurfaceFormat::OpenVG, "@brief Enum constant QSurfaceFormat::OpenVG"),
  "@qt\n@brief This class represents the QSurfaceFormat::RenderableType enum");

static gsi::QFlagsClass<QSurfaceFormat::RenderableType > decl_QSurfaceFormat_RenderableType_Enums ("QtGui", "QSurfaceFormat_QFlags_RenderableType",
  "@qt\n@brief This class represents the QFlags<QSurfaceFormat::RenderableType> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QSurfaceFormat> inject_QSurfaceFormat_RenderableType_Enum_in_parent (decl_QSurfaceFormat_RenderableType_Enum.defs ());
static gsi::ClassExt<QSurfaceFormat> decl_QSurfaceFormat_RenderableType_Enum_as_child (decl_QSurfaceFormat_RenderableType_Enum, "RenderableType");
static gsi::ClassExt<QSurfaceFormat> decl_QSurfaceFormat_RenderableType_Enums_as_child (decl_QSurfaceFormat_RenderableType_Enums, "QFlags_RenderableType");

}


//  Implementation of the enum wrapper class for QSurfaceFormat::SwapBehavior
namespace qt_gsi
{

static gsi::Enum<QSurfaceFormat::SwapBehavior> decl_QSurfaceFormat_SwapBehavior_Enum ("QtGui", "QSurfaceFormat_SwapBehavior",
    gsi::enum_const ("DefaultSwapBehavior", QSurfaceFormat::DefaultSwapBehavior, "@brief Enum constant QSurfaceFormat::DefaultSwapBehavior") +
    gsi::enum_const ("SingleBuffer", QSurfaceFormat::SingleBuffer, "@brief Enum constant QSurfaceFormat::SingleBuffer") +
    gsi::enum_const ("DoubleBuffer", QSurfaceFormat::DoubleBuffer, "@brief Enum constant QSurfaceFormat::DoubleBuffer") +
    gsi::enum_const ("TripleBuffer", QSurfaceFormat::TripleBuffer, "@brief Enum constant QSurfaceFormat::TripleBuffer"),
  "@qt\n@brief This class represents the QSurfaceFormat::SwapBehavior enum");

static gsi::QFlagsClass<QSurfaceFormat::SwapBehavior > decl_QSurfaceFormat_SwapBehavior_Enums ("QtGui", "QSurfaceFormat_QFlags_SwapBehavior",
  "@qt\n@brief This class represents the QFlags<QSurfaceFormat::SwapBehavior> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QSurfaceFormat> inject_QSurfaceFormat_SwapBehavior_Enum_in_parent (decl_QSurfaceFormat_SwapBehavior_Enum.defs ());
static gsi::ClassExt<QSurfaceFormat> decl_QSurfaceFormat_SwapBehavior_Enum_as_child (decl_QSurfaceFormat_SwapBehavior_Enum, "SwapBehavior");
static gsi::ClassExt<QSurfaceFormat> decl_QSurfaceFormat_SwapBehavior_Enums_as_child (decl_QSurfaceFormat_SwapBehavior_Enums, "QFlags_SwapBehavior");

}

