.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\" Copyright \(co 2000  The XFree86 Project, Inc.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided "as is" without express or implied warranty.
.\"
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.TH XStringListToTextProperty __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XStringListToTextProperty, XTextPropertyToStringList, XFreeStringList, XTextProperty \- convert string lists and text property structure
.SH SYNTAX
.HP
Status XStringListToTextProperty\^(\^char **\fIlist\fP\^, int \fIcount\fP\^,
XTextProperty *\fItext_prop_return\fP\^);
.HP
Status XTextPropertyToStringList\^(\^XTextProperty *\fItext_prop\fP\^, char
***\fIlist_return\fP\^, int *\fIcount_return\fP\^);
.HP
void XFreeStringList\^(\^char **\fIlist\fP\^);
.SH ARGUMENTS
.IP \fIcount\fP 1i
Specifies the number of strings.
.IP \fIcount_return\fP 1i
Returns the number of strings.
.IP \fIlist\fP 1i
Specifies the list of strings to be freed.
.IP \fIlist\fP 1i
Specifies a list of null-terminated character strings.
.IP \fIlist_return\fP 1i
Returns a list of null-terminated character strings.
.IP \fItext_prop\fP 1i
Specifies the
.B XTextProperty
structure to be used.
.IP \fItext_prop_return\fP 1i
Returns the
.B XTextProperty
structure.
.SH DESCRIPTION
The
.B XStringListToTextProperty
function sets the specified
.B XTextProperty
to be of type STRING (format 8) with a value representing the
concatenation of the specified list of null-separated character strings.
An extra null byte (which is not included in the nitems member)
is stored at the end of the value field of text_prop_return.
The strings are assumed (without verification) to be in the STRING encoding.
If insufficient memory is available for the new value string,
.B XStringListToTextProperty
does not set any fields in the
.B XTextProperty
structure and returns a zero status.
Otherwise, it returns a nonzero status.
To free the storage for the value field, use
.BR XFree .
.LP
The
.B XTextPropertyToStringList
function returns a list of strings representing the null-separated elements
of the specified
.B XTextProperty
structure.
The data in text_prop must be of type STRING and format 8.
Multiple elements of the property
(for example, the strings in a disjoint text selection)
are separated by NULL (encoding 0).
The contents of the property are not null-terminated.
If insufficient memory is available for the list and its elements,
.B XTextPropertyToStringList
sets no return values and returns a zero status.
Otherwise, it returns a nonzero status.
To free the storage for the list and its contents, use
.BR XFreeStringList .
.LP
The
.B XFreeStringList
function releases memory allocated by
.BR XmbTextPropertyToTextList ,
.B Xutf8TextPropertyToTextList
and
.B XTextPropertyToStringList
and the missing charset list allocated by
.BR XCreateFontSet .
.SH STRUCTURES
The
.B XTextProperty
structure contains:
.LP
.EX
typedef struct {
        unsigned char *value;   /\&* property data */
        Atom encoding;  /\&* type of property */
        int format;     /\&* 8, 16, or 32 */
        unsigned long nitems;   /\&* number of items in value */
} XTextProperty;
.EE
.SH "SEE ALSO"
XAllocClassHint(__libmansuffix__),
XAllocIconSize(__libmansuffix__),
XAllocSizeHints(__libmansuffix__),
XAllocWMHints(__libmansuffix__),
XFree(__libmansuffix__),
XSetCommand(__libmansuffix__),
XSetTransientForHint(__libmansuffix__),
XSetTextProperty(__libmansuffix__),
XSetWMClientMachine(__libmansuffix__),
XSetWMColormapWindows(__libmansuffix__),
XSetWMIconName(__libmansuffix__),
XSetWMName(__libmansuffix__),
XSetWMProperties(__libmansuffix__),
XSetWMProtocols(__libmansuffix__)
.br
\fI\*(xL\fP
