#
# Copyright (C) 2014-2022, AdaCore
# SPDX-License-Identifier: Apache-2.0
#

"""
This script is meant to be sourced inside GDB when debugging a program that
uses libadalang. It installs Langkit's "GDB helpers": pretty-printers and
custom commands that are convenient when debugging libadalang. Note that GDB
helpers require the Langkit Python library.
"""

import sys


sys.path.append('/usr/pkg/lib/python3.13/site-packages')


try:
    import langkit.gdb
except ImportError as exc:
    print(
        f"{__file__}: Cannot import the 'langkit.gdb' Python package: langkit"
        " GDB helpers require it",
        file=sys.stderr,
    )
else:
    
    langkit.gdb.setup(
        lib_name='libadalang',
        astnode_names=['Ada_Node', 'Abort_Node', 'Abort_Absent', 'Abort_Present', 'Abstract_Node', 'Abstract_Absent', 'Abstract_Present', 'Ada_List', 'Ada_Node_List', 'Abstract_State_Decl_List', 'Alternatives_List', 'Constraint_List', 'Decl_List', 'Stmt_List', 'Aspect_Assoc_List', 'Base_Assoc_List', 'Basic_Assoc_List', 'Assoc_List', 'Case_Expr_Alternative_List', 'Case_Stmt_Alternative_List', 'Compilation_Unit_List', 'Concat_Operand_List', 'Contract_Case_Assoc_List', 'Defining_Name_List', 'Discriminant_Spec_List', 'Elsif_Expr_Part_List', 'Elsif_Stmt_Part_List', 'Enum_Literal_Decl_List', 'Expr_List', 'Expr_Alternatives_List', 'Format_String_Chunk_List', 'Identifier_List', 'Discriminant_Choice_List', 'Name_List', 'Parent_List', 'Param_Spec_List', 'Pragma_Node_List', 'Select_When_Part_List', 'Unconstrained_Array_Index_List', 'Variant_List', 'Aliased_Node', 'Aliased_Absent', 'Aliased_Present', 'All_Node', 'All_Absent', 'All_Present', 'Array_Indices', 'Constrained_Array_Indices', 'Unconstrained_Array_Indices', 'Aspect_Assoc', 'Aspect_Clause', 'At_Clause', 'Attribute_Def_Clause', 'Enum_Rep_Clause', 'Record_Rep_Clause', 'Aspect_Spec', 'Base_Assoc', 'Contract_Case_Assoc', 'Pragma_Argument_Assoc', 'Base_Formal_Param_Holder', 'Base_Subp_Spec', 'Entry_Spec', 'Enum_Subp_Spec', 'Subp_Spec', 'Synthetic_Binary_Spec', 'Synthetic_Unary_Spec', 'Component_List', 'Discriminant_Part', 'Known_Discriminant_Part', 'Unknown_Discriminant_Part', 'Entry_Completion_Formal_Params', 'Generic_Formal_Part', 'Base_Record_Def', 'Null_Record_Def', 'Record_Def', 'Basic_Assoc', 'Aggregate_Assoc', 'Multi_Dim_Array_Assoc', 'Composite_Constraint_Assoc', 'Iterated_Assoc', 'Param_Assoc', 'Basic_Decl', 'Abstract_State_Decl', 'Anonymous_Expr_Decl', 'Base_Formal_Param_Decl', 'Component_Decl', 'Discriminant_Spec', 'Generic_Formal', 'Generic_Formal_Obj_Decl', 'Generic_Formal_Package', 'Generic_Formal_Subp_Decl', 'Generic_Formal_Type_Decl', 'Param_Spec', 'Synthetic_Formal_Param_Decl', 'Base_Package_Decl', 'Generic_Package_Internal', 'Package_Decl', 'Base_Type_Decl', 'Base_Subtype_Decl', 'Discrete_Base_Subtype_Decl', 'Subtype_Decl', 'Classwide_Type_Decl', 'Incomplete_Type_Decl', 'Incomplete_Formal_Type_Decl', 'Incomplete_Tagged_Type_Decl', 'Protected_Type_Decl', 'Task_Type_Decl', 'Single_Task_Type_Decl', 'Type_Decl', 'Anonymous_Type_Decl', 'Synth_Anonymous_Type_Decl', 'Concrete_Type_Decl', 'Formal_Type_Decl', 'Basic_Subp_Decl', 'Classic_Subp_Decl', 'Abstract_Subp_Decl', 'Formal_Subp_Decl', 'Abstract_Formal_Subp_Decl', 'Concrete_Formal_Subp_Decl', 'Subp_Decl', 'Entry_Decl', 'Enum_Literal_Decl', 'Synthetic_Char_Enum_Lit', 'Generic_Subp_Internal', 'Synthetic_Subp_Decl', 'Body_Node', 'Accept_Stmt_Body', 'Base_Subp_Body', 'Expr_Function', 'Null_Subp_Decl', 'Subp_Body', 'Subp_Renaming_Decl', 'Body_Stub', 'Package_Body_Stub', 'Protected_Body_Stub', 'Subp_Body_Stub', 'Task_Body_Stub', 'Entry_Body', 'Package_Body', 'Protected_Body', 'Task_Body', 'Entry_Index_Spec', 'Error_Decl', 'Exception_Decl', 'Exception_Handler', 'For_Loop_Var_Decl', 'Generic_Decl', 'Generic_Package_Decl', 'Generic_Subp_Decl', 'Generic_Instantiation', 'Generic_Package_Instantiation', 'Generic_Subp_Instantiation', 'Generic_Renaming_Decl', 'Generic_Package_Renaming_Decl', 'Generic_Subp_Renaming_Decl', 'Label_Decl', 'Named_Stmt_Decl', 'Number_Decl', 'Object_Decl', 'Extended_Return_Stmt_Object_Decl', 'No_Type_Object_Renaming_Decl', 'Package_Renaming_Decl', 'Single_Protected_Decl', 'Single_Task_Decl', 'Synthetic_Object_Decl', 'Case_Stmt_Alternative', 'Compilation_Unit', 'Component_Clause', 'Component_Def', 'Constant_Node', 'Constant_Absent', 'Constant_Present', 'Constraint', 'Composite_Constraint', 'Delta_Constraint', 'Digits_Constraint', 'Range_Constraint', 'Declarative_Part', 'Private_Part', 'Public_Part', 'Elsif_Expr_Part', 'Elsif_Stmt_Part', 'Expr', 'Abstract_State_Decl_Expr', 'Allocator', 'Base_Aggregate', 'Aggregate', 'Bracket_Aggregate', 'Delta_Aggregate', 'Bracket_Delta_Aggregate', 'Null_Record_Aggregate', 'Bin_Op', 'Relation_Op', 'Box_Expr', 'Case_Expr_Alternative', 'Concat_Op', 'Concat_Operand', 'Cond_Expr', 'Case_Expr', 'If_Expr', 'Contract_Cases', 'Decl_Expr', 'Format_String_Literal', 'Membership_Expr', 'Name', 'Array_Subcomponent_Choice_Name', 'Attribute_Ref', 'Call_Expr', 'Defining_Name', 'Synthetic_Defining_Name', 'Discrete_Subtype_Name', 'Dotted_Name', 'End_Name', 'Explicit_Deref', 'Qual_Expr', 'Reduce_Attribute_Ref', 'Single_Tok_Node', 'Base_Id', 'Char_Literal', 'Identifier', 'Op', 'Op_Abs', 'Op_And', 'Op_And_Then', 'Op_Concat', 'Op_Div', 'Op_Double_Dot', 'Op_Eq', 'Op_Gt', 'Op_Gte', 'Op_In', 'Op_Lt', 'Op_Lte', 'Op_Minus', 'Op_Mod', 'Op_Mult', 'Op_Neq', 'Op_Not', 'Op_Not_In', 'Op_Or', 'Op_Or_Else', 'Op_Plus', 'Op_Pow', 'Op_Rem', 'Op_Xor', 'String_Literal', 'Null_Literal', 'Num_Literal', 'Int_Literal', 'Real_Literal', 'Synthetic_Identifier', 'Target_Name', 'Update_Attribute_Ref', 'Paren_Expr', 'Quantified_Expr', 'Raise_Expr', 'Un_Op', 'For_Loop_Iter_Filter', 'Format_String_Chunk', 'Format_String_Tok_Node', 'Format_String_Tok_End', 'Format_String_Tok_Mid', 'Format_String_Tok_Start', 'Format_String_Tok_String', 'Handled_Stmts', 'Interface_Kind', 'Interface_Kind_Limited', 'Interface_Kind_Protected', 'Interface_Kind_Synchronized', 'Interface_Kind_Task', 'Iter_Type', 'Iter_Type_In', 'Iter_Type_Of', 'Library_Item', 'Limited_Node', 'Limited_Absent', 'Limited_Present', 'Loop_Spec', 'For_Loop_Spec', 'While_Loop_Spec', 'Mode', 'Mode_Default', 'Mode_In', 'Mode_In_Out', 'Mode_Out', 'Multi_Abstract_State_Decl', 'Not_Null', 'Not_Null_Absent', 'Not_Null_Present', 'Null_Component_Decl', 'Others_Designator', 'Overriding_Node', 'Overriding_Not_Overriding', 'Overriding_Overriding', 'Overriding_Unspecified', 'Params', 'Paren_Abstract_State_Decl', 'Pp_Directive', 'Pp_Else_Directive', 'Pp_Elsif_Directive', 'Pp_End_If_Directive', 'Pp_If_Directive', 'Pp_Then_Kw', 'Pragma_Node', 'Private_Node', 'Private_Absent', 'Private_Present', 'Protected_Def', 'Protected_Node', 'Protected_Absent', 'Protected_Present', 'Quantifier', 'Quantifier_All', 'Quantifier_Some', 'Range_Spec', 'Renaming_Clause', 'Synthetic_Renaming_Clause', 'Reverse_Node', 'Reverse_Absent', 'Reverse_Present', 'Select_When_Part', 'Stmt', 'Composite_Stmt', 'Accept_Stmt', 'Accept_Stmt_With_Stmts', 'Base_Loop_Stmt', 'For_Loop_Stmt', 'Loop_Stmt', 'While_Loop_Stmt', 'Block_Stmt', 'Begin_Block', 'Decl_Block', 'Case_Stmt', 'Extended_Return_Stmt', 'If_Stmt', 'Named_Stmt', 'Select_Stmt', 'Error_Stmt', 'Simple_Stmt', 'Abort_Stmt', 'Assign_Stmt', 'Call_Stmt', 'Delay_Stmt', 'Exit_Stmt', 'Goto_Stmt', 'Label', 'Null_Stmt', 'Raise_Stmt', 'Requeue_Stmt', 'Return_Stmt', 'Simple_Decl_Stmt', 'Terminate_Alternative', 'Subp_Kind', 'Subp_Kind_Function', 'Subp_Kind_Procedure', 'Subunit', 'Synchronized_Node', 'Synchronized_Absent', 'Synchronized_Present', 'Tagged_Node', 'Tagged_Absent', 'Tagged_Present', 'Task_Def', 'Type_Attributes_Repository', 'Type_Def', 'Access_Def', 'Access_To_Subp_Def', 'Base_Type_Access_Def', 'Anonymous_Type_Access_Def', 'Type_Access_Def', 'Array_Type_Def', 'Derived_Type_Def', 'Enum_Type_Def', 'Formal_Discrete_Type_Def', 'Interface_Type_Def', 'Mod_Int_Type_Def', 'Private_Type_Def', 'Real_Type_Def', 'Decimal_Fixed_Point_Def', 'Floating_Point_Def', 'Ordinary_Fixed_Point_Def', 'Record_Type_Def', 'Signed_Int_Type_Def', 'Type_Expr', 'Anonymous_Type', 'Enum_Lit_Synth_Type_Expr', 'Subtype_Indication', 'Constrained_Subtype_Indication', 'Discrete_Subtype_Indication', 'Synthetic_Type_Expr', 'Unconstrained_Array_Index', 'Until_Node', 'Until_Absent', 'Until_Present', 'Use_Clause', 'Use_Package_Clause', 'Use_Type_Clause', 'Value_Sequence', 'Variant', 'Variant_Part', 'With_Clause', 'With_Private', 'With_Private_Absent', 'With_Private_Present'],
        astnode_kinds={1: 'Abort_Absent', 2: 'Abort_Present', 3: 'Abstract_Absent', 4: 'Abstract_Present', 5: 'Ada_Node_List', 6: 'Abstract_State_Decl_List', 7: 'Alternatives_List', 8: 'Constraint_List', 9: 'Decl_List', 10: 'Stmt_List', 11: 'Aspect_Assoc_List', 12: 'Base_Assoc_List', 13: 'Assoc_List', 14: 'Case_Expr_Alternative_List', 15: 'Case_Stmt_Alternative_List', 16: 'Compilation_Unit_List', 17: 'Concat_Operand_List', 18: 'Contract_Case_Assoc_List', 19: 'Defining_Name_List', 20: 'Discriminant_Spec_List', 21: 'Elsif_Expr_Part_List', 22: 'Elsif_Stmt_Part_List', 23: 'Enum_Literal_Decl_List', 24: 'Expr_Alternatives_List', 25: 'Format_String_Chunk_List', 26: 'Discriminant_Choice_List', 27: 'Name_List', 28: 'Parent_List', 29: 'Param_Spec_List', 30: 'Pragma_Node_List', 31: 'Select_When_Part_List', 32: 'Unconstrained_Array_Index_List', 33: 'Variant_List', 34: 'Aliased_Absent', 35: 'Aliased_Present', 36: 'All_Absent', 37: 'All_Present', 38: 'Constrained_Array_Indices', 39: 'Unconstrained_Array_Indices', 40: 'Aspect_Assoc', 41: 'At_Clause', 42: 'Attribute_Def_Clause', 43: 'Enum_Rep_Clause', 44: 'Record_Rep_Clause', 45: 'Aspect_Spec', 46: 'Contract_Case_Assoc', 47: 'Pragma_Argument_Assoc', 48: 'Entry_Spec', 49: 'Enum_Subp_Spec', 50: 'Subp_Spec', 51: 'Synthetic_Binary_Spec', 52: 'Synthetic_Unary_Spec', 53: 'Component_List', 54: 'Known_Discriminant_Part', 55: 'Unknown_Discriminant_Part', 56: 'Entry_Completion_Formal_Params', 57: 'Generic_Formal_Part', 58: 'Null_Record_Def', 59: 'Record_Def', 60: 'Aggregate_Assoc', 61: 'Multi_Dim_Array_Assoc', 62: 'Composite_Constraint_Assoc', 63: 'Iterated_Assoc', 64: 'Param_Assoc', 65: 'Abstract_State_Decl', 66: 'Anonymous_Expr_Decl', 67: 'Component_Decl', 68: 'Discriminant_Spec', 69: 'Generic_Formal_Obj_Decl', 70: 'Generic_Formal_Package', 71: 'Generic_Formal_Subp_Decl', 72: 'Generic_Formal_Type_Decl', 73: 'Param_Spec', 74: 'Synthetic_Formal_Param_Decl', 75: 'Generic_Package_Internal', 76: 'Package_Decl', 77: 'Discrete_Base_Subtype_Decl', 78: 'Subtype_Decl', 79: 'Classwide_Type_Decl', 80: 'Incomplete_Type_Decl', 81: 'Incomplete_Formal_Type_Decl', 82: 'Incomplete_Tagged_Type_Decl', 83: 'Protected_Type_Decl', 84: 'Task_Type_Decl', 85: 'Single_Task_Type_Decl', 86: 'Anonymous_Type_Decl', 87: 'Synth_Anonymous_Type_Decl', 88: 'Concrete_Type_Decl', 89: 'Formal_Type_Decl', 90: 'Abstract_Subp_Decl', 91: 'Abstract_Formal_Subp_Decl', 92: 'Concrete_Formal_Subp_Decl', 93: 'Subp_Decl', 94: 'Entry_Decl', 95: 'Enum_Literal_Decl', 96: 'Synthetic_Char_Enum_Lit', 97: 'Generic_Subp_Internal', 98: 'Synthetic_Subp_Decl', 99: 'Accept_Stmt_Body', 100: 'Expr_Function', 101: 'Null_Subp_Decl', 102: 'Subp_Body', 103: 'Subp_Renaming_Decl', 104: 'Package_Body_Stub', 105: 'Protected_Body_Stub', 106: 'Subp_Body_Stub', 107: 'Task_Body_Stub', 108: 'Entry_Body', 109: 'Package_Body', 110: 'Protected_Body', 111: 'Task_Body', 112: 'Entry_Index_Spec', 113: 'Error_Decl', 114: 'Exception_Decl', 115: 'Exception_Handler', 116: 'For_Loop_Var_Decl', 117: 'Generic_Package_Decl', 118: 'Generic_Subp_Decl', 119: 'Generic_Package_Instantiation', 120: 'Generic_Subp_Instantiation', 121: 'Generic_Package_Renaming_Decl', 122: 'Generic_Subp_Renaming_Decl', 123: 'Label_Decl', 124: 'Named_Stmt_Decl', 125: 'Number_Decl', 126: 'Object_Decl', 127: 'Extended_Return_Stmt_Object_Decl', 128: 'No_Type_Object_Renaming_Decl', 129: 'Package_Renaming_Decl', 130: 'Single_Protected_Decl', 131: 'Single_Task_Decl', 132: 'Synthetic_Object_Decl', 133: 'Case_Stmt_Alternative', 134: 'Compilation_Unit', 135: 'Component_Clause', 136: 'Component_Def', 137: 'Constant_Absent', 138: 'Constant_Present', 139: 'Composite_Constraint', 140: 'Delta_Constraint', 141: 'Digits_Constraint', 142: 'Range_Constraint', 143: 'Declarative_Part', 144: 'Private_Part', 145: 'Public_Part', 146: 'Elsif_Expr_Part', 147: 'Elsif_Stmt_Part', 148: 'Abstract_State_Decl_Expr', 149: 'Allocator', 150: 'Aggregate', 151: 'Bracket_Aggregate', 152: 'Delta_Aggregate', 153: 'Bracket_Delta_Aggregate', 154: 'Null_Record_Aggregate', 155: 'Bin_Op', 156: 'Relation_Op', 157: 'Box_Expr', 158: 'Case_Expr_Alternative', 159: 'Concat_Op', 160: 'Concat_Operand', 161: 'Case_Expr', 162: 'If_Expr', 163: 'Contract_Cases', 164: 'Decl_Expr', 165: 'Format_String_Literal', 166: 'Membership_Expr', 167: 'Array_Subcomponent_Choice_Name', 168: 'Attribute_Ref', 169: 'Call_Expr', 170: 'Defining_Name', 171: 'Synthetic_Defining_Name', 172: 'Discrete_Subtype_Name', 173: 'Dotted_Name', 174: 'End_Name', 175: 'Explicit_Deref', 176: 'Qual_Expr', 177: 'Reduce_Attribute_Ref', 178: 'Char_Literal', 179: 'Identifier', 180: 'Op_Abs', 181: 'Op_And', 182: 'Op_And_Then', 183: 'Op_Concat', 184: 'Op_Div', 185: 'Op_Double_Dot', 186: 'Op_Eq', 187: 'Op_Gt', 188: 'Op_Gte', 189: 'Op_In', 190: 'Op_Lt', 191: 'Op_Lte', 192: 'Op_Minus', 193: 'Op_Mod', 194: 'Op_Mult', 195: 'Op_Neq', 196: 'Op_Not', 197: 'Op_Not_In', 198: 'Op_Or', 199: 'Op_Or_Else', 200: 'Op_Plus', 201: 'Op_Pow', 202: 'Op_Rem', 203: 'Op_Xor', 204: 'String_Literal', 205: 'Null_Literal', 206: 'Int_Literal', 207: 'Real_Literal', 208: 'Synthetic_Identifier', 209: 'Target_Name', 210: 'Update_Attribute_Ref', 211: 'Paren_Expr', 212: 'Quantified_Expr', 213: 'Raise_Expr', 214: 'Un_Op', 215: 'For_Loop_Iter_Filter', 216: 'Format_String_Chunk', 217: 'Format_String_Tok_End', 218: 'Format_String_Tok_Mid', 219: 'Format_String_Tok_Start', 220: 'Format_String_Tok_String', 221: 'Handled_Stmts', 222: 'Interface_Kind_Limited', 223: 'Interface_Kind_Protected', 224: 'Interface_Kind_Synchronized', 225: 'Interface_Kind_Task', 226: 'Iter_Type_In', 227: 'Iter_Type_Of', 228: 'Library_Item', 229: 'Limited_Absent', 230: 'Limited_Present', 231: 'For_Loop_Spec', 232: 'While_Loop_Spec', 233: 'Mode_Default', 234: 'Mode_In', 235: 'Mode_In_Out', 236: 'Mode_Out', 237: 'Multi_Abstract_State_Decl', 238: 'Not_Null_Absent', 239: 'Not_Null_Present', 240: 'Null_Component_Decl', 241: 'Others_Designator', 242: 'Overriding_Not_Overriding', 243: 'Overriding_Overriding', 244: 'Overriding_Unspecified', 245: 'Params', 246: 'Paren_Abstract_State_Decl', 247: 'Pp_Else_Directive', 248: 'Pp_Elsif_Directive', 249: 'Pp_End_If_Directive', 250: 'Pp_If_Directive', 251: 'Pp_Then_Kw', 252: 'Pragma_Node', 253: 'Private_Absent', 254: 'Private_Present', 255: 'Protected_Def', 256: 'Protected_Absent', 257: 'Protected_Present', 258: 'Quantifier_All', 259: 'Quantifier_Some', 260: 'Range_Spec', 261: 'Renaming_Clause', 262: 'Synthetic_Renaming_Clause', 263: 'Reverse_Absent', 264: 'Reverse_Present', 265: 'Select_When_Part', 266: 'Accept_Stmt', 267: 'Accept_Stmt_With_Stmts', 268: 'For_Loop_Stmt', 269: 'Loop_Stmt', 270: 'While_Loop_Stmt', 271: 'Begin_Block', 272: 'Decl_Block', 273: 'Case_Stmt', 274: 'Extended_Return_Stmt', 275: 'If_Stmt', 276: 'Named_Stmt', 277: 'Select_Stmt', 278: 'Error_Stmt', 279: 'Abort_Stmt', 280: 'Assign_Stmt', 281: 'Call_Stmt', 282: 'Delay_Stmt', 283: 'Exit_Stmt', 284: 'Goto_Stmt', 285: 'Label', 286: 'Null_Stmt', 287: 'Raise_Stmt', 288: 'Requeue_Stmt', 289: 'Return_Stmt', 290: 'Simple_Decl_Stmt', 291: 'Terminate_Alternative', 292: 'Subp_Kind_Function', 293: 'Subp_Kind_Procedure', 294: 'Subunit', 295: 'Synchronized_Absent', 296: 'Synchronized_Present', 297: 'Tagged_Absent', 298: 'Tagged_Present', 299: 'Task_Def', 300: 'Type_Attributes_Repository', 301: 'Access_To_Subp_Def', 302: 'Anonymous_Type_Access_Def', 303: 'Type_Access_Def', 304: 'Array_Type_Def', 305: 'Derived_Type_Def', 306: 'Enum_Type_Def', 307: 'Formal_Discrete_Type_Def', 308: 'Interface_Type_Def', 309: 'Mod_Int_Type_Def', 310: 'Private_Type_Def', 311: 'Decimal_Fixed_Point_Def', 312: 'Floating_Point_Def', 313: 'Ordinary_Fixed_Point_Def', 314: 'Record_Type_Def', 315: 'Signed_Int_Type_Def', 316: 'Anonymous_Type', 317: 'Enum_Lit_Synth_Type_Expr', 318: 'Subtype_Indication', 319: 'Constrained_Subtype_Indication', 320: 'Discrete_Subtype_Indication', 321: 'Synthetic_Type_Expr', 322: 'Unconstrained_Array_Index', 323: 'Until_Absent', 324: 'Until_Present', 325: 'Use_Package_Clause', 326: 'Use_Type_Clause', 327: 'Value_Sequence', 328: 'Variant', 329: 'Variant_Part', 330: 'With_Clause', 331: 'With_Private_Absent', 332: 'With_Private_Present'},
        prefix='lal'
    )
