# Contributing to LTFS

We love pull requests from everyone.

When contributing to this repository, please first discuss the change you wish to make via issue, email, or any other method with the owners of this repository before making a change.

Please note we have a [coding style guide](../docs/CODE_OF_CONDUCT.md), please follow it in all your interactions with the project.

1. Fork, then clone the repo

  ```
  git clone git@github.com:your-username/ltfs.git
  ```

2. Make your fix or change

  * Please follow the style guidelines of this project
  * Please comment to the code, particularly in hard-to-understand areas
  * Please remove all warnings in the first target environment (RHEL7 x86_64)
  * Please confrim your fix or change works as expected

3. Push to your fork and submit pull request.

4. At this point you're waiting until we may suggest some changes or improvements or alternatives.

__Some things that will increase the chance that your pull request is accepted__

* Follow our [coding style guide](../docs/CODE_OF_CONDUCT.md).
* Write a good commit message.
