---
title: "Grafana Mimir Helm chart version 3.2 release notes"
menuTitle: "V3.2 release notes"
description: "Release notes for Grafana Mimir Helm chart version 3.2"
weight: 300
---

# Grafana Mimir Helm chart version 3.2 release notes

Grafana Labs is excited to announce version 3.2 of the Grafana Mimir Helm chart, which is compatible with Grafana Mimir v2.4 or Grafana Enterprise Metrics (GEM) v2.3. The `mimir-distributed` Helm chart is the best way to install Mimir on Kubernetes.

To learn about new features and enhancements in Grafana Mimir or GEM, see the release notes for [Grafana Mimir v2.4](/docs/mimir/v2.4.x/release-notes/v2.4/) or [Grafana Enterprise Metrics v2.3](/docs/enterprise-metrics/latest/release-notes/v2-3/).

The highlights that follow include the top features, enhancements, and bugfixes in this release. For a comprehensive list of changes, see the [Helm chart changelog](https://github.com/grafana/mimir/tree/main/operations/helm/charts/mimir-distributed/CHANGELOG.md).

> **Note:** If you are upgrading from Grafana Mimir Helm chart 3.1, review the [list of important changes]({{< relref "#important-changes" >}}) that follow.

## Features and enhancements

Notable enhancements are as follows:

- Added support for [topologySpreadConstraints](https://kubernetes.io/docs/concepts/scheduling-eviction/topology-spread-constraints/).
- Replaced the default anti-affinity rules with topologySpreadConstraints for all components which puts less restrictions on where Kubernetes can run pods.
- Updated the anti affinity rules in the sizing plans (`small.yaml`, `large.yaml`, `capped-small.yaml`, or `capped-large.yaml`). The sizing plans now enforce that no two pods of the ingester, store-gateway, or alertmanager StatefulSets are scheduled on the same Node. Pods from different StatefulSets can share a Node.
- Support for Openshift Route resource for NGINX has been added.

## Important changes

In Grafana Mimir Helm chart v3.2, the following changes were made:

- If you are not using the sizing plans (`small.yaml`, `large.yaml`, `capped-small.yaml`, or `capped-large.yaml`) in production, you must reintroduce pod affinity rules for the ingester and store-gateway. This also fixes a missing label selector for the ingester.
  Merge the following configuration into your custom values file:
  ```yaml
  ingester:
    affinity:
      podAntiAffinity:
        requiredDuringSchedulingIgnoredDuringExecution:
          - labelSelector:
              matchExpressions:
                - key: target
                  operator: In
                  values:
                    - ingester
            topologyKey: "kubernetes.io/hostname"
          - labelSelector:
              matchExpressions:
                - key: app.kubernetes.io/component
                  operator: In
                  values:
                    - ingester
            topologyKey: "kubernetes.io/hostname"
  store_gateway:
    affinity:
      podAntiAffinity:
        requiredDuringSchedulingIgnoredDuringExecution:
          - labelSelector:
              matchExpressions:
                - key: target
                  operator: In
                  values:
                    - store-gateway
            topologyKey: "kubernetes.io/hostname"
          - labelSelector:
              matchExpressions:
                - key: app.kubernetes.io/component
                  operator: In
                  values:
                    - store-gateway
            topologyKey: "kubernetes.io/hostname"
  ```

## Bug fixes

- [PR 2906](https://github.com/grafana/mimir/pull/2906): Fix wrong label selector in ingester anti affinity rules in the sizing plans.
- [PR 3262](https://github.com/grafana/mimir/pull/3262): Query-scheduler no longer periodically terminates connections from query-frontends and queriers. This caused some queries to time out and EOF errors in the logs.
