; APX legacy conditional testcases

%macro testcase 2
 %ifdef BIN
  db %1
 %endif
 %ifdef SRC
  %2
 %endif
%endmacro

bits 64

; --- cmovcc - conditional move instruction ---
; - cmovb/cmovnae/cmovc - cmov if below -
testcase	{0x66, 0x0F, 0x42, 0x0A},		{cmovb cx, [rdx]}	; r/m16 -> reg16
testcase	{0x0F, 0x42, 0x0A},			{cmovb ecx, [rdx]}	; r/m32 -> reg32
testcase	{0x4C, 0x0F, 0x42, 0x0A},		{cmovb r9, [rdx]}	; r/m64 -> reg64
testcase	{0x66, 0x0F, 0x42, 0x0A},		{cmovnae cx, [rdx]}	; r/m16 -> reg16
testcase	{0x0F, 0x42, 0x0A},			{cmovnae ecx, [rdx]}	; r/m32 -> reg32
testcase	{0x4C, 0x0F, 0x42, 0x0A},		{cmovnae r9, [rdx]}	; r/m64 -> reg64

; implicit evex through ND
testcase	{0x62, 0xF4, 0x35, 0x10, 0x42, 0x0A},	{cmovb r25w, cx, [rdx]}		; ndd16 = cond ? r/m16 : reg16
testcase	{0x62, 0xF4, 0x34, 0x10, 0x42, 0x0A},	{cmovb r25d, ecx, [rdx]}	; ndd32 = cond ? r/m32 : reg32
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x42, 0x0A},	{cmovb r25, rcx, [rdx]}		; ndd64 = cond ? r/m64 : reg64
testcase	{0x62, 0xF4, 0x35, 0x10, 0x42, 0x0A},	{cmovnae r25w, cx, [rdx]}	; ndd16 = cond ? r/m16 : reg16
testcase	{0x62, 0xF4, 0x34, 0x10, 0x42, 0x0A},	{cmovnae r25d, ecx, [rdx]}	; ndd32 = cond ? r/m32 : reg32
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x42, 0x0A},	{cmovnae r25, rcx, [rdx]}	; ndd64 = cond ? r/m64 : reg64

; rex2 variant
testcase	{0x66, 0xD5, 0xC4, 0x42, 0x0A},		{cmovb r25w, [rdx]}	; r/m16 -> ereg16
testcase	{0xD5, 0xC4, 0x42, 0x0A},		{cmovb r25d, [rdx]}	; r/m32 -> ereg32
testcase	{0xD5, 0xCC, 0x42, 0x0A},		{cmovb r25, [rdx]}	; r/m64 -> ereg64
testcase	{0x66, 0xD5, 0xC4, 0x42, 0x0A},		{cmovnae r25w, [rdx]}	; r/m16 -> ereg16
testcase	{0xD5, 0xC4, 0x42, 0x0A},		{cmovnae r25d, [rdx]}	; r/m32 -> ereg32
testcase	{0xD5, 0xCC, 0x42, 0x0A},		{cmovnae r25, [rdx]}	; r/m64 -> ereg64

; - cmovbe/cmovna - cmov if below or equal -
testcase	{0x66, 0x0F, 0x46, 0x0A},		{cmovbe cx, [rdx]}	; r/m16 -> reg16
testcase	{0x0F, 0x46, 0x0A},			{cmovbe ecx, [rdx]}	; r/m32 -> reg32
testcase	{0x4C, 0x0F, 0x46, 0x0A},		{cmovbe r9, [rdx]}	; r/m64 -> reg64
testcase	{0x66, 0x0F, 0x46, 0x0A},		{cmovna cx, [rdx]}	; r/m16 -> reg16
testcase	{0x0F, 0x46, 0x0A},			{cmovna ecx, [rdx]}	; r/m32 -> reg32
testcase	{0x4C, 0x0F, 0x46, 0x0A},		{cmovna r9, [rdx]}	; r/m64 -> reg64

; implicit evex through ND
testcase	{0x62, 0xF4, 0x35, 0x10, 0x46, 0x0A},	{cmovbe r25w, cx, [rdx]}	; ndd16 = cond ? r/m16 : reg16
testcase	{0x62, 0xF4, 0x34, 0x10, 0x46, 0x0A},	{cmovbe r25d, ecx, [rdx]}	; ndd32 = cond ? r/m32 : reg32
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x46, 0x0A},	{cmovbe r25, rcx, [rdx]}	; ndd64 = cond ? r/m64 : reg64
testcase	{0x62, 0xF4, 0x35, 0x10, 0x46, 0x0A},	{cmovna r25w, cx, [rdx]}	; ndd16 = cond ? r/m16 : reg16
testcase	{0x62, 0xF4, 0x34, 0x10, 0x46, 0x0A},	{cmovna r25d, ecx, [rdx]}	; ndd32 = cond ? r/m32 : reg32
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x46, 0x0A},	{cmovna r25, rcx, [rdx]}	; ndd64 = cond ? r/m64 : reg64

; rex2 variant
testcase	{0x66, 0xD5, 0xC4, 0x46, 0x0A},		{cmovbe r25w, [rdx]}	; r/m16 -> ereg16
testcase	{0xD5, 0xC4, 0x46, 0x0A},		{cmovbe r25d, [rdx]}	; r/m32 -> ereg32
testcase	{0xD5, 0xCC, 0x46, 0x0A},		{cmovbe r25, [rdx]}	; r/m64 -> ereg64
testcase	{0x66, 0xD5, 0xC4, 0x46, 0x0A},		{cmovna r25w, [rdx]}	; r/m16 -> ereg16
testcase	{0xD5, 0xC4, 0x46, 0x0A},		{cmovna r25d, [rdx]}	; r/m32 -> ereg32
testcase	{0xD5, 0xCC, 0x46, 0x0A},		{cmovna r25, [rdx]}	; r/m64 -> ereg64

; - cmovl/cmovnge - cmov if less -
testcase	{0x66, 0x0F, 0x4C, 0x0A},		{cmovl cx, [rdx]}	; r/m16 -> reg16
testcase	{0x0F, 0x4C, 0x0A},			{cmovl ecx, [rdx]}	; r/m32 -> reg32
testcase	{0x4C, 0x0F, 0x4C, 0x0A},		{cmovl r9, [rdx]}	; r/m64 -> reg64
testcase	{0x66, 0x0F, 0x4C, 0x0A},		{cmovnge cx, [rdx]}	; r/m16 -> reg16
testcase	{0x0F, 0x4C, 0x0A},			{cmovnge ecx, [rdx]}	; r/m32 -> reg32
testcase	{0x4C, 0x0F, 0x4C, 0x0A},		{cmovnge r9, [rdx]}	; r/m64 -> reg64

; implicit evex through ND
testcase	{0x62, 0xF4, 0x35, 0x10, 0x4C, 0x0A},	{cmovl r25w, cx, [rdx]}		; ndd16 = cond ? r/m16 : reg16
testcase	{0x62, 0xF4, 0x34, 0x10, 0x4C, 0x0A},	{cmovl r25d, ecx, [rdx]}	; ndd32 = cond ? r/m32 : reg32
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x4C, 0x0A},	{cmovl r25, rcx, [rdx]}		; ndd64 = cond ? r/m64 : reg64
testcase	{0x62, 0xF4, 0x35, 0x10, 0x4C, 0x0A},	{cmovnge r25w, cx, [rdx]}	; ndd16 = cond ? r/m16 : reg16
testcase	{0x62, 0xF4, 0x34, 0x10, 0x4C, 0x0A},	{cmovnge r25d, ecx, [rdx]}	; ndd32 = cond ? r/m32 : reg32
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x4C, 0x0A},	{cmovnge r25, rcx, [rdx]}	; ndd64 = cond ? r/m64 : reg64

; rex2 variant
testcase	{0x66, 0xD5, 0xC4, 0x4C, 0x0A},		{cmovl r25w, [rdx]}	; r/m16 -> ereg16
testcase	{0xD5, 0xC4, 0x4C, 0x0A},		{cmovl r25d, [rdx]}	; r/m32 -> ereg32
testcase	{0xD5, 0xCC, 0x4C, 0x0A},		{cmovl r25, [rdx]}	; r/m64 -> ereg64
testcase	{0x66, 0xD5, 0xC4, 0x4C, 0x0A},		{cmovnge r25w, [rdx]}	; r/m16 -> ereg16
testcase	{0xD5, 0xC4, 0x4C, 0x0A},		{cmovnge r25d, [rdx]}	; r/m32 -> ereg32
testcase	{0xD5, 0xCC, 0x4C, 0x0A},		{cmovnge r25, [rdx]}	; r/m64 -> ereg64

; - cmovle/cmovng - cmov if less or equal -
testcase	{0x66, 0x0F, 0x4E, 0x0A},		{cmovle cx, [rdx]}	; r/m16 -> reg16
testcase	{0x0F, 0x4E, 0x0A},			{cmovle ecx, [rdx]}	; r/m32 -> reg32
testcase	{0x4C, 0x0F, 0x4E, 0x0A},		{cmovle r9, [rdx]}	; r/m64 -> reg64
testcase	{0x66, 0x0F, 0x4E, 0x0A},		{cmovng cx, [rdx]}	; r/m16 -> reg16
testcase	{0x0F, 0x4E, 0x0A},			{cmovng ecx, [rdx]}	; r/m32 -> reg32
testcase	{0x4C, 0x0F, 0x4E, 0x0A},		{cmovng r9, [rdx]}	; r/m64 -> reg64

; implicit evex through ND
testcase	{0x62, 0xF4, 0x35, 0x10, 0x4E, 0x0A},	{cmovle r25w, cx, [rdx]}	; ndd16 = cond ? r/m16 : reg16
testcase	{0x62, 0xF4, 0x34, 0x10, 0x4E, 0x0A},	{cmovle r25d, ecx, [rdx]}	; ndd32 = cond ? r/m32 : reg32
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x4E, 0x0A},	{cmovle r25, rcx, [rdx]}	; ndd64 = cond ? r/m64 : reg64
testcase	{0x62, 0xF4, 0x35, 0x10, 0x4E, 0x0A},	{cmovng r25w, cx, [rdx]}	; ndd16 = cond ? r/m16 : reg16
testcase	{0x62, 0xF4, 0x34, 0x10, 0x4E, 0x0A},	{cmovng r25d, ecx, [rdx]}	; ndd32 = cond ? r/m32 : reg32
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x4E, 0x0A},	{cmovng r25, rcx, [rdx]}	; ndd64 = cond ? r/m64 : reg64

; rex2 variant
testcase	{0x66, 0xD5, 0xC4, 0x4E, 0x0A},		{cmovle r25w, [rdx]}	; r/m16 -> ereg16
testcase	{0xD5, 0xC4, 0x4E, 0x0A},		{cmovle r25d, [rdx]}	; r/m32 -> ereg32
testcase	{0xD5, 0xCC, 0x4E, 0x0A},		{cmovle r25, [rdx]}	; r/m64 -> ereg64
testcase	{0x66, 0xD5, 0xC4, 0x4E, 0x0A},		{cmovng r25w, [rdx]}	; r/m16 -> ereg16
testcase	{0xD5, 0xC4, 0x4E, 0x0A},		{cmovng r25d, [rdx]}	; r/m32 -> ereg32
testcase	{0xD5, 0xCC, 0x4E, 0x0A},		{cmovng r25, [rdx]}	; r/m64 -> ereg64

; - cmovnb/cmovae/cmovnc - cmov if not below -
testcase	{0x66, 0x0F, 0x43, 0x0A},		{cmovnb cx, [rdx]}	; r/m16 -> reg16
testcase	{0x0F, 0x43, 0x0A},			{cmovnb ecx, [rdx]}	; r/m32 -> reg32
testcase	{0x4C, 0x0F, 0x43, 0x0A},		{cmovnb r9, [rdx]}	; r/m64 -> reg64
testcase	{0x66, 0x0F, 0x43, 0x0A},		{cmovae cx, [rdx]}	; r/m16 -> reg16
testcase	{0x0F, 0x43, 0x0A},			{cmovae ecx, [rdx]}	; r/m32 -> reg32
testcase	{0x4C, 0x0F, 0x43, 0x0A},		{cmovae r9, [rdx]}	; r/m64 -> reg64

; implicit evex through ND
testcase	{0x62, 0xF4, 0x35, 0x10, 0x43, 0x0A},	{cmovnb r25w, cx, [rdx]}	; ndd16 = cond ? r/m16 : reg16
testcase	{0x62, 0xF4, 0x34, 0x10, 0x43, 0x0A},	{cmovnb r25d, ecx, [rdx]}	; ndd32 = cond ? r/m32 : reg32
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x43, 0x0A},	{cmovnb r25, rcx, [rdx]}	; ndd64 = cond ? r/m64 : reg64
testcase	{0x62, 0xF4, 0x35, 0x10, 0x43, 0x0A},	{cmovae r25w, cx, [rdx]}	; ndd16 = cond ? r/m16 : reg16
testcase	{0x62, 0xF4, 0x34, 0x10, 0x43, 0x0A},	{cmovae r25d, ecx, [rdx]}	; ndd32 = cond ? r/m32 : reg32
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x43, 0x0A},	{cmovae r25, rcx, [rdx]}	; ndd64 = cond ? r/m64 : reg64

; rex2 variant
testcase	{0x66, 0xD5, 0xC4, 0x43, 0x0A},		{cmovnb r25w, [rdx]}	; r/m16 -> ereg16
testcase	{0xD5, 0xC4, 0x43, 0x0A},		{cmovnb r25d, [rdx]}	; r/m32 -> ereg32
testcase	{0xD5, 0xCC, 0x43, 0x0A},		{cmovnb r25, [rdx]}	; r/m64 -> ereg64
testcase	{0x66, 0xD5, 0xC4, 0x43, 0x0A},		{cmovae r25w, [rdx]}	; r/m16 -> ereg16
testcase	{0xD5, 0xC4, 0x43, 0x0A},		{cmovae r25d, [rdx]}	; r/m32 -> ereg32
testcase	{0xD5, 0xCC, 0x43, 0x0A},		{cmovae r25, [rdx]}	; r/m64 -> ereg64

; - cmovnbe/cmova - cmov if not below or equal -
testcase	{0x66, 0x0F, 0x47, 0x0A},		{cmovnbe cx, [rdx]}	; r/m16 -> reg16
testcase	{0x0F, 0x47, 0x0A},			{cmovnbe ecx, [rdx]}	; r/m32 -> reg32
testcase	{0x4C, 0x0F, 0x47, 0x0A},		{cmovnbe r9, [rdx]}	; r/m64 -> reg64
testcase	{0x66, 0x0F, 0x47, 0x0A},		{cmova cx, [rdx]}	; r/m16 -> reg16
testcase	{0x0F, 0x47, 0x0A},			{cmova ecx, [rdx]}	; r/m32 -> reg32
testcase	{0x4C, 0x0F, 0x47, 0x0A},		{cmova r9, [rdx]}	; r/m64 -> reg64

; implicit evex through ND
testcase	{0x62, 0xF4, 0x35, 0x10, 0x47, 0x0A},	{cmovnbe r25w, cx, [rdx]}	; ndd16 = cond ? r/m16 : reg16
testcase	{0x62, 0xF4, 0x34, 0x10, 0x47, 0x0A},	{cmovnbe r25d, ecx, [rdx]}	; ndd32 = cond ? r/m32 : reg32
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x47, 0x0A},	{cmovnbe r25, rcx, [rdx]}	; ndd64 = cond ? r/m64 : reg64
testcase	{0x62, 0xF4, 0x35, 0x10, 0x47, 0x0A},	{cmova r25w, cx, [rdx]}		; ndd16 = cond ? r/m16 : reg16
testcase	{0x62, 0xF4, 0x34, 0x10, 0x47, 0x0A},	{cmova r25d, ecx, [rdx]}	; ndd32 = cond ? r/m32 : reg32
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x47, 0x0A},	{cmova r25, rcx, [rdx]}		; ndd64 = cond ? r/m64 : reg64

; rex2 variant
testcase	{0x66, 0xD5, 0xC4, 0x47, 0x0A},		{cmovnbe r25w, [rdx]}	; r/m16 -> ereg16
testcase	{0xD5, 0xC4, 0x47, 0x0A},		{cmovnbe r25d, [rdx]}	; r/m32 -> ereg32
testcase	{0xD5, 0xCC, 0x47, 0x0A},		{cmovnbe r25, [rdx]}	; r/m64 -> ereg64
testcase	{0x66, 0xD5, 0xC4, 0x47, 0x0A},		{cmova r25w, [rdx]}	; r/m16 -> ereg16
testcase	{0xD5, 0xC4, 0x47, 0x0A},		{cmova r25d, [rdx]}	; r/m32 -> ereg32
testcase	{0xD5, 0xCC, 0x47, 0x0A},		{cmova r25, [rdx]}	; r/m64 -> ereg64

; - cmovnl/cmovge - cmov if not less -
testcase	{0x66, 0x0F, 0x4D, 0x0A},		{cmovnl cx, [rdx]}	; r/m16 -> reg16
testcase	{0x0F, 0x4D, 0x0A},			{cmovnl ecx, [rdx]}	; r/m32 -> reg32
testcase	{0x4C, 0x0F, 0x4D, 0x0A},		{cmovnl r9, [rdx]}	; r/m64 -> reg64
testcase	{0x66, 0x0F, 0x4D, 0x0A},		{cmovge cx, [rdx]}	; r/m16 -> reg16
testcase	{0x0F, 0x4D, 0x0A},			{cmovge ecx, [rdx]}	; r/m32 -> reg32
testcase	{0x4C, 0x0F, 0x4D, 0x0A},		{cmovge r9, [rdx]}	; r/m64 -> reg64

; implicit evex through ND
testcase	{0x62, 0xF4, 0x35, 0x10, 0x4D, 0x0A},	{cmovnl r25w, cx, [rdx]}	; ndd16 = cond ? r/m16 : reg16
testcase	{0x62, 0xF4, 0x34, 0x10, 0x4D, 0x0A},	{cmovnl r25d, ecx, [rdx]}	; ndd32 = cond ? r/m32 : reg32
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x4D, 0x0A},	{cmovnl r25, rcx, [rdx]}	; ndd64 = cond ? r/m64 : reg64
testcase	{0x62, 0xF4, 0x35, 0x10, 0x4D, 0x0A},	{cmovge r25w, cx, [rdx]}	; ndd16 = cond ? r/m16 : reg16
testcase	{0x62, 0xF4, 0x34, 0x10, 0x4D, 0x0A},	{cmovge r25d, ecx, [rdx]}	; ndd32 = cond ? r/m32 : reg32
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x4D, 0x0A},	{cmovge r25, rcx, [rdx]}	; ndd64 = cond ? r/m64 : reg64

; rex2 variant
testcase	{0x66, 0xD5, 0xC4, 0x4D, 0x0A},		{cmovnl r25w, [rdx]}	; r/m16 -> ereg16
testcase	{0xD5, 0xC4, 0x4D, 0x0A},		{cmovnl r25d, [rdx]}	; r/m32 -> ereg32
testcase	{0xD5, 0xCC, 0x4D, 0x0A},		{cmovnl r25, [rdx]}	; r/m64 -> ereg64
testcase	{0x66, 0xD5, 0xC4, 0x4D, 0x0A},		{cmovge r25w, [rdx]}	; r/m16 -> ereg16
testcase	{0xD5, 0xC4, 0x4D, 0x0A},		{cmovge r25d, [rdx]}	; r/m32 -> ereg32
testcase	{0xD5, 0xCC, 0x4D, 0x0A},		{cmovge r25, [rdx]}	; r/m64 -> ereg64

; - cmovnle/cmovg - cmov if not less or equal -
testcase	{0x66, 0x0F, 0x4F, 0x0A},		{cmovnle cx, [rdx]}	; r/m16 -> reg16
testcase	{0x0F, 0x4F, 0x0A},			{cmovnle ecx, [rdx]}	; r/m32 -> reg32
testcase	{0x4C, 0x0F, 0x4F, 0x0A},		{cmovnle r9, [rdx]}	; r/m64 -> reg64
testcase	{0x66, 0x0F, 0x4F, 0x0A},		{cmovg cx, [rdx]}	; r/m16 -> reg16
testcase	{0x0F, 0x4F, 0x0A},			{cmovg ecx, [rdx]}	; r/m32 -> reg32
testcase	{0x4C, 0x0F, 0x4F, 0x0A},		{cmovg r9, [rdx]}	; r/m64 -> reg64

; implicit evex through ND
testcase	{0x62, 0xF4, 0x35, 0x10, 0x4F, 0x0A},	{cmovnle r25w, cx, [rdx]}	; ndd16 = cond ? r/m16 : reg16
testcase	{0x62, 0xF4, 0x34, 0x10, 0x4F, 0x0A},	{cmovnle r25d, ecx, [rdx]}	; ndd32 = cond ? r/m32 : reg32
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x4F, 0x0A},	{cmovnle r25, rcx, [rdx]}	; ndd64 = cond ? r/m64 : reg64
testcase	{0x62, 0xF4, 0x35, 0x10, 0x4F, 0x0A},	{cmovg r25w, cx, [rdx]}		; ndd16 = cond ? r/m16 : reg16
testcase	{0x62, 0xF4, 0x34, 0x10, 0x4F, 0x0A},	{cmovg r25d, ecx, [rdx]}	; ndd32 = cond ? r/m32 : reg32
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x4F, 0x0A},	{cmovg r25, rcx, [rdx]}		; ndd64 = cond ? r/m64 : reg64

; rex2 variant
testcase	{0x66, 0xD5, 0xC4, 0x4F, 0x0A},		{cmovnle r25w, [rdx]}	; r/m16 -> ereg16
testcase	{0xD5, 0xC4, 0x4F, 0x0A},		{cmovnle r25d, [rdx]}	; r/m32 -> ereg32
testcase	{0xD5, 0xCC, 0x4F, 0x0A},		{cmovnle r25, [rdx]}	; r/m64 -> ereg64
testcase	{0x66, 0xD5, 0xC4, 0x4F, 0x0A},		{cmovg r25w, [rdx]}	; r/m16 -> ereg16
testcase	{0xD5, 0xC4, 0x4F, 0x0A},		{cmovg r25d, [rdx]}	; r/m32 -> ereg32
testcase	{0xD5, 0xCC, 0x4F, 0x0A},		{cmovg r25, [rdx]}	; r/m64 -> ereg64

; - cmovno - cmov if not overflow -
testcase	{0x66, 0x0F, 0x41, 0x0A},		{cmovno cx, [rdx]}	; r/m16 -> reg16
testcase	{0x0F, 0x41, 0x0A},			{cmovno ecx, [rdx]}	; r/m32 -> reg32
testcase	{0x4C, 0x0F, 0x41, 0x0A},		{cmovno r9, [rdx]}	; r/m64 -> reg64

; implicit evex through ND
testcase	{0x62, 0xF4, 0x35, 0x10, 0x41, 0x0A},	{cmovno r25w, cx, [rdx]}	; ndd16 = cond ? r/m16 : reg16
testcase	{0x62, 0xF4, 0x34, 0x10, 0x41, 0x0A},	{cmovno r25d, ecx, [rdx]}	; ndd32 = cond ? r/m32 : reg32
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x41, 0x0A},	{cmovno r25, rcx, [rdx]}	; ndd64 = cond ? r/m64 : reg64

; rex2 variant
testcase	{0x66, 0xD5, 0xC4, 0x41, 0x0A},		{cmovno r25w, [rdx]}	; r/m16 -> ereg16
testcase	{0xD5, 0xC4, 0x41, 0x0A},		{cmovno r25d, [rdx]}	; r/m32 -> ereg32
testcase	{0xD5, 0xCC, 0x41, 0x0A},		{cmovno r25, [rdx]}	; r/m64 -> ereg64

; - cmovnp/cmovpo - cmov if not parity -
testcase	{0x66, 0x0F, 0x4B, 0x0A},		{cmovnp cx, [rdx]}	; r/m16 -> reg16
testcase	{0x0F, 0x4B, 0x0A},			{cmovnp ecx, [rdx]}	; r/m32 -> reg32
testcase	{0x4C, 0x0F, 0x4B, 0x0A},		{cmovnp r9, [rdx]}	; r/m64 -> reg64
testcase	{0x66, 0x0F, 0x4B, 0x0A},		{cmovpo cx, [rdx]}	; r/m16 -> reg16
testcase	{0x0F, 0x4B, 0x0A},			{cmovpo ecx, [rdx]}	; r/m32 -> reg32
testcase	{0x4C, 0x0F, 0x4B, 0x0A},		{cmovpo r9, [rdx]}	; r/m64 -> reg64

; implicit evex through ND
testcase	{0x62, 0xF4, 0x35, 0x10, 0x4B, 0x0A},	{cmovnp r25w, cx, [rdx]}	; ndd16 = cond ? r/m16 : reg16
testcase	{0x62, 0xF4, 0x34, 0x10, 0x4B, 0x0A},	{cmovnp r25d, ecx, [rdx]}	; ndd32 = cond ? r/m32 : reg32
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x4B, 0x0A},	{cmovnp r25, rcx, [rdx]}	; ndd64 = cond ? r/m64 : reg64
testcase	{0x62, 0xF4, 0x35, 0x10, 0x4B, 0x0A},	{cmovpo r25w, cx, [rdx]}	; ndd16 = cond ? r/m16 : reg16
testcase	{0x62, 0xF4, 0x34, 0x10, 0x4B, 0x0A},	{cmovpo r25d, ecx, [rdx]}	; ndd32 = cond ? r/m32 : reg32
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x4B, 0x0A},	{cmovpo r25, rcx, [rdx]}	; ndd64 = cond ? r/m64 : reg64

; rex2 variant
testcase	{0x66, 0xD5, 0xC4, 0x4B, 0x0A},		{cmovnp r25w, [rdx]}	; r/m16 -> ereg16
testcase	{0xD5, 0xC4, 0x4B, 0x0A},		{cmovnp r25d, [rdx]}	; r/m32 -> ereg32
testcase	{0xD5, 0xCC, 0x4B, 0x0A},		{cmovnp r25, [rdx]}	; r/m64 -> ereg64
testcase	{0x66, 0xD5, 0xC4, 0x4B, 0x0A},		{cmovpo r25w, [rdx]}	; r/m16 -> ereg16
testcase	{0xD5, 0xC4, 0x4B, 0x0A},		{cmovpo r25d, [rdx]}	; r/m32 -> ereg32
testcase	{0xD5, 0xCC, 0x4B, 0x0A},		{cmovpo r25, [rdx]}	; r/m64 -> ereg64

; - cmovns - cmov if not signed -
testcase	{0x66, 0x0F, 0x49, 0x0A},		{cmovns cx, [rdx]}	; r/m16 -> reg16
testcase	{0x0F, 0x49, 0x0A},			{cmovns ecx, [rdx]}	; r/m32 -> reg32
testcase	{0x4C, 0x0F, 0x49, 0x0A},		{cmovns r9, [rdx]}	; r/m64 -> reg64

; implicit evex through ND
testcase	{0x62, 0xF4, 0x35, 0x10, 0x49, 0x0A},	{cmovns r25w, cx, [rdx]}	; ndd16 = cond ? r/m16 : reg16
testcase	{0x62, 0xF4, 0x34, 0x10, 0x49, 0x0A},	{cmovns r25d, ecx, [rdx]}	; ndd32 = cond ? r/m32 : reg32
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x49, 0x0A},	{cmovns r25, rcx, [rdx]}	; ndd64 = cond ? r/m64 : reg64

; rex2 variant
testcase	{0x66, 0xD5, 0xC4, 0x49, 0x0A},		{cmovns r25w, [rdx]}	; r/m16 -> ereg16
testcase	{0xD5, 0xC4, 0x49, 0x0A},		{cmovns r25d, [rdx]}	; r/m32 -> ereg32
testcase	{0xD5, 0xCC, 0x49, 0x0A},		{cmovns r25, [rdx]}	; r/m64 -> ereg64

; - cmovnz/cmovne - cmov if not zero -
testcase	{0x66, 0x0F, 0x45, 0x0A},		{cmovnz cx, [rdx]}	; r/m16 -> reg16
testcase	{0x0F, 0x45, 0x0A},			{cmovnz ecx, [rdx]}	; r/m32 -> reg32
testcase	{0x4C, 0x0F, 0x45, 0x0A},		{cmovnz r9, [rdx]}	; r/m64 -> reg64
testcase	{0x66, 0x0F, 0x45, 0x0A},		{cmovne cx, [rdx]}	; r/m16 -> reg16
testcase	{0x0F, 0x45, 0x0A},			{cmovne ecx, [rdx]}	; r/m32 -> reg32
testcase	{0x4C, 0x0F, 0x45, 0x0A},		{cmovne r9, [rdx]}	; r/m64 -> reg64

; implicit evex through ND
testcase	{0x62, 0xF4, 0x35, 0x10, 0x45, 0x0A},	{cmovnz r25w, cx, [rdx]}	; ndd16 = cond ? r/m16 : reg16
testcase	{0x62, 0xF4, 0x34, 0x10, 0x45, 0x0A},	{cmovnz r25d, ecx, [rdx]}	; ndd32 = cond ? r/m32 : reg32
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x45, 0x0A},	{cmovnz r25, rcx, [rdx]}	; ndd64 = cond ? r/m64 : reg64
testcase	{0x62, 0xF4, 0x35, 0x10, 0x45, 0x0A},	{cmovne r25w, cx, [rdx]}	; ndd16 = cond ? r/m16 : reg16
testcase	{0x62, 0xF4, 0x34, 0x10, 0x45, 0x0A},	{cmovne r25d, ecx, [rdx]}	; ndd32 = cond ? r/m32 : reg32
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x45, 0x0A},	{cmovne r25, rcx, [rdx]}	; ndd64 = cond ? r/m64 : reg64

; rex2 variant
testcase	{0x66, 0xD5, 0xC4, 0x45, 0x0A},		{cmovnz r25w, [rdx]}	; r/m16 -> ereg16
testcase	{0xD5, 0xC4, 0x45, 0x0A},		{cmovnz r25d, [rdx]}	; r/m32 -> ereg32
testcase	{0xD5, 0xCC, 0x45, 0x0A},		{cmovnz r25, [rdx]}	; r/m64 -> ereg64
testcase	{0x66, 0xD5, 0xC4, 0x45, 0x0A},		{cmovne r25w, [rdx]}	; r/m16 -> ereg16
testcase	{0xD5, 0xC4, 0x45, 0x0A},		{cmovne r25d, [rdx]}	; r/m32 -> ereg32
testcase	{0xD5, 0xCC, 0x45, 0x0A},		{cmovne r25, [rdx]}	; r/m64 -> ereg64

; - cmovo - cmov if overflow -
testcase	{0x66, 0x0F, 0x40, 0x0A},		{cmovo cx, [rdx]}	; r/m16 -> reg16
testcase	{0x0F, 0x40, 0x0A},			{cmovo ecx, [rdx]}	; r/m32 -> reg32
testcase	{0x4C, 0x0F, 0x40, 0x0A},		{cmovo r9, [rdx]}	; r/m64 -> reg64

; implicit evex through ND
testcase	{0x62, 0xF4, 0x35, 0x10, 0x40, 0x0A},	{cmovo r25w, cx, [rdx]}		; ndd16 = cond ? r/m16 : reg16
testcase	{0x62, 0xF4, 0x34, 0x10, 0x40, 0x0A},	{cmovo r25d, ecx, [rdx]}	; ndd32 = cond ? r/m32 : reg32
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x40, 0x0A},	{cmovo r25, rcx, [rdx]}		; ndd64 = cond ? r/m64 : reg64

; rex2 variant
testcase	{0x66, 0xD5, 0xC4, 0x40, 0x0A},		{cmovo r25w, [rdx]}	; r/m16 -> ereg16
testcase	{0xD5, 0xC4, 0x40, 0x0A},		{cmovo r25d, [rdx]}	; r/m32 -> ereg32
testcase	{0xD5, 0xCC, 0x40, 0x0A},		{cmovo r25, [rdx]}	; r/m64 -> ereg64

; - cmovp/cmovpe - cmov if parity -
testcase	{0x66, 0x0F, 0x4A, 0x0A},		{cmovp cx, [rdx]}	; r/m16 -> reg16
testcase	{0x0F, 0x4A, 0x0A},			{cmovp ecx, [rdx]}	; r/m32 -> reg32
testcase	{0x4C, 0x0F, 0x4A, 0x0A},		{cmovp r9, [rdx]}	; r/m64 -> reg64
testcase	{0x66, 0x0F, 0x4A, 0x0A},		{cmovpe cx, [rdx]}	; r/m16 -> reg16
testcase	{0x0F, 0x4A, 0x0A},			{cmovpe ecx, [rdx]}	; r/m32 -> reg32
testcase	{0x4C, 0x0F, 0x4A, 0x0A},		{cmovpe r9, [rdx]}	; r/m64 -> reg64

; implicit evex through ND
testcase	{0x62, 0xF4, 0x35, 0x10, 0x4A, 0x0A},	{cmovp r25w, cx, [rdx]}		; ndd16 = cond ? r/m16 : reg16
testcase	{0x62, 0xF4, 0x34, 0x10, 0x4A, 0x0A},	{cmovp r25d, ecx, [rdx]}	; ndd32 = cond ? r/m32 : reg32
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x4A, 0x0A},	{cmovp r25, rcx, [rdx]}		; ndd64 = cond ? r/m64 : reg64
testcase	{0x62, 0xF4, 0x35, 0x10, 0x4A, 0x0A},	{cmovpe r25w, cx, [rdx]}	; ndd16 = cond ? r/m16 : reg16
testcase	{0x62, 0xF4, 0x34, 0x10, 0x4A, 0x0A},	{cmovpe r25d, ecx, [rdx]}	; ndd32 = cond ? r/m32 : reg32
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x4A, 0x0A},	{cmovpe r25, rcx, [rdx]}	; ndd64 = cond ? r/m64 : reg64

; rex2 variant
testcase	{0x66, 0xD5, 0xC4, 0x4A, 0x0A},		{cmovp r25w, [rdx]}	; r/m16 -> ereg16
testcase	{0xD5, 0xC4, 0x4A, 0x0A},		{cmovp r25d, [rdx]}	; r/m32 -> ereg32
testcase	{0xD5, 0xCC, 0x4A, 0x0A},		{cmovp r25, [rdx]}	; r/m64 -> ereg64
testcase	{0x66, 0xD5, 0xC4, 0x4A, 0x0A},		{cmovpe r25w, [rdx]}	; r/m16 -> ereg16
testcase	{0xD5, 0xC4, 0x4A, 0x0A},		{cmovpe r25d, [rdx]}	; r/m32 -> ereg32
testcase	{0xD5, 0xCC, 0x4A, 0x0A},		{cmovpe r25, [rdx]}	; r/m64 -> ereg64

; - cmovs - cmov if signed -
testcase	{0x66, 0x0F, 0x48, 0x0A},		{cmovs cx, [rdx]}	; r/m16 -> reg16
testcase	{0x0F, 0x48, 0x0A},			{cmovs ecx, [rdx]}	; r/m32 -> reg32
testcase	{0x4C, 0x0F, 0x48, 0x0A},		{cmovs r9, [rdx]}	; r/m64 -> reg64

; implicit evex through ND
testcase	{0x62, 0xF4, 0x35, 0x10, 0x48, 0x0A},	{cmovs r25w, cx, [rdx]}		; ndd16 = cond ? r/m16 : reg16
testcase	{0x62, 0xF4, 0x34, 0x10, 0x48, 0x0A},	{cmovs r25d, ecx, [rdx]}	; ndd32 = cond ? r/m32 : reg32
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x48, 0x0A},	{cmovs r25, rcx, [rdx]}		; ndd64 = cond ? r/m64 : reg64

; rex2 variant
testcase	{0x66, 0xD5, 0xC4, 0x48, 0x0A},		{cmovs r25w, [rdx]}	; r/m16 -> ereg16
testcase	{0xD5, 0xC4, 0x48, 0x0A},		{cmovs r25d, [rdx]}	; r/m32 -> ereg32
testcase	{0xD5, 0xCC, 0x48, 0x0A},		{cmovs r25, [rdx]}	; r/m64 -> ereg64

; - cmovz/cmove - cmov if zero -
testcase	{0x66, 0x0F, 0x44, 0x0A},		{cmovz cx, [rdx]}	; r/m16 -> reg16
testcase	{0x0F, 0x44, 0x0A},			{cmovz ecx, [rdx]}	; r/m32 -> reg32
testcase	{0x4C, 0x0F, 0x44, 0x0A},		{cmovz r9, [rdx]}	; r/m64 -> reg64
testcase	{0x66, 0x0F, 0x44, 0x0A},		{cmove cx, [rdx]}	; r/m16 -> reg16
testcase	{0x0F, 0x44, 0x0A},			{cmove ecx, [rdx]}	; r/m32 -> reg32
testcase	{0x4C, 0x0F, 0x44, 0x0A},		{cmove r9, [rdx]}	; r/m64 -> reg64

; implicit evex through ND
testcase	{0x62, 0xF4, 0x35, 0x10, 0x44, 0x0A},	{cmovz r25w, cx, [rdx]}		; ndd16 = cond ? r/m16 : reg16
testcase	{0x62, 0xF4, 0x34, 0x10, 0x44, 0x0A},	{cmovz r25d, ecx, [rdx]}	; ndd32 = cond ? r/m32 : reg32
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x44, 0x0A},	{cmovz r25, rcx, [rdx]}		; ndd64 = cond ? r/m64 : reg64
testcase	{0x62, 0xF4, 0x35, 0x10, 0x44, 0x0A},	{cmove r25w, cx, [rdx]}	; ndd16 = cond ? r/m16 : reg16
testcase	{0x62, 0xF4, 0x34, 0x10, 0x44, 0x0A},	{cmove r25d, ecx, [rdx]}	; ndd32 = cond ? r/m32 : reg32
testcase	{0x62, 0xF4, 0xB4, 0x10, 0x44, 0x0A},	{cmove r25, rcx, [rdx]}	; ndd64 = cond ? r/m64 : reg64

; rex2 variant
testcase	{0x66, 0xD5, 0xC4, 0x44, 0x0A},		{cmovz r25w, [rdx]}	; r/m16 -> ereg16
testcase	{0xD5, 0xC4, 0x44, 0x0A},		{cmovz r25d, [rdx]}	; r/m32 -> ereg32
testcase	{0xD5, 0xCC, 0x44, 0x0A},		{cmovz r25, [rdx]}	; r/m64 -> ereg64
testcase	{0x66, 0xD5, 0xC4, 0x44, 0x0A},		{cmove r25w, [rdx]}	; r/m16 -> ereg16
testcase	{0xD5, 0xC4, 0x44, 0x0A},		{cmove r25d, [rdx]}	; r/m32 -> ereg32
testcase	{0xD5, 0xCC, 0x44, 0x0A},		{cmove r25, [rdx]}	; r/m64 -> ereg64

; --- cmpccxadd - conditional add instruction ---
; - cmpbexadd - add if below or equal -
testcase	{0xC4, 0x62, 0x71, 0xE6, 0x0A},		{cmpbexadd [rdx], r9d, ecx}	; r/m32 += r32
testcase	{0xC4, 0x62, 0xF1, 0xE6, 0x0A},		{cmpbexadd [rdx], r9, rcx}	; r/m64 += r64
testcase	{0x62, 0x4A, 0x75, 0x08, 0xE6, 0x0A},	{cmpbexadd [r26], r25d, ecx}	; r/m32 += r32
testcase	{0x62, 0x4A, 0xF5, 0x08, 0xE6, 0x0A},	{cmpbexadd [r26], r25, rcx}	; r/m64 += r64

; - cmpbxadd - add if below -
testcase	{0xC4, 0x62, 0x71, 0xE2, 0x0A},		{cmpbxadd [rdx], r9d, ecx}	; r/m32 += r32
testcase	{0xC4, 0x62, 0xF1, 0xE2, 0x0A},		{cmpbxadd [rdx], r9, rcx}	; r/m64 += r64
testcase	{0x62, 0x4A, 0x75, 0x08, 0xE2, 0x0A},	{cmpbxadd [r26], r25d, ecx}	; r/m32 += r32
testcase	{0x62, 0x4A, 0xF5, 0x08, 0xE2, 0x0A},	{cmpbxadd [r26], r25, rcx}	; r/m64 += r64

; - cmplexadd - add if less or equal -
testcase	{0xC4, 0x62, 0x71, 0xEE, 0x0A},		{cmplexadd [rdx], r9d, ecx}	; r/m32 += r32
testcase	{0xC4, 0x62, 0xF1, 0xEE, 0x0A},		{cmplexadd [rdx], r9, rcx}	; r/m64 += r64
testcase	{0x62, 0x4A, 0x75, 0x08, 0xEE, 0x0A},	{cmplexadd [r26], r25d, ecx}	; r/m32 += r32
testcase	{0x62, 0x4A, 0xF5, 0x08, 0xEE, 0x0A},	{cmplexadd [r26], r25, rcx}	; r/m64 += r64

; - cmplxadd - add if less or equal -
testcase	{0xC4, 0x62, 0x71, 0xEC, 0x0A},		{cmplxadd [rdx], r9d, ecx}	; r/m32 += r32
testcase	{0xC4, 0x62, 0xF1, 0xEC, 0x0A},		{cmplxadd [rdx], r9, rcx}	; r/m64 += r64
testcase	{0x62, 0x4A, 0x75, 0x08, 0xEC, 0x0A},	{cmplxadd [r26], r25d, ecx}	; r/m32 += r32
testcase	{0x62, 0x4A, 0xF5, 0x08, 0xEC, 0x0A},	{cmplxadd [r26], r25, rcx}	; r/m64 += r64

; - cmpnbexadd - add if not below or equal -
testcase	{0xC4, 0x62, 0x71, 0xE7, 0x0A},		{cmpnbexadd [rdx], r9d, ecx}	; r/m32 += r32
testcase	{0xC4, 0x62, 0xF1, 0xE7, 0x0A},		{cmpnbexadd [rdx], r9, rcx}	; r/m64 += r64
testcase	{0x62, 0x4A, 0x75, 0x08, 0xE7, 0x0A},	{cmpnbexadd [r26], r25d, ecx}	; r/m32 += r32
testcase	{0x62, 0x4A, 0xF5, 0x08, 0xE7, 0x0A},	{cmpnbexadd [r26], r25, rcx}	; r/m64 += r64

; - cmpnbxadd - add if not below -
testcase	{0xC4, 0x62, 0x71, 0xE3, 0x0A},		{cmpnbxadd [rdx], r9d, ecx}	; r/m32 += r32
testcase	{0xC4, 0x62, 0xF1, 0xE3, 0x0A},		{cmpnbxadd [rdx], r9, rcx}	; r/m64 += r64
testcase	{0x62, 0x4A, 0x75, 0x08, 0xE3, 0x0A},	{cmpnbxadd [r26], r25d, ecx}	; r/m32 += r32
testcase	{0x62, 0x4A, 0xF5, 0x08, 0xE3, 0x0A},	{cmpnbxadd [r26], r25, rcx}	; r/m64 += r64

; - cmpnlexadd - add if not less or equal -
testcase	{0xC4, 0x62, 0x71, 0xEF, 0x0A},		{cmpnlexadd [rdx], r9d, ecx}	; r/m32 += r32
testcase	{0xC4, 0x62, 0xF1, 0xEF, 0x0A},		{cmpnlexadd [rdx], r9, rcx}	; r/m64 += r64
testcase	{0x62, 0x4A, 0x75, 0x08, 0xEF, 0x0A},	{cmpnlexadd [r26], r25d, ecx}	; r/m32 += r32
testcase	{0x62, 0x4A, 0xF5, 0x08, 0xEF, 0x0A},	{cmpnlexadd [r26], r25, rcx}	; r/m64 += r64

; - cmpnlxadd - add if not less -
testcase	{0xC4, 0x62, 0x71, 0xED, 0x0A},		{cmpnlxadd [rdx], r9d, ecx}	; r/m32 += r32
testcase	{0xC4, 0x62, 0xF1, 0xED, 0x0A},		{cmpnlxadd [rdx], r9, rcx}	; r/m64 += r64
testcase	{0x62, 0x4A, 0x75, 0x08, 0xED, 0x0A},	{cmpnlxadd [r26], r25d, ecx}	; r/m32 += r32
testcase	{0x62, 0x4A, 0xF5, 0x08, 0xED, 0x0A},	{cmpnlxadd [r26], r25, rcx}	; r/m64 += r64

; - cmpnoxadd - add if not overflow -
testcase	{0xC4, 0x62, 0x71, 0xE1, 0x0A},		{cmpnoxadd [rdx], r9d, ecx}	; r/m32 += r32
testcase	{0xC4, 0x62, 0xF1, 0xE1, 0x0A},		{cmpnoxadd [rdx], r9, rcx}	; r/m64 += r64
testcase	{0x62, 0x4A, 0x75, 0x08, 0xE1, 0x0A},	{cmpnoxadd [r26], r25d, ecx}	; r/m32 += r32
testcase	{0x62, 0x4A, 0xF5, 0x08, 0xE1, 0x0A},	{cmpnoxadd [r26], r25, rcx}	; r/m64 += r64

; - cmpnpxadd - add if not parity -
testcase	{0xC4, 0x62, 0x71, 0xEB, 0x0A},		{cmpnpxadd [rdx], r9d, ecx}	; r/m32 += r32
testcase	{0xC4, 0x62, 0xF1, 0xEB, 0x0A},		{cmpnpxadd [rdx], r9, rcx}	; r/m64 += r64
testcase	{0x62, 0x4A, 0x75, 0x08, 0xEB, 0x0A},	{cmpnpxadd [r26], r25d, ecx}	; r/m32 += r32
testcase	{0x62, 0x4A, 0xF5, 0x08, 0xEB, 0x0A},	{cmpnpxadd [r26], r25, rcx}	; r/m64 += r64

; - cmpnsxadd - add if not sign -
testcase	{0xC4, 0x62, 0x71, 0xE9, 0x0A},		{cmpnsxadd [rdx], r9d, ecx}	; r/m32 += r32
testcase	{0xC4, 0x62, 0xF1, 0xE9, 0x0A},		{cmpnsxadd [rdx], r9, rcx}	; r/m64 += r64
testcase	{0x62, 0x4A, 0x75, 0x08, 0xE9, 0x0A},	{cmpnsxadd [r26], r25d, ecx}	; r/m32 += r32
testcase	{0x62, 0x4A, 0xF5, 0x08, 0xE9, 0x0A},	{cmpnsxadd [r26], r25, rcx}	; r/m64 += r64

; - cmpnzxadd - add if not zero -
testcase	{0xC4, 0x62, 0x71, 0xE5, 0x0A},		{cmpnzxadd [rdx], r9d, ecx}	; r/m32 += r32
testcase	{0xC4, 0x62, 0xF1, 0xE5, 0x0A},		{cmpnzxadd [rdx], r9, rcx}	; r/m64 += r64
testcase	{0x62, 0x4A, 0x75, 0x08, 0xE5, 0x0A},	{cmpnzxadd [r26], r25d, ecx}	; r/m32 += r32
testcase	{0x62, 0x4A, 0xF5, 0x08, 0xE5, 0x0A},	{cmpnzxadd [r26], r25, rcx}	; r/m64 += r64

; - cmpoxadd - add if overflow -
testcase	{0xC4, 0x62, 0x71, 0xE0, 0x0A},		{cmpoxadd [rdx], r9d, ecx}	; r/m32 += r32
testcase	{0xC4, 0x62, 0xF1, 0xE0, 0x0A},		{cmpoxadd [rdx], r9, rcx}	; r/m64 += r64
testcase	{0x62, 0x4A, 0x75, 0x08, 0xE0, 0x0A},	{cmpoxadd [r26], r25d, ecx}	; r/m32 += r32
testcase	{0x62, 0x4A, 0xF5, 0x08, 0xE0, 0x0A},	{cmpoxadd [r26], r25, rcx}	; r/m64 += r64

; - cmppxadd - add if parity -
testcase	{0xC4, 0x62, 0x71, 0xEA, 0x0A},		{cmppxadd [rdx], r9d, ecx}	; r/m32 += r32
testcase	{0xC4, 0x62, 0xF1, 0xEA, 0x0A},		{cmppxadd [rdx], r9, rcx}	; r/m64 += r64
testcase	{0x62, 0x4A, 0x75, 0x08, 0xEA, 0x0A},	{cmppxadd [r26], r25d, ecx}	; r/m32 += r32
testcase	{0x62, 0x4A, 0xF5, 0x08, 0xEA, 0x0A},	{cmppxadd [r26], r25, rcx}	; r/m64 += r64

; - cmpsxadd - add if sign -
testcase	{0xC4, 0x62, 0x71, 0xE8, 0x0A},		{cmpsxadd [rdx], r9d, ecx}	; r/m32 += r32
testcase	{0xC4, 0x62, 0xF1, 0xE8, 0x0A},		{cmpsxadd [rdx], r9, rcx}	; r/m64 += r64
testcase	{0x62, 0x4A, 0x75, 0x08, 0xE8, 0x0A},	{cmpsxadd [r26], r25d, ecx}	; r/m32 += r32
testcase	{0x62, 0x4A, 0xF5, 0x08, 0xE8, 0x0A},	{cmpsxadd [r26], r25, rcx}	; r/m64 += r64

; - cmpzxadd - add if zero -
testcase	{0xC4, 0x62, 0x71, 0xE4, 0x0A},		{cmpzxadd [rdx], r9d, ecx}	; r/m32 += r32
testcase	{0xC4, 0x62, 0xF1, 0xE4, 0x0A},		{cmpzxadd [rdx], r9, rcx}	; r/m64 += r64
testcase	{0x62, 0x4A, 0x75, 0x08, 0xE4, 0x0A},	{cmpzxadd [r26], r25d, ecx}	; r/m32 += r32
testcase	{0x62, 0x4A, 0xF5, 0x08, 0xE4, 0x0A},	{cmpzxadd [r26], r25, rcx}	; r/m64 += r64

