#
# nono
# Copyright (C) 2020 nono project
# Licensed under nono-license.txt
#

# 共通の定義。
# サブディレクトリの Makefile は先頭で .include すること。
#
# TOPDIR はこの Makefile.inc が置いてあるディレクトリ。
# make を実行するサブディレクトリがここの1つ下でない場合は、そこからこの
# ディレクトリまでの相対パスを事前に定義しておくこと。
#
# ここでは以下の変数を定義する。これらはコマンドライン上に完全順不同で登場
# すると読みにくいのでなんとなくグループ分けしたいというくらいの意味合い。
#
# CCFLAGS
#	C/C++ 共通のコンパイラオプション。
# WARNFLAGS
#	C/C++ 共通のワーニングオプション。
# WARNFLAGS_C
# WARNFLAGS_CXX
#	C/C++ 専用のワーニングオプション。
# CPPFLAGS
#	C/C++ 共通のプリプロセッサオプション。
#
# これらの変数には必要なら各 Makefile で値を追加してよい。
#
# COPT は C/C++ 共通の追加の一時的なオプションで、make のコマンドラインで
# 指定されることを想定している (./Makefile.rule 参照)。

# ここからコード

# システム定義(/usr/share/mk/*.mk) の CFLAGS、CXXFLAGS は使わない。
# 定義が OS によってまちまちなのと、特に NetBSD の CXXFLAGS は特定のオプション
# を勝手に削るとか実にきしょい動きをするのでハマる。CPPFLAGS も念のため。
CFLAGS=		# reset system definition
CXXFLAGS=	# reset system definition
CPPFLAGS=	# reset system definition

TOPDIR?=	..

.include "Makefile.cfg"

PROFOPT=	-g
#PROFOPT=	-g -pg

## ASan for GCC
#PROFOPT+=	-fsanitize=address -fno-omit-frame-pointer -static-libstdc++
## ASan for clang
#PROFOPT+=	-fsanitize=address -fno-omit-frame-pointer -O1
## MSan for clang
#PROFOPT+=	-fsanitize=memory -fno-omit-frame-pointer -fno-optimize-sibling-calls -fsanitize-memory-track-origins=2 -O1
## TSan
#PROFOPT+=	-fsanitize=thread
## UBSan
#PROFOPT+=	-fsanitize=undefined

CCFLAGS+=		-O2
CCFLAGS+=		${PROFOPT}

# C++17 では不要になるはず?
CXXFLAGS+=		-faligned-new

WARNFLAGS+=		-Wall -Werror
WARNFLAGS+=		-Wignored-qualifiers
WARNFLAGS+=		-Wno-sign-compare
WARNFLAGS+=		-Wno-unused-result
WARNFLAGS+=		-Wpointer-arith

WARNFLAGS_CXX+=	-Wnon-virtual-dtor

WARNFLAGS_C+=	${WARNFLAGS_C_cfg}
WARNFLAGS_CXX+=	${WARNFLAGS_CXX_cfg}

# wxWidgets-3.0 用のハック。
# (wxWidgets-3.2 以降では wxWidgets 側がやってるので不要になる)
.if "${WX_MAJORMINOR}" == "30"
.if ${WARNFLAGS_CXX:M-Winconsistent-missing-override}
CPPFLAGS_WXWIDGETS+=	-Wno-inconsistent-missing-override
.endif
.if ${WARNFLAGS_CXX:M-Wsuggest-override}
CPPFLAGS_WXWIDGETS+=	-Wno-suggest-override
.endif
.endif

CPPFLAGS+=	-I.
CPPFLAGS+=	-I${TOPDIR}
CPPFLAGS+=	-I${TOPDIR}/debugger
CPPFLAGS+=	-I${TOPDIR}/fpe
CPPFLAGS+=	-I${TOPDIR}/hd64180
CPPFLAGS+=	-I${TOPDIR}/host
CPPFLAGS+=	-I${TOPDIR}/lib
CPPFLAGS+=	-I${TOPDIR}/m680x0
CPPFLAGS+=	-I${TOPDIR}/m88xx0
CPPFLAGS+=	-I${TOPDIR}/vm
CPPFLAGS+=	-I${TOPDIR}/wx

# CFLAGS   は C   コンパイラに指定するコンパイルオプション。
# CXXFLAGS は C++ コンパイラに指定するコンパイルオプション。
# CPPFLAGS は C/C++ 共通でコンパイラに指定するプリプロセッサオプション。

CFLAGS+=	${CCFLAGS}
CXXFLAGS+=	${CCFLAGS}
.if !defined(RELEASE)
CFLAGS+=	${WARNFLAGS} ${WARNFLAGS_C}
CXXFLAGS+=	${WARNFLAGS} ${WARNFLAGS_CXX}
.endif

LDFLAGS+=	${PROFOPT}

# リンカに指定する引数
MYLIBS=	\
	../vm/libnnvm.a	\
	../debugger/libnndebugger.a \
	../m680x0/libnnm680x0.a	\
	../m88xx0/libnnm88xx0.a \
	../hd64180/libnnhd64180.a	\
	../fpe/libnnfpe.a	\
	../host/libnnhost.a \
	../lib/libnnlib.a	\

.if "${.MAKE.OS}" == "Darwin"
# Apple Clang は --start-group, --end-group に対応してない。うーん。
MYLIBS_GROUP=	${MYLIBS} ${MYLIBS}
.else
MYLIBS_GROUP=	-Wl,--start-group ${MYLIBS} -Wl,--end-group
.endif
