//
// nono
// Copyright (C) 2022 nono project
// Licensed under nono-license.txt
//

//
// ベクタテーブル (モニタ)
//

#pragma once

#include "device.h"
#include <array>
#include <map>
#include <vector>

class MainbusDevice;
class MainMPUDevice;
enum class VMType;

class VectorTable : public Device
{
	using inherited = Device;

 public:
	explicit VectorTable(VMType vmtype);
	~VectorTable() override;

	bool Init() override;

	// 例外名を返す (ベクタテーブル用)
	const char *GetTableName(int vector) const;

	// 例外名を返す (例外履歴用)
	const char *GetExceptionName(int vector) const;

	// ベクタテーブルの要素数を返す
	int Size() const { return nametable.size(); }

	// モニタ更新
	DECLARE_MONITOR_CALLBACK(MonitorUpdate);

 private:
	// 初期化
	void InitTableM680x0(VMType vmtype);
	void InitTableLuna88k();

	// ベクタテーブル
	std::vector<const char *> nametable {};

	MainbusDevice *mainbus {};
	MainMPUDevice *mpu {};

	// モニタ
	Monitor *monitor {};

	// 初期値
	static std::array<const char * const, 64>  name_m680x0;
	static std::map<int, const char * const>   name_x68030;
	static std::map<int, const char * const>   name_luna1;
	static std::map<int, const char * const>   name_news;
	static std::map<int, const char * const>   name_virt68k;
	static std::array<const char * const, 11>  name_luna88k;
};

static inline VectorTable *GetVectorTable() {
	return Object::GetObject<VectorTable>(OBJ_VECTOR_TABLE);
}
