<!--
 nono
 Copyright (C) 2020 nono project
 Licensed under nono-license.txt
-->
<?php require_once "common.php"; ?>
<html>
<head>
<?php
	get_version();
	print_head_common();
?>
<title>nono document (<?php print $nono_ver; ?>)</title>
</head>
<?php
function H4($name, $title)
{
	global $h4number;
	global $h5number;
	$h4number++;
	$h5number = 0;
	print <<<_EOM_
<a name="{$name}"></a>
<details open style="padding-top: 1em">
<summary><span class=h4>{$h4number}. {$title}</span></summary>
_EOM_;
}
function H4end()
{
	print "</details>\n";
}

function H5($name, $title)
{
	global $h4number;
	global $h5number;
	$h5number++;
	print <<<_EOM_
<a name="{$name}"></a>
<details open style="padding-top: 1em">
<summary><span class=h5>{$h4number}.{$h5number}. {$title}</span></summary>
_EOM_;
}
function H5end()
{
	print "</details>\n";
}
?>
<body>
<h3>nono <?=$nono_ver?> (<?=$nono_date?>)</h3>

nono は NetBSD とかで動作する OMRON LUNA-I/LUNA-88K のエミュレータです。
何故か SHARP X68030 と virt-m68k も動いたりするかも知れません。
<q>nono is OMRON LUNA-I/LUNA-88K emulator runs on NetBSD and etc.
It can also emulate SHARP X68030 and virt-m68k.</q>

<hr>

<h4>Index of this page:</h4>
<div class="main">
<a href="#build">1. ビルド方法 <q>How to build</q></a><br>
<a href="#execute">2. 実行方法 <q>How to execute</q></a><br>
<a href="#configuration">3. 設定 <q>Configuration</q></a><br>
<a href="#aboutvm">4. VM について <q>About VM</q></a><br>
<a href="#tryit">5. 実行してみる <q>Try it</q></a><br>
<a href="#network">6. ホストネットワーク設定例 <q>Example of host network setup</q></a><br>
<a href="#knownissues">7. 既知の問題 <q>Known Issues</q></a><br>
<a href="#migrate">8. 過去のバージョンからの移行方法
<q>How to migrate from old versions</q></a><br>
<a href="#changes">9. 変更履歴 <q>Changes</q></a><br>
<a href="#license">10. 連絡先、ライセンス等 <q>Contact, License, etc</q></a><br>
</div>
<p>
<div class="main">
<span class="new">緑背景</span>は新規または目立った更新のあった箇所です。
<q><span class="new">Green Background</span> is new or updated paragraph.</q>
</div>


<?php H4("build", "ビルド方法 <q>How to build</q>"); ?>
<div class="main">
ビルドには以下が必要です。
<q>The followings are required for build.</q>

<ul>
<li>make (BSD make, not GNU make)
<li>C/C++ compiler which supports -std=c++14.
<br>
(For gcc, at least 7.4 or later.
For clang, at least 7.0 or later.)
<li>wxWidgets 3.2.x "stable" branch.
 (3.0.x "old stable" branch would also work.)
<li>gettext
<li>libslirp (4.7.0 or later is comfirmed, 4.8.0 or later is preferred.)
</ul>

<p>
NetBSD(pkgsrc) なら必要なパッケージは
x11/wxGTK32 と net/libslirp です。
wxGTK32 の代わりに wxGTK30 でも動くはずです。
<q>If you use NetBSD(pkgsrc),
x11/wxGTK32 and net/libslirp are needed.
wxGTK30 would also work.</q>

<p>
(NetBSD 以外でのビルドはサポートしていませんが)
Ubuntu 24.04 ではたぶん以下のパッケージが必要です。
<q>You may need the following packages on Ubuntu 24.04
(though we won't support non-NetBSD platform).</q>
</p>
<dl>
<dd>
bmake,
build-essential,
gettext,
libbsd-dev,
libkqueue-dev,
libslirp-dev,
libwxgtk3.2-dev,
zlib1g-dev
</dl>

<p>
nono のソースアーカイブを展開したら以下のようにビルドします。
<q>Extract the nono's source archive and build as following.</q>
</p>

<blockquote class="cons"><pre>
% ./configure [&lt;options&gt;]
% make -DRELEASE depend
% make -DRELEASE
% su
# make install
</pre></blockquote>

<p>
configure には環境変数 CC、CXX でコンパイラを指定することが出来ます。
wx-config が標準的な名前で提供されていないために見付けられない場合には
環境変数 WX_CONFIG にパスを指定することが出来ます。
また configure のオプションとして以下が指定できます。
<q>You can specify C/C++ compiler using environment variable CC and CXX
if configure cannot find standard name suitable compiler.
You can specify wx-config path using environment variable WX_CONFIG
if configure cannot find wx-config.
Also, you can specify the following option for <tt>configure</tt>.
</q>
<p>
<ul>
<li><tt>--disable-avx2</tt> …
amd64(x86_64) で AVX2 対応コードを無効にします。
デフォルトでは、コンパイラが AVX2 に対応していることを
configure が検出できれば AVX2 対応コードを生成します。
<q>Disable AVX2 support on amd64(x86_64).
By the default, it will generate AVX2 supported binary
only if configure detects that compiler supports AVX2.</q>
<li><tt>--disable-neon</tt> …
aarch64 で NEON 対応コードを無効にします。
デフォルトでは、コンパイラが NEON に対応していることを
configure が検出できれば NEON 対応コードを生成します。
<q>Disable NEON support on aarch64.
By the default, it will generate NEON supported binary
only if configure detects that compiler supports NEON.</q>
</ul>
<p>
<tt>make install</tt> により2つの実行ファイルがインストールされます。
<tt>nono</tt> が GUI 版実行ファイル、
<tt>nono-cli</tt> がコマンドライン版です。
<q><tt>make install</tt> will install two executables.
<tt>nono</tt> is the GUI executable and <tt>nono-cli</tt> is
the command line executable.</q>
</p>
</div>
<?php H4end(); ?>


<?php H4("execute", "実行方法 <q>How to execute</q>"); ?>
<div class="main">
nono は複数機種に対応しているため設定なしでは起動できません。
設定は設定ファイルかコマンドラインオプションで指定します。
詳細は以下の<a name="#configuration">設定</a>の章を参照してください。
<q>nono supports multiple architectures so that
it needs configuration.
See the following <a name="#configuration">Configuration</a> section for
details.</q>
</div>

<?php H5("commandline", "コマンドラインオプション <q>Command Line Option</q>");
?>
<div class="main">
<dl>
<?php
function item($name, $desc)
{
	if (!is_array($name)) {
		$name = array($name);
	}
	foreach ($name as $n) {
		print "<dt class=dt-indent><tt>{$n}</tt></dt>\n";
	}
	print "<dd>{$desc}</p></dd>\n";
}
function option_item($name, $desc)
{
	item($name, $desc);
}

option_item("-c <i>vmpath</i>", <<<_EOM_
VM ディレクトリ/設定ファイルを指定します。
<i>vmpath</i> がディレクトリならそのディレクトリの中の nono.cfg
を設定ファイルとします。
<i>vmpath</i> がファイルならそれを設定ファイルとします。
そしていずれの場合も
設定ファイルがあるディレクトリを VM ディレクトリとします。
-c オプションを省略すると <i>vmpath</i> をカレントディレクトリとします。
<q>Specifies the VM directory/configuration file.
If <i>vmpath</i> is a directory,
make nono.cfg in that directory a configuration file.
Or if <i>vmpath</i> is a file,
make the specified file a configuration file.
And in both cases,
make the directory where that file is located a VM directory.
If <tt>-c</tt> option is omitted,
<i>vmpath</i> is considered as the current directory.</q>
_EOM_
);

option_item("--create-sram", <<<_EOM_
(X68030 Only)
VM ディレクトリに X68030 用の SRAM.DAT がなければ初期状態で作成して終了します。
<q>
nono will create the initial SRAM.DAT for X68030 and exit,
if there is no SRAM.DAT in the VM directory.</q>
_EOM_
);

option_item("-f", <<<_EOM_
高速モードで起動します。
GUI なら起動後にもメニューから変更できますが、その初期値を変えるだけです。
設定の <tt>fast-mode=1</tt> と等価です。
<q>Boot as the fast mode.
You can change this mode on GUI menu after boot,
and the option only changes its initial state.
This option is equivalent to <tt>fast-mode=1</tt> in configuration.</q>
_EOM_
);

option_item("<span class='new'>--fd0 <i>file</i><br>--fd1 <i>file</i></span>", <<<_EOM_
<span class="new">
(X68030 Only) フロッピーイメージを指定します。
<i>file</i> が相対パスの場合カレントディレクトリからのパスになります。
設定の <tt>fd0-image</tt>、<tt>fd1-image</tt>
とは相対パスの起点の違いを除いて同一です。
<q>Specifies the floppy image.
If <tt><i>file</i></tt> is relative path,
it is path from the current directory.
This option is equivalent to <tt>fd0-image</tt>, <tt>fd1-image</tt>
in configuration except for base directory of the relative path.</q>
</span>
_EOM_
);

option_item("--fontsize <i>height</i>", <<<_EOM_
GUI 版のみ。
全サブウインドウの起動時のフォントサイズを指定します。
起動後にメニューから変更できます。
設定の <tt>monitor-fontsize</tt> と等価です。
<q>GUI Only.
Specifies the initial fontsize of all sub windows.
You can change this value on GUI menu after boot.
This option is equivalent to <tt>monitor-fontsize</tt> in configuration.</q>
_EOM_
);

option_item("--initrd <i>file</i>", <<<_EOM_
(virt-m68k Only)
カーネルに渡す初期 RAM ディスクのパスを指定します。
<i>file</i> が相対パスの場合カレントディレクトリからのパスになります。
設定の <tt>exec-initrd</tt> とは相対パスの起点の違いを除いて同一です。
<q>Specifies the initial ramdisk image passed to the kernel.
If <tt><i>file</i></tt> is relative path,
it is path from the current directory.
This option is equivalent to <tt>exec-initrd</tt> in configuration
except for base directory of the relative path.</q>
_EOM_
);

option_item("-s <i>scale</i>", <<<_EOM_
GUI 版のみ。
メインウィンドウの起動時のスケールを実数で指定します。
設定の <tt>mainview-scale</tt> と等価です。
起動後はメニューからプリセットされた倍率と
<tt>mainview-scale</tt> で指定された倍率には変更可能です。
<q>GUI Only.
Specifies the initial main window scale in real number.
This is equivalent to <tt>mainview-scale</tt> in configuration.
You can change this scale on GUI menu after boot.</q>
_EOM_
);

option_item("--show-config", <<<_EOM_
設定ファイルと <tt>-V</tt> オプションを読み込んだ結果を表示します。
<q>Shows the result of reading configuration file and
parsing <tt>-V</tt> options.</q>
_EOM_
);

option_item("-v", <<<_EOM_
バージョンを表示します。
<q>Shows the version.</q>
_EOM_
);

option_item("-V <i>name</i>=<i>value</i>", <<<_EOM_
設定ファイルで指定した <tt><i>name</i>=<i>configvalue</i></tt> の代わりに
このオプションの <tt><i>name</i>=<i>value</i></tt> を適用します。
<tt><i>name</i></tt> が正しくない場合はエラー終了します。
<q>Use this <i>name</i>=<i>value</i>
instead of <i>name</i>=<i>configvalue</i> specified in configuration file.
If <tt><i>name</i></tt> is not correct, it will exit on error.</q>
_EOM_
);

option_item("-X <i>file</i>", <<<_EOM_
ホストの <tt><i>file</i></tt> をロードして実行します。
<tt><i>file</i></tt> が相対パスの場合カレントディレクトリからのパスになります。
設定の <tt>exec-file</tt> とは相対パスの起点の違いを除いて同一です。
ファイルが gzip 圧縮されていれば自動的に展開します。
(展開後の) ファイル形式は以下の通りですが、
実際にはブートローダとカーネル程度しか想定していません。
また、いずれも起動元デバイスが取得できないなどの問題はあるかも知れません。
<q>Loads and executes host's <tt><i>file</i></tt>.
If <tt><i>file</i></tt> is relative path,
it is path from the current directory.
This option is equivalent to <tt>exec-file</tt> in configuration
except for base directory of the relative path.
If the file is gzip'd, it is automatically extracted.
The supported file format (after extracting) is the following.
Actually, it only assumes bootloaders or kernels.
And note that it may not obtain some information that where did I boot from,
for example.</q>
<ul>
<li>a.out (OMAGIC) 実行ファイル (おそらくブートローダのみサポート)
<q>a.out (OMAGIC) executable (It probably supports bootloaders only)</q>
<li>ELF 実行ファイル
(おそらくカーネルのみサポート。
NetBSD の実行ファイルのようであれば、
カーネルだと思ってシンボルテーブルも読み込みます)
<q>ELF executable
(It probably supports the kernel only.
If the file is assumed to be NetBSD executable,
it will also load symbol tables as the bootloader does to the kernel.)</q>
<li>ELF object (Experimental)
</ul>
LUNA では設定の <tt>prom-image</tt> (後述) によらず内蔵の互換 ROM で起動します。
<tt>luna-dipsw1</tt> の DIPSW 設定が
<tt>dipsw-autoboot=yes</tt> 相当の状態ならそのまま直ちにホストファイルを実行し、
そうでなければ互換 ROM のプロンプトで停止します。
後者の場合でも LUNA-I なら "g" コマンド、LUNA-88K なら "b" コマンドによる
ロードはここで指定したホストファイルをロードします。
X68030 では、IPLROM 起動の後の起動デバイスに細工がしてあり、
そこからホストファイルを実行します。
virt-m68k (と NEWS) はこの方法でしか起動できませんので、
実行ファイルの指定は必須になります。
<q>On LUNA,
regardless of <tt>prom-image</tt> configuration (see below),
it boots the internal emulated PROM.
If <tt>luna-dipsw1</tt> configuration meets <tt>dipsw-autoboot=yes</tt>,
it will immediately load and execute the host file.
Otherwise, it will wait in prompt.
Even in this case, "g" command (in LUNA-I) or "b" command (in LUNA-88K)
will load the host file that is specified by this option.
On X68030,
nono hacks the boot device after normal boot from IPLROM,
and loads and executes the host file.
On virt-m68k (and NEWS), this is the only way to boot.</q>
_EOM_
);
?>
</dl>

以下開発用。<q>For developers:</q>
<dl>
<?php
// 項目間を空けない
function option_dev($name, $desc)
{
	print "<dt class=dt-indent><tt>{$name}</tt></dt>\n";
	print "<dd>{$desc}</dd>\n";
}

option_dev("-b <i>hexaddr</i>[,<i>skipcount</i>]", <<<_EOM_
デバッガのブレークポイントを 16進数で指定します。
_EOM_
);

option_dev("-C", <<<_EOM_
ログをコンソールにも出力します。
通常はログウィンドウにだけ出力されます。
_EOM_
);

option_dev("-d", <<<_EOM_
起動時にデバッガプロンプトで停止します。
_EOM_
);

option_dev("-D", <<<_EOM_
コンソールをデバッガとして使用します。
過去との互換性のために存在していますが、
<tt>-V debugger-driver=stdio</tt> と等価です。
_EOM_
);

$hlink = linkto_str("human", "human.html");
option_dev("-H", "Human68k モードです。→ {$hlink}");

option_dev("-L <i>name1</i>=<i>level1</i>[,<i>name2</i>=<i>level2</i>,...]",
<<<_EOM_
ログレベルを指定します。
カンマで区切って複数指定することも出来ます。
<tt>-Lhelp</tt> で name の一覧を表示します。
_EOM_
);

option_dev("-M <i>name</i>[,<i>name2</i>,...]", <<<_EOM_
起動時に表示するモニタウィンドウを指定します。
カンマで区切って複数指定することも出来ます。
<tt>-Mhelp</tt> で name の一覧を表示します。
_EOM_
);


?>
</dl>
</div>
<?php H5end(); ?>
<?php H4end(); ?>


<?php H4("configuration", "設定 <q>Configuration</q>"); ?>
<div class="main">
nono の設定はいずれも以下の順序で適用されます。
<q>nono's configurations are always applied in the following order.</q>
<ol>
<li>デフォルト値 <q>Default value</q>
<li>~/.nono.cfg があればその内容
<q>Contents of ~/.nono.cfg if exists</q>
<li>VM ディレクトリ内の nono.cfg (または -c で指定したファイル)
があればその内容
<q>Contents of nono.cfg in the VM directory (or the file specified by -c option) if exists</q>
<li>コマンドラインオプション <q>Command line option</q>
</ol>
ファイルの書式はどちらも <tt>key = value</tt> 形式で1行1項目ずつです。
<tt>key</tt> と <tt>value</tt> の前後の空白は取り除かれます。
また空行と "<tt>#</tt>" で始まる行は無視します。
知らないキーは警告を出した上で無視します。
同じキーが複数回現れた場合、
上に列挙した順に後から書いたほうで上書きし、
同じファイル内でも同様に後に書いたほうで上書きします。
コマンドラインオプション <tt>-V</tt> 等はこれをさらに上書きします。
コマンドラインオプションで同じキーが複数回現れた場合も後に書いたほうが上書きします。
<q>
The syntax of both files is <tt>key = value</tt> format, one per line.
White spaces before and after <tt>key</tt> and <tt>value</tt> are ignored.
Blank lines, lines beginning with "<tt>#</tt>" are also ignored.
The lines with unrecognized key are ignored with a warning.

If the same key appears more than once,
the latter overwrites the former in the above order.
If the same key appears in a file,
the latter overwrites the former in the same manner.
Then, command line option <tt>-V</tt> etc. overwrites them.
If the same key appears more than once in the command line option,
do in the same manner.</q>
<p>
<tt>vmtype</tt> を除くすべての設定項目はそれぞれデフォルト値を持っています。
つまり少なくとも <tt>vmtype</tt> だけは設定ファイルかコマンドラインオプションで指定する必要があります。
<q>All configuration items except <tt>vmtype</tt> have default value.
It means, you need to specify at least only <tt>vmtype</tt>
by configuration file or commandline option.</q>
<p>
設定項目は次の通りです。
<q>The configuration items are:</q>
<dl>
<?php
function config_item($name, $desc)
{
	item($name, $desc);
}

config_item("vmtype = <i>string</i>", <<<_EOM_
VM 種別を以下のいずれかから指定します。
省略不可です。
<q>Specifies the VM type from the following.
This field is mandatory.</q>
<table cellspacing=0 cellpadding=0>
<tr><td>&nbsp;<td><tt>luna</tt>	<td>&nbsp;… LUNA-I
<tr><td><td><tt>luna88k</tt>	<td>&nbsp;… LUNA-88K
<tr><td><td><tt>x68030</tt>		<td>&nbsp;… X68030
<tr><td><td><tt>news</tt>		<td>&nbsp;… NWS-1750 (Just a joke)
<tr><td><td><tt>virt-m68k</tt> (or <tt>virt68k</tt>) <td>&nbsp;… virt-m68k
</table>
_EOM_
);

config_item("cgrom-image = <i>path</i>", <<<_EOM_
(X68030 Only)
X68030 の外部 CGROM イメージファイルのパスを指定します。
CGROM は 768KB です。
<i>path</i> がファイル名のみなら VM ディレクトリとその親ディレクトリからこのファイル名を検索します。
<i>path</i> が相対パスなら VM ディレクトリからの相対パスになります (現在のディレクトリからではありません)。
空にすると nono 内蔵の互換 CGROM を使用します。
デフォルトは空です。
<q>Specifies the X68030's external CGROM image file path.
This CGROM is 768KB.
If the <i>path</i> does not have any path delimiters,
the VM directory and then its parent directory will be searched.
If the <i>path</i> is a relative path,
it will be path from the VM directory, not from the current directory.
If the <i>path</i> is empty, nono's builtin compatible CGROM will be used.
The default value is empty.</q>
_EOM_
);

config_item("clock-sync = <i>value</i>", <<<_EOM_
仮想マシン内の時刻の同期方法を指定します。
<tt>real</tt> なら実時間に同期、<tt>virtual</tt> なら仮想時間に同期します。
<q>Specifies how to synchronize the time in the virtual machine.
If <tt>real</tt>, synchronize with the real time;
if <tt>virtual</tt>, synchronize with the virtual time.</q>
<ul>
<li>LUNA-I では 60Hz のシステムクロック割り込みと RTC(MK48T02) が対象で、
デフォルトは <tt>real</tt> です。
<q>On LUNA-I, 60Hz system clock interrupt and RTC(MK48T02) are the target.
The default is <tt>real</tt>.</q>
<li>LUNA-88K では 100Hz のシステムクロック割り込みと RTC(MK48T02) が対象で、
デフォルトは <tt>real</tt> です。
<q>On LUNA-88K, 100Hz system clock interrupt and RTC(MK48T02) are the target.
The default is <tt>real</tt>.</q>
<li>NWS-1750 ではシステムクロック割り込みと RTC(MK48T02) が対象で、
デフォルトは <tt>real</tt> です。
<q>On NWS-1750, system clock interrupt and RTC(MK48T02) are the target.
The default is <tt>real</tt>.</q>
<li>virt-m68k では Goldfish Timer の割り込みと Goldfish RTC が対象で、
デフォルトは <tt>real</tt> です。
<q>On virt-m68k, Goldfish Timer interrupt and Goldfish RTC are the target.
The default is <tt>real</tt>.</q>
<li><span class="new">X68030 では MFP のタイマー割り込みと RTC(RP5C15) が対象で、
デフォルトは <tt>virtual</tt> です。
MFP の TxDR レジスタの読み出しは、
この指定に関わらず常に <tt>virtual</tt> 相当の動作しか出来ません。
<a href="#netbsd-x68k-timesync">NetBSD/x68k での時間同期</a> の項も参照してください。
<q>On X68030, MFP timer interrupts and RTC(RP5C15) are the target.
The default is <tt>virtual</tt>.
Note that reading from MFP TxDR register only works as <tt>virtual</tt>,
regardless of this setting.
See also <a href="#netbsd-x68k-timesync">Time Synchronization on NetBSD/x68k</a>.</q>
</span>
</ul>
_EOM_
);

config_item("debugger-driver = <i>string</i>", <<<_EOM_
デバッガのコンソールドライバを指定します。
<tt>stdio</tt>、<tt>tcp</tt>、<tt>none</tt> が選択可能です。
<tt>stdio</tt> は標準入出力を使用します。
<tt>tcp</tt> は TCP ポートで TELNET プロトコルで待ち受けます。
<tt>none</tt> ならホスト側とは一切通信を行いません。
デフォルトは <tt>none</tt> です。
<q>Specifies console driver of the debugger.
<tt>stdio</tt>, <tt>tcp</tt>, and <tt>none</tt> can be specified.
<tt>stdio</tt> uses the standard input/output.
<tt>tcp</tt> listens on TCP port using TELNET protocol.
<tt>none</tt> doesn't make any communication with the host.
The default is <tt>none</tt>.</q>
_EOM_
);

config_item("debugger-tcp-port = <i>integer</i>",
<<<_EOM_
デバッガのコンソールドライバが tcp の時の TCP 待ち受けポート番号を指定します。
<q>Specifies the TCP port number that debugger console driver listens.</q>
_EOM_
);

?><a name="config-dipsw-autoboot"></a><?php
config_item("dipsw-autoboot = <i>yesno</i>", <<<_EOM_
(LUNA and NEWS Only)
機種に依存せず DIPSW を自動起動に設定するかどうか指定します。
"<tt>yes</tt>" なら自動起動するように、
"<tt>no</tt>" なら自動起動しないように DIPSW 設定を上書きします。
"" (空) なら何もしません。デフォルトは "" です。
このオプションは <tt>luna-dipsw1</tt> や <tt>news-dipsw</tt>
の状態が設定ファイルやコマンドラインオプションによって確定した後に
該当のスイッチだけを変更します。
<q>Specifies whether to configure DIPSW to boot automatically,
regardless of the models.
"<tt>yes</tt>" overwrites DIPSW, to boot automatically.
"<tt>no</tt>" overwrites DIPSW, not to boot automatically.
"" (Empty) does nothing.
The default value is "".
This option only changes the appropriate switch(es)
after the <tt>luna-dipsw1</tt> or <tt>news-dipsw</tt> configuration
is determined by the configuration file or command line options.</q>
_EOM_
);

config_item("dipsw-serial = <i>yesno</i>", <<<_EOM_
(LUNA and NEWS Only)
機種に依存せず DIPSW をシリアルコンソールを使うかどうか指定します。
"<tt>yes</tt>" ならシリアルコンソールを使うように、
"<tt>no</tt>" ならシリアルコンソールを使わないように DIPSW 設定を上書きします。
"" (空) なら何もしません。デフォルトは "" です。
<tt>luna-dipsw1</tt> もしくは <tt>news-dipsw</tt> (機種による)
の状態が設定ファイルやコマンドラインオプションによって確定した後に
このオプションによって該当のスイッチだけを変更します。
NEWS でシリアルコンソールを使わないを選択した場合、
SW1,2,3 は OFF, OFF, ON にセットされ、
NWB-512 モノクロコンソール(未実装) が選択されます。
<q>Specifies whether to configure DIPSW to use serial console,
regardless of the models.
"<tt>yes</tt>" overwrites DIPSW, to use serial console.
"<tt>no</tt>" overwrites DIPSW, not to use serial console.
"" (Empty) does nothing.
The default value is "".
This option only changes the appropriate switch(es)
after the <tt>luna-dipsw1</tt> or <tt>news-dipsw</tt> configuration
is determined by the configuration file or command line options.
If you choose not to use serial console on NEWS,
SW1,2,3 will be set OFF, OFF, ON respectively,
and NWB-512 monochrome console (not implemented) will be chosen.</q>
_EOM_
);

config_item(
	"ethernet-macaddr = <i>string</i><br>" .
	"ethernet<i>N</i>-macaddr = <i>string</i><br>",
<<<_EOM_
<i>N</i>
番目のイーサネットデバイスの仮想マシン側の MAC アドレスを指定します。
<tt><i>XX</i>:<i>XX</i>:<i>XX</i>:<i>XX</i>:<i>XX</i>:<i>XX</i></tt>
形式で指定します。
<tt>auto</tt> なら自動的に決定します。
デフォルトは <tt>auto</tt> です。
<tt>ethernet-macaddr</tt> は <tt>ethernet0-macaddr</tt> の別名です。
_EOM_
);

config_item("exec-file = <i>path</i>", <<<_EOM_
起動時にロードするホストの実行ファイルを指定します。
-X オプションとほぼ同等ですが、相対パスは VM ディレクトリを起点にします。
<q>Specifiies the host file that will be loaded at startup.
This is mostly the same as -X option.
The only one difference is that relative path originates the VM directory.</q>
_EOM_
);

config_item("exec-bootparam = <i>string</i>", <<<_EOM_
(virt-m68k Only)
カーネルに渡すブートパラメータを指定します。
内容はたぶん OS ごとに異なりますが、
NetBSD/virt68k では "<tt>root=ld0</tt>" (クォートを除く)
のようにしてカーネルにルートデバイスを指示します。
<q>Specifies the boot parameter that is passed to the kernel.
The syntax may differ depending on the OS, but in NetBSD/virt68k,
you can specify the root device to the kernel, like as
"<tt>root=ld0</tt>" (excluding quotes).</q>
_EOM_
);

config_item("exec-initrd = <i>path</i>", <<<_EOM_
(virt-m68k Only)
カーネルに渡す初期 RAM ディスクイメージのパスを指定します。
--initrd オプションとほぼ同等ですが、相対パスは VM ディレクトリを起点にします。
<q>Specifies the initial ramdisk image passed to the kernel.
This is mostly the same as --initrd option.
The only one difference is that relative path originates the VM directory.</q>
_EOM_
);

config_item("extram-size = <i>integer</i>", <<<_EOM_
(X68030 Only)
拡張メモリのサイズを MB 単位で指定します。
今の所以下だけが指定できます。
<q>Specifies the extended RAM size in MB.
For now, only the following can be specified.</q>
<ul>
<li><tt>0</tt> … 拡張メモリを使用しません。デフォルトです。
<q>No extended memory.  It's default.</q>
<li><tt>16</tt> … TS-6BE16 互換モードで、
アドレス $0100'0000 からの 16MB です。
<q>TS-6BE16 compatible mode.
Its address is from $0100'0000 and the size is 16MB.</q>
<li><tt>128/256/512</tt> … 060turbo 互換モードで、
アドレス $1000'0000 からです。
<q>060turbo compatible mode.  Its address is from $1000'0000.</q>
</ul>
_EOM_
);

config_item("fast-mode = <i>integer</i>", <<<_EOM_
起動時の動作モードを指定します。0 なら通常モード、1 なら高速モードです。
デフォルトは 0 です。
コマンドラインオプション <tt>-f</tt> でも高速モードへのみ指定可能です。
_EOM_
);

config_item("fd-drive = <i>integer</i>", <<<_EOM_
(X68030 Only)
フロッピードライブの数を 0 から 4 で指定します。
デフォルトは 2 です。
<q>Specifies the number of floppy drives from <tt>0</tt> to <tt>4</tt>.
The default is <tt>2</tt>.</q>
_EOM_
);

config_item("fd<i>N</i>-image = <i>path</i>", <<<_EOM_
(X68030 Only)
フロッピードライブ <i>N</i> に起動時に挿入するディスクイメージを指定します。
イメージパスが相対パスなら VM ディレクトリからの相対パスになります。
起動後はメニューから操作できます。
デフォルトは空です。
<q>Specifies a diskimage to be inserted to floppy drive <i>N</i> at startup.
If the <i>path</i> is relative path, it is from the VM directory.
You can also operate them from menu after startup.
The default is empty.</q>
_EOM_
);

config_item("fpu-type = <i>value</i>", <<<_EOM_
(X68030 and virt-m68k Only)
68030 に FPU コプロセッサを装着するかどうか指定しています。
この設定は <tt>mpu-type</tt> が <tt>68030</tt> の時のみ有効です。
<tt>none</tt> なら FPU コプロセッサを装着しません。
<tt>68881</tt> なら FPU コプロセッサとして 68881 を装着します。
現状 68882 はサポートしていません。
また <tt>none</tt> の代わりに <tt>0</tt>、
<tt>68881</tt> の代わりに <tt>1</tt> と書くこともできます。
デフォルトは <tt>68881</tt> です。
LUNA-I はたぶん 68881 搭載モデルのみのため変更できません。
<q>Specifies whether to install FPU co-processor or not.
This item is meaningful only if <tt>mpu-type</tt> is <tt>68030</tt>.
If <tt>none</tt>, FPU co-processor is not installed.
If <tt>68881</tt>, 68881 FPU co-processor is installed.
68882 is not supported yet.
And, <tt>none</tt> can also be written as <tt>0</tt>,
<tt>68881</tt> can also be written as <tt>1</tt>.
The default is <tt>68881</tt>.
This item cannot be specified on LUNA-I
because (probably) all LUNA-I has 68881.</q>
_EOM_
);

config_item("host-avx2 = <i>string</i>", <<<_EOM_
ホストが amd64(x86_64) の場合にレンダリングに AVX2
アクセラレーションを使うかどうかを指定します。
<tt>auto</tt> なら起動時にホスト CPU が AVX2 をサポートしているか確認し、
サポートしていれば使用します。
<tt>no</tt> なら AVX2 コードを実行しません。
デフォルトは <tt>auto</tt> です。
amd64(x86_64) 以外のホストではこの設定は無視されます。
<q>Specifies whether to use AVX2 acceleration for rendering
on amd64(x86_64) host.
If <tt>auto</tt>, nono checks whether the host CPU supports AVX2
on startup and use it if it does.
If <tt>no</tt>, nono will not execute AVX2 instructions.
The default is <tt>auto</tt>.
Note that this item is ignored if the host is not amd64(x86_64).</q>
_EOM_
);

config_item("host-neon = <i>string</i>", <<<_EOM_
ホストが aarch64 の場合にレンダリングに NEON
アクセラレーションを使うかどうかを指定します。
<tt>auto</tt> なら使用し、
<tt>no</tt> なら使用しません。
デフォルトは <tt>auto</tt> です。
aarch64 以外のホストではこの設定は無視されます。
<q>Specifies whether to use NEON acceleration for rendering
on aarch64 host.
If <tt>auto</tt>, nono uses NEON code.
If <tt>no</tt>, nono don't use NEON code.
The default is <tt>auto</tt>.
Note that this item is ignored if the host is not aarch64.</q>
_EOM_
);

config_item("hostcom-driver = <i>string</i>", <<<_EOM_
シリアルポートのホスト側ドライバを指定します。
<tt>stdio</tt> なら標準入出力を使用します。
<tt>tcp</tt> なら TCP ポートで TELNET プロトコルで待ち受けます。
<tt>cons</tt> ならメイン画面で端末エミュレーションを行います。
<tt>none</tt> ならホスト側とは一切通信を行いません。
ゲスト機種によって対応しているホスト側ドライバの種類とデフォルト値が変わります。
LUNA-I、LUNA-88K、X68030 では <tt>stdio</tt>、<tt>tcp</tt>、<tt>none</tt>
が選択可能でデフォルトは <tt>none</tt> です。
virt-m68k、NEWS では <tt>stdio</tt>、<tt>tcp</tt>、<tt>cons</tt>、<tt>none</tt>
すべてが選択可能でデフォルトは <tt>cons</tt> です。
<q>Specifies the host driver of serial port.
<tt>stdio</tt> uses the standard input/output.
<tt>tcp</tt> listens on TCP port using TELNET protocol.
<tt>cons</tt> does a terminal emulation in main panel.
<tt>none</tt> doesn't make any communication with the host.
The choices and default value vary depending on the guest type.
On LUNA-I, LUNA-88K and X68030, you can choose <tt>stdio</tt>, <tt>tcp</tt>
or <tt>none</tt>, and the default is <tt>none</tt>.
On virt-m68k and NEWS, you can choose all of <tt>stdio</tt>, <tt>tcp</tt>,
<tt>cons</tt> or <tt>none</tt>, and the default is <tt>cons</tt>.</q>
_EOM_
);

config_item("hostcom-tcp-port = <i>integer</i>", <<<_EOM_
ホストドライバが tcp の時の TCP 待ち受けポート番号を指定します。
<q>Specifies the TCP port number that host driver listens.</q>
_EOM_
);

config_item("hostcom-fallback = <i>integer</i>", <<<_EOM_
<tt>hostcom-driver</tt> で指定したドライバが使用可能でなかった時、
0 ならプロセスを終了します。1 なら <tt>none</tt> を選択して実行を継続します。
デフォルトは 0 です。
<q>Specifies the behavior when the driver which is selected by
<tt>hostcom-driver</tt> is unusable;
terminate the process if 0,
or continue to run using the <tt>none</tt> driver if 1.
The default is 0.</q>
_EOM_
);

config_item("hostkbd-input = <i>string</i>", <<<_EOM_
(LUNA and X68030 Only)
ホストキーボードの入力モードを指定します。
<tt>char</tt> ならキャラクタ入力モード、
<tt>jp</tt> なら日本語キーボードモードです。
デフォルトは <tt>char</tt> です。
詳細は <a href="#aboutvm">VM について</a> の章を参照してください。
<q>Specifies the input mode of the host keyboard.
<tt>char</tt> means the character mode,
<tt>jp</tt> means the Japanese keyboard mode.
The defualt is <tt>char</tt>.
See <a href="#aboutvm">About VM</a> for details.</q>
_EOM_
);

config_item(
	"hostnet-driver = <i>string</i><br>" .
	"hostnet-afpacket-ifname = <i>ifname</i><br>" .
	"hostnet-bpf-ifname = <i>ifname</i><br>" .
	"hostnet-tap-devpath = <i>path</i><br>" .
	"hostnet-usermode-hostfwd = <i>string</i><br>" .
	"hostnet-usermode-net = <i>string</i><br>" .
	"hostnet-usermode-net6 = <i>string</i><br>" .
	"hostnet-fallback = <i>integer</i><br>", <<<_EOM_
それぞれ <tt>hostnet0-*</tt> の別名です。
_EOM_
);

config_item("hostnet<i>N</i>-driver = <i>string</i>", <<<_EOM_
<i>N</i>
番目のイーサネットデバイスのホスト側ドライバを指定します。
<tt>afpacket</tt>、<tt>bpf</tt>、<tt>tap</tt>、<tt>usermode</tt> のうち
configure で検出したものと <tt>auto</tt>、<tt>none</tt> が選択可能です。
<q>Specifies the host driver of <i>N</i>-th
ethernet device.
<tt>afpacket</tt>, <tt>bpf</tt>, <tt>tap</tt> and <tt>usermode</tt> can be specified
only if the configure detects them.
<tt>auto</tt> and <tt>none</tt> can always be specified.</q>
<ul>
<li><tt>afpacket</tt> は Linux の AF_PACKET ソケットを使用します。
ホスト自身とは通信できません。
<q><tt>afpacket</tt> uses Linux's AF_PACKET socket.
It cannot communicate with the host itself.</q>
<li><tt>bpf</tt> は bpf(4) デバイスを使用します。
ホスト自身とは通信できません。
<q><tt>bpf</tt> uses bpf(4) device.
It cannot communicate with the host itself.</q>
<li><tt>tap</tt> は tap(4) デバイスを使用します。
<q><tt>tap</tt> uses tap(4) device.</q>
<li><tt>usermode</tt> は libslirp を使用したユーザモードです。
nono 自身が NAT ルータ、DHCP サーバ、DNS サーバの機能を持ちます。
<q><tt>usermode</tt> is an usermode network using libslirp.
nono also acts as NAT router, DHCP server and DNS server.</q>
<li><tt>none</tt> ならホスト側とは一切通信を行いません。
<q><tt>none</tt> doesn't make any communication with the host.</q>
</ul>
<tt>auto</tt> は <tt>usermode</tt> と同義ですが、
configure で libslirp が無効になっている場合は <tt>none</tt> と同義になります。
<tt>hostnet0-driver</tt> のデフォルトは <tt>auto</tt>、
<tt>hostnet1-driver</tt> のデフォルトは <tt>none</tt> です。
<q><tt>auto</tt> is a synonym for <tt>usermode</tt>, but
when libslirp is disabled on configure, it is a synonym for <tt>none</tt>.
The default of <tt>hostnet0-driver</tt> is <tt>auto</tt>,
the default of <tt>hostnet1-driver</tt> is <tt>none</tt>.</q>
_EOM_
);

config_item("hostnet<i>N</i>-afpacket-ifname = <i>ifname</i>", <<<_EOM_
ホストドライバが afpacket の時にバインドするインタフェースを1つ指定します。
<i>ifname</i> が <tt>auto</tt>
なら使用可能なインタフェースを1つ自動的に選択します。
デフォルトは <tt>auto</tt> です。
なお、このホストドライバではローカルホストとの通信は出来ません。
<q>Specifies an interface name to bind to, when the host driver is afpacket.
If <tt>auto</tt> is specified as <i>ifname</i>,
it selects an usable interface automatically.
The default is <tt>auto</tt>.
Note that this host driver cannot communicate with the localhost.</q>
_EOM_
);

config_item("hostnet<i>N</i>-bpf-ifname = <i>ifname</i>", <<<_EOM_
ホストドライバが bpf の時にバインドするインタフェースを1つ指定します。
<i>ifname</i> が <tt>auto</tt>
なら使用可能なインタフェースを1つ自動的に選択します。
デフォルトは <tt>auto</tt> です。
なお、このホストドライバではローカルホストとの通信は出来ません。
<q>Specifies an interface name to bind to, when the host driver is bpf.
If <tt>auto</tt> is specified as <i>ifname</i>,
it selects an usable interface automatically.
The default is <tt>auto</tt>.
Note that this host driver cannot communicate with the localhost.</q>
_EOM_
);

config_item("hostnet<i>N</i>-tap-devpath = <i>path</i>", <<<_EOM_
ホストドライバが tap の時に使用するデバイスを1つフルパスで指定します。
デフォルトは <tt>auto</tt> で、この場合は自動的にデバイスを選択します。
この時の探し方はホスト OS によって異なります。
Linux なら <tt>/dev/net/tun</tt> を指定したのと同じです。
OpenBSD なら <tt>/dev/tap0</tt> から <tt>/dev/tap9</tt> まで
順番にオープンできるまで試します。
NetBSD (と FreeBSD) ならまず <tt>/dev/tap</tt> でクローニングを試み、
それが失敗すれば <tt>/dev/tap0</tt> から <tt>/dev/tap9</tt> までを
順番にオープンできるまで試します。
いずれの場合も VM ディレクトリかその親ディレクトリに
<tt>nono-ifup</tt>, <tt>nono-ifdown</tt> という名前のシェルスクリプトが必要です。
何もすることがない場合でも正常終了する空のシェルスクリプトを用意してください。
<q>
Specifies a device pathname, when the host driver is tap.
The default is <tt>auto</tt>.
The behavior in this case depends on the host OS.
On Linux, it's the same as <tt>/dev/net/tun</tt>.
On OpenBSD, it will try from <tt>/dev/tap0</tt> to <tt>/dev/tap9</tt>
until successful.
On NetBSD (and FreeBSD), it will try cloning by <tt>/dev/tap</tt> first.
If that fails, then try from <tt>/dev/tap0</tt> to <tt>/dev/tap9</tt>
until successful.
In all cases, you need to prepare two shell script files which names are
<tt>nono-ifup</tt> and <tt>nono-ifdown</tt> in the VM directory or
its parent directory.
Even if you don't have anything to do in these scripts,
you need to prepare empty scripts that will terminate successfully.</q>
_EOM_
);

config_item("hostnet<i>N</i>-usermode-net = <i>network</i>/<i>netmask</i>", <<<_EOM_
ホストドライバが usermode の時の、内部 IPv4 ネットワークのアドレスを指定します。
ネットワークアドレスは
<tt>192.0.2.0/255.255.255.0</tt> のようにネットマスクで指定するか
<tt>192.0.2.0/24</tt> のようにネットマスク長で指定することも出来ます。
デフォルトは <tt>10.8.0.0/24</tt> です。
_EOM_
);

config_item("hostnet<i>N</i>-usermode-net6 = <i>network</i>/<i>prefixlen</i>", <<<_EOM_
ホストドライバが usermode の時の、内部 IPv6 ネットワークのアドレスを指定します。
ネットワークアドレスは <tt>2001:db8::/64</tt>
のようにアドレスとプレフィックス長で指定します。
デフォルトは <tt>fd08::/64</tt> です。
_EOM_
);

config_item("hostnet<i>N</i>-usermode-hostfwd = <i>entry</i>[<i>;entry</i>[<i>;…</i>]]", <<<_EOM_
ホストドライバが usermode の時の、外部から内部へのポートフォワーディングの設定を行います。
1つの <i>entry</i> は
<dl>
<dd>
<tt><i>protocol</i>,[<i>hostaddr</i>:]<i>hostport</i>,[<i>guestaddr</i>:]<i>guestport</i></tt>
</dd>
のように '<tt>,</tt>'(カンマ) 3つで区切って表します。
<i>protocol</i> は <tt>tcp</tt> か <tt>udp</tt> です。
<i>hostaddr</i> はホストのバインドアドレスで省略すると 0.0.0.0 です。
<i>guestaddr</i> はゲストのアドレスで、
省略すると DHCP でクライアントに配布したアドレスになります
(通常は省略します)。
例えば、ホストの 10022/tcp へのコネクションをゲストの 22/tcp に転送したい場合は
<tt>tcp,10022,22</tt> となります。
複数指定する場合は '<tt>;</tt>'(セミコロン) で区切って1行に並べます。
<p>
IPv6 には対応していません。
_EOM_
);

config_item("hostnet<i>N</i>-fallback = <i>integer</i>", <<<_EOM_
<tt>hostnet<i>N</i>-driver</tt> で指定したドライバが使用可能でなかった時、
0 ならプロセスを終了します。
1 なら none を選択して実行を継続します。
デフォルトは 0 です。
<q>Specifies the behavior when the driver which is selected by
<tt>hostnet<i>N</i>-driver</tt> is unusable;
terminate the process if 0,
or continue to run using the <tt>none</tt> driver if 1.
The default is 0.</q>
_EOM_
);

config_item("iplrom1-image = <i>path</i>", <<<_EOM_
(X68030 Only)
X68030 の外部 IPLROM イメージファイルのパスを指定します。
こちらは 0xfe0000..0xffffff の 128KB の部分で、IPLROM30 と呼ばれているほうです。
<i>path</i> がファイル名のみなら VM ディレクトリとその親ディレクトリからこのファイル名を検索します。
<i>path</i> が相対パスなら VM ディレクトリからの相対パスになります (現在のディレクトリからではありません)。
空にすると無償配布されている IPLROM30 を使用します。
デフォルトは空です。
<q>Specifies the X68030's external IPLROM image file path.
This one contains 128KB at 0xfe0000..0xffffff and is known as IPLROM30.
If the <i>path</i> does not have any path delimiters,
the VM directory and then its parent directory will be searched.
If the <i>path</i> is a relative path,
it will be path from the VM directory, not from the current directory.
If the <i>path</i> is empty, the public released IPLROM30 will be used.
The default value is empty.</q>
_EOM_
);

config_item("iplrom2-image = <i>path</i>", <<<_EOM_
(X68030 Only)
X68030 の外部 IPLROM イメージファイルのパスを指定します。
こちらは 0xfc0000..0xfdffff の 128KB の部分で、ROM30 と呼ばれているほうです。
<i>path</i> がファイル名のみなら VM ディレクトリとその親ディレクトリからこのファイル名を検索します。
<i>path</i> が相対パスなら VM ディレクトリからの相対パスになります (現在のディレクトリからではありません)。
空にすると内蔵 ROM を使用します。
内蔵 ROM は NetBSD/x68k が起動する程度の SCSI IOCS のみサポートしています。
デフォルトは空です。
<q>Specifies the X68030's external IPLROM image file path.
This one contains 128KB at 0xfc0000..0xfdffff and is known as ROM30.
If the <i>path</i> does not have any path delimiters,
the VM directory and then its parent directory will be searched.
If the <i>path</i> is a relative path,
it will be path from the VM directory, not from the current directory.
If the <i>path</i> is empty, internal emulated ROM will be used.
The ROM supports only enough SCSI IOCS to boot NetBSD/x68k.
The default value is empty.</q>
_EOM_
);

config_item("keyboard-connect = <i>integer</i>", <<<_EOM_
(LUNA and X68030 Only)
起動時にキーボードを本体に接続するかどうかを指定します。
1 なら接続し、0 なら接続しません。デフォルトは 1 です。
起動後はメニューから変更可能です。
<q>Specifies whether to connect keyboard on boot.
If 1, it is connected; if 0, it isn't connected.  The default is 1.
You can change it on GUI menu after boot.</q>
_EOM_
);

config_item("luna-adjust-misused-epoch = <i>integer</i>", <<<_EOM_
(LUNA Only)
LUNA で誤った RTC epoch を採用している OS 向けに RTC
エミュレーションを補正するかどうかを
指定します。0 なら補正をしません(実機と同じ動作)、
1 なら補正します(現実世界と同じ動作)。
デフォルトは 1 で、通常 1 のままで使用して問題ありません。
<q>
Specifies whether nono corrects RTC emulation for OSes
that adopts wrong RTC epoch on LUNA.
0 means making no correction
(this is the same behavior as the actual machine).
1 means making correction
(this is the same behavior as the real world).
The default is 1.  Normally, leave it 1.</q>
<p>
LUNA で採用している RTC (MK48T02) は2桁で保持している年の値が
4 で割り切れる年をうるう年とする仕様です。
ところが NetBSD/luna68k、OpenBSD/luna88k などはこの
RTC の年の値を 1970年からの経過年として使用しています。
例えば1970年はうるう年ではないため 2月28日の翌日は 3月1日ですが、
MK48T02 的には 00年であるためうるう年と認識し 2月28日の翌日が2月29日になります。
このように、これらの OS を使っている場合実機の
RTC は4年のうち約2年間、1日ずれた日付を指しているようです。
しかしながら、RTC の時刻は OS 起動時に一度読んだ後は基本的に参照しない上、
今時必要なら NTP で時間を合わせるため、
実機でも問題が顕在化することはまずないと思います。
nono の場合は実機と異なり、アプリケーション実行中しか RTC が進まないため、
補正がない場合の動作が問題になるのは
nono を起動したまま偶数年の2月末日から日付をまたいで、
かつ nono を起動したまま OS を再起動して NTP などで時刻修正を行わなかった時
だけだと思います。
このオプションはほぼ開発者向けの動作確認用です。
_EOM_
);

config_item("luna-dipsw1 = <i>string</i>", <<<_EOM_
(LUNA Only)
本体前面 DIPSW#1-1..#1-8 の内容を指定します。
"<tt>0</tt>" を DOWN、"<tt>1</tt>" を UP として、
これを8つ並べた形式で、前から順に #1..#8 に対応します。
<q>Specifies status of the front panel DIPSW#1-1..#1-8 using 8 digits.
"<tt>0</tt>" means DOWN and "<tt>1</tt>" means UP.
The first character corresponds to #1 and
the eighth character corresponds to #8.</q>
<p>
LUNA-I でのデフォルトは <tt>11110111</tt> です。
各スイッチの内容は以下のリンクを参照してください。
<q>On LUNA-I, the default value is <tt>11110111</tt>.
See the following link about DIPSW.</q><br>
→ <a href="https://wiki.netbsd.org/ports/luna68k/luna68k_info/"
>NetBSD/luna68k: Information</a>
<br>
LUNA-88K でのデフォルトは <tt>11111111</tt> です。
各スイッチの内容は以下のリンクを参照してください。
<q>On LUNA-88K, the default value is <tt>11111111</tt>.
See the following link about DIPSW.</q><br>
→ <a href="http://man.openbsd.org/boot_luna88k.8"
>OpenBSD manual pages: boot_luna88k(8)</a>
<p>
自動起動するかどうかとシリアルコンソールを使うかどうかを指定したい場合は
こちらではなく
<a href="#config-dipsw-autoboot">dipsw-autoboot、dipsw-serial</a>
設定を使うほうが便利です。
<q>If you only want to specify whether to autoboot and/or
to use serial console,
<a href="#config-dipsw-autoboot">dipsw-autoboot, dipsw-serial</a>
configurations are useful.</q>
_EOM_
);

config_item("luna-dipsw2 = <i>string</i>", <<<_EOM_
(LUNA Only)
本体前面 DIPSW#2-1..#2-8 の内容を指定します。
書式は <tt>luna-dipsw1</tt> と同じです。
デフォルトは <tt>11111111</tt> です。
<q>Specifies status of the front panel DIPSW#2-1..#2-8.
The same syntax as <tt>luna-dipsw1</tt> is used.
The default value is <tt>11111111</tt>.</q>
<p>
NetBSD/luna68k のブートローダは、
DIPSW#2 が "<tt>11111111</tt>" なら自動的にカーネルをロードして実行し、
どれかでも "<tt>0</tt>" にするとプロンプトで停止するようです。
<span class=strike>(本当は #8 だけで制御するつもりだったんじゃないかという気がします)</span>
<q>NetBSD/luna68k bootloader will automatically load and execute the kernel,
if the DIPSW#2 is "<tt>11111111</tt>".
Otherwise, the bootloader will enter interactive mode.
<span class=strike>(I doubt that they actually wanted to switch with only #8)
</span></q>
_EOM_
);

config_item("luna-video-plane = <i>integer</i>", <<<_EOM_
(LUNA Only)
LUNA のビデオボードのプレーン数を 1、4、8 から指定します。
1 ならモノクロビデオボード、
4 なら16色 (4bpp) ビデオボード、
8 なら 256色 (8bpp) ビデオボードです。
デフォルトは 4 です。
<q>Specifies number of planes on LUNA video board.
The valid values are 1, 4 or 8.
1 means a monochrome video board,
4 means 16-color (4bpp) video board,
8 means 256-color (8bpp) video board.
The default value is 4.</q>
_EOM_
);

config_item(
	"m88100-version = <i>integer</i><br>" .
	"m88200-version = <i>integer</i>", <<<_EOM_
(LUNA-88K Only)
MPU と CMMU のマスクバージョンを設定します。
今の所これによるエミュレータの動作の違いはありません。
どちらかというとこれを参照しているゲスト OS の動作確認用です。
デフォルトは <tt>m88100-version</tt> が 11、<tt>m88200-version</tt> が 9 です。
<q>Specifies MPU and CMMU mask version.
This item doesn't affect any MPU/CMMU emulations for now.
But it may be useful for verifying the guest OS behaviors.
The default value is 11 for <tt>m88100-version</tt>,
9 for <tt>m88200-version</tt>.</q>
_EOM_
);

config_item("mainview-scale = <i>double</i>", <<<_EOM_
メインウィンドウの起動時のスケールを実数で指定します。
コマンドラインオプション <tt>-s</tt> で上書き可能です。
起動後はメニューから、
プリセットされた倍率とここで指定した倍率には変更可能です。
デフォルトは 1.0 です。
_EOM_
);

config_item("monitor-fontsize = <i>integer</i>",
<<<_EOM_
テキスト系モニタとステータスパネルのフォントサイズを
12, 16, 24 から指定します。
コマンドラインオプション <tt>--fontsize</tt> で上書き可能です。
起動後はメニューから変更することができます。
デフォルトは 12 です。
_EOM_
);

config_item("monitor-rate = <i>integer</i>", <<<_EOM_
テキスト系モニタウィンドウの更新頻度を Hz 単位で指定します。
1 から 60 までの間で指定でき、デフォルトは 20Hz です。
起動後にメニューから、
プリセットされた頻度とここで指定した頻度には変更可能です。
<q>Specifies refresh rate of all text monitor windows in Hz.
It ranges from 1 to 60.  The default is 20Hz.
You can choose this value on GUI menu after boot,
from preset rate or rate specified here.</q>
_EOM_
);

config_item("mpu-clock = <i>value</i>", <<<_EOM_
MPU のクロック数を MHz 単位で指定します。
デフォルトは LUNA-I なら 20MHz、LUNA-88K と X68030 なら 25MHz です。
virt-m68k ではあまり意味はありませんが 25MHz です。
<q>Specifies the MPU clock in MHz.
The default value is 20MHz on LUNA-I, or 25MHz on LUNA-88K and X68030.
On virt-m68k, it's less meaningful but 25MHz.</q>
_EOM_
);

config_item("mpu-type = <i>value</i>", <<<_EOM_
(X68030, virt-m68k Only)
MPU 種別を <tt>68030</tt> か <tt>68040</tt> で指定します。
デフォルトは <tt>68030</tt> です。
<q>Specifies the MPU type, <tt>68030</tt> or <tt>68040</tt>.
The default is <tt>68030</tt>.</q>
_EOM_
);

config_item("mpu-pseudo-stop = <i>integer</i>", <<<_EOM_
(LUNA-88K Only)
m88100 にて疑似 STOP 状態を有効にするかどうかを指定します。
0 なら無効(実機と同じ動作)、1 なら有効で、デフォルトは 1 です。
m88100 には、m68k の STOP 命令 (割り込みが上がるまで何もせず待つ)
に相当する命令がなく、
大抵ビジーウェイトループで割り込みが上がるのを待つことになります。
これは実機では (消費電力を減らす手段がないという些細な問題以外には)
何のデメリットもないのですが、
エミュレータで特に高速動作させている時には割り込みが上がるまで
(例えば人間がキーを入力するまで) ホスト CPU パワーを使い潰してビジーウェイトループを実行し続けることになり、ホスト CPU があっつあつになります。
それを防ぐための機能です。
特徴的な命令列を検出して実現しているので、すべての状況で動作するわけではありません。
_EOM_
);

config_item(
	"nereid0-enable = <i>integer</i><br>" .
	"nereid1-enable = <i>integer</i><br>", <<<_EOM_
(X68030 Only)
Nereid 拡張ボードを装着するかどうかを指定します。
Nereid は同時に2枚まで使用することができます。
値は <tt>0</tt> なら装着せず、<tt>1</tt> なら装着します。
デフォルトは <tt>0</tt> (装着しない) です。
詳細は <a href="#nereid">4.6 Nereid の章</a>を参照してください。
<q>Specifies whether install Nereid expansion board or not.
Up to two board can be operated at the same time.
If <tt>0</tt>, the board is not installed.
If <tt>1</tt>, the board is installed.
The default value is <tt>0</tt>.
See also <a href="#nereid">Section 4.6 Nereid</a> below for details.</q>
_EOM_
);

config_item(
	"nereid0-net = <i>integer</i><br>" .
	"nereid1-net = <i>integer</i><br>", <<<_EOM_
(X68030 Only)
Nereid ボードの NIC (RTL8019AS) のみを無効にすることが出来ます
(実機では通常そのようなことは出来ません)。
<tt>0</tt> なら無効、<tt>1</tt> なら有効です。デフォルトは <tt>1</tt> です。
通常は <tt>1</tt> のまま使用してください。
この設定は対応する <tt>nereid<i>N</i>-enable</tt> が <tt>0</tt>
(ボードを装着しない) の場合は意味を持ちません。
<q>This can disable only NIC (RTL8019AS) of Nereid expansion board
(although it's not possible normally in the real world).
It's disabled if <tt>0</tt>, or enabled if <tt>1</tt>.
The default is <tt>1</tt>.  Normally, leave it <tt>1</tt>.
This item will be ignored if the corresponding <tt>nereid<i>N</i>-enable</tt>
is <tt>0</tt>.</q>
_EOM_
);

config_item(
	"nereid0-ram-size = <i>integer</i><br>" .
	"nereid1-ram-size = <i>integer</i><br>", <<<_EOM_
(X68030 Only)
Nereid ボードのバンクメモリのサイズを MB 単位で指定します。
指定できるのは <tt>0</tt>, <tt>4</tt>, <tt>16</tt> です。
<tt>0</tt> を指定するとバンクメモリを無効にします。
デフォルトは <tt>16</tt> です。
この設定は対応する <tt>nereid<i>N</i>-enable</tt> が <tt>0</tt>
(ボードを装着しない) の場合は意味を持ちません。
<q>Specifies bank memory size in MB of Nereid expansion board.
The valid values are <tt>0</tt>, <tt>4</tt> or <tt>16</tt>.
If <tt>0</tt>, disable the bank memory.
The default is <tt>16</tt>.
This item will be ignored if the corresponding <tt>nereid<i>N</i>-enable</tt>
is <tt>0</tt>.</q>
<br><br>
また通常は必要ありませんが -4 または -16 を指定すると、
バンクメモリは無効にした上で Nereid 制御ポートのビット6の読み出し値
(バンクメモリの容量) を再現することが出来ます。
-4 ならビット6は 0 (4MB)、0 か -16 なら 1(16MB) が読み出せます。
_EOM_
);

config_item("news-dipsw = <i>string</i>", <<<_EOM_
(NEWS Only)
DIPSW の内容を指定します。
"<tt>0</tt>" を OFF、"<tt>1</tt>" を ON として、
これを8つ並べた形式で、前から順に SW1..SW8 に対応します。
デフォルトは <tt>00001000</tt> です。
<q>Specifies status of the DIPSW using 8 digits.
"<tt>0</tt>" means OFF and "<tt>1</tt>" is ON.
The first character corresponds to SW1 and
the eighth character corresponds to SW8.
The default valus is <tt>00001000</tt>.</q>
<br><br>
各スイッチの内容は以下のリンクを参照してください。
<q>See the following link about DIPSW.</q><br>
→ <a href="https://www.netbsd.org/ports/news68k/faq.html#dip_sw"
>NetBSD/news68k Frequently Asked Questions</a>
<p>
自動起動するかどうかとシリアルコンソールを使うかどうかを指定したい場合は
こちらではなく
<a href="#config-dipsw-autoboot">dipsw-autoboot、dipsw-serial</a>
設定を使うほうが便利です。
<q>If you only want to specify whether to autoboot and/or
to use serial console,
<a href="#config-dipsw-autoboot">dipsw-autoboot, dipsw-serial</a>
configurations are useful.</q>
_EOM_
);

config_item("prom-image = <i>path</i>", <<<_EOM_
(LUNA Only)
LUNA-I/LUNA-88K の外部 ROM イメージファイルのパスを指定します。
<i>path</i> がファイル名のみなら VM ディレクトリとその親ディレクトリからこのファイル名を検索します。
<i>path</i> が相対パスなら VM ディレクトリからの相対パスになります (現在のディレクトリからではありません)。
空にすると内蔵 ROM を使用します。
デフォルトは空です。
<q>Specifies the LUNA-I/LUNA-88K's external ROM image file path.
If the <i>path</i> does not have any path delimiters,
the VM directory and then its parent directory will be searched.
If the <i>path</i> is a relative path,
it will be path from the VM directory, not from the current directory.
If the <i>path</i> is empty, internal emulated ROM will be used.
The default value is empty.</q>
<p>
実機を持っていない場合はこの値を空に (= デフォルトのままに) しておくと、
nono 内蔵のなんちゃって下位互換 ROM で起動します。
<q>If you does not have the real LUNA machines,
you can boot with nono's internal downward compatible emulated ROM
if you set this field empty (or leave it as the default).</q>
<p>
LUNA-I 実機を持っている場合は
ROM ファイルを指定することで実機 ROM で起動できます。
ROM ファイルは実機の 0x41000000-0x4101ffff (128KB) を保存したものです。
今のところ ROM は V4.22 (Thu Jul 27 11:45:42 1989) のみサポートしています。
それ以外については何も分かりません。
<q>If you have the real LUNA-I machine,
you can boot with the real ROM spcifying the ROM file path.
The ROM file is extracted from 0x41000000-0x4101ffff (128KB) of
the real LUNA-I machine.
For now, only V4.22 (Thu Jul 27 11:45:42 1989) is supported.
I have no idea about other ROMs.</q>
<p>
LUNA-88K 実機の場合は 0x41000000-0x4103ffff (256KB) を保存したものです。
今のところ ROM は version 1.20 のみサポートしています。
<q>
For LUNA-88K,
the ROM file is extracted from 0x41000000-0x4103ffff (256KB).
For now, only version 1.20 is supported.</q>
_EOM_
);

config_item("ram-size = <i>integer</i>", <<<_EOM_
搭載する RAM サイズを MB 単位で指定します。<q>Specifies the RAM size in MB.</q>
<ul>
<li>LUNA-I のデフォルトは 16MB です。
16MB 未満は 4MB 単位で、
16MB 以上は 512MB まで 1MB 単位で指定できます。
ただし <tt>prom-image</tt> で実機イメージを指定した場合は 255MB が上限になります。
ちなみに NetBSD/luna68k の起動には最低でも 8MB 必要です。
<q>On LUNA-I, the default is 16MB.
If the size is less than 16MB, you can specify in 4MB unit.
If larger, you can specify up to 512MB in 1MB unit.
However, if you have <tt>prom-image</tt> with the real image,
the maximum is limited to 255MB.
By the way, NetBSD/luna68k needs at least 8MB to boot.</q>
<li>LUNA-88K のデフォルトは 64MB です。
64MB 未満は 16MB 単位で、
64MB 以上は暫定で 512MB まで 1MB 単位で指定できます。
ただし <tt>prom-image</tt> で実機イメージを指定した場合は
240MB が上限になります。
<q>On LUNA-88K, the default is 64MB.
If the size is less than 64MB, you can specify in 16MB unit.
If larger, you can specify up to tentative 512MB in 1MB unit.
However, if you have <tt>prom-image</tt> with the real image,
the maximum is limited to 240MB.</q>
<li>X68030 ではメイン RAM 容量を示し、デフォルトは 12MB です。
4MB から 12MB まで 1MB 単位で指定できます。
拡張メモリについては extram-size を参照してください。
<q>On X68030, the default is 12MB.
You can specify it in 1MB unit from 4MB to 12MB.
See extram-size for extended memory.</q>
<li>NWS-1750 では現状 16MB で変更できません。
<q>On NWS-1750, This is 16MB fixed for now.</q>
<li>virt-m68k のデフォルトは 128MB です。
16MB から 4080MB まで指定可能です。
指定された値が 16MB で割り切れない場合は 16MB 単位に切り上げになります。
<q>On virt-m68k, the default is 128MB and
the range is 16MB to 4080MB.
If the specified size is not divisible by 16MB,
it will be rounded up to 16MB.</q>
</ul>
_EOM_
);

config_item("rtc-epoch-year = <i>integer</i>", <<<_EOM_
(LUNA Only)
RTC (MK48T02) の基準年を指定します。
デフォルトは 1970年です。
NetBSD/luna68k、OpenBSD/luna88k はいずれも基準年を 1970年としていますので、
デフォルトのままで構いません。
ゲスト OS に 4.4BSD を使用する際は 1900 を指定します。
NEWS では今の所 1900 固定で変更出来ません。
<q>Specifies the RTC (MK48T02) epoch year.
The default is 1970.
Since both NetBSD/luna68k and OpenBSD/luna88k use 1970 as epoch year,
there is no need to touch this value.
If you boot 4.4BSD on LUNA-I as the guest OS, specify 1900.
On NEWS, it is fixed at 1900.</q>
_EOM_
);

config_item("show-statuspanel = <i>integer</i>", <<<_EOM_
ステータスパネルを表示するかどうかを指定します。
0 なら非表示、1 なら表示です。
デフォルトは 1(表示) です。
起動後はメニューから変更可能です。
<q>Specifies whether to display the status panel or not.
If 0, it is hidden; if 1, it is shown.
The default is 1 (show).
You can change it on GUI menu after boot.</q>
_EOM_
);

config_item("spc0-id<i>N</i>-image = <i>devtype</i>[,<i>path</i>]", <<<_EOM_
(LUNA and X68030 Only)
SCSI デバイスとイメージを指定します。キーの <i>N</i> には 0 から 7 が入ります。
ただし ID 7 は本体が使用しますので指定しないでください。
値はデバイス種別 <i>devtype</i> とディスクイメージパス <i>path</i>
を "<tt>,</tt>"(カンマ) で区切って並べた形式です。
デバイス種別 <i>devtype</i> は以下のいずれかです。
<q>Specifies SCSI device and image.  <i>N</i> in the key is 0 to 7.
But don't specify ID 7 because the host uses it.
The value is in a form of device type <i>devtype</i> and
the disk image path <i>path</i> separated by "<tt>,</tt>"(comma).
<i>devtype</i> can be one of the following:</q>
<ul>
<li><tt>hd</tt> … HD drive
<li><tt>cd</tt> … CD-ROM drive
<li><tt>mo</tt> … MO drive
</ul>

<p>
<i>devtype</i> が <tt>hd</tt> なら <i>path</i> は省略できません。
<i>devtype</i> が <tt>cd</tt> か <tt>mo</tt> なら <i>path</i> は省略可能です。
イメージパスが相対パスなら VM ディレクトリからの相対パスになります。
<q>If <i>devtype</i> is <tt>hd</tt>, <i>path</i> cannot be ommitted.
If <i>devtype</i> is <tt>cd</tt> or <tt>mo</tt>, <i>path</i> can be ommitted.
If the <i>path</i> is relative path, it is from the VM directory.</q>

<p>
例えば、nono.cfg と同じディレクトリに置いた sd0.img を
起動 HDD ディスクイメージとして使い
(LUNA では通常 ID 6 をプライマリ HDD に割り当てます)、
ID 5 に同じディレクトリの install.iso をセットした CD ドライブを、
ID 4 に起動時メディアなしの MO ドライブを接続する場合は次のようになります。
<q>For example, if you use a harddisk image sd0.img placed in the same
directory as nono.cfg
(LUNA usually assigns ID 6 to the primary HDD),
ID 5 for CD-ROM drive that loads install.iso in the same directory,
and ID 4 for MO drive without media on boot,
write as following:</q>
<blockquote><pre>
spc0-id6-image = hd,sd0.img
spc0-id5-image = cd,install.iso
spc0-id4-image = mo
</pre></blockquote>
_EOM_
);

config_item("spc0-id<i>N</i>-seektime = <i>integer</i>", <<<_EOM_
(LUNA and X68030 Only)
指定の SCSI HDD の平均シークタイムを msec 単位で指定します。
現在のデフォルトは <tt>0</tt> です (S・S・D!! S・S・D!!)。
16 程度を指定すると幾分往時に思いを馳せることが出来るかもしれませんが、
今の所あまり安定していません。
<q>Specifies the average seek time of specified SCSI HDD in msec.
Currently, the default value is <tt>0</tt>
(This may be something like SSD :-).
If you specify about 16 or so, you can feel nostalgic,
but this feature is still unstable.</q>
_EOM_
);

config_item("spc0-id<i>N</i>-writeignore = <i>integer</i>", <<<_EOM_
(LUNA and X68030 Only)
指定の SCSI HD デバイスへの書き込みをイメージに書き戻すかどうか指定します。
<tt>0</tt> なら通常動作(書き込みを行う)です。
<tt>1</tt> ならディスクイメージに一切書き戻しません。
デバイスへ書き込んだはずのデータは Copy-On-Write の要領で、
VM ディレクトリ内の一時ファイルに書き込みます。
この一時ファイルはアプリケーション終了時に削除します。
fsck を気にせずカーネルのデバッグとかを行いたい場合にはどうぞ。
何が起きるか意味が分からない人は指定しないでください。
デフォルトは <tt>0</tt> です。
<q>Specifies whether nono writes a writing to SCSI HD devices back
to the diskimage.
<tt>0</tt> means normal operation (writes to the diskimage).
<tt>1</tt> means that nono will not write to the diskimage back.
Data that the guest wrote to the device will be written to a temporary file
in the VM directory,
like Copy-On-Write.
The temporary file will be removed when the application exits.
This is useful for kernel debugging because it does not require fsck
after the kernel hangs or reboots.
Don't use this flag if you don't understand this paragraph.
The default value is <tt>0</tt>.</q>
<p>
ちなみに、メディアを書き込み禁止にしたい場合はこれではなく、
イメージファイルの書き込み権を落としてください。
<q>By the way, if you want to make the media write-protected,
clear the write permission from the image file
(instead of this setting).</q>
_EOM_
);

config_item("sram-sync-ramsize = <i>integer</i>", <<<_EOM_
(X68030 Only)
SRAM の RAM 容量欄を実際の RAM サイズに合わせるかどうかを指定します。
<tt>0</tt> なら何もしません (実機と同じ)。
<tt>1</tt> なら、アプリケーション起動時に
SRAM の \$ed0008.L (RAM 容量) を ram-size の設定値で更新します。
この更新は、
アプリケーション起動時に SRAM マジックが正しく書かれている場合のみ行われます。
デフォルトは <tt>1</tt> です。
<q>Specifies whether to synchronize a RAM size field in SRAM
with real RAM size or not.
If <tt>0</tt>, the application will do nothing (as same as the real).
If <tt>1</tt>, the application updates(synchronizes)
\$ed0008.L (RAM size) in SRAM with configuration value of ram-size.
This update is performed once only if
the SRAM magic string is correct at the application startup.
The default is <tt>1</tt>.</q>
_EOM_
);

config_item("virtio-block<i>N</i>-image = <i>path</i>", <<<_EOM_
(virt-m68k Only)
VirtIO ブロックデバイスのイメージを指定します。
キーの <i>N</i> は現状 0 から 7 が指定可能です。
イメージパスが相対パスなら VM ディレクトリからの相対パスになります。
<q>Specifies VirtIO block device's image.
<i>N</i> in the key is 0 through 7 for now.
If the path is relative path, it is from the VM directory.</q>
_EOM_
);

config_item("virtio-block<i>N</i>-writeignore = <i>integer</i>", <<<_EOM_
(virt-m68k Only)
指定の VirtIO ブロックデバイスへの書き込みをイメージに書き戻すかどうか指定します。
詳細は <tt>spc0-id<i>N</i>-writeignore</tt> を参照してください。
<q>Specifies whether nono writes a writing to VirtIO block devices back
to the diskimage.
See <tt>spc0-id<i>N</i>-writeignore</tt> for details.</q>
_EOM_
);

config_item("<span class='new'>virtio-scsi-id<i>N</i>-image = <i>devtype</i>[,<i>path</i>]</span>", <<<_EOM_
<span class="new">
(virt-m68k Only)
VirtIO SCSI デバイスとイメージを指定します。
イニシエータ ID が不要なため、
キーの <i>N</i> には 0 から 7 が指定できます。
詳細は <tt>spc0-id<i>N</i>-image</tt> を参照してください。
<q>Specifies VirtIO SCSI device and image.
You can specify all of 0 thorugh 7 for the key <i>N</i>,
because there is no initiator.
See <tt>spc0-id<i>N</i>-image</tt> for more details.</q>
</span>
_EOM_
);

config_item("<span class='new'>virtio-scsi-id<i>N</i>-writeignore = <i>integer</i></span>", <<<_EOM_
<span class="new">
(virt-m68k Only)
指定の VirtIO SCSI デバイスへの書き込みをイメージに書き戻すかどうか指定します。
詳細は <tt>spc0-id<i>N</i>-writeignore</tt> を参照してください。
<q>Specifies whether nono writes a writing to VirtIO SCSI devices back
to the diskimage.
See <tt>spc0-id<i>N</i>-writeignore</tt> for details.</q>
</span>
_EOM_
);

config_item("windrv-path = <i>path</i>", <<<_EOM_
(X68030 Only)
Windrv でゲスト側に見せるホストディレクトリを指定します。
今の所指定できるディレクトリは1つだけです。
空なら Windrv デバイスが存在しないように振る舞います。
デフォルトは空です。
_EOM_
);

config_item("x68k-cut-fc2 = <i>integer</i>", <<<_EOM_
(X68030 Only)
MPU (68030) の FC2 ピンを切断するかどうかを指定します。
<tt>0</tt> なら切断しません (標準の状態)。
<tt>1</tt> なら切断します。
デフォルトは <tt>1</tt> です。
NetBSD/x68k で X サーバを起動する場合のみ <tt>1</tt> にする必要があります。
<q>Specifies whether to cut MPU(68030) FC2 pin.
If <tt>0</tt>, the FC2 pin is connected as usual.
If <tt>1</tt>, it is disconnected.
The default is <tt>1</tt>.
Only if you run the X server on NetBSD/x68k, it needs to be <tt>1</tt>.</q>
_EOM_
);

config_item("xp-clock = <i>value</i>", <<<_EOM_
(LUNA Only)
XP プロセッサのクロック数を MHz 単位で指定します。
デフォルトは 6.144 [MHz] です。
_EOM_
);


?>
</dl>
</div>
<?php H4end(); ?>


<?php H4("aboutvm", "VM について <q>About VM</q>"); ?>

<?php H5("", "実装状況 <q>Implementation Status</q>"); ?>
<div class="main">
<table cellpadding=0 cellspacing=0>
<tr><td style="padding-right: 1em">◎	<td>: ほぼ実装済み <q>Mostly implemented</q>
<tr><td>○	<td>: 困らない程度には実装済み <q>Works</q>
<tr><td>△	<td>: とりあえず動いてる程度 <q>Works somehow</q>
<tr><td>×	<td>: 未実装 <q>Not implemented</q>
<tr><td>—	<td>: 実装予定なし <q>Not planned</q>
</table>
<style type="text/css">
.pghd {
	border: 0px none;
	border-bottom: 1px solid black;
	padding-top: 1em;
}
.pgth {
	border-top: 0px none;
	border-left: 1px solid black;
	border-right: 1px solid black;
	border-bottom: 1px solid black;
	padding-right: 1ex;
}
.pgtd {
	border-top: 0px none;
	border-left: 0px none;
	border-right: 1px solid black;
	border-bottom: 1px solid black;
}
</style>
<table cellspacing=0 cellpadding=0>
<?php
	$table = <<<__EOM__
LUNA-I
MPU (68030)		◎
FPU (68881)		◎
BT454			◎
CRTC2			○	標準で使用する値のみサポート
Frame buffer	◎
Keyboard/Mouse	◎
SIO (uPD7201)	◎
PIO (8255)		○
Ethernet (AM7990)	◎
NVRAM&amp;RTC (MK48T02)	◎
Front LCD		◎
SPC (MB89352)	◎
SCSI HD/CD/MO Devices	○
XP(HD647180) CPU	△
XP(HD647180) Timer0/1	○
XP(HD647180) その他の内蔵デバイス<br><q>Other internal devices</q>	×
XP 周辺デバイス <q>Peripheral devices</q>	×
電源 <q>Power Circuit</q>			○

LUNA-88K specific
MPU (88100 part)	○ 	マルチプロセッサ未実装、バグも未実装? <wbr><q>MP (and bugs?) not implemented</q>
MPU (88200 part)	◎
MPU (88110)		—	実装予定なし <q>Not planned</q>
FUSEROM			○

X68030
MPU (68030)		◎	68EC030 は実装予定なし <q>68EC030 is not planned</q>
FPU (68881)		◎	68882 は未実装 <q>68882 not implemented</q>
MPU (68040)		△	キャッシュ未実装、実行サイクル未考察
DMAC			△
CRTC/VC			△	768x512 のテキスト画面のみサポート <wbr><q>Only 768x512 text screen supported</q>
FDC/FDD			○
標準・拡張エリアセット <q>Areaset</q>	◎
ADPCM/OPM		×
テキスト画面<q>Text screen</q>	○
コントラスト <wbr><q>Contrast</q>	◎
グラフィック機能全般 <wbr><q>All other graphics</q>	×	当面予定なし <q>Not scheduled</q>
Keyboard		◎	TVコントロールを除く <q>Except TV Control</q>
Mouse			◎	本体接続のみ
MFP				△
PPI (8255)		△
Printer			×
RTC				◎	アラームを除く <q>Except Alarm</q>
SPC (MB89352)	◎
SCSI HD/CD/MO Devices	○
SCC (Z8530)		◎
SRAM			◎
システムポート<q>System port</q>	△
電源 <q>Power curcuit</q>			○
Nereid Ethernet		◎
Nereid Bank memory	◎
Nereid USB			—	実装予定なし <q>Not planned</q>
拡張メモリ <q>Extended memory</q>	○
Windrv			△

NWS-1750
MPU (68030)		◎
FPU (68881)		◎	68882 は未実装 <q>68882 not implemented</q>
PROM				×
SCC (Z8530)		◎	チャンネル A のみホストに接続 <wbr><q>Only channel A is connected to the host</q>
Ethernet (AM7990)	◎
NVRAM&amp;RTC (MK48T02)	◎
Video Board		×
Keyboard/Mouse	×
SCSI Controller		×
IDROM, DIP-SW, 100Hz Timer, 診断用LED		○
AST, Lv2Intr	×
電源 <q>Power Circuit</q>	×

virt-m68k
MPU (68030)		◎
FPU (68881)		◎	68882 は未実装 <q>68882 not implemented</q>
MPU (68040)		△	キャッシュ未実装、実行サイクル未考察
Goldfish PIC	◎
Goldfish RTC	◎
Goldfish Timer	◎
Goldfish TTY	○
VirtIO Block	○
VirtIO Network		○
VirtIO Entropy	◎
<span class="new">VirtIO SCSI</span>	<span class="new">○</span>
Power Control	○

__EOM__;
	$table_lines = preg_split("/\n/", $table);
	foreach ($table_lines as $line) {
		if ($line == "") {
			continue;
		} else if (preg_match("/\t/", $line) == 0) {
			// table title
			print "<tr><td colspan=3 class=pghd>{$line}\n";
		} else {
			$t = preg_split("/\t+/", $line, 3);
			$h = isset($t[0]) ? $t[0] : "";
			$m = isset($t[1]) ? $t[1] : "";
			$d = isset($t[2]) ? $t[2] : "";
			print "<tr><td class=pgth>{$h}\n";
			print " <td class=pgtd style='padding: 0 1ex 0 1ex'>{$m}\n";
			print " <td class=pgtd style='padding-left: 0.5ex'>{$d}\n";
		}
	}
?>
</table>
</div>
<?php H5end(); ?>

<?php H5("", "MPU (68030)"); ?>
<div class="main">
68030 ATC (アドレス変換キャッシュ) は実際の仕様とは異なり高速化してあります。
<q>68030 ATC (Address Translation Cache) is differ from and faster than the real 68030.</q>
</div>
<?php H5end(); ?>

<?php H5("", "MPU (68040)"); ?>
<div class="main">
いくつか未実装の命令があります。
キャッシュは未実装で、
それに伴いキャッシュ制御を行う新設命令 CINV*, CPUSH* も未実装です。
MMU、ATC はまだ怪しいです。
FPU はある程度動作すると思いますが
例外を起こす細かい条件は未検証のため、
本来は例外が起きてソフトウェア (FPSP) で処理するはずのものが
68881 相当のハードウェアエミュレーションで実行出来てしまうという
通常あまり困らないタイプの問題は存分にあります。
<br>
<span class="new">
命令の実行サイクルについてはある程度似せているつもりですが、
そもそも 68040 はパイプライン方式なので 68000 時代のようにサイクル数を
正確にエミュレーションすることはおそらく不可能です。</span>
<br>
68040 は X68030 と virt-m68k でのみ選択可能です。
NEWS に 68040 搭載モデルはなさそうなのと、
LUNA では 68040 搭載モデルは LUNA-I ではなく LUNA-II になるからです。
</div>
<?php H5end(); ?>

<?php H5("", "LUNA の ROM エミュレーション"); ?>
<div class="main">
LUNA-I、LUNA-88K で PROM の外部イメージを指定しない場合
(<tt>prom-image</tt> が空の場合)、
内蔵の独自 ROM が動作し、コンソールモニタが起動します。
このコンソールモニタの動作は実機のそれとよく似ていますが、
これは実機確認の際に操作方法が違いすぎると(自分が)困るため仕方なく似せているもので、
忠実なコピーを作る目的ではありません。
</div>
<?php H5end(); ?>

<?php H5("", "X68030 の ROM (ROM30) エミュレーション"); ?>
<div class="main">
X68030 で ROM30 の外部イメージを指定しない場合
(<tt>iplrom2-image</tt> が空の場合)、内蔵の独自 ROM が組み込まれます。
本来の ROM30 には SCSIIOCS の他に ROM デバッガなどが含まれていますが、
内蔵 ROM はこのうち SCSIIOCS を NetBSD/x68k が起動するのに十分なだけしか
実装していません。
Human68k を起動する場合はお手元の実機から ROM イメージを作成してください。
</div>
<?php H5end(); ?>

<?php H5("", "NEWS エミュレーション"); ?>
<div class="main">
NEWS エミュレーションは今の所
<tt>-X</tt> オプションでカーネルを直接起動することしか出来ません。
PROM も NetBSD/news68k
の起動と終了に最低限必要な程度が誤魔化してあるだけです。
また、デバイスの配置や、デバイスが存在しないアドレスへのアクセスが
どうなるかなどは実機確認をしていないため分かりません。
従って、動くものは動く、程度のものでしかありません。
というかネタです。
</div>
<?php H5end(); ?>

<?php H5("", "virt-m68k エミュレーション"); ?>
<div class="main">
QEMU の "virt" (架空ハードウェア仕様)の互換機ｗをサポートしています。
NetBSD/virt68k が動作します。
<tt>-X</tt> オプション (または設定の <tt>exec-file</tt>)
でカーネルを、
設定の <tt>exec-bootparam</tt> でルートデバイスを
それぞれ指定してください。
インストール時には <tt>--initrd</tt> (または設定の <tt>exec-initrd</tt>)
で RAM ディスクイメージも指定します。
<q>Supports QEMU "virt" virtual hardware's compatible machine and
it can run NetBSD/virt68k.
You need to specify the kernel by <tt>-X</tt> option
(or <tt>exec-file</tt> in configuration).
If you want to install, you also need to specify the ramdisk image by
<tt>--initrd</tt> option (or <tt>exec-initrd</tt> in configuration).</q>
</div>
<?php H5end(); ?>

<?php H5("nereid", "シリアルコンソールの端末エミュレーション"); ?>
<div class="main">
virt-m68k (や NEWS) のようにシリアルコンソールしか持たない機種のために、
メイン画面でシリアルコンソールの端末エミュレーションを実装してあります。
<tt>hostcom-driver = cons</tt> とすることで nono のメイン画面に
シリアルコンソールの内容が表示されます。
カラーは現状サポートしていませんが、
ボールド、イタリック、下線などはある程度サポートしています。
バックログはありませんので、バックログが必要なら
<tt>stdio</tt> 等を使ってください。
</div>
<?php H5end(); ?>

<?php H5("nereid", "X68030 の Nereid エミュレーション"); ?>
<div class="main">
現実の Nereid はイーサネット/メモリ/USB の複合拡張ボードで、
このうちメモリは、メインメモリの増設に使える他、
メインメモリとして使わなかった領域をバンクメモリとして使うことも出来ます。
nono ではこの Nereid の機能のうちイーサネット (RTL8019AS)
とバンクメモリのみサポートします。
メインメモリの増設機能はエミュレータでは意味がないので実装しません。また
USB (SL811HS/T) の実装予定はありません。
<q>Nereid in the real world is a combined Ethernet/memory/USB expansion board.
Of these, the memory can be used to expand main memory,
and areas not used for the main memory can be used as bank memory.
nono supports only ethernet (RTL8019AS) and bank memory among
the functions of the Nereid expansion board.
Main memory expansion is not supported because it's meaningless on emulators.
Also, USB (SL811HS/T) is not planned for implementation.</q>
<br><br>
Nereid は DIPSW6,7 によりアドレス・割り込みベクタの組を2通り指定できるため、
2枚まで同時に運用することが出来ます。
本来 SW6 と SW7 は (衝突さえしなければ) 任意に組み合わせることが可能ですが、
nono では簡便のためボード #0 は SW6,7 が OFF、
ボード #1 は SW6,7 が ON と固定しています。
<q>Since Nereid can set to two different combinations of addresses and
interrupt vectors by DIPSW,
so up to two boards can be operated at the same time.
Originally, SW6 and SW7 can be arbitrarily combined
(as long as they don't collide), in nono however, for simpility,
SW6 and SW7 are fixed to be OFF on board #0, and
SW6 and SW7 are fixed to be ON on board #1.</q>
<blockquote>
<table border=1 rules=all>
<tr><th><th>#0 (<tt>nereid0-*</tt>)<th>#1 (<tt>nereid1-*</tt>)
<tr><td align=center>ベースアドレス・割り込みベクタ<br><q>Base address and interrupt vectors</q>
 <td>$ece300,$f9,$fb<br>(SW7=OFF)
 <td>$eceb00,$f8,$fa<br>(SW7=ON)
<tr><td align=center>バンクメモリウィンドウ<br><q>Bank memory window</q>
 <td>$ee0000<br>(SW6=OFF)
 <td>$ef0000<br>(SW6=ON)
</table>
</blockquote>
バンクメモリは、メインメモリとして使わなかった領域を使用します。
そのため実機でもバンクメモリの容量は DIPSW のメインメモリ割り当て設定
(SW1-5) に依存します。
nono に関係する結論だけでいうと、
メインメモリへの割り当てを一切行わない場合はバンクメモリは 16MB 確保でき、
メインメモリへの割り当てをいくらかでも行うとバンクメモリは 4MB となります。
設定の <tt>nereid<i>N</i>-ram-size</tt> はこの部分を指定していることになります。
またこの容量とは独立に SW8 でバンクメモリの有効・無効を指定できますので、
<tt>nereid<i>N</i>-ram-size</tt> が 0 (以下) というのは SW8
でバンクメモリを無効にしたことに相当します。
<q>Bank memory uses memory areas not used as the main memory.
So the bank memory size depends on the main memory settings (SW1-5).
As a result,
only if you don't allocate any memories to main memory,
the bank memory can be allocated 16MB.
Otherwise, the bank memory will be allocated 4MB.
Thus, <tt>nereid<i>N</i>-ram-size</tt> specifies this value.
Also, SW8 specifies enable/disable of the bank memory regardless of the size,
<tt>nereid<i>N</i>-ram-size = 0</tt> (or less) means disabling the bank memory.</q>
</div>
<?php H5end(); ?>

<?php H5("", "usermode ネットワーク"); ?>
<div class="main">
usermode ネットワークでは nono 自身が
NAT ルータ、DHCP サーバ、DNS サーバの機能を持ちます。
ルータと DHCP サーバのアドレスはネットワークアドレス +1 (デフォルトでは 10.8.0.1)、
DNS サーバのアドレスはネットワークアドレス +2 (デフォルトでは 10.8.0.2) です。
IPv6 ルータのアドレスはネットワークアドレス +1 (デフォルトでは fd08::1)、
DNS サーバのアドレスはネットワークアドレス +2 (デフォルトでは fd08::2) です。
</div>
<?php H5end(); ?>

<?php H5("netbsd-x68k-timesync", "NetBSD/x68k での時間同期"
 . "<q>Time Synchronization on NetBSD/x68k</q>"); ?>
<div class="main">
<span class="new">
X68030 でゲスト OS に NetBSD/x68k を使う場合、
nono と NetBSD/x68k を次の通りに設定すれば
nono をフルスピード動作にしてもゲスト OS の時間がずれなくなります。
まず nono の設定ファイルに以下を追加します。
<blockquote><pre class=file>
clock-sync = real
</pre></blockquote>
ゲストの NetBSD/x68k を起動し、
<tt>/etc/sysctl.conf</tt> に以下の1行を追加します。
<blockquote><pre class=file>
kern.timecounter.hardware=clockinterrupt
</pre></blockquote>
さらに <tt>/etc/rc.conf</tt> に
<blockquote><pre class=file>
ntpdate=YES
ntpdate_hosts=ntp.nict.jp
</pre></blockquote>
などと設定します (NTP サーバはお好みで)。
sysctl の設定によって、ゲスト OS の時計は「この設定が有効になった時点から」
実時間間隔を刻めますが、
電源オンからここまでにずれた分が解決できるわけではありませんので、
必然的に時計を合わせる必要もあるためです。
これで再起動すると次回からはフルスピードでも実時間を刻めます。
(再起動せずに有効にしたい場合はこの設定の後 root ユーザで
<blockquote><pre class=cons>
/etc/rc.d/sysctl start
/etc/rc.d/ntpdate start
</pre></blockquote>
を実行してください)
</span>
</div>
<?php H5end(); ?>

<?php H5("", "Windrv"); ?>
<div class="main">
X68030 で Windrv を一応サポートしています。
Human68k からホストのファイルシステムをアクセスする機構です。
従来の Windrv とはホスト OS の前提が異なるため、
既存実装からの移植ではありませんし、
そもそも Human68k とホスト(UNIX)ファイルシステムの差異による制約も多くあります。
これらを把握してから使用してください。
<ul>
<li>ファイル名は21文字すべて認識します。
22文字以上(というか 18.3 形式以外)のファイル名はゲストからは見えません。
<li>ファイル名中の ASCII 以外の文字には現状対応していません。
これらの文字を含むファイルはゲストからは見えません。
<li>マルチピリオドには対応していません。
このようなファイルはゲストからは見えません。
<li>大文字小文字は区別しません。
大文字小文字だけが違う同名のファイル (例えば a.BAK と a.bak) があると、
検索(FILES/NFILES) には現れません。
この状況で a.Bak (大文字小文字を区別していれば違うファイル)
を新規作成しようとすると (大文字小文字を区別しないゲスト OS からは
a.Bak というエントリは存在しないように見えるにも関わらず)
作成できなくしてあります。
<li>ファイルサイズが 2GB 以上のファイルはゲストからは見えません。
<li>Human68k 側の属性は A(アーカイブ)/D(ディレクトリ)/R(読み込み専用)
のみ対応しています。
S(システム)/H(隠しファイル)属性は保存されません。
<li>ホストのシンボリックリンクは、リンク先の
ファイルもしくはディレクトリとして見えます。
またリンク先が Windrv のルートパスの外側を指していても構いません。
<li>ファイルのロックには対応していません。
<li>WindrvXM.sys による拡張動作には対応していません。
windrv 互換として動作します。
<li>TwentyOne.x は現状 +T/-C/-P/-S (いずれもデフォルト) 相当だと思います。
TwentyOne.x が常駐していないとか、
これ以外のオプションの時にどうなるかは把握していません。
<li>lndrv.x によるゲスト側のシンボリックリンク機能には未対応です。
</ul>
<p></p>
Windrv を使用する場合、まず nono
の設定ファイルに <tt>windrv-path</tt> を設定します。
次にゲストの Human68k の CONFIG.SYS に WINDRV.SYS (または WindrvXM.sys)
を設定してください。
<blockquote>
<pre class=file>
DEVICE = \SYS\WINDRV.SYS
</pre>
</blockquote>
</div>
<?php H5end(); ?>

<?php H5("", "ステータスパネル <q>Status Panel</q>"); ?>
<div class="main">
ステータスパネル中央にあるパフォーマンスメータのアイコンは
高速モードの状態を表示しています。
ダブルクリックすると高速/等速モードの指定を切り替えることができます。
<q>The performance meter's icon at the center of the status panel
shows the VM speed status.
You can switch full speed / syncronized mode by double-clicking
on this icon.</q>
<table>
<tr><td valign=top>
<image src="image/sp-ffmark0.png" style="padding:0.5ex; background-color:white">
<td valign=top>…
<td valign=top>
マークなしの場合、ユーザが等速モードを指定していて、等速モードで実行中です。
<q>When no icons are displayed,
the user has specified syncronized mode and
the VM is running in synchronized mode.</q>
<tr><td valign=top>
<image src="image/sp-ffmark2.png" style="padding:0.5ex; background-color:white">
<td valign=top>…
<td valign=top>
三角3つの場合、ユーザが高速モードを指定していて、高速モードで実行中です。
高速モード中はパーセントではなく何倍速で動作しているかを表します。
<q>When an icon (three triangles) is displayed,
the user has specified full speed mode and
the VM is running in full speed mode.
<tr><td valign=top>
<image src="image/sp-ffmark1.png" style="padding:0.5ex; background-color:white">
<td valign=top>…
<td valign=top>
三角2つの場合、ユーザが高速モードを指定していて、等速モードで実行中です。
以下のいずれかの状態で起きます。
<q>When an icon (two triangles) is displayed,
the user has specified full speed mode and
the VM is running in synchronized mode.
This will happen when any of the following occurs:</q>
<ul>
<li>キー押下中(後述)あるいはキーボードブザー発声中
<q>When any keys are pressed (see below),
or the keyboard buzzer is sounding.
<li>STOP instruction on m68k.
<li>pseudo STOP state on m88k.
</ul>
</table>
</div>
<?php H5end(); ?>

<?php H5("", "DIPSW 設定ウィンドウ"); ?>
<div class="main">
DIPSW 設定ウィンドウでの変更はアプリケーション起動中のみ有効です。
またここでの設定は即 VM に反映されますが、
LUNA の場合 DIPSW の状態を
PIO(8255) がラッチするのが概ね起動時および再起動時のみとなっています
(厳密には PROM と XP が云々ですが)。
</div>
<?php H5end(); ?>

<?php H5("", "メモリダンプモニタ <q>Memory Dump Monitor</q>"); ?>
<div class="main">
メモリダンプモニタの出力形式を、バイト、ワード、ロングワード
(m88k ではそれぞれバイト、ハーフワード、ワードと表現します)
から選択できます。
また 68030/88200 の MMU ディスクリプタとして表示させることもできます
(この位置が正しいディスクリプタかどうかは関係なく表示します)。
逆アセンブルは、
LUNA-I なら m68k と HD64180 の逆アセンブルが、
LUNA-88K なら m88k と HD64180 の逆アセンブルが、
X68030/virt-m68k/NEWS なら m68k の逆アセンブルが選択できます。
<q>On memory dump monitor,
you can choose the output format from byte, word and longword
(In m88k, it is represented as byte, halfword and word respectively).
Also you can choose 68030/88200 MMU descriptor format
(It displays regardless of whether this address is used as descriptor or not).
Disassemble is now merged from disassemble monitor.
On LUNA-I, you can choose m68k and HD64180 disassemble.
On LUNA-88K, you can choose m88k and HD64180 disassemble.
On X68030/virt-m68k/NEWS,
you can choose m68k disassemble.</q>
<p>
表示されているダンプ値をダブルクリックすることでメモリの値を編集できます。
編集できるのはメモリと以下の部分のみです。
<q>You can edit the memory value by double click.
Only memory and the following areas are editable.</q>
<ul>
<li>NVRAM (LUNA and NEWS Only) …
編集するとただちにファイルも更新します。
後ろの8バイトのみ時計レジスタを兼ねているため編集不可です。
<q>The backend file is also updated immediately when edited.
The only last 8 bytes are not editable since there are the clock registers.</q>
<li>Bitmap framebuffer (LUNA Only) … 共通プレーンは書き込み不可です。
<q>The common plane is not editable.</q>
<li>SRAM (X68030 Only) …
編集するとただちにファイルも更新します。
<q>The backend file is also updated immediately when edited.</q>
<li>TVRAM とテキストパレット (X68030 Only) <q>Text VRAM and text palette</q>
</ul>
</div>
<?php H5end(); ?>

<?php H5("", "デバイスマップモニタ <q>Device Map Monitor</q>"); ?>
<div class="main">
m68k/m88k バスに接続されているデバイスを表示します。
32ビットアドレスのうち上位 8 ビット、256個分を表示しています。
1枠が 16MB になります。
また、X68030 ではこのうち 24ビット空間を別モニタで表示します。
こちらは 1枠 8KB x 2048個です。
どちらも内部構造を表示しているだけなので名前に馴染みがない場合があるかもしれません。
NEWS のデバイスマップは内部構造の都合上、
内部状態を正確に反映していないケースがあるかも知れません。
</div>
<?php H5end(); ?>

<?php H5("", "キー入力モード <q>Key input mode</q>"); ?>
<div class="main">
LUNA も X68030 もキーボードは通常日本語キーボードです
(LUNA には英語キーボードも存在するようですが…)。
そのため、ホストが日本語キーボードの場合とそうでない場合のために
2つの入力モードを用意しています。
どちらも一長一短があります。
<q>LUNA and X68030 has the Japanese keyboard
(though I ever heard there are US keyboard for LUNA...).
So nono provides two input modes
for Japanese keyboard users and non Japanese keyboard users.
Both have advantages and disadvantages.</q>
<p>
JP キーボードモードは、ホストが日本語キーボードであることを前提に
対応するキーの押下、開放をその都度 VM に入力します。
メリットとしては動作が実機に近くなり、
特にキーリピート(をハードウェアが行わないこと)も忠実に再現可能です。
デメリットは ALT + TAB やアクセラレータキーでメニューを開く場合などに
キー入力が残ることがあることです
(キーを押した後でフォーカスが外れるとキーを離したことが
アプリケーションに通知されないため)。
またホストが日本語キーボードでなければ使いづらいです。
<q>JP keyboard mode assumes that the host uses the Japanese keyboard.
Each time you presses and releases a key,
nono sends the corresponding key-pressed or key-released to the VM.
One advantage is that it's close to the real machine behavior,
and another is that it can reproduce
the LUNA keyboard itself does not perform a key repeat.
On the other hand,
one disadvantage is that key sometimes remains pressed,
especially when you enter ALT + TAB to switch the application
or enter accelerator key to open the menu
(If the application loses the focus after the key is pressed,
the application will not receive the subsequent key release).
And another disadvantage is that
it will be hard to use for non Japenese keyboard users.</q>
<p>
一方、キャラクタ入力モードは、ホストから入力された「文字」を
再び LUNA/X68030 のキーコードに解釈し直して VM に入力するモードです。
例えばゲスト OS に "@" を入力したい場合、
US キーボードなら [SHIFT] + [2] を、
JP キーボードなら [@] キーを押しますが、
どちらも VM には [@] キーの押下、[@] キーの開放が連続して送られます。
US キーボードで [SHIFT] を押したことは通知されません。
逆に "=" を入力したい場合、
US キーボードなら [=] キーを、
JP キーボードなら [SHIFT] + [-] を押しますが、
どちらも VM には
[SHIFT]押下 → [-]押下 → [-]開放 → [SHIFT]開放のシーケンスが送られます。
このようにホストキーボードのレイアウトによらず、
入力したい文字が入力できるようになり、
通常のタイピングで困ることはないと思います。
デメリットは、通常の文字入力以外のタイピングはほぼ出来ないことです。
[SHIFT] キーを押したままにすることや、
文字が入力できないキーの組み合わせは入力出来ません。
もう一つのデメリットはキーリピート(をハードウェアが行わないこと)が再現できず、
ホスト側のキーリピートが効いてしまうことです
(本来キーリピートが動作しない ROM やブートローダでもキーリピートが効くことは
一般ユーザからはメリットに感じられるかも知れませんが)。
<q>In contrast, in the character mode, when you type a character,
nono re-converts it into the LUNA/X68030's key code and sends it to the VM.
For example if you want to type "@" in the guest OS,
you would press [SHIFT] + [2] on the US keyboard or [@] on the JP keyboard.
In both cases, the sequence of
[@]-pressed and [@]-released will be sent to the VM.
Note that the fact that you pressed [SHIFT] key on the US keyboard
will not be sent to the VM.
Another example, if you want to type "=",
you would press [=] on the US keyboard or [SHIFT] + [-] on the JP keyboard.
In both cases, the sequence of
[SHIFT]-pressed, [-]-pressed, [-]-released, and [SHIFT]-released
will be sent to the VM.
Thus, you can type what character you want to type,
regardless of your keyboard layout.
Of course there are some disadvantages.
Firstly, it's hard to type any special characters,
for example, you can not type any key conbinations
that don't generate a character.
Or you can not hold [SHIFT] key pressed.
Secondly, the key repeat works (by the host),
even though it should not work as a correct emulation
(Although some of you may feel it an advantage).</q>
</div>
<?php H5end(); ?>

<?php H5("","キャラクタ入力モードのキーコード対応表 " .
	"<q>Keycode table in the character mode</q>"); ?>
<div class="main">
キャラクタ入力モードでの、ホストから入力した文字と
VM に送信されるキーの対応は次の通りです。
ファンクションキーとカーソルキーは文字ではありませんが
特別に対応しています。
ここに記載のないゲストキーはソフトウェアキーボードからのみ入力できます。
<q>The following table shows the correspondence between
the character that typed from the host
and the key that will be sent to the VM.
nono can recognize the function keys and arrow keys.
The keys that not listed in this table can
only be typed from the software keyboard window.</q>
<p>
<center>
<style type="text/css">
.keytable-whole {
	display: inline-block;
	vertical-align: top;
	border-bottom: solid 1px;
}
.keytable-middle {
	margin-left: 1em;
	margin-right: 1em;
}

.keytable-head {
	text-align: left;
	border-top:    solid 1px;
	border-bottom: solid 1px;
}
.keytable-headl {
	padding-right: 1em;
	border-left:   solid 1px;
	border-right:  solid 1px;
}
.keytable-headr {
	border-right:  solid 1px;
}

.keytable-tdl {
	padding-right: 1em;
	border-left:   solid 1px;
	border-right:  solid 1px;
}
.keytable-tdr {
	border-right:  solid 1px;
}
</style>
<?php
	$str = <<<__EOM__
		<tt>a</tt> 〜 <tt>z</tt>	[A] 〜 [Z]
		<tt>0</tt> 〜 <tt>9</tt>	[0] 〜 [9]
		SPACE		[SPACE]
		<tt>-</tt>	[-]
		<tt>^</tt>	[^]
		<tt>&bsol;</tt>	[&bsol;]
		<tt>@</tt>	[@]
		<tt>[</tt>	[[]
		<tt>;</tt>	[;]
		<tt>:</tt>	[:]
		<tt>]</tt>	[]]
		<tt>,</tt>	[,]
		<tt>.</tt>	[.]
		<tt>/</tt>	[/]

		<tt>A</tt> 〜 <tt>Z</tt>	[SHIFT]+[A] 〜 [SHIFT]+[Z]
		<tt>!</tt>	[SHIFT]+[1]
		<tt>"</tt>	[SHIFT]+[2]
		<tt>#</tt>	[SHIFT]+[3]
		<tt>$</tt>	[SHIFT]+[4]
		<tt>%</tt>	[SHIFT]+[5]
		<tt>&amp;</tt>	[SHIFT]+[6]
		<tt>'</tt>	[SHIFT]+[7]
		<tt>(</tt>	[SHIFT]+[8]
		<tt>)</tt>	[SHIFT]+[9]
		<tt>=</tt>	[SHIFT]+[-]
		<tt>~</tt>	[SHIFT]+[^]
		<tt>|</tt>	[SHIFT]+[&bsol;]
		<tt>`</tt>	[SHIFT]+[@]
		<tt>{</tt>	[SHIFT]+[[]
		<tt>+</tt>	[SHIFT]+[;]
		<tt>*</tt>	[SHIFT]+[:]
		<tt>]</tt>	[SHIFT]+[]]
		<tt>&lt;</tt>	[SHIFT]+[,]
		<tt>&gt;</tt>	[SHIFT]+[.]
		<tt>?</tt>	[SHIFT]+[/]
		<tt>_</tt>	[SHIFT]+[_]

		F1 〜 F10	[PF1] 〜 [PF10]
		F11		[PF10]
		↑		[↑]
		←		[←]
		→		[→]
		↓		[↓]
		<tt>^@</tt>	[CTRL]+[@]
		<tt>^A</tt> 〜 <tt>^Z</tt>	[CTRL]+[A] 〜 [CTRL]+[Z]
		<tt>^[</tt>	[ESC]
		<tt>^\</tt>	[CTRL]+[&bsol;]
		<tt>^]</tt>	[CTRL]+[]]
		<tt>^^</tt>	[CTRL]+[^]
		<tt>^_</tt>	[CTRL]+[_]
		<tt>^H</tt>	[BS]
		<tt>^I</tt>	[TAB]
		<tt>^M</tt>	[Enter]
__EOM__;
	$table = array();
	$table[0] = array();
	$table[1] = array();
	$table[2] = array();
	$i = 0;
	foreach (explode("\n", $str) as $s) {
		if ($s == "") {
			$i++;
			continue;
		}
		$s = preg_replace("/^\t+/", "", $s);
		list ($hkey, $gkey) = preg_split("/\t+/", $s);
		$table[$i][] = array($hkey, $gkey);
	}

	for ($j = 0; $j < count($table); $j++) {
		switch ($j) {
		 case 0:	$classname = "left";	break;
		 default:	$classname = "middle";	break;
		 case 3:	$classname = "right";	break;
		}
		print "<table class='keytable-whole keytable-${classname}'";
		print " cellspacing=0 cellpadding=1>\n";
		print "<tr>";
		print "<th class='keytable-head keytable-headl'>HostChar";
		print "<th class='keytable-head keytable-headr'>GuestKey\n";
		for ($i = 0; $i < count($table[$j]); $i++) {
			list ($h, $g) = $table[$j][$i];
			print "<tr>";
			print "<td class='keytable-tdl'>{$h}";
			print "<td class='keytable-tdr'>${g}\n";
		}
		print "</table>\n";
	}
?>
</center>
</div>
<?php H5end(); ?>

<?php H5("", "JP キーボードモードのキーコード対応表 " .
	"<q>Keycode table in the JP keyboard mode</q>"); ?>
<div class="main">
JP キーボードモードでの、ホストキーと VM に送信されるキーの対応は次の通りです。
ここに記載のないキーはソフトウェアキーボードからのみ入力出来ます。
<q>The following table shows the correspondence between
the host key and the guest key.
The keys that not listed in this table can only be entered from
the software keyboard window.</q>
<p>
<center>
<?php
	$str = <<<__EOM__
		[0] 〜 [9]		[0] 〜 [9]
		[A] 〜 [Z]		[A] 〜 [Z]
		[-]				[-]
		[^]				[^]
		[&bsol;]		[&bsol;]
		[@]				[@]
		[[]				[[]
		[;]				[;]
		[:]				[:]
		[]]				[]]
		[,]				[,]
		[.]				[.]

		[/]				[/]
		[_]				[_]
		[ESC]			[ESC]
		[TAB]			[TAB]
		[CTRL]			[CTRL]
		[SHIFT-L]		[SHIFT-L]
		[SHIFT-R]		[SHIFT-R]
		[Enter]			[Enter]
		[↑]			[↑]
		[←]			[←]
		[→]			[→]
		[↓]			[↓]

		[BS]			[BS]
		[Delete]		[DEL]
		[F1] 〜 [F10]	[PF1] 〜 [PF10]
		[F11]			[PF10]
		Numpad[0]〜[9]	Numpad[0]〜[9]
		Numpad[+]		Numpad[+]
		Numpad[-]		Numpad[-]
		Numpad[*]		Numpad[*]
		Numpad[/]		Numpad[/]
		Numpad[=]		Numpad[=]
		Numpad[.]		Numpad[.]
		Numpad[Enter]	Numpad[Enter]

		[Home]			[HOME]
		[Insert]		[INS]
		[PageUp]		[ROLL UP]
		[PageDown]		[ROLL DOWN]
		[End]			[UNDO]
__EOM__;
	$table = array();
	$table[0] = array();	// 1段目(共通)
	$table[1] = array();	// 1段目(共通)
	$table[2] = array();	// 1段目(共通)
	$table[3] = array();	// 2段目(X68030)
	$i = 0;
	foreach (explode("\n", $str) as $s) {
		if ($s == "") {
			$i++;
			continue;
		}
		$s = preg_replace("/^\t+/", "", $s);
		list ($hkey, $gkey) = preg_split("/\t+/", $s);
		$table[$i][] = array($hkey, $gkey);
	}

	for ($j = 0; $j < count($table); $j++) {
		if ($j == 3) {
			print "<br>\n";
		}

		$caption = "";
		switch ($j) {
		 case 0:	$classname = "left";	break;
		 case 1:	$classname = "middle";	break;
		 case 2:	$classname = "right";	break;
		 case 3:	$classname = "left";	$caption = "(X68030 Only)";	break;
		}
		print "<table class='keytable-whole keytable-${classname}'";
		print " cellspacing=0 cellpadding=0>\n";
		if ($caption != "") {
			print "<caption>{$caption}</caption>\n";
		}
		print "<tr>";
		print "<th class='keytable-head keytable-headl'>HostKey";
		print "<th class='keytable-head keytable-headr'>GuestKey\n";
		for ($i = 0; $i < count($table[$j]); $i++) {
			list ($h, $g) = $table[$j][$i];
			print "<tr>";
			print "<td class='keytable-tdl'>{$h}";
			print "<td class='keytable-tdr'>${g}\n";
		}
		print "</table>\n";
	}
?>
</center>
</div>
<?php H5end(); ?>

<?php H5("", "キーリピート <q>Key Repeat</q>"); ?>
<div class="main">
LUNA では、キーボードがハードウェア側でキーリピートを行わず、
ソフトウェア(OS など)がキーリピートの処理を行います。
そのため、キーリピートを実装していない LUNA の PROM や
NetBSD/luna68k のブートローダではキーリピートは起きず、
キーリピートを実装している NetBSD/luna68k カーネルではキーリピートが起こせます。
キーリピートを起こす間隔をゲストのソフトウェアが測定しているということは、
VM が高速動作するとキーリピートもそれに合わせて発生することになり、
これをホスト側から防ぐ手段はありません。
そこで nono ではキー入力が発生している間
(キーが一つでも押されてからキーが全て離されるまでの間)、
高速モードが指示されていても VM を一時的に等速モードに落として実行します。
上記のアイコンがそれを区別しているのはこのためです。
そのため、何らかの理由でキーが入りっぱなしになった場合
(ALT + TAB やアクセラレータキーでメニューを開くと起きがちです)
高速モードが抑制されたままということが起きえます。
その場合はソフトウェアキーボードからキー入力を解除するなどしてください。
<q>On LUNA,
key repeat is done by software(OS), not by the keyboard hardware.
For this reason,
key repeat doesn't occur on LUNA's PROM or NetBSD/luna68k's bootloader
that don't implement it, and
key repeat occurs on NetBSD/luna68k kernel that implements it.
Since the timing of key repeat is measured by the guest software,
if the VM is running faster than the real,
the key repeat will occur faster, too.
The host application doesn't have the way to avoid it.
Therefore, nono will temporarily suppress the full speed mode
while any keys are pressed.
That is why the above-mentioned icon distinguishes them.
If keys continue to be pressed for some reasons,
the VM also continues to run syncronized mode.
In this case, you can resolve it by using the software keyboard window.</q>
</div>
<?php H5end(); ?>
<?php H4end(); ?>


<?php H4("tryit", "実行してみる <q>Try it</q>"); ?>
<?php H5("", "NetBSD/luna68k を実行してみる <q>Try NetBSD/luna68k</q>"); ?>
<div class="main">
つついさんが NetBSD/luna68k 9.2 の liveimage を用意されています。
<q>Tsutsui-san has provided a liveimage of NetBSD/luna68k 9.2.</q>
<dl>
<dd><a href="https://twitter.com/tsutsuii/status/1436381589211017217"
>https://twitter.com/tsutsuii/status/1436381589211017217</a><br>
</dl>
ここではこれを起動してみます。<q>Let's try it.</q>
<br>
<ol>
<li>どこかに nono 用のディレクトリを用意し(例えば ~/nono/)、
その中に VM ディレクトリを用意します (例えば ~/nono/luna/)。
<q>Create a directory somewhere for nono (for example ~/nono/),
and create subdirectories for individual VMs in it
(for example ~/nono/luna/).</q>

<li>以下のリンクからイメージファイルをダウンロードして展開し、
VM ディレクトリ ~/nono/luna/ に置きます。
<q>Download imagefile from the following link,
extract it and place it in the VM directory, ~/nono/luna/.</q>
<blockquote>
<a href="http://teokurebsd.org/netbsd/liveimage/20210910-luna68k/"
>http://teokurebsd.org/netbsd/liveimage/20210910-luna68k/</a>
</blockquote>

<li>以下の内容の設定ファイル nono.cfg を VM ディレクトリ ~/nono/luna/
に作成します。
<q>Create a configuration file nono.cfg in the VM directory, ~/nono/luna/,
with following contents.</q>
<blockquote class="file"><pre>
vmtype = luna
spc0-id6-image = hd,liveimage-luna68k-with-packages-20210910.img
</pre></blockquote>

<li><tt>nono -c ~/nono/luna</tt> で起動します
(VM ディレクトリに自動的に NVRAM.DAT が作られます)。
<q>Run as <tt>nono -c ~/nono/luna</tt>.
(NVRAM.DAT will be created automatically in the VM directory)</q>

<li>Emulated ROM Monitor が起動するので、
初回は以下のように入力すると NetBSD が起動します。
<q>The emulated ROM Monitor will be executed.
Then, only for the first time,
entering the following can boot NetBSD.</q>
<blockquote><pre>
k&#x23ce;
&#x23ce;
&#x23ce;
d&#x23ce;
boot&#x23ce;
g&#x23ce;
x&#x23ce;
</pre></blockquote>
画面はこんな感じのはずです (太字が入力部分)。
<q>You will see a screen like this.  The bold text indicates
the characters you need to enter.</q>
<blockquote class="file"><pre>
NONO <?=$nono_ver?> Emulated ROM Monitor for LUNA-I

** NVRAM Initialized.

&gt;<b>k&#x23ce;</b>
controller: dk  ?<b>&#x23ce;</b>
drive unit: 0  ?<b>&#x23ce;</b>
partition : c  ?<b>d&#x23ce;</b>
filename  : vmunix  ?<b>boot&#x23ce;</b>
&gt;<b>g&#x23ce;</b>
Loaded.  Entry point = $00700000
&gt;<b>x&#x23ce;</b>
</pre></blockquote>
この内容は NVRAM.DAT に記録されているので次回以降は直接 NetBSD が起動します。
<q>The information you have just entered is recorded in the NVRAM,
so next time it will boot NetBSD automatically.</q>
<li>初回起動時、
Updating fontconfig cache はあほみたいに時間がかかりますが、
nono がハングアップしてるわけではありません(>_<)。
また初回は起動後数時間めちゃくちゃ重たいですが、
これはバックグラウンドで makemandb が動くためで
nono のせいではありません(>_<)。
<q>At the first boot, you will see the console stops after printing
"Updating fontconfig cache".
This is because the infamous fontconfig takes very looooong time.
nono would not have hang-up.
In addition, at the first boot, you will feel it's too heavy for several hours.
This is because the infamous makemandb(8) runs heavily in the background
for a looooong time.
It's very sad to me that these two accidents which are far from the ideal
are the first experiences of newcomers.</q>

<li>終了する時は root
ユーザで &ldquo;<tt>shutdown -p now</tt>&rdquo; を実行してください。
LUNA はソフトウェアから電源オフでき、
VM の電源オフで nono も終了します。
<q>To quit, type &ldquo;<tt>shutdown -p now</tt>&rdquo; as the root user.
LUNA can be powered off by software,
and nono will terminate when the VM is powered off.</q>
</ol>
</div>
<?php H5end(); ?>

<?php H5("", "OpenBSD/luna88k を実行してみる <q>Try OpenBSD/luna88k</q>"); ?>
<div class="main">
あおやまさんが OpenBSD/luna88k 7.6 の liveimage を用意されています。
<q>Aoyama-san has provided a liveimage of OpenBSD/luna88k 7.6.</q>
<dl>
<dd><a href="https://bsd.network/@ao_kenji/113300210182705408"
>https://bsd.network/@ao_kenji/113300210182705408</a>
</dl>
ここではこれを起動してみます。<q>Let's try it.</q>
<br>
<ol>
<li>どこかに nono 用のディレクトリを用意し(例えば ~/nono/)、
その中に VM ディレクトリを用意します (例えば ~/nono/luna88k/)。
<q>Create a directory somewhere for nono (for example ~/nono/),
and create subdirectories for individual VMs in it
(for example ~/nono/luna88k/).</q>

<li>以下のリンクから liveimage-luna88k-raw-20241013.img.gz
をダウンロードして展開し、
VM ディレクトリ ~/nono/luna88k/ に置きます。
<q>Download liveimage-luna88k-raw-20241013.img.gz from the following link,
extract it and place it in the VM directory, ~/nono/luna88k/.</q>
<blockquote>
<a href="http://www.nk-home.net/~aoyama/liveimage/"
>http://www.nk-home.net/~aoyama/liveimage/</a>
</blockquote>

<li>以下の内容の設定ファイル nono.cfg を VM ディレクトリ ~/nono/luna88k/
に作成します。
<q>Create a configuration file nono.cfg in the VM directory, ~/nono/luna88k/,
with following contents.</q>
<blockquote class="file"><pre>
vmtype = luna88k
spc0-id6-image = hd,liveimage-luna88k-raw-20241013.img
</pre></blockquote>

<li><tt>nono -c ~/nono/luna88k</tt> で起動します
(VM ディレクトリに自動的に NVRAM.DAT が作られます)。
<q>Run as <tt>nono -c ~/nono/luna88k</tt>.
(NVRAM.DAT will be created automatically in the VM directory)</q>
<li>Emulated ROM Monitor が起動するので、
初回は以下のように入力すると OpenBSD が起動します。
<q>The emulated ROM Monitor will be executed.
Then, only for the first time,
entering the following can boot OpenBSD.</q>
<blockquote><pre>
nvram boot_filename boot&#x23ce;
y
b&#x23ce;
</pre></blockquote>
画面はこんな感じのはずです (太字が入力部分)。
<q>You will see a screen like this.  The bold text indicates
the characters you need to enter.</q>
<blockquote class="file"><pre>
NONO <?=$nono_ver?> Emulated ROM Monitor for LUNA-88K

** NVRAM Initialized.

N&gt;<b>nvram boot_filename boot&#x23ce;</b>
Update boot_filename : "vmunix" -&gt; "boot" (Y/[N]):<b>y</b>
Updated
N&gt;<b>b&#x23ce;</b>
</pre></blockquote>
この内容は NVRAM.DAT に記録されているので次回以降は直接 OpenBSD が起動します。
<q>The information you have just entered is recorded in the NVRAM,
so next time it will boot OpenBSD automatically.</q>

<li>終了する時は root
ユーザで &ldquo;<tt>shutdown -p now</tt>&rdquo; を実行してください。
LUNA-88K はソフトウェアから電源オフでき、
VM の電源オフで nono も終了します。
<q>To quit, type &ldquo;<tt>shutdown -p now</tt>&rdquo; as the root user.
LUNA-88K can be powered off by software,
and nono will terminate when the VM is powered off.</q>
</ol>
</div>
<?php H5end(); ?>


<?php H5("", "NetBSD/x68k を実行してみる <q>Try NetBSD/x68k</q>"); ?>
<div class="main">
つついさんが NetBSD/x68k 10.1 の liveimage を用意されています。
ここではこれを起動してみます。
<q>Tsutsui-san has provided a liveimage of NetBSD/x68k 10.1.
Let's try it.</q>
<br>
<ol>
<li>どこかに nono 用のディレクトリを用意し(例えば ~/nono/)、
その中に VM ディレクトリを用意します (例えば ~/nono/x68k/)。
<q>Create a directory somewhere for nono (for example ~/nono/),
and create subdirectories for individual VMs in it
(for example ~/nono/x68k/).</q>

<li>以下のサイトから
「パッケージインストール設定済み版」か
「インストーラでインストールしたところまでの未設定版」の
お好みのほうをダウンロードします。
迷ったら「パッケージインストール設定済み版」がよいでしょう。
ダウンロードできたら展開して、VM ディレクトリ ~/nono/x68k/ に置きます。
<q>Download your favorite one of with-packages or plain-install
from the following site.
Extract it and place it in the VM directory, ~/nono/x68k/.</q>
<blockquote>
<a href="http://www.ceres.dti.ne.jp/tsutsui/netbsd/liveimage/x68k.html"
>http://www.ceres.dti.ne.jp/tsutsui/netbsd/liveimage/x68k.html</a>
</blockquote>

<li>以下の内容の設定ファイル nono.cfg を VM ディレクトリ ~/nono/x68k/
に作成します。
<q>Create a configuration file nono.cfg in the VM directory, ~/nono/x68k/,
with following contents.</q>
<blockquote class="file"><pre>
vmtype = x68030
spc0-id0-image = hd,liveimage-x68k-with-packages-20250106.hds
</pre></blockquote>

<li>初回のみ <tt>nono -c ~/nono/x68k --create-sram</tt> を実行します。
これで VM ディレクトリに初期状態の SRAM.DAT が作られます。
<q>Only the first time, run as <tt>nono -c ~/nono/x68k --create-sram</tt>.
This will create an initial SRAM.DAT in the VM directory.</q>

<li><tt>nono -c ~/nono/x68k</tt> で起動すると、
HDD から NetBSD/x68k が起動します。
次回以降はこれだけで直接 NetBSD が起動します。
<q>Again, run as <tt>nono -c ~/nono/x68k</tt>.
NetBSD/x68k will be booted from HDD.
Next time, it will boot NetBSD automatically.</q>

<li>初回起動後数時間はめちゃくちゃ重たいですが、
これはバックグラウンドで makemandb が動くためで
nono のせいではありません(>_<)。
<q>At the first boot, you will feel it's too heavy for several hours.
This is because the infamous makemandb(8) runs heavily in the background
for a looooong time.
It's very sad to me that the accident which is far from the ideal
is the first experiences of newcomers.</q>

<li>NetBSD が起動した後なら (正確には powerd(8) が起動していれば)、
終了する時はメニューの「デバイス &gt; 操作 &gt; 電源ボタンを押す」
でシャットダウンして電源オフになり、
VM の電源オフで nono も終了します。
<q>After NetBSD boots up (more precisely, if powerd(8) is running),
you can shutdown and power off by
"Device &gt; Operation &gt; Push Power button" on menu,
and nono will terminate when the VM is powered off.</q>
</ul>
</div>
<?php H5end(); ?>


<?php H5("", "NetBSD/virt68k をインストールしてみる"
	. " <q>Try installing NetBSD/virt68k</q>"); ?>
<div class="main">
ここでは NetBSD/virt68k をクリーンインストールする手順だけ紹介します。
<q>Here I will introduce how to install NetBSD/virt68k cleanly.</q>
<br>
<ol>

<li>どこかに nono 用のディレクトリを用意し(例えば ~/nono/)、
その中に VM ディレクトリを用意します (例えば ~/nono/virt68k/)。
<q>Create a directory somewhere for nono (for example ~/nono/),
and create subdirectories for individual VMs in it
(for example ~/nono/virt68k/).</q>

<li>NetBSD/virt68k のインストールセットはまだ用意されてないようなので、
NetBSD のソースコードから build.sh でビルドします。
<q>There doesn't seem to be the official NetBSD/virt68k set available yet.
You have to build it manually from the source code using build.sh. :(</q>

<li>インストーラを起動するカーネルとその後運用するカーネルは同じものなので
VM ディレクトリ内に持ってきておくとよいです。
<q>The kernel used for installation and the kernel used for operation
are the same.
So it would be good idea to bring it into the VM directory at this point.</q>
<blockquote class="cons"><pre>
cp &lt;path&gt;/release/virt68k/binary/kernel/netbsd-GENERIC.gz ~/nono/virt68k/
</pre></blockquote>

<li>空のディスクイメージを用意します。
1GB でもインストール自体は出来ますが、もう少し大きいほうが安心です。
<q>Prepare an empty disk image file.
You can install it with 1GB at least,
but it would be safer if it was a little larger.</q>
<blockquote class="cons"><pre>
dd if=/dev/zero of=virt68k.img bs=1m count=2048
</pre></blockquote>

<li>以下の内容の設定ファイル nono.cfg を VM ディレクトリ ~/nono/virt68k
に作成します。
<q>Create a configuration file nono.cfg in the VM directory, ~/nono/virt68k/,
with following contents.</q>
<blockquote class="file"><pre>
vmtype = virt-m68k
exec-file = netbsd-GENERIC.gz
exec-bootparam = root=ld0
virtio-block0-image = virt68k.img
fast-mode = 1
</pre></blockquote>

<li>インストーラ RAM ディスクを指定してインストーラを起動します。
設定ファイルでルートデバイスを ld0 に指定していますが、
RAM ディスク指定のほうが優先されるようです。
<q>Run the installer by specifying installer RAM disk.
By the way, configuration file specifies root device as ld0,
but RAM disk specified by the command line will take precedence.</q>
<blockquote class="cons"><pre>
nono -c ~/nono/virt68k \
 --initrd &lt;path&gt;/release/virt68k/installation/ramdisks/inst-ramdisk.fs
</pre></blockquote>

<li>しばらくすると見慣れたインストーラが起動してきます。
インストールが終わったらトップメニューから e:Utility menu &gt;
g:Halt the system
を選択してください。ゲストの電源がオフになり nono も終了します。
<q>After a while, the familiar installer will start.
Once the installation has finished,
choose e:Utility menu &gt; g:Halt the system.
Then the guest will shut down, and nono also will terminate.</q>

<li>インストールしたディスクから起動するには、
<tt>--initrd</tt> オプションを外して実行します。
カーネルは引き続きホストファイルシステム上にあるもの
(ここでは ~/nono/virt68k/netbsd-GENERIC.gz) を使います。
<q>To boot from the installed disk,
run without <tt>--initrd</tt> option.
It still uses the kernel on the host filesystem,
just like the installer does.</q>
<blockquote class="cons"><pre>
nono -c ~/nono/virt68k
</pre></blockquote>
</ul>
</div>
<?php H5end(); ?>
<?php H4end(); ?>


<?php H4("network",
	"ホストネットワーク設定例 <q>Example of host network setup</q>"); ?>
<?php H5("network-tap", "tap"); ?>
<div class=main>
NetBSD の tap(4) デバイスを用いて、
ホストの wm0 と nono のゲスト OS を接続する場合の設定例です。
<ol>
<li>
設定ファイル nono.cfg に以下の行を追加します。
<q>Add the following line to configuration file, nono.cfg.</q>
<blockquote class="file"><pre>
hostnet-driver = tap
hostnet-tap-devpath = auto
</pre></blockquote>

<li>デフォルトでは /dev/tap は一般ユーザからアクセスできないので、
chmod で適当にパーミッションを与えます。
番号の付いていないほうの /dev/tap だけでいいです。
sysinst 等で OS をアップグレードするとパーミッションが 600
に戻るのがハマりポイントです。
<q>By default, /dev/tap is only accessible to privileged user.
You need to chmod /dev/tap (without unit number) appropriately.
Note that upgrading using sysinst always resets the permission to 600.</q>

<li>bridge(4) インタフェースを作成し、
ホストの外部(物理)インタフェースをブリッジに追加しておきます。
<q>Create a bridge(4) interface, and
add your physical interface to the bridge.</q>
<blockquote class="cons"><pre>
# ifconfig bridge0 create
# brconfig bridge0 add wm0
</pre></blockquote>
常用するなら /etc の設定ファイルに書いておきましょう。
<q>If you use it regularly,
you can put configuration file into /etc.</q>
<blockquote>
/etc/ifconfig.bridge0
<pre class=file>
create
up
!/sbin/brconfig $int add wm0
</pre>
<pre class=cons>
# /etc/rc.d/network restart
</pre>
</blockquote>

<li>
一般ユーザに戻って、
VM ディレクトリかその親ディレクトリに
次のような 2つのスクリプトを用意します。
nono は tap(4) をオープンし、
そのデバイス名を引数にこれらのスクリプトを呼びます。
sudo の設定は別途行ってください。
<q>Return to non-privileged user, and
create following two scripts in the VM directory or its parent directory.
nono will open tap(4) and
invoke these scripts with the name of the device as an argument.
In addition, you need to set up sudo separately.</q>
<blockquote>
nono-ifup
<pre class=file>
#!/bin/sh
sudo /sbin/ifconfig $1 up
sudo /sbin/brconfig bridge0 add $1
</pre></blockquote>

<blockquote>
nono-ifdown
<pre class=file>
#!/bin/sh
sudo /sbin/brconfig bridge0 delete $1
sudo /sbin/ifconfig $1 down
</pre></blockquote>

<blockquote class="cons"><pre>
% chmod +x nono-ifup nono-ifdown
</pre></blockquote>

<li>nono を起動し、
メニューの「モニタ &gt; ホスト &gt; ホストネットワーク」を開いて
HostNet Driver: tap になっていれば動いてるはずです。
<q>Run nono,
and open "Monitor &gt; Host &gt; Host Network" window from menu.
It's OK if you can see "HostNet Driver: tap".</q>

</ol>
</div>
<?php H5end(); ?>
<?php H4end(); ?>


<?php H4("knownissues", "既知の問題 <q>Known Issues</q>"); ?>
<div class="main">
<ul>
<li>デバッガのコンソール入力で、
カーソルキーなどの特殊文字入力に対する表示が動作していません。
<q>In debugger console, some special characters like cursor keys
aren't printed correctly.</q>
(since ver 0.3.0)
<li>ホストが VirtualBox (on Windows?) で、
VirtualBox の「マウス統合」が有効にしている場合、
nono の「マウスモード」でマウスポインタが正しく移動しません。
<q>If the host OS is running on VirtualBox (on Windows?) and
"Mouse integration" on VirtualBox is enabled,
the mouse pointer will not move as expected in nono's Mouse Mode.</q>
(2021/12/30)

<li>Wayland の場合にウィンドウサイズが正しく設定されない場合があります。
wxWidgets (3.0/3.2) のバグと思われます。
<q>On Wayland, window size may be incorrect.
This may be due to wxWidgets (3.0/3.2) bug.</q>
(2021/12/30, Updated 2024/07/03)

<li>nono ではありませんが、wxWidgets 3.2 (with GTK3) は
NetBSD/sparc (などマイナーアーキテクチャ?)
でウィンドウ内がほぼ描画されないようです。
wxWidgets 3.0 (with GTK2) であれば動作します。
<q>On wxWidgets 3.2 (with GTK3), it seems that the inside of the window
is hardly drawn at NetBSD/sparc (and such minor architectures?).
wxWidgets 3.0 (with GTK2) can.</q>
(2024/07/03)

</ul>
</div>
<?php H4end(); ?>


<?php H4("migrate",
	"過去のバージョンからの移行方法 <q>How to migrate from old versions</q>");
?>
<div class="main">
バージョンアップに伴い設定ファイル等に非互換が発生する場合があります。
その場合は以下の移行方法を参照して設定ファイル等を更新してください。
<q>Some versions may have incompatibilities in the configuration files, etc.
In such case, you may need to upgrade it by referring the following link.</q>
<ul>
<li><a href="upgrade-0.3.0.html">From ver 0.2.x to ver 0.3.0</a>
<li><a href="upgrade-0.2.0.html">From ver 0.1.x to ver 0.2.0</a>
</ul>
</div>
<?php H4end(); ?>


<?php H4("util", "付属ソフトウェア <q>Included Software</q>"); ?>
<div class="main">
<ul>
<li><?php linkto("runx", "runx"); ?>
</ul>
</div>
<?php H4end(); ?>


<?php H4("changes", "変更履歴 <q>Changes</q>"); ?>
<div class="main">
See <?php linkto("changes", "changes.html"); ?>.
</div>
<?php H4end(); ?>


<?php H4("license", "連絡先、ライセンス等 <q>Contact, License, etc</q>"); ?>

<?php H5("", "ライセンス <q>License</q>"); ?>
<div class="main">
<ul>
<li>
nono 自身については
<a href="nono-license.txt">nono-license.txt</a> を読んでください。
<q>See nono-license.txt about nono itself.</q>
<li>
nono は無償公開されている X68030 の IPLROM を使用しています。
<a href="fsharp-license.txt">許諾条件</a>を読んでください。
<q>nono uses X68030 IPLROM image distributed without charge.
You must read
<a href="fsharp-license.txt">the license agreement</a>
(even though it's Japanese original text only).</q>
<li>
nono は SIL Open Font License version 1.1 で配布されているフォントの
一部を改変して組み込んでいます。
<q>nono modifies and embeds the font distributed as SIL Open Font License version 1.1.</q>
</ul>
</div>

<?php H5end(); ?>

<?php H5("", "連絡先 <q>Contact us</q>"); ?>
<div class="main">
バグ報告などは以下にお願いします。日本語でおk。
<q>If you find any problems, please let me know.
You may write in English.</q><br>
<a href="https://github.com/isaki68k/nono-issue/issues"
>https://github.com/isaki68k/nono-issue/issues</a>
</div>
<?php H5end(); ?>

<?php H5("", "パッチの提供について <q>About contributes</q>"); ?>
<div class="main">
パッチを提供してくださる場合は以下に同意したものとします。
<q>If you provide a patch to nono, we assume that you agree the following
conditions:</q>
<ul>
<li>成果物が nono のライセンスに従って運用あるいは配布されること。
<q>All your work will be operated or distributed under the nono license.</q>
<li>ライセンスが将来変わる可能性があること。
<q>The license may be changed in the future.</q>
<li>著作部分に関して著作者人格権を行使しないこと。
<q>Do not exercise your author's rights.</q>
</ul>
</div>
<?php H5end(); ?>

<?php H5("", "Acknowledgements"); ?>
<div class="main">
nono は以下の広告条項を含むソースコードを利用しています。
<q>nono uses source code with the following advertising clause.</q>
<blockquote>
This product includes software developed by Gordon Ross<br>
This product includes software developed by the University of California, Lawrence Berkeley Laboratory.<br>
</blockquote>
</div>
<?php H5end(); ?>
<?php H4end(); ?>

<hr>
nono project
</body>
</html>
