//
// nono
// Copyright (C) 2022 nono project
// Licensed under nono-license.txt
//

//
// HD64180 演算部分
//

#pragma once

#include "hd64180.h"

class hd64180acc : public hd64180flag
{
 public:
	uint32 ld_ir8(uint32 src);

	uint32 add_8(uint32 dst, uint32 src, bool save_c = false);
	uint32 sub_8(uint32 dst, uint32 src, bool save_c = false);
	uint32 inc_8(uint32 src) { return add_8(src, 1, true); }
	uint32 dec_8(uint32 src) { return sub_8(src, 1, true); }
	uint32 adc_8(uint32 dst, uint32 src);
	uint32 sbc_8(uint32 dst, uint32 src);

	uint32 add_16(uint32 dst, uint32 src);
	uint32 adc_16(uint32 dst, uint32 src);
	uint32 sbc_16(uint32 dst, uint32 src);

	void bit_8(uint b, uint32 src);
	uint32 in_8(uint32 src);
	uint32 outm_8(uint32 src, uint32 creg);

	uint32 and_8(uint32 dst, uint32 src);
	uint32 or_8(uint32 dst, uint32 src);
	uint32 xor_8(uint32 dst, uint32 src);
	void tst_8(uint32 dst, uint32 src);

	uint32 sla_8(uint32 src);
	uint32 sra_8(uint32 src);
	uint32 sll_8(uint32 src);
	uint32 srl_8(uint32 src);
	uint32 rl_8(uint32 src);
	uint32 rlc_8(uint32 src);
	uint32 rr_8(uint32 src);
	uint32 rrc_8(uint32 src);

	uint32 daa_8(uint32 src);

 private:
	static inline uint32 vflag_add(uint32 dst, uint32 src, uint32 res);
	static inline uint32 vflag_sub(uint32 dst, uint32 src, uint32 res);
	static inline uint32 hflag_add(uint32 dst, uint32 src);
	static inline uint32 hflag_sub(uint32 dst, uint32 src);
};
