//
// nono
// Copyright (C) 2022 nono project
// Licensed under nono-license.txt
//

//
// HD647180
//

#pragma once

// HD647180 定数定義など
class HD647180
{
 public:
	// 割り込み。
	//
	// HD647180 の割り込みは 15個。
	// HD64180 (7がない方) は12個と異なることに注意。
	// '7' で増えた 3つはベクタコード的には末尾に追加されたが
	// 割り込みレベルは真ん中に追加されている。

	// 割り込み優先順位。(数字が小さいほうが優先順位が高い)
	static const int IntmapTRAP 	= 0;
	static const int IntmapNMI		= 1;
	static const int IntmapINT0 	= 2;
	static const int IntmapINT1 	= 3;
	static const int IntmapINT2 	= 4;
	static const int IntmapInpCap	= 5;	// Input Capture
	static const int IntmapOutCmp	= 6;	// Output Compare
	static const int IntmapTimeOv	= 7;	// Timer Overflow
	static const int IntmapTimer0	= 8;
	static const int IntmapTimer1	= 9;
	static const int IntmapDMA0 	= 10;
	static const int IntmapDMA1 	= 11;
	static const int IntmapCSIO		= 12;
	static const int IntmapASCI0	= 13;
	static const int IntmapASCI1	= 14;
	static const int IntmapMAX		= 15;	// 最後+1

	static constexpr int IntmapTimer(int ch) { return IntmapTimer0 + ch; }

	// 内蔵 I/O ポート
	static const uint32 IO_CNTLA0	= 0x00;	// ASCI Control Register A Channel0
	static const uint32 IO_CNTLA1	= 0x01;	// ASCI Control Register A Channel1
	static const uint32 IO_CNTLB0	= 0x02;	// ASCI Control Register B Channel0
	static const uint32 IO_CNTLB1	= 0x03;	// ASCI Control Register B Channel1
	static const uint32 IO_STAT0	= 0x04;	// ASCI Status Register Channel0
	static const uint32 IO_STAT1	= 0x05;	// ASCI Status Register Channel1
	static const uint32 IO_TDR0		= 0x06;	// ASCI Transmit Data Register Ch0
	static const uint32 IO_TDR1		= 0x07;	// ASCI Transmit Data Register Ch1
	static const uint32 IO_TSR0		= 0x08;	// ASCI Receive Data Register Ch0
	static const uint32 IO_TSR1		= 0x09;	// ASCI Receive Data Register Ch1

	static const uint32 IO_CNTR		= 0x0a;	// CSI/O Control Register
	static const uint32 IO_TRDR		= 0x0b;	// CSI/O Transmit/Receive Data Reg.
	static const uint32 IO_TMDR0L	= 0x0c;	// Timer Data Register Channel0L
	static const uint32 IO_TMDR0H	= 0x0d;	// Timer Data Register Channel0H
	static const uint32 IO_RLDR0L	= 0x0e;	// Timer Reload Register Channel0L
	static const uint32 IO_RLDR0H	= 0x0f;	// Timer Reload Register Channel0H
	static const uint32 IO_TCR		= 0x10;	// Timer Control Register
	static const uint32 IO_TMDR1L	= 0x14;	// Timer Data Register Channel1L
	static const uint32 IO_TMDR1H	= 0x15;	// Timer Data Register Channel1H
	static const uint32 IO_RLDR1L	= 0x16;	// Timer Reload Register Channel1L
	static const uint32 IO_RLDR1H	= 0x17;	// Timer Reload Register Channel1H
	static const uint32 IO_FRFC		= 0x18;	// Free Running Counter

	static constexpr uint32 IO_TMDRL(int ch) {
		return (ch == 0) ? IO_TMDR0L : IO_TMDR1L;
	}
	static constexpr uint32 IO_TMDRH(int ch) {
		return (ch == 0) ? IO_TMDR0H : IO_TMDR1H;
	}
	static constexpr uint32 IO_RLDRL(int ch) {
		return (ch == 0) ? IO_RLDR0L : IO_RLDR1L;
	}
	static constexpr uint32 IO_RLDRH(int ch) {
		return (ch == 0) ? IO_RLDR0H : IO_RLDR1H;
	}

	static const uint32 IO_SAR0L	= 0x20;	// DMA Source Address Reg. Ch0L
	static const uint32 IO_SAR0H	= 0x21;	// DMA Source Address Reg. Ch0H
	static const uint32 IO_SAR0B	= 0x22;	// DMA Source Address Reg. Ch0B
	static const uint32 IO_DAR0L	= 0x23;	// DMA Dest. Address Reg. Ch0L
	static const uint32 IO_DAR0H	= 0x24;	// DMA Dest. Address Reg. Ch0H
	static const uint32 IO_DAR0B	= 0x25;	// DMA Dest. Address Reg. Ch0B
	static const uint32 IO_BCR0L	= 0x26;	// DMA Byte Count Register Ch0L
	static const uint32 IO_BCR0H	= 0x27;	// DMA Byte Count Register Ch0H
	static const uint32 IO_MAR1L	= 0x28;	// DMA Memory Address Reg. Ch1L
	static const uint32 IO_MAR1H	= 0x29;	// DMA Memory Address Reg. Ch1H
	static const uint32 IO_MAR1B	= 0x2a;	// DMA Memory Address Reg. Ch1B
	static const uint32 IO_IAR1L	= 0x2b;	// DMA I/O Address Register Ch1L
	static const uint32 IO_IAR1H	= 0x2c;	// DMA I/O Address Register Ch1H
	static const uint32 IO_BCR1L	= 0x2e;	// DMA Byte Count Register Ch1L
	static const uint32 IO_BCR1H	= 0x2f;	// DMA Byte Count Register Ch1H
	static const uint32 IO_DSTAT	= 0x30;	// DMA Status Register
	static const uint32 IO_DMODE	= 0x31;	// DMA Mode Register
	static const uint32 IO_DCNTL	= 0x32;	// DMA/Wait Control Register

	static const uint32 IO_IL		= 0x33;	// Interrupt Vector Low Register
	static const uint32 IO_ITC		= 0x34;	// INT/TRAP Control Register

	static const uint32 IO_RCR		= 0x36;	// Refresh Control Register
	static const uint32 IO_CBR		= 0x38;	// MMU Common Base Register
	static const uint32 IO_BBR		= 0x39;	// MMU Bank Base Register
	static const uint32 IO_CBAR		= 0x3a;	// MMU Common/Bank Area Register
	static const uint32 IO_OMCR		= 0x3e;	// Operation Mode Control Register
	static const uint32 IO_ICR		= 0x3f;	// I/O Control Register

	static const uint32 IO_T2FRCL	= 0x40;	// Timer 2 Free-Running Counter L
	static const uint32 IO_T2FRCH	= 0x41;	// Timer 2 Free-Running Counter H
	static const uint32 IO_T2OCR1L	= 0x42;	// Timer 2 Output Compare Reg. 1L
	static const uint32 IO_T2OCR1H	= 0x43;	// Timer 2 Output Compare Reg. 1H
	static const uint32 IO_T2OCR2L	= 0x44;	// Timer 2 Output Compare Reg. 2L
	static const uint32 IO_T2OCR2H	= 0x45;	// Timer 2 Output Compare Reg. 2H
	static const uint32 IO_T2ICRL	= 0x46;	// Timer 2 Input Capture Register L
	static const uint32 IO_T2ICRH	= 0x47;	// Timer 2 Input Capture Register H
	static const uint32 IO_T2CSR1	= 0x48;	// Timer 2 Control/status Reg. 1
	static const uint32 IO_T2CSR2	= 0x49;	// Timer 2 Control/status Reg. 2
	static const uint32 IO_CCSR		= 0x50;	// Comparator Control/status Reg.
	static const uint32 IO_RMCR		= 0x51;	// RAM Control Register

	static const uint32 IO_DERA		= 0x53;	// Port A Disable Register
	// 0x60..0x65 は IDR[A-F] (Port [A-F] Input Data Register) と
	// ODR[A-F] (Port [A-F] Output Data Register) が同じ番号に割り当てられて
	// いる。このポートをどっち方向に設定するかで名前を変えているようだが
	// 逆アセンブルの際にはどのみち困るので、ここでは IODR[A-F] とする。
	static const uint32 IO_IODRA	= 0x60;	// Port A I/O Data Reg. (ODRA/IDRA)
	static const uint32 IO_IODRB	= 0x61;	// Port B I/O Data Reg. (ODRB/IDRB)
	static const uint32 IO_IODRC	= 0x62;	// Port C I/O Data Reg. (ODRC/IDRC)
	static const uint32 IO_IODRD	= 0x63;	// Port D I/O Data Reg. (ODRD/IDRD)
	static const uint32 IO_IODRE	= 0x64;	// Port E I/O Data Reg. (ODRE/IDRE)
	static const uint32 IO_IODRF	= 0x65;	// Port F I/O Data Reg. (ODRF/IDRF)
	static const uint32 IO_IDRG		= 0x66;	// Port G Input Data Register
	static const uint32 IO_DDRA		= 0x70;	// Port A Data Direction Register
	static const uint32 IO_DDRB		= 0x71;	// Port B Data Direction Register
	static const uint32 IO_DDRC		= 0x72;	// Port C Data Direction Register
	static const uint32 IO_DDRD		= 0x73;	// Port D Data Direction Register
	static const uint32 IO_DDRE		= 0x74;	// Port E Data Direction Register
	static const uint32 IO_DDRF		= 0x75;	// Port F Data Direction Register
};
