//
// nono
// Copyright (C) 2024 nono project
// Licensed under nono-license.txt
//

//
// シリアルポートのメイン画面コンソール入出力ドライバ
//

#pragma once

#include "comdriver.h"
#include "autofd.h"

class ConsoleDevice;

class COMDriverCons : public COMDriver
{
	using inherited = COMDriver;
 public:
	explicit COMDriverCons(HostDevice *hostdev_);
	~COMDriverCons() override;

	bool InitDriver() override;
	int Read() override;
	void Write(uint32 data) override;

	void EnqueueChar(uint charcode);

 private:
	// VM側 (UI スレッド) からの連絡用。
	autofd rxpipe {};
	autofd txpipe {};

	ConsoleDevice *console {};
};
