//
// nono
// Copyright (C) 2022 nono project
// Licensed under nono-license.txt
//

//
// ホストドライバ (基本クラス)
//

#include "driver.h"
#include "hostdevice.h"

// コンストラクタ
Driver::Driver(HostDevice *hostdev_, const char *drivername_)
	: inherited(OBJ_NONE)
{
	hostdev = hostdev_;
	drivername = drivername_;

	SetName(hostdev->GetName() + "." + drivername);

	// ドライバのログレベルは常にホストデバイス(親)のログレベルに従属なので
	// ドライバオブジェクトにログエイリアスは不要。
	ClearAlias();

	// コンストラクト後ただちにログ出力できるようここで一度追従しておく。
	// 以降はホストデバイスの SetLogLevel() で変更する。
	loglevel = hostdev->loglevel;
}

// デストラクタ
Driver::~Driver()
{
}

// ドライバ初期化
bool
Driver::InitDriver()
{
	putmsg(1, "created");
	return true;
}

// Driver の Dispatch() は udata を返す。
int
Driver::Dispatch(int udata)
{
	return udata;
}

// モニタ (ドライバ依存情報のみ)
void
Driver::MonitorUpdateMD(TextScreen& screen, int y)
{
}
