//
// nono
// Copyright (C) 2022 nono project
// Licensed under nono-license.txt
//

//
// ホストドライバ (基本クラス)
//

#pragma once

#include "object.h"
#include "monitor.h"

class HostDevice;

class Driver : public Object
{
	using inherited = Object;
 protected:
	static const int NODATA = -1;

 protected:
	Driver(HostDevice *hostdev_, const char *drivername_);
 public:
	~Driver() override;

	virtual bool InitDriver();

	// ドライバ固有の Dispatch。 udata を返す。
	// 必要に応じて udata を変更しても良い。
	// これ以上処理することがなければ HostDevice::DONE を返す。
	virtual int Dispatch(int udata);

	// モニタのうちドライバ依存部分の情報を書き出す。
	// screen のうち y行目から2行のみがドライバ依存部分なので
	// ここだけ書き出すこと。不要なら書き出さなくてよい。Clear() しないこと。
	virtual void MonitorUpdateMD(TextScreen& screen, int y);

	// ドライバ名を取得。
	const char *GetDriverName() const { return drivername; }

	// 親ホストデバイス(基本クラス)を取得。
	HostDevice *GetHostDev() const { return hostdev; }

 protected:
	// 親ホストデバイス
	HostDevice *hostdev {};

	// ドライバ名 ("None" とか)
	const char *drivername {};
};
