//
// nono
// Copyright (C) 2021 nono project
// Licensed under nono-license.txt
//

//
// シリアルポートのホストデバイス
//

#pragma once

#include "hostdevice.h"
#include "comdriver.h"
#include "spscqueue.h"

class HostCOMDevice : public HostDevice
{
	using inherited = HostDevice;
	using COMQueue = SPSCQueue<uint8, 1024>;

	// 統計情報
	struct stat_t {
		uint64 tx_bytes;			// VM からの送信バイト数
		uint64 rx_bytes;			// VM が受信したバイト数
		uint64 txqfull_bytes;		// TxQ が一杯で落としたバイト数
		uint64 rxqfull_bytes;		// RxQ が一杯で落としたバイト数
		uint64 write_bytes;			// ホストへの書き出しバイト数
		uint64 read_bytes;			// ホストからの読み込みバイト数

		uint txq_peak;				// キューのおおよその最大使用量
		uint rxq_peak;				// キューのおおよその最大使用量
	};

 public:
	HostCOMDevice(Device *parent_, const std::string& objname_);
	~HostCOMDevice() override;

	void SetLogLevel(int loglevel_) override;
	bool Create2() override;

	void Dispatch(int udata) override;
	bool Tx(uint32 data);
	uint32 Rx();

 private:
	bool SelectDriver();

	int Read() override;
	void Write(uint32 data) override;

	DECLARE_MONITOR_CALLBACK(MonitorUpdate);

	// キュー
	COMQueue txq {};
	COMQueue rxq {};

	std::unique_ptr<COMDriver> driver {};

	// 統計情報
	struct stat_t stat {};

	Monitor *monitor {};
};
