//
// nono
// Copyright (C) 2021 nono project
// Licensed under nono-license.txt
//

//
// ホストデバイス (基本クラス)
//

#pragma once

#include "thread.h"
#include "autofd.h"
#include "kevent.h"

using DeviceCallback_t = void (Device::*)();
#define ToDeviceCallback(f) static_cast<DeviceCallback_t>(f)

class HostDevice : public ThreadDevice
{
	using inherited = ThreadDevice;

 public:
	static const int DONE				= 0;	// 処理終了
	static const int DATA_FROM_VM		= 1;	// VM からの着信
	static const int DATA_FROM_OUTER	= 2;	// 外部からの着信
	static const int LISTEN_SOCKET		= 3;	// 待受ソケット着信

 protected:
	HostDevice(Device *parent_, uint objid_);
 public:
	~HostDevice() override;

	bool Create2() override;

	void Terminate() override;

	// 設定ファイルキーのプレフィックス ("hostcomX-" とか) を返す
	std::string GetConfigKey() const;

	// NetDriver からのディスクリプタの登録
	int AddOuter(int fd);
	int DelOuter(int fd);
	int AddListen(int ls, int action);

	void SetRxCallback(DeviceCallback_t func);
	void SetAcceptCallback(DeviceCallback_t func);

 protected:
	void ThreadRun() override;

	virtual void Dispatch(int udata);

	// ドライバから読み込み。キューに投入したデータ数を返す。
	virtual int Read() = 0;

	// ドライバに書き出し。
	virtual void Write(uint32 data) = 0;

	bool WritePipe(uint32 data);

	// ログ出力
	void putlogn(const char *fmt, ...) const override __printflike(2, 3);

	// 親デバイス
	Device *parent {};

	autofd kq {};

	// VM からの送信用パイプ
	autofd rpipe {};
	autofd wpipe {};

	// 各種通知コールバック
	DeviceCallback_t rx_func {};
	DeviceCallback_t accept_func {};

	// スレッド終了フラグ
	bool exit_requested {};
};
