//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// ホストネットワークのドライバ (基本クラス)
//

#pragma once

#include "driver.h"
#include "autofd.h"

class NetPacket;

class NetDriver : public Driver
{
	using inherited = Driver;

 protected:
	NetDriver(HostDevice *hostdev_, const char *drivername_);
 public:
	~NetDriver() override;

	// パケットを外部から受信する。
	// VM に送り込むパケットがなければ負数(NODATA)を返す。
	// VM に送り込むパケットがあれば p に書き戻して、ドライバ側のバッファに
	// 残っているパケット数 (といっても 0 か 1以上) を返す。
	virtual int Read(NetPacket *p) = 0;

	// パケットを外部に送信する。
	virtual void Write(const void *buf, int buflen) = 0;

	// InitDriver() 中の(主に最後の)エラーメッセージ。
	// NetDriver は複数を順番に試す場合もあるし、全部エラーになっても終了する
	// かどうかは設定によるので、各ドライバはエラーが発生しても各自で warnx に
	// よる表示はせず、ここにエラーメッセージをセットする。必要になった時点で
	// HostNetDevice が最後の一つを warnx() で表示する。
	// なお、おそらくそれだけでは大抵何も分からないのでこれとは別に
	// ログレベル 1 で putmsg() は充実させておくこと。
	std::string errmsg {};

 protected:
	// ifup/ifdown スクリプト実行
	bool Run_ifup();
	bool Run_ifdown();

	std::string ifname {};		// (あれば)作成したインタフェース名

	// デバイスディスクリプタ。
	// ディスクリプタを持つというのは共通なのでディスクリプタはここに置くが
	// これを Open(), Close() するのはあくまで継承側の仕事で、こちらでは
	// 初期化と IsOpen() だけ受け持つ。ちょっと責任分解点が気持ち悪いけど。
	autofd fd {};

 private:
	bool RunScript(const char *filename);
};
