//
// nono
// Copyright (C) 2021 nono project
// Licensed under nono-license.txt
//

//
// kqueue/kevent をいろいろ便利にする
//

#pragma once

#include "header.h"

#include <sys/types.h>
#if defined(HAVE_SYS_EVENT_H)
#include <sys/event.h>
#endif
#if defined(HAVE_KQUEUE_SYS_EVENT_H)
#include <kqueue/sys/event.h>
#endif
#include <sys/time.h>

// udata の型は環境によって異なる
using kevent_udata_t = decltype(kevent::udata);

// udata と int の相互変換
static inline kevent_udata_t
EV_INT2UDATA(int x)
{
	return (kevent_udata_t)(intptr_t)x;
}
static inline int
EV_UDATA2INT(kevent_udata_t x)
{
	return (int)(intptr_t)x;
}

#define kevent_set(k, e, n)		kevent((k), (e), (n), NULL, 0, NULL)
#define kevent_poll(k, e, n, t)	kevent((k), NULL, 0, (e), (n), (t))

static inline int
kevent_add(int kq, int fd, int filter, int action, int udata)
{
	struct kevent kev;

	EV_SET(&kev, fd, filter, action, 0, 0, EV_INT2UDATA(udata));
	return kevent_set(kq, &kev, 1);
}
