//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// ログ
//

#pragma once

#include "fixedqueue.h"
#include <mutex>

class Logger final
{
 public:
	Logger();
	~Logger();

	// ログ書き込み
	void Write(const char *);

	// ログ読み出し
	bool Read(char *, int);

	// 標準出力にも出すかどうか
	void UseStdout(bool val) { use_stdout = val; }

 private:
	// パイプ
	FixedQueue<uint8, 65536> pipe {};

	// 1行ずつの読み書き動作をアトミックにするための排他制御
	std::mutex mtx {};

	// 標準出力にも出すかどうか
	bool use_stdout {};
};
