//
// nono
// Copyright (C) 2021 nono project
// Licensed under nono-license.txt
//

//
// Shift_JIS 関係
//

#pragma once

#include "header.h"

class SJIS
{
 public:
	// ASCII なら true を返す
	static bool IsASCII(uint8 c)
	{
		return c < 0x80;
	}

	// 半角カナ なら true を返す
	static bool IsKana(uint8 c)
	{
		// 半角カナの上位ニブルは a,b,c,d
		return (1 << (c >> 4)) & 0b00111100'00000000;
	}

	// 全角文字の 1 バイト目なら true を返す
	static bool IsZenkaku(uint8 c)
	{
		// Shift_JIS の1文字目は上位ニブルが 8,9,e。
		// f は第三水準以降で使用されているが第二水準まででは使われておらず
		// CGROM にデータも用意されてないので、ここでは半角外字領域とする。

		// bit 8, 9, e を立てた値と and すればよい。
		// なお ubuntu amd64 gcc9.3 はビットテスト命令にコンパイルしてくれる。
		return (1 << (c >> 4)) & 0b01000011'00000000;
	}

	// 半角文字なら true を返す
	static bool IsHankaku(uint8 c)
	{
		return !IsZenkaku(c);
	}
};
