//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

// EA

#pragma once

	// 命令ワードの下位6ビット mmmrrr のうち mmm の部分を取り出す
	static inline int eamode(uint x)	{ return (x >> 3) & 7; }
	// 命令ワードの下位6ビット mmmrrr のうち rrr の部分を取り出す
	static inline int eanum(uint x)		{ return x & 7; }

	// internal_ea_*() は EA を計算だけする部分。CYCLE はここでは加算しない。
	// MOVE の DST 側からも呼ばれる。

	// (An)
	inline uint32 internal_ea_anin(uint n)
	{
		return reg.A[n];
	}

	// (An)+ .B
	inline uint32 internal_ea_anpi_1(uint n)
	{
		if (n == 7) {
			reg.A[n] += 2;
			return reg.A[n] - 2;
		} else {
			reg.A[n] += 1;
			return reg.A[n] - 1;
		}
	}

	// (An)+ .W
	inline uint32 internal_ea_anpi_2(uint n)
	{
		reg.A[n] += 2;
		return reg.A[n] - 2;
	}

	// (An)+ .L
	inline uint32 internal_ea_anpi_4(uint n)
	{
		reg.A[n] += 4;
		return reg.A[n] - 4;
	}

	// -(An) .B
	inline uint32 internal_ea_anpd_1(uint n)
	{
		if (n == 7) {
			reg.A[n] -= 2;
		} else {
			reg.A[n] -= 1;
		}
		return reg.A[n];
	}

	// -(An) .W
	inline uint32 internal_ea_anpd_2(uint n)
	{
		reg.A[n] -= 2;
		return reg.A[n];
	}

	// -(An) .L
	inline uint32 internal_ea_anpd_4(uint n)
	{
		reg.A[n] -= 4;
		return reg.A[n];
	}

	// d16(An)
	inline uint32 internal_ea_andi(uint n)
	{
		int32 disp = (int32)(int16)fetch_2();
		return reg.A[n] + disp;
	}

	// (An,IX)
	inline uint32 internal_ea_anix(uint n)
	{
		return internal_ea_ix(reg.A[n]);
	}

	// Abs.W
	inline uint32 internal_ea_absw()
	{
		return (int32)(int16)fetch_2();
	}

	// Abs.L
	inline uint32 internal_ea_absl()
	{
		return fetch_4();
	}

	// d16(PC)
	inline uint32 internal_ea_pcdi()
	{
		int32 origin = reg.pc;
		int32 disp = (int32)(int16)fetch_2();
		return origin + disp;
	}

	// (PC,IX)
	inline uint32 internal_ea_pcix()
	{
		return internal_ea_ix(reg.pc);
	}

	uint32 internal_ea_ix(uint32);

	// CEA (個別)
	uint32 cea_anin(uint n);
	uint32 cea_anpi_1(uint n);
	uint32 cea_anpi_2(uint n);
	uint32 cea_anpi_4(uint n);
	uint32 cea_anpd_1(uint n);
	uint32 cea_anpd_2(uint n);
	uint32 cea_anpd_4(uint n);
	uint32 cea_andi(uint n);
	uint32 cea_anix(uint n);
	uint32 cea_absw();
	uint32 cea_absl();
	uint32 cea_pcdi();
	uint32 cea_pcix();

	// FEA (個別)
	uint32 fea_anin();
	uint32 fea_anpi_1();
	uint32 fea_anpi_2();
	uint32 fea_anpi_4();
	uint32 fea_anpd_1();
	uint32 fea_anpd_2();
	uint32 fea_anpd_4();
	uint32 fea_andi();
	uint32 fea_anix();
	uint32 fea_absw();
	uint32 fea_absl();
	uint32 fea_pcdi();
	uint32 fea_pcix();
	void   fea_imm_2();
	void   fea_imm_4();

	// CEA (グループ)
	uint32 cea_ctrl();
	uint32 cea_data_1();
	uint32 cea_data_2();
	uint32 cea_data_4();
	uint32 cea_copro();

	// FEA (グループ)
	uint32 fea_data_1();
	uint32 fea_data_2();
	uint32 fea_data_4();
	uint32 fea_all_1();
	uint32 fea_all_2();
	uint32 fea_all_4();
