
#include <err.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <stdio.h>
#include <termios.h>
#include <unistd.h>

int
main(int ac, char *av[])
{

	int fd;

	fd = open("/dev/dty00", O_RDWR);
	if (fd < 0) {
		err(1, "open");
	}

	ioctl(fd, TIOCNXCL);

	termios t;
	tcgetattr(fd, &t);
	fprintf(stderr, "c_iflag=%08x\n", t.c_iflag);
	fprintf(stderr, "c_oflag=%08x\n", t.c_oflag);
	fprintf(stderr, "c_cflag=%08x\n", t.c_cflag);
	fprintf(stderr, "c_lflag=%08x\n", t.c_lflag);
	cfmakeraw(&t);
	cfsetspeed(&t, B9600);
	t.c_iflag = IGNBRK;
	t.c_cflag = CREAD | CS8 | CLOCAL;
	t.c_lflag &= ~ICANON;
	t.c_cc[VTIME] = 0;
	t.c_cc[VMIN] = 1;
	tcsetattr(fd, TCSANOW, &t);
	tcgetattr(fd, &t);
	fprintf(stderr, "\nc_iflag=%08x\n", t.c_iflag);
	fprintf(stderr, "c_oflag=%08x\n", t.c_oflag);
	fprintf(stderr, "c_cflag=%08x\n", t.c_cflag);
	fprintf(stderr, "c_lflag=%08x\n", t.c_lflag);

	for (;;) {
		char buf[4];
		int r;

		int c = getchar();

		buf[0] = c;
		r = write(fd, buf, 1);
		if (r <= 0) {
			err(1, "write");
		}
		r = read(fd, buf, 1);
		fprintf(stderr, "%d ", r);
		if (r < 0) {
			err(1, "read");
		}
		if (r > 0) {
			putchar(buf[0]);
		}
	}
	return 0;
}

