; vi:set ts=8:

;
; nono
; Copyright (C) 2023 nono project
; Licensed under nono-license.txt
;

; MSX-DOS エミュレーションのような何か。
; 0005H にシステムコールを用意して、0100H 番地からプログラムを実行する。
;
; 0000H〜     : 各種ハンドラ
; 0100H       : エントリポイント
; 7000H       : ROM 相当のプログラムコード置き場
; 7EFDH〜7FFFH: 転送用リングバッファ
; F000H       : スタック初期値

RINGADDR	equ	07F00H

	org	7000H
start:
	LD	A,3CH
	;OUT0	(36H),A		; Disable Refresh
	defb	0EDH, 39H, 36H	; HD64180 命令…

	LD	SP,0F000H
	; puts のための初期化
	LD	HL,7F00H-3
	XOR	A
	LD	(HL),A		; (RINGADDR-3) = 0
	INC	HL
	LD	(HL),A		; (RINGADDR-2) = 0
	INC	HL
	LD	A,7FH
	LD	(HL),A		; (RINGADDR-1) = 0x7F

	; 0000H に TRAP ハンドラ
	; 0005H にシステムコールハンドラ
	LD	BC,0008H
	LD	DE,0000H
	LD	HL,handler_0000
	LDIR

	CALL	0100H
exit:
	JR	doscall_00
	; not reached

; TRAP ハンドラ
trap_handler:
	LD	HL,msg_trap_exit
	CALL	puts
	; not reached

; MSX-DOS コール
; 基本的にレジスタは破壊されると思ってよい。
doscall_handler:
	LD	A,C
	OR	A
	JR	Z,doscall_00
	CP	02H
	JR	Z,doscall_02
	CP	09H
	JR	Z,doscall_09


; ---
; C=$00 EXIT
; 終了する。
doscall_00:
	LD	A,1AH
	JR	putc

; ---
; C=$02 PUTC
;
; E に出力する文字コード。
; ここでは '^Z' 出力でプログラム終了。
doscall_02:
	LD	A,E
	JR	putc

; ---
; C=$09 PUTS
; DE に出力する文字列の開始番地 ('$' で終端)。
doscall_09:
	EX	DE,HL
	JR	puts

; ---
; 内部で putc として呼ぶ場合は A に出力する文字コード。
; レジスタはすべて保存される。
putc:
	PUSH	AF
	PUSH	HL

	LD	HL,(RINGADDR-2)		; HL <- dst
	LD	(HL),A			; 1文字出力
	INC	L			; 256バイト循環バッファ
	LD	(RINGADDR-2),HL		; カーソルを更新

	CP	1AH			; 書いたのが '^Z' なら終了
	JR	Z,_putc_term

	LD	A,L
	AND	7FH			; 0x00/0x80 に来たら同期をとる
	JR	NZ,_putc_done
_putc_sync:
	LD	A,(RINGADDR-3)
	CP	L
	JR	NZ,_putc_sync
_putc_done:
	POP	HL
	POP	AF
	RET

_putc_term:				; 無限ループ
	JR	_putc_term

; ---
; 内部で puts として呼ぶ時は HL に開始番地。'$' で終端。
; レジスタはすべて保存される。
puts:
	PUSH	AF
	PUSH	HL
puts_loop:
	LD	A,(HL)
	INC	HL
	CP	'$'			; '$' ならこれを出力せずに終了
	JR	Z,_puts_done

	CALL	putc			; A を出力
	JR	puts_loop
_puts_done:
	POP	HL
	POP	AF
	RET

	; 0000H に転送する部分
handler_0000:
	defb	0C3H			; 0000 JP
	defw	trap_handler		; 0001 trap_handler
	defb	0, 0			; 0003
	defb	0C3H			; 0005 JP
	defw	doscall_handler		; 0006 doscall_handler

msg_trap_exit:
	defm	"TRAP occurred!"
	defb	0DH, 0AH, '$'
