//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// M88200 CMMU の I/O デバイス部分
//

#pragma once

#include "device.h"
#include <array>

class m88200;

class CMMUDevice : public IODevice
{
	using inherited = IODevice;

	// レジスタオフセット
	static const uint32 IDR		= 0x000;
	static const uint32 SCR		= 0x004;
	static const uint32 SSR		= 0x008;
	static const uint32 SAR		= 0x00c;
	static const uint32 SCTR	= 0x104;
	static const uint32 PFSR	= 0x108;
	static const uint32 PFAR	= 0x10c;

	static const uint32 SAPR	= 0x200;
	static const uint32 UAPR	= 0x204;

	static const uint32 BWP0	= 0x400;
	static const uint32 BWP7	= 0x41c;
	static const uint32 CDP0	= 0x800;
	static const uint32 CDP3	= 0x80c;
	static const uint32 CTP0	= 0x840;
	static const uint32 CTP3	= 0x84c;

	static const uint32 CSSP	= 0x880;

 public:
	CMMUDevice();
	~CMMUDevice() override;

	bool Init() override;

	busdata Read(busaddr addr) override;
	busdata Write(busaddr addr, uint32 data) override;
	busdata Peek1(uint32 addr) override;

 private:
	// アドレスデコーダ
	static uint32 Decoder(uint32 addr);

	// Peek1() の下請け
	uint32 Peek4(uint32 addr) const;

	// 指定された ID の CMMU(m88200) を返す。なければ NULL を返す。
	m88200 *GetCMMU(uint id) const {
		if (id >= cmmus.size()) {
			return NULL;
		}
		return cmmus[id];
	}

	// CMMU へのリンク (最大 4 MPU)
	std::array<m88200*, 8> cmmus {};
};

static inline CMMUDevice *GetCMMUDevice() {
	return Object::GetObject<CMMUDevice>(OBJ_CMMUIO);
}
