//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// Ethernet 基本クラス
//

//          IODevice
//              |
//              v
//        EthernetDevice (イーサネットとしての共通部分)
//              |
//     +--------+-------+
//     v                v
// LanceDevice     RTL8019ASDevice
// (LUNA, AM7990)  (X68000, RTL8019AS)

#pragma once

#include "device.h"
#include "macaddr.h"

class HostNetDevice;

class EthernetDevice : public IODevice
{
	using inherited = IODevice;
 protected:
	explicit EthernetDevice(uint objid_);
 public:
	~EthernetDevice() override;

	bool Create() override;

	// 設定から MAC アドレスを取得するヘルパー関数。
	// (MAC アドレスを保持するデバイスが呼ぶ)
	static bool GetConfigMacAddr(uint n, MacAddr *dst, bool accept_rom);

	// CRC32 を計算する。
	static uint32 CRC32(const uint8 *buf, size_t buflen);
	static uint32 CRC32(const MacAddr& mac);

 protected:
	// ホストスレッドからの受信通知
	void HostRxCallback();

	std::unique_ptr<HostNetDevice> hostnet /*{}*/;
};
