//
// nono
// Copyright (C) 2023 nono project
// Licensed under nono-license.txt
//

//
// X68030 勝手に拡張メモリ
//

#pragma once

#include "device.h"

class ExtRAMDevice : public IODevice
{
	using inherited = IODevice;
 public:
	ExtRAMDevice();
	~ExtRAMDevice() override;

	bool Init() override;
	void ResetHard(bool poweron) override;

	busdata Read(busaddr addr) override;
	busdata Write(busaddr, uint32 data) override;
	busdata Peek1(uint32 addr) override;
	bool Poke1(uint32 addr, uint32 data) override;

	// 拡張メモリ容量(バイト単位)を取得
	int GetSize() const	{ return ram_size; }
	// 拡張メモリ容量(MB単位)を取得
	int GetSizeMB() const { return ram_size / 1024 / 1024; }

 private:
	inline uint32 Decoder(uint32) const;

	std::unique_ptr<uint8[]> ram {};

	// 拡張メモリの開始アドレス
	uint32 ram_addr {};

	// 拡張メモリ容量(バイト単位)。ram[] の確保したバイト数
	uint ram_size {};
};

static inline ExtRAMDevice *GetExtRAMDevice() {
	return Object::GetObject<ExtRAMDevice>(OBJ_EXTRAM);
}
