//
// nono
// Copyright (C) 2024 nono project
// Licensed under nono-license.txt
//

//
// Goldfish TTY
//

#pragma once

#include "device.h"
#include "message.h"
#include <deque>

class GFPICDevice;
class HostCOMDevice;
class MainbusDevice;

class GFTTYDevice : public IODevice
{
	using inherited = IODevice;

	static const uint32 PUT_CHAR	= 0x00U >> 2;
	static const uint32 BYTES_READY	= 0x04U >> 2;
	static const uint32 COMMAND		= 0x08U >> 2;
	static const uint32 DATA_PTR	= 0x10U >> 2;
	static const uint32 DATA_LEN	= 0x14U >> 2;
	static const uint32 VERSION		= 0x20U >> 2;

	static const uint32 CMD_INT_DISABLE		= 0x00;
	static const uint32 CMD_INT_ENABLE		= 0x01;
	static const uint32 CMD_WRITE_BUFFER	= 0x02;
	static const uint32 CMD_READ_BUFFER		= 0x03;

	static const uint32 GFTTYVersion		= 1;

 public:
	GFTTYDevice();
	~GFTTYDevice() override;

	bool Create() override;
	void SetLogLevel(int loglevel_) override;
	bool Init() override;
	void ResetHard(bool poweron) override;

 protected:
	// BusIO インタフェース
	static const uint32 NPORT = 0x1000 >> 2;
	busdata ReadPort(uint32 offset);
	busdata WritePort(uint32 offset, uint32 data);
	busdata PeekPort(uint32 offset);

 private:
	uint32 GetREADY() const;
	void Command(uint32);
	void Tx(uint32);
	void ChangeInterrupt();

	// シリアルから1バイト受信のメッセージとイベントコールバック
	void HostRxCallback();
	void RxMessage(MessageID, uint32);

	// パフォーマンス測定用のギミック。
	int sesame_idx {};

	// 受信キュー
	std::deque<uint8> rxq {};

	uint32 dma_ptr {};
	uint32 dma_len {};
	bool intr_enable {};

	std::unique_ptr<HostCOMDevice> hostcom /*{}*/;

	GFPICDevice *gfpic {};
	MainbusDevice *mainbus {};
};

static inline GFTTYDevice *GetGFTTYDevice() {
	return Object::GetObject<GFTTYDevice>(OBJ_GFTTY);
}
