//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// GVRAM
//

#pragma once

#include "device.h"

class GVRAMDevice : public IODevice
{
	using inherited = IODevice;
	static const uint32 baseaddr = 0xc0'0000;
 public:
	GVRAMDevice();
	~GVRAMDevice() override;

	bool Init() override;

	busdata Read(busaddr addr) override;
	busdata Write(busaddr addr, uint32 data) override;
	busdata Peek1(uint32 addr) override;

 private:
	inline uint32 Decoder(uint32 addr) const;

	std::unique_ptr<uint8[]> mem {};
};
