//
// nono
// Copyright (C) 2022 nono project
// Licensed under nono-license.txt
//

//
// メッセージ
//

#pragma once

#include "device.h"

class MessageID
{
 public:
	enum {
		// リクエストフラグにビット割付されるメッセージ。
		// Bit0 は REQUEST_EXIT で使用しているため
		// こちらでは NONE に割り付けて衝突しないようにしている。
		NONE = 0,

		HOSTCOM_RX,
		HOSTNET0_RX,
		HOSTNET1_RX,

		MAX_REQUEST,

		// ここ以降はキューイングされるメッセージ。
		// 整数。

		RESET,
		POWEROFF_EXIT,
		POWEROFF_RESTART,
		POWER_BUTTON,

		SCSIDEV_LOAD_0,
		SCSIDEV_LOAD_1,
		SCSIDEV_LOAD_2,
		SCSIDEV_LOAD_3,
		SCSIDEV_LOAD_4,
		SCSIDEV_LOAD_5,
		SCSIDEV_LOAD_6,
		SCSIDEV_LOAD_7,
		SCSIDEV_UNLOAD_0,
		SCSIDEV_UNLOAD_1,
		SCSIDEV_UNLOAD_2,
		SCSIDEV_UNLOAD_3,
		SCSIDEV_UNLOAD_4,
		SCSIDEV_UNLOAD_5,
		SCSIDEV_UNLOAD_6,
		SCSIDEV_UNLOAD_7,

		FDD_LOAD_0,
		FDD_LOAD_1,
		FDD_LOAD_2,
		FDD_LOAD_3,
		FDD_UNLOAD_0,
		FDD_UNLOAD_1,
		FDD_UNLOAD_2,
		FDD_UNLOAD_3,

		VIRTIO_BLOCK_DONE_0,
		VIRTIO_BLOCK_DONE_1,
		VIRTIO_BLOCK_DONE_2,
		VIRTIO_BLOCK_DONE_3,
		VIRTIO_BLOCK_DONE_4,
		VIRTIO_BLOCK_DONE_5,
		VIRTIO_BLOCK_DONE_6,
		VIRTIO_BLOCK_DONE_7,
		VIRTIO_NET_DONE,
		VIRTIO_ENTROPY_DONE,
		VIRTIO_SCSI_DONE,

		KEY_INPUT,

		NMI,

		SCHEDULER_SYNCMODE,

		MPU_TRACE_MAIN,
		MPU_TRACE_XP,

		// MAX は宛先を確保する際の最大値。
		MAX,

		// ここ以降は、経路中だけで使われるメッセージ。

		MPU_TRACE_ALL,
	};

 public:
	MessageID() {
		id = NONE;
	}
	// enum からの自動変換のため explicit つけない。
	MessageID(int id_) {
		id = id_;
	}

	MessageID& operator=(int id_) {
		id = id_;
		return *this;
	}
	operator int() const {
		return id;
	}

	static MessageID SCSIDEV_LOAD(int n) {
		return MessageID(SCSIDEV_LOAD_0 + n);
	}
	static MessageID SCSIDEV_UNLOAD(int n) {
		return MessageID(SCSIDEV_UNLOAD_0 + n);
	}

	static MessageID FDD_LOAD(int n) {
		return MessageID(FDD_LOAD_0 + n);
	}
	static MessageID FDD_UNLOAD(int n) {
		return MessageID(FDD_UNLOAD_0 + n);
	}

	static MessageID VIRTIO_BLOCK_DONE(int n) {
		return MessageID(VIRTIO_BLOCK_DONE_0 + n);
	}

	static MessageID HOSTNET_RX(int n) {
		return MessageID(HOSTNET0_RX + n);
	}

 private:
	int id;
};

using MessageCallback_t = void (Device::*)(MessageID, uint32);
#define ToMessageCallback(f) static_cast<MessageCallback_t>(f)
